// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v6.33.2
// source: envoy/config/listener/v3/listener.proto

package listenerv3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	v31 "github.com/cncf/xds/go/xds/core/v3"
	v32 "github.com/cncf/xds/go/xds/type/matcher/v3"
	_ "github.com/envoyproxy/go-control-plane/envoy/annotations"
	v33 "github.com/envoyproxy/go-control-plane/envoy/config/accesslog/v3"
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Listener_DrainType int32

const (
	// Drain in response to calling /healthcheck/fail admin endpoint (along with the health check
	// filter), listener removal/modification, and hot restart.
	Listener_DEFAULT Listener_DrainType = 0
	// Drain in response to listener removal/modification and hot restart. This setting does not
	// include /healthcheck/fail. This setting may be desirable if Envoy is hosting both ingress
	// and egress listeners.
	Listener_MODIFY_ONLY Listener_DrainType = 1
)

// Enum value maps for Listener_DrainType.
var (
	Listener_DrainType_name = map[int32]string{
		0: "DEFAULT",
		1: "MODIFY_ONLY",
	}
	Listener_DrainType_value = map[string]int32{
		"DEFAULT":     0,
		"MODIFY_ONLY": 1,
	}
)

func (x Listener_DrainType) Enum() *Listener_DrainType {
	p := new(Listener_DrainType)
	*p = x
	return p
}

func (x Listener_DrainType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Listener_DrainType) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_config_listener_v3_listener_proto_enumTypes[0].Descriptor()
}

func (Listener_DrainType) Type() protoreflect.EnumType {
	return &file_envoy_config_listener_v3_listener_proto_enumTypes[0]
}

func (x Listener_DrainType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Listener_DrainType.Descriptor instead.
func (Listener_DrainType) EnumDescriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{2, 0}
}

// The additional address the listener is listening on.
type AdditionalAddress struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	Address *v3.Address            `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Additional socket options that may not be present in Envoy source code or
	// precompiled binaries. If specified, this will override the
	// :ref:`socket_options <envoy_v3_api_field_config.listener.v3.Listener.socket_options>`
	// in the listener. If specified with no
	// :ref:`socket_options <envoy_v3_api_field_config.core.v3.SocketOptionsOverride.socket_options>`
	// or an empty list of :ref:`socket_options <envoy_v3_api_field_config.core.v3.SocketOptionsOverride.socket_options>`,
	// it means no socket option will apply.
	SocketOptions *v3.SocketOptionsOverride `protobuf:"bytes,2,opt,name=socket_options,json=socketOptions,proto3" json:"socket_options,omitempty"`
	// Configures TCP keepalive settings for the additional address.
	// If not set, the listener :ref:`tcp_keepalive <envoy_v3_api_field_config.listener.v3.Listener.tcp_keepalive>`
	// configuration is inherited. You can explicitly disable TCP keepalive for the additional address by setting any keepalive field
	// (:ref:`keepalive_probes <envoy_v3_api_field_config.core.v3.TcpKeepalive.keepalive_probes>`,
	// :ref:`keepalive_time <envoy_v3_api_field_config.core.v3.TcpKeepalive.keepalive_time>`, or
	// :ref:`keepalive_interval <envoy_v3_api_field_config.core.v3.TcpKeepalive.keepalive_interval>`) to “0“.
	TcpKeepalive  *v3.TcpKeepalive `protobuf:"bytes,3,opt,name=tcp_keepalive,json=tcpKeepalive,proto3" json:"tcp_keepalive,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AdditionalAddress) Reset() {
	*x = AdditionalAddress{}
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdditionalAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdditionalAddress) ProtoMessage() {}

func (x *AdditionalAddress) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdditionalAddress.ProtoReflect.Descriptor instead.
func (*AdditionalAddress) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{0}
}

func (x *AdditionalAddress) GetAddress() *v3.Address {
	if x != nil {
		return x.Address
	}
	return nil
}

func (x *AdditionalAddress) GetSocketOptions() *v3.SocketOptionsOverride {
	if x != nil {
		return x.SocketOptions
	}
	return nil
}

func (x *AdditionalAddress) GetTcpKeepalive() *v3.TcpKeepalive {
	if x != nil {
		return x.TcpKeepalive
	}
	return nil
}

// Listener list collections. Entries are “Listener“ resources or references.
// [#not-implemented-hide:]
type ListenerCollection struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Entries       []*v31.CollectionEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListenerCollection) Reset() {
	*x = ListenerCollection{}
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListenerCollection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenerCollection) ProtoMessage() {}

func (x *ListenerCollection) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenerCollection.ProtoReflect.Descriptor instead.
func (*ListenerCollection) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{1}
}

func (x *ListenerCollection) GetEntries() []*v31.CollectionEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// [#next-free-field: 38]
type Listener struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The unique name by which this listener is known. If no name is provided,
	// Envoy will allocate an internal UUID for the listener. If the listener is to be dynamically
	// updated or removed via :ref:`LDS <config_listeners_lds>` a unique name must be provided.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The address that the listener should listen on. In general, the address must be unique, though
	// that is governed by the bind rules of the OS. E.g., multiple listeners can listen on port 0 on
	// Linux as the actual port will be allocated by the OS.
	// Required unless “api_listener“ or “listener_specifier“ is populated.
	//
	// When the address contains a network namespace filepath (via
	// :ref:`network_namespace_filepath <envoy_v3_api_field_config.core.v3.SocketAddress.network_namespace_filepath>`),
	// Envoy automatically populates the filter state with key “envoy.network.network_namespace“
	// when a connection is accepted. This provides read-only access to the network namespace for
	// filters, access logs, and other components.
	Address *v3.Address `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// The additional addresses the listener should listen on. The addresses must be unique across all
	// listeners. Multiple addresses with port 0 can be supplied. When using multiple addresses in a single listener,
	// all addresses use the same protocol, and multiple internal addresses are not supported.
	AdditionalAddresses []*AdditionalAddress `protobuf:"bytes,33,rep,name=additional_addresses,json=additionalAddresses,proto3" json:"additional_addresses,omitempty"`
	// Optional prefix to use on listener stats. If empty, the stats will be rooted at
	// “listener.<address as string>.“. If non-empty, stats will be rooted at
	// “listener.<stat_prefix>.“.
	StatPrefix string `protobuf:"bytes,28,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// A list of filter chains to consider for this listener. The
	// :ref:`FilterChain <envoy_v3_api_msg_config.listener.v3.FilterChain>` with the most specific
	// :ref:`FilterChainMatch <envoy_v3_api_msg_config.listener.v3.FilterChainMatch>` criteria is used on a
	// connection.
	//
	// Example using SNI for filter chain selection can be found in the
	// :ref:`FAQ entry <faq_how_to_setup_sni>`.
	FilterChains []*FilterChain `protobuf:"bytes,3,rep,name=filter_chains,json=filterChains,proto3" json:"filter_chains,omitempty"`
	// Discover filter chains configurations by external service. Dynamic discovery of filter chains is allowed
	// while having statically configured filter chains, however, a filter chain name must be unique within a
	// listener. If a discovered filter chain matches a name of an existing filter chain, it is discarded.
	// [#not-implemented-hide:]
	FcdsConfig *Listener_FcdsConfig `protobuf:"bytes,36,opt,name=fcds_config,json=fcdsConfig,proto3" json:"fcds_config,omitempty"`
	// :ref:`Matcher API <arch_overview_matching_listener>` resolving the filter chain name from the
	// network properties. This matcher is used as a replacement for the filter chain match condition
	// :ref:`filter_chain_match
	// <envoy_v3_api_field_config.listener.v3.FilterChain.filter_chain_match>`. If specified, all
	// :ref:`filter_chains <envoy_v3_api_field_config.listener.v3.Listener.filter_chains>` must have a
	// non-empty and unique :ref:`name <envoy_v3_api_field_config.listener.v3.FilterChain.name>` field
	// and not specify :ref:`filter_chain_match
	// <envoy_v3_api_field_config.listener.v3.FilterChain.filter_chain_match>` field.
	//
	// .. note::
	//
	//	Once matched, each connection is permanently bound to its filter chain.
	//	If the matcher changes but the filter chain remains the same, the
	//	connections bound to the filter chain are not drained. If, however, the
	//	filter chain is removed or structurally modified, then the drain for its
	//	connections is initiated.
	FilterChainMatcher *v32.Matcher `protobuf:"bytes,32,opt,name=filter_chain_matcher,json=filterChainMatcher,proto3" json:"filter_chain_matcher,omitempty"`
	// If a connection is redirected using “iptables“, the port on which the proxy
	// receives it might be different from the original destination address. When this flag is set to
	// true, the listener hands off redirected connections to the listener associated with the
	// original destination address. If there is no listener associated with the original destination
	// address, the connection is handled by the listener that receives it. Defaults to false.
	UseOriginalDst *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=use_original_dst,json=useOriginalDst,proto3" json:"use_original_dst,omitempty"`
	// The default filter chain if none of the filter chain matches. If no default filter chain is supplied,
	// the connection will be closed. The filter chain match is ignored in this field.
	DefaultFilterChain *FilterChain `protobuf:"bytes,25,opt,name=default_filter_chain,json=defaultFilterChain,proto3" json:"default_filter_chain,omitempty"`
	// Soft limit on size of the listener’s new connection read and write buffers.
	// If unspecified, an implementation defined default is applied (1MiB).
	PerConnectionBufferLimitBytes *wrapperspb.UInt32Value `protobuf:"bytes,5,opt,name=per_connection_buffer_limit_bytes,json=perConnectionBufferLimitBytes,proto3" json:"per_connection_buffer_limit_bytes,omitempty"`
	// Listener metadata.
	Metadata *v3.Metadata `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// [#not-implemented-hide:]
	//
	// Deprecated: Marked as deprecated in envoy/config/listener/v3/listener.proto.
	DeprecatedV1 *Listener_DeprecatedV1 `protobuf:"bytes,7,opt,name=deprecated_v1,json=deprecatedV1,proto3" json:"deprecated_v1,omitempty"`
	// The type of draining to perform at a listener-wide level.
	DrainType Listener_DrainType `protobuf:"varint,8,opt,name=drain_type,json=drainType,proto3,enum=envoy.config.listener.v3.Listener_DrainType" json:"drain_type,omitempty"`
	// Listener filters have the opportunity to manipulate and augment the connection metadata that
	// is used in connection filter chain matching, for example. These filters are run before any in
	// :ref:`filter_chains <envoy_v3_api_field_config.listener.v3.Listener.filter_chains>`. Order matters as the
	// filters are processed sequentially right after a socket has been accepted by the listener, and
	// before a connection is created.
	// UDP Listener filters can be specified when the protocol in the listener socket address in
	// :ref:`protocol <envoy_v3_api_field_config.core.v3.SocketAddress.protocol>` is :ref:`UDP
	// <envoy_v3_api_enum_value_config.core.v3.SocketAddress.Protocol.UDP>` and no
	// :ref:`quic_options <envoy_v3_api_field_config.listener.v3.UdpListenerConfig.quic_options>` is specified in :ref:`udp_listener_config <envoy_v3_api_field_config.listener.v3.Listener.udp_listener_config>`.
	// QUIC listener filters can be specified when :ref:`quic_options
	// <envoy_v3_api_field_config.listener.v3.UdpListenerConfig.quic_options>` is
	// specified in :ref:`udp_listener_config <envoy_v3_api_field_config.listener.v3.Listener.udp_listener_config>`.
	// They are processed sequentially right before connection creation. And like TCP Listener filters, they can be used to manipulate the connection metadata and socket. But the difference is that they can't be used to pause connection creation.
	ListenerFilters []*ListenerFilter `protobuf:"bytes,9,rep,name=listener_filters,json=listenerFilters,proto3" json:"listener_filters,omitempty"`
	// The timeout to wait for all listener filters to complete operation. If the timeout is reached,
	// the accepted socket is closed without a connection being created unless
	// “continue_on_listener_filters_timeout“ is set to true. Specify 0 to disable the
	// timeout. If not specified, a default timeout of 15s is used.
	ListenerFiltersTimeout *durationpb.Duration `protobuf:"bytes,15,opt,name=listener_filters_timeout,json=listenerFiltersTimeout,proto3" json:"listener_filters_timeout,omitempty"`
	// Whether a connection should be created when listener filters timeout. Default is false.
	//
	// .. attention::
	//
	//	Some listener filters, such as :ref:`Proxy Protocol filter
	//	<config_listener_filters_proxy_protocol>`, should not be used with this option. It will cause
	//	unexpected behavior when a connection is created.
	ContinueOnListenerFiltersTimeout bool `protobuf:"varint,17,opt,name=continue_on_listener_filters_timeout,json=continueOnListenerFiltersTimeout,proto3" json:"continue_on_listener_filters_timeout,omitempty"`
	// Whether the listener should be set as a transparent socket.
	// When this flag is set to true, connections can be redirected to the listener using an
	// “iptables“ “TPROXY“ target, in which case the original source and destination addresses and
	// ports are preserved on accepted connections. This flag should be used in combination with
	// :ref:`an original_dst <config_listener_filters_original_dst>` :ref:`listener filter
	// <envoy_v3_api_field_config.listener.v3.Listener.listener_filters>` to mark the connections' local addresses as
	// "restored." This can be used to hand off each redirected connection to another listener
	// associated with the connection's destination address. Direct connections to the socket without
	// using “TPROXY“ cannot be distinguished from connections redirected using “TPROXY“ and are
	// therefore treated as if they were redirected.
	// When this flag is set to false, the listener's socket is explicitly reset as non-transparent.
	// Setting this flag requires Envoy to run with the “CAP_NET_ADMIN“ capability.
	// When this flag is not set (default), the socket is not modified, i.e. the transparent option
	// is neither set nor reset.
	Transparent *wrapperspb.BoolValue `protobuf:"bytes,10,opt,name=transparent,proto3" json:"transparent,omitempty"`
	// Whether the listener should set the “IP_FREEBIND“ socket option. When this
	// flag is set to true, listeners can be bound to an IP address that is not
	// configured on the system running Envoy. When this flag is set to false, the
	// option “IP_FREEBIND“ is disabled on the socket. When this flag is not set
	// (default), the socket is not modified, i.e. the option is neither enabled
	// nor disabled.
	Freebind *wrapperspb.BoolValue `protobuf:"bytes,11,opt,name=freebind,proto3" json:"freebind,omitempty"`
	// Additional socket options that may not be present in Envoy source code or
	// precompiled binaries.
	// It is not allowed to update the socket options for any existing address if
	// :ref:`enable_reuse_port <envoy_v3_api_field_config.listener.v3.Listener.enable_reuse_port>`
	// is “false“ to avoid the conflict when creating new sockets for the listener.
	SocketOptions []*v3.SocketOption `protobuf:"bytes,13,rep,name=socket_options,json=socketOptions,proto3" json:"socket_options,omitempty"`
	// Whether the listener should accept TCP Fast Open (TFO) connections.
	// When this flag is set to a value greater than 0, the option TCP_FASTOPEN is enabled on
	// the socket, with a queue length of the specified size
	// (see `details in RFC7413 <https://tools.ietf.org/html/rfc7413#section-5.1>`_).
	// When this flag is set to 0, the option TCP_FASTOPEN is disabled on the socket.
	// When this flag is not set (default), the socket is not modified,
	// i.e. the option is neither enabled nor disabled.
	//
	// On Linux, the net.ipv4.tcp_fastopen kernel parameter must include flag 0x2 to enable
	// TCP_FASTOPEN.
	// See `ip-sysctl.txt <https://www.kernel.org/doc/Documentation/networking/ip-sysctl.txt>`_.
	//
	// On macOS, only values of 0, 1, and unset are valid; other values may result in an error.
	// To set the queue length on macOS, set the net.inet.tcp.fastopen_backlog kernel parameter.
	TcpFastOpenQueueLength *wrapperspb.UInt32Value `protobuf:"bytes,12,opt,name=tcp_fast_open_queue_length,json=tcpFastOpenQueueLength,proto3" json:"tcp_fast_open_queue_length,omitempty"`
	// Specifies the intended direction of the traffic relative to the local Envoy.
	// This property is required on Windows for listeners using the original destination filter,
	// see :ref:`Original Destination <config_listener_filters_original_dst>`.
	TrafficDirection v3.TrafficDirection `protobuf:"varint,16,opt,name=traffic_direction,json=trafficDirection,proto3,enum=envoy.config.core.v3.TrafficDirection" json:"traffic_direction,omitempty"`
	// If the protocol in the listener socket address in :ref:`protocol
	// <envoy_v3_api_field_config.core.v3.SocketAddress.protocol>` is :ref:`UDP
	// <envoy_v3_api_enum_value_config.core.v3.SocketAddress.Protocol.UDP>`, this field specifies UDP
	// listener specific configuration.
	UdpListenerConfig *UdpListenerConfig `protobuf:"bytes,18,opt,name=udp_listener_config,json=udpListenerConfig,proto3" json:"udp_listener_config,omitempty"`
	// Used to represent an API listener, which is used in non-proxy clients. The type of API
	// exposed to the non-proxy application depends on the type of API listener.
	// When this field is set, no other field except for :ref:`name<envoy_v3_api_field_config.listener.v3.Listener.name>`
	// should be set.
	//
	// .. note::
	//
	//	Currently only one ApiListener can be installed; and it can only be done via bootstrap config,
	//	not LDS.
	//
	// [#next-major-version: In the v3 API, instead of this messy approach where the socket
	// listener fields are directly in the top-level Listener message and the API listener types
	// are in the ApiListener message, the socket listener messages should be in their own message,
	// and the top-level Listener should essentially be a oneof that selects between the
	// socket listener and the various types of API listener. That way, a given Listener message
	// can structurally only contain the fields of the relevant type.]
	ApiListener *ApiListener `protobuf:"bytes,19,opt,name=api_listener,json=apiListener,proto3" json:"api_listener,omitempty"`
	// The listener's connection balancer configuration, currently only applicable to TCP listeners.
	// If no configuration is specified, Envoy will not attempt to balance active connections between
	// worker threads.
	//
	// In the scenario that the listener X redirects all the connections to the listeners Y1 and Y2
	// by setting :ref:`use_original_dst <envoy_v3_api_field_config.listener.v3.Listener.use_original_dst>` in X
	// and :ref:`bind_to_port <envoy_v3_api_field_config.listener.v3.Listener.bind_to_port>` to false in Y1 and Y2,
	// it is recommended to disable the balance config in listener X to avoid the cost of balancing, and
	// enable the balance config in Y1 and Y2 to balance the connections among the workers.
	ConnectionBalanceConfig *Listener_ConnectionBalanceConfig `protobuf:"bytes,20,opt,name=connection_balance_config,json=connectionBalanceConfig,proto3" json:"connection_balance_config,omitempty"`
	// Deprecated. Use “enable_reuse_port“ instead.
	//
	// Deprecated: Marked as deprecated in envoy/config/listener/v3/listener.proto.
	ReusePort bool `protobuf:"varint,21,opt,name=reuse_port,json=reusePort,proto3" json:"reuse_port,omitempty"`
	// When this flag is set to true, listeners set the “SO_REUSEPORT“ socket option and
	// create one socket for each worker thread. This makes inbound connections
	// distribute among worker threads roughly evenly in cases where there are a high number
	// of connections. When this flag is set to false, all worker threads share one socket. This field
	// defaults to true. The change of field will be rejected during an listener update when the
	// runtime flag “envoy.reloadable_features.enable_update_listener_socket_options“ is enabled.
	// Otherwise, the update of this field will be ignored quietly.
	//
	// .. attention::
	//
	//	Although this field defaults to true, it has different behavior on different platforms. See
	//	the following text for more information.
	//
	//   - On Linux, reuse_port is respected for both TCP and UDP listeners. It also works correctly
	//     with hot restart.
	//   - On macOS, reuse_port for TCP does not do what it does on Linux. Instead of load balancing,
	//     the last socket wins and receives all connections/packets. For TCP, reuse_port is force
	//     disabled and the user is warned. For UDP, it is enabled, but only one worker will receive
	//     packets. For QUIC/H3, SW routing will send packets to other workers. For "raw" UDP, only
	//     a single worker will currently receive packets.
	//   - On Windows, reuse_port for TCP has undefined behavior. It is force disabled and the user
	//     is warned similar to macOS. It is left enabled for UDP with undefined behavior currently.
	EnableReusePort *wrapperspb.BoolValue `protobuf:"bytes,29,opt,name=enable_reuse_port,json=enableReusePort,proto3" json:"enable_reuse_port,omitempty"`
	// Configuration for :ref:`access logs <arch_overview_access_logs>`
	// emitted by this listener.
	AccessLog []*v33.AccessLog `protobuf:"bytes,22,rep,name=access_log,json=accessLog,proto3" json:"access_log,omitempty"`
	// The maximum length a tcp listener's pending connections queue can grow to. If no value is
	// provided net.core.somaxconn will be used on Linux and 128 otherwise.
	TcpBacklogSize *wrapperspb.UInt32Value `protobuf:"bytes,24,opt,name=tcp_backlog_size,json=tcpBacklogSize,proto3" json:"tcp_backlog_size,omitempty"`
	// The maximum number of connections to accept from the kernel per socket
	// event. Envoy may decide to close these connections after accepting them
	// from the kernel e.g. due to load shedding, or other policies.
	// If there are more than max_connections_to_accept_per_socket_event
	// connections pending accept, connections over this threshold will be
	// accepted in later event loop iterations.
	// If no value is provided Envoy will accept all connections pending accept
	// from the kernel.
	//
	// .. note::
	//
	//	It is recommended to lower this value for better overload management and reduced per-event cost.
	//	Setting it to 1 is a viable option with no noticeable impact on performance.
	MaxConnectionsToAcceptPerSocketEvent *wrapperspb.UInt32Value `protobuf:"bytes,34,opt,name=max_connections_to_accept_per_socket_event,json=maxConnectionsToAcceptPerSocketEvent,proto3" json:"max_connections_to_accept_per_socket_event,omitempty"`
	// Whether the listener should bind to the port. A listener that doesn't
	// bind can only receive connections redirected from other listeners that set
	// :ref:`use_original_dst <envoy_v3_api_field_config.listener.v3.Listener.use_original_dst>`
	// to true. Default is true.
	BindToPort *wrapperspb.BoolValue `protobuf:"bytes,26,opt,name=bind_to_port,json=bindToPort,proto3" json:"bind_to_port,omitempty"`
	// The exclusive listener type and the corresponding config.
	//
	// Types that are valid to be assigned to ListenerSpecifier:
	//
	//	*Listener_InternalListener
	ListenerSpecifier isListener_ListenerSpecifier `protobuf_oneof:"listener_specifier"`
	// Enable MPTCP (multi-path TCP) on this listener. Clients will be allowed to establish
	// MPTCP connections. Non-MPTCP clients will fall back to regular TCP.
	EnableMptcp bool `protobuf:"varint,30,opt,name=enable_mptcp,json=enableMptcp,proto3" json:"enable_mptcp,omitempty"`
	// Whether the listener should limit connections based upon the value of
	// :ref:`global_downstream_max_connections <config_overload_manager_limiting_connections>`.
	IgnoreGlobalConnLimit bool `protobuf:"varint,31,opt,name=ignore_global_conn_limit,json=ignoreGlobalConnLimit,proto3" json:"ignore_global_conn_limit,omitempty"`
	// Whether the listener bypasses configured overload manager actions.
	BypassOverloadManager bool `protobuf:"varint,35,opt,name=bypass_overload_manager,json=bypassOverloadManager,proto3" json:"bypass_overload_manager,omitempty"`
	// If set, TCP keepalive settings are configured for the listener address and inherited by
	// additional addresses. If not set, TCP keepalive settings are not configured for the
	// listener address and additional addresses by default. See :ref:`tcp_keepalive <envoy_v3_api_field_config.listener.v3.AdditionalAddress.tcp_keepalive>`
	// to explicitly configure TCP keepalive settings for individual additional addresses.
	TcpKeepalive  *v3.TcpKeepalive `protobuf:"bytes,37,opt,name=tcp_keepalive,json=tcpKeepalive,proto3" json:"tcp_keepalive,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Listener) Reset() {
	*x = Listener{}
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Listener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listener) ProtoMessage() {}

func (x *Listener) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listener.ProtoReflect.Descriptor instead.
func (*Listener) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{2}
}

func (x *Listener) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Listener) GetAddress() *v3.Address {
	if x != nil {
		return x.Address
	}
	return nil
}

func (x *Listener) GetAdditionalAddresses() []*AdditionalAddress {
	if x != nil {
		return x.AdditionalAddresses
	}
	return nil
}

func (x *Listener) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

func (x *Listener) GetFilterChains() []*FilterChain {
	if x != nil {
		return x.FilterChains
	}
	return nil
}

func (x *Listener) GetFcdsConfig() *Listener_FcdsConfig {
	if x != nil {
		return x.FcdsConfig
	}
	return nil
}

func (x *Listener) GetFilterChainMatcher() *v32.Matcher {
	if x != nil {
		return x.FilterChainMatcher
	}
	return nil
}

func (x *Listener) GetUseOriginalDst() *wrapperspb.BoolValue {
	if x != nil {
		return x.UseOriginalDst
	}
	return nil
}

func (x *Listener) GetDefaultFilterChain() *FilterChain {
	if x != nil {
		return x.DefaultFilterChain
	}
	return nil
}

func (x *Listener) GetPerConnectionBufferLimitBytes() *wrapperspb.UInt32Value {
	if x != nil {
		return x.PerConnectionBufferLimitBytes
	}
	return nil
}

func (x *Listener) GetMetadata() *v3.Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Deprecated: Marked as deprecated in envoy/config/listener/v3/listener.proto.
func (x *Listener) GetDeprecatedV1() *Listener_DeprecatedV1 {
	if x != nil {
		return x.DeprecatedV1
	}
	return nil
}

func (x *Listener) GetDrainType() Listener_DrainType {
	if x != nil {
		return x.DrainType
	}
	return Listener_DEFAULT
}

func (x *Listener) GetListenerFilters() []*ListenerFilter {
	if x != nil {
		return x.ListenerFilters
	}
	return nil
}

func (x *Listener) GetListenerFiltersTimeout() *durationpb.Duration {
	if x != nil {
		return x.ListenerFiltersTimeout
	}
	return nil
}

func (x *Listener) GetContinueOnListenerFiltersTimeout() bool {
	if x != nil {
		return x.ContinueOnListenerFiltersTimeout
	}
	return false
}

func (x *Listener) GetTransparent() *wrapperspb.BoolValue {
	if x != nil {
		return x.Transparent
	}
	return nil
}

func (x *Listener) GetFreebind() *wrapperspb.BoolValue {
	if x != nil {
		return x.Freebind
	}
	return nil
}

func (x *Listener) GetSocketOptions() []*v3.SocketOption {
	if x != nil {
		return x.SocketOptions
	}
	return nil
}

func (x *Listener) GetTcpFastOpenQueueLength() *wrapperspb.UInt32Value {
	if x != nil {
		return x.TcpFastOpenQueueLength
	}
	return nil
}

func (x *Listener) GetTrafficDirection() v3.TrafficDirection {
	if x != nil {
		return x.TrafficDirection
	}
	return v3.TrafficDirection(0)
}

func (x *Listener) GetUdpListenerConfig() *UdpListenerConfig {
	if x != nil {
		return x.UdpListenerConfig
	}
	return nil
}

func (x *Listener) GetApiListener() *ApiListener {
	if x != nil {
		return x.ApiListener
	}
	return nil
}

func (x *Listener) GetConnectionBalanceConfig() *Listener_ConnectionBalanceConfig {
	if x != nil {
		return x.ConnectionBalanceConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in envoy/config/listener/v3/listener.proto.
func (x *Listener) GetReusePort() bool {
	if x != nil {
		return x.ReusePort
	}
	return false
}

func (x *Listener) GetEnableReusePort() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableReusePort
	}
	return nil
}

func (x *Listener) GetAccessLog() []*v33.AccessLog {
	if x != nil {
		return x.AccessLog
	}
	return nil
}

func (x *Listener) GetTcpBacklogSize() *wrapperspb.UInt32Value {
	if x != nil {
		return x.TcpBacklogSize
	}
	return nil
}

func (x *Listener) GetMaxConnectionsToAcceptPerSocketEvent() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxConnectionsToAcceptPerSocketEvent
	}
	return nil
}

func (x *Listener) GetBindToPort() *wrapperspb.BoolValue {
	if x != nil {
		return x.BindToPort
	}
	return nil
}

func (x *Listener) GetListenerSpecifier() isListener_ListenerSpecifier {
	if x != nil {
		return x.ListenerSpecifier
	}
	return nil
}

func (x *Listener) GetInternalListener() *Listener_InternalListenerConfig {
	if x != nil {
		if x, ok := x.ListenerSpecifier.(*Listener_InternalListener); ok {
			return x.InternalListener
		}
	}
	return nil
}

func (x *Listener) GetEnableMptcp() bool {
	if x != nil {
		return x.EnableMptcp
	}
	return false
}

func (x *Listener) GetIgnoreGlobalConnLimit() bool {
	if x != nil {
		return x.IgnoreGlobalConnLimit
	}
	return false
}

func (x *Listener) GetBypassOverloadManager() bool {
	if x != nil {
		return x.BypassOverloadManager
	}
	return false
}

func (x *Listener) GetTcpKeepalive() *v3.TcpKeepalive {
	if x != nil {
		return x.TcpKeepalive
	}
	return nil
}

type isListener_ListenerSpecifier interface {
	isListener_ListenerSpecifier()
}

type Listener_InternalListener struct {
	// Used to represent an internal listener which does not listen on OSI L4 address but can be used by the
	// :ref:`envoy cluster <envoy_v3_api_msg_config.cluster.v3.Cluster>` to create a user space connection to.
	// The internal listener acts as a TCP listener. It supports listener filters and network filter chains.
	// Upstream clusters refer to the internal listeners by their :ref:`name
	// <envoy_v3_api_field_config.listener.v3.Listener.name>`. :ref:`Address
	// <envoy_v3_api_field_config.listener.v3.Listener.address>` must not be set on the internal listeners.
	//
	// There are some limitations that are derived from the implementation. The known limitations include:
	//
	//   - :ref:`ConnectionBalanceConfig <envoy_v3_api_msg_config.listener.v3.Listener.ConnectionBalanceConfig>` is not
	//     allowed because both the cluster connection and the listener connection must be owned by the same dispatcher.
	//   - :ref:`tcp_backlog_size <envoy_v3_api_field_config.listener.v3.Listener.tcp_backlog_size>`
	//   - :ref:`freebind <envoy_v3_api_field_config.listener.v3.Listener.freebind>`
	//   - :ref:`transparent <envoy_v3_api_field_config.listener.v3.Listener.transparent>`
	InternalListener *Listener_InternalListenerConfig `protobuf:"bytes,27,opt,name=internal_listener,json=internalListener,proto3,oneof"`
}

func (*Listener_InternalListener) isListener_ListenerSpecifier() {}

// A placeholder proto so that users can explicitly configure the standard
// Listener Manager via the bootstrap's :ref:`listener_manager <envoy_v3_api_field_config.bootstrap.v3.Bootstrap.listener_manager>`.
// [#not-implemented-hide:]
type ListenerManager struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListenerManager) Reset() {
	*x = ListenerManager{}
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListenerManager) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenerManager) ProtoMessage() {}

func (x *ListenerManager) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenerManager.ProtoReflect.Descriptor instead.
func (*ListenerManager) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{3}
}

// A placeholder proto so that users can explicitly configure the standard
// Validation Listener Manager via the bootstrap's :ref:`listener_manager <envoy_v3_api_field_config.bootstrap.v3.Bootstrap.listener_manager>`.
// [#not-implemented-hide:]
type ValidationListenerManager struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidationListenerManager) Reset() {
	*x = ValidationListenerManager{}
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidationListenerManager) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationListenerManager) ProtoMessage() {}

func (x *ValidationListenerManager) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationListenerManager.ProtoReflect.Descriptor instead.
func (*ValidationListenerManager) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{4}
}

// A placeholder proto so that users can explicitly configure the API
// Listener Manager via the bootstrap's :ref:`listener_manager <envoy_v3_api_field_config.bootstrap.v3.Bootstrap.listener_manager>`.
// [#not-implemented-hide:]
type ApiListenerManager struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApiListenerManager) Reset() {
	*x = ApiListenerManager{}
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApiListenerManager) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiListenerManager) ProtoMessage() {}

func (x *ApiListenerManager) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiListenerManager.ProtoReflect.Descriptor instead.
func (*ApiListenerManager) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{5}
}

// [#not-implemented-hide:]
type Listener_DeprecatedV1 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Whether the listener should bind to the port. A listener that doesn't
	// bind can only receive connections redirected from other listeners that
	// set use_original_dst parameter to true. Default is true.
	//
	// This is deprecated. Use :ref:`Listener.bind_to_port
	// <envoy_v3_api_field_config.listener.v3.Listener.bind_to_port>`
	BindToPort    *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=bind_to_port,json=bindToPort,proto3" json:"bind_to_port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Listener_DeprecatedV1) Reset() {
	*x = Listener_DeprecatedV1{}
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Listener_DeprecatedV1) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listener_DeprecatedV1) ProtoMessage() {}

func (x *Listener_DeprecatedV1) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listener_DeprecatedV1.ProtoReflect.Descriptor instead.
func (*Listener_DeprecatedV1) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{2, 0}
}

func (x *Listener_DeprecatedV1) GetBindToPort() *wrapperspb.BoolValue {
	if x != nil {
		return x.BindToPort
	}
	return nil
}

// Configuration for listener connection balancing.
type Listener_ConnectionBalanceConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to BalanceType:
	//
	//	*Listener_ConnectionBalanceConfig_ExactBalance_
	//	*Listener_ConnectionBalanceConfig_ExtendBalance
	BalanceType   isListener_ConnectionBalanceConfig_BalanceType `protobuf_oneof:"balance_type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Listener_ConnectionBalanceConfig) Reset() {
	*x = Listener_ConnectionBalanceConfig{}
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Listener_ConnectionBalanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listener_ConnectionBalanceConfig) ProtoMessage() {}

func (x *Listener_ConnectionBalanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listener_ConnectionBalanceConfig.ProtoReflect.Descriptor instead.
func (*Listener_ConnectionBalanceConfig) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{2, 1}
}

func (x *Listener_ConnectionBalanceConfig) GetBalanceType() isListener_ConnectionBalanceConfig_BalanceType {
	if x != nil {
		return x.BalanceType
	}
	return nil
}

func (x *Listener_ConnectionBalanceConfig) GetExactBalance() *Listener_ConnectionBalanceConfig_ExactBalance {
	if x != nil {
		if x, ok := x.BalanceType.(*Listener_ConnectionBalanceConfig_ExactBalance_); ok {
			return x.ExactBalance
		}
	}
	return nil
}

func (x *Listener_ConnectionBalanceConfig) GetExtendBalance() *v3.TypedExtensionConfig {
	if x != nil {
		if x, ok := x.BalanceType.(*Listener_ConnectionBalanceConfig_ExtendBalance); ok {
			return x.ExtendBalance
		}
	}
	return nil
}

type isListener_ConnectionBalanceConfig_BalanceType interface {
	isListener_ConnectionBalanceConfig_BalanceType()
}

type Listener_ConnectionBalanceConfig_ExactBalance_ struct {
	// If specified, the listener will use the exact connection balancer.
	ExactBalance *Listener_ConnectionBalanceConfig_ExactBalance `protobuf:"bytes,1,opt,name=exact_balance,json=exactBalance,proto3,oneof"`
}

type Listener_ConnectionBalanceConfig_ExtendBalance struct {
	// The listener will use the connection balancer according to “type_url“. If “type_url“ is invalid,
	// Envoy will not attempt to balance active connections between worker threads.
	// [#extension-category: envoy.network.connection_balance]
	ExtendBalance *v3.TypedExtensionConfig `protobuf:"bytes,2,opt,name=extend_balance,json=extendBalance,proto3,oneof"`
}

func (*Listener_ConnectionBalanceConfig_ExactBalance_) isListener_ConnectionBalanceConfig_BalanceType() {
}

func (*Listener_ConnectionBalanceConfig_ExtendBalance) isListener_ConnectionBalanceConfig_BalanceType() {
}

// Configuration for envoy internal listener. All the future internal listener features should be added here.
type Listener_InternalListenerConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Listener_InternalListenerConfig) Reset() {
	*x = Listener_InternalListenerConfig{}
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Listener_InternalListenerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listener_InternalListenerConfig) ProtoMessage() {}

func (x *Listener_InternalListenerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listener_InternalListenerConfig.ProtoReflect.Descriptor instead.
func (*Listener_InternalListenerConfig) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{2, 2}
}

// Configuration for filter chains discovery.
// [#not-implemented-hide:]
type Listener_FcdsConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional name to present to the filter chain discovery service. This may be an arbitrary name with arbitrary
	// length. If a name is not provided, the listener's name is used. Refer to :ref:`filter_chains <envoy_v3_api_field_config.listener.v3.Listener.name>`.
	// for details on how listener name is determined if unspecified. In addition, this may be a xdstp:// URL.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Configuration for the source of FCDS updates for this listener.
	// .. note::
	//
	//	This discovery service only supports ``AGGREGATED_GRPC`` API type.
	ConfigSource  *v3.ConfigSource `protobuf:"bytes,2,opt,name=config_source,json=configSource,proto3" json:"config_source,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Listener_FcdsConfig) Reset() {
	*x = Listener_FcdsConfig{}
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Listener_FcdsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listener_FcdsConfig) ProtoMessage() {}

func (x *Listener_FcdsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listener_FcdsConfig.ProtoReflect.Descriptor instead.
func (*Listener_FcdsConfig) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{2, 3}
}

func (x *Listener_FcdsConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Listener_FcdsConfig) GetConfigSource() *v3.ConfigSource {
	if x != nil {
		return x.ConfigSource
	}
	return nil
}

// A connection balancer implementation that does exact balancing. This means that a lock is
// held during balancing so that connection counts are nearly exactly balanced between worker
// threads. This is "nearly" exact in the sense that a connection might close in parallel thus
// making the counts incorrect, but this should be rectified on the next accept. This balancer
// sacrifices accept throughput for accuracy and should be used when there are a small number of
// connections that rarely cycle (e.g., service mesh gRPC egress).
type Listener_ConnectionBalanceConfig_ExactBalance struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Listener_ConnectionBalanceConfig_ExactBalance) Reset() {
	*x = Listener_ConnectionBalanceConfig_ExactBalance{}
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Listener_ConnectionBalanceConfig_ExactBalance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listener_ConnectionBalanceConfig_ExactBalance) ProtoMessage() {}

func (x *Listener_ConnectionBalanceConfig_ExactBalance) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_listener_v3_listener_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listener_ConnectionBalanceConfig_ExactBalance.ProtoReflect.Descriptor instead.
func (*Listener_ConnectionBalanceConfig_ExactBalance) Descriptor() ([]byte, []int) {
	return file_envoy_config_listener_v3_listener_proto_rawDescGZIP(), []int{2, 1, 0}
}

var File_envoy_config_listener_v3_listener_proto protoreflect.FileDescriptor

const file_envoy_config_listener_v3_listener_proto_rawDesc = "" +
	"\n" +
	"'envoy/config/listener/v3/listener.proto\x12\x18envoy.config.listener.v3\x1a)envoy/config/accesslog/v3/accesslog.proto\x1a\"envoy/config/core/v3/address.proto\x1a\x1fenvoy/config/core/v3/base.proto\x1a(envoy/config/core/v3/config_source.proto\x1a$envoy/config/core/v3/extension.proto\x1a(envoy/config/core/v3/socket_option.proto\x1a+envoy/config/listener/v3/api_listener.proto\x1a2envoy/config/listener/v3/listener_components.proto\x1a2envoy/config/listener/v3/udp_listener_config.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\"xds/core/v3/collection_entry.proto\x1a!xds/type/matcher/v3/matcher.proto\x1a#envoy/annotations/deprecation.proto\x1a\x1fudpa/annotations/security.proto\x1a\x1dudpa/annotations/status.proto\x1a!udpa/annotations/versioning.proto\x1a\x17validate/validate.proto\"\xe9\x01\n" +
	"\x11AdditionalAddress\x127\n" +
	"\aaddress\x18\x01 \x01(\v2\x1d.envoy.config.core.v3.AddressR\aaddress\x12R\n" +
	"\x0esocket_options\x18\x02 \x01(\v2+.envoy.config.core.v3.SocketOptionsOverrideR\rsocketOptions\x12G\n" +
	"\rtcp_keepalive\x18\x03 \x01(\v2\".envoy.config.core.v3.TcpKeepaliveR\ftcpKeepalive\"L\n" +
	"\x12ListenerCollection\x126\n" +
	"\aentries\x18\x01 \x03(\v2\x1c.xds.core.v3.CollectionEntryR\aentries\"\xb8\x1a\n" +
	"\bListener\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x127\n" +
	"\aaddress\x18\x02 \x01(\v2\x1d.envoy.config.core.v3.AddressR\aaddress\x12^\n" +
	"\x14additional_addresses\x18! \x03(\v2+.envoy.config.listener.v3.AdditionalAddressR\x13additionalAddresses\x12\x1f\n" +
	"\vstat_prefix\x18\x1c \x01(\tR\n" +
	"statPrefix\x12J\n" +
	"\rfilter_chains\x18\x03 \x03(\v2%.envoy.config.listener.v3.FilterChainR\ffilterChains\x12N\n" +
	"\vfcds_config\x18$ \x01(\v2-.envoy.config.listener.v3.Listener.FcdsConfigR\n" +
	"fcdsConfig\x12N\n" +
	"\x14filter_chain_matcher\x18  \x01(\v2\x1c.xds.type.matcher.v3.MatcherR\x12filterChainMatcher\x12D\n" +
	"\x10use_original_dst\x18\x04 \x01(\v2\x1a.google.protobuf.BoolValueR\x0euseOriginalDst\x12W\n" +
	"\x14default_filter_chain\x18\x19 \x01(\v2%.envoy.config.listener.v3.FilterChainR\x12defaultFilterChain\x12o\n" +
	"!per_connection_buffer_limit_bytes\x18\x05 \x01(\v2\x1c.google.protobuf.UInt32ValueB\a\x8a\x93\xb7*\x02\b\x01R\x1dperConnectionBufferLimitBytes\x12:\n" +
	"\bmetadata\x18\x06 \x01(\v2\x1e.envoy.config.core.v3.MetadataR\bmetadata\x12a\n" +
	"\rdeprecated_v1\x18\a \x01(\v2/.envoy.config.listener.v3.Listener.DeprecatedV1B\v\x92ǆ\xd8\x04\x033.0\x18\x01R\fdeprecatedV1\x12K\n" +
	"\n" +
	"drain_type\x18\b \x01(\x0e2,.envoy.config.listener.v3.Listener.DrainTypeR\tdrainType\x12S\n" +
	"\x10listener_filters\x18\t \x03(\v2(.envoy.config.listener.v3.ListenerFilterR\x0flistenerFilters\x12S\n" +
	"\x18listener_filters_timeout\x18\x0f \x01(\v2\x19.google.protobuf.DurationR\x16listenerFiltersTimeout\x12N\n" +
	"$continue_on_listener_filters_timeout\x18\x11 \x01(\bR continueOnListenerFiltersTimeout\x12<\n" +
	"\vtransparent\x18\n" +
	" \x01(\v2\x1a.google.protobuf.BoolValueR\vtransparent\x126\n" +
	"\bfreebind\x18\v \x01(\v2\x1a.google.protobuf.BoolValueR\bfreebind\x12I\n" +
	"\x0esocket_options\x18\r \x03(\v2\".envoy.config.core.v3.SocketOptionR\rsocketOptions\x12X\n" +
	"\x1atcp_fast_open_queue_length\x18\f \x01(\v2\x1c.google.protobuf.UInt32ValueR\x16tcpFastOpenQueueLength\x12S\n" +
	"\x11traffic_direction\x18\x10 \x01(\x0e2&.envoy.config.core.v3.TrafficDirectionR\x10trafficDirection\x12[\n" +
	"\x13udp_listener_config\x18\x12 \x01(\v2+.envoy.config.listener.v3.UdpListenerConfigR\x11udpListenerConfig\x12H\n" +
	"\fapi_listener\x18\x13 \x01(\v2%.envoy.config.listener.v3.ApiListenerR\vapiListener\x12v\n" +
	"\x19connection_balance_config\x18\x14 \x01(\v2:.envoy.config.listener.v3.Listener.ConnectionBalanceConfigR\x17connectionBalanceConfig\x12*\n" +
	"\n" +
	"reuse_port\x18\x15 \x01(\bB\v\x92ǆ\xd8\x04\x033.0\x18\x01R\treusePort\x12F\n" +
	"\x11enable_reuse_port\x18\x1d \x01(\v2\x1a.google.protobuf.BoolValueR\x0fenableReusePort\x12C\n" +
	"\n" +
	"access_log\x18\x16 \x03(\v2$.envoy.config.accesslog.v3.AccessLogR\taccessLog\x12F\n" +
	"\x10tcp_backlog_size\x18\x18 \x01(\v2\x1c.google.protobuf.UInt32ValueR\x0etcpBacklogSize\x12\x7f\n" +
	"*max_connections_to_accept_per_socket_event\x18\" \x01(\v2\x1c.google.protobuf.UInt32ValueB\a\xfaB\x04*\x02 \x00R$maxConnectionsToAcceptPerSocketEvent\x12<\n" +
	"\fbind_to_port\x18\x1a \x01(\v2\x1a.google.protobuf.BoolValueR\n" +
	"bindToPort\x12h\n" +
	"\x11internal_listener\x18\x1b \x01(\v29.envoy.config.listener.v3.Listener.InternalListenerConfigH\x00R\x10internalListener\x12!\n" +
	"\fenable_mptcp\x18\x1e \x01(\bR\venableMptcp\x127\n" +
	"\x18ignore_global_conn_limit\x18\x1f \x01(\bR\x15ignoreGlobalConnLimit\x126\n" +
	"\x17bypass_overload_manager\x18# \x01(\bR\x15bypassOverloadManager\x12G\n" +
	"\rtcp_keepalive\x18% \x01(\v2\".envoy.config.core.v3.TcpKeepaliveR\ftcpKeepalive\x1aw\n" +
	"\fDeprecatedV1\x12<\n" +
	"\fbind_to_port\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\n" +
	"bindToPort:)\x9aň\x1e$\n" +
	"\"envoy.api.v2.Listener.DeprecatedV1\x1a\xfc\x02\n" +
	"\x17ConnectionBalanceConfig\x12n\n" +
	"\rexact_balance\x18\x01 \x01(\v2G.envoy.config.listener.v3.Listener.ConnectionBalanceConfig.ExactBalanceH\x00R\fexactBalance\x12S\n" +
	"\x0eextend_balance\x18\x02 \x01(\v2*.envoy.config.core.v3.TypedExtensionConfigH\x00R\rextendBalance\x1aQ\n" +
	"\fExactBalance:A\x9aň\x1e<\n" +
	":envoy.api.v2.Listener.ConnectionBalanceConfig.ExactBalance:4\x9aň\x1e/\n" +
	"-envoy.api.v2.Listener.ConnectionBalanceConfigB\x13\n" +
	"\fbalance_type\x12\x03\xf8B\x01\x1a\x18\n" +
	"\x16InternalListenerConfig\x1ai\n" +
	"\n" +
	"FcdsConfig\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12G\n" +
	"\rconfig_source\x18\x02 \x01(\v2\".envoy.config.core.v3.ConfigSourceR\fconfigSource\")\n" +
	"\tDrainType\x12\v\n" +
	"\aDEFAULT\x10\x00\x12\x0f\n" +
	"\vMODIFY_ONLY\x10\x01:\x1c\x9aň\x1e\x17\n" +
	"\x15envoy.api.v2.ListenerB\x14\n" +
	"\x12listener_specifierJ\x04\b\x0e\x10\x0fJ\x04\b\x17\x10\x18\"\x11\n" +
	"\x0fListenerManager\"\x1b\n" +
	"\x19ValidationListenerManager\"\x14\n" +
	"\x12ApiListenerManagerB\x8d\x01\xba\x80\xc8\xd1\x06\x02\x10\x02\n" +
	"&io.envoyproxy.envoy.config.listener.v3B\rListenerProtoP\x01ZJgithub.com/envoyproxy/go-control-plane/envoy/config/listener/v3;listenerv3b\x06proto3"

var (
	file_envoy_config_listener_v3_listener_proto_rawDescOnce sync.Once
	file_envoy_config_listener_v3_listener_proto_rawDescData []byte
)

func file_envoy_config_listener_v3_listener_proto_rawDescGZIP() []byte {
	file_envoy_config_listener_v3_listener_proto_rawDescOnce.Do(func() {
		file_envoy_config_listener_v3_listener_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_envoy_config_listener_v3_listener_proto_rawDesc), len(file_envoy_config_listener_v3_listener_proto_rawDesc)))
	})
	return file_envoy_config_listener_v3_listener_proto_rawDescData
}

var file_envoy_config_listener_v3_listener_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_envoy_config_listener_v3_listener_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_envoy_config_listener_v3_listener_proto_goTypes = []any{
	(Listener_DrainType)(0),                               // 0: envoy.config.listener.v3.Listener.DrainType
	(*AdditionalAddress)(nil),                             // 1: envoy.config.listener.v3.AdditionalAddress
	(*ListenerCollection)(nil),                            // 2: envoy.config.listener.v3.ListenerCollection
	(*Listener)(nil),                                      // 3: envoy.config.listener.v3.Listener
	(*ListenerManager)(nil),                               // 4: envoy.config.listener.v3.ListenerManager
	(*ValidationListenerManager)(nil),                     // 5: envoy.config.listener.v3.ValidationListenerManager
	(*ApiListenerManager)(nil),                            // 6: envoy.config.listener.v3.ApiListenerManager
	(*Listener_DeprecatedV1)(nil),                         // 7: envoy.config.listener.v3.Listener.DeprecatedV1
	(*Listener_ConnectionBalanceConfig)(nil),              // 8: envoy.config.listener.v3.Listener.ConnectionBalanceConfig
	(*Listener_InternalListenerConfig)(nil),               // 9: envoy.config.listener.v3.Listener.InternalListenerConfig
	(*Listener_FcdsConfig)(nil),                           // 10: envoy.config.listener.v3.Listener.FcdsConfig
	(*Listener_ConnectionBalanceConfig_ExactBalance)(nil), // 11: envoy.config.listener.v3.Listener.ConnectionBalanceConfig.ExactBalance
	(*v3.Address)(nil),                                    // 12: envoy.config.core.v3.Address
	(*v3.SocketOptionsOverride)(nil),                      // 13: envoy.config.core.v3.SocketOptionsOverride
	(*v3.TcpKeepalive)(nil),                               // 14: envoy.config.core.v3.TcpKeepalive
	(*v31.CollectionEntry)(nil),                           // 15: xds.core.v3.CollectionEntry
	(*FilterChain)(nil),                                   // 16: envoy.config.listener.v3.FilterChain
	(*v32.Matcher)(nil),                                   // 17: xds.type.matcher.v3.Matcher
	(*wrapperspb.BoolValue)(nil),                          // 18: google.protobuf.BoolValue
	(*wrapperspb.UInt32Value)(nil),                        // 19: google.protobuf.UInt32Value
	(*v3.Metadata)(nil),                                   // 20: envoy.config.core.v3.Metadata
	(*ListenerFilter)(nil),                                // 21: envoy.config.listener.v3.ListenerFilter
	(*durationpb.Duration)(nil),                           // 22: google.protobuf.Duration
	(*v3.SocketOption)(nil),                               // 23: envoy.config.core.v3.SocketOption
	(v3.TrafficDirection)(0),                              // 24: envoy.config.core.v3.TrafficDirection
	(*UdpListenerConfig)(nil),                             // 25: envoy.config.listener.v3.UdpListenerConfig
	(*ApiListener)(nil),                                   // 26: envoy.config.listener.v3.ApiListener
	(*v33.AccessLog)(nil),                                 // 27: envoy.config.accesslog.v3.AccessLog
	(*v3.TypedExtensionConfig)(nil),                       // 28: envoy.config.core.v3.TypedExtensionConfig
	(*v3.ConfigSource)(nil),                               // 29: envoy.config.core.v3.ConfigSource
}
var file_envoy_config_listener_v3_listener_proto_depIdxs = []int32{
	12, // 0: envoy.config.listener.v3.AdditionalAddress.address:type_name -> envoy.config.core.v3.Address
	13, // 1: envoy.config.listener.v3.AdditionalAddress.socket_options:type_name -> envoy.config.core.v3.SocketOptionsOverride
	14, // 2: envoy.config.listener.v3.AdditionalAddress.tcp_keepalive:type_name -> envoy.config.core.v3.TcpKeepalive
	15, // 3: envoy.config.listener.v3.ListenerCollection.entries:type_name -> xds.core.v3.CollectionEntry
	12, // 4: envoy.config.listener.v3.Listener.address:type_name -> envoy.config.core.v3.Address
	1,  // 5: envoy.config.listener.v3.Listener.additional_addresses:type_name -> envoy.config.listener.v3.AdditionalAddress
	16, // 6: envoy.config.listener.v3.Listener.filter_chains:type_name -> envoy.config.listener.v3.FilterChain
	10, // 7: envoy.config.listener.v3.Listener.fcds_config:type_name -> envoy.config.listener.v3.Listener.FcdsConfig
	17, // 8: envoy.config.listener.v3.Listener.filter_chain_matcher:type_name -> xds.type.matcher.v3.Matcher
	18, // 9: envoy.config.listener.v3.Listener.use_original_dst:type_name -> google.protobuf.BoolValue
	16, // 10: envoy.config.listener.v3.Listener.default_filter_chain:type_name -> envoy.config.listener.v3.FilterChain
	19, // 11: envoy.config.listener.v3.Listener.per_connection_buffer_limit_bytes:type_name -> google.protobuf.UInt32Value
	20, // 12: envoy.config.listener.v3.Listener.metadata:type_name -> envoy.config.core.v3.Metadata
	7,  // 13: envoy.config.listener.v3.Listener.deprecated_v1:type_name -> envoy.config.listener.v3.Listener.DeprecatedV1
	0,  // 14: envoy.config.listener.v3.Listener.drain_type:type_name -> envoy.config.listener.v3.Listener.DrainType
	21, // 15: envoy.config.listener.v3.Listener.listener_filters:type_name -> envoy.config.listener.v3.ListenerFilter
	22, // 16: envoy.config.listener.v3.Listener.listener_filters_timeout:type_name -> google.protobuf.Duration
	18, // 17: envoy.config.listener.v3.Listener.transparent:type_name -> google.protobuf.BoolValue
	18, // 18: envoy.config.listener.v3.Listener.freebind:type_name -> google.protobuf.BoolValue
	23, // 19: envoy.config.listener.v3.Listener.socket_options:type_name -> envoy.config.core.v3.SocketOption
	19, // 20: envoy.config.listener.v3.Listener.tcp_fast_open_queue_length:type_name -> google.protobuf.UInt32Value
	24, // 21: envoy.config.listener.v3.Listener.traffic_direction:type_name -> envoy.config.core.v3.TrafficDirection
	25, // 22: envoy.config.listener.v3.Listener.udp_listener_config:type_name -> envoy.config.listener.v3.UdpListenerConfig
	26, // 23: envoy.config.listener.v3.Listener.api_listener:type_name -> envoy.config.listener.v3.ApiListener
	8,  // 24: envoy.config.listener.v3.Listener.connection_balance_config:type_name -> envoy.config.listener.v3.Listener.ConnectionBalanceConfig
	18, // 25: envoy.config.listener.v3.Listener.enable_reuse_port:type_name -> google.protobuf.BoolValue
	27, // 26: envoy.config.listener.v3.Listener.access_log:type_name -> envoy.config.accesslog.v3.AccessLog
	19, // 27: envoy.config.listener.v3.Listener.tcp_backlog_size:type_name -> google.protobuf.UInt32Value
	19, // 28: envoy.config.listener.v3.Listener.max_connections_to_accept_per_socket_event:type_name -> google.protobuf.UInt32Value
	18, // 29: envoy.config.listener.v3.Listener.bind_to_port:type_name -> google.protobuf.BoolValue
	9,  // 30: envoy.config.listener.v3.Listener.internal_listener:type_name -> envoy.config.listener.v3.Listener.InternalListenerConfig
	14, // 31: envoy.config.listener.v3.Listener.tcp_keepalive:type_name -> envoy.config.core.v3.TcpKeepalive
	18, // 32: envoy.config.listener.v3.Listener.DeprecatedV1.bind_to_port:type_name -> google.protobuf.BoolValue
	11, // 33: envoy.config.listener.v3.Listener.ConnectionBalanceConfig.exact_balance:type_name -> envoy.config.listener.v3.Listener.ConnectionBalanceConfig.ExactBalance
	28, // 34: envoy.config.listener.v3.Listener.ConnectionBalanceConfig.extend_balance:type_name -> envoy.config.core.v3.TypedExtensionConfig
	29, // 35: envoy.config.listener.v3.Listener.FcdsConfig.config_source:type_name -> envoy.config.core.v3.ConfigSource
	36, // [36:36] is the sub-list for method output_type
	36, // [36:36] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_envoy_config_listener_v3_listener_proto_init() }
func file_envoy_config_listener_v3_listener_proto_init() {
	if File_envoy_config_listener_v3_listener_proto != nil {
		return
	}
	file_envoy_config_listener_v3_api_listener_proto_init()
	file_envoy_config_listener_v3_listener_components_proto_init()
	file_envoy_config_listener_v3_udp_listener_config_proto_init()
	file_envoy_config_listener_v3_listener_proto_msgTypes[2].OneofWrappers = []any{
		(*Listener_InternalListener)(nil),
	}
	file_envoy_config_listener_v3_listener_proto_msgTypes[7].OneofWrappers = []any{
		(*Listener_ConnectionBalanceConfig_ExactBalance_)(nil),
		(*Listener_ConnectionBalanceConfig_ExtendBalance)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_envoy_config_listener_v3_listener_proto_rawDesc), len(file_envoy_config_listener_v3_listener_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_config_listener_v3_listener_proto_goTypes,
		DependencyIndexes: file_envoy_config_listener_v3_listener_proto_depIdxs,
		EnumInfos:         file_envoy_config_listener_v3_listener_proto_enumTypes,
		MessageInfos:      file_envoy_config_listener_v3_listener_proto_msgTypes,
	}.Build()
	File_envoy_config_listener_v3_listener_proto = out.File
	file_envoy_config_listener_v3_listener_proto_goTypes = nil
	file_envoy_config_listener_v3_listener_proto_depIdxs = nil
}
