//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/clusters/dns/v3/dns_cluster.proto

package dnsv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"

	v3 "github.com/envoyproxy/go-control-plane/envoy/extensions/clusters/common/dns/v3"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort

	_ = v3.DnsLookupFamily(0)
)

// Validate checks the field values on DnsCluster with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *DnsCluster) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DnsCluster with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in DnsClusterMultiError, or
// nil if none found.
func (m *DnsCluster) ValidateAll() error {
	return m.validate(true)
}

func (m *DnsCluster) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if d := m.GetDnsRefreshRate(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = DnsClusterValidationError{
				field:  "DnsRefreshRate",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 1000000*time.Nanosecond)

			if dur <= gt {
				err := DnsClusterValidationError{
					field:  "DnsRefreshRate",
					reason: "value must be greater than 1ms",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetDnsFailureRefreshRate()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DnsClusterValidationError{
					field:  "DnsFailureRefreshRate",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DnsClusterValidationError{
					field:  "DnsFailureRefreshRate",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDnsFailureRefreshRate()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DnsClusterValidationError{
				field:  "DnsFailureRefreshRate",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for RespectDnsTtl

	if d := m.GetDnsJitter(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = DnsClusterValidationError{
				field:  "DnsJitter",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := DnsClusterValidationError{
					field:  "DnsJitter",
					reason: "value must be greater than or equal to 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetTypedDnsResolverConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DnsClusterValidationError{
					field:  "TypedDnsResolverConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DnsClusterValidationError{
					field:  "TypedDnsResolverConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTypedDnsResolverConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DnsClusterValidationError{
				field:  "TypedDnsResolverConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for DnsLookupFamily

	// no validation rules for AllAddressesInSingleEndpoint

	if len(errors) > 0 {
		return DnsClusterMultiError(errors)
	}

	return nil
}

// DnsClusterMultiError is an error wrapping multiple validation errors
// returned by DnsCluster.ValidateAll() if the designated constraints aren't met.
type DnsClusterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DnsClusterMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DnsClusterMultiError) AllErrors() []error { return m }

// DnsClusterValidationError is the validation error returned by
// DnsCluster.Validate if the designated constraints aren't met.
type DnsClusterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DnsClusterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DnsClusterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DnsClusterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DnsClusterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DnsClusterValidationError) ErrorName() string { return "DnsClusterValidationError" }

// Error satisfies the builtin error interface
func (e DnsClusterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDnsCluster.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DnsClusterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DnsClusterValidationError{}

// Validate checks the field values on DnsCluster_RefreshRate with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DnsCluster_RefreshRate) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DnsCluster_RefreshRate with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DnsCluster_RefreshRateMultiError, or nil if none found.
func (m *DnsCluster_RefreshRate) ValidateAll() error {
	return m.validate(true)
}

func (m *DnsCluster_RefreshRate) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetBaseInterval() == nil {
		err := DnsCluster_RefreshRateValidationError{
			field:  "BaseInterval",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if d := m.GetBaseInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = DnsCluster_RefreshRateValidationError{
				field:  "BaseInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 1000000*time.Nanosecond)

			if dur <= gt {
				err := DnsCluster_RefreshRateValidationError{
					field:  "BaseInterval",
					reason: "value must be greater than 1ms",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetMaxInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = DnsCluster_RefreshRateValidationError{
				field:  "MaxInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 1000000*time.Nanosecond)

			if dur <= gt {
				err := DnsCluster_RefreshRateValidationError{
					field:  "MaxInterval",
					reason: "value must be greater than 1ms",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return DnsCluster_RefreshRateMultiError(errors)
	}

	return nil
}

// DnsCluster_RefreshRateMultiError is an error wrapping multiple validation
// errors returned by DnsCluster_RefreshRate.ValidateAll() if the designated
// constraints aren't met.
type DnsCluster_RefreshRateMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DnsCluster_RefreshRateMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DnsCluster_RefreshRateMultiError) AllErrors() []error { return m }

// DnsCluster_RefreshRateValidationError is the validation error returned by
// DnsCluster_RefreshRate.Validate if the designated constraints aren't met.
type DnsCluster_RefreshRateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DnsCluster_RefreshRateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DnsCluster_RefreshRateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DnsCluster_RefreshRateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DnsCluster_RefreshRateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DnsCluster_RefreshRateValidationError) ErrorName() string {
	return "DnsCluster_RefreshRateValidationError"
}

// Error satisfies the builtin error interface
func (e DnsCluster_RefreshRateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDnsCluster_RefreshRate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DnsCluster_RefreshRateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DnsCluster_RefreshRateValidationError{}
