//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/load_balancing_policies/override_host/v3/override_host.proto

package override_hostv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on OverrideHost with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *OverrideHost) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on OverrideHost with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in OverrideHostMultiError, or
// nil if none found.
func (m *OverrideHost) ValidateAll() error {
	return m.validate(true)
}

func (m *OverrideHost) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetOverrideHostSources()) < 1 {
		err := OverrideHostValidationError{
			field:  "OverrideHostSources",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetOverrideHostSources() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, OverrideHostValidationError{
						field:  fmt.Sprintf("OverrideHostSources[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, OverrideHostValidationError{
						field:  fmt.Sprintf("OverrideHostSources[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OverrideHostValidationError{
					field:  fmt.Sprintf("OverrideHostSources[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if m.GetFallbackPolicy() == nil {
		err := OverrideHostValidationError{
			field:  "FallbackPolicy",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetFallbackPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, OverrideHostValidationError{
					field:  "FallbackPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, OverrideHostValidationError{
					field:  "FallbackPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFallbackPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OverrideHostValidationError{
				field:  "FallbackPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return OverrideHostMultiError(errors)
	}

	return nil
}

// OverrideHostMultiError is an error wrapping multiple validation errors
// returned by OverrideHost.ValidateAll() if the designated constraints aren't met.
type OverrideHostMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m OverrideHostMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m OverrideHostMultiError) AllErrors() []error { return m }

// OverrideHostValidationError is the validation error returned by
// OverrideHost.Validate if the designated constraints aren't met.
type OverrideHostValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OverrideHostValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OverrideHostValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OverrideHostValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OverrideHostValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OverrideHostValidationError) ErrorName() string { return "OverrideHostValidationError" }

// Error satisfies the builtin error interface
func (e OverrideHostValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOverrideHost.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OverrideHostValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OverrideHostValidationError{}

// Validate checks the field values on OverrideHost_OverrideHostSource with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *OverrideHost_OverrideHostSource) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on OverrideHost_OverrideHostSource with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// OverrideHost_OverrideHostSourceMultiError, or nil if none found.
func (m *OverrideHost_OverrideHostSource) ValidateAll() error {
	return m.validate(true)
}

func (m *OverrideHost_OverrideHostSource) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_OverrideHost_OverrideHostSource_Header_Pattern.MatchString(m.GetHeader()) {
		err := OverrideHost_OverrideHostSourceValidationError{
			field:  "Header",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, OverrideHost_OverrideHostSourceValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, OverrideHost_OverrideHostSourceValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OverrideHost_OverrideHostSourceValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return OverrideHost_OverrideHostSourceMultiError(errors)
	}

	return nil
}

// OverrideHost_OverrideHostSourceMultiError is an error wrapping multiple
// validation errors returned by OverrideHost_OverrideHostSource.ValidateAll()
// if the designated constraints aren't met.
type OverrideHost_OverrideHostSourceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m OverrideHost_OverrideHostSourceMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m OverrideHost_OverrideHostSourceMultiError) AllErrors() []error { return m }

// OverrideHost_OverrideHostSourceValidationError is the validation error
// returned by OverrideHost_OverrideHostSource.Validate if the designated
// constraints aren't met.
type OverrideHost_OverrideHostSourceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OverrideHost_OverrideHostSourceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OverrideHost_OverrideHostSourceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OverrideHost_OverrideHostSourceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OverrideHost_OverrideHostSourceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OverrideHost_OverrideHostSourceValidationError) ErrorName() string {
	return "OverrideHost_OverrideHostSourceValidationError"
}

// Error satisfies the builtin error interface
func (e OverrideHost_OverrideHostSourceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOverrideHost_OverrideHostSource.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OverrideHost_OverrideHostSourceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OverrideHost_OverrideHostSourceValidationError{}

var _OverrideHost_OverrideHostSource_Header_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")
