#ifndef NIL_H
#define NIL_H

/* Warning, this file is autogenerated by cbindgen. Don't modify this manually. */

#include <stdarg.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include "nouveau/headers/nv_device_info.h"
#include "util/format/u_format.h"
#include "drm-uapi/drm_fourcc.h"

#define NIL_MAX_LEVELS 16

#define NIL_MAX_DRM_FORMAT_MODS 7

#define nil_DRM_FORMAT_MOD_LINEAR 0

#define nil_DRM_FORMAT_MOD_INVALID 72057594037927935

enum nil_gob_type {
  /**
   * Indicates a linear (not tiled) image
   */
  NIL_GOB_TYPE_LINEAR,
  /**
   * A grab-bag GOB format for all depth/stencil surfaces
   */
  NIL_GOB_TYPE_FERMI_ZS,
  /**
   * The Fermi GOB format for color images
   *
   * A `FermiColor` GOB is 512 bytes, arranged in a 64x8 layout and split
   * into Sectors. Each Sector is 32 Bytes, and the Sectors in a GOB are
   * arranged in a 16x2 layout (i.e., two 16B lines on top of each other).
   * It's then arranged into two columns that are 2 sectors by 4, leading to
   * a 4x4 grid of sectors:
   *
   * |           |           |           |           |
   * |-----------|-----------|-----------|-----------|
   * | Sector  1 | Sector  2 | Sector  9 | Sector 10 |
   * | Sector  0 | Sector  3 | Sector  8 | Sector 11 |
   * | Sector  5 | Sector  6 | Sector 13 | Sector 14 |
   * | Sector  4 | Sector  7 | Sector 12 | Sector 15 |
   *
   * `CopyGOBFermi` implements CPU copies for Fermi color GOBs.
   */
  NIL_GOB_TYPE_FERMI_COLOR,
  /**
   * The Tegra GOB format for color images
   *
   * A `TegraColor` GOB is 512 bytes, arranged in a 64x8 layout and split
   * into Sectors. Each Sector is 32 Bytes, and the Sectors in a GOB are
   * arranged in a 16x2 layout (i.e., two 16B lines on top of each other).
   * It's then arranged into two columns that are 2 sectors by 4, leading to
   * a 4x4 grid of sectors:
   *
   * |           |           |           |           |
   * |-----------|-----------|-----------|-----------|
   * | Sector  0 | Sector  1 | Sector  8 | Sector  9 |
   * | Sector  2 | Sector  3 | Sector 10 | Sector 11 |
   * | Sector  4 | Sector  5 | Sector 12 | Sector 13 |
   * | Sector  6 | Sector  7 | Sector 14 | Sector 15 |
   *
   * `CopyGOBTegra` implements CPU copies for Tegra color GOBs.
   */
  NIL_GOB_TYPE_TEGRA_COLOR,
  /**
   * The Turing 2D GOB format for color images
   *
   * A `TuringColor2D` GOB is 512 bytes, arranged in a 64x8 layout and split
   * into Sectors. Each Sector is 32 Bytes, and the Sectors in a GOB are
   * arranged in a 16x2 layout (i.e., two 16B lines on top of each other).
   * It's then arranged into two columns that are 2 sectors by 4, leading to
   * a 4x4 grid of sectors:
   *
   * |           |           |           |           |
   * |-----------|-----------|-----------|-----------|
   * | Sector  0 | Sector  2 | Sector  8 | Sector 10 |
   * | Sector  1 | Sector  3 | Sector  9 | Sector 11 |
   * | Sector  4 | Sector  6 | Sector 12 | Sector 14 |
   * | Sector  5 | Sector  7 | Sector 13 | Sector 15 |
   *
   * `CopyGOBTuring2D` implements CPU copies for Turing color 2D GOBs.
   */
  NIL_GOB_TYPE_TURING_COLOR2_D,
  /**
   * The Blackwell+ GOB format for 8bit images
   *
   * A `Blackwell8Bit` GOB is 512 bytes, arranged in a 64x8 layout and split
   * into Sectors. Each Sector is 32 Bytes, and the Sectors in a GOB are
   * arranged in a 8x4 layout (i.e., four 8B lines on top of each other).
   * It's then arranged into two columns that are 4 sectors by 2, leading to
   * a 2x8 grid of sectors:
   *
   * |           |           |           |           |           |           |           |           |
   * |-----------|-----------|-----------|-----------|-----------|-----------|-----------|-----------|
   * | Sector  0 | Sector  2 | Sector  4 | Sector  6 | Sector  8 | Sector 10 | Sector 12 | Sector 14 |
   * | Sector  1 | Sector  3 | Sector  5 | Sector  7 | Sector  9 | Sector 11 | Sector 13 | Sector 15 |
   *
   * `CopyGOBBlackwell2D1BPP` implements CPU copies for 8-bit Blackwell
   * color 2D GOBs.
   */
  NIL_GOB_TYPE_BLACKWELL8_BIT,
  /**
   * The Blackwell+ GOB format for 16bit images
   *
   * A `Blackwell16Bit` GOB is 512 bytes, arranged in a 64x8 layout and split
   * into Sectors. Each Sector is 32 Bytes, and the Sectors in a GOB are
   * arranged in a 16x2 layout (i.e., two 16B lines on top of each other).
   * It's then arranged into two columns that are 2 sectors by 4, leading to
   * a 4x4 grid of sectors:
   *
   * |           |           |           |           |
   * |-----------|-----------|-----------|-----------|
   * | Sector  0 | Sector  1 | Sector  8 | Sector  9 |
   * | Sector  2 | Sector  3 | Sector 10 | Sector 11 |
   * | Sector  4 | Sector  5 | Sector 12 | Sector 13 |
   * | Sector  6 | Sector  7 | Sector 14 | Sector 15 |
   *
   * `CopyGOBBlackwell2D2BPP` implements CPU copies for 16-bit Blackwell
   * color 2D GOBs.
   */
  NIL_GOB_TYPE_BLACKWELL16_BIT,
  /**
   * The Blackwell+ GOB format for 24-bit depth images
   */
  NIL_GOB_TYPE_BLACKWELL_Z24,
};
typedef uint8_t nil_gob_type;

enum nil_image_dim {
  NIL_IMAGE_DIM_1D = 1,
  NIL_IMAGE_DIM_2D = 2,
  NIL_IMAGE_DIM_3D = 3,
};
typedef uint8_t nil_image_dim;

enum nil_sample_layout {
  NIL_SAMPLE_LAYOUT_1X1,
  NIL_SAMPLE_LAYOUT_2X1,
  NIL_SAMPLE_LAYOUT_2X1_D3D,
  NIL_SAMPLE_LAYOUT_2X2,
  NIL_SAMPLE_LAYOUT_4X2,
  NIL_SAMPLE_LAYOUT_4X2_D3D,
  NIL_SAMPLE_LAYOUT_4X4,
  NIL_SAMPLE_LAYOUT_INVALID,
};
typedef uint8_t nil_sample_layout;

enum nil_view_type {
  NIL_VIEW_TYPE_1D,
  NIL_VIEW_TYPE_2D,
  NIL_VIEW_TYPE_3D,
  NIL_VIEW_TYPE_3D_SLICED,
  NIL_VIEW_TYPE_CUBE,
  NIL_VIEW_TYPE_1D_ARRAY,
  NIL_VIEW_TYPE_2D_ARRAY,
  NIL_VIEW_TYPE_CUBE_ARRAY,
};
typedef uint8_t nil_view_type;

/**
 * An enum describing how an image view will be accessed by the shader.
 */
enum nil_view_access {
  /**
   * This image view will be accessed via texture instructions (tex, etc.)
   */
  NIL_VIEW_ACCESS_TEXTURE,
  /**
   * This image view will be accessed as a storage image via surface
   * instructions (suld/sust)
   *
   * This primarily affects multisampled images.  With multisampled storage
   * image, we generate a descriptor which has the image dimensions in units
   * of samples rather than pixels.  The resulting descriptors are safe to
   * access via surface instructions (suld/sust) since the surface
   * instructions entirely ignore the MULTI_SAMPLE_COUNT field in the image
   * descriptor.  They are not, however, safe to access from texture
   * instructions as those take the sample count into account and will think
   * the image is too big, possibly leading to OOB reads.
   *
   * In NAK (the compiler component), we have lowering code which takes the
   * sample into account and is able compute 2D (x, y) coordidinates in
   * sample space which correspond to the logical (x, y, s) coordinate
   * provided by the client shader, thus allowing multisampled storage
   * access.
   */
  NIL_VIEW_ACCESS_STORAGE,
};
typedef uint8_t nil_view_access;

struct nil_Extent4D_Bytes {
  uint32_t width;
  uint32_t height;
  uint32_t depth;
  uint32_t array_len;
};

struct nil_Offset4D_Bytes {
  uint32_t x;
  uint32_t y;
  uint32_t z;
  uint32_t a;
};

/**
 * NVIDIA hardware employs a semi-programmable multi-tier image tiling scheme.
 *
 * ## Images as arrays of tiles (or blocks)
 *
 * Images are first tiled in a grid of rows of tiles (which NVIDIA calls
 * "Blocks"), with one or more columns:
 *
 * |         |         |         |         |
 * |---------|---------|---------|---------|
 * | Tile 0  | Tile 1  | Tile 2  | Tile 3  |
 * | Tile 4  | Tile 5  | Tile 6  | Tile 7  |
 * | Tile 8  | Tile 9  | Tile 10 | Tile 11 |
 *
 * The tiles (or blocks) themselves are ordered linearly as can be seen above,
 * which is where the "Block Linear" naming comes from for NVIDIA's tiling
 * scheme.
 *
 * For 3D images, each tile continues in the Z direction such that tiles
 * contain multiple Z slices. If the image depth is longer than the tile depth,
 * there will be more than one layer of tiles, where a layer is made up of 1 or
 * more Z slices. For example, if the above tile pattern was the first layer of
 * a multilayer arrangement, the second layer would be:
 *
 * |         |         |         |         |
 * |---------|---------|---------|---------|
 * | Tile 12 | Tile 13 | Tile 14 | Tile 15 |
 * | Tile 16 | Tile 17 | Tile 18 | Tile 19 |
 * | Tile 20 | Tile 21 | Tile 22 | Tile 23 |
 *
 * The number of rows, columns, and layers of tiles can thus be deduced to be:
 * ```
 *    rows    = ceiling(image_height / tile_height)
 *    columns = ceiling(image_width  / tile_width)
 *    layers  = ceiling(image_depth  / tile_depth)
 * ```
 * Where `tile_width`, `tile_height`, and `tile_depth` come from
 * [`Tiling::extent_B`].
 *
 * ## Tiles as arrays of GOBs
 *
 * Now comes the second tier. Each tile (or block) is composed of GOBs (Groups
 * of Bytes) arranged in linear order, just like tiles are within the image
 * itself.  In the common case, each tile is just vertical column of GOBs.
 * However, for 3D or sparse images, a tile may be fully 3-dimensional.
 *
 * The number of GOBs per tiles is controllable by software.  Image
 * descriptors, color target bind methods, and DMA methods all allow
 * programming tile dimensions in units of a power of two number of GOBs.  In
 * NIL, these dimensions are given by [`Tiling::x_log2'], [`Tiling::y_log2'],
 * and [`Tiling::y_log2'].
 *
 * ## GOBs as arrays of bytes
 *
 * The data may be further swizzled within a GOB.  The swizzling of data within
 * a GOB is determined by the [`GOBType`].
 */
struct nil_tiling {
  /**
   * GOB type
   */
  nil_gob_type gob_type;
  /**
   * log2 of the X tile dimension in GOBs
   */
  uint8_t x_log2;
  /**
   * log2 of the Y tile dimension in GOBs
   */
  uint8_t y_log2;
  /**
   * log2 of the z tile dimension in GOBs
   */
  uint8_t z_log2;
};

struct nil_descriptor {
  uint32_t bits[8];
};

struct nil_format {
  enum pipe_format p_format;
};

struct nil_Extent4D_Pixels {
  uint32_t width;
  uint32_t height;
  uint32_t depth;
  uint32_t array_len;
};

/**
 * Represents the data layout of a single slice (level + lod) of an image.
 */
struct nil_image_level {
  uint64_t offset_B;
  struct nil_tiling tiling;
  uint32_t row_stride_B;
};

struct nil_image {
  nil_image_dim dim;
  struct nil_format format;
  struct nil_Extent4D_Pixels extent_px;
  nil_sample_layout sample_layout;
  uint32_t num_levels;
  uint32_t mip_tail_first_lod;
  struct nil_image_level levels[NIL_MAX_LEVELS];
  uint64_t array_stride_B;
  uint32_t align_B;
  uint64_t size_B;
  bool compressed;
  uint16_t tile_mode;
  uint8_t pte_kind;
};

struct nil_view {
  nil_view_type view_type;
  nil_view_access access;
  /**
   * The format to use in the view
   *
   * This may differ from the format of the actual isl_surf but must have the
   * same block size.
   */
  struct nil_format format;
  uint32_t base_level;
  uint32_t num_levels;
  /**
   * Base array layer
   *
   * For cube maps, both base_array_layer and array_len should be specified in
   * terms of 2-D layers and must be a multiple of 6.
   */
  uint32_t base_array_layer;
  /**
   * Array Length
   *
   * Indicates the number of array elements starting at  Base Array Layer.
   */
  uint32_t array_len;
  enum pipe_swizzle swizzle[4];
  float min_lod_clamp;
};

struct nil_Extent4D_Elements {
  uint32_t width;
  uint32_t height;
  uint32_t depth;
  uint32_t array_len;
};

struct nil_Extent4D_Tiles {
  uint32_t width;
  uint32_t height;
  uint32_t depth;
  uint32_t array_len;
};

struct nil_Offset4D_Elements {
  uint32_t x;
  uint32_t y;
  uint32_t z;
  uint32_t a;
};

struct nil_Offset4D_Pixels {
  uint32_t x;
  uint32_t y;
  uint32_t z;
  uint32_t a;
};

struct nil_Offset4D_Tiles {
  uint32_t x;
  uint32_t y;
  uint32_t z;
  uint32_t a;
};

struct nil_Extent4D_Samples {
  uint32_t width;
  uint32_t height;
  uint32_t depth;
  uint32_t array_len;
};

struct nil_sample_offset {
  uint8_t x;
  uint8_t y;
};

typedef uint8_t nil_image_usage_flags;

struct nil_image_init_info {
  nil_image_dim dim;
  struct nil_format format;
  struct nil_Extent4D_Pixels extent_px;
  uint32_t levels;
  uint32_t samples;
  nil_image_usage_flags usage;
  uint64_t modifier;
  uint32_t explicit_row_stride_B;
  uint32_t max_alignment_B;
};

/**
 * Descriptor for Kepler storage image functions
 *
 * This is never passed directly to hardware, but is used by
 * nak_nir_lower_image_addrs to lower image coordinates into addresses.
 */
struct nil_su_info {
  /**
   * Address of the image LOF, shifted by 8
   */
  uint32_t addr_shifted8;
  /**
   * Hardware format bitfield
   *
   * See encode_format for a more precise description.
   */
  uint32_t format_info;
  /**
   * suclamp value in the X dimension
   * for buffers this is the number of elements.
   */
  uint32_t clamp_x;
  /**
   * Bits 0 ..24: Pitch in tiles for block linear or
   *                    in elements for pitch linear
   * Bits 24..28: Log2 of sample width in pixels
   * Bits 28..32: Log2 of sample height in pixels
   */
  uint32_t pitch;
  /**
   * suclamp value in the Y dimension
   * for buffers this is the size of the element in bytes.
   */
  uint32_t clamp_y;
  /**
   * Array stride in bytes, shifted by 8
   */
  uint32_t array_stride_shifted8;
  /**
   * suclamp value in the Z dimension, or array clamp
   */
  uint32_t clamp_z;
  /**
   * Extra offsetting information
   *
   * For multisampled images, this is a map from sample index to
   * x/y position within a pixel. Each nibble is a sample with
   * x in the low 2 bits and y in the high 2 bits.
   *
   * For buffers (which can never be multisampled), this is
   * the low 8 bits of the address.
   */
  uint32_t extra;
};

#define NIL_IMAGE_USAGE_2D_VIEW_BIT (1 << 0)

#define NIL_IMAGE_USAGE_LINEAR_BIT (1 << 1)

#define NIL_IMAGE_USAGE_SPARSE_RESIDENCY_BIT (1 << 2)

#define NIL_IMAGE_USAGE_VIDEO_BIT (1 << 3)

void nil_copy_linear_to_tiled(void *tiled_dst,
                              struct nil_Extent4D_Bytes level_extent_B,
                              const void *linear_src,
                              size_t linear_row_stride_B,
                              size_t linear_plane_stride_B,
                              struct nil_Offset4D_Bytes offset_B,
                              struct nil_Extent4D_Bytes extent_B,
                              const struct nil_tiling *tiling);

void nil_copy_tiled_to_linear(void *linear_dst,
                              size_t linear_row_stride_B,
                              size_t linear_plane_stride_B,
                              const void *tiled_src,
                              struct nil_Extent4D_Bytes level_extent_B,
                              struct nil_Offset4D_Bytes offset_B,
                              struct nil_Extent4D_Bytes extent_B,
                              const struct nil_tiling *tiling);

struct nil_descriptor nil_image_view_descriptor(const struct nv_device_info *dev,
                                                const struct nil_image *image,
                                                const struct nil_view *view,
                                                uint64_t base_address);

struct nil_descriptor nil_buffer_descriptor(const struct nv_device_info *dev,
                                            uint64_t base_address,
                                            struct nil_format format,
                                            uint32_t num_elements);

struct nil_descriptor nil_null_descriptor(const struct nv_device_info *dev,
                                          uint64_t zero_page_address);

struct nil_Extent4D_Elements nil_extent4d_px_to_el(struct nil_Extent4D_Pixels extent_px,
                                                   struct nil_format format,
                                                   nil_sample_layout sample_layout);

struct nil_Extent4D_Tiles nil_extent4d_px_to_tl(struct nil_Extent4D_Pixels extent_px,
                                                const struct nil_tiling *tiling,
                                                struct nil_format format,
                                                nil_sample_layout sample_layout);

struct nil_Extent4D_Bytes nil_extent4d_px_to_B(struct nil_Extent4D_Pixels extent_px,
                                               struct nil_format format,
                                               nil_sample_layout sample_layout);

struct nil_Offset4D_Elements nil_offset4d_px_to_el(struct nil_Offset4D_Pixels offset,
                                                   struct nil_format format,
                                                   nil_sample_layout sample_layout);

struct nil_Offset4D_Tiles nil_offset4d_px_to_tl(struct nil_Offset4D_Pixels offset,
                                                const struct nil_tiling *tiling,
                                                struct nil_format format,
                                                nil_sample_layout sample_layout);

struct nil_Offset4D_Bytes nil_offset4d_px_to_B(struct nil_Offset4D_Pixels offset,
                                               struct nil_format format,
                                               nil_sample_layout sample_layout);

bool nil_format_supports_texturing(const struct nv_device_info *dev, enum pipe_format p_format);

bool nil_format_supports_filtering(const struct nv_device_info *dev, enum pipe_format p_format);

bool nil_format_supports_buffer(const struct nv_device_info *_dev, enum pipe_format p_format);

bool nil_format_supports_storage(const struct nv_device_info *dev, enum pipe_format p_format);

bool nil_format_supports_color_targets(const struct nv_device_info *dev, enum pipe_format p_format);

bool nil_format_supports_blending(const struct nv_device_info *dev, enum pipe_format p_format);

bool nil_format_supports_depth_stencil(const struct nv_device_info *dev, enum pipe_format p_format);

uint32_t nil_format_to_color_target(enum pipe_format p_format);

uint32_t nil_format_to_depth_stencil(enum pipe_format p_format);

struct nil_format nil_format(enum pipe_format p_format);

nil_sample_layout nil_choose_sample_layout(uint32_t samples);

uint32_t nil_sample_layout_samples(nil_sample_layout self);

struct nil_Extent4D_Samples nil_px_extent_sa(nil_sample_layout self);

struct nil_sample_offset nil_sample_offset(nil_sample_layout self, uint8_t s);

bool nil_image_init(const struct nv_device_info *dev,
                    struct nil_image *image_out,
                    const struct nil_image_init_info *info);

bool nil_image_init_planar(const struct nv_device_info *dev,
                           struct nil_image *image_out,
                           const struct nil_image_init_info *info,
                           size_t plane,
                           size_t plane_count);

struct nil_Extent4D_Pixels nil_image_level_extent_px(const struct nil_image *self, uint32_t level);

uint64_t nil_image_level_layer_offset_B(const struct nil_image *self,
                                        uint32_t level,
                                        uint32_t layer);

uint64_t nil_image_mip_tail_offset_B(const struct nil_image *self);

uint32_t nil_image_mip_tail_size_B(const struct nil_image *self);

struct nil_Extent4D_Samples nil_image_level_extent_sa(const struct nil_image *self, uint32_t level);

uint64_t nil_image_level_layer_size_B(const struct nil_image *self, uint32_t level);

uint64_t nil_image_level_size_B(const struct nil_image *self, uint32_t level);

uint64_t nil_image_level_depth_stride_B(const struct nil_image *self, uint32_t level);

struct nil_image nil_image_for_level(const struct nil_image *self,
                                     uint32_t level,
                                     uint64_t *offset_in_bytes_out);

struct nil_image nil_image_level_as_uncompressed(const struct nil_image *self,
                                                 uint32_t level,
                                                 uint64_t *offset_in_bytes_out);

struct nil_image nil_image_3d_level_as_2d_array(const struct nil_image *self,
                                                uint32_t level,
                                                uint64_t *offset_in_bytes_out);

struct nil_image nil_msaa_image_as_sa(const struct nil_image *self);

uint64_t nil_image_level_z_offset_B(const struct nil_image *self, uint32_t level, uint32_t z);

void nil_drm_format_mods_for_format(const struct nv_device_info *dev,
                                    struct nil_format format,
                                    size_t *mod_count,
                                    uint64_t (*mods)[NIL_MAX_DRM_FORMAT_MODS]);

uint64_t nil_select_best_drm_format_mod(const struct nv_device_info *dev,
                                        struct nil_format format,
                                        size_t modifier_count,
                                        const uint64_t *modifiers);

struct nil_su_info nil_fill_su_info(const struct nv_device_info *dev,
                                    const struct nil_image *image,
                                    const struct nil_view *view,
                                    uint64_t base_address);

struct nil_su_info nil_buffer_fill_su_info(const struct nv_device_info *_dev,
                                           uint64_t base_address,
                                           struct nil_format format,
                                           uint32_t num_elements);

struct nil_su_info nil_fill_null_su_info(const struct nv_device_info *_dev);

uint32_t nil_gob_type_height(nil_gob_type self);

uint32_t nil_tiling_size_B(const struct nil_tiling *self);

struct nil_Extent4D_Pixels nil_sparse_block_extent_px(struct nil_format format,
                                                      nil_image_dim dim,
                                                      nil_sample_layout sample_layout);

#endif  /* NIL_H */
