/* Autogenerated file, do not edit */
/*
 * Copyright 2024 Collabora Ltd.
 * SPDX-License-Identifier: MIT
 */

#ifndef PAN_PACK_H
#define PAN_PACK_H

#include "genxml/pan_pack_helpers.h"


#define mali_pixel_format_print(fp, format) \
    fprintf(fp, "%*sFormat (v7): %s%s %s%s\n", indent, "", \
        mali_format_as_str((enum mali_format)((format >> 12) & 0xFF)), \
        (format & (1 << 20)) ? " sRGB" : "", \
        mali_rgb_component_order_as_str((enum mali_rgb_component_order)(format & ((1 << 12) - 1))), \
        (format & (1 << 21)) ? " XXX BAD BIT" : "");

enum mali_attribute_type {
        MALI_ATTRIBUTE_TYPE_1D               =      1,
        MALI_ATTRIBUTE_TYPE_1D_POT_DIVISOR   =      2,
        MALI_ATTRIBUTE_TYPE_1D_NPOT_DIVISOR  =      3,
        MALI_ATTRIBUTE_TYPE_1D_PRIMITIVE_INDEX_BUFFER =      5,
        MALI_ATTRIBUTE_TYPE_VERTEX_PACKET    =      6,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_attribute_type_as_str(enum mali_attribute_type imm)
{
    switch (imm) {
    case MALI_ATTRIBUTE_TYPE_1D: return "1D";
    case MALI_ATTRIBUTE_TYPE_1D_POT_DIVISOR: return "1D POT Divisor";
    case MALI_ATTRIBUTE_TYPE_1D_NPOT_DIVISOR: return "1D NPOT Divisor";
    case MALI_ATTRIBUTE_TYPE_1D_PRIMITIVE_INDEX_BUFFER: return "1D Primitive Index Buffer";
    case MALI_ATTRIBUTE_TYPE_VERTEX_PACKET: return "Vertex packet";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_channel {
        MALI_CHANNEL_R                       =      0,
        MALI_CHANNEL_G                       =      1,
        MALI_CHANNEL_B                       =      2,
        MALI_CHANNEL_A                       =      3,
        MALI_CHANNEL_0                       =      4,
        MALI_CHANNEL_1                       =      5,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_channel_as_str(enum mali_channel imm)
{
    switch (imm) {
    case MALI_CHANNEL_R: return "R";
    case MALI_CHANNEL_G: return "G";
    case MALI_CHANNEL_B: return "B";
    case MALI_CHANNEL_A: return "A";
    case MALI_CHANNEL_0: return "0";
    case MALI_CHANNEL_1: return "1";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_depth_source {
        MALI_DEPTH_SOURCE_MINIMUM            =      0,
        MALI_DEPTH_SOURCE_MAXIMUM            =      1,
        MALI_DEPTH_SOURCE_FIXED_FUNCTION     =      2,
        MALI_DEPTH_SOURCE_SHADER             =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_depth_source_as_str(enum mali_depth_source imm)
{
    switch (imm) {
    case MALI_DEPTH_SOURCE_MINIMUM: return "Minimum";
    case MALI_DEPTH_SOURCE_MAXIMUM: return "Maximum";
    case MALI_DEPTH_SOURCE_FIXED_FUNCTION: return "Fixed function";
    case MALI_DEPTH_SOURCE_SHADER: return "Shader";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_depth_clamp_mode {
        MALI_DEPTH_CLAMP_MODE_0_1            =      1,
        MALI_DEPTH_CLAMP_MODE_BOUNDS         =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_depth_clamp_mode_as_str(enum mali_depth_clamp_mode imm)
{
    switch (imm) {
    case MALI_DEPTH_CLAMP_MODE_0_1: return "[0, 1]";
    case MALI_DEPTH_CLAMP_MODE_BOUNDS: return "Bounds";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_shader_stage {
        MALI_SHADER_STAGE_COMPUTE            =      1,
        MALI_SHADER_STAGE_FRAGMENT           =      2,
        MALI_SHADER_STAGE_VERTEX             =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_shader_stage_as_str(enum mali_shader_stage imm)
{
    switch (imm) {
    case MALI_SHADER_STAGE_COMPUTE: return "Compute";
    case MALI_SHADER_STAGE_FRAGMENT: return "Fragment";
    case MALI_SHADER_STAGE_VERTEX: return "Vertex";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_descriptor_type {
        MALI_DESCRIPTOR_TYPE_NULL            =      0,
        MALI_DESCRIPTOR_TYPE_SAMPLER         =      1,
        MALI_DESCRIPTOR_TYPE_TEXTURE         =      2,
        MALI_DESCRIPTOR_TYPE_ATTRIBUTE       =      5,
        MALI_DESCRIPTOR_TYPE_DEPTH_STENCIL   =      7,
        MALI_DESCRIPTOR_TYPE_SHADER          =      8,
        MALI_DESCRIPTOR_TYPE_BUFFER          =      9,
        MALI_DESCRIPTOR_TYPE_PLANE           =     10,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_descriptor_type_as_str(enum mali_descriptor_type imm)
{
    switch (imm) {
    case MALI_DESCRIPTOR_TYPE_NULL: return "Null";
    case MALI_DESCRIPTOR_TYPE_SAMPLER: return "Sampler";
    case MALI_DESCRIPTOR_TYPE_TEXTURE: return "Texture";
    case MALI_DESCRIPTOR_TYPE_ATTRIBUTE: return "Attribute";
    case MALI_DESCRIPTOR_TYPE_DEPTH_STENCIL: return "Depth/stencil";
    case MALI_DESCRIPTOR_TYPE_SHADER: return "Shader";
    case MALI_DESCRIPTOR_TYPE_BUFFER: return "Buffer";
    case MALI_DESCRIPTOR_TYPE_PLANE: return "Plane";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_buffer_type {
        MALI_BUFFER_TYPE_SIMPLE              =      1,
        MALI_BUFFER_TYPE_TILER_HEAP          =      2,
        MALI_BUFFER_TYPE_STRUCTURE           =      3,
        MALI_BUFFER_TYPE_VERTEX_PACKET       =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_buffer_type_as_str(enum mali_buffer_type imm)
{
    switch (imm) {
    case MALI_BUFFER_TYPE_SIMPLE: return "Simple";
    case MALI_BUFFER_TYPE_TILER_HEAP: return "Tiler heap";
    case MALI_BUFFER_TYPE_STRUCTURE: return "Structure";
    case MALI_BUFFER_TYPE_VERTEX_PACKET: return "Vertex packet";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_draw_mode {
        MALI_DRAW_MODE_NONE                  =      0,
        MALI_DRAW_MODE_POINTS                =      1,
        MALI_DRAW_MODE_LINES                 =      2,
        MALI_DRAW_MODE_LINE_STRIP            =      4,
        MALI_DRAW_MODE_LINE_LOOP             =      6,
        MALI_DRAW_MODE_TRIANGLES             =      8,
        MALI_DRAW_MODE_TRIANGLE_STRIP        =     10,
        MALI_DRAW_MODE_TRIANGLE_FAN          =     12,
        MALI_DRAW_MODE_POLYGON               =     13,
        MALI_DRAW_MODE_QUADS                 =     14,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_draw_mode_as_str(enum mali_draw_mode imm)
{
    switch (imm) {
    case MALI_DRAW_MODE_NONE: return "None";
    case MALI_DRAW_MODE_POINTS: return "Points";
    case MALI_DRAW_MODE_LINES: return "Lines";
    case MALI_DRAW_MODE_LINE_STRIP: return "Line strip";
    case MALI_DRAW_MODE_LINE_LOOP: return "Line loop";
    case MALI_DRAW_MODE_TRIANGLES: return "Triangles";
    case MALI_DRAW_MODE_TRIANGLE_STRIP: return "Triangle strip";
    case MALI_DRAW_MODE_TRIANGLE_FAN: return "Triangle fan";
    case MALI_DRAW_MODE_POLYGON: return "Polygon";
    case MALI_DRAW_MODE_QUADS: return "Quads";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_func {
        MALI_FUNC_NEVER                      =      0,
        MALI_FUNC_LESS                       =      1,
        MALI_FUNC_EQUAL                      =      2,
        MALI_FUNC_LEQUAL                     =      3,
        MALI_FUNC_GREATER                    =      4,
        MALI_FUNC_NOT_EQUAL                  =      5,
        MALI_FUNC_GEQUAL                     =      6,
        MALI_FUNC_ALWAYS                     =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_func_as_str(enum mali_func imm)
{
    switch (imm) {
    case MALI_FUNC_NEVER: return "Never";
    case MALI_FUNC_LESS: return "Less";
    case MALI_FUNC_EQUAL: return "Equal";
    case MALI_FUNC_LEQUAL: return "Lequal";
    case MALI_FUNC_GREATER: return "Greater";
    case MALI_FUNC_NOT_EQUAL: return "Not Equal";
    case MALI_FUNC_GEQUAL: return "Gequal";
    case MALI_FUNC_ALWAYS: return "Always";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_address_mode {
        MALI_ADDRESS_MODE_FLAT               =      0,
        MALI_ADDRESS_MODE_PACKED             =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_address_mode_as_str(enum mali_address_mode imm)
{
    switch (imm) {
    case MALI_ADDRESS_MODE_FLAT: return "Flat";
    case MALI_ADDRESS_MODE_PACKED: return "Packed";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_format {
        MALI_ETC2_RGB8                       =      1,
        MALI_ETC2_R11_UNORM                  =      2,
        MALI_ETC2_RGBA8                      =      3,
        MALI_ETC2_RG11_UNORM                 =      4,
        MALI_BC1_UNORM                       =      7,
        MALI_BC2_UNORM                       =      8,
        MALI_BC3_UNORM                       =      9,
        MALI_BC4_UNORM                       =     10,
        MALI_BC4_SNORM                       =     11,
        MALI_BC5_UNORM                       =     12,
        MALI_BC5_SNORM                       =     13,
        MALI_BC6H_UF16                       =     14,
        MALI_BC6H_SF16                       =     15,
        MALI_BC7_UNORM                       =     16,
        MALI_ETC2_R11_SNORM                  =     17,
        MALI_ETC2_RG11_SNORM                 =     18,
        MALI_ETC2_RGB8A1                     =     19,
        MALI_ASTC_3D_LDR                     =     20,
        MALI_ASTC_3D_HDR                     =     21,
        MALI_ASTC_2D_LDR                     =     22,
        MALI_ASTC_2D_HDR                     =     23,
        MALI_AFBC                            =     24,
        MALI_AFRC                            =     25,
        MALI_ASTC_2D_NARROW                  =     30,
        MALI_ASTC_3D_NARROW                  =     31,
        MALI_YUV8                            =     32,
        MALI_YUVA8                           =     33,
        MALI_YUYV8                           =     34,
        MALI_VYUY8                           =     35,
        MALI_Y8_UV8_422                      =     36,
        MALI_Y8_U8_V8_422                    =     37,
        MALI_Y8_UV8_420                      =     38,
        MALI_Y8_U8_V8_420                    =     39,
        MALI_YUV10_A2                        =     40,
        MALI_A2_YUV10                        =     41,
        MALI_YUYAAYVYAA                      =     42,
        MALI_YUYV10                          =     44,
        MALI_VYUY10                          =     45,
        MALI_Y10_UV10_422                    =     46,
        MALI_Y10_UV10_420                    =     47,
        MALI_YUV16                           =     48,
        MALI_YUVA16                          =     49,
        MALI_YUYV16                          =     50,
        MALI_VYUY16                          =     51,
        MALI_Y10X6_U10X6V10X6_422            =     52,
        MALI_Y16_UV16_422                    =     53,
        MALI_Y16_UV16_420                    =     55,
        MALI_RGB565                          =     64,
        MALI_RGB5_A1_UNORM                   =     65,
        MALI_A1_BGR5_UNORM                   =     66,
        MALI_RGB10_A2_UNORM                  =     67,
        MALI_A2_BGR10_UNORM                  =     68,
        MALI_RGB10_A2_SNORM                  =     69,
        MALI_A2_BGR10_SNORM                  =     70,
        MALI_RGB10_A2UI                      =     71,
        MALI_A2_BGR10UI                      =     72,
        MALI_RGB10_A2I                       =     73,
        MALI_A2_BGR10I                       =     74,
        MALI_Z16_UNORM                       =     75,
        MALI_Z32                             =     76,
        MALI_Z24X8_UNORM                     =     77,
        MALI_X8Z24                           =     78,
        MALI_R32_FIXED                       =     81,
        MALI_RG32_FIXED                      =     82,
        MALI_RGB32_FIXED                     =     83,
        MALI_RGBA32_FIXED                    =     84,
        MALI_R11F_G11F_B10F                  =     89,
        MALI_B10F_G11F_R11F                  =     90,
        MALI_R9F_G9F_B9F_E5F                 =     91,
        MALI_E5F_B9F_G9F_R9F                 =     92,
        MALI_S8                              =     93,
        MALI_SNAP_4                          =     94,
        MALI_CONSTANT                        =     95,
        MALI_R8_SNORM                        =     99,
        MALI_R16_SNORM                       =    100,
        MALI_R32_SNORM                       =    101,
        MALI_RG4_SNORM                       =    106,
        MALI_RG8_SNORM                       =    107,
        MALI_RG16_SNORM                      =    108,
        MALI_RG32_SNORM                      =    109,
        MALI_RGB8_SNORM                      =    115,
        MALI_RGB16_SNORM                     =    116,
        MALI_RGB32_SNORM                     =    117,
        MALI_RGBA2_SNORM                     =    121,
        MALI_RGBA4_SNORM                     =    122,
        MALI_RGBA8_SNORM                     =    123,
        MALI_RGBA16_SNORM                    =    124,
        MALI_RGBA32_SNORM                    =    125,
        MALI_R8UI                            =    131,
        MALI_R16UI                           =    132,
        MALI_R32UI                           =    133,
        MALI_RG4UI                           =    138,
        MALI_RG8UI                           =    139,
        MALI_RG16UI                          =    140,
        MALI_RG32UI                          =    141,
        MALI_RGB8UI                          =    147,
        MALI_RGB16UI                         =    148,
        MALI_RGB32UI                         =    149,
        MALI_RGBA2UI                         =    153,
        MALI_RGBA4UI                         =    154,
        MALI_RGBA8UI                         =    155,
        MALI_RGBA16UI                        =    156,
        MALI_RGBA32UI                        =    157,
        MALI_R8_UNORM                        =    163,
        MALI_R16_UNORM                       =    164,
        MALI_R32_UNORM                       =    165,
        MALI_R32F                            =    167,
        MALI_RG4_UNORM                       =    170,
        MALI_RG8_UNORM                       =    171,
        MALI_RG16_UNORM                      =    172,
        MALI_RG32_UNORM                      =    173,
        MALI_RG32F                           =    175,
        MALI_RGB8_UNORM                      =    179,
        MALI_RGB16_UNORM                     =    180,
        MALI_RGB32_UNORM                     =    181,
        MALI_RGB32F                          =    183,
        MALI_RGBA2_UNORM                     =    185,
        MALI_RGBA4_UNORM                     =    186,
        MALI_RGBA8_UNORM                     =    187,
        MALI_RGBA16_UNORM                    =    188,
        MALI_RGBA32_UNORM                    =    189,
        MALI_RGBA32F                         =    191,
        MALI_R8I                             =    195,
        MALI_R16I                            =    196,
        MALI_R32I                            =    197,
        MALI_R16F                            =    199,
        MALI_RG4I                            =    202,
        MALI_RG8I                            =    203,
        MALI_RG16I                           =    204,
        MALI_RG32I                           =    205,
        MALI_RG16F                           =    207,
        MALI_RGB8I                           =    211,
        MALI_RGB16I                          =    212,
        MALI_RGB32I                          =    213,
        MALI_RGB16F                          =    215,
        MALI_RGBA2I                          =    217,
        MALI_RGBA4I                          =    218,
        MALI_RGBA8I                          =    219,
        MALI_RGBA16I                         =    220,
        MALI_RGBA32I                         =    221,
        MALI_RGBA16F                         =    223,
        MALI_RGB5_A1_AU                      =    224,
        MALI_RGB5_A1_PU                      =    225,
        MALI_R5G6B5_AU                       =    226,
        MALI_R5G6B5_PU                       =    227,
        MALI_SNAP4_V                         =    230,
        MALI_R32F_RTZ                        =    231,
        MALI_RGBA4_AU                        =    232,
        MALI_RGBA4_PU                        =    233,
        MALI_RGBA8_TB                        =    237,
        MALI_RGB10_A2_TB                     =    238,
        MALI_RG32F_RTZ                       =    239,
        MALI_TESS_VERTEX_PACK                =    240,
        MALI_RGB8_A2_AU                      =    241,
        MALI_RGB8_A2_PU                      =    242,
        MALI_RGB32F_RTZ                      =    247,
        MALI_RGBA32F_RTZ                     =    255,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_format_as_str(enum mali_format imm)
{
    switch (imm) {
    case MALI_ETC2_RGB8: return "ETC2 RGB8";
    case MALI_ETC2_R11_UNORM: return "ETC2 R11 UNORM";
    case MALI_ETC2_RGBA8: return "ETC2 RGBA8";
    case MALI_ETC2_RG11_UNORM: return "ETC2 RG11 UNORM";
    case MALI_BC1_UNORM: return "BC1 UNORM";
    case MALI_BC2_UNORM: return "BC2 UNORM";
    case MALI_BC3_UNORM: return "BC3 UNORM";
    case MALI_BC4_UNORM: return "BC4 UNORM";
    case MALI_BC4_SNORM: return "BC4 SNORM";
    case MALI_BC5_UNORM: return "BC5 UNORM";
    case MALI_BC5_SNORM: return "BC5 SNORM";
    case MALI_BC6H_UF16: return "BC6H UF16";
    case MALI_BC6H_SF16: return "BC6H SF16";
    case MALI_BC7_UNORM: return "BC7 UNORM";
    case MALI_ETC2_R11_SNORM: return "ETC2 R11 SNORM";
    case MALI_ETC2_RG11_SNORM: return "ETC2 RG11 SNORM";
    case MALI_ETC2_RGB8A1: return "ETC2 RGB8A1";
    case MALI_ASTC_3D_LDR: return "ASTC 3D LDR";
    case MALI_ASTC_3D_HDR: return "ASTC 3D HDR";
    case MALI_ASTC_2D_LDR: return "ASTC 2D LDR";
    case MALI_ASTC_2D_HDR: return "ASTC 2D HDR";
    case MALI_AFBC: return "AFBC";
    case MALI_AFRC: return "AFRC";
    case MALI_ASTC_2D_NARROW: return "ASTC 2D NARROW";
    case MALI_ASTC_3D_NARROW: return "ASTC 3D NARROW";
    case MALI_YUV8: return "YUV8";
    case MALI_YUVA8: return "YUVA8";
    case MALI_YUYV8: return "YUYV8";
    case MALI_VYUY8: return "VYUY8";
    case MALI_Y8_UV8_422: return "Y8 UV8 422";
    case MALI_Y8_U8_V8_422: return "Y8 U8 V8 422";
    case MALI_Y8_UV8_420: return "Y8 UV8 420";
    case MALI_Y8_U8_V8_420: return "Y8 U8 V8 420";
    case MALI_YUV10_A2: return "YUV10 A2";
    case MALI_A2_YUV10: return "A2 YUV10";
    case MALI_YUYAAYVYAA: return "YUYAAYVYAA";
    case MALI_YUYV10: return "YUYV10";
    case MALI_VYUY10: return "VYUY10";
    case MALI_Y10_UV10_422: return "Y10 UV10 422";
    case MALI_Y10_UV10_420: return "Y10 UV10 420";
    case MALI_YUV16: return "YUV16";
    case MALI_YUVA16: return "YUVA16";
    case MALI_YUYV16: return "YUYV16";
    case MALI_VYUY16: return "VYUY16";
    case MALI_Y10X6_U10X6V10X6_422: return "Y10X6 U10X6V10X6 422";
    case MALI_Y16_UV16_422: return "Y16 UV16 422";
    case MALI_Y16_UV16_420: return "Y16 UV16 420";
    case MALI_RGB565: return "RGB565";
    case MALI_RGB5_A1_UNORM: return "RGB5 A1 UNORM";
    case MALI_A1_BGR5_UNORM: return "A1 BGR5 UNORM";
    case MALI_RGB10_A2_UNORM: return "RGB10 A2 UNORM";
    case MALI_A2_BGR10_UNORM: return "A2 BGR10 UNORM";
    case MALI_RGB10_A2_SNORM: return "RGB10 A2 SNORM";
    case MALI_A2_BGR10_SNORM: return "A2 BGR10 SNORM";
    case MALI_RGB10_A2UI: return "RGB10 A2UI";
    case MALI_A2_BGR10UI: return "A2 BGR10UI";
    case MALI_RGB10_A2I: return "RGB10 A2I";
    case MALI_A2_BGR10I: return "A2 BGR10I";
    case MALI_Z16_UNORM: return "Z16 UNORM";
    case MALI_Z32: return "Z32";
    case MALI_Z24X8_UNORM: return "Z24X8 UNORM";
    case MALI_X8Z24: return "X8Z24";
    case MALI_R32_FIXED: return "R32 FIXED";
    case MALI_RG32_FIXED: return "RG32 FIXED";
    case MALI_RGB32_FIXED: return "RGB32 FIXED";
    case MALI_RGBA32_FIXED: return "RGBA32 FIXED";
    case MALI_R11F_G11F_B10F: return "R11F G11F B10F";
    case MALI_B10F_G11F_R11F: return "B10F G11F R11F";
    case MALI_R9F_G9F_B9F_E5F: return "R9F G9F B9F E5F";
    case MALI_E5F_B9F_G9F_R9F: return "E5F B9F G9F R9F";
    case MALI_S8: return "S8";
    case MALI_SNAP_4: return "Snap 4";
    case MALI_CONSTANT: return "Constant";
    case MALI_R8_SNORM: return "R8 SNORM";
    case MALI_R16_SNORM: return "R16 SNORM";
    case MALI_R32_SNORM: return "R32 SNORM";
    case MALI_RG4_SNORM: return "RG4 SNORM";
    case MALI_RG8_SNORM: return "RG8 SNORM";
    case MALI_RG16_SNORM: return "RG16 SNORM";
    case MALI_RG32_SNORM: return "RG32 SNORM";
    case MALI_RGB8_SNORM: return "RGB8 SNORM";
    case MALI_RGB16_SNORM: return "RGB16 SNORM";
    case MALI_RGB32_SNORM: return "RGB32 SNORM";
    case MALI_RGBA2_SNORM: return "RGBA2 SNORM";
    case MALI_RGBA4_SNORM: return "RGBA4 SNORM";
    case MALI_RGBA8_SNORM: return "RGBA8 SNORM";
    case MALI_RGBA16_SNORM: return "RGBA16 SNORM";
    case MALI_RGBA32_SNORM: return "RGBA32 SNORM";
    case MALI_R8UI: return "R8UI";
    case MALI_R16UI: return "R16UI";
    case MALI_R32UI: return "R32UI";
    case MALI_RG4UI: return "RG4UI";
    case MALI_RG8UI: return "RG8UI";
    case MALI_RG16UI: return "RG16UI";
    case MALI_RG32UI: return "RG32UI";
    case MALI_RGB8UI: return "RGB8UI";
    case MALI_RGB16UI: return "RGB16UI";
    case MALI_RGB32UI: return "RGB32UI";
    case MALI_RGBA2UI: return "RGBA2UI";
    case MALI_RGBA4UI: return "RGBA4UI";
    case MALI_RGBA8UI: return "RGBA8UI";
    case MALI_RGBA16UI: return "RGBA16UI";
    case MALI_RGBA32UI: return "RGBA32UI";
    case MALI_R8_UNORM: return "R8 UNORM";
    case MALI_R16_UNORM: return "R16 UNORM";
    case MALI_R32_UNORM: return "R32 UNORM";
    case MALI_R32F: return "R32F";
    case MALI_RG4_UNORM: return "RG4 UNORM";
    case MALI_RG8_UNORM: return "RG8 UNORM";
    case MALI_RG16_UNORM: return "RG16 UNORM";
    case MALI_RG32_UNORM: return "RG32 UNORM";
    case MALI_RG32F: return "RG32F";
    case MALI_RGB8_UNORM: return "RGB8 UNORM";
    case MALI_RGB16_UNORM: return "RGB16 UNORM";
    case MALI_RGB32_UNORM: return "RGB32 UNORM";
    case MALI_RGB32F: return "RGB32F";
    case MALI_RGBA2_UNORM: return "RGBA2 UNORM";
    case MALI_RGBA4_UNORM: return "RGBA4 UNORM";
    case MALI_RGBA8_UNORM: return "RGBA8 UNORM";
    case MALI_RGBA16_UNORM: return "RGBA16 UNORM";
    case MALI_RGBA32_UNORM: return "RGBA32 UNORM";
    case MALI_RGBA32F: return "RGBA32F";
    case MALI_R8I: return "R8I";
    case MALI_R16I: return "R16I";
    case MALI_R32I: return "R32I";
    case MALI_R16F: return "R16F";
    case MALI_RG4I: return "RG4I";
    case MALI_RG8I: return "RG8I";
    case MALI_RG16I: return "RG16I";
    case MALI_RG32I: return "RG32I";
    case MALI_RG16F: return "RG16F";
    case MALI_RGB8I: return "RGB8I";
    case MALI_RGB16I: return "RGB16I";
    case MALI_RGB32I: return "RGB32I";
    case MALI_RGB16F: return "RGB16F";
    case MALI_RGBA2I: return "RGBA2I";
    case MALI_RGBA4I: return "RGBA4I";
    case MALI_RGBA8I: return "RGBA8I";
    case MALI_RGBA16I: return "RGBA16I";
    case MALI_RGBA32I: return "RGBA32I";
    case MALI_RGBA16F: return "RGBA16F";
    case MALI_RGB5_A1_AU: return "RGB5 A1 AU";
    case MALI_RGB5_A1_PU: return "RGB5 A1 PU";
    case MALI_R5G6B5_AU: return "R5G6B5 AU";
    case MALI_R5G6B5_PU: return "R5G6B5 PU";
    case MALI_SNAP4_V: return "Snap4 V";
    case MALI_R32F_RTZ: return "R32F RTZ";
    case MALI_RGBA4_AU: return "RGBA4 AU";
    case MALI_RGBA4_PU: return "RGBA4 PU";
    case MALI_RGBA8_TB: return "RGBA8 TB";
    case MALI_RGB10_A2_TB: return "RGB10 A2 TB";
    case MALI_RG32F_RTZ: return "RG32F RTZ";
    case MALI_TESS_VERTEX_PACK: return "Tess Vertex Pack";
    case MALI_RGB8_A2_AU: return "RGB8 A2 AU";
    case MALI_RGB8_A2_PU: return "RGB8 A2 PU";
    case MALI_RGB32F_RTZ: return "RGB32F RTZ";
    case MALI_RGBA32F_RTZ: return "RGBA32F RTZ";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_rgb_component_order {
        MALI_RGB_COMPONENT_ORDER_RGBA        =      0,
        MALI_RGB_COMPONENT_ORDER_GRBA        =      2,
        MALI_RGB_COMPONENT_ORDER_BGRA        =      4,
        MALI_RGB_COMPONENT_ORDER_ARGB        =      8,
        MALI_RGB_COMPONENT_ORDER_AGRB        =     10,
        MALI_RGB_COMPONENT_ORDER_ABGR        =     12,
        MALI_RGB_COMPONENT_ORDER_RGB1        =     16,
        MALI_RGB_COMPONENT_ORDER_GRB1        =     18,
        MALI_RGB_COMPONENT_ORDER_BGR1        =     20,
        MALI_RGB_COMPONENT_ORDER_1RGB        =     24,
        MALI_RGB_COMPONENT_ORDER_1GRB        =     26,
        MALI_RGB_COMPONENT_ORDER_1BGR        =     28,
        MALI_RGB_COMPONENT_ORDER_RRRR        =    226,
        MALI_RGB_COMPONENT_ORDER_RRR1        =    227,
        MALI_RGB_COMPONENT_ORDER_RRRA        =    228,
        MALI_RGB_COMPONENT_ORDER_000A        =    229,
        MALI_RGB_COMPONENT_ORDER_0001        =    230,
        MALI_RGB_COMPONENT_ORDER_0000        =    231,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V9    =    232,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V10   =    233,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V11   =    234,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V12   =    235,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V13   =    236,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V14   =    237,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V15   =    238,
        MALI_RGB_COMPONENT_ORDER_SNAP4_V16   =    239,
        MALI_RGB_COMPONENT_ORDER_R000        =    240,
        MALI_RGB_COMPONENT_ORDER_RBGA        =    242,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_rgb_component_order_as_str(enum mali_rgb_component_order imm)
{
    switch (imm) {
    case MALI_RGB_COMPONENT_ORDER_RGBA: return "RGBA";
    case MALI_RGB_COMPONENT_ORDER_GRBA: return "GRBA";
    case MALI_RGB_COMPONENT_ORDER_BGRA: return "BGRA";
    case MALI_RGB_COMPONENT_ORDER_ARGB: return "ARGB";
    case MALI_RGB_COMPONENT_ORDER_AGRB: return "AGRB";
    case MALI_RGB_COMPONENT_ORDER_ABGR: return "ABGR";
    case MALI_RGB_COMPONENT_ORDER_RGB1: return "RGB1";
    case MALI_RGB_COMPONENT_ORDER_GRB1: return "GRB1";
    case MALI_RGB_COMPONENT_ORDER_BGR1: return "BGR1";
    case MALI_RGB_COMPONENT_ORDER_1RGB: return "1RGB";
    case MALI_RGB_COMPONENT_ORDER_1GRB: return "1GRB";
    case MALI_RGB_COMPONENT_ORDER_1BGR: return "1BGR";
    case MALI_RGB_COMPONENT_ORDER_RRRR: return "RRRR";
    case MALI_RGB_COMPONENT_ORDER_RRR1: return "RRR1";
    case MALI_RGB_COMPONENT_ORDER_RRRA: return "RRRA";
    case MALI_RGB_COMPONENT_ORDER_000A: return "000A";
    case MALI_RGB_COMPONENT_ORDER_0001: return "0001";
    case MALI_RGB_COMPONENT_ORDER_0000: return "0000";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V9: return "Snap4 v9";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V10: return "Snap4 v10";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V11: return "Snap4 v11";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V12: return "Snap4 v12";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V13: return "Snap4 v13";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V14: return "Snap4 v14";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V15: return "Snap4 v15";
    case MALI_RGB_COMPONENT_ORDER_SNAP4_V16: return "Snap4 v16";
    case MALI_RGB_COMPONENT_ORDER_R000: return "R000";
    case MALI_RGB_COMPONENT_ORDER_RBGA: return "RBGA";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_swizzle {
        MALI_YUV_SWIZZLE_YUVA                =      0,
        MALI_YUV_SWIZZLE_YVUA                =      1,
        MALI_YUV_SWIZZLE_UYVA                =      2,
        MALI_YUV_SWIZZLE_UVYA                =      3,
        MALI_YUV_SWIZZLE_VUYA                =      4,
        MALI_YUV_SWIZZLE_VYUA                =      5,
        MALI_YUV_SWIZZLE_Y00A                =      6,
        MALI_YUV_SWIZZLE_YXXA                =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_swizzle_as_str(enum mali_yuv_swizzle imm)
{
    switch (imm) {
    case MALI_YUV_SWIZZLE_YUVA: return "YUVA";
    case MALI_YUV_SWIZZLE_YVUA: return "YVUA";
    case MALI_YUV_SWIZZLE_UYVA: return "UYVA";
    case MALI_YUV_SWIZZLE_UVYA: return "UVYA";
    case MALI_YUV_SWIZZLE_VUYA: return "VUYA";
    case MALI_YUV_SWIZZLE_VYUA: return "VYUA";
    case MALI_YUV_SWIZZLE_Y00A: return "Y00A";
    case MALI_YUV_SWIZZLE_YXXA: return "YXXA";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_conversion_mode {
        MALI_YUV_CONVERSION_MODE_NO_CONVERSION =      0,
        MALI_YUV_CONVERSION_MODE_BT_601      =      3,
        MALI_YUV_CONVERSION_MODE_BT_709      =      4,
        MALI_YUV_CONVERSION_MODE_BT_2020     =      6,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_conversion_mode_as_str(enum mali_yuv_conversion_mode imm)
{
    switch (imm) {
    case MALI_YUV_CONVERSION_MODE_NO_CONVERSION: return "No Conversion";
    case MALI_YUV_CONVERSION_MODE_BT_601: return "BT 601";
    case MALI_YUV_CONVERSION_MODE_BT_709: return "BT 709";
    case MALI_YUV_CONVERSION_MODE_BT_2020: return "BT 2020";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_cr_siting {
        MALI_YUV_CR_SITING_CO_SITED          =      0,
        MALI_YUV_CR_SITING_CENTER_Y          =      1,
        MALI_YUV_CR_SITING_CENTER_X          =      2,
        MALI_YUV_CR_SITING_CENTER            =      3,
        MALI_YUV_CR_SITING_ONE_QUARTER       =      4,
        MALI_YUV_CR_SITING_THREE_QUARTERS    =      5,
        MALI_YUV_CR_SITING_REPLICATED        =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_cr_siting_as_str(enum mali_yuv_cr_siting imm)
{
    switch (imm) {
    case MALI_YUV_CR_SITING_CO_SITED: return "Co-Sited";
    case MALI_YUV_CR_SITING_CENTER_Y: return "Center Y";
    case MALI_YUV_CR_SITING_CENTER_X: return "Center X";
    case MALI_YUV_CR_SITING_CENTER: return "Center";
    case MALI_YUV_CR_SITING_ONE_QUARTER: return "One Quarter";
    case MALI_YUV_CR_SITING_THREE_QUARTERS: return "Three Quarters";
    case MALI_YUV_CR_SITING_REPLICATED: return "Replicated";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_astc_2d_dimension {
        MALI_ASTC_2D_DIMENSION_4             =      0,
        MALI_ASTC_2D_DIMENSION_5             =      1,
        MALI_ASTC_2D_DIMENSION_6             =      2,
        MALI_ASTC_2D_DIMENSION_8             =      4,
        MALI_ASTC_2D_DIMENSION_10            =      6,
        MALI_ASTC_2D_DIMENSION_12            =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_astc_2d_dimension_as_str(enum mali_astc_2d_dimension imm)
{
    switch (imm) {
    case MALI_ASTC_2D_DIMENSION_4: return "4";
    case MALI_ASTC_2D_DIMENSION_5: return "5";
    case MALI_ASTC_2D_DIMENSION_6: return "6";
    case MALI_ASTC_2D_DIMENSION_8: return "8";
    case MALI_ASTC_2D_DIMENSION_10: return "10";
    case MALI_ASTC_2D_DIMENSION_12: return "12";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_astc_3d_dimension {
        MALI_ASTC_3D_DIMENSION_4             =      0,
        MALI_ASTC_3D_DIMENSION_5             =      1,
        MALI_ASTC_3D_DIMENSION_6             =      2,
        MALI_ASTC_3D_DIMENSION_3             =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_astc_3d_dimension_as_str(enum mali_astc_3d_dimension imm)
{
    switch (imm) {
    case MALI_ASTC_3D_DIMENSION_4: return "4";
    case MALI_ASTC_3D_DIMENSION_5: return "5";
    case MALI_ASTC_3D_DIMENSION_6: return "6";
    case MALI_ASTC_3D_DIMENSION_3: return "3";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_pixel_kill {
        MALI_PIXEL_KILL_FORCE_EARLY          =      0,
        MALI_PIXEL_KILL_STRONG_EARLY         =      1,
        MALI_PIXEL_KILL_WEAK_EARLY           =      2,
        MALI_PIXEL_KILL_FORCE_LATE           =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_pixel_kill_as_str(enum mali_pixel_kill imm)
{
    switch (imm) {
    case MALI_PIXEL_KILL_FORCE_EARLY: return "Force Early";
    case MALI_PIXEL_KILL_STRONG_EARLY: return "Strong Early";
    case MALI_PIXEL_KILL_WEAK_EARLY: return "Weak Early";
    case MALI_PIXEL_KILL_FORCE_LATE: return "Force Late";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_block_format {
        MALI_BLOCK_FORMAT_NO_WRITE           =      0,
        MALI_BLOCK_FORMAT_TILED_U_INTERLEAVED =      1,
        MALI_BLOCK_FORMAT_LINEAR             =      2,
        MALI_BLOCK_FORMAT_AFBC               =     12,
        MALI_BLOCK_FORMAT_AFBC_TILED         =     13,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_block_format_as_str(enum mali_block_format imm)
{
    switch (imm) {
    case MALI_BLOCK_FORMAT_NO_WRITE: return "No Write";
    case MALI_BLOCK_FORMAT_TILED_U_INTERLEAVED: return "Tiled U-Interleaved";
    case MALI_BLOCK_FORMAT_LINEAR: return "Linear";
    case MALI_BLOCK_FORMAT_AFBC: return "AFBC";
    case MALI_BLOCK_FORMAT_AFBC_TILED: return "AFBC Tiled";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_writeback_mode {
        MALI_WRITEBACK_MODE_COMPAT           =      0,
        MALI_WRITEBACK_MODE_AFRC_RGB         =      6,
        MALI_WRITEBACK_MODE_AFRC_YUV         =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_writeback_mode_as_str(enum mali_writeback_mode imm)
{
    switch (imm) {
    case MALI_WRITEBACK_MODE_COMPAT: return "Compat";
    case MALI_WRITEBACK_MODE_AFRC_RGB: return "AFRC RGB";
    case MALI_WRITEBACK_MODE_AFRC_YUV: return "AFRC YUV";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_mipmap_mode {
        MALI_MIPMAP_MODE_NEAREST             =      0,
        MALI_MIPMAP_MODE_NONE                =      1,
        MALI_MIPMAP_MODE_TRILINEAR           =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_mipmap_mode_as_str(enum mali_mipmap_mode imm)
{
    switch (imm) {
    case MALI_MIPMAP_MODE_NEAREST: return "Nearest";
    case MALI_MIPMAP_MODE_NONE: return "None";
    case MALI_MIPMAP_MODE_TRILINEAR: return "Trilinear";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_lod_algorithm {
        MALI_LOD_ALGORITHM_ISOTROPIC         =      0,
        MALI_LOD_ALGORITHM_ANISOTROPIC       =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_lod_algorithm_as_str(enum mali_lod_algorithm imm)
{
    switch (imm) {
    case MALI_LOD_ALGORITHM_ISOTROPIC: return "Isotropic";
    case MALI_LOD_ALGORITHM_ANISOTROPIC: return "Anisotropic";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_msaa {
        MALI_MSAA_SINGLE                     =      0,
        MALI_MSAA_AVERAGE                    =      1,
        MALI_MSAA_LAYERED                    =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_msaa_as_str(enum mali_msaa imm)
{
    switch (imm) {
    case MALI_MSAA_SINGLE: return "Single";
    case MALI_MSAA_AVERAGE: return "Average";
    case MALI_MSAA_LAYERED: return "Layered";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_index_type {
        MALI_INDEX_TYPE_NONE                 =      0,
        MALI_INDEX_TYPE_UINT8                =      1,
        MALI_INDEX_TYPE_UINT16               =      2,
        MALI_INDEX_TYPE_UINT32               =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_index_type_as_str(enum mali_index_type imm)
{
    switch (imm) {
    case MALI_INDEX_TYPE_NONE: return "None";
    case MALI_INDEX_TYPE_UINT8: return "UINT8";
    case MALI_INDEX_TYPE_UINT16: return "UINT16";
    case MALI_INDEX_TYPE_UINT32: return "UINT32";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_occlusion_mode {
        MALI_OCCLUSION_MODE_DISABLED         =      0,
        MALI_OCCLUSION_MODE_PREDICATE        =      1,
        MALI_OCCLUSION_MODE_COUNTER          =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_occlusion_mode_as_str(enum mali_occlusion_mode imm)
{
    switch (imm) {
    case MALI_OCCLUSION_MODE_DISABLED: return "Disabled";
    case MALI_OCCLUSION_MODE_PREDICATE: return "Predicate";
    case MALI_OCCLUSION_MODE_COUNTER: return "Counter";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_stencil_op {
        MALI_STENCIL_OP_KEEP                 =      0,
        MALI_STENCIL_OP_REPLACE              =      1,
        MALI_STENCIL_OP_ZERO                 =      2,
        MALI_STENCIL_OP_INVERT               =      3,
        MALI_STENCIL_OP_INCR_WRAP            =      4,
        MALI_STENCIL_OP_DECR_WRAP            =      5,
        MALI_STENCIL_OP_INCR_SAT             =      6,
        MALI_STENCIL_OP_DECR_SAT             =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_stencil_op_as_str(enum mali_stencil_op imm)
{
    switch (imm) {
    case MALI_STENCIL_OP_KEEP: return "Keep";
    case MALI_STENCIL_OP_REPLACE: return "Replace";
    case MALI_STENCIL_OP_ZERO: return "Zero";
    case MALI_STENCIL_OP_INVERT: return "Invert";
    case MALI_STENCIL_OP_INCR_WRAP: return "Incr Wrap";
    case MALI_STENCIL_OP_DECR_WRAP: return "Decr Wrap";
    case MALI_STENCIL_OP_INCR_SAT: return "Incr Sat";
    case MALI_STENCIL_OP_DECR_SAT: return "Decr Sat";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_texture_dimension {
        MALI_TEXTURE_DIMENSION_CUBE          =      0,
        MALI_TEXTURE_DIMENSION_1D            =      1,
        MALI_TEXTURE_DIMENSION_2D            =      2,
        MALI_TEXTURE_DIMENSION_3D            =      3,
        MALI_TEXTURE_DIMENSION_2D_IMAGE_CROP =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_texture_dimension_as_str(enum mali_texture_dimension imm)
{
    switch (imm) {
    case MALI_TEXTURE_DIMENSION_CUBE: return "Cube";
    case MALI_TEXTURE_DIMENSION_1D: return "1D";
    case MALI_TEXTURE_DIMENSION_2D: return "2D";
    case MALI_TEXTURE_DIMENSION_3D: return "3D";
    case MALI_TEXTURE_DIMENSION_2D_IMAGE_CROP: return "2D Image Crop";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_wrap_mode {
        MALI_WRAP_MODE_REPEAT                =      8,
        MALI_WRAP_MODE_CLAMP_TO_EDGE         =      9,
        MALI_WRAP_MODE_CLAMP_TO_BORDER       =     11,
        MALI_WRAP_MODE_MIRRORED_REPEAT       =     12,
        MALI_WRAP_MODE_MIRRORED_CLAMP_TO_EDGE =     13,
        MALI_WRAP_MODE_MIRRORED_CLAMP_TO_BORDER =     15,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_wrap_mode_as_str(enum mali_wrap_mode imm)
{
    switch (imm) {
    case MALI_WRAP_MODE_REPEAT: return "Repeat";
    case MALI_WRAP_MODE_CLAMP_TO_EDGE: return "Clamp to Edge";
    case MALI_WRAP_MODE_CLAMP_TO_BORDER: return "Clamp to Border";
    case MALI_WRAP_MODE_MIRRORED_REPEAT: return "Mirrored Repeat";
    case MALI_WRAP_MODE_MIRRORED_CLAMP_TO_EDGE: return "Mirrored Clamp to Edge";
    case MALI_WRAP_MODE_MIRRORED_CLAMP_TO_BORDER: return "Mirrored Clamp to Border";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_tile_render_order {
        MALI_TILE_RENDER_ORDER_Z_ORDER       =      0,
        MALI_TILE_RENDER_ORDER_HORIZONTAL    =      1,
        MALI_TILE_RENDER_ORDER_VERTICAL      =      2,
        MALI_TILE_RENDER_ORDER_REVERSE_HORIZONTAL =      5,
        MALI_TILE_RENDER_ORDER_REVERSE_VERTICAL =      6,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_tile_render_order_as_str(enum mali_tile_render_order imm)
{
    switch (imm) {
    case MALI_TILE_RENDER_ORDER_Z_ORDER: return "Z Order";
    case MALI_TILE_RENDER_ORDER_HORIZONTAL: return "Horizontal";
    case MALI_TILE_RENDER_ORDER_VERTICAL: return "Vertical";
    case MALI_TILE_RENDER_ORDER_REVERSE_HORIZONTAL: return "Reverse horizontal";
    case MALI_TILE_RENDER_ORDER_REVERSE_VERTICAL: return "Reverse vertical";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_task_axis {
        MALI_TASK_AXIS_X                     =      0,
        MALI_TASK_AXIS_Y                     =      1,
        MALI_TASK_AXIS_Z                     =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_task_axis_as_str(enum mali_task_axis imm)
{
    switch (imm) {
    case MALI_TASK_AXIS_X: return "X";
    case MALI_TASK_AXIS_Y: return "Y";
    case MALI_TASK_AXIS_Z: return "Z";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_attribute_frequency {
        MALI_ATTRIBUTE_FREQUENCY_VERTEX      =      0,
        MALI_ATTRIBUTE_FREQUENCY_INSTANCE    =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_attribute_frequency_as_str(enum mali_attribute_frequency imm)
{
    switch (imm) {
    case MALI_ATTRIBUTE_FREQUENCY_VERTEX: return "Vertex";
    case MALI_ATTRIBUTE_FREQUENCY_INSTANCE: return "Instance";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_condition {
        MALI_CS_CONDITION_LEQUAL             =      0,
        MALI_CS_CONDITION_GREATER            =      1,
        MALI_CS_CONDITION_EQUAL              =      2,
        MALI_CS_CONDITION_NEQUAL             =      3,
        MALI_CS_CONDITION_LESS               =      4,
        MALI_CS_CONDITION_GEQUAL             =      5,
        MALI_CS_CONDITION_ALWAYS             =      6,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_condition_as_str(enum mali_cs_condition imm)
{
    switch (imm) {
    case MALI_CS_CONDITION_LEQUAL: return "Lequal";
    case MALI_CS_CONDITION_GREATER: return "Greater";
    case MALI_CS_CONDITION_EQUAL: return "Equal";
    case MALI_CS_CONDITION_NEQUAL: return "Nequal";
    case MALI_CS_CONDITION_LESS: return "Less";
    case MALI_CS_CONDITION_GEQUAL: return "Gequal";
    case MALI_CS_CONDITION_ALWAYS: return "Always";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_state {
        MALI_CS_STATE_TIMESTAMP              =      0,
        MALI_CS_STATE_CYCLE_COUNT            =      1,
        MALI_CS_STATE_DISJOINT_COUNT         =      2,
        MALI_CS_STATE_ERROR_STATUS           =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_state_as_str(enum mali_cs_state imm)
{
    switch (imm) {
    case MALI_CS_STATE_TIMESTAMP: return "Timestamp";
    case MALI_CS_STATE_CYCLE_COUNT: return "Cycle count";
    case MALI_CS_STATE_DISJOINT_COUNT: return "Disjoint count";
    case MALI_CS_STATE_ERROR_STATUS: return "Error status";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_heap_operation {
        MALI_CS_HEAP_OPERATION_VERTEX_TILER_STARTED =      0,
        MALI_CS_HEAP_OPERATION_VERTEX_TILER_COMPLETED =      1,
        MALI_CS_HEAP_OPERATION_FRAGMENT_COMPLETED =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_heap_operation_as_str(enum mali_cs_heap_operation imm)
{
    switch (imm) {
    case MALI_CS_HEAP_OPERATION_VERTEX_TILER_STARTED: return "Vertex/Tiler Started";
    case MALI_CS_HEAP_OPERATION_VERTEX_TILER_COMPLETED: return "Vertex/Tiler Completed";
    case MALI_CS_HEAP_OPERATION_FRAGMENT_COMPLETED: return "Fragment Completed";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_flush_mode {
        MALI_CS_FLUSH_MODE_NONE              =      0,
        MALI_CS_FLUSH_MODE_CLEAN             =      1,
        MALI_CS_FLUSH_MODE_CLEAN_AND_INVALIDATE =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_flush_mode_as_str(enum mali_cs_flush_mode imm)
{
    switch (imm) {
    case MALI_CS_FLUSH_MODE_NONE: return "None";
    case MALI_CS_FLUSH_MODE_CLEAN: return "Clean";
    case MALI_CS_FLUSH_MODE_CLEAN_AND_INVALIDATE: return "Clean and invalidate";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_other_flush_mode {
        MALI_CS_OTHER_FLUSH_MODE_NONE        =      0,
        MALI_CS_OTHER_FLUSH_MODE_INVALIDATE  =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_other_flush_mode_as_str(enum mali_cs_other_flush_mode imm)
{
    switch (imm) {
    case MALI_CS_OTHER_FLUSH_MODE_NONE: return "None";
    case MALI_CS_OTHER_FLUSH_MODE_INVALIDATE: return "Invalidate";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_draw_id_register_enable {
        MALI_CS_DRAW_ID_REGISTER_ENABLE_NO_DRAWID =      0,
        MALI_CS_DRAW_ID_REGISTER_ENABLE_DRAWID =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_draw_id_register_enable_as_str(enum mali_cs_draw_id_register_enable imm)
{
    switch (imm) {
    case MALI_CS_DRAW_ID_REGISTER_ENABLE_NO_DRAWID: return "No Drawid";
    case MALI_CS_DRAW_ID_REGISTER_ENABLE_DRAWID: return "Drawid";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_memory_allocation_enable {
        MALI_CS_MEMORY_ALLOCATION_ENABLE_NO_MALLOC =      0,
        MALI_CS_MEMORY_ALLOCATION_ENABLE_MALLOC =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_memory_allocation_enable_as_str(enum mali_cs_memory_allocation_enable imm)
{
    switch (imm) {
    case MALI_CS_MEMORY_ALLOCATION_ENABLE_NO_MALLOC: return "No Malloc";
    case MALI_CS_MEMORY_ALLOCATION_ENABLE_MALLOC: return "Malloc";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_opcode {
        MALI_CS_OPCODE_NOP                   =      0,
        MALI_CS_OPCODE_MOVE48                =      1,
        MALI_CS_OPCODE_MOVE32                =      2,
        MALI_CS_OPCODE_WAIT                  =      3,
        MALI_CS_OPCODE_RUN_COMPUTE           =      4,
        MALI_CS_OPCODE_RUN_FRAGMENT          =      7,
        MALI_CS_OPCODE_RUN_FULLSCREEN        =      8,
        MALI_CS_OPCODE_FINISH_TILING         =      9,
        MALI_CS_OPCODE_FINISH_FRAGMENT       =     11,
        MALI_CS_OPCODE_RUN_IDVS2             =     12,
        MALI_CS_OPCODE_ADD_IMMEDIATE32       =     16,
        MALI_CS_OPCODE_ADD_IMMEDIATE64       =     17,
        MALI_CS_OPCODE_COMPARE_SELECT32      =     18,
        MALI_CS_OPCODE_LOGIC_OP32            =     19,
        MALI_CS_OPCODE_LOAD_MULTIPLE         =     20,
        MALI_CS_OPCODE_STORE_MULTIPLE        =     21,
        MALI_CS_OPCODE_BRANCH                =     22,
        MALI_CS_OPCODE_SET_SB_ENTRY          =     23,
        MALI_CS_OPCODE_PROGRESS_WAIT         =     24,
        MALI_CS_OPCODE_SET_EXCEPTION_HANDLER =     25,
        MALI_CS_OPCODE_NEXT_SB_ENTRY         =     26,
        MALI_CS_OPCODE_SET_STATE             =     27,
        MALI_CS_OPCODE_SET_STATE_IMM32       =     28,
        MALI_CS_OPCODE_SHARED_SB_INC         =     30,
        MALI_CS_OPCODE_SHARED_SB_DEC         =     31,
        MALI_CS_OPCODE_CALL                  =     32,
        MALI_CS_OPCODE_JUMP                  =     33,
        MALI_CS_OPCODE_REQ_RESOURCE          =     34,
        MALI_CS_OPCODE_FLUSH_CACHE2          =     36,
        MALI_CS_OPCODE_SYNC_ADD32            =     37,
        MALI_CS_OPCODE_SYNC_SET32            =     38,
        MALI_CS_OPCODE_SYNC_WAIT32           =     39,
        MALI_CS_OPCODE_STORE_STATE           =     40,
        MALI_CS_OPCODE_PROT_REGION           =     41,
        MALI_CS_OPCODE_PROGRESS_STORE        =     42,
        MALI_CS_OPCODE_PROGRESS_LOAD         =     43,
        MALI_CS_OPCODE_RUN_COMPUTE_INDIRECT  =     44,
        MALI_CS_OPCODE_ERROR_BARRIER         =     47,
        MALI_CS_OPCODE_HEAP_SET              =     48,
        MALI_CS_OPCODE_HEAP_OPERATION        =     49,
        MALI_CS_OPCODE_TRACE_POINT           =     50,
        MALI_CS_OPCODE_SYNC_ADD64            =     51,
        MALI_CS_OPCODE_SYNC_SET64            =     52,
        MALI_CS_OPCODE_SYNC_WAIT64           =     53,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_opcode_as_str(enum mali_cs_opcode imm)
{
    switch (imm) {
    case MALI_CS_OPCODE_NOP: return "NOP";
    case MALI_CS_OPCODE_MOVE48: return "MOVE48";
    case MALI_CS_OPCODE_MOVE32: return "MOVE32";
    case MALI_CS_OPCODE_WAIT: return "WAIT";
    case MALI_CS_OPCODE_RUN_COMPUTE: return "RUN_COMPUTE";
    case MALI_CS_OPCODE_RUN_FRAGMENT: return "RUN_FRAGMENT";
    case MALI_CS_OPCODE_RUN_FULLSCREEN: return "RUN_FULLSCREEN";
    case MALI_CS_OPCODE_FINISH_TILING: return "FINISH_TILING";
    case MALI_CS_OPCODE_FINISH_FRAGMENT: return "FINISH_FRAGMENT";
    case MALI_CS_OPCODE_RUN_IDVS2: return "RUN_IDVS2";
    case MALI_CS_OPCODE_ADD_IMMEDIATE32: return "ADD_IMMEDIATE32";
    case MALI_CS_OPCODE_ADD_IMMEDIATE64: return "ADD_IMMEDIATE64";
    case MALI_CS_OPCODE_COMPARE_SELECT32: return "COMPARE_SELECT32";
    case MALI_CS_OPCODE_LOGIC_OP32: return "LOGIC_OP32";
    case MALI_CS_OPCODE_LOAD_MULTIPLE: return "LOAD_MULTIPLE";
    case MALI_CS_OPCODE_STORE_MULTIPLE: return "STORE_MULTIPLE";
    case MALI_CS_OPCODE_BRANCH: return "BRANCH";
    case MALI_CS_OPCODE_SET_SB_ENTRY: return "SET_SB_ENTRY";
    case MALI_CS_OPCODE_PROGRESS_WAIT: return "PROGRESS_WAIT";
    case MALI_CS_OPCODE_SET_EXCEPTION_HANDLER: return "SET_EXCEPTION_HANDLER";
    case MALI_CS_OPCODE_NEXT_SB_ENTRY: return "NEXT_SB_ENTRY";
    case MALI_CS_OPCODE_SET_STATE: return "SET_STATE";
    case MALI_CS_OPCODE_SET_STATE_IMM32: return "SET_STATE_IMM32";
    case MALI_CS_OPCODE_SHARED_SB_INC: return "SHARED_SB_INC";
    case MALI_CS_OPCODE_SHARED_SB_DEC: return "SHARED_SB_DEC";
    case MALI_CS_OPCODE_CALL: return "CALL";
    case MALI_CS_OPCODE_JUMP: return "JUMP";
    case MALI_CS_OPCODE_REQ_RESOURCE: return "REQ_RESOURCE";
    case MALI_CS_OPCODE_FLUSH_CACHE2: return "FLUSH_CACHE2";
    case MALI_CS_OPCODE_SYNC_ADD32: return "SYNC_ADD32";
    case MALI_CS_OPCODE_SYNC_SET32: return "SYNC_SET32";
    case MALI_CS_OPCODE_SYNC_WAIT32: return "SYNC_WAIT32";
    case MALI_CS_OPCODE_STORE_STATE: return "STORE_STATE";
    case MALI_CS_OPCODE_PROT_REGION: return "PROT_REGION";
    case MALI_CS_OPCODE_PROGRESS_STORE: return "PROGRESS_STORE";
    case MALI_CS_OPCODE_PROGRESS_LOAD: return "PROGRESS_LOAD";
    case MALI_CS_OPCODE_RUN_COMPUTE_INDIRECT: return "RUN_COMPUTE_INDIRECT";
    case MALI_CS_OPCODE_ERROR_BARRIER: return "ERROR_BARRIER";
    case MALI_CS_OPCODE_HEAP_SET: return "HEAP_SET";
    case MALI_CS_OPCODE_HEAP_OPERATION: return "HEAP_OPERATION";
    case MALI_CS_OPCODE_TRACE_POINT: return "TRACE_POINT";
    case MALI_CS_OPCODE_SYNC_ADD64: return "SYNC_ADD64";
    case MALI_CS_OPCODE_SYNC_SET64: return "SYNC_SET64";
    case MALI_CS_OPCODE_SYNC_WAIT64: return "SYNC_WAIT64";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_progress_increment {
        MALI_CS_PROGRESS_INCREMENT_NO_INCREMENT =      0,
        MALI_CS_PROGRESS_INCREMENT_INCREMENT =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_progress_increment_as_str(enum mali_cs_progress_increment imm)
{
    switch (imm) {
    case MALI_CS_PROGRESS_INCREMENT_NO_INCREMENT: return "No Increment";
    case MALI_CS_PROGRESS_INCREMENT_INCREMENT: return "Increment";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_defer_mode {
        MALI_CS_DEFER_MODE_DEFER_IMMEDIATE   =      0,
        MALI_CS_DEFER_MODE_DEFER_INDIRECT    =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_defer_mode_as_str(enum mali_cs_defer_mode imm)
{
    switch (imm) {
    case MALI_CS_DEFER_MODE_DEFER_IMMEDIATE: return "Defer Immediate";
    case MALI_CS_DEFER_MODE_DEFER_INDIRECT: return "Defer Indirect";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_idvs_pipeline_stage {
        MALI_IDVS_PIPELINE_STAGE_INTERNAL    =      0,
        MALI_IDVS_PIPELINE_STAGE_COMPUTE     =      1,
        MALI_IDVS_PIPELINE_STAGE_VERTEX      =      2,
        MALI_IDVS_PIPELINE_STAGE_TESS_CONTROL =      3,
        MALI_IDVS_PIPELINE_STAGE_TESS_EVAL   =      4,
        MALI_IDVS_PIPELINE_STAGE_GEOMETRY    =      5,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_idvs_pipeline_stage_as_str(enum mali_idvs_pipeline_stage imm)
{
    switch (imm) {
    case MALI_IDVS_PIPELINE_STAGE_INTERNAL: return "Internal";
    case MALI_IDVS_PIPELINE_STAGE_COMPUTE: return "Compute";
    case MALI_IDVS_PIPELINE_STAGE_VERTEX: return "Vertex";
    case MALI_IDVS_PIPELINE_STAGE_TESS_CONTROL: return "Tess Control";
    case MALI_IDVS_PIPELINE_STAGE_TESS_EVAL: return "Tess Eval";
    case MALI_IDVS_PIPELINE_STAGE_GEOMETRY: return "Geometry";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_finish_fragment_heap {
        MALI_FINISH_FRAGMENT_HEAP_HEAP_NOP   =      0,
        MALI_FINISH_FRAGMENT_HEAP_FRAG_END   =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_finish_fragment_heap_as_str(enum mali_finish_fragment_heap imm)
{
    switch (imm) {
    case MALI_FINISH_FRAGMENT_HEAP_HEAP_NOP: return "HEAP_NOP";
    case MALI_FINISH_FRAGMENT_HEAP_FRAG_END: return "FRAG_END";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_compute_resources {
        MALI_CS_COMPUTE_RESOURCES_NO_COMPUTE =      0,
        MALI_CS_COMPUTE_RESOURCES_COMPUTE    =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_compute_resources_as_str(enum mali_cs_compute_resources imm)
{
    switch (imm) {
    case MALI_CS_COMPUTE_RESOURCES_NO_COMPUTE: return "No Compute";
    case MALI_CS_COMPUTE_RESOURCES_COMPUTE: return "Compute";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_fragment_resources {
        MALI_CS_FRAGMENT_RESOURCES_NO_FRAGMENT =      0,
        MALI_CS_FRAGMENT_RESOURCES_FRAGMENT  =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_fragment_resources_as_str(enum mali_cs_fragment_resources imm)
{
    switch (imm) {
    case MALI_CS_FRAGMENT_RESOURCES_NO_FRAGMENT: return "No Fragment";
    case MALI_CS_FRAGMENT_RESOURCES_FRAGMENT: return "Fragment";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_tiler_resources {
        MALI_CS_TILER_RESOURCES_NO_TILER     =      0,
        MALI_CS_TILER_RESOURCES_TILER        =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_tiler_resources_as_str(enum mali_cs_tiler_resources imm)
{
    switch (imm) {
    case MALI_CS_TILER_RESOURCES_NO_TILER: return "No Tiler";
    case MALI_CS_TILER_RESOURCES_TILER: return "Tiler";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_idvs_resources {
        MALI_CS_IDVS_RESOURCES_NO_IDVS       =      0,
        MALI_CS_IDVS_RESOURCES_IDVS          =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_idvs_resources_as_str(enum mali_cs_idvs_resources imm)
{
    switch (imm) {
    case MALI_CS_IDVS_RESOURCES_NO_IDVS: return "No IDVS";
    case MALI_CS_IDVS_RESOURCES_IDVS: return "IDVS";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_rt_resources {
        MALI_CS_RT_RESOURCES_NO_RAY_TRACING  =      0,
        MALI_CS_RT_RESOURCES_RAY_TRACING     =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_rt_resources_as_str(enum mali_cs_rt_resources imm)
{
    switch (imm) {
    case MALI_CS_RT_RESOURCES_NO_RAY_TRACING: return "No Ray Tracing";
    case MALI_CS_RT_RESOURCES_RAY_TRACING: return "Ray Tracing";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_tiler_map_enable {
        MALI_CS_TILER_MAP_ENABLE_NO_TEM      =      0,
        MALI_CS_TILER_MAP_ENABLE_TEM         =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_tiler_map_enable_as_str(enum mali_cs_tiler_map_enable imm)
{
    switch (imm) {
    case MALI_CS_TILER_MAP_ENABLE_NO_TEM: return "No TEM";
    case MALI_CS_TILER_MAP_ENABLE_TEM: return "TEM";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_exception_type {
        MALI_CS_EXCEPTION_TYPE_TILER_OOM     =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_exception_type_as_str(enum mali_cs_exception_type imm)
{
    switch (imm) {
    case MALI_CS_EXCEPTION_TYPE_TILER_OOM: return "Tiler OOM";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_sync_error_propagate {
        MALI_CS_SYNC_ERROR_PROPAGATE_CLEAR   =      0,
        MALI_CS_SYNC_ERROR_PROPAGATE_PROPAGATE =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_sync_error_propagate_as_str(enum mali_cs_sync_error_propagate imm)
{
    switch (imm) {
    case MALI_CS_SYNC_ERROR_PROPAGATE_CLEAR: return "Clear";
    case MALI_CS_SYNC_ERROR_PROPAGATE_PROPAGATE: return "Propagate";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_sync_error_reject {
        MALI_CS_SYNC_ERROR_REJECT_INHERIT    =      0,
        MALI_CS_SYNC_ERROR_REJECT_REJECT     =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_sync_error_reject_as_str(enum mali_cs_sync_error_reject imm)
{
    switch (imm) {
    case MALI_CS_SYNC_ERROR_REJECT_INHERIT: return "Inherit";
    case MALI_CS_SYNC_ERROR_REJECT_REJECT: return "Reject";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_sync_scope {
        MALI_CS_SYNC_SCOPE_SYSTEM            =      0,
        MALI_CS_SYNC_SCOPE_CSG               =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_sync_scope_as_str(enum mali_cs_sync_scope imm)
{
    switch (imm) {
    case MALI_CS_SYNC_SCOPE_SYSTEM: return "System";
    case MALI_CS_SYNC_SCOPE_CSG: return "CSG";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_wait_mode {
        MALI_CS_WAIT_MODE_IMMEDIATE          =      0,
        MALI_CS_WAIT_MODE_INDIRECT           =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_wait_mode_as_str(enum mali_cs_wait_mode imm)
{
    switch (imm) {
    case MALI_CS_WAIT_MODE_IMMEDIATE: return "Immediate";
    case MALI_CS_WAIT_MODE_INDIRECT: return "Indirect";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_logic_op {
        MALI_CS_LOGIC_OP_CLEAR               =      0,
        MALI_CS_LOGIC_OP_AND                 =      1,
        MALI_CS_LOGIC_OP_AND_A_NB            =      2,
        MALI_CS_LOGIC_OP_MOV_A               =      3,
        MALI_CS_LOGIC_OP_AND_NA_B            =      4,
        MALI_CS_LOGIC_OP_MOV_B               =      5,
        MALI_CS_LOGIC_OP_XOR                 =      6,
        MALI_CS_LOGIC_OP_OR                  =      7,
        MALI_CS_LOGIC_OP_NOR                 =      8,
        MALI_CS_LOGIC_OP_XNOR                =      9,
        MALI_CS_LOGIC_OP_NOT_B               =     10,
        MALI_CS_LOGIC_OP_OR_A_NB             =     11,
        MALI_CS_LOGIC_OP_NOT_A               =     12,
        MALI_CS_LOGIC_OP_OR_NA_B             =     13,
        MALI_CS_LOGIC_OP_NAND                =     14,
        MALI_CS_LOGIC_OP_SET                 =     15,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_logic_op_as_str(enum mali_cs_logic_op imm)
{
    switch (imm) {
    case MALI_CS_LOGIC_OP_CLEAR: return "CLEAR";
    case MALI_CS_LOGIC_OP_AND: return "AND";
    case MALI_CS_LOGIC_OP_AND_A_NB: return "AND_A_NB";
    case MALI_CS_LOGIC_OP_MOV_A: return "MOV_A";
    case MALI_CS_LOGIC_OP_AND_NA_B: return "AND_NA_B";
    case MALI_CS_LOGIC_OP_MOV_B: return "MOV_B";
    case MALI_CS_LOGIC_OP_XOR: return "XOR";
    case MALI_CS_LOGIC_OP_OR: return "OR";
    case MALI_CS_LOGIC_OP_NOR: return "NOR";
    case MALI_CS_LOGIC_OP_XNOR: return "XNOR";
    case MALI_CS_LOGIC_OP_NOT_B: return "NOT_B";
    case MALI_CS_LOGIC_OP_OR_A_NB: return "OR_A_NB";
    case MALI_CS_LOGIC_OP_NOT_A: return "NOT_A";
    case MALI_CS_LOGIC_OP_OR_NA_B: return "OR_NA_B";
    case MALI_CS_LOGIC_OP_NAND: return "NAND";
    case MALI_CS_LOGIC_OP_SET: return "SET";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_logic_op_index {
        MALI_CS_LOGIC_OP_INDEX_DIRECT        =      0,
        MALI_CS_LOGIC_OP_INDEX_INDEX         =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_logic_op_index_as_str(enum mali_cs_logic_op_index imm)
{
    switch (imm) {
    case MALI_CS_LOGIC_OP_INDEX_DIRECT: return "Direct";
    case MALI_CS_LOGIC_OP_INDEX_INDEX: return "Index";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_next_sb_entry_format {
        MALI_CS_NEXT_SB_ENTRY_FORMAT_INDEX   =      0,
        MALI_CS_NEXT_SB_ENTRY_FORMAT_MASK    =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_next_sb_entry_format_as_str(enum mali_cs_next_sb_entry_format imm)
{
    switch (imm) {
    case MALI_CS_NEXT_SB_ENTRY_FORMAT_INDEX: return "Index";
    case MALI_CS_NEXT_SB_ENTRY_FORMAT_MASK: return "Mask";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_scoreboard_type {
        MALI_CS_SCOREBOARD_TYPE_NO_CHANGE    =      0,
        MALI_CS_SCOREBOARD_TYPE_ENDPOINT     =      1,
        MALI_CS_SCOREBOARD_TYPE_OTHER        =      2,
        MALI_CS_SCOREBOARD_TYPE_DEFERRED     =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_scoreboard_type_as_str(enum mali_cs_scoreboard_type imm)
{
    switch (imm) {
    case MALI_CS_SCOREBOARD_TYPE_NO_CHANGE: return "No Change";
    case MALI_CS_SCOREBOARD_TYPE_ENDPOINT: return "Endpoint";
    case MALI_CS_SCOREBOARD_TYPE_OTHER: return "Other";
    case MALI_CS_SCOREBOARD_TYPE_DEFERRED: return "Deferred";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_set_state_type {
        MALI_CS_SET_STATE_TYPE_SB_SEL_ENDPOINT =      0,
        MALI_CS_SET_STATE_TYPE_SB_SEL_OTHER  =      1,
        MALI_CS_SET_STATE_TYPE_SB_SEL_DEFERRED =      2,
        MALI_CS_SET_STATE_TYPE_SB_MASK_STREAM =      8,
        MALI_CS_SET_STATE_TYPE_SB_MASK_WAIT  =      9,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_set_state_type_as_str(enum mali_cs_set_state_type imm)
{
    switch (imm) {
    case MALI_CS_SET_STATE_TYPE_SB_SEL_ENDPOINT: return "SB Sel Endpoint";
    case MALI_CS_SET_STATE_TYPE_SB_SEL_OTHER: return "SB Sel Other";
    case MALI_CS_SET_STATE_TYPE_SB_SEL_DEFERRED: return "SB Sel Deferred";
    case MALI_CS_SET_STATE_TYPE_SB_MASK_STREAM: return "SB Mask Stream";
    case MALI_CS_SET_STATE_TYPE_SB_MASK_WAIT: return "SB Mask Wait";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_cs_shared_sb_increment_defer_mode {
        MALI_CS_SHARED_SB_INCREMENT_DEFER_MODE_DEFER_IMMEDIATE =      0,
        MALI_CS_SHARED_SB_INCREMENT_DEFER_MODE_DEFER_INDIRECT =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_cs_shared_sb_increment_defer_mode_as_str(enum mali_cs_shared_sb_increment_defer_mode imm)
{
    switch (imm) {
    case MALI_CS_SHARED_SB_INCREMENT_DEFER_MODE_DEFER_IMMEDIATE: return "Defer Immediate";
    case MALI_CS_SHARED_SB_INCREMENT_DEFER_MODE_DEFER_INDIRECT: return "Defer Indirect";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_idvs_shading_mode {
        MALI_IDVS_SHADING_MODE_EARLY         =      0,
        MALI_IDVS_SHADING_MODE_DEFERRED      =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_idvs_shading_mode_as_str(enum mali_idvs_shading_mode imm)
{
    switch (imm) {
    case MALI_IDVS_SHADING_MODE_EARLY: return "Early";
    case MALI_IDVS_SHADING_MODE_DEFERRED: return "Deferred";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_CS_BASE {
   uint64_t                             data;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_BASE_header                     \
   0

#define MALI_CS_BASE_LENGTH 8
struct mali_cs_base_packed { uint32_t opaque[2]; };
#define MALI_CS_BASE_PACKED_T struct mali_cs_base_packed
#define MALI_CS_BASE_pack(__packed, __unpacked) \
do { \
   MALI_CS_BASE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->data, 0, 55); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->data, 0, 55) >> 32 | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_BASE_unpack(__packed, __unpacked) \
do { \
   MALI_CS_BASE_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->data, &__tmp_packed.opaque[0], 0, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_BASE_print(FILE *fp, const struct MALI_CS_BASE * values, unsigned indent)
{
   fprintf(fp, "%*sData: 0x%" PRIx64 "\n", indent, "", values->data);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_ADD_IMM32 {
   int64_t                              immediate;
   uint32_t                             source;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_ADD_IMM32_header                \
   .opcode = MALI_CS_OPCODE_ADD_IMMEDIATE32

#define MALI_CS_ADD_IMM32_LENGTH 8
struct mali_cs_add_imm32_packed { uint32_t opaque[2]; };
#define MALI_CS_ADD_IMM32_PACKED_T struct mali_cs_add_imm32_packed
#define MALI_CS_ADD_IMM32_pack(__packed, __unpacked) \
do { \
   MALI_CS_ADD_IMM32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_sint((__unpacked)->immediate, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source, 8, 15) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_ADD_IMM32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_ADD_IMM32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xff) fprintf(stderr, "XXX: Invalid field of CS ADD_IMM32 unpacked at word 1\n"); \
   __gen_unpack_sint((__unpacked)->immediate, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->source, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_ADD_IMM32_print(FILE *fp, const struct MALI_CS_ADD_IMM32 * values, unsigned indent)
{
   fprintf(fp, "%*sImmediate: %" PRId64 "\n", indent, "", (int64_t)values->immediate);
   fprintf(fp, "%*sSource: %u\n", indent, "", values->source);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_ADD_IMM64 {
   int64_t                              immediate;
   uint32_t                             source;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_ADD_IMM64_header                \
   .opcode = MALI_CS_OPCODE_ADD_IMMEDIATE64

#define MALI_CS_ADD_IMM64_LENGTH 8
struct mali_cs_add_imm64_packed { uint32_t opaque[2]; };
#define MALI_CS_ADD_IMM64_PACKED_T struct mali_cs_add_imm64_packed
#define MALI_CS_ADD_IMM64_pack(__packed, __unpacked) \
do { \
   MALI_CS_ADD_IMM64_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_sint((__unpacked)->immediate, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source, 8, 15) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_ADD_IMM64_unpack(__packed, __unpacked) \
do { \
   MALI_CS_ADD_IMM64_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xff) fprintf(stderr, "XXX: Invalid field of CS ADD_IMM64 unpacked at word 1\n"); \
   __gen_unpack_sint((__unpacked)->immediate, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->source, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_ADD_IMM64_print(FILE *fp, const struct MALI_CS_ADD_IMM64 * values, unsigned indent)
{
   fprintf(fp, "%*sImmediate: %" PRId64 "\n", indent, "", (int64_t)values->immediate);
   fprintf(fp, "%*sSource: %u\n", indent, "", values->source);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_BRANCH {
   int32_t                              offset;
   enum mali_cs_condition               condition;
   uint32_t                             value;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_BRANCH_header                   \
   .opcode = MALI_CS_OPCODE_BRANCH

#define MALI_CS_BRANCH_LENGTH 8
struct mali_cs_branch_packed { uint32_t opaque[2]; };
#define MALI_CS_BRANCH_PACKED_T struct mali_cs_branch_packed
#define MALI_CS_BRANCH_pack(__packed, __unpacked) \
do { \
   MALI_CS_BRANCH_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_sint((__unpacked)->offset, 0, 15) | \
            util_bitpack_uint((__unpacked)->condition, 28, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->value, 8, 15) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_BRANCH_unpack(__packed, __unpacked) \
do { \
   MALI_CS_BRANCH_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff0000) fprintf(stderr, "XXX: Invalid field of CS BRANCH unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff00ff) fprintf(stderr, "XXX: Invalid field of CS BRANCH unpacked at word 1\n"); \
   __gen_unpack_sint((__unpacked)->offset, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->condition, &__tmp_packed.opaque[0], 28, 31); \
   __gen_unpack_uint((__unpacked)->value, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_BRANCH_print(FILE *fp, const struct MALI_CS_BRANCH * values, unsigned indent)
{
   fprintf(fp, "%*sOffset: %" PRId64 "\n", indent, "", (int64_t)values->offset);
   fprintf(fp, "%*sCondition: %s\n", indent, "", mali_cs_condition_as_str(values->condition));
   fprintf(fp, "%*sValue: %u\n", indent, "", values->value);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_CALL {
   uint32_t                             length;
   uint32_t                             address;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_CALL_header                     \
   .opcode = MALI_CS_OPCODE_CALL

#define MALI_CS_CALL_LENGTH 8
struct mali_cs_call_packed { uint32_t opaque[2]; };
#define MALI_CS_CALL_PACKED_T struct mali_cs_call_packed
#define MALI_CS_CALL_pack(__packed, __unpacked) \
do { \
   MALI_CS_CALL_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->length, 0, 7) | \
            util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_CALL_unpack(__packed, __unpacked) \
do { \
   MALI_CS_CALL_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CS CALL unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff0000) fprintf(stderr, "XXX: Invalid field of CS CALL unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->length, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_CALL_print(FILE *fp, const struct MALI_CS_CALL * values, unsigned indent)
{
   fprintf(fp, "%*sLength: %u\n", indent, "", values->length);
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_ERROR_BARRIER {
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_ERROR_BARRIER_header            \
   .opcode = MALI_CS_OPCODE_ERROR_BARRIER

#define MALI_CS_ERROR_BARRIER_LENGTH 8
struct mali_cs_error_barrier_packed { uint32_t opaque[2]; };
#define MALI_CS_ERROR_BARRIER_PACKED_T struct mali_cs_error_barrier_packed
#define MALI_CS_ERROR_BARRIER_pack(__packed, __unpacked) \
do { \
   MALI_CS_ERROR_BARRIER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_ERROR_BARRIER_unpack(__packed, __unpacked) \
do { \
   MALI_CS_ERROR_BARRIER_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CS ERROR_BARRIER unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffff) fprintf(stderr, "XXX: Invalid field of CS ERROR_BARRIER unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_ERROR_BARRIER_print(FILE *fp, const struct MALI_CS_ERROR_BARRIER * values, unsigned indent)
{
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_FINISH_FRAGMENT {
   bool                                 increment_fragment_completed;
   uint32_t                             wait_mask;
   uint32_t                             last_heap_chunk;
   uint32_t                             first_heap_chunk;
   uint32_t                             signal_slot;
   enum mali_cs_defer_mode              defer_mode;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_FINISH_FRAGMENT_header          \
   .defer_mode = MALI_CS_DEFER_MODE_DEFER_IMMEDIATE,  \
   .opcode = MALI_CS_OPCODE_FINISH_FRAGMENT

#define MALI_CS_FINISH_FRAGMENT_LENGTH 8
struct mali_cs_finish_fragment_packed { uint32_t opaque[2]; };
#define MALI_CS_FINISH_FRAGMENT_PACKED_T struct mali_cs_finish_fragment_packed
#define MALI_CS_FINISH_FRAGMENT_pack(__packed, __unpacked) \
do { \
   MALI_CS_FINISH_FRAGMENT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->increment_fragment_completed, 0, 0) | \
            util_bitpack_uint((__unpacked)->wait_mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->last_heap_chunk, 0, 7) | \
            util_bitpack_uint((__unpacked)->first_heap_chunk, 8, 15) | \
            util_bitpack_uint((__unpacked)->signal_slot, 16, 19) | \
            util_bitpack_uint((__unpacked)->defer_mode, 20, 20) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_FINISH_FRAGMENT_unpack(__packed, __unpacked) \
do { \
   MALI_CS_FINISH_FRAGMENT_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfffe) fprintf(stderr, "XXX: Invalid field of CS FINISH_FRAGMENT unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xe00000) fprintf(stderr, "XXX: Invalid field of CS FINISH_FRAGMENT unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->increment_fragment_completed, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->wait_mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->last_heap_chunk, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->first_heap_chunk, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->signal_slot, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->defer_mode, &__tmp_packed.opaque[0], 52, 52); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_FINISH_FRAGMENT_print(FILE *fp, const struct MALI_CS_FINISH_FRAGMENT * values, unsigned indent)
{
   fprintf(fp, "%*sIncrement Fragment Completed: %s\n", indent, "", values->increment_fragment_completed ? "true" : "false");
   fprintf(fp, "%*sWait Mask: 0x%x\n", indent, "", values->wait_mask);
   fprintf(fp, "%*sLast Heap Chunk: %u\n", indent, "", values->last_heap_chunk);
   fprintf(fp, "%*sFirst Heap Chunk: %u\n", indent, "", values->first_heap_chunk);
   fprintf(fp, "%*sSignal slot: 0x%x\n", indent, "", values->signal_slot);
   fprintf(fp, "%*sDefer Mode: %s\n", indent, "", mali_cs_defer_mode_as_str(values->defer_mode));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_FINISH_TILING {
   enum mali_cs_progress_increment      progress_increment;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_FINISH_TILING_header            \
   .progress_increment = MALI_CS_PROGRESS_INCREMENT_NO_INCREMENT,  \
   .opcode = MALI_CS_OPCODE_FINISH_TILING

#define MALI_CS_FINISH_TILING_LENGTH 8
struct mali_cs_finish_tiling_packed { uint32_t opaque[2]; };
#define MALI_CS_FINISH_TILING_PACKED_T struct mali_cs_finish_tiling_packed
#define MALI_CS_FINISH_TILING_pack(__packed, __unpacked) \
do { \
   MALI_CS_FINISH_TILING_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->progress_increment, 0, 0) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_FINISH_TILING_unpack(__packed, __unpacked) \
do { \
   MALI_CS_FINISH_TILING_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CS FINISH_TILING unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xfffffe) fprintf(stderr, "XXX: Invalid field of CS FINISH_TILING unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->progress_increment, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_FINISH_TILING_print(FILE *fp, const struct MALI_CS_FINISH_TILING * values, unsigned indent)
{
   fprintf(fp, "%*sProgress Increment: %s\n", indent, "", mali_cs_progress_increment_as_str(values->progress_increment));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_FLUSH_CACHE2 {
   enum mali_cs_flush_mode              l2_flush_mode;
   enum mali_cs_flush_mode              lsc_flush_mode;
   enum mali_cs_other_flush_mode        other_flush_mode;
   uint32_t                             wait_mask;
   uint32_t                             latest_flush_id;
   uint32_t                             signal_slot;
   enum mali_cs_defer_mode              defer_mode;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_FLUSH_CACHE2_header             \
   .defer_mode = MALI_CS_DEFER_MODE_DEFER_IMMEDIATE,  \
   .opcode = MALI_CS_OPCODE_FLUSH_CACHE2

#define MALI_CS_FLUSH_CACHE2_LENGTH 8
struct mali_cs_flush_cache2_packed { uint32_t opaque[2]; };
#define MALI_CS_FLUSH_CACHE2_PACKED_T struct mali_cs_flush_cache2_packed
#define MALI_CS_FLUSH_CACHE2_pack(__packed, __unpacked) \
do { \
   MALI_CS_FLUSH_CACHE2_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->l2_flush_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->lsc_flush_mode, 4, 7) | \
            util_bitpack_uint((__unpacked)->other_flush_mode, 8, 11) | \
            util_bitpack_uint((__unpacked)->wait_mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->latest_flush_id, 8, 15) | \
            util_bitpack_uint((__unpacked)->signal_slot, 16, 19) | \
            util_bitpack_uint((__unpacked)->defer_mode, 20, 20) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_FLUSH_CACHE2_unpack(__packed, __unpacked) \
do { \
   MALI_CS_FLUSH_CACHE2_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf000) fprintf(stderr, "XXX: Invalid field of CS FLUSH_CACHE2 unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xe000ff) fprintf(stderr, "XXX: Invalid field of CS FLUSH_CACHE2 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->l2_flush_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->lsc_flush_mode, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->other_flush_mode, &__tmp_packed.opaque[0], 8, 11); \
   __gen_unpack_uint((__unpacked)->wait_mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->latest_flush_id, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->signal_slot, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->defer_mode, &__tmp_packed.opaque[0], 52, 52); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_FLUSH_CACHE2_print(FILE *fp, const struct MALI_CS_FLUSH_CACHE2 * values, unsigned indent)
{
   fprintf(fp, "%*sL2 Flush Mode: %s\n", indent, "", mali_cs_flush_mode_as_str(values->l2_flush_mode));
   fprintf(fp, "%*sLSC Flush Mode: %s\n", indent, "", mali_cs_flush_mode_as_str(values->lsc_flush_mode));
   fprintf(fp, "%*sOther Flush Mode: %s\n", indent, "", mali_cs_other_flush_mode_as_str(values->other_flush_mode));
   fprintf(fp, "%*sWait Mask: 0x%x\n", indent, "", values->wait_mask);
   fprintf(fp, "%*sLatest Flush ID: %u\n", indent, "", values->latest_flush_id);
   fprintf(fp, "%*sSignal slot: %u\n", indent, "", values->signal_slot);
   fprintf(fp, "%*sDefer Mode: %s\n", indent, "", mali_cs_defer_mode_as_str(values->defer_mode));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_HEAP_SET {
   uint32_t                             address;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_HEAP_SET_header                 \
   .opcode = MALI_CS_OPCODE_HEAP_SET

#define MALI_CS_HEAP_SET_LENGTH 8
struct mali_cs_heap_set_packed { uint32_t opaque[2]; };
#define MALI_CS_HEAP_SET_PACKED_T struct mali_cs_heap_set_packed
#define MALI_CS_HEAP_SET_pack(__packed, __unpacked) \
do { \
   MALI_CS_HEAP_SET_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_HEAP_SET_unpack(__packed, __unpacked) \
do { \
   MALI_CS_HEAP_SET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CS HEAP_SET unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff00ff) fprintf(stderr, "XXX: Invalid field of CS HEAP_SET unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_HEAP_SET_print(FILE *fp, const struct MALI_CS_HEAP_SET * values, unsigned indent)
{
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_HEAP_OPERATION {
   uint32_t                             wait_mask;
   enum mali_cs_heap_operation          operation;
   uint32_t                             signal_slot;
   enum mali_cs_defer_mode              defer_mode;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_HEAP_OPERATION_header           \
   .defer_mode = MALI_CS_DEFER_MODE_DEFER_IMMEDIATE,  \
   .opcode = MALI_CS_OPCODE_HEAP_OPERATION

#define MALI_CS_HEAP_OPERATION_LENGTH 8
struct mali_cs_heap_operation_packed { uint32_t opaque[2]; };
#define MALI_CS_HEAP_OPERATION_PACKED_T struct mali_cs_heap_operation_packed
#define MALI_CS_HEAP_OPERATION_pack(__packed, __unpacked) \
do { \
   MALI_CS_HEAP_OPERATION_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->wait_mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->operation, 0, 2) | \
            util_bitpack_uint((__unpacked)->signal_slot, 16, 19) | \
            util_bitpack_uint((__unpacked)->defer_mode, 20, 20) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_HEAP_OPERATION_unpack(__packed, __unpacked) \
do { \
   MALI_CS_HEAP_OPERATION_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffff) fprintf(stderr, "XXX: Invalid field of CS HEAP_OPERATION unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xe0fff8) fprintf(stderr, "XXX: Invalid field of CS HEAP_OPERATION unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->wait_mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->operation, &__tmp_packed.opaque[0], 32, 34); \
   __gen_unpack_uint((__unpacked)->signal_slot, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->defer_mode, &__tmp_packed.opaque[0], 52, 52); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_HEAP_OPERATION_print(FILE *fp, const struct MALI_CS_HEAP_OPERATION * values, unsigned indent)
{
   fprintf(fp, "%*sWait mask: 0x%x\n", indent, "", values->wait_mask);
   fprintf(fp, "%*sOperation: %s\n", indent, "", mali_cs_heap_operation_as_str(values->operation));
   fprintf(fp, "%*sSignal slot: %u\n", indent, "", values->signal_slot);
   fprintf(fp, "%*sDefer Mode: %s\n", indent, "", mali_cs_defer_mode_as_str(values->defer_mode));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_JUMP {
   uint32_t                             length;
   uint32_t                             address;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_JUMP_header                     \
   .opcode = MALI_CS_OPCODE_JUMP

#define MALI_CS_JUMP_LENGTH 8
struct mali_cs_jump_packed { uint32_t opaque[2]; };
#define MALI_CS_JUMP_PACKED_T struct mali_cs_jump_packed
#define MALI_CS_JUMP_pack(__packed, __unpacked) \
do { \
   MALI_CS_JUMP_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->length, 0, 7) | \
            util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_JUMP_unpack(__packed, __unpacked) \
do { \
   MALI_CS_JUMP_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CS JUMP unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff0000) fprintf(stderr, "XXX: Invalid field of CS JUMP unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->length, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_JUMP_print(FILE *fp, const struct MALI_CS_JUMP * values, unsigned indent)
{
   fprintf(fp, "%*sLength: %u\n", indent, "", values->length);
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_LOAD_MULTIPLE {
   int32_t                              offset;
   uint32_t                             mask;
   uint32_t                             address;
   uint32_t                             base_register;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_LOAD_MULTIPLE_header            \
   .opcode = MALI_CS_OPCODE_LOAD_MULTIPLE

#define MALI_CS_LOAD_MULTIPLE_LENGTH 8
struct mali_cs_load_multiple_packed { uint32_t opaque[2]; };
#define MALI_CS_LOAD_MULTIPLE_PACKED_T struct mali_cs_load_multiple_packed
#define MALI_CS_LOAD_MULTIPLE_pack(__packed, __unpacked) \
do { \
   MALI_CS_LOAD_MULTIPLE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_sint((__unpacked)->offset, 0, 15) | \
            util_bitpack_uint((__unpacked)->mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->base_register, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_LOAD_MULTIPLE_unpack(__packed, __unpacked) \
do { \
   MALI_CS_LOAD_MULTIPLE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xff) fprintf(stderr, "XXX: Invalid field of CS LOAD_MULTIPLE unpacked at word 1\n"); \
   __gen_unpack_sint((__unpacked)->offset, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->base_register, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_LOAD_MULTIPLE_print(FILE *fp, const struct MALI_CS_LOAD_MULTIPLE * values, unsigned indent)
{
   fprintf(fp, "%*sOffset: %" PRId64 "\n", indent, "", (int64_t)values->offset);
   fprintf(fp, "%*sMask: 0x%x\n", indent, "", values->mask);
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sBase Register: %u\n", indent, "", values->base_register);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_MOVE32 {
   uint64_t                             immediate;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_MOVE32_header                   \
   .opcode = MALI_CS_OPCODE_MOVE32

#define MALI_CS_MOVE32_LENGTH 8
struct mali_cs_move32_packed { uint32_t opaque[2]; };
#define MALI_CS_MOVE32_PACKED_T struct mali_cs_move32_packed
#define MALI_CS_MOVE32_pack(__packed, __unpacked) \
do { \
   MALI_CS_MOVE32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->immediate, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_MOVE32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_MOVE32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xffff) fprintf(stderr, "XXX: Invalid field of CS MOVE32 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->immediate, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_MOVE32_print(FILE *fp, const struct MALI_CS_MOVE32 * values, unsigned indent)
{
   fprintf(fp, "%*sImmediate: 0x%" PRIx64 "\n", indent, "", values->immediate);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_MOVE48 {
   uint64_t                             immediate;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_MOVE48_header                   \
   .opcode = MALI_CS_OPCODE_MOVE48

#define MALI_CS_MOVE48_LENGTH 8
struct mali_cs_move48_packed { uint32_t opaque[2]; };
#define MALI_CS_MOVE48_PACKED_T struct mali_cs_move48_packed
#define MALI_CS_MOVE48_pack(__packed, __unpacked) \
do { \
   MALI_CS_MOVE48_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->immediate, 0, 47); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->immediate, 0, 47) >> 32 | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_MOVE48_unpack(__packed, __unpacked) \
do { \
   MALI_CS_MOVE48_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->immediate, &__tmp_packed.opaque[0], 0, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_MOVE48_print(FILE *fp, const struct MALI_CS_MOVE48 * values, unsigned indent)
{
   fprintf(fp, "%*sImmediate: 0x%" PRIx64 "\n", indent, "", values->immediate);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_NOP {
   uint64_t                             ignored;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_NOP_header                      \
   .opcode = MALI_CS_OPCODE_NOP

#define MALI_CS_NOP_LENGTH 8
struct mali_cs_nop_packed { uint32_t opaque[2]; };
#define MALI_CS_NOP_PACKED_T struct mali_cs_nop_packed
#define MALI_CS_NOP_pack(__packed, __unpacked) \
do { \
   MALI_CS_NOP_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->ignored, 0, 55); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->ignored, 0, 55) >> 32 | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_NOP_unpack(__packed, __unpacked) \
do { \
   MALI_CS_NOP_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->ignored, &__tmp_packed.opaque[0], 0, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_NOP_print(FILE *fp, const struct MALI_CS_NOP * values, unsigned indent)
{
   fprintf(fp, "%*sIgnored: 0x%" PRIx64 "\n", indent, "", values->ignored);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_PROGRESS_STORE {
   uint32_t                             source;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_PROGRESS_STORE_header           \
   .opcode = MALI_CS_OPCODE_PROGRESS_STORE

#define MALI_CS_PROGRESS_STORE_LENGTH 8
struct mali_cs_progress_store_packed { uint32_t opaque[2]; };
#define MALI_CS_PROGRESS_STORE_PACKED_T struct mali_cs_progress_store_packed
#define MALI_CS_PROGRESS_STORE_pack(__packed, __unpacked) \
do { \
   MALI_CS_PROGRESS_STORE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source, 8, 15) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_PROGRESS_STORE_unpack(__packed, __unpacked) \
do { \
   MALI_CS_PROGRESS_STORE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CS PROGRESS_STORE unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff00ff) fprintf(stderr, "XXX: Invalid field of CS PROGRESS_STORE unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->source, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_PROGRESS_STORE_print(FILE *fp, const struct MALI_CS_PROGRESS_STORE * values, unsigned indent)
{
   fprintf(fp, "%*sSource: %u\n", indent, "", values->source);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_PROGRESS_LOAD {
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_PROGRESS_LOAD_header            \
   .opcode = MALI_CS_OPCODE_PROGRESS_LOAD

#define MALI_CS_PROGRESS_LOAD_LENGTH 8
struct mali_cs_progress_load_packed { uint32_t opaque[2]; };
#define MALI_CS_PROGRESS_LOAD_PACKED_T struct mali_cs_progress_load_packed
#define MALI_CS_PROGRESS_LOAD_pack(__packed, __unpacked) \
do { \
   MALI_CS_PROGRESS_LOAD_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_PROGRESS_LOAD_unpack(__packed, __unpacked) \
do { \
   MALI_CS_PROGRESS_LOAD_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CS PROGRESS_LOAD unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffff) fprintf(stderr, "XXX: Invalid field of CS PROGRESS_LOAD unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_PROGRESS_LOAD_print(FILE *fp, const struct MALI_CS_PROGRESS_LOAD * values, unsigned indent)
{
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_PROGRESS_WAIT {
   uint32_t                             queue;
   uint32_t                             source;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_PROGRESS_WAIT_header            \
   .opcode = MALI_CS_OPCODE_PROGRESS_WAIT

#define MALI_CS_PROGRESS_WAIT_LENGTH 8
struct mali_cs_progress_wait_packed { uint32_t opaque[2]; };
#define MALI_CS_PROGRESS_WAIT_PACKED_T struct mali_cs_progress_wait_packed
#define MALI_CS_PROGRESS_WAIT_pack(__packed, __unpacked) \
do { \
   MALI_CS_PROGRESS_WAIT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->queue, 0, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source, 8, 15) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_PROGRESS_WAIT_unpack(__packed, __unpacked) \
do { \
   MALI_CS_PROGRESS_WAIT_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of CS PROGRESS_WAIT unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff00ff) fprintf(stderr, "XXX: Invalid field of CS PROGRESS_WAIT unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->queue, &__tmp_packed.opaque[0], 0, 4); \
   __gen_unpack_uint((__unpacked)->source, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_PROGRESS_WAIT_print(FILE *fp, const struct MALI_CS_PROGRESS_WAIT * values, unsigned indent)
{
   fprintf(fp, "%*sQueue: %u\n", indent, "", values->queue);
   fprintf(fp, "%*sSource: %u\n", indent, "", values->source);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_PROT_REGION {
   uint32_t                             size;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_PROT_REGION_header              \
   .opcode = MALI_CS_OPCODE_PROT_REGION

#define MALI_CS_PROT_REGION_LENGTH 8
struct mali_cs_prot_region_packed { uint32_t opaque[2]; };
#define MALI_CS_PROT_REGION_PACKED_T struct mali_cs_prot_region_packed
#define MALI_CS_PROT_REGION_pack(__packed, __unpacked) \
do { \
   MALI_CS_PROT_REGION_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->size, 0, 15); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_PROT_REGION_unpack(__packed, __unpacked) \
do { \
   MALI_CS_PROT_REGION_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of CS PROT_REGION unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffff) fprintf(stderr, "XXX: Invalid field of CS PROT_REGION unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_PROT_REGION_print(FILE *fp, const struct MALI_CS_PROT_REGION * values, unsigned indent)
{
   fprintf(fp, "%*sSize: %u\n", indent, "", values->size);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_REQ_RESOURCE {
   bool                                 compute;
   bool                                 fragment;
   bool                                 tiler;
   bool                                 idvs;
   bool                                 rt;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_REQ_RESOURCE_header             \
   .opcode = MALI_CS_OPCODE_REQ_RESOURCE

#define MALI_CS_REQ_RESOURCE_LENGTH 8
struct mali_cs_req_resource_packed { uint32_t opaque[2]; };
#define MALI_CS_REQ_RESOURCE_PACKED_T struct mali_cs_req_resource_packed
#define MALI_CS_REQ_RESOURCE_pack(__packed, __unpacked) \
do { \
   MALI_CS_REQ_RESOURCE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->compute, 0, 0) | \
            util_bitpack_uint((__unpacked)->fragment, 1, 1) | \
            util_bitpack_uint((__unpacked)->tiler, 2, 2) | \
            util_bitpack_uint((__unpacked)->idvs, 3, 3) | \
            util_bitpack_uint((__unpacked)->rt, 4, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_REQ_RESOURCE_unpack(__packed, __unpacked) \
do { \
   MALI_CS_REQ_RESOURCE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of CS REQ_RESOURCE unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffff) fprintf(stderr, "XXX: Invalid field of CS REQ_RESOURCE unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->compute, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->fragment, &__tmp_packed.opaque[0], 1, 1); \
   __gen_unpack_uint((__unpacked)->tiler, &__tmp_packed.opaque[0], 2, 2); \
   __gen_unpack_uint((__unpacked)->idvs, &__tmp_packed.opaque[0], 3, 3); \
   __gen_unpack_uint((__unpacked)->rt, &__tmp_packed.opaque[0], 4, 4); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_REQ_RESOURCE_print(FILE *fp, const struct MALI_CS_REQ_RESOURCE * values, unsigned indent)
{
   fprintf(fp, "%*sCompute: %s\n", indent, "", values->compute ? "true" : "false");
   fprintf(fp, "%*sFragment: %s\n", indent, "", values->fragment ? "true" : "false");
   fprintf(fp, "%*sTiler: %s\n", indent, "", values->tiler ? "true" : "false");
   fprintf(fp, "%*sIDVS: %s\n", indent, "", values->idvs ? "true" : "false");
   fprintf(fp, "%*sRT: %s\n", indent, "", values->rt ? "true" : "false");
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_RUN_COMPUTE {
   uint32_t                             task_increment;
   enum mali_task_axis                  task_axis;
   uint32_t                             ep_limit;
   enum mali_cs_progress_increment      progress_increment;
   uint32_t                             srt_select;
   uint32_t                             spd_select;
   uint32_t                             tsd_select;
   uint32_t                             fau_select;
   enum mali_idvs_pipeline_stage        stage;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_RUN_COMPUTE_header              \
   .progress_increment = MALI_CS_PROGRESS_INCREMENT_NO_INCREMENT,  \
   .stage = MALI_IDVS_PIPELINE_STAGE_INTERNAL,  \
   .opcode = MALI_CS_OPCODE_RUN_COMPUTE

#define MALI_CS_RUN_COMPUTE_LENGTH 8
struct mali_cs_run_compute_packed { uint32_t opaque[2]; };
#define MALI_CS_RUN_COMPUTE_PACKED_T struct mali_cs_run_compute_packed
#define MALI_CS_RUN_COMPUTE_pack(__packed, __unpacked) \
do { \
   MALI_CS_RUN_COMPUTE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->task_increment, 0, 13) | \
            util_bitpack_uint((__unpacked)->task_axis, 14, 15) | \
            util_bitpack_uint((__unpacked)->ep_limit, 16, 23); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->progress_increment, 0, 0) | \
            util_bitpack_uint((__unpacked)->srt_select, 8, 9) | \
            util_bitpack_uint((__unpacked)->spd_select, 10, 11) | \
            util_bitpack_uint((__unpacked)->tsd_select, 12, 13) | \
            util_bitpack_uint((__unpacked)->fau_select, 14, 15) | \
            util_bitpack_uint((__unpacked)->stage, 16, 19) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_RUN_COMPUTE_unpack(__packed, __unpacked) \
do { \
   MALI_CS_RUN_COMPUTE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff000000) fprintf(stderr, "XXX: Invalid field of CS RUN_COMPUTE unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf000fe) fprintf(stderr, "XXX: Invalid field of CS RUN_COMPUTE unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->task_increment, &__tmp_packed.opaque[0], 0, 13); \
   __gen_unpack_uint((__unpacked)->task_axis, &__tmp_packed.opaque[0], 14, 15); \
   __gen_unpack_uint((__unpacked)->ep_limit, &__tmp_packed.opaque[0], 16, 23); \
   __gen_unpack_uint((__unpacked)->progress_increment, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->srt_select, &__tmp_packed.opaque[0], 40, 41); \
   __gen_unpack_uint((__unpacked)->spd_select, &__tmp_packed.opaque[0], 42, 43); \
   __gen_unpack_uint((__unpacked)->tsd_select, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->fau_select, &__tmp_packed.opaque[0], 46, 47); \
   __gen_unpack_uint((__unpacked)->stage, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_RUN_COMPUTE_print(FILE *fp, const struct MALI_CS_RUN_COMPUTE * values, unsigned indent)
{
   fprintf(fp, "%*sTask Increment: %u\n", indent, "", values->task_increment);
   fprintf(fp, "%*sTask Axis: %s\n", indent, "", mali_task_axis_as_str(values->task_axis));
   fprintf(fp, "%*sEp Limit: %u\n", indent, "", values->ep_limit);
   fprintf(fp, "%*sProgress Increment: %s\n", indent, "", mali_cs_progress_increment_as_str(values->progress_increment));
   fprintf(fp, "%*sSRT Select: %u\n", indent, "", values->srt_select);
   fprintf(fp, "%*sSPD Select: %u\n", indent, "", values->spd_select);
   fprintf(fp, "%*sTSD Select: %u\n", indent, "", values->tsd_select);
   fprintf(fp, "%*sFAU Select: %u\n", indent, "", values->fau_select);
   fprintf(fp, "%*sStage: %s\n", indent, "", mali_idvs_pipeline_stage_as_str(values->stage));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_RUN_COMPUTE_INDIRECT {
   uint32_t                             workgroups_per_task;
   uint32_t                             endpoint_limit;
   enum mali_cs_progress_increment      progress_increment;
   uint32_t                             srt_select;
   uint32_t                             spd_select;
   uint32_t                             tsd_select;
   uint32_t                             fau_select;
   enum mali_idvs_pipeline_stage        stage;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_RUN_COMPUTE_INDIRECT_header     \
   .progress_increment = MALI_CS_PROGRESS_INCREMENT_NO_INCREMENT,  \
   .stage = MALI_IDVS_PIPELINE_STAGE_INTERNAL,  \
   .opcode = MALI_CS_OPCODE_RUN_COMPUTE_INDIRECT

#define MALI_CS_RUN_COMPUTE_INDIRECT_LENGTH 8
struct mali_cs_run_compute_indirect_packed { uint32_t opaque[2]; };
#define MALI_CS_RUN_COMPUTE_INDIRECT_PACKED_T struct mali_cs_run_compute_indirect_packed
#define MALI_CS_RUN_COMPUTE_INDIRECT_pack(__packed, __unpacked) \
do { \
   MALI_CS_RUN_COMPUTE_INDIRECT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->workgroups_per_task, 0, 15) | \
            util_bitpack_uint((__unpacked)->endpoint_limit, 16, 23); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->progress_increment, 0, 0) | \
            util_bitpack_uint((__unpacked)->srt_select, 8, 9) | \
            util_bitpack_uint((__unpacked)->spd_select, 10, 11) | \
            util_bitpack_uint((__unpacked)->tsd_select, 12, 13) | \
            util_bitpack_uint((__unpacked)->fau_select, 14, 15) | \
            util_bitpack_uint((__unpacked)->stage, 16, 19) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_RUN_COMPUTE_INDIRECT_unpack(__packed, __unpacked) \
do { \
   MALI_CS_RUN_COMPUTE_INDIRECT_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff000000) fprintf(stderr, "XXX: Invalid field of CS RUN_COMPUTE_INDIRECT unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf000fe) fprintf(stderr, "XXX: Invalid field of CS RUN_COMPUTE_INDIRECT unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->workgroups_per_task, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->endpoint_limit, &__tmp_packed.opaque[0], 16, 23); \
   __gen_unpack_uint((__unpacked)->progress_increment, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->srt_select, &__tmp_packed.opaque[0], 40, 41); \
   __gen_unpack_uint((__unpacked)->spd_select, &__tmp_packed.opaque[0], 42, 43); \
   __gen_unpack_uint((__unpacked)->tsd_select, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->fau_select, &__tmp_packed.opaque[0], 46, 47); \
   __gen_unpack_uint((__unpacked)->stage, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_RUN_COMPUTE_INDIRECT_print(FILE *fp, const struct MALI_CS_RUN_COMPUTE_INDIRECT * values, unsigned indent)
{
   fprintf(fp, "%*sWorkgroups Per Task: %u\n", indent, "", values->workgroups_per_task);
   fprintf(fp, "%*sEndpoint Limit: %u\n", indent, "", values->endpoint_limit);
   fprintf(fp, "%*sProgress Increment: %s\n", indent, "", mali_cs_progress_increment_as_str(values->progress_increment));
   fprintf(fp, "%*sSRT Select: %u\n", indent, "", values->srt_select);
   fprintf(fp, "%*sSPD Select: %u\n", indent, "", values->spd_select);
   fprintf(fp, "%*sTSD Select: %u\n", indent, "", values->tsd_select);
   fprintf(fp, "%*sFAU Select: %u\n", indent, "", values->fau_select);
   fprintf(fp, "%*sStage: %s\n", indent, "", mali_idvs_pipeline_stage_as_str(values->stage));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_RUN_FRAGMENT {
   bool                                 enable_tem;
   enum mali_tile_render_order          tile_order;
   enum mali_cs_progress_increment      progress_increment;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_RUN_FRAGMENT_header             \
   .progress_increment = MALI_CS_PROGRESS_INCREMENT_NO_INCREMENT,  \
   .opcode = MALI_CS_OPCODE_RUN_FRAGMENT

#define MALI_CS_RUN_FRAGMENT_LENGTH 8
struct mali_cs_run_fragment_packed { uint32_t opaque[2]; };
#define MALI_CS_RUN_FRAGMENT_PACKED_T struct mali_cs_run_fragment_packed
#define MALI_CS_RUN_FRAGMENT_pack(__packed, __unpacked) \
do { \
   MALI_CS_RUN_FRAGMENT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->enable_tem, 0, 0) | \
            util_bitpack_uint((__unpacked)->tile_order, 4, 7); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->progress_increment, 0, 0) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_RUN_FRAGMENT_unpack(__packed, __unpacked) \
do { \
   MALI_CS_RUN_FRAGMENT_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffff0e) fprintf(stderr, "XXX: Invalid field of CS RUN_FRAGMENT unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xfffffe) fprintf(stderr, "XXX: Invalid field of CS RUN_FRAGMENT unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->enable_tem, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->tile_order, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->progress_increment, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_RUN_FRAGMENT_print(FILE *fp, const struct MALI_CS_RUN_FRAGMENT * values, unsigned indent)
{
   fprintf(fp, "%*sEnable TEM: %s\n", indent, "", values->enable_tem ? "true" : "false");
   fprintf(fp, "%*sTile Order: %s\n", indent, "", mali_tile_render_order_as_str(values->tile_order));
   fprintf(fp, "%*sProgress Increment: %s\n", indent, "", mali_cs_progress_increment_as_str(values->progress_increment));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_RUN_FULLSCREEN {
   uint64_t                             flags_override;
   enum mali_cs_progress_increment      progress_increment;
   uint32_t                             dcd;
   bool                                 tiler_flags2_enable;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_RUN_FULLSCREEN_header           \
   .progress_increment = MALI_CS_PROGRESS_INCREMENT_NO_INCREMENT,  \
   .tiler_flags2_enable = 1,  \
   .opcode = MALI_CS_OPCODE_RUN_FULLSCREEN

#define MALI_CS_RUN_FULLSCREEN_LENGTH 8
struct mali_cs_run_fullscreen_packed { uint32_t opaque[2]; };
#define MALI_CS_RUN_FULLSCREEN_PACKED_T struct mali_cs_run_fullscreen_packed
#define MALI_CS_RUN_FULLSCREEN_pack(__packed, __unpacked) \
do { \
   MALI_CS_RUN_FULLSCREEN_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->flags_override, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->progress_increment, 0, 0) | \
            util_bitpack_uint((__unpacked)->dcd, 8, 15) | \
            util_bitpack_uint((__unpacked)->tiler_flags2_enable, 23, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_RUN_FULLSCREEN_unpack(__packed, __unpacked) \
do { \
   MALI_CS_RUN_FULLSCREEN_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0x7f00fe) fprintf(stderr, "XXX: Invalid field of CS RUN_FULLSCREEN unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->flags_override, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->progress_increment, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->dcd, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->tiler_flags2_enable, &__tmp_packed.opaque[0], 55, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_RUN_FULLSCREEN_print(FILE *fp, const struct MALI_CS_RUN_FULLSCREEN * values, unsigned indent)
{
   fprintf(fp, "%*sFlags Override: 0x%" PRIx64 "\n", indent, "", values->flags_override);
   fprintf(fp, "%*sProgress Increment: %s\n", indent, "", mali_cs_progress_increment_as_str(values->progress_increment));
   fprintf(fp, "%*sDCD: %u\n", indent, "", values->dcd);
   fprintf(fp, "%*sTiler Flags2 Enable: %s\n", indent, "", values->tiler_flags2_enable ? "true" : "false");
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SET_EXCEPTION_HANDLER {
   enum mali_cs_exception_type          exception_type;
   uint32_t                             length;
   uint32_t                             address;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SET_EXCEPTION_HANDLER_header    \
   .exception_type = MALI_CS_EXCEPTION_TYPE_TILER_OOM,  \
   .opcode = MALI_CS_OPCODE_SET_EXCEPTION_HANDLER

#define MALI_CS_SET_EXCEPTION_HANDLER_LENGTH 8
struct mali_cs_set_exception_handler_packed { uint32_t opaque[2]; };
#define MALI_CS_SET_EXCEPTION_HANDLER_PACKED_T struct mali_cs_set_exception_handler_packed
#define MALI_CS_SET_EXCEPTION_HANDLER_pack(__packed, __unpacked) \
do { \
   MALI_CS_SET_EXCEPTION_HANDLER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->exception_type, 0, 7); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->length, 0, 7) | \
            util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SET_EXCEPTION_HANDLER_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SET_EXCEPTION_HANDLER_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of CS SET_EXCEPTION_HANDLER unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff0000) fprintf(stderr, "XXX: Invalid field of CS SET_EXCEPTION_HANDLER unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->exception_type, &__tmp_packed.opaque[0], 0, 7); \
   __gen_unpack_uint((__unpacked)->length, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SET_EXCEPTION_HANDLER_print(FILE *fp, const struct MALI_CS_SET_EXCEPTION_HANDLER * values, unsigned indent)
{
   fprintf(fp, "%*sException type: %s\n", indent, "", mali_cs_exception_type_as_str(values->exception_type));
   fprintf(fp, "%*sLength: %u\n", indent, "", values->length);
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SET_SB_ENTRY {
   uint32_t                             endpoint_entry;
   uint32_t                             other_entry;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SET_SB_ENTRY_header             \
   .opcode = MALI_CS_OPCODE_SET_SB_ENTRY

#define MALI_CS_SET_SB_ENTRY_LENGTH 8
struct mali_cs_set_sb_entry_packed { uint32_t opaque[2]; };
#define MALI_CS_SET_SB_ENTRY_PACKED_T struct mali_cs_set_sb_entry_packed
#define MALI_CS_SET_SB_ENTRY_pack(__packed, __unpacked) \
do { \
   MALI_CS_SET_SB_ENTRY_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->endpoint_entry, 0, 3) | \
            util_bitpack_uint((__unpacked)->other_entry, 4, 7); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SET_SB_ENTRY_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SET_SB_ENTRY_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of CS SET_SB_ENTRY unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffff) fprintf(stderr, "XXX: Invalid field of CS SET_SB_ENTRY unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->endpoint_entry, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->other_entry, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SET_SB_ENTRY_print(FILE *fp, const struct MALI_CS_SET_SB_ENTRY * values, unsigned indent)
{
   fprintf(fp, "%*sEndpoint entry: %u\n", indent, "", values->endpoint_entry);
   fprintf(fp, "%*sOther Entry: %u\n", indent, "", values->other_entry);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_STORE_MULTIPLE {
   int32_t                              offset;
   uint32_t                             mask;
   uint32_t                             address;
   uint32_t                             base_register;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_STORE_MULTIPLE_header           \
   .opcode = MALI_CS_OPCODE_STORE_MULTIPLE

#define MALI_CS_STORE_MULTIPLE_LENGTH 8
struct mali_cs_store_multiple_packed { uint32_t opaque[2]; };
#define MALI_CS_STORE_MULTIPLE_PACKED_T struct mali_cs_store_multiple_packed
#define MALI_CS_STORE_MULTIPLE_pack(__packed, __unpacked) \
do { \
   MALI_CS_STORE_MULTIPLE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_sint((__unpacked)->offset, 0, 15) | \
            util_bitpack_uint((__unpacked)->mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->base_register, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_STORE_MULTIPLE_unpack(__packed, __unpacked) \
do { \
   MALI_CS_STORE_MULTIPLE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xff) fprintf(stderr, "XXX: Invalid field of CS STORE_MULTIPLE unpacked at word 1\n"); \
   __gen_unpack_sint((__unpacked)->offset, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->base_register, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_STORE_MULTIPLE_print(FILE *fp, const struct MALI_CS_STORE_MULTIPLE * values, unsigned indent)
{
   fprintf(fp, "%*sOffset: %" PRId64 "\n", indent, "", (int64_t)values->offset);
   fprintf(fp, "%*sMask: 0x%x\n", indent, "", values->mask);
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sBase Register: %u\n", indent, "", values->base_register);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_STORE_STATE {
   int32_t                              offset;
   uint32_t                             wait_mask;
   enum mali_cs_state                   state;
   uint32_t                             address;
   uint32_t                             signal_slot;
   enum mali_cs_defer_mode              defer_mode;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_STORE_STATE_header              \
   .defer_mode = MALI_CS_DEFER_MODE_DEFER_IMMEDIATE,  \
   .opcode = MALI_CS_OPCODE_STORE_STATE

#define MALI_CS_STORE_STATE_LENGTH 8
struct mali_cs_store_state_packed { uint32_t opaque[2]; };
#define MALI_CS_STORE_STATE_PACKED_T struct mali_cs_store_state_packed
#define MALI_CS_STORE_STATE_pack(__packed, __unpacked) \
do { \
   MALI_CS_STORE_STATE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_sint((__unpacked)->offset, 0, 15) | \
            util_bitpack_uint((__unpacked)->wait_mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->state, 0, 7) | \
            util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->signal_slot, 16, 19) | \
            util_bitpack_uint((__unpacked)->defer_mode, 20, 20) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_STORE_STATE_unpack(__packed, __unpacked) \
do { \
   MALI_CS_STORE_STATE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xe00000) fprintf(stderr, "XXX: Invalid field of CS STORE_STATE unpacked at word 1\n"); \
   __gen_unpack_sint((__unpacked)->offset, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->wait_mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->state, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->signal_slot, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->defer_mode, &__tmp_packed.opaque[0], 52, 52); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_STORE_STATE_print(FILE *fp, const struct MALI_CS_STORE_STATE * values, unsigned indent)
{
   fprintf(fp, "%*sOffset: %" PRId64 "\n", indent, "", (int64_t)values->offset);
   fprintf(fp, "%*sWait Mask: 0x%x\n", indent, "", values->wait_mask);
   fprintf(fp, "%*sState: %s\n", indent, "", mali_cs_state_as_str(values->state));
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sSignal slot: %u\n", indent, "", values->signal_slot);
   fprintf(fp, "%*sDefer Mode: %s\n", indent, "", mali_cs_defer_mode_as_str(values->defer_mode));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SYNC_ADD32 {
   bool                                 error_propagate;
   enum mali_cs_sync_scope              scope;
   uint32_t                             wait_mask;
   uint32_t                             data;
   uint32_t                             address;
   uint32_t                             signal_slot;
   enum mali_cs_defer_mode              defer_mode;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SYNC_ADD32_header               \
   .scope = MALI_CS_SYNC_SCOPE_SYSTEM,  \
   .defer_mode = MALI_CS_DEFER_MODE_DEFER_IMMEDIATE,  \
   .opcode = MALI_CS_OPCODE_SYNC_ADD32

#define MALI_CS_SYNC_ADD32_LENGTH 8
struct mali_cs_sync_add32_packed { uint32_t opaque[2]; };
#define MALI_CS_SYNC_ADD32_PACKED_T struct mali_cs_sync_add32_packed
#define MALI_CS_SYNC_ADD32_pack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_ADD32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->error_propagate, 0, 0) | \
            util_bitpack_uint((__unpacked)->scope, 1, 2) | \
            util_bitpack_uint((__unpacked)->wait_mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->data, 0, 7) | \
            util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->signal_slot, 16, 19) | \
            util_bitpack_uint((__unpacked)->defer_mode, 20, 20) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SYNC_ADD32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_ADD32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff8) fprintf(stderr, "XXX: Invalid field of CS SYNC_ADD32 unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xe00000) fprintf(stderr, "XXX: Invalid field of CS SYNC_ADD32 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->error_propagate, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->scope, &__tmp_packed.opaque[0], 1, 2); \
   __gen_unpack_uint((__unpacked)->wait_mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->data, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->signal_slot, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->defer_mode, &__tmp_packed.opaque[0], 52, 52); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SYNC_ADD32_print(FILE *fp, const struct MALI_CS_SYNC_ADD32 * values, unsigned indent)
{
   fprintf(fp, "%*sError Propagate: %s\n", indent, "", values->error_propagate ? "true" : "false");
   fprintf(fp, "%*sScope: %s\n", indent, "", mali_cs_sync_scope_as_str(values->scope));
   fprintf(fp, "%*sWait mask: 0x%x\n", indent, "", values->wait_mask);
   fprintf(fp, "%*sData: %u\n", indent, "", values->data);
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sSignal slot: %u\n", indent, "", values->signal_slot);
   fprintf(fp, "%*sDefer Mode: %s\n", indent, "", mali_cs_defer_mode_as_str(values->defer_mode));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SYNC_SET32 {
   bool                                 error_propagate;
   enum mali_cs_sync_scope              scope;
   uint32_t                             wait_mask;
   uint32_t                             data;
   uint32_t                             address;
   uint32_t                             signal_slot;
   enum mali_cs_defer_mode              defer_mode;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SYNC_SET32_header               \
   .scope = MALI_CS_SYNC_SCOPE_SYSTEM,  \
   .defer_mode = MALI_CS_DEFER_MODE_DEFER_IMMEDIATE,  \
   .opcode = MALI_CS_OPCODE_SYNC_SET32

#define MALI_CS_SYNC_SET32_LENGTH 8
struct mali_cs_sync_set32_packed { uint32_t opaque[2]; };
#define MALI_CS_SYNC_SET32_PACKED_T struct mali_cs_sync_set32_packed
#define MALI_CS_SYNC_SET32_pack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_SET32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->error_propagate, 0, 0) | \
            util_bitpack_uint((__unpacked)->scope, 1, 2) | \
            util_bitpack_uint((__unpacked)->wait_mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->data, 0, 7) | \
            util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->signal_slot, 16, 19) | \
            util_bitpack_uint((__unpacked)->defer_mode, 20, 20) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SYNC_SET32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_SET32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff8) fprintf(stderr, "XXX: Invalid field of CS SYNC_SET32 unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xe00000) fprintf(stderr, "XXX: Invalid field of CS SYNC_SET32 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->error_propagate, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->scope, &__tmp_packed.opaque[0], 1, 2); \
   __gen_unpack_uint((__unpacked)->wait_mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->data, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->signal_slot, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->defer_mode, &__tmp_packed.opaque[0], 52, 52); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SYNC_SET32_print(FILE *fp, const struct MALI_CS_SYNC_SET32 * values, unsigned indent)
{
   fprintf(fp, "%*sError Propagate: %s\n", indent, "", values->error_propagate ? "true" : "false");
   fprintf(fp, "%*sScope: %s\n", indent, "", mali_cs_sync_scope_as_str(values->scope));
   fprintf(fp, "%*sWait mask: 0x%x\n", indent, "", values->wait_mask);
   fprintf(fp, "%*sData: %u\n", indent, "", values->data);
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sSignal slot: %u\n", indent, "", values->signal_slot);
   fprintf(fp, "%*sDefer Mode: %s\n", indent, "", mali_cs_defer_mode_as_str(values->defer_mode));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SYNC_WAIT32 {
   enum mali_cs_sync_error_reject       error_reject;
   enum mali_cs_condition               condition;
   uint32_t                             data;
   uint32_t                             address;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SYNC_WAIT32_header              \
   .error_reject = MALI_CS_SYNC_ERROR_REJECT_INHERIT,  \
   .opcode = MALI_CS_OPCODE_SYNC_WAIT32

#define MALI_CS_SYNC_WAIT32_LENGTH 8
struct mali_cs_sync_wait32_packed { uint32_t opaque[2]; };
#define MALI_CS_SYNC_WAIT32_PACKED_T struct mali_cs_sync_wait32_packed
#define MALI_CS_SYNC_WAIT32_pack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_WAIT32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->error_reject, 0, 0) | \
            util_bitpack_uint((__unpacked)->condition, 28, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->data, 0, 7) | \
            util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SYNC_WAIT32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_WAIT32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe) fprintf(stderr, "XXX: Invalid field of CS SYNC_WAIT32 unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff0000) fprintf(stderr, "XXX: Invalid field of CS SYNC_WAIT32 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->error_reject, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->condition, &__tmp_packed.opaque[0], 28, 31); \
   __gen_unpack_uint((__unpacked)->data, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SYNC_WAIT32_print(FILE *fp, const struct MALI_CS_SYNC_WAIT32 * values, unsigned indent)
{
   fprintf(fp, "%*sError Reject: %s\n", indent, "", mali_cs_sync_error_reject_as_str(values->error_reject));
   fprintf(fp, "%*sCondition: %s\n", indent, "", mali_cs_condition_as_str(values->condition));
   fprintf(fp, "%*sData: %u\n", indent, "", values->data);
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SYNC_ADD64 {
   bool                                 error_propagate;
   enum mali_cs_sync_scope              scope;
   uint32_t                             wait_mask;
   uint32_t                             data;
   uint32_t                             address;
   uint32_t                             signal_slot;
   enum mali_cs_defer_mode              defer_mode;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SYNC_ADD64_header               \
   .scope = MALI_CS_SYNC_SCOPE_SYSTEM,  \
   .defer_mode = MALI_CS_DEFER_MODE_DEFER_IMMEDIATE,  \
   .opcode = MALI_CS_OPCODE_SYNC_ADD64

#define MALI_CS_SYNC_ADD64_LENGTH 8
struct mali_cs_sync_add64_packed { uint32_t opaque[2]; };
#define MALI_CS_SYNC_ADD64_PACKED_T struct mali_cs_sync_add64_packed
#define MALI_CS_SYNC_ADD64_pack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_ADD64_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->error_propagate, 0, 0) | \
            util_bitpack_uint((__unpacked)->scope, 1, 2) | \
            util_bitpack_uint((__unpacked)->wait_mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->data, 0, 7) | \
            util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->signal_slot, 16, 19) | \
            util_bitpack_uint((__unpacked)->defer_mode, 20, 20) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SYNC_ADD64_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_ADD64_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff8) fprintf(stderr, "XXX: Invalid field of CS SYNC_ADD64 unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xe00000) fprintf(stderr, "XXX: Invalid field of CS SYNC_ADD64 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->error_propagate, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->scope, &__tmp_packed.opaque[0], 1, 2); \
   __gen_unpack_uint((__unpacked)->wait_mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->data, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->signal_slot, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->defer_mode, &__tmp_packed.opaque[0], 52, 52); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SYNC_ADD64_print(FILE *fp, const struct MALI_CS_SYNC_ADD64 * values, unsigned indent)
{
   fprintf(fp, "%*sError Propagate: %s\n", indent, "", values->error_propagate ? "true" : "false");
   fprintf(fp, "%*sScope: %s\n", indent, "", mali_cs_sync_scope_as_str(values->scope));
   fprintf(fp, "%*sWait mask: 0x%x\n", indent, "", values->wait_mask);
   fprintf(fp, "%*sData: %u\n", indent, "", values->data);
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sSignal slot: %u\n", indent, "", values->signal_slot);
   fprintf(fp, "%*sDefer Mode: %s\n", indent, "", mali_cs_defer_mode_as_str(values->defer_mode));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SYNC_SET64 {
   bool                                 error_propagate;
   enum mali_cs_sync_scope              scope;
   uint32_t                             wait_mask;
   uint32_t                             data;
   uint32_t                             address;
   uint32_t                             signal_slot;
   enum mali_cs_defer_mode              defer_mode;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SYNC_SET64_header               \
   .scope = MALI_CS_SYNC_SCOPE_SYSTEM,  \
   .defer_mode = MALI_CS_DEFER_MODE_DEFER_IMMEDIATE,  \
   .opcode = MALI_CS_OPCODE_SYNC_SET64

#define MALI_CS_SYNC_SET64_LENGTH 8
struct mali_cs_sync_set64_packed { uint32_t opaque[2]; };
#define MALI_CS_SYNC_SET64_PACKED_T struct mali_cs_sync_set64_packed
#define MALI_CS_SYNC_SET64_pack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_SET64_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->error_propagate, 0, 0) | \
            util_bitpack_uint((__unpacked)->scope, 1, 2) | \
            util_bitpack_uint((__unpacked)->wait_mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->data, 0, 7) | \
            util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->signal_slot, 16, 19) | \
            util_bitpack_uint((__unpacked)->defer_mode, 20, 20) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SYNC_SET64_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_SET64_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff8) fprintf(stderr, "XXX: Invalid field of CS SYNC_SET64 unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xe00000) fprintf(stderr, "XXX: Invalid field of CS SYNC_SET64 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->error_propagate, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->scope, &__tmp_packed.opaque[0], 1, 2); \
   __gen_unpack_uint((__unpacked)->wait_mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->data, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->signal_slot, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->defer_mode, &__tmp_packed.opaque[0], 52, 52); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SYNC_SET64_print(FILE *fp, const struct MALI_CS_SYNC_SET64 * values, unsigned indent)
{
   fprintf(fp, "%*sError Propagate: %s\n", indent, "", values->error_propagate ? "true" : "false");
   fprintf(fp, "%*sScope: %s\n", indent, "", mali_cs_sync_scope_as_str(values->scope));
   fprintf(fp, "%*sWait mask: 0x%x\n", indent, "", values->wait_mask);
   fprintf(fp, "%*sData: %u\n", indent, "", values->data);
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sSignal slot: %u\n", indent, "", values->signal_slot);
   fprintf(fp, "%*sDefer Mode: %s\n", indent, "", mali_cs_defer_mode_as_str(values->defer_mode));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SYNC_WAIT64 {
   enum mali_cs_sync_error_reject       error_reject;
   enum mali_cs_condition               condition;
   uint32_t                             data;
   uint32_t                             address;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SYNC_WAIT64_header              \
   .error_reject = MALI_CS_SYNC_ERROR_REJECT_INHERIT,  \
   .opcode = MALI_CS_OPCODE_SYNC_WAIT64

#define MALI_CS_SYNC_WAIT64_LENGTH 8
struct mali_cs_sync_wait64_packed { uint32_t opaque[2]; };
#define MALI_CS_SYNC_WAIT64_PACKED_T struct mali_cs_sync_wait64_packed
#define MALI_CS_SYNC_WAIT64_pack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_WAIT64_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->error_reject, 0, 0) | \
            util_bitpack_uint((__unpacked)->condition, 28, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->data, 0, 7) | \
            util_bitpack_uint((__unpacked)->address, 8, 15) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SYNC_WAIT64_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SYNC_WAIT64_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe) fprintf(stderr, "XXX: Invalid field of CS SYNC_WAIT64 unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff0000) fprintf(stderr, "XXX: Invalid field of CS SYNC_WAIT64 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->error_reject, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->condition, &__tmp_packed.opaque[0], 28, 31); \
   __gen_unpack_uint((__unpacked)->data, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SYNC_WAIT64_print(FILE *fp, const struct MALI_CS_SYNC_WAIT64 * values, unsigned indent)
{
   fprintf(fp, "%*sError Reject: %s\n", indent, "", mali_cs_sync_error_reject_as_str(values->error_reject));
   fprintf(fp, "%*sCondition: %s\n", indent, "", mali_cs_condition_as_str(values->condition));
   fprintf(fp, "%*sData: %u\n", indent, "", values->data);
   fprintf(fp, "%*sAddress: %u\n", indent, "", values->address);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_TRACE_POINT {
   uint32_t                             wait_mask;
   uint32_t                             base_register;
   uint32_t                             register_count;
   uint32_t                             signal_slot;
   enum mali_cs_defer_mode              defer_mode;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_TRACE_POINT_header              \
   .defer_mode = MALI_CS_DEFER_MODE_DEFER_IMMEDIATE,  \
   .opcode = MALI_CS_OPCODE_TRACE_POINT

#define MALI_CS_TRACE_POINT_LENGTH 8
struct mali_cs_trace_point_packed { uint32_t opaque[2]; };
#define MALI_CS_TRACE_POINT_PACKED_T struct mali_cs_trace_point_packed
#define MALI_CS_TRACE_POINT_pack(__packed, __unpacked) \
do { \
   MALI_CS_TRACE_POINT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->wait_mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->base_register, 0, 7) | \
            util_bitpack_uint((__unpacked)->register_count, 8, 15) | \
            util_bitpack_uint((__unpacked)->signal_slot, 16, 19) | \
            util_bitpack_uint((__unpacked)->defer_mode, 20, 20) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_TRACE_POINT_unpack(__packed, __unpacked) \
do { \
   MALI_CS_TRACE_POINT_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffff) fprintf(stderr, "XXX: Invalid field of CS TRACE_POINT unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xe00000) fprintf(stderr, "XXX: Invalid field of CS TRACE_POINT unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->wait_mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->base_register, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->register_count, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->signal_slot, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->defer_mode, &__tmp_packed.opaque[0], 52, 52); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_TRACE_POINT_print(FILE *fp, const struct MALI_CS_TRACE_POINT * values, unsigned indent)
{
   fprintf(fp, "%*sWait mask: 0x%x\n", indent, "", values->wait_mask);
   fprintf(fp, "%*sBase Register: %u\n", indent, "", values->base_register);
   fprintf(fp, "%*sRegister count: %u\n", indent, "", values->register_count);
   fprintf(fp, "%*sSignal slot: %u\n", indent, "", values->signal_slot);
   fprintf(fp, "%*sDefer Mode: %s\n", indent, "", mali_cs_defer_mode_as_str(values->defer_mode));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_UMIN32 {
   uint32_t                             source_1;
   uint32_t                             source_0;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_UMIN32_header                   \
   .opcode = MALI_CS_OPCODE_COMPARE_SELECT32

#define MALI_CS_UMIN32_LENGTH 8
struct mali_cs_umin32_packed { uint32_t opaque[2]; };
#define MALI_CS_UMIN32_PACKED_T struct mali_cs_umin32_packed
#define MALI_CS_UMIN32_pack(__packed, __unpacked) \
do { \
   MALI_CS_UMIN32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source_1, 0, 7) | \
            util_bitpack_uint((__unpacked)->source_0, 8, 15) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_UMIN32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_UMIN32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CS UMIN32 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->source_1, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->source_0, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_UMIN32_print(FILE *fp, const struct MALI_CS_UMIN32 * values, unsigned indent)
{
   fprintf(fp, "%*sSource 1: %u\n", indent, "", values->source_1);
   fprintf(fp, "%*sSource 0: %u\n", indent, "", values->source_0);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_WAIT {
   uint32_t                             wait_mask;
   enum mali_cs_progress_increment      progress_increment;
   enum mali_cs_wait_mode               wait_mode;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_WAIT_header                     \
   .progress_increment = MALI_CS_PROGRESS_INCREMENT_NO_INCREMENT,  \
   .wait_mode = MALI_CS_WAIT_MODE_IMMEDIATE,  \
   .opcode = MALI_CS_OPCODE_WAIT

#define MALI_CS_WAIT_LENGTH 8
struct mali_cs_wait_packed { uint32_t opaque[2]; };
#define MALI_CS_WAIT_PACKED_T struct mali_cs_wait_packed
#define MALI_CS_WAIT_pack(__packed, __unpacked) \
do { \
   MALI_CS_WAIT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->wait_mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->progress_increment, 0, 0) | \
            util_bitpack_uint((__unpacked)->wait_mode, 1, 1) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_WAIT_unpack(__packed, __unpacked) \
do { \
   MALI_CS_WAIT_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffff) fprintf(stderr, "XXX: Invalid field of CS WAIT unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xfffffc) fprintf(stderr, "XXX: Invalid field of CS WAIT unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->wait_mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->progress_increment, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->wait_mode, &__tmp_packed.opaque[0], 33, 33); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_WAIT_print(FILE *fp, const struct MALI_CS_WAIT * values, unsigned indent)
{
   fprintf(fp, "%*sWait mask: 0x%x\n", indent, "", values->wait_mask);
   fprintf(fp, "%*sProgress Increment: %s\n", indent, "", mali_cs_progress_increment_as_str(values->progress_increment));
   fprintf(fp, "%*sWait Mode: %s\n", indent, "", mali_cs_wait_mode_as_str(values->wait_mode));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_LOGIC_OP32 {
   enum mali_cs_logic_op                mode;
   enum mali_cs_logic_op_index          index;
   uint32_t                             source_1;
   uint32_t                             source_0;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_LOGIC_OP32_header               \
   .index = MALI_CS_LOGIC_OP_INDEX_DIRECT,  \
   .opcode = MALI_CS_OPCODE_LOGIC_OP32

#define MALI_CS_LOGIC_OP32_LENGTH 8
struct mali_cs_logic_op32_packed { uint32_t opaque[2]; };
#define MALI_CS_LOGIC_OP32_PACKED_T struct mali_cs_logic_op32_packed
#define MALI_CS_LOGIC_OP32_pack(__packed, __unpacked) \
do { \
   MALI_CS_LOGIC_OP32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->index, 4, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source_1, 0, 7) | \
            util_bitpack_uint((__unpacked)->source_0, 8, 15) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_LOGIC_OP32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_LOGIC_OP32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of CS LOGIC_OP32 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->index, &__tmp_packed.opaque[0], 4, 4); \
   __gen_unpack_uint((__unpacked)->source_1, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->source_0, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_LOGIC_OP32_print(FILE *fp, const struct MALI_CS_LOGIC_OP32 * values, unsigned indent)
{
   fprintf(fp, "%*sMode: %s\n", indent, "", mali_cs_logic_op_as_str(values->mode));
   fprintf(fp, "%*sIndex: %s\n", indent, "", mali_cs_logic_op_index_as_str(values->index));
   fprintf(fp, "%*sSource 1: %u\n", indent, "", values->source_1);
   fprintf(fp, "%*sSource 0: %u\n", indent, "", values->source_0);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_MOVE_REG32 {
   enum mali_cs_logic_op                mode;
   enum mali_cs_logic_op_index          index;
   uint32_t                             source;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_MOVE_REG32_header               \
   .mode = MALI_CS_LOGIC_OP_MOV_A,  \
   .index = MALI_CS_LOGIC_OP_INDEX_DIRECT,  \
   .opcode = MALI_CS_OPCODE_LOGIC_OP32

#define MALI_CS_MOVE_REG32_LENGTH 8
struct mali_cs_move_reg32_packed { uint32_t opaque[2]; };
#define MALI_CS_MOVE_REG32_PACKED_T struct mali_cs_move_reg32_packed
#define MALI_CS_MOVE_REG32_pack(__packed, __unpacked) \
do { \
   MALI_CS_MOVE_REG32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->index, 4, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source, 8, 15) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_MOVE_REG32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_MOVE_REG32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of CS MOVE_REG32 unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff) fprintf(stderr, "XXX: Invalid field of CS MOVE_REG32 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->index, &__tmp_packed.opaque[0], 4, 4); \
   __gen_unpack_uint((__unpacked)->source, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_MOVE_REG32_print(FILE *fp, const struct MALI_CS_MOVE_REG32 * values, unsigned indent)
{
   fprintf(fp, "%*sMode: %s\n", indent, "", mali_cs_logic_op_as_str(values->mode));
   fprintf(fp, "%*sIndex: %s\n", indent, "", mali_cs_logic_op_index_as_str(values->index));
   fprintf(fp, "%*sSource: %u\n", indent, "", values->source);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_AND32 {
   enum mali_cs_logic_op                mode;
   enum mali_cs_logic_op_index          index;
   uint32_t                             source_1;
   uint32_t                             source_0;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_AND32_header                    \
   .mode = MALI_CS_LOGIC_OP_AND,  \
   .index = MALI_CS_LOGIC_OP_INDEX_DIRECT,  \
   .opcode = MALI_CS_OPCODE_LOGIC_OP32

#define MALI_CS_AND32_LENGTH 8
struct mali_cs_and32_packed { uint32_t opaque[2]; };
#define MALI_CS_AND32_PACKED_T struct mali_cs_and32_packed
#define MALI_CS_AND32_pack(__packed, __unpacked) \
do { \
   MALI_CS_AND32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->index, 4, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source_1, 0, 7) | \
            util_bitpack_uint((__unpacked)->source_0, 8, 15) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_AND32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_AND32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of CS AND32 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->index, &__tmp_packed.opaque[0], 4, 4); \
   __gen_unpack_uint((__unpacked)->source_1, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->source_0, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_AND32_print(FILE *fp, const struct MALI_CS_AND32 * values, unsigned indent)
{
   fprintf(fp, "%*sMode: %s\n", indent, "", mali_cs_logic_op_as_str(values->mode));
   fprintf(fp, "%*sIndex: %s\n", indent, "", mali_cs_logic_op_index_as_str(values->index));
   fprintf(fp, "%*sSource 1: %u\n", indent, "", values->source_1);
   fprintf(fp, "%*sSource 0: %u\n", indent, "", values->source_0);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_XOR32 {
   enum mali_cs_logic_op                mode;
   enum mali_cs_logic_op_index          index;
   uint32_t                             source_1;
   uint32_t                             source_0;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_XOR32_header                    \
   .mode = MALI_CS_LOGIC_OP_XOR,  \
   .index = MALI_CS_LOGIC_OP_INDEX_DIRECT,  \
   .opcode = MALI_CS_OPCODE_LOGIC_OP32

#define MALI_CS_XOR32_LENGTH 8
struct mali_cs_xor32_packed { uint32_t opaque[2]; };
#define MALI_CS_XOR32_PACKED_T struct mali_cs_xor32_packed
#define MALI_CS_XOR32_pack(__packed, __unpacked) \
do { \
   MALI_CS_XOR32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->index, 4, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source_1, 0, 7) | \
            util_bitpack_uint((__unpacked)->source_0, 8, 15) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_XOR32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_XOR32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of CS XOR32 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->index, &__tmp_packed.opaque[0], 4, 4); \
   __gen_unpack_uint((__unpacked)->source_1, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->source_0, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_XOR32_print(FILE *fp, const struct MALI_CS_XOR32 * values, unsigned indent)
{
   fprintf(fp, "%*sMode: %s\n", indent, "", mali_cs_logic_op_as_str(values->mode));
   fprintf(fp, "%*sIndex: %s\n", indent, "", mali_cs_logic_op_index_as_str(values->index));
   fprintf(fp, "%*sSource 1: %u\n", indent, "", values->source_1);
   fprintf(fp, "%*sSource 0: %u\n", indent, "", values->source_0);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_OR32 {
   enum mali_cs_logic_op                mode;
   enum mali_cs_logic_op_index          index;
   uint32_t                             source_1;
   uint32_t                             source_0;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_OR32_header                     \
   .mode = MALI_CS_LOGIC_OP_OR,  \
   .index = MALI_CS_LOGIC_OP_INDEX_DIRECT,  \
   .opcode = MALI_CS_OPCODE_LOGIC_OP32

#define MALI_CS_OR32_LENGTH 8
struct mali_cs_or32_packed { uint32_t opaque[2]; };
#define MALI_CS_OR32_PACKED_T struct mali_cs_or32_packed
#define MALI_CS_OR32_pack(__packed, __unpacked) \
do { \
   MALI_CS_OR32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->index, 4, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source_1, 0, 7) | \
            util_bitpack_uint((__unpacked)->source_0, 8, 15) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_OR32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_OR32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of CS OR32 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->index, &__tmp_packed.opaque[0], 4, 4); \
   __gen_unpack_uint((__unpacked)->source_1, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->source_0, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_OR32_print(FILE *fp, const struct MALI_CS_OR32 * values, unsigned indent)
{
   fprintf(fp, "%*sMode: %s\n", indent, "", mali_cs_logic_op_as_str(values->mode));
   fprintf(fp, "%*sIndex: %s\n", indent, "", mali_cs_logic_op_index_as_str(values->index));
   fprintf(fp, "%*sSource 1: %u\n", indent, "", values->source_1);
   fprintf(fp, "%*sSource 0: %u\n", indent, "", values->source_0);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_NOT32 {
   enum mali_cs_logic_op                mode;
   enum mali_cs_logic_op_index          index;
   uint32_t                             source;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_NOT32_header                    \
   .mode = MALI_CS_LOGIC_OP_NOT_A,  \
   .index = MALI_CS_LOGIC_OP_INDEX_DIRECT,  \
   .opcode = MALI_CS_OPCODE_LOGIC_OP32

#define MALI_CS_NOT32_LENGTH 8
struct mali_cs_not32_packed { uint32_t opaque[2]; };
#define MALI_CS_NOT32_PACKED_T struct mali_cs_not32_packed
#define MALI_CS_NOT32_pack(__packed, __unpacked) \
do { \
   MALI_CS_NOT32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->index, 4, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source, 8, 15) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_NOT32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_NOT32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of CS NOT32 unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff) fprintf(stderr, "XXX: Invalid field of CS NOT32 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->index, &__tmp_packed.opaque[0], 4, 4); \
   __gen_unpack_uint((__unpacked)->source, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_NOT32_print(FILE *fp, const struct MALI_CS_NOT32 * values, unsigned indent)
{
   fprintf(fp, "%*sMode: %s\n", indent, "", mali_cs_logic_op_as_str(values->mode));
   fprintf(fp, "%*sIndex: %s\n", indent, "", mali_cs_logic_op_index_as_str(values->index));
   fprintf(fp, "%*sSource: %u\n", indent, "", values->source);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_BIT_SET32 {
   enum mali_cs_logic_op                mode;
   enum mali_cs_logic_op_index          index;
   uint32_t                             source_1;
   uint32_t                             source_0;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_BIT_SET32_header                \
   .mode = MALI_CS_LOGIC_OP_OR,  \
   .index = MALI_CS_LOGIC_OP_INDEX_INDEX,  \
   .opcode = MALI_CS_OPCODE_LOGIC_OP32

#define MALI_CS_BIT_SET32_LENGTH 8
struct mali_cs_bit_set32_packed { uint32_t opaque[2]; };
#define MALI_CS_BIT_SET32_PACKED_T struct mali_cs_bit_set32_packed
#define MALI_CS_BIT_SET32_pack(__packed, __unpacked) \
do { \
   MALI_CS_BIT_SET32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->index, 4, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source_1, 0, 7) | \
            util_bitpack_uint((__unpacked)->source_0, 8, 15) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_BIT_SET32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_BIT_SET32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of CS BIT_SET32 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->index, &__tmp_packed.opaque[0], 4, 4); \
   __gen_unpack_uint((__unpacked)->source_1, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->source_0, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_BIT_SET32_print(FILE *fp, const struct MALI_CS_BIT_SET32 * values, unsigned indent)
{
   fprintf(fp, "%*sMode: %s\n", indent, "", mali_cs_logic_op_as_str(values->mode));
   fprintf(fp, "%*sIndex: %s\n", indent, "", mali_cs_logic_op_index_as_str(values->index));
   fprintf(fp, "%*sSource 1: %u\n", indent, "", values->source_1);
   fprintf(fp, "%*sSource 0: %u\n", indent, "", values->source_0);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_BIT_CLEAR32 {
   enum mali_cs_logic_op                mode;
   enum mali_cs_logic_op_index          index;
   uint32_t                             source_1;
   uint32_t                             source_0;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_BIT_CLEAR32_header              \
   .mode = MALI_CS_LOGIC_OP_AND_A_NB,  \
   .index = MALI_CS_LOGIC_OP_INDEX_INDEX,  \
   .opcode = MALI_CS_OPCODE_LOGIC_OP32

#define MALI_CS_BIT_CLEAR32_LENGTH 8
struct mali_cs_bit_clear32_packed { uint32_t opaque[2]; };
#define MALI_CS_BIT_CLEAR32_PACKED_T struct mali_cs_bit_clear32_packed
#define MALI_CS_BIT_CLEAR32_pack(__packed, __unpacked) \
do { \
   MALI_CS_BIT_CLEAR32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->index, 4, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->source_1, 0, 7) | \
            util_bitpack_uint((__unpacked)->source_0, 8, 15) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_BIT_CLEAR32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_BIT_CLEAR32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of CS BIT_CLEAR32 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->index, &__tmp_packed.opaque[0], 4, 4); \
   __gen_unpack_uint((__unpacked)->source_1, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->source_0, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_BIT_CLEAR32_print(FILE *fp, const struct MALI_CS_BIT_CLEAR32 * values, unsigned indent)
{
   fprintf(fp, "%*sMode: %s\n", indent, "", mali_cs_logic_op_as_str(values->mode));
   fprintf(fp, "%*sIndex: %s\n", indent, "", mali_cs_logic_op_index_as_str(values->index));
   fprintf(fp, "%*sSource 1: %u\n", indent, "", values->source_1);
   fprintf(fp, "%*sSource 0: %u\n", indent, "", values->source_0);
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_NEXT_SB_ENTRY {
   enum mali_cs_scoreboard_type         sb_type;
   enum mali_cs_next_sb_entry_format    format;
   uint32_t                             destination;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_NEXT_SB_ENTRY_header            \
   .sb_type = MALI_CS_SCOREBOARD_TYPE_NO_CHANGE,  \
   .format = MALI_CS_NEXT_SB_ENTRY_FORMAT_INDEX,  \
   .opcode = MALI_CS_OPCODE_NEXT_SB_ENTRY

#define MALI_CS_NEXT_SB_ENTRY_LENGTH 8
struct mali_cs_next_sb_entry_packed { uint32_t opaque[2]; };
#define MALI_CS_NEXT_SB_ENTRY_PACKED_T struct mali_cs_next_sb_entry_packed
#define MALI_CS_NEXT_SB_ENTRY_pack(__packed, __unpacked) \
do { \
   MALI_CS_NEXT_SB_ENTRY_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->sb_type, 0, 3) | \
            util_bitpack_uint((__unpacked)->format, 4, 4) | \
            util_bitpack_uint((__unpacked)->destination, 16, 23) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_NEXT_SB_ENTRY_unpack(__packed, __unpacked) \
do { \
   MALI_CS_NEXT_SB_ENTRY_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CS NEXT_SB_ENTRY unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffe0) fprintf(stderr, "XXX: Invalid field of CS NEXT_SB_ENTRY unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->sb_type, &__tmp_packed.opaque[0], 32, 35); \
   __gen_unpack_uint((__unpacked)->format, &__tmp_packed.opaque[0], 36, 36); \
   __gen_unpack_uint((__unpacked)->destination, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_NEXT_SB_ENTRY_print(FILE *fp, const struct MALI_CS_NEXT_SB_ENTRY * values, unsigned indent)
{
   fprintf(fp, "%*sSB Type: %s\n", indent, "", mali_cs_scoreboard_type_as_str(values->sb_type));
   fprintf(fp, "%*sFormat: %s\n", indent, "", mali_cs_next_sb_entry_format_as_str(values->format));
   fprintf(fp, "%*sDestination: %u\n", indent, "", values->destination);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SET_STATE {
   enum mali_cs_set_state_type          state;
   uint32_t                             source;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SET_STATE_header                \
   .opcode = MALI_CS_OPCODE_SET_STATE

#define MALI_CS_SET_STATE_LENGTH 8
struct mali_cs_set_state_packed { uint32_t opaque[2]; };
#define MALI_CS_SET_STATE_PACKED_T struct mali_cs_set_state_packed
#define MALI_CS_SET_STATE_pack(__packed, __unpacked) \
do { \
   MALI_CS_SET_STATE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->state, 0, 7) | \
            util_bitpack_uint((__unpacked)->source, 8, 15) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SET_STATE_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SET_STATE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CS SET_STATE unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xff0000) fprintf(stderr, "XXX: Invalid field of CS SET_STATE unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->state, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->source, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SET_STATE_print(FILE *fp, const struct MALI_CS_SET_STATE * values, unsigned indent)
{
   fprintf(fp, "%*sState: %s\n", indent, "", mali_cs_set_state_type_as_str(values->state));
   fprintf(fp, "%*sSource: %u\n", indent, "", values->source);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SET_STATE_IMM32 {
   uint64_t                             value;
   enum mali_cs_set_state_type          state;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SET_STATE_IMM32_header          \
   .opcode = MALI_CS_OPCODE_SET_STATE_IMM32

#define MALI_CS_SET_STATE_IMM32_LENGTH 8
struct mali_cs_set_state_imm32_packed { uint32_t opaque[2]; };
#define MALI_CS_SET_STATE_IMM32_PACKED_T struct mali_cs_set_state_imm32_packed
#define MALI_CS_SET_STATE_IMM32_pack(__packed, __unpacked) \
do { \
   MALI_CS_SET_STATE_IMM32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->value, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->state, 0, 7) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SET_STATE_IMM32_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SET_STATE_IMM32_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xffff00) fprintf(stderr, "XXX: Invalid field of CS SET_STATE_IMM32 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->value, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->state, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SET_STATE_IMM32_print(FILE *fp, const struct MALI_CS_SET_STATE_IMM32 * values, unsigned indent)
{
   fprintf(fp, "%*sValue: 0x%" PRIx64 "\n", indent, "", values->value);
   fprintf(fp, "%*sState: %s\n", indent, "", mali_cs_set_state_type_as_str(values->state));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SHARED_SB_DEC {
   enum mali_cs_progress_increment      progress_increment;
   uint32_t                             shared_entry;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SHARED_SB_DEC_header            \
   .progress_increment = MALI_CS_PROGRESS_INCREMENT_NO_INCREMENT,  \
   .opcode = MALI_CS_OPCODE_SHARED_SB_DEC

#define MALI_CS_SHARED_SB_DEC_LENGTH 8
struct mali_cs_shared_sb_dec_packed { uint32_t opaque[2]; };
#define MALI_CS_SHARED_SB_DEC_PACKED_T struct mali_cs_shared_sb_dec_packed
#define MALI_CS_SHARED_SB_DEC_pack(__packed, __unpacked) \
do { \
   MALI_CS_SHARED_SB_DEC_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->progress_increment, 0, 0) | \
            util_bitpack_uint((__unpacked)->shared_entry, 16, 19) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SHARED_SB_DEC_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SHARED_SB_DEC_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CS SHARED_SB_DEC unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf0fffe) fprintf(stderr, "XXX: Invalid field of CS SHARED_SB_DEC unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->progress_increment, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->shared_entry, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SHARED_SB_DEC_print(FILE *fp, const struct MALI_CS_SHARED_SB_DEC * values, unsigned indent)
{
   fprintf(fp, "%*sProgress Increment: %s\n", indent, "", mali_cs_progress_increment_as_str(values->progress_increment));
   fprintf(fp, "%*sShared Entry: %u\n", indent, "", values->shared_entry);
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_SHARED_SB_INC {
   uint32_t                             sb_mask;
   enum mali_cs_progress_increment      progress_increment;
   uint32_t                             shared_entry;
   enum mali_cs_shared_sb_increment_defer_mode defer_mode;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_SHARED_SB_INC_header            \
   .progress_increment = MALI_CS_PROGRESS_INCREMENT_NO_INCREMENT,  \
   .defer_mode = MALI_CS_SHARED_SB_INCREMENT_DEFER_MODE_DEFER_IMMEDIATE,  \
   .opcode = MALI_CS_OPCODE_SHARED_SB_INC

#define MALI_CS_SHARED_SB_INC_LENGTH 8
struct mali_cs_shared_sb_inc_packed { uint32_t opaque[2]; };
#define MALI_CS_SHARED_SB_INC_PACKED_T struct mali_cs_shared_sb_inc_packed
#define MALI_CS_SHARED_SB_INC_pack(__packed, __unpacked) \
do { \
   MALI_CS_SHARED_SB_INC_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->sb_mask, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->progress_increment, 0, 0) | \
            util_bitpack_uint((__unpacked)->shared_entry, 16, 19) | \
            util_bitpack_uint((__unpacked)->defer_mode, 20, 20) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_SHARED_SB_INC_unpack(__packed, __unpacked) \
do { \
   MALI_CS_SHARED_SB_INC_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffff) fprintf(stderr, "XXX: Invalid field of CS SHARED_SB_INC unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xe0fffe) fprintf(stderr, "XXX: Invalid field of CS SHARED_SB_INC unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->sb_mask, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->progress_increment, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->shared_entry, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->defer_mode, &__tmp_packed.opaque[0], 52, 52); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_SHARED_SB_INC_print(FILE *fp, const struct MALI_CS_SHARED_SB_INC * values, unsigned indent)
{
   fprintf(fp, "%*sSB Mask: 0x%x\n", indent, "", values->sb_mask);
   fprintf(fp, "%*sProgress Increment: %s\n", indent, "", mali_cs_progress_increment_as_str(values->progress_increment));
   fprintf(fp, "%*sShared Entry: %u\n", indent, "", values->shared_entry);
   fprintf(fp, "%*sDefer Mode: %s\n", indent, "", mali_cs_shared_sb_increment_defer_mode_as_str(values->defer_mode));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
struct MALI_CS_RUN_IDVS2 {
   uint64_t                             flags_override;
   enum mali_cs_progress_increment      progress_increment;
   enum mali_cs_memory_allocation_enable malloc_enable;
   enum mali_cs_draw_id_register_enable draw_id_register_enable;
   enum mali_idvs_shading_mode          vertex_shading_mode;
   uint32_t                             draw_id;
   enum mali_idvs_pipeline_stage        stage;
   enum mali_cs_opcode                  opcode;
};

#define MALI_CS_RUN_IDVS2_header                \
   .progress_increment = MALI_CS_PROGRESS_INCREMENT_NO_INCREMENT,  \
   .malloc_enable = MALI_CS_MEMORY_ALLOCATION_ENABLE_NO_MALLOC,  \
   .draw_id_register_enable = MALI_CS_DRAW_ID_REGISTER_ENABLE_NO_DRAWID,  \
   .vertex_shading_mode = MALI_IDVS_SHADING_MODE_EARLY,  \
   .stage = MALI_IDVS_PIPELINE_STAGE_INTERNAL,  \
   .opcode = MALI_CS_OPCODE_RUN_IDVS2

#define MALI_CS_RUN_IDVS2_LENGTH 8
struct mali_cs_run_idvs2_packed { uint32_t opaque[2]; };
#define MALI_CS_RUN_IDVS2_PACKED_T struct mali_cs_run_idvs2_packed
#define MALI_CS_RUN_IDVS2_pack(__packed, __unpacked) \
do { \
   MALI_CS_RUN_IDVS2_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->flags_override, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->progress_increment, 0, 0) | \
            util_bitpack_uint((__unpacked)->malloc_enable, 1, 1) | \
            util_bitpack_uint((__unpacked)->draw_id_register_enable, 2, 2) | \
            util_bitpack_uint((__unpacked)->vertex_shading_mode, 3, 4) | \
            util_bitpack_uint((__unpacked)->draw_id, 8, 15) | \
            util_bitpack_uint((__unpacked)->stage, 16, 19) | \
            util_bitpack_uint((__unpacked)->opcode, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CS_RUN_IDVS2_unpack(__packed, __unpacked) \
do { \
   MALI_CS_RUN_IDVS2_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xf000e0) fprintf(stderr, "XXX: Invalid field of CS RUN_IDVS2 unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->flags_override, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->progress_increment, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->malloc_enable, &__tmp_packed.opaque[0], 33, 33); \
   __gen_unpack_uint((__unpacked)->draw_id_register_enable, &__tmp_packed.opaque[0], 34, 34); \
   __gen_unpack_uint((__unpacked)->vertex_shading_mode, &__tmp_packed.opaque[0], 35, 36); \
   __gen_unpack_uint((__unpacked)->draw_id, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->stage, &__tmp_packed.opaque[0], 48, 51); \
   __gen_unpack_uint((__unpacked)->opcode, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CS_RUN_IDVS2_print(FILE *fp, const struct MALI_CS_RUN_IDVS2 * values, unsigned indent)
{
   fprintf(fp, "%*sFlags Override: 0x%" PRIx64 "\n", indent, "", values->flags_override);
   fprintf(fp, "%*sProgress Increment: %s\n", indent, "", mali_cs_progress_increment_as_str(values->progress_increment));
   fprintf(fp, "%*sMalloc Enable: %s\n", indent, "", mali_cs_memory_allocation_enable_as_str(values->malloc_enable));
   fprintf(fp, "%*sDraw ID Register Enable: %s\n", indent, "", mali_cs_draw_id_register_enable_as_str(values->draw_id_register_enable));
   fprintf(fp, "%*sVertex Shading Mode: %s\n", indent, "", mali_idvs_shading_mode_as_str(values->vertex_shading_mode));
   fprintf(fp, "%*sDraw ID: %u\n", indent, "", values->draw_id);
   fprintf(fp, "%*sStage: %s\n", indent, "", mali_idvs_pipeline_stage_as_str(values->stage));
   fprintf(fp, "%*sOpcode: %s\n", indent, "", mali_cs_opcode_as_str(values->opcode));
}

#endif
enum mali_compute_sr {
        MALI_COMPUTE_SR_SRT_0                =      0,
        MALI_COMPUTE_SR_SRT_1                =      2,
        MALI_COMPUTE_SR_SRT_2                =      4,
        MALI_COMPUTE_SR_SRT_3                =      6,
        MALI_COMPUTE_SR_FAU_0                =      8,
        MALI_COMPUTE_SR_FAU_1                =     10,
        MALI_COMPUTE_SR_FAU_2                =     12,
        MALI_COMPUTE_SR_FAU_3                =     14,
        MALI_COMPUTE_SR_SPD_0                =     16,
        MALI_COMPUTE_SR_SPD_1                =     18,
        MALI_COMPUTE_SR_SPD_2                =     20,
        MALI_COMPUTE_SR_SPD_3                =     22,
        MALI_COMPUTE_SR_TSD_0                =     24,
        MALI_COMPUTE_SR_TSD_1                =     26,
        MALI_COMPUTE_SR_TSD_2                =     28,
        MALI_COMPUTE_SR_TSD_3                =     30,
        MALI_COMPUTE_SR_GLOBAL_ATTRIBUTE_OFFSET =     32,
        MALI_COMPUTE_SR_WG_SIZE              =     33,
        MALI_COMPUTE_SR_JOB_OFFSET_X         =     34,
        MALI_COMPUTE_SR_JOB_OFFSET_Y         =     35,
        MALI_COMPUTE_SR_JOB_OFFSET_Z         =     36,
        MALI_COMPUTE_SR_JOB_SIZE_X           =     37,
        MALI_COMPUTE_SR_JOB_SIZE_Y           =     38,
        MALI_COMPUTE_SR_JOB_SIZE_Z           =     39,
        MALI_COMPUTE_SR_ITER_TRACE_ID0       =     62,
        MALI_COMPUTE_SR_ITER_TRACE_ID1       =     63,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_compute_sr_as_str(enum mali_compute_sr imm)
{
    switch (imm) {
    case MALI_COMPUTE_SR_SRT_0: return "SRT_0";
    case MALI_COMPUTE_SR_SRT_1: return "SRT_1";
    case MALI_COMPUTE_SR_SRT_2: return "SRT_2";
    case MALI_COMPUTE_SR_SRT_3: return "SRT_3";
    case MALI_COMPUTE_SR_FAU_0: return "FAU_0";
    case MALI_COMPUTE_SR_FAU_1: return "FAU_1";
    case MALI_COMPUTE_SR_FAU_2: return "FAU_2";
    case MALI_COMPUTE_SR_FAU_3: return "FAU_3";
    case MALI_COMPUTE_SR_SPD_0: return "SPD_0";
    case MALI_COMPUTE_SR_SPD_1: return "SPD_1";
    case MALI_COMPUTE_SR_SPD_2: return "SPD_2";
    case MALI_COMPUTE_SR_SPD_3: return "SPD_3";
    case MALI_COMPUTE_SR_TSD_0: return "TSD_0";
    case MALI_COMPUTE_SR_TSD_1: return "TSD_1";
    case MALI_COMPUTE_SR_TSD_2: return "TSD_2";
    case MALI_COMPUTE_SR_TSD_3: return "TSD_3";
    case MALI_COMPUTE_SR_GLOBAL_ATTRIBUTE_OFFSET: return "GLOBAL_ATTRIBUTE_OFFSET";
    case MALI_COMPUTE_SR_WG_SIZE: return "WG_SIZE";
    case MALI_COMPUTE_SR_JOB_OFFSET_X: return "JOB_OFFSET_X";
    case MALI_COMPUTE_SR_JOB_OFFSET_Y: return "JOB_OFFSET_Y";
    case MALI_COMPUTE_SR_JOB_OFFSET_Z: return "JOB_OFFSET_Z";
    case MALI_COMPUTE_SR_JOB_SIZE_X: return "JOB_SIZE_X";
    case MALI_COMPUTE_SR_JOB_SIZE_Y: return "JOB_SIZE_Y";
    case MALI_COMPUTE_SR_JOB_SIZE_Z: return "JOB_SIZE_Z";
    case MALI_COMPUTE_SR_ITER_TRACE_ID0: return "ITER_TRACE_ID0";
    case MALI_COMPUTE_SR_ITER_TRACE_ID1: return "ITER_TRACE_ID1";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_idvs_sr {
        MALI_IDVS_SR_VERTEX_SRT              =      0,
        MALI_IDVS_SR_FRAGMENT_SRT            =      2,
        MALI_IDVS_SR_VERTEX_FAU              =      8,
        MALI_IDVS_SR_FRAGMENT_FAU            =     10,
        MALI_IDVS_SR_VERTEX_SPD              =     16,
        MALI_IDVS_SR_FRAGMENT_SPD            =     18,
        MALI_IDVS_SR_VERTEX_TSD              =     24,
        MALI_IDVS_SR_FRAGMENT_TSD            =     26,
        MALI_IDVS_SR_GLOBAL_ATTRIBUTE_OFFSET =     32,
        MALI_IDVS_SR_INDEX_COUNT             =     33,
        MALI_IDVS_SR_INSTANCE_COUNT          =     34,
        MALI_IDVS_SR_INDEX_OFFSET            =     35,
        MALI_IDVS_SR_VERTEX_OFFSET           =     36,
        MALI_IDVS_SR_INSTANCE_OFFSET         =     37,
        MALI_IDVS_SR_TILER_CTX               =     40,
        MALI_IDVS_SR_SCISSOR_BOX             =     42,
        MALI_IDVS_SR_VIEWPORT_HIGH           =     44,
        MALI_IDVS_SR_VIEWPORT_LOW            =     46,
        MALI_IDVS_SR_INDEX_BUFFER            =     48,
        MALI_IDVS_SR_INDEX_BUFFER_SIZE       =     50,
        MALI_IDVS_SR_VARY_SIZE               =     51,
        MALI_IDVS_SR_ZSD                     =     52,
        MALI_IDVS_SR_BLEND_DESC              =     54,
        MALI_IDVS_SR_TILER_FLAGS             =     56,
        MALI_IDVS_SR_DCD0                    =     57,
        MALI_IDVS_SR_DCD1                    =     58,
        MALI_IDVS_SR_DCD2                    =     59,
        MALI_IDVS_SR_PRIMITIVE_SIZE          =     60,
        MALI_IDVS_SR_TILER_FLAGS2            =     61,
        MALI_IDVS_SR_ITER_TRACE_ID0          =     62,
        MALI_IDVS_SR_ITER_TRACE_ID1          =     63,
        MALI_IDVS_SR_OQ                      =     64,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_idvs_sr_as_str(enum mali_idvs_sr imm)
{
    switch (imm) {
    case MALI_IDVS_SR_VERTEX_SRT: return "VERTEX_SRT";
    case MALI_IDVS_SR_FRAGMENT_SRT: return "FRAGMENT_SRT";
    case MALI_IDVS_SR_VERTEX_FAU: return "VERTEX_FAU";
    case MALI_IDVS_SR_FRAGMENT_FAU: return "FRAGMENT_FAU";
    case MALI_IDVS_SR_VERTEX_SPD: return "VERTEX_SPD";
    case MALI_IDVS_SR_FRAGMENT_SPD: return "FRAGMENT_SPD";
    case MALI_IDVS_SR_VERTEX_TSD: return "VERTEX_TSD";
    case MALI_IDVS_SR_FRAGMENT_TSD: return "FRAGMENT_TSD";
    case MALI_IDVS_SR_GLOBAL_ATTRIBUTE_OFFSET: return "GLOBAL_ATTRIBUTE_OFFSET";
    case MALI_IDVS_SR_INDEX_COUNT: return "INDEX_COUNT";
    case MALI_IDVS_SR_INSTANCE_COUNT: return "INSTANCE_COUNT";
    case MALI_IDVS_SR_INDEX_OFFSET: return "INDEX_OFFSET";
    case MALI_IDVS_SR_VERTEX_OFFSET: return "VERTEX_OFFSET";
    case MALI_IDVS_SR_INSTANCE_OFFSET: return "INSTANCE_OFFSET";
    case MALI_IDVS_SR_TILER_CTX: return "TILER_CTX";
    case MALI_IDVS_SR_SCISSOR_BOX: return "SCISSOR_BOX";
    case MALI_IDVS_SR_VIEWPORT_HIGH: return "VIEWPORT_HIGH";
    case MALI_IDVS_SR_VIEWPORT_LOW: return "VIEWPORT_LOW";
    case MALI_IDVS_SR_INDEX_BUFFER: return "INDEX_BUFFER";
    case MALI_IDVS_SR_INDEX_BUFFER_SIZE: return "INDEX_BUFFER_SIZE";
    case MALI_IDVS_SR_VARY_SIZE: return "VARY_SIZE";
    case MALI_IDVS_SR_ZSD: return "ZSD";
    case MALI_IDVS_SR_BLEND_DESC: return "BLEND_DESC";
    case MALI_IDVS_SR_TILER_FLAGS: return "TILER_FLAGS";
    case MALI_IDVS_SR_DCD0: return "DCD0";
    case MALI_IDVS_SR_DCD1: return "DCD1";
    case MALI_IDVS_SR_DCD2: return "DCD2";
    case MALI_IDVS_SR_PRIMITIVE_SIZE: return "PRIMITIVE_SIZE";
    case MALI_IDVS_SR_TILER_FLAGS2: return "TILER_FLAGS2";
    case MALI_IDVS_SR_ITER_TRACE_ID0: return "ITER_TRACE_ID0";
    case MALI_IDVS_SR_ITER_TRACE_ID1: return "ITER_TRACE_ID1";
    case MALI_IDVS_SR_OQ: return "OQ";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_fragment_sr {
        MALI_FRAGMENT_SR_FBD_POINTER         =     40,
        MALI_FRAGMENT_SR_BBOX_MIN            =     42,
        MALI_FRAGMENT_SR_BBOX_MAX            =     43,
        MALI_FRAGMENT_SR_TEM_POINTER         =     44,
        MALI_FRAGMENT_SR_TEM_ROW_STRIDE      =     46,
        MALI_FRAGMENT_SR_ITER_TRACE_ID0      =     62,
        MALI_FRAGMENT_SR_ITER_TRACE_ID1      =     63,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_fragment_sr_as_str(enum mali_fragment_sr imm)
{
    switch (imm) {
    case MALI_FRAGMENT_SR_FBD_POINTER: return "FBD_POINTER";
    case MALI_FRAGMENT_SR_BBOX_MIN: return "BBOX_MIN";
    case MALI_FRAGMENT_SR_BBOX_MAX: return "BBOX_MAX";
    case MALI_FRAGMENT_SR_TEM_POINTER: return "TEM_POINTER";
    case MALI_FRAGMENT_SR_TEM_ROW_STRIDE: return "TEM_ROW_STRIDE";
    case MALI_FRAGMENT_SR_ITER_TRACE_ID0: return "ITER_TRACE_ID0";
    case MALI_FRAGMENT_SR_ITER_TRACE_ID1: return "ITER_TRACE_ID1";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_DESCRIPTOR_HEADER {
   enum mali_descriptor_type            type;
   uint32_t                             ignore;
};

#define MALI_DESCRIPTOR_HEADER_header           \
   .type = MALI_DESCRIPTOR_TYPE_NULL

#define MALI_DESCRIPTOR_HEADER_LENGTH 4
#define MALI_DESCRIPTOR_HEADER_ALIGN 32
struct mali_descriptor_header_packed { uint32_t opaque[1]; };
#define MALI_DESCRIPTOR_HEADER_PACKED_T struct mali_descriptor_header_packed
#define MALI_DESCRIPTOR_HEADER_pack(__packed, __unpacked) \
do { \
   MALI_DESCRIPTOR_HEADER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->ignore, 4, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DESCRIPTOR_HEADER_unpack(__packed, __unpacked) \
do { \
   MALI_DESCRIPTOR_HEADER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->ignore, &__tmp_packed.opaque[0], 4, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DESCRIPTOR_HEADER_print(FILE *fp, const struct MALI_DESCRIPTOR_HEADER * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sIgnore: %u\n", indent, "", values->ignore);
}

#endif
struct MALI_NULL_DESCRIPTOR {
   enum mali_descriptor_type            type;
};

#define MALI_NULL_DESCRIPTOR_header             \
   .type = MALI_DESCRIPTOR_TYPE_NULL

#define MALI_NULL_DESCRIPTOR_LENGTH 32
#define MALI_NULL_DESCRIPTOR_ALIGN 32
struct mali_null_descriptor_packed { uint32_t opaque[8]; };
#define MALI_NULL_DESCRIPTOR_PACKED_T struct mali_null_descriptor_packed
#define MALI_NULL_DESCRIPTOR_pack(__packed, __unpacked) \
do { \
   MALI_NULL_DESCRIPTOR_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_NULL_DESCRIPTOR_unpack(__packed, __unpacked) \
do { \
   MALI_NULL_DESCRIPTOR_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfffffff0) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Descriptor unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_NULL_DESCRIPTOR_print(FILE *fp, const struct MALI_NULL_DESCRIPTOR * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
}

#endif
struct MALI_ATTRIBUTE {
   enum mali_descriptor_type            type;
   enum mali_attribute_type             attribute_type;
   bool                                 offset_enable;
   uint32_t                             format;
   uint32_t                             table;
   enum mali_attribute_frequency        frequency;
   uint32_t                             divisor_r;
   uint32_t                             divisor_e;
   int64_t                              offset;
   uint64_t                             buffer_index;
   uint64_t                             stride;
   uint32_t                             attribute_stride;
   uint32_t                             packet_stride;
   uint64_t                             divisor_d;
};

#define MALI_ATTRIBUTE_header                   \
   .type = MALI_DESCRIPTOR_TYPE_ATTRIBUTE

#define MALI_ATTRIBUTE_LENGTH 32
#define MALI_ATTRIBUTE_ALIGN 32
struct mali_attribute_packed { uint32_t opaque[8]; };
#define MALI_ATTRIBUTE_PACKED_T struct mali_attribute_packed
#define MALI_ATTRIBUTE_pack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->attribute_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->offset_enable, 8, 8) | \
            util_bitpack_uint((__unpacked)->format, 10, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->table, 0, 5) | \
            util_bitpack_uint((__unpacked)->frequency, 6, 7) | \
            util_bitpack_uint((__unpacked)->divisor_r, 24, 28) | \
            util_bitpack_uint((__unpacked)->divisor_e, 29, 29); \
   __tmp_packed.opaque[ 2] = util_bitpack_sint((__unpacked)->offset, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->buffer_index, 0, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->attribute_stride, 0, 15) | \
            util_bitpack_uint((__unpacked)->packet_stride, 16, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->divisor_d, 0, 31); \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ATTRIBUTE_unpack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x200) fprintf(stderr, "XXX: Invalid field of Attribute unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xc0ffff00) fprintf(stderr, "XXX: Invalid field of Attribute unpacked at word 1\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Attribute unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Attribute unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->attribute_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->offset_enable, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->format, &__tmp_packed.opaque[0], 10, 31); \
   __gen_unpack_uint((__unpacked)->table, &__tmp_packed.opaque[0], 32, 37); \
   __gen_unpack_uint((__unpacked)->frequency, &__tmp_packed.opaque[0], 38, 39); \
   __gen_unpack_uint((__unpacked)->divisor_r, &__tmp_packed.opaque[0], 56, 60); \
   __gen_unpack_uint((__unpacked)->divisor_e, &__tmp_packed.opaque[0], 61, 61); \
   __gen_unpack_sint((__unpacked)->offset, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->buffer_index, &__tmp_packed.opaque[0], 96, 127); \
   __gen_unpack_uint((__unpacked)->stride, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->attribute_stride, &__tmp_packed.opaque[0], 128, 143); \
   __gen_unpack_uint((__unpacked)->packet_stride, &__tmp_packed.opaque[0], 144, 159); \
   __gen_unpack_uint((__unpacked)->divisor_d, &__tmp_packed.opaque[0], 160, 191); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ATTRIBUTE_print(FILE *fp, const struct MALI_ATTRIBUTE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sAttribute type: %s\n", indent, "", mali_attribute_type_as_str(values->attribute_type));
   fprintf(fp, "%*sOffset enable: %s\n", indent, "", values->offset_enable ? "true" : "false");
   mali_pixel_format_print(fp, values->format);
   fprintf(fp, "%*sTable: %u\n", indent, "", values->table);
   fprintf(fp, "%*sFrequency: %s\n", indent, "", mali_attribute_frequency_as_str(values->frequency));
   fprintf(fp, "%*sDivisor R: %u\n", indent, "", values->divisor_r);
   fprintf(fp, "%*sDivisor E: %u\n", indent, "", values->divisor_e);
   fprintf(fp, "%*sOffset: %" PRId64 "\n", indent, "", (int64_t)values->offset);
   fprintf(fp, "%*sBuffer index: 0x%" PRIx64 "\n", indent, "", values->buffer_index);
   fprintf(fp, "%*sStride: 0x%" PRIx64 "\n", indent, "", values->stride);
   fprintf(fp, "%*sAttribute stride: %u\n", indent, "", values->attribute_stride);
   fprintf(fp, "%*sPacket stride: %u\n", indent, "", values->packet_stride);
   fprintf(fp, "%*sDivisor D: 0x%" PRIx64 "\n", indent, "", values->divisor_d);
}

#endif
struct MALI_BUFFER {
   enum mali_descriptor_type            type;
   enum mali_buffer_type                buffer_type;
   uint64_t                             size;
   uint64_t                             address;
   uint64_t                             size_hi;
   uint64_t                             stride;
   uint32_t                             packet_stride;
   uint32_t                             attribute_stride;
};

#define MALI_BUFFER_header                      \
   .type = MALI_DESCRIPTOR_TYPE_BUFFER,  \
   .buffer_type = MALI_BUFFER_TYPE_SIMPLE

#define MALI_BUFFER_LENGTH 32
#define MALI_BUFFER_ALIGN 32
struct mali_buffer_packed { uint32_t opaque[8]; };
#define MALI_BUFFER_PACKED_T struct mali_buffer_packed
#define MALI_BUFFER_pack(__packed, __unpacked) \
do { \
   MALI_BUFFER_PACKED_T __tmp_packed; \
   assert(((__unpacked)->packet_stride & 0x3f) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->buffer_type, 4, 7); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->address, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->address, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->packet_stride >> 6, 0, 15) | \
            util_bitpack_uint((__unpacked)->attribute_stride, 16, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->size_hi, 0, 31); \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_BUFFER_unpack(__packed, __unpacked) \
do { \
   MALI_BUFFER_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of Buffer unpacked at word 0\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Buffer unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Buffer unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->buffer_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->size_hi, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_uint((__unpacked)->stride, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->packet_stride, &__tmp_packed.opaque[0], 128, 143); \
   (__unpacked)->packet_stride = (__unpacked)->packet_stride << 6; \
   __gen_unpack_uint((__unpacked)->attribute_stride, &__tmp_packed.opaque[0], 144, 159); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_BUFFER_print(FILE *fp, const struct MALI_BUFFER * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sBuffer type: %s\n", indent, "", mali_buffer_type_as_str(values->buffer_type));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sAddress: 0x%" PRIx64 "\n", indent, "", values->address);
   fprintf(fp, "%*sSize hi: 0x%" PRIx64 "\n", indent, "", values->size_hi);
   fprintf(fp, "%*sStride: 0x%" PRIx64 "\n", indent, "", values->stride);
   fprintf(fp, "%*sPacket stride: %u\n", indent, "", values->packet_stride);
   fprintf(fp, "%*sAttribute stride: %u\n", indent, "", values->attribute_stride);
}

#endif
enum mali_blend_operand_a {
        MALI_BLEND_OPERAND_A_ZERO            =      1,
        MALI_BLEND_OPERAND_A_SRC             =      2,
        MALI_BLEND_OPERAND_A_DEST            =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_blend_operand_a_as_str(enum mali_blend_operand_a imm)
{
    switch (imm) {
    case MALI_BLEND_OPERAND_A_ZERO: return "Zero";
    case MALI_BLEND_OPERAND_A_SRC: return "Src";
    case MALI_BLEND_OPERAND_A_DEST: return "Dest";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_blend_operand_b {
        MALI_BLEND_OPERAND_B_SRC_MINUS_DEST  =      0,
        MALI_BLEND_OPERAND_B_SRC_PLUS_DEST   =      1,
        MALI_BLEND_OPERAND_B_SRC             =      2,
        MALI_BLEND_OPERAND_B_DEST            =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_blend_operand_b_as_str(enum mali_blend_operand_b imm)
{
    switch (imm) {
    case MALI_BLEND_OPERAND_B_SRC_MINUS_DEST: return "Src Minus Dest";
    case MALI_BLEND_OPERAND_B_SRC_PLUS_DEST: return "Src Plus Dest";
    case MALI_BLEND_OPERAND_B_SRC: return "Src";
    case MALI_BLEND_OPERAND_B_DEST: return "Dest";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_blend_operand_c {
        MALI_BLEND_OPERAND_C_ZERO            =      1,
        MALI_BLEND_OPERAND_C_SRC             =      2,
        MALI_BLEND_OPERAND_C_DEST            =      3,
        MALI_BLEND_OPERAND_C_SRC_X_2         =      4,
        MALI_BLEND_OPERAND_C_SRC_ALPHA       =      5,
        MALI_BLEND_OPERAND_C_DEST_ALPHA      =      6,
        MALI_BLEND_OPERAND_C_CONSTANT        =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_blend_operand_c_as_str(enum mali_blend_operand_c imm)
{
    switch (imm) {
    case MALI_BLEND_OPERAND_C_ZERO: return "Zero";
    case MALI_BLEND_OPERAND_C_SRC: return "Src";
    case MALI_BLEND_OPERAND_C_DEST: return "Dest";
    case MALI_BLEND_OPERAND_C_SRC_X_2: return "Src x 2";
    case MALI_BLEND_OPERAND_C_SRC_ALPHA: return "Src Alpha";
    case MALI_BLEND_OPERAND_C_DEST_ALPHA: return "Dest Alpha";
    case MALI_BLEND_OPERAND_C_CONSTANT: return "Constant";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_BLEND_FUNCTION {
   enum mali_blend_operand_a            a;
   bool                                 negate_a;
   enum mali_blend_operand_b            b;
   bool                                 negate_b;
   enum mali_blend_operand_c            c;
   bool                                 invert_c;
};

#define MALI_BLEND_FUNCTION_header              \
   0

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_FUNCTION_print(FILE *fp, const struct MALI_BLEND_FUNCTION * values, unsigned indent)
{
   fprintf(fp, "%*sA: %s\n", indent, "", mali_blend_operand_a_as_str(values->a));
   fprintf(fp, "%*sNegate A: %s\n", indent, "", values->negate_a ? "true" : "false");
   fprintf(fp, "%*sB: %s\n", indent, "", mali_blend_operand_b_as_str(values->b));
   fprintf(fp, "%*sNegate B: %s\n", indent, "", values->negate_b ? "true" : "false");
   fprintf(fp, "%*sC: %s\n", indent, "", mali_blend_operand_c_as_str(values->c));
   fprintf(fp, "%*sInvert C: %s\n", indent, "", values->invert_c ? "true" : "false");
}

#endif
struct MALI_BLEND_EQUATION {
   struct MALI_BLEND_FUNCTION           rgb;
   struct MALI_BLEND_FUNCTION           alpha;
   uint32_t                             color_mask;
};

#define MALI_BLEND_EQUATION_header              \
   .rgb = { MALI_BLEND_FUNCTION_header },  \
   .alpha = { MALI_BLEND_FUNCTION_header }

#define MALI_BLEND_EQUATION_LENGTH 4
struct mali_blend_equation_packed { uint32_t opaque[1]; };
#define MALI_BLEND_EQUATION_PACKED_T struct mali_blend_equation_packed
#define MALI_BLEND_EQUATION_pack(__packed, __unpacked) \
do { \
   MALI_BLEND_EQUATION_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->rgb.a, 0, 1) | \
            util_bitpack_uint((__unpacked)->rgb.negate_a, 3, 3) | \
            util_bitpack_uint((__unpacked)->rgb.b, 4, 5) | \
            util_bitpack_uint((__unpacked)->rgb.negate_b, 7, 7) | \
            util_bitpack_uint((__unpacked)->rgb.c, 8, 10) | \
            util_bitpack_uint((__unpacked)->rgb.invert_c, 11, 11) | \
            util_bitpack_uint((__unpacked)->alpha.a, 12, 13) | \
            util_bitpack_uint((__unpacked)->alpha.negate_a, 15, 15) | \
            util_bitpack_uint((__unpacked)->alpha.b, 16, 17) | \
            util_bitpack_uint((__unpacked)->alpha.negate_b, 19, 19) | \
            util_bitpack_uint((__unpacked)->alpha.c, 20, 22) | \
            util_bitpack_uint((__unpacked)->alpha.invert_c, 23, 23) | \
            util_bitpack_uint((__unpacked)->color_mask, 28, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_BLEND_EQUATION_unpack(__packed, __unpacked) \
do { \
   MALI_BLEND_EQUATION_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf044044) fprintf(stderr, "XXX: Invalid field of Blend Equation unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->rgb.a, &__tmp_packed.opaque[0], 0, 1); \
   __gen_unpack_uint((__unpacked)->rgb.negate_a, &__tmp_packed.opaque[0], 3, 3); \
   __gen_unpack_uint((__unpacked)->rgb.b, &__tmp_packed.opaque[0], 4, 5); \
   __gen_unpack_uint((__unpacked)->rgb.negate_b, &__tmp_packed.opaque[0], 7, 7); \
   __gen_unpack_uint((__unpacked)->rgb.c, &__tmp_packed.opaque[0], 8, 10); \
   __gen_unpack_uint((__unpacked)->rgb.invert_c, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->alpha.a, &__tmp_packed.opaque[0], 12, 13); \
   __gen_unpack_uint((__unpacked)->alpha.negate_a, &__tmp_packed.opaque[0], 15, 15); \
   __gen_unpack_uint((__unpacked)->alpha.b, &__tmp_packed.opaque[0], 16, 17); \
   __gen_unpack_uint((__unpacked)->alpha.negate_b, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->alpha.c, &__tmp_packed.opaque[0], 20, 22); \
   __gen_unpack_uint((__unpacked)->alpha.invert_c, &__tmp_packed.opaque[0], 23, 23); \
   __gen_unpack_uint((__unpacked)->color_mask, &__tmp_packed.opaque[0], 28, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_EQUATION_print(FILE *fp, const struct MALI_BLEND_EQUATION * values, unsigned indent)
{
   fprintf(fp, "%*sRGB:\n", indent, "");
   MALI_BLEND_FUNCTION_print(fp, &values->rgb, indent + 2);
   fprintf(fp, "%*sAlpha:\n", indent, "");
   MALI_BLEND_FUNCTION_print(fp, &values->alpha, indent + 2);
   fprintf(fp, "%*sColor Mask: %u\n", indent, "", values->color_mask);
}

#endif
enum mali_register_file_format {
        MALI_REGISTER_FILE_FORMAT_F16        =      0,
        MALI_REGISTER_FILE_FORMAT_F32        =      1,
        MALI_REGISTER_FILE_FORMAT_I32        =      2,
        MALI_REGISTER_FILE_FORMAT_U32        =      3,
        MALI_REGISTER_FILE_FORMAT_I16        =      4,
        MALI_REGISTER_FILE_FORMAT_U16        =      5,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_register_file_format_as_str(enum mali_register_file_format imm)
{
    switch (imm) {
    case MALI_REGISTER_FILE_FORMAT_F16: return "F16";
    case MALI_REGISTER_FILE_FORMAT_F32: return "F32";
    case MALI_REGISTER_FILE_FORMAT_I32: return "I32";
    case MALI_REGISTER_FILE_FORMAT_U32: return "U32";
    case MALI_REGISTER_FILE_FORMAT_I16: return "I16";
    case MALI_REGISTER_FILE_FORMAT_U16: return "U16";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_blend_mode {
        MALI_BLEND_MODE_SHADER               =      0,
        MALI_BLEND_MODE_OPAQUE               =      1,
        MALI_BLEND_MODE_FIXED_FUNCTION       =      2,
        MALI_BLEND_MODE_OFF                  =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_blend_mode_as_str(enum mali_blend_mode imm)
{
    switch (imm) {
    case MALI_BLEND_MODE_SHADER: return "Shader";
    case MALI_BLEND_MODE_OPAQUE: return "Opaque";
    case MALI_BLEND_MODE_FIXED_FUNCTION: return "Fixed-Function";
    case MALI_BLEND_MODE_OFF: return "Off";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_BLEND_SHADER {
   uint32_t                             pc;
};

#define MALI_BLEND_SHADER_header                \
   0

#define MALI_BLEND_SHADER_LENGTH 8
struct mali_blend_shader_packed { uint32_t opaque[2]; };
#define MALI_BLEND_SHADER_PACKED_T struct mali_blend_shader_packed
#define MALI_BLEND_SHADER_pack(__packed, __unpacked) \
do { \
   MALI_BLEND_SHADER_PACKED_T __tmp_packed; \
   assert(((__unpacked)->pc & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->pc >> 4, 4, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_BLEND_SHADER_unpack(__packed, __unpacked) \
do { \
   MALI_BLEND_SHADER_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Blend Shader unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf) fprintf(stderr, "XXX: Invalid field of Blend Shader unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->pc, &__tmp_packed.opaque[0], 36, 63); \
   (__unpacked)->pc = (__unpacked)->pc << 4; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_SHADER_print(FILE *fp, const struct MALI_BLEND_SHADER * values, unsigned indent)
{
   fprintf(fp, "%*sPC: %u\n", indent, "", values->pc);
}

#endif
struct MALI_INTERNAL_CONVERSION {
   uint32_t                             memory_format;
   bool                                 raw;
   enum mali_register_file_format       register_format;
};

#define MALI_INTERNAL_CONVERSION_header         \
   0

#define MALI_INTERNAL_CONVERSION_LENGTH 4
#define MALI_INTERNAL_CONVERSION_ALIGN 4
struct mali_internal_conversion_packed { uint32_t opaque[1]; };
#define MALI_INTERNAL_CONVERSION_PACKED_T struct mali_internal_conversion_packed
#define MALI_INTERNAL_CONVERSION_pack(__packed, __unpacked) \
do { \
   MALI_INTERNAL_CONVERSION_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->memory_format, 0, 21) | \
            util_bitpack_uint((__unpacked)->raw, 22, 22) | \
            util_bitpack_uint((__unpacked)->register_format, 24, 26); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_INTERNAL_CONVERSION_unpack(__packed, __unpacked) \
do { \
   MALI_INTERNAL_CONVERSION_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf8800000) fprintf(stderr, "XXX: Invalid field of Internal Conversion unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->memory_format, &__tmp_packed.opaque[0], 0, 21); \
   __gen_unpack_uint((__unpacked)->raw, &__tmp_packed.opaque[0], 22, 22); \
   __gen_unpack_uint((__unpacked)->register_format, &__tmp_packed.opaque[0], 24, 26); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_INTERNAL_CONVERSION_print(FILE *fp, const struct MALI_INTERNAL_CONVERSION * values, unsigned indent)
{
   mali_pixel_format_print(fp, values->memory_format);
   fprintf(fp, "%*sRaw: %s\n", indent, "", values->raw ? "true" : "false");
   fprintf(fp, "%*sRegister Format: %s\n", indent, "", mali_register_file_format_as_str(values->register_format));
}

#endif
struct MALI_BLEND_FIXED_FUNCTION {
   uint32_t                             num_comps;
   uint32_t                             rt;
#define MALI_BIFROST_BLEND_MAX_RT                8
   struct MALI_INTERNAL_CONVERSION      conversion;
};

#define MALI_BLEND_FIXED_FUNCTION_header        \
   .num_comps = 1,  \
   .conversion = { MALI_INTERNAL_CONVERSION_header }

#define MALI_BLEND_FIXED_FUNCTION_LENGTH 8
struct mali_blend_fixed_function_packed { uint32_t opaque[2]; };
#define MALI_BLEND_FIXED_FUNCTION_PACKED_T struct mali_blend_fixed_function_packed
#define MALI_BLEND_FIXED_FUNCTION_pack(__packed, __unpacked) \
do { \
   MALI_BLEND_FIXED_FUNCTION_PACKED_T __tmp_packed; \
   assert((__unpacked)->num_comps >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->num_comps - 1, 3, 4) | \
            util_bitpack_uint((__unpacked)->rt, 16, 19); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->conversion.memory_format, 0, 21) | \
            util_bitpack_uint((__unpacked)->conversion.raw, 22, 22) | \
            util_bitpack_uint((__unpacked)->conversion.register_format, 24, 26); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_BLEND_FIXED_FUNCTION_unpack(__packed, __unpacked) \
do { \
   MALI_BLEND_FIXED_FUNCTION_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff0ffe7) fprintf(stderr, "XXX: Invalid field of Blend Fixed-Function unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf8800000) fprintf(stderr, "XXX: Invalid field of Blend Fixed-Function unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->num_comps, &__tmp_packed.opaque[0], 3, 4); \
   (__unpacked)->num_comps = (__unpacked)->num_comps + 1; \
   __gen_unpack_uint((__unpacked)->rt, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->conversion.memory_format, &__tmp_packed.opaque[0], 32, 53); \
   __gen_unpack_uint((__unpacked)->conversion.raw, &__tmp_packed.opaque[0], 54, 54); \
   __gen_unpack_uint((__unpacked)->conversion.register_format, &__tmp_packed.opaque[0], 56, 58); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_FIXED_FUNCTION_print(FILE *fp, const struct MALI_BLEND_FIXED_FUNCTION * values, unsigned indent)
{
   fprintf(fp, "%*sNum Comps: %u\n", indent, "", values->num_comps);
   fprintf(fp, "%*sRT: %u\n", indent, "", values->rt);
   fprintf(fp, "%*sConversion:\n", indent, "");
   MALI_INTERNAL_CONVERSION_print(fp, &values->conversion, indent + 2);
}

#endif
struct MALI_INTERNAL_BLEND {
   enum mali_blend_mode                 mode;
   struct MALI_BLEND_SHADER             shader;
   struct MALI_BLEND_FIXED_FUNCTION     fixed_function;
};

#define MALI_INTERNAL_BLEND_header              \
   .shader = { MALI_BLEND_SHADER_header },  \
   .fixed_function = { MALI_BLEND_FIXED_FUNCTION_header }

#define MALI_INTERNAL_BLEND_LENGTH 8
#define MALI_INTERNAL_BLEND_ALIGN 8
struct mali_internal_blend_packed { uint32_t opaque[2]; };
#define MALI_INTERNAL_BLEND_PACKED_T struct mali_internal_blend_packed
#define MALI_INTERNAL_BLEND_pack(__packed, __unpacked) \
do { \
   MALI_INTERNAL_BLEND_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->mode, 0, 1) | \
            util_bitpack_uint((__unpacked)->fixed_function.num_comps - 1, 3, 4) | \
            util_bitpack_uint((__unpacked)->fixed_function.rt, 16, 19); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->shader.pc >> 4, 4, 31) | \
            util_bitpack_uint((__unpacked)->fixed_function.conversion.memory_format, 0, 21) | \
            util_bitpack_uint((__unpacked)->fixed_function.conversion.raw, 22, 22) | \
            util_bitpack_uint((__unpacked)->fixed_function.conversion.register_format, 24, 26); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_INTERNAL_BLEND_unpack(__packed, __unpacked) \
do { \
   MALI_INTERNAL_BLEND_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff0ffe4) fprintf(stderr, "XXX: Invalid field of Internal Blend unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->mode, &__tmp_packed.opaque[0], 0, 1); \
   __gen_unpack_uint((__unpacked)->shader.pc, &__tmp_packed.opaque[0], 36, 63); \
   (__unpacked)->shader.pc = (__unpacked)->shader.pc << 4; \
   __gen_unpack_uint((__unpacked)->fixed_function.num_comps, &__tmp_packed.opaque[0], 3, 4); \
   (__unpacked)->fixed_function.num_comps = (__unpacked)->fixed_function.num_comps + 1; \
   __gen_unpack_uint((__unpacked)->fixed_function.rt, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->fixed_function.conversion.memory_format, &__tmp_packed.opaque[0], 32, 53); \
   __gen_unpack_uint((__unpacked)->fixed_function.conversion.raw, &__tmp_packed.opaque[0], 54, 54); \
   __gen_unpack_uint((__unpacked)->fixed_function.conversion.register_format, &__tmp_packed.opaque[0], 56, 58); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_INTERNAL_BLEND_print(FILE *fp, const struct MALI_INTERNAL_BLEND * values, unsigned indent)
{
   fprintf(fp, "%*sMode: %s\n", indent, "", mali_blend_mode_as_str(values->mode));
   fprintf(fp, "%*sShader:\n", indent, "");
   MALI_BLEND_SHADER_print(fp, &values->shader, indent + 2);
   fprintf(fp, "%*sFixed-Function:\n", indent, "");
   MALI_BLEND_FIXED_FUNCTION_print(fp, &values->fixed_function, indent + 2);
}

#endif
struct MALI_BLEND {
   bool                                 load_destination;
   bool                                 alpha_to_one;
   bool                                 enable;
   bool                                 srgb;
   bool                                 round_to_fb_precision;
   uint32_t                             blend_constant;
   struct MALI_BLEND_EQUATION           equation;
   struct MALI_INTERNAL_BLEND           internal;
};

#define MALI_BLEND_header                       \
   .load_destination = false,  \
   .enable = true,  \
   .srgb = false,  \
   .round_to_fb_precision = false,  \
   .equation = { MALI_BLEND_EQUATION_header },  \
   .internal = { MALI_INTERNAL_BLEND_header }

#define MALI_BLEND_LENGTH 16
#define MALI_BLEND_ALIGN 16
struct mali_blend_packed { uint32_t opaque[4]; };
#define MALI_BLEND_PACKED_T struct mali_blend_packed
#define MALI_BLEND_pack(__packed, __unpacked) \
do { \
   MALI_BLEND_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->load_destination, 0, 0) | \
            util_bitpack_uint((__unpacked)->alpha_to_one, 8, 8) | \
            util_bitpack_uint((__unpacked)->enable, 9, 9) | \
            util_bitpack_uint((__unpacked)->srgb, 10, 10) | \
            util_bitpack_uint((__unpacked)->round_to_fb_precision, 11, 11) | \
            util_bitpack_uint((__unpacked)->blend_constant, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->equation.rgb.a, 0, 1) | \
            util_bitpack_uint((__unpacked)->equation.rgb.negate_a, 3, 3) | \
            util_bitpack_uint((__unpacked)->equation.rgb.b, 4, 5) | \
            util_bitpack_uint((__unpacked)->equation.rgb.negate_b, 7, 7) | \
            util_bitpack_uint((__unpacked)->equation.rgb.c, 8, 10) | \
            util_bitpack_uint((__unpacked)->equation.rgb.invert_c, 11, 11) | \
            util_bitpack_uint((__unpacked)->equation.alpha.a, 12, 13) | \
            util_bitpack_uint((__unpacked)->equation.alpha.negate_a, 15, 15) | \
            util_bitpack_uint((__unpacked)->equation.alpha.b, 16, 17) | \
            util_bitpack_uint((__unpacked)->equation.alpha.negate_b, 19, 19) | \
            util_bitpack_uint((__unpacked)->equation.alpha.c, 20, 22) | \
            util_bitpack_uint((__unpacked)->equation.alpha.invert_c, 23, 23) | \
            util_bitpack_uint((__unpacked)->equation.color_mask, 28, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->internal.mode, 0, 1) | \
            util_bitpack_uint((__unpacked)->internal.fixed_function.num_comps - 1, 3, 4) | \
            util_bitpack_uint((__unpacked)->internal.fixed_function.rt, 16, 19); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->internal.shader.pc >> 4, 4, 31) | \
            util_bitpack_uint((__unpacked)->internal.fixed_function.conversion.memory_format, 0, 21) | \
            util_bitpack_uint((__unpacked)->internal.fixed_function.conversion.raw, 22, 22) | \
            util_bitpack_uint((__unpacked)->internal.fixed_function.conversion.register_format, 24, 26); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_BLEND_unpack(__packed, __unpacked) \
do { \
   MALI_BLEND_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf0fe) fprintf(stderr, "XXX: Invalid field of Blend unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf044044) fprintf(stderr, "XXX: Invalid field of Blend unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xfff0ffe4) fprintf(stderr, "XXX: Invalid field of Blend unpacked at word 2\n"); \
   __gen_unpack_uint((__unpacked)->load_destination, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->alpha_to_one, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->enable, &__tmp_packed.opaque[0], 9, 9); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 10, 10); \
   __gen_unpack_uint((__unpacked)->round_to_fb_precision, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->blend_constant, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->equation.rgb.a, &__tmp_packed.opaque[0], 32, 33); \
   __gen_unpack_uint((__unpacked)->equation.rgb.negate_a, &__tmp_packed.opaque[0], 35, 35); \
   __gen_unpack_uint((__unpacked)->equation.rgb.b, &__tmp_packed.opaque[0], 36, 37); \
   __gen_unpack_uint((__unpacked)->equation.rgb.negate_b, &__tmp_packed.opaque[0], 39, 39); \
   __gen_unpack_uint((__unpacked)->equation.rgb.c, &__tmp_packed.opaque[0], 40, 42); \
   __gen_unpack_uint((__unpacked)->equation.rgb.invert_c, &__tmp_packed.opaque[0], 43, 43); \
   __gen_unpack_uint((__unpacked)->equation.alpha.a, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->equation.alpha.negate_a, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->equation.alpha.b, &__tmp_packed.opaque[0], 48, 49); \
   __gen_unpack_uint((__unpacked)->equation.alpha.negate_b, &__tmp_packed.opaque[0], 51, 51); \
   __gen_unpack_uint((__unpacked)->equation.alpha.c, &__tmp_packed.opaque[0], 52, 54); \
   __gen_unpack_uint((__unpacked)->equation.alpha.invert_c, &__tmp_packed.opaque[0], 55, 55); \
   __gen_unpack_uint((__unpacked)->equation.color_mask, &__tmp_packed.opaque[0], 60, 63); \
   __gen_unpack_uint((__unpacked)->internal.mode, &__tmp_packed.opaque[0], 64, 65); \
   __gen_unpack_uint((__unpacked)->internal.shader.pc, &__tmp_packed.opaque[0], 100, 127); \
   (__unpacked)->internal.shader.pc = (__unpacked)->internal.shader.pc << 4; \
   __gen_unpack_uint((__unpacked)->internal.fixed_function.num_comps, &__tmp_packed.opaque[0], 67, 68); \
   (__unpacked)->internal.fixed_function.num_comps = (__unpacked)->internal.fixed_function.num_comps + 1; \
   __gen_unpack_uint((__unpacked)->internal.fixed_function.rt, &__tmp_packed.opaque[0], 80, 83); \
   __gen_unpack_uint((__unpacked)->internal.fixed_function.conversion.memory_format, &__tmp_packed.opaque[0], 96, 117); \
   __gen_unpack_uint((__unpacked)->internal.fixed_function.conversion.raw, &__tmp_packed.opaque[0], 118, 118); \
   __gen_unpack_uint((__unpacked)->internal.fixed_function.conversion.register_format, &__tmp_packed.opaque[0], 120, 122); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_print(FILE *fp, const struct MALI_BLEND * values, unsigned indent)
{
   fprintf(fp, "%*sLoad Destination: %s\n", indent, "", values->load_destination ? "true" : "false");
   fprintf(fp, "%*sAlpha To One: %s\n", indent, "", values->alpha_to_one ? "true" : "false");
   fprintf(fp, "%*sEnable: %s\n", indent, "", values->enable ? "true" : "false");
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sRound to FB precision: %s\n", indent, "", values->round_to_fb_precision ? "true" : "false");
   fprintf(fp, "%*sBlend Constant: %u\n", indent, "", values->blend_constant);
   fprintf(fp, "%*sEquation:\n", indent, "");
   MALI_BLEND_EQUATION_print(fp, &values->equation, indent + 2);
   fprintf(fp, "%*sInternal:\n", indent, "");
   MALI_INTERNAL_BLEND_print(fp, &values->internal, indent + 2);
}

#endif
enum mali_point_size_array_format {
        MALI_POINT_SIZE_ARRAY_FORMAT_NONE    =      0,
        MALI_POINT_SIZE_ARRAY_FORMAT_FP16    =      2,
        MALI_POINT_SIZE_ARRAY_FORMAT_FP32    =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_point_size_array_format_as_str(enum mali_point_size_array_format imm)
{
    switch (imm) {
    case MALI_POINT_SIZE_ARRAY_FORMAT_NONE: return "None";
    case MALI_POINT_SIZE_ARRAY_FORMAT_FP16: return "FP16";
    case MALI_POINT_SIZE_ARRAY_FORMAT_FP32: return "FP32";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_fifo_format {
        MALI_FIFO_FORMAT_AUTO                =      0,
        MALI_FIFO_FORMAT_BASIC               =      1,
        MALI_FIFO_FORMAT_EXTENDED            =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_fifo_format_as_str(enum mali_fifo_format imm)
{
    switch (imm) {
    case MALI_FIFO_FORMAT_AUTO: return "Auto";
    case MALI_FIFO_FORMAT_BASIC: return "Basic";
    case MALI_FIFO_FORMAT_EXTENDED: return "Extended";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_PRIMITIVE_FLAGS {
   enum mali_draw_mode                  draw_mode;
   enum mali_index_type                 index_type;
   enum mali_point_size_array_format    point_size_array_format;
   bool                                 primitive_index_enable;
   bool                                 primitive_index_writeback;
   bool                                 allow_rotating_primitives;
   bool                                 low_depth_cull;
   bool                                 high_depth_cull;
   bool                                 secondary_shader;
   bool                                 primitive_restart;
   bool                                 layer_index_enable;
   bool                                 scissor_array_enable;
   enum mali_fifo_format                position_fifo_format;
   uint32_t                             view_mask;
};

#define MALI_PRIMITIVE_FLAGS_header             \
   .draw_mode = MALI_DRAW_MODE_NONE,  \
   .index_type = MALI_INDEX_TYPE_NONE,  \
   .low_depth_cull = true,  \
   .high_depth_cull = true

#define MALI_PRIMITIVE_FLAGS_LENGTH 4
struct mali_primitive_flags_packed { uint32_t opaque[1]; };
#define MALI_PRIMITIVE_FLAGS_PACKED_T struct mali_primitive_flags_packed
#define MALI_PRIMITIVE_FLAGS_pack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_FLAGS_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->draw_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->index_type, 8, 10) | \
            util_bitpack_uint((__unpacked)->point_size_array_format, 11, 12) | \
            util_bitpack_uint((__unpacked)->primitive_index_enable, 13, 13) | \
            util_bitpack_uint((__unpacked)->primitive_index_writeback, 14, 14) | \
            util_bitpack_uint((__unpacked)->allow_rotating_primitives, 15, 15) | \
            util_bitpack_uint((__unpacked)->low_depth_cull, 16, 16) | \
            util_bitpack_uint((__unpacked)->high_depth_cull, 17, 17) | \
            util_bitpack_uint((__unpacked)->secondary_shader, 18, 18) | \
            util_bitpack_uint((__unpacked)->primitive_restart, 19, 19) | \
            util_bitpack_uint((__unpacked)->layer_index_enable, 20, 20) | \
            util_bitpack_uint((__unpacked)->scissor_array_enable, 21, 21) | \
            util_bitpack_uint((__unpacked)->position_fifo_format, 22, 23) | \
            util_bitpack_uint((__unpacked)->view_mask, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PRIMITIVE_FLAGS_unpack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_FLAGS_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf0) fprintf(stderr, "XXX: Invalid field of Primitive Flags unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->draw_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->index_type, &__tmp_packed.opaque[0], 8, 10); \
   __gen_unpack_uint((__unpacked)->point_size_array_format, &__tmp_packed.opaque[0], 11, 12); \
   __gen_unpack_uint((__unpacked)->primitive_index_enable, &__tmp_packed.opaque[0], 13, 13); \
   __gen_unpack_uint((__unpacked)->primitive_index_writeback, &__tmp_packed.opaque[0], 14, 14); \
   __gen_unpack_uint((__unpacked)->allow_rotating_primitives, &__tmp_packed.opaque[0], 15, 15); \
   __gen_unpack_uint((__unpacked)->low_depth_cull, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->high_depth_cull, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->secondary_shader, &__tmp_packed.opaque[0], 18, 18); \
   __gen_unpack_uint((__unpacked)->primitive_restart, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->layer_index_enable, &__tmp_packed.opaque[0], 20, 20); \
   __gen_unpack_uint((__unpacked)->scissor_array_enable, &__tmp_packed.opaque[0], 21, 21); \
   __gen_unpack_uint((__unpacked)->position_fifo_format, &__tmp_packed.opaque[0], 22, 23); \
   __gen_unpack_uint((__unpacked)->view_mask, &__tmp_packed.opaque[0], 24, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PRIMITIVE_FLAGS_print(FILE *fp, const struct MALI_PRIMITIVE_FLAGS * values, unsigned indent)
{
   fprintf(fp, "%*sDraw mode: %s\n", indent, "", mali_draw_mode_as_str(values->draw_mode));
   fprintf(fp, "%*sIndex type: %s\n", indent, "", mali_index_type_as_str(values->index_type));
   fprintf(fp, "%*sPoint size array format: %s\n", indent, "", mali_point_size_array_format_as_str(values->point_size_array_format));
   fprintf(fp, "%*sPrimitive Index Enable: %s\n", indent, "", values->primitive_index_enable ? "true" : "false");
   fprintf(fp, "%*sPrimitive Index Writeback: %s\n", indent, "", values->primitive_index_writeback ? "true" : "false");
   fprintf(fp, "%*sAllow rotating primitives: %s\n", indent, "", values->allow_rotating_primitives ? "true" : "false");
   fprintf(fp, "%*sLow Depth Cull: %s\n", indent, "", values->low_depth_cull ? "true" : "false");
   fprintf(fp, "%*sHigh Depth Cull: %s\n", indent, "", values->high_depth_cull ? "true" : "false");
   fprintf(fp, "%*sSecondary Shader: %s\n", indent, "", values->secondary_shader ? "true" : "false");
   fprintf(fp, "%*sPrimitive restart: %s\n", indent, "", values->primitive_restart ? "true" : "false");
   fprintf(fp, "%*sLayer index enable: %s\n", indent, "", values->layer_index_enable ? "true" : "false");
   fprintf(fp, "%*sScissor array enable: %s\n", indent, "", values->scissor_array_enable ? "true" : "false");
   fprintf(fp, "%*sPosition FIFO format: %s\n", indent, "", mali_fifo_format_as_str(values->position_fifo_format));
   fprintf(fp, "%*sView mask: 0x%x\n", indent, "", values->view_mask);
}

#endif
enum mali_vrs_draw_rate {
        MALI_VRS_DRAW_RATE_1X1               =      0,
        MALI_VRS_DRAW_RATE_1X2               =      1,
        MALI_VRS_DRAW_RATE_1X4               =      2,
        MALI_VRS_DRAW_RATE_2X1               =      4,
        MALI_VRS_DRAW_RATE_2X2               =      5,
        MALI_VRS_DRAW_RATE_2X4               =      6,
        MALI_VRS_DRAW_RATE_4X1               =      8,
        MALI_VRS_DRAW_RATE_4X2               =      9,
        MALI_VRS_DRAW_RATE_4X4               =     10,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_vrs_draw_rate_as_str(enum mali_vrs_draw_rate imm)
{
    switch (imm) {
    case MALI_VRS_DRAW_RATE_1X1: return "1x1";
    case MALI_VRS_DRAW_RATE_1X2: return "1x2";
    case MALI_VRS_DRAW_RATE_1X4: return "1x4";
    case MALI_VRS_DRAW_RATE_2X1: return "2x1";
    case MALI_VRS_DRAW_RATE_2X2: return "2x2";
    case MALI_VRS_DRAW_RATE_2X4: return "2x4";
    case MALI_VRS_DRAW_RATE_4X1: return "4x1";
    case MALI_VRS_DRAW_RATE_4X2: return "4x2";
    case MALI_VRS_DRAW_RATE_4X4: return "4x4";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_vrs_combiner {
        MALI_VRS_COMBINER_KEEP               =      0,
        MALI_VRS_COMBINER_REPLACE            =      1,
        MALI_VRS_COMBINER_MIN                =      2,
        MALI_VRS_COMBINER_MAX                =      3,
        MALI_VRS_COMBINER_MUL                =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_vrs_combiner_as_str(enum mali_vrs_combiner imm)
{
    switch (imm) {
    case MALI_VRS_COMBINER_KEEP: return "Keep";
    case MALI_VRS_COMBINER_REPLACE: return "Replace";
    case MALI_VRS_COMBINER_MIN: return "Min";
    case MALI_VRS_COMBINER_MAX: return "Max";
    case MALI_VRS_COMBINER_MUL: return "Mul";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_PRIMITIVE_FLAGS_2 {
   enum mali_vrs_draw_rate              vrs_draw_rate;
   enum mali_vrs_combiner               vrs_combiner_0;
   enum mali_vrs_combiner               vrs_combiner_1;
};

#define MALI_PRIMITIVE_FLAGS_2_header           \
   .vrs_draw_rate = MALI_VRS_DRAW_RATE_1X1,  \
   .vrs_combiner_0 = MALI_VRS_COMBINER_KEEP,  \
   .vrs_combiner_1 = MALI_VRS_COMBINER_KEEP

#define MALI_PRIMITIVE_FLAGS_2_LENGTH 4
struct mali_primitive_flags_2_packed { uint32_t opaque[1]; };
#define MALI_PRIMITIVE_FLAGS_2_PACKED_T struct mali_primitive_flags_2_packed
#define MALI_PRIMITIVE_FLAGS_2_pack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_FLAGS_2_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->vrs_draw_rate, 0, 3) | \
            util_bitpack_uint((__unpacked)->vrs_combiner_0, 4, 6) | \
            util_bitpack_uint((__unpacked)->vrs_combiner_1, 7, 9); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PRIMITIVE_FLAGS_2_unpack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_FLAGS_2_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfffffc00) fprintf(stderr, "XXX: Invalid field of Primitive Flags 2 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->vrs_draw_rate, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->vrs_combiner_0, &__tmp_packed.opaque[0], 4, 6); \
   __gen_unpack_uint((__unpacked)->vrs_combiner_1, &__tmp_packed.opaque[0], 7, 9); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PRIMITIVE_FLAGS_2_print(FILE *fp, const struct MALI_PRIMITIVE_FLAGS_2 * values, unsigned indent)
{
   fprintf(fp, "%*sVRS Draw Rate: %s\n", indent, "", mali_vrs_draw_rate_as_str(values->vrs_draw_rate));
   fprintf(fp, "%*sVRS Combiner 0: %s\n", indent, "", mali_vrs_combiner_as_str(values->vrs_combiner_0));
   fprintf(fp, "%*sVRS Combiner 1: %s\n", indent, "", mali_vrs_combiner_as_str(values->vrs_combiner_1));
}

#endif
struct MALI_PRIMITIVE {
   enum mali_draw_mode                  draw_mode;
   enum mali_index_type                 index_type;
   bool                                 primitive_index_enable;
   bool                                 primitive_index_writeback;
   bool                                 allow_rotating_primitives;
   bool                                 low_depth_cull;
   bool                                 high_depth_cull;
   bool                                 secondary_shader;
   bool                                 primitive_restart;
   bool                                 layer_index_enable;
   bool                                 scissor_array_enable;
   int64_t                              base_vertex_offset;
   uint64_t                             instance_offset;
   uint64_t                             index_count;
};

#define MALI_PRIMITIVE_header                   \
   .draw_mode = MALI_DRAW_MODE_NONE,  \
   .index_type = MALI_INDEX_TYPE_NONE,  \
   .low_depth_cull = true,  \
   .high_depth_cull = true

#define MALI_PRIMITIVE_LENGTH 16
struct mali_primitive_packed { uint32_t opaque[4]; };
#define MALI_PRIMITIVE_PACKED_T struct mali_primitive_packed
#define MALI_PRIMITIVE_pack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->draw_mode, 0, 7) | \
            util_bitpack_uint((__unpacked)->index_type, 8, 10) | \
            util_bitpack_uint((__unpacked)->primitive_index_enable, 13, 13) | \
            util_bitpack_uint((__unpacked)->primitive_index_writeback, 14, 14) | \
            util_bitpack_uint((__unpacked)->allow_rotating_primitives, 15, 15) | \
            util_bitpack_uint((__unpacked)->low_depth_cull, 16, 16) | \
            util_bitpack_uint((__unpacked)->high_depth_cull, 17, 17) | \
            util_bitpack_uint((__unpacked)->secondary_shader, 18, 18) | \
            util_bitpack_uint((__unpacked)->primitive_restart, 19, 19) | \
            util_bitpack_uint((__unpacked)->layer_index_enable, 20, 20) | \
            util_bitpack_uint((__unpacked)->scissor_array_enable, 21, 21); \
   __tmp_packed.opaque[ 1] = util_bitpack_sint((__unpacked)->base_vertex_offset, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->instance_offset, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->index_count, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PRIMITIVE_unpack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffc01800) fprintf(stderr, "XXX: Invalid field of Primitive unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->draw_mode, &__tmp_packed.opaque[0], 0, 7); \
   __gen_unpack_uint((__unpacked)->index_type, &__tmp_packed.opaque[0], 8, 10); \
   __gen_unpack_uint((__unpacked)->primitive_index_enable, &__tmp_packed.opaque[0], 13, 13); \
   __gen_unpack_uint((__unpacked)->primitive_index_writeback, &__tmp_packed.opaque[0], 14, 14); \
   __gen_unpack_uint((__unpacked)->allow_rotating_primitives, &__tmp_packed.opaque[0], 15, 15); \
   __gen_unpack_uint((__unpacked)->low_depth_cull, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->high_depth_cull, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->secondary_shader, &__tmp_packed.opaque[0], 18, 18); \
   __gen_unpack_uint((__unpacked)->primitive_restart, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->layer_index_enable, &__tmp_packed.opaque[0], 20, 20); \
   __gen_unpack_uint((__unpacked)->scissor_array_enable, &__tmp_packed.opaque[0], 21, 21); \
   __gen_unpack_sint((__unpacked)->base_vertex_offset, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->instance_offset, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->index_count, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PRIMITIVE_print(FILE *fp, const struct MALI_PRIMITIVE * values, unsigned indent)
{
   fprintf(fp, "%*sDraw mode: %s\n", indent, "", mali_draw_mode_as_str(values->draw_mode));
   fprintf(fp, "%*sIndex type: %s\n", indent, "", mali_index_type_as_str(values->index_type));
   fprintf(fp, "%*sPrimitive Index Enable: %s\n", indent, "", values->primitive_index_enable ? "true" : "false");
   fprintf(fp, "%*sPrimitive Index Writeback: %s\n", indent, "", values->primitive_index_writeback ? "true" : "false");
   fprintf(fp, "%*sAllow rotating primitives: %s\n", indent, "", values->allow_rotating_primitives ? "true" : "false");
   fprintf(fp, "%*sLow Depth Cull: %s\n", indent, "", values->low_depth_cull ? "true" : "false");
   fprintf(fp, "%*sHigh Depth Cull: %s\n", indent, "", values->high_depth_cull ? "true" : "false");
   fprintf(fp, "%*sSecondary Shader: %s\n", indent, "", values->secondary_shader ? "true" : "false");
   fprintf(fp, "%*sPrimitive restart: %s\n", indent, "", values->primitive_restart ? "true" : "false");
   fprintf(fp, "%*sLayer index enable: %s\n", indent, "", values->layer_index_enable ? "true" : "false");
   fprintf(fp, "%*sScissor array enable: %s\n", indent, "", values->scissor_array_enable ? "true" : "false");
   fprintf(fp, "%*sBase vertex offset: %" PRId64 "\n", indent, "", (int64_t)values->base_vertex_offset);
   fprintf(fp, "%*sInstance offset: 0x%" PRIx64 "\n", indent, "", values->instance_offset);
   fprintf(fp, "%*sIndex count: 0x%" PRIx64 "\n", indent, "", values->index_count);
}

#endif
enum mali_reduction_mode {
        MALI_REDUCTION_MODE_AVERAGE          =      0,
        MALI_REDUCTION_MODE_MINIMUM          =      2,
        MALI_REDUCTION_MODE_MAXIMUM          =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_reduction_mode_as_str(enum mali_reduction_mode imm)
{
    switch (imm) {
    case MALI_REDUCTION_MODE_AVERAGE: return "Average";
    case MALI_REDUCTION_MODE_MINIMUM: return "Minimum";
    case MALI_REDUCTION_MODE_MAXIMUM: return "Maximum";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_SAMPLER {
   enum mali_descriptor_type            type;
   enum mali_reduction_mode             reduction_mode;
   enum mali_wrap_mode                  wrap_mode_r;
   enum mali_wrap_mode                  wrap_mode_t;
   enum mali_wrap_mode                  wrap_mode_s;
   bool                                 round_to_nearest_even;
   bool                                 srgb_override;
   bool                                 seamless_cube_map;
   bool                                 clamp_integer_coordinates;
   bool                                 normalized_coordinates;
   bool                                 clamp_integer_array_indices;
   bool                                 minify_nearest;
   bool                                 magnify_nearest;
   bool                                 magnify_cutoff;
   enum mali_mipmap_mode                mipmap_mode;
   float                                minimum_lod;
   enum mali_func                       compare_function;
   float                                maximum_lod;
   float                                lod_bias;
   uint32_t                             maximum_anisotropy;
   enum mali_lod_algorithm              lod_algorithm;
   uint32_t                             border_color_r;
   uint32_t                             border_color_g;
   uint32_t                             border_color_b;
   uint32_t                             border_color_a;
};

#define MALI_SAMPLER_header                     \
   .type = MALI_DESCRIPTOR_TYPE_SAMPLER,  \
   .reduction_mode = MALI_REDUCTION_MODE_AVERAGE,  \
   .wrap_mode_r = MALI_WRAP_MODE_CLAMP_TO_EDGE,  \
   .wrap_mode_t = MALI_WRAP_MODE_CLAMP_TO_EDGE,  \
   .wrap_mode_s = MALI_WRAP_MODE_CLAMP_TO_EDGE,  \
   .round_to_nearest_even = true,  \
   .srgb_override = false,  \
   .seamless_cube_map = true,  \
   .normalized_coordinates = true,  \
   .clamp_integer_array_indices = true,  \
   .minify_nearest = false,  \
   .magnify_nearest = false,  \
   .magnify_cutoff = false,  \
   .mipmap_mode = MALI_MIPMAP_MODE_NEAREST,  \
   .minimum_lod = 0,  \
   .compare_function = MALI_FUNC_NEVER,  \
   .maximum_lod = 0,  \
   .lod_bias = 0,  \
   .maximum_anisotropy = 1,  \
   .lod_algorithm = MALI_LOD_ALGORITHM_ISOTROPIC,  \
   .border_color_r = 0.0,  \
   .border_color_g = 0.0,  \
   .border_color_b = 0.0,  \
   .border_color_a = 0.0

#define MALI_SAMPLER_LENGTH 32
#define MALI_SAMPLER_ALIGN 32
struct mali_sampler_packed { uint32_t opaque[8]; };
#define MALI_SAMPLER_PACKED_T struct mali_sampler_packed
#define MALI_SAMPLER_pack(__packed, __unpacked) \
do { \
   MALI_SAMPLER_PACKED_T __tmp_packed; \
   assert((__unpacked)->maximum_anisotropy >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->reduction_mode, 4, 5) | \
            util_bitpack_uint((__unpacked)->wrap_mode_r, 8, 11) | \
            util_bitpack_uint((__unpacked)->wrap_mode_t, 12, 15) | \
            util_bitpack_uint((__unpacked)->wrap_mode_s, 16, 19) | \
            util_bitpack_uint((__unpacked)->round_to_nearest_even, 21, 21) | \
            util_bitpack_uint((__unpacked)->srgb_override, 22, 22) | \
            util_bitpack_uint((__unpacked)->seamless_cube_map, 23, 23) | \
            util_bitpack_uint((__unpacked)->clamp_integer_coordinates, 24, 24) | \
            util_bitpack_uint((__unpacked)->normalized_coordinates, 25, 25) | \
            util_bitpack_uint((__unpacked)->clamp_integer_array_indices, 26, 26) | \
            util_bitpack_uint((__unpacked)->minify_nearest, 27, 27) | \
            util_bitpack_uint((__unpacked)->magnify_nearest, 28, 28) | \
            util_bitpack_uint((__unpacked)->magnify_cutoff, 29, 29) | \
            util_bitpack_uint((__unpacked)->mipmap_mode, 30, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_ufixed_clamp((__unpacked)->minimum_lod, 0, 12, 8) | \
            util_bitpack_uint((__unpacked)->compare_function, 13, 15) | \
            util_bitpack_ufixed_clamp((__unpacked)->maximum_lod, 16, 28, 8); \
   __tmp_packed.opaque[ 2] = util_bitpack_sfixed_clamp((__unpacked)->lod_bias, 0, 15, 8) | \
            util_bitpack_uint((__unpacked)->maximum_anisotropy - 1, 16, 20) | \
            util_bitpack_uint((__unpacked)->lod_algorithm, 24, 25); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->border_color_r, 0, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->border_color_g, 0, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->border_color_b, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->border_color_a, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SAMPLER_unpack(__packed, __unpacked) \
do { \
   MALI_SAMPLER_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x1000c0) fprintf(stderr, "XXX: Invalid field of Sampler unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xe0000000) fprintf(stderr, "XXX: Invalid field of Sampler unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xfce00000) fprintf(stderr, "XXX: Invalid field of Sampler unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Sampler unpacked at word 3\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->reduction_mode, &__tmp_packed.opaque[0], 4, 5); \
   __gen_unpack_uint((__unpacked)->wrap_mode_r, &__tmp_packed.opaque[0], 8, 11); \
   __gen_unpack_uint((__unpacked)->wrap_mode_t, &__tmp_packed.opaque[0], 12, 15); \
   __gen_unpack_uint((__unpacked)->wrap_mode_s, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->round_to_nearest_even, &__tmp_packed.opaque[0], 21, 21); \
   __gen_unpack_uint((__unpacked)->srgb_override, &__tmp_packed.opaque[0], 22, 22); \
   __gen_unpack_uint((__unpacked)->seamless_cube_map, &__tmp_packed.opaque[0], 23, 23); \
   __gen_unpack_uint((__unpacked)->clamp_integer_coordinates, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->normalized_coordinates, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->clamp_integer_array_indices, &__tmp_packed.opaque[0], 26, 26); \
   __gen_unpack_uint((__unpacked)->minify_nearest, &__tmp_packed.opaque[0], 27, 27); \
   __gen_unpack_uint((__unpacked)->magnify_nearest, &__tmp_packed.opaque[0], 28, 28); \
   __gen_unpack_uint((__unpacked)->magnify_cutoff, &__tmp_packed.opaque[0], 29, 29); \
   __gen_unpack_uint((__unpacked)->mipmap_mode, &__tmp_packed.opaque[0], 30, 31); \
   __gen_unpack_ulod((__unpacked)->minimum_lod, &__tmp_packed.opaque[0], 32, 44); \
   __gen_unpack_uint((__unpacked)->compare_function, &__tmp_packed.opaque[0], 45, 47); \
   __gen_unpack_ulod((__unpacked)->maximum_lod, &__tmp_packed.opaque[0], 48, 60); \
   __gen_unpack_slod((__unpacked)->lod_bias, &__tmp_packed.opaque[0], 64, 79); \
   __gen_unpack_uint((__unpacked)->maximum_anisotropy, &__tmp_packed.opaque[0], 80, 84); \
   (__unpacked)->maximum_anisotropy = (__unpacked)->maximum_anisotropy + 1; \
   __gen_unpack_uint((__unpacked)->lod_algorithm, &__tmp_packed.opaque[0], 88, 89); \
   __gen_unpack_uint((__unpacked)->border_color_r, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->border_color_g, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_uint((__unpacked)->border_color_b, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->border_color_a, &__tmp_packed.opaque[0], 224, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SAMPLER_print(FILE *fp, const struct MALI_SAMPLER * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sReduction mode: %s\n", indent, "", mali_reduction_mode_as_str(values->reduction_mode));
   fprintf(fp, "%*sWrap Mode R: %s\n", indent, "", mali_wrap_mode_as_str(values->wrap_mode_r));
   fprintf(fp, "%*sWrap Mode T: %s\n", indent, "", mali_wrap_mode_as_str(values->wrap_mode_t));
   fprintf(fp, "%*sWrap Mode S: %s\n", indent, "", mali_wrap_mode_as_str(values->wrap_mode_s));
   fprintf(fp, "%*sRound to nearest even: %s\n", indent, "", values->round_to_nearest_even ? "true" : "false");
   fprintf(fp, "%*ssRGB override: %s\n", indent, "", values->srgb_override ? "true" : "false");
   fprintf(fp, "%*sSeamless Cube Map: %s\n", indent, "", values->seamless_cube_map ? "true" : "false");
   fprintf(fp, "%*sClamp integer coordinates: %s\n", indent, "", values->clamp_integer_coordinates ? "true" : "false");
   fprintf(fp, "%*sNormalized Coordinates: %s\n", indent, "", values->normalized_coordinates ? "true" : "false");
   fprintf(fp, "%*sClamp integer array indices: %s\n", indent, "", values->clamp_integer_array_indices ? "true" : "false");
   fprintf(fp, "%*sMinify nearest: %s\n", indent, "", values->minify_nearest ? "true" : "false");
   fprintf(fp, "%*sMagnify nearest: %s\n", indent, "", values->magnify_nearest ? "true" : "false");
   fprintf(fp, "%*sMagnify cutoff: %s\n", indent, "", values->magnify_cutoff ? "true" : "false");
   fprintf(fp, "%*sMipmap Mode: %s\n", indent, "", mali_mipmap_mode_as_str(values->mipmap_mode));
   fprintf(fp, "%*sMinimum LOD: %f\n", indent, "", values->minimum_lod);
   fprintf(fp, "%*sCompare Function: %s\n", indent, "", mali_func_as_str(values->compare_function));
   fprintf(fp, "%*sMaximum LOD: %f\n", indent, "", values->maximum_lod);
   fprintf(fp, "%*sLOD bias: %f\n", indent, "", values->lod_bias);
   fprintf(fp, "%*sMaximum anisotropy: %u\n", indent, "", values->maximum_anisotropy);
   fprintf(fp, "%*sLOD algorithm: %s\n", indent, "", mali_lod_algorithm_as_str(values->lod_algorithm));
   fprintf(fp, "%*sBorder Color R: 0x%X (%f)\n", indent, "", values->border_color_r, uif(values->border_color_r));
   fprintf(fp, "%*sBorder Color G: 0x%X (%f)\n", indent, "", values->border_color_g, uif(values->border_color_g));
   fprintf(fp, "%*sBorder Color B: 0x%X (%f)\n", indent, "", values->border_color_b, uif(values->border_color_b));
   fprintf(fp, "%*sBorder Color A: 0x%X (%f)\n", indent, "", values->border_color_a, uif(values->border_color_a));
}

#endif
enum mali_plane_type {
        MALI_PLANE_TYPE_NULL                 =      0,
        MALI_PLANE_TYPE_GENERIC              =      1,
        MALI_PLANE_TYPE_ASTC_2D              =      4,
        MALI_PLANE_TYPE_ASTC_3D              =      5,
        MALI_PLANE_TYPE_AFBC                 =      6,
        MALI_PLANE_TYPE_CHROMA_2P            =      8,
        MALI_PLANE_TYPE_AFRC                 =     10,
        MALI_PLANE_TYPE_AFRC_CHROMA_2P       =     11,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_plane_type_as_str(enum mali_plane_type imm)
{
    switch (imm) {
    case MALI_PLANE_TYPE_NULL: return "Null";
    case MALI_PLANE_TYPE_GENERIC: return "Generic";
    case MALI_PLANE_TYPE_ASTC_2D: return "ASTC 2D";
    case MALI_PLANE_TYPE_ASTC_3D: return "ASTC 3D";
    case MALI_PLANE_TYPE_AFBC: return "AFBC";
    case MALI_PLANE_TYPE_CHROMA_2P: return "Chroma 2p";
    case MALI_PLANE_TYPE_AFRC: return "AFRC";
    case MALI_PLANE_TYPE_AFRC_CHROMA_2P: return "AFRC Chroma 2p";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_clump_ordering {
        MALI_CLUMP_ORDERING_TILED_U_INTERLEAVED =      1,
        MALI_CLUMP_ORDERING_LINEAR           =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_clump_ordering_as_str(enum mali_clump_ordering imm)
{
    switch (imm) {
    case MALI_CLUMP_ORDERING_TILED_U_INTERLEAVED: return "Tiled U-Interleaved";
    case MALI_CLUMP_ORDERING_LINEAR: return "Linear";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_clump_format {
        MALI_CLUMP_FORMAT_RAW8               =      0,
        MALI_CLUMP_FORMAT_RAW16              =      1,
        MALI_CLUMP_FORMAT_RAW32              =      2,
        MALI_CLUMP_FORMAT_RAW64              =      3,
        MALI_CLUMP_FORMAT_RAW128             =      4,
        MALI_CLUMP_FORMAT_RAW24              =      8,
        MALI_CLUMP_FORMAT_RAW48              =      9,
        MALI_CLUMP_FORMAT_RAW96              =     10,
        MALI_CLUMP_FORMAT_D32X32             =     16,
        MALI_CLUMP_FORMAT_X32D32             =     17,
        MALI_CLUMP_FORMAT_X32S8X24           =     18,
        MALI_CLUMP_FORMAT_X24S8X32           =     19,
        MALI_CLUMP_FORMAT_X24S8              =     20,
        MALI_CLUMP_FORMAT_S8X24              =     21,
        MALI_CLUMP_FORMAT_S8                 =     22,
        MALI_CLUMP_FORMAT_L4A4               =     24,
        MALI_CLUMP_FORMAT_L8A8               =     25,
        MALI_CLUMP_FORMAT_A8                 =     26,
        MALI_CLUMP_FORMAT_ETC2_RGB8          =     32,
        MALI_CLUMP_FORMAT_ETC2_R11_UNORM     =     33,
        MALI_CLUMP_FORMAT_ETC2_R11_SNORM     =     34,
        MALI_CLUMP_FORMAT_ETC2_RG11_UNORM    =     35,
        MALI_CLUMP_FORMAT_ETC2_RG11_SNORM    =     36,
        MALI_CLUMP_FORMAT_ETC2_RGBA8         =     37,
        MALI_CLUMP_FORMAT_ETC2_RGB8A1        =     38,
        MALI_CLUMP_FORMAT_BC1_UNORM          =     48,
        MALI_CLUMP_FORMAT_BC2_UNORM          =     49,
        MALI_CLUMP_FORMAT_BC3_UNORM          =     50,
        MALI_CLUMP_FORMAT_BC4_UNORM          =     51,
        MALI_CLUMP_FORMAT_BC4_SNORM          =     52,
        MALI_CLUMP_FORMAT_BC5_UNORM          =     53,
        MALI_CLUMP_FORMAT_BC5_SNORM          =     54,
        MALI_CLUMP_FORMAT_BC6H_UF16          =     55,
        MALI_CLUMP_FORMAT_BC6H_SF16          =     56,
        MALI_CLUMP_FORMAT_BC7_UNORM          =     57,
        MALI_CLUMP_FORMAT_Y8_UV8_422         =     64,
        MALI_CLUMP_FORMAT_Y10_UV10_422       =     65,
        MALI_CLUMP_FORMAT_Y16_UV16_422       =     67,
        MALI_CLUMP_FORMAT_Y8_UV8_420         =     72,
        MALI_CLUMP_FORMAT_Y10_UV10_420       =     73,
        MALI_CLUMP_FORMAT_Y16_UV16_420       =     75,
        MALI_CLUMP_FORMAT_YUV420_10X6        =     76,
        MALI_CLUMP_FORMAT_RAW10              =    120,
        MALI_CLUMP_FORMAT_RAW12              =    121,
        MALI_CLUMP_FORMAT_R8G8B8G8           =    124,
        MALI_CLUMP_FORMAT_G8R8G8B8           =    125,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_clump_format_as_str(enum mali_clump_format imm)
{
    switch (imm) {
    case MALI_CLUMP_FORMAT_RAW8: return "RAW8";
    case MALI_CLUMP_FORMAT_RAW16: return "RAW16";
    case MALI_CLUMP_FORMAT_RAW32: return "RAW32";
    case MALI_CLUMP_FORMAT_RAW64: return "RAW64";
    case MALI_CLUMP_FORMAT_RAW128: return "RAW128";
    case MALI_CLUMP_FORMAT_RAW24: return "RAW24";
    case MALI_CLUMP_FORMAT_RAW48: return "RAW48";
    case MALI_CLUMP_FORMAT_RAW96: return "RAW96";
    case MALI_CLUMP_FORMAT_D32X32: return "D32X32";
    case MALI_CLUMP_FORMAT_X32D32: return "X32D32";
    case MALI_CLUMP_FORMAT_X32S8X24: return "X32S8X24";
    case MALI_CLUMP_FORMAT_X24S8X32: return "X24S8X32";
    case MALI_CLUMP_FORMAT_X24S8: return "X24S8";
    case MALI_CLUMP_FORMAT_S8X24: return "S8X24";
    case MALI_CLUMP_FORMAT_S8: return "S8";
    case MALI_CLUMP_FORMAT_L4A4: return "L4A4";
    case MALI_CLUMP_FORMAT_L8A8: return "L8A8";
    case MALI_CLUMP_FORMAT_A8: return "A8";
    case MALI_CLUMP_FORMAT_ETC2_RGB8: return "ETC2 RGB8";
    case MALI_CLUMP_FORMAT_ETC2_R11_UNORM: return "ETC2 R11 UNORM";
    case MALI_CLUMP_FORMAT_ETC2_R11_SNORM: return "ETC2 R11 SNORM";
    case MALI_CLUMP_FORMAT_ETC2_RG11_UNORM: return "ETC2 RG11 UNORM";
    case MALI_CLUMP_FORMAT_ETC2_RG11_SNORM: return "ETC2 RG11 SNORM";
    case MALI_CLUMP_FORMAT_ETC2_RGBA8: return "ETC2 RGBA8";
    case MALI_CLUMP_FORMAT_ETC2_RGB8A1: return "ETC2 RGB8A1";
    case MALI_CLUMP_FORMAT_BC1_UNORM: return "BC1 UNORM";
    case MALI_CLUMP_FORMAT_BC2_UNORM: return "BC2 UNORM";
    case MALI_CLUMP_FORMAT_BC3_UNORM: return "BC3 UNORM";
    case MALI_CLUMP_FORMAT_BC4_UNORM: return "BC4 UNORM";
    case MALI_CLUMP_FORMAT_BC4_SNORM: return "BC4 SNORM";
    case MALI_CLUMP_FORMAT_BC5_UNORM: return "BC5 UNORM";
    case MALI_CLUMP_FORMAT_BC5_SNORM: return "BC5 SNORM";
    case MALI_CLUMP_FORMAT_BC6H_UF16: return "BC6H UF16";
    case MALI_CLUMP_FORMAT_BC6H_SF16: return "BC6H SF16";
    case MALI_CLUMP_FORMAT_BC7_UNORM: return "BC7 UNORM";
    case MALI_CLUMP_FORMAT_Y8_UV8_422: return "Y8 UV8 422";
    case MALI_CLUMP_FORMAT_Y10_UV10_422: return "Y10 UV10 422";
    case MALI_CLUMP_FORMAT_Y16_UV16_422: return "Y16 UV16 422";
    case MALI_CLUMP_FORMAT_Y8_UV8_420: return "Y8 UV8 420";
    case MALI_CLUMP_FORMAT_Y10_UV10_420: return "Y10 UV10 420";
    case MALI_CLUMP_FORMAT_Y16_UV16_420: return "Y16 UV16 420";
    case MALI_CLUMP_FORMAT_YUV420_10X6: return "YUV420 10x6";
    case MALI_CLUMP_FORMAT_RAW10: return "RAW10";
    case MALI_CLUMP_FORMAT_RAW12: return "RAW12";
    case MALI_CLUMP_FORMAT_R8G8B8G8: return "R8G8B8G8";
    case MALI_CLUMP_FORMAT_G8R8G8B8: return "G8R8G8B8";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_afbc_superblock_size {
        MALI_AFBC_SUPERBLOCK_SIZE_16X16      =      0,
        MALI_AFBC_SUPERBLOCK_SIZE_32X8       =      1,
        MALI_AFBC_SUPERBLOCK_SIZE_64X4       =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_afbc_superblock_size_as_str(enum mali_afbc_superblock_size imm)
{
    switch (imm) {
    case MALI_AFBC_SUPERBLOCK_SIZE_16X16: return "16x16";
    case MALI_AFBC_SUPERBLOCK_SIZE_32X8: return "32x8";
    case MALI_AFBC_SUPERBLOCK_SIZE_64X4: return "64x4";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_afbc_compression_mode {
        MALI_AFBC_COMPRESSION_MODE_R8        =      0,
        MALI_AFBC_COMPRESSION_MODE_R8G8      =      3,
        MALI_AFBC_COMPRESSION_MODE_R5G6B5    =      4,
        MALI_AFBC_COMPRESSION_MODE_R4G4B4A4  =      5,
        MALI_AFBC_COMPRESSION_MODE_R5G5B5A1  =      6,
        MALI_AFBC_COMPRESSION_MODE_R8G8B8    =      9,
        MALI_AFBC_COMPRESSION_MODE_R8G8B8A8  =     10,
        MALI_AFBC_COMPRESSION_MODE_R10G10B10A2 =     11,
        MALI_AFBC_COMPRESSION_MODE_R11G11B10 =     12,
        MALI_AFBC_COMPRESSION_MODE_S8        =     14,
        MALI_AFBC_COMPRESSION_MODE_X24S8     =     15,
        MALI_AFBC_COMPRESSION_MODE_YUV420_6C8 =     32,
        MALI_AFBC_COMPRESSION_MODE_YUV420_2C8 =     34,
        MALI_AFBC_COMPRESSION_MODE_YUV420_1C8 =     35,
        MALI_AFBC_COMPRESSION_MODE_YUV422_4C8 =     37,
        MALI_AFBC_COMPRESSION_MODE_YUV422_2C8 =     38,
        MALI_AFBC_COMPRESSION_MODE_YUV422_1C8 =     39,
        MALI_AFBC_COMPRESSION_MODE_YUV420_6C10 =     40,
        MALI_AFBC_COMPRESSION_MODE_YUV420_2C10 =     42,
        MALI_AFBC_COMPRESSION_MODE_YUV420_1C10 =     43,
        MALI_AFBC_COMPRESSION_MODE_YUV422_4C10 =     45,
        MALI_AFBC_COMPRESSION_MODE_YUV422_2C10 =     46,
        MALI_AFBC_COMPRESSION_MODE_YUV422_1C10 =     47,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_afbc_compression_mode_as_str(enum mali_afbc_compression_mode imm)
{
    switch (imm) {
    case MALI_AFBC_COMPRESSION_MODE_R8: return "R8";
    case MALI_AFBC_COMPRESSION_MODE_R8G8: return "R8G8";
    case MALI_AFBC_COMPRESSION_MODE_R5G6B5: return "R5G6B5";
    case MALI_AFBC_COMPRESSION_MODE_R4G4B4A4: return "R4G4B4A4";
    case MALI_AFBC_COMPRESSION_MODE_R5G5B5A1: return "R5G5B5A1";
    case MALI_AFBC_COMPRESSION_MODE_R8G8B8: return "R8G8B8";
    case MALI_AFBC_COMPRESSION_MODE_R8G8B8A8: return "R8G8B8A8";
    case MALI_AFBC_COMPRESSION_MODE_R10G10B10A2: return "R10G10B10A2";
    case MALI_AFBC_COMPRESSION_MODE_R11G11B10: return "R11G11B10";
    case MALI_AFBC_COMPRESSION_MODE_S8: return "S8";
    case MALI_AFBC_COMPRESSION_MODE_X24S8: return "X24S8";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_6C8: return "YUV420 6c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_2C8: return "YUV420 2c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_1C8: return "YUV420 1c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_4C8: return "YUV422 4c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_2C8: return "YUV422 2c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_1C8: return "YUV422 1c8";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_6C10: return "YUV420 6c10";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_2C10: return "YUV420 2c10";
    case MALI_AFBC_COMPRESSION_MODE_YUV420_1C10: return "YUV420 1c10";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_4C10: return "YUV422 4c10";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_2C10: return "YUV422 2c10";
    case MALI_AFBC_COMPRESSION_MODE_YUV422_1C10: return "YUV422 1c10";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_afrc_block_size {
        MALI_AFRC_BLOCK_SIZE_16              =      4,
        MALI_AFRC_BLOCK_SIZE_24              =      5,
        MALI_AFRC_BLOCK_SIZE_32              =      6,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_afrc_block_size_as_str(enum mali_afrc_block_size imm)
{
    switch (imm) {
    case MALI_AFRC_BLOCK_SIZE_16: return "16";
    case MALI_AFRC_BLOCK_SIZE_24: return "24";
    case MALI_AFRC_BLOCK_SIZE_32: return "32";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_afrc_format {
        MALI_AFRC_FORMAT_R8_SCAN             =      0,
        MALI_AFRC_FORMAT_R8G8_SCAN           =      1,
        MALI_AFRC_FORMAT_R8G8B8_SCAN         =      2,
        MALI_AFRC_FORMAT_R8G8B8A8_SCAN       =      3,
        MALI_AFRC_FORMAT_R8_ROT              =      4,
        MALI_AFRC_FORMAT_R8G8_ROT            =      5,
        MALI_AFRC_FORMAT_R8G8B8_ROT          =      6,
        MALI_AFRC_FORMAT_R8G8B8A8_ROT        =      7,
        MALI_AFRC_FORMAT_R10G10B10A10_SCAN   =     11,
        MALI_AFRC_FORMAT_R10G10B10A10_ROT    =     15,
        MALI_AFRC_FORMAT_R8_444_SCAN         =     64,
        MALI_AFRC_FORMAT_R8_422_SCAN         =     65,
        MALI_AFRC_FORMAT_R8_420_SCAN         =     66,
        MALI_AFRC_FORMAT_R8_444_ROT          =     68,
        MALI_AFRC_FORMAT_R8_422_ROT          =     69,
        MALI_AFRC_FORMAT_R8_420_ROT          =     70,
        MALI_AFRC_FORMAT_R8G8_444_SCAN       =     72,
        MALI_AFRC_FORMAT_R8G8_422_SCAN       =     73,
        MALI_AFRC_FORMAT_R8G8_420_SCAN       =     74,
        MALI_AFRC_FORMAT_R8G8_444_ROT        =     76,
        MALI_AFRC_FORMAT_R8G8_422_ROT        =     77,
        MALI_AFRC_FORMAT_R8G8_420_ROT        =     78,
        MALI_AFRC_FORMAT_R10_444_SCAN        =     80,
        MALI_AFRC_FORMAT_R10_422_SCAN        =     81,
        MALI_AFRC_FORMAT_R10_420_SCAN        =     82,
        MALI_AFRC_FORMAT_R10_444_ROT         =     84,
        MALI_AFRC_FORMAT_R10_422_ROT         =     85,
        MALI_AFRC_FORMAT_R10_420_ROT         =     86,
        MALI_AFRC_FORMAT_R10G10_422_SCAN     =     89,
        MALI_AFRC_FORMAT_R10G10_420_SCAN     =     90,
        MALI_AFRC_FORMAT_R10G10_422_ROT      =     93,
        MALI_AFRC_FORMAT_R10G10_420_ROT      =     94,
        MALI_AFRC_FORMAT_INVALID             =    256,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_afrc_format_as_str(enum mali_afrc_format imm)
{
    switch (imm) {
    case MALI_AFRC_FORMAT_R8_SCAN: return "R8 SCAN";
    case MALI_AFRC_FORMAT_R8G8_SCAN: return "R8G8 SCAN";
    case MALI_AFRC_FORMAT_R8G8B8_SCAN: return "R8G8B8 SCAN";
    case MALI_AFRC_FORMAT_R8G8B8A8_SCAN: return "R8G8B8A8 SCAN";
    case MALI_AFRC_FORMAT_R8_ROT: return "R8 ROT";
    case MALI_AFRC_FORMAT_R8G8_ROT: return "R8G8 ROT";
    case MALI_AFRC_FORMAT_R8G8B8_ROT: return "R8G8B8 ROT";
    case MALI_AFRC_FORMAT_R8G8B8A8_ROT: return "R8G8B8A8 ROT";
    case MALI_AFRC_FORMAT_R10G10B10A10_SCAN: return "R10G10B10A10 SCAN";
    case MALI_AFRC_FORMAT_R10G10B10A10_ROT: return "R10G10B10A10 ROT";
    case MALI_AFRC_FORMAT_R8_444_SCAN: return "R8_444 SCAN";
    case MALI_AFRC_FORMAT_R8_422_SCAN: return "R8_422 SCAN";
    case MALI_AFRC_FORMAT_R8_420_SCAN: return "R8_420 SCAN";
    case MALI_AFRC_FORMAT_R8_444_ROT: return "R8_444 ROT";
    case MALI_AFRC_FORMAT_R8_422_ROT: return "R8_422 ROT";
    case MALI_AFRC_FORMAT_R8_420_ROT: return "R8_420 ROT";
    case MALI_AFRC_FORMAT_R8G8_444_SCAN: return "R8G8_444 SCAN";
    case MALI_AFRC_FORMAT_R8G8_422_SCAN: return "R8G8_422 SCAN";
    case MALI_AFRC_FORMAT_R8G8_420_SCAN: return "R8G8_420 SCAN";
    case MALI_AFRC_FORMAT_R8G8_444_ROT: return "R8G8_444 ROT";
    case MALI_AFRC_FORMAT_R8G8_422_ROT: return "R8G8_422 ROT";
    case MALI_AFRC_FORMAT_R8G8_420_ROT: return "R8G8_420 ROT";
    case MALI_AFRC_FORMAT_R10_444_SCAN: return "R10_444 SCAN";
    case MALI_AFRC_FORMAT_R10_422_SCAN: return "R10_422 SCAN";
    case MALI_AFRC_FORMAT_R10_420_SCAN: return "R10_420 SCAN";
    case MALI_AFRC_FORMAT_R10_444_ROT: return "R10_444 ROT";
    case MALI_AFRC_FORMAT_R10_422_ROT: return "R10_422 ROT";
    case MALI_AFRC_FORMAT_R10_420_ROT: return "R10_420 ROT";
    case MALI_AFRC_FORMAT_R10G10_422_SCAN: return "R10G10_422 SCAN";
    case MALI_AFRC_FORMAT_R10G10_420_SCAN: return "R10G10_420 SCAN";
    case MALI_AFRC_FORMAT_R10G10_422_ROT: return "R10G10_422 ROT";
    case MALI_AFRC_FORMAT_R10G10_420_ROT: return "R10G10_420 ROT";
    case MALI_AFRC_FORMAT_INVALID: return "INVALID";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_TEXTURE {
   enum mali_descriptor_type            type;
   enum mali_texture_dimension          dimension;
   bool                                 sample_corner_position;
   bool                                 normalize_coordinates;
   uint32_t                             format;
   uint32_t                             width;
   uint32_t                             height;
   uint32_t                             swizzle;
   bool                                 texel_interleave;
   uint32_t                             levels;
   uint32_t                             minimum_level;
   float                                minimum_lod;
   uint32_t                             sample_count;
   float                                maximum_lod;
   uint64_t                             surfaces;
   uint32_t                             array_size;
   uint32_t                             depth;
};

#define MALI_TEXTURE_header                     \
   .type = MALI_DESCRIPTOR_TYPE_TEXTURE,  \
   .sample_corner_position = false,  \
   .normalize_coordinates = false,  \
   .levels = 1,  \
   .minimum_lod = 0,  \
   .sample_count = 1,  \
   .maximum_lod = 0,  \
   .array_size = 1,  \
   .depth = 1

#define MALI_TEXTURE_LENGTH 32
#define MALI_TEXTURE_ALIGN 32
struct mali_texture_packed { uint32_t opaque[8]; };
#define MALI_TEXTURE_PACKED_T struct mali_texture_packed
#define MALI_TEXTURE_pack(__packed, __unpacked) \
do { \
   MALI_TEXTURE_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   assert((__unpacked)->levels >= 1); \
   assert(IS_POT_NONZERO((__unpacked)->sample_count)); \
   assert((__unpacked)->array_size >= 1); \
   assert((__unpacked)->depth >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->dimension, 4, 6) | \
            util_bitpack_uint((__unpacked)->sample_corner_position, 8, 8) | \
            util_bitpack_uint((__unpacked)->normalize_coordinates, 9, 9) | \
            util_bitpack_uint((__unpacked)->format, 10, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->swizzle, 0, 11) | \
            util_bitpack_uint((__unpacked)->texel_interleave, 12, 12) | \
            util_bitpack_uint((__unpacked)->levels - 1, 16, 20) | \
            util_bitpack_uint((__unpacked)->minimum_level, 24, 28); \
   __tmp_packed.opaque[ 3] = util_bitpack_ufixed_clamp((__unpacked)->minimum_lod, 0, 12, 8) | \
            util_bitpack_uint(util_logbase2((__unpacked)->sample_count), 13, 15) | \
            util_bitpack_ufixed_clamp((__unpacked)->maximum_lod, 16, 28, 8); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->surfaces, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->surfaces, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->array_size - 1, 0, 15); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->depth - 1, 0, 15); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TEXTURE_unpack(__packed, __unpacked) \
do { \
   MALI_TEXTURE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x80) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 0\n"); \
   if (__tmp_packed.opaque[2] & 0xe0e0e000) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xe0000000) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 3\n"); \
   if (__tmp_packed.opaque[6] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->dimension, &__tmp_packed.opaque[0], 4, 6); \
   __gen_unpack_uint((__unpacked)->sample_corner_position, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->normalize_coordinates, &__tmp_packed.opaque[0], 9, 9); \
   __gen_unpack_uint((__unpacked)->format, &__tmp_packed.opaque[0], 10, 31); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 32, 47); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 48, 63); \
   (__unpacked)->height = (__unpacked)->height + 1; \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 64, 75); \
   __gen_unpack_uint((__unpacked)->texel_interleave, &__tmp_packed.opaque[0], 76, 76); \
   __gen_unpack_uint((__unpacked)->levels, &__tmp_packed.opaque[0], 80, 84); \
   (__unpacked)->levels = (__unpacked)->levels + 1; \
   __gen_unpack_uint((__unpacked)->minimum_level, &__tmp_packed.opaque[0], 88, 92); \
   __gen_unpack_ulod((__unpacked)->minimum_lod, &__tmp_packed.opaque[0], 96, 108); \
   __gen_unpack_uint((__unpacked)->sample_count, &__tmp_packed.opaque[0], 109, 111); \
   (__unpacked)->sample_count = 1U << (__unpacked)->sample_count; \
   __gen_unpack_ulod((__unpacked)->maximum_lod, &__tmp_packed.opaque[0], 112, 124); \
   __gen_unpack_uint((__unpacked)->surfaces, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->array_size, &__tmp_packed.opaque[0], 192, 207); \
   (__unpacked)->array_size = (__unpacked)->array_size + 1; \
   __gen_unpack_uint((__unpacked)->depth, &__tmp_packed.opaque[0], 224, 239); \
   (__unpacked)->depth = (__unpacked)->depth + 1; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TEXTURE_print(FILE *fp, const struct MALI_TEXTURE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sDimension: %s\n", indent, "", mali_texture_dimension_as_str(values->dimension));
   fprintf(fp, "%*sSample corner position: %s\n", indent, "", values->sample_corner_position ? "true" : "false");
   fprintf(fp, "%*sNormalize coordinates: %s\n", indent, "", values->normalize_coordinates ? "true" : "false");
   mali_pixel_format_print(fp, values->format);
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sTexel interleave: %s\n", indent, "", values->texel_interleave ? "true" : "false");
   fprintf(fp, "%*sLevels: %u\n", indent, "", values->levels);
   fprintf(fp, "%*sMinimum level: %u\n", indent, "", values->minimum_level);
   fprintf(fp, "%*sMinimum LOD: %f\n", indent, "", values->minimum_lod);
   fprintf(fp, "%*sSample count: %u\n", indent, "", values->sample_count);
   fprintf(fp, "%*sMaximum LOD: %f\n", indent, "", values->maximum_lod);
   fprintf(fp, "%*sSurfaces: 0x%" PRIx64 "\n", indent, "", values->surfaces);
   fprintf(fp, "%*sArray size: %u\n", indent, "", values->array_size);
   fprintf(fp, "%*sDepth: %u\n", indent, "", values->depth);
}

#endif
struct MALI_PLANE_HEADER {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   uint32_t                             ignore;
};

#define MALI_PLANE_HEADER_header                \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_NULL

#define MALI_PLANE_HEADER_LENGTH 4
#define MALI_PLANE_HEADER_ALIGN 32
struct mali_plane_header_packed { uint32_t opaque[1]; };
#define MALI_PLANE_HEADER_PACKED_T struct mali_plane_header_packed
#define MALI_PLANE_HEADER_pack(__packed, __unpacked) \
do { \
   MALI_PLANE_HEADER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->ignore, 8, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PLANE_HEADER_unpack(__packed, __unpacked) \
do { \
   MALI_PLANE_HEADER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->ignore, &__tmp_packed.opaque[0], 8, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PLANE_HEADER_print(FILE *fp, const struct MALI_PLANE_HEADER * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sIgnore: %u\n", indent, "", values->ignore);
}

#endif
struct MALI_NULL_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
};

#define MALI_NULL_PLANE_header                  \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_NULL

#define MALI_NULL_PLANE_LENGTH 32
#define MALI_NULL_PLANE_ALIGN 32
struct mali_null_plane_packed { uint32_t opaque[8]; };
#define MALI_NULL_PLANE_PACKED_T struct mali_null_plane_packed
#define MALI_NULL_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_NULL_PLANE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_NULL_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_NULL_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Null Plane unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_NULL_PLANE_print(FILE *fp, const struct MALI_NULL_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
}

#endif
struct MALI_GENERIC_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   enum mali_clump_ordering             clump_ordering;
   enum mali_clump_format               clump_format;
   uint64_t                             size;
   uint64_t                             pointer;
   uint32_t                             size_hi;
   uint32_t                             row_stride;
   uint32_t                             slice_stride_hi;
   uint64_t                             slice_stride;
   uint32_t                             width;
   uint32_t                             height;
};

#define MALI_GENERIC_PLANE_header               \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_GENERIC,  \
   .width = 1,  \
   .height = 1

#define MALI_GENERIC_PLANE_LENGTH 32
#define MALI_GENERIC_PLANE_ALIGN 32
struct mali_generic_plane_packed { uint32_t opaque[8]; };
#define MALI_GENERIC_PLANE_PACKED_T struct mali_generic_plane_packed
#define MALI_GENERIC_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_GENERIC_PLANE_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->clump_ordering, 8, 11) | \
            util_bitpack_uint((__unpacked)->clump_format, 24, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 47); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 47) >> 32 | \
            util_bitpack_uint((__unpacked)->size_hi, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->slice_stride_hi, 27, 31); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->slice_stride, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_GENERIC_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_GENERIC_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff000) fprintf(stderr, "XXX: Invalid field of Generic Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Generic Plane unpacked at word 5\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->clump_ordering, &__tmp_packed.opaque[0], 8, 11); \
   __gen_unpack_uint((__unpacked)->clump_format, &__tmp_packed.opaque[0], 24, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 111); \
   __gen_unpack_uint((__unpacked)->size_hi, &__tmp_packed.opaque[0], 112, 127); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 128, 154); \
   __gen_unpack_uint((__unpacked)->slice_stride_hi, &__tmp_packed.opaque[0], 155, 159); \
   __gen_unpack_uint((__unpacked)->slice_stride, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 224, 239); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 240, 255); \
   (__unpacked)->height = (__unpacked)->height + 1; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_GENERIC_PLANE_print(FILE *fp, const struct MALI_GENERIC_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sClump ordering: %s\n", indent, "", mali_clump_ordering_as_str(values->clump_ordering));
   fprintf(fp, "%*sClump format: %s\n", indent, "", mali_clump_format_as_str(values->clump_format));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sSize hi: %u\n", indent, "", values->size_hi);
   fprintf(fp, "%*sRow stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSlice stride hi: %u\n", indent, "", values->slice_stride_hi);
   fprintf(fp, "%*sSlice stride: 0x%" PRIx64 "\n", indent, "", values->slice_stride);
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
}

#endif
struct MALI_ASTC_2D_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   enum mali_clump_ordering             clump_ordering;
   bool                                 decode_hdr;
   bool                                 decode_wide;
   enum mali_astc_2d_dimension          block_width;
   enum mali_astc_2d_dimension          block_height;
   uint64_t                             size;
   uint64_t                             pointer;
   uint32_t                             size_hi;
   uint32_t                             row_stride;
   uint32_t                             slice_stride_hi;
   uint64_t                             slice_stride;
   uint32_t                             width;
   uint32_t                             height;
};

#define MALI_ASTC_2D_PLANE_header               \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_ASTC_2D,  \
   .width = 1,  \
   .height = 1

#define MALI_ASTC_2D_PLANE_LENGTH 32
#define MALI_ASTC_2D_PLANE_ALIGN 32
struct mali_astc_2d_plane_packed { uint32_t opaque[8]; };
#define MALI_ASTC_2D_PLANE_PACKED_T struct mali_astc_2d_plane_packed
#define MALI_ASTC_2D_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_ASTC_2D_PLANE_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->clump_ordering, 8, 11) | \
            util_bitpack_uint((__unpacked)->decode_hdr, 24, 24) | \
            util_bitpack_uint((__unpacked)->decode_wide, 25, 25) | \
            util_bitpack_uint((__unpacked)->block_width, 26, 28) | \
            util_bitpack_uint((__unpacked)->block_height, 29, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 47); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 47) >> 32 | \
            util_bitpack_uint((__unpacked)->size_hi, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->slice_stride_hi, 27, 31); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->slice_stride, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ASTC_2D_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_ASTC_2D_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff000) fprintf(stderr, "XXX: Invalid field of ASTC 2D Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ASTC 2D Plane unpacked at word 5\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->clump_ordering, &__tmp_packed.opaque[0], 8, 11); \
   __gen_unpack_uint((__unpacked)->decode_hdr, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->decode_wide, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->block_width, &__tmp_packed.opaque[0], 26, 28); \
   __gen_unpack_uint((__unpacked)->block_height, &__tmp_packed.opaque[0], 29, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 111); \
   __gen_unpack_uint((__unpacked)->size_hi, &__tmp_packed.opaque[0], 112, 127); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 128, 154); \
   __gen_unpack_uint((__unpacked)->slice_stride_hi, &__tmp_packed.opaque[0], 155, 159); \
   __gen_unpack_uint((__unpacked)->slice_stride, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 224, 239); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 240, 255); \
   (__unpacked)->height = (__unpacked)->height + 1; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ASTC_2D_PLANE_print(FILE *fp, const struct MALI_ASTC_2D_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sClump ordering: %s\n", indent, "", mali_clump_ordering_as_str(values->clump_ordering));
   fprintf(fp, "%*sDecode HDR: %s\n", indent, "", values->decode_hdr ? "true" : "false");
   fprintf(fp, "%*sDecode Wide: %s\n", indent, "", values->decode_wide ? "true" : "false");
   fprintf(fp, "%*sBlock width: %s\n", indent, "", mali_astc_2d_dimension_as_str(values->block_width));
   fprintf(fp, "%*sBlock height: %s\n", indent, "", mali_astc_2d_dimension_as_str(values->block_height));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sSize hi: %u\n", indent, "", values->size_hi);
   fprintf(fp, "%*sRow stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSlice stride hi: %u\n", indent, "", values->slice_stride_hi);
   fprintf(fp, "%*sSlice stride: 0x%" PRIx64 "\n", indent, "", values->slice_stride);
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
}

#endif
struct MALI_ASTC_3D_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   enum mali_clump_ordering             clump_ordering;
   bool                                 decode_hdr;
   bool                                 decode_wide;
   enum mali_astc_3d_dimension          block_width;
   enum mali_astc_3d_dimension          block_height;
   enum mali_astc_3d_dimension          block_depth;
   uint64_t                             size;
   uint64_t                             pointer;
   uint32_t                             size_hi;
   uint32_t                             row_stride;
   uint32_t                             slice_stride_hi;
   uint64_t                             slice_stride;
   uint32_t                             width;
   uint32_t                             height;
};

#define MALI_ASTC_3D_PLANE_header               \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_ASTC_3D,  \
   .width = 1,  \
   .height = 1

#define MALI_ASTC_3D_PLANE_LENGTH 32
#define MALI_ASTC_3D_PLANE_ALIGN 32
struct mali_astc_3d_plane_packed { uint32_t opaque[8]; };
#define MALI_ASTC_3D_PLANE_PACKED_T struct mali_astc_3d_plane_packed
#define MALI_ASTC_3D_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_ASTC_3D_PLANE_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->clump_ordering, 8, 11) | \
            util_bitpack_uint((__unpacked)->decode_hdr, 24, 24) | \
            util_bitpack_uint((__unpacked)->decode_wide, 25, 25) | \
            util_bitpack_uint((__unpacked)->block_width, 26, 27) | \
            util_bitpack_uint((__unpacked)->block_height, 28, 29) | \
            util_bitpack_uint((__unpacked)->block_depth, 30, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 47); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 47) >> 32 | \
            util_bitpack_uint((__unpacked)->size_hi, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->slice_stride_hi, 27, 31); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->slice_stride, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ASTC_3D_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_ASTC_3D_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff000) fprintf(stderr, "XXX: Invalid field of ASTC 3D Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ASTC 3D Plane unpacked at word 5\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->clump_ordering, &__tmp_packed.opaque[0], 8, 11); \
   __gen_unpack_uint((__unpacked)->decode_hdr, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->decode_wide, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->block_width, &__tmp_packed.opaque[0], 26, 27); \
   __gen_unpack_uint((__unpacked)->block_height, &__tmp_packed.opaque[0], 28, 29); \
   __gen_unpack_uint((__unpacked)->block_depth, &__tmp_packed.opaque[0], 30, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 111); \
   __gen_unpack_uint((__unpacked)->size_hi, &__tmp_packed.opaque[0], 112, 127); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 128, 154); \
   __gen_unpack_uint((__unpacked)->slice_stride_hi, &__tmp_packed.opaque[0], 155, 159); \
   __gen_unpack_uint((__unpacked)->slice_stride, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 224, 239); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 240, 255); \
   (__unpacked)->height = (__unpacked)->height + 1; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ASTC_3D_PLANE_print(FILE *fp, const struct MALI_ASTC_3D_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sClump ordering: %s\n", indent, "", mali_clump_ordering_as_str(values->clump_ordering));
   fprintf(fp, "%*sDecode HDR: %s\n", indent, "", values->decode_hdr ? "true" : "false");
   fprintf(fp, "%*sDecode Wide: %s\n", indent, "", values->decode_wide ? "true" : "false");
   fprintf(fp, "%*sBlock width: %s\n", indent, "", mali_astc_3d_dimension_as_str(values->block_width));
   fprintf(fp, "%*sBlock height: %s\n", indent, "", mali_astc_3d_dimension_as_str(values->block_height));
   fprintf(fp, "%*sBlock depth: %s\n", indent, "", mali_astc_3d_dimension_as_str(values->block_depth));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sSize hi: %u\n", indent, "", values->size_hi);
   fprintf(fp, "%*sRow stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSlice stride hi: %u\n", indent, "", values->slice_stride_hi);
   fprintf(fp, "%*sSlice stride: 0x%" PRIx64 "\n", indent, "", values->slice_stride);
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
}

#endif
struct MALI_AFBC_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   enum mali_afbc_superblock_size       superblock_size;
   bool                                 ytr;
   bool                                 split_block;
   bool                                 alpha_hint;
   bool                                 tiled_header;
   bool                                 prefetch;
   enum mali_afbc_compression_mode      compression_mode;
   uint64_t                             size;
   uint64_t                             pointer;
   uint32_t                             size_hi;
   uint32_t                             header_row_stride;
   uint32_t                             header_slice_stride_hi;
   uint64_t                             header_slice_size;
   uint64_t                             header_slice_stride;
   uint32_t                             width;
   uint32_t                             height;
};

#define MALI_AFBC_PLANE_header                  \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_AFBC,  \
   .width = 1,  \
   .height = 1

#define MALI_AFBC_PLANE_LENGTH 32
#define MALI_AFBC_PLANE_ALIGN 32
struct mali_afbc_plane_packed { uint32_t opaque[8]; };
#define MALI_AFBC_PLANE_PACKED_T struct mali_afbc_plane_packed
#define MALI_AFBC_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_AFBC_PLANE_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->superblock_size, 8, 10) | \
            util_bitpack_uint((__unpacked)->ytr, 16, 16) | \
            util_bitpack_uint((__unpacked)->split_block, 17, 17) | \
            util_bitpack_uint((__unpacked)->alpha_hint, 18, 18) | \
            util_bitpack_uint((__unpacked)->tiled_header, 19, 19) | \
            util_bitpack_uint((__unpacked)->prefetch, 20, 20) | \
            util_bitpack_uint((__unpacked)->compression_mode, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 47); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 47) >> 32 | \
            util_bitpack_uint((__unpacked)->size_hi, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->header_row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->header_slice_stride_hi, 27, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->header_slice_size, 0, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->header_slice_stride, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFBC_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_AFBC_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x3e0f800) fprintf(stderr, "XXX: Invalid field of AFBC Plane unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->superblock_size, &__tmp_packed.opaque[0], 8, 10); \
   __gen_unpack_uint((__unpacked)->ytr, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->split_block, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->alpha_hint, &__tmp_packed.opaque[0], 18, 18); \
   __gen_unpack_uint((__unpacked)->tiled_header, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->prefetch, &__tmp_packed.opaque[0], 20, 20); \
   __gen_unpack_uint((__unpacked)->compression_mode, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 111); \
   __gen_unpack_uint((__unpacked)->size_hi, &__tmp_packed.opaque[0], 112, 127); \
   __gen_unpack_uint((__unpacked)->header_row_stride, &__tmp_packed.opaque[0], 128, 154); \
   __gen_unpack_uint((__unpacked)->header_slice_stride_hi, &__tmp_packed.opaque[0], 155, 159); \
   __gen_unpack_uint((__unpacked)->header_slice_size, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_uint((__unpacked)->header_slice_stride, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 224, 239); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 240, 255); \
   (__unpacked)->height = (__unpacked)->height + 1; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFBC_PLANE_print(FILE *fp, const struct MALI_AFBC_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sSuperblock size: %s\n", indent, "", mali_afbc_superblock_size_as_str(values->superblock_size));
   fprintf(fp, "%*sYTR: %s\n", indent, "", values->ytr ? "true" : "false");
   fprintf(fp, "%*sSplit block: %s\n", indent, "", values->split_block ? "true" : "false");
   fprintf(fp, "%*sAlpha hint: %s\n", indent, "", values->alpha_hint ? "true" : "false");
   fprintf(fp, "%*sTiled header: %s\n", indent, "", values->tiled_header ? "true" : "false");
   fprintf(fp, "%*sPrefetch: %s\n", indent, "", values->prefetch ? "true" : "false");
   fprintf(fp, "%*sCompression mode: %s\n", indent, "", mali_afbc_compression_mode_as_str(values->compression_mode));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sSize hi: %u\n", indent, "", values->size_hi);
   fprintf(fp, "%*sHeader row stride: %u\n", indent, "", values->header_row_stride);
   fprintf(fp, "%*sHeader slice stride hi: %u\n", indent, "", values->header_slice_stride_hi);
   fprintf(fp, "%*sHeader slice size: 0x%" PRIx64 "\n", indent, "", values->header_slice_size);
   fprintf(fp, "%*sHeader slice stride: 0x%" PRIx64 "\n", indent, "", values->header_slice_stride);
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
}

#endif
struct MALI_CHROMA_2P_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   enum mali_clump_ordering             clump_ordering;
   enum mali_clump_format               clump_format;
   uint64_t                             size;
   uint64_t                             pointer;
   uint32_t                             size_hi;
   uint32_t                             row_stride;
   uint32_t                             width;
   uint32_t                             height;
   uint64_t                             secondary_pointer;
};

#define MALI_CHROMA_2P_PLANE_header             \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_CHROMA_2P,  \
   .width = 1,  \
   .height = 1

#define MALI_CHROMA_2P_PLANE_LENGTH 32
#define MALI_CHROMA_2P_PLANE_ALIGN 32
struct mali_chroma_2p_plane_packed { uint32_t opaque[8]; };
#define MALI_CHROMA_2P_PLANE_PACKED_T struct mali_chroma_2p_plane_packed
#define MALI_CHROMA_2P_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_CHROMA_2P_PLANE_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->clump_ordering, 8, 11) | \
            util_bitpack_uint((__unpacked)->clump_format, 24, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 47); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 47) >> 32 | \
            util_bitpack_uint((__unpacked)->size_hi, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->row_stride, 0, 26); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->secondary_pointer, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->secondary_pointer, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CHROMA_2P_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_CHROMA_2P_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff000) fprintf(stderr, "XXX: Invalid field of Chroma 2p Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[4] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of Chroma 2p Plane unpacked at word 4\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->clump_ordering, &__tmp_packed.opaque[0], 8, 11); \
   __gen_unpack_uint((__unpacked)->clump_format, &__tmp_packed.opaque[0], 24, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 111); \
   __gen_unpack_uint((__unpacked)->size_hi, &__tmp_packed.opaque[0], 112, 127); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 128, 154); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 160, 175); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 176, 191); \
   (__unpacked)->height = (__unpacked)->height + 1; \
   __gen_unpack_uint((__unpacked)->secondary_pointer, &__tmp_packed.opaque[0], 192, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CHROMA_2P_PLANE_print(FILE *fp, const struct MALI_CHROMA_2P_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sClump ordering: %s\n", indent, "", mali_clump_ordering_as_str(values->clump_ordering));
   fprintf(fp, "%*sClump format: %s\n", indent, "", mali_clump_format_as_str(values->clump_format));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sSize hi: %u\n", indent, "", values->size_hi);
   fprintf(fp, "%*sRow stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
   fprintf(fp, "%*sSecondary Pointer: 0x%" PRIx64 "\n", indent, "", values->secondary_pointer);
}

#endif
struct MALI_AFRC_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   uint32_t                             codec_arguments;
   enum mali_afrc_block_size            block_size;
   enum mali_afrc_format                format;
   uint64_t                             size;
   uint64_t                             pointer;
   uint32_t                             size_hi;
   uint32_t                             row_stride;
   uint32_t                             slice_stride_hi;
   uint64_t                             slice_stride;
   uint32_t                             width;
   uint32_t                             height;
};

#define MALI_AFRC_PLANE_header                  \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_AFRC,  \
   .width = 1,  \
   .height = 1

#define MALI_AFRC_PLANE_LENGTH 32
#define MALI_AFRC_PLANE_ALIGN 32
struct mali_afrc_plane_packed { uint32_t opaque[8]; };
#define MALI_AFRC_PLANE_PACKED_T struct mali_afrc_plane_packed
#define MALI_AFRC_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_AFRC_PLANE_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->codec_arguments, 8, 15) | \
            util_bitpack_uint((__unpacked)->block_size, 20, 23) | \
            util_bitpack_uint((__unpacked)->format, 24, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 47); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 47) >> 32 | \
            util_bitpack_uint((__unpacked)->size_hi, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->slice_stride_hi, 27, 31); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->slice_stride, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFRC_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_AFRC_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf0000) fprintf(stderr, "XXX: Invalid field of AFRC Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFRC Plane unpacked at word 5\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->codec_arguments, &__tmp_packed.opaque[0], 8, 15); \
   __gen_unpack_uint((__unpacked)->block_size, &__tmp_packed.opaque[0], 20, 23); \
   __gen_unpack_uint((__unpacked)->format, &__tmp_packed.opaque[0], 24, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 111); \
   __gen_unpack_uint((__unpacked)->size_hi, &__tmp_packed.opaque[0], 112, 127); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 128, 154); \
   __gen_unpack_uint((__unpacked)->slice_stride_hi, &__tmp_packed.opaque[0], 155, 159); \
   __gen_unpack_uint((__unpacked)->slice_stride, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 224, 239); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 240, 255); \
   (__unpacked)->height = (__unpacked)->height + 1; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFRC_PLANE_print(FILE *fp, const struct MALI_AFRC_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sCodec arguments: %u\n", indent, "", values->codec_arguments);
   fprintf(fp, "%*sBlock size: %s\n", indent, "", mali_afrc_block_size_as_str(values->block_size));
   fprintf(fp, "%*sFormat: %s\n", indent, "", mali_afrc_format_as_str(values->format));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sSize hi: %u\n", indent, "", values->size_hi);
   fprintf(fp, "%*sRow stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSlice stride hi: %u\n", indent, "", values->slice_stride_hi);
   fprintf(fp, "%*sSlice stride: 0x%" PRIx64 "\n", indent, "", values->slice_stride);
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
}

#endif
struct MALI_AFRC_CHROMA_2P_PLANE {
   enum mali_descriptor_type            type;
   enum mali_plane_type                 plane_type;
   uint32_t                             codec_arguments;
   enum mali_afrc_block_size            block_size;
   enum mali_afrc_format                format;
   uint64_t                             size;
   uint64_t                             pointer;
   uint32_t                             size_hi;
   uint32_t                             row_stride;
   uint32_t                             width;
   uint32_t                             height;
   uint64_t                             secondary_pointer;
};

#define MALI_AFRC_CHROMA_2P_PLANE_header        \
   .type = MALI_DESCRIPTOR_TYPE_PLANE,  \
   .plane_type = MALI_PLANE_TYPE_AFRC_CHROMA_2P,  \
   .width = 1,  \
   .height = 1

#define MALI_AFRC_CHROMA_2P_PLANE_LENGTH 32
#define MALI_AFRC_CHROMA_2P_PLANE_ALIGN 32
struct mali_afrc_chroma_2p_plane_packed { uint32_t opaque[8]; };
#define MALI_AFRC_CHROMA_2P_PLANE_PACKED_T struct mali_afrc_chroma_2p_plane_packed
#define MALI_AFRC_CHROMA_2P_PLANE_pack(__packed, __unpacked) \
do { \
   MALI_AFRC_CHROMA_2P_PLANE_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->plane_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->codec_arguments, 8, 15) | \
            util_bitpack_uint((__unpacked)->block_size, 20, 23) | \
            util_bitpack_uint((__unpacked)->format, 24, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->pointer, 0, 47); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->pointer, 0, 47) >> 32 | \
            util_bitpack_uint((__unpacked)->size_hi, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->row_stride, 0, 26); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->secondary_pointer, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->secondary_pointer, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFRC_CHROMA_2P_PLANE_unpack(__packed, __unpacked) \
do { \
   MALI_AFRC_CHROMA_2P_PLANE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf0000) fprintf(stderr, "XXX: Invalid field of AFRC Chroma 2p Plane unpacked at word 0\n"); \
   if (__tmp_packed.opaque[4] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of AFRC Chroma 2p Plane unpacked at word 4\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->plane_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->codec_arguments, &__tmp_packed.opaque[0], 8, 15); \
   __gen_unpack_uint((__unpacked)->block_size, &__tmp_packed.opaque[0], 20, 23); \
   __gen_unpack_uint((__unpacked)->format, &__tmp_packed.opaque[0], 24, 31); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 64, 111); \
   __gen_unpack_uint((__unpacked)->size_hi, &__tmp_packed.opaque[0], 112, 127); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 128, 154); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 160, 175); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 176, 191); \
   (__unpacked)->height = (__unpacked)->height + 1; \
   __gen_unpack_uint((__unpacked)->secondary_pointer, &__tmp_packed.opaque[0], 192, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFRC_CHROMA_2P_PLANE_print(FILE *fp, const struct MALI_AFRC_CHROMA_2P_PLANE * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sPlane type: %s\n", indent, "", mali_plane_type_as_str(values->plane_type));
   fprintf(fp, "%*sCodec arguments: %u\n", indent, "", values->codec_arguments);
   fprintf(fp, "%*sBlock size: %s\n", indent, "", mali_afrc_block_size_as_str(values->block_size));
   fprintf(fp, "%*sFormat: %s\n", indent, "", mali_afrc_format_as_str(values->format));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sSize hi: %u\n", indent, "", values->size_hi);
   fprintf(fp, "%*sRow stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
   fprintf(fp, "%*sSecondary Pointer: 0x%" PRIx64 "\n", indent, "", values->secondary_pointer);
}

#endif
enum mali_shader_register_allocation {
        MALI_SHADER_REGISTER_ALLOCATION_64_PER_THREAD =      0,
        MALI_SHADER_REGISTER_ALLOCATION_32_PER_THREAD =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_shader_register_allocation_as_str(enum mali_shader_register_allocation imm)
{
    switch (imm) {
    case MALI_SHADER_REGISTER_ALLOCATION_64_PER_THREAD: return "64 Per Thread";
    case MALI_SHADER_REGISTER_ALLOCATION_32_PER_THREAD: return "32 Per Thread";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_flush_to_zero_mode {
        MALI_FLUSH_TO_ZERO_MODE_PRESERVE_SUBNORMALS =      0,
        MALI_FLUSH_TO_ZERO_MODE_DX11         =      1,
        MALI_FLUSH_TO_ZERO_MODE_ALWAYS       =      2,
        MALI_FLUSH_TO_ZERO_MODE_ABRUPT       =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_flush_to_zero_mode_as_str(enum mali_flush_to_zero_mode imm)
{
    switch (imm) {
    case MALI_FLUSH_TO_ZERO_MODE_PRESERVE_SUBNORMALS: return "Preserve subnormals";
    case MALI_FLUSH_TO_ZERO_MODE_DX11: return "DX11";
    case MALI_FLUSH_TO_ZERO_MODE_ALWAYS: return "Always";
    case MALI_FLUSH_TO_ZERO_MODE_ABRUPT: return "Abrupt";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_PRELOAD {
   uint32_t                             r48_r63;
   bool                                 r55;
   bool                                 r56;
   bool                                 r57;
   bool                                 r58;
   bool                                 r59;
   bool                                 r60;
   bool                                 r61;
   bool                                 r62;
   bool                                 r63;
};

#define MALI_PRELOAD_header                     \
   0

#define MALI_PRELOAD_LENGTH 4
struct mali_preload_packed { uint32_t opaque[1]; };
#define MALI_PRELOAD_PACKED_T struct mali_preload_packed
#define MALI_PRELOAD_pack(__packed, __unpacked) \
do { \
   MALI_PRELOAD_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->r48_r63, 0, 15) | \
            util_bitpack_uint((__unpacked)->r55, 7, 7) | \
            util_bitpack_uint((__unpacked)->r56, 8, 8) | \
            util_bitpack_uint((__unpacked)->r57, 9, 9) | \
            util_bitpack_uint((__unpacked)->r58, 10, 10) | \
            util_bitpack_uint((__unpacked)->r59, 11, 11) | \
            util_bitpack_uint((__unpacked)->r60, 12, 12) | \
            util_bitpack_uint((__unpacked)->r61, 13, 13) | \
            util_bitpack_uint((__unpacked)->r62, 14, 14) | \
            util_bitpack_uint((__unpacked)->r63, 15, 15); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PRELOAD_unpack(__packed, __unpacked) \
do { \
   MALI_PRELOAD_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Preload unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->r48_r63, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->r55, &__tmp_packed.opaque[0], 7, 7); \
   __gen_unpack_uint((__unpacked)->r56, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->r57, &__tmp_packed.opaque[0], 9, 9); \
   __gen_unpack_uint((__unpacked)->r58, &__tmp_packed.opaque[0], 10, 10); \
   __gen_unpack_uint((__unpacked)->r59, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->r60, &__tmp_packed.opaque[0], 12, 12); \
   __gen_unpack_uint((__unpacked)->r61, &__tmp_packed.opaque[0], 13, 13); \
   __gen_unpack_uint((__unpacked)->r62, &__tmp_packed.opaque[0], 14, 14); \
   __gen_unpack_uint((__unpacked)->r63, &__tmp_packed.opaque[0], 15, 15); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PRELOAD_print(FILE *fp, const struct MALI_PRELOAD * values, unsigned indent)
{
   fprintf(fp, "%*sR48-R63: 0x%x\n", indent, "", values->r48_r63);
   fprintf(fp, "%*sR55: %s\n", indent, "", values->r55 ? "true" : "false");
   fprintf(fp, "%*sR56: %s\n", indent, "", values->r56 ? "true" : "false");
   fprintf(fp, "%*sR57: %s\n", indent, "", values->r57 ? "true" : "false");
   fprintf(fp, "%*sR58: %s\n", indent, "", values->r58 ? "true" : "false");
   fprintf(fp, "%*sR59: %s\n", indent, "", values->r59 ? "true" : "false");
   fprintf(fp, "%*sR60: %s\n", indent, "", values->r60 ? "true" : "false");
   fprintf(fp, "%*sR61: %s\n", indent, "", values->r61 ? "true" : "false");
   fprintf(fp, "%*sR62: %s\n", indent, "", values->r62 ? "true" : "false");
   fprintf(fp, "%*sR63: %s\n", indent, "", values->r63 ? "true" : "false");
}

#endif
enum mali_coverage_bitmask_type {
        MALI_COVERAGE_BITMASK_TYPE_DX        =      0,
        MALI_COVERAGE_BITMASK_TYPE_GL        =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_coverage_bitmask_type_as_str(enum mali_coverage_bitmask_type imm)
{
    switch (imm) {
    case MALI_COVERAGE_BITMASK_TYPE_DX: return "DX";
    case MALI_COVERAGE_BITMASK_TYPE_GL: return "GL";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_SHADER_PROGRAM {
   enum mali_descriptor_type            type;
   enum mali_shader_stage               stage;
   enum mali_coverage_bitmask_type      fragment_coverage_bitmask_type;
   bool                                 suppress_nan;
   enum mali_flush_to_zero_mode         flush_to_zero_mode;
   bool                                 suppress_inf;
   bool                                 requires_helper_threads;
   bool                                 shader_contains_jump_ex;
   enum mali_shader_register_allocation register_allocation;
   struct MALI_PRELOAD                  preload;
   uint32_t                             max_warps;
   uint64_t                             binary;
};

#define MALI_SHADER_PROGRAM_header              \
   .type = MALI_DESCRIPTOR_TYPE_SHADER,  \
   .preload = { MALI_PRELOAD_header }

#define MALI_SHADER_PROGRAM_LENGTH 32
#define MALI_SHADER_PROGRAM_ALIGN 32
struct mali_shader_program_packed { uint32_t opaque[8]; };
#define MALI_SHADER_PROGRAM_PACKED_T struct mali_shader_program_packed
#define MALI_SHADER_PROGRAM_pack(__packed, __unpacked) \
do { \
   MALI_SHADER_PROGRAM_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->stage, 4, 7) | \
            util_bitpack_uint((__unpacked)->fragment_coverage_bitmask_type, 8, 8) | \
            util_bitpack_uint((__unpacked)->suppress_nan, 16, 16) | \
            util_bitpack_uint((__unpacked)->flush_to_zero_mode, 17, 18) | \
            util_bitpack_uint((__unpacked)->suppress_inf, 19, 19) | \
            util_bitpack_uint((__unpacked)->requires_helper_threads, 28, 28) | \
            util_bitpack_uint((__unpacked)->shader_contains_jump_ex, 29, 29) | \
            util_bitpack_uint((__unpacked)->register_allocation, 30, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->preload.r48_r63, 0, 15) | \
            util_bitpack_uint((__unpacked)->preload.r55, 7, 7) | \
            util_bitpack_uint((__unpacked)->preload.r56, 8, 8) | \
            util_bitpack_uint((__unpacked)->preload.r57, 9, 9) | \
            util_bitpack_uint((__unpacked)->preload.r58, 10, 10) | \
            util_bitpack_uint((__unpacked)->preload.r59, 11, 11) | \
            util_bitpack_uint((__unpacked)->preload.r60, 12, 12) | \
            util_bitpack_uint((__unpacked)->preload.r61, 13, 13) | \
            util_bitpack_uint((__unpacked)->preload.r62, 14, 14) | \
            util_bitpack_uint((__unpacked)->preload.r63, 15, 15) | \
            util_bitpack_uint((__unpacked)->max_warps, 16, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->binary, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->binary, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SHADER_PROGRAM_unpack(__packed, __unpacked) \
do { \
   MALI_SHADER_PROGRAM_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff0fe00) fprintf(stderr, "XXX: Invalid field of Shader Program unpacked at word 0\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Program unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Program unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Program unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Shader Program unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->stage, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->fragment_coverage_bitmask_type, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->suppress_nan, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->flush_to_zero_mode, &__tmp_packed.opaque[0], 17, 18); \
   __gen_unpack_uint((__unpacked)->suppress_inf, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->requires_helper_threads, &__tmp_packed.opaque[0], 28, 28); \
   __gen_unpack_uint((__unpacked)->shader_contains_jump_ex, &__tmp_packed.opaque[0], 29, 29); \
   __gen_unpack_uint((__unpacked)->register_allocation, &__tmp_packed.opaque[0], 30, 31); \
   __gen_unpack_uint((__unpacked)->preload.r48_r63, &__tmp_packed.opaque[0], 32, 47); \
   __gen_unpack_uint((__unpacked)->preload.r55, &__tmp_packed.opaque[0], 39, 39); \
   __gen_unpack_uint((__unpacked)->preload.r56, &__tmp_packed.opaque[0], 40, 40); \
   __gen_unpack_uint((__unpacked)->preload.r57, &__tmp_packed.opaque[0], 41, 41); \
   __gen_unpack_uint((__unpacked)->preload.r58, &__tmp_packed.opaque[0], 42, 42); \
   __gen_unpack_uint((__unpacked)->preload.r59, &__tmp_packed.opaque[0], 43, 43); \
   __gen_unpack_uint((__unpacked)->preload.r60, &__tmp_packed.opaque[0], 44, 44); \
   __gen_unpack_uint((__unpacked)->preload.r61, &__tmp_packed.opaque[0], 45, 45); \
   __gen_unpack_uint((__unpacked)->preload.r62, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->preload.r63, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->max_warps, &__tmp_packed.opaque[0], 48, 63); \
   __gen_unpack_uint((__unpacked)->binary, &__tmp_packed.opaque[0], 64, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SHADER_PROGRAM_print(FILE *fp, const struct MALI_SHADER_PROGRAM * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sStage: %s\n", indent, "", mali_shader_stage_as_str(values->stage));
   fprintf(fp, "%*sFragment coverage bitmask type: %s\n", indent, "", mali_coverage_bitmask_type_as_str(values->fragment_coverage_bitmask_type));
   fprintf(fp, "%*sSuppress NaN: %s\n", indent, "", values->suppress_nan ? "true" : "false");
   fprintf(fp, "%*sFlush to zero mode: %s\n", indent, "", mali_flush_to_zero_mode_as_str(values->flush_to_zero_mode));
   fprintf(fp, "%*sSuppress Inf: %s\n", indent, "", values->suppress_inf ? "true" : "false");
   fprintf(fp, "%*sRequires helper threads: %s\n", indent, "", values->requires_helper_threads ? "true" : "false");
   fprintf(fp, "%*sShader contains JUMP_EX: %s\n", indent, "", values->shader_contains_jump_ex ? "true" : "false");
   fprintf(fp, "%*sRegister allocation: %s\n", indent, "", mali_shader_register_allocation_as_str(values->register_allocation));
   fprintf(fp, "%*sPreload:\n", indent, "");
   MALI_PRELOAD_print(fp, &values->preload, indent + 2);
   fprintf(fp, "%*sMax Warps: %u\n", indent, "", values->max_warps);
   fprintf(fp, "%*sBinary: 0x%" PRIx64 "\n", indent, "", values->binary);
}

#endif
struct MALI_SCISSOR {
   uint32_t                             scissor_minimum_x;
   uint32_t                             scissor_minimum_y;
   uint32_t                             scissor_maximum_x;
   uint32_t                             scissor_maximum_y;
};

#define MALI_SCISSOR_header                     \
   0

#define MALI_SCISSOR_LENGTH 8
struct mali_scissor_packed { uint32_t opaque[2]; };
#define MALI_SCISSOR_PACKED_T struct mali_scissor_packed
#define MALI_SCISSOR_pack(__packed, __unpacked) \
do { \
   MALI_SCISSOR_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->scissor_minimum_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->scissor_minimum_y, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->scissor_maximum_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->scissor_maximum_y, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SCISSOR_unpack(__packed, __unpacked) \
do { \
   MALI_SCISSOR_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->scissor_minimum_x, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->scissor_minimum_y, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->scissor_maximum_x, &__tmp_packed.opaque[0], 32, 47); \
   __gen_unpack_uint((__unpacked)->scissor_maximum_y, &__tmp_packed.opaque[0], 48, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SCISSOR_print(FILE *fp, const struct MALI_SCISSOR * values, unsigned indent)
{
   fprintf(fp, "%*sScissor Minimum X: %u\n", indent, "", values->scissor_minimum_x);
   fprintf(fp, "%*sScissor Minimum Y: %u\n", indent, "", values->scissor_minimum_y);
   fprintf(fp, "%*sScissor Maximum X: %u\n", indent, "", values->scissor_maximum_x);
   fprintf(fp, "%*sScissor Maximum Y: %u\n", indent, "", values->scissor_maximum_y);
}

#endif
struct MALI_LOCAL_STORAGE {
   uint32_t                             tls_size;
   uint32_t                             wls_instances;
#define MALI_LOCAL_STORAGE_NO_WORKGROUP_MEM      2147483648
   uint32_t                             wls_size_base;
   uint32_t                             wls_size_scale;
   uint64_t                             tls_base_pointer;
   enum mali_address_mode               tls_address_mode;
   uint64_t                             wls_base_pointer;
};

#define MALI_LOCAL_STORAGE_header               \
   .wls_instances = MALI_LOCAL_STORAGE_NO_WORKGROUP_MEM

#define MALI_LOCAL_STORAGE_LENGTH 32
#define MALI_LOCAL_STORAGE_ALIGN 64
struct mali_local_storage_packed { uint32_t opaque[8]; };
#define MALI_LOCAL_STORAGE_PACKED_T struct mali_local_storage_packed
#define MALI_LOCAL_STORAGE_pack(__packed, __unpacked) \
do { \
   MALI_LOCAL_STORAGE_PACKED_T __tmp_packed; \
   assert(IS_POT_NONZERO((__unpacked)->wls_instances)); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->tls_size, 0, 4); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint(util_logbase2((__unpacked)->wls_instances), 0, 4) | \
            util_bitpack_uint((__unpacked)->wls_size_base, 5, 6) | \
            util_bitpack_uint((__unpacked)->wls_size_scale, 8, 12); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->tls_base_pointer, 0, 47); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->tls_base_pointer, 0, 47) >> 32 | \
            util_bitpack_uint((__unpacked)->tls_address_mode, 28, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->wls_base_pointer, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->wls_base_pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_LOCAL_STORAGE_unpack(__packed, __unpacked) \
do { \
   MALI_LOCAL_STORAGE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffe0) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffe080) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 1\n"); \
   if (__tmp_packed.opaque[3] & 0xfff0000) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 3\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->tls_size, &__tmp_packed.opaque[0], 0, 4); \
   __gen_unpack_uint((__unpacked)->wls_instances, &__tmp_packed.opaque[0], 32, 36); \
   (__unpacked)->wls_instances = 1U << (__unpacked)->wls_instances; \
   __gen_unpack_uint((__unpacked)->wls_size_base, &__tmp_packed.opaque[0], 37, 38); \
   __gen_unpack_uint((__unpacked)->wls_size_scale, &__tmp_packed.opaque[0], 40, 44); \
   __gen_unpack_uint((__unpacked)->tls_base_pointer, &__tmp_packed.opaque[0], 64, 111); \
   __gen_unpack_uint((__unpacked)->tls_address_mode, &__tmp_packed.opaque[0], 124, 127); \
   __gen_unpack_uint((__unpacked)->wls_base_pointer, &__tmp_packed.opaque[0], 128, 191); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_LOCAL_STORAGE_print(FILE *fp, const struct MALI_LOCAL_STORAGE * values, unsigned indent)
{
   fprintf(fp, "%*sTLS Size: %u\n", indent, "", values->tls_size);
   fprintf(fp, "%*sWLS Instances: %u\n", indent, "", values->wls_instances);
   fprintf(fp, "%*sWLS Size Base: %u\n", indent, "", values->wls_size_base);
   fprintf(fp, "%*sWLS Size Scale: %u\n", indent, "", values->wls_size_scale);
   fprintf(fp, "%*sTLS Base Pointer: 0x%" PRIx64 "\n", indent, "", values->tls_base_pointer);
   fprintf(fp, "%*sTLS Address Mode: %s\n", indent, "", mali_address_mode_as_str(values->tls_address_mode));
   fprintf(fp, "%*sWLS Base Pointer: 0x%" PRIx64 "\n", indent, "", values->wls_base_pointer);
}

#endif
enum mali_color_buffer_internal_format {
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW_VALUE =      0,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A8 =      1,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R10G10B10A2 =      2,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A2 =      3,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R4G4B4A4 =      4,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G6B5A0 =      5,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G5B5A1 =      6,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW8 =     32,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW16 =     33,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW32 =     34,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW64 =     35,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW128 =     36,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_color_buffer_internal_format_as_str(enum mali_color_buffer_internal_format imm)
{
    switch (imm) {
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW_VALUE: return "Raw Value";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A8: return "R8G8B8A8";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R10G10B10A2: return "R10G10B10A2";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A2: return "R8G8B8A2";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R4G4B4A4: return "R4G4B4A4";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G6B5A0: return "R5G6B5A0";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G5B5A1: return "R5G5B5A1";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW8: return "RAW8";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW16: return "RAW16";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW32: return "RAW32";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW64: return "RAW64";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW128: return "RAW128";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_color_format {
        MALI_COLOR_FORMAT_RAW8               =      0,
        MALI_COLOR_FORMAT_RAW16              =      1,
        MALI_COLOR_FORMAT_RAW24              =      2,
        MALI_COLOR_FORMAT_RAW32              =      3,
        MALI_COLOR_FORMAT_RAW48              =      4,
        MALI_COLOR_FORMAT_RAW64              =      5,
        MALI_COLOR_FORMAT_RAW96              =      6,
        MALI_COLOR_FORMAT_RAW128             =      7,
        MALI_COLOR_FORMAT_RAW192             =      8,
        MALI_COLOR_FORMAT_RAW256             =      9,
        MALI_COLOR_FORMAT_RAW384             =     10,
        MALI_COLOR_FORMAT_RAW512             =     11,
        MALI_COLOR_FORMAT_RAW768             =     12,
        MALI_COLOR_FORMAT_RAW1024            =     13,
        MALI_COLOR_FORMAT_RAW1536            =     14,
        MALI_COLOR_FORMAT_RAW2048            =     15,
        MALI_COLOR_FORMAT_R8                 =     16,
        MALI_COLOR_FORMAT_R8G8               =     17,
        MALI_COLOR_FORMAT_R8G8B8             =     18,
        MALI_COLOR_FORMAT_R8G8B8A8           =     19,
        MALI_COLOR_FORMAT_R4G4B4A4           =     20,
        MALI_COLOR_FORMAT_R5G6B5             =     21,
        MALI_COLOR_FORMAT_R8G8B8_FROM_R8G8B8A2 =     22,
        MALI_COLOR_FORMAT_R10G10B10A2        =     24,
        MALI_COLOR_FORMAT_A2B10G10R10        =     25,
        MALI_COLOR_FORMAT_R5G5B5A1           =     28,
        MALI_COLOR_FORMAT_A1B5G5R5           =     29,
        MALI_COLOR_FORMAT_NATIVE             =     31,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_color_format_as_str(enum mali_color_format imm)
{
    switch (imm) {
    case MALI_COLOR_FORMAT_RAW8: return "RAW8";
    case MALI_COLOR_FORMAT_RAW16: return "RAW16";
    case MALI_COLOR_FORMAT_RAW24: return "RAW24";
    case MALI_COLOR_FORMAT_RAW32: return "RAW32";
    case MALI_COLOR_FORMAT_RAW48: return "RAW48";
    case MALI_COLOR_FORMAT_RAW64: return "RAW64";
    case MALI_COLOR_FORMAT_RAW96: return "RAW96";
    case MALI_COLOR_FORMAT_RAW128: return "RAW128";
    case MALI_COLOR_FORMAT_RAW192: return "RAW192";
    case MALI_COLOR_FORMAT_RAW256: return "RAW256";
    case MALI_COLOR_FORMAT_RAW384: return "RAW384";
    case MALI_COLOR_FORMAT_RAW512: return "RAW512";
    case MALI_COLOR_FORMAT_RAW768: return "RAW768";
    case MALI_COLOR_FORMAT_RAW1024: return "RAW1024";
    case MALI_COLOR_FORMAT_RAW1536: return "RAW1536";
    case MALI_COLOR_FORMAT_RAW2048: return "RAW2048";
    case MALI_COLOR_FORMAT_R8: return "R8";
    case MALI_COLOR_FORMAT_R8G8: return "R8G8";
    case MALI_COLOR_FORMAT_R8G8B8: return "R8G8B8";
    case MALI_COLOR_FORMAT_R8G8B8A8: return "R8G8B8A8";
    case MALI_COLOR_FORMAT_R4G4B4A4: return "R4G4B4A4";
    case MALI_COLOR_FORMAT_R5G6B5: return "R5G6B5";
    case MALI_COLOR_FORMAT_R8G8B8_FROM_R8G8B8A2: return "R8G8B8_FROM_R8G8B8A2";
    case MALI_COLOR_FORMAT_R10G10B10A2: return "R10G10B10A2";
    case MALI_COLOR_FORMAT_A2B10G10R10: return "A2B10G10R10";
    case MALI_COLOR_FORMAT_R5G5B5A1: return "R5G5B5A1";
    case MALI_COLOR_FORMAT_A1B5G5R5: return "A1B5G5R5";
    case MALI_COLOR_FORMAT_NATIVE: return "NATIVE";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_downsampling_accumulation_mode {
        MALI_DOWNSAMPLING_ACCUMULATION_MODE_UNSIGNED_NORMALIZED_INTEGER =      0,
        MALI_DOWNSAMPLING_ACCUMULATION_MODE_SIGNED_NORMALIZED_INTEGER =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_downsampling_accumulation_mode_as_str(enum mali_downsampling_accumulation_mode imm)
{
    switch (imm) {
    case MALI_DOWNSAMPLING_ACCUMULATION_MODE_UNSIGNED_NORMALIZED_INTEGER: return "Unsigned normalized integer";
    case MALI_DOWNSAMPLING_ACCUMULATION_MODE_SIGNED_NORMALIZED_INTEGER: return "Signed normalized integer";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_sample_layout {
        MALI_SAMPLE_LAYOUT_ORDERED_4X_GRID   =      0,
        MALI_SAMPLE_LAYOUT_ROTATED_4X_GRID   =      1,
        MALI_SAMPLE_LAYOUT_D3D_8X_GRID       =      2,
        MALI_SAMPLE_LAYOUT_D3D_16X_GRID      =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_sample_layout_as_str(enum mali_sample_layout imm)
{
    switch (imm) {
    case MALI_SAMPLE_LAYOUT_ORDERED_4X_GRID: return "Ordered 4x Grid";
    case MALI_SAMPLE_LAYOUT_ROTATED_4X_GRID: return "Rotated 4x Grid";
    case MALI_SAMPLE_LAYOUT_D3D_8X_GRID: return "D3D 8x Grid";
    case MALI_SAMPLE_LAYOUT_D3D_16X_GRID: return "D3D 16x Grid";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_zs_format {
        MALI_ZS_FORMAT_D16                   =      1,
        MALI_ZS_FORMAT_D24                   =      2,
        MALI_ZS_FORMAT_D24X8                 =      4,
        MALI_ZS_FORMAT_D24S8                 =      5,
        MALI_ZS_FORMAT_D32                   =     14,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_zs_format_as_str(enum mali_zs_format imm)
{
    switch (imm) {
    case MALI_ZS_FORMAT_D16: return "D16";
    case MALI_ZS_FORMAT_D24: return "D24";
    case MALI_ZS_FORMAT_D24X8: return "D24X8";
    case MALI_ZS_FORMAT_D24S8: return "D24S8";
    case MALI_ZS_FORMAT_D32: return "D32";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_zs_preload_format {
        MALI_ZS_PRELOAD_FORMAT_D32_S8X24     =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_zs_preload_format_as_str(enum mali_zs_preload_format imm)
{
    switch (imm) {
    case MALI_ZS_PRELOAD_FORMAT_D32_S8X24: return "D32_S8X24";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_s_format {
        MALI_S_FORMAT_S8                     =      1,
        MALI_S_FORMAT_X24S8                  =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_s_format_as_str(enum mali_s_format imm)
{
    switch (imm) {
    case MALI_S_FORMAT_S8: return "S8";
    case MALI_S_FORMAT_X24S8: return "X24S8";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_tie_break_rule {
        MALI_TIE_BREAK_RULE_0_IN_180_OUT     =      0,
        MALI_TIE_BREAK_RULE_0_OUT_180_IN     =      1,
        MALI_TIE_BREAK_RULE_MINUS_180_IN_0_OUT =      2,
        MALI_TIE_BREAK_RULE_MINUS_180_OUT_0_IN =      3,
        MALI_TIE_BREAK_RULE_90_IN_270_OUT    =      4,
        MALI_TIE_BREAK_RULE_90_OUT_270_IN    =      5,
        MALI_TIE_BREAK_RULE_MINUS_90_IN_90_OUT =      6,
        MALI_TIE_BREAK_RULE_MINUS_90_OUT_90_IN =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_tie_break_rule_as_str(enum mali_tie_break_rule imm)
{
    switch (imm) {
    case MALI_TIE_BREAK_RULE_0_IN_180_OUT: return "0_IN_180_OUT";
    case MALI_TIE_BREAK_RULE_0_OUT_180_IN: return "0_OUT_180_IN";
    case MALI_TIE_BREAK_RULE_MINUS_180_IN_0_OUT: return "MINUS_180_IN_0_OUT";
    case MALI_TIE_BREAK_RULE_MINUS_180_OUT_0_IN: return "MINUS_180_OUT_0_IN";
    case MALI_TIE_BREAK_RULE_90_IN_270_OUT: return "90_IN_270_OUT";
    case MALI_TIE_BREAK_RULE_90_OUT_270_IN: return "90_OUT_270_IN";
    case MALI_TIE_BREAK_RULE_MINUS_90_IN_90_OUT: return "MINUS_90_IN_90_OUT";
    case MALI_TIE_BREAK_RULE_MINUS_90_OUT_90_IN: return "MINUS_90_OUT_90_IN";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_RT_BUFFER {
   uint64_t                             base;
   uint32_t                             row_stride;
   uint32_t                             surface_stride_hi;
   uint64_t                             surface_stride;
};

#define MALI_RT_BUFFER_header                   \
   0

#define MALI_RT_BUFFER_LENGTH 16
struct mali_rt_buffer_packed { uint32_t opaque[4]; };
#define MALI_RT_BUFFER_PACKED_T struct mali_rt_buffer_packed
#define MALI_RT_BUFFER_pack(__packed, __unpacked) \
do { \
   MALI_RT_BUFFER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->base, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->surface_stride_hi, 27, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->surface_stride, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RT_BUFFER_unpack(__packed, __unpacked) \
do { \
   MALI_RT_BUFFER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->base, &__tmp_packed.opaque[0], 0, 63); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 64, 90); \
   __gen_unpack_uint((__unpacked)->surface_stride_hi, &__tmp_packed.opaque[0], 91, 95); \
   __gen_unpack_uint((__unpacked)->surface_stride, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RT_BUFFER_print(FILE *fp, const struct MALI_RT_BUFFER * values, unsigned indent)
{
   fprintf(fp, "%*sBase: 0x%" PRIx64 "\n", indent, "", values->base);
   fprintf(fp, "%*sRow Stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSurface Stride hi: %u\n", indent, "", values->surface_stride_hi);
   fprintf(fp, "%*sSurface Stride: 0x%" PRIx64 "\n", indent, "", values->surface_stride);
}

#endif
enum mali_sample_pattern {
        MALI_SAMPLE_PATTERN_SINGLE_SAMPLED   =      0,
        MALI_SAMPLE_PATTERN_ORDERED_4X_GRID  =      1,
        MALI_SAMPLE_PATTERN_ROTATED_4X_GRID  =      2,
        MALI_SAMPLE_PATTERN_D3D_8X_GRID      =      3,
        MALI_SAMPLE_PATTERN_D3D_16X_GRID     =      4,
        MALI_SAMPLE_PATTERN_ROTATED_2X_GRID  =      5,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_sample_pattern_as_str(enum mali_sample_pattern imm)
{
    switch (imm) {
    case MALI_SAMPLE_PATTERN_SINGLE_SAMPLED: return "Single-sampled";
    case MALI_SAMPLE_PATTERN_ORDERED_4X_GRID: return "Ordered 4x Grid";
    case MALI_SAMPLE_PATTERN_ROTATED_4X_GRID: return "Rotated 4x Grid";
    case MALI_SAMPLE_PATTERN_D3D_8X_GRID: return "D3D 8x Grid";
    case MALI_SAMPLE_PATTERN_D3D_16X_GRID: return "D3D 16x Grid";
    case MALI_SAMPLE_PATTERN_ROTATED_2X_GRID: return "Rotated 2x Grid";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_z_internal_format {
        MALI_Z_INTERNAL_FORMAT_D16           =      0,
        MALI_Z_INTERNAL_FORMAT_D24           =      1,
        MALI_Z_INTERNAL_FORMAT_D32           =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_z_internal_format_as_str(enum mali_z_internal_format imm)
{
    switch (imm) {
    case MALI_Z_INTERNAL_FORMAT_D16: return "D16";
    case MALI_Z_INTERNAL_FORMAT_D24: return "D24";
    case MALI_Z_INTERNAL_FORMAT_D32: return "D32";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_pre_post_frame_shader_mode {
        MALI_PRE_POST_FRAME_SHADER_MODE_NEVER =      0,
        MALI_PRE_POST_FRAME_SHADER_MODE_ALWAYS =      1,
        MALI_PRE_POST_FRAME_SHADER_MODE_INTERSECT =      2,
        MALI_PRE_POST_FRAME_SHADER_MODE_EARLY_ZS_ALWAYS =      3,
        MALI_PRE_POST_FRAME_SHADER_MODE_EARLY_ZS_INTERSECT =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_pre_post_frame_shader_mode_as_str(enum mali_pre_post_frame_shader_mode imm)
{
    switch (imm) {
    case MALI_PRE_POST_FRAME_SHADER_MODE_NEVER: return "Never";
    case MALI_PRE_POST_FRAME_SHADER_MODE_ALWAYS: return "Always";
    case MALI_PRE_POST_FRAME_SHADER_MODE_INTERSECT: return "Intersect";
    case MALI_PRE_POST_FRAME_SHADER_MODE_EARLY_ZS_ALWAYS: return "Early ZS Always";
    case MALI_PRE_POST_FRAME_SHADER_MODE_EARLY_ZS_INTERSECT: return "Early ZS Intersect";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_downscale {
        MALI_DOWNSCALE_NONE                  =      0,
        MALI_DOWNSCALE_2X                    =      1,
        MALI_DOWNSCALE_4X                    =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_downscale_as_str(enum mali_downscale imm)
{
    switch (imm) {
    case MALI_DOWNSCALE_NONE: return "None";
    case MALI_DOWNSCALE_2X: return "2x";
    case MALI_DOWNSCALE_4X: return "4x";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_vrs_image_rate {
        MALI_VRS_IMAGE_RATE_GRANULE_8X8      =      0,
        MALI_VRS_IMAGE_RATE_GRANULE_16X16    =      1,
        MALI_VRS_IMAGE_RATE_GRANULE_32X32    =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_vrs_image_rate_as_str(enum mali_vrs_image_rate imm)
{
    switch (imm) {
    case MALI_VRS_IMAGE_RATE_GRANULE_8X8: return "Granule 8x8";
    case MALI_VRS_IMAGE_RATE_GRANULE_16X16: return "Granule 16x16";
    case MALI_VRS_IMAGE_RATE_GRANULE_32X32: return "Granule 32x32";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_VIEWPORT {
   uint32_t                             min_x;
   uint32_t                             min_y;
   uint32_t                             max_x;
   uint32_t                             max_y;
   float                                min_depth;
   float                                max_depth;
};

#define MALI_VIEWPORT_header                    \
   0

#define MALI_VIEWPORT_LENGTH 16
#define MALI_VIEWPORT_ALIGN 16
struct mali_viewport_packed { uint32_t opaque[4]; };
#define MALI_VIEWPORT_PACKED_T struct mali_viewport_packed
#define MALI_VIEWPORT_pack(__packed, __unpacked) \
do { \
   MALI_VIEWPORT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->min_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->min_y, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->max_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->max_y, 16, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_float((__unpacked)->min_depth); \
   __tmp_packed.opaque[ 3] = util_bitpack_float((__unpacked)->max_depth); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_VIEWPORT_unpack(__packed, __unpacked) \
do { \
   MALI_VIEWPORT_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->min_x, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->min_y, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->max_x, &__tmp_packed.opaque[0], 32, 47); \
   __gen_unpack_uint((__unpacked)->max_y, &__tmp_packed.opaque[0], 48, 63); \
   __gen_unpack_float((__unpacked)->min_depth, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_float((__unpacked)->max_depth, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_VIEWPORT_print(FILE *fp, const struct MALI_VIEWPORT * values, unsigned indent)
{
   fprintf(fp, "%*sMin X: %u\n", indent, "", values->min_x);
   fprintf(fp, "%*sMin Y: %u\n", indent, "", values->min_y);
   fprintf(fp, "%*sMax X: %u\n", indent, "", values->max_x);
   fprintf(fp, "%*sMax Y: %u\n", indent, "", values->max_y);
   fprintf(fp, "%*sMin Depth: %f\n", indent, "", values->min_depth);
   fprintf(fp, "%*sMax Depth: %f\n", indent, "", values->max_depth);
}

#endif
struct MALI_FRAMEBUFFER_PARAMETERS {
   enum mali_pre_post_frame_shader_mode pre_frame_0;
   enum mali_pre_post_frame_shader_mode pre_frame_1;
   enum mali_pre_post_frame_shader_mode post_frame;
   enum mali_downscale                  downscale_geometry;
   uint32_t                             internal_layer_index;
   uint64_t                             frame_argument;
   uint64_t                             sample_locations;
   uint64_t                             frame_shader_dcds;
   uint32_t                             width;
   uint32_t                             height;
   uint32_t                             bound_min_x;
   uint32_t                             bound_min_y;
   uint32_t                             bound_max_x;
   uint32_t                             bound_max_y;
   uint32_t                             sample_count;
   enum mali_sample_pattern             sample_pattern;
   enum mali_tie_break_rule             tie_break_rule;
   uint32_t                             effective_tile_size;
   bool                                 first_provoking_vertex;
   bool                                 point_sprite_coord_origin_max_y;
   bool                                 blend_suppress_inf;
   bool                                 blend_suppress_nan;
   bool                                 blend_suppress_denorm;
   uint32_t                             render_target_count;
   uint32_t                             color_buffer_allocation;
   uint32_t                             s_clear;
   bool                                 s_write_enable;
   bool                                 s_preload_enable;
   bool                                 s_unload_enable;
   enum mali_z_internal_format          z_internal_format;
   bool                                 z_write_enable;
   bool                                 z_preload_enable;
   bool                                 z_unload_enable;
   bool                                 has_zs_crc_extension;
   bool                                 empty_tile_read_enable;
   bool                                 empty_tile_write_enable;
   bool                                 crc_read_enable;
   bool                                 crc_write_enable;
   float                                z_clear;
   uint64_t                             tiler;
   enum mali_vrs_image_rate             vrs_image_rate;
   uint64_t                             vrs_image_plane;
};

#define MALI_FRAMEBUFFER_PARAMETERS_header      \
   .sample_count = 1,  \
   .point_sprite_coord_origin_max_y = true

#define MALI_FRAMEBUFFER_PARAMETERS_LENGTH 72
#define MALI_FRAMEBUFFER_PARAMETERS_ALIGN 64
struct mali_framebuffer_parameters_packed { uint32_t opaque[18]; };
#define MALI_FRAMEBUFFER_PARAMETERS_PACKED_T struct mali_framebuffer_parameters_packed
#define MALI_FRAMEBUFFER_PARAMETERS_pack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PARAMETERS_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   assert(IS_POT_NONZERO((__unpacked)->sample_count)); \
   assert(IS_POT_NONZERO((__unpacked)->effective_tile_size)); \
   assert((__unpacked)->render_target_count >= 1); \
   assert(((__unpacked)->color_buffer_allocation & 0x3ff) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->pre_frame_0, 0, 2) | \
            util_bitpack_uint((__unpacked)->pre_frame_1, 3, 5) | \
            util_bitpack_uint((__unpacked)->post_frame, 6, 8) | \
            util_bitpack_uint((__unpacked)->downscale_geometry, 9, 10) | \
            util_bitpack_uint((__unpacked)->internal_layer_index, 24, 31); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->frame_argument, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->frame_argument, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->sample_locations, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->sample_locations, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->frame_shader_dcds, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->frame_shader_dcds, 0, 63) >> 32; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->bound_min_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->bound_min_y, 16, 31); \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->bound_max_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->bound_max_y, 16, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint(util_logbase2((__unpacked)->sample_count), 0, 2) | \
            util_bitpack_uint((__unpacked)->sample_pattern, 3, 5) | \
            util_bitpack_uint((__unpacked)->tie_break_rule, 6, 8) | \
            util_bitpack_uint(util_logbase2((__unpacked)->effective_tile_size), 9, 12) | \
            util_bitpack_uint((__unpacked)->first_provoking_vertex, 14, 14) | \
            util_bitpack_uint((__unpacked)->point_sprite_coord_origin_max_y, 15, 15) | \
            util_bitpack_uint((__unpacked)->blend_suppress_inf, 16, 16) | \
            util_bitpack_uint((__unpacked)->blend_suppress_nan, 17, 17) | \
            util_bitpack_uint((__unpacked)->blend_suppress_denorm, 18, 18) | \
            util_bitpack_uint((__unpacked)->render_target_count - 1, 19, 22) | \
            util_bitpack_uint((__unpacked)->color_buffer_allocation >> 10, 24, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->s_clear, 0, 7) | \
            util_bitpack_uint((__unpacked)->s_write_enable, 8, 8) | \
            util_bitpack_uint((__unpacked)->s_preload_enable, 9, 9) | \
            util_bitpack_uint((__unpacked)->s_unload_enable, 10, 10) | \
            util_bitpack_uint((__unpacked)->z_internal_format, 16, 17) | \
            util_bitpack_uint((__unpacked)->z_write_enable, 18, 18) | \
            util_bitpack_uint((__unpacked)->z_preload_enable, 19, 19) | \
            util_bitpack_uint((__unpacked)->z_unload_enable, 20, 20) | \
            util_bitpack_uint((__unpacked)->has_zs_crc_extension, 21, 21) | \
            util_bitpack_uint((__unpacked)->empty_tile_read_enable, 28, 28) | \
            util_bitpack_uint((__unpacked)->empty_tile_write_enable, 29, 29) | \
            util_bitpack_uint((__unpacked)->crc_read_enable, 30, 30) | \
            util_bitpack_uint((__unpacked)->crc_write_enable, 31, 31); \
   __tmp_packed.opaque[13] = util_bitpack_float((__unpacked)->z_clear); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->tiler, 0, 63); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->tiler, 0, 63) >> 32; \
   __tmp_packed.opaque[16] = util_bitpack_uint((__unpacked)->vrs_image_rate, 0, 1) | \
            util_bitpack_uint((__unpacked)->vrs_image_plane, 5, 63); \
   __tmp_packed.opaque[17] = util_bitpack_uint((__unpacked)->vrs_image_plane, 5, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FRAMEBUFFER_PARAMETERS_unpack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PARAMETERS_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfff800) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 1\n"); \
   if (__tmp_packed.opaque[11] & 0x802000) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 11\n"); \
   if (__tmp_packed.opaque[12] & 0xfc0f800) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 12\n"); \
   if (__tmp_packed.opaque[16] & 0x1c) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 16\n"); \
   __gen_unpack_uint((__unpacked)->pre_frame_0, &__tmp_packed.opaque[0], 0, 2); \
   __gen_unpack_uint((__unpacked)->pre_frame_1, &__tmp_packed.opaque[0], 3, 5); \
   __gen_unpack_uint((__unpacked)->post_frame, &__tmp_packed.opaque[0], 6, 8); \
   __gen_unpack_uint((__unpacked)->downscale_geometry, &__tmp_packed.opaque[0], 9, 10); \
   __gen_unpack_uint((__unpacked)->internal_layer_index, &__tmp_packed.opaque[0], 24, 31); \
   __gen_unpack_uint((__unpacked)->frame_argument, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->sample_locations, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->frame_shader_dcds, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 256, 271); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 272, 287); \
   (__unpacked)->height = (__unpacked)->height + 1; \
   __gen_unpack_uint((__unpacked)->bound_min_x, &__tmp_packed.opaque[0], 288, 303); \
   __gen_unpack_uint((__unpacked)->bound_min_y, &__tmp_packed.opaque[0], 304, 319); \
   __gen_unpack_uint((__unpacked)->bound_max_x, &__tmp_packed.opaque[0], 320, 335); \
   __gen_unpack_uint((__unpacked)->bound_max_y, &__tmp_packed.opaque[0], 336, 351); \
   __gen_unpack_uint((__unpacked)->sample_count, &__tmp_packed.opaque[0], 352, 354); \
   (__unpacked)->sample_count = 1U << (__unpacked)->sample_count; \
   __gen_unpack_uint((__unpacked)->sample_pattern, &__tmp_packed.opaque[0], 355, 357); \
   __gen_unpack_uint((__unpacked)->tie_break_rule, &__tmp_packed.opaque[0], 358, 360); \
   __gen_unpack_uint((__unpacked)->effective_tile_size, &__tmp_packed.opaque[0], 361, 364); \
   (__unpacked)->effective_tile_size = 1U << (__unpacked)->effective_tile_size; \
   __gen_unpack_uint((__unpacked)->first_provoking_vertex, &__tmp_packed.opaque[0], 366, 366); \
   __gen_unpack_uint((__unpacked)->point_sprite_coord_origin_max_y, &__tmp_packed.opaque[0], 367, 367); \
   __gen_unpack_uint((__unpacked)->blend_suppress_inf, &__tmp_packed.opaque[0], 368, 368); \
   __gen_unpack_uint((__unpacked)->blend_suppress_nan, &__tmp_packed.opaque[0], 369, 369); \
   __gen_unpack_uint((__unpacked)->blend_suppress_denorm, &__tmp_packed.opaque[0], 370, 370); \
   __gen_unpack_uint((__unpacked)->render_target_count, &__tmp_packed.opaque[0], 371, 374); \
   (__unpacked)->render_target_count = (__unpacked)->render_target_count + 1; \
   __gen_unpack_uint((__unpacked)->color_buffer_allocation, &__tmp_packed.opaque[0], 376, 383); \
   (__unpacked)->color_buffer_allocation = (__unpacked)->color_buffer_allocation << 10; \
   __gen_unpack_uint((__unpacked)->s_clear, &__tmp_packed.opaque[0], 384, 391); \
   __gen_unpack_uint((__unpacked)->s_write_enable, &__tmp_packed.opaque[0], 392, 392); \
   __gen_unpack_uint((__unpacked)->s_preload_enable, &__tmp_packed.opaque[0], 393, 393); \
   __gen_unpack_uint((__unpacked)->s_unload_enable, &__tmp_packed.opaque[0], 394, 394); \
   __gen_unpack_uint((__unpacked)->z_internal_format, &__tmp_packed.opaque[0], 400, 401); \
   __gen_unpack_uint((__unpacked)->z_write_enable, &__tmp_packed.opaque[0], 402, 402); \
   __gen_unpack_uint((__unpacked)->z_preload_enable, &__tmp_packed.opaque[0], 403, 403); \
   __gen_unpack_uint((__unpacked)->z_unload_enable, &__tmp_packed.opaque[0], 404, 404); \
   __gen_unpack_uint((__unpacked)->has_zs_crc_extension, &__tmp_packed.opaque[0], 405, 405); \
   __gen_unpack_uint((__unpacked)->empty_tile_read_enable, &__tmp_packed.opaque[0], 412, 412); \
   __gen_unpack_uint((__unpacked)->empty_tile_write_enable, &__tmp_packed.opaque[0], 413, 413); \
   __gen_unpack_uint((__unpacked)->crc_read_enable, &__tmp_packed.opaque[0], 414, 414); \
   __gen_unpack_uint((__unpacked)->crc_write_enable, &__tmp_packed.opaque[0], 415, 415); \
   __gen_unpack_float((__unpacked)->z_clear, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->tiler, &__tmp_packed.opaque[0], 448, 511); \
   __gen_unpack_uint((__unpacked)->vrs_image_rate, &__tmp_packed.opaque[0], 512, 513); \
   __gen_unpack_uint((__unpacked)->vrs_image_plane, &__tmp_packed.opaque[0], 517, 575); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FRAMEBUFFER_PARAMETERS_print(FILE *fp, const struct MALI_FRAMEBUFFER_PARAMETERS * values, unsigned indent)
{
   fprintf(fp, "%*sPre Frame 0: %s\n", indent, "", mali_pre_post_frame_shader_mode_as_str(values->pre_frame_0));
   fprintf(fp, "%*sPre Frame 1: %s\n", indent, "", mali_pre_post_frame_shader_mode_as_str(values->pre_frame_1));
   fprintf(fp, "%*sPost Frame: %s\n", indent, "", mali_pre_post_frame_shader_mode_as_str(values->post_frame));
   fprintf(fp, "%*sDownscale geometry: %s\n", indent, "", mali_downscale_as_str(values->downscale_geometry));
   fprintf(fp, "%*sInternal layer index: %u\n", indent, "", values->internal_layer_index);
   fprintf(fp, "%*sFrame argument: 0x%" PRIx64 "\n", indent, "", values->frame_argument);
   fprintf(fp, "%*sSample Locations: 0x%" PRIx64 "\n", indent, "", values->sample_locations);
   fprintf(fp, "%*sFrame Shader DCDs: 0x%" PRIx64 "\n", indent, "", values->frame_shader_dcds);
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
   fprintf(fp, "%*sBound Min X: %u\n", indent, "", values->bound_min_x);
   fprintf(fp, "%*sBound Min Y: %u\n", indent, "", values->bound_min_y);
   fprintf(fp, "%*sBound Max X: %u\n", indent, "", values->bound_max_x);
   fprintf(fp, "%*sBound Max Y: %u\n", indent, "", values->bound_max_y);
   fprintf(fp, "%*sSample Count: %u\n", indent, "", values->sample_count);
   fprintf(fp, "%*sSample Pattern: %s\n", indent, "", mali_sample_pattern_as_str(values->sample_pattern));
   fprintf(fp, "%*sTie-Break Rule: %s\n", indent, "", mali_tie_break_rule_as_str(values->tie_break_rule));
   fprintf(fp, "%*sEffective Tile Size: %u\n", indent, "", values->effective_tile_size);
   fprintf(fp, "%*sFirst provoking vertex: %s\n", indent, "", values->first_provoking_vertex ? "true" : "false");
   fprintf(fp, "%*sPoint sprite coord origin max Y: %s\n", indent, "", values->point_sprite_coord_origin_max_y ? "true" : "false");
   fprintf(fp, "%*sBlend suppress Inf: %s\n", indent, "", values->blend_suppress_inf ? "true" : "false");
   fprintf(fp, "%*sBlend suppress NaN: %s\n", indent, "", values->blend_suppress_nan ? "true" : "false");
   fprintf(fp, "%*sBlend suppress denorm: %s\n", indent, "", values->blend_suppress_denorm ? "true" : "false");
   fprintf(fp, "%*sRender Target Count: %u\n", indent, "", values->render_target_count);
   fprintf(fp, "%*sColor Buffer Allocation: %u\n", indent, "", values->color_buffer_allocation);
   fprintf(fp, "%*sS Clear: %u\n", indent, "", values->s_clear);
   fprintf(fp, "%*sS Write Enable: %s\n", indent, "", values->s_write_enable ? "true" : "false");
   fprintf(fp, "%*sS Preload Enable: %s\n", indent, "", values->s_preload_enable ? "true" : "false");
   fprintf(fp, "%*sS Unload Enable: %s\n", indent, "", values->s_unload_enable ? "true" : "false");
   fprintf(fp, "%*sZ Internal Format: %s\n", indent, "", mali_z_internal_format_as_str(values->z_internal_format));
   fprintf(fp, "%*sZ Write Enable: %s\n", indent, "", values->z_write_enable ? "true" : "false");
   fprintf(fp, "%*sZ Preload Enable: %s\n", indent, "", values->z_preload_enable ? "true" : "false");
   fprintf(fp, "%*sZ Unload Enable: %s\n", indent, "", values->z_unload_enable ? "true" : "false");
   fprintf(fp, "%*sHas ZS CRC Extension: %s\n", indent, "", values->has_zs_crc_extension ? "true" : "false");
   fprintf(fp, "%*sEmpty Tile Read Enable: %s\n", indent, "", values->empty_tile_read_enable ? "true" : "false");
   fprintf(fp, "%*sEmpty Tile Write Enable: %s\n", indent, "", values->empty_tile_write_enable ? "true" : "false");
   fprintf(fp, "%*sCRC Read Enable: %s\n", indent, "", values->crc_read_enable ? "true" : "false");
   fprintf(fp, "%*sCRC Write Enable: %s\n", indent, "", values->crc_write_enable ? "true" : "false");
   fprintf(fp, "%*sZ Clear: %f\n", indent, "", values->z_clear);
   fprintf(fp, "%*sTiler: 0x%" PRIx64 "\n", indent, "", values->tiler);
   fprintf(fp, "%*sVRS Image Rate: %s\n", indent, "", mali_vrs_image_rate_as_str(values->vrs_image_rate));
   fprintf(fp, "%*sVRS Image Plane: 0x%" PRIx64 "\n", indent, "", values->vrs_image_plane);
}

#endif
struct MALI_CRC {
   uint32_t                             render_target;
   uint32_t                             row_stride;
   uint64_t                             clear_color;
   uint64_t                             base;
};

#define MALI_CRC_header                         \
   0

#define MALI_CRC_LENGTH 64
#define MALI_CRC_ALIGN 64
struct mali_crc_packed { uint32_t opaque[16]; };
#define MALI_CRC_PACKED_T struct mali_crc_packed
#define MALI_CRC_pack(__packed, __unpacked) \
do { \
   MALI_CRC_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->render_target, 13, 15); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->row_stride, 0, 26); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->clear_color, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->clear_color, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->base, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = 0; \
   __tmp_packed.opaque[ 9] = 0; \
   __tmp_packed.opaque[10] = 0; \
   __tmp_packed.opaque[11] = 0; \
   __tmp_packed.opaque[12] = 0; \
   __tmp_packed.opaque[13] = 0; \
   __tmp_packed.opaque[14] = 0; \
   __tmp_packed.opaque[15] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CRC_unpack(__packed, __unpacked) \
do { \
   MALI_CRC_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffff1fff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 1\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 7\n"); \
   if (__tmp_packed.opaque[8] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 11\n"); \
   if (__tmp_packed.opaque[12] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 12\n"); \
   if (__tmp_packed.opaque[13] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 13\n"); \
   if (__tmp_packed.opaque[14] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 14\n"); \
   if (__tmp_packed.opaque[15] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of CRC unpacked at word 15\n"); \
   __gen_unpack_uint((__unpacked)->render_target, &__tmp_packed.opaque[0], 13, 15); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 32, 58); \
   __gen_unpack_uint((__unpacked)->clear_color, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->base, &__tmp_packed.opaque[0], 128, 191); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CRC_print(FILE *fp, const struct MALI_CRC * values, unsigned indent)
{
   fprintf(fp, "%*sRender Target: %u\n", indent, "", values->render_target);
   fprintf(fp, "%*sRow Stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sClear Color: 0x%" PRIx64 "\n", indent, "", values->clear_color);
   fprintf(fp, "%*sBase: 0x%" PRIx64 "\n", indent, "", values->base);
}

#endif
struct MALI_ZS_TARGET {
   enum mali_zs_format                  write_format;
   enum mali_block_format               block_format;
   enum mali_msaa                       msaa;
   bool                                 clean_pixel_write_enable;
   uint64_t                             base;
   uint32_t                             row_stride;
   uint32_t                             surface_stride_hi;
   uint64_t                             surface_stride;
};

#define MALI_ZS_TARGET_header                   \
   .msaa = MALI_MSAA_SINGLE

#define MALI_ZS_TARGET_LENGTH 64
#define MALI_ZS_TARGET_ALIGN 64
struct mali_zs_target_packed { uint32_t opaque[16]; };
#define MALI_ZS_TARGET_PACKED_T struct mali_zs_target_packed
#define MALI_ZS_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_ZS_TARGET_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->write_format, 0, 3) | \
            util_bitpack_uint((__unpacked)->block_format, 4, 7) | \
            util_bitpack_uint((__unpacked)->msaa, 8, 9) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->surface_stride_hi, 27, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->surface_stride, 0, 31); \
   __tmp_packed.opaque[12] = 0; \
   __tmp_packed.opaque[13] = 0; \
   __tmp_packed.opaque[14] = 0; \
   __tmp_packed.opaque[15] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ZS_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_ZS_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x7ffffc00) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 7\n"); \
   if (__tmp_packed.opaque[12] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 12\n"); \
   if (__tmp_packed.opaque[13] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 13\n"); \
   if (__tmp_packed.opaque[14] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 14\n"); \
   if (__tmp_packed.opaque[15] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS Target unpacked at word 15\n"); \
   __gen_unpack_uint((__unpacked)->write_format, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->block_format, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->msaa, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->surface_stride_hi, &__tmp_packed.opaque[0], 347, 351); \
   __gen_unpack_uint((__unpacked)->surface_stride, &__tmp_packed.opaque[0], 352, 383); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ZS_TARGET_print(FILE *fp, const struct MALI_ZS_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWrite Format: %s\n", indent, "", mali_zs_format_as_str(values->write_format));
   fprintf(fp, "%*sBlock Format: %s\n", indent, "", mali_block_format_as_str(values->block_format));
   fprintf(fp, "%*sMSAA: %s\n", indent, "", mali_msaa_as_str(values->msaa));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sBase: 0x%" PRIx64 "\n", indent, "", values->base);
   fprintf(fp, "%*sRow Stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSurface Stride hi: %u\n", indent, "", values->surface_stride_hi);
   fprintf(fp, "%*sSurface Stride: 0x%" PRIx64 "\n", indent, "", values->surface_stride);
}

#endif
struct MALI_AFBC_ZS_TARGET {
   enum mali_zs_format                  write_format;
   enum mali_block_format               block_format;
   enum mali_msaa                       msaa;
   bool                                 reverse_issue_order;
   bool                                 clean_pixel_write_enable;
   uint64_t                             header;
   uint32_t                             header_row_stride;
   uint64_t                             body_offset;
};

#define MALI_AFBC_ZS_TARGET_header              \
   .msaa = MALI_MSAA_SINGLE

#define MALI_AFBC_ZS_TARGET_LENGTH 64
#define MALI_AFBC_ZS_TARGET_ALIGN 64
struct mali_afbc_zs_target_packed { uint32_t opaque[16]; };
#define MALI_AFBC_ZS_TARGET_PACKED_T struct mali_afbc_zs_target_packed
#define MALI_AFBC_ZS_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_AFBC_ZS_TARGET_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->write_format, 0, 3) | \
            util_bitpack_uint((__unpacked)->block_format, 4, 7) | \
            util_bitpack_uint((__unpacked)->msaa, 8, 9) | \
            util_bitpack_uint((__unpacked)->reverse_issue_order, 30, 30) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->header, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->header, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->header_row_stride, 0, 26); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->body_offset, 0, 31); \
   __tmp_packed.opaque[12] = 0; \
   __tmp_packed.opaque[13] = 0; \
   __tmp_packed.opaque[14] = 0; \
   __tmp_packed.opaque[15] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFBC_ZS_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_AFBC_ZS_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x3ffffc00) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 7\n"); \
   if (__tmp_packed.opaque[10] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 10\n"); \
   if (__tmp_packed.opaque[12] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 12\n"); \
   if (__tmp_packed.opaque[13] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 13\n"); \
   if (__tmp_packed.opaque[14] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 14\n"); \
   if (__tmp_packed.opaque[15] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC ZS Target unpacked at word 15\n"); \
   __gen_unpack_uint((__unpacked)->write_format, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->block_format, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->msaa, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->reverse_issue_order, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->header_row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->body_offset, &__tmp_packed.opaque[0], 352, 383); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFBC_ZS_TARGET_print(FILE *fp, const struct MALI_AFBC_ZS_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWrite Format: %s\n", indent, "", mali_zs_format_as_str(values->write_format));
   fprintf(fp, "%*sBlock Format: %s\n", indent, "", mali_block_format_as_str(values->block_format));
   fprintf(fp, "%*sMSAA: %s\n", indent, "", mali_msaa_as_str(values->msaa));
   fprintf(fp, "%*sReverse Issue Order: %s\n", indent, "", values->reverse_issue_order ? "true" : "false");
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sHeader: 0x%" PRIx64 "\n", indent, "", values->header);
   fprintf(fp, "%*sHeader Row Stride: %u\n", indent, "", values->header_row_stride);
   fprintf(fp, "%*sBody Offset: 0x%" PRIx64 "\n", indent, "", values->body_offset);
}

#endif
struct MALI_S_TARGET {
   enum mali_s_format                   write_format;
   enum mali_block_format               block_format;
   enum mali_msaa                       msaa;
   bool                                 clean_pixel_write_enable;
   uint64_t                             base;
   uint32_t                             row_stride;
   uint32_t                             surface_stride_hi;
   uint64_t                             surface_stride;
};

#define MALI_S_TARGET_header                    \
   .msaa = MALI_MSAA_SINGLE

#define MALI_S_TARGET_LENGTH 64
#define MALI_S_TARGET_ALIGN 64
struct mali_s_target_packed { uint32_t opaque[16]; };
#define MALI_S_TARGET_PACKED_T struct mali_s_target_packed
#define MALI_S_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_S_TARGET_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->write_format, 16, 19) | \
            util_bitpack_uint((__unpacked)->block_format, 20, 23) | \
            util_bitpack_uint((__unpacked)->msaa, 24, 25) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = 0; \
   __tmp_packed.opaque[ 9] = 0; \
   __tmp_packed.opaque[10] = 0; \
   __tmp_packed.opaque[11] = 0; \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->base, 0, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->base, 0, 63) >> 32; \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->surface_stride_hi, 27, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->surface_stride, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_S_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_S_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x7c00ffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 7\n"); \
   if (__tmp_packed.opaque[8] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of S Target unpacked at word 11\n"); \
   __gen_unpack_uint((__unpacked)->write_format, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->block_format, &__tmp_packed.opaque[0], 20, 23); \
   __gen_unpack_uint((__unpacked)->msaa, &__tmp_packed.opaque[0], 24, 25); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->base, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 448, 474); \
   __gen_unpack_uint((__unpacked)->surface_stride_hi, &__tmp_packed.opaque[0], 475, 479); \
   __gen_unpack_uint((__unpacked)->surface_stride, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_S_TARGET_print(FILE *fp, const struct MALI_S_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWrite Format: %s\n", indent, "", mali_s_format_as_str(values->write_format));
   fprintf(fp, "%*sBlock Format: %s\n", indent, "", mali_block_format_as_str(values->block_format));
   fprintf(fp, "%*sMSAA: %s\n", indent, "", mali_msaa_as_str(values->msaa));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sBase: 0x%" PRIx64 "\n", indent, "", values->base);
   fprintf(fp, "%*sRow Stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSurface Stride hi: %u\n", indent, "", values->surface_stride_hi);
   fprintf(fp, "%*sSurface Stride: 0x%" PRIx64 "\n", indent, "", values->surface_stride);
}

#endif
struct MALI_AFBC_S_TARGET {
   enum mali_s_format                   write_format;
   enum mali_block_format               block_format;
   enum mali_msaa                       msaa;
   bool                                 reverse_issue_order;
   bool                                 clean_pixel_write_enable;
   uint64_t                             header;
   uint32_t                             header_row_stride;
   uint64_t                             body_offset;
};

#define MALI_AFBC_S_TARGET_header               \
   .msaa = MALI_MSAA_SINGLE

#define MALI_AFBC_S_TARGET_LENGTH 64
#define MALI_AFBC_S_TARGET_ALIGN 64
struct mali_afbc_s_target_packed { uint32_t opaque[16]; };
#define MALI_AFBC_S_TARGET_PACKED_T struct mali_afbc_s_target_packed
#define MALI_AFBC_S_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_AFBC_S_TARGET_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->write_format, 16, 19) | \
            util_bitpack_uint((__unpacked)->block_format, 20, 23) | \
            util_bitpack_uint((__unpacked)->msaa, 24, 25) | \
            util_bitpack_uint((__unpacked)->reverse_issue_order, 30, 30) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = 0; \
   __tmp_packed.opaque[ 9] = 0; \
   __tmp_packed.opaque[10] = 0; \
   __tmp_packed.opaque[11] = 0; \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->header, 0, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->header, 0, 63) >> 32; \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->header_row_stride, 0, 26); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->body_offset, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFBC_S_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_AFBC_S_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x3c00ffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 7\n"); \
   if (__tmp_packed.opaque[8] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 11\n"); \
   if (__tmp_packed.opaque[14] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of AFBC S Target unpacked at word 14\n"); \
   __gen_unpack_uint((__unpacked)->write_format, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->block_format, &__tmp_packed.opaque[0], 20, 23); \
   __gen_unpack_uint((__unpacked)->msaa, &__tmp_packed.opaque[0], 24, 25); \
   __gen_unpack_uint((__unpacked)->reverse_issue_order, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->header, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->header_row_stride, &__tmp_packed.opaque[0], 448, 474); \
   __gen_unpack_uint((__unpacked)->body_offset, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFBC_S_TARGET_print(FILE *fp, const struct MALI_AFBC_S_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWrite Format: %s\n", indent, "", mali_s_format_as_str(values->write_format));
   fprintf(fp, "%*sBlock Format: %s\n", indent, "", mali_block_format_as_str(values->block_format));
   fprintf(fp, "%*sMSAA: %s\n", indent, "", mali_msaa_as_str(values->msaa));
   fprintf(fp, "%*sReverse Issue Order: %s\n", indent, "", values->reverse_issue_order ? "true" : "false");
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sHeader: 0x%" PRIx64 "\n", indent, "", values->header);
   fprintf(fp, "%*sHeader Row Stride: %u\n", indent, "", values->header_row_stride);
   fprintf(fp, "%*sBody Offset: 0x%" PRIx64 "\n", indent, "", values->body_offset);
}

#endif
struct MALI_ZS_CRC_EXTENSION {
   struct MALI_CRC                      crc;
   struct MALI_AFBC_ZS_TARGET           afbc_zs;
   struct MALI_ZS_TARGET                zs;
   struct MALI_AFBC_S_TARGET            afbc_s;
   struct MALI_S_TARGET                 s;
};

#define MALI_ZS_CRC_EXTENSION_header            \
   .crc = { MALI_CRC_header },  \
   .afbc_zs = { MALI_AFBC_ZS_TARGET_header },  \
   .zs = { MALI_ZS_TARGET_header },  \
   .afbc_s = { MALI_AFBC_S_TARGET_header },  \
   .s = { MALI_S_TARGET_header }

#define MALI_ZS_CRC_EXTENSION_LENGTH 64
#define MALI_ZS_CRC_EXTENSION_ALIGN 64
struct mali_zs_crc_extension_packed { uint32_t opaque[16]; };
#define MALI_ZS_CRC_EXTENSION_PACKED_T struct mali_zs_crc_extension_packed
#define MALI_ZS_CRC_EXTENSION_pack(__packed, __unpacked) \
do { \
   MALI_ZS_CRC_EXTENSION_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->crc.render_target, 13, 15) | \
            util_bitpack_uint((__unpacked)->afbc_zs.write_format, 0, 3) | \
            util_bitpack_uint((__unpacked)->afbc_zs.block_format, 4, 7) | \
            util_bitpack_uint((__unpacked)->afbc_zs.msaa, 8, 9) | \
            util_bitpack_uint((__unpacked)->afbc_zs.reverse_issue_order, 30, 30) | \
            util_bitpack_uint((__unpacked)->afbc_zs.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->zs.write_format, 0, 3) | \
            util_bitpack_uint((__unpacked)->zs.block_format, 4, 7) | \
            util_bitpack_uint((__unpacked)->zs.msaa, 8, 9) | \
            util_bitpack_uint((__unpacked)->zs.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->afbc_s.write_format, 16, 19) | \
            util_bitpack_uint((__unpacked)->afbc_s.block_format, 20, 23) | \
            util_bitpack_uint((__unpacked)->afbc_s.msaa, 24, 25) | \
            util_bitpack_uint((__unpacked)->afbc_s.reverse_issue_order, 30, 30) | \
            util_bitpack_uint((__unpacked)->afbc_s.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->s.write_format, 16, 19) | \
            util_bitpack_uint((__unpacked)->s.block_format, 20, 23) | \
            util_bitpack_uint((__unpacked)->s.msaa, 24, 25) | \
            util_bitpack_uint((__unpacked)->s.clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->crc.row_stride, 0, 26); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->crc.clear_color, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->crc.clear_color, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->crc.base, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->crc.base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->afbc_zs.header, 0, 63) | \
            util_bitpack_uint((__unpacked)->zs.base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->afbc_zs.header, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->zs.base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->afbc_zs.header_row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->zs.row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->zs.surface_stride_hi, 27, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->afbc_zs.body_offset, 0, 31) | \
            util_bitpack_uint((__unpacked)->zs.surface_stride, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->afbc_s.header, 0, 63) | \
            util_bitpack_uint((__unpacked)->s.base, 0, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->afbc_s.header, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->s.base, 0, 63) >> 32; \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->afbc_s.header_row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->s.row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->s.surface_stride_hi, 27, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->afbc_s.body_offset, 0, 31) | \
            util_bitpack_uint((__unpacked)->s.surface_stride, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ZS_CRC_EXTENSION_unpack(__packed, __unpacked) \
do { \
   MALI_ZS_CRC_EXTENSION_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x3c001c00) fprintf(stderr, "XXX: Invalid field of ZS CRC Extension unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of ZS CRC Extension unpacked at word 1\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS CRC Extension unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of ZS CRC Extension unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->crc.render_target, &__tmp_packed.opaque[0], 13, 15); \
   __gen_unpack_uint((__unpacked)->crc.row_stride, &__tmp_packed.opaque[0], 32, 58); \
   __gen_unpack_uint((__unpacked)->crc.clear_color, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->crc.base, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->afbc_zs.write_format, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->afbc_zs.block_format, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->afbc_zs.msaa, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->afbc_zs.reverse_issue_order, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->afbc_zs.clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->afbc_zs.header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->afbc_zs.header_row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->afbc_zs.body_offset, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->zs.write_format, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->zs.block_format, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->zs.msaa, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->zs.clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->zs.base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->zs.row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->zs.surface_stride_hi, &__tmp_packed.opaque[0], 347, 351); \
   __gen_unpack_uint((__unpacked)->zs.surface_stride, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->afbc_s.write_format, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->afbc_s.block_format, &__tmp_packed.opaque[0], 20, 23); \
   __gen_unpack_uint((__unpacked)->afbc_s.msaa, &__tmp_packed.opaque[0], 24, 25); \
   __gen_unpack_uint((__unpacked)->afbc_s.reverse_issue_order, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->afbc_s.clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->afbc_s.header, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->afbc_s.header_row_stride, &__tmp_packed.opaque[0], 448, 474); \
   __gen_unpack_uint((__unpacked)->afbc_s.body_offset, &__tmp_packed.opaque[0], 480, 511); \
   __gen_unpack_uint((__unpacked)->s.write_format, &__tmp_packed.opaque[0], 16, 19); \
   __gen_unpack_uint((__unpacked)->s.block_format, &__tmp_packed.opaque[0], 20, 23); \
   __gen_unpack_uint((__unpacked)->s.msaa, &__tmp_packed.opaque[0], 24, 25); \
   __gen_unpack_uint((__unpacked)->s.clean_pixel_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->s.base, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->s.row_stride, &__tmp_packed.opaque[0], 448, 474); \
   __gen_unpack_uint((__unpacked)->s.surface_stride_hi, &__tmp_packed.opaque[0], 475, 479); \
   __gen_unpack_uint((__unpacked)->s.surface_stride, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ZS_CRC_EXTENSION_print(FILE *fp, const struct MALI_ZS_CRC_EXTENSION * values, unsigned indent)
{
   fprintf(fp, "%*sCRC:\n", indent, "");
   MALI_CRC_print(fp, &values->crc, indent + 2);
   fprintf(fp, "%*sAFBC ZS:\n", indent, "");
   MALI_AFBC_ZS_TARGET_print(fp, &values->afbc_zs, indent + 2);
   fprintf(fp, "%*sZS:\n", indent, "");
   MALI_ZS_TARGET_print(fp, &values->zs, indent + 2);
   fprintf(fp, "%*sAFBC S:\n", indent, "");
   MALI_AFBC_S_TARGET_print(fp, &values->afbc_s, indent + 2);
   fprintf(fp, "%*sS:\n", indent, "");
   MALI_S_TARGET_print(fp, &values->s, indent + 2);
}

#endif
enum mali_yuv_conv_k6 {
        MALI_YUV_CONV_K6_0                   =      0,
        MALI_YUV_CONV_K6_16                  =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_conv_k6_as_str(enum mali_yuv_conv_k6 imm)
{
    switch (imm) {
    case MALI_YUV_CONV_K6_0: return "0";
    case MALI_YUV_CONV_K6_16: return "16";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_conv_k7_clamp {
        MALI_YUV_CONV_K7_CLAMP_MINUS_128_TO_127 =      0,
        MALI_YUV_CONV_K7_CLAMP_MINUS_112_TO_111 =      1,
        MALI_YUV_CONV_K7_CLAMP_0_TO_255      =      2,
        MALI_YUV_CONV_K7_CLAMP_16_TO_239     =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_conv_k7_clamp_as_str(enum mali_yuv_conv_k7_clamp imm)
{
    switch (imm) {
    case MALI_YUV_CONV_K7_CLAMP_MINUS_128_TO_127: return "MINUS_128_TO_127";
    case MALI_YUV_CONV_K7_CLAMP_MINUS_112_TO_111: return "MINUS_112_TO_111";
    case MALI_YUV_CONV_K7_CLAMP_0_TO_255: return "0_TO_255";
    case MALI_YUV_CONV_K7_CLAMP_16_TO_239: return "16_TO_239";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_conv_k8 {
        MALI_YUV_CONV_K8_220                 =      0,
        MALI_YUV_CONV_K8_256                 =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_conv_k8_as_str(enum mali_yuv_conv_k8 imm)
{
    switch (imm) {
    case MALI_YUV_CONV_K8_220: return "220";
    case MALI_YUV_CONV_K8_256: return "256";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_RT_CLEAR {
   uint64_t                             color_0;
   uint64_t                             color_1;
   uint64_t                             color_2;
   uint64_t                             color_3;
};

#define MALI_RT_CLEAR_header                    \
   0

#define MALI_RT_CLEAR_LENGTH 16
struct mali_rt_clear_packed { uint32_t opaque[4]; };
#define MALI_RT_CLEAR_PACKED_T struct mali_rt_clear_packed
#define MALI_RT_CLEAR_pack(__packed, __unpacked) \
do { \
   MALI_RT_CLEAR_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->color_0, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->color_1, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->color_2, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RT_CLEAR_unpack(__packed, __unpacked) \
do { \
   MALI_RT_CLEAR_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->color_0, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->color_1, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->color_2, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->color_3, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RT_CLEAR_print(FILE *fp, const struct MALI_RT_CLEAR * values, unsigned indent)
{
   fprintf(fp, "%*sColor 0: 0x%" PRIx64 "\n", indent, "", values->color_0);
   fprintf(fp, "%*sColor 1: 0x%" PRIx64 "\n", indent, "", values->color_1);
   fprintf(fp, "%*sColor 2: 0x%" PRIx64 "\n", indent, "", values->color_2);
   fprintf(fp, "%*sColor 3: 0x%" PRIx64 "\n", indent, "", values->color_3);
}

#endif
struct MALI_RGB_RENDER_TARGET {
   enum mali_writeback_mode             writeback_mode;
   uint32_t                             internal_buffer_offset;
   bool                                 yuv_enable;
   bool                                 dithered_clear;
   enum mali_color_buffer_internal_format internal_format;
   bool                                 write_enable;
   enum mali_color_format               writeback_format;
   enum mali_block_format               writeback_block_format;
   enum mali_msaa                       writeback_msaa;
   bool                                 srgb;
   bool                                 dithering_enable;
   uint32_t                             swizzle;
   bool                                 clean_pixel_write_enable;
   struct MALI_RT_BUFFER                writeback_buffer;
   struct MALI_RT_CLEAR                 clear;
};

#define MALI_RGB_RENDER_TARGET_header           \
   .writeback_mode = MALI_WRITEBACK_MODE_COMPAT,  \
   .yuv_enable = false,  \
   .writeback_buffer = { MALI_RT_BUFFER_header },  \
   .clear = { MALI_RT_CLEAR_header }

#define MALI_RGB_RENDER_TARGET_LENGTH 64
#define MALI_RGB_RENDER_TARGET_ALIGN 64
struct mali_rgb_render_target_packed { uint32_t opaque[16]; };
#define MALI_RGB_RENDER_TARGET_PACKED_T struct mali_rgb_render_target_packed
#define MALI_RGB_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_RGB_RENDER_TARGET_PACKED_T __tmp_packed; \
   assert(((__unpacked)->internal_buffer_offset & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->writeback_buffer.base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->writeback_buffer.base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->writeback_buffer.row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->writeback_buffer.surface_stride_hi, 27, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->writeback_buffer.surface_stride, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RGB_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_RGB_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff0000) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000006) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of RGB Render Target unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->internal_buffer_offset = (__unpacked)->internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->writeback_buffer.base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->writeback_buffer.row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->writeback_buffer.surface_stride_hi, &__tmp_packed.opaque[0], 347, 351); \
   __gen_unpack_uint((__unpacked)->writeback_buffer.surface_stride, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RGB_RENDER_TARGET_print(FILE *fp, const struct MALI_RGB_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWriteback Mode: %s\n", indent, "", mali_writeback_mode_as_str(values->writeback_mode));
   fprintf(fp, "%*sInternal Buffer Offset: %u\n", indent, "", values->internal_buffer_offset);
   fprintf(fp, "%*sYUV Enable: %s\n", indent, "", values->yuv_enable ? "true" : "false");
   fprintf(fp, "%*sDithered Clear: %s\n", indent, "", values->dithered_clear ? "true" : "false");
   fprintf(fp, "%*sInternal Format: %s\n", indent, "", mali_color_buffer_internal_format_as_str(values->internal_format));
   fprintf(fp, "%*sWrite Enable: %s\n", indent, "", values->write_enable ? "true" : "false");
   fprintf(fp, "%*sWriteback Format: %s\n", indent, "", mali_color_format_as_str(values->writeback_format));
   fprintf(fp, "%*sWriteback Block Format: %s\n", indent, "", mali_block_format_as_str(values->writeback_block_format));
   fprintf(fp, "%*sWriteback MSAA: %s\n", indent, "", mali_msaa_as_str(values->writeback_msaa));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sDithering Enable: %s\n", indent, "", values->dithering_enable ? "true" : "false");
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sWriteback buffer:\n", indent, "");
   MALI_RT_BUFFER_print(fp, &values->writeback_buffer, indent + 2);
   fprintf(fp, "%*sClear:\n", indent, "");
   MALI_RT_CLEAR_print(fp, &values->clear, indent + 2);
}

#endif
struct MALI_YUV_RENDER_TARGET {
   enum mali_writeback_mode             writeback_mode;
   uint32_t                             internal_buffer_offset;
   bool                                 yuv_enable;
   bool                                 dithered_clear;
   enum mali_color_buffer_internal_format internal_format;
   bool                                 write_enable;
   enum mali_color_format               writeback_format;
   enum mali_block_format               writeback_block_format;
   enum mali_msaa                       writeback_msaa;
   bool                                 srgb;
   bool                                 dithering_enable;
   uint32_t                             swizzle;
   bool                                 clean_pixel_write_enable;
   enum mali_yuv_swizzle                yuv_swizzle;
   bool                                 full_range;
   enum mali_yuv_conversion_mode        conversion_mode;
   enum mali_yuv_cr_siting              cr_siting;
   bool                                 unsigned_cr_range;
   uint64_t                             plane_0_base;
   uint64_t                             plane_1_base;
   uint64_t                             plane_2_base;
   uint32_t                             plane_0_stride;
   uint32_t                             plane_1_2_stride;
   struct MALI_RT_CLEAR                 clear;
};

#define MALI_YUV_RENDER_TARGET_header           \
   .writeback_mode = MALI_WRITEBACK_MODE_COMPAT,  \
   .yuv_enable = true,  \
   .clear = { MALI_RT_CLEAR_header }

#define MALI_YUV_RENDER_TARGET_LENGTH 64
#define MALI_YUV_RENDER_TARGET_ALIGN 64
struct mali_yuv_render_target_packed { uint32_t opaque[16]; };
#define MALI_YUV_RENDER_TARGET_PACKED_T struct mali_yuv_render_target_packed
#define MALI_YUV_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_YUV_RENDER_TARGET_PACKED_T __tmp_packed; \
   assert(((__unpacked)->internal_buffer_offset & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->yuv_swizzle, 16, 18) | \
            util_bitpack_uint((__unpacked)->full_range, 20, 20) | \
            util_bitpack_uint((__unpacked)->conversion_mode, 21, 24) | \
            util_bitpack_uint((__unpacked)->cr_siting, 25, 27) | \
            util_bitpack_uint((__unpacked)->unsigned_cr_range, 28, 28); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->plane_0_base, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->plane_0_base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->plane_1_base, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->plane_1_base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->plane_2_base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->plane_2_base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->plane_0_stride, 0, 26); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->plane_1_2_stride, 0, 26); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_YUV_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_YUV_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff0000) fprintf(stderr, "XXX: Invalid field of YUV Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000006) fprintf(stderr, "XXX: Invalid field of YUV Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xe008ffff) fprintf(stderr, "XXX: Invalid field of YUV Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of YUV Render Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[10] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of YUV Render Target unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of YUV Render Target unpacked at word 11\n"); \
   __gen_unpack_uint((__unpacked)->writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->internal_buffer_offset = (__unpacked)->internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->yuv_swizzle, &__tmp_packed.opaque[0], 80, 82); \
   __gen_unpack_uint((__unpacked)->full_range, &__tmp_packed.opaque[0], 84, 84); \
   __gen_unpack_uint((__unpacked)->conversion_mode, &__tmp_packed.opaque[0], 85, 88); \
   __gen_unpack_uint((__unpacked)->cr_siting, &__tmp_packed.opaque[0], 89, 91); \
   __gen_unpack_uint((__unpacked)->unsigned_cr_range, &__tmp_packed.opaque[0], 92, 92); \
   __gen_unpack_uint((__unpacked)->plane_0_base, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->plane_1_base, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->plane_2_base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->plane_0_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->plane_1_2_stride, &__tmp_packed.opaque[0], 352, 378); \
   __gen_unpack_uint((__unpacked)->clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_YUV_RENDER_TARGET_print(FILE *fp, const struct MALI_YUV_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWriteback Mode: %s\n", indent, "", mali_writeback_mode_as_str(values->writeback_mode));
   fprintf(fp, "%*sInternal Buffer Offset: %u\n", indent, "", values->internal_buffer_offset);
   fprintf(fp, "%*sYUV Enable: %s\n", indent, "", values->yuv_enable ? "true" : "false");
   fprintf(fp, "%*sDithered Clear: %s\n", indent, "", values->dithered_clear ? "true" : "false");
   fprintf(fp, "%*sInternal Format: %s\n", indent, "", mali_color_buffer_internal_format_as_str(values->internal_format));
   fprintf(fp, "%*sWrite Enable: %s\n", indent, "", values->write_enable ? "true" : "false");
   fprintf(fp, "%*sWriteback Format: %s\n", indent, "", mali_color_format_as_str(values->writeback_format));
   fprintf(fp, "%*sWriteback Block Format: %s\n", indent, "", mali_block_format_as_str(values->writeback_block_format));
   fprintf(fp, "%*sWriteback MSAA: %s\n", indent, "", mali_msaa_as_str(values->writeback_msaa));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sDithering Enable: %s\n", indent, "", values->dithering_enable ? "true" : "false");
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sYUV Swizzle: %s\n", indent, "", mali_yuv_swizzle_as_str(values->yuv_swizzle));
   fprintf(fp, "%*sFull Range: %s\n", indent, "", values->full_range ? "true" : "false");
   fprintf(fp, "%*sConversion Mode: %s\n", indent, "", mali_yuv_conversion_mode_as_str(values->conversion_mode));
   fprintf(fp, "%*sCr Siting: %s\n", indent, "", mali_yuv_cr_siting_as_str(values->cr_siting));
   fprintf(fp, "%*sUnsigned Cr Range: %s\n", indent, "", values->unsigned_cr_range ? "true" : "false");
   fprintf(fp, "%*sPlane 0 Base: 0x%" PRIx64 "\n", indent, "", values->plane_0_base);
   fprintf(fp, "%*sPlane 1 Base: 0x%" PRIx64 "\n", indent, "", values->plane_1_base);
   fprintf(fp, "%*sPlane 2 Base: 0x%" PRIx64 "\n", indent, "", values->plane_2_base);
   fprintf(fp, "%*sPlane 0 Stride: %u\n", indent, "", values->plane_0_stride);
   fprintf(fp, "%*sPlane 1 2 Stride: %u\n", indent, "", values->plane_1_2_stride);
   fprintf(fp, "%*sClear:\n", indent, "");
   MALI_RT_CLEAR_print(fp, &values->clear, indent + 2);
}

#endif
struct MALI_AFBC_RGB_RENDER_TARGET {
   enum mali_writeback_mode             writeback_mode;
   uint32_t                             internal_buffer_offset;
   bool                                 yuv_enable;
   bool                                 dithered_clear;
   enum mali_color_buffer_internal_format internal_format;
   bool                                 write_enable;
   enum mali_color_format               writeback_format;
   enum mali_block_format               writeback_block_format;
   enum mali_msaa                       writeback_msaa;
   bool                                 srgb;
   bool                                 dithering_enable;
   uint32_t                             swizzle;
   bool                                 clean_pixel_write_enable;
   bool                                 yuv_transform;
   bool                                 split_block;
   bool                                 wide_block;
   bool                                 reverse_issue_order;
   bool                                 front_buffer;
   bool                                 alpha_hint;
   enum mali_afbc_compression_mode      compression_mode;
   uint64_t                             header;
   uint32_t                             row_stride;
   uint64_t                             body_offset;
   struct MALI_RT_CLEAR                 clear;
};

#define MALI_AFBC_RGB_RENDER_TARGET_header      \
   .writeback_mode = MALI_WRITEBACK_MODE_COMPAT,  \
   .yuv_enable = false,  \
   .clear = { MALI_RT_CLEAR_header }

#define MALI_AFBC_RGB_RENDER_TARGET_LENGTH 64
#define MALI_AFBC_RGB_RENDER_TARGET_ALIGN 64
struct mali_afbc_rgb_render_target_packed { uint32_t opaque[16]; };
#define MALI_AFBC_RGB_RENDER_TARGET_PACKED_T struct mali_afbc_rgb_render_target_packed
#define MALI_AFBC_RGB_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_AFBC_RGB_RENDER_TARGET_PACKED_T __tmp_packed; \
   assert(((__unpacked)->internal_buffer_offset & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->yuv_transform, 0, 0) | \
            util_bitpack_uint((__unpacked)->split_block, 1, 1) | \
            util_bitpack_uint((__unpacked)->wide_block, 2, 2) | \
            util_bitpack_uint((__unpacked)->reverse_issue_order, 3, 3) | \
            util_bitpack_uint((__unpacked)->front_buffer, 4, 4) | \
            util_bitpack_uint((__unpacked)->alpha_hint, 5, 5) | \
            util_bitpack_uint((__unpacked)->compression_mode, 10, 15); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->header, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->header, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->row_stride, 0, 26); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->body_offset, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFBC_RGB_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_AFBC_RGB_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff0000) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000006) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffff03c0) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 7\n"); \
   if (__tmp_packed.opaque[10] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of AFBC RGB Render Target unpacked at word 10\n"); \
   __gen_unpack_uint((__unpacked)->writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->internal_buffer_offset = (__unpacked)->internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->yuv_transform, &__tmp_packed.opaque[0], 64, 64); \
   __gen_unpack_uint((__unpacked)->split_block, &__tmp_packed.opaque[0], 65, 65); \
   __gen_unpack_uint((__unpacked)->wide_block, &__tmp_packed.opaque[0], 66, 66); \
   __gen_unpack_uint((__unpacked)->reverse_issue_order, &__tmp_packed.opaque[0], 67, 67); \
   __gen_unpack_uint((__unpacked)->front_buffer, &__tmp_packed.opaque[0], 68, 68); \
   __gen_unpack_uint((__unpacked)->alpha_hint, &__tmp_packed.opaque[0], 69, 69); \
   __gen_unpack_uint((__unpacked)->compression_mode, &__tmp_packed.opaque[0], 74, 79); \
   __gen_unpack_uint((__unpacked)->header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->body_offset, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFBC_RGB_RENDER_TARGET_print(FILE *fp, const struct MALI_AFBC_RGB_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWriteback Mode: %s\n", indent, "", mali_writeback_mode_as_str(values->writeback_mode));
   fprintf(fp, "%*sInternal Buffer Offset: %u\n", indent, "", values->internal_buffer_offset);
   fprintf(fp, "%*sYUV Enable: %s\n", indent, "", values->yuv_enable ? "true" : "false");
   fprintf(fp, "%*sDithered Clear: %s\n", indent, "", values->dithered_clear ? "true" : "false");
   fprintf(fp, "%*sInternal Format: %s\n", indent, "", mali_color_buffer_internal_format_as_str(values->internal_format));
   fprintf(fp, "%*sWrite Enable: %s\n", indent, "", values->write_enable ? "true" : "false");
   fprintf(fp, "%*sWriteback Format: %s\n", indent, "", mali_color_format_as_str(values->writeback_format));
   fprintf(fp, "%*sWriteback Block Format: %s\n", indent, "", mali_block_format_as_str(values->writeback_block_format));
   fprintf(fp, "%*sWriteback MSAA: %s\n", indent, "", mali_msaa_as_str(values->writeback_msaa));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sDithering Enable: %s\n", indent, "", values->dithering_enable ? "true" : "false");
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sYUV Transform: %s\n", indent, "", values->yuv_transform ? "true" : "false");
   fprintf(fp, "%*sSplit block: %s\n", indent, "", values->split_block ? "true" : "false");
   fprintf(fp, "%*sWide block: %s\n", indent, "", values->wide_block ? "true" : "false");
   fprintf(fp, "%*sReverse issue order: %s\n", indent, "", values->reverse_issue_order ? "true" : "false");
   fprintf(fp, "%*sFront buffer: %s\n", indent, "", values->front_buffer ? "true" : "false");
   fprintf(fp, "%*sAlpha hint: %s\n", indent, "", values->alpha_hint ? "true" : "false");
   fprintf(fp, "%*sCompression mode: %s\n", indent, "", mali_afbc_compression_mode_as_str(values->compression_mode));
   fprintf(fp, "%*sHeader: 0x%" PRIx64 "\n", indent, "", values->header);
   fprintf(fp, "%*sRow stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sBody offset: 0x%" PRIx64 "\n", indent, "", values->body_offset);
   fprintf(fp, "%*sClear:\n", indent, "");
   MALI_RT_CLEAR_print(fp, &values->clear, indent + 2);
}

#endif
struct MALI_AFBC_YUV_RENDER_TARGET {
   enum mali_writeback_mode             writeback_mode;
   uint32_t                             internal_buffer_offset;
   bool                                 yuv_enable;
   bool                                 dithered_clear;
   enum mali_color_buffer_internal_format internal_format;
   bool                                 write_enable;
   enum mali_color_format               writeback_format;
   enum mali_block_format               writeback_block_format;
   enum mali_msaa                       writeback_msaa;
   bool                                 srgb;
   bool                                 dithering_enable;
   uint32_t                             swizzle;
   bool                                 clean_pixel_write_enable;
   bool                                 yuv_transform;
   bool                                 split_block;
   bool                                 wide_block;
   bool                                 reverse_issue_order;
   bool                                 front_buffer;
   bool                                 alpha_hint;
   enum mali_afbc_compression_mode      compression_mode;
   enum mali_yuv_swizzle                yuv_swizzle;
   bool                                 full_range;
   enum mali_yuv_conversion_mode        conversion_mode;
   enum mali_yuv_cr_siting              cr_siting;
   bool                                 unsigned_cr_range;
   uint64_t                             header;
   uint32_t                             row_stride;
   uint64_t                             body_offset;
   struct MALI_RT_CLEAR                 clear;
};

#define MALI_AFBC_YUV_RENDER_TARGET_header      \
   .writeback_mode = MALI_WRITEBACK_MODE_COMPAT,  \
   .yuv_enable = true,  \
   .yuv_transform = false,  \
   .clear = { MALI_RT_CLEAR_header }

#define MALI_AFBC_YUV_RENDER_TARGET_LENGTH 64
#define MALI_AFBC_YUV_RENDER_TARGET_ALIGN 64
struct mali_afbc_yuv_render_target_packed { uint32_t opaque[16]; };
#define MALI_AFBC_YUV_RENDER_TARGET_PACKED_T struct mali_afbc_yuv_render_target_packed
#define MALI_AFBC_YUV_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_AFBC_YUV_RENDER_TARGET_PACKED_T __tmp_packed; \
   assert(((__unpacked)->internal_buffer_offset & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->yuv_transform, 0, 0) | \
            util_bitpack_uint((__unpacked)->split_block, 1, 1) | \
            util_bitpack_uint((__unpacked)->wide_block, 2, 2) | \
            util_bitpack_uint((__unpacked)->reverse_issue_order, 3, 3) | \
            util_bitpack_uint((__unpacked)->front_buffer, 4, 4) | \
            util_bitpack_uint((__unpacked)->alpha_hint, 5, 5) | \
            util_bitpack_uint((__unpacked)->compression_mode, 10, 15) | \
            util_bitpack_uint((__unpacked)->yuv_swizzle, 16, 18) | \
            util_bitpack_uint((__unpacked)->full_range, 20, 20) | \
            util_bitpack_uint((__unpacked)->conversion_mode, 21, 24) | \
            util_bitpack_uint((__unpacked)->cr_siting, 25, 27) | \
            util_bitpack_uint((__unpacked)->unsigned_cr_range, 28, 28); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->header, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->header, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->row_stride, 0, 26); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->body_offset, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFBC_YUV_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_AFBC_YUV_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff0000) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000006) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xe00803c0) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 7\n"); \
   if (__tmp_packed.opaque[10] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of AFBC YUV Render Target unpacked at word 10\n"); \
   __gen_unpack_uint((__unpacked)->writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->internal_buffer_offset = (__unpacked)->internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->yuv_transform, &__tmp_packed.opaque[0], 64, 64); \
   __gen_unpack_uint((__unpacked)->split_block, &__tmp_packed.opaque[0], 65, 65); \
   __gen_unpack_uint((__unpacked)->wide_block, &__tmp_packed.opaque[0], 66, 66); \
   __gen_unpack_uint((__unpacked)->reverse_issue_order, &__tmp_packed.opaque[0], 67, 67); \
   __gen_unpack_uint((__unpacked)->front_buffer, &__tmp_packed.opaque[0], 68, 68); \
   __gen_unpack_uint((__unpacked)->alpha_hint, &__tmp_packed.opaque[0], 69, 69); \
   __gen_unpack_uint((__unpacked)->compression_mode, &__tmp_packed.opaque[0], 74, 79); \
   __gen_unpack_uint((__unpacked)->yuv_swizzle, &__tmp_packed.opaque[0], 80, 82); \
   __gen_unpack_uint((__unpacked)->full_range, &__tmp_packed.opaque[0], 84, 84); \
   __gen_unpack_uint((__unpacked)->conversion_mode, &__tmp_packed.opaque[0], 85, 88); \
   __gen_unpack_uint((__unpacked)->cr_siting, &__tmp_packed.opaque[0], 89, 91); \
   __gen_unpack_uint((__unpacked)->unsigned_cr_range, &__tmp_packed.opaque[0], 92, 92); \
   __gen_unpack_uint((__unpacked)->header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->body_offset, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFBC_YUV_RENDER_TARGET_print(FILE *fp, const struct MALI_AFBC_YUV_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWriteback Mode: %s\n", indent, "", mali_writeback_mode_as_str(values->writeback_mode));
   fprintf(fp, "%*sInternal Buffer Offset: %u\n", indent, "", values->internal_buffer_offset);
   fprintf(fp, "%*sYUV Enable: %s\n", indent, "", values->yuv_enable ? "true" : "false");
   fprintf(fp, "%*sDithered Clear: %s\n", indent, "", values->dithered_clear ? "true" : "false");
   fprintf(fp, "%*sInternal Format: %s\n", indent, "", mali_color_buffer_internal_format_as_str(values->internal_format));
   fprintf(fp, "%*sWrite Enable: %s\n", indent, "", values->write_enable ? "true" : "false");
   fprintf(fp, "%*sWriteback Format: %s\n", indent, "", mali_color_format_as_str(values->writeback_format));
   fprintf(fp, "%*sWriteback Block Format: %s\n", indent, "", mali_block_format_as_str(values->writeback_block_format));
   fprintf(fp, "%*sWriteback MSAA: %s\n", indent, "", mali_msaa_as_str(values->writeback_msaa));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sDithering Enable: %s\n", indent, "", values->dithering_enable ? "true" : "false");
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sYUV Transform: %s\n", indent, "", values->yuv_transform ? "true" : "false");
   fprintf(fp, "%*sSplit block: %s\n", indent, "", values->split_block ? "true" : "false");
   fprintf(fp, "%*sWide block: %s\n", indent, "", values->wide_block ? "true" : "false");
   fprintf(fp, "%*sReverse issue order: %s\n", indent, "", values->reverse_issue_order ? "true" : "false");
   fprintf(fp, "%*sFront buffer: %s\n", indent, "", values->front_buffer ? "true" : "false");
   fprintf(fp, "%*sAlpha hint: %s\n", indent, "", values->alpha_hint ? "true" : "false");
   fprintf(fp, "%*sCompression mode: %s\n", indent, "", mali_afbc_compression_mode_as_str(values->compression_mode));
   fprintf(fp, "%*sYUV Swizzle: %s\n", indent, "", mali_yuv_swizzle_as_str(values->yuv_swizzle));
   fprintf(fp, "%*sFull Range: %s\n", indent, "", values->full_range ? "true" : "false");
   fprintf(fp, "%*sConversion Mode: %s\n", indent, "", mali_yuv_conversion_mode_as_str(values->conversion_mode));
   fprintf(fp, "%*sCr Siting: %s\n", indent, "", mali_yuv_cr_siting_as_str(values->cr_siting));
   fprintf(fp, "%*sUnsigned Cr Range: %s\n", indent, "", values->unsigned_cr_range ? "true" : "false");
   fprintf(fp, "%*sHeader: 0x%" PRIx64 "\n", indent, "", values->header);
   fprintf(fp, "%*sRow stride: %u\n", indent, "", values->row_stride);
   fprintf(fp, "%*sBody offset: 0x%" PRIx64 "\n", indent, "", values->body_offset);
   fprintf(fp, "%*sClear:\n", indent, "");
   MALI_RT_CLEAR_print(fp, &values->clear, indent + 2);
}

#endif
struct MALI_AFRC_RGB_RENDER_TARGET {
   enum mali_writeback_mode             writeback_mode;
   uint32_t                             internal_buffer_offset;
   bool                                 yuv_enable;
   bool                                 dithered_clear;
   enum mali_color_buffer_internal_format internal_format;
   enum mali_color_format               writeback_format;
   enum mali_msaa                       writeback_msaa;
   bool                                 srgb;
   bool                                 dithering_enable;
   uint32_t                             swizzle;
   bool                                 clean_pixel_write_enable;
   enum mali_afrc_block_size            afrc_block_size;
   enum mali_afrc_format                afrc_format;
   uint32_t                             afrc_codec_args;
   struct MALI_RT_BUFFER                writeback_buffer;
   struct MALI_RT_CLEAR                 clear;
};

#define MALI_AFRC_RGB_RENDER_TARGET_header      \
   .writeback_mode = MALI_WRITEBACK_MODE_AFRC_RGB,  \
   .yuv_enable = true,  \
   .writeback_buffer = { MALI_RT_BUFFER_header },  \
   .clear = { MALI_RT_CLEAR_header }

#define MALI_AFRC_RGB_RENDER_TARGET_LENGTH 64
#define MALI_AFRC_RGB_RENDER_TARGET_ALIGN 64
struct mali_afrc_rgb_render_target_packed { uint32_t opaque[16]; };
#define MALI_AFRC_RGB_RENDER_TARGET_PACKED_T struct mali_afrc_rgb_render_target_packed
#define MALI_AFRC_RGB_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_AFRC_RGB_RENDER_TARGET_PACKED_T __tmp_packed; \
   assert(((__unpacked)->internal_buffer_offset & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->writeback_format, 0, 7) | \
            util_bitpack_uint((__unpacked)->writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->afrc_block_size, 4, 7) | \
            util_bitpack_uint((__unpacked)->afrc_format, 8, 15); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->afrc_codec_args, 0, 7); \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->writeback_buffer.base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->writeback_buffer.base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->writeback_buffer.row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->writeback_buffer.surface_stride_hi, 27, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->writeback_buffer.surface_stride, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFRC_RGB_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_AFRC_RGB_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff0000) fprintf(stderr, "XXX: Invalid field of AFRC RGB Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000f00) fprintf(stderr, "XXX: Invalid field of AFRC RGB Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffff000f) fprintf(stderr, "XXX: Invalid field of AFRC RGB Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of AFRC RGB Render Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFRC RGB Render Target unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFRC RGB Render Target unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFRC RGB Render Target unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of AFRC RGB Render Target unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->internal_buffer_offset = (__unpacked)->internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->writeback_format, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->afrc_block_size, &__tmp_packed.opaque[0], 68, 71); \
   __gen_unpack_uint((__unpacked)->afrc_format, &__tmp_packed.opaque[0], 72, 79); \
   __gen_unpack_uint((__unpacked)->afrc_codec_args, &__tmp_packed.opaque[0], 96, 103); \
   __gen_unpack_uint((__unpacked)->writeback_buffer.base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->writeback_buffer.row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->writeback_buffer.surface_stride_hi, &__tmp_packed.opaque[0], 347, 351); \
   __gen_unpack_uint((__unpacked)->writeback_buffer.surface_stride, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFRC_RGB_RENDER_TARGET_print(FILE *fp, const struct MALI_AFRC_RGB_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWriteback Mode: %s\n", indent, "", mali_writeback_mode_as_str(values->writeback_mode));
   fprintf(fp, "%*sInternal Buffer Offset: %u\n", indent, "", values->internal_buffer_offset);
   fprintf(fp, "%*sYUV Enable: %s\n", indent, "", values->yuv_enable ? "true" : "false");
   fprintf(fp, "%*sDithered Clear: %s\n", indent, "", values->dithered_clear ? "true" : "false");
   fprintf(fp, "%*sInternal Format: %s\n", indent, "", mali_color_buffer_internal_format_as_str(values->internal_format));
   fprintf(fp, "%*sWriteback Format: %s\n", indent, "", mali_color_format_as_str(values->writeback_format));
   fprintf(fp, "%*sWriteback MSAA: %s\n", indent, "", mali_msaa_as_str(values->writeback_msaa));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sDithering Enable: %s\n", indent, "", values->dithering_enable ? "true" : "false");
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sAFRC Block Size: %s\n", indent, "", mali_afrc_block_size_as_str(values->afrc_block_size));
   fprintf(fp, "%*sAFRC Format: %s\n", indent, "", mali_afrc_format_as_str(values->afrc_format));
   fprintf(fp, "%*sAFRC Codec args: %u\n", indent, "", values->afrc_codec_args);
   fprintf(fp, "%*sWriteback buffer:\n", indent, "");
   MALI_RT_BUFFER_print(fp, &values->writeback_buffer, indent + 2);
   fprintf(fp, "%*sClear:\n", indent, "");
   MALI_RT_CLEAR_print(fp, &values->clear, indent + 2);
}

#endif
struct MALI_AFRC_YUV_RENDER_TARGET {
   enum mali_writeback_mode             writeback_mode;
   uint32_t                             internal_buffer_offset;
   bool                                 yuv_enable;
   bool                                 dithered_clear;
   enum mali_color_buffer_internal_format internal_format;
   enum mali_color_format               writeback_format;
   enum mali_msaa                       writeback_msaa;
   bool                                 srgb;
   bool                                 dithering_enable;
   uint32_t                             swizzle;
   bool                                 clean_pixel_write_enable;
   enum mali_afrc_block_size            afrc_luma_block_size;
   enum mali_afrc_format                afrc_luma_format;
   enum mali_yuv_swizzle                yuv_swizzle;
   bool                                 full_range;
   enum mali_yuv_conversion_mode        conversion_mode;
   enum mali_yuv_cr_siting              cr_siting;
   bool                                 unsigned_cr_range;
   uint32_t                             afrc_luma_codec_args;
   uint32_t                             afrc_chroma_codec_args;
   enum mali_afrc_block_size            afrc_chroma_block_size;
   enum mali_afrc_format                afrc_chroma_format;
   uint64_t                             plane_0_base;
   uint64_t                             plane_1_base;
   uint64_t                             plane_2_base;
   uint32_t                             plane_0_stride;
   uint32_t                             plane_1_2_stride;
   struct MALI_RT_CLEAR                 clear;
};

#define MALI_AFRC_YUV_RENDER_TARGET_header      \
   .writeback_mode = MALI_WRITEBACK_MODE_AFRC_YUV,  \
   .yuv_enable = true,  \
   .clear = { MALI_RT_CLEAR_header }

#define MALI_AFRC_YUV_RENDER_TARGET_LENGTH 64
#define MALI_AFRC_YUV_RENDER_TARGET_ALIGN 64
struct mali_afrc_yuv_render_target_packed { uint32_t opaque[16]; };
#define MALI_AFRC_YUV_RENDER_TARGET_PACKED_T struct mali_afrc_yuv_render_target_packed
#define MALI_AFRC_YUV_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_AFRC_YUV_RENDER_TARGET_PACKED_T __tmp_packed; \
   assert(((__unpacked)->internal_buffer_offset & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->writeback_format, 0, 7) | \
            util_bitpack_uint((__unpacked)->writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->afrc_luma_block_size, 4, 7) | \
            util_bitpack_uint((__unpacked)->afrc_luma_format, 8, 15) | \
            util_bitpack_uint((__unpacked)->yuv_swizzle, 16, 18) | \
            util_bitpack_uint((__unpacked)->full_range, 20, 20) | \
            util_bitpack_uint((__unpacked)->conversion_mode, 21, 24) | \
            util_bitpack_uint((__unpacked)->cr_siting, 25, 27) | \
            util_bitpack_uint((__unpacked)->unsigned_cr_range, 28, 28); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->afrc_luma_codec_args, 0, 7) | \
            util_bitpack_uint((__unpacked)->afrc_chroma_codec_args, 8, 15) | \
            util_bitpack_uint((__unpacked)->afrc_chroma_block_size, 20, 23) | \
            util_bitpack_uint((__unpacked)->afrc_chroma_format, 24, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->plane_0_base, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->plane_0_base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->plane_1_base, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->plane_1_base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->plane_2_base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->plane_2_base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->plane_0_stride, 0, 26); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->plane_1_2_stride, 0, 26); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_AFRC_YUV_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_AFRC_YUV_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff0000) fprintf(stderr, "XXX: Invalid field of AFRC YUV Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000f00) fprintf(stderr, "XXX: Invalid field of AFRC YUV Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xe008000f) fprintf(stderr, "XXX: Invalid field of AFRC YUV Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xf0000) fprintf(stderr, "XXX: Invalid field of AFRC YUV Render Target unpacked at word 3\n"); \
   if (__tmp_packed.opaque[10] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of AFRC YUV Render Target unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xf8000000) fprintf(stderr, "XXX: Invalid field of AFRC YUV Render Target unpacked at word 11\n"); \
   __gen_unpack_uint((__unpacked)->writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->internal_buffer_offset = (__unpacked)->internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->writeback_format, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->afrc_luma_block_size, &__tmp_packed.opaque[0], 68, 71); \
   __gen_unpack_uint((__unpacked)->afrc_luma_format, &__tmp_packed.opaque[0], 72, 79); \
   __gen_unpack_uint((__unpacked)->yuv_swizzle, &__tmp_packed.opaque[0], 80, 82); \
   __gen_unpack_uint((__unpacked)->full_range, &__tmp_packed.opaque[0], 84, 84); \
   __gen_unpack_uint((__unpacked)->conversion_mode, &__tmp_packed.opaque[0], 85, 88); \
   __gen_unpack_uint((__unpacked)->cr_siting, &__tmp_packed.opaque[0], 89, 91); \
   __gen_unpack_uint((__unpacked)->unsigned_cr_range, &__tmp_packed.opaque[0], 92, 92); \
   __gen_unpack_uint((__unpacked)->afrc_luma_codec_args, &__tmp_packed.opaque[0], 96, 103); \
   __gen_unpack_uint((__unpacked)->afrc_chroma_codec_args, &__tmp_packed.opaque[0], 104, 111); \
   __gen_unpack_uint((__unpacked)->afrc_chroma_block_size, &__tmp_packed.opaque[0], 116, 119); \
   __gen_unpack_uint((__unpacked)->afrc_chroma_format, &__tmp_packed.opaque[0], 120, 127); \
   __gen_unpack_uint((__unpacked)->plane_0_base, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->plane_1_base, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->plane_2_base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->plane_0_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->plane_1_2_stride, &__tmp_packed.opaque[0], 352, 378); \
   __gen_unpack_uint((__unpacked)->clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_AFRC_YUV_RENDER_TARGET_print(FILE *fp, const struct MALI_AFRC_YUV_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sWriteback Mode: %s\n", indent, "", mali_writeback_mode_as_str(values->writeback_mode));
   fprintf(fp, "%*sInternal Buffer Offset: %u\n", indent, "", values->internal_buffer_offset);
   fprintf(fp, "%*sYUV Enable: %s\n", indent, "", values->yuv_enable ? "true" : "false");
   fprintf(fp, "%*sDithered Clear: %s\n", indent, "", values->dithered_clear ? "true" : "false");
   fprintf(fp, "%*sInternal Format: %s\n", indent, "", mali_color_buffer_internal_format_as_str(values->internal_format));
   fprintf(fp, "%*sWriteback Format: %s\n", indent, "", mali_color_format_as_str(values->writeback_format));
   fprintf(fp, "%*sWriteback MSAA: %s\n", indent, "", mali_msaa_as_str(values->writeback_msaa));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sDithering Enable: %s\n", indent, "", values->dithering_enable ? "true" : "false");
   fprintf(fp, "%*sSwizzle: %u (%s)\n", indent, "", values->swizzle, mali_component_swizzle(values->swizzle));
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sAFRC Luma Block Size: %s\n", indent, "", mali_afrc_block_size_as_str(values->afrc_luma_block_size));
   fprintf(fp, "%*sAFRC Luma Format: %s\n", indent, "", mali_afrc_format_as_str(values->afrc_luma_format));
   fprintf(fp, "%*sYUV Swizzle: %s\n", indent, "", mali_yuv_swizzle_as_str(values->yuv_swizzle));
   fprintf(fp, "%*sFull Range: %s\n", indent, "", values->full_range ? "true" : "false");
   fprintf(fp, "%*sConversion Mode: %s\n", indent, "", mali_yuv_conversion_mode_as_str(values->conversion_mode));
   fprintf(fp, "%*sCr Siting: %s\n", indent, "", mali_yuv_cr_siting_as_str(values->cr_siting));
   fprintf(fp, "%*sUnsigned Cr Range: %s\n", indent, "", values->unsigned_cr_range ? "true" : "false");
   fprintf(fp, "%*sAFRC Luma codec args: %u\n", indent, "", values->afrc_luma_codec_args);
   fprintf(fp, "%*sAFRC Chroma codec args: %u\n", indent, "", values->afrc_chroma_codec_args);
   fprintf(fp, "%*sAFRC Chroma Block Size: %s\n", indent, "", mali_afrc_block_size_as_str(values->afrc_chroma_block_size));
   fprintf(fp, "%*sAFRC Chroma Format: %s\n", indent, "", mali_afrc_format_as_str(values->afrc_chroma_format));
   fprintf(fp, "%*sPlane 0 Base: 0x%" PRIx64 "\n", indent, "", values->plane_0_base);
   fprintf(fp, "%*sPlane 1 Base: 0x%" PRIx64 "\n", indent, "", values->plane_1_base);
   fprintf(fp, "%*sPlane 2 Base: 0x%" PRIx64 "\n", indent, "", values->plane_2_base);
   fprintf(fp, "%*sPlane 0 Stride: %u\n", indent, "", values->plane_0_stride);
   fprintf(fp, "%*sPlane 1 2 Stride: %u\n", indent, "", values->plane_1_2_stride);
   fprintf(fp, "%*sClear:\n", indent, "");
   MALI_RT_CLEAR_print(fp, &values->clear, indent + 2);
}

#endif
struct MALI_RENDER_TARGET {
   struct MALI_RGB_RENDER_TARGET        rgb;
   struct MALI_YUV_RENDER_TARGET        yuv;
   struct MALI_AFBC_RGB_RENDER_TARGET   afbc_rgb;
   struct MALI_AFBC_YUV_RENDER_TARGET   afbc_yuv;
   struct MALI_AFRC_RGB_RENDER_TARGET   afrc_rgb;
   struct MALI_AFRC_YUV_RENDER_TARGET   afrc_yuv;
};

#define MALI_RENDER_TARGET_header               \
   .rgb = { MALI_RGB_RENDER_TARGET_header },  \
   .yuv = { MALI_YUV_RENDER_TARGET_header },  \
   .afbc_rgb = { MALI_AFBC_RGB_RENDER_TARGET_header },  \
   .afbc_yuv = { MALI_AFBC_YUV_RENDER_TARGET_header },  \
   .afrc_rgb = { MALI_AFRC_RGB_RENDER_TARGET_header },  \
   .afrc_yuv = { MALI_AFRC_YUV_RENDER_TARGET_header }

#define MALI_RENDER_TARGET_LENGTH 64
#define MALI_RENDER_TARGET_ALIGN 64
struct mali_render_target_packed { uint32_t opaque[16]; };
#define MALI_RENDER_TARGET_PACKED_T struct mali_render_target_packed
#define MALI_RENDER_TARGET_pack(__packed, __unpacked) \
do { \
   MALI_RENDER_TARGET_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->rgb.writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->rgb.internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->rgb.yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->rgb.dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->rgb.internal_format, 26, 31) | \
            util_bitpack_uint((__unpacked)->yuv.writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->yuv.internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->yuv.yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->yuv.dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->yuv.internal_format, 26, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.internal_format, 26, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.internal_format, 26, 31) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.internal_format, 26, 31) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.writeback_mode, 0, 3) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.internal_buffer_offset >> 4, 4, 15) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.yuv_enable, 24, 24) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.dithered_clear, 25, 25) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.internal_format, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->rgb.write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->rgb.writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->rgb.writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->rgb.writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->rgb.srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->rgb.dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->rgb.swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->rgb.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->yuv.write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->yuv.writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->yuv.writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->yuv.writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->yuv.srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->yuv.dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->yuv.swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->yuv.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.write_enable, 0, 0) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.writeback_format, 3, 7) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.writeback_block_format, 8, 11) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.writeback_format, 0, 7) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.clean_pixel_write_enable, 31, 31) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.writeback_format, 0, 7) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.writeback_msaa, 12, 13) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.srgb, 14, 14) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.dithering_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.swizzle, 16, 27) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.clean_pixel_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->yuv.yuv_swizzle, 16, 18) | \
            util_bitpack_uint((__unpacked)->yuv.full_range, 20, 20) | \
            util_bitpack_uint((__unpacked)->yuv.conversion_mode, 21, 24) | \
            util_bitpack_uint((__unpacked)->yuv.cr_siting, 25, 27) | \
            util_bitpack_uint((__unpacked)->yuv.unsigned_cr_range, 28, 28) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.yuv_transform, 0, 0) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.split_block, 1, 1) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.wide_block, 2, 2) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.reverse_issue_order, 3, 3) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.front_buffer, 4, 4) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.alpha_hint, 5, 5) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.compression_mode, 10, 15) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.yuv_transform, 0, 0) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.split_block, 1, 1) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.wide_block, 2, 2) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.reverse_issue_order, 3, 3) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.front_buffer, 4, 4) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.alpha_hint, 5, 5) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.compression_mode, 10, 15) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.yuv_swizzle, 16, 18) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.full_range, 20, 20) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.conversion_mode, 21, 24) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.cr_siting, 25, 27) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.unsigned_cr_range, 28, 28) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.afrc_block_size, 4, 7) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.afrc_format, 8, 15) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.afrc_luma_block_size, 4, 7) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.afrc_luma_format, 8, 15) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.yuv_swizzle, 16, 18) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.full_range, 20, 20) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.conversion_mode, 21, 24) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.cr_siting, 25, 27) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.unsigned_cr_range, 28, 28); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->afrc_rgb.afrc_codec_args, 0, 7) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.afrc_luma_codec_args, 0, 7) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.afrc_chroma_codec_args, 8, 15) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.afrc_chroma_block_size, 20, 23) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.afrc_chroma_format, 24, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->yuv.plane_0_base, 0, 63) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.plane_0_base, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->yuv.plane_0_base, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->afrc_yuv.plane_0_base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->yuv.plane_1_base, 0, 63) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.plane_1_base, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->yuv.plane_1_base, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->afrc_yuv.plane_1_base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->rgb.writeback_buffer.base, 0, 63) | \
            util_bitpack_uint((__unpacked)->yuv.plane_2_base, 0, 63) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.header, 0, 63) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.header, 0, 63) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.writeback_buffer.base, 0, 63) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.plane_2_base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->rgb.writeback_buffer.base, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->yuv.plane_2_base, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->afbc_rgb.header, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->afbc_yuv.header, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->afrc_rgb.writeback_buffer.base, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->afrc_yuv.plane_2_base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->rgb.writeback_buffer.row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->rgb.writeback_buffer.surface_stride_hi, 27, 31) | \
            util_bitpack_uint((__unpacked)->yuv.plane_0_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.writeback_buffer.row_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.writeback_buffer.surface_stride_hi, 27, 31) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.plane_0_stride, 0, 26); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->rgb.writeback_buffer.surface_stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->yuv.plane_1_2_stride, 0, 26) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.body_offset, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.body_offset, 0, 31) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.writeback_buffer.surface_stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.plane_1_2_stride, 0, 26); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->rgb.clear.color_0, 0, 31) | \
            util_bitpack_uint((__unpacked)->yuv.clear.color_0, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.clear.color_0, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.clear.color_0, 0, 31) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.clear.color_0, 0, 31) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.clear.color_0, 0, 31); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->rgb.clear.color_1, 0, 31) | \
            util_bitpack_uint((__unpacked)->yuv.clear.color_1, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.clear.color_1, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.clear.color_1, 0, 31) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.clear.color_1, 0, 31) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.clear.color_1, 0, 31); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->rgb.clear.color_2, 0, 31) | \
            util_bitpack_uint((__unpacked)->yuv.clear.color_2, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.clear.color_2, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.clear.color_2, 0, 31) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.clear.color_2, 0, 31) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.clear.color_2, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->rgb.clear.color_3, 0, 31) | \
            util_bitpack_uint((__unpacked)->yuv.clear.color_3, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_rgb.clear.color_3, 0, 31) | \
            util_bitpack_uint((__unpacked)->afbc_yuv.clear.color_3, 0, 31) | \
            util_bitpack_uint((__unpacked)->afrc_rgb.clear.color_3, 0, 31) | \
            util_bitpack_uint((__unpacked)->afrc_yuv.clear.color_3, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RENDER_TARGET_unpack(__packed, __unpacked) \
do { \
   MALI_RENDER_TARGET_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff0000) fprintf(stderr, "XXX: Invalid field of Render Target unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0x70000000) fprintf(stderr, "XXX: Invalid field of Render Target unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xe0080000) fprintf(stderr, "XXX: Invalid field of Render Target unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xf0000) fprintf(stderr, "XXX: Invalid field of Render Target unpacked at word 3\n"); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->rgb.internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->rgb.internal_buffer_offset = (__unpacked)->rgb.internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->rgb.yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->rgb.dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->rgb.internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->rgb.write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->rgb.srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->rgb.dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->rgb.swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->rgb.clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_buffer.base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_buffer.row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_buffer.surface_stride_hi, &__tmp_packed.opaque[0], 347, 351); \
   __gen_unpack_uint((__unpacked)->rgb.writeback_buffer.surface_stride, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->rgb.clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->rgb.clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->rgb.clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->rgb.clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
   __gen_unpack_uint((__unpacked)->yuv.writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->yuv.internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->yuv.internal_buffer_offset = (__unpacked)->yuv.internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->yuv.yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->yuv.dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->yuv.internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->yuv.write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->yuv.writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->yuv.writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->yuv.writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->yuv.srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->yuv.dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->yuv.swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->yuv.clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->yuv.yuv_swizzle, &__tmp_packed.opaque[0], 80, 82); \
   __gen_unpack_uint((__unpacked)->yuv.full_range, &__tmp_packed.opaque[0], 84, 84); \
   __gen_unpack_uint((__unpacked)->yuv.conversion_mode, &__tmp_packed.opaque[0], 85, 88); \
   __gen_unpack_uint((__unpacked)->yuv.cr_siting, &__tmp_packed.opaque[0], 89, 91); \
   __gen_unpack_uint((__unpacked)->yuv.unsigned_cr_range, &__tmp_packed.opaque[0], 92, 92); \
   __gen_unpack_uint((__unpacked)->yuv.plane_0_base, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->yuv.plane_1_base, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->yuv.plane_2_base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->yuv.plane_0_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->yuv.plane_1_2_stride, &__tmp_packed.opaque[0], 352, 378); \
   __gen_unpack_uint((__unpacked)->yuv.clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->yuv.clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->yuv.clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->yuv.clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->afbc_rgb.internal_buffer_offset = (__unpacked)->afbc_rgb.internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->afbc_rgb.yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.yuv_transform, &__tmp_packed.opaque[0], 64, 64); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.split_block, &__tmp_packed.opaque[0], 65, 65); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.wide_block, &__tmp_packed.opaque[0], 66, 66); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.reverse_issue_order, &__tmp_packed.opaque[0], 67, 67); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.front_buffer, &__tmp_packed.opaque[0], 68, 68); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.alpha_hint, &__tmp_packed.opaque[0], 69, 69); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.compression_mode, &__tmp_packed.opaque[0], 74, 79); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.body_offset, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->afbc_rgb.clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->afbc_yuv.internal_buffer_offset = (__unpacked)->afbc_yuv.internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->afbc_yuv.yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.write_enable, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.writeback_format, &__tmp_packed.opaque[0], 35, 39); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.writeback_block_format, &__tmp_packed.opaque[0], 40, 43); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.yuv_transform, &__tmp_packed.opaque[0], 64, 64); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.split_block, &__tmp_packed.opaque[0], 65, 65); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.wide_block, &__tmp_packed.opaque[0], 66, 66); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.reverse_issue_order, &__tmp_packed.opaque[0], 67, 67); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.front_buffer, &__tmp_packed.opaque[0], 68, 68); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.alpha_hint, &__tmp_packed.opaque[0], 69, 69); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.compression_mode, &__tmp_packed.opaque[0], 74, 79); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.yuv_swizzle, &__tmp_packed.opaque[0], 80, 82); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.full_range, &__tmp_packed.opaque[0], 84, 84); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.conversion_mode, &__tmp_packed.opaque[0], 85, 88); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.cr_siting, &__tmp_packed.opaque[0], 89, 91); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.unsigned_cr_range, &__tmp_packed.opaque[0], 92, 92); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.header, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.body_offset, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->afbc_yuv.clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->afrc_rgb.internal_buffer_offset = (__unpacked)->afrc_rgb.internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->afrc_rgb.yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.writeback_format, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.afrc_block_size, &__tmp_packed.opaque[0], 68, 71); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.afrc_format, &__tmp_packed.opaque[0], 72, 79); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.afrc_codec_args, &__tmp_packed.opaque[0], 96, 103); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.writeback_buffer.base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.writeback_buffer.row_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.writeback_buffer.surface_stride_hi, &__tmp_packed.opaque[0], 347, 351); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.writeback_buffer.surface_stride, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->afrc_rgb.clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.writeback_mode, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.internal_buffer_offset, &__tmp_packed.opaque[0], 4, 15); \
   (__unpacked)->afrc_yuv.internal_buffer_offset = (__unpacked)->afrc_yuv.internal_buffer_offset << 4; \
   __gen_unpack_uint((__unpacked)->afrc_yuv.yuv_enable, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.dithered_clear, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.internal_format, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.writeback_format, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.writeback_msaa, &__tmp_packed.opaque[0], 44, 45); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.srgb, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.dithering_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.swizzle, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.clean_pixel_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.afrc_luma_block_size, &__tmp_packed.opaque[0], 68, 71); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.afrc_luma_format, &__tmp_packed.opaque[0], 72, 79); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.yuv_swizzle, &__tmp_packed.opaque[0], 80, 82); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.full_range, &__tmp_packed.opaque[0], 84, 84); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.conversion_mode, &__tmp_packed.opaque[0], 85, 88); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.cr_siting, &__tmp_packed.opaque[0], 89, 91); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.unsigned_cr_range, &__tmp_packed.opaque[0], 92, 92); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.afrc_luma_codec_args, &__tmp_packed.opaque[0], 96, 103); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.afrc_chroma_codec_args, &__tmp_packed.opaque[0], 104, 111); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.afrc_chroma_block_size, &__tmp_packed.opaque[0], 116, 119); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.afrc_chroma_format, &__tmp_packed.opaque[0], 120, 127); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.plane_0_base, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.plane_1_base, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.plane_2_base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.plane_0_stride, &__tmp_packed.opaque[0], 320, 346); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.plane_1_2_stride, &__tmp_packed.opaque[0], 352, 378); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.clear.color_0, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.clear.color_1, &__tmp_packed.opaque[0], 416, 447); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.clear.color_2, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->afrc_yuv.clear.color_3, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RENDER_TARGET_print(FILE *fp, const struct MALI_RENDER_TARGET * values, unsigned indent)
{
   fprintf(fp, "%*sRGB:\n", indent, "");
   MALI_RGB_RENDER_TARGET_print(fp, &values->rgb, indent + 2);
   fprintf(fp, "%*sYUV:\n", indent, "");
   MALI_YUV_RENDER_TARGET_print(fp, &values->yuv, indent + 2);
   fprintf(fp, "%*sAFBC RGB:\n", indent, "");
   MALI_AFBC_RGB_RENDER_TARGET_print(fp, &values->afbc_rgb, indent + 2);
   fprintf(fp, "%*sAFBC YUV:\n", indent, "");
   MALI_AFBC_YUV_RENDER_TARGET_print(fp, &values->afbc_yuv, indent + 2);
   fprintf(fp, "%*sAFRC RGB:\n", indent, "");
   MALI_AFRC_RGB_RENDER_TARGET_print(fp, &values->afrc_rgb, indent + 2);
   fprintf(fp, "%*sAFRC YUV:\n", indent, "");
   MALI_AFRC_YUV_RENDER_TARGET_print(fp, &values->afrc_yuv, indent + 2);
}

#endif
enum mali_chunk_size {
        MALI_CHUNK_SIZE_256_KIB              =      0,
        MALI_CHUNK_SIZE_512_KIB              =      1,
        MALI_CHUNK_SIZE_1_MIB                =      2,
        MALI_CHUNK_SIZE_2_MIB                =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_chunk_size_as_str(enum mali_chunk_size imm)
{
    switch (imm) {
    case MALI_CHUNK_SIZE_256_KIB: return "256 KiB";
    case MALI_CHUNK_SIZE_512_KIB: return "512 KiB";
    case MALI_CHUNK_SIZE_1_MIB: return "1 MiB";
    case MALI_CHUNK_SIZE_2_MIB: return "2 MiB";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_chunk_partition {
        MALI_CHUNK_PARTITION_DYNAMIC         =      0,
        MALI_CHUNK_PARTITION_STATIC_25       =      1,
        MALI_CHUNK_PARTITION_STATIC_50       =      2,
        MALI_CHUNK_PARTITION_STATIC_75       =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_chunk_partition_as_str(enum mali_chunk_partition imm)
{
    switch (imm) {
    case MALI_CHUNK_PARTITION_DYNAMIC: return "Dynamic";
    case MALI_CHUNK_PARTITION_STATIC_25: return "Static 25%";
    case MALI_CHUNK_PARTITION_STATIC_50: return "Static 50%";
    case MALI_CHUNK_PARTITION_STATIC_75: return "Static 75%";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_TILER_HEAP {
   enum mali_descriptor_type            type;
   enum mali_buffer_type                buffer_type;
   enum mali_chunk_size                 chunk_size;
   enum mali_chunk_partition            partitioning;
   uint64_t                             size;
   uint64_t                             base;
   uint64_t                             bottom;
   uint64_t                             top;
};

#define MALI_TILER_HEAP_header                  \
   .type = MALI_DESCRIPTOR_TYPE_BUFFER,  \
   .buffer_type = MALI_BUFFER_TYPE_TILER_HEAP,  \
   .chunk_size = MALI_CHUNK_SIZE_256_KIB,  \
   .partitioning = MALI_CHUNK_PARTITION_DYNAMIC

#define MALI_TILER_HEAP_LENGTH 32
#define MALI_TILER_HEAP_ALIGN 32
struct mali_tiler_heap_packed { uint32_t opaque[8]; };
#define MALI_TILER_HEAP_PACKED_T struct mali_tiler_heap_packed
#define MALI_TILER_HEAP_pack(__packed, __unpacked) \
do { \
   MALI_TILER_HEAP_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->buffer_type, 4, 7) | \
            util_bitpack_uint((__unpacked)->chunk_size, 8, 9) | \
            util_bitpack_uint((__unpacked)->partitioning, 10, 11); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint(ALIGN_POT((__unpacked)->size, 4096), 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->base, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->bottom, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->bottom, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->top, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->top, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TILER_HEAP_unpack(__packed, __unpacked) \
do { \
   MALI_TILER_HEAP_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfffff000) fprintf(stderr, "XXX: Invalid field of Tiler Heap unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->buffer_type, &__tmp_packed.opaque[0], 4, 7); \
   __gen_unpack_uint((__unpacked)->chunk_size, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->partitioning, &__tmp_packed.opaque[0], 10, 11); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 32, 63); \
   assert(!((__unpacked)->size & 0xfff)); \
   __gen_unpack_uint((__unpacked)->base, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->bottom, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->top, &__tmp_packed.opaque[0], 192, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TILER_HEAP_print(FILE *fp, const struct MALI_TILER_HEAP * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sBuffer type: %s\n", indent, "", mali_buffer_type_as_str(values->buffer_type));
   fprintf(fp, "%*sChunk size: %s\n", indent, "", mali_chunk_size_as_str(values->chunk_size));
   fprintf(fp, "%*sPartitioning: %s\n", indent, "", mali_chunk_partition_as_str(values->partitioning));
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sBase: 0x%" PRIx64 "\n", indent, "", values->base);
   fprintf(fp, "%*sBottom: 0x%" PRIx64 "\n", indent, "", values->bottom);
   fprintf(fp, "%*sTop: 0x%" PRIx64 "\n", indent, "", values->top);
}

#endif
struct MALI_TILER_WEIGHTS {
   uint32_t                             weight0;
   uint32_t                             weight1;
   uint32_t                             weight2;
   uint32_t                             weight3;
   uint32_t                             weight4;
   uint32_t                             weight5;
   uint32_t                             weight6;
   uint32_t                             weight7;
};

#define MALI_TILER_WEIGHTS_header               \
   0

#define MALI_TILER_WEIGHTS_LENGTH 32
struct mali_tiler_weights_packed { uint32_t opaque[8]; };
#define MALI_TILER_WEIGHTS_PACKED_T struct mali_tiler_weights_packed
#define MALI_TILER_WEIGHTS_pack(__packed, __unpacked) \
do { \
   MALI_TILER_WEIGHTS_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->weight0, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->weight1, 16, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->weight2, 16, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->weight3, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->weight4, 16, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->weight5, 16, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->weight6, 16, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->weight7, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TILER_WEIGHTS_unpack(__packed, __unpacked) \
do { \
   MALI_TILER_WEIGHTS_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffff) fprintf(stderr, "XXX: Invalid field of Tiler Weights unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->weight0, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_uint((__unpacked)->weight1, &__tmp_packed.opaque[0], 48, 63); \
   __gen_unpack_uint((__unpacked)->weight2, &__tmp_packed.opaque[0], 80, 95); \
   __gen_unpack_uint((__unpacked)->weight3, &__tmp_packed.opaque[0], 112, 127); \
   __gen_unpack_uint((__unpacked)->weight4, &__tmp_packed.opaque[0], 144, 159); \
   __gen_unpack_uint((__unpacked)->weight5, &__tmp_packed.opaque[0], 176, 191); \
   __gen_unpack_uint((__unpacked)->weight6, &__tmp_packed.opaque[0], 208, 223); \
   __gen_unpack_uint((__unpacked)->weight7, &__tmp_packed.opaque[0], 240, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TILER_WEIGHTS_print(FILE *fp, const struct MALI_TILER_WEIGHTS * values, unsigned indent)
{
   fprintf(fp, "%*sWeight0: %u\n", indent, "", values->weight0);
   fprintf(fp, "%*sWeight1: %u\n", indent, "", values->weight1);
   fprintf(fp, "%*sWeight2: %u\n", indent, "", values->weight2);
   fprintf(fp, "%*sWeight3: %u\n", indent, "", values->weight3);
   fprintf(fp, "%*sWeight4: %u\n", indent, "", values->weight4);
   fprintf(fp, "%*sWeight5: %u\n", indent, "", values->weight5);
   fprintf(fp, "%*sWeight6: %u\n", indent, "", values->weight6);
   fprintf(fp, "%*sWeight7: %u\n", indent, "", values->weight7);
}

#endif
struct MALI_TILER_STATE {
   uint64_t                             word0;
   uint64_t                             word1;
   uint64_t                             word2;
   uint64_t                             word3;
   uint64_t                             word4;
   uint64_t                             word5;
   uint64_t                             word6;
   uint64_t                             word7;
};

#define MALI_TILER_STATE_header                 \
   0

#define MALI_TILER_STATE_LENGTH 64
struct mali_tiler_state_packed { uint32_t opaque[16]; };
#define MALI_TILER_STATE_PACKED_T struct mali_tiler_state_packed
#define MALI_TILER_STATE_pack(__packed, __unpacked) \
do { \
   MALI_TILER_STATE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->word0, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->word1, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->word2, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->word3, 0, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->word4, 0, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->word5, 0, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->word6, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->word7, 0, 31); \
   __tmp_packed.opaque[ 8] = 0; \
   __tmp_packed.opaque[ 9] = 0; \
   __tmp_packed.opaque[10] = 0; \
   __tmp_packed.opaque[11] = 0; \
   __tmp_packed.opaque[12] = 0; \
   __tmp_packed.opaque[13] = 0; \
   __tmp_packed.opaque[14] = 0; \
   __tmp_packed.opaque[15] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TILER_STATE_unpack(__packed, __unpacked) \
do { \
   MALI_TILER_STATE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[8] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler State unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler State unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler State unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler State unpacked at word 11\n"); \
   if (__tmp_packed.opaque[12] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler State unpacked at word 12\n"); \
   if (__tmp_packed.opaque[13] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler State unpacked at word 13\n"); \
   if (__tmp_packed.opaque[14] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler State unpacked at word 14\n"); \
   if (__tmp_packed.opaque[15] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler State unpacked at word 15\n"); \
   __gen_unpack_uint((__unpacked)->word0, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->word1, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->word2, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->word3, &__tmp_packed.opaque[0], 96, 127); \
   __gen_unpack_uint((__unpacked)->word4, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->word5, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_uint((__unpacked)->word6, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->word7, &__tmp_packed.opaque[0], 224, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TILER_STATE_print(FILE *fp, const struct MALI_TILER_STATE * values, unsigned indent)
{
   fprintf(fp, "%*sWord0: 0x%" PRIx64 "\n", indent, "", values->word0);
   fprintf(fp, "%*sWord1: 0x%" PRIx64 "\n", indent, "", values->word1);
   fprintf(fp, "%*sWord2: 0x%" PRIx64 "\n", indent, "", values->word2);
   fprintf(fp, "%*sWord3: 0x%" PRIx64 "\n", indent, "", values->word3);
   fprintf(fp, "%*sWord4: 0x%" PRIx64 "\n", indent, "", values->word4);
   fprintf(fp, "%*sWord5: 0x%" PRIx64 "\n", indent, "", values->word5);
   fprintf(fp, "%*sWord6: 0x%" PRIx64 "\n", indent, "", values->word6);
   fprintf(fp, "%*sWord7: 0x%" PRIx64 "\n", indent, "", values->word7);
}

#endif
struct MALI_TILER_CONTEXT {
   uint64_t                             polygon_list;
   uint32_t                             hierarchy_mask;
   enum mali_sample_pattern             sample_pattern;
   bool                                 sample_test_disable;
   bool                                 first_provoking_vertex;
   uint32_t                             effective_tile_size;
   uint32_t                             fb_width;
   uint32_t                             fb_height;
   uint32_t                             layer_count;
   int32_t                              layer_offset;
   uint64_t                             heap;
   uint32_t                             geometry_buffer_size;
   uint64_t                             geometry_buffer;
   uint64_t                             completed_top;
   uint64_t                             completed_bottom;
   struct MALI_TILER_STATE              private_state;
};

#define MALI_TILER_CONTEXT_header               \
   .layer_count = 1,  \
   .geometry_buffer_size = 65536,  \
   .private_state = { MALI_TILER_STATE_header }

#define MALI_TILER_CONTEXT_LENGTH 128
#define MALI_TILER_CONTEXT_ALIGN 64
struct mali_tiler_context_packed { uint32_t opaque[32]; };
#define MALI_TILER_CONTEXT_PACKED_T struct mali_tiler_context_packed
#define MALI_TILER_CONTEXT_pack(__packed, __unpacked) \
do { \
   MALI_TILER_CONTEXT_PACKED_T __tmp_packed; \
   assert(IS_POT_NONZERO((__unpacked)->effective_tile_size)); \
   assert((__unpacked)->fb_width >= 1); \
   assert((__unpacked)->fb_height >= 1); \
   assert((__unpacked)->layer_count >= 1); \
   assert(((__unpacked)->geometry_buffer_size & 0xfff) == 0); \
   assert(((__unpacked)->geometry_buffer & 0xfff) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->polygon_list, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->polygon_list, 0, 63) >> 32; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->hierarchy_mask, 0, 12) | \
            util_bitpack_uint((__unpacked)->sample_pattern, 13, 15) | \
            util_bitpack_uint((__unpacked)->sample_test_disable, 17, 17) | \
            util_bitpack_uint((__unpacked)->first_provoking_vertex, 18, 18) | \
            util_bitpack_uint(util_logbase2((__unpacked)->effective_tile_size), 20, 23); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->fb_width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->fb_height - 1, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->layer_count - 1, 0, 7) | \
            util_bitpack_sint((__unpacked)->layer_offset, 8, 16); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->heap, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->heap, 0, 63) >> 32; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->geometry_buffer_size >> 12, 0, 11) | \
            util_bitpack_uint((__unpacked)->geometry_buffer >> 12, 12, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->geometry_buffer >> 12, 12, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->completed_top, 0, 63); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->completed_top, 0, 63) >> 32; \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->completed_bottom, 0, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->completed_bottom, 0, 63) >> 32; \
   __tmp_packed.opaque[14] = 0; \
   __tmp_packed.opaque[15] = 0; \
   __tmp_packed.opaque[16] = 0; \
   __tmp_packed.opaque[17] = 0; \
   __tmp_packed.opaque[18] = 0; \
   __tmp_packed.opaque[19] = 0; \
   __tmp_packed.opaque[20] = 0; \
   __tmp_packed.opaque[21] = 0; \
   __tmp_packed.opaque[22] = 0; \
   __tmp_packed.opaque[23] = 0; \
   __tmp_packed.opaque[24] = util_bitpack_uint((__unpacked)->private_state.word0, 0, 31); \
   __tmp_packed.opaque[25] = util_bitpack_uint((__unpacked)->private_state.word1, 0, 31); \
   __tmp_packed.opaque[26] = util_bitpack_uint((__unpacked)->private_state.word2, 0, 31); \
   __tmp_packed.opaque[27] = util_bitpack_uint((__unpacked)->private_state.word3, 0, 31); \
   __tmp_packed.opaque[28] = util_bitpack_uint((__unpacked)->private_state.word4, 0, 31); \
   __tmp_packed.opaque[29] = util_bitpack_uint((__unpacked)->private_state.word5, 0, 31); \
   __tmp_packed.opaque[30] = util_bitpack_uint((__unpacked)->private_state.word6, 0, 31); \
   __tmp_packed.opaque[31] = util_bitpack_uint((__unpacked)->private_state.word7, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TILER_CONTEXT_unpack(__packed, __unpacked) \
do { \
   MALI_TILER_CONTEXT_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[2] & 0xff090000) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 2\n"); \
   if (__tmp_packed.opaque[4] & 0xfffe0000) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 5\n"); \
   if (__tmp_packed.opaque[14] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 14\n"); \
   if (__tmp_packed.opaque[15] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 15\n"); \
   if (__tmp_packed.opaque[16] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 16\n"); \
   if (__tmp_packed.opaque[17] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 17\n"); \
   if (__tmp_packed.opaque[18] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 18\n"); \
   if (__tmp_packed.opaque[19] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 19\n"); \
   if (__tmp_packed.opaque[20] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 20\n"); \
   if (__tmp_packed.opaque[21] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 21\n"); \
   if (__tmp_packed.opaque[22] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 22\n"); \
   if (__tmp_packed.opaque[23] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 23\n"); \
   __gen_unpack_uint((__unpacked)->polygon_list, &__tmp_packed.opaque[0], 0, 63); \
   __gen_unpack_uint((__unpacked)->hierarchy_mask, &__tmp_packed.opaque[0], 64, 76); \
   __gen_unpack_uint((__unpacked)->sample_pattern, &__tmp_packed.opaque[0], 77, 79); \
   __gen_unpack_uint((__unpacked)->sample_test_disable, &__tmp_packed.opaque[0], 81, 81); \
   __gen_unpack_uint((__unpacked)->first_provoking_vertex, &__tmp_packed.opaque[0], 82, 82); \
   __gen_unpack_uint((__unpacked)->effective_tile_size, &__tmp_packed.opaque[0], 84, 87); \
   (__unpacked)->effective_tile_size = 1U << (__unpacked)->effective_tile_size; \
   __gen_unpack_uint((__unpacked)->fb_width, &__tmp_packed.opaque[0], 96, 111); \
   (__unpacked)->fb_width = (__unpacked)->fb_width + 1; \
   __gen_unpack_uint((__unpacked)->fb_height, &__tmp_packed.opaque[0], 112, 127); \
   (__unpacked)->fb_height = (__unpacked)->fb_height + 1; \
   __gen_unpack_uint((__unpacked)->layer_count, &__tmp_packed.opaque[0], 128, 135); \
   (__unpacked)->layer_count = (__unpacked)->layer_count + 1; \
   __gen_unpack_sint((__unpacked)->layer_offset, &__tmp_packed.opaque[0], 136, 144); \
   __gen_unpack_uint((__unpacked)->heap, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->geometry_buffer_size, &__tmp_packed.opaque[0], 256, 267); \
   (__unpacked)->geometry_buffer_size = (__unpacked)->geometry_buffer_size << 12; \
   __gen_unpack_uint((__unpacked)->geometry_buffer, &__tmp_packed.opaque[0], 268, 319); \
   (__unpacked)->geometry_buffer = (__unpacked)->geometry_buffer << 12; \
   __gen_unpack_uint((__unpacked)->completed_top, &__tmp_packed.opaque[0], 320, 383); \
   __gen_unpack_uint((__unpacked)->completed_bottom, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->private_state.word0, &__tmp_packed.opaque[0], 768, 799); \
   __gen_unpack_uint((__unpacked)->private_state.word1, &__tmp_packed.opaque[0], 800, 831); \
   __gen_unpack_uint((__unpacked)->private_state.word2, &__tmp_packed.opaque[0], 832, 863); \
   __gen_unpack_uint((__unpacked)->private_state.word3, &__tmp_packed.opaque[0], 864, 895); \
   __gen_unpack_uint((__unpacked)->private_state.word4, &__tmp_packed.opaque[0], 896, 927); \
   __gen_unpack_uint((__unpacked)->private_state.word5, &__tmp_packed.opaque[0], 928, 959); \
   __gen_unpack_uint((__unpacked)->private_state.word6, &__tmp_packed.opaque[0], 960, 991); \
   __gen_unpack_uint((__unpacked)->private_state.word7, &__tmp_packed.opaque[0], 992, 1023); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TILER_CONTEXT_print(FILE *fp, const struct MALI_TILER_CONTEXT * values, unsigned indent)
{
   fprintf(fp, "%*sPolygon List: 0x%" PRIx64 "\n", indent, "", values->polygon_list);
   fprintf(fp, "%*sHierarchy Mask: %u\n", indent, "", values->hierarchy_mask);
   fprintf(fp, "%*sSample Pattern: %s\n", indent, "", mali_sample_pattern_as_str(values->sample_pattern));
   fprintf(fp, "%*sSample test disable: %s\n", indent, "", values->sample_test_disable ? "true" : "false");
   fprintf(fp, "%*sFirst provoking vertex: %s\n", indent, "", values->first_provoking_vertex ? "true" : "false");
   fprintf(fp, "%*sEffective Tile Size: %u\n", indent, "", values->effective_tile_size);
   fprintf(fp, "%*sFB Width: %u\n", indent, "", values->fb_width);
   fprintf(fp, "%*sFB Height: %u\n", indent, "", values->fb_height);
   fprintf(fp, "%*sLayer count: %u\n", indent, "", values->layer_count);
   fprintf(fp, "%*sLayer offset: %" PRId64 "\n", indent, "", (int64_t)values->layer_offset);
   fprintf(fp, "%*sHeap: 0x%" PRIx64 "\n", indent, "", values->heap);
   fprintf(fp, "%*sGeometry buffer size: %u\n", indent, "", values->geometry_buffer_size);
   fprintf(fp, "%*sGeometry buffer: 0x%" PRIx64 "\n", indent, "", values->geometry_buffer);
   fprintf(fp, "%*sCompleted top: 0x%" PRIx64 "\n", indent, "", values->completed_top);
   fprintf(fp, "%*sCompleted bottom: 0x%" PRIx64 "\n", indent, "", values->completed_bottom);
   fprintf(fp, "%*sPrivate state:\n", indent, "");
   MALI_TILER_STATE_print(fp, &values->private_state, indent + 2);
}

#endif
struct MALI_FRAMEBUFFER_PADDING {
   int dummy;
};

#define MALI_FRAMEBUFFER_PADDING_header         \
   0

#define MALI_FRAMEBUFFER_PADDING_LENGTH 56
struct mali_framebuffer_padding_packed { uint32_t opaque[14]; };
#define MALI_FRAMEBUFFER_PADDING_PACKED_T struct mali_framebuffer_padding_packed
#define MALI_FRAMEBUFFER_PADDING_pack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PADDING_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = 0; \
   __tmp_packed.opaque[ 9] = 0; \
   __tmp_packed.opaque[10] = 0; \
   __tmp_packed.opaque[11] = 0; \
   __tmp_packed.opaque[12] = 0; \
   __tmp_packed.opaque[13] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FRAMEBUFFER_PADDING_unpack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PADDING_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 7\n"); \
   if (__tmp_packed.opaque[8] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 11\n"); \
   if (__tmp_packed.opaque[12] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 12\n"); \
   if (__tmp_packed.opaque[13] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding unpacked at word 13\n"); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FRAMEBUFFER_PADDING_print(FILE *fp, const struct MALI_FRAMEBUFFER_PADDING * values, unsigned indent)
{
}

#endif
struct mali_framebuffer_packed {
   uint32_t opaque[32];
};

#define MALI_FRAMEBUFFER_PACKED_T struct mali_framebuffer_packed
#define MALI_FRAMEBUFFER_LENGTH 128
#define MALI_FRAMEBUFFER_ALIGN 64
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_TYPE struct MALI_FRAMEBUFFER_PARAMETERS
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_PACKED_TYPE MALI_FRAMEBUFFER_PARAMETERS_PACKED_T
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_header MALI_FRAMEBUFFER_PARAMETERS_header
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_pack MALI_FRAMEBUFFER_PARAMETERS_pack
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_unpack MALI_FRAMEBUFFER_PARAMETERS_unpack
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_print MALI_FRAMEBUFFER_PARAMETERS_print
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_OFFSET 0
#define MALI_FRAMEBUFFER_SECTION_PADDING_TYPE struct MALI_FRAMEBUFFER_PADDING
#define MALI_FRAMEBUFFER_SECTION_PADDING_PACKED_TYPE MALI_FRAMEBUFFER_PADDING_PACKED_T
#define MALI_FRAMEBUFFER_SECTION_PADDING_header MALI_FRAMEBUFFER_PADDING_header
#define MALI_FRAMEBUFFER_SECTION_PADDING_pack MALI_FRAMEBUFFER_PADDING_pack
#define MALI_FRAMEBUFFER_SECTION_PADDING_unpack MALI_FRAMEBUFFER_PADDING_unpack
#define MALI_FRAMEBUFFER_SECTION_PADDING_print MALI_FRAMEBUFFER_PADDING_print
#define MALI_FRAMEBUFFER_SECTION_PADDING_OFFSET 72

struct MALI_FRAMEBUFFER_POINTER {
   bool                                 type;
   bool                                 zs_crc_extension_present;
   uint32_t                             render_target_count;
   uint64_t                             pointer;
};

#define MALI_FRAMEBUFFER_POINTER_header         \
   .type = true

#define MALI_FRAMEBUFFER_POINTER_LENGTH 8
struct mali_framebuffer_pointer_packed { uint32_t opaque[2]; };
#define MALI_FRAMEBUFFER_POINTER_PACKED_T struct mali_framebuffer_pointer_packed
#define MALI_FRAMEBUFFER_POINTER_pack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_POINTER_PACKED_T __tmp_packed; \
   assert((__unpacked)->render_target_count >= 1); \
   assert(((__unpacked)->pointer & 0x3f) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 0) | \
            util_bitpack_uint((__unpacked)->zs_crc_extension_present, 1, 1) | \
            util_bitpack_uint((__unpacked)->render_target_count - 1, 2, 5) | \
            util_bitpack_uint((__unpacked)->pointer >> 6, 6, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->pointer >> 6, 6, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FRAMEBUFFER_POINTER_unpack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_POINTER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->zs_crc_extension_present, &__tmp_packed.opaque[0], 1, 1); \
   __gen_unpack_uint((__unpacked)->render_target_count, &__tmp_packed.opaque[0], 2, 5); \
   (__unpacked)->render_target_count = (__unpacked)->render_target_count + 1; \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 6, 63); \
   (__unpacked)->pointer = (__unpacked)->pointer << 6; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FRAMEBUFFER_POINTER_print(FILE *fp, const struct MALI_FRAMEBUFFER_POINTER * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", values->type ? "true" : "false");
   fprintf(fp, "%*sZS CRC Extension present: %s\n", indent, "", values->zs_crc_extension_present ? "true" : "false");
   fprintf(fp, "%*sRender target count: %u\n", indent, "", values->render_target_count);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
}

#endif
struct MALI_COMPUTE_SIZE_WORKGROUP {
   uint32_t                             workgroup_size_x;
   uint32_t                             workgroup_size_y;
   uint32_t                             workgroup_size_z;
   bool                                 allow_merging_workgroups;
};

#define MALI_COMPUTE_SIZE_WORKGROUP_header      \
   0

#define MALI_COMPUTE_SIZE_WORKGROUP_LENGTH 4
struct mali_compute_size_workgroup_packed { uint32_t opaque[1]; };
#define MALI_COMPUTE_SIZE_WORKGROUP_PACKED_T struct mali_compute_size_workgroup_packed
#define MALI_COMPUTE_SIZE_WORKGROUP_pack(__packed, __unpacked) \
do { \
   MALI_COMPUTE_SIZE_WORKGROUP_PACKED_T __tmp_packed; \
   assert((__unpacked)->workgroup_size_x >= 1); \
   assert((__unpacked)->workgroup_size_y >= 1); \
   assert((__unpacked)->workgroup_size_z >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->workgroup_size_x - 1, 0, 9) | \
            util_bitpack_uint((__unpacked)->workgroup_size_y - 1, 10, 19) | \
            util_bitpack_uint((__unpacked)->workgroup_size_z - 1, 20, 29) | \
            util_bitpack_uint((__unpacked)->allow_merging_workgroups, 31, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_COMPUTE_SIZE_WORKGROUP_unpack(__packed, __unpacked) \
do { \
   MALI_COMPUTE_SIZE_WORKGROUP_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x40000000) fprintf(stderr, "XXX: Invalid field of Compute size workgroup unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->workgroup_size_x, &__tmp_packed.opaque[0], 0, 9); \
   (__unpacked)->workgroup_size_x = (__unpacked)->workgroup_size_x + 1; \
   __gen_unpack_uint((__unpacked)->workgroup_size_y, &__tmp_packed.opaque[0], 10, 19); \
   (__unpacked)->workgroup_size_y = (__unpacked)->workgroup_size_y + 1; \
   __gen_unpack_uint((__unpacked)->workgroup_size_z, &__tmp_packed.opaque[0], 20, 29); \
   (__unpacked)->workgroup_size_z = (__unpacked)->workgroup_size_z + 1; \
   __gen_unpack_uint((__unpacked)->allow_merging_workgroups, &__tmp_packed.opaque[0], 31, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_COMPUTE_SIZE_WORKGROUP_print(FILE *fp, const struct MALI_COMPUTE_SIZE_WORKGROUP * values, unsigned indent)
{
   fprintf(fp, "%*sWorkgroup size X: %u\n", indent, "", values->workgroup_size_x);
   fprintf(fp, "%*sWorkgroup size Y: %u\n", indent, "", values->workgroup_size_y);
   fprintf(fp, "%*sWorkgroup size Z: %u\n", indent, "", values->workgroup_size_z);
   fprintf(fp, "%*sAllow merging workgroups: %s\n", indent, "", values->allow_merging_workgroups ? "true" : "false");
}

#endif
struct MALI_RESOURCE {
   uint64_t                             address;
   bool                                 contains_descriptors;
   uint64_t                             size;
};

#define MALI_RESOURCE_header                    \
   .contains_descriptors = true

#define MALI_RESOURCE_LENGTH 16
#define MALI_RESOURCE_ALIGN 64
struct mali_resource_packed { uint32_t opaque[4]; };
#define MALI_RESOURCE_PACKED_T struct mali_resource_packed
#define MALI_RESOURCE_pack(__packed, __unpacked) \
do { \
   MALI_RESOURCE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->address, 0, 55); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->address, 0, 55) >> 32 | \
            util_bitpack_uint((__unpacked)->contains_descriptors, 24, 24); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->size, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->size, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RESOURCE_unpack(__packed, __unpacked) \
do { \
   MALI_RESOURCE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xfe000000) fprintf(stderr, "XXX: Invalid field of Resource unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 0, 55); \
   __gen_unpack_uint((__unpacked)->contains_descriptors, &__tmp_packed.opaque[0], 56, 56); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 64, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RESOURCE_print(FILE *fp, const struct MALI_RESOURCE * values, unsigned indent)
{
   fprintf(fp, "%*sAddress: 0x%" PRIx64 "\n", indent, "", values->address);
   fprintf(fp, "%*sContains descriptors: %s\n", indent, "", values->contains_descriptors ? "true" : "false");
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
}

#endif
struct MALI_DEPTH_STENCIL {
   enum mali_descriptor_type            type;
   enum mali_func                       front_compare_function;
   enum mali_stencil_op                 front_stencil_fail;
   enum mali_stencil_op                 front_depth_fail;
   enum mali_stencil_op                 front_depth_pass;
   enum mali_func                       back_compare_function;
   enum mali_stencil_op                 back_stencil_fail;
   enum mali_stencil_op                 back_depth_fail;
   enum mali_stencil_op                 back_depth_pass;
   bool                                 stencil_from_shader;
   bool                                 stencil_test_enable;
   uint32_t                             front_write_mask;
   uint32_t                             back_write_mask;
   uint32_t                             front_value_mask;
   uint32_t                             back_value_mask;
   uint32_t                             front_reference_value;
   uint32_t                             back_reference_value;
   bool                                 depth_cull_enable;
   enum mali_depth_clamp_mode           depth_clamp_mode;
   enum mali_depth_source               depth_source;
   bool                                 depth_write_enable;
   bool                                 depth_bias_enable;
   enum mali_func                       depth_function;
   float                                depth_units;
   float                                depth_factor;
   float                                depth_bias_clamp;
};

#define MALI_DEPTH_STENCIL_header               \
   .type = MALI_DESCRIPTOR_TYPE_DEPTH_STENCIL,  \
   .depth_cull_enable = true,  \
   .depth_clamp_mode = MALI_DEPTH_CLAMP_MODE_0_1,  \
   .depth_source = MALI_DEPTH_SOURCE_FIXED_FUNCTION

#define MALI_DEPTH_STENCIL_LENGTH 32
#define MALI_DEPTH_STENCIL_ALIGN 32
struct mali_depth_stencil_packed { uint32_t opaque[8]; };
#define MALI_DEPTH_STENCIL_PACKED_T struct mali_depth_stencil_packed
#define MALI_DEPTH_STENCIL_pack(__packed, __unpacked) \
do { \
   MALI_DEPTH_STENCIL_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 3) | \
            util_bitpack_uint((__unpacked)->front_compare_function, 4, 6) | \
            util_bitpack_uint((__unpacked)->front_stencil_fail, 7, 9) | \
            util_bitpack_uint((__unpacked)->front_depth_fail, 10, 12) | \
            util_bitpack_uint((__unpacked)->front_depth_pass, 13, 15) | \
            util_bitpack_uint((__unpacked)->back_compare_function, 16, 18) | \
            util_bitpack_uint((__unpacked)->back_stencil_fail, 19, 21) | \
            util_bitpack_uint((__unpacked)->back_depth_fail, 22, 24) | \
            util_bitpack_uint((__unpacked)->back_depth_pass, 25, 27) | \
            util_bitpack_uint((__unpacked)->stencil_from_shader, 30, 30) | \
            util_bitpack_uint((__unpacked)->stencil_test_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->front_write_mask, 0, 7) | \
            util_bitpack_uint((__unpacked)->back_write_mask, 8, 15) | \
            util_bitpack_uint((__unpacked)->front_value_mask, 16, 23) | \
            util_bitpack_uint((__unpacked)->back_value_mask, 24, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->front_reference_value, 0, 7) | \
            util_bitpack_uint((__unpacked)->back_reference_value, 8, 15); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->depth_cull_enable, 22, 22) | \
            util_bitpack_uint((__unpacked)->depth_clamp_mode, 23, 24) | \
            util_bitpack_uint((__unpacked)->depth_source, 25, 26) | \
            util_bitpack_uint((__unpacked)->depth_write_enable, 27, 27) | \
            util_bitpack_uint((__unpacked)->depth_bias_enable, 28, 28) | \
            util_bitpack_uint((__unpacked)->depth_function, 29, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_float((__unpacked)->depth_units); \
   __tmp_packed.opaque[ 6] = util_bitpack_float((__unpacked)->depth_factor); \
   __tmp_packed.opaque[ 7] = util_bitpack_float((__unpacked)->depth_bias_clamp); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DEPTH_STENCIL_unpack(__packed, __unpacked) \
do { \
   MALI_DEPTH_STENCIL_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x30000000) fprintf(stderr, "XXX: Invalid field of Depth/stencil unpacked at word 0\n"); \
   if (__tmp_packed.opaque[2] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Depth/stencil unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Depth/stencil unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0x3fffff) fprintf(stderr, "XXX: Invalid field of Depth/stencil unpacked at word 4\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 3); \
   __gen_unpack_uint((__unpacked)->front_compare_function, &__tmp_packed.opaque[0], 4, 6); \
   __gen_unpack_uint((__unpacked)->front_stencil_fail, &__tmp_packed.opaque[0], 7, 9); \
   __gen_unpack_uint((__unpacked)->front_depth_fail, &__tmp_packed.opaque[0], 10, 12); \
   __gen_unpack_uint((__unpacked)->front_depth_pass, &__tmp_packed.opaque[0], 13, 15); \
   __gen_unpack_uint((__unpacked)->back_compare_function, &__tmp_packed.opaque[0], 16, 18); \
   __gen_unpack_uint((__unpacked)->back_stencil_fail, &__tmp_packed.opaque[0], 19, 21); \
   __gen_unpack_uint((__unpacked)->back_depth_fail, &__tmp_packed.opaque[0], 22, 24); \
   __gen_unpack_uint((__unpacked)->back_depth_pass, &__tmp_packed.opaque[0], 25, 27); \
   __gen_unpack_uint((__unpacked)->stencil_from_shader, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->stencil_test_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->front_write_mask, &__tmp_packed.opaque[0], 32, 39); \
   __gen_unpack_uint((__unpacked)->back_write_mask, &__tmp_packed.opaque[0], 40, 47); \
   __gen_unpack_uint((__unpacked)->front_value_mask, &__tmp_packed.opaque[0], 48, 55); \
   __gen_unpack_uint((__unpacked)->back_value_mask, &__tmp_packed.opaque[0], 56, 63); \
   __gen_unpack_uint((__unpacked)->front_reference_value, &__tmp_packed.opaque[0], 64, 71); \
   __gen_unpack_uint((__unpacked)->back_reference_value, &__tmp_packed.opaque[0], 72, 79); \
   __gen_unpack_uint((__unpacked)->depth_cull_enable, &__tmp_packed.opaque[0], 150, 150); \
   __gen_unpack_uint((__unpacked)->depth_clamp_mode, &__tmp_packed.opaque[0], 151, 152); \
   __gen_unpack_uint((__unpacked)->depth_source, &__tmp_packed.opaque[0], 153, 154); \
   __gen_unpack_uint((__unpacked)->depth_write_enable, &__tmp_packed.opaque[0], 155, 155); \
   __gen_unpack_uint((__unpacked)->depth_bias_enable, &__tmp_packed.opaque[0], 156, 156); \
   __gen_unpack_uint((__unpacked)->depth_function, &__tmp_packed.opaque[0], 157, 159); \
   __gen_unpack_float((__unpacked)->depth_units, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_float((__unpacked)->depth_factor, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_float((__unpacked)->depth_bias_clamp, &__tmp_packed.opaque[0], 224, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DEPTH_STENCIL_print(FILE *fp, const struct MALI_DEPTH_STENCIL * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_descriptor_type_as_str(values->type));
   fprintf(fp, "%*sFront compare function: %s\n", indent, "", mali_func_as_str(values->front_compare_function));
   fprintf(fp, "%*sFront stencil fail: %s\n", indent, "", mali_stencil_op_as_str(values->front_stencil_fail));
   fprintf(fp, "%*sFront depth fail: %s\n", indent, "", mali_stencil_op_as_str(values->front_depth_fail));
   fprintf(fp, "%*sFront depth pass: %s\n", indent, "", mali_stencil_op_as_str(values->front_depth_pass));
   fprintf(fp, "%*sBack compare function: %s\n", indent, "", mali_func_as_str(values->back_compare_function));
   fprintf(fp, "%*sBack stencil fail: %s\n", indent, "", mali_stencil_op_as_str(values->back_stencil_fail));
   fprintf(fp, "%*sBack depth fail: %s\n", indent, "", mali_stencil_op_as_str(values->back_depth_fail));
   fprintf(fp, "%*sBack depth pass: %s\n", indent, "", mali_stencil_op_as_str(values->back_depth_pass));
   fprintf(fp, "%*sStencil from shader: %s\n", indent, "", values->stencil_from_shader ? "true" : "false");
   fprintf(fp, "%*sStencil test enable: %s\n", indent, "", values->stencil_test_enable ? "true" : "false");
   fprintf(fp, "%*sFront write mask: 0x%x\n", indent, "", values->front_write_mask);
   fprintf(fp, "%*sBack write mask: 0x%x\n", indent, "", values->back_write_mask);
   fprintf(fp, "%*sFront value mask: 0x%x\n", indent, "", values->front_value_mask);
   fprintf(fp, "%*sBack value mask: 0x%x\n", indent, "", values->back_value_mask);
   fprintf(fp, "%*sFront reference value: 0x%x\n", indent, "", values->front_reference_value);
   fprintf(fp, "%*sBack reference value: 0x%x\n", indent, "", values->back_reference_value);
   fprintf(fp, "%*sDepth cull enable: %s\n", indent, "", values->depth_cull_enable ? "true" : "false");
   fprintf(fp, "%*sDepth clamp mode: %s\n", indent, "", mali_depth_clamp_mode_as_str(values->depth_clamp_mode));
   fprintf(fp, "%*sDepth source: %s\n", indent, "", mali_depth_source_as_str(values->depth_source));
   fprintf(fp, "%*sDepth write enable: %s\n", indent, "", values->depth_write_enable ? "true" : "false");
   fprintf(fp, "%*sDepth bias enable: %s\n", indent, "", values->depth_bias_enable ? "true" : "false");
   fprintf(fp, "%*sDepth function: %s\n", indent, "", mali_func_as_str(values->depth_function));
   fprintf(fp, "%*sDepth units: %f\n", indent, "", values->depth_units);
   fprintf(fp, "%*sDepth factor: %f\n", indent, "", values->depth_factor);
   fprintf(fp, "%*sDepth bias clamp: %f\n", indent, "", values->depth_bias_clamp);
}

#endif
enum mali_conservative_rast_mode {
        MALI_CONSERVATIVE_RAST_MODE_DISABLED =      0,
        MALI_CONSERVATIVE_RAST_MODE_OVER_ESTIMATE =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_conservative_rast_mode_as_str(enum mali_conservative_rast_mode imm)
{
    switch (imm) {
    case MALI_CONSERVATIVE_RAST_MODE_DISABLED: return "Disabled";
    case MALI_CONSERVATIVE_RAST_MODE_OVER_ESTIMATE: return "Over Estimate";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_DCD_FLAGS_0 {
   bool                                 allow_forward_pixel_to_kill;
   bool                                 allow_forward_pixel_to_be_killed;
   enum mali_pixel_kill                 pixel_kill_operation;
   enum mali_pixel_kill                 zs_update_operation;
   bool                                 overdraw_alpha0;
   bool                                 overdraw_alpha1;
   bool                                 clean_fragment_write;
   bool                                 primitive_barrier;
   bool                                 evaluate_per_sample;
   bool                                 disable_vrs_clamp_2x2;
   bool                                 aligned_line_ends;
   enum mali_occlusion_mode             occlusion_query;
   bool                                 front_face_ccw;
   bool                                 cull_front_face;
   bool                                 cull_back_face;
   bool                                 multisample_enable;
   bool                                 shader_modifies_coverage;
   bool                                 alpha_to_coverage_invert;
   bool                                 alpha_to_coverage;
   bool                                 scissor_mode;
   enum mali_conservative_rast_mode     conservative_rast_mode;
   bool                                 cull_zero_area;
   bool                                 conservative_tracking;
};

#define MALI_DCD_FLAGS_0_header                 \
   0

#define MALI_DCD_FLAGS_0_LENGTH 4
struct mali_dcd_flags_0_packed { uint32_t opaque[1]; };
#define MALI_DCD_FLAGS_0_PACKED_T struct mali_dcd_flags_0_packed
#define MALI_DCD_FLAGS_0_pack(__packed, __unpacked) \
do { \
   MALI_DCD_FLAGS_0_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->allow_forward_pixel_to_kill, 0, 0) | \
            util_bitpack_uint((__unpacked)->allow_forward_pixel_to_be_killed, 1, 1) | \
            util_bitpack_uint((__unpacked)->pixel_kill_operation, 2, 3) | \
            util_bitpack_uint((__unpacked)->zs_update_operation, 4, 5) | \
            util_bitpack_uint((__unpacked)->overdraw_alpha0, 7, 7) | \
            util_bitpack_uint((__unpacked)->overdraw_alpha1, 8, 8) | \
            util_bitpack_uint((__unpacked)->clean_fragment_write, 9, 9) | \
            util_bitpack_uint((__unpacked)->primitive_barrier, 10, 10) | \
            util_bitpack_uint((__unpacked)->evaluate_per_sample, 11, 11) | \
            util_bitpack_uint((__unpacked)->disable_vrs_clamp_2x2, 12, 12) | \
            util_bitpack_uint((__unpacked)->aligned_line_ends, 13, 13) | \
            util_bitpack_uint((__unpacked)->occlusion_query, 14, 15) | \
            util_bitpack_uint((__unpacked)->front_face_ccw, 16, 16) | \
            util_bitpack_uint((__unpacked)->cull_front_face, 17, 17) | \
            util_bitpack_uint((__unpacked)->cull_back_face, 18, 18) | \
            util_bitpack_uint((__unpacked)->multisample_enable, 19, 19) | \
            util_bitpack_uint((__unpacked)->shader_modifies_coverage, 20, 20) | \
            util_bitpack_uint((__unpacked)->alpha_to_coverage_invert, 21, 21) | \
            util_bitpack_uint((__unpacked)->alpha_to_coverage, 22, 22) | \
            util_bitpack_uint((__unpacked)->scissor_mode, 23, 23) | \
            util_bitpack_uint((__unpacked)->conservative_rast_mode, 24, 25) | \
            util_bitpack_uint((__unpacked)->cull_zero_area, 26, 26) | \
            util_bitpack_uint((__unpacked)->conservative_tracking, 27, 27); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DCD_FLAGS_0_unpack(__packed, __unpacked) \
do { \
   MALI_DCD_FLAGS_0_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf0000040) fprintf(stderr, "XXX: Invalid field of DCD Flags 0 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->allow_forward_pixel_to_kill, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->allow_forward_pixel_to_be_killed, &__tmp_packed.opaque[0], 1, 1); \
   __gen_unpack_uint((__unpacked)->pixel_kill_operation, &__tmp_packed.opaque[0], 2, 3); \
   __gen_unpack_uint((__unpacked)->zs_update_operation, &__tmp_packed.opaque[0], 4, 5); \
   __gen_unpack_uint((__unpacked)->overdraw_alpha0, &__tmp_packed.opaque[0], 7, 7); \
   __gen_unpack_uint((__unpacked)->overdraw_alpha1, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->clean_fragment_write, &__tmp_packed.opaque[0], 9, 9); \
   __gen_unpack_uint((__unpacked)->primitive_barrier, &__tmp_packed.opaque[0], 10, 10); \
   __gen_unpack_uint((__unpacked)->evaluate_per_sample, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->disable_vrs_clamp_2x2, &__tmp_packed.opaque[0], 12, 12); \
   __gen_unpack_uint((__unpacked)->aligned_line_ends, &__tmp_packed.opaque[0], 13, 13); \
   __gen_unpack_uint((__unpacked)->occlusion_query, &__tmp_packed.opaque[0], 14, 15); \
   __gen_unpack_uint((__unpacked)->front_face_ccw, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->cull_front_face, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->cull_back_face, &__tmp_packed.opaque[0], 18, 18); \
   __gen_unpack_uint((__unpacked)->multisample_enable, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->shader_modifies_coverage, &__tmp_packed.opaque[0], 20, 20); \
   __gen_unpack_uint((__unpacked)->alpha_to_coverage_invert, &__tmp_packed.opaque[0], 21, 21); \
   __gen_unpack_uint((__unpacked)->alpha_to_coverage, &__tmp_packed.opaque[0], 22, 22); \
   __gen_unpack_uint((__unpacked)->scissor_mode, &__tmp_packed.opaque[0], 23, 23); \
   __gen_unpack_uint((__unpacked)->conservative_rast_mode, &__tmp_packed.opaque[0], 24, 25); \
   __gen_unpack_uint((__unpacked)->cull_zero_area, &__tmp_packed.opaque[0], 26, 26); \
   __gen_unpack_uint((__unpacked)->conservative_tracking, &__tmp_packed.opaque[0], 27, 27); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DCD_FLAGS_0_print(FILE *fp, const struct MALI_DCD_FLAGS_0 * values, unsigned indent)
{
   fprintf(fp, "%*sAllow Forward Pixel To Kill: %s\n", indent, "", values->allow_forward_pixel_to_kill ? "true" : "false");
   fprintf(fp, "%*sAllow Forward Pixel To Be Killed: %s\n", indent, "", values->allow_forward_pixel_to_be_killed ? "true" : "false");
   fprintf(fp, "%*sPixel Kill Operation: %s\n", indent, "", mali_pixel_kill_as_str(values->pixel_kill_operation));
   fprintf(fp, "%*sZS Update Operation: %s\n", indent, "", mali_pixel_kill_as_str(values->zs_update_operation));
   fprintf(fp, "%*sOverdraw Alpha0: %s\n", indent, "", values->overdraw_alpha0 ? "true" : "false");
   fprintf(fp, "%*sOverdraw Alpha1: %s\n", indent, "", values->overdraw_alpha1 ? "true" : "false");
   fprintf(fp, "%*sClean Fragment Write: %s\n", indent, "", values->clean_fragment_write ? "true" : "false");
   fprintf(fp, "%*sPrimitive Barrier: %s\n", indent, "", values->primitive_barrier ? "true" : "false");
   fprintf(fp, "%*sEvaluate per-sample: %s\n", indent, "", values->evaluate_per_sample ? "true" : "false");
   fprintf(fp, "%*sDisable VRS Clamp 2x2: %s\n", indent, "", values->disable_vrs_clamp_2x2 ? "true" : "false");
   fprintf(fp, "%*sAligned line-ends: %s\n", indent, "", values->aligned_line_ends ? "true" : "false");
   fprintf(fp, "%*sOcclusion Query: %s\n", indent, "", mali_occlusion_mode_as_str(values->occlusion_query));
   fprintf(fp, "%*sFront Face CCW: %s\n", indent, "", values->front_face_ccw ? "true" : "false");
   fprintf(fp, "%*sCull Front Face: %s\n", indent, "", values->cull_front_face ? "true" : "false");
   fprintf(fp, "%*sCull Back Face: %s\n", indent, "", values->cull_back_face ? "true" : "false");
   fprintf(fp, "%*sMultisample Enable: %s\n", indent, "", values->multisample_enable ? "true" : "false");
   fprintf(fp, "%*sShader Modifies Coverage: %s\n", indent, "", values->shader_modifies_coverage ? "true" : "false");
   fprintf(fp, "%*sAlpha To Coverage Invert: %s\n", indent, "", values->alpha_to_coverage_invert ? "true" : "false");
   fprintf(fp, "%*sAlpha To Coverage: %s\n", indent, "", values->alpha_to_coverage ? "true" : "false");
   fprintf(fp, "%*sScissor Mode: %s\n", indent, "", values->scissor_mode ? "true" : "false");
   fprintf(fp, "%*sConservative Rast Mode: %s\n", indent, "", mali_conservative_rast_mode_as_str(values->conservative_rast_mode));
   fprintf(fp, "%*sCull Zero Area: %s\n", indent, "", values->cull_zero_area ? "true" : "false");
   fprintf(fp, "%*sConservative Tracking: %s\n", indent, "", values->conservative_tracking ? "true" : "false");
}

#endif
struct MALI_DCD_FLAGS_1 {
   uint32_t                             sample_mask;
   uint32_t                             render_target_mask;
};

#define MALI_DCD_FLAGS_1_header                 \
   0

#define MALI_DCD_FLAGS_1_LENGTH 4
struct mali_dcd_flags_1_packed { uint32_t opaque[1]; };
#define MALI_DCD_FLAGS_1_PACKED_T struct mali_dcd_flags_1_packed
#define MALI_DCD_FLAGS_1_pack(__packed, __unpacked) \
do { \
   MALI_DCD_FLAGS_1_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->sample_mask, 0, 15) | \
            util_bitpack_uint((__unpacked)->render_target_mask, 16, 27); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DCD_FLAGS_1_unpack(__packed, __unpacked) \
do { \
   MALI_DCD_FLAGS_1_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf0000000) fprintf(stderr, "XXX: Invalid field of DCD Flags 1 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->sample_mask, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->render_target_mask, &__tmp_packed.opaque[0], 16, 27); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DCD_FLAGS_1_print(FILE *fp, const struct MALI_DCD_FLAGS_1 * values, unsigned indent)
{
   fprintf(fp, "%*sSample Mask: 0x%x\n", indent, "", values->sample_mask);
   fprintf(fp, "%*sRender Target Mask: 0x%x\n", indent, "", values->render_target_mask);
}

#endif
struct MALI_DCD_FLAGS_2 {
   uint32_t                             read_mask;
   uint32_t                             write_mask;
   bool                                 no_shader_stencil_read;
   bool                                 no_shader_depth_read;
};

#define MALI_DCD_FLAGS_2_header                 \
   0

#define MALI_DCD_FLAGS_2_LENGTH 4
struct mali_dcd_flags_2_packed { uint32_t opaque[1]; };
#define MALI_DCD_FLAGS_2_PACKED_T struct mali_dcd_flags_2_packed
#define MALI_DCD_FLAGS_2_pack(__packed, __unpacked) \
do { \
   MALI_DCD_FLAGS_2_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->read_mask, 0, 11) | \
            util_bitpack_uint((__unpacked)->write_mask, 12, 23) | \
            util_bitpack_uint((__unpacked)->no_shader_stencil_read, 24, 24) | \
            util_bitpack_uint((__unpacked)->no_shader_depth_read, 25, 25); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DCD_FLAGS_2_unpack(__packed, __unpacked) \
do { \
   MALI_DCD_FLAGS_2_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfc000000) fprintf(stderr, "XXX: Invalid field of DCD Flags 2 unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->read_mask, &__tmp_packed.opaque[0], 0, 11); \
   __gen_unpack_uint((__unpacked)->write_mask, &__tmp_packed.opaque[0], 12, 23); \
   __gen_unpack_uint((__unpacked)->no_shader_stencil_read, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->no_shader_depth_read, &__tmp_packed.opaque[0], 25, 25); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DCD_FLAGS_2_print(FILE *fp, const struct MALI_DCD_FLAGS_2 * values, unsigned indent)
{
   fprintf(fp, "%*sRead Mask: 0x%x\n", indent, "", values->read_mask);
   fprintf(fp, "%*sWrite Mask: 0x%x\n", indent, "", values->write_mask);
   fprintf(fp, "%*sNo Shader Stencil Read: %s\n", indent, "", values->no_shader_stencil_read ? "true" : "false");
   fprintf(fp, "%*sNo Shader Depth Read: %s\n", indent, "", values->no_shader_depth_read ? "true" : "false");
}

#endif
struct MALI_FAU_POINTER {
   uint64_t                             pointer;
   uint32_t                             count;
};

#define MALI_FAU_POINTER_header                 \
   0

#define MALI_FAU_POINTER_LENGTH 8
struct mali_fau_pointer_packed { uint32_t opaque[2]; };
#define MALI_FAU_POINTER_PACKED_T struct mali_fau_pointer_packed
#define MALI_FAU_POINTER_pack(__packed, __unpacked) \
do { \
   MALI_FAU_POINTER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->pointer, 0, 55); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->pointer, 0, 55) >> 32 | \
            util_bitpack_uint((__unpacked)->count, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FAU_POINTER_unpack(__packed, __unpacked) \
do { \
   MALI_FAU_POINTER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 0, 55); \
   __gen_unpack_uint((__unpacked)->count, &__tmp_packed.opaque[0], 56, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FAU_POINTER_print(FILE *fp, const struct MALI_FAU_POINTER * values, unsigned indent)
{
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sCount: %u\n", indent, "", values->count);
}

#endif
struct MALI_DRAW {
   struct MALI_DCD_FLAGS_0              flags_0;
   struct MALI_DCD_FLAGS_1              flags_1;
   uint64_t                             vertex_pointer;
   struct MALI_DCD_FLAGS_2              flags_2;
   uint64_t                             depth_stencil;
   uint32_t                             blend_count;
   uint64_t                             blend;
   uint64_t                             occlusion;
   uint64_t                             vertex_resources;
   uint64_t                             vertex_shader;
   struct MALI_FAU_POINTER              vertex_fau;
   uint64_t                             fragment_resources;
   uint64_t                             fragment_shader;
   uint64_t                             thread_storage;
   struct MALI_FAU_POINTER              fragment_fau;
#define MALI_RESOURCE_TABLE_SIZE_ALIGNMENT       4
};

#define MALI_DRAW_header                        \
   .flags_0 = { MALI_DCD_FLAGS_0_header },  \
   .flags_1 = { MALI_DCD_FLAGS_1_header },  \
   .flags_2 = { MALI_DCD_FLAGS_2_header },  \
   .vertex_fau = { MALI_FAU_POINTER_header },  \
   .fragment_fau = { MALI_FAU_POINTER_header }

#define MALI_DRAW_LENGTH 128
#define MALI_DRAW_ALIGN 64
struct mali_draw_packed { uint32_t opaque[32]; };
#define MALI_DRAW_PACKED_T struct mali_draw_packed
#define MALI_DRAW_pack(__packed, __unpacked) \
do { \
   MALI_DRAW_PACKED_T __tmp_packed; \
   assert(((__unpacked)->blend & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->flags_0.allow_forward_pixel_to_kill, 0, 0) | \
            util_bitpack_uint((__unpacked)->flags_0.allow_forward_pixel_to_be_killed, 1, 1) | \
            util_bitpack_uint((__unpacked)->flags_0.pixel_kill_operation, 2, 3) | \
            util_bitpack_uint((__unpacked)->flags_0.zs_update_operation, 4, 5) | \
            util_bitpack_uint((__unpacked)->flags_0.overdraw_alpha0, 7, 7) | \
            util_bitpack_uint((__unpacked)->flags_0.overdraw_alpha1, 8, 8) | \
            util_bitpack_uint((__unpacked)->flags_0.clean_fragment_write, 9, 9) | \
            util_bitpack_uint((__unpacked)->flags_0.primitive_barrier, 10, 10) | \
            util_bitpack_uint((__unpacked)->flags_0.evaluate_per_sample, 11, 11) | \
            util_bitpack_uint((__unpacked)->flags_0.disable_vrs_clamp_2x2, 12, 12) | \
            util_bitpack_uint((__unpacked)->flags_0.aligned_line_ends, 13, 13) | \
            util_bitpack_uint((__unpacked)->flags_0.occlusion_query, 14, 15) | \
            util_bitpack_uint((__unpacked)->flags_0.front_face_ccw, 16, 16) | \
            util_bitpack_uint((__unpacked)->flags_0.cull_front_face, 17, 17) | \
            util_bitpack_uint((__unpacked)->flags_0.cull_back_face, 18, 18) | \
            util_bitpack_uint((__unpacked)->flags_0.multisample_enable, 19, 19) | \
            util_bitpack_uint((__unpacked)->flags_0.shader_modifies_coverage, 20, 20) | \
            util_bitpack_uint((__unpacked)->flags_0.alpha_to_coverage_invert, 21, 21) | \
            util_bitpack_uint((__unpacked)->flags_0.alpha_to_coverage, 22, 22) | \
            util_bitpack_uint((__unpacked)->flags_0.scissor_mode, 23, 23) | \
            util_bitpack_uint((__unpacked)->flags_0.conservative_rast_mode, 24, 25) | \
            util_bitpack_uint((__unpacked)->flags_0.cull_zero_area, 26, 26) | \
            util_bitpack_uint((__unpacked)->flags_0.conservative_tracking, 27, 27); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->flags_1.sample_mask, 0, 15) | \
            util_bitpack_uint((__unpacked)->flags_1.render_target_mask, 16, 27); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->vertex_pointer, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->vertex_pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->flags_2.read_mask, 0, 11) | \
            util_bitpack_uint((__unpacked)->flags_2.write_mask, 12, 23) | \
            util_bitpack_uint((__unpacked)->flags_2.no_shader_stencil_read, 24, 24) | \
            util_bitpack_uint((__unpacked)->flags_2.no_shader_depth_read, 25, 25); \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = 0; \
   __tmp_packed.opaque[ 9] = 0; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->depth_stencil, 0, 63); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->depth_stencil, 0, 63) >> 32; \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->blend_count, 0, 3) | \
            util_bitpack_uint((__unpacked)->blend >> 4, 4, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->blend >> 4, 4, 63) >> 32; \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->occlusion, 0, 63); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->occlusion, 0, 63) >> 32; \
   __tmp_packed.opaque[16] = 0; \
   __tmp_packed.opaque[17] = 0; \
   __tmp_packed.opaque[18] = util_bitpack_uint((__unpacked)->vertex_resources, 0, 63); \
   __tmp_packed.opaque[19] = util_bitpack_uint((__unpacked)->vertex_resources, 0, 63) >> 32; \
   __tmp_packed.opaque[20] = util_bitpack_uint((__unpacked)->vertex_shader, 0, 63); \
   __tmp_packed.opaque[21] = util_bitpack_uint((__unpacked)->vertex_shader, 0, 63) >> 32; \
   __tmp_packed.opaque[22] = util_bitpack_uint((__unpacked)->vertex_fau.pointer, 0, 55); \
   __tmp_packed.opaque[23] = util_bitpack_uint((__unpacked)->vertex_fau.pointer, 0, 55) >> 32 | \
            util_bitpack_uint((__unpacked)->vertex_fau.count, 24, 31); \
   __tmp_packed.opaque[24] = util_bitpack_uint((__unpacked)->fragment_resources, 0, 63); \
   __tmp_packed.opaque[25] = util_bitpack_uint((__unpacked)->fragment_resources, 0, 63) >> 32; \
   __tmp_packed.opaque[26] = util_bitpack_uint((__unpacked)->fragment_shader, 0, 63); \
   __tmp_packed.opaque[27] = util_bitpack_uint((__unpacked)->fragment_shader, 0, 63) >> 32; \
   __tmp_packed.opaque[28] = util_bitpack_uint((__unpacked)->thread_storage, 0, 63); \
   __tmp_packed.opaque[29] = util_bitpack_uint((__unpacked)->thread_storage, 0, 63) >> 32; \
   __tmp_packed.opaque[30] = util_bitpack_uint((__unpacked)->fragment_fau.pointer, 0, 55); \
   __tmp_packed.opaque[31] = util_bitpack_uint((__unpacked)->fragment_fau.pointer, 0, 55) >> 32 | \
            util_bitpack_uint((__unpacked)->fragment_fau.count, 24, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DRAW_unpack(__packed, __unpacked) \
do { \
   MALI_DRAW_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf0000040) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf0000000) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 1\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xfc000000) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 7\n"); \
   if (__tmp_packed.opaque[8] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 8\n"); \
   if (__tmp_packed.opaque[9] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 9\n"); \
   if (__tmp_packed.opaque[16] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 16\n"); \
   if (__tmp_packed.opaque[17] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 17\n"); \
   __gen_unpack_uint((__unpacked)->flags_0.allow_forward_pixel_to_kill, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->flags_0.allow_forward_pixel_to_be_killed, &__tmp_packed.opaque[0], 1, 1); \
   __gen_unpack_uint((__unpacked)->flags_0.pixel_kill_operation, &__tmp_packed.opaque[0], 2, 3); \
   __gen_unpack_uint((__unpacked)->flags_0.zs_update_operation, &__tmp_packed.opaque[0], 4, 5); \
   __gen_unpack_uint((__unpacked)->flags_0.overdraw_alpha0, &__tmp_packed.opaque[0], 7, 7); \
   __gen_unpack_uint((__unpacked)->flags_0.overdraw_alpha1, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->flags_0.clean_fragment_write, &__tmp_packed.opaque[0], 9, 9); \
   __gen_unpack_uint((__unpacked)->flags_0.primitive_barrier, &__tmp_packed.opaque[0], 10, 10); \
   __gen_unpack_uint((__unpacked)->flags_0.evaluate_per_sample, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->flags_0.disable_vrs_clamp_2x2, &__tmp_packed.opaque[0], 12, 12); \
   __gen_unpack_uint((__unpacked)->flags_0.aligned_line_ends, &__tmp_packed.opaque[0], 13, 13); \
   __gen_unpack_uint((__unpacked)->flags_0.occlusion_query, &__tmp_packed.opaque[0], 14, 15); \
   __gen_unpack_uint((__unpacked)->flags_0.front_face_ccw, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->flags_0.cull_front_face, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->flags_0.cull_back_face, &__tmp_packed.opaque[0], 18, 18); \
   __gen_unpack_uint((__unpacked)->flags_0.multisample_enable, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->flags_0.shader_modifies_coverage, &__tmp_packed.opaque[0], 20, 20); \
   __gen_unpack_uint((__unpacked)->flags_0.alpha_to_coverage_invert, &__tmp_packed.opaque[0], 21, 21); \
   __gen_unpack_uint((__unpacked)->flags_0.alpha_to_coverage, &__tmp_packed.opaque[0], 22, 22); \
   __gen_unpack_uint((__unpacked)->flags_0.scissor_mode, &__tmp_packed.opaque[0], 23, 23); \
   __gen_unpack_uint((__unpacked)->flags_0.conservative_rast_mode, &__tmp_packed.opaque[0], 24, 25); \
   __gen_unpack_uint((__unpacked)->flags_0.cull_zero_area, &__tmp_packed.opaque[0], 26, 26); \
   __gen_unpack_uint((__unpacked)->flags_0.conservative_tracking, &__tmp_packed.opaque[0], 27, 27); \
   __gen_unpack_uint((__unpacked)->flags_1.sample_mask, &__tmp_packed.opaque[0], 32, 47); \
   __gen_unpack_uint((__unpacked)->flags_1.render_target_mask, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->vertex_pointer, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->flags_2.read_mask, &__tmp_packed.opaque[0], 160, 171); \
   __gen_unpack_uint((__unpacked)->flags_2.write_mask, &__tmp_packed.opaque[0], 172, 183); \
   __gen_unpack_uint((__unpacked)->flags_2.no_shader_stencil_read, &__tmp_packed.opaque[0], 184, 184); \
   __gen_unpack_uint((__unpacked)->flags_2.no_shader_depth_read, &__tmp_packed.opaque[0], 185, 185); \
   __gen_unpack_uint((__unpacked)->depth_stencil, &__tmp_packed.opaque[0], 320, 383); \
   __gen_unpack_uint((__unpacked)->blend_count, &__tmp_packed.opaque[0], 384, 387); \
   __gen_unpack_uint((__unpacked)->blend, &__tmp_packed.opaque[0], 388, 447); \
   (__unpacked)->blend = (__unpacked)->blend << 4; \
   __gen_unpack_uint((__unpacked)->occlusion, &__tmp_packed.opaque[0], 448, 511); \
   __gen_unpack_uint((__unpacked)->vertex_resources, &__tmp_packed.opaque[0], 576, 639); \
   __gen_unpack_uint((__unpacked)->vertex_shader, &__tmp_packed.opaque[0], 640, 703); \
   __gen_unpack_uint((__unpacked)->vertex_fau.pointer, &__tmp_packed.opaque[0], 704, 759); \
   __gen_unpack_uint((__unpacked)->vertex_fau.count, &__tmp_packed.opaque[0], 760, 767); \
   __gen_unpack_uint((__unpacked)->fragment_resources, &__tmp_packed.opaque[0], 768, 831); \
   __gen_unpack_uint((__unpacked)->fragment_shader, &__tmp_packed.opaque[0], 832, 895); \
   __gen_unpack_uint((__unpacked)->thread_storage, &__tmp_packed.opaque[0], 896, 959); \
   __gen_unpack_uint((__unpacked)->fragment_fau.pointer, &__tmp_packed.opaque[0], 960, 1015); \
   __gen_unpack_uint((__unpacked)->fragment_fau.count, &__tmp_packed.opaque[0], 1016, 1023); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DRAW_print(FILE *fp, const struct MALI_DRAW * values, unsigned indent)
{
   fprintf(fp, "%*sFlags 0:\n", indent, "");
   MALI_DCD_FLAGS_0_print(fp, &values->flags_0, indent + 2);
   fprintf(fp, "%*sFlags 1:\n", indent, "");
   MALI_DCD_FLAGS_1_print(fp, &values->flags_1, indent + 2);
   fprintf(fp, "%*sVertex pointer: 0x%" PRIx64 "\n", indent, "", values->vertex_pointer);
   fprintf(fp, "%*sFlags 2:\n", indent, "");
   MALI_DCD_FLAGS_2_print(fp, &values->flags_2, indent + 2);
   fprintf(fp, "%*sDepth/stencil: 0x%" PRIx64 "\n", indent, "", values->depth_stencil);
   fprintf(fp, "%*sBlend count: %u\n", indent, "", values->blend_count);
   fprintf(fp, "%*sBlend: 0x%" PRIx64 "\n", indent, "", values->blend);
   fprintf(fp, "%*sOcclusion: 0x%" PRIx64 "\n", indent, "", values->occlusion);
   fprintf(fp, "%*sVertex Resources: 0x%" PRIx64 "\n", indent, "", values->vertex_resources);
   fprintf(fp, "%*sVertex Shader: 0x%" PRIx64 "\n", indent, "", values->vertex_shader);
   fprintf(fp, "%*sVertex FAU:\n", indent, "");
   MALI_FAU_POINTER_print(fp, &values->vertex_fau, indent + 2);
   fprintf(fp, "%*sFragment Resources: 0x%" PRIx64 "\n", indent, "", values->fragment_resources);
   fprintf(fp, "%*sFragment Shader: 0x%" PRIx64 "\n", indent, "", values->fragment_shader);
   fprintf(fp, "%*sThread storage: 0x%" PRIx64 "\n", indent, "", values->thread_storage);
   fprintf(fp, "%*sFragment FAU:\n", indent, "");
   MALI_FAU_POINTER_print(fp, &values->fragment_fau, indent + 2);
}

#endif
struct MALI_PRIMITIVE_SIZE {
   float                                fixed_sized;
   uint64_t                             size_array;
};

#define MALI_PRIMITIVE_SIZE_header              \
   0

#define MALI_PRIMITIVE_SIZE_LENGTH 8
struct mali_primitive_size_packed { uint32_t opaque[2]; };
#define MALI_PRIMITIVE_SIZE_PACKED_T struct mali_primitive_size_packed
#define MALI_PRIMITIVE_SIZE_pack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_SIZE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_float((__unpacked)->fixed_sized) | \
            util_bitpack_uint((__unpacked)->size_array, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size_array, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PRIMITIVE_SIZE_unpack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_SIZE_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_float((__unpacked)->fixed_sized, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->size_array, &__tmp_packed.opaque[0], 0, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PRIMITIVE_SIZE_print(FILE *fp, const struct MALI_PRIMITIVE_SIZE * values, unsigned indent)
{
   fprintf(fp, "%*sFixed Sized: %f\n", indent, "", values->fixed_sized);
   fprintf(fp, "%*sSize Array: 0x%" PRIx64 "\n", indent, "", values->size_array);
}

#endif
#endif
