
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 2832
 * transforms:
 *    ('fgeu', 'a', 'b') => ('inot', ('flt', 'a', 'b'))
 *    ('fltu', 'a', 'b') => ('inot', ('fge', 'a', 'b'))
 *    ('fneo', 0.0, 'a') => ('flt', 0.0, ('fabs', 'a'))
 *    ('fequ', 0.0, 'a') => ('inot', ('flt', 0.0, ('fabs', 'a')))
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a@8', 128) => ('ishl', 'a', 7)
 *    ('imul', 'a@16', 32768) => ('ishl', 'a', 15)
 *    ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31)
 *    ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63)
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b')))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b'))
 *    ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5)))
 *    ('fneg', ('fneg', 'a')) => ('fcanonicalize', 'a')
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('fadd(nsz)', 'a', 0.0) => ('fcanonicalize', 'a')
 *    ('fadd', 'a', -0.0) => ('fcanonicalize', 'a')
 *    ('iadd', 'a', 0) => a
 *    ('iadd_sat', 'a', 0) => a
 *    ('isub_sat', 'a', 0) => a
 *    ('uadd_sat', 'a', 0) => a
 *    ('usub_sat', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd'))
 *    ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a')
 *    ('iand', ('iand', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', ('iand', 'a', 'b'), 'c')
 *    ('ior', ('ior', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', ('ior', 'a', 'b'), 'c')
 *    ('iand', ('ior(is_used_once)', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', 'c')
 *    ('iand', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('iand', 'a', 'b')
 *    ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0)
 *    ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0)
 *    ('uge', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0)
 *    ('ult', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0)
 *    ('ige', ('iand', 'a', 'b'), '#b(is_pos_power_of_two)') => ('ine', ('iand', 'a', 'b'), 0)
 *    ('ilt', ('iand', 'a', 'b'), '#b(is_pos_power_of_two)') => ('ieq', ('iand', 'a', 'b'), 0)
 *    ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b'))
 *    ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => ('fcanonicalize', 'b')
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => ('fcanonicalize', 'b')
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('fadd', 'a', 'a') => ('fmul', 'a', 2.0)
 *    ('fadd(contract)', 'a', ('fadd(is_used_once)', 'a', 'b')) => ('fadd', 'b', ('fmul', 'a', 2.0))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('~fmul', 'a', -0.0) => 0.0
 *    ('fmul(nsz,nnan)', 'a', 0.0) => 0.0
 *    ('fmul(nsz,nnan)', 'a', -0.0) => 0.0
 *    ('fmulz', 'a', 0.0) => 0.0
 *    ('fmulz', 'a', -0.0) => 0.0
 *    ('fmulz(nsz)', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a', 'a') => ('fmul', 'a', 'a')
 *    ('ffmaz(nsz)', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b')
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('fmul', 'a', 1.0) => ('fcanonicalize', 'a')
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('ffma(nsz,nnan)', 0.0, 'a', 'b') => ('fcanonicalize', 'b')
 *    ('ffma(nsz,nnan)', -0.0, 'a', 'b') => ('fcanonicalize', 'b')
 *    ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b')
 *    ('ffmaz', -0.0, 'a', 'b') => ('fadd', 0.0, 'b')
 *    ('ffma(nsz)', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffmaz(nsz)', 'a', 'b', 0.0) => ('fmulz', 'a', 'b')
 *    ('ffma', 'a', 'b', -0.0) => ('fmul', 'a', 'b')
 *    ('ffmaz', 'a', 'b', -0.0) => ('fmulz', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffmaz(nsz)', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('ffmaz(nsz)', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('flrp(nnan,nsz)', 'a', 'b', 0.0) => ('fcanonicalize', 'a')
 *    ('flrp(nnan,nsz)', 'a', 'b', -0.0) => ('fcanonicalize', 'a')
 *    ('flrp(nnan,nsz)', 'a', 'b', 1.0) => ('fcanonicalize', 'b')
 *    ('~flrp', 'a', 'a', 'b') => ('fcanonicalize', 'a')
 *    ('flrp(nnan,nsz)', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('flrp(nnan,nsz)', -0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('sdot_4x8_iadd', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd', 'a', 0, 'b') => b
 *    ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd_sat', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 0, 'a', 'b') => b
 *    ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b
 *    ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), 'a', 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'b')), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fabs', 'b'), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fabs', 'b'), 0.0)) => ('fmulz', ('fabs', 'a'), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fabs', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fneg', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), 'a', 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', 'a', 'b')
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b'))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b'))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b'))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b'))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), 'b')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', 'a'), ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b'))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', 'a'), 'b')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', 'a', 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b'))), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fabs', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fabs', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('ffma@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c')
 *    ('ffma@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b')))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b')))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b')))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b')))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('iand(is_only_used_as_float)', 'a@16', 32767) => ('fabs', 'a')
 *    ('ixor(is_only_used_as_float)', 'a@16', 32768) => ('fneg', 'a')
 *    ('ior(is_only_used_as_float)', 'a@16', 32768) => ('fneg', ('fabs', 'a'))
 *    ('iand(is_only_used_as_float)', 'a@32', 2147483647) => ('fabs', 'a')
 *    ('ixor(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', 'a')
 *    ('ior(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', ('fabs', 'a'))
 *    ('iand(is_only_used_as_float)', 'a@64', 9223372036854775807) => ('fabs', 'a')
 *    ('ixor(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', 'a')
 *    ('ior(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', ('fabs', 'a'))
 *    ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', ('fcanonicalize', 'd'), ('fmul', 'a', 'b'))
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', ('fcanonicalize', 'd'), ('fmul', 'a', 'b'))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a'))
 *    ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', ('fcanonicalize', 'd'), ('fmul', 'a', 'b'))
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('fadd', ('ffloor', 'a'), ('b2f', ('iand', ('flt', 'a', 0), ('flt', ('fneg', ('ffract', 'a')), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0))
 *    ('fadd', ('ffloor', 'a'), ('b2f', ('inot', ('fge', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a')))))) => ('ftrunc', ('fadd', 'a', 0))
 *    ('fadd', ('ffloor', 'a'), ('b2f', ('flt', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0))
 *    ('fadd(nnan,nsz)', 'a', ('ffract', ('fneg', 'a'))) => ('fceil', 'a')
 *    ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a'))
 *    ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a'))
 *    ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a'))
 *    ('fadd@16(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@32(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@64(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fadd@16', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a')
 *    ('fadd@32', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a')
 *    ('fadd@64', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a')
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('ffma@16(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz(contract)', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('bcsel', 'a', ('fmul', 'b', 'c'), 0), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', 'a', 0.0) => 0.0
 *    ('fdot3', 'a', 0.0) => 0.0
 *    ('fdot2', 'a', 0.0) => 0.0
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b.x')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', 'a(w_is_zero)', 'b') => ('fdot3', 'a.xyz', 'b.xyz')
 *    ('fdot4', 'a(z_is_zero)', 'b') => ('fdot3', 'a.xyw', 'b.xyw')
 *    ('fdot4', 'a(y_is_zero)', 'b') => ('fdot3', 'a.xzw', 'b.xzw')
 *    ('fdot4', 'a(x_is_zero)', 'b') => ('fdot3', 'a.yzw', 'b.yzw')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b.x')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot3', 'a(x_is_zero)', 'b') => ('fdot2', 'a.yz', 'b.yz')
 *    ('fdot3', 'a(y_is_zero)', 'b') => ('fdot2', 'a.xz', 'b.xz')
 *    ('fdot3', 'a(z_is_zero)', 'b') => ('fdot2', 'a.xy', 'b.xy')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b.x')
 *    ('fdot2', 'a(x_is_zero)', 'b') => ('fmul', 'a.y', 'b.y')
 *    ('fdot2', 'a(y_is_zero)', 'b') => ('fmul', 'a.x', 'b.x')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('imul', ('ishl', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'c', 'b'))
 *    ('fcanonicalize', 'a@16') => a
 *    ('fcanonicalize', 'a@32') => a
 *    ('fcanonicalize', 'a@64') => a
 *    ('fcanonicalize(is_only_used_as_float)', 'a') => a
 *    ('fcanonicalize', 'a(is_created_as_float)') => a
 *    ('fcanonicalize', 'a(is_integral)') => a
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand@32', ('ushr@32(is_used_once)', 'a', 'b'), '#c(is_const_bitmask)') => ('ubfe', 'a', 'b', ('bit_count', 'c'))
 *    ('iand@32', ('ushr@32', 'a', 'b'), ('bfm', 'c', 0)) => ('ubfe', 'a', 'b', 'c')
 *    ('ushr', ('iand', 'a', ('bfm', 'c', 'b')), 'b') => ('ubfe', 'a', 'b', 'c')
 *    ('ushr@32', ('iand(is_used_once)', 'a', '#b(is_const_bfm)'), '#c') => ('bcsel', ('ilt', ('find_lsb', 'b'), ('iand', 'c', 31)), ('ushr', ('ubfe', 'a', ('find_lsb', 'b'), ('bit_count', 'b')), ('isub', 'c', ('find_lsb', 'b'))), ('ishl', ('ubfe', 'a', ('find_lsb', 'b'), ('bit_count', 'b')), ('isub', ('find_lsb', 'b'), 'c')))
 *    ('ubfe', ('ubfe', 'a', '#b', '#c'), '#d', '#e') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 'e', 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0))))
 *    ('ushr@32', ('ubfe', 'a', '#b', '#c'), '#d(is_5lsb_not_zero)') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 31, 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0))))
 *    ('iand', 'a(is_unsigned_multiple_of_4)', -4) => a
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a(is_not_const)'), '#b') => ('flt', ('fneg', 'b'), 'a')
 *    ('flt', '#b', ('fneg', 'a(is_not_const)')) => ('flt', 'a', ('fneg', 'b'))
 *    ('fge', ('fneg', 'a(is_not_const)'), '#b') => ('fge', ('fneg', 'b'), 'a')
 *    ('fge', '#b', ('fneg', 'a(is_not_const)')) => ('fge', 'a', ('fneg', 'b'))
 *    ('fneu', ('fneg', 'a(is_not_const)'), '#b') => ('fneu', ('fneg', 'b'), 'a')
 *    ('feq', '#b', ('fneg', 'a(is_not_const)')) => ('feq', 'a', ('fneg', 'b'))
 *    ('flt', 'a', -0.0) => ('flt', 'a', 0.0)
 *    ('flt', -0.0, 'a') => ('flt', 0.0, 'a')
 *    ('fge', 'a', -0.0) => ('fge', 'a', 0.0)
 *    ('fge', -0.0, 'a') => ('fge', 0.0, 'a')
 *    ('fneu', 'a', -0.0) => ('fneu', 0.0, 'a')
 *    ('feq', -0.0, 'a') => ('feq', 'a', 0.0)
 *    ('ieq', ('ineg', 'a(is_not_const)'), '#b') => ('ieq', 'a', ('ineg', 'b'))
 *    ('ine', ('ineg', 'a(is_not_const)'), '#b') => ('ine', 'a', ('ineg', 'b'))
 *    ('ieq', ('inot', 'a(is_not_const)'), '#b') => ('ieq', 'a', ('inot', 'b'))
 *    ('ine', ('inot', 'a(is_not_const)'), '#b') => ('ine', 'a', ('inot', 'b'))
 *    ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0)
 *    ('ieq', ('bit_count(is_used_once)', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('bit_count(is_used_once)', 'a'), 0) => ('ine', 'a', 0)
 *    ('ieq', ('ineg', 'a'), ('ineg', 'b')) => ('ieq', 'a', 'b')
 *    ('ine', ('ineg', 'a'), ('ineg', 'b')) => ('ine', 'a', 'b')
 *    ('ieq', ('inot', 'a'), ('inot', 'b')) => ('ieq', 'a', 'b')
 *    ('ine', ('inot', 'a'), ('inot', 'b')) => ('ine', 'a', 'b')
 *    ('fneu', ('fabs', 'a'), 0.0) => ('fneu', 'a', 0.0)
 *    ('feq', ('fabs', 'a'), 0.0) => ('feq', 'a', 0.0)
 *    ('fneu', ('fabs', 'a'), ('fabs', 'a')) => ('fneu', 'a', 'a')
 *    ('feq', ('fabs', 'a'), ('fabs', 'a')) => ('feq', 'a', 'a')
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('bcsel(is_only_used_as_float)', ('feq', 'a', 'b(is_not_zero)'), 'b', 'a') => a
 *    ('bcsel(is_only_used_as_float)', ('fneu', 'a', 'b(is_not_zero)'), 'a', 'b') => a
 *    ('bcsel', ('feq', 'a', 0, 'ignore_exact'), 0, ('fsat', ('fmul', 'a', 'b(is_a_number)'))) => ('!fsat', ('fmul', 'a', 'b'))
 *    ('bcsel', ('fneu', 'a', 0, 'ignore_exact'), ('fsat', ('fmul', 'a', 'b(is_a_number)')), 0) => ('!fsat', ('fmul', 'a', 'b'))
 *    ('bcsel', ('feq', 'a', 0, 'ignore_exact'), 'b', ('fadd', 'a', 'b(is_not_zero)')) => ('fadd', 'a', 'b')
 *    ('bcsel', ('fneu', 'a', 0, 'ignore_exact'), ('fadd', 'a', 'b(is_not_zero)'), 'b') => ('fadd', 'a', 'b')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('flt', 0.0, ('b2f', 'a@1')) => a
 *    ('ieq', 'a@1', False) => ('inot', 'a')
 *    ('ieq', 'a@1', True) => a
 *    ('ine', 'a@1', False) => a
 *    ('ine', 'a@1', True) => ('inot', 'a')
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('ieq', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ine', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('bcsel', 'a', ('b2f', 'b@1'), 0) => ('b2f', ('bcsel', 'a', 'b', False))
 *    ('bcsel', 'a', ('b2f', 'b@1'), 1.0) => ('b2f', ('bcsel', 'a', 'b', True))
 *    ('bcsel', 'a', 0, ('b2f', 'b@1')) => ('b2f', ('bcsel', 'a', False, 'b'))
 *    ('bcsel', 'a', 1.0, ('b2f', 'b@1')) => ('b2f', ('bcsel', 'a', True, 'b'))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', True) => ('ior', ('inot', 'a'), 'b')
 *    ('bcsel', 'a', False, 'b') => ('iand', ('inot', 'a'), 'b')
 *    ('fmin', 'a', 'a') => ('fcanonicalize', 'a')
 *    ('fmax', 'a', 'a') => ('fcanonicalize', 'a')
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('fmin', ('fmax', 'a(is_finite)', 'b'), 'a') => ('fmul', 1.0, 'a')
 *    ('fmax', ('fmin', 'a(is_finite)', 'b'), 'a') => ('fmul', 1.0, 'a')
 *    ('umin', ('umax', 'a', 'b'), 'a') => a
 *    ('umax', ('umin', 'a', 'b'), 'a') => a
 *    ('imin', ('imax', 'a', 'b'), 'a') => a
 *    ('imax', ('imin', 'a', 'b'), 'a') => a
 *    ('fmax(nsz)', 'a(is_a_number_not_negative)', 'b(is_not_positive)') => ('fcanonicalize', 'a')
 *    ('fmin(nsz)', 'a(is_a_number_not_positive)', 'b(is_not_negative)') => ('fcanonicalize', 'a')
 *    ('fmax', 'a(is_a_number_not_negative)', 'b(is_lt_zero)') => ('fcanonicalize', 'a')
 *    ('fmin', 'a(is_a_number_not_positive)', 'b(is_gt_zero)') => ('fcanonicalize', 'a')
 *    ('fneg', ('fmax(is_used_once)', ('fneg', 'a'), ('fneg', 'b'))) => ('fmin', 'a', 'b')
 *    ('fneg', ('fmin(is_used_once)', ('fneg', 'a'), ('fneg', 'b'))) => ('fmax', 'a', 'b')
 *    ('fneg', ('fmax(is_used_once)', ('fneg', 'a'), '#b')) => ('fmin', 'a', ('fneg', 'b'))
 *    ('fneg', ('fmin(is_used_once)', ('fneg', 'a'), '#b')) => ('fmax', 'a', ('fneg', 'b'))
 *    ('fmin(nsz)', 'a', -0.0) => ('fmin', 'a', 0.0)
 *    ('fmax(nsz)', 'a', -0.0) => ('fmax', 'a', 0.0)
 *    ('ine', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('ine', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('ine', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ine', 'd', 'b'), ('ine', 'd', 'c'))
 *    ('ine', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ine', 'd', 'b'), ('ine', 'd', 'c'))
 *    ('ieq', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ieq', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ieq', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ieq', 'd', 'b'), ('ieq', 'd', 'c'))
 *    ('ieq', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ieq', 'd', 'b'), ('ieq', 'd', 'c'))
 *    ('ilt', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ilt', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ige', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('ult', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('uge', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('bitz', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('bitz', 'b', 'd'), ('bitz', 'c', 'd'))
 *    ('bitz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('bitz', 'b', 'd'), ('bitz', 'c', 'd'))
 *    ('bitz', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('bitz', 'd', 'b'), ('bitz', 'd', 'c'))
 *    ('bitz', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('bitz', 'd', 'b'), ('bitz', 'd', 'c'))
 *    ('bitnz', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('bitnz', 'b', 'd'), ('bitnz', 'c', 'd'))
 *    ('bitnz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('bitnz', 'b', 'd'), ('bitnz', 'c', 'd'))
 *    ('bitnz', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('bitnz', 'd', 'b'), ('bitnz', 'd', 'c'))
 *    ('bitnz', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('bitnz', 'd', 'b'), ('bitnz', 'd', 'c'))
 *    ('fneu', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('fneu', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('fneu', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fneu', 'd', 'b'), ('fneu', 'd', 'c'))
 *    ('fneu', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fneu', 'd', 'b'), ('fneu', 'd', 'c'))
 *    ('feq', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('feq', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('feq', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('feq', 'd', 'b'), ('feq', 'd', 'c'))
 *    ('feq', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('feq', 'd', 'b'), ('feq', 'd', 'c'))
 *    ('flt', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('flt', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('fge', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('fneo', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fneo', 'b', 'd'), ('fneo', 'c', 'd'))
 *    ('fneo', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fneo', 'b', 'd'), ('fneo', 'c', 'd'))
 *    ('fneo', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fneo', 'd', 'b'), ('fneo', 'd', 'c'))
 *    ('fneo', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fneo', 'd', 'b'), ('fneo', 'd', 'c'))
 *    ('fequ', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fequ', 'b', 'd'), ('fequ', 'c', 'd'))
 *    ('fequ', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fequ', 'b', 'd'), ('fequ', 'c', 'd'))
 *    ('fequ', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fequ', 'd', 'b'), ('fequ', 'd', 'c'))
 *    ('fequ', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fequ', 'd', 'b'), ('fequ', 'd', 'c'))
 *    ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fabs', 'a')) => ('fcanonicalize', 'a')
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('fmax', 'a', ('fneg', ('fabs', 'a'))) => ('fcanonicalize', 'a')
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat(nsz)', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('fmax', ('fsat(is_used_once)', 'a'), ('fsat(is_used_once)', 'b')) => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('~fsat', ('fadd', 1.0, 'a(is_not_negative)')) => 1.0
 *    ('fsat', ('fadd', 1.0, 'a(is_a_number_not_negative)')) => 1.0
 *    ('fneg', ('bcsel(is_used_once)', 'a', '#b', '#c')) => ('bcsel', 'a', ('fneg', 'b'), ('fneg', 'c'))
 *    ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a'))
 *    ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a'))
 *    ('fmax', ('fadd(is_used_once)', 'a(is_not_positive)', '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', 'a', 'b'))
 *    ('fmax', ('ffma(is_used_once)', 'a(is_not_positive)', 'b(is_not_negative)', '#c(is_zero_to_one)'), 0.0) => ('fsat', ('ffma', 'a', 'b', 'c'))
 *    ('fmax', ('ffma(is_used_once)', 'a', ('fneg', 'a'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('ffma', 'a', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fmax', 'a', 'b(is_not_positive)')) => ('fsat', 'a')
 *    ('fsat', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fsat', 'b'), ('fsat', 'c'))
 *    ('fsat', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fsat', 'b'), ('fsat', 'c'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('uge', 'a', 'b'), ('ult', 'a', 'b')) => False
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b')
 *    ('umin', ('iand', 'a', '#b(is_pos_power_of_two)'), ('iand', 'c', 'b')) => ('iand', ('iand', 'a', 'b'), ('iand', 'c', 'b'))
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('fmul', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')), ('i2f', ('iadd', ('b2i', ('flt', 0.0, 'a')), ('ineg', ('b2i', ('flt', 'a', 0.0)))))) => ('bcsel', ('!flt', 'a', 0.0), ('fneg', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b'))), ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('~f2f16', ('f2f', 'a')) => ('f2f16', 'a')
 *    ('~f2f16', ('u2f', 'a')) => ('u2f16', 'a')
 *    ('~f2f16', ('i2f', 'a')) => ('i2f16', 'a')
 *    ('~f2u16', ('f2f', 'a')) => ('f2u16', 'a')
 *    ('~f2i16', ('f2f', 'a')) => ('f2i16', 'a')
 *    ('i2f16', ('f2i', ('fsign', 'a@16'))) => ('fsign', 'a')
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('f2f16', ('f2f32', 'a@16')) => ('fcanonicalize', 'a')
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('f2f16', ('f2f64', 'a@16')) => ('fcanonicalize', 'a')
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('fmul', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')), ('i2f', ('iadd', ('b2i', ('flt', 0.0, 'a')), ('ineg', ('b2i', ('flt', 'a', 0.0)))))) => ('bcsel', ('!flt', 'a', 0.0), ('fneg', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b'))), ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('~f2f32', ('f2f', 'a')) => ('f2f32', 'a')
 *    ('~f2f32', ('u2f', 'a')) => ('u2f32', 'a')
 *    ('~f2f32', ('i2f', 'a')) => ('i2f32', 'a')
 *    ('~f2u32', ('f2f', 'a')) => ('f2u32', 'a')
 *    ('~f2i32', ('f2f', 'a')) => ('f2i32', 'a')
 *    ('i2f32', ('f2i', ('fsign', 'a@32'))) => ('fsign', 'a')
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('f2f32', ('f2f64', 'a@32')) => ('fcanonicalize', 'a')
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('fmul', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')), ('i2f', ('iadd', ('b2i', ('flt', 0.0, 'a')), ('ineg', ('b2i', ('flt', 'a', 0.0)))))) => ('bcsel', ('!flt', 'a', 0.0), ('fneg', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b'))), ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('~f2f64', ('f2f', 'a')) => ('f2f64', 'a')
 *    ('~f2f64', ('u2f', 'a')) => ('u2f64', 'a')
 *    ('~f2f64', ('i2f', 'a')) => ('i2f64', 'a')
 *    ('~f2u64', ('f2f', 'a')) => ('f2u64', 'a')
 *    ('~f2i64', ('f2f', 'a')) => ('f2i64', 'a')
 *    ('i2f64', ('f2i', ('fsign', 'a@64'))) => ('fsign', 'a')
 *    ('i2i1', ('i2i8', 'a@1')) => a
 *    ('u2u1', ('u2u8', 'a@1')) => a
 *    ('i2i1', ('i2i16', 'a@1')) => a
 *    ('u2u1', ('u2u16', 'a@1')) => a
 *    ('u2f16', ('u2u8', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i8', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u16', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@1')) => ('i2f16', 'a')
 *    ('i2i1', ('i2i32', 'a@1')) => a
 *    ('u2u1', ('u2u32', 'a@1')) => a
 *    ('u2f32', ('u2u8', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i8', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u16', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@1')) => ('i2f32', 'a')
 *    ('i2i1', ('i2i64', 'a@1')) => a
 *    ('u2u1', ('u2u64', 'a@1')) => a
 *    ('u2f64', ('u2u8', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i8', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u16', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@1')) => ('i2f64', 'a')
 *    ('i2i8', ('i2i16', 'a@8')) => a
 *    ('u2u8', ('u2u16', 'a@8')) => a
 *    ('u2f16', ('u2u16', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@8')) => ('i2f16', 'a')
 *    ('i2i8', ('i2i32', 'a@8')) => a
 *    ('u2u8', ('u2u32', 'a@8')) => a
 *    ('u2f32', ('u2u16', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@8')) => ('i2f32', 'a')
 *    ('i2i8', ('i2i64', 'a@8')) => a
 *    ('u2u8', ('u2u64', 'a@8')) => a
 *    ('u2f64', ('u2u16', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@8')) => ('i2f64', 'a')
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@16')) => ('i2f32', 'a')
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('u2f64', ('u2u32', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@16')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b')
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b')
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@8', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@8', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@8', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@8', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@8', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@8', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@8', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@8', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 1), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 3), 1)) => ('ushr', 'a', ('ishl', 'b', 1))
 *    ('ior', ('ilt(is_used_once)', 'a@8', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a@8', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a@8', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a@8', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a@8', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a@8', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a@8', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a@8', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a@8', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a@8', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a@8', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a@8', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a@8', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a@8', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a@8', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a@8', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@16', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@16', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@16', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@16', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@16', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@16', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@16', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@16', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 1), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 3), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('ior', ('ilt(is_used_once)', 'a@16', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a@16', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a@16', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a@16', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a@16', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a@16', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a@16', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a@16', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a@16', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a@16', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a@16', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a@16', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a@16', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a@16', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a@16', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a@16', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@32', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@32', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@32', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@32', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@32', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@32', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@32', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@32', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 1), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 3), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('ior', ('ilt(is_used_once)', 'a@32', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a@32', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a@32', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a@32', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a@32', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a@32', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a@32', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a@32', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a@32', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a@32', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a@32', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a@32', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a@32', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a@32', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a@32', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a@32', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@64', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@64', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@64', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@64', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@64', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@64', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@64', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@64', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 1), 5)) => ('ushr', 'a', ('ishl', 'b', 5))
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 3), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('ior', ('ilt(is_used_once)', 'a@64', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a@64', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a@64', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a@64', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a@64', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a@64', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a@64', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a@64', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a@64', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a@64', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a@64', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a@64', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a@64', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a@64', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a@64', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a@64', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', ('ieq', 'a', 0), ('ior', ('ieq', 'a', 1), 'b')) => ('ior', ('uge', 1, 'a'), 'b')
 *    ('ior', ('uge', 1, 'a'), ('ior', ('ieq', 'a', 2), 'b')) => ('ior', ('uge', 2, 'a'), 'b')
 *    ('ior', ('uge', 2, 'a'), ('ior', ('ieq', 'a', 3), 'b')) => ('ior', ('uge', 3, 'a'), 'b')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('uge', 'a', 1) => ('ine', 'a', 0)
 *    ('ult', 'a', 1) => ('ieq', 'a', 0)
 *    ('uge', 0, 'a') => ('ieq', 'a', 0)
 *    ('ult', 0, 'a') => ('ine', 'a', 0)
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('ishl', ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)), '#c') => ('bcsel', ('ige', ('iand', 'c', 31), ('find_lsb', 'b')), ('ishl', ('iand', 'a', 'b'), ('iadd', ('iand', 'c', 31), ('ineg', ('find_lsb', 'b')))), ('ushr', ('iand', 'a', 'b'), ('iadd', ('ineg', ('iand', 'c', 31)), ('find_lsb', 'b'))))
 *    ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)) => ('ushr', ('iand', 'a', 'b'), ('find_lsb', 'b'))
 *    ('ior', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('ior', ('b2i', 'a'), 'b'), 1)
 *    ('iand', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('b2i', 'a'), 'b')
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ieq', ('umin', '#a', 'b'), 0) => ('ior', ('ieq', 'a', 0), ('ieq', 'b', 0))
 *    ('ine', ('umax', '#a', 'b'), 0) => ('ior', ('ine', 'a', 0), ('ine', 'b', 0))
 *    ('ieq', ('umax', '#a', 'b'), 0) => ('iand', ('ieq', 'a', 0), ('ieq', 'b', 0))
 *    ('ine', ('umin', '#a', 'b'), 0) => ('iand', ('ine', 'a', 0), ('ine', 'b', 0))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ushr', ('iabs', 'a'), 'b')
 *    ('iabs', ('ushr', ('iabs', 'a'), 'b')) => ('ushr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('slt', 'a', -0.0) => ('slt', 'a', 0.0)
 *    ('slt', -0.0, 'a') => ('slt', 0.0, 'a')
 *    ('sge', 'a', -0.0) => ('sge', 'a', 0.0)
 *    ('sge', -0.0, 'a') => ('sge', 0.0, 'a')
 *    ('seq', 'a', -0.0) => ('seq', 'a', 0.0)
 *    ('sne', 'a', -0.0) => ('sne', 'a', 0.0)
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fall_equal8', 'a', 'b') => ('seq', ('fany_nequal8', 'a', 'b'), 0.0)
 *    ('fall_equal16', 'a', 'b') => ('seq', ('fany_nequal16', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal8', 'a', 'b') => ('fsat', ('fdot8', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal16', 'a', 'b') => ('fsat', ('fdot16', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('f2bf', 'a') => ('bcsel', ('!fneu', 'a', 'a'), -1, ('unpack_32_2x16_split_y', 'a'))
 *    ('bf2f', 'a') => ('pack_32_2x16', ('vec2', 0, 'a'))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('iand', ('ieq', 'a.y', 'b.y'), ('ieq', 'a.z', 'b.z')))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('ball_iequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h'))))
 *    ('ball_iequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('ieq', 'a.i', 'b.i'), ('ieq', 'a.j', 'b.j')), ('iand', ('ieq', 'a.k', 'b.k'), ('ieq', 'a.l', 'b.l'))), ('iand', ('iand', ('ieq', 'a.m', 'b.m'), ('ieq', 'a.n', 'b.n')), ('iand', ('ieq', 'a.o', 'b.o'), ('ieq', 'a.p', 'b.p')))))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('iand', ('feq', 'a.y', 'b.y'), ('feq', 'a.z', 'b.z')))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('ball_fequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h'))))
 *    ('ball_fequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('feq', 'a.i', 'b.i'), ('feq', 'a.j', 'b.j')), ('iand', ('feq', 'a.k', 'b.k'), ('feq', 'a.l', 'b.l'))), ('iand', ('iand', ('feq', 'a.m', 'b.m'), ('feq', 'a.n', 'b.n')), ('iand', ('feq', 'a.o', 'b.o'), ('feq', 'a.p', 'b.p')))))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ior', ('ine', 'a.y', 'b.y'), ('ine', 'a.z', 'b.z')))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('bany_inequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h'))))
 *    ('bany_inequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('ine', 'a.i', 'b.i'), ('ine', 'a.j', 'b.j')), ('ior', ('ine', 'a.k', 'b.k'), ('ine', 'a.l', 'b.l'))), ('ior', ('ior', ('ine', 'a.m', 'b.m'), ('ine', 'a.n', 'b.n')), ('ior', ('ine', 'a.o', 'b.o'), ('ine', 'a.p', 'b.p')))))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('ior', ('fneu', 'a.y', 'b.y'), ('fneu', 'a.z', 'b.z')))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('bany_fnequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h'))))
 *    ('bany_fnequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('fneu', 'a.i', 'b.i'), ('fneu', 'a.j', 'b.j')), ('ior', ('fneu', 'a.k', 'b.k'), ('fneu', 'a.l', 'b.l'))), ('ior', ('ior', ('fneu', 'a.m', 'b.m'), ('fneu', 'a.n', 'b.n')), ('ior', ('fneu', 'a.o', 'b.o'), ('fneu', 'a.p', 'b.p')))))
 *    ('bcsel@8', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel@8', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel@8', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel@8', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel@16', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel@16', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel@16', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel@32', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel@32', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel@64', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel@64', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), 'b') => ('bcsel', 'a', 'b', 0)
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('bcsel', 'a', ('b2i', 'b@1'), ('b2i', 'c@1')) => ('b2i', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('b2i', 'b@1'), 0) => ('b2i', ('bcsel', 'a', 'b', False))
 *    ('bcsel', 'a', ('b2i', 'b@1'), 1) => ('b2i', ('bcsel', 'a', 'b', True))
 *    ('bcsel', 'a', 0, ('b2i', 'b@1')) => ('b2i', ('bcsel', 'a', False, 'b'))
 *    ('bcsel', 'a', 1, ('b2i', 'b@1')) => ('b2i', ('bcsel', 'a', True, 'b'))
 *    ('bcsel', 'a', ('ineg', ('b2i', 'b@1')), ('ineg', ('b2i', 'c@1'))) => ('ineg', ('b2i', ('bcsel', 'a', 'b', 'c')))
 *    ('bcsel', 'a', ('ineg', ('b2i', 'b@1')), 0) => ('ineg', ('b2i', ('bcsel', 'a', 'b', False)))
 *    ('bcsel', 'a', ('ineg', ('b2i', 'b@1')), -1) => ('ineg', ('b2i', ('bcsel', 'a', 'b', True)))
 *    ('bcsel', 'a', 0, ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('bcsel', 'a', False, 'b')))
 *    ('bcsel', 'a', -1, ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('bcsel', 'a', True, 'b')))
 *    ('inot', ('ineg', ('b2i', 'a'))) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('ishl', ('ineg', ('b2i', 'a')), '#b') => ('iand', ('ishl', -1, 'b'), ('ineg', ('b2i', 'a')))
 *    ('ushr', ('ineg', ('b2i', 'a')), '#b') => ('iand', ('ushr', -1, 'b'), ('ineg', ('b2i', 'a')))
 *    ('ine', ('b2i', 'a@1'), ('ineg', ('b2i', 'b@1'))) => ('ior', 'a', 'b')
 *    ('ieq', ('b2i', 'a@1'), ('ineg', ('b2i', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('iand', ('ior', ('b2i', 'a@1'), ('ineg', ('b2i', 'b@1'))), 1) => ('b2i', ('ior', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('iand', ('iand', ('b2i', 'a@1'), ('ineg', ('b2i', 'b@1'))), 1) => ('b2i', ('iand', 'a', 'b'))
 *    ('ixor', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('ixor', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ixor', 'a', 'b')))
 *    ('iand', ('ixor', ('b2i', 'a@1'), ('ineg', ('b2i', 'b@1'))), 1) => ('b2i', ('ixor', 'a', 'b'))
 *    ('feq', ('seq', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('seq', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('ffma', ('b2f', 'a@1'), ('b2f', 'b@1'), 'c') => ('fadd', ('b2f', ('iand', 'a', 'b')), 'c')
 *    ('fmul', ('b2f', ('fneu', 'a', 0)), 'a') => ('fmul', 1.0, 'a')
 *    ('ffma', ('b2f', ('fneu', 'a', 0)), 'a', 'b') => ('fadd', 'a', 'b')
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', 0) => 0
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', ('inot', 'a')) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', -1) => -1
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('ixor', 'a', ('ixor', 'a', 'b')) => b
 *    ('ixor', 'a', -1) => ('inot', 'a')
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('iand', 'b', 'c'))
 *    ('iand@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', 0, ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), 0)
 *    ('iand@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', -1, ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), -1)
 *    ('ixor@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ixor', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ixor@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ixor', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', -1, 'a') => -1
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ushr', 'a', 'b')) => ('ushr', 'a', 'b')
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ishr', 'a', 'b')) => ('ishr', 'a', 'b')
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ishl', 'a', 'b')) => ('ishl', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ushr', 'a', 'b'), 'a') => ('ushr', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ishr', 'a', 'b'), 'a') => ('ishr', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ishl', 'a', 'b'), 'a') => ('ishl', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@8', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 8, 'b')))
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('urol@64', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 64, 'b')))
 *    ('uror@8', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 8, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('uror@64', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 64, 'b')))
 *    ('bitfield_select', 4278190080, ('ishl', 'b@32', 24), ('ushr', 'a', 8)) => ('shfr', 'b', 'a', 8)
 *    ('bitfield_select', 4294901760, ('ishl', 'b@32', 16), ('extract_u16', 'a', 1)) => ('shfr', 'b', 'a', 16)
 *    ('bitfield_select', 4294967040, ('ishl', 'b@32', 8), ('extract_u8', 'a', 3)) => ('shfr', 'b', 'a', 24)
 *    ('ior', ('ishl', 'b@32', 24), ('ushr', 'a', 8)) => ('shfr', 'b', 'a', 8)
 *    ('ior', ('ishl', 'b@32', 16), ('extract_u16', 'a', 1)) => ('shfr', 'b', 'a', 16)
 *    ('ior', ('ishl', 'b@32', 8), ('extract_u8', 'a', 3)) => ('shfr', 'b', 'a', 24)
 *    ('bcsel', ('ieq', 'c', 0), 'a', ('ior', ('ishl', 'b@32', ('iadd', 32, ('ineg', 'c'))), ('ushr@32', 'a', 'c'))) => ('shfr', 'b', 'a', 'c')
 *    ('bcsel', ('ine', 'c', 0), ('ior', ('ishl', 'b@32', ('iadd', 32, ('ineg', 'c'))), ('ushr@32', 'a', 'c')), 'a') => ('shfr', 'b', 'a', 'c')
 *    ('ior', ('ishl', 'a@32', ('iadd', 32, ('ineg', 'b'))), ('ushr@32', 'a', 'b')) => ('shfr', 'a', 'a', 'b')
 *    ('bfi', 4294967295, 'a', 'b') => a
 *    ('bfi', 0, 'a', 'b') => b
 *    ('bfi', ('ineg', ('b2i', 'a@1')), 'b', 'c') => ('bcsel', 'a', 'b', 'c')
 *    ('bfi', 'a', 0, 'b') => ('iand', ('inot', 'a'), 'b')
 *    ('bfi', '#a(is_odd)', 'b', 'b') => b
 *    ('bfi', '#a(is_odd)', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bfi', '#a(is_odd)', 'b', 0) => ('iand', 'a', 'b')
 *    ('bfi', '#a(is_odd)', 'b', 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('u2f32', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), ('iand', 'b', 1), ('u2f', 'a'))
 *    ('u2f', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), 0, ('u2f', 'a'))
 *    ('~fexp2', ('flog2', 'a')) => ('fcanonicalize', 'a')
 *    ('~flog2', ('fexp2', 'a')) => ('fcanonicalize', 'a')
 *    ('fpow@32', 'a', 'b') => ('fexp2', ('fmulz', ('flog2', 'a'), 'b'))
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 3.0)) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 5.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 6.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 8.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')))
 *    ('~fpow', 'a', 1.0) => ('fcanonicalize', 'a')
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 3.0) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => ('fcanonicalize', 'a')
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => ('fcanonicalize', 'a')
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('fcsel', 'a', 'b', 'b') => ('fcanonicalize', 'b')
 *    ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('umax', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('umin', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a'), 1) => ('b2i', 'a')
 *    ('ine', ('umin', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('iand', 'a', ('ine', 'b', 0))
 *    ('ine', ('umax', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('ior', 'a', ('ine', 'b', 0))
 *    ('ine', ('umin', ('b2i', 'a@1'), 'b'), 0) => ('iand', 'a', ('ine', 'b', 0))
 *    ('ine', ('umax', ('b2i', 'a@1'), 'b'), 0) => ('ior', 'a', ('ine', 'b', 0))
 *    ('ieq', ('umin', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('ior', ('inot', 'a'), ('ieq', 'b', 0))
 *    ('ieq', ('umax', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('iand', ('inot', 'a'), ('ieq', 'b', 0))
 *    ('ieq', ('umin', ('b2i', 'a@1'), 'b'), 0) => ('ior', ('inot', 'a'), ('ieq', 'b', 0))
 *    ('ieq', ('umax', ('b2i', 'a@1'), 'b'), 0) => ('iand', ('inot', 'a'), ('ieq', 'b', 0))
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a(is_not_negative)')) => ('f2u', 'a')
 *    ('f2i', ('ffloor', 'a(is_not_negative)')) => ('f2i', 'a')
 *    ('f2u', ('ffloor', 'a')) => ('f2u', 'a')
 *    ('f2u', 'a(is_not_positive)') => 0
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('f2i32', ('f2fmp', 'a@32')) => ('f2i32', 'a')
 *    ('f2u32', ('f2fmp', 'a@32')) => ('f2u32', 'a')
 *    ('i2f32', ('i2imp', 'a@32')) => ('i2f32', 'a')
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('fround_even', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('ffract', ('ffract', 'a')) => ('ffract', 'a')
 *    ('fabs', 'a(is_not_negative)') => ('fcanonicalize', 'a')
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('fmin', 'a(is_a_number_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32', 'a')) => a.x
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32', 'a')) => a.y
 *    ('unpack_64_2x32_split_x', ('u2u64', 'a@32')) => a
 *    ('unpack_64_2x32_split_x', ('i2i64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('i2i64(is_used_once)', 'a@32')) => ('ishr', 'a', 31)
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32', 'a'), ('unpack_64_2x32.y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('unpack_32_2x16_split_x', ('pack_32_2x16_split', 'a', 'b')) => a
 *    ('unpack_32_2x16_split_y', ('pack_32_2x16_split', 'a', 'b')) => b
 *    ('unpack_32_2x16_split_x', ('pack_32_2x16', 'a')) => a.x
 *    ('unpack_32_2x16_split_y', ('pack_32_2x16', 'a')) => a.y
 *    ('unpack_32_2x16_split_x', ('u2u32', 'a@16')) => a
 *    ('unpack_32_2x16_split_x', ('i2i32', 'a@16')) => a
 *    ('unpack_32_2x16_split_y', ('i2i32(is_used_once)', 'a@16')) => ('ishr', 'a', 15)
 *    ('unpack_32_2x16', ('pack_32_2x16_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_32_2x16', ('pack_32_2x16', 'a')) => a
 *    ('pack_32_2x16_split', ('unpack_32_2x16_split_x', 'a'), ('unpack_32_2x16_split_y', 'a')) => a
 *    ('pack_32_2x16_split', ('unpack_32_2x16', 'a'), ('unpack_32_2x16.y', 'a')) => a
 *    ('pack_32_2x16', ('vec2', ('unpack_32_2x16_split_x', 'a'), ('unpack_32_2x16_split_y', 'a'))) => a
 *    ('pack_32_2x16', ('unpack_32_2x16', 'a')) => a
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a@1')) => 0
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a@8')) => 0
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a@16')) => 0
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a@32')) => 0
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_4x16', 'a')) => a
 *    ('pack_64_4x16', ('unpack_64_4x16', 'a')) => a
 *    ('unpack_32_4x8', ('pack_32_4x8', 'a')) => a
 *    ('pack_32_4x8', ('unpack_32_4x8', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_2x32', ('vec2', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd')))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('unpack_64_4x16', ('pack_64_2x32_split', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd'))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('pack_64_2x32_split', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd')) => ('pack_64_4x16', ('vec4', 'a', 'b', 'c', 'd'))
 *    ('pack_64_2x32', ('vec2', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd'))) => ('pack_64_4x16', ('vec4', 'a', 'b', 'c', 'd'))
 *    ('pack_64_2x32', ('vec2', ('pack_32_2x16', ('vec2', 'a', 'b')), ('pack_32_2x16', ('vec2', 'c', 'd')))) => ('pack_64_4x16', ('vec4', 'a', 'b', 'c', 'd'))
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('ishr', ('iand', 'a@32', 65280), 8) => ('extract_u8', 'a', 1)
 *    ('ishr', ('iand', 'a@64', 65280), 8) => ('extract_u8', 'a', 1)
 *    ('ishr', ('iand', 'a', 16711680), 16) => ('extract_u8', 'a', 2)
 *    ('u2u8', ('extract_u16', 'a', 1)) => ('u2u8', ('extract_u8', 'a', 2))
 *    ('u2u8', ('ushr', 'a', 8)) => ('u2u8', ('extract_u8', 'a', 1))
 *    ('i2i16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('i2i16', ('extract_i8', 'a', 'b'))
 *    ('u2u16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('u2u16', ('extract_u8', 'a', 'b'))
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_i8', ('iand', 'a', 65280), 1) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('iand', 'a', 16711680), 2) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('iand', 'a', 4278190080), 3) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('iand', 'a', 65280), 1) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('iand', 'a', 16711680), 2) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('iand', 'a', 4278190080), 3) => ('extract_u8', 'a', 3)
 *    ('ior', ('bcsel', ('ieq', ('iand', 'a', 128), 0), 0, -256), ('extract_u8', 'a', 0)) => ('extract_i8', 'a', 0)
 *    ('ior', ('bcsel', ('ieq', ('iand', 'a', 32768), 0), 0, -256), ('extract_u8', 'a', 1)) => ('extract_i8', 'a', 1)
 *    ('ior', ('bcsel', ('ieq', ('iand', 'a', 8388608), 0), 0, -256), ('extract_u8', 'a', 2)) => ('extract_i8', 'a', 2)
 *    ('ior', ('bcsel', ('ige', 'a@32', 0), 0, -256), ('extract_u8', 'a', 3)) => ('extract_i8', 'a', 3)
 *    ('ior', ('bcsel', ('ine', ('iand', 'a', 128), 0), -256, 0), ('extract_u8', 'a', 0)) => ('extract_i8', 'a', 0)
 *    ('ior', ('bcsel', ('ine', ('iand', 'a', 32768), 0), -256, 0), ('extract_u8', 'a', 1)) => ('extract_i8', 'a', 1)
 *    ('ior', ('bcsel', ('ine', ('iand', 'a', 8388608), 0), -256, 0), ('extract_u8', 'a', 2)) => ('extract_i8', 'a', 2)
 *    ('ior', ('bcsel', ('ilt', 'a@32', 0), -256, 0), ('extract_u8', 'a', 3)) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ushr', 'a', 8), 0) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ushr', 'a', 8), 1) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ushr', 'a', 8), 2) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a', 8), 1) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a', 8), 2) => ('extract_u8', 'a', 3)
 *    ('extract_i8', ('extract_i16', 'a', 1), 0) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('extract_i16', 'a', 1), 1) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('extract_u16', 'a', 1), 0) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('extract_u16', 'a', 1), 1) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('extract_i16', 'a', 1), 1) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('extract_u16', 'a', 1), 1) => ('extract_u8', 'a', 3)
 *    ('iand', ('extract_u8', 'a', 0), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('iand', ('extract_u16', 'a', 0), '#b') => ('iand', 'a', ('iand', 'b', 65535))
 *    ('ieq', ('iand', ('extract_u8', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('iand', 'c', 255), ('imul', ('i2i32', 'b'), 8))), 0)
 *    ('ine', ('iand', ('extract_u8', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('iand', 'c', 255), ('imul', ('i2i32', 'b'), 8))), 0)
 *    ('ieq', ('iand', ('extract_u16(is_used_once)', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('iand', 'c', 65535), ('imul', ('i2i32', 'b'), 16))), 0)
 *    ('ine', ('iand', ('extract_u16(is_used_once)', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('iand', 'c', 65535), ('imul', ('i2i32', 'b'), 16))), 0)
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('ior', ('ishl', ('u2u32', 'a@8'), 24), ('ior', ('ishl', ('u2u32', 'b@8'), 16), ('ior', ('ishl', ('u2u32', 'c@8'), 8), ('u2u32', 'd@8')))) => ('pack_32_4x8', ('vec4', 'd', 'c', 'b', 'a'))
 *    ('ior', ('ishl', 'a', 16), ('u2u32', 'b@16')) => ('pack_32_2x16_split', 'b', ('u2u16', 'a'))
 *    ('ior', ('u2u16', ('unpack_32_4x8', 'a')), ('ishl', ('u2u16', ('unpack_32_4x8.y', 'a')), 8)) => ('unpack_32_2x16_split_x', 'a')
 *    ('ior', ('u2u16', ('unpack_32_4x8.z', 'a')), ('ishl', ('u2u16', ('unpack_32_4x8.w', 'a')), 8)) => ('unpack_32_2x16_split_y', 'a')
 *    ('i2i16', ('unpack_32_4x8(xz_components_unused).y', 'a')) => ('extract_i8', ('unpack_32_2x16.x', 'a'), 1)
 *    ('i2i16', ('unpack_32_4x8(xz_components_unused).w', 'a')) => ('extract_i8', ('unpack_32_2x16.y', 'a'), 1)
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_i16', ('iand', 'a', 16711680), 1) => ('extract_u8', 'a', 2)
 *    ('extract_u16', ('iand', 'a', 16711680), 1) => ('extract_u8', 'a', 2)
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('pack_half_2x16_split', 'a', 'b') => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_64_2x32_split_x', ('ushr', 'a', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('u2u32', ('ushr', 'a@64', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('ishl', ('pack_half_2x16_rtz_split', 'a', 0), 16) => ('pack_half_2x16_rtz_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_rtz_split', 0, 'a'), 16) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_rtz_split', 0, 'a'), 1) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('iadd', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('pack_uint_2x16', ('vec2', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 'b', 0))) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('bfi', 4294901760, ('pack_half_2x16_split', 'a', 'b'), ('pack_half_2x16_split', 'c', 'd')) => ('pack_half_2x16_split', 'c', 'a')
 *    ('iand', ('bfi', 15, '#a', 'b'), 4294967292) => ('bfi', 15, ('iand', 'a', 4294967292), 'b')
 *    ('iand', ('bfi', 7, '#a', 'b'), 4294967292) => ('bfi', 7, ('iand', 'a', 4294967292), 'b')
 *    ('umin', ('ishl', ('iand', 'a', 15), 3), 120) => ('ishl', ('iand', 'a', 15), 3)
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('i2i', 'a')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('i2i', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('i2i', 'c')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('i2i', 'd')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('u2u', 'a')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('u2u', 'b')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('u2u', 'c')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('u2u', 'd')
 *    ('u2u32', ('iadd(is_used_once)', 'a@64', 'b')) => ('iadd', ('u2u32', 'a'), ('u2u32', 'b'))
 *    ('u2u32', ('imul(is_used_once)', 'a@64', 'b')) => ('imul', ('u2u32', 'a'), ('u2u32', 'b'))
 *    ('u2f32', ('u2u64', 'a@32')) => ('u2f32', 'a')
 *    ('ult', 4294967295, 'a@64') => ('ine', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('i2i16', ('u2u8', ('iand', 'a@16', 1))) => ('iand', 'a@16', 1)
 *    ('u2u16', ('u2u8', ('iand', 'a@16', 1))) => ('iand', 'a@16', 1)
 *    ('u2u32', ('ushr', ('ior', ('ishl', 'a', 32), ('u2u64', 'b@8')), 32)) => ('u2u32', 'a')
 *    ('u2u32', ('ushr', ('ior', ('ishl', 'a', 32), ('u2u64', 'b@16')), 32)) => ('u2u32', 'a')
 *    ('u2u32', ('ushr', ('ior', ('ishl', 'a', 32), ('u2u64', 'b@32')), 32)) => ('u2u32', 'a')
 *    ('u2u16', ('ushr', ('ior', ('ishl', 'a', 16), ('u2u32', 'b@8')), 16)) => ('u2u16', 'a')
 *    ('u2u16', ('ushr', ('ior', ('ishl', 'a', 16), ('u2u32', 'b@16')), 16)) => ('u2u16', 'a')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ieq', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ieq', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ieq', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ieq', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ine', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ine', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ine', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ine', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ult', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ult', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ult', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ilt', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ilt', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ilt', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ilt', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('uge', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('uge', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('uge', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ige', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ige', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ige', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ige', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ige', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('bitz', 'a', 'b') => ('inot', ('bitnz', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('fmulz(is_used_by_non_fsat,nsz)', ('fneg', 'a'), 'b') => ('fneg', ('fmulz', 'a', 'b'))
 *    ('ffma', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)') => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~ffma', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffma', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)', 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('ffma(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffma', 'a', 'b', 'd'), 'c')
 *    ('~fadd(is_used_once)', ('ffmaz(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffmaz', 'a', 'b', 'd'), 'c')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz', '#a', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('~ffma', '#a', ('fmul', 'b(is_not_const)', '#c'), 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('~fadd', '#a', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffma', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffma', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('~fadd', '#a', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffmaz', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffmaz', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('ior', ('iand', 'a', '#c'), ('ior', 'b', ('iand', 'a', '#d'))) => ('ior', 'b', ('iand', 'a', ('ior', 'c', 'd')))
 *    ('~fadd', ('fadd(is_used_once)', 'a(is_fmul)', 'b(is_fmul)'), 'c(is_not_fmul)') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb_rev', 'a'), 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ige', ('ufind_msb_rev', 'a'), 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), ('ifind_msb', 'a')) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), ('ifind_msb', 'a'), ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), ('ifind_msb_rev', 'a')) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), ('ifind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('iand', 'a', ('inot', ('ishl', 1, ('find_lsb', 'a')))) => ('iand', 'a', ('inot', ('ineg', 'a')))
 *    ('find_lsb', ('bitfield_reverse', 'a@32')) => ('ufind_msb_rev', 'a')
 *    ('ufind_msb_rev', ('bitfield_reverse', 'a@32')) => ('find_lsb', 'a')
 *    ('ifind_msb', ('f2i32(is_used_once)', 'a')) => ('ufind_msb', ('f2i32', ('fabs', 'a')))
 *    ('ifind_msb', ('extract_u8', 'a', 'b')) => ('ufind_msb', ('extract_u8', 'a', 'b'))
 *    ('ifind_msb', ('extract_u16', 'a', 'b')) => ('ufind_msb', ('extract_u16', 'a', 'b'))
 *    ('ifind_msb', ('imax', 'a', 1)) => ('ufind_msb', ('imax', 'a', 1))
 *    ('fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), ('fcanonicalize', 'b'))
 *    ('fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fneg', 'b'))
 *    ('fmulz(nsz)', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), ('fcanonicalize', 'b'))
 *    ('fmulz(nsz)', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fneg', 'b'))
 *    ('fabs', ('bcsel(is_used_once)', 'b', ('fneg', 'a'), 'a')) => ('fabs', 'a')
 *    ('fabs', ('bcsel(is_used_once)', 'b', 'a', ('fneg', 'a'))) => ('fabs', 'a')
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'd', 'c'), 'd') => ('bcsel', ('iand', 'a', ('inot', 'b')), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel(is_used_once)', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel(is_used_once)', 'c', 'd', 'b')) => ('bcsel', ('iand', 'c', ('inot', 'a')), 'd', 'b')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('imul_32x16', 'a', 'b') => ('imul', 'a', ('extract_i16', 'b', 0))
 *    ('umul_32x16', 'a', 'b') => ('imul', 'a', ('extract_u16', 'b', 0))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ibitfield_extract', 'value@32', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value@32', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', 0, 'b') => ('iand', ('inot', 'a'), 'b')
 *    ('bitfield_select', 0, 'a', 'b') => b
 *    ('bitfield_select', 'a', 'b', -1) => ('ior', ('inot', 'a'), 'b')
 *    ('bitfield_select', 'a', -1, 'b') => ('ior', 'a', 'b')
 *    ('bitfield_select', -1, 'a', 'b') => a
 *    ('bitfield_select', 'a', 'b', 'b') => b
 *    ('bitfield_select', 'a', ('inot', 'b'), 'b') => ('ixor', 'a', 'b')
 *    ('bitfield_select', 'a', 'b', ('inot', 'b')) => ('inot', ('ixor', 'a', 'b'))
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('bitfield_select', 'a', 'b', ('iand', ('inot', 'a'), 'c')) => ('bitfield_select', 'a', 'b', 'c')
 *    ('bitfield_select', ('inot', 'a'), 'b', 'c') => ('bitfield_select', 'a', 'c', 'b')
 *    ('bitfield_select', ('ineg', ('b2i', 'a@1')), 'b', 'c') => ('bcsel', 'a', 'b', 'c')
 *    ('ior', ('iand', 'a', 'b'), ('iand', ('inot', 'a'), 'c')) => ('bitfield_select', 'a', 'b', 'c')
 *    ('iadd', ('iand', 'a', 'b'), ('iand', ('inot', 'a'), 'c')) => ('bitfield_select', 'a', 'b', 'c')
 *    ('ixor', ('iand', 'a', 'b'), ('iand', ('inot', 'a'), 'c')) => ('bitfield_select', 'a', 'b', 'c')
 *    ('ixor', ('iand', 'a', ('ixor', 'b', 'c')), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('bitfield_select@1', 'a', 'b', 'c') => ('bcsel', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ult', 'a', ('umin', ('iand', 'a', 'b'), 'c')) => False
 *    ('ult', 31, ('umin', '#bits(is_ult_32)', 'a')) => False
 *    ('ubfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ubfe', 'value', 'offset', 'width')
 *    ('ibfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ibfe', 'value', 'offset', 'width')
 *    ('bfm', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset')))), 'offset') => ('bfm', 'width', 'offset')
 *    ('iadd@32', ('ishl', 1, 'a'), -1) => ('bfm', 'a', 0)
 *    ('ishl', ('bfm', 'a', 0), 'b') => ('bfm', 'a', 'b')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('ine', ('ubfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('ine', ('ibfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('iand(is_used_once)', ('ushr', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ishl', 'c', 'b')), 0)
 *    ('ine', ('iand(is_used_once)', ('ishl', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ushr', 'c', 'b')), 0)
 *    ('ieq', ('iand(is_used_once)', ('ushr', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', 'c', 'b')), 0)
 *    ('ieq', ('iand(is_used_once)', ('ishl', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ushr', 'c', 'b')), 0)
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ifind_msb', 'value') => ('isub', 31, ('uclz', ('ixor', 'value', ('ishr', 'value', 31))))
 *    ('ufind_msb', 'value@32') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('ufind_msb', 'value@32') => ('isub', 31, ('uclz', 'value'))
 *    ('uclz', 'a') => ('umin', 32, ('ufind_msb_rev', 'a'))
 *    ('find_lsb', 'value@64') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('find_lsb', 'value') => ('ufind_msb', ('u2u32', ('iand', 'value', ('ineg', 'value'))))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_32_4x8', ('f2u8', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_32_4x8', ('f2i8', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('fmul', 1.0, ('u2u16', 'a')))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('fmul', 1.0, ('u2u16', ('ushr', 'a', 16))))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('fsign', 'a@64') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('amul', ('udiv_aligned_4', 'a'), 4) => a
 *    ('imul', ('udiv_aligned_4', 'a'), 4) => a
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('imul_high@16', 'a', 'b') => ('i2i16', ('ishr', ('imul24_relaxed', ('i2i32', 'a'), ('i2i32', 'b')), 16))
 *    ('umul_high@16', 'a', 'b') => ('u2u16', ('ushr', ('umul24_relaxed', ('u2u32', 'a'), ('u2u32', 'b')), 16))
 *    ('b2i16', ('vec2', ('ult', 'a@16', 'b'), ('ult', 'c@16', 'd'))) => ('umin', 1, ('usub_sat', ('vec2', 'b', 'd'), ('vec2', 'a', 'c')))
 *    ('b2i16', ('vec2', ('uge', 'a@16', '#b(is_not_zero)'), ('uge', 'c@16', '#d(is_not_zero)'))) => ('umin', 1, ('usub_sat', ('vec2', 'a', 'c'), ('iadd', ('vec2', 'b', 'd'), -1)))
 *    ('b2i16', ('vec2', ('uge', '#a(is_not_uint_max)', 'b@16'), ('uge', '#c(is_not_uint_max)', 'd@16'))) => ('umin', 1, ('usub_sat', ('iadd', ('vec2', 'a', 'c'), 1), ('vec2', 'b', 'd')))
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bitfield_insert', 'base@32', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('bitfield_insert', 'base@32', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ibitfield_extract', 'value@8', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 8, 'bits'), 'offset')), ('isub', 8, 'bits')))
 *    ('ubitfield_extract', 'value@8', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 8), -1, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ibitfield_extract', 'value@16', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 16, 'bits'), 'offset')), ('isub', 16, 'bits')))
 *    ('ubitfield_extract', 'value@16', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 16), -1, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ibitfield_extract', 'value@32', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value@32', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), -1, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('bitfield_insert', 'base@8', 'insert', 'offset', 'bits') => ('bitfield_select', ('u2u8', ('bfm', 'bits', 'offset')), ('ishl', 'insert', 'offset'), 'base')
 *    ('bitfield_insert', 'base@8', 'insert', 'offset', 'bits') => ('u2u8', ('bfi', ('bfm', 'bits', 'offset'), ('u2u32', 'insert'), ('u2u32', 'base')))
 *    ('bitfield_insert', 'base@8', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 7, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base@16', 'insert', 'offset', 'bits') => ('bitfield_select', ('u2u16', ('bfm', 'bits', 'offset')), ('ishl', 'insert', 'offset'), 'base')
 *    ('bitfield_insert', 'base@16', 'insert', 'offset', 'bits') => ('u2u16', ('bfi', ('bfm', 'bits', 'offset'), ('u2u32', 'insert'), ('u2u32', 'base')))
 *    ('bitfield_insert', 'base@16', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 15, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base@32', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base@64', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 63, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq(is_used_once)', 'a', 'b'), ('feq(is_used_once)', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq(is_used_once)', 'a', 'b'), ('feq(is_used_once)', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq(is_used_once)', 'a', 'b'), ('fneu(is_used_once)', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq(is_used_once)', 'a', 'b'), ('fneu(is_used_once)', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu(is_used_once)', 'a', 'b'), ('fneu(is_used_once)', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu(is_used_once)', 'a', 'b'), ('fneu(is_used_once)', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('f2f16', ('fmax(is_used_once)', 'a', '#b')) => ('fmax', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2f16', ('fmin(is_used_once)', 'a', '#b')) => ('fmin', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2f16', ('vec2(is_used_once)', ('fmax(is_used_once)', 'a', '#b'), ('fmax(is_used_once)', 'c', '#d'))) => ('fmax', ('f2f16', ('vec2', 'a', 'c')), ('f2f16', ('vec2', 'b', 'd')))
 *    ('f2f16', ('vec2(is_used_once)', ('fmin(is_used_once)', 'a', '#b'), ('fmin(is_used_once)', 'c', '#d'))) => ('fmin', ('f2f16', ('vec2', 'a', 'c')), ('f2f16', ('vec2', 'b', 'd')))
 *    ('pack_half_2x16_rtz_split', ('fmax(is_used_once)', 'a', '#b'), ('fmax(is_used_once)', 'c', '#d')) => ('pack_32_2x16', ('fmax', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'a', 'c')), ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'b', 'd'))))
 *    ('pack_half_2x16_rtz_split', ('fmin(is_used_once)', 'a', '#b'), ('fmin(is_used_once)', 'c', '#d')) => ('pack_32_2x16', ('fmin', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'a', 'c')), ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'b', 'd'))))
 *    ('pack_half_2x16_rtz_split', ('fneg(is_used_once)', ('fmax(is_used_once)', 'a', '#b')), ('fneg(is_used_once)', ('fmax(is_used_once)', 'c', '#d'))) => ('pack_32_2x16', ('fmin', ('fneg', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'a', 'c'))), ('fneg', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'b', 'd')))))
 *    ('pack_half_2x16_rtz_split', ('fneg(is_used_once)', ('fmin(is_used_once)', 'a', '#b')), ('fneg(is_used_once)', ('fmin(is_used_once)', 'c', '#d'))) => ('pack_32_2x16', ('fmax', ('fneg', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'a', 'c'))), ('fneg', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'b', 'd')))))
 *    ('pack_half_2x16_rtz_split', ('bcsel(is_used_once)', 'a', 'b', '#c'), ('bcsel(is_used_once)', 'a', 'd', '#e')) => ('bcsel', 'a', ('pack_half_2x16_rtz_split', 'b', 'd'), ('pack_half_2x16_rtz_split', 'c', 'e'))
 *    ('pack_half_2x16_rtz_split', ('bcsel(is_used_once)', 'a', '#b', 'c'), ('bcsel(is_used_once)', 'a', '#d', 'e')) => ('bcsel', 'a', ('pack_half_2x16_rtz_split', 'b', 'd'), ('pack_half_2x16_rtz_split', 'c', 'e'))
 *    ('pack_half_2x16_rtz_split', ('b2f', 'a@1'), ('b2f', 'a')) => ('bcsel', 'a', 1006648320, 0)
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('!fmul', ('!fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('!fmul', ('!fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('!fmul', ('!fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('iadd(many-comm-expr)', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('bcsel', ('iand', ('fneu', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('fneu', 'x', 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('fneu', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 4294967295), ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)) => ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)
 *    ('iadd(many-comm-expr)', ('iadd', ('iadd', ('bcsel', ('ieq', ('extract_u8', 'a@32', 0), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 0), ('ineg', ('extract_u8', 'b@32', 0))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 1), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 1), ('ineg', ('extract_u8', 'b@32', 1)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 2), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 2), ('ineg', ('extract_u8', 'b@32', 2)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 3), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 3), ('ineg', ('extract_u8', 'b@32', 3)))))) => ('msad_4x8', 'a', 'b', 0)
 *    ('iadd', ('msad_4x8', 'a', 'b', 0), 'c') => ('msad_4x8', 'a', 'b', 'c')
 *    ('f2e4m3fn_sat', ('bcsel', ('feq', ('fabs', 'a'), inf), '#b(is_nan)', 'a')) => ('f2e4m3fn_satfn', 'a')
 *    ('f2e4m3fn_sat', ('bcsel', ('feq', 'a(is_not_negative)', inf), '#b(is_nan)', 'a')) => ('f2e4m3fn_satfn', 'a')
 *    ('f2e4m3fn_sat', ('bcsel', ('feq', 'a(is_not_positive)', -inf), '#b(is_nan)', 'a')) => ('f2e4m3fn_satfn', 'a')
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', ('fabs', 'a'), inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', ('fabs', 'c'), inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', ('fabs', 'a'), inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_negative)', inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', ('fabs', 'a'), inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_positive)', -inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_negative)', inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', ('fabs', 'c'), inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_negative)', inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_negative)', inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_negative)', inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_positive)', -inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_positive)', -inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', ('fabs', 'c'), inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_positive)', -inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_negative)', inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_positive)', -inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_positive)', -inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('fmulz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmulz', 'b', 'd'), ('fmulz', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('umul_16x16', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c(is_not_const)'), ('fmulz', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c(is_not_const)'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_amd(is_used_once)', 'a'), ('fsin_amd(is_used_once)', 'b')) => ('fsin_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_amd(is_used_once)', 'a'), ('fcos_amd(is_used_once)', 'b')) => ('fcos_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_mdg(is_used_once)', 'a'), ('fsin_mdg(is_used_once)', 'b')) => ('fsin_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_mdg(is_used_once)', 'a'), ('fcos_mdg(is_used_once)', 'b')) => ('fcos_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_agx(is_used_once)', 'a'), ('fsin_agx(is_used_once)', 'b')) => ('fsin_agx', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcanonicalize(is_used_once)', 'a'), ('fcanonicalize(is_used_once)', 'b')) => ('fcanonicalize', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('fcanonicalize', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('fcanonicalize', 'a'), ('fcanonicalize', 'b'))
 *    ('fisnormal', 'a@16') => ('ult', 4095, ('iadd', ('ishl', 'a', 1), 2048))
 *    ('fisnormal', 'a@32') => ('ult', 33554431, ('iadd', ('ishl', 'a', 1), 16777216))
 *    ('fisnormal', 'a@64') => ('ult', 18014398509481983, ('iadd', ('ishl', 'a', 1), 9007199254740992))
 *    ('fquantize2f16', 'a@32') => ('bcsel', ('!flt', ('!fabs', 'a'), 6.103515625e-05), ('iand', 'a', 2147483648), ('!f2f32', ('!f2f16_rtne', 'a')))
 *    ('bfi', 4294967295, 'a', '#b') => ('iadd', ('ishl', 'a', 0), ('iand', 'b', -4294967296))
 *    ('bfi', 8589934590, 'a', '#b') => ('iadd', ('ishl', 'a', 1), ('iand', 'b', -8589934591))
 *    ('bfi', 17179869180, 'a', '#b') => ('iadd', ('ishl', 'a', 2), ('iand', 'b', -17179869181))
 *    ('bfi', 34359738360, 'a', '#b') => ('iadd', ('ishl', 'a', 3), ('iand', 'b', -34359738361))
 *    ('bfi', 68719476720, 'a', '#b') => ('iadd', ('ishl', 'a', 4), ('iand', 'b', -68719476721))
 *    ('bfi', 137438953440, 'a', '#b') => ('iadd', ('ishl', 'a', 5), ('iand', 'b', -137438953441))
 *    ('bfi', 274877906880, 'a', '#b') => ('iadd', ('ishl', 'a', 6), ('iand', 'b', -274877906881))
 *    ('bfi', 549755813760, 'a', '#b') => ('iadd', ('ishl', 'a', 7), ('iand', 'b', -549755813761))
 *    ('bfi', 1099511627520, 'a', '#b') => ('iadd', ('ishl', 'a', 8), ('iand', 'b', -1099511627521))
 *    ('bfi', 2199023255040, 'a', '#b') => ('iadd', ('ishl', 'a', 9), ('iand', 'b', -2199023255041))
 *    ('bfi', 4398046510080, 'a', '#b') => ('iadd', ('ishl', 'a', 10), ('iand', 'b', -4398046510081))
 *    ('bfi', 8796093020160, 'a', '#b') => ('iadd', ('ishl', 'a', 11), ('iand', 'b', -8796093020161))
 *    ('bfi', 17592186040320, 'a', '#b') => ('iadd', ('ishl', 'a', 12), ('iand', 'b', -17592186040321))
 *    ('bfi', 35184372080640, 'a', '#b') => ('iadd', ('ishl', 'a', 13), ('iand', 'b', -35184372080641))
 *    ('bfi', 70368744161280, 'a', '#b') => ('iadd', ('ishl', 'a', 14), ('iand', 'b', -70368744161281))
 *    ('bfi', 140737488322560, 'a', '#b') => ('iadd', ('ishl', 'a', 15), ('iand', 'b', -140737488322561))
 *    ('bfi', 281474976645120, 'a', '#b') => ('iadd', ('ishl', 'a', 16), ('iand', 'b', -281474976645121))
 *    ('bfi', 562949953290240, 'a', '#b') => ('iadd', ('ishl', 'a', 17), ('iand', 'b', -562949953290241))
 *    ('bfi', 1125899906580480, 'a', '#b') => ('iadd', ('ishl', 'a', 18), ('iand', 'b', -1125899906580481))
 *    ('bfi', 2251799813160960, 'a', '#b') => ('iadd', ('ishl', 'a', 19), ('iand', 'b', -2251799813160961))
 *    ('bfi', 4503599626321920, 'a', '#b') => ('iadd', ('ishl', 'a', 20), ('iand', 'b', -4503599626321921))
 *    ('bfi', 9007199252643840, 'a', '#b') => ('iadd', ('ishl', 'a', 21), ('iand', 'b', -9007199252643841))
 *    ('bfi', 18014398505287680, 'a', '#b') => ('iadd', ('ishl', 'a', 22), ('iand', 'b', -18014398505287681))
 *    ('bfi', 36028797010575360, 'a', '#b') => ('iadd', ('ishl', 'a', 23), ('iand', 'b', -36028797010575361))
 *    ('bfi', 72057594021150720, 'a', '#b') => ('iadd', ('ishl', 'a', 24), ('iand', 'b', -72057594021150721))
 *    ('bfi', 144115188042301440, 'a', '#b') => ('iadd', ('ishl', 'a', 25), ('iand', 'b', -144115188042301441))
 *    ('bfi', 288230376084602880, 'a', '#b') => ('iadd', ('ishl', 'a', 26), ('iand', 'b', -288230376084602881))
 *    ('bfi', 576460752169205760, 'a', '#b') => ('iadd', ('ishl', 'a', 27), ('iand', 'b', -576460752169205761))
 *    ('bfi', 1152921504338411520, 'a', '#b') => ('iadd', ('ishl', 'a', 28), ('iand', 'b', -1152921504338411521))
 *    ('bfi', 2305843008676823040, 'a', '#b') => ('iadd', ('ishl', 'a', 29), ('iand', 'b', -2305843008676823041))
 *    ('bfi', 4611686017353646080, 'a', '#b') => ('iadd', ('ishl', 'a', 30), ('iand', 'b', -4611686017353646081))
 *    ('fadd', '#a(is_nan)', 'b') => nan
 *    ('fadd', 'a', '#b(is_nan)') => nan
 *    ('fdiv', '#a(is_nan)', 'b') => nan
 *    ('fdiv', 'a', '#b(is_nan)') => nan
 *    ('fmod', '#a(is_nan)', 'b') => nan
 *    ('fmod', 'a', '#b(is_nan)') => nan
 *    ('fmul', '#a(is_nan)', 'b') => nan
 *    ('fmul', 'a', '#b(is_nan)') => nan
 *    ('fpow', '#a(is_nan)', 'b') => nan
 *    ('fpow', 'a', '#b(is_nan)') => nan
 *    ('frem', '#a(is_nan)', 'b') => nan
 *    ('frem', 'a', '#b(is_nan)') => nan
 *    ('fsub', '#a(is_nan)', 'b') => nan
 *    ('fsub', 'a', '#b(is_nan)') => nan
 *    ('ffma', '#a(is_nan)', 'b', 'c') => nan
 *    ('ffma', 'a', '#b(is_nan)', 'c') => nan
 *    ('ffma', 'a', 'b', '#c(is_nan)') => nan
 *    ('flrp', '#a(is_nan)', 'b', 'c') => nan
 *    ('flrp', 'a', '#b(is_nan)', 'c') => nan
 *    ('flrp', 'a', 'b', '#c(is_nan)') => nan
 *    ('fmin', '#a(is_nan)', 'b') => b
 *    ('fmax', '#a(is_nan)', 'b') => b
 *    ('ldexp', '#a(is_nan)', 'b') => nan
 *    ('fdot2', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot3', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot4', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot5', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot8', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot16', '#a(is_any_comp_nan)', 'b') => nan
 *    ('feq', '#a(is_nan)', 'b') => False
 *    ('feq', 'a', '#b(is_nan)') => False
 *    ('fge', '#a(is_nan)', 'b') => False
 *    ('fge', 'a', '#b(is_nan)') => False
 *    ('flt', '#a(is_nan)', 'b') => False
 *    ('flt', 'a', '#b(is_nan)') => False
 *    ('fneu', '#a(is_nan)', 'b') => True
 *    ('seq', '#a(is_nan)', 'b') => 0.0
 *    ('seq', 'a', '#b(is_nan)') => 0.0
 *    ('sge', '#a(is_nan)', 'b') => 0.0
 *    ('sge', 'a', '#b(is_nan)') => 0.0
 *    ('slt', '#a(is_nan)', 'b') => 0.0
 *    ('slt', 'a', '#b(is_nan)') => 0.0
 *    ('sne', '#a(is_nan)', 'b') => 1.0
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ieq', ('b2i', 'a@1'), 1) => a
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('ine', ('b2i', 'a@1'), 1) => ('inot', 'a')
 *    ('ieq', ('b2i', 'a@1'), '#b') => ('bcsel', ('ieq', 'b', 0), ('inot', 'a'), ('bcsel', ('ieq', 'b', 1), 'a', False))
 *    ('ine', ('b2i', 'a@1'), '#b') => ('bcsel', ('ieq', 'b', 0), 'a', ('bcsel', ('ieq', 'b', 1), ('inot', 'a'), True))
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('feq', ('b2f', 'a@1'), 1.0) => a
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('fneu', ('b2f', 'a@1'), 1.0) => ('inot', 'a')
 *    ('feq', ('b2f', 'a@1'), '#b') => ('bcsel', ('feq', 'b', 0.0), ('inot', 'a'), ('bcsel', ('feq', 'b', 1.0), 'a', False))
 *    ('fneu', ('b2f', 'a@1'), '#b') => ('bcsel', ('feq', 'b', 0.0), 'a', ('bcsel', ('feq', 'b', 1.0), ('inot', 'a'), True))
 */


static const nir_search_value_union nir_opt_algebraic_values[] = {
   /* ('fgeu', 'a', 'b') => ('inot', ('flt', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fgeu,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace0_0_0 -> 0 in the cache */
   /* replace0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 3 },
      -1,
   } },

   /* ('fltu', 'a', 'b') => ('inot', ('fge', 'a', 'b')) */
   /* search1_0 -> 0 in the cache */
   /* search1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fltu,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace1_0_0 -> 0 in the cache */
   /* replace1_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 6 },
      -1,
   } },

   /* ('fneo', 0.0, 'a') => ('flt', 0.0, ('fabs', 'a')) */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneo,
      0, 1,
      { 8, 9 },
      -1,
   } },

   /* replace2_0 -> 8 in the cache */
   /* replace2_1_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* ('fequ', 0.0, 'a') => ('inot', ('flt', 0.0, ('fabs', 'a'))) */
   /* search3_0 -> 8 in the cache */
   /* search3_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fequ,
      0, 1,
      { 8, 9 },
      -1,
   } },

   /* replace3_0_0 -> 8 in the cache */
   /* replace3_0_1_0 -> 9 in the cache */
   /* replace3_0_1 -> 11 in the cache */
   /* replace3_0 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 12 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b')) */
   /* search4_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 0, 15 },
      -1,
   } },

   /* replace4_0 -> 0 in the cache */
   /* replace4_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_find_lsb,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 0, 17 },
      -1,
   } },

   /* ('imul', 'a@8', 128) => ('ishl', 'a', 7) */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x80ull /* 128 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 19, 20 },
      -1,
   } },

   /* replace5_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7ull /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 19, 22 },
      -1,
   } },

   /* ('imul', 'a@16', 32768) => ('ishl', 'a', 15) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x8000ull /* 32768 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 24, 25 },
      -1,
   } },

   /* replace6_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfull /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 24, 27 },
      -1,
   } },

   /* ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x80000000ull /* 2147483648 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 29, 30 },
      -1,
   } },

   /* replace7_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1full /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 32 },
      -1,
   } },

   /* ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x8000000000000000ull /* 9223372036854775808 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 34, 35 },
      -1,
   } },

   /* replace8_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3full /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 34, 37 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b')))) */
   /* search9_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 0, 39 },
      -1,
   } },

   /* replace9_0_0 -> 0 in the cache */
   /* replace9_0_1_0_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iabs,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_find_lsb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 0, 42 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 43 },
      -1,
   } },

   /* ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b')) */
   /* search10_0 -> 9 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 9, 45 },
      -1,
   } },

   /* replace10_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 47, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 9, 49 },
      -1,
   } },

   /* ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b'))) */
   /* search11_0 -> 34 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 34, 51 },
      -1,
   } },

   /* replace11_0_0 -> 34 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ufind_msb,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 34, 54 },
      -1,
   } },
   /* replace11_1_0 -> 34 in the cache */
   /* replace11_1_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_find_lsb,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 34, 56 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 55, 57 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search12_0_0 -> 29 in the cache */
   /* search12_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul_2x32_64,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 59 },
      -1,
   } },

   /* replace12_0 -> 29 in the cache */
   /* replace12_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search13_0_0 -> 29 in the cache */
   /* search13_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umul_2x32_64,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 62 },
      -1,
   } },

   /* replace13_0 -> 29 in the cache */
   /* replace13_1 -> 48 in the cache */
   /* replace13 -> 61 in the cache */

   /* ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b')) */
   /* search14_0 -> 29 in the cache */
   /* search14_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul_2x32_64,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* replace14_0_0 -> 29 in the cache */
   /* replace14_0_1 -> 48 in the cache */
   /* replace14_0 -> 61 in the cache */
   /* replace14_1_0 -> 29 in the cache */
   /* replace14_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul_high,
      1, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 61, 65 },
      -1,
   } },

   /* ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b')) */
   /* search15_0 -> 29 in the cache */
   /* search15_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umul_2x32_64,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* replace15_0_0 -> 29 in the cache */
   /* replace15_0_1 -> 48 in the cache */
   /* replace15_0 -> 61 in the cache */
   /* replace15_1_0 -> 29 in the cache */
   /* replace15_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umul_high,
      1, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 61, 68 },
      -1,
   } },

   /* ('udiv', 'a', 1) => a */
   /* search16_0 -> 9 in the cache */
   /* search16_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_udiv,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace16 -> 9 in the cache */

   /* ('idiv', 'a', 1) => a */
   /* search17_0 -> 9 in the cache */
   /* search17_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_idiv,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace17 -> 9 in the cache */

   /* ('umod', 'a', 1) => 0 */
   /* search18_0 -> 9 in the cache */
   /* search18_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umod,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },

   /* ('imod', 'a', 1) => 0 */
   /* search19_0 -> 9 in the cache */
   /* search19_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imod,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace19 -> 73 in the cache */

   /* ('imod', 'a', -1) => 0 */
   /* search20_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imod,
      -1, 0,
      { 9, 75 },
      -1,
   } },

   /* replace20 -> 73 in the cache */

   /* ('irem', 'a', 1) => 0 */
   /* search21_0 -> 9 in the cache */
   /* search21_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_irem,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace21 -> 73 in the cache */

   /* ('irem', 'a', -1) => 0 */
   /* search22_0 -> 9 in the cache */
   /* search22_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_irem,
      -1, 0,
      { 9, 75 },
      -1,
   } },

   /* replace22 -> 73 in the cache */

   /* ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b')) */
   /* search23_0 -> 0 in the cache */
   /* search23_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udiv,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace23_0 -> 0 in the cache */
   /* replace23_1_0 -> 1 in the cache */
   /* replace23_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 17 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b'))) */
   /* search24_0 -> 0 in the cache */
   /* search24_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_idiv,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace24_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isign,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace24_1_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace24_1_1_0 -> 1 in the cache */
   /* replace24_1_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 83, 17 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 82, 84 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b'))))) */
   /* search25_0 -> 0 in the cache */
   /* search25_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_idiv,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace25_0_0_0 -> 0 in the cache */
   /* replace25_0_0 -> 82 in the cache */
   /* replace25_0_1_0_0 -> 0 in the cache */
   /* replace25_0_1_0 -> 83 in the cache */
   /* replace25_0_1_1_0_0 -> 1 in the cache */
   /* replace25_0_1_1_0 -> 41 in the cache */
   /* replace25_0_1_1 -> 42 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 83, 42 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 82, 87 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 1,
      { 88 },
      -1,
   } },

   /* ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search26_0 -> 0 in the cache */
   /* search26_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umod,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace26_0 -> 0 in the cache */
   /* replace26_1_0 -> 1 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_isub,
      -1, 0,
      { 1, 91 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 0, 92 },
      -1,
   } },

   /* ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search27_0 -> 0 in the cache */
   /* search27_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imod,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace27_0 -> 0 in the cache */
   /* replace27_1_0 -> 1 in the cache */
   /* replace27_1_1 -> 91 in the cache */
   /* replace27_1 -> 92 in the cache */
   /* replace27 -> 93 in the cache */

   /* ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b')) */
   /* search28_0 -> 0 in the cache */
   /* search28_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imod,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace28_0_0_0 -> 0 in the cache */
   /* replace28_0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* replace28_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 2,
      { 96, 1 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   /* replace28_2_0 -> 0 in the cache */
   /* replace28_2_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 97, 98, 99 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b'))) */
   /* search29_0 -> 0 in the cache */
   /* search29_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_irem,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace29_0 -> 0 in the cache */
   /* replace29_1_0_0_0 -> 0 in the cache */
   /* replace29_1_0_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ilt,
      -1, 0,
      { 0, 98 },
      -1,
   } },
   /* replace29_1_0_1_0 -> 0 in the cache */
   /* replace29_1_0_1_1_0 -> 1 in the cache */
   /* replace29_1_0_1_1_1 -> 91 in the cache */
   /* replace29_1_0_1_1 -> 92 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 0, 92 },
      -1,
   } },
   /* replace29_1_0_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 102, 103, 0 },
      -1,
   } },
   /* replace29_1_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 2,
      { 104, 105 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 2,
      { 0, 106 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b')) */
   /* search30_0 -> 0 in the cache */
   /* search30_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_irem,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace30_0 -> 0 in the cache */
   /* replace30_1_0 -> 1 in the cache */
   /* replace30_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_irem,
      -1, 0,
      { 0, 41 },
      -1,
   } },

   /* ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5))) */
   /* search31_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsign,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search31_1_0_0_0 -> 9 in the cache */
   /* search31_1_0_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe0000000000000ull /* 0.5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fadd,
      1, 1,
      { 11, 111 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 1,
      { 112 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 110, 113 },
      -1,
   } },

   /* replace31_0_0 -> 9 in the cache */
   /* replace31_0_1_0_0 -> 9 in the cache */
   /* replace31_0_1_0 -> 110 in the cache */
   /* replace31_0_1_1 -> 111 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      1, 1,
      { 110, 111 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 9, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ftrunc,
      -1, 2,
      { 116 },
      -1,
   } },

   /* ('fneg', ('fneg', 'a')) => ('fcanonicalize', 'a') */
   /* search32_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 118 },
      -1,
   } },

   /* replace32_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('ineg', ('ineg', 'a')) => a */
   /* search33_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 121 },
      -1,
   } },

   /* replace33 -> 9 in the cache */

   /* ('fabs', ('fneg', 'a')) => ('fabs', 'a') */
   /* search34_0_0 -> 9 in the cache */
   /* search34_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 118 },
      -1,
   } },

   /* replace34_0 -> 9 in the cache */
   /* replace34 -> 11 in the cache */

   /* ('fabs', ('u2f', 'a')) => ('u2f', 'a') */
   /* search35_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_u2f,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 124 },
      -1,
   } },

   /* replace35_0 -> 9 in the cache */
   /* replace35 -> 124 in the cache */

   /* ('iabs', ('iabs', 'a')) => ('iabs', 'a') */
   /* search36_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iabs,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iabs,
      -1, 0,
      { 126 },
      -1,
   } },

   /* replace36_0 -> 9 in the cache */
   /* replace36 -> 126 in the cache */

   /* ('iabs', ('ineg', 'a')) => ('iabs', 'a') */
   /* search37_0_0 -> 9 in the cache */
   /* search37_0 -> 121 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iabs,
      -1, 0,
      { 121 },
      -1,
   } },

   /* replace37_0 -> 9 in the cache */
   /* replace37 -> 126 in the cache */

   /* ('fadd(nsz)', 'a', 0.0) => ('fcanonicalize', 'a') */
   /* search38_0 -> 9 in the cache */
   /* search38_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fadd,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace38_0 -> 9 in the cache */
   /* replace38 -> 120 in the cache */

   /* ('fadd', 'a', -0.0) => ('fcanonicalize', 'a') */
   /* search39_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x8000000000000000ull /* -0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fadd,
      0, 1,
      { 9, 130 },
      -1,
   } },

   /* replace39_0 -> 9 in the cache */
   /* replace39 -> 120 in the cache */

   /* ('iadd', 'a', 0) => a */
   /* search40_0 -> 9 in the cache */
   /* search40_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iadd,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace40 -> 9 in the cache */

   /* ('iadd_sat', 'a', 0) => a */
   /* search41_0 -> 9 in the cache */
   /* search41_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iadd_sat,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace41 -> 9 in the cache */

   /* ('isub_sat', 'a', 0) => a */
   /* search42_0 -> 9 in the cache */
   /* search42_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_isub_sat,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* replace42 -> 9 in the cache */

   /* ('uadd_sat', 'a', 0) => a */
   /* search43_0 -> 9 in the cache */
   /* search43_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_uadd_sat,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace43 -> 9 in the cache */

   /* ('usub_sat', 'a', 0) => a */
   /* search44_0 -> 9 in the cache */
   /* search44_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_usub_sat,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* replace44 -> 9 in the cache */

   /* ('usadd_4x8_vc4', 'a', 0) => a */
   /* search45_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 29, 137 },
      -1,
   } },

   /* replace45 -> 29 in the cache */

   /* ('usadd_4x8_vc4', 'a', -1) => -1 */
   /* search46_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 29, 139 },
      -1,
   } },

   /* replace46 -> 139 in the cache */

   /* ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 141, 142 },
      -1,
   } },
   /* search47_1_0 -> 141 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 141, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 143, 145 },
      -1,
   } },

   /* replace47_0 -> 141 in the cache */
   /* replace47_1_0 -> 142 in the cache */
   /* replace47_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 142, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 141, 147 },
      -1,
   } },

   /* ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search48_0_0 -> 29 in the cache */
   /* search48_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 29, 48 },
      -1,
   } },
   /* search48_1_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      2, 1,
      { 29, 150 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 149, 151 },
      -1,
   } },

   /* replace48_0 -> 29 in the cache */
   /* replace48_1_0 -> 48 in the cache */
   /* replace48_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 48, 150 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 2,
      { 29, 153 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search49_0 -> 0 in the cache */
   /* search49_1 -> 1 in the cache */
   /* search49_2_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 0, 155, 156 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 0, 1, 157 },
      -1,
   } },

   /* replace49_0 -> 0 in the cache */
   /* replace49_1_0 -> 1 in the cache */
   /* replace49_1_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 1, 155 },
      -1,
   } },
   /* replace49_2 -> 156 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 0, 159, 156 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   /* search50_0 -> 0 in the cache */
   /* search50_1 -> 1 in the cache */
   /* search50_2_0 -> 0 in the cache */
   /* search50_2_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 0, 155 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 0, 1, 161 },
      -1,
   } },

   /* replace50_0 -> 0 in the cache */
   /* replace50_1_0 -> 1 in the cache */
   /* replace50_1_1 -> 155 in the cache */
   /* replace50_1 -> 159 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 0, 159 },
      -1,
   } },

   /* ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 164, 165 },
      0,
   } },
   /* search51_1_0 -> 164 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      2, 1,
      { 164, 167, 168 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 166, 169 },
      -1,
   } },

   /* replace51_0 -> 164 in the cache */
   /* replace51_1_0 -> 165 in the cache */
   /* replace51_1_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 165, 167 },
      -1,
   } },
   /* replace51_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 164, 171, 168 },
      -1,
   } },

   /* ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd')) */
   /* search52_0 -> 164 in the cache */
   /* search52_1_0 -> 165 in the cache */
   /* search52_1_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 165, 167 },
      0,
   } },
   /* search52_2_0 -> 165 in the cache */
   /* search52_2_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 165, 168 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 164, 173, 174 },
      -1,
   } },

   /* replace52_0 -> 165 in the cache */
   /* replace52_1_0 -> 164 in the cache */
   /* replace52_1_1 -> 167 in the cache */
   /* replace52_1_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 164, 167, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 165, 176 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search53_0 -> 29 in the cache */
   /* search53_1 -> 48 in the cache */
   /* search53_2_0 -> 29 in the cache */
   /* search53_2_1 -> 150 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      1, 1,
      { 29, 150, 178 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 2,
      { 29, 48, 179 },
      -1,
   } },

   /* replace53_0 -> 29 in the cache */
   /* replace53_1_0 -> 48 in the cache */
   /* replace53_1_1 -> 150 in the cache */
   /* replace53_1 -> 153 in the cache */
   /* replace53_2 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 2,
      { 29, 153, 178 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search54_0 -> 29 in the cache */
   /* search54_1 -> 48 in the cache */
   /* search54_2_0 -> 29 in the cache */
   /* search54_2_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 29, 150 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 2,
      { 29, 48, 182 },
      -1,
   } },

   /* replace54_0 -> 29 in the cache */
   /* replace54_1_0 -> 48 in the cache */
   /* replace54_1_1 -> 150 in the cache */
   /* replace54_1 -> 153 in the cache */
   /* replace54 -> 154 in the cache */

   /* ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search55_0_0 -> 29 in the cache */
   /* search55_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 29, 48 },
      0,
   } },
   /* search55_1_0 -> 29 in the cache */
   /* search55_1_1 -> 150 in the cache */
   /* search55_1_2 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      2, 1,
      { 29, 150, 178 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 184, 185 },
      -1,
   } },

   /* replace55_0 -> 29 in the cache */
   /* replace55_1_0 -> 48 in the cache */
   /* replace55_1_1 -> 150 in the cache */
   /* replace55_1 -> 153 in the cache */
   /* replace55_2 -> 178 in the cache */
   /* replace55 -> 181 in the cache */

   /* ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd')) */
   /* search56_0 -> 29 in the cache */
   /* search56_1_0 -> 48 in the cache */
   /* search56_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 48, 150 },
      0,
   } },
   /* search56_2_0 -> 48 in the cache */
   /* search56_2_1 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      2, 1,
      { 48, 178 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 3,
      { 29, 187, 188 },
      -1,
   } },

   /* replace56_0 -> 48 in the cache */
   /* replace56_1_0 -> 29 in the cache */
   /* replace56_1_1 -> 150 in the cache */
   /* replace56_1_2 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      1, 1,
      { 29, 150, 178 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 2,
      { 48, 190 },
      -1,
   } },

   /* ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c')) */
   /* search57_0_0 -> 141 in the cache */
   /* search57_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 1,
      { 141, 142 },
      -1,
   } },
   /* search57_1_0 -> 141 in the cache */
   /* search57_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      2, 1,
      { 141, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 192, 193 },
      -1,
   } },

   /* replace57_0 -> 141 in the cache */
   /* replace57_1_0 -> 142 in the cache */
   /* replace57_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 142, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 2,
      { 141, 195 },
      -1,
   } },

   /* ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 197, 198 },
      -1,
   } },
   /* search58_1_0 -> 144 in the cache */
   /* search58_1_1 -> 198 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 144, 198 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 199, 200 },
      -1,
   } },

   /* replace58_0_0 -> 197 in the cache */
   /* replace58_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 197, 144 },
      -1,
   } },
   /* replace58_1 -> 198 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 202, 198 },
      -1,
   } },

   /* ('iand', ('iand', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', ('iand', 'a', 'b'), 'c') */
   /* search59_0_0 -> 141 in the cache */
   /* search59_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 141, 142 },
      -1,
   } },
   /* search59_1_0 -> 141 in the cache */
   /* search59_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      2, 1,
      { 141, 144 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 3,
      { 204, 205 },
      -1,
   } },

   /* replace59_0_0 -> 141 in the cache */
   /* replace59_0_1 -> 142 in the cache */
   /* replace59_0 -> 204 in the cache */
   /* replace59_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 2,
      { 204, 144 },
      -1,
   } },

   /* ('ior', ('ior', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', ('ior', 'a', 'b'), 'c') */
   /* search60_0_0 -> 141 in the cache */
   /* search60_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      1, 1,
      { 141, 142 },
      -1,
   } },
   /* search60_1_0 -> 141 in the cache */
   /* search60_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      2, 1,
      { 141, 144 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 3,
      { 208, 209 },
      -1,
   } },

   /* replace60_0_0 -> 141 in the cache */
   /* replace60_0_1 -> 142 in the cache */
   /* replace60_0 -> 208 in the cache */
   /* replace60_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 2,
      { 208, 144 },
      -1,
   } },

   /* ('iand', ('ior(is_used_once)', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c')) */
   /* search61_0_0 -> 141 in the cache */
   /* search61_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      1, 1,
      { 141, 142 },
      0,
   } },
   /* search61_1_0 -> 141 in the cache */
   /* search61_1_1 -> 144 in the cache */
   /* search61_1 -> 209 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 3,
      { 212, 209 },
      -1,
   } },

   /* replace61_0 -> 141 in the cache */
   /* replace61_1_0 -> 142 in the cache */
   /* replace61_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 142, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 2,
      { 141, 214 },
      -1,
   } },

   /* ('ior', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c')) */
   /* search62_0_0 -> 141 in the cache */
   /* search62_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 141, 142 },
      0,
   } },
   /* search62_1_0 -> 141 in the cache */
   /* search62_1_1 -> 144 in the cache */
   /* search62_1 -> 205 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 3,
      { 216, 205 },
      -1,
   } },

   /* replace62_0 -> 141 in the cache */
   /* replace62_1_0 -> 142 in the cache */
   /* replace62_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      1, 1,
      { 142, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 2,
      { 141, 218 },
      -1,
   } },

   /* ('ior', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', 'c') */
   /* search63_0_0 -> 141 in the cache */
   /* search63_0_1 -> 142 in the cache */
   /* search63_0 -> 204 in the cache */
   /* search63_1_0 -> 141 in the cache */
   /* search63_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      2, 1,
      { 141, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 3,
      { 204, 220 },
      -1,
   } },

   /* replace63_0 -> 141 in the cache */
   /* replace63_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 141, 144 },
      -1,
   } },

   /* ('iand', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('iand', 'a', 'b') */
   /* search64_0_0 -> 141 in the cache */
   /* search64_0_1 -> 142 in the cache */
   /* search64_0 -> 204 in the cache */
   /* search64_1_0 -> 141 in the cache */
   /* search64_1_1 -> 144 in the cache */
   /* search64_1 -> 220 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 3,
      { 204, 220 },
      -1,
   } },

   /* replace64_0 -> 141 in the cache */
   /* replace64_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 141, 142 },
      -1,
   } },

   /* ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0) */
   /* search65_0_0 -> 0 in the cache */
   /* search65_0_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 0, 15 },
      -1,
   } },
   /* search65_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 2,
      { 225, 1 },
      -1,
   } },

   /* replace65_0_0 -> 0 in the cache */
   /* replace65_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* replace65_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 2,
      { 227, 98 },
      -1,
   } },

   /* ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0) */
   /* search66_0_0 -> 0 in the cache */
   /* search66_0_1 -> 15 in the cache */
   /* search66_0 -> 225 in the cache */
   /* search66_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 2,
      { 225, 1 },
      -1,
   } },

   /* replace66_0_0 -> 0 in the cache */
   /* replace66_0_1 -> 1 in the cache */
   /* replace66_0 -> 227 in the cache */
   /* replace66_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 2,
      { 227, 98 },
      -1,
   } },

   /* ('uge', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0) */
   /* search67_0_0 -> 0 in the cache */
   /* search67_0_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 0, 15 },
      -1,
   } },
   /* search67_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 1,
      { 231, 1 },
      -1,
   } },

   /* replace67_0_0 -> 0 in the cache */
   /* replace67_0_1 -> 1 in the cache */
   /* replace67_0 -> 227 in the cache */
   /* replace67_1 -> 98 in the cache */
   /* replace67 -> 228 in the cache */

   /* ('ult', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0) */
   /* search68_0_0 -> 0 in the cache */
   /* search68_0_1 -> 15 in the cache */
   /* search68_0 -> 231 in the cache */
   /* search68_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 1,
      { 231, 1 },
      -1,
   } },

   /* replace68_0_0 -> 0 in the cache */
   /* replace68_0_1 -> 1 in the cache */
   /* replace68_0 -> 227 in the cache */
   /* replace68_1 -> 98 in the cache */
   /* replace68 -> 230 in the cache */

   /* ('ige', ('iand', 'a', 'b'), '#b(is_pos_power_of_two)') => ('ine', ('iand', 'a', 'b'), 0) */
   /* search69_0_0 -> 0 in the cache */
   /* search69_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 0, 1 },
      -1,
   } },
   /* search69_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 1,
      { 234, 15 },
      -1,
   } },

   /* replace69_0_0 -> 0 in the cache */
   /* replace69_0_1 -> 1 in the cache */
   /* replace69_0 -> 227 in the cache */
   /* replace69_1 -> 98 in the cache */
   /* replace69 -> 228 in the cache */

   /* ('ilt', ('iand', 'a', 'b'), '#b(is_pos_power_of_two)') => ('ieq', ('iand', 'a', 'b'), 0) */
   /* search70_0_0 -> 0 in the cache */
   /* search70_0_1 -> 1 in the cache */
   /* search70_0 -> 234 in the cache */
   /* search70_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 1,
      { 234, 15 },
      -1,
   } },

   /* replace70_0_0 -> 0 in the cache */
   /* replace70_0_1 -> 1 in the cache */
   /* replace70_0 -> 227 in the cache */
   /* replace70_1 -> 98 in the cache */
   /* replace70 -> 230 in the cache */

   /* ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b')) */
   /* search71_0_0 -> 9 in the cache */
   /* search71_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 9, 45 },
      0,
   } },
   /* search71_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 237, 73 },
      -1,
   } },

   /* replace71_0 -> 9 in the cache */
   /* replace71_1_0 -> 47 in the cache */
   /* replace71_1_1 -> 48 in the cache */
   /* replace71_1 -> 49 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 9, 49 },
      -1,
   } },

   /* ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b')) */
   /* search72_0_0 -> 9 in the cache */
   /* search72_0_1 -> 45 in the cache */
   /* search72_0 -> 237 in the cache */
   /* search72_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 237, 73 },
      -1,
   } },

   /* replace72_0 -> 9 in the cache */
   /* replace72_1_0 -> 47 in the cache */
   /* replace72_1_1 -> 48 in the cache */
   /* replace72_1 -> 49 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 9, 49 },
      -1,
   } },

   /* ('~fadd', ('fneg', 'a'), 'a') => 0.0 */
   /* search73_0_0 -> 9 in the cache */
   /* search73_0 -> 118 in the cache */
   /* search73_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 118, 9 },
      -1,
   } },

   /* replace73 -> 8 in the cache */

   /* ('iadd', ('ineg', 'a'), 'a') => 0 */
   /* search74_0_0 -> 9 in the cache */
   /* search74_0 -> 121 in the cache */
   /* search74_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 121, 9 },
      -1,
   } },

   /* replace74 -> 73 in the cache */

   /* ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b */
   /* search75_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search75_1_0 -> 0 in the cache */
   /* search75_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 244, 245 },
      -1,
   } },

   /* replace75 -> 1 in the cache */

   /* ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b */
   /* search76_0 -> 0 in the cache */
   /* search76_1_0_0 -> 0 in the cache */
   /* search76_1_0 -> 244 in the cache */
   /* search76_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 244, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 247 },
      -1,
   } },

   /* replace76 -> 1 in the cache */

   /* ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => ('fcanonicalize', 'b') */
   /* search77_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search77_1_0 -> 0 in the cache */
   /* search77_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 249, 250 },
      -1,
   } },

   /* replace77_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 1 },
      -1,
   } },

   /* ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => ('fcanonicalize', 'b') */
   /* search78_0 -> 0 in the cache */
   /* search78_1_0_0 -> 0 in the cache */
   /* search78_1_0 -> 249 in the cache */
   /* search78_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 249, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 0, 253 },
      -1,
   } },

   /* replace78_0 -> 1 in the cache */
   /* replace78 -> 252 in the cache */

   /* ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a')) */
   /* search79_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search79_1_0_0 -> 9 in the cache */
   /* search79_1_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 255, 256 },
      -1,
   } },

   /* replace79_0_0 -> 9 in the cache */
   /* replace79_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('fadd', 'a', 'a') => ('fmul', 'a', 2.0) */
   /* search80_0 -> 9 in the cache */
   /* search80_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace80_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x4000000000000000ull /* 2.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 260 },
      -1,
   } },

   /* ('fadd(contract)', 'a', ('fadd(is_used_once)', 'a', 'b')) => ('fadd', 'b', ('fmul', 'a', 2.0)) */
   /* search81_0 -> 0 in the cache */
   /* search81_1_0 -> 0 in the cache */
   /* search81_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 0, 262 },
      -1,
   } },

   /* replace81_0 -> 1 in the cache */
   /* replace81_1_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x4000000000000000ull /* 2.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      1, 1,
      { 0, 264 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 1, 265 },
      -1,
   } },

   /* ('~fmul', 'a', 0.0) => 0.0 */
   /* search82_0 -> 9 in the cache */
   /* search82_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace82 -> 8 in the cache */

   /* ('~fmul', 'a', -0.0) => 0.0 */
   /* search83_0 -> 9 in the cache */
   /* search83_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 130 },
      -1,
   } },

   /* replace83 -> 8 in the cache */

   /* ('fmul(nsz,nnan)', 'a', 0.0) => 0.0 */
   /* search84_0 -> 9 in the cache */
   /* search84_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace84 -> 8 in the cache */

   /* ('fmul(nsz,nnan)', 'a', -0.0) => 0.0 */
   /* search85_0 -> 9 in the cache */
   /* search85_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 130 },
      -1,
   } },

   /* replace85 -> 8 in the cache */

   /* ('fmulz', 'a', 0.0) => 0.0 */
   /* search86_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmulz,
      0, 1,
      { 29, 271 },
      -1,
   } },

   /* replace86 -> 271 in the cache */

   /* ('fmulz', 'a', -0.0) => 0.0 */
   /* search87_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x8000000000000000ull /* -0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmulz,
      0, 1,
      { 29, 273 },
      -1,
   } },

   /* replace87 -> 271 in the cache */

   /* ('fmulz(nsz)', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b') */
   /* search88_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 29, 275 },
      -1,
   } },

   /* replace88_0 -> 29 in the cache */
   /* replace88_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 278, 279 },
      -1,
   } },

   /* replace89_0 -> 29 in the cache */
   /* replace89_1 -> 48 in the cache */
   /* replace89 -> 277 in the cache */

   /* ('fmulz', 'a', 'a') => ('fmul', 'a', 'a') */
   /* search90_0 -> 29 in the cache */
   /* search90_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* replace90_0 -> 29 in the cache */
   /* replace90_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* ('ffmaz(nsz)', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search91_0 -> 29 in the cache */
   /* search91_1 -> 275 in the cache */
   /* search91_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 29, 275, 150 },
      -1,
   } },

   /* replace91_0 -> 29 in the cache */
   /* replace91_1 -> 48 in the cache */
   /* replace91_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search92_0 -> 278 in the cache */
   /* search92_1 -> 279 in the cache */
   /* search92_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 278, 279, 150 },
      -1,
   } },

   /* replace92_0 -> 29 in the cache */
   /* replace92_1 -> 48 in the cache */
   /* replace92_2 -> 150 in the cache */
   /* replace92 -> 284 in the cache */

   /* ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b') */
   /* search93_0 -> 29 in the cache */
   /* search93_1 -> 29 in the cache */
   /* search93_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      -1, 0,
      { 29, 29, 48 },
      -1,
   } },

   /* replace93_0 -> 29 in the cache */
   /* replace93_1 -> 29 in the cache */
   /* replace93_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      -1, 0,
      { 29, 29, 48 },
      -1,
   } },

   /* ('imul', 'a', 0) => 0 */
   /* search94_0 -> 9 in the cache */
   /* search94_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace94 -> 73 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', 0) => 0 */
   /* search95_0 -> 29 in the cache */
   /* search95_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 29, 137 },
      -1,
   } },

   /* replace95 -> 137 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', -1) => a */
   /* search96_0 -> 29 in the cache */
   /* search96_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 29, 139 },
      -1,
   } },

   /* replace96 -> 29 in the cache */

   /* ('fmul', 'a', 1.0) => ('fcanonicalize', 'a') */
   /* search97_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 291 },
      -1,
   } },

   /* replace97_0 -> 9 in the cache */
   /* replace97 -> 120 in the cache */

   /* ('imul', 'a', 1) => a */
   /* search98_0 -> 9 in the cache */
   /* search98_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 9, 47 },
      -1,
   } },

   /* replace98 -> 9 in the cache */

   /* ('fmul', 'a', -1.0) => ('fneg', 'a') */
   /* search99_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 294 },
      -1,
   } },

   /* replace99_0 -> 9 in the cache */
   /* replace99 -> 118 in the cache */

   /* ('imul', 'a', -1) => ('ineg', 'a') */
   /* search100_0 -> 9 in the cache */
   /* search100_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace100_0 -> 9 in the cache */
   /* replace100 -> 121 in the cache */

   /* ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a') */
   /* search101_0_0 -> 9 in the cache */
   /* search101_0 -> 110 in the cache */
   /* search101_1_0 -> 9 in the cache */
   /* search101_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      -1, 0,
      { 9, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 110, 297 },
      -1,
   } },

   /* replace101_0_0 -> 9 in the cache */
   /* replace101_0 -> 11 in the cache */
   /* replace101_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 11, 9 },
      -1,
   } },

   /* ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a') */
   /* search102_0_0_0 -> 9 in the cache */
   /* search102_0_0 -> 110 in the cache */
   /* search102_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 110, 9 },
      -1,
   } },
   /* search102_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 300, 9 },
      -1,
   } },

   /* replace102_0_0 -> 9 in the cache */
   /* replace102_0 -> 11 in the cache */
   /* replace102_1 -> 9 in the cache */
   /* replace102 -> 299 in the cache */

   /* ('ffma(nsz,nnan)', 0.0, 'a', 'b') => ('fcanonicalize', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search103_1 -> 0 in the cache */
   /* search103_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 302, 0, 1 },
      -1,
   } },

   /* replace103_0 -> 1 in the cache */
   /* replace103 -> 252 in the cache */

   /* ('ffma(nsz,nnan)', -0.0, 'a', 'b') => ('fcanonicalize', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x8000000000000000ull /* -0.0 */ },
   } },
   /* search104_1 -> 0 in the cache */
   /* search104_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 304, 0, 1 },
      -1,
   } },

   /* replace104_0 -> 1 in the cache */
   /* replace104 -> 252 in the cache */

   /* ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b') */
   /* search105_0 -> 271 in the cache */
   /* search105_1 -> 29 in the cache */
   /* search105_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 271, 29, 48 },
      -1,
   } },

   /* replace105_0 -> 271 in the cache */
   /* replace105_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 271, 48 },
      -1,
   } },

   /* ('ffmaz', -0.0, 'a', 'b') => ('fadd', 0.0, 'b') */
   /* search106_0 -> 273 in the cache */
   /* search106_1 -> 29 in the cache */
   /* search106_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 273, 29, 48 },
      -1,
   } },

   /* replace106_0 -> 271 in the cache */
   /* replace106_1 -> 48 in the cache */
   /* replace106 -> 307 in the cache */

   /* ('ffma(nsz)', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search107_0 -> 0 in the cache */
   /* search107_1 -> 1 in the cache */
   /* search107_2 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 0, 1, 302 },
      -1,
   } },

   /* replace107_0 -> 0 in the cache */
   /* replace107_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('ffmaz(nsz)', 'a', 'b', 0.0) => ('fmulz', 'a', 'b') */
   /* search108_0 -> 29 in the cache */
   /* search108_1 -> 48 in the cache */
   /* search108_2 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 271 },
      -1,
   } },

   /* replace108_0 -> 29 in the cache */
   /* replace108_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('ffma', 'a', 'b', -0.0) => ('fmul', 'a', 'b') */
   /* search109_0 -> 0 in the cache */
   /* search109_1 -> 1 in the cache */
   /* search109_2 -> 304 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 0, 1, 304 },
      -1,
   } },

   /* replace109_0 -> 0 in the cache */
   /* replace109_1 -> 1 in the cache */
   /* replace109 -> 310 in the cache */

   /* ('ffmaz', 'a', 'b', -0.0) => ('fmulz', 'a', 'b') */
   /* search110_0 -> 29 in the cache */
   /* search110_1 -> 48 in the cache */
   /* search110_2 -> 273 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 273 },
      -1,
   } },

   /* replace110_0 -> 29 in the cache */
   /* replace110_1 -> 48 in the cache */
   /* replace110 -> 312 in the cache */

   /* ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* search111_1 -> 0 in the cache */
   /* search111_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 315, 0, 1 },
      -1,
   } },

   /* replace111_0 -> 0 in the cache */
   /* replace111_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('ffmaz(nsz)', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* search112_1 -> 29 in the cache */
   /* search112_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 318, 29, 48 },
      -1,
   } },

   /* replace112_0 -> 29 in the cache */
   /* replace112_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   /* search113_1 -> 0 in the cache */
   /* search113_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 321, 0, 1 },
      -1,
   } },

   /* replace113_0_0 -> 0 in the cache */
   /* replace113_0 -> 249 in the cache */
   /* replace113_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 249, 1 },
      -1,
   } },

   /* ('ffmaz(nsz)', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   /* search114_1 -> 29 in the cache */
   /* search114_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 324, 29, 48 },
      -1,
   } },

   /* replace114_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 29 },
      -1,
   } },
   /* replace114_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 326, 48 },
      -1,
   } },

   /* ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search115_2 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 328, 329, 144 },
      -1,
   } },

   /* replace115_0_0 -> 141 in the cache */
   /* replace115_0_1 -> 142 in the cache */
   /* replace115_0 -> 143 in the cache */
   /* replace115_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 143, 144 },
      -1,
   } },

   /* ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search116_1 -> 45 in the cache */
   /* search116_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 332, 45, 150 },
      -1,
   } },

   /* replace116_0_0 -> 29 in the cache */
   /* replace116_0_1 -> 48 in the cache */
   /* replace116_0 -> 149 in the cache */
   /* replace116_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 149, 150 },
      -1,
   } },

   /* ('flrp(nnan,nsz)', 'a', 'b', 0.0) => ('fcanonicalize', 'a') */
   /* search117_0 -> 0 in the cache */
   /* search117_1 -> 1 in the cache */
   /* search117_2 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 0, 1, 302 },
      -1,
   } },

   /* replace117_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 0 },
      -1,
   } },

   /* ('flrp(nnan,nsz)', 'a', 'b', -0.0) => ('fcanonicalize', 'a') */
   /* search118_0 -> 0 in the cache */
   /* search118_1 -> 1 in the cache */
   /* search118_2 -> 304 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 0, 1, 304 },
      -1,
   } },

   /* replace118_0 -> 0 in the cache */
   /* replace118 -> 336 in the cache */

   /* ('flrp(nnan,nsz)', 'a', 'b', 1.0) => ('fcanonicalize', 'b') */
   /* search119_0 -> 0 in the cache */
   /* search119_1 -> 1 in the cache */
   /* search119_2 -> 315 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 0, 1, 315 },
      -1,
   } },

   /* replace119_0 -> 1 in the cache */
   /* replace119 -> 252 in the cache */

   /* ('~flrp', 'a', 'a', 'b') => ('fcanonicalize', 'a') */
   /* search120_0 -> 0 in the cache */
   /* search120_1 -> 0 in the cache */
   /* search120_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 0, 0, 1 },
      -1,
   } },

   /* replace120_0 -> 0 in the cache */
   /* replace120 -> 336 in the cache */

   /* ('flrp(nnan,nsz)', 0.0, 'a', 'b') => ('fmul', 'a', 'b') */
   /* search121_0 -> 302 in the cache */
   /* search121_1 -> 0 in the cache */
   /* search121_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 302, 0, 1 },
      -1,
   } },

   /* replace121_0 -> 0 in the cache */
   /* replace121_1 -> 1 in the cache */
   /* replace121 -> 310 in the cache */

   /* ('flrp(nnan,nsz)', -0.0, 'a', 'b') => ('fmul', 'a', 'b') */
   /* search122_0 -> 304 in the cache */
   /* search122_1 -> 0 in the cache */
   /* search122_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 304, 0, 1 },
      -1,
   } },

   /* replace122_0 -> 0 in the cache */
   /* replace122_1 -> 1 in the cache */
   /* replace122 -> 310 in the cache */

   /* ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search123_0 -> 141 in the cache */
   /* search123_1_0 -> 141 in the cache */
   /* search123_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 141, 142 },
      0,
   } },
   /* search123_2 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 141, 342, 144 },
      -1,
   } },

   /* replace123_0_0 -> 142 in the cache */
   /* replace123_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 142, 144 },
      -1,
   } },
   /* replace123_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 344, 141 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 0, 'b') => b */
   /* search124_0 -> 29 in the cache */
   /* search124_1 -> 137 in the cache */
   /* search124_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 29, 137, 48 },
      -1,
   } },

   /* replace124 -> 48 in the cache */

   /* ('udot_4x8_uadd', 'a', 0, 'b') => b */
   /* search125_0 -> 29 in the cache */
   /* search125_1 -> 137 in the cache */
   /* search125_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 29, 137, 48 },
      -1,
   } },

   /* replace125 -> 48 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search126_0 -> 29 in the cache */
   /* search126_1 -> 137 in the cache */
   /* search126_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 29, 137, 48 },
      -1,
   } },

   /* replace126 -> 48 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 0, 'b') => b */
   /* search127_0 -> 29 in the cache */
   /* search127_1 -> 137 in the cache */
   /* search127_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 137, 48 },
      -1,
   } },

   /* replace127 -> 48 in the cache */

   /* ('sdot_2x16_iadd', 'a', 0, 'b') => b */
   /* search128_0 -> 29 in the cache */
   /* search128_1 -> 137 in the cache */
   /* search128_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 29, 137, 48 },
      -1,
   } },

   /* replace128 -> 48 in the cache */

   /* ('udot_2x16_uadd', 'a', 0, 'b') => b */
   /* search129_0 -> 29 in the cache */
   /* search129_1 -> 137 in the cache */
   /* search129_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 29, 137, 48 },
      -1,
   } },

   /* replace129 -> 48 in the cache */

   /* ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b */
   /* search130_0 -> 29 in the cache */
   /* search130_1 -> 137 in the cache */
   /* search130_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 29, 137, 48 },
      -1,
   } },

   /* replace130 -> 48 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 0, 'b') => b */
   /* search131_0 -> 29 in the cache */
   /* search131_1 -> 137 in the cache */
   /* search131_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 29, 137, 48 },
      -1,
   } },

   /* replace131 -> 48 in the cache */

   /* ('sudot_4x8_iadd', 'a', 0, 'b') => b */
   /* search132_0 -> 29 in the cache */
   /* search132_1 -> 137 in the cache */
   /* search132_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 137, 48 },
      -1,
   } },

   /* replace132 -> 48 in the cache */

   /* ('sudot_4x8_iadd', 0, 'a', 'b') => b */
   /* search133_0 -> 137 in the cache */
   /* search133_1 -> 29 in the cache */
   /* search133_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 137, 29, 48 },
      -1,
   } },

   /* replace133 -> 48 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search134_0 -> 29 in the cache */
   /* search134_1 -> 137 in the cache */
   /* search134_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 29, 137, 48 },
      -1,
   } },

   /* replace134 -> 48 in the cache */

   /* ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b */
   /* search135_0 -> 137 in the cache */
   /* search135_1 -> 29 in the cache */
   /* search135_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 137, 29, 48 },
      -1,
   } },

   /* replace135 -> 48 in the cache */

   /* ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search136_0_0 -> 29 in the cache */
   /* search136_0_1 -> 48 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 29, 48, 358 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 359, 360 },
      -1,
   } },

   /* replace136_0 -> 29 in the cache */
   /* replace136_1 -> 48 in the cache */
   /* replace136_2_0 -> 150 in the cache */
   /* replace136_2_1 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 150, 178 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      0, 2,
      { 29, 48, 362 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search137_0_0 -> 29 in the cache */
   /* search137_0_1 -> 48 in the cache */
   /* search137_0_2 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 29, 48, 358 },
      0,
   } },
   /* search137_1 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 364, 360 },
      -1,
   } },

   /* replace137_0 -> 29 in the cache */
   /* replace137_1 -> 48 in the cache */
   /* replace137_2_0 -> 150 in the cache */
   /* replace137_2_1 -> 178 in the cache */
   /* replace137_2 -> 362 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      0, 2,
      { 29, 48, 362 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search138_0_0 -> 29 in the cache */
   /* search138_0_1 -> 48 in the cache */
   /* search138_0_2 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 358 },
      0,
   } },
   /* search138_1 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 367, 360 },
      -1,
   } },

   /* replace138_0 -> 29 in the cache */
   /* replace138_1 -> 48 in the cache */
   /* replace138_2_0 -> 150 in the cache */
   /* replace138_2_1 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 150, 178 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 1,
      { 29, 48, 369 },
      -1,
   } },

   /* ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search139_0_0 -> 29 in the cache */
   /* search139_0_1 -> 48 in the cache */
   /* search139_0_2 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 29, 48, 358 },
      0,
   } },
   /* search139_1 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 371, 360 },
      -1,
   } },

   /* replace139_0 -> 29 in the cache */
   /* replace139_1 -> 48 in the cache */
   /* replace139_2_0 -> 150 in the cache */
   /* replace139_2_1 -> 178 in the cache */
   /* replace139_2 -> 362 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      0, 2,
      { 29, 48, 362 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search140_0_0 -> 29 in the cache */
   /* search140_0_1 -> 48 in the cache */
   /* search140_0_2 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 29, 48, 358 },
      0,
   } },
   /* search140_1 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 374, 360 },
      -1,
   } },

   /* replace140_0 -> 29 in the cache */
   /* replace140_1 -> 48 in the cache */
   /* replace140_2_0 -> 150 in the cache */
   /* replace140_2_1 -> 178 in the cache */
   /* replace140_2 -> 362 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      0, 2,
      { 29, 48, 362 },
      -1,
   } },

   /* ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search141_0_1 -> 48 in the cache */
   /* search141_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 377, 48, 137 },
      -1,
   } },
   /* search141_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 378, 150 },
      -1,
   } },

   /* replace141_0 -> 29 in the cache */
   /* replace141_1 -> 48 in the cache */
   /* replace141_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search142_0_0 -> 377 in the cache */
   /* search142_0_1 -> 48 in the cache */
   /* search142_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 377, 48, 137 },
      -1,
   } },
   /* search142_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 381, 150 },
      -1,
   } },

   /* replace142_0 -> 29 in the cache */
   /* replace142_1 -> 48 in the cache */
   /* replace142_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search143_0_0 -> 377 in the cache */
   /* search143_0_1 -> 48 in the cache */
   /* search143_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 377, 48, 137 },
      -1,
   } },
   /* search143_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 384, 150 },
      -1,
   } },

   /* replace143_0 -> 29 in the cache */
   /* replace143_1 -> 48 in the cache */
   /* replace143_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 150 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search144_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search144_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 387, 137 },
      -1,
   } },
   /* search144_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 388, 150 },
      -1,
   } },

   /* replace144_0 -> 29 in the cache */
   /* replace144_1 -> 48 in the cache */
   /* replace144_2 -> 150 in the cache */
   /* replace144 -> 386 in the cache */

   /* ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c') */
   /* search145_0_0 -> 377 in the cache */
   /* search145_0_1 -> 48 in the cache */
   /* search145_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 377, 48, 137 },
      -1,
   } },
   /* search145_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 390, 150 },
      -1,
   } },

   /* replace145_0 -> 29 in the cache */
   /* replace145_1 -> 48 in the cache */
   /* replace145_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c') */
   /* search146_0_0 -> 377 in the cache */
   /* search146_0_1 -> 48 in the cache */
   /* search146_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 377, 48, 137 },
      -1,
   } },
   /* search146_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 393, 150 },
      -1,
   } },

   /* replace146_0 -> 29 in the cache */
   /* replace146_1 -> 48 in the cache */
   /* replace146_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search147_0 -> 332 in the cache */
   /* search147_1 -> 45 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 332, 45, 396 },
      -1,
   } },

   /* replace147_0_0 -> 29 in the cache */
   /* replace147_0_1 -> 48 in the cache */
   /* replace147_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 29, 48, 137 },
      -1,
   } },
   /* replace147_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 398, 150 },
      -1,
   } },

   /* ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search148_0 -> 332 in the cache */
   /* search148_1 -> 45 in the cache */
   /* search148_2 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 332, 45, 396 },
      -1,
   } },

   /* replace148_0_0 -> 29 in the cache */
   /* replace148_0_1 -> 48 in the cache */
   /* replace148_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 29, 48, 137 },
      -1,
   } },
   /* replace148_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 401, 150 },
      -1,
   } },

   /* ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search149_0 -> 332 in the cache */
   /* search149_1 -> 45 in the cache */
   /* search149_2 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 332, 45, 396 },
      -1,
   } },

   /* replace149_0_0 -> 29 in the cache */
   /* replace149_0_1 -> 48 in the cache */
   /* replace149_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 137 },
      -1,
   } },
   /* replace149_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 404, 150 },
      -1,
   } },

   /* ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search150_0 -> 332 in the cache */
   /* search150_1 -> 45 in the cache */
   /* search150_2 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 332, 45, 396 },
      -1,
   } },

   /* replace150_0_0 -> 29 in the cache */
   /* replace150_0_1 -> 48 in the cache */
   /* replace150_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 29, 48, 137 },
      -1,
   } },
   /* replace150_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 407, 150 },
      -1,
   } },

   /* ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search151_0 -> 332 in the cache */
   /* search151_1 -> 45 in the cache */
   /* search151_2 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 332, 45, 396 },
      -1,
   } },

   /* replace151_0_0 -> 29 in the cache */
   /* replace151_0_1 -> 48 in the cache */
   /* replace151_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 29, 48, 137 },
      -1,
   } },
   /* replace151_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 410, 150 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search152_0 -> 332 in the cache */
   /* search152_1 -> 45 in the cache */
   /* search152_2 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 332, 45, 396 },
      -1,
   } },

   /* replace152_0_0 -> 29 in the cache */
   /* replace152_0_1 -> 48 in the cache */
   /* replace152_0_2 -> 137 in the cache */
   /* replace152_0 -> 398 in the cache */
   /* replace152_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd_sat,
      0, 2,
      { 398, 150 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search153_0 -> 332 in the cache */
   /* search153_1 -> 45 in the cache */
   /* search153_2 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 332, 45, 396 },
      -1,
   } },

   /* replace153_0_0 -> 29 in the cache */
   /* replace153_0_1 -> 48 in the cache */
   /* replace153_0_2 -> 137 in the cache */
   /* replace153_0 -> 401 in the cache */
   /* replace153_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uadd_sat,
      0, 2,
      { 401, 150 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search154_0 -> 332 in the cache */
   /* search154_1 -> 45 in the cache */
   /* search154_2 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 332, 45, 396 },
      -1,
   } },

   /* replace154_0_0 -> 29 in the cache */
   /* replace154_0_1 -> 48 in the cache */
   /* replace154_0_2 -> 137 in the cache */
   /* replace154_0 -> 404 in the cache */
   /* replace154_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd_sat,
      0, 1,
      { 404, 150 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search155_0 -> 332 in the cache */
   /* search155_1 -> 45 in the cache */
   /* search155_2 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 332, 45, 396 },
      -1,
   } },

   /* replace155_0_0 -> 29 in the cache */
   /* replace155_0_1 -> 48 in the cache */
   /* replace155_0_2 -> 137 in the cache */
   /* replace155_0 -> 407 in the cache */
   /* replace155_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd_sat,
      0, 2,
      { 407, 150 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search156_0 -> 332 in the cache */
   /* search156_1 -> 45 in the cache */
   /* search156_2 -> 396 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 332, 45, 396 },
      -1,
   } },

   /* replace156_0_0 -> 29 in the cache */
   /* replace156_0_1 -> 48 in the cache */
   /* replace156_0_2 -> 137 in the cache */
   /* replace156_0 -> 410 in the cache */
   /* replace156_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uadd_sat,
      0, 2,
      { 410, 150 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b'))) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search157_0_0_1 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      1, 1,
      { 422, 271 },
      -1,
   } },
   /* search157_0_1 -> 271 in the cache */
   /* search157_0_2_0_0 -> 198 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 198 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 424 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 423, 271, 425 },
      -1,
   } },
   /* search157_1_0_0 -> 198 in the cache */
   /* search157_1_0_1 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      2, 1,
      { 198, 271 },
      -1,
   } },
   /* search157_1_1 -> 271 in the cache */
   /* search157_1_2_0_0 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 422 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 428 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 427, 271, 429 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 426, 430 },
      -1,
   } },

   /* replace157_0_0_0 -> 198 in the cache */
   /* replace157_0_0 -> 424 in the cache */
   /* replace157_0 -> 425 in the cache */
   /* replace157_1_0_0 -> 422 in the cache */
   /* replace157_1_0 -> 428 in the cache */
   /* replace157_1 -> 429 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 425, 429 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b')) */
   /* search158_0_0_0 -> 422 in the cache */
   /* search158_0_0_1 -> 271 in the cache */
   /* search158_0_0 -> 423 in the cache */
   /* search158_0_1 -> 271 in the cache */
   /* search158_0_2_0_0 -> 198 in the cache */
   /* search158_0_2_0 -> 424 in the cache */
   /* search158_0_2 -> 425 in the cache */
   /* search158_0 -> 426 in the cache */
   /* search158_1_0_0 -> 198 in the cache */
   /* search158_1_0_1 -> 271 in the cache */
   /* search158_1_0 -> 427 in the cache */
   /* search158_1_1 -> 271 in the cache */
   /* search158_1_2_0 -> 422 in the cache */
   /* search158_1_2 -> 428 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 427, 271, 428 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 426, 433 },
      -1,
   } },

   /* replace158_0_0_0 -> 198 in the cache */
   /* replace158_0_0 -> 424 in the cache */
   /* replace158_0 -> 425 in the cache */
   /* replace158_1_0 -> 422 in the cache */
   /* replace158_1 -> 428 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 425, 428 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b')) */
   /* search159_0_0_0 -> 422 in the cache */
   /* search159_0_0_1 -> 271 in the cache */
   /* search159_0_0 -> 423 in the cache */
   /* search159_0_1 -> 271 in the cache */
   /* search159_0_2_0_0 -> 198 in the cache */
   /* search159_0_2_0 -> 424 in the cache */
   /* search159_0_2 -> 425 in the cache */
   /* search159_0 -> 426 in the cache */
   /* search159_1_0_0 -> 198 in the cache */
   /* search159_1_0_1 -> 271 in the cache */
   /* search159_1_0 -> 427 in the cache */
   /* search159_1_1 -> 271 in the cache */
   /* search159_1_2_0 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 422 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 427, 271, 436 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 426, 437 },
      -1,
   } },

   /* replace159_0_0_0 -> 198 in the cache */
   /* replace159_0_0 -> 424 in the cache */
   /* replace159_0 -> 425 in the cache */
   /* replace159_1_0 -> 422 in the cache */
   /* replace159_1 -> 436 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 425, 436 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search160_0_0_0 -> 422 in the cache */
   /* search160_0_0_1 -> 271 in the cache */
   /* search160_0_0 -> 423 in the cache */
   /* search160_0_1 -> 271 in the cache */
   /* search160_0_2_0_0 -> 198 in the cache */
   /* search160_0_2_0 -> 424 in the cache */
   /* search160_0_2 -> 425 in the cache */
   /* search160_0 -> 426 in the cache */
   /* search160_1_0_0 -> 198 in the cache */
   /* search160_1_0_1 -> 271 in the cache */
   /* search160_1_0 -> 427 in the cache */
   /* search160_1_1 -> 271 in the cache */
   /* search160_1_2 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 427, 271, 422 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 426, 440 },
      -1,
   } },

   /* replace160_0_0_0 -> 198 in the cache */
   /* replace160_0_0 -> 424 in the cache */
   /* replace160_0 -> 425 in the cache */
   /* replace160_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 425, 422 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b')) */
   /* search161_0_0_0 -> 422 in the cache */
   /* search161_0_0_1 -> 271 in the cache */
   /* search161_0_0 -> 423 in the cache */
   /* search161_0_1 -> 271 in the cache */
   /* search161_0_2_0 -> 198 in the cache */
   /* search161_0_2 -> 424 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 423, 271, 424 },
      -1,
   } },
   /* search161_1_0_0 -> 198 in the cache */
   /* search161_1_0_1 -> 271 in the cache */
   /* search161_1_0 -> 427 in the cache */
   /* search161_1_1 -> 271 in the cache */
   /* search161_1_2_0 -> 422 in the cache */
   /* search161_1_2 -> 428 in the cache */
   /* search161_1 -> 433 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 443, 433 },
      -1,
   } },

   /* replace161_0_0 -> 198 in the cache */
   /* replace161_0 -> 424 in the cache */
   /* replace161_1_0 -> 422 in the cache */
   /* replace161_1 -> 428 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 424, 428 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b')) */
   /* search162_0_0_0 -> 422 in the cache */
   /* search162_0_0_1 -> 271 in the cache */
   /* search162_0_0 -> 423 in the cache */
   /* search162_0_1 -> 271 in the cache */
   /* search162_0_2_0 -> 198 in the cache */
   /* search162_0_2 -> 424 in the cache */
   /* search162_0 -> 443 in the cache */
   /* search162_1_0_0 -> 198 in the cache */
   /* search162_1_0_1 -> 271 in the cache */
   /* search162_1_0 -> 427 in the cache */
   /* search162_1_1 -> 271 in the cache */
   /* search162_1_2_0 -> 422 in the cache */
   /* search162_1_2 -> 436 in the cache */
   /* search162_1 -> 437 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 443, 437 },
      -1,
   } },

   /* replace162_0_0 -> 198 in the cache */
   /* replace162_0 -> 424 in the cache */
   /* replace162_1_0 -> 422 in the cache */
   /* replace162_1 -> 436 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 424, 436 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search163_0_0_0 -> 422 in the cache */
   /* search163_0_0_1 -> 271 in the cache */
   /* search163_0_0 -> 423 in the cache */
   /* search163_0_1 -> 271 in the cache */
   /* search163_0_2_0 -> 198 in the cache */
   /* search163_0_2 -> 424 in the cache */
   /* search163_0 -> 443 in the cache */
   /* search163_1_0_0 -> 198 in the cache */
   /* search163_1_0_1 -> 271 in the cache */
   /* search163_1_0 -> 427 in the cache */
   /* search163_1_1 -> 271 in the cache */
   /* search163_1_2 -> 422 in the cache */
   /* search163_1 -> 440 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 443, 440 },
      -1,
   } },

   /* replace163_0_0 -> 198 in the cache */
   /* replace163_0 -> 424 in the cache */
   /* replace163_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 424, 422 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b')) */
   /* search164_0_0_0 -> 422 in the cache */
   /* search164_0_0_1 -> 271 in the cache */
   /* search164_0_0 -> 423 in the cache */
   /* search164_0_1 -> 271 in the cache */
   /* search164_0_2_0 -> 198 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 198 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 423, 271, 450 },
      -1,
   } },
   /* search164_1_0_0 -> 198 in the cache */
   /* search164_1_0_1 -> 271 in the cache */
   /* search164_1_0 -> 427 in the cache */
   /* search164_1_1 -> 271 in the cache */
   /* search164_1_2_0 -> 422 in the cache */
   /* search164_1_2 -> 436 in the cache */
   /* search164_1 -> 437 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 451, 437 },
      -1,
   } },

   /* replace164_0_0 -> 198 in the cache */
   /* replace164_0 -> 450 in the cache */
   /* replace164_1_0 -> 422 in the cache */
   /* replace164_1 -> 436 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 450, 436 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search165_0_0_0 -> 422 in the cache */
   /* search165_0_0_1 -> 271 in the cache */
   /* search165_0_0 -> 423 in the cache */
   /* search165_0_1 -> 271 in the cache */
   /* search165_0_2_0 -> 198 in the cache */
   /* search165_0_2 -> 450 in the cache */
   /* search165_0 -> 451 in the cache */
   /* search165_1_0_0 -> 198 in the cache */
   /* search165_1_0_1 -> 271 in the cache */
   /* search165_1_0 -> 427 in the cache */
   /* search165_1_1 -> 271 in the cache */
   /* search165_1_2 -> 422 in the cache */
   /* search165_1 -> 440 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 451, 440 },
      -1,
   } },

   /* replace165_0_0 -> 198 in the cache */
   /* replace165_0 -> 450 in the cache */
   /* replace165_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 450, 422 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   /* search166_0_0_0 -> 422 in the cache */
   /* search166_0_0_1 -> 271 in the cache */
   /* search166_0_0 -> 423 in the cache */
   /* search166_0_1 -> 271 in the cache */
   /* search166_0_2 -> 198 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 423, 271, 198 },
      -1,
   } },
   /* search166_1_0_0 -> 198 in the cache */
   /* search166_1_0_1 -> 271 in the cache */
   /* search166_1_0 -> 427 in the cache */
   /* search166_1_1 -> 271 in the cache */
   /* search166_1_2 -> 422 in the cache */
   /* search166_1 -> 440 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 456, 440 },
      -1,
   } },

   /* replace166_0 -> 198 in the cache */
   /* replace166_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 198, 422 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b'))) */
   /* search167_0_0_0 -> 422 in the cache */
   /* search167_0_0_1 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      1, 1,
      { 422, 271 },
      -1,
   } },
   /* search167_0_1_0_0 -> 198 in the cache */
   /* search167_0_1_0 -> 424 in the cache */
   /* search167_0_1 -> 425 in the cache */
   /* search167_0_2 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 459, 425, 271 },
      -1,
   } },
   /* search167_1_0_0 -> 198 in the cache */
   /* search167_1_0_1 -> 271 in the cache */
   /* search167_1_0 -> 427 in the cache */
   /* search167_1_1 -> 271 in the cache */
   /* search167_1_2_0_0 -> 422 in the cache */
   /* search167_1_2_0 -> 428 in the cache */
   /* search167_1_2 -> 429 in the cache */
   /* search167_1 -> 430 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 460, 430 },
      -1,
   } },

   /* replace167_0_0_0 -> 198 in the cache */
   /* replace167_0_0 -> 424 in the cache */
   /* replace167_0 -> 425 in the cache */
   /* replace167_1_0_0 -> 422 in the cache */
   /* replace167_1_0 -> 428 in the cache */
   /* replace167_1 -> 429 in the cache */
   /* replace167 -> 432 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b')) */
   /* search168_0_0_0 -> 422 in the cache */
   /* search168_0_0_1 -> 271 in the cache */
   /* search168_0_0 -> 459 in the cache */
   /* search168_0_1_0_0 -> 198 in the cache */
   /* search168_0_1_0 -> 424 in the cache */
   /* search168_0_1 -> 425 in the cache */
   /* search168_0_2 -> 271 in the cache */
   /* search168_0 -> 460 in the cache */
   /* search168_1_0_0 -> 198 in the cache */
   /* search168_1_0_1 -> 271 in the cache */
   /* search168_1_0 -> 427 in the cache */
   /* search168_1_1 -> 271 in the cache */
   /* search168_1_2_0 -> 422 in the cache */
   /* search168_1_2 -> 428 in the cache */
   /* search168_1 -> 433 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 460, 433 },
      -1,
   } },

   /* replace168_0_0_0 -> 198 in the cache */
   /* replace168_0_0 -> 424 in the cache */
   /* replace168_0 -> 425 in the cache */
   /* replace168_1_0 -> 422 in the cache */
   /* replace168_1 -> 428 in the cache */
   /* replace168 -> 435 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b')) */
   /* search169_0_0_0 -> 422 in the cache */
   /* search169_0_0_1 -> 271 in the cache */
   /* search169_0_0 -> 459 in the cache */
   /* search169_0_1_0_0 -> 198 in the cache */
   /* search169_0_1_0 -> 424 in the cache */
   /* search169_0_1 -> 425 in the cache */
   /* search169_0_2 -> 271 in the cache */
   /* search169_0 -> 460 in the cache */
   /* search169_1_0_0 -> 198 in the cache */
   /* search169_1_0_1 -> 271 in the cache */
   /* search169_1_0 -> 427 in the cache */
   /* search169_1_1 -> 271 in the cache */
   /* search169_1_2_0 -> 422 in the cache */
   /* search169_1_2 -> 436 in the cache */
   /* search169_1 -> 437 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 460, 437 },
      -1,
   } },

   /* replace169_0_0_0 -> 198 in the cache */
   /* replace169_0_0 -> 424 in the cache */
   /* replace169_0 -> 425 in the cache */
   /* replace169_1_0 -> 422 in the cache */
   /* replace169_1 -> 436 in the cache */
   /* replace169 -> 439 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search170_0_0_0 -> 422 in the cache */
   /* search170_0_0_1 -> 271 in the cache */
   /* search170_0_0 -> 459 in the cache */
   /* search170_0_1_0_0 -> 198 in the cache */
   /* search170_0_1_0 -> 424 in the cache */
   /* search170_0_1 -> 425 in the cache */
   /* search170_0_2 -> 271 in the cache */
   /* search170_0 -> 460 in the cache */
   /* search170_1_0_0 -> 198 in the cache */
   /* search170_1_0_1 -> 271 in the cache */
   /* search170_1_0 -> 427 in the cache */
   /* search170_1_1 -> 271 in the cache */
   /* search170_1_2 -> 422 in the cache */
   /* search170_1 -> 440 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 460, 440 },
      -1,
   } },

   /* replace170_0_0_0 -> 198 in the cache */
   /* replace170_0_0 -> 424 in the cache */
   /* replace170_0 -> 425 in the cache */
   /* replace170_1 -> 422 in the cache */
   /* replace170 -> 442 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b')) */
   /* search171_0_0_0 -> 422 in the cache */
   /* search171_0_0_1 -> 271 in the cache */
   /* search171_0_0 -> 459 in the cache */
   /* search171_0_1_0 -> 198 in the cache */
   /* search171_0_1 -> 424 in the cache */
   /* search171_0_2 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 459, 424, 271 },
      -1,
   } },
   /* search171_1_0_0 -> 198 in the cache */
   /* search171_1_0_1 -> 271 in the cache */
   /* search171_1_0 -> 427 in the cache */
   /* search171_1_1 -> 271 in the cache */
   /* search171_1_2_0 -> 422 in the cache */
   /* search171_1_2 -> 428 in the cache */
   /* search171_1 -> 433 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 465, 433 },
      -1,
   } },

   /* replace171_0_0 -> 198 in the cache */
   /* replace171_0 -> 424 in the cache */
   /* replace171_1_0 -> 422 in the cache */
   /* replace171_1 -> 428 in the cache */
   /* replace171 -> 445 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b')) */
   /* search172_0_0_0 -> 422 in the cache */
   /* search172_0_0_1 -> 271 in the cache */
   /* search172_0_0 -> 459 in the cache */
   /* search172_0_1_0 -> 198 in the cache */
   /* search172_0_1 -> 424 in the cache */
   /* search172_0_2 -> 271 in the cache */
   /* search172_0 -> 465 in the cache */
   /* search172_1_0_0 -> 198 in the cache */
   /* search172_1_0_1 -> 271 in the cache */
   /* search172_1_0 -> 427 in the cache */
   /* search172_1_1 -> 271 in the cache */
   /* search172_1_2_0 -> 422 in the cache */
   /* search172_1_2 -> 436 in the cache */
   /* search172_1 -> 437 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 465, 437 },
      -1,
   } },

   /* replace172_0_0 -> 198 in the cache */
   /* replace172_0 -> 424 in the cache */
   /* replace172_1_0 -> 422 in the cache */
   /* replace172_1 -> 436 in the cache */
   /* replace172 -> 447 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search173_0_0_0 -> 422 in the cache */
   /* search173_0_0_1 -> 271 in the cache */
   /* search173_0_0 -> 459 in the cache */
   /* search173_0_1_0 -> 198 in the cache */
   /* search173_0_1 -> 424 in the cache */
   /* search173_0_2 -> 271 in the cache */
   /* search173_0 -> 465 in the cache */
   /* search173_1_0_0 -> 198 in the cache */
   /* search173_1_0_1 -> 271 in the cache */
   /* search173_1_0 -> 427 in the cache */
   /* search173_1_1 -> 271 in the cache */
   /* search173_1_2 -> 422 in the cache */
   /* search173_1 -> 440 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 465, 440 },
      -1,
   } },

   /* replace173_0_0 -> 198 in the cache */
   /* replace173_0 -> 424 in the cache */
   /* replace173_1 -> 422 in the cache */
   /* replace173 -> 449 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b')) */
   /* search174_0_0_0 -> 422 in the cache */
   /* search174_0_0_1 -> 271 in the cache */
   /* search174_0_0 -> 459 in the cache */
   /* search174_0_1_0 -> 198 in the cache */
   /* search174_0_1 -> 450 in the cache */
   /* search174_0_2 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 459, 450, 271 },
      -1,
   } },
   /* search174_1_0_0 -> 198 in the cache */
   /* search174_1_0_1 -> 271 in the cache */
   /* search174_1_0 -> 427 in the cache */
   /* search174_1_1 -> 271 in the cache */
   /* search174_1_2_0 -> 422 in the cache */
   /* search174_1_2 -> 436 in the cache */
   /* search174_1 -> 437 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 469, 437 },
      -1,
   } },

   /* replace174_0_0 -> 198 in the cache */
   /* replace174_0 -> 450 in the cache */
   /* replace174_1_0 -> 422 in the cache */
   /* replace174_1 -> 436 in the cache */
   /* replace174 -> 453 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search175_0_0_0 -> 422 in the cache */
   /* search175_0_0_1 -> 271 in the cache */
   /* search175_0_0 -> 459 in the cache */
   /* search175_0_1_0 -> 198 in the cache */
   /* search175_0_1 -> 450 in the cache */
   /* search175_0_2 -> 271 in the cache */
   /* search175_0 -> 469 in the cache */
   /* search175_1_0_0 -> 198 in the cache */
   /* search175_1_0_1 -> 271 in the cache */
   /* search175_1_0 -> 427 in the cache */
   /* search175_1_1 -> 271 in the cache */
   /* search175_1_2 -> 422 in the cache */
   /* search175_1 -> 440 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 469, 440 },
      -1,
   } },

   /* replace175_0_0 -> 198 in the cache */
   /* replace175_0 -> 450 in the cache */
   /* replace175_1 -> 422 in the cache */
   /* replace175 -> 455 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), 'a', 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   /* search176_0_0_0 -> 422 in the cache */
   /* search176_0_0_1 -> 271 in the cache */
   /* search176_0_0 -> 459 in the cache */
   /* search176_0_1 -> 198 in the cache */
   /* search176_0_2 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 459, 198, 271 },
      -1,
   } },
   /* search176_1_0_0 -> 198 in the cache */
   /* search176_1_0_1 -> 271 in the cache */
   /* search176_1_0 -> 427 in the cache */
   /* search176_1_1 -> 271 in the cache */
   /* search176_1_2 -> 422 in the cache */
   /* search176_1 -> 440 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 472, 440 },
      -1,
   } },

   /* replace176_0 -> 198 in the cache */
   /* replace176_1 -> 422 in the cache */
   /* replace176 -> 458 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'b')), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b'))) */
   /* search177_0_0_0 -> 422 in the cache */
   /* search177_0_0_1 -> 271 in the cache */
   /* search177_0_0 -> 459 in the cache */
   /* search177_0_1_0_0 -> 198 in the cache */
   /* search177_0_1_0 -> 424 in the cache */
   /* search177_0_1 -> 425 in the cache */
   /* search177_0_2 -> 271 in the cache */
   /* search177_0 -> 460 in the cache */
   /* search177_1_0_0 -> 198 in the cache */
   /* search177_1_0_1 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      2, 1,
      { 198, 271 },
      -1,
   } },
   /* search177_1_1_0_0 -> 422 in the cache */
   /* search177_1_1_0 -> 428 in the cache */
   /* search177_1_1 -> 429 in the cache */
   /* search177_1_2 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 474, 429, 271 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 460, 475 },
      -1,
   } },

   /* replace177_0_0_0 -> 198 in the cache */
   /* replace177_0_0 -> 424 in the cache */
   /* replace177_0 -> 425 in the cache */
   /* replace177_1_0_0 -> 422 in the cache */
   /* replace177_1_0 -> 428 in the cache */
   /* replace177_1 -> 429 in the cache */
   /* replace177 -> 432 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fabs', 'b'), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b')) */
   /* search178_0_0_0 -> 422 in the cache */
   /* search178_0_0_1 -> 271 in the cache */
   /* search178_0_0 -> 459 in the cache */
   /* search178_0_1_0_0 -> 198 in the cache */
   /* search178_0_1_0 -> 424 in the cache */
   /* search178_0_1 -> 425 in the cache */
   /* search178_0_2 -> 271 in the cache */
   /* search178_0 -> 460 in the cache */
   /* search178_1_0_0 -> 198 in the cache */
   /* search178_1_0_1 -> 271 in the cache */
   /* search178_1_0 -> 474 in the cache */
   /* search178_1_1_0 -> 422 in the cache */
   /* search178_1_1 -> 428 in the cache */
   /* search178_1_2 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 474, 428, 271 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 460, 477 },
      -1,
   } },

   /* replace178_0_0_0 -> 198 in the cache */
   /* replace178_0_0 -> 424 in the cache */
   /* replace178_0 -> 425 in the cache */
   /* replace178_1_0 -> 422 in the cache */
   /* replace178_1 -> 428 in the cache */
   /* replace178 -> 435 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b')) */
   /* search179_0_0_0 -> 422 in the cache */
   /* search179_0_0_1 -> 271 in the cache */
   /* search179_0_0 -> 459 in the cache */
   /* search179_0_1_0_0 -> 198 in the cache */
   /* search179_0_1_0 -> 424 in the cache */
   /* search179_0_1 -> 425 in the cache */
   /* search179_0_2 -> 271 in the cache */
   /* search179_0 -> 460 in the cache */
   /* search179_1_0_0 -> 198 in the cache */
   /* search179_1_0_1 -> 271 in the cache */
   /* search179_1_0 -> 474 in the cache */
   /* search179_1_1_0 -> 422 in the cache */
   /* search179_1_1 -> 436 in the cache */
   /* search179_1_2 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 474, 436, 271 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 460, 479 },
      -1,
   } },

   /* replace179_0_0_0 -> 198 in the cache */
   /* replace179_0_0 -> 424 in the cache */
   /* replace179_0 -> 425 in the cache */
   /* replace179_1_0 -> 422 in the cache */
   /* replace179_1 -> 436 in the cache */
   /* replace179 -> 439 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search180_0_0_0 -> 422 in the cache */
   /* search180_0_0_1 -> 271 in the cache */
   /* search180_0_0 -> 459 in the cache */
   /* search180_0_1_0_0 -> 198 in the cache */
   /* search180_0_1_0 -> 424 in the cache */
   /* search180_0_1 -> 425 in the cache */
   /* search180_0_2 -> 271 in the cache */
   /* search180_0 -> 460 in the cache */
   /* search180_1_0_0 -> 198 in the cache */
   /* search180_1_0_1 -> 271 in the cache */
   /* search180_1_0 -> 474 in the cache */
   /* search180_1_1 -> 422 in the cache */
   /* search180_1_2 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 474, 422, 271 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 460, 481 },
      -1,
   } },

   /* replace180_0_0_0 -> 198 in the cache */
   /* replace180_0_0 -> 424 in the cache */
   /* replace180_0 -> 425 in the cache */
   /* replace180_1 -> 422 in the cache */
   /* replace180 -> 442 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fabs', 'b'), 0.0)) => ('fmulz', ('fabs', 'a'), ('fabs', 'b')) */
   /* search181_0_0_0 -> 422 in the cache */
   /* search181_0_0_1 -> 271 in the cache */
   /* search181_0_0 -> 459 in the cache */
   /* search181_0_1_0 -> 198 in the cache */
   /* search181_0_1 -> 424 in the cache */
   /* search181_0_2 -> 271 in the cache */
   /* search181_0 -> 465 in the cache */
   /* search181_1_0_0 -> 198 in the cache */
   /* search181_1_0_1 -> 271 in the cache */
   /* search181_1_0 -> 474 in the cache */
   /* search181_1_1_0 -> 422 in the cache */
   /* search181_1_1 -> 428 in the cache */
   /* search181_1_2 -> 271 in the cache */
   /* search181_1 -> 477 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 465, 477 },
      -1,
   } },

   /* replace181_0_0 -> 198 in the cache */
   /* replace181_0 -> 424 in the cache */
   /* replace181_1_0 -> 422 in the cache */
   /* replace181_1 -> 428 in the cache */
   /* replace181 -> 445 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fabs', 'a'), ('fneg', 'b')) */
   /* search182_0_0_0 -> 422 in the cache */
   /* search182_0_0_1 -> 271 in the cache */
   /* search182_0_0 -> 459 in the cache */
   /* search182_0_1_0 -> 198 in the cache */
   /* search182_0_1 -> 424 in the cache */
   /* search182_0_2 -> 271 in the cache */
   /* search182_0 -> 465 in the cache */
   /* search182_1_0_0 -> 198 in the cache */
   /* search182_1_0_1 -> 271 in the cache */
   /* search182_1_0 -> 474 in the cache */
   /* search182_1_1_0 -> 422 in the cache */
   /* search182_1_1 -> 436 in the cache */
   /* search182_1_2 -> 271 in the cache */
   /* search182_1 -> 479 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 465, 479 },
      -1,
   } },

   /* replace182_0_0 -> 198 in the cache */
   /* replace182_0 -> 424 in the cache */
   /* replace182_1_0 -> 422 in the cache */
   /* replace182_1 -> 436 in the cache */
   /* replace182 -> 447 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search183_0_0_0 -> 422 in the cache */
   /* search183_0_0_1 -> 271 in the cache */
   /* search183_0_0 -> 459 in the cache */
   /* search183_0_1_0 -> 198 in the cache */
   /* search183_0_1 -> 424 in the cache */
   /* search183_0_2 -> 271 in the cache */
   /* search183_0 -> 465 in the cache */
   /* search183_1_0_0 -> 198 in the cache */
   /* search183_1_0_1 -> 271 in the cache */
   /* search183_1_0 -> 474 in the cache */
   /* search183_1_1 -> 422 in the cache */
   /* search183_1_2 -> 271 in the cache */
   /* search183_1 -> 481 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 465, 481 },
      -1,
   } },

   /* replace183_0_0 -> 198 in the cache */
   /* replace183_0 -> 424 in the cache */
   /* replace183_1 -> 422 in the cache */
   /* replace183 -> 449 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fneg', 'a'), ('fneg', 'b')) */
   /* search184_0_0_0 -> 422 in the cache */
   /* search184_0_0_1 -> 271 in the cache */
   /* search184_0_0 -> 459 in the cache */
   /* search184_0_1_0 -> 198 in the cache */
   /* search184_0_1 -> 450 in the cache */
   /* search184_0_2 -> 271 in the cache */
   /* search184_0 -> 469 in the cache */
   /* search184_1_0_0 -> 198 in the cache */
   /* search184_1_0_1 -> 271 in the cache */
   /* search184_1_0 -> 474 in the cache */
   /* search184_1_1_0 -> 422 in the cache */
   /* search184_1_1 -> 436 in the cache */
   /* search184_1_2 -> 271 in the cache */
   /* search184_1 -> 479 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 469, 479 },
      -1,
   } },

   /* replace184_0_0 -> 198 in the cache */
   /* replace184_0 -> 450 in the cache */
   /* replace184_1_0 -> 422 in the cache */
   /* replace184_1 -> 436 in the cache */
   /* replace184 -> 453 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search185_0_0_0 -> 422 in the cache */
   /* search185_0_0_1 -> 271 in the cache */
   /* search185_0_0 -> 459 in the cache */
   /* search185_0_1_0 -> 198 in the cache */
   /* search185_0_1 -> 450 in the cache */
   /* search185_0_2 -> 271 in the cache */
   /* search185_0 -> 469 in the cache */
   /* search185_1_0_0 -> 198 in the cache */
   /* search185_1_0_1 -> 271 in the cache */
   /* search185_1_0 -> 474 in the cache */
   /* search185_1_1 -> 422 in the cache */
   /* search185_1_2 -> 271 in the cache */
   /* search185_1 -> 481 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 469, 481 },
      -1,
   } },

   /* replace185_0_0 -> 198 in the cache */
   /* replace185_0 -> 450 in the cache */
   /* replace185_1 -> 422 in the cache */
   /* replace185 -> 455 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), 'a', 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', 'a', 'b') */
   /* search186_0_0_0 -> 422 in the cache */
   /* search186_0_0_1 -> 271 in the cache */
   /* search186_0_0 -> 459 in the cache */
   /* search186_0_1 -> 198 in the cache */
   /* search186_0_2 -> 271 in the cache */
   /* search186_0 -> 472 in the cache */
   /* search186_1_0_0 -> 198 in the cache */
   /* search186_1_0_1 -> 271 in the cache */
   /* search186_1_0 -> 474 in the cache */
   /* search186_1_1 -> 422 in the cache */
   /* search186_1_2 -> 271 in the cache */
   /* search186_1 -> 481 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 472, 481 },
      -1,
   } },

   /* replace186_0 -> 198 in the cache */
   /* replace186_1 -> 422 in the cache */
   /* replace186 -> 458 in the cache */

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b'))) */
   /* search187_0_0_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 29 },
      -1,
   } },
   /* search187_0_0_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 1,
      { 489, 490 },
      -1,
   } },
   /* search187_0_1 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 2,
      { 491, 271 },
      -1,
   } },
   /* search187_1 -> 271 in the cache */
   /* search187_2_0_0_0 -> 29 in the cache */
   /* search187_2_0_0 -> 489 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 489 },
      -1,
   } },
   /* search187_2_1_0_0 -> 48 in the cache */
   /* search187_2_1_0 -> 490 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 490 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 493, 494 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 492, 271, 495 },
      -1,
   } },

   /* replace187_0_0_0 -> 29 in the cache */
   /* replace187_0_0 -> 489 in the cache */
   /* replace187_0 -> 493 in the cache */
   /* replace187_1_0_0 -> 48 in the cache */
   /* replace187_1_0 -> 490 in the cache */
   /* replace187_1 -> 494 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 493, 494 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b')) */
   /* search188_0_0_0_0 -> 29 in the cache */
   /* search188_0_0_0 -> 489 in the cache */
   /* search188_0_0_1_0 -> 48 in the cache */
   /* search188_0_0_1 -> 490 in the cache */
   /* search188_0_0 -> 491 in the cache */
   /* search188_0_1 -> 271 in the cache */
   /* search188_0 -> 492 in the cache */
   /* search188_1 -> 271 in the cache */
   /* search188_2_0_0_0 -> 29 in the cache */
   /* search188_2_0_0 -> 489 in the cache */
   /* search188_2_0 -> 493 in the cache */
   /* search188_2_1_0 -> 48 in the cache */
   /* search188_2_1 -> 490 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 493, 490 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 492, 271, 498 },
      -1,
   } },

   /* replace188_0_0_0 -> 29 in the cache */
   /* replace188_0_0 -> 489 in the cache */
   /* replace188_0 -> 493 in the cache */
   /* replace188_1_0 -> 48 in the cache */
   /* replace188_1 -> 490 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 493, 490 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b')) */
   /* search189_0_0_0_0 -> 29 in the cache */
   /* search189_0_0_0 -> 489 in the cache */
   /* search189_0_0_1_0 -> 48 in the cache */
   /* search189_0_0_1 -> 490 in the cache */
   /* search189_0_0 -> 491 in the cache */
   /* search189_0_1 -> 271 in the cache */
   /* search189_0 -> 492 in the cache */
   /* search189_1 -> 271 in the cache */
   /* search189_2_0_0_0 -> 29 in the cache */
   /* search189_2_0_0 -> 489 in the cache */
   /* search189_2_0 -> 493 in the cache */
   /* search189_2_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 493, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 492, 271, 502 },
      -1,
   } },

   /* replace189_0_0_0 -> 29 in the cache */
   /* replace189_0_0 -> 489 in the cache */
   /* replace189_0 -> 493 in the cache */
   /* replace189_1_0 -> 48 in the cache */
   /* replace189_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 493, 501 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search190_0_0_0_0 -> 29 in the cache */
   /* search190_0_0_0 -> 489 in the cache */
   /* search190_0_0_1_0 -> 48 in the cache */
   /* search190_0_0_1 -> 490 in the cache */
   /* search190_0_0 -> 491 in the cache */
   /* search190_0_1 -> 271 in the cache */
   /* search190_0 -> 492 in the cache */
   /* search190_1 -> 271 in the cache */
   /* search190_2_0_0_0 -> 29 in the cache */
   /* search190_2_0_0 -> 489 in the cache */
   /* search190_2_0 -> 493 in the cache */
   /* search190_2_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 493, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 492, 271, 505 },
      -1,
   } },

   /* replace190_0_0_0 -> 29 in the cache */
   /* replace190_0_0 -> 489 in the cache */
   /* replace190_0 -> 493 in the cache */
   /* replace190_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 493, 48 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b')) */
   /* search191_0_0_0_0 -> 29 in the cache */
   /* search191_0_0_0 -> 489 in the cache */
   /* search191_0_0_1_0 -> 48 in the cache */
   /* search191_0_0_1 -> 490 in the cache */
   /* search191_0_0 -> 491 in the cache */
   /* search191_0_1 -> 271 in the cache */
   /* search191_0 -> 492 in the cache */
   /* search191_1 -> 271 in the cache */
   /* search191_2_0_0 -> 29 in the cache */
   /* search191_2_0 -> 489 in the cache */
   /* search191_2_1_0 -> 48 in the cache */
   /* search191_2_1 -> 490 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 489, 490 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 492, 271, 508 },
      -1,
   } },

   /* replace191_0_0 -> 29 in the cache */
   /* replace191_0 -> 489 in the cache */
   /* replace191_1_0 -> 48 in the cache */
   /* replace191_1 -> 490 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 489, 490 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b')) */
   /* search192_0_0_0_0 -> 29 in the cache */
   /* search192_0_0_0 -> 489 in the cache */
   /* search192_0_0_1_0 -> 48 in the cache */
   /* search192_0_0_1 -> 490 in the cache */
   /* search192_0_0 -> 491 in the cache */
   /* search192_0_1 -> 271 in the cache */
   /* search192_0 -> 492 in the cache */
   /* search192_1 -> 271 in the cache */
   /* search192_2_0_0 -> 29 in the cache */
   /* search192_2_0 -> 489 in the cache */
   /* search192_2_1_0 -> 48 in the cache */
   /* search192_2_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 489, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 492, 271, 511 },
      -1,
   } },

   /* replace192_0_0 -> 29 in the cache */
   /* replace192_0 -> 489 in the cache */
   /* replace192_1_0 -> 48 in the cache */
   /* replace192_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 489, 501 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), 'b')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search193_0_0_0_0 -> 29 in the cache */
   /* search193_0_0_0 -> 489 in the cache */
   /* search193_0_0_1_0 -> 48 in the cache */
   /* search193_0_0_1 -> 490 in the cache */
   /* search193_0_0 -> 491 in the cache */
   /* search193_0_1 -> 271 in the cache */
   /* search193_0 -> 492 in the cache */
   /* search193_1 -> 271 in the cache */
   /* search193_2_0_0 -> 29 in the cache */
   /* search193_2_0 -> 489 in the cache */
   /* search193_2_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 489, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 492, 271, 514 },
      -1,
   } },

   /* replace193_0_0 -> 29 in the cache */
   /* replace193_0 -> 489 in the cache */
   /* replace193_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 489, 48 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', 'a'), ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b')) */
   /* search194_0_0_0_0 -> 29 in the cache */
   /* search194_0_0_0 -> 489 in the cache */
   /* search194_0_0_1_0 -> 48 in the cache */
   /* search194_0_0_1 -> 490 in the cache */
   /* search194_0_0 -> 491 in the cache */
   /* search194_0_1 -> 271 in the cache */
   /* search194_0 -> 492 in the cache */
   /* search194_1 -> 271 in the cache */
   /* search194_2_0_0 -> 29 in the cache */
   /* search194_2_0 -> 326 in the cache */
   /* search194_2_1_0 -> 48 in the cache */
   /* search194_2_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 326, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 492, 271, 517 },
      -1,
   } },

   /* replace194_0_0 -> 29 in the cache */
   /* replace194_0 -> 326 in the cache */
   /* replace194_1_0 -> 48 in the cache */
   /* replace194_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 326, 501 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', 'a'), 'b')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search195_0_0_0_0 -> 29 in the cache */
   /* search195_0_0_0 -> 489 in the cache */
   /* search195_0_0_1_0 -> 48 in the cache */
   /* search195_0_0_1 -> 490 in the cache */
   /* search195_0_0 -> 491 in the cache */
   /* search195_0_1 -> 271 in the cache */
   /* search195_0 -> 492 in the cache */
   /* search195_1 -> 271 in the cache */
   /* search195_2_0_0 -> 29 in the cache */
   /* search195_2_0 -> 326 in the cache */
   /* search195_2_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 326, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 492, 271, 520 },
      -1,
   } },

   /* replace195_0_0 -> 29 in the cache */
   /* replace195_0 -> 326 in the cache */
   /* replace195_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 326, 48 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', 'a', 'b')) => ('fmulz', 'a', 'b') */
   /* search196_0_0_0_0 -> 29 in the cache */
   /* search196_0_0_0 -> 489 in the cache */
   /* search196_0_0_1_0 -> 48 in the cache */
   /* search196_0_0_1 -> 490 in the cache */
   /* search196_0_0 -> 491 in the cache */
   /* search196_0_1 -> 271 in the cache */
   /* search196_0 -> 492 in the cache */
   /* search196_1 -> 271 in the cache */
   /* search196_2_0 -> 29 in the cache */
   /* search196_2_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 492, 271, 523 },
      -1,
   } },

   /* replace196_0 -> 29 in the cache */
   /* replace196_1 -> 48 in the cache */
   /* replace196 -> 312 in the cache */

   /* ('fmul@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search197_0_0_0 -> 29 in the cache */
   /* search197_0_0 -> 489 in the cache */
   /* search197_0 -> 493 in the cache */
   /* search197_1_0_0 -> 29 in the cache */
   /* search197_1_0_1 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      1, 1,
      { 29, 271 },
      -1,
   } },
   /* search197_1_1 -> 271 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 525, 271, 526 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 493, 527 },
      -1,
   } },

   /* replace197_0_0_0 -> 29 in the cache */
   /* replace197_0_0 -> 489 in the cache */
   /* replace197_0 -> 493 in the cache */
   /* replace197_1 -> 48 in the cache */
   /* replace197 -> 507 in the cache */

   /* ('fmul@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search198_0_0 -> 29 in the cache */
   /* search198_0 -> 489 in the cache */
   /* search198_1_0_0 -> 29 in the cache */
   /* search198_1_0_1 -> 271 in the cache */
   /* search198_1_0 -> 525 in the cache */
   /* search198_1_1 -> 271 in the cache */
   /* search198_1_2 -> 526 in the cache */
   /* search198_1 -> 527 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 489, 527 },
      -1,
   } },

   /* replace198_0_0 -> 29 in the cache */
   /* replace198_0 -> 489 in the cache */
   /* replace198_1 -> 48 in the cache */
   /* replace198 -> 516 in the cache */

   /* ('fmul@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search199_0_0 -> 29 in the cache */
   /* search199_0 -> 326 in the cache */
   /* search199_1_0_0 -> 29 in the cache */
   /* search199_1_0_1 -> 271 in the cache */
   /* search199_1_0 -> 525 in the cache */
   /* search199_1_1 -> 271 in the cache */
   /* search199_1_2 -> 526 in the cache */
   /* search199_1 -> 527 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 326, 527 },
      -1,
   } },

   /* replace199_0_0 -> 29 in the cache */
   /* replace199_0 -> 326 in the cache */
   /* replace199_1 -> 48 in the cache */
   /* replace199 -> 522 in the cache */

   /* ('fmul@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b') */
   /* search200_0 -> 29 in the cache */
   /* search200_1_0_0 -> 29 in the cache */
   /* search200_1_0_1 -> 271 in the cache */
   /* search200_1_0 -> 525 in the cache */
   /* search200_1_1 -> 271 in the cache */
   /* search200_1_2 -> 526 in the cache */
   /* search200_1 -> 527 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 29, 527 },
      -1,
   } },

   /* replace200_0 -> 29 in the cache */
   /* replace200_1 -> 48 in the cache */
   /* replace200 -> 312 in the cache */

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b'))), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')), 'c') */
   /* search201_0_0_0 -> 422 in the cache */
   /* search201_0_0_1 -> 271 in the cache */
   /* search201_0_0 -> 423 in the cache */
   /* search201_0_1 -> 271 in the cache */
   /* search201_0_2_0_0 -> 198 in the cache */
   /* search201_0_2_0 -> 424 in the cache */
   /* search201_0_2 -> 425 in the cache */
   /* search201_0 -> 426 in the cache */
   /* search201_1_0_0 -> 198 in the cache */
   /* search201_1_0_1 -> 271 in the cache */
   /* search201_1_0 -> 427 in the cache */
   /* search201_1_1 -> 271 in the cache */
   /* search201_1_2_0_0 -> 422 in the cache */
   /* search201_1_2_0 -> 428 in the cache */
   /* search201_1_2 -> 429 in the cache */
   /* search201_1 -> 430 in the cache */
   /* search201_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 426, 430, 150 },
      -1,
   } },

   /* replace201_0_0_0 -> 198 in the cache */
   /* replace201_0_0 -> 424 in the cache */
   /* replace201_0 -> 425 in the cache */
   /* replace201_1_0_0 -> 422 in the cache */
   /* replace201_1_0 -> 428 in the cache */
   /* replace201_1 -> 429 in the cache */
   /* replace201_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 425, 429, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fabs', 'b'), 'c') */
   /* search202_0_0_0 -> 422 in the cache */
   /* search202_0_0_1 -> 271 in the cache */
   /* search202_0_0 -> 423 in the cache */
   /* search202_0_1 -> 271 in the cache */
   /* search202_0_2_0_0 -> 198 in the cache */
   /* search202_0_2_0 -> 424 in the cache */
   /* search202_0_2 -> 425 in the cache */
   /* search202_0 -> 426 in the cache */
   /* search202_1_0_0 -> 198 in the cache */
   /* search202_1_0_1 -> 271 in the cache */
   /* search202_1_0 -> 427 in the cache */
   /* search202_1_1 -> 271 in the cache */
   /* search202_1_2_0 -> 422 in the cache */
   /* search202_1_2 -> 428 in the cache */
   /* search202_1 -> 433 in the cache */
   /* search202_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 426, 433, 150 },
      -1,
   } },

   /* replace202_0_0_0 -> 198 in the cache */
   /* replace202_0_0 -> 424 in the cache */
   /* replace202_0 -> 425 in the cache */
   /* replace202_1_0 -> 422 in the cache */
   /* replace202_1 -> 428 in the cache */
   /* replace202_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 425, 428, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', 'b'), 'c') */
   /* search203_0_0_0 -> 422 in the cache */
   /* search203_0_0_1 -> 271 in the cache */
   /* search203_0_0 -> 423 in the cache */
   /* search203_0_1 -> 271 in the cache */
   /* search203_0_2_0_0 -> 198 in the cache */
   /* search203_0_2_0 -> 424 in the cache */
   /* search203_0_2 -> 425 in the cache */
   /* search203_0 -> 426 in the cache */
   /* search203_1_0_0 -> 198 in the cache */
   /* search203_1_0_1 -> 271 in the cache */
   /* search203_1_0 -> 427 in the cache */
   /* search203_1_1 -> 271 in the cache */
   /* search203_1_2_0 -> 422 in the cache */
   /* search203_1_2 -> 436 in the cache */
   /* search203_1 -> 437 in the cache */
   /* search203_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 426, 437, 150 },
      -1,
   } },

   /* replace203_0_0_0 -> 198 in the cache */
   /* replace203_0_0 -> 424 in the cache */
   /* replace203_0 -> 425 in the cache */
   /* replace203_1_0 -> 422 in the cache */
   /* replace203_1 -> 436 in the cache */
   /* replace203_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 425, 436, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c') */
   /* search204_0_0_0 -> 422 in the cache */
   /* search204_0_0_1 -> 271 in the cache */
   /* search204_0_0 -> 423 in the cache */
   /* search204_0_1 -> 271 in the cache */
   /* search204_0_2_0_0 -> 198 in the cache */
   /* search204_0_2_0 -> 424 in the cache */
   /* search204_0_2 -> 425 in the cache */
   /* search204_0 -> 426 in the cache */
   /* search204_1_0_0 -> 198 in the cache */
   /* search204_1_0_1 -> 271 in the cache */
   /* search204_1_0 -> 427 in the cache */
   /* search204_1_1 -> 271 in the cache */
   /* search204_1_2 -> 422 in the cache */
   /* search204_1 -> 440 in the cache */
   /* search204_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 426, 440, 150 },
      -1,
   } },

   /* replace204_0_0_0 -> 198 in the cache */
   /* replace204_0_0 -> 424 in the cache */
   /* replace204_0 -> 425 in the cache */
   /* replace204_1 -> 422 in the cache */
   /* replace204_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 425, 422, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fabs', 'b'), 'c') */
   /* search205_0_0_0 -> 422 in the cache */
   /* search205_0_0_1 -> 271 in the cache */
   /* search205_0_0 -> 423 in the cache */
   /* search205_0_1 -> 271 in the cache */
   /* search205_0_2_0 -> 198 in the cache */
   /* search205_0_2 -> 424 in the cache */
   /* search205_0 -> 443 in the cache */
   /* search205_1_0_0 -> 198 in the cache */
   /* search205_1_0_1 -> 271 in the cache */
   /* search205_1_0 -> 427 in the cache */
   /* search205_1_1 -> 271 in the cache */
   /* search205_1_2_0 -> 422 in the cache */
   /* search205_1_2 -> 428 in the cache */
   /* search205_1 -> 433 in the cache */
   /* search205_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 443, 433, 150 },
      -1,
   } },

   /* replace205_0_0 -> 198 in the cache */
   /* replace205_0 -> 424 in the cache */
   /* replace205_1_0 -> 422 in the cache */
   /* replace205_1 -> 428 in the cache */
   /* replace205_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 424, 428, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fneg', 'b'), 'c') */
   /* search206_0_0_0 -> 422 in the cache */
   /* search206_0_0_1 -> 271 in the cache */
   /* search206_0_0 -> 423 in the cache */
   /* search206_0_1 -> 271 in the cache */
   /* search206_0_2_0 -> 198 in the cache */
   /* search206_0_2 -> 424 in the cache */
   /* search206_0 -> 443 in the cache */
   /* search206_1_0_0 -> 198 in the cache */
   /* search206_1_0_1 -> 271 in the cache */
   /* search206_1_0 -> 427 in the cache */
   /* search206_1_1 -> 271 in the cache */
   /* search206_1_2_0 -> 422 in the cache */
   /* search206_1_2 -> 436 in the cache */
   /* search206_1 -> 437 in the cache */
   /* search206_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 443, 437, 150 },
      -1,
   } },

   /* replace206_0_0 -> 198 in the cache */
   /* replace206_0 -> 424 in the cache */
   /* replace206_1_0 -> 422 in the cache */
   /* replace206_1 -> 436 in the cache */
   /* replace206_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 424, 436, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c') */
   /* search207_0_0_0 -> 422 in the cache */
   /* search207_0_0_1 -> 271 in the cache */
   /* search207_0_0 -> 423 in the cache */
   /* search207_0_1 -> 271 in the cache */
   /* search207_0_2_0 -> 198 in the cache */
   /* search207_0_2 -> 424 in the cache */
   /* search207_0 -> 443 in the cache */
   /* search207_1_0_0 -> 198 in the cache */
   /* search207_1_0_1 -> 271 in the cache */
   /* search207_1_0 -> 427 in the cache */
   /* search207_1_1 -> 271 in the cache */
   /* search207_1_2 -> 422 in the cache */
   /* search207_1 -> 440 in the cache */
   /* search207_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 443, 440, 150 },
      -1,
   } },

   /* replace207_0_0 -> 198 in the cache */
   /* replace207_0 -> 424 in the cache */
   /* replace207_1 -> 422 in the cache */
   /* replace207_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 424, 422, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') */
   /* search208_0_0_0 -> 422 in the cache */
   /* search208_0_0_1 -> 271 in the cache */
   /* search208_0_0 -> 423 in the cache */
   /* search208_0_1 -> 271 in the cache */
   /* search208_0_2_0 -> 198 in the cache */
   /* search208_0_2 -> 450 in the cache */
   /* search208_0 -> 451 in the cache */
   /* search208_1_0_0 -> 198 in the cache */
   /* search208_1_0_1 -> 271 in the cache */
   /* search208_1_0 -> 427 in the cache */
   /* search208_1_1 -> 271 in the cache */
   /* search208_1_2_0 -> 422 in the cache */
   /* search208_1_2 -> 436 in the cache */
   /* search208_1 -> 437 in the cache */
   /* search208_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 451, 437, 150 },
      -1,
   } },

   /* replace208_0_0 -> 198 in the cache */
   /* replace208_0 -> 450 in the cache */
   /* replace208_1_0 -> 422 in the cache */
   /* replace208_1 -> 436 in the cache */
   /* replace208_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 450, 436, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c') */
   /* search209_0_0_0 -> 422 in the cache */
   /* search209_0_0_1 -> 271 in the cache */
   /* search209_0_0 -> 423 in the cache */
   /* search209_0_1 -> 271 in the cache */
   /* search209_0_2_0 -> 198 in the cache */
   /* search209_0_2 -> 450 in the cache */
   /* search209_0 -> 451 in the cache */
   /* search209_1_0_0 -> 198 in the cache */
   /* search209_1_0_1 -> 271 in the cache */
   /* search209_1_0 -> 427 in the cache */
   /* search209_1_1 -> 271 in the cache */
   /* search209_1_2 -> 422 in the cache */
   /* search209_1 -> 440 in the cache */
   /* search209_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 451, 440, 150 },
      -1,
   } },

   /* replace209_0_0 -> 198 in the cache */
   /* replace209_0 -> 450 in the cache */
   /* replace209_1 -> 422 in the cache */
   /* replace209_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 450, 422, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search210_0_0_0 -> 422 in the cache */
   /* search210_0_0_1 -> 271 in the cache */
   /* search210_0_0 -> 423 in the cache */
   /* search210_0_1 -> 271 in the cache */
   /* search210_0_2 -> 198 in the cache */
   /* search210_0 -> 456 in the cache */
   /* search210_1_0_0 -> 198 in the cache */
   /* search210_1_0_1 -> 271 in the cache */
   /* search210_1_0 -> 427 in the cache */
   /* search210_1_1 -> 271 in the cache */
   /* search210_1_2 -> 422 in the cache */
   /* search210_1 -> 440 in the cache */
   /* search210_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 456, 440, 150 },
      -1,
   } },

   /* replace210_0 -> 198 in the cache */
   /* replace210_1 -> 422 in the cache */
   /* replace210_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 198, 422, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c') */
   /* search211_0_0_0 -> 29 in the cache */
   /* search211_0_0 -> 489 in the cache */
   /* search211_0 -> 493 in the cache */
   /* search211_1_0_0 -> 29 in the cache */
   /* search211_1_0_1 -> 271 in the cache */
   /* search211_1_0 -> 525 in the cache */
   /* search211_1_1 -> 271 in the cache */
   /* search211_1_2 -> 526 in the cache */
   /* search211_1 -> 527 in the cache */
   /* search211_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 493, 527, 150 },
      -1,
   } },

   /* replace211_0_0_0 -> 29 in the cache */
   /* replace211_0_0 -> 489 in the cache */
   /* replace211_0 -> 493 in the cache */
   /* replace211_1 -> 48 in the cache */
   /* replace211_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 493, 48, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c') */
   /* search212_0_0 -> 29 in the cache */
   /* search212_0 -> 489 in the cache */
   /* search212_1_0_0 -> 29 in the cache */
   /* search212_1_0_1 -> 271 in the cache */
   /* search212_1_0 -> 525 in the cache */
   /* search212_1_1 -> 271 in the cache */
   /* search212_1_2 -> 526 in the cache */
   /* search212_1 -> 527 in the cache */
   /* search212_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 489, 527, 150 },
      -1,
   } },

   /* replace212_0_0 -> 29 in the cache */
   /* replace212_0 -> 489 in the cache */
   /* replace212_1 -> 48 in the cache */
   /* replace212_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 489, 48, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c') */
   /* search213_0_0 -> 29 in the cache */
   /* search213_0 -> 326 in the cache */
   /* search213_1_0_0 -> 29 in the cache */
   /* search213_1_0_1 -> 271 in the cache */
   /* search213_1_0 -> 525 in the cache */
   /* search213_1_1 -> 271 in the cache */
   /* search213_1_2 -> 526 in the cache */
   /* search213_1 -> 527 in the cache */
   /* search213_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 326, 527, 150 },
      -1,
   } },

   /* replace213_0_0 -> 29 in the cache */
   /* replace213_0 -> 326 in the cache */
   /* replace213_1 -> 48 in the cache */
   /* replace213_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 326, 48, 150 },
      -1,
   } },

   /* ('ffma@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search214_0 -> 29 in the cache */
   /* search214_1_0_0 -> 29 in the cache */
   /* search214_1_0_1 -> 271 in the cache */
   /* search214_1_0 -> 525 in the cache */
   /* search214_1_1 -> 271 in the cache */
   /* search214_1_2 -> 526 in the cache */
   /* search214_1 -> 527 in the cache */
   /* search214_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 29, 527, 150 },
      -1,
   } },

   /* replace214_0 -> 29 in the cache */
   /* replace214_1 -> 48 in the cache */
   /* replace214_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b')))) */
   /* search215_0_0 -> 422 in the cache */
   /* search215_0_1 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 422, 271 },
      -1,
   } },
   /* search215_1 -> 318 in the cache */
   /* search215_2_0_0 -> 198 in the cache */
   /* search215_2_0_1_0_0 -> 422 in the cache */
   /* search215_2_0_1_0 -> 428 in the cache */
   /* search215_2_0_1 -> 429 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 198, 429 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 561 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 560, 318, 562 },
      -1,
   } },

   /* replace215_0_0 -> 198 in the cache */
   /* replace215_0_1_0_0 -> 422 in the cache */
   /* replace215_0_1_0 -> 428 in the cache */
   /* replace215_0_1 -> 429 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 198, 429 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 564 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b'))) */
   /* search216_0_0 -> 422 in the cache */
   /* search216_0_1 -> 271 in the cache */
   /* search216_0 -> 560 in the cache */
   /* search216_1 -> 318 in the cache */
   /* search216_2_0_0 -> 198 in the cache */
   /* search216_2_0_1_0 -> 422 in the cache */
   /* search216_2_0_1 -> 428 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 198, 428 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 560, 318, 567 },
      -1,
   } },

   /* replace216_0_0 -> 198 in the cache */
   /* replace216_0_1_0 -> 422 in the cache */
   /* replace216_0_1 -> 428 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 198, 428 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 569 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b'))) */
   /* search217_0_0 -> 422 in the cache */
   /* search217_0_1 -> 271 in the cache */
   /* search217_0 -> 560 in the cache */
   /* search217_1 -> 318 in the cache */
   /* search217_2_0_0 -> 198 in the cache */
   /* search217_2_0_1_0 -> 422 in the cache */
   /* search217_2_0_1 -> 436 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 198, 436 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 571 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 560, 318, 572 },
      -1,
   } },

   /* replace217_0_0 -> 198 in the cache */
   /* replace217_0_1_0 -> 422 in the cache */
   /* replace217_0_1 -> 436 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 198, 436 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 574 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search218_0_0 -> 422 in the cache */
   /* search218_0_1 -> 271 in the cache */
   /* search218_0 -> 560 in the cache */
   /* search218_1 -> 318 in the cache */
   /* search218_2_0_0 -> 198 in the cache */
   /* search218_2_0_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 198, 422 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 576 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 560, 318, 577 },
      -1,
   } },

   /* replace218_0_0 -> 198 in the cache */
   /* replace218_0_1 -> 422 in the cache */
   /* replace218_0 -> 458 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 458 },
      -1,
   } },

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b')))) */
   /* search219_0_0 -> 422 in the cache */
   /* search219_0_1 -> 271 in the cache */
   /* search219_0 -> 560 in the cache */
   /* search219_1 -> 318 in the cache */
   /* search219_2_0_0 -> 198 in the cache */
   /* search219_2_0_1_0_0 -> 422 in the cache */
   /* search219_2_0_1_0 -> 428 in the cache */
   /* search219_2_0_1 -> 429 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 198, 429 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 580 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 560, 318, 581 },
      -1,
   } },

   /* replace219_0_0 -> 198 in the cache */
   /* replace219_0_1_0_0 -> 422 in the cache */
   /* replace219_0_1_0 -> 428 in the cache */
   /* replace219_0_1 -> 429 in the cache */
   /* replace219_0 -> 564 in the cache */
   /* replace219 -> 565 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b'))) */
   /* search220_0_0 -> 422 in the cache */
   /* search220_0_1 -> 271 in the cache */
   /* search220_0 -> 560 in the cache */
   /* search220_1 -> 318 in the cache */
   /* search220_2_0_0 -> 198 in the cache */
   /* search220_2_0_1_0 -> 422 in the cache */
   /* search220_2_0_1 -> 428 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 198, 428 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 583 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 560, 318, 584 },
      -1,
   } },

   /* replace220_0_0 -> 198 in the cache */
   /* replace220_0_1_0 -> 422 in the cache */
   /* replace220_0_1 -> 428 in the cache */
   /* replace220_0 -> 569 in the cache */
   /* replace220 -> 570 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b'))) */
   /* search221_0_0 -> 422 in the cache */
   /* search221_0_1 -> 271 in the cache */
   /* search221_0 -> 560 in the cache */
   /* search221_1 -> 318 in the cache */
   /* search221_2_0_0 -> 198 in the cache */
   /* search221_2_0_1_0 -> 422 in the cache */
   /* search221_2_0_1 -> 436 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 198, 436 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 586 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 560, 318, 587 },
      -1,
   } },

   /* replace221_0_0 -> 198 in the cache */
   /* replace221_0_1_0 -> 422 in the cache */
   /* replace221_0_1 -> 436 in the cache */
   /* replace221_0 -> 574 in the cache */
   /* replace221 -> 575 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search222_0_0 -> 422 in the cache */
   /* search222_0_1 -> 271 in the cache */
   /* search222_0 -> 560 in the cache */
   /* search222_1 -> 318 in the cache */
   /* search222_2_0_0 -> 198 in the cache */
   /* search222_2_0_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 198, 422 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 589 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 560, 318, 590 },
      -1,
   } },

   /* replace222_0_0 -> 198 in the cache */
   /* replace222_0_1 -> 422 in the cache */
   /* replace222_0 -> 458 in the cache */
   /* replace222 -> 579 in the cache */

   /* ('iand(is_only_used_as_float)', 'a@16', 32767) => ('fabs', 'a') */
   /* search223_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x7fffull /* 32767 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 24, 592 },
      1,
   } },

   /* replace223_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('ixor(is_only_used_as_float)', 'a@16', 32768) => ('fneg', 'a') */
   /* search224_0 -> 24 in the cache */
   /* search224_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ixor,
      0, 1,
      { 24, 25 },
      1,
   } },

   /* replace224_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('ior(is_only_used_as_float)', 'a@16', 32768) => ('fneg', ('fabs', 'a')) */
   /* search225_0 -> 24 in the cache */
   /* search225_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ior,
      0, 1,
      { 24, 25 },
      1,
   } },

   /* replace225_0_0 -> 24 in the cache */
   /* replace225_0 -> 594 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 594 },
      -1,
   } },

   /* ('iand(is_only_used_as_float)', 'a@32', 2147483647) => ('fabs', 'a') */
   /* search226_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffffull /* 2147483647 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 599 },
      1,
   } },

   /* replace226_0 -> 29 in the cache */
   /* replace226 -> 489 in the cache */

   /* ('ixor(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', 'a') */
   /* search227_0 -> 29 in the cache */
   /* search227_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ixor,
      0, 1,
      { 29, 30 },
      1,
   } },

   /* replace227_0 -> 29 in the cache */
   /* replace227 -> 326 in the cache */

   /* ('ior(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', ('fabs', 'a')) */
   /* search228_0 -> 29 in the cache */
   /* search228_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ior,
      0, 1,
      { 29, 30 },
      1,
   } },

   /* replace228_0_0 -> 29 in the cache */
   /* replace228_0 -> 489 in the cache */
   /* replace228 -> 493 in the cache */

   /* ('iand(is_only_used_as_float)', 'a@64', 9223372036854775807) => ('fabs', 'a') */
   /* search229_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x7fffffffffffffffull /* 9223372036854775807 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 34, 603 },
      1,
   } },

   /* replace229_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 34 },
      -1,
   } },

   /* ('ixor(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', 'a') */
   /* search230_0 -> 34 in the cache */
   /* search230_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ixor,
      0, 1,
      { 34, 35 },
      1,
   } },

   /* replace230_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 34 },
      -1,
   } },

   /* ('ior(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', ('fabs', 'a')) */
   /* search231_0 -> 34 in the cache */
   /* search231_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ior,
      0, 1,
      { 34, 35 },
      1,
   } },

   /* replace231_0_0 -> 34 in the cache */
   /* replace231_0 -> 605 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 605 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search232_0 -> 29 in the cache */
   /* search232_1 -> 48 in the cache */
   /* search232_2 -> 150 in the cache */
   /* search232 -> 380 in the cache */

   /* replace232_0_0_0_0_0 -> 29 in the cache */
   /* replace232_0_0_0_0_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 29, 137 },
      -1,
   } },
   /* replace232_0_0_0_1_0 -> 48 in the cache */
   /* replace232_0_0_0_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 48, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 610, 611 },
      -1,
   } },
   /* replace232_0_0_1_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 29, 613 },
      -1,
   } },
   /* replace232_0_0_1_1_0 -> 48 in the cache */
   /* replace232_0_0_1_1_1 -> 613 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 48, 613 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      4, 1,
      { 614, 615 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 3,
      { 612, 616 },
      -1,
   } },
   /* replace232_0_1_0_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2ull /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 29, 618 },
      -1,
   } },
   /* replace232_0_1_0_1_0 -> 48 in the cache */
   /* replace232_0_1_0_1_1 -> 618 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 48, 618 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      6, 1,
      { 619, 620 },
      -1,
   } },
   /* replace232_0_1_1_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3ull /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 29, 622 },
      -1,
   } },
   /* replace232_0_1_1_1_0 -> 48 in the cache */
   /* replace232_0_1_1_1_1 -> 622 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 48, 622 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      7, 1,
      { 623, 624 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      5, 3,
      { 621, 625 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 7,
      { 617, 626 },
      -1,
   } },
   /* replace232_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 8,
      { 627, 150 },
      -1,
   } },

   /* ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search233_0 -> 29 in the cache */
   /* search233_1 -> 48 in the cache */
   /* search233_2 -> 150 in the cache */
   /* search233 -> 383 in the cache */

   /* replace233_0_0_0_0_0 -> 29 in the cache */
   /* replace233_0_0_0_0_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 29, 137 },
      -1,
   } },
   /* replace233_0_0_0_1_0 -> 48 in the cache */
   /* replace233_0_0_0_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 48, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 629, 630 },
      -1,
   } },
   /* replace233_0_0_1_0_0 -> 29 in the cache */
   /* replace233_0_0_1_0_1 -> 613 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 29, 613 },
      -1,
   } },
   /* replace233_0_0_1_1_0 -> 48 in the cache */
   /* replace233_0_0_1_1_1 -> 613 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 48, 613 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      4, 1,
      { 632, 633 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 3,
      { 631, 634 },
      -1,
   } },
   /* replace233_0_1_0_0_0 -> 29 in the cache */
   /* replace233_0_1_0_0_1 -> 618 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 29, 618 },
      -1,
   } },
   /* replace233_0_1_0_1_0 -> 48 in the cache */
   /* replace233_0_1_0_1_1 -> 618 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 48, 618 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      6, 1,
      { 636, 637 },
      -1,
   } },
   /* replace233_0_1_1_0_0 -> 29 in the cache */
   /* replace233_0_1_1_0_1 -> 622 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 29, 622 },
      -1,
   } },
   /* replace233_0_1_1_1_0 -> 48 in the cache */
   /* replace233_0_1_1_1_1 -> 622 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 48, 622 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      7, 1,
      { 639, 640 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      5, 3,
      { 638, 641 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 7,
      { 635, 642 },
      -1,
   } },
   /* replace233_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 8,
      { 643, 150 },
      -1,
   } },

   /* ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search234_0 -> 29 in the cache */
   /* search234_1 -> 48 in the cache */
   /* search234_2 -> 150 in the cache */
   /* search234 -> 386 in the cache */

   /* replace234_0_0_0_0_0 -> 29 in the cache */
   /* replace234_0_0_0_0_1 -> 137 in the cache */
   /* replace234_0_0_0_0 -> 610 in the cache */
   /* replace234_0_0_0_1_0 -> 48 in the cache */
   /* replace234_0_0_0_1_1 -> 137 in the cache */
   /* replace234_0_0_0_1 -> 630 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 610, 630 },
      -1,
   } },
   /* replace234_0_0_1_0_0 -> 29 in the cache */
   /* replace234_0_0_1_0_1 -> 613 in the cache */
   /* replace234_0_0_1_0 -> 614 in the cache */
   /* replace234_0_0_1_1_0 -> 48 in the cache */
   /* replace234_0_0_1_1_1 -> 613 in the cache */
   /* replace234_0_0_1_1 -> 633 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      4, 1,
      { 614, 633 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 3,
      { 645, 646 },
      -1,
   } },
   /* replace234_0_1_0_0_0 -> 29 in the cache */
   /* replace234_0_1_0_0_1 -> 618 in the cache */
   /* replace234_0_1_0_0 -> 619 in the cache */
   /* replace234_0_1_0_1_0 -> 48 in the cache */
   /* replace234_0_1_0_1_1 -> 618 in the cache */
   /* replace234_0_1_0_1 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      6, 1,
      { 619, 637 },
      -1,
   } },
   /* replace234_0_1_1_0_0 -> 29 in the cache */
   /* replace234_0_1_1_0_1 -> 622 in the cache */
   /* replace234_0_1_1_0 -> 623 in the cache */
   /* replace234_0_1_1_1_0 -> 48 in the cache */
   /* replace234_0_1_1_1_1 -> 622 in the cache */
   /* replace234_0_1_1_1 -> 640 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      7, 1,
      { 623, 640 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      5, 3,
      { 648, 649 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 7,
      { 647, 650 },
      -1,
   } },
   /* replace234_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 8,
      { 651, 150 },
      -1,
   } },

   /* ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search235_0 -> 29 in the cache */
   /* search235_1 -> 48 in the cache */
   /* search235_2 -> 150 in the cache */
   /* search235 -> 392 in the cache */

   /* replace235_0_0_0_0 -> 29 in the cache */
   /* replace235_0_0_0_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i16,
      -1, 0,
      { 29, 137 },
      -1,
   } },
   /* replace235_0_0_1_0 -> 48 in the cache */
   /* replace235_0_0_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i16,
      -1, 0,
      { 48, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      2, 1,
      { 653, 654 },
      -1,
   } },
   /* replace235_0_1_0_0 -> 29 in the cache */
   /* replace235_0_1_0_1 -> 613 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i16,
      -1, 0,
      { 29, 613 },
      -1,
   } },
   /* replace235_0_1_1_0 -> 48 in the cache */
   /* replace235_0_1_1_1 -> 613 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i16,
      -1, 0,
      { 48, 613 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 656, 657 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 655, 658 },
      -1,
   } },
   /* replace235_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 4,
      { 659, 150 },
      -1,
   } },

   /* ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search236_0 -> 29 in the cache */
   /* search236_1 -> 48 in the cache */
   /* search236_2 -> 150 in the cache */
   /* search236 -> 395 in the cache */

   /* replace236_0_0_0_0 -> 29 in the cache */
   /* replace236_0_0_0_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u16,
      -1, 0,
      { 29, 137 },
      -1,
   } },
   /* replace236_0_0_1_0 -> 48 in the cache */
   /* replace236_0_0_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u16,
      -1, 0,
      { 48, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      2, 1,
      { 661, 662 },
      -1,
   } },
   /* replace236_0_1_0_0 -> 29 in the cache */
   /* replace236_0_1_0_1 -> 613 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u16,
      -1, 0,
      { 29, 613 },
      -1,
   } },
   /* replace236_0_1_1_0 -> 48 in the cache */
   /* replace236_0_1_1_1 -> 613 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u16,
      -1, 0,
      { 48, 613 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 664, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 663, 666 },
      -1,
   } },
   /* replace236_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 4,
      { 667, 150 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search237_0 -> 29 in the cache */
   /* search237_1 -> 48 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      7,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 48, 669 },
      -1,
   } },

   /* replace237_0 -> 29 in the cache */
   /* replace237_1 -> 48 in the cache */
   /* replace237_2 -> 150 in the cache */
   /* replace237 -> 383 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search238_0 -> 29 in the cache */
   /* search238_1 -> 48 in the cache */
   /* search238_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* replace238_0_0 -> 29 in the cache */
   /* replace238_0_1 -> 48 in the cache */
   /* replace238_0_2 -> 137 in the cache */
   /* replace238_0 -> 401 in the cache */
   /* replace238_1 -> 150 in the cache */
   /* replace238 -> 415 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search239_0 -> 29 in the cache */
   /* search239_1 -> 48 in the cache */
   /* search239_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* replace239_0_0 -> 29 in the cache */
   /* replace239_0_1 -> 48 in the cache */
   /* replace239_0_2 -> 137 in the cache */
   /* replace239_0 -> 398 in the cache */
   /* replace239_1 -> 150 in the cache */
   /* replace239 -> 413 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search240_0 -> 29 in the cache */
   /* search240_1 -> 48 in the cache */
   /* search240_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 29, 48, 150 },
      -1,
   } },

   /* replace240_0_0 -> 29 in the cache */
   /* replace240_0_1 -> 48 in the cache */
   /* replace240_0_2 -> 137 in the cache */
   /* replace240_0 -> 404 in the cache */
   /* replace240_1 -> 150 in the cache */
   /* replace240 -> 417 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search241_0 -> 29 in the cache */
   /* search241_1 -> 48 in the cache */
   /* search241_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* replace241_0_0_0_0 -> 29 in the cache */
   /* replace241_0_0_0_1 -> 137 in the cache */
   /* replace241_0_0_0 -> 661 in the cache */
   /* replace241_0_0_1_0 -> 48 in the cache */
   /* replace241_0_0_1_1 -> 137 in the cache */
   /* replace241_0_0_1 -> 662 in the cache */
   /* replace241_0_0 -> 663 in the cache */
   /* replace241_0_1_0_0 -> 29 in the cache */
   /* replace241_0_1_0_1 -> 613 in the cache */
   /* replace241_0_1_0 -> 664 in the cache */
   /* replace241_0_1_1_0 -> 48 in the cache */
   /* replace241_0_1_1_1 -> 613 in the cache */
   /* replace241_0_1_1 -> 665 in the cache */
   /* replace241_0_1 -> 666 in the cache */
   /* replace241_0 -> 667 in the cache */
   /* replace241_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uadd_sat,
      0, 4,
      { 667, 150 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search242_0 -> 29 in the cache */
   /* search242_1 -> 48 in the cache */
   /* search242_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* replace242_0_0_0_0 -> 29 in the cache */
   /* replace242_0_0_0_1 -> 137 in the cache */
   /* replace242_0_0_0 -> 653 in the cache */
   /* replace242_0_0_1_0 -> 48 in the cache */
   /* replace242_0_0_1_1 -> 137 in the cache */
   /* replace242_0_0_1 -> 654 in the cache */
   /* replace242_0_0 -> 655 in the cache */
   /* replace242_0_1_0_0 -> 29 in the cache */
   /* replace242_0_1_0_1 -> 613 in the cache */
   /* replace242_0_1_0 -> 656 in the cache */
   /* replace242_0_1_1_0 -> 48 in the cache */
   /* replace242_0_1_1_1 -> 613 in the cache */
   /* replace242_0_1_1 -> 657 in the cache */
   /* replace242_0_1 -> 658 in the cache */
   /* replace242_0 -> 659 in the cache */
   /* replace242_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd_sat,
      0, 4,
      { 659, 150 },
      -1,
   } },

   /* ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search243_0 -> 24 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 679 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 24, 678, 680 },
      -1,
   } },

   /* replace243_0 -> 679 in the cache */
   /* replace243_1_0 -> 678 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 678 },
      -1,
   } },
   /* replace243_2_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 679, 682, 683 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search244_0 -> 24 in the cache */
   /* search244_1_0 -> 24 in the cache */
   /* search244_1_1 -> 678 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 24, 678 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 24, 685, 686 },
      -1,
   } },

   /* replace244_0_0 -> 678 in the cache */
   /* replace244_0_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 678, 686 },
      -1,
   } },
   /* replace244_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 688, 24 },
      -1,
   } },

   /* ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search245_0_0 -> 24 in the cache */
   /* search245_0_1 -> 678 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 24, 678 },
      0,
   } },
   /* search245_1_0 -> 24 in the cache */
   /* search245_1_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 24, 686 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 2,
      { 690, 691, 692 },
      -1,
   } },

   /* replace245_0_0 -> 678 in the cache */
   /* replace245_0_1 -> 686 in the cache */
   /* replace245_0_2 -> 692 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 678, 686, 692 },
      -1,
   } },
   /* replace245_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 694, 24 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search246_0 -> 24 in the cache */
   /* search246_1_0 -> 24 in the cache */
   /* search246_1_1 -> 678 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 24, 678 },
      0,
   } },
   /* search246_2 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 24, 696, 686 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* replace246_0_1 -> 678 in the cache */
   /* replace246_0_2 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 698, 678, 686 },
      -1,
   } },
   /* replace246_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 699, 24 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search247_0_0 -> 24 in the cache */
   /* search247_0_1_0 -> 698 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 701 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 698, 702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 24, 703 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search247_1_1 -> 701 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 705, 701 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 704, 706 },
      -1,
   } },

   /* replace247_0 -> 24 in the cache */
   /* replace247_1 -> 705 in the cache */
   /* replace247_2 -> 701 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 24, 705, 701 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search248_0_0 -> 24 in the cache */
   /* search248_0_1_0_0 -> 698 in the cache */
   /* search248_0_1_0_1_0 -> 701 in the cache */
   /* search248_0_1_0_1 -> 702 in the cache */
   /* search248_0_1_0 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 24, 709 },
      -1,
   } },
   /* search248_1_0 -> 705 in the cache */
   /* search248_1_1_0 -> 701 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 701 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 705, 711 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 710, 712 },
      -1,
   } },

   /* replace248_0 -> 24 in the cache */
   /* replace248_1 -> 705 in the cache */
   /* replace248_2_0 -> 701 in the cache */
   /* replace248_2 -> 711 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 24, 705, 711 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search249_0 -> 24 in the cache */
   /* search249_1_0 -> 701 in the cache */
   /* search249_1_1_0 -> 705 in the cache */
   /* search249_1_1_1_0 -> 24 in the cache */
   /* search249_1_1_1 -> 596 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 705, 596 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 701, 715 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 24, 716 },
      -1,
   } },

   /* replace249_0 -> 24 in the cache */
   /* replace249_1 -> 705 in the cache */
   /* replace249_2 -> 701 in the cache */
   /* replace249 -> 708 in the cache */

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search250_0_0 -> 24 in the cache */
   /* search250_0_1_0 -> 698 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 718 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 719 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 698, 720 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 24, 721 },
      -1,
   } },
   /* search250_1_0 -> 705 in the cache */
   /* search250_1_1_0 -> 718 in the cache */
   /* search250_1_1 -> 719 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 705, 719 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 722, 723 },
      -1,
   } },

   /* replace250_0 -> 718 in the cache */
   /* replace250_1 -> 705 in the cache */
   /* replace250_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 718, 705, 24 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search251_0 -> 24 in the cache */
   /* search251_1_0_0 -> 718 in the cache */
   /* search251_1_0 -> 719 in the cache */
   /* search251_1_1_0 -> 705 in the cache */
   /* search251_1_1_1_0 -> 24 in the cache */
   /* search251_1_1_1 -> 596 in the cache */
   /* search251_1_1 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 719, 715 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 24, 726 },
      -1,
   } },

   /* replace251_0 -> 718 in the cache */
   /* replace251_1_0 -> 705 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 705 },
      -1,
   } },
   /* replace251_2_0 -> 24 in the cache */
   /* replace251_2 -> 683 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 718, 728, 683 },
      -1,
   } },

   /* ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search252_0 -> 24 in the cache */
   /* search252_1_0 -> 698 in the cache */
   /* search252_1_1_0_0 -> 718 in the cache */
   /* search252_1_1_0 -> 719 in the cache */
   /* search252_1_1 -> 720 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 698, 720 },
      -1,
   } },
   /* search252_2_0 -> 705 in the cache */
   /* search252_2_1_0 -> 718 in the cache */
   /* search252_2_1 -> 719 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 705, 719 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 24, 730, 731 },
      -1,
   } },

   /* replace252_0 -> 718 in the cache */
   /* replace252_1_0 -> 705 in the cache */
   /* replace252_1 -> 728 in the cache */
   /* replace252_2_0 -> 24 in the cache */
   /* replace252_2 -> 683 in the cache */
   /* replace252 -> 729 in the cache */

   /* ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search253_1_0 -> 718 in the cache */
   /* search253_1 -> 719 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 734 },
      -1,
   } },
   /* search253_2_1_0 -> 718 in the cache */
   /* search253_2_1 -> 719 in the cache */
   /* search253_2_2 -> 734 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 735, 719, 734 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 733, 719, 736 },
      -1,
   } },

   /* replace253_0 -> 718 in the cache */
   /* replace253_1_0 -> 733 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 733 },
      -1,
   } },
   /* replace253_2_0 -> 734 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 734 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 718, 738, 739 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 741 },
      -1,
   } },
   /* search254_1_0 -> 678 in the cache */
   /* search254_1_1_0 -> 734 in the cache */
   /* search254_1_1 -> 735 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 678, 735 },
      -1,
   } },
   /* search254_2 -> 734 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 742, 743, 734 },
      -1,
   } },

   /* replace254_0 -> 741 in the cache */
   /* replace254_1_0 -> 678 in the cache */
   /* replace254_1 -> 682 in the cache */
   /* replace254_2_0 -> 734 in the cache */
   /* replace254_2 -> 739 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 741, 682, 739 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', ('fcanonicalize', 'd'), ('fmul', 'a', 'b')) */
   /* search255_0_0 -> 741 in the cache */
   /* search255_0 -> 742 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 746 },
      -1,
   } },
   /* search255_1_1 -> 705 in the cache */
   /* search255_1_2 -> 692 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 747, 705, 692 },
      -1,
   } },
   /* search255_2_0 -> 746 in the cache */
   /* search255_2_1 -> 705 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 746, 705 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 742, 748, 749 },
      -1,
   } },

   /* replace255_0 -> 741 in the cache */
   /* replace255_1_0 -> 692 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 692 },
      -1,
   } },
   /* replace255_2_0 -> 746 in the cache */
   /* replace255_2_1 -> 705 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 746, 705 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 741, 751, 752 },
      -1,
   } },

   /* ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search256_0 -> 698 in the cache */
   /* search256_1_0_0_0 -> 698 in the cache */
   /* search256_1_0_0_1_0 -> 24 in the cache */
   /* search256_1_0_0_1 -> 596 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 698, 596 },
      -1,
   } },
   /* search256_1_0_1_0 -> 698 in the cache */
   /* search256_1_0_1_1_0 -> 678 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 678 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      3, 1,
      { 698, 755 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 3,
      { 754, 756 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 3,
      { 757 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 698, 758 },
      -1,
   } },

   /* replace256_0 -> 678 in the cache */
   /* replace256_1 -> 698 in the cache */
   /* replace256_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flrp,
      -1, 0,
      { 678, 698, 24 },
      -1,
   } },

   /* ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search257_0 -> 29 in the cache */
   /* search257_1 -> 48 in the cache */
   /* search257_2_0 -> 679 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 679 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 29, 48, 761 },
      -1,
   } },

   /* replace257_0 -> 679 in the cache */
   /* replace257_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 48 },
      -1,
   } },
   /* replace257_2_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 679, 763, 764 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search258_0 -> 29 in the cache */
   /* search258_1_0 -> 29 in the cache */
   /* search258_1_1 -> 48 in the cache */
   /* search258_1 -> 320 in the cache */
   /* search258_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 29, 320, 150 },
      -1,
   } },

   /* replace258_0_0 -> 48 in the cache */
   /* replace258_0_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 48, 150 },
      -1,
   } },
   /* replace258_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 767, 29 },
      -1,
   } },

   /* ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search259_0_0 -> 29 in the cache */
   /* search259_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 29, 48 },
      0,
   } },
   /* search259_1_0 -> 29 in the cache */
   /* search259_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 29, 150 },
      0,
   } },
   /* search259_2 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 2,
      { 769, 770, 178 },
      -1,
   } },

   /* replace259_0_0 -> 48 in the cache */
   /* replace259_0_1 -> 150 in the cache */
   /* replace259_0_2 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 48, 150, 178 },
      -1,
   } },
   /* replace259_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 772, 29 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search260_0 -> 29 in the cache */
   /* search260_1_0 -> 29 in the cache */
   /* search260_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 29, 48 },
      0,
   } },
   /* search260_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 29, 774, 150 },
      -1,
   } },

   /* replace260_0_0 -> 318 in the cache */
   /* replace260_0_1 -> 48 in the cache */
   /* replace260_0_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 318, 48, 150 },
      -1,
   } },
   /* replace260_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 776, 29 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search261_0_0 -> 29 in the cache */
   /* search261_0_1_0 -> 318 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 778 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 318, 779 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 29, 780 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search261_1_1 -> 778 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 782, 778 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 781, 783 },
      -1,
   } },

   /* replace261_0 -> 29 in the cache */
   /* replace261_1 -> 782 in the cache */
   /* replace261_2 -> 778 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 29, 782, 778 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search262_0_0 -> 29 in the cache */
   /* search262_0_1_0_0 -> 318 in the cache */
   /* search262_0_1_0_1_0 -> 778 in the cache */
   /* search262_0_1_0_1 -> 779 in the cache */
   /* search262_0_1_0 -> 780 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 780 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 29, 786 },
      -1,
   } },
   /* search262_1_0 -> 782 in the cache */
   /* search262_1_1_0 -> 778 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 778 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 782, 788 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 787, 789 },
      -1,
   } },

   /* replace262_0 -> 29 in the cache */
   /* replace262_1 -> 782 in the cache */
   /* replace262_2_0 -> 778 in the cache */
   /* replace262_2 -> 788 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 29, 782, 788 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search263_0 -> 29 in the cache */
   /* search263_1_0 -> 778 in the cache */
   /* search263_1_1_0 -> 782 in the cache */
   /* search263_1_1_1_0 -> 29 in the cache */
   /* search263_1_1_1 -> 326 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 782, 326 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 778, 792 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 29, 793 },
      -1,
   } },

   /* replace263_0 -> 29 in the cache */
   /* replace263_1 -> 782 in the cache */
   /* replace263_2 -> 778 in the cache */
   /* replace263 -> 785 in the cache */

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search264_0_0 -> 29 in the cache */
   /* search264_0_1_0 -> 318 in the cache */
   /* search264_0_1_1_0_0 -> 718 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 718 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 795 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 318, 796 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 29, 797 },
      -1,
   } },
   /* search264_1_0 -> 782 in the cache */
   /* search264_1_1_0 -> 718 in the cache */
   /* search264_1_1 -> 795 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 782, 795 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 798, 799 },
      -1,
   } },

   /* replace264_0 -> 718 in the cache */
   /* replace264_1 -> 782 in the cache */
   /* replace264_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 718, 782, 29 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search265_0 -> 29 in the cache */
   /* search265_1_0_0 -> 718 in the cache */
   /* search265_1_0 -> 795 in the cache */
   /* search265_1_1_0 -> 782 in the cache */
   /* search265_1_1_1_0 -> 29 in the cache */
   /* search265_1_1_1 -> 326 in the cache */
   /* search265_1_1 -> 792 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 795, 792 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 29, 802 },
      -1,
   } },

   /* replace265_0 -> 718 in the cache */
   /* replace265_1_0 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 782 },
      -1,
   } },
   /* replace265_2_0 -> 29 in the cache */
   /* replace265_2 -> 764 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 718, 804, 764 },
      -1,
   } },

   /* ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search266_0 -> 29 in the cache */
   /* search266_1_0 -> 318 in the cache */
   /* search266_1_1_0_0 -> 718 in the cache */
   /* search266_1_1_0 -> 795 in the cache */
   /* search266_1_1 -> 796 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 318, 796 },
      -1,
   } },
   /* search266_2_0 -> 782 in the cache */
   /* search266_2_1_0 -> 718 in the cache */
   /* search266_2_1 -> 795 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 782, 795 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 29, 806, 807 },
      -1,
   } },

   /* replace266_0 -> 718 in the cache */
   /* replace266_1_0 -> 782 in the cache */
   /* replace266_1 -> 804 in the cache */
   /* replace266_2_0 -> 29 in the cache */
   /* replace266_2 -> 764 in the cache */
   /* replace266 -> 805 in the cache */

   /* ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search267_0 -> 422 in the cache */
   /* search267_1_0 -> 718 in the cache */
   /* search267_1 -> 795 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 809 },
      -1,
   } },
   /* search267_2_1_0 -> 718 in the cache */
   /* search267_2_1 -> 795 in the cache */
   /* search267_2_2 -> 809 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 810, 795, 809 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 422, 795, 811 },
      -1,
   } },

   /* replace267_0 -> 718 in the cache */
   /* replace267_1_0 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 422 },
      -1,
   } },
   /* replace267_2_0 -> 809 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 809 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 718, 813, 814 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search268_0_0 -> 741 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 741 },
      -1,
   } },
   /* search268_1_0 -> 48 in the cache */
   /* search268_1_1_0 -> 809 in the cache */
   /* search268_1_1 -> 810 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 48, 810 },
      -1,
   } },
   /* search268_2 -> 809 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 816, 817, 809 },
      -1,
   } },

   /* replace268_0 -> 741 in the cache */
   /* replace268_1_0 -> 48 in the cache */
   /* replace268_1 -> 763 in the cache */
   /* replace268_2_0 -> 809 in the cache */
   /* replace268_2 -> 814 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 741, 763, 814 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', ('fcanonicalize', 'd'), ('fmul', 'a', 'b')) */
   /* search269_0_0 -> 741 in the cache */
   /* search269_0 -> 816 in the cache */
   /* search269_1_0_0 -> 198 in the cache */
   /* search269_1_0 -> 450 in the cache */
   /* search269_1_1 -> 782 in the cache */
   /* search269_1_2 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 450, 782, 178 },
      -1,
   } },
   /* search269_2_0 -> 198 in the cache */
   /* search269_2_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 198, 782 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 816, 820, 821 },
      -1,
   } },

   /* replace269_0 -> 741 in the cache */
   /* replace269_1_0 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 178 },
      -1,
   } },
   /* replace269_2_0 -> 198 in the cache */
   /* replace269_2_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 198, 782 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 741, 823, 824 },
      -1,
   } },

   /* ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search270_0 -> 318 in the cache */
   /* search270_1_0_0_0 -> 318 in the cache */
   /* search270_1_0_0_1_0 -> 29 in the cache */
   /* search270_1_0_0_1 -> 326 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 318, 326 },
      -1,
   } },
   /* search270_1_0_1_0 -> 318 in the cache */
   /* search270_1_0_1_1_0 -> 48 in the cache */
   /* search270_1_0_1_1 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      3, 1,
      { 318, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 3,
      { 826, 827 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 3,
      { 828 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 318, 829 },
      -1,
   } },

   /* replace270_0 -> 48 in the cache */
   /* replace270_1 -> 318 in the cache */
   /* replace270_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flrp,
      -1, 0,
      { 48, 318, 29 },
      -1,
   } },

   /* ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search271_0 -> 34 in the cache */
   /* search271_1 -> 53 in the cache */
   /* search271_2_0 -> 679 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 679 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 34, 53, 832 },
      -1,
   } },

   /* replace271_0 -> 679 in the cache */
   /* replace271_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 53 },
      -1,
   } },
   /* replace271_2_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 679, 834, 835 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search272_0 -> 34 in the cache */
   /* search272_1_0 -> 34 in the cache */
   /* search272_1_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 34, 53 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 34, 837, 838 },
      -1,
   } },

   /* replace272_0_0 -> 53 in the cache */
   /* replace272_0_1 -> 838 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 53, 838 },
      -1,
   } },
   /* replace272_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 840, 34 },
      -1,
   } },

   /* ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search273_0_0 -> 34 in the cache */
   /* search273_0_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 34, 53 },
      0,
   } },
   /* search273_1_0 -> 34 in the cache */
   /* search273_1_1 -> 838 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 34, 838 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 2,
      { 842, 843, 844 },
      -1,
   } },

   /* replace273_0_0 -> 53 in the cache */
   /* replace273_0_1 -> 838 in the cache */
   /* replace273_0_2 -> 844 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 53, 838, 844 },
      -1,
   } },
   /* replace273_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 846, 34 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search274_0 -> 34 in the cache */
   /* search274_1_0 -> 34 in the cache */
   /* search274_1_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 34, 53 },
      0,
   } },
   /* search274_2 -> 838 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 34, 848, 838 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* replace274_0_1 -> 53 in the cache */
   /* replace274_0_2 -> 838 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 850, 53, 838 },
      -1,
   } },
   /* replace274_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 851, 34 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search275_0_0 -> 34 in the cache */
   /* search275_0_1_0 -> 850 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 853 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 850, 854 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 34, 855 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search275_1_1 -> 853 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 857, 853 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 856, 858 },
      -1,
   } },

   /* replace275_0 -> 34 in the cache */
   /* replace275_1 -> 857 in the cache */
   /* replace275_2 -> 853 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 34, 857, 853 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search276_0_0 -> 34 in the cache */
   /* search276_0_1_0_0 -> 850 in the cache */
   /* search276_0_1_0_1_0 -> 853 in the cache */
   /* search276_0_1_0_1 -> 854 in the cache */
   /* search276_0_1_0 -> 855 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 855 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 34, 861 },
      -1,
   } },
   /* search276_1_0 -> 857 in the cache */
   /* search276_1_1_0 -> 853 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 853 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 857, 863 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 862, 864 },
      -1,
   } },

   /* replace276_0 -> 34 in the cache */
   /* replace276_1 -> 857 in the cache */
   /* replace276_2_0 -> 853 in the cache */
   /* replace276_2 -> 863 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 34, 857, 863 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search277_0 -> 34 in the cache */
   /* search277_1_0 -> 853 in the cache */
   /* search277_1_1_0 -> 857 in the cache */
   /* search277_1_1_1_0 -> 34 in the cache */
   /* search277_1_1_1 -> 607 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 857, 607 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 853, 867 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 34, 868 },
      -1,
   } },

   /* replace277_0 -> 34 in the cache */
   /* replace277_1 -> 857 in the cache */
   /* replace277_2 -> 853 in the cache */
   /* replace277 -> 860 in the cache */

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search278_0_0 -> 34 in the cache */
   /* search278_0_1_0 -> 850 in the cache */
   /* search278_0_1_1_0_0 -> 718 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 718 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 870 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 850, 871 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 34, 872 },
      -1,
   } },
   /* search278_1_0 -> 857 in the cache */
   /* search278_1_1_0 -> 718 in the cache */
   /* search278_1_1 -> 870 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 857, 870 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 873, 874 },
      -1,
   } },

   /* replace278_0 -> 718 in the cache */
   /* replace278_1 -> 857 in the cache */
   /* replace278_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 718, 857, 34 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search279_0 -> 34 in the cache */
   /* search279_1_0_0 -> 718 in the cache */
   /* search279_1_0 -> 870 in the cache */
   /* search279_1_1_0 -> 857 in the cache */
   /* search279_1_1_1_0 -> 34 in the cache */
   /* search279_1_1_1 -> 607 in the cache */
   /* search279_1_1 -> 867 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 870, 867 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 34, 877 },
      -1,
   } },

   /* replace279_0 -> 718 in the cache */
   /* replace279_1_0 -> 857 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 857 },
      -1,
   } },
   /* replace279_2_0 -> 34 in the cache */
   /* replace279_2 -> 835 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 718, 879, 835 },
      -1,
   } },

   /* ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search280_0 -> 34 in the cache */
   /* search280_1_0 -> 850 in the cache */
   /* search280_1_1_0_0 -> 718 in the cache */
   /* search280_1_1_0 -> 870 in the cache */
   /* search280_1_1 -> 871 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 850, 871 },
      -1,
   } },
   /* search280_2_0 -> 857 in the cache */
   /* search280_2_1_0 -> 718 in the cache */
   /* search280_2_1 -> 870 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 857, 870 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 34, 881, 882 },
      -1,
   } },

   /* replace280_0 -> 718 in the cache */
   /* replace280_1_0 -> 857 in the cache */
   /* replace280_1 -> 879 in the cache */
   /* replace280_2_0 -> 34 in the cache */
   /* replace280_2 -> 835 in the cache */
   /* replace280 -> 880 in the cache */

   /* ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search281_1_0 -> 718 in the cache */
   /* search281_1 -> 870 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 885 },
      -1,
   } },
   /* search281_2_1_0 -> 718 in the cache */
   /* search281_2_1 -> 870 in the cache */
   /* search281_2_2 -> 885 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 886, 870, 885 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 884, 870, 887 },
      -1,
   } },

   /* replace281_0 -> 718 in the cache */
   /* replace281_1_0 -> 884 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 884 },
      -1,
   } },
   /* replace281_2_0 -> 885 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 885 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 718, 889, 890 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', ('fcanonicalize', 'b'), ('fcanonicalize', 'a')) */
   /* search282_0_0 -> 741 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 741 },
      -1,
   } },
   /* search282_1_0 -> 53 in the cache */
   /* search282_1_1_0 -> 885 in the cache */
   /* search282_1_1 -> 886 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 53, 886 },
      -1,
   } },
   /* search282_2 -> 885 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 892, 893, 885 },
      -1,
   } },

   /* replace282_0 -> 741 in the cache */
   /* replace282_1_0 -> 53 in the cache */
   /* replace282_1 -> 834 in the cache */
   /* replace282_2_0 -> 885 in the cache */
   /* replace282_2 -> 890 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 741, 834, 890 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', ('fcanonicalize', 'd'), ('fmul', 'a', 'b')) */
   /* search283_0_0 -> 741 in the cache */
   /* search283_0 -> 892 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 896 },
      -1,
   } },
   /* search283_1_1 -> 857 in the cache */
   /* search283_1_2 -> 844 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 897, 857, 844 },
      -1,
   } },
   /* search283_2_0 -> 896 in the cache */
   /* search283_2_1 -> 857 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 896, 857 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 892, 898, 899 },
      -1,
   } },

   /* replace283_0 -> 741 in the cache */
   /* replace283_1_0 -> 844 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 844 },
      -1,
   } },
   /* replace283_2_0 -> 896 in the cache */
   /* replace283_2_1 -> 857 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 896, 857 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 741, 901, 902 },
      -1,
   } },

   /* ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search284_0 -> 850 in the cache */
   /* search284_1_0_0_0 -> 850 in the cache */
   /* search284_1_0_0_1_0 -> 34 in the cache */
   /* search284_1_0_0_1 -> 607 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 850, 607 },
      -1,
   } },
   /* search284_1_0_1_0 -> 850 in the cache */
   /* search284_1_0_1_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      3, 1,
      { 850, 905 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 3,
      { 904, 906 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 3,
      { 907 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 850, 908 },
      -1,
   } },

   /* replace284_0 -> 53 in the cache */
   /* replace284_1 -> 850 in the cache */
   /* replace284_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flrp,
      -1, 0,
      { 53, 850, 34 },
      -1,
   } },

   /* ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search285_0_0 -> 164 in the cache */
   /* search285_0_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 164, 165 },
      0,
   } },
   /* search285_1_0 -> 164 in the cache */
   /* search285_1_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 164, 167 },
      0,
   } },
   /* search285_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 2,
      { 911, 912, 168 },
      -1,
   } },

   /* replace285_0_0 -> 165 in the cache */
   /* replace285_0_1 -> 167 in the cache */
   /* replace285_0_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 165, 167, 168 },
      -1,
   } },
   /* replace285_1 -> 164 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 914, 164 },
      -1,
   } },

   /* ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a') */
   /* search286_0 -> 0 in the cache */
   /* search286_1 -> 302 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flrp,
      -1, 0,
      { 0, 302, 916 },
      -1,
   } },

   /* replace286_0_0_0 -> 0 in the cache */
   /* replace286_0_0 -> 249 in the cache */
   /* replace286_0_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 249, 916 },
      -1,
   } },
   /* replace286_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 918, 0 },
      -1,
   } },

   /* ('fadd', ('ffloor', 'a'), ('b2f', ('iand', ('flt', 'a', 0), ('flt', ('fneg', ('ffract', 'a')), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0)) */
   /* search287_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search287_1_0_0_0 -> 9 in the cache */
   /* search287_1_0_0_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 9, 73 },
      -1,
   } },
   /* search287_1_0_1_0_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffract,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 922 },
      -1,
   } },
   /* search287_1_0_1_1_0 -> 9 in the cache */
   /* search287_1_0_1_1 -> 922 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 923, 922 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 921, 924 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 1,
      { 925 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 920, 926 },
      -1,
   } },

   /* replace287_0_0 -> 9 in the cache */
   /* replace287_0_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fadd,
      0, 1,
      { 9, 73 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ftrunc,
      -1, 1,
      { 928 },
      -1,
   } },

   /* ('fadd', ('ffloor', 'a'), ('b2f', ('inot', ('fge', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a')))))) => ('ftrunc', ('fadd', 'a', 0)) */
   /* search288_0_0 -> 9 in the cache */
   /* search288_0 -> 920 in the cache */
   /* search288_1_0_0_0 -> 73 in the cache */
   /* search288_1_0_0_1_0_0 -> 9 in the cache */
   /* search288_1_0_0_1_0 -> 118 in the cache */
   /* search288_1_0_0_1_1_0 -> 9 in the cache */
   /* search288_1_0_0_1_1 -> 922 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 1,
      { 118, 922 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 73, 930 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 931 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 1,
      { 932 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 920, 933 },
      -1,
   } },

   /* replace288_0_0 -> 9 in the cache */
   /* replace288_0_1 -> 73 in the cache */
   /* replace288_0 -> 928 in the cache */
   /* replace288 -> 929 in the cache */

   /* ('fadd', ('ffloor', 'a'), ('b2f', ('flt', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0)) */
   /* search289_0_0 -> 9 in the cache */
   /* search289_0 -> 920 in the cache */
   /* search289_1_0_0 -> 73 in the cache */
   /* search289_1_0_1_0_0 -> 9 in the cache */
   /* search289_1_0_1_0 -> 118 in the cache */
   /* search289_1_0_1_1_0 -> 9 in the cache */
   /* search289_1_0_1_1 -> 922 in the cache */
   /* search289_1_0_1 -> 930 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 73, 930 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 1,
      { 935 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 920, 936 },
      -1,
   } },

   /* replace289_0_0 -> 9 in the cache */
   /* replace289_0_1 -> 73 in the cache */
   /* replace289_0 -> 928 in the cache */
   /* replace289 -> 929 in the cache */

   /* ('fadd(nnan,nsz)', 'a', ('ffract', ('fneg', 'a'))) => ('fceil', 'a') */
   /* search290_0 -> 9 in the cache */
   /* search290_1_0_0 -> 9 in the cache */
   /* search290_1_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffract,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 9, 938 },
      -1,
   } },

   /* replace290_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fceil,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search291_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ftrunc,
      -1, 0,
      { 24 },
      -1,
   } },

   /* replace291_0_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 24, 942 },
      -1,
   } },
   /* replace291_1_0_0_0 -> 24 in the cache */
   /* replace291_1_0_0 -> 594 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 594 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 944 },
      -1,
   } },
   /* replace291_2_0_0 -> 24 in the cache */
   /* replace291_2_0 -> 594 in the cache */
   /* replace291_2 -> 944 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 943, 945, 944 },
      -1,
   } },

   /* ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search292_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ftrunc,
      -1, 0,
      { 29 },
      -1,
   } },

   /* replace292_0_0 -> 29 in the cache */
   /* replace292_0_1 -> 271 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 29, 271 },
      -1,
   } },
   /* replace292_1_0_0_0 -> 29 in the cache */
   /* replace292_1_0_0 -> 489 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 489 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 949 },
      -1,
   } },
   /* replace292_2_0_0 -> 29 in the cache */
   /* replace292_2_0 -> 489 in the cache */
   /* replace292_2 -> 949 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 948, 950, 949 },
      -1,
   } },

   /* ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search293_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ftrunc,
      -1, 0,
      { 34 },
      -1,
   } },

   /* replace293_0_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 34, 953 },
      -1,
   } },
   /* replace293_1_0_0_0 -> 34 in the cache */
   /* replace293_1_0_0 -> 605 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 605 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 955 },
      -1,
   } },
   /* replace293_2_0_0 -> 34 in the cache */
   /* replace293_2_0 -> 605 in the cache */
   /* replace293_2 -> 955 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 954, 956, 955 },
      -1,
   } },

   /* ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search294_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 24 },
      -1,
   } },

   /* replace294_0 -> 24 in the cache */
   /* replace294_1_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffract,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 24, 959 },
      -1,
   } },

   /* ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search295_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 29 },
      -1,
   } },

   /* replace295_0 -> 29 in the cache */
   /* replace295_1_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffract,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 29, 962 },
      -1,
   } },

   /* ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search296_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 34 },
      -1,
   } },

   /* replace296_0 -> 34 in the cache */
   /* replace296_1_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffract,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 34, 965 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a')) */
   /* search297_0 -> 24 in the cache */
   /* search297_1_0 -> 678 in the cache */
   /* search297_1_1_0_0 -> 24 in the cache */
   /* search297_1_1_0 -> 959 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 959 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 678, 967 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 24, 968 },
      -1,
   } },

   /* replace297_0 -> 678 in the cache */
   /* replace297_1_0 -> 24 in the cache */
   /* replace297_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 678, 958 },
      -1,
   } },

   /* ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a')) */
   /* search298_0 -> 29 in the cache */
   /* search298_1_0 -> 48 in the cache */
   /* search298_1_1_0_0 -> 29 in the cache */
   /* search298_1_1_0 -> 962 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 962 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 48, 971 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 29, 972 },
      -1,
   } },

   /* replace298_0 -> 48 in the cache */
   /* replace298_1_0 -> 29 in the cache */
   /* replace298_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 48, 961 },
      -1,
   } },

   /* ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a')) */
   /* search299_0 -> 34 in the cache */
   /* search299_1_0 -> 53 in the cache */
   /* search299_1_1_0_0 -> 34 in the cache */
   /* search299_1_1_0 -> 965 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 965 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 53, 975 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 34, 976 },
      -1,
   } },

   /* replace299_0 -> 53 in the cache */
   /* replace299_1_0 -> 34 in the cache */
   /* replace299_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 53, 964 },
      -1,
   } },

   /* ('fadd@16(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search300_0 -> 24 in the cache */
   /* search300_1_0_0 -> 24 in the cache */
   /* search300_1_0 -> 959 in the cache */
   /* search300_1 -> 967 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 24, 967 },
      -1,
   } },

   /* replace300_0 -> 24 in the cache */
   /* replace300 -> 958 in the cache */

   /* ('fadd@32(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search301_0 -> 29 in the cache */
   /* search301_1_0_0 -> 29 in the cache */
   /* search301_1_0 -> 962 in the cache */
   /* search301_1 -> 971 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 29, 971 },
      -1,
   } },

   /* replace301_0 -> 29 in the cache */
   /* replace301 -> 961 in the cache */

   /* ('fadd@64(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search302_0 -> 34 in the cache */
   /* search302_1_0_0 -> 34 in the cache */
   /* search302_1_0 -> 965 in the cache */
   /* search302_1 -> 975 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 34, 975 },
      -1,
   } },

   /* replace302_0 -> 34 in the cache */
   /* replace302 -> 964 in the cache */

   /* ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search303_0 -> 24 in the cache */
   /* search303 -> 959 in the cache */

   /* replace303_0 -> 24 in the cache */
   /* replace303_1_0 -> 24 in the cache */
   /* replace303_1 -> 958 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 24, 958 },
      -1,
   } },

   /* ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search304_0 -> 29 in the cache */
   /* search304 -> 962 in the cache */

   /* replace304_0 -> 29 in the cache */
   /* replace304_1_0 -> 29 in the cache */
   /* replace304_1 -> 961 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 29, 961 },
      -1,
   } },

   /* ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search305_0 -> 34 in the cache */
   /* search305 -> 965 in the cache */

   /* replace305_0 -> 34 in the cache */
   /* replace305_1_0 -> 34 in the cache */
   /* replace305_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 34, 964 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a') */
   /* search306_0 -> 24 in the cache */
   /* search306_1_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 24 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 985 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 24, 986 },
      -1,
   } },

   /* replace306_0 -> 24 in the cache */
   /* replace306 -> 959 in the cache */

   /* ('fadd@32', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a') */
   /* search307_0 -> 29 in the cache */
   /* search307_1_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 29 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 988 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 29, 989 },
      -1,
   } },

   /* replace307_0 -> 29 in the cache */
   /* replace307 -> 962 in the cache */

   /* ('fadd@64', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a') */
   /* search308_0 -> 34 in the cache */
   /* search308_1_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 34 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 991 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 34, 992 },
      -1,
   } },

   /* replace308_0 -> 34 in the cache */
   /* replace308 -> 965 in the cache */

   /* ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a'))) */
   /* search309_0 -> 9 in the cache */
   /* search309 -> 940 in the cache */

   /* replace309_0_0_0 -> 9 in the cache */
   /* replace309_0_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 994 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search310_0 -> 24 in the cache */
   /* search310_1 -> 678 in the cache */
   /* search310_2 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 24, 678, 686 },
      -1,
   } },

   /* replace310_0_0 -> 24 in the cache */
   /* replace310_0_1 -> 678 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 24, 678 },
      -1,
   } },
   /* replace310_1 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 997, 686 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search311_0 -> 29 in the cache */
   /* search311_1 -> 48 in the cache */
   /* search311_2 -> 150 in the cache */
   /* search311 -> 284 in the cache */

   /* replace311_0_0 -> 29 in the cache */
   /* replace311_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 29, 48 },
      -1,
   } },
   /* replace311_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 999, 150 },
      -1,
   } },

   /* ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search312_0 -> 34 in the cache */
   /* search312_1 -> 53 in the cache */
   /* search312_2 -> 838 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 34, 53, 838 },
      -1,
   } },

   /* replace312_0_0 -> 34 in the cache */
   /* replace312_0_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 34, 53 },
      -1,
   } },
   /* replace312_1 -> 838 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 1002, 838 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search313_0 -> 29 in the cache */
   /* search313_1 -> 48 in the cache */
   /* search313_2 -> 150 in the cache */
   /* search313 -> 559 in the cache */

   /* replace313_0_0 -> 29 in the cache */
   /* replace313_0_1 -> 48 in the cache */
   /* replace313_0 -> 149 in the cache */
   /* replace313_1 -> 150 in the cache */
   /* replace313 -> 334 in the cache */

   /* ('ffma@16(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search314_0 -> 24 in the cache */
   /* search314_1 -> 678 in the cache */
   /* search314_2 -> 686 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 24, 678, 686 },
      -1,
   } },

   /* replace314_0_0 -> 24 in the cache */
   /* replace314_0_1 -> 678 in the cache */
   /* replace314_0 -> 997 in the cache */
   /* replace314_1 -> 686 in the cache */
   /* replace314 -> 998 in the cache */

   /* ('ffma@32(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search315_0 -> 29 in the cache */
   /* search315_1 -> 48 in the cache */
   /* search315_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* replace315_0_0 -> 29 in the cache */
   /* replace315_0_1 -> 48 in the cache */
   /* replace315_0 -> 999 in the cache */
   /* replace315_1 -> 150 in the cache */
   /* replace315 -> 1000 in the cache */

   /* ('ffma@64(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search316_0 -> 34 in the cache */
   /* search316_1 -> 53 in the cache */
   /* search316_2 -> 838 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 34, 53, 838 },
      -1,
   } },

   /* replace316_0_0 -> 34 in the cache */
   /* replace316_0_1 -> 53 in the cache */
   /* replace316_0 -> 1002 in the cache */
   /* replace316_1 -> 838 in the cache */
   /* replace316 -> 1003 in the cache */

   /* ('ffmaz(contract)', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search317_0 -> 29 in the cache */
   /* search317_1 -> 48 in the cache */
   /* search317_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 150 },
      -1,
   } },

   /* replace317_0_0 -> 29 in the cache */
   /* replace317_0_1 -> 48 in the cache */
   /* replace317_0 -> 149 in the cache */
   /* replace317_1 -> 150 in the cache */
   /* replace317 -> 334 in the cache */

   /* ('~fmul', ('fadd', ('bcsel', 'a', ('fmul', 'b', 'c'), 0), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 1009, 1010 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -5 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 1008, 1011, 1012 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 2,
      { 1013, 1014 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 1015, 1016 },
      -1,
   } },

   /* replace318_0 -> 1008 in the cache */
   /* replace318_1_0_0_0 -> 1009 in the cache */
   /* replace318_1_0_0_1 -> 1010 in the cache */
   /* replace318_1_0_0 -> 1011 in the cache */
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 2,
      { 1011, 1018 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 1019, 1020 },
      -1,
   } },
   /* replace318_2_0 -> 1018 in the cache */
   /* replace318_2_1 -> 1020 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 1018, 1020 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1008, 1021, 1022 },
      -1,
   } },

   /* ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b') */
   /* search319_0 -> 0 in the cache */
   /* search319_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdph,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   /* replace319_0_3 -> 315 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec4,
      -1, 0,
      { 1025, 1026, 1027, 315 },
      -1,
   } },
   /* replace319_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1028, 1 },
      -1,
   } },

   /* ('fdot4', 'a', 0.0) => 0.0 */
   /* search320_0 -> 9 in the cache */
   /* search320_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fdot4,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace320 -> 8 in the cache */

   /* ('fdot3', 'a', 0.0) => 0.0 */
   /* search321_0 -> 9 in the cache */
   /* search321_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fdot3,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace321 -> 8 in the cache */

   /* ('fdot2', 'a', 0.0) => 0.0 */
   /* search322_0 -> 9 in the cache */
   /* search322_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fdot2,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace322 -> 8 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search323_0_0 -> 164 in the cache */
   /* search323_0_1 -> 165 in the cache */
   /* search323_0_2 -> 167 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec4,
      -1, 0,
      { 164, 165, 167, 1033 },
      -1,
   } },
   /* search323_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1034, 168 },
      -1,
   } },

   /* replace323_0_0 -> 164 in the cache */
   /* replace323_0_1 -> 165 in the cache */
   /* replace323_0_2 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec3,
      -1, 0,
      { 164, 165, 167 },
      -1,
   } },
   /* replace323_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdph,
      -1, 0,
      { 1036, 168 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b.x') */
   /* search324_0_0 -> 0 in the cache */
   /* search324_0_1 -> 302 in the cache */
   /* search324_0_2 -> 302 in the cache */
   /* search324_0_3 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_vec4,
      -1, 0,
      { 0, 302, 302, 302 },
      -1,
   } },
   /* search324_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1038, 1 },
      -1,
   } },

   /* replace324_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 0, 1040 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search325_0_0 -> 141 in the cache */
   /* search325_0_1 -> 142 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search325_0_3 -> 1042 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec4,
      -1, 0,
      { 141, 142, 1042, 1042 },
      -1,
   } },
   /* search325_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1043, 144 },
      -1,
   } },

   /* replace325_0_0 -> 141 in the cache */
   /* replace325_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec2,
      -1, 0,
      { 141, 142 },
      -1,
   } },
   /* replace325_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot2,
      0, 1,
      { 1045, 144 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search326_0_0 -> 164 in the cache */
   /* search326_0_1 -> 165 in the cache */
   /* search326_0_2 -> 167 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec4,
      -1, 0,
      { 164, 165, 167, 1047 },
      -1,
   } },
   /* search326_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1048, 168 },
      -1,
   } },

   /* replace326_0_0 -> 164 in the cache */
   /* replace326_0_1 -> 165 in the cache */
   /* replace326_0_2 -> 167 in the cache */
   /* replace326_0 -> 1036 in the cache */
   /* replace326_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1036, 168 },
      -1,
   } },

   /* ('fdot4', 'a(w_is_zero)', 'b') => ('fdot3', 'a.xyz', 'b.xyz') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      8,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search327_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1051, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1053, 1054 },
      -1,
   } },

   /* ('fdot4', 'a(z_is_zero)', 'b') => ('fdot3', 'a.xyw', 'b.xyw') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      9,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search328_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1056, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 3},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 3},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1058, 1059 },
      -1,
   } },

   /* ('fdot4', 'a(y_is_zero)', 'b') => ('fdot3', 'a.xzw', 'b.xzw') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search329_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1061, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 2, 3},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 2, 3},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1063, 1064 },
      -1,
   } },

   /* ('fdot4', 'a(x_is_zero)', 'b') => ('fdot3', 'a.yzw', 'b.yzw') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      11,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search330_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1066, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1, 2, 3},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1, 2, 3},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1068, 1069 },
      -1,
   } },

   /* ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b.x') */
   /* search331_0_0 -> 0 in the cache */
   /* search331_0_1 -> 302 in the cache */
   /* search331_0_2 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_vec3,
      -1, 0,
      { 0, 302, 302 },
      -1,
   } },
   /* search331_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1071, 1 },
      -1,
   } },

   /* replace331_0 -> 0 in the cache */
   /* replace331_1 -> 1040 in the cache */
   /* replace331 -> 1041 in the cache */

   /* ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search332_0_0 -> 141 in the cache */
   /* search332_0_1 -> 142 in the cache */
   /* search332_0_2 -> 1042 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec3,
      -1, 0,
      { 141, 142, 1042 },
      -1,
   } },
   /* search332_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1073, 144 },
      -1,
   } },

   /* replace332_0_0 -> 141 in the cache */
   /* replace332_0_1 -> 142 in the cache */
   /* replace332_0 -> 1045 in the cache */
   /* replace332_1 -> 144 in the cache */
   /* replace332 -> 1046 in the cache */

   /* ('fdot3', 'a(x_is_zero)', 'b') => ('fdot2', 'a.yz', 'b.yz') */
   /* search333_0 -> 1066 in the cache */
   /* search333_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1066, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1, 2},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1, 2},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot2,
      0, 1,
      { 1076, 1077 },
      -1,
   } },

   /* ('fdot3', 'a(y_is_zero)', 'b') => ('fdot2', 'a.xz', 'b.xz') */
   /* search334_0 -> 1061 in the cache */
   /* search334_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1061, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 2},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 2},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot2,
      0, 1,
      { 1080, 1081 },
      -1,
   } },

   /* ('fdot3', 'a(z_is_zero)', 'b') => ('fdot2', 'a.xy', 'b.xy') */
   /* search335_0 -> 1056 in the cache */
   /* search335_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1056, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot2,
      0, 1,
      { 1084, 1085 },
      -1,
   } },

   /* ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b.x') */
   /* search336_0_0 -> 0 in the cache */
   /* search336_0_1 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_vec2,
      -1, 0,
      { 0, 302 },
      -1,
   } },
   /* search336_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot2,
      0, 1,
      { 1087, 1 },
      -1,
   } },

   /* replace336_0 -> 0 in the cache */
   /* replace336_1 -> 1040 in the cache */
   /* replace336 -> 1041 in the cache */

   /* ('fdot2', 'a(x_is_zero)', 'b') => ('fmul', 'a.y', 'b.y') */
   /* search337_0 -> 1066 in the cache */
   /* search337_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot2,
      0, 1,
      { 1066, 1 },
      -1,
   } },

   /* replace337_0 -> 1026 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 1026, 1090 },
      -1,
   } },

   /* ('fdot2', 'a(y_is_zero)', 'b') => ('fmul', 'a.x', 'b.x') */
   /* search338_0 -> 1061 in the cache */
   /* search338_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot2,
      0, 1,
      { 1061, 1 },
      -1,
   } },

   /* replace338_0 -> 1025 in the cache */
   /* replace338_1 -> 1040 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 1025, 1040 },
      -1,
   } },

   /* ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y') */
   /* search339_0 -> 9 in the cache */
   /* search339_1 -> 291 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fdot2,
      0, 1,
      { 9, 291 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      -1, 0,
      { 1095, 1096 },
      -1,
   } },

   /* ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a'))) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      12,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 1098 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1099 },
      0,
   } },
   /* search340_1 -> 291 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fadd,
      0, 1,
      { 1100, 291 },
      -1,
   } },

   /* replace340_0_0 -> 291 in the cache */
   /* replace340_0_1_0 -> 9 in the cache */
   /* replace340_0_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 291, 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 1102 },
      -1,
   } },

   /* ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd')) */
   /* search341_0_0_0 -> 141 in the cache */
   /* search341_0_0_1 -> 329 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 1,
      { 141, 329 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1104, 1105 },
      -1,
   } },
   /* search341_1 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 2,
      { 1106, 360 },
      -1,
   } },

   /* replace341_0_0 -> 141 in the cache */
   /* replace341_0_1_0 -> 142 in the cache */
   /* replace341_0_1_1 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 142, 178 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 1,
      { 141, 1108 },
      -1,
   } },
   /* replace341_1_0 -> 144 in the cache */
   /* replace341_1_1 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 144, 178 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1109, 1110 },
      -1,
   } },

   /* ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c')) */
   /* search342_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 0, 1112 },
      -1,
   } },
   /* search342_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1113, 358 },
      -1,
   } },

   /* replace342_0 -> 0 in the cache */
   /* replace342_1_0 -> 1 in the cache */
   /* replace342_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1, 150 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 0, 1115 },
      -1,
   } },

   /* ('imul', ('ishl', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'c', 'b')) */
   /* search343_0_0 -> 141 in the cache */
   /* search343_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 141, 45 },
      -1,
   } },
   /* search343_1 -> 1105 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 1117, 1105 },
      -1,
   } },

   /* replace343_0 -> 141 in the cache */
   /* replace343_1_0 -> 144 in the cache */
   /* replace343_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 144, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 141, 1119 },
      -1,
   } },

   /* ('fcanonicalize', 'a@16') => a */
   /* search344_0 -> 24 in the cache */
   /* search344 -> 683 in the cache */

   /* replace344 -> 24 in the cache */

   /* ('fcanonicalize', 'a@32') => a */
   /* search345_0 -> 29 in the cache */
   /* search345 -> 764 in the cache */

   /* replace345 -> 29 in the cache */

   /* ('fcanonicalize', 'a@64') => a */
   /* search346_0 -> 34 in the cache */
   /* search346 -> 835 in the cache */

   /* replace346 -> 34 in the cache */

   /* ('fcanonicalize(is_only_used_as_float)', 'a') => a */
   /* search347_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 9 },
      1,
   } },

   /* replace347 -> 9 in the cache */

   /* ('fcanonicalize', 'a(is_created_as_float)') => a */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 1122 },
      -1,
   } },

   /* replace348 -> 9 in the cache */

   /* ('fcanonicalize', 'a(is_integral)') => a */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      14,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fcanonicalize,
      -1, 0,
      { 1124 },
      -1,
   } },

   /* replace349 -> 9 in the cache */

   /* ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search350_0_0 -> 19 in the cache */
   /* search350_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search350_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1126, 358 },
      -1,
   } },

   /* replace350_0_0_0_0 -> 48 in the cache */
   /* replace350_0_0_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 48, 22 },
      -1,
   } },
   /* replace350_0_0_1_0 -> 150 in the cache */
   /* replace350_0_0_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 150, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1128, 1129 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8ull /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ult,
      -1, 3,
      { 1130, 1131 },
      -1,
   } },
   /* replace350_1_0 -> 19 in the cache */
   /* replace350_1_1_0 -> 48 in the cache */
   /* replace350_1_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      3, 1,
      { 48, 150 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 19, 1133 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1132, 1134, 1135 },
      -1,
   } },

   /* ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search351_0_0 -> 19 in the cache */
   /* search351_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search351_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1137, 358 },
      -1,
   } },

   /* replace351_0_0_0_0 -> 48 in the cache */
   /* replace351_0_0_0_1 -> 22 in the cache */
   /* replace351_0_0_0 -> 1128 in the cache */
   /* replace351_0_0_1_0 -> 150 in the cache */
   /* replace351_0_0_1_1 -> 22 in the cache */
   /* replace351_0_0_1 -> 1129 in the cache */
   /* replace351_0_0 -> 1130 in the cache */
   /* replace351_0_1 -> 1131 in the cache */
   /* replace351_0 -> 1132 in the cache */
   /* replace351_1_0 -> 19 in the cache */
   /* replace351_1_1_0 -> 48 in the cache */
   /* replace351_1_1_1 -> 150 in the cache */
   /* replace351_1_1 -> 1133 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 19, 1133 },
      -1,
   } },
   /* replace351_2 -> 1135 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1132, 1139, 1135 },
      -1,
   } },

   /* ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7)) */
   /* search352_0_0 -> 19 in the cache */
   /* search352_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search352_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 1141, 358 },
      -1,
   } },

   /* replace352_0 -> 19 in the cache */
   /* replace352_1_0_0_0 -> 48 in the cache */
   /* replace352_1_0_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 48, 22 },
      -1,
   } },
   /* replace352_1_0_1_0 -> 150 in the cache */
   /* replace352_1_0_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      3, 1,
      { 150, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 1143, 1144 },
      -1,
   } },
   /* replace352_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imin,
      0, 4,
      { 1145, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 4,
      { 19, 1146 },
      -1,
   } },

   /* ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search353_0_0 -> 24 in the cache */
   /* search353_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search353_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1148, 358 },
      -1,
   } },

   /* replace353_0_0_0_0 -> 48 in the cache */
   /* replace353_0_0_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 48, 27 },
      -1,
   } },
   /* replace353_0_0_1_0 -> 150 in the cache */
   /* replace353_0_0_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 150, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1150, 1151 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10ull /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ult,
      -1, 3,
      { 1152, 1153 },
      -1,
   } },
   /* replace353_1_0 -> 24 in the cache */
   /* replace353_1_1_0 -> 48 in the cache */
   /* replace353_1_1_1 -> 150 in the cache */
   /* replace353_1_1 -> 1133 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 24, 1133 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1154, 1155, 1156 },
      -1,
   } },

   /* ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search354_0_0 -> 24 in the cache */
   /* search354_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search354_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1158, 358 },
      -1,
   } },

   /* replace354_0_0_0_0 -> 48 in the cache */
   /* replace354_0_0_0_1 -> 27 in the cache */
   /* replace354_0_0_0 -> 1150 in the cache */
   /* replace354_0_0_1_0 -> 150 in the cache */
   /* replace354_0_0_1_1 -> 27 in the cache */
   /* replace354_0_0_1 -> 1151 in the cache */
   /* replace354_0_0 -> 1152 in the cache */
   /* replace354_0_1 -> 1153 in the cache */
   /* replace354_0 -> 1154 in the cache */
   /* replace354_1_0 -> 24 in the cache */
   /* replace354_1_1_0 -> 48 in the cache */
   /* replace354_1_1_1 -> 150 in the cache */
   /* replace354_1_1 -> 1133 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 24, 1133 },
      -1,
   } },
   /* replace354_2 -> 1156 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1154, 1160, 1156 },
      -1,
   } },

   /* ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15)) */
   /* search355_0_0 -> 24 in the cache */
   /* search355_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search355_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 1162, 358 },
      -1,
   } },

   /* replace355_0 -> 24 in the cache */
   /* replace355_1_0_0_0 -> 48 in the cache */
   /* replace355_1_0_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 48, 27 },
      -1,
   } },
   /* replace355_1_0_1_0 -> 150 in the cache */
   /* replace355_1_0_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      3, 1,
      { 150, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 1164, 1165 },
      -1,
   } },
   /* replace355_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imin,
      0, 4,
      { 1166, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 4,
      { 24, 1167 },
      -1,
   } },

   /* ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search356_0_0 -> 29 in the cache */
   /* search356_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search356_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1169, 358 },
      -1,
   } },

   /* replace356_0_0_0_0 -> 48 in the cache */
   /* replace356_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 48, 32 },
      -1,
   } },
   /* replace356_0_0_1_0 -> 150 in the cache */
   /* replace356_0_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 150, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1171, 1172 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20ull /* 32 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ult,
      -1, 3,
      { 1173, 1174 },
      -1,
   } },
   /* replace356_1_0 -> 29 in the cache */
   /* replace356_1_1_0 -> 48 in the cache */
   /* replace356_1_1_1 -> 150 in the cache */
   /* replace356_1_1 -> 1133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 29, 1133 },
      -1,
   } },
   /* replace356_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1175, 1176, 137 },
      -1,
   } },

   /* ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search357_0_0 -> 29 in the cache */
   /* search357_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search357_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1178, 358 },
      -1,
   } },

   /* replace357_0_0_0_0 -> 48 in the cache */
   /* replace357_0_0_0_1 -> 32 in the cache */
   /* replace357_0_0_0 -> 1171 in the cache */
   /* replace357_0_0_1_0 -> 150 in the cache */
   /* replace357_0_0_1_1 -> 32 in the cache */
   /* replace357_0_0_1 -> 1172 in the cache */
   /* replace357_0_0 -> 1173 in the cache */
   /* replace357_0_1 -> 1174 in the cache */
   /* replace357_0 -> 1175 in the cache */
   /* replace357_1_0 -> 29 in the cache */
   /* replace357_1_1_0 -> 48 in the cache */
   /* replace357_1_1_1 -> 150 in the cache */
   /* replace357_1_1 -> 1133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 29, 1133 },
      -1,
   } },
   /* replace357_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1175, 1180, 137 },
      -1,
   } },

   /* ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31)) */
   /* search358_0_0 -> 29 in the cache */
   /* search358_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search358_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 1182, 358 },
      -1,
   } },

   /* replace358_0 -> 29 in the cache */
   /* replace358_1_0_0_0 -> 48 in the cache */
   /* replace358_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 48, 32 },
      -1,
   } },
   /* replace358_1_0_1_0 -> 150 in the cache */
   /* replace358_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      3, 1,
      { 150, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 1184, 1185 },
      -1,
   } },
   /* replace358_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imin,
      0, 4,
      { 1186, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 4,
      { 29, 1187 },
      -1,
   } },

   /* ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search359_0_0 -> 34 in the cache */
   /* search359_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search359_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1189, 358 },
      -1,
   } },

   /* replace359_0_0_0_0 -> 48 in the cache */
   /* replace359_0_0_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 48, 37 },
      -1,
   } },
   /* replace359_0_0_1_0 -> 150 in the cache */
   /* replace359_0_0_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 150, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1191, 1192 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x40ull /* 64 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ult,
      -1, 3,
      { 1193, 1194 },
      -1,
   } },
   /* replace359_1_0 -> 34 in the cache */
   /* replace359_1_1_0 -> 48 in the cache */
   /* replace359_1_1_1 -> 150 in the cache */
   /* replace359_1_1 -> 1133 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 34, 1133 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1195, 1196, 1197 },
      -1,
   } },

   /* ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search360_0_0 -> 34 in the cache */
   /* search360_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search360_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1199, 358 },
      -1,
   } },

   /* replace360_0_0_0_0 -> 48 in the cache */
   /* replace360_0_0_0_1 -> 37 in the cache */
   /* replace360_0_0_0 -> 1191 in the cache */
   /* replace360_0_0_1_0 -> 150 in the cache */
   /* replace360_0_0_1_1 -> 37 in the cache */
   /* replace360_0_0_1 -> 1192 in the cache */
   /* replace360_0_0 -> 1193 in the cache */
   /* replace360_0_1 -> 1194 in the cache */
   /* replace360_0 -> 1195 in the cache */
   /* replace360_1_0 -> 34 in the cache */
   /* replace360_1_1_0 -> 48 in the cache */
   /* replace360_1_1_1 -> 150 in the cache */
   /* replace360_1_1 -> 1133 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 34, 1133 },
      -1,
   } },
   /* replace360_2 -> 1197 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1195, 1201, 1197 },
      -1,
   } },

   /* ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63)) */
   /* search361_0_0 -> 34 in the cache */
   /* search361_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search361_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 1203, 358 },
      -1,
   } },

   /* replace361_0 -> 34 in the cache */
   /* replace361_1_0_0_0 -> 48 in the cache */
   /* replace361_1_0_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 48, 37 },
      -1,
   } },
   /* replace361_1_0_1_0 -> 150 in the cache */
   /* replace361_1_0_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      3, 1,
      { 150, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 1205, 1206 },
      -1,
   } },
   /* replace361_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imin,
      0, 4,
      { 1207, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 4,
      { 34, 1208 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search362_0_0 -> 19 in the cache */
   /* search362_0_1 -> 45 in the cache */
   /* search362_0 -> 1137 in the cache */
   /* search362_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1137, 48 },
      -1,
   } },

   /* replace362_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   /* replace362_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1211, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 19, 1212 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search363_0_0 -> 19 in the cache */
   /* search363_0_1 -> 45 in the cache */
   /* search363_0 -> 1141 in the cache */
   /* search363_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1141, 48 },
      -1,
   } },

   /* replace363_0 -> 19 in the cache */
   /* replace363_1_0 -> 1211 in the cache */
   /* replace363_1_1 -> 48 in the cache */
   /* replace363_1 -> 1212 in the cache */
   /* replace363 -> 1213 in the cache */

   /* ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b')) */
   /* search364_0_0 -> 19 in the cache */
   /* search364_0_1 -> 45 in the cache */
   /* search364_0 -> 1126 in the cache */
   /* search364_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1126, 48 },
      -1,
   } },

   /* replace364_0 -> 19 in the cache */
   /* replace364_1_0 -> 1211 in the cache */
   /* replace364_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1211, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 19, 1216 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search365_0_0 -> 24 in the cache */
   /* search365_0_1 -> 45 in the cache */
   /* search365_0 -> 1158 in the cache */
   /* search365_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1158, 48 },
      -1,
   } },

   /* replace365_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffffull /* 65535 */ },
   } },
   /* replace365_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1219, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 24, 1220 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search366_0_0 -> 24 in the cache */
   /* search366_0_1 -> 45 in the cache */
   /* search366_0 -> 1162 in the cache */
   /* search366_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1162, 48 },
      -1,
   } },

   /* replace366_0 -> 24 in the cache */
   /* replace366_1_0 -> 1219 in the cache */
   /* replace366_1_1 -> 48 in the cache */
   /* replace366_1 -> 1220 in the cache */
   /* replace366 -> 1221 in the cache */

   /* ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b')) */
   /* search367_0_0 -> 24 in the cache */
   /* search367_0_1 -> 45 in the cache */
   /* search367_0 -> 1148 in the cache */
   /* search367_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1148, 48 },
      -1,
   } },

   /* replace367_0 -> 24 in the cache */
   /* replace367_1_0 -> 1219 in the cache */
   /* replace367_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1219, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 24, 1224 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search368_0_0 -> 29 in the cache */
   /* search368_0_1 -> 45 in the cache */
   /* search368_0 -> 1178 in the cache */
   /* search368_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1178, 48 },
      -1,
   } },

   /* replace368_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffull /* 4294967295 */ },
   } },
   /* replace368_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1227, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1228 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search369_0_0 -> 29 in the cache */
   /* search369_0_1 -> 45 in the cache */
   /* search369_0 -> 1182 in the cache */
   /* search369_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1182, 48 },
      -1,
   } },

   /* replace369_0 -> 29 in the cache */
   /* replace369_1_0 -> 1227 in the cache */
   /* replace369_1_1 -> 48 in the cache */
   /* replace369_1 -> 1228 in the cache */
   /* replace369 -> 1229 in the cache */

   /* ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b')) */
   /* search370_0_0 -> 29 in the cache */
   /* search370_0_1 -> 45 in the cache */
   /* search370_0 -> 1169 in the cache */
   /* search370_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1169, 48 },
      -1,
   } },

   /* replace370_0 -> 29 in the cache */
   /* replace370_1_0 -> 1227 in the cache */
   /* replace370_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1227, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1232 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search371_0_0 -> 34 in the cache */
   /* search371_0_1 -> 45 in the cache */
   /* search371_0 -> 1199 in the cache */
   /* search371_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1199, 48 },
      -1,
   } },

   /* replace371_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffffull /* 18446744073709551615 */ },
   } },
   /* replace371_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1235, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 34, 1236 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search372_0_0 -> 34 in the cache */
   /* search372_0_1 -> 45 in the cache */
   /* search372_0 -> 1203 in the cache */
   /* search372_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1203, 48 },
      -1,
   } },

   /* replace372_0 -> 34 in the cache */
   /* replace372_1_0 -> 1235 in the cache */
   /* replace372_1_1 -> 48 in the cache */
   /* replace372_1 -> 1236 in the cache */
   /* replace372 -> 1237 in the cache */

   /* ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b')) */
   /* search373_0_0 -> 34 in the cache */
   /* search373_0_1 -> 45 in the cache */
   /* search373_0 -> 1189 in the cache */
   /* search373_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1189, 48 },
      -1,
   } },

   /* replace373_0 -> 34 in the cache */
   /* replace373_1_0 -> 1235 in the cache */
   /* replace373_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1235, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 34, 1240 },
      -1,
   } },

   /* ('iand@32', ('ushr@32(is_used_once)', 'a', 'b'), '#c(is_const_bitmask)') => ('ubfe', 'a', 'b', ('bit_count', 'c')) */
   /* search374_0_0 -> 29 in the cache */
   /* search374_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 48 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      15,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1242, 1243 },
      -1,
   } },

   /* replace374_0 -> 29 in the cache */
   /* replace374_1 -> 48 in the cache */
   /* replace374_2_0 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bit_count,
      -1, 0,
      { 150 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 29, 48, 1245 },
      -1,
   } },

   /* ('iand@32', ('ushr@32', 'a', 'b'), ('bfm', 'c', 0)) => ('ubfe', 'a', 'b', 'c') */
   /* search375_0_0 -> 29 in the cache */
   /* search375_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 48 },
      -1,
   } },
   /* search375_1_0 -> 150 in the cache */
   /* search375_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bfm,
      -1, 0,
      { 150, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1247, 1248 },
      -1,
   } },

   /* replace375_0 -> 29 in the cache */
   /* replace375_1 -> 48 in the cache */
   /* replace375_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 29, 48, 150 },
      -1,
   } },

   /* ('ushr', ('iand', 'a', ('bfm', 'c', 'b')), 'b') => ('ubfe', 'a', 'b', 'c') */
   /* search376_0_0 -> 29 in the cache */
   /* search376_0_1_0 -> 778 in the cache */
   /* search376_0_1_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bfm,
      -1, 0,
      { 778, 782 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1251 },
      -1,
   } },
   /* search376_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 1252, 782 },
      -1,
   } },

   /* replace376_0 -> 29 in the cache */
   /* replace376_1 -> 782 in the cache */
   /* replace376_2 -> 778 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 29, 782, 778 },
      -1,
   } },

   /* ('ushr@32', ('iand(is_used_once)', 'a', '#b(is_const_bfm)'), '#c') => ('bcsel', ('ilt', ('find_lsb', 'b'), ('iand', 'c', 31)), ('ushr', ('ubfe', 'a', ('find_lsb', 'b'), ('bit_count', 'b')), ('isub', 'c', ('find_lsb', 'b'))), ('ishl', ('ubfe', 'a', ('find_lsb', 'b'), ('bit_count', 'b')), ('isub', ('find_lsb', 'b'), 'c'))) */
   /* search377_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1255 },
      0,
   } },
   /* search377_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 1256, 358 },
      -1,
   } },

   /* replace377_0_0_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_find_lsb,
      -1, 0,
      { 48 },
      -1,
   } },
   /* replace377_0_1_0 -> 150 in the cache */
   /* replace377_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 150, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 1,
      { 1258, 1259 },
      -1,
   } },
   /* replace377_1_0_0 -> 29 in the cache */
   /* replace377_1_0_1_0 -> 48 in the cache */
   /* replace377_1_0_1 -> 1258 in the cache */
   /* replace377_1_0_2_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bit_count,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 29, 1258, 1261 },
      -1,
   } },
   /* replace377_1_1_0 -> 150 in the cache */
   /* replace377_1_1_1_0 -> 48 in the cache */
   /* replace377_1_1_1 -> 1258 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 150, 1258 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1262, 1263 },
      -1,
   } },
   /* replace377_2_0_0 -> 29 in the cache */
   /* replace377_2_0_1_0 -> 48 in the cache */
   /* replace377_2_0_1 -> 1258 in the cache */
   /* replace377_2_0_2_0 -> 48 in the cache */
   /* replace377_2_0_2 -> 1261 in the cache */
   /* replace377_2_0 -> 1262 in the cache */
   /* replace377_2_1_0_0 -> 48 in the cache */
   /* replace377_2_1_0 -> 1258 in the cache */
   /* replace377_2_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 1258, 150 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1262, 1265 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 1260, 1264, 1266 },
      -1,
   } },

   /* ('ubfe', ('ubfe', 'a', '#b', '#c'), '#d', '#e') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 'e', 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0)))) */
   /* search378_0_0 -> 29 in the cache */
   /* search378_0_1 -> 45 in the cache */
   /* search378_0_2 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 29, 45, 358 },
      -1,
   } },
   /* search378_1 -> 360 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 1268, 360, 1269 },
      -1,
   } },

   /* replace378_0_0 -> 32 in the cache */
   /* replace378_0_1_0_0 -> 48 in the cache */
   /* replace378_0_1_0_1 -> 32 in the cache */
   /* replace378_0_1_0 -> 1171 in the cache */
   /* replace378_0_1_1_0 -> 178 in the cache */
   /* replace378_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 178, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1171, 1271 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 3,
      { 32, 1272 },
      -1,
   } },
   /* replace378_1 -> 137 in the cache */
   /* replace378_2_0 -> 29 in the cache */
   /* replace378_2_1_0_0 -> 48 in the cache */
   /* replace378_2_1_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      4, 1,
      { 48, 32 },
      -1,
   } },
   /* replace378_2_1_1_0 -> 178 in the cache */
   /* replace378_2_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      5, 1,
      { 178, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      3, 3,
      { 1274, 1275 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace378_2_2_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      7, 1,
      { 1277, 32 },
      -1,
   } },
   /* replace378_2_2_1_0_0_0_0 -> 150 in the cache */
   /* replace378_2_2_1_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      10, 1,
      { 150, 32 },
      -1,
   } },
   /* replace378_2_2_1_0_0_1_0 -> 1174 in the cache */
   /* replace378_2_2_1_0_0_1_1_0 -> 48 in the cache */
   /* replace378_2_2_1_0_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      11, 1,
      { 48, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 1,
      { 1174, 1280 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      9, 3,
      { 1279, 1281 },
      -1,
   } },
   /* replace378_2_2_1_0_1_0 -> 178 in the cache */
   /* replace378_2_2_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      12, 1,
      { 178, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 4,
      { 1282, 1283 },
      -1,
   } },
   /* replace378_2_2_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imax,
      8, 5,
      { 1284, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      6, 7,
      { 1278, 1285 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 10,
      { 29, 1276, 1286 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 13,
      { 1273, 137, 1287 },
      -1,
   } },

   /* ('ushr@32', ('ubfe', 'a', '#b', '#c'), '#d(is_5lsb_not_zero)') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 31, 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0)))) */
   /* search379_0_0 -> 29 in the cache */
   /* search379_0_1 -> 45 in the cache */
   /* search379_0_2 -> 358 in the cache */
   /* search379_0 -> 1268 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1268, 1289 },
      -1,
   } },

   /* replace379_0_0 -> 32 in the cache */
   /* replace379_0_1_0_0 -> 48 in the cache */
   /* replace379_0_1_0_1 -> 32 in the cache */
   /* replace379_0_1_0 -> 1171 in the cache */
   /* replace379_0_1_1_0 -> 178 in the cache */
   /* replace379_0_1_1_1 -> 32 in the cache */
   /* replace379_0_1_1 -> 1271 in the cache */
   /* replace379_0_1 -> 1272 in the cache */
   /* replace379_0 -> 1273 in the cache */
   /* replace379_1 -> 137 in the cache */
   /* replace379_2_0 -> 29 in the cache */
   /* replace379_2_1_0_0 -> 48 in the cache */
   /* replace379_2_1_0_1 -> 32 in the cache */
   /* replace379_2_1_0 -> 1274 in the cache */
   /* replace379_2_1_1_0 -> 178 in the cache */
   /* replace379_2_1_1_1 -> 32 in the cache */
   /* replace379_2_1_1 -> 1275 in the cache */
   /* replace379_2_1 -> 1276 in the cache */
   /* replace379_2_2_0_0 -> 32 in the cache */
   /* replace379_2_2_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      -1, 0,
      { 32, 32 },
      -1,
   } },
   /* replace379_2_2_1_0_0_0_0 -> 150 in the cache */
   /* replace379_2_2_1_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      9, 1,
      { 150, 32 },
      -1,
   } },
   /* replace379_2_2_1_0_0_1_0 -> 1174 in the cache */
   /* replace379_2_2_1_0_0_1_1_0 -> 48 in the cache */
   /* replace379_2_2_1_0_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      10, 1,
      { 48, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 1,
      { 1174, 1293 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      8, 3,
      { 1292, 1294 },
      -1,
   } },
   /* replace379_2_2_1_0_1_0 -> 178 in the cache */
   /* replace379_2_2_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      11, 1,
      { 178, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 4,
      { 1295, 1296 },
      -1,
   } },
   /* replace379_2_2_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imax,
      7, 5,
      { 1297, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      6, 6,
      { 1291, 1298 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 9,
      { 29, 1276, 1299 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 12,
      { 1273, 137, 1300 },
      -1,
   } },

   /* ('iand', 'a(is_unsigned_multiple_of_4)', -4) => a */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xfffffffffffffffcull /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1302, 1303 },
      -1,
   } },

   /* replace380 -> 9 in the cache */

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b') */
   /* search381_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1305 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffeull /* 4294967294 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1306, 1307 },
      -1,
   } },

   /* replace381_0_0 -> 29 in the cache */
   /* replace381_0_1 -> 1307 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1307 },
      -1,
   } },
   /* replace381_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1309, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b') */
   /* search382_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1311 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffcull /* 4294967292 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1312, 1313 },
      -1,
   } },

   /* replace382_0_0 -> 29 in the cache */
   /* replace382_0_1 -> 1313 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1313 },
      -1,
   } },
   /* replace382_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1315, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b') */
   /* search383_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      20,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1317 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff8ull /* 4294967288 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1318, 1319 },
      -1,
   } },

   /* replace383_0_0 -> 29 in the cache */
   /* replace383_0_1 -> 1319 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1319 },
      -1,
   } },
   /* replace383_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1321, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b') */
   /* search384_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      21,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1323 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff0ull /* 4294967280 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1324, 1325 },
      -1,
   } },

   /* replace384_0_0 -> 29 in the cache */
   /* replace384_0_1 -> 1325 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1325 },
      -1,
   } },
   /* replace384_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1327, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b') */
   /* search385_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      22,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1329 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffe0ull /* 4294967264 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1330, 1331 },
      -1,
   } },

   /* replace385_0_0 -> 29 in the cache */
   /* replace385_0_1 -> 1331 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1331 },
      -1,
   } },
   /* replace385_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1333, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b') */
   /* search386_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      23,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1335 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffc0ull /* 4294967232 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1336, 1337 },
      -1,
   } },

   /* replace386_0_0 -> 29 in the cache */
   /* replace386_0_1 -> 1337 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1337 },
      -1,
   } },
   /* replace386_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1339, 48 },
      -1,
   } },

   /* ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1) */
   /* search387_0_0 -> 29 in the cache */
   /* search387_0_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 599 },
      -1,
   } },
   /* search387_1 -> 613 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1341, 613 },
      -1,
   } },

   /* replace387_0 -> 29 in the cache */
   /* replace387_1 -> 613 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 613 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1) */
   /* search388_0_0 -> 29 in the cache */
   /* search388_0_1 -> 613 in the cache */
   /* search388_0 -> 1343 in the cache */
   /* search388_1 -> 1307 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1343, 1307 },
      -1,
   } },

   /* replace388_0 -> 29 in the cache */
   /* replace388_1 -> 613 in the cache */
   /* replace388 -> 1343 in the cache */

   /* ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1) */
   /* search389_0_0 -> 29 in the cache */
   /* search389_0_1 -> 613 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 613 },
      -1,
   } },
   /* search389_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1345, 599 },
      -1,
   } },

   /* replace389_0 -> 29 in the cache */
   /* replace389_1 -> 613 in the cache */
   /* replace389 -> 1345 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2) */
   /* search390_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffffull /* 1073741823 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1347 },
      -1,
   } },
   /* search390_1 -> 618 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1348, 618 },
      -1,
   } },

   /* replace390_0 -> 29 in the cache */
   /* replace390_1 -> 618 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 618 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2) */
   /* search391_0_0 -> 29 in the cache */
   /* search391_0_1 -> 618 in the cache */
   /* search391_0 -> 1350 in the cache */
   /* search391_1 -> 1313 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1350, 1313 },
      -1,
   } },

   /* replace391_0 -> 29 in the cache */
   /* replace391_1 -> 618 in the cache */
   /* replace391 -> 1350 in the cache */

   /* ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2) */
   /* search392_0_0 -> 29 in the cache */
   /* search392_0_1 -> 618 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 618 },
      -1,
   } },
   /* search392_1 -> 1347 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1352, 1347 },
      -1,
   } },

   /* replace392_0 -> 29 in the cache */
   /* replace392_1 -> 618 in the cache */
   /* replace392 -> 1352 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16) */
   /* search393_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffull /* 65535 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1354 },
      -1,
   } },
   /* search393_1 -> 1153 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1355, 1153 },
      -1,
   } },

   /* replace393_0 -> 29 in the cache */
   /* replace393_1 -> 1153 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 1153 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16) */
   /* search394_0_0 -> 29 in the cache */
   /* search394_0_1 -> 1153 in the cache */
   /* search394_0 -> 1357 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff0000ull /* 4294901760 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1357, 1358 },
      -1,
   } },

   /* replace394_0 -> 29 in the cache */
   /* replace394_1 -> 1153 in the cache */
   /* replace394 -> 1357 in the cache */

   /* ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16) */
   /* search395_0_0 -> 29 in the cache */
   /* search395_0_1 -> 1153 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 1153 },
      -1,
   } },
   /* search395_1 -> 1354 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1360, 1354 },
      -1,
   } },

   /* replace395_0 -> 29 in the cache */
   /* replace395_1 -> 1153 in the cache */
   /* replace395 -> 1360 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24) */
   /* search396_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1362 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x18ull /* 24 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1363, 1364 },
      -1,
   } },

   /* replace396_0 -> 29 in the cache */
   /* replace396_1 -> 1364 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 1364 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24) */
   /* search397_0_0 -> 29 in the cache */
   /* search397_0_1 -> 1364 in the cache */
   /* search397_0 -> 1366 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff000000ull /* 4278190080 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1366, 1367 },
      -1,
   } },

   /* replace397_0 -> 29 in the cache */
   /* replace397_1 -> 1364 in the cache */
   /* replace397 -> 1366 in the cache */

   /* ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24) */
   /* search398_0_0 -> 29 in the cache */
   /* search398_0_1 -> 1364 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 1364 },
      -1,
   } },
   /* search398_1 -> 1362 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1369, 1362 },
      -1,
   } },

   /* replace398_0 -> 29 in the cache */
   /* replace398_1 -> 1364 in the cache */
   /* replace398 -> 1369 in the cache */

   /* ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c')) */
   /* search399_0_0 -> 0 in the cache */
   /* search399_0_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 1112 },
      -1,
   } },
   /* search399_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1371, 358 },
      -1,
   } },

   /* replace399_0_0 -> 0 in the cache */
   /* replace399_0_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 0, 150 },
      -1,
   } },
   /* replace399_1_0 -> 1 in the cache */
   /* replace399_1_1 -> 150 in the cache */
   /* replace399_1 -> 1115 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 1373, 1115 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search400_0_0_0 -> 141 in the cache */
   /* search400_0_0_1 -> 329 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 141, 329 },
      -1,
   } },
   /* search400_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1375, 144 },
      0,
   } },
   /* search400_1 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 2,
      { 1376, 360 },
      -1,
   } },

   /* replace400_0_0_0 -> 141 in the cache */
   /* replace400_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 141, 144 },
      -1,
   } },
   /* replace400_0_1 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1378, 178 },
      -1,
   } },
   /* replace400_1_0 -> 142 in the cache */
   /* replace400_1_1 -> 178 in the cache */
   /* replace400_1 -> 1108 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1379, 1108 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c')) */
   /* search401_0_0 -> 141 in the cache */
   /* search401_0_1 -> 329 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 141, 329 },
      0,
   } },
   /* search401_1 -> 1105 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 2,
      { 1381, 1105 },
      -1,
   } },

   /* replace401_0_0 -> 141 in the cache */
   /* replace401_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 1,
      { 141, 144 },
      -1,
   } },
   /* replace401_1_0 -> 142 in the cache */
   /* replace401_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      2, 1,
      { 142, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1383, 1384 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd')) */
   /* search402_0_0_0 -> 164 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 1,
      { 164, 1386 },
      0,
   } },
   /* search402_0_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 2,
      { 1387, 167 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 3,
      { 1388, 1389 },
      -1,
   } },

   /* replace402_0_0_0 -> 164 in the cache */
   /* replace402_0_0_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 1,
      { 164, 167 },
      -1,
   } },
   /* replace402_0_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 2,
      { 1391, 168 },
      -1,
   } },
   /* replace402_1_0 -> 165 in the cache */
   /* replace402_1_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 165, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 4,
      { 1392, 1393 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search403_0_0_0 -> 141 in the cache */
   /* search403_0_0_1 -> 329 in the cache */
   /* search403_0_0 -> 1381 in the cache */
   /* search403_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1381, 144 },
      0,
   } },
   /* search403_1 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 2,
      { 1395, 360 },
      -1,
   } },

   /* replace403_0_0_0 -> 141 in the cache */
   /* replace403_0_0_1 -> 144 in the cache */
   /* replace403_0_0 -> 1378 in the cache */
   /* replace403_0_1 -> 178 in the cache */
   /* replace403_0 -> 1379 in the cache */
   /* replace403_1_0 -> 142 in the cache */
   /* replace403_1_1 -> 178 in the cache */
   /* replace403_1 -> 1108 in the cache */
   /* replace403 -> 1380 in the cache */

   /* ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      24,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      24,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1397, 1398 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1399 },
      -1,
   } },

   /* replace404_0 -> 0 in the cache */
   /* replace404_1 -> 1 in the cache */
   /* replace404 -> 6 in the cache */

   /* ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b') */
   /* search405_0_0 -> 1397 in the cache */
   /* search405_0_1 -> 1398 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1397, 1398 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1401 },
      -1,
   } },

   /* replace405_0 -> 0 in the cache */
   /* replace405_1 -> 1 in the cache */
   /* replace405 -> 3 in the cache */

   /* ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b') */
   /* search406_0_0 -> 0 in the cache */
   /* search406_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 1403 },
      -1,
   } },

   /* replace406_0 -> 0 in the cache */
   /* replace406_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b') */
   /* search407_0_0 -> 0 in the cache */
   /* search407_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 1406 },
      -1,
   } },

   /* replace407_0 -> 0 in the cache */
   /* replace407_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b') */
   /* search408_0_0 -> 0 in the cache */
   /* search408_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1409 },
      -1,
   } },

   /* replace408_0 -> 0 in the cache */
   /* replace408_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b') */
   /* search409_0_0 -> 0 in the cache */
   /* search409_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1412 },
      -1,
   } },

   /* replace409_0 -> 0 in the cache */
   /* replace409_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b') */
   /* search410_0_0 -> 0 in the cache */
   /* search410_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1415 },
      -1,
   } },

   /* replace410_0 -> 0 in the cache */
   /* replace410_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b') */
   /* search411_0_0 -> 0 in the cache */
   /* search411_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1418 },
      -1,
   } },

   /* replace411_0 -> 0 in the cache */
   /* replace411_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b') */
   /* search412_0_0 -> 0 in the cache */
   /* search412_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 1421 },
      -1,
   } },

   /* replace412_0 -> 0 in the cache */
   /* replace412_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b') */
   /* search413_0_0 -> 0 in the cache */
   /* search413_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 1424 },
      -1,
   } },

   /* replace413_0 -> 0 in the cache */
   /* replace413_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False */
   /* search414_0_0 -> 0 in the cache */
   /* search414_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search414_1_0 -> 0 in the cache */
   /* search414_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 3,
      { 1427, 1428 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_FALSE /* False */ },
   } },

   /* ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False */
   /* search415_0_0 -> 0 in the cache */
   /* search415_0_1 -> 1 in the cache */
   /* search415_0 -> 3 in the cache */
   /* search415_1_0 -> 1 in the cache */
   /* search415_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 3, 1431 },
      -1,
   } },

   /* replace415 -> 1430 in the cache */

   /* ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False */
   /* search416_0_0 -> 0 in the cache */
   /* search416_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search416_1_0 -> 0 in the cache */
   /* search416_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 3,
      { 1433, 1434 },
      -1,
   } },

   /* replace416 -> 1430 in the cache */

   /* ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False */
   /* search417_0_0 -> 0 in the cache */
   /* search417_0_1 -> 1 in the cache */
   /* search417_0 -> 1417 in the cache */
   /* search417_1_0 -> 1 in the cache */
   /* search417_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1417, 1436 },
      -1,
   } },

   /* replace417 -> 1430 in the cache */

   /* ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False */
   /* search418_0_0 -> 0 in the cache */
   /* search418_0_1 -> 1 in the cache */
   /* search418_0 -> 1420 in the cache */
   /* search418_1_0 -> 1 in the cache */
   /* search418_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1420, 1438 },
      -1,
   } },

   /* replace418 -> 1430 in the cache */

   /* ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a') */
   /* search419_0_0 -> 0 in the cache */
   /* search419_0 -> 249 in the cache */
   /* search419_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 249, 1440 },
      -1,
   } },

   /* replace419_0 -> 1 in the cache */
   /* replace419_1 -> 0 in the cache */
   /* replace419 -> 1431 in the cache */

   /* ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a') */
   /* search420_0_0 -> 0 in the cache */
   /* search420_0 -> 249 in the cache */
   /* search420_1_0 -> 1 in the cache */
   /* search420_1 -> 1440 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 249, 1440 },
      -1,
   } },

   /* replace420_0 -> 1 in the cache */
   /* replace420_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1, 0 },
      -1,
   } },

   /* ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a') */
   /* search421_0_0 -> 0 in the cache */
   /* search421_0 -> 249 in the cache */
   /* search421_1_0 -> 1 in the cache */
   /* search421_1 -> 1440 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 249, 1440 },
      -1,
   } },

   /* replace421_0 -> 1 in the cache */
   /* replace421_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1, 0 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a') */
   /* search422_0_0 -> 0 in the cache */
   /* search422_0 -> 249 in the cache */
   /* search422_1_0 -> 1 in the cache */
   /* search422_1 -> 1440 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 249, 1440 },
      -1,
   } },

   /* replace422_0 -> 1 in the cache */
   /* replace422_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1, 0 },
      -1,
   } },

   /* ('flt', ('fneg', 'a(is_not_const)'), '#b') => ('flt', ('fneg', 'b'), 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1448 },
      -1,
   } },
   /* search423_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1449, 1112 },
      -1,
   } },

   /* replace423_0_0 -> 1 in the cache */
   /* replace423_0 -> 1440 in the cache */
   /* replace423_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1440, 0 },
      -1,
   } },

   /* ('flt', '#b', ('fneg', 'a(is_not_const)')) => ('flt', 'a', ('fneg', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1453 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1452, 1454 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1457 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1456, 1458 },
      -1,
   } },

   /* ('fge', ('fneg', 'a(is_not_const)'), '#b') => ('fge', ('fneg', 'b'), 'a') */
   /* search425_0_0 -> 1448 in the cache */
   /* search425_0 -> 1449 in the cache */
   /* search425_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1449, 1112 },
      -1,
   } },

   /* replace425_0_0 -> 1 in the cache */
   /* replace425_0 -> 1440 in the cache */
   /* replace425_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1440, 0 },
      -1,
   } },

   /* ('fge', '#b', ('fneg', 'a(is_not_const)')) => ('fge', 'a', ('fneg', 'b')) */
   /* search426_0 -> 1452 in the cache */
   /* search426_1_0 -> 1453 in the cache */
   /* search426_1 -> 1454 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1452, 1454 },
      -1,
   } },

   /* replace426_0 -> 1456 in the cache */
   /* replace426_1_0 -> 1457 in the cache */
   /* replace426_1 -> 1458 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1456, 1458 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a(is_not_const)'), '#b') => ('fneu', ('fneg', 'b'), 'a') */
   /* search427_0_0 -> 1448 in the cache */
   /* search427_0 -> 1449 in the cache */
   /* search427_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1449, 1112 },
      -1,
   } },

   /* replace427_0_0 -> 1 in the cache */
   /* replace427_0 -> 1440 in the cache */
   /* replace427_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1440, 0 },
      -1,
   } },

   /* ('feq', '#b', ('fneg', 'a(is_not_const)')) => ('feq', 'a', ('fneg', 'b')) */
   /* search428_0 -> 1452 in the cache */
   /* search428_1_0 -> 1453 in the cache */
   /* search428_1 -> 1454 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1452, 1454 },
      -1,
   } },

   /* replace428_0 -> 1456 in the cache */
   /* replace428_1_0 -> 1457 in the cache */
   /* replace428_1 -> 1458 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1456, 1458 },
      -1,
   } },

   /* ('flt', 'a', -0.0) => ('flt', 'a', 0.0) */
   /* search429_0 -> 9 in the cache */
   /* search429_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 9, 130 },
      -1,
   } },

   /* replace429_0 -> 9 in the cache */
   /* replace429_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 9, 8 },
      -1,
   } },

   /* ('flt', -0.0, 'a') => ('flt', 0.0, 'a') */
   /* search430_0 -> 130 in the cache */
   /* search430_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 130, 9 },
      -1,
   } },

   /* replace430_0 -> 8 in the cache */
   /* replace430_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 8, 9 },
      -1,
   } },

   /* ('fge', 'a', -0.0) => ('fge', 'a', 0.0) */
   /* search431_0 -> 9 in the cache */
   /* search431_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 9, 130 },
      -1,
   } },

   /* replace431_0 -> 9 in the cache */
   /* replace431_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 9, 8 },
      -1,
   } },

   /* ('fge', -0.0, 'a') => ('fge', 0.0, 'a') */
   /* search432_0 -> 130 in the cache */
   /* search432_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 130, 9 },
      -1,
   } },

   /* replace432_0 -> 8 in the cache */
   /* replace432_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 8, 9 },
      -1,
   } },

   /* ('fneu', 'a', -0.0) => ('fneu', 0.0, 'a') */
   /* search433_0 -> 9 in the cache */
   /* search433_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 9, 130 },
      -1,
   } },

   /* replace433_0 -> 8 in the cache */
   /* replace433_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 8, 9 },
      -1,
   } },

   /* ('feq', -0.0, 'a') => ('feq', 'a', 0.0) */
   /* search434_0 -> 130 in the cache */
   /* search434_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 130, 9 },
      -1,
   } },

   /* replace434_0 -> 9 in the cache */
   /* replace434_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('ieq', ('ineg', 'a(is_not_const)'), '#b') => ('ieq', 'a', ('ineg', 'b')) */
   /* search435_0_0 -> 1448 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 1448 },
      -1,
   } },
   /* search435_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1480, 1112 },
      -1,
   } },

   /* replace435_0 -> 0 in the cache */
   /* replace435_1_0 -> 1 in the cache */
   /* replace435_1 -> 105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 0, 105 },
      -1,
   } },

   /* ('ine', ('ineg', 'a(is_not_const)'), '#b') => ('ine', 'a', ('ineg', 'b')) */
   /* search436_0_0 -> 1448 in the cache */
   /* search436_0 -> 1480 in the cache */
   /* search436_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1480, 1112 },
      -1,
   } },

   /* replace436_0 -> 0 in the cache */
   /* replace436_1_0 -> 1 in the cache */
   /* replace436_1 -> 105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 0, 105 },
      -1,
   } },

   /* ('ieq', ('inot', 'a(is_not_const)'), '#b') => ('ieq', 'a', ('inot', 'b')) */
   /* search437_0_0 -> 1448 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1448 },
      -1,
   } },
   /* search437_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1485, 1112 },
      -1,
   } },

   /* replace437_0 -> 0 in the cache */
   /* replace437_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 0, 1487 },
      -1,
   } },

   /* ('ine', ('inot', 'a(is_not_const)'), '#b') => ('ine', 'a', ('inot', 'b')) */
   /* search438_0_0 -> 1448 in the cache */
   /* search438_0 -> 1485 in the cache */
   /* search438_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1485, 1112 },
      -1,
   } },

   /* replace438_0 -> 0 in the cache */
   /* replace438_1_0 -> 1 in the cache */
   /* replace438_1 -> 1487 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 0, 1487 },
      -1,
   } },

   /* ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0) */
   /* search439_0_0 -> 9 in the cache */
   /* search439_0 -> 126 in the cache */
   /* search439_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 126, 73 },
      -1,
   } },

   /* replace439_0 -> 9 in the cache */
   /* replace439_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0) */
   /* search440_0_0 -> 9 in the cache */
   /* search440_0 -> 126 in the cache */
   /* search440_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 126, 73 },
      -1,
   } },

   /* replace440_0 -> 9 in the cache */
   /* replace440_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* ('ieq', ('bit_count(is_used_once)', 'a'), 0) => ('ieq', 'a', 0) */
   /* search441_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bit_count,
      -1, 0,
      { 9 },
      0,
   } },
   /* search441_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 1495, 137 },
      -1,
   } },

   /* replace441_0 -> 9 in the cache */
   /* replace441_1 -> 73 in the cache */
   /* replace441 -> 1492 in the cache */

   /* ('ine', ('bit_count(is_used_once)', 'a'), 0) => ('ine', 'a', 0) */
   /* search442_0_0 -> 9 in the cache */
   /* search442_0 -> 1495 in the cache */
   /* search442_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 1495, 137 },
      -1,
   } },

   /* replace442_0 -> 9 in the cache */
   /* replace442_1 -> 73 in the cache */
   /* replace442 -> 1494 in the cache */

   /* ('ieq', ('ineg', 'a'), ('ineg', 'b')) => ('ieq', 'a', 'b') */
   /* search443_0_0 -> 0 in the cache */
   /* search443_0 -> 244 in the cache */
   /* search443_1_0 -> 1 in the cache */
   /* search443_1 -> 105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 244, 105 },
      -1,
   } },

   /* replace443_0 -> 0 in the cache */
   /* replace443_1 -> 1 in the cache */
   /* replace443 -> 1426 in the cache */

   /* ('ine', ('ineg', 'a'), ('ineg', 'b')) => ('ine', 'a', 'b') */
   /* search444_0_0 -> 0 in the cache */
   /* search444_0 -> 244 in the cache */
   /* search444_1_0 -> 1 in the cache */
   /* search444_1 -> 105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 244, 105 },
      -1,
   } },

   /* replace444_0 -> 0 in the cache */
   /* replace444_1 -> 1 in the cache */
   /* replace444 -> 1423 in the cache */

   /* ('ieq', ('inot', 'a'), ('inot', 'b')) => ('ieq', 'a', 'b') */
   /* search445_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search445_1_0 -> 1 in the cache */
   /* search445_1 -> 1487 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1500, 1487 },
      -1,
   } },

   /* replace445_0 -> 0 in the cache */
   /* replace445_1 -> 1 in the cache */
   /* replace445 -> 1426 in the cache */

   /* ('ine', ('inot', 'a'), ('inot', 'b')) => ('ine', 'a', 'b') */
   /* search446_0_0 -> 0 in the cache */
   /* search446_0 -> 1500 in the cache */
   /* search446_1_0 -> 1 in the cache */
   /* search446_1 -> 1487 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1500, 1487 },
      -1,
   } },

   /* replace446_0 -> 0 in the cache */
   /* replace446_1 -> 1 in the cache */
   /* replace446 -> 1423 in the cache */

   /* ('fneu', ('fabs', 'a'), 0.0) => ('fneu', 'a', 0.0) */
   /* search447_0_0 -> 9 in the cache */
   /* search447_0 -> 11 in the cache */
   /* search447_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace447_0 -> 9 in the cache */
   /* replace447_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('feq', ('fabs', 'a'), 0.0) => ('feq', 'a', 0.0) */
   /* search448_0_0 -> 9 in the cache */
   /* search448_0 -> 11 in the cache */
   /* search448_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace448_0 -> 9 in the cache */
   /* replace448_1 -> 8 in the cache */
   /* replace448 -> 1479 in the cache */

   /* ('fneu', ('fabs', 'a'), ('fabs', 'a')) => ('fneu', 'a', 'a') */
   /* search449_0_0 -> 9 in the cache */
   /* search449_0 -> 11 in the cache */
   /* search449_1_0 -> 9 in the cache */
   /* search449_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      -1, 0,
      { 11, 11 },
      -1,
   } },

   /* replace449_0 -> 9 in the cache */
   /* replace449_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* ('feq', ('fabs', 'a'), ('fabs', 'a')) => ('feq', 'a', 'a') */
   /* search450_0_0 -> 9 in the cache */
   /* search450_0 -> 11 in the cache */
   /* search450_1_0 -> 9 in the cache */
   /* search450_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      -1, 0,
      { 11, 11 },
      -1,
   } },

   /* replace450_0 -> 9 in the cache */
   /* replace450_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      25,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search451_1_0 -> 1456 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 1456 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1510, 1511 },
      -1,
   } },

   /* replace451_0 -> 1457 in the cache */
   /* replace451_1 -> 1456 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1457, 1456 },
      -1,
   } },

   /* ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b') */
   /* search452_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 0 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      25,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1514, 1515 },
      -1,
   } },

   /* replace452_0 -> 0 in the cache */
   /* replace452_1 -> 1 in the cache */
   /* replace452 -> 6 in the cache */

   /* ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b') */
   /* search453_0_0 -> 0 in the cache */
   /* search453_0 -> 1514 in the cache */
   /* search453_1 -> 1515 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1514, 1515 },
      -1,
   } },

   /* replace453_0 -> 0 in the cache */
   /* replace453_1 -> 1 in the cache */
   /* replace453 -> 1408 in the cache */

   /* ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b') */
   /* search454_0_0 -> 0 in the cache */
   /* search454_0 -> 1514 in the cache */
   /* search454_1 -> 1515 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1514, 1515 },
      -1,
   } },

   /* replace454_0 -> 0 in the cache */
   /* replace454_1 -> 1 in the cache */
   /* replace454 -> 1405 in the cache */

   /* ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0) */
   /* search455_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 9 },
      0,
   } },
   /* search455_1 -> 291 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 1519, 291 },
      -1,
   } },

   /* replace455_0 -> 9 in the cache */
   /* replace455_1 -> 291 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 9, 291 },
      -1,
   } },

   /* ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a') */
   /* search456_0 -> 8 in the cache */
   /* search456_1_0 -> 9 in the cache */
   /* search456_1 -> 1519 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 8, 1519 },
      -1,
   } },

   /* replace456_0 -> 8 in the cache */
   /* replace456_1 -> 9 in the cache */
   /* replace456 -> 1471 in the cache */

   /* ('bcsel(is_only_used_as_float)', ('feq', 'a', 'b(is_not_zero)'), 'b', 'a') => a */
   /* search457_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      26,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 0, 1523 },
      -1,
   } },
   /* search457_1 -> 1 in the cache */
   /* search457_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 1524, 1, 0 },
      1,
   } },

   /* replace457 -> 0 in the cache */

   /* ('bcsel(is_only_used_as_float)', ('fneu', 'a', 'b(is_not_zero)'), 'a', 'b') => a */
   /* search458_0_0 -> 0 in the cache */
   /* search458_0_1 -> 1523 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 0, 1523 },
      -1,
   } },
   /* search458_1 -> 0 in the cache */
   /* search458_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 1526, 0, 1 },
      1,
   } },

   /* replace458 -> 0 in the cache */

   /* ('bcsel', ('feq', 'a', 0, 'ignore_exact'), 0, ('fsat', ('fmul', 'a', 'b(is_a_number)'))) => ('!fsat', ('fmul', 'a', 'b')) */
   /* search459_0_0 -> 0 in the cache */
   /* search459_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 0, 98 },
      -1,
   } },
   /* search459_1 -> 98 in the cache */
   /* search459_2_0_0 -> 0 in the cache */
   /* search459_2_0_1 -> 1398 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 0, 1398 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 1529 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1528, 98, 1530 },
      -1,
   } },

   /* replace459_0_0 -> 0 in the cache */
   /* replace459_0_1 -> 1 in the cache */
   /* replace459_0 -> 310 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 310 },
      -1,
   } },

   /* ('bcsel', ('fneu', 'a', 0, 'ignore_exact'), ('fsat', ('fmul', 'a', 'b(is_a_number)')), 0) => ('!fsat', ('fmul', 'a', 'b')) */
   /* search460_0_0 -> 0 in the cache */
   /* search460_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 0, 98 },
      -1,
   } },
   /* search460_1_0_0 -> 0 in the cache */
   /* search460_1_0_1 -> 1398 in the cache */
   /* search460_1_0 -> 1529 in the cache */
   /* search460_1 -> 1530 in the cache */
   /* search460_2 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1533, 1530, 98 },
      -1,
   } },

   /* replace460_0_0 -> 0 in the cache */
   /* replace460_0_1 -> 1 in the cache */
   /* replace460_0 -> 310 in the cache */
   /* replace460 -> 1532 in the cache */

   /* ('bcsel', ('feq', 'a', 0, 'ignore_exact'), 'b', ('fadd', 'a', 'b(is_not_zero)')) => ('fadd', 'a', 'b') */
   /* search461_0_0 -> 0 in the cache */
   /* search461_0_1 -> 98 in the cache */
   /* search461_0 -> 1528 in the cache */
   /* search461_1 -> 1 in the cache */
   /* search461_2_0 -> 0 in the cache */
   /* search461_2_1 -> 1523 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 0, 1523 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1528, 1, 1535 },
      -1,
   } },

   /* replace461_0 -> 0 in the cache */
   /* replace461_1 -> 1 in the cache */
   /* replace461 -> 317 in the cache */

   /* ('bcsel', ('fneu', 'a', 0, 'ignore_exact'), ('fadd', 'a', 'b(is_not_zero)'), 'b') => ('fadd', 'a', 'b') */
   /* search462_0_0 -> 0 in the cache */
   /* search462_0_1 -> 98 in the cache */
   /* search462_0 -> 1533 in the cache */
   /* search462_1_0 -> 0 in the cache */
   /* search462_1_1 -> 1523 in the cache */
   /* search462_1 -> 1535 in the cache */
   /* search462_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1533, 1535, 1 },
      -1,
   } },

   /* replace462_0 -> 0 in the cache */
   /* replace462_1 -> 1 in the cache */
   /* replace462 -> 317 in the cache */

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search463_1_0 -> 1008 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1008 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1538, 1539 },
      -1,
   } },

   /* replace463_0 -> 1008 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1008 },
      -1,
   } },

   /* ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a') */
   /* search464_0_0_0 -> 1008 in the cache */
   /* search464_0_0 -> 1539 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1539 },
      -1,
   } },
   /* search464_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 1542, 1538 },
      -1,
   } },

   /* replace464_0 -> 1008 in the cache */
   /* replace464 -> 1541 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search465_0_0_0 -> 1008 in the cache */
   /* search465_0_0 -> 1539 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1544 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 1539, 1545 },
      -1,
   } },
   /* search465_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 2,
      { 1546, 1538 },
      -1,
   } },

   /* replace465_0 -> 1008 in the cache */
   /* replace465_1 -> 1544 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 1008, 1544 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search466_0_0 -> 1008 in the cache */
   /* search466_0 -> 1539 in the cache */
   /* search466_1_0_0 -> 1544 in the cache */
   /* search466_1_0 -> 1545 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1545 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1539, 1549 },
      -1,
   } },

   /* replace466_0 -> 1008 in the cache */
   /* replace466_1 -> 1544 in the cache */
   /* replace466 -> 1548 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b') */
   /* search467_0_0_0 -> 1008 in the cache */
   /* search467_0_0 -> 1539 in the cache */
   /* search467_0_1_0_0 -> 1544 in the cache */
   /* search467_0_1_0 -> 1545 in the cache */
   /* search467_0_1 -> 1549 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 1539, 1549 },
      -1,
   } },
   /* search467_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 2,
      { 1551, 1538 },
      -1,
   } },

   /* replace467_0 -> 1008 in the cache */
   /* replace467_1 -> 1544 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ixor,
      0, 1,
      { 1008, 1544 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b') */
   /* search468_0_0 -> 1008 in the cache */
   /* search468_0 -> 1539 in the cache */
   /* search468_1_0 -> 1544 in the cache */
   /* search468_1 -> 1545 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1539, 1545 },
      -1,
   } },

   /* replace468_0 -> 1008 in the cache */
   /* replace468_1 -> 1544 in the cache */
   /* replace468 -> 1553 in the cache */

   /* ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b') */
   /* search469_0_0_0 -> 1008 in the cache */
   /* search469_0_0 -> 1539 in the cache */
   /* search469_0 -> 1542 in the cache */
   /* search469_1_0_0 -> 1544 in the cache */
   /* search469_1_0 -> 1545 in the cache */
   /* search469_1 -> 1549 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1542, 1549 },
      -1,
   } },

   /* replace469_0 -> 1008 in the cache */
   /* replace469_1 -> 1544 in the cache */
   /* replace469 -> 1553 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search470_0_0_0 -> 1008 in the cache */
   /* search470_0_0 -> 1539 in the cache */
   /* search470_0_1_0 -> 1544 in the cache */
   /* search470_0_1 -> 1545 in the cache */
   /* search470_0 -> 1546 in the cache */
   /* search470_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 2,
      { 1546, 1538 },
      -1,
   } },

   /* replace470_0_0 -> 1008 in the cache */
   /* replace470_0_1 -> 1544 in the cache */
   /* replace470_0 -> 1548 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 1548 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search471_0_0 -> 1008 in the cache */
   /* search471_0 -> 1539 in the cache */
   /* search471_1_0_0 -> 1544 in the cache */
   /* search471_1_0 -> 1545 in the cache */
   /* search471_1 -> 1549 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1539, 1549 },
      -1,
   } },

   /* replace471_0_0 -> 1008 in the cache */
   /* replace471_0_1 -> 1544 in the cache */
   /* replace471_0 -> 1548 in the cache */
   /* replace471 -> 1557 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b') */
   /* search472_0_0_0 -> 1008 in the cache */
   /* search472_0_0 -> 1539 in the cache */
   /* search472_0_1_0_0 -> 1544 in the cache */
   /* search472_0_1_0 -> 1545 in the cache */
   /* search472_0_1 -> 1549 in the cache */
   /* search472_0 -> 1551 in the cache */
   /* search472_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 2,
      { 1551, 1538 },
      -1,
   } },

   /* replace472_0 -> 1008 in the cache */
   /* replace472_1 -> 1544 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1008, 1544 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b') */
   /* search473_0_0 -> 1008 in the cache */
   /* search473_0 -> 1539 in the cache */
   /* search473_1_0 -> 1544 in the cache */
   /* search473_1 -> 1545 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1539, 1545 },
      -1,
   } },

   /* replace473_0 -> 1008 in the cache */
   /* replace473_1 -> 1544 in the cache */
   /* replace473 -> 1560 in the cache */

   /* ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b') */
   /* search474_0_0_0 -> 1008 in the cache */
   /* search474_0_0 -> 1539 in the cache */
   /* search474_0 -> 1542 in the cache */
   /* search474_1_0_0 -> 1544 in the cache */
   /* search474_1_0 -> 1545 in the cache */
   /* search474_1 -> 1549 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1542, 1549 },
      -1,
   } },

   /* replace474_0 -> 1008 in the cache */
   /* replace474_1 -> 1544 in the cache */
   /* replace474 -> 1560 in the cache */

   /* ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b') */
   /* search475_0_0_0_0 -> 1008 in the cache */
   /* search475_0_0_0 -> 1539 in the cache */
   /* search475_0_0_1_0 -> 1544 in the cache */
   /* search475_0_0_1 -> 1545 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 1539, 1545 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1563 },
      -1,
   } },
   /* search475_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 1,
      { 1564, 1538 },
      -1,
   } },

   /* replace475_0 -> 1008 in the cache */
   /* replace475_1 -> 1544 in the cache */
   /* replace475 -> 1548 in the cache */

   /* ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search476_0 -> 1538 in the cache */
   /* search476_1_0_0 -> 1008 in the cache */
   /* search476_1_0 -> 1539 in the cache */
   /* search476_1_1_0 -> 1544 in the cache */
   /* search476_1_1 -> 1545 in the cache */
   /* search476_1 -> 1563 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 1538, 1563 },
      -1,
   } },

   /* replace476_0 -> 1008 in the cache */
   /* replace476_1 -> 1544 in the cache */
   /* replace476 -> 1548 in the cache */

   /* ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search477_0_0_0_0 -> 1008 in the cache */
   /* search477_0_0_0 -> 1539 in the cache */
   /* search477_0_0_1_0 -> 1544 in the cache */
   /* search477_0_0_1 -> 1545 in the cache */
   /* search477_0_0 -> 1563 in the cache */
   /* search477_0 -> 1564 in the cache */
   /* search477_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 1,
      { 1564, 1538 },
      -1,
   } },

   /* replace477_0_0 -> 1008 in the cache */
   /* replace477_0_1 -> 1544 in the cache */
   /* replace477_0 -> 1548 in the cache */
   /* replace477 -> 1557 in the cache */

   /* ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search478_0 -> 1538 in the cache */
   /* search478_1_0_0 -> 1008 in the cache */
   /* search478_1_0 -> 1539 in the cache */
   /* search478_1_1_0 -> 1544 in the cache */
   /* search478_1_1 -> 1545 in the cache */
   /* search478_1 -> 1563 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 1538, 1563 },
      -1,
   } },

   /* replace478_0_0 -> 1008 in the cache */
   /* replace478_0_1 -> 1544 in the cache */
   /* replace478_0 -> 1548 in the cache */
   /* replace478 -> 1557 in the cache */

   /* ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0) */
   /* search479_0 -> 9 in the cache */
   /* search479_1_0 -> 9 in the cache */
   /* search479_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 9, 118 },
      -1,
   } },

   /* replace479_0 -> 9 in the cache */
   /* replace479_1 -> 8 in the cache */
   /* replace479 -> 1469 in the cache */

   /* ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0) */
   /* search480_0 -> 9 in the cache */
   /* search480_1_0 -> 9 in the cache */
   /* search480_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 9, 118 },
      -1,
   } },

   /* replace480_0 -> 9 in the cache */
   /* replace480_1 -> 8 in the cache */
   /* replace480 -> 1473 in the cache */

   /* ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1572 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1574 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 1573, 1575 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1576 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 2,
      { 1571, 1577 },
      -1,
   } },
   /* search481_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 2,
      { 1578, 8 },
      -1,
   } },

   /* replace481_0_0 -> 1571 in the cache */
   /* replace481_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 1571, 8 },
      -1,
   } },
   /* replace481_1_0 -> 1572 in the cache */
   /* replace481_1_1 -> 1574 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      1, 1,
      { 1572, 1574 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 2,
      { 1580, 1581 },
      -1,
   } },

   /* ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0) */
   /* search482_0_0 -> 0 in the cache */
   /* search482_0_1 -> 1 in the cache */
   /* search482_0 -> 317 in the cache */
   /* search482_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 317, 0 },
      -1,
   } },

   /* replace482_0 -> 1 in the cache */
   /* replace482_1 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 1, 302 },
      -1,
   } },

   /* ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0) */
   /* search483_0_0 -> 0 in the cache */
   /* search483_0_1 -> 1 in the cache */
   /* search483_0 -> 317 in the cache */
   /* search483_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 317, 0 },
      -1,
   } },

   /* replace483_0 -> 1 in the cache */
   /* replace483_1 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 1, 302 },
      -1,
   } },

   /* ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0) */
   /* search484_0_0 -> 0 in the cache */
   /* search484_0_1 -> 1 in the cache */
   /* search484_0 -> 250 in the cache */
   /* search484_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 2,
      { 250, 0 },
      -1,
   } },

   /* replace484_0 -> 1 in the cache */
   /* replace484_1 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 1, 302 },
      -1,
   } },

   /* ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0) */
   /* search485_0_0 -> 0 in the cache */
   /* search485_0_1 -> 1 in the cache */
   /* search485_0 -> 250 in the cache */
   /* search485_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 2,
      { 250, 0 },
      -1,
   } },

   /* replace485_0 -> 1 in the cache */
   /* replace485_1 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 1, 302 },
      -1,
   } },

   /* ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search486_0_0 -> 141 in the cache */
   /* search486_0_1 -> 329 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 141, 329 },
      0,
   } },
   /* search486_1 -> 1105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 1591, 1105 },
      -1,
   } },

   /* replace486_0 -> 141 in the cache */
   /* replace486_1_0 -> 144 in the cache */
   /* replace486_1_1_0 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 144, 1593 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 141, 1594 },
      -1,
   } },

   /* ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search487_0_0_0 -> 141 in the cache */
   /* search487_0_0_1 -> 329 in the cache */
   /* search487_0_0 -> 1591 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1591 },
      0,
   } },
   /* search487_1 -> 1105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 1596, 1105 },
      -1,
   } },

   /* replace487_0_0_0 -> 144 in the cache */
   /* replace487_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 144, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1598 },
      -1,
   } },
   /* replace487_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 1599, 141 },
      -1,
   } },

   /* ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search488_0_0 -> 141 in the cache */
   /* search488_0_1 -> 329 in the cache */
   /* search488_0 -> 1591 in the cache */
   /* search488_1 -> 1105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 1591, 1105 },
      -1,
   } },

   /* replace488_0 -> 141 in the cache */
   /* replace488_1_0 -> 144 in the cache */
   /* replace488_1_1_0 -> 142 in the cache */
   /* replace488_1_1 -> 1593 in the cache */
   /* replace488_1 -> 1594 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 141, 1594 },
      -1,
   } },

   /* ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search489_0_0_0 -> 141 in the cache */
   /* search489_0_0_1 -> 329 in the cache */
   /* search489_0_0 -> 1591 in the cache */
   /* search489_0 -> 1596 in the cache */
   /* search489_1 -> 1105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 1596, 1105 },
      -1,
   } },

   /* replace489_0_0_0 -> 144 in the cache */
   /* replace489_0_0_1 -> 142 in the cache */
   /* replace489_0_0 -> 1598 in the cache */
   /* replace489_0 -> 1599 in the cache */
   /* replace489_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 1599, 141 },
      -1,
   } },

   /* ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search490_0_0 -> 141 in the cache */
   /* search490_0_1 -> 329 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 141, 329 },
      0,
   } },
   /* search490_1 -> 1105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 2,
      { 1605, 1105 },
      -1,
   } },

   /* replace490_0 -> 141 in the cache */
   /* replace490_1_0 -> 144 in the cache */
   /* replace490_1_1_0 -> 142 in the cache */
   /* replace490_1_1 -> 1593 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 144, 1593 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 2,
      { 141, 1607 },
      -1,
   } },

   /* ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search491_0_0_0 -> 141 in the cache */
   /* search491_0_0_1 -> 329 in the cache */
   /* search491_0_0 -> 1605 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1605 },
      0,
   } },
   /* search491_1 -> 1105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 2,
      { 1609, 1105 },
      -1,
   } },

   /* replace491_0_0_0 -> 144 in the cache */
   /* replace491_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 144, 142 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1611 },
      -1,
   } },
   /* replace491_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 2,
      { 1612, 141 },
      -1,
   } },

   /* ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search492_0_0 -> 141 in the cache */
   /* search492_0_1 -> 329 in the cache */
   /* search492_0 -> 1605 in the cache */
   /* search492_1 -> 1105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 2,
      { 1605, 1105 },
      -1,
   } },

   /* replace492_0 -> 141 in the cache */
   /* replace492_1_0 -> 144 in the cache */
   /* replace492_1_1_0 -> 142 in the cache */
   /* replace492_1_1 -> 1593 in the cache */
   /* replace492_1 -> 1607 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 2,
      { 141, 1607 },
      -1,
   } },

   /* ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search493_0_0_0 -> 141 in the cache */
   /* search493_0_0_1 -> 329 in the cache */
   /* search493_0_0 -> 1605 in the cache */
   /* search493_0 -> 1609 in the cache */
   /* search493_1 -> 1105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 2,
      { 1609, 1105 },
      -1,
   } },

   /* replace493_0_0_0 -> 144 in the cache */
   /* replace493_0_0_1 -> 142 in the cache */
   /* replace493_0_0 -> 1611 in the cache */
   /* replace493_0 -> 1612 in the cache */
   /* replace493_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 2,
      { 1612, 141 },
      -1,
   } },

   /* ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0) */
   /* search494_0_0 -> 0 in the cache */
   /* search494_0_1 -> 1 in the cache */
   /* search494_0 -> 245 in the cache */
   /* search494_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 2,
      { 245, 0 },
      -1,
   } },

   /* replace494_0 -> 1 in the cache */
   /* replace494_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 1, 98 },
      -1,
   } },

   /* ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0) */
   /* search495_0_0 -> 0 in the cache */
   /* search495_0_1 -> 1 in the cache */
   /* search495_0 -> 245 in the cache */
   /* search495_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 2,
      { 245, 0 },
      -1,
   } },

   /* replace495_0 -> 1 in the cache */
   /* replace495_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 1, 98 },
      -1,
   } },

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   /* search496_0 -> 1538 in the cache */
   /* search496_1_0 -> 1008 in the cache */
   /* search496_1 -> 1539 in the cache */
   /* search496 -> 1540 in the cache */

   /* replace496_0 -> 1008 in the cache */
   /* replace496 -> 1541 in the cache */

   /* ('flt', 0.0, ('b2f', 'a@1')) => a */
   /* search497_0 -> 1538 in the cache */
   /* search497_1_0 -> 1008 in the cache */
   /* search497_1 -> 1539 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1538, 1539 },
      -1,
   } },

   /* replace497 -> 1008 in the cache */

   /* ('ieq', 'a@1', False) => ('inot', 'a') */
   /* search498_0 -> 1008 in the cache */
   /* search498_1 -> 1430 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 1008, 1430 },
      -1,
   } },

   /* replace498_0 -> 1008 in the cache */
   /* replace498 -> 1541 in the cache */

   /* ('ieq', 'a@1', True) => a */
   /* search499_0 -> 1008 in the cache */
   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_TRUE /* True */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 1008, 1624 },
      -1,
   } },

   /* replace499 -> 1008 in the cache */

   /* ('ine', 'a@1', False) => a */
   /* search500_0 -> 1008 in the cache */
   /* search500_1 -> 1430 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 1008, 1430 },
      -1,
   } },

   /* replace500 -> 1008 in the cache */

   /* ('ine', 'a@1', True) => ('inot', 'a') */
   /* search501_0 -> 1008 in the cache */
   /* search501_1 -> 1624 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 1008, 1624 },
      -1,
   } },

   /* replace501_0 -> 1008 in the cache */
   /* replace501 -> 1541 in the cache */

   /* ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search502_0_0 -> 9 in the cache */
   /* search502_0 -> 124 in the cache */
   /* search502_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 124, 1538 },
      -1,
   } },

   /* replace502_0 -> 9 in the cache */
   /* replace502_1 -> 73 in the cache */
   /* replace502 -> 1494 in the cache */

   /* ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search503_0_0 -> 9 in the cache */
   /* search503_0 -> 124 in the cache */
   /* search503_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 124, 1538 },
      -1,
   } },

   /* replace503_0 -> 9 in the cache */
   /* replace503_1 -> 73 in the cache */
   /* replace503 -> 1492 in the cache */

   /* ('fge', ('u2f', 'a'), 0.0) => True */
   /* search504_0_0 -> 9 in the cache */
   /* search504_0 -> 124 in the cache */
   /* search504_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 124, 1538 },
      -1,
   } },

   /* replace504 -> 1624 in the cache */

   /* ('fge', 0.0, ('u2f', 'a')) => ('ieq', 0, 'a') */
   /* search505_0 -> 1538 in the cache */
   /* search505_1_0 -> 9 in the cache */
   /* search505_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1538, 124 },
      -1,
   } },

   /* replace505_0 -> 73 in the cache */
   /* replace505_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 73, 9 },
      -1,
   } },

   /* ('flt', ('u2f', 'a'), 0.0) => False */
   /* search506_0_0 -> 9 in the cache */
   /* search506_0 -> 124 in the cache */
   /* search506_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 124, 1538 },
      -1,
   } },

   /* replace506 -> 1430 in the cache */

   /* ('flt', 0.0, ('u2f', 'a')) => ('ine', 0, 'a') */
   /* search507_0 -> 1538 in the cache */
   /* search507_1_0 -> 9 in the cache */
   /* search507_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1538, 124 },
      -1,
   } },

   /* replace507_0 -> 73 in the cache */
   /* replace507_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 73, 9 },
      -1,
   } },

   /* ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search508_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_i2f,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search508_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 1636, 1538 },
      -1,
   } },

   /* replace508_0 -> 9 in the cache */
   /* replace508_1 -> 73 in the cache */
   /* replace508 -> 1494 in the cache */

   /* ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search509_0_0 -> 9 in the cache */
   /* search509_0 -> 1636 in the cache */
   /* search509_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 1636, 1538 },
      -1,
   } },

   /* replace509_0 -> 9 in the cache */
   /* replace509_1 -> 73 in the cache */
   /* replace509 -> 1492 in the cache */

   /* ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0) */
   /* search510_0_0 -> 9 in the cache */
   /* search510_0 -> 1636 in the cache */
   /* search510_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 1636, 1538 },
      -1,
   } },

   /* replace510_0 -> 9 in the cache */
   /* replace510_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ige,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a') */
   /* search511_0 -> 1538 in the cache */
   /* search511_1_0 -> 9 in the cache */
   /* search511_1 -> 1636 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1538, 1636 },
      -1,
   } },

   /* replace511_0 -> 73 in the cache */
   /* replace511_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0) */
   /* search512_0_0 -> 9 in the cache */
   /* search512_0 -> 1636 in the cache */
   /* search512_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 1636, 1538 },
      -1,
   } },

   /* replace512_0 -> 9 in the cache */
   /* replace512_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ilt,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a') */
   /* search513_0 -> 1538 in the cache */
   /* search513_1_0 -> 9 in the cache */
   /* search513_1 -> 1636 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1538, 1636 },
      -1,
   } },

   /* replace513_0 -> 73 in the cache */
   /* replace513_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0) */
   /* search514_0 -> 8 in the cache */
   /* search514_1_0 -> 9 in the cache */
   /* search514_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* replace514_0 -> 9 in the cache */
   /* replace514_1 -> 8 in the cache */
   /* replace514 -> 1504 in the cache */

   /* ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0) */
   /* search515_0_0_0 -> 9 in the cache */
   /* search515_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 11 },
      -1,
   } },
   /* search515_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 1648, 8 },
      -1,
   } },

   /* replace515_0 -> 9 in the cache */
   /* replace515_1 -> 8 in the cache */
   /* replace515 -> 1504 in the cache */

   /* ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0) */
   /* search516_0 -> 8 in the cache */
   /* search516_1_0 -> 9 in the cache */
   /* search516_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* replace516_0 -> 9 in the cache */
   /* replace516_1 -> 8 in the cache */
   /* replace516 -> 1479 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search517_0_0_0 -> 9 in the cache */
   /* search517_0_0 -> 11 in the cache */
   /* search517_0 -> 1648 in the cache */
   /* search517_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 1648, 8 },
      -1,
   } },

   /* replace517_0 -> 9 in the cache */
   /* replace517_1 -> 8 in the cache */
   /* replace517 -> 1479 in the cache */

   /* ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a')) */
   /* search518_0_0 -> 9 in the cache */
   /* search518_0_1 -> 8 in the cache */
   /* search518_0 -> 1473 in the cache */
   /* search518_1_0 -> 291 in the cache */
   /* search518_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 291, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1473, 1652 },
      -1,
   } },

   /* replace518_0 -> 9 in the cache */
   /* replace518_1_0 -> 9 in the cache */
   /* replace518_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 9, 255 },
      -1,
   } },

   /* ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b')) */
   /* search519_0_0 -> 1008 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1008 },
      0,
   } },
   /* search519_1_0 -> 1544 in the cache */
   /* search519_1 -> 1545 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 1655, 1545 },
      -1,
   } },

   /* replace519_0_0 -> 1008 in the cache */
   /* replace519_0_1 -> 1544 in the cache */
   /* replace519_0 -> 1548 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 1,
      { 1548 },
      -1,
   } },

   /* ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b'))) */
   /* search520_0_0_0 -> 1008 in the cache */
   /* search520_0_0 -> 1655 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1655 },
      0,
   } },
   /* search520_1_0_0 -> 1544 in the cache */
   /* search520_1_0 -> 1545 in the cache */
   /* search520_1 -> 1549 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 1658, 1549 },
      -1,
   } },

   /* replace520_0_0_0 -> 1008 in the cache */
   /* replace520_0_0_1 -> 1544 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1008, 1544 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 1,
      { 1660 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1661 },
      -1,
   } },

   /* ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search521_0_0 -> 1008 in the cache */
   /* search521_0 -> 1655 in the cache */
   /* search521_1_0 -> 1544 in the cache */
   /* search521_1 -> 1545 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1655, 1545 },
      -1,
   } },

   /* replace521_0_0 -> 1008 in the cache */
   /* replace521_0_1 -> 1544 in the cache */
   /* replace521_0 -> 1660 in the cache */
   /* replace521 -> 1661 in the cache */

   /* ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b'))) */
   /* search522_0_0_0 -> 1008 in the cache */
   /* search522_0_0 -> 1655 in the cache */
   /* search522_0 -> 1658 in the cache */
   /* search522_1_0_0 -> 1544 in the cache */
   /* search522_1_0 -> 1545 in the cache */
   /* search522_1 -> 1549 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1658, 1549 },
      -1,
   } },

   /* replace522_0_0_0 -> 1008 in the cache */
   /* replace522_0_0_1 -> 1544 in the cache */
   /* replace522_0_0 -> 1548 in the cache */
   /* replace522_0 -> 1657 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1657 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f', 'b@1'), 0) => ('b2f', ('bcsel', 'a', 'b', False)) */
   /* search523_0 -> 1008 in the cache */
   /* search523_1_0 -> 1544 in the cache */
   /* search523_1 -> 1545 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1545, 1666 },
      -1,
   } },

   /* replace523_0_0 -> 1008 in the cache */
   /* replace523_0_1 -> 1544 in the cache */
   /* replace523_0_2 -> 1430 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1544, 1430 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1668 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f', 'b@1'), 1.0) => ('b2f', ('bcsel', 'a', 'b', True)) */
   /* search524_0 -> 1008 in the cache */
   /* search524_1_0 -> 1544 in the cache */
   /* search524_1 -> 1545 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1545, 1670 },
      -1,
   } },

   /* replace524_0_0 -> 1008 in the cache */
   /* replace524_0_1 -> 1544 in the cache */
   /* replace524_0_2 -> 1624 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1544, 1624 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1672 },
      -1,
   } },

   /* ('bcsel', 'a', 0, ('b2f', 'b@1')) => ('b2f', ('bcsel', 'a', False, 'b')) */
   /* search525_0 -> 1008 in the cache */
   /* search525_1 -> 1666 in the cache */
   /* search525_2_0 -> 1544 in the cache */
   /* search525_2 -> 1545 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1666, 1545 },
      -1,
   } },

   /* replace525_0_0 -> 1008 in the cache */
   /* replace525_0_1 -> 1430 in the cache */
   /* replace525_0_2 -> 1544 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1430, 1544 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1675 },
      -1,
   } },

   /* ('bcsel', 'a', 1.0, ('b2f', 'b@1')) => ('b2f', ('bcsel', 'a', True, 'b')) */
   /* search526_0 -> 1008 in the cache */
   /* search526_1 -> 1670 in the cache */
   /* search526_2_0 -> 1544 in the cache */
   /* search526_2 -> 1545 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1670, 1545 },
      -1,
   } },

   /* replace526_0_0 -> 1008 in the cache */
   /* replace526_0_1 -> 1624 in the cache */
   /* replace526_0_2 -> 1544 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1624, 1544 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1678 },
      -1,
   } },

   /* ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0)) */
   /* search527_0_0 -> 1008 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1008 },
      -1,
   } },
   /* search527_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1680, 1112 },
      -1,
   } },

   /* replace527_0 -> 1008 in the cache */
   /* replace527_1_0 -> 1 in the cache */
   /* replace527_1_1 -> 315 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmin,
      0, 1,
      { 1, 315 },
      -1,
   } },
   /* replace527_2_0 -> 1 in the cache */
   /* replace527_2_1 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmin,
      1, 1,
      { 1, 302 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1008, 1682, 1683 },
      -1,
   } },

   /* ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b') */
   /* search528_0_0 -> 0 in the cache */
   /* search528_0_1_0 -> 1 in the cache */
   /* search528_0_1 -> 1440 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 0, 1440 },
      0,
   } },
   /* search528_1 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 1,
      { 1685, 302 },
      -1,
   } },

   /* replace528_0 -> 0 in the cache */
   /* replace528_1 -> 1 in the cache */
   /* replace528 -> 3 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search529_0_0_0 -> 9 in the cache */
   /* search529_0_0 -> 11 in the cache */
   /* search529_0 -> 1648 in the cache */
   /* search529_1 -> 8 in the cache */
   /* search529 -> 1651 in the cache */

   /* replace529_0 -> 9 in the cache */
   /* replace529_1 -> 8 in the cache */
   /* replace529 -> 1479 in the cache */

   /* ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search530_0_0 -> 1457 in the cache */
   /* search530_0_1 -> 1456 in the cache */
   /* search530_0 -> 1513 in the cache */
   /* search530_1 -> 1457 in the cache */
   /* search530_2 -> 1456 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1513, 1457, 1456 },
      -1,
   } },

   /* replace530_0 -> 1456 in the cache */
   /* replace530_1 -> 1457 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1456, 1457 },
      -1,
   } },

   /* ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search531_0_0 -> 0 in the cache */
   /* search531_0_1 -> 1 in the cache */
   /* search531_0 -> 3 in the cache */
   /* search531_1 -> 1 in the cache */
   /* search531_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 3, 1, 0 },
      -1,
   } },

   /* replace531_0 -> 0 in the cache */
   /* replace531_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search532_0_0 -> 0 in the cache */
   /* search532_0_1 -> 1 in the cache */
   /* search532_0 -> 6 in the cache */
   /* search532_1 -> 1 in the cache */
   /* search532_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 6, 1, 0 },
      -1,
   } },

   /* replace532_0 -> 0 in the cache */
   /* replace532_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search533_0_0 -> 1457 in the cache */
   /* search533_0_1 -> 1456 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1457, 1456 },
      -1,
   } },
   /* search533_1 -> 1457 in the cache */
   /* search533_2 -> 1456 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1693, 1457, 1456 },
      -1,
   } },

   /* replace533_0 -> 1456 in the cache */
   /* replace533_1 -> 1457 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 1456, 1457 },
      -1,
   } },

   /* ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b') */
   /* search534_0_0 -> 1008 in the cache */
   /* search534_0 -> 1541 in the cache */
   /* search534_1 -> 142 in the cache */
   /* search534_2 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1541, 142, 144 },
      -1,
   } },

   /* replace534_0 -> 1008 in the cache */
   /* replace534_1 -> 144 in the cache */
   /* replace534_2 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 144, 142 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd') */
   /* search535_0 -> 1008 in the cache */
   /* search535_1_0 -> 1008 in the cache */
   /* search535_1_1 -> 165 in the cache */
   /* search535_1_2 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 165, 167 },
      -1,
   } },
   /* search535_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1698, 168 },
      -1,
   } },

   /* replace535_0 -> 1008 in the cache */
   /* replace535_1 -> 165 in the cache */
   /* replace535_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 165, 168 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd') */
   /* search536_0 -> 1008 in the cache */
   /* search536_1 -> 165 in the cache */
   /* search536_2_0 -> 1008 in the cache */
   /* search536_2_1 -> 167 in the cache */
   /* search536_2_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 167, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 165, 1701 },
      -1,
   } },

   /* replace536_0 -> 1008 in the cache */
   /* replace536_1 -> 165 in the cache */
   /* replace536_2 -> 168 in the cache */
   /* replace536 -> 1700 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search537_0 -> 1008 in the cache */
   /* search537_1_0 -> 1544 in the cache */
   /* search537_1_1 -> 1010 in the cache */
   /* search537_1_2 -> 1018 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1544, 1010, 1018 },
      -1,
   } },
   /* search537_2_0 -> 1544 in the cache */
   /* search537_2_1 -> 1010 in the cache */
   /* search537_2_2 -> 1020 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1544, 1010, 1020 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1703, 1704 },
      -1,
   } },

   /* replace537_0 -> 1544 in the cache */
   /* replace537_1 -> 1010 in the cache */
   /* replace537_2_0 -> 1008 in the cache */
   /* replace537_2_1 -> 1018 in the cache */
   /* replace537_2_2 -> 1020 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1018, 1020 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1544, 1010, 1706 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search538_0 -> 1008 in the cache */
   /* search538_1_0 -> 1544 in the cache */
   /* search538_1_1 -> 1010 in the cache */
   /* search538_1_2 -> 1018 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1544, 1010, 1018 },
      0,
   } },
   /* search538_2_0 -> 1544 in the cache */
   /* search538_2_1 -> 1010 in the cache */
   /* search538_2_2 -> 1020 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1544, 1010, 1020 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1708, 1709 },
      -1,
   } },

   /* replace538_0 -> 1544 in the cache */
   /* replace538_1 -> 1010 in the cache */
   /* replace538_2_0 -> 1008 in the cache */
   /* replace538_2_1 -> 1018 in the cache */
   /* replace538_2_2 -> 1020 in the cache */
   /* replace538_2 -> 1706 in the cache */
   /* replace538 -> 1707 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search539_0 -> 1008 in the cache */
   /* search539_1_0 -> 1544 in the cache */
   /* search539_1_1 -> 167 in the cache */
   /* search539_1_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1544, 167, 168 },
      -1,
   } },
   /* search539_2_0 -> 1544 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search539_2_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1544, 1712, 168 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1711, 1713 },
      -1,
   } },

   /* replace539_0 -> 1544 in the cache */
   /* replace539_1_0 -> 1008 in the cache */
   /* replace539_1_1 -> 167 in the cache */
   /* replace539_1_2 -> 1712 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 167, 1712 },
      -1,
   } },
   /* replace539_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1544, 1715, 168 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search540_0 -> 1008 in the cache */
   /* search540_1_0 -> 1544 in the cache */
   /* search540_1_1 -> 167 in the cache */
   /* search540_1_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1544, 167, 168 },
      0,
   } },
   /* search540_2_0 -> 1544 in the cache */
   /* search540_2_1 -> 1712 in the cache */
   /* search540_2_2 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1544, 1712, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1717, 1718 },
      -1,
   } },

   /* replace540_0 -> 1544 in the cache */
   /* replace540_1_0 -> 1008 in the cache */
   /* replace540_1_1 -> 167 in the cache */
   /* replace540_1_2 -> 1712 in the cache */
   /* replace540_1 -> 1715 in the cache */
   /* replace540_2 -> 168 in the cache */
   /* replace540 -> 1716 in the cache */

   /* ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b') */
   /* search541_0 -> 1008 in the cache */
   /* search541_1 -> 1624 in the cache */
   /* search541_2 -> 1544 in the cache */
   /* search541 -> 1678 in the cache */

   /* replace541_0 -> 1008 in the cache */
   /* replace541_1 -> 1544 in the cache */
   /* replace541 -> 1548 in the cache */

   /* ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b') */
   /* search542_0 -> 1008 in the cache */
   /* search542_1 -> 1008 in the cache */
   /* search542_2 -> 1544 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1008, 1544 },
      -1,
   } },

   /* replace542_0 -> 1008 in the cache */
   /* replace542_1 -> 1544 in the cache */
   /* replace542 -> 1548 in the cache */

   /* ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b') */
   /* search543_0 -> 1008 in the cache */
   /* search543_1 -> 1544 in the cache */
   /* search543_2 -> 1430 in the cache */
   /* search543 -> 1668 in the cache */

   /* replace543_0 -> 1008 in the cache */
   /* replace543_1 -> 1544 in the cache */
   /* replace543 -> 1660 in the cache */

   /* ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b') */
   /* search544_0 -> 1008 in the cache */
   /* search544_1 -> 1544 in the cache */
   /* search544_2 -> 1008 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1544, 1008 },
      -1,
   } },

   /* replace544_0 -> 1008 in the cache */
   /* replace544_1 -> 1544 in the cache */
   /* replace544 -> 1660 in the cache */

   /* ('bcsel', 'a', 'b', True) => ('ior', ('inot', 'a'), 'b') */
   /* search545_0 -> 1008 in the cache */
   /* search545_1 -> 1544 in the cache */
   /* search545_2 -> 1624 in the cache */
   /* search545 -> 1672 in the cache */

   /* replace545_0_0 -> 1008 in the cache */
   /* replace545_0 -> 1541 in the cache */
   /* replace545_1 -> 1544 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 1541, 1544 },
      -1,
   } },

   /* ('bcsel', 'a', False, 'b') => ('iand', ('inot', 'a'), 'b') */
   /* search546_0 -> 1008 in the cache */
   /* search546_1 -> 1430 in the cache */
   /* search546_2 -> 1544 in the cache */
   /* search546 -> 1675 in the cache */

   /* replace546_0_0 -> 1008 in the cache */
   /* replace546_0 -> 1541 in the cache */
   /* replace546_1 -> 1544 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1541, 1544 },
      -1,
   } },

   /* ('fmin', 'a', 'a') => ('fcanonicalize', 'a') */
   /* search547_0 -> 9 in the cache */
   /* search547_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace547_0 -> 9 in the cache */
   /* replace547 -> 120 in the cache */

   /* ('fmax', 'a', 'a') => ('fcanonicalize', 'a') */
   /* search548_0 -> 9 in the cache */
   /* search548_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace548_0 -> 9 in the cache */
   /* replace548 -> 120 in the cache */

   /* ('imin', 'a', 'a') => a */
   /* search549_0 -> 9 in the cache */
   /* search549_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace549 -> 9 in the cache */

   /* ('imax', 'a', 'a') => a */
   /* search550_0 -> 9 in the cache */
   /* search550_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace550 -> 9 in the cache */

   /* ('umin', 'a', 'a') => a */
   /* search551_0 -> 9 in the cache */
   /* search551_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace551 -> 9 in the cache */

   /* ('umin', 'a', 0) => 0 */
   /* search552_0 -> 9 in the cache */
   /* search552_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umin,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace552 -> 73 in the cache */

   /* ('umin', 'a', -1) => a */
   /* search553_0 -> 9 in the cache */
   /* search553_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umin,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace553 -> 9 in the cache */

   /* ('umax', 'a', 'a') => a */
   /* search554_0 -> 9 in the cache */
   /* search554_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace554 -> 9 in the cache */

   /* ('umax', 'a', 0) => a */
   /* search555_0 -> 9 in the cache */
   /* search555_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umax,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace555 -> 9 in the cache */

   /* ('umax', 'a', -1) => -1 */
   /* search556_0 -> 9 in the cache */
   /* search556_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umax,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace556 -> 75 in the cache */

   /* ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b') */
   /* search557_0_0 -> 0 in the cache */
   /* search557_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search557_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 2,
      { 1734, 1 },
      -1,
   } },

   /* replace557_0 -> 0 in the cache */
   /* replace557_1 -> 1 in the cache */
   /* replace557 -> 1690 in the cache */

   /* ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b') */
   /* search558_0_0 -> 0 in the cache */
   /* search558_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search558_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      0, 2,
      { 1736, 1 },
      -1,
   } },

   /* replace558_0 -> 0 in the cache */
   /* replace558_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b') */
   /* search559_0_0 -> 0 in the cache */
   /* search559_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search559_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      0, 2,
      { 1739, 1 },
      -1,
   } },

   /* replace559_0 -> 0 in the cache */
   /* replace559_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b') */
   /* search560_0_0 -> 0 in the cache */
   /* search560_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search560_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 2,
      { 1742, 1 },
      -1,
   } },

   /* replace560_0 -> 0 in the cache */
   /* replace560_1 -> 1 in the cache */
   /* replace560 -> 1692 in the cache */

   /* ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b') */
   /* search561_0_0 -> 0 in the cache */
   /* search561_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search561_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      0, 2,
      { 1744, 1 },
      -1,
   } },

   /* replace561_0 -> 0 in the cache */
   /* replace561_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b') */
   /* search562_0_0 -> 0 in the cache */
   /* search562_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search562_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      0, 2,
      { 1747, 1 },
      -1,
   } },

   /* replace562_0 -> 0 in the cache */
   /* replace562_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c') */
   /* search563_0_0_0 -> 141 in the cache */
   /* search563_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      2, 1,
      { 141, 142 },
      -1,
   } },
   /* search563_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      1, 2,
      { 1750, 144 },
      -1,
   } },
   /* search563_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 3,
      { 1751, 141 },
      -1,
   } },

   /* replace563_0_0 -> 141 in the cache */
   /* replace563_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      1, 1,
      { 141, 142 },
      -1,
   } },
   /* replace563_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 2,
      { 1753, 144 },
      -1,
   } },

   /* ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c') */
   /* search564_0_0_0 -> 141 in the cache */
   /* search564_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      2, 1,
      { 141, 142 },
      -1,
   } },
   /* search564_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      1, 2,
      { 1755, 144 },
      -1,
   } },
   /* search564_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      0, 3,
      { 1756, 141 },
      -1,
   } },

   /* replace564_0_0 -> 141 in the cache */
   /* replace564_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      1, 1,
      { 141, 142 },
      -1,
   } },
   /* replace564_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      0, 2,
      { 1758, 144 },
      -1,
   } },

   /* ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c') */
   /* search565_0_0_0 -> 141 in the cache */
   /* search565_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      2, 1,
      { 141, 142 },
      -1,
   } },
   /* search565_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      1, 2,
      { 1760, 144 },
      -1,
   } },
   /* search565_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      0, 3,
      { 1761, 141 },
      -1,
   } },

   /* replace565_0_0 -> 141 in the cache */
   /* replace565_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      1, 1,
      { 141, 142 },
      -1,
   } },
   /* replace565_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      0, 2,
      { 1763, 144 },
      -1,
   } },

   /* ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c') */
   /* search566_0_0_0 -> 141 in the cache */
   /* search566_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      2, 1,
      { 141, 142 },
      -1,
   } },
   /* search566_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 2,
      { 1765, 144 },
      -1,
   } },
   /* search566_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 3,
      { 1766, 141 },
      -1,
   } },

   /* replace566_0_0 -> 141 in the cache */
   /* replace566_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 1,
      { 141, 142 },
      -1,
   } },
   /* replace566_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 2,
      { 1768, 144 },
      -1,
   } },

   /* ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c') */
   /* search567_0_0_0 -> 141 in the cache */
   /* search567_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      2, 1,
      { 141, 142 },
      -1,
   } },
   /* search567_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      1, 2,
      { 1770, 144 },
      -1,
   } },
   /* search567_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      0, 3,
      { 1771, 141 },
      -1,
   } },

   /* replace567_0_0 -> 141 in the cache */
   /* replace567_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      1, 1,
      { 141, 142 },
      -1,
   } },
   /* replace567_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      0, 2,
      { 1773, 144 },
      -1,
   } },

   /* ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c') */
   /* search568_0_0_0 -> 141 in the cache */
   /* search568_0_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      2, 1,
      { 141, 142 },
      -1,
   } },
   /* search568_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      1, 2,
      { 1775, 144 },
      -1,
   } },
   /* search568_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      0, 3,
      { 1776, 141 },
      -1,
   } },

   /* replace568_0_0 -> 141 in the cache */
   /* replace568_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      1, 1,
      { 141, 142 },
      -1,
   } },
   /* replace568_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      0, 2,
      { 1778, 144 },
      -1,
   } },

   /* ('fmin', ('fmax', 'a(is_finite)', 'b'), 'a') => ('fmul', 1.0, 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search569_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      1, 1,
      { 1780, 1 },
      -1,
   } },
   /* search569_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 2,
      { 1781, 0 },
      -1,
   } },

   /* replace569_0 -> 315 in the cache */
   /* replace569_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 315, 0 },
      -1,
   } },

   /* ('fmax', ('fmin', 'a(is_finite)', 'b'), 'a') => ('fmul', 1.0, 'a') */
   /* search570_0_0 -> 1780 in the cache */
   /* search570_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 1,
      { 1780, 1 },
      -1,
   } },
   /* search570_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 2,
      { 1784, 0 },
      -1,
   } },

   /* replace570_0 -> 315 in the cache */
   /* replace570_1 -> 0 in the cache */
   /* replace570 -> 1783 in the cache */

   /* ('umin', ('umax', 'a', 'b'), 'a') => a */
   /* search571_0_0 -> 0 in the cache */
   /* search571_0_1 -> 1 in the cache */
   /* search571_0 -> 1736 in the cache */
   /* search571_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      0, 2,
      { 1736, 0 },
      -1,
   } },

   /* replace571 -> 0 in the cache */

   /* ('umax', ('umin', 'a', 'b'), 'a') => a */
   /* search572_0_0 -> 0 in the cache */
   /* search572_0_1 -> 1 in the cache */
   /* search572_0 -> 1744 in the cache */
   /* search572_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      0, 2,
      { 1744, 0 },
      -1,
   } },

   /* replace572 -> 0 in the cache */

   /* ('imin', ('imax', 'a', 'b'), 'a') => a */
   /* search573_0_0 -> 0 in the cache */
   /* search573_0_1 -> 1 in the cache */
   /* search573_0 -> 1739 in the cache */
   /* search573_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      0, 2,
      { 1739, 0 },
      -1,
   } },

   /* replace573 -> 0 in the cache */

   /* ('imax', ('imin', 'a', 'b'), 'a') => a */
   /* search574_0_0 -> 0 in the cache */
   /* search574_0_1 -> 1 in the cache */
   /* search574_0 -> 1747 in the cache */
   /* search574_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      0, 2,
      { 1747, 0 },
      -1,
   } },

   /* replace574 -> 0 in the cache */

   /* ('fmax(nsz)', 'a(is_a_number_not_negative)', 'b(is_not_positive)') => ('fcanonicalize', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      27,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      28,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 1790, 1791 },
      -1,
   } },

   /* replace575_0 -> 0 in the cache */
   /* replace575 -> 336 in the cache */

   /* ('fmin(nsz)', 'a(is_a_number_not_positive)', 'b(is_not_negative)') => ('fcanonicalize', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      29,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      30,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1793, 1794 },
      -1,
   } },

   /* replace576_0 -> 0 in the cache */
   /* replace576 -> 336 in the cache */

   /* ('fmax', 'a(is_a_number_not_negative)', 'b(is_lt_zero)') => ('fcanonicalize', 'a') */
   /* search577_0 -> 1790 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      31,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 1790, 1796 },
      -1,
   } },

   /* replace577_0 -> 0 in the cache */
   /* replace577 -> 336 in the cache */

   /* ('fmin', 'a(is_a_number_not_positive)', 'b(is_gt_zero)') => ('fcanonicalize', 'a') */
   /* search578_0 -> 1793 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      32,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1793, 1798 },
      -1,
   } },

   /* replace578_0 -> 0 in the cache */
   /* replace578 -> 336 in the cache */

   /* ('fneg', ('fmax(is_used_once)', ('fneg', 'a'), ('fneg', 'b'))) => ('fmin', 'a', 'b') */
   /* search579_0_0_0 -> 0 in the cache */
   /* search579_0_0 -> 249 in the cache */
   /* search579_0_1_0 -> 1 in the cache */
   /* search579_0_1 -> 1440 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 249, 1440 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1800 },
      -1,
   } },

   /* replace579_0 -> 0 in the cache */
   /* replace579_1 -> 1 in the cache */
   /* replace579 -> 1692 in the cache */

   /* ('fneg', ('fmin(is_used_once)', ('fneg', 'a'), ('fneg', 'b'))) => ('fmax', 'a', 'b') */
   /* search580_0_0_0 -> 0 in the cache */
   /* search580_0_0 -> 249 in the cache */
   /* search580_0_1_0 -> 1 in the cache */
   /* search580_0_1 -> 1440 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 249, 1440 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1802 },
      -1,
   } },

   /* replace580_0 -> 0 in the cache */
   /* replace580_1 -> 1 in the cache */
   /* replace580 -> 1690 in the cache */

   /* ('fneg', ('fmax(is_used_once)', ('fneg', 'a'), '#b')) => ('fmin', 'a', ('fneg', 'b')) */
   /* search581_0_0_0 -> 0 in the cache */
   /* search581_0_0 -> 249 in the cache */
   /* search581_0_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 249, 1112 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1804 },
      -1,
   } },

   /* replace581_0 -> 0 in the cache */
   /* replace581_1_0 -> 1 in the cache */
   /* replace581_1 -> 1440 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 0, 1440 },
      -1,
   } },

   /* ('fneg', ('fmin(is_used_once)', ('fneg', 'a'), '#b')) => ('fmax', 'a', ('fneg', 'b')) */
   /* search582_0_0_0 -> 0 in the cache */
   /* search582_0_0 -> 249 in the cache */
   /* search582_0_1 -> 1112 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 249, 1112 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1807 },
      -1,
   } },

   /* replace582_0 -> 0 in the cache */
   /* replace582_1_0 -> 1 in the cache */
   /* replace582_1 -> 1440 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 0, 1440 },
      -1,
   } },

   /* ('fmin(nsz)', 'a', -0.0) => ('fmin', 'a', 0.0) */
   /* search583_0 -> 9 in the cache */
   /* search583_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmin,
      0, 1,
      { 9, 130 },
      -1,
   } },

   /* replace583_0 -> 9 in the cache */
   /* replace583_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmin,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('fmax(nsz)', 'a', -0.0) => ('fmax', 'a', 0.0) */
   /* search584_0 -> 9 in the cache */
   /* search584_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmax,
      0, 1,
      { 9, 130 },
      -1,
   } },

   /* replace584_0 -> 9 in the cache */
   /* replace584_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmax,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('ine', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd')) */
   /* search585_0_0 -> 1008 in the cache */
   /* search585_0_1 -> 165 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 165, 1814 },
      0,
   } },
   /* search585_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1815, 1389 },
      -1,
   } },

   /* replace585_0 -> 1008 in the cache */
   /* replace585_1_0 -> 165 in the cache */
   /* replace585_1_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 165, 168 },
      -1,
   } },
   /* replace585_2_0 -> 167 in the cache */
   /* replace585_2_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      1, 1,
      { 167, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1008, 1817, 1818 },
      -1,
   } },

   /* ('ine', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd')) */
   /* search586_0_0 -> 1008 in the cache */
   /* search586_0_1 -> 1386 in the cache */
   /* search586_0_2 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1386, 167 },
      0,
   } },
   /* search586_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1820, 1389 },
      -1,
   } },

   /* replace586_0 -> 1008 in the cache */
   /* replace586_1_0 -> 165 in the cache */
   /* replace586_1_1 -> 168 in the cache */
   /* replace586_1 -> 1817 in the cache */
   /* replace586_2_0 -> 167 in the cache */
   /* replace586_2_1 -> 168 in the cache */
   /* replace586_2 -> 1818 in the cache */
   /* replace586 -> 1819 in the cache */

   /* ('ine', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ine', 'd', 'b'), ('ine', 'd', 'c')) */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search587_1_0 -> 1572 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1572, 1823, 1824 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1822, 1825 },
      -1,
   } },

   /* replace587_0 -> 1572 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace587_1_1 -> 1823 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1827, 1823 },
      -1,
   } },
   /* replace587_2_0 -> 1827 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      1, 1,
      { 1827, 1829 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1572, 1828, 1830 },
      -1,
   } },

   /* ('ine', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ine', 'd', 'b'), ('ine', 'd', 'c')) */
   /* search588_0 -> 1822 in the cache */
   /* search588_1_0 -> 1572 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search588_1_2 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1572, 1832, 1829 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1822, 1833 },
      -1,
   } },

   /* replace588_0 -> 1572 in the cache */
   /* replace588_1_0 -> 1827 in the cache */
   /* replace588_1_1 -> 1823 in the cache */
   /* replace588_1 -> 1828 in the cache */
   /* replace588_2_0 -> 1827 in the cache */
   /* replace588_2_1 -> 1829 in the cache */
   /* replace588_2 -> 1830 in the cache */
   /* replace588 -> 1831 in the cache */

   /* ('ieq', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd')) */
   /* search589_0_0 -> 1008 in the cache */
   /* search589_0_1 -> 165 in the cache */
   /* search589_0_2 -> 1814 in the cache */
   /* search589_0 -> 1815 in the cache */
   /* search589_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1815, 1389 },
      -1,
   } },

   /* replace589_0 -> 1008 in the cache */
   /* replace589_1_0 -> 165 in the cache */
   /* replace589_1_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 165, 168 },
      -1,
   } },
   /* replace589_2_0 -> 167 in the cache */
   /* replace589_2_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      1, 1,
      { 167, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1008, 1836, 1837 },
      -1,
   } },

   /* ('ieq', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd')) */
   /* search590_0_0 -> 1008 in the cache */
   /* search590_0_1 -> 1386 in the cache */
   /* search590_0_2 -> 167 in the cache */
   /* search590_0 -> 1820 in the cache */
   /* search590_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1820, 1389 },
      -1,
   } },

   /* replace590_0 -> 1008 in the cache */
   /* replace590_1_0 -> 165 in the cache */
   /* replace590_1_1 -> 168 in the cache */
   /* replace590_1 -> 1836 in the cache */
   /* replace590_2_0 -> 167 in the cache */
   /* replace590_2_1 -> 168 in the cache */
   /* replace590_2 -> 1837 in the cache */
   /* replace590 -> 1838 in the cache */

   /* ('ieq', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ieq', 'd', 'b'), ('ieq', 'd', 'c')) */
   /* search591_0 -> 1822 in the cache */
   /* search591_1_0 -> 1572 in the cache */
   /* search591_1_1 -> 1823 in the cache */
   /* search591_1_2 -> 1824 in the cache */
   /* search591_1 -> 1825 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1822, 1825 },
      -1,
   } },

   /* replace591_0 -> 1572 in the cache */
   /* replace591_1_0 -> 1827 in the cache */
   /* replace591_1_1 -> 1823 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1827, 1823 },
      -1,
   } },
   /* replace591_2_0 -> 1827 in the cache */
   /* replace591_2_1 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      1, 1,
      { 1827, 1829 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1572, 1841, 1842 },
      -1,
   } },

   /* ('ieq', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ieq', 'd', 'b'), ('ieq', 'd', 'c')) */
   /* search592_0 -> 1822 in the cache */
   /* search592_1_0 -> 1572 in the cache */
   /* search592_1_1 -> 1832 in the cache */
   /* search592_1_2 -> 1829 in the cache */
   /* search592_1 -> 1833 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1822, 1833 },
      -1,
   } },

   /* replace592_0 -> 1572 in the cache */
   /* replace592_1_0 -> 1827 in the cache */
   /* replace592_1_1 -> 1823 in the cache */
   /* replace592_1 -> 1841 in the cache */
   /* replace592_2_0 -> 1827 in the cache */
   /* replace592_2_1 -> 1829 in the cache */
   /* replace592_2 -> 1842 in the cache */
   /* replace592 -> 1843 in the cache */

   /* ('ilt', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd')) */
   /* search593_0_0 -> 1008 in the cache */
   /* search593_0_1 -> 165 in the cache */
   /* search593_0_2 -> 1814 in the cache */
   /* search593_0 -> 1815 in the cache */
   /* search593_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1815, 1389 },
      -1,
   } },

   /* replace593_0 -> 1008 in the cache */
   /* replace593_1_0 -> 165 in the cache */
   /* replace593_1_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 165, 168 },
      -1,
   } },
   /* replace593_2_0 -> 167 in the cache */
   /* replace593_2_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 167, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1846, 1847 },
      -1,
   } },

   /* ('ilt', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd')) */
   /* search594_0_0 -> 1008 in the cache */
   /* search594_0_1 -> 1386 in the cache */
   /* search594_0_2 -> 167 in the cache */
   /* search594_0 -> 1820 in the cache */
   /* search594_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1820, 1389 },
      -1,
   } },

   /* replace594_0 -> 1008 in the cache */
   /* replace594_1_0 -> 165 in the cache */
   /* replace594_1_1 -> 168 in the cache */
   /* replace594_1 -> 1846 in the cache */
   /* replace594_2_0 -> 167 in the cache */
   /* replace594_2_1 -> 168 in the cache */
   /* replace594_2 -> 1847 in the cache */
   /* replace594 -> 1848 in the cache */

   /* ('ilt', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c')) */
   /* search595_0 -> 1822 in the cache */
   /* search595_1_0 -> 1572 in the cache */
   /* search595_1_1 -> 1823 in the cache */
   /* search595_1_2 -> 1824 in the cache */
   /* search595_1 -> 1825 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1822, 1825 },
      -1,
   } },

   /* replace595_0 -> 1572 in the cache */
   /* replace595_1_0 -> 1827 in the cache */
   /* replace595_1_1 -> 1823 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1827, 1823 },
      -1,
   } },
   /* replace595_2_0 -> 1827 in the cache */
   /* replace595_2_1 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1827, 1829 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1572, 1851, 1852 },
      -1,
   } },

   /* ('ilt', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c')) */
   /* search596_0 -> 1822 in the cache */
   /* search596_1_0 -> 1572 in the cache */
   /* search596_1_1 -> 1832 in the cache */
   /* search596_1_2 -> 1829 in the cache */
   /* search596_1 -> 1833 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1822, 1833 },
      -1,
   } },

   /* replace596_0 -> 1572 in the cache */
   /* replace596_1_0 -> 1827 in the cache */
   /* replace596_1_1 -> 1823 in the cache */
   /* replace596_1 -> 1851 in the cache */
   /* replace596_2_0 -> 1827 in the cache */
   /* replace596_2_1 -> 1829 in the cache */
   /* replace596_2 -> 1852 in the cache */
   /* replace596 -> 1853 in the cache */

   /* ('ige', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd')) */
   /* search597_0_0 -> 1008 in the cache */
   /* search597_0_1 -> 165 in the cache */
   /* search597_0_2 -> 1814 in the cache */
   /* search597_0 -> 1815 in the cache */
   /* search597_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1815, 1389 },
      -1,
   } },

   /* replace597_0 -> 1008 in the cache */
   /* replace597_1_0 -> 165 in the cache */
   /* replace597_1_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 165, 168 },
      -1,
   } },
   /* replace597_2_0 -> 167 in the cache */
   /* replace597_2_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 167, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1856, 1857 },
      -1,
   } },

   /* ('ige', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd')) */
   /* search598_0_0 -> 1008 in the cache */
   /* search598_0_1 -> 1386 in the cache */
   /* search598_0_2 -> 167 in the cache */
   /* search598_0 -> 1820 in the cache */
   /* search598_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1820, 1389 },
      -1,
   } },

   /* replace598_0 -> 1008 in the cache */
   /* replace598_1_0 -> 165 in the cache */
   /* replace598_1_1 -> 168 in the cache */
   /* replace598_1 -> 1856 in the cache */
   /* replace598_2_0 -> 167 in the cache */
   /* replace598_2_1 -> 168 in the cache */
   /* replace598_2 -> 1857 in the cache */
   /* replace598 -> 1858 in the cache */

   /* ('ige', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c')) */
   /* search599_0 -> 1822 in the cache */
   /* search599_1_0 -> 1572 in the cache */
   /* search599_1_1 -> 1823 in the cache */
   /* search599_1_2 -> 1824 in the cache */
   /* search599_1 -> 1825 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1822, 1825 },
      -1,
   } },

   /* replace599_0 -> 1572 in the cache */
   /* replace599_1_0 -> 1827 in the cache */
   /* replace599_1_1 -> 1823 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1827, 1823 },
      -1,
   } },
   /* replace599_2_0 -> 1827 in the cache */
   /* replace599_2_1 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1827, 1829 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1572, 1861, 1862 },
      -1,
   } },

   /* ('ige', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c')) */
   /* search600_0 -> 1822 in the cache */
   /* search600_1_0 -> 1572 in the cache */
   /* search600_1_1 -> 1832 in the cache */
   /* search600_1_2 -> 1829 in the cache */
   /* search600_1 -> 1833 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1822, 1833 },
      -1,
   } },

   /* replace600_0 -> 1572 in the cache */
   /* replace600_1_0 -> 1827 in the cache */
   /* replace600_1_1 -> 1823 in the cache */
   /* replace600_1 -> 1861 in the cache */
   /* replace600_2_0 -> 1827 in the cache */
   /* replace600_2_1 -> 1829 in the cache */
   /* replace600_2 -> 1862 in the cache */
   /* replace600 -> 1863 in the cache */

   /* ('ult', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd')) */
   /* search601_0_0 -> 1008 in the cache */
   /* search601_0_1 -> 165 in the cache */
   /* search601_0_2 -> 1814 in the cache */
   /* search601_0 -> 1815 in the cache */
   /* search601_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1815, 1389 },
      -1,
   } },

   /* replace601_0 -> 1008 in the cache */
   /* replace601_1_0 -> 165 in the cache */
   /* replace601_1_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 165, 168 },
      -1,
   } },
   /* replace601_2_0 -> 167 in the cache */
   /* replace601_2_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 167, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1866, 1867 },
      -1,
   } },

   /* ('ult', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd')) */
   /* search602_0_0 -> 1008 in the cache */
   /* search602_0_1 -> 1386 in the cache */
   /* search602_0_2 -> 167 in the cache */
   /* search602_0 -> 1820 in the cache */
   /* search602_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1820, 1389 },
      -1,
   } },

   /* replace602_0 -> 1008 in the cache */
   /* replace602_1_0 -> 165 in the cache */
   /* replace602_1_1 -> 168 in the cache */
   /* replace602_1 -> 1866 in the cache */
   /* replace602_2_0 -> 167 in the cache */
   /* replace602_2_1 -> 168 in the cache */
   /* replace602_2 -> 1867 in the cache */
   /* replace602 -> 1868 in the cache */

   /* ('ult', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c')) */
   /* search603_0 -> 1822 in the cache */
   /* search603_1_0 -> 1572 in the cache */
   /* search603_1_1 -> 1823 in the cache */
   /* search603_1_2 -> 1824 in the cache */
   /* search603_1 -> 1825 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1822, 1825 },
      -1,
   } },

   /* replace603_0 -> 1572 in the cache */
   /* replace603_1_0 -> 1827 in the cache */
   /* replace603_1_1 -> 1823 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1827, 1823 },
      -1,
   } },
   /* replace603_2_0 -> 1827 in the cache */
   /* replace603_2_1 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1827, 1829 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1572, 1871, 1872 },
      -1,
   } },

   /* ('ult', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c')) */
   /* search604_0 -> 1822 in the cache */
   /* search604_1_0 -> 1572 in the cache */
   /* search604_1_1 -> 1832 in the cache */
   /* search604_1_2 -> 1829 in the cache */
   /* search604_1 -> 1833 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1822, 1833 },
      -1,
   } },

   /* replace604_0 -> 1572 in the cache */
   /* replace604_1_0 -> 1827 in the cache */
   /* replace604_1_1 -> 1823 in the cache */
   /* replace604_1 -> 1871 in the cache */
   /* replace604_2_0 -> 1827 in the cache */
   /* replace604_2_1 -> 1829 in the cache */
   /* replace604_2 -> 1872 in the cache */
   /* replace604 -> 1873 in the cache */

   /* ('uge', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd')) */
   /* search605_0_0 -> 1008 in the cache */
   /* search605_0_1 -> 165 in the cache */
   /* search605_0_2 -> 1814 in the cache */
   /* search605_0 -> 1815 in the cache */
   /* search605_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1815, 1389 },
      -1,
   } },

   /* replace605_0 -> 1008 in the cache */
   /* replace605_1_0 -> 165 in the cache */
   /* replace605_1_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 165, 168 },
      -1,
   } },
   /* replace605_2_0 -> 167 in the cache */
   /* replace605_2_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 167, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1876, 1877 },
      -1,
   } },

   /* ('uge', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd')) */
   /* search606_0_0 -> 1008 in the cache */
   /* search606_0_1 -> 1386 in the cache */
   /* search606_0_2 -> 167 in the cache */
   /* search606_0 -> 1820 in the cache */
   /* search606_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1820, 1389 },
      -1,
   } },

   /* replace606_0 -> 1008 in the cache */
   /* replace606_1_0 -> 165 in the cache */
   /* replace606_1_1 -> 168 in the cache */
   /* replace606_1 -> 1876 in the cache */
   /* replace606_2_0 -> 167 in the cache */
   /* replace606_2_1 -> 168 in the cache */
   /* replace606_2 -> 1877 in the cache */
   /* replace606 -> 1878 in the cache */

   /* ('uge', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c')) */
   /* search607_0 -> 1822 in the cache */
   /* search607_1_0 -> 1572 in the cache */
   /* search607_1_1 -> 1823 in the cache */
   /* search607_1_2 -> 1824 in the cache */
   /* search607_1 -> 1825 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1822, 1825 },
      -1,
   } },

   /* replace607_0 -> 1572 in the cache */
   /* replace607_1_0 -> 1827 in the cache */
   /* replace607_1_1 -> 1823 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1827, 1823 },
      -1,
   } },
   /* replace607_2_0 -> 1827 in the cache */
   /* replace607_2_1 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1827, 1829 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1572, 1881, 1882 },
      -1,
   } },

   /* ('uge', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c')) */
   /* search608_0 -> 1822 in the cache */
   /* search608_1_0 -> 1572 in the cache */
   /* search608_1_1 -> 1832 in the cache */
   /* search608_1_2 -> 1829 in the cache */
   /* search608_1 -> 1833 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1822, 1833 },
      -1,
   } },

   /* replace608_0 -> 1572 in the cache */
   /* replace608_1_0 -> 1827 in the cache */
   /* replace608_1_1 -> 1823 in the cache */
   /* replace608_1 -> 1881 in the cache */
   /* replace608_2_0 -> 1827 in the cache */
   /* replace608_2_1 -> 1829 in the cache */
   /* replace608_2 -> 1882 in the cache */
   /* replace608 -> 1883 in the cache */

   /* ('bitz', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('bitz', 'b', 'd'), ('bitz', 'c', 'd')) */
   /* search609_0_0 -> 1008 in the cache */
   /* search609_0_1 -> 142 in the cache */
   /* search609_0_2 -> 1105 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 142, 1105 },
      0,
   } },
   /* search609_1 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1885, 360 },
      -1,
   } },

   /* replace609_0 -> 1008 in the cache */
   /* replace609_1_0 -> 142 in the cache */
   /* replace609_1_1 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 142, 178 },
      -1,
   } },
   /* replace609_2_0 -> 144 in the cache */
   /* replace609_2_1 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 144, 178 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1887, 1888 },
      -1,
   } },

   /* ('bitz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('bitz', 'b', 'd'), ('bitz', 'c', 'd')) */
   /* search610_0_0 -> 1008 in the cache */
   /* search610_0_1 -> 329 in the cache */
   /* search610_0_2 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 329, 144 },
      0,
   } },
   /* search610_1 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1890, 360 },
      -1,
   } },

   /* replace610_0 -> 1008 in the cache */
   /* replace610_1_0 -> 142 in the cache */
   /* replace610_1_1 -> 178 in the cache */
   /* replace610_1 -> 1887 in the cache */
   /* replace610_2_0 -> 144 in the cache */
   /* replace610_2_1 -> 178 in the cache */
   /* replace610_2 -> 1888 in the cache */
   /* replace610 -> 1889 in the cache */

   /* ('bitz', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('bitz', 'd', 'b'), ('bitz', 'd', 'c')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search611_1_0 -> 1572 in the cache */
   /* search611_1_1 -> 782 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1572, 782, 1893 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1892, 1894 },
      -1,
   } },

   /* replace611_0 -> 1572 in the cache */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace611_1_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1896, 782 },
      -1,
   } },
   /* replace611_2_0 -> 1896 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1896, 1898 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1572, 1897, 1899 },
      -1,
   } },

   /* ('bitz', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('bitz', 'd', 'b'), ('bitz', 'd', 'c')) */
   /* search612_0 -> 1892 in the cache */
   /* search612_1_0 -> 1572 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search612_1_2 -> 1898 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1572, 1901, 1898 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1892, 1902 },
      -1,
   } },

   /* replace612_0 -> 1572 in the cache */
   /* replace612_1_0 -> 1896 in the cache */
   /* replace612_1_1 -> 782 in the cache */
   /* replace612_1 -> 1897 in the cache */
   /* replace612_2_0 -> 1896 in the cache */
   /* replace612_2_1 -> 1898 in the cache */
   /* replace612_2 -> 1899 in the cache */
   /* replace612 -> 1900 in the cache */

   /* ('bitnz', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('bitnz', 'b', 'd'), ('bitnz', 'c', 'd')) */
   /* search613_0_0 -> 1008 in the cache */
   /* search613_0_1 -> 142 in the cache */
   /* search613_0_2 -> 1105 in the cache */
   /* search613_0 -> 1885 in the cache */
   /* search613_1 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1885, 360 },
      -1,
   } },

   /* replace613_0 -> 1008 in the cache */
   /* replace613_1_0 -> 142 in the cache */
   /* replace613_1_1 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 142, 178 },
      -1,
   } },
   /* replace613_2_0 -> 144 in the cache */
   /* replace613_2_1 -> 178 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 144, 178 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1905, 1906 },
      -1,
   } },

   /* ('bitnz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('bitnz', 'b', 'd'), ('bitnz', 'c', 'd')) */
   /* search614_0_0 -> 1008 in the cache */
   /* search614_0_1 -> 329 in the cache */
   /* search614_0_2 -> 144 in the cache */
   /* search614_0 -> 1890 in the cache */
   /* search614_1 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1890, 360 },
      -1,
   } },

   /* replace614_0 -> 1008 in the cache */
   /* replace614_1_0 -> 142 in the cache */
   /* replace614_1_1 -> 178 in the cache */
   /* replace614_1 -> 1905 in the cache */
   /* replace614_2_0 -> 144 in the cache */
   /* replace614_2_1 -> 178 in the cache */
   /* replace614_2 -> 1906 in the cache */
   /* replace614 -> 1907 in the cache */

   /* ('bitnz', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('bitnz', 'd', 'b'), ('bitnz', 'd', 'c')) */
   /* search615_0 -> 1892 in the cache */
   /* search615_1_0 -> 1572 in the cache */
   /* search615_1_1 -> 782 in the cache */
   /* search615_1_2 -> 1893 in the cache */
   /* search615_1 -> 1894 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1892, 1894 },
      -1,
   } },

   /* replace615_0 -> 1572 in the cache */
   /* replace615_1_0 -> 1896 in the cache */
   /* replace615_1_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1896, 782 },
      -1,
   } },
   /* replace615_2_0 -> 1896 in the cache */
   /* replace615_2_1 -> 1898 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1896, 1898 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1572, 1910, 1911 },
      -1,
   } },

   /* ('bitnz', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('bitnz', 'd', 'b'), ('bitnz', 'd', 'c')) */
   /* search616_0 -> 1892 in the cache */
   /* search616_1_0 -> 1572 in the cache */
   /* search616_1_1 -> 1901 in the cache */
   /* search616_1_2 -> 1898 in the cache */
   /* search616_1 -> 1902 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1892, 1902 },
      -1,
   } },

   /* replace616_0 -> 1572 in the cache */
   /* replace616_1_0 -> 1896 in the cache */
   /* replace616_1_1 -> 782 in the cache */
   /* replace616_1 -> 1910 in the cache */
   /* replace616_2_0 -> 1896 in the cache */
   /* replace616_2_1 -> 1898 in the cache */
   /* replace616_2 -> 1911 in the cache */
   /* replace616 -> 1912 in the cache */

   /* ('fneu', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd')) */
   /* search617_0_0 -> 1008 in the cache */
   /* search617_0_1 -> 165 in the cache */
   /* search617_0_2 -> 1814 in the cache */
   /* search617_0 -> 1815 in the cache */
   /* search617_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1815, 1389 },
      -1,
   } },

   /* replace617_0 -> 1008 in the cache */
   /* replace617_1_0 -> 165 in the cache */
   /* replace617_1_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 165, 168 },
      -1,
   } },
   /* replace617_2_0 -> 167 in the cache */
   /* replace617_2_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      1, 1,
      { 167, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1008, 1915, 1916 },
      -1,
   } },

   /* ('fneu', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd')) */
   /* search618_0_0 -> 1008 in the cache */
   /* search618_0_1 -> 1386 in the cache */
   /* search618_0_2 -> 167 in the cache */
   /* search618_0 -> 1820 in the cache */
   /* search618_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1820, 1389 },
      -1,
   } },

   /* replace618_0 -> 1008 in the cache */
   /* replace618_1_0 -> 165 in the cache */
   /* replace618_1_1 -> 168 in the cache */
   /* replace618_1 -> 1915 in the cache */
   /* replace618_2_0 -> 167 in the cache */
   /* replace618_2_1 -> 168 in the cache */
   /* replace618_2 -> 1916 in the cache */
   /* replace618 -> 1917 in the cache */

   /* ('fneu', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fneu', 'd', 'b'), ('fneu', 'd', 'c')) */
   /* search619_0 -> 1822 in the cache */
   /* search619_1_0 -> 1572 in the cache */
   /* search619_1_1 -> 1823 in the cache */
   /* search619_1_2 -> 1824 in the cache */
   /* search619_1 -> 1825 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1822, 1825 },
      -1,
   } },

   /* replace619_0 -> 1572 in the cache */
   /* replace619_1_0 -> 1827 in the cache */
   /* replace619_1_1 -> 1823 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1827, 1823 },
      -1,
   } },
   /* replace619_2_0 -> 1827 in the cache */
   /* replace619_2_1 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      1, 1,
      { 1827, 1829 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1572, 1920, 1921 },
      -1,
   } },

   /* ('fneu', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fneu', 'd', 'b'), ('fneu', 'd', 'c')) */
   /* search620_0 -> 1822 in the cache */
   /* search620_1_0 -> 1572 in the cache */
   /* search620_1_1 -> 1832 in the cache */
   /* search620_1_2 -> 1829 in the cache */
   /* search620_1 -> 1833 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1822, 1833 },
      -1,
   } },

   /* replace620_0 -> 1572 in the cache */
   /* replace620_1_0 -> 1827 in the cache */
   /* replace620_1_1 -> 1823 in the cache */
   /* replace620_1 -> 1920 in the cache */
   /* replace620_2_0 -> 1827 in the cache */
   /* replace620_2_1 -> 1829 in the cache */
   /* replace620_2 -> 1921 in the cache */
   /* replace620 -> 1922 in the cache */

   /* ('feq', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd')) */
   /* search621_0_0 -> 1008 in the cache */
   /* search621_0_1 -> 165 in the cache */
   /* search621_0_2 -> 1814 in the cache */
   /* search621_0 -> 1815 in the cache */
   /* search621_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1815, 1389 },
      -1,
   } },

   /* replace621_0 -> 1008 in the cache */
   /* replace621_1_0 -> 165 in the cache */
   /* replace621_1_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 165, 168 },
      -1,
   } },
   /* replace621_2_0 -> 167 in the cache */
   /* replace621_2_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      1, 1,
      { 167, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1008, 1925, 1926 },
      -1,
   } },

   /* ('feq', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd')) */
   /* search622_0_0 -> 1008 in the cache */
   /* search622_0_1 -> 1386 in the cache */
   /* search622_0_2 -> 167 in the cache */
   /* search622_0 -> 1820 in the cache */
   /* search622_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1820, 1389 },
      -1,
   } },

   /* replace622_0 -> 1008 in the cache */
   /* replace622_1_0 -> 165 in the cache */
   /* replace622_1_1 -> 168 in the cache */
   /* replace622_1 -> 1925 in the cache */
   /* replace622_2_0 -> 167 in the cache */
   /* replace622_2_1 -> 168 in the cache */
   /* replace622_2 -> 1926 in the cache */
   /* replace622 -> 1927 in the cache */

   /* ('feq', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('feq', 'd', 'b'), ('feq', 'd', 'c')) */
   /* search623_0 -> 1822 in the cache */
   /* search623_1_0 -> 1572 in the cache */
   /* search623_1_1 -> 1823 in the cache */
   /* search623_1_2 -> 1824 in the cache */
   /* search623_1 -> 1825 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1822, 1825 },
      -1,
   } },

   /* replace623_0 -> 1572 in the cache */
   /* replace623_1_0 -> 1827 in the cache */
   /* replace623_1_1 -> 1823 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1827, 1823 },
      -1,
   } },
   /* replace623_2_0 -> 1827 in the cache */
   /* replace623_2_1 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      1, 1,
      { 1827, 1829 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1572, 1930, 1931 },
      -1,
   } },

   /* ('feq', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('feq', 'd', 'b'), ('feq', 'd', 'c')) */
   /* search624_0 -> 1822 in the cache */
   /* search624_1_0 -> 1572 in the cache */
   /* search624_1_1 -> 1832 in the cache */
   /* search624_1_2 -> 1829 in the cache */
   /* search624_1 -> 1833 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1822, 1833 },
      -1,
   } },

   /* replace624_0 -> 1572 in the cache */
   /* replace624_1_0 -> 1827 in the cache */
   /* replace624_1_1 -> 1823 in the cache */
   /* replace624_1 -> 1930 in the cache */
   /* replace624_2_0 -> 1827 in the cache */
   /* replace624_2_1 -> 1829 in the cache */
   /* replace624_2 -> 1931 in the cache */
   /* replace624 -> 1932 in the cache */

   /* ('flt', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd')) */
   /* search625_0_0 -> 1008 in the cache */
   /* search625_0_1 -> 165 in the cache */
   /* search625_0_2 -> 1814 in the cache */
   /* search625_0 -> 1815 in the cache */
   /* search625_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1815, 1389 },
      -1,
   } },

   /* replace625_0 -> 1008 in the cache */
   /* replace625_1_0 -> 165 in the cache */
   /* replace625_1_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 165, 168 },
      -1,
   } },
   /* replace625_2_0 -> 167 in the cache */
   /* replace625_2_1 -> 168 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 167, 168 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1008, 1935, 1936 },
      -1,
   } },

   /* ('flt', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd')) */
   /* search626_0_0 -> 1008 in the cache */
   /* search626_0_1 -> 1386 in the cache */
   /* search626_0_2 -> 167 in the cache */
   /* search626_0 -> 1820 in the cache */
   /* search626_1 -> 1389 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1820, 1389 },
      -1,
   } },

   /* replace626_0 -> 1008 in the cache */
   /* replace626_1_0 -> 165 in the cache */
   /* replace626_1_1 -> 168 in the cache */
   /* replace626_1 -> 1935 in the cache */
   /* replace626_2_0 -> 167 in the cache */
   /* replace626_2_1 -> 168 in the cache */
   /* replace626_2 -> 1936 in the cache */
   /* replace626 -> 1937 in the cache */

   /* ('flt', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c')) */
   /* search627_0 -> 1822 in the cache */
   /* search627_1_0 -> 1572 in the cache */
   /* search627_1_1 -> 1823 in the cache */
   /* search627_1_2 -> 1824 in the cache */
   /* search627_1 -> 1825 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1822, 1825 },
   