/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 * Copyright (C) 2020, Google Inc.
 *
 * Image Processing Algorithm proxy for vimc
 *
 * This file is auto-generated. Do not edit.
 */

#pragma once

#include <libcamera/ipa/ipa_interface.h>
#include <libcamera/ipa/vimc_ipa_interface.h>

#include <libcamera/base/object.h>
#include <libcamera/base/thread.h>

#include "libcamera/internal/control_serializer.h"
#include "libcamera/internal/ipa_proxy.h"
#include "libcamera/internal/ipc_pipe.h"
#include "libcamera/internal/ipc_pipe_unixsocket.h"
#include "libcamera/internal/ipc_unixsocket.h"

namespace libcamera {

namespace ipa {

namespace vimc {


class IPAProxyVimcThreaded;
class IPAProxyVimcIsolated;

class IPAProxyVimc : public IPAProxy, public IPAVimcInterface, public Object
{
public:
	using Threaded = IPAProxyVimcThreaded;
	using Isolated = IPAProxyVimcIsolated;

protected:
	using IPAProxy::IPAProxy;
};

class IPAProxyVimcThreaded : public IPAProxyVimc
{
public:
	IPAProxyVimcThreaded(IPAModule *ipam, const GlobalConfiguration &configuration);
	~IPAProxyVimcThreaded();


        int32_t init(
        	const IPASettings &settings,
        	const IPAOperationCode code,
        	const Flags<ipa::vimc::TestFlag> inFlags,
        	Flags<ipa::vimc::TestFlag> *outFlags) override;

        int32_t configure(
        	const IPACameraSensorInfo &sensorInfo,
        	const std::map<uint32_t, libcamera::IPAStream> &streamConfig,
        	const std::map<uint32_t, libcamera::ControlInfoMap> &entityControls) override;

        int32_t start() override;

        void stop() override;

        void mapBuffers(
        	const std::vector<libcamera::IPABuffer> &buffers) override;

        void unmapBuffers(
        	const std::vector<uint32_t> &ids) override;

        void queueRequest(
        	const uint32_t frame,
        	const ControlList &controls) override;

        void computeParams(
        	const uint32_t frame,
        	const uint32_t bufferId) override;


private:

        void paramsComputedHandler(
        	const uint32_t bufferId,
        	const Flags<ipa::vimc::TestFlag> flags);


	/* Helper class to invoke async functions in another thread. */
	class ThreadProxy : public Object
	{
	public:
		ThreadProxy()
			: ipa_(nullptr)
		{
		}

		void setIPA(IPAVimcInterface *ipa)
		{
			ipa_ = ipa;
		}

		void stop()
		{
			ipa_->stop();
		}

		int32_t start()
		{
			return ipa_->start();
		}
		void queueRequest(
                	const uint32_t frame,
                	const ControlList &controls)
		{
			ipa_->queueRequest(frame, controls);
		}
		void computeParams(
                	const uint32_t frame,
                	const uint32_t bufferId)
		{
			ipa_->computeParams(frame, bufferId);
		}

	private:
		IPAVimcInterface *ipa_;
	};

	Thread thread_;
	ThreadProxy proxy_;
	std::unique_ptr<IPAVimcInterface> ipa_;
};

class IPAProxyVimcIsolated : public IPAProxyVimc
{
public:
	IPAProxyVimcIsolated(IPAModule *ipam, const GlobalConfiguration &configuration);
	~IPAProxyVimcIsolated();


        int32_t init(
        	const IPASettings &settings,
        	const IPAOperationCode code,
        	const Flags<ipa::vimc::TestFlag> inFlags,
        	Flags<ipa::vimc::TestFlag> *outFlags) override;

        int32_t configure(
        	const IPACameraSensorInfo &sensorInfo,
        	const std::map<uint32_t, libcamera::IPAStream> &streamConfig,
        	const std::map<uint32_t, libcamera::ControlInfoMap> &entityControls) override;

        int32_t start() override;

        void stop() override;

        void mapBuffers(
        	const std::vector<libcamera::IPABuffer> &buffers) override;

        void unmapBuffers(
        	const std::vector<uint32_t> &ids) override;

        void queueRequest(
        	const uint32_t frame,
        	const ControlList &controls) override;

        void computeParams(
        	const uint32_t frame,
        	const uint32_t bufferId) override;


private:
	void recvMessage(const IPCMessage &data);


	void paramsComputedHandler(
		std::vector<uint8_t>::const_iterator data,
		size_t dataSize,
		const std::vector<SharedFD> &fds);


	std::unique_ptr<IPCPipeUnixSocket> ipc_;

	ControlSerializer controlSerializer_;


	uint32_t seq_;
};

} /* namespace vimc */

} /* namespace ipa */

} /* namespace libcamera */