/* SPDX-FileCopyrightText: 2010 - Ignacio Casal Quinteiro
 * SPDX-FileCopyrightText: 2014 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <gtk/gtk.h>
#include "gtksourcebuffer.h"
#include "gtksourcefile.h"
#include "gtksourceinternal.h"

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_BUFFER_OUTPUT_STREAM		(gtk_source_buffer_output_stream_get_type ())
#define GTK_SOURCE_BUFFER_OUTPUT_STREAM(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_BUFFER_OUTPUT_STREAM, GtkSourceBufferOutputStream))
#define GTK_SOURCE_BUFFER_OUTPUT_STREAM_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_SOURCE_TYPE_BUFFER_OUTPUT_STREAM, GtkSourceBufferOutputStreamClass))
#define GTK_SOURCE_IS_BUFFER_OUTPUT_STREAM(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_SOURCE_TYPE_BUFFER_OUTPUT_STREAM))
#define GTK_SOURCE_IS_BUFFER_OUTPUT_STREAM_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_BUFFER_OUTPUT_STREAM))
#define GTK_SOURCE_BUFFER_OUTPUT_STREAM_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_SOURCE_TYPE_BUFFER_OUTPUT_STREAM, GtkSourceBufferOutputStreamClass))

typedef struct _GtkSourceBufferOutputStream        GtkSourceBufferOutputStream;
typedef struct _GtkSourceBufferOutputStreamClass   GtkSourceBufferOutputStreamClass;
typedef struct _GtkSourceBufferOutputStreamPrivate GtkSourceBufferOutputStreamPrivate;

struct _GtkSourceBufferOutputStream
{
	GOutputStream parent;

	GtkSourceBufferOutputStreamPrivate *priv;
};

struct _GtkSourceBufferOutputStreamClass
{
	GOutputStreamClass parent_class;
};

GTK_SOURCE_INTERNAL
GType			gtk_source_buffer_output_stream_get_type		(void) G_GNUC_CONST;

GTK_SOURCE_INTERNAL
GtkSourceBufferOutputStream *
			gtk_source_buffer_output_stream_new			(GtkSourceBuffer *buffer,
										 GSList          *candidate_encodings,
										 gboolean         remove_trailing_newline);

GTK_SOURCE_INTERNAL
GtkSourceNewlineType	gtk_source_buffer_output_stream_detect_newline_type	(GtkSourceBufferOutputStream *stream);

GTK_SOURCE_INTERNAL
GtkSourceEncoding *	gtk_source_buffer_output_stream_get_guessed		(GtkSourceBufferOutputStream *stream);

GTK_SOURCE_INTERNAL
guint			gtk_source_buffer_output_stream_get_num_fallbacks	(GtkSourceBufferOutputStream *stream);

G_END_DECLS
