// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolExportTraceServiceResponse = sync.Pool{
		New: func() any {
			return &otlpcollectortrace.ExportTraceServiceResponse{}
		},
	}
)

func NewOrigExportTraceServiceResponse() *otlpcollectortrace.ExportTraceServiceResponse {
	if !UseProtoPooling.IsEnabled() {
		return &otlpcollectortrace.ExportTraceServiceResponse{}
	}
	return protoPoolExportTraceServiceResponse.Get().(*otlpcollectortrace.ExportTraceServiceResponse)
}

func DeleteOrigExportTraceServiceResponse(orig *otlpcollectortrace.ExportTraceServiceResponse, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteOrigExportTracePartialSuccess(&orig.PartialSuccess, false)

	orig.Reset()
	if nullable {
		protoPoolExportTraceServiceResponse.Put(orig)
	}
}

func CopyOrigExportTraceServiceResponse(dest, src *otlpcollectortrace.ExportTraceServiceResponse) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	CopyOrigExportTracePartialSuccess(&dest.PartialSuccess, &src.PartialSuccess)
}

func GenTestOrigExportTraceServiceResponse() *otlpcollectortrace.ExportTraceServiceResponse {
	orig := NewOrigExportTraceServiceResponse()
	orig.PartialSuccess = *GenTestOrigExportTracePartialSuccess()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportTraceServiceResponse(orig *otlpcollectortrace.ExportTraceServiceResponse, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("partialSuccess")
	MarshalJSONOrigExportTracePartialSuccess(&orig.PartialSuccess, dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExportResponse unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportTraceServiceResponse(orig *otlpcollectortrace.ExportTraceServiceResponse, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "partialSuccess", "partial_success":
			UnmarshalJSONOrigExportTracePartialSuccess(&orig.PartialSuccess, iter)
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigExportTraceServiceResponse(orig *otlpcollectortrace.ExportTraceServiceResponse) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigExportTracePartialSuccess(&orig.PartialSuccess)
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func MarshalProtoOrigExportTraceServiceResponse(orig *otlpcollectortrace.ExportTraceServiceResponse, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigExportTracePartialSuccess(&orig.PartialSuccess, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	return len(buf) - pos
}

func UnmarshalProtoOrigExportTraceServiceResponse(orig *otlpcollectortrace.ExportTraceServiceResponse, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialSuccess", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigExportTracePartialSuccess(&orig.PartialSuccess, buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
