// Code generated by ndpgen. DO NOT EDIT.

package host

import (
	"context"
	"encoding/json"

	extism "github.com/extism/go-sdk"
)

// KVStoreSetRequest is the request type for KVStore.Set.
type KVStoreSetRequest struct {
	Key   string `json:"key"`
	Value []byte `json:"value"`
}

// KVStoreSetResponse is the response type for KVStore.Set.
type KVStoreSetResponse struct {
	Error string `json:"error,omitempty"`
}

// KVStoreGetRequest is the request type for KVStore.Get.
type KVStoreGetRequest struct {
	Key string `json:"key"`
}

// KVStoreGetResponse is the response type for KVStore.Get.
type KVStoreGetResponse struct {
	Value  []byte `json:"value,omitempty"`
	Exists bool   `json:"exists,omitempty"`
	Error  string `json:"error,omitempty"`
}

// KVStoreDeleteRequest is the request type for KVStore.Delete.
type KVStoreDeleteRequest struct {
	Key string `json:"key"`
}

// KVStoreDeleteResponse is the response type for KVStore.Delete.
type KVStoreDeleteResponse struct {
	Error string `json:"error,omitempty"`
}

// KVStoreHasRequest is the request type for KVStore.Has.
type KVStoreHasRequest struct {
	Key string `json:"key"`
}

// KVStoreHasResponse is the response type for KVStore.Has.
type KVStoreHasResponse struct {
	Exists bool   `json:"exists,omitempty"`
	Error  string `json:"error,omitempty"`
}

// KVStoreListRequest is the request type for KVStore.List.
type KVStoreListRequest struct {
	Prefix string `json:"prefix"`
}

// KVStoreListResponse is the response type for KVStore.List.
type KVStoreListResponse struct {
	Keys  []string `json:"keys,omitempty"`
	Error string   `json:"error,omitempty"`
}

// KVStoreGetStorageUsedResponse is the response type for KVStore.GetStorageUsed.
type KVStoreGetStorageUsedResponse struct {
	Bytes int64  `json:"bytes,omitempty"`
	Error string `json:"error,omitempty"`
}

// RegisterKVStoreHostFunctions registers KVStore service host functions.
// The returned host functions should be added to the plugin's configuration.
func RegisterKVStoreHostFunctions(service KVStoreService) []extism.HostFunction {
	return []extism.HostFunction{
		newKVStoreSetHostFunction(service),
		newKVStoreGetHostFunction(service),
		newKVStoreDeleteHostFunction(service),
		newKVStoreHasHostFunction(service),
		newKVStoreListHostFunction(service),
		newKVStoreGetStorageUsedHostFunction(service),
	}
}

func newKVStoreSetHostFunction(service KVStoreService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"kvstore_set",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				kvstoreWriteError(p, stack, err)
				return
			}
			var req KVStoreSetRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				kvstoreWriteError(p, stack, err)
				return
			}

			// Call the service method
			if svcErr := service.Set(ctx, req.Key, req.Value); svcErr != nil {
				kvstoreWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := KVStoreSetResponse{}
			kvstoreWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newKVStoreGetHostFunction(service KVStoreService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"kvstore_get",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				kvstoreWriteError(p, stack, err)
				return
			}
			var req KVStoreGetRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				kvstoreWriteError(p, stack, err)
				return
			}

			// Call the service method
			value, exists, svcErr := service.Get(ctx, req.Key)
			if svcErr != nil {
				kvstoreWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := KVStoreGetResponse{
				Value:  value,
				Exists: exists,
			}
			kvstoreWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newKVStoreDeleteHostFunction(service KVStoreService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"kvstore_delete",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				kvstoreWriteError(p, stack, err)
				return
			}
			var req KVStoreDeleteRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				kvstoreWriteError(p, stack, err)
				return
			}

			// Call the service method
			if svcErr := service.Delete(ctx, req.Key); svcErr != nil {
				kvstoreWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := KVStoreDeleteResponse{}
			kvstoreWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newKVStoreHasHostFunction(service KVStoreService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"kvstore_has",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				kvstoreWriteError(p, stack, err)
				return
			}
			var req KVStoreHasRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				kvstoreWriteError(p, stack, err)
				return
			}

			// Call the service method
			exists, svcErr := service.Has(ctx, req.Key)
			if svcErr != nil {
				kvstoreWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := KVStoreHasResponse{
				Exists: exists,
			}
			kvstoreWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newKVStoreListHostFunction(service KVStoreService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"kvstore_list",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				kvstoreWriteError(p, stack, err)
				return
			}
			var req KVStoreListRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				kvstoreWriteError(p, stack, err)
				return
			}

			// Call the service method
			keys, svcErr := service.List(ctx, req.Prefix)
			if svcErr != nil {
				kvstoreWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := KVStoreListResponse{
				Keys: keys,
			}
			kvstoreWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newKVStoreGetStorageUsedHostFunction(service KVStoreService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"kvstore_getstorageused",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {

			// Call the service method
			bytes, svcErr := service.GetStorageUsed(ctx)
			if svcErr != nil {
				kvstoreWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := KVStoreGetStorageUsedResponse{
				Bytes: bytes,
			}
			kvstoreWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

// kvstoreWriteResponse writes a JSON response to plugin memory.
func kvstoreWriteResponse(p *extism.CurrentPlugin, stack []uint64, resp any) {
	respBytes, err := json.Marshal(resp)
	if err != nil {
		kvstoreWriteError(p, stack, err)
		return
	}
	respPtr, err := p.WriteBytes(respBytes)
	if err != nil {
		stack[0] = 0
		return
	}
	stack[0] = respPtr
}

// kvstoreWriteError writes an error response to plugin memory.
func kvstoreWriteError(p *extism.CurrentPlugin, stack []uint64, err error) {
	errResp := struct {
		Error string `json:"error"`
	}{Error: err.Error()}
	respBytes, _ := json.Marshal(errResp)
	respPtr, _ := p.WriteBytes(respBytes)
	stack[0] = respPtr
}
