//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/route/v3/route_components.proto

package routev3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"

	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort

	_ = v3.RoutingPriority(0)
)

// Validate checks the field values on VirtualHost with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *VirtualHost) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on VirtualHost with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in VirtualHostMultiError, or
// nil if none found.
func (m *VirtualHost) ValidateAll() error {
	return m.validate(true)
}

func (m *VirtualHost) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := VirtualHostValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetDomains()) < 1 {
		err := VirtualHostValidationError{
			field:  "Domains",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetDomains() {
		_, _ = idx, item

		if !_VirtualHost_Domains_Pattern.MatchString(item) {
			err := VirtualHostValidationError{
				field:  fmt.Sprintf("Domains[%v]", idx),
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	for idx, item := range m.GetRoutes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("Routes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("Routes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("Routes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetMatcher()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "Matcher",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "Matcher",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMatcher()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				field:  "Matcher",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := VirtualHost_TlsRequirementType_name[int32(m.GetRequireTls())]; !ok {
		err := VirtualHostValidationError{
			field:  "RequireTls",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetVirtualClusters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("VirtualClusters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("VirtualClusters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("VirtualClusters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetRateLimits() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("RateLimits[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("RateLimits[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("RateLimits[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetRequestHeadersToAdd()) > 1000 {
		err := VirtualHostValidationError{
			field:  "RequestHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRequestHeadersToAdd() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetRequestHeadersToRemove() {
		_, _ = idx, item

		if utf8.RuneCountInString(item) < 1 {
			err := VirtualHostValidationError{
				field:  fmt.Sprintf("RequestHeadersToRemove[%v]", idx),
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_VirtualHost_RequestHeadersToRemove_Pattern.MatchString(item) {
			err := VirtualHostValidationError{
				field:  fmt.Sprintf("RequestHeadersToRemove[%v]", idx),
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(m.GetResponseHeadersToAdd()) > 1000 {
		err := VirtualHostValidationError{
			field:  "ResponseHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetResponseHeadersToAdd() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetResponseHeadersToRemove() {
		_, _ = idx, item

		if utf8.RuneCountInString(item) < 1 {
			err := VirtualHostValidationError{
				field:  fmt.Sprintf("ResponseHeadersToRemove[%v]", idx),
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_VirtualHost_ResponseHeadersToRemove_Pattern.MatchString(item) {
			err := VirtualHostValidationError{
				field:  fmt.Sprintf("ResponseHeadersToRemove[%v]", idx),
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetCors()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "Cors",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "Cors",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCors()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				field:  "Cors",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	{
		sorted_keys := make([]string, len(m.GetTypedPerFilterConfig()))
		i := 0
		for key := range m.GetTypedPerFilterConfig() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetTypedPerFilterConfig()[key]
			_ = val

			// no validation rules for TypedPerFilterConfig[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, VirtualHostValidationError{
							field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, VirtualHostValidationError{
							field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return VirtualHostValidationError{
						field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	// no validation rules for IncludeRequestAttemptCount

	// no validation rules for IncludeAttemptCountInResponse

	if all {
		switch v := interface{}(m.GetRetryPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				field:  "RetryPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRetryPolicyTypedConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "RetryPolicyTypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "RetryPolicyTypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryPolicyTypedConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				field:  "RetryPolicyTypedConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetHedgePolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "HedgePolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "HedgePolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHedgePolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				field:  "HedgePolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for IncludeIsTimeoutRetryHeader

	if all {
		switch v := interface{}(m.GetPerRequestBufferLimitBytes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "PerRequestBufferLimitBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "PerRequestBufferLimitBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPerRequestBufferLimitBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				field:  "PerRequestBufferLimitBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetRequestMirrorPolicies() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("RequestMirrorPolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, VirtualHostValidationError{
						field:  fmt.Sprintf("RequestMirrorPolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("RequestMirrorPolicies[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, VirtualHostValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return VirtualHostMultiError(errors)
	}

	return nil
}

// VirtualHostMultiError is an error wrapping multiple validation errors
// returned by VirtualHost.ValidateAll() if the designated constraints aren't met.
type VirtualHostMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m VirtualHostMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m VirtualHostMultiError) AllErrors() []error { return m }

// VirtualHostValidationError is the validation error returned by
// VirtualHost.Validate if the designated constraints aren't met.
type VirtualHostValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e VirtualHostValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e VirtualHostValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e VirtualHostValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e VirtualHostValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e VirtualHostValidationError) ErrorName() string { return "VirtualHostValidationError" }

// Error satisfies the builtin error interface
func (e VirtualHostValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sVirtualHost.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = VirtualHostValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = VirtualHostValidationError{}

var _VirtualHost_Domains_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _VirtualHost_RequestHeadersToRemove_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _VirtualHost_ResponseHeadersToRemove_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on FilterAction with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *FilterAction) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FilterAction with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in FilterActionMultiError, or
// nil if none found.
func (m *FilterAction) ValidateAll() error {
	return m.validate(true)
}

func (m *FilterAction) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetAction()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FilterActionValidationError{
					field:  "Action",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FilterActionValidationError{
					field:  "Action",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAction()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FilterActionValidationError{
				field:  "Action",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return FilterActionMultiError(errors)
	}

	return nil
}

// FilterActionMultiError is an error wrapping multiple validation errors
// returned by FilterAction.ValidateAll() if the designated constraints aren't met.
type FilterActionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FilterActionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FilterActionMultiError) AllErrors() []error { return m }

// FilterActionValidationError is the validation error returned by
// FilterAction.Validate if the designated constraints aren't met.
type FilterActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FilterActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FilterActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FilterActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FilterActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FilterActionValidationError) ErrorName() string { return "FilterActionValidationError" }

// Error satisfies the builtin error interface
func (e FilterActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFilterAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FilterActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FilterActionValidationError{}

// Validate checks the field values on RouteList with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RouteList) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteList with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RouteListMultiError, or nil
// if none found.
func (m *RouteList) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteList) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetRoutes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteListValidationError{
						field:  fmt.Sprintf("Routes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteListValidationError{
						field:  fmt.Sprintf("Routes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteListValidationError{
					field:  fmt.Sprintf("Routes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return RouteListMultiError(errors)
	}

	return nil
}

// RouteListMultiError is an error wrapping multiple validation errors returned
// by RouteList.ValidateAll() if the designated constraints aren't met.
type RouteListMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteListMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteListMultiError) AllErrors() []error { return m }

// RouteListValidationError is the validation error returned by
// RouteList.Validate if the designated constraints aren't met.
type RouteListValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteListValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteListValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteListValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteListValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteListValidationError) ErrorName() string { return "RouteListValidationError" }

// Error satisfies the builtin error interface
func (e RouteListValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteList.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteListValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteListValidationError{}

// Validate checks the field values on Route with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Route) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Route with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in RouteMultiError, or nil if none found.
func (m *Route) ValidateAll() error {
	return m.validate(true)
}

func (m *Route) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Name

	if m.GetMatch() == nil {
		err := RouteValidationError{
			field:  "Match",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMatch()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteValidationError{
					field:  "Match",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteValidationError{
					field:  "Match",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				field:  "Match",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDecorator()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteValidationError{
					field:  "Decorator",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteValidationError{
					field:  "Decorator",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDecorator()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				field:  "Decorator",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	{
		sorted_keys := make([]string, len(m.GetTypedPerFilterConfig()))
		i := 0
		for key := range m.GetTypedPerFilterConfig() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetTypedPerFilterConfig()[key]
			_ = val

			// no validation rules for TypedPerFilterConfig[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, RouteValidationError{
							field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, RouteValidationError{
							field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return RouteValidationError{
						field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if len(m.GetRequestHeadersToAdd()) > 1000 {
		err := RouteValidationError{
			field:  "RequestHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRequestHeadersToAdd() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetRequestHeadersToRemove() {
		_, _ = idx, item

		if utf8.RuneCountInString(item) < 1 {
			err := RouteValidationError{
				field:  fmt.Sprintf("RequestHeadersToRemove[%v]", idx),
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_Route_RequestHeadersToRemove_Pattern.MatchString(item) {
			err := RouteValidationError{
				field:  fmt.Sprintf("RequestHeadersToRemove[%v]", idx),
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(m.GetResponseHeadersToAdd()) > 1000 {
		err := RouteValidationError{
			field:  "ResponseHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetResponseHeadersToAdd() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetResponseHeadersToRemove() {
		_, _ = idx, item

		if utf8.RuneCountInString(item) < 1 {
			err := RouteValidationError{
				field:  fmt.Sprintf("ResponseHeadersToRemove[%v]", idx),
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_Route_ResponseHeadersToRemove_Pattern.MatchString(item) {
			err := RouteValidationError{
				field:  fmt.Sprintf("ResponseHeadersToRemove[%v]", idx),
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetTracing()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteValidationError{
					field:  "Tracing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteValidationError{
					field:  "Tracing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTracing()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				field:  "Tracing",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPerRequestBufferLimitBytes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteValidationError{
					field:  "PerRequestBufferLimitBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteValidationError{
					field:  "PerRequestBufferLimitBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPerRequestBufferLimitBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				field:  "PerRequestBufferLimitBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for StatPrefix

	oneofActionPresent := false
	switch v := m.Action.(type) {
	case *Route_Route:
		if v == nil {
			err := RouteValidationError{
				field:  "Action",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionPresent = true

		if all {
			switch v := interface{}(m.GetRoute()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  "Route",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  "Route",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRoute()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  "Route",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Route_Redirect:
		if v == nil {
			err := RouteValidationError{
				field:  "Action",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionPresent = true

		if all {
			switch v := interface{}(m.GetRedirect()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  "Redirect",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  "Redirect",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRedirect()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  "Redirect",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Route_DirectResponse:
		if v == nil {
			err := RouteValidationError{
				field:  "Action",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionPresent = true

		if all {
			switch v := interface{}(m.GetDirectResponse()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  "DirectResponse",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  "DirectResponse",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetDirectResponse()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  "DirectResponse",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Route_FilterAction:
		if v == nil {
			err := RouteValidationError{
				field:  "Action",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionPresent = true

		if all {
			switch v := interface{}(m.GetFilterAction()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  "FilterAction",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  "FilterAction",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetFilterAction()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  "FilterAction",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Route_NonForwardingAction:
		if v == nil {
			err := RouteValidationError{
				field:  "Action",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionPresent = true

		if all {
			switch v := interface{}(m.GetNonForwardingAction()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  "NonForwardingAction",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteValidationError{
						field:  "NonForwardingAction",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetNonForwardingAction()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  "NonForwardingAction",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofActionPresent {
		err := RouteValidationError{
			field:  "Action",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RouteMultiError(errors)
	}

	return nil
}

// RouteMultiError is an error wrapping multiple validation errors returned by
// Route.ValidateAll() if the designated constraints aren't met.
type RouteMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteMultiError) AllErrors() []error { return m }

// RouteValidationError is the validation error returned by Route.Validate if
// the designated constraints aren't met.
type RouteValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteValidationError) ErrorName() string { return "RouteValidationError" }

// Error satisfies the builtin error interface
func (e RouteValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRoute.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteValidationError{}

var _Route_RequestHeadersToRemove_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _Route_ResponseHeadersToRemove_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on WeightedCluster with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *WeightedCluster) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WeightedCluster with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// WeightedClusterMultiError, or nil if none found.
func (m *WeightedCluster) ValidateAll() error {
	return m.validate(true)
}

func (m *WeightedCluster) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetClusters()) < 1 {
		err := WeightedClusterValidationError{
			field:  "Clusters",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetClusters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, WeightedClusterValidationError{
						field:  fmt.Sprintf("Clusters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, WeightedClusterValidationError{
						field:  fmt.Sprintf("Clusters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WeightedClusterValidationError{
					field:  fmt.Sprintf("Clusters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetTotalWeight()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WeightedClusterValidationError{
					field:  "TotalWeight",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WeightedClusterValidationError{
					field:  "TotalWeight",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTotalWeight()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WeightedClusterValidationError{
				field:  "TotalWeight",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for RuntimeKeyPrefix

	switch v := m.RandomValueSpecifier.(type) {
	case *WeightedCluster_HeaderName:
		if v == nil {
			err := WeightedClusterValidationError{
				field:  "RandomValueSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_WeightedCluster_HeaderName_Pattern.MatchString(m.GetHeaderName()) {
			err := WeightedClusterValidationError{
				field:  "HeaderName",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return WeightedClusterMultiError(errors)
	}

	return nil
}

// WeightedClusterMultiError is an error wrapping multiple validation errors
// returned by WeightedCluster.ValidateAll() if the designated constraints
// aren't met.
type WeightedClusterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WeightedClusterMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WeightedClusterMultiError) AllErrors() []error { return m }

// WeightedClusterValidationError is the validation error returned by
// WeightedCluster.Validate if the designated constraints aren't met.
type WeightedClusterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WeightedClusterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WeightedClusterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WeightedClusterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WeightedClusterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WeightedClusterValidationError) ErrorName() string { return "WeightedClusterValidationError" }

// Error satisfies the builtin error interface
func (e WeightedClusterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWeightedCluster.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WeightedClusterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WeightedClusterValidationError{}

var _WeightedCluster_HeaderName_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on ClusterSpecifierPlugin with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ClusterSpecifierPlugin) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ClusterSpecifierPlugin with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ClusterSpecifierPluginMultiError, or nil if none found.
func (m *ClusterSpecifierPlugin) ValidateAll() error {
	return m.validate(true)
}

func (m *ClusterSpecifierPlugin) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetExtension() == nil {
		err := ClusterSpecifierPluginValidationError{
			field:  "Extension",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetExtension()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterSpecifierPluginValidationError{
					field:  "Extension",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterSpecifierPluginValidationError{
					field:  "Extension",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetExtension()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterSpecifierPluginValidationError{
				field:  "Extension",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for IsOptional

	if len(errors) > 0 {
		return ClusterSpecifierPluginMultiError(errors)
	}

	return nil
}

// ClusterSpecifierPluginMultiError is an error wrapping multiple validation
// errors returned by ClusterSpecifierPlugin.ValidateAll() if the designated
// constraints aren't met.
type ClusterSpecifierPluginMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ClusterSpecifierPluginMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ClusterSpecifierPluginMultiError) AllErrors() []error { return m }

// ClusterSpecifierPluginValidationError is the validation error returned by
// ClusterSpecifierPlugin.Validate if the designated constraints aren't met.
type ClusterSpecifierPluginValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ClusterSpecifierPluginValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ClusterSpecifierPluginValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ClusterSpecifierPluginValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ClusterSpecifierPluginValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ClusterSpecifierPluginValidationError) ErrorName() string {
	return "ClusterSpecifierPluginValidationError"
}

// Error satisfies the builtin error interface
func (e ClusterSpecifierPluginValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sClusterSpecifierPlugin.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ClusterSpecifierPluginValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ClusterSpecifierPluginValidationError{}

// Validate checks the field values on RouteMatch with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RouteMatch) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteMatch with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RouteMatchMultiError, or
// nil if none found.
func (m *RouteMatch) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteMatch) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetCaseSensitive()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteMatchValidationError{
					field:  "CaseSensitive",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteMatchValidationError{
					field:  "CaseSensitive",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCaseSensitive()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatchValidationError{
				field:  "CaseSensitive",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRuntimeFraction()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteMatchValidationError{
					field:  "RuntimeFraction",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteMatchValidationError{
					field:  "RuntimeFraction",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRuntimeFraction()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatchValidationError{
				field:  "RuntimeFraction",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetHeaders() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  fmt.Sprintf("Headers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  fmt.Sprintf("Headers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					field:  fmt.Sprintf("Headers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetQueryParameters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  fmt.Sprintf("QueryParameters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  fmt.Sprintf("QueryParameters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					field:  fmt.Sprintf("QueryParameters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetGrpc()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteMatchValidationError{
					field:  "Grpc",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteMatchValidationError{
					field:  "Grpc",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGrpc()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatchValidationError{
				field:  "Grpc",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTlsContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteMatchValidationError{
					field:  "TlsContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteMatchValidationError{
					field:  "TlsContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTlsContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatchValidationError{
				field:  "TlsContext",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetDynamicMetadata() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  fmt.Sprintf("DynamicMetadata[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  fmt.Sprintf("DynamicMetadata[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					field:  fmt.Sprintf("DynamicMetadata[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetFilterState() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  fmt.Sprintf("FilterState[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  fmt.Sprintf("FilterState[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					field:  fmt.Sprintf("FilterState[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	oneofPathSpecifierPresent := false
	switch v := m.PathSpecifier.(type) {
	case *RouteMatch_Prefix:
		if v == nil {
			err := RouteMatchValidationError{
				field:  "PathSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPathSpecifierPresent = true
		// no validation rules for Prefix
	case *RouteMatch_Path:
		if v == nil {
			err := RouteMatchValidationError{
				field:  "PathSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPathSpecifierPresent = true
		// no validation rules for Path
	case *RouteMatch_SafeRegex:
		if v == nil {
			err := RouteMatchValidationError{
				field:  "PathSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPathSpecifierPresent = true

		if m.GetSafeRegex() == nil {
			err := RouteMatchValidationError{
				field:  "SafeRegex",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetSafeRegex()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  "SafeRegex",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  "SafeRegex",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetSafeRegex()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					field:  "SafeRegex",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RouteMatch_ConnectMatcher_:
		if v == nil {
			err := RouteMatchValidationError{
				field:  "PathSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPathSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetConnectMatcher()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  "ConnectMatcher",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  "ConnectMatcher",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetConnectMatcher()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					field:  "ConnectMatcher",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RouteMatch_PathSeparatedPrefix:
		if v == nil {
			err := RouteMatchValidationError{
				field:  "PathSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPathSpecifierPresent = true

		if !_RouteMatch_PathSeparatedPrefix_Pattern.MatchString(m.GetPathSeparatedPrefix()) {
			err := RouteMatchValidationError{
				field:  "PathSeparatedPrefix",
				reason: "value does not match regex pattern \"^[^?#]+[^?#/]$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *RouteMatch_PathMatchPolicy:
		if v == nil {
			err := RouteMatchValidationError{
				field:  "PathSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPathSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetPathMatchPolicy()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  "PathMatchPolicy",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteMatchValidationError{
						field:  "PathMatchPolicy",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetPathMatchPolicy()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					field:  "PathMatchPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofPathSpecifierPresent {
		err := RouteMatchValidationError{
			field:  "PathSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RouteMatchMultiError(errors)
	}

	return nil
}

// RouteMatchMultiError is an error wrapping multiple validation errors
// returned by RouteMatch.ValidateAll() if the designated constraints aren't met.
type RouteMatchMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteMatchMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteMatchMultiError) AllErrors() []error { return m }

// RouteMatchValidationError is the validation error returned by
// RouteMatch.Validate if the designated constraints aren't met.
type RouteMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteMatchValidationError) ErrorName() string { return "RouteMatchValidationError" }

// Error satisfies the builtin error interface
func (e RouteMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteMatchValidationError{}

var _RouteMatch_PathSeparatedPrefix_Pattern = regexp.MustCompile("^[^?#]+[^?#/]$")

// Validate checks the field values on CorsPolicy with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *CorsPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CorsPolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in CorsPolicyMultiError, or
// nil if none found.
func (m *CorsPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *CorsPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetAllowOriginStringMatch() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CorsPolicyValidationError{
						field:  fmt.Sprintf("AllowOriginStringMatch[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CorsPolicyValidationError{
						field:  fmt.Sprintf("AllowOriginStringMatch[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CorsPolicyValidationError{
					field:  fmt.Sprintf("AllowOriginStringMatch[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for AllowMethods

	// no validation rules for AllowHeaders

	// no validation rules for ExposeHeaders

	// no validation rules for MaxAge

	if all {
		switch v := interface{}(m.GetAllowCredentials()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CorsPolicyValidationError{
					field:  "AllowCredentials",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CorsPolicyValidationError{
					field:  "AllowCredentials",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAllowCredentials()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CorsPolicyValidationError{
				field:  "AllowCredentials",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetShadowEnabled()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CorsPolicyValidationError{
					field:  "ShadowEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CorsPolicyValidationError{
					field:  "ShadowEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetShadowEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CorsPolicyValidationError{
				field:  "ShadowEnabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAllowPrivateNetworkAccess()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CorsPolicyValidationError{
					field:  "AllowPrivateNetworkAccess",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CorsPolicyValidationError{
					field:  "AllowPrivateNetworkAccess",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAllowPrivateNetworkAccess()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CorsPolicyValidationError{
				field:  "AllowPrivateNetworkAccess",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetForwardNotMatchingPreflights()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CorsPolicyValidationError{
					field:  "ForwardNotMatchingPreflights",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CorsPolicyValidationError{
					field:  "ForwardNotMatchingPreflights",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetForwardNotMatchingPreflights()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CorsPolicyValidationError{
				field:  "ForwardNotMatchingPreflights",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch v := m.EnabledSpecifier.(type) {
	case *CorsPolicy_FilterEnabled:
		if v == nil {
			err := CorsPolicyValidationError{
				field:  "EnabledSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetFilterEnabled()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CorsPolicyValidationError{
						field:  "FilterEnabled",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CorsPolicyValidationError{
						field:  "FilterEnabled",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetFilterEnabled()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CorsPolicyValidationError{
					field:  "FilterEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return CorsPolicyMultiError(errors)
	}

	return nil
}

// CorsPolicyMultiError is an error wrapping multiple validation errors
// returned by CorsPolicy.ValidateAll() if the designated constraints aren't met.
type CorsPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CorsPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CorsPolicyMultiError) AllErrors() []error { return m }

// CorsPolicyValidationError is the validation error returned by
// CorsPolicy.Validate if the designated constraints aren't met.
type CorsPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CorsPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CorsPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CorsPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CorsPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CorsPolicyValidationError) ErrorName() string { return "CorsPolicyValidationError" }

// Error satisfies the builtin error interface
func (e CorsPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCorsPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CorsPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CorsPolicyValidationError{}

// Validate checks the field values on RouteAction with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RouteAction) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteAction with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RouteActionMultiError, or
// nil if none found.
func (m *RouteAction) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := RouteAction_ClusterNotFoundResponseCode_name[int32(m.GetClusterNotFoundResponseCode())]; !ok {
		err := RouteActionValidationError{
			field:  "ClusterNotFoundResponseCode",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadataMatch()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "MetadataMatch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "MetadataMatch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadataMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "MetadataMatch",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if !_RouteAction_PrefixRewrite_Pattern.MatchString(m.GetPrefixRewrite()) {
		err := RouteActionValidationError{
			field:  "PrefixRewrite",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetRegexRewrite()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "RegexRewrite",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "RegexRewrite",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRegexRewrite()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "RegexRewrite",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPathRewritePolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "PathRewritePolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "PathRewritePolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPathRewritePolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "PathRewritePolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for AppendXForwardedHost

	if all {
		switch v := interface{}(m.GetTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "Timeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "Timeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "Timeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetIdleTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "IdleTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "IdleTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetIdleTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "IdleTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetEarlyDataPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "EarlyDataPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "EarlyDataPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEarlyDataPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "EarlyDataPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRetryPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "RetryPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRetryPolicyTypedConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "RetryPolicyTypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "RetryPolicyTypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryPolicyTypedConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "RetryPolicyTypedConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetRequestMirrorPolicies() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  fmt.Sprintf("RequestMirrorPolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  fmt.Sprintf("RequestMirrorPolicies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  fmt.Sprintf("RequestMirrorPolicies[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if _, ok := v3.RoutingPriority_name[int32(m.GetPriority())]; !ok {
		err := RouteActionValidationError{
			field:  "Priority",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRateLimits() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  fmt.Sprintf("RateLimits[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  fmt.Sprintf("RateLimits[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  fmt.Sprintf("RateLimits[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetIncludeVhRateLimits()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "IncludeVhRateLimits",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "IncludeVhRateLimits",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetIncludeVhRateLimits()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "IncludeVhRateLimits",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetHashPolicy() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  fmt.Sprintf("HashPolicy[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  fmt.Sprintf("HashPolicy[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  fmt.Sprintf("HashPolicy[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetCors()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "Cors",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "Cors",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCors()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "Cors",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMaxGrpcTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "MaxGrpcTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "MaxGrpcTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxGrpcTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "MaxGrpcTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetGrpcTimeoutOffset()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "GrpcTimeoutOffset",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "GrpcTimeoutOffset",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGrpcTimeoutOffset()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "GrpcTimeoutOffset",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetUpgradeConfigs() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  fmt.Sprintf("UpgradeConfigs[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  fmt.Sprintf("UpgradeConfigs[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  fmt.Sprintf("UpgradeConfigs[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetInternalRedirectPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "InternalRedirectPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "InternalRedirectPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetInternalRedirectPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "InternalRedirectPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for InternalRedirectAction

	if all {
		switch v := interface{}(m.GetMaxInternalRedirects()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "MaxInternalRedirects",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "MaxInternalRedirects",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxInternalRedirects()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "MaxInternalRedirects",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetHedgePolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "HedgePolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "HedgePolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHedgePolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "HedgePolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMaxStreamDuration()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "MaxStreamDuration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteActionValidationError{
					field:  "MaxStreamDuration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxStreamDuration()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "MaxStreamDuration",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	oneofClusterSpecifierPresent := false
	switch v := m.ClusterSpecifier.(type) {
	case *RouteAction_Cluster:
		if v == nil {
			err := RouteActionValidationError{
				field:  "ClusterSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofClusterSpecifierPresent = true

		if utf8.RuneCountInString(m.GetCluster()) < 1 {
			err := RouteActionValidationError{
				field:  "Cluster",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *RouteAction_ClusterHeader:
		if v == nil {
			err := RouteActionValidationError{
				field:  "ClusterSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofClusterSpecifierPresent = true

		if utf8.RuneCountInString(m.GetClusterHeader()) < 1 {
			err := RouteActionValidationError{
				field:  "ClusterHeader",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_RouteAction_ClusterHeader_Pattern.MatchString(m.GetClusterHeader()) {
			err := RouteActionValidationError{
				field:  "ClusterHeader",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *RouteAction_WeightedClusters:
		if v == nil {
			err := RouteActionValidationError{
				field:  "ClusterSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofClusterSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetWeightedClusters()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  "WeightedClusters",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  "WeightedClusters",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetWeightedClusters()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  "WeightedClusters",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RouteAction_ClusterSpecifierPlugin:
		if v == nil {
			err := RouteActionValidationError{
				field:  "ClusterSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofClusterSpecifierPresent = true
		// no validation rules for ClusterSpecifierPlugin
	case *RouteAction_InlineClusterSpecifierPlugin:
		if v == nil {
			err := RouteActionValidationError{
				field:  "ClusterSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofClusterSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetInlineClusterSpecifierPlugin()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  "InlineClusterSpecifierPlugin",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  "InlineClusterSpecifierPlugin",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetInlineClusterSpecifierPlugin()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  "InlineClusterSpecifierPlugin",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofClusterSpecifierPresent {
		err := RouteActionValidationError{
			field:  "ClusterSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}
	switch v := m.HostRewriteSpecifier.(type) {
	case *RouteAction_HostRewriteLiteral:
		if v == nil {
			err := RouteActionValidationError{
				field:  "HostRewriteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_RouteAction_HostRewriteLiteral_Pattern.MatchString(m.GetHostRewriteLiteral()) {
			err := RouteActionValidationError{
				field:  "HostRewriteLiteral",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *RouteAction_AutoHostRewrite:
		if v == nil {
			err := RouteActionValidationError{
				field:  "HostRewriteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetAutoHostRewrite()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  "AutoHostRewrite",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  "AutoHostRewrite",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAutoHostRewrite()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  "AutoHostRewrite",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RouteAction_HostRewriteHeader:
		if v == nil {
			err := RouteActionValidationError{
				field:  "HostRewriteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_RouteAction_HostRewriteHeader_Pattern.MatchString(m.GetHostRewriteHeader()) {
			err := RouteActionValidationError{
				field:  "HostRewriteHeader",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *RouteAction_HostRewritePathRegex:
		if v == nil {
			err := RouteActionValidationError{
				field:  "HostRewriteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetHostRewritePathRegex()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  "HostRewritePathRegex",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteActionValidationError{
						field:  "HostRewritePathRegex",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetHostRewritePathRegex()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  "HostRewritePathRegex",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return RouteActionMultiError(errors)
	}

	return nil
}

// RouteActionMultiError is an error wrapping multiple validation errors
// returned by RouteAction.ValidateAll() if the designated constraints aren't met.
type RouteActionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteActionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteActionMultiError) AllErrors() []error { return m }

// RouteActionValidationError is the validation error returned by
// RouteAction.Validate if the designated constraints aren't met.
type RouteActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteActionValidationError) ErrorName() string { return "RouteActionValidationError" }

// Error satisfies the builtin error interface
func (e RouteActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteActionValidationError{}

var _RouteAction_ClusterHeader_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _RouteAction_PrefixRewrite_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _RouteAction_HostRewriteLiteral_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _RouteAction_HostRewriteHeader_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on RetryPolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RetryPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RetryPolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RetryPolicyMultiError, or
// nil if none found.
func (m *RetryPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *RetryPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for RetryOn

	if all {
		switch v := interface{}(m.GetNumRetries()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "NumRetries",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "NumRetries",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetNumRetries()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "NumRetries",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPerTryTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "PerTryTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "PerTryTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPerTryTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "PerTryTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPerTryIdleTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "PerTryIdleTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "PerTryIdleTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPerTryIdleTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "PerTryIdleTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRetryPriority()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "RetryPriority",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "RetryPriority",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryPriority()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "RetryPriority",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetRetryHostPredicate() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RetryPolicyValidationError{
						field:  fmt.Sprintf("RetryHostPredicate[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RetryPolicyValidationError{
						field:  fmt.Sprintf("RetryHostPredicate[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicyValidationError{
					field:  fmt.Sprintf("RetryHostPredicate[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetRetryOptionsPredicates() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RetryPolicyValidationError{
						field:  fmt.Sprintf("RetryOptionsPredicates[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RetryPolicyValidationError{
						field:  fmt.Sprintf("RetryOptionsPredicates[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicyValidationError{
					field:  fmt.Sprintf("RetryOptionsPredicates[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for HostSelectionRetryMaxAttempts

	if all {
		switch v := interface{}(m.GetRetryBackOff()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "RetryBackOff",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "RetryBackOff",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryBackOff()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "RetryBackOff",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRateLimitedRetryBackOff()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "RateLimitedRetryBackOff",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RetryPolicyValidationError{
					field:  "RateLimitedRetryBackOff",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRateLimitedRetryBackOff()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "RateLimitedRetryBackOff",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetRetriableHeaders() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RetryPolicyValidationError{
						field:  fmt.Sprintf("RetriableHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RetryPolicyValidationError{
						field:  fmt.Sprintf("RetriableHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicyValidationError{
					field:  fmt.Sprintf("RetriableHeaders[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetRetriableRequestHeaders() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RetryPolicyValidationError{
						field:  fmt.Sprintf("RetriableRequestHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RetryPolicyValidationError{
						field:  fmt.Sprintf("RetriableRequestHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicyValidationError{
					field:  fmt.Sprintf("RetriableRequestHeaders[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return RetryPolicyMultiError(errors)
	}

	return nil
}

// RetryPolicyMultiError is an error wrapping multiple validation errors
// returned by RetryPolicy.ValidateAll() if the designated constraints aren't met.
type RetryPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RetryPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RetryPolicyMultiError) AllErrors() []error { return m }

// RetryPolicyValidationError is the validation error returned by
// RetryPolicy.Validate if the designated constraints aren't met.
type RetryPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicyValidationError) ErrorName() string { return "RetryPolicyValidationError" }

// Error satisfies the builtin error interface
func (e RetryPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicyValidationError{}

// Validate checks the field values on HedgePolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HedgePolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HedgePolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HedgePolicyMultiError, or
// nil if none found.
func (m *HedgePolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *HedgePolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetInitialRequests(); wrapper != nil {

		if wrapper.GetValue() < 1 {
			err := HedgePolicyValidationError{
				field:  "InitialRequests",
				reason: "value must be greater than or equal to 1",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetAdditionalRequestChance()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HedgePolicyValidationError{
					field:  "AdditionalRequestChance",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HedgePolicyValidationError{
					field:  "AdditionalRequestChance",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAdditionalRequestChance()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HedgePolicyValidationError{
				field:  "AdditionalRequestChance",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for HedgeOnPerTryTimeout

	if len(errors) > 0 {
		return HedgePolicyMultiError(errors)
	}

	return nil
}

// HedgePolicyMultiError is an error wrapping multiple validation errors
// returned by HedgePolicy.ValidateAll() if the designated constraints aren't met.
type HedgePolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HedgePolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HedgePolicyMultiError) AllErrors() []error { return m }

// HedgePolicyValidationError is the validation error returned by
// HedgePolicy.Validate if the designated constraints aren't met.
type HedgePolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HedgePolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HedgePolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HedgePolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HedgePolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HedgePolicyValidationError) ErrorName() string { return "HedgePolicyValidationError" }

// Error satisfies the builtin error interface
func (e HedgePolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHedgePolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HedgePolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HedgePolicyValidationError{}

// Validate checks the field values on RedirectAction with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RedirectAction) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedirectAction with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RedirectActionMultiError,
// or nil if none found.
func (m *RedirectAction) ValidateAll() error {
	return m.validate(true)
}

func (m *RedirectAction) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_RedirectAction_HostRedirect_Pattern.MatchString(m.GetHostRedirect()) {
		err := RedirectActionValidationError{
			field:  "HostRedirect",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for PortRedirect

	if _, ok := RedirectAction_RedirectResponseCode_name[int32(m.GetResponseCode())]; !ok {
		err := RedirectActionValidationError{
			field:  "ResponseCode",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for StripQuery

	switch v := m.SchemeRewriteSpecifier.(type) {
	case *RedirectAction_HttpsRedirect:
		if v == nil {
			err := RedirectActionValidationError{
				field:  "SchemeRewriteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for HttpsRedirect
	case *RedirectAction_SchemeRedirect:
		if v == nil {
			err := RedirectActionValidationError{
				field:  "SchemeRewriteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for SchemeRedirect
	default:
		_ = v // ensures v is used
	}
	switch v := m.PathRewriteSpecifier.(type) {
	case *RedirectAction_PathRedirect:
		if v == nil {
			err := RedirectActionValidationError{
				field:  "PathRewriteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_RedirectAction_PathRedirect_Pattern.MatchString(m.GetPathRedirect()) {
			err := RedirectActionValidationError{
				field:  "PathRedirect",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *RedirectAction_PrefixRewrite:
		if v == nil {
			err := RedirectActionValidationError{
				field:  "PathRewriteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_RedirectAction_PrefixRewrite_Pattern.MatchString(m.GetPrefixRewrite()) {
			err := RedirectActionValidationError{
				field:  "PrefixRewrite",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *RedirectAction_RegexRewrite:
		if v == nil {
			err := RedirectActionValidationError{
				field:  "PathRewriteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetRegexRewrite()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RedirectActionValidationError{
						field:  "RegexRewrite",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RedirectActionValidationError{
						field:  "RegexRewrite",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRegexRewrite()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RedirectActionValidationError{
					field:  "RegexRewrite",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return RedirectActionMultiError(errors)
	}

	return nil
}

// RedirectActionMultiError is an error wrapping multiple validation errors
// returned by RedirectAction.ValidateAll() if the designated constraints
// aren't met.
type RedirectActionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedirectActionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedirectActionMultiError) AllErrors() []error { return m }

// RedirectActionValidationError is the validation error returned by
// RedirectAction.Validate if the designated constraints aren't met.
type RedirectActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedirectActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedirectActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedirectActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedirectActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedirectActionValidationError) ErrorName() string { return "RedirectActionValidationError" }

// Error satisfies the builtin error interface
func (e RedirectActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedirectAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedirectActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedirectActionValidationError{}

var _RedirectAction_HostRedirect_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _RedirectAction_PathRedirect_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _RedirectAction_PrefixRewrite_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on DirectResponseAction with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DirectResponseAction) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DirectResponseAction with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DirectResponseActionMultiError, or nil if none found.
func (m *DirectResponseAction) ValidateAll() error {
	return m.validate(true)
}

func (m *DirectResponseAction) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if val := m.GetStatus(); val < 200 || val >= 600 {
		err := DirectResponseActionValidationError{
			field:  "Status",
			reason: "value must be inside range [200, 600)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetBody()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DirectResponseActionValidationError{
					field:  "Body",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DirectResponseActionValidationError{
					field:  "Body",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBody()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DirectResponseActionValidationError{
				field:  "Body",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return DirectResponseActionMultiError(errors)
	}

	return nil
}

// DirectResponseActionMultiError is an error wrapping multiple validation
// errors returned by DirectResponseAction.ValidateAll() if the designated
// constraints aren't met.
type DirectResponseActionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DirectResponseActionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DirectResponseActionMultiError) AllErrors() []error { return m }

// DirectResponseActionValidationError is the validation error returned by
// DirectResponseAction.Validate if the designated constraints aren't met.
type DirectResponseActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DirectResponseActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DirectResponseActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DirectResponseActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DirectResponseActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DirectResponseActionValidationError) ErrorName() string {
	return "DirectResponseActionValidationError"
}

// Error satisfies the builtin error interface
func (e DirectResponseActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDirectResponseAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DirectResponseActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DirectResponseActionValidationError{}

// Validate checks the field values on NonForwardingAction with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *NonForwardingAction) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on NonForwardingAction with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// NonForwardingActionMultiError, or nil if none found.
func (m *NonForwardingAction) ValidateAll() error {
	return m.validate(true)
}

func (m *NonForwardingAction) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return NonForwardingActionMultiError(errors)
	}

	return nil
}

// NonForwardingActionMultiError is an error wrapping multiple validation
// errors returned by NonForwardingAction.ValidateAll() if the designated
// constraints aren't met.
type NonForwardingActionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m NonForwardingActionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m NonForwardingActionMultiError) AllErrors() []error { return m }

// NonForwardingActionValidationError is the validation error returned by
// NonForwardingAction.Validate if the designated constraints aren't met.
type NonForwardingActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e NonForwardingActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e NonForwardingActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e NonForwardingActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e NonForwardingActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e NonForwardingActionValidationError) ErrorName() string {
	return "NonForwardingActionValidationError"
}

// Error satisfies the builtin error interface
func (e NonForwardingActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sNonForwardingAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = NonForwardingActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = NonForwardingActionValidationError{}

// Validate checks the field values on Decorator with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Decorator) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Decorator with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in DecoratorMultiError, or nil
// if none found.
func (m *Decorator) ValidateAll() error {
	return m.validate(true)
}

func (m *Decorator) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetOperation()) < 1 {
		err := DecoratorValidationError{
			field:  "Operation",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetPropagate()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DecoratorValidationError{
					field:  "Propagate",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DecoratorValidationError{
					field:  "Propagate",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPropagate()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DecoratorValidationError{
				field:  "Propagate",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return DecoratorMultiError(errors)
	}

	return nil
}

// DecoratorMultiError is an error wrapping multiple validation errors returned
// by Decorator.ValidateAll() if the designated constraints aren't met.
type DecoratorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DecoratorMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DecoratorMultiError) AllErrors() []error { return m }

// DecoratorValidationError is the validation error returned by
// Decorator.Validate if the designated constraints aren't met.
type DecoratorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DecoratorValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DecoratorValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DecoratorValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DecoratorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DecoratorValidationError) ErrorName() string { return "DecoratorValidationError" }

// Error satisfies the builtin error interface
func (e DecoratorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDecorator.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DecoratorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DecoratorValidationError{}

// Validate checks the field values on Tracing with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Tracing) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Tracing with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in TracingMultiError, or nil if none found.
func (m *Tracing) ValidateAll() error {
	return m.validate(true)
}

func (m *Tracing) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetClientSampling()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TracingValidationError{
					field:  "ClientSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TracingValidationError{
					field:  "ClientSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetClientSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TracingValidationError{
				field:  "ClientSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRandomSampling()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TracingValidationError{
					field:  "RandomSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TracingValidationError{
					field:  "RandomSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRandomSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TracingValidationError{
				field:  "RandomSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetOverallSampling()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TracingValidationError{
					field:  "OverallSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TracingValidationError{
					field:  "OverallSampling",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOverallSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TracingValidationError{
				field:  "OverallSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetCustomTags() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TracingValidationError{
						field:  fmt.Sprintf("CustomTags[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TracingValidationError{
						field:  fmt.Sprintf("CustomTags[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TracingValidationError{
					field:  fmt.Sprintf("CustomTags[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return TracingMultiError(errors)
	}

	return nil
}

// TracingMultiError is an error wrapping multiple validation errors returned
// by Tracing.ValidateAll() if the designated constraints aren't met.
type TracingMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TracingMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TracingMultiError) AllErrors() []error { return m }

// TracingValidationError is the validation error returned by Tracing.Validate
// if the designated constraints aren't met.
type TracingValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TracingValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TracingValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TracingValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TracingValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TracingValidationError) ErrorName() string { return "TracingValidationError" }

// Error satisfies the builtin error interface
func (e TracingValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTracing.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TracingValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TracingValidationError{}

// Validate checks the field values on VirtualCluster with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *VirtualCluster) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on VirtualCluster with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in VirtualClusterMultiError,
// or nil if none found.
func (m *VirtualCluster) ValidateAll() error {
	return m.validate(true)
}

func (m *VirtualCluster) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetHeaders() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, VirtualClusterValidationError{
						field:  fmt.Sprintf("Headers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, VirtualClusterValidationError{
						field:  fmt.Sprintf("Headers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualClusterValidationError{
					field:  fmt.Sprintf("Headers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := VirtualClusterValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return VirtualClusterMultiError(errors)
	}

	return nil
}

// VirtualClusterMultiError is an error wrapping multiple validation errors
// returned by VirtualCluster.ValidateAll() if the designated constraints
// aren't met.
type VirtualClusterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m VirtualClusterMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m VirtualClusterMultiError) AllErrors() []error { return m }

// VirtualClusterValidationError is the validation error returned by
// VirtualCluster.Validate if the designated constraints aren't met.
type VirtualClusterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e VirtualClusterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e VirtualClusterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e VirtualClusterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e VirtualClusterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e VirtualClusterValidationError) ErrorName() string { return "VirtualClusterValidationError" }

// Error satisfies the builtin error interface
func (e VirtualClusterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sVirtualCluster.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = VirtualClusterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = VirtualClusterValidationError{}

// Validate checks the field values on RateLimit with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RateLimit) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RateLimitMultiError, or nil
// if none found.
func (m *RateLimit) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetStage(); wrapper != nil {

		if wrapper.GetValue() > 10 {
			err := RateLimitValidationError{
				field:  "Stage",
				reason: "value must be less than or equal to 10",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	// no validation rules for DisableKey

	if len(m.GetActions()) < 1 {
		err := RateLimitValidationError{
			field:  "Actions",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetActions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimitValidationError{
						field:  fmt.Sprintf("Actions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimitValidationError{
						field:  fmt.Sprintf("Actions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimitValidationError{
					field:  fmt.Sprintf("Actions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetLimit()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitValidationError{
					field:  "Limit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitValidationError{
					field:  "Limit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLimit()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitValidationError{
				field:  "Limit",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetHitsAddend()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimitValidationError{
					field:  "HitsAddend",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimitValidationError{
					field:  "HitsAddend",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHitsAddend()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimitValidationError{
				field:  "HitsAddend",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ApplyOnStreamDone

	if len(errors) > 0 {
		return RateLimitMultiError(errors)
	}

	return nil
}

// RateLimitMultiError is an error wrapping multiple validation errors returned
// by RateLimit.ValidateAll() if the designated constraints aren't met.
type RateLimitMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimitMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimitMultiError) AllErrors() []error { return m }

// RateLimitValidationError is the validation error returned by
// RateLimit.Validate if the designated constraints aren't met.
type RateLimitValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimitValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimitValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimitValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimitValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimitValidationError) ErrorName() string { return "RateLimitValidationError" }

// Error satisfies the builtin error interface
func (e RateLimitValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimitValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimitValidationError{}

// Validate checks the field values on HeaderMatcher with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HeaderMatcher) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderMatcher with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HeaderMatcherMultiError, or
// nil if none found.
func (m *HeaderMatcher) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderMatcher) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := HeaderMatcherValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_HeaderMatcher_Name_Pattern.MatchString(m.GetName()) {
		err := HeaderMatcherValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for InvertMatch

	// no validation rules for TreatMissingHeaderAsEmpty

	switch v := m.HeaderMatchSpecifier.(type) {
	case *HeaderMatcher_ExactMatch:
		if v == nil {
			err := HeaderMatcherValidationError{
				field:  "HeaderMatchSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for ExactMatch
	case *HeaderMatcher_SafeRegexMatch:
		if v == nil {
			err := HeaderMatcherValidationError{
				field:  "HeaderMatchSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetSafeRegexMatch()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HeaderMatcherValidationError{
						field:  "SafeRegexMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HeaderMatcherValidationError{
						field:  "SafeRegexMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetSafeRegexMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderMatcherValidationError{
					field:  "SafeRegexMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *HeaderMatcher_RangeMatch:
		if v == nil {
			err := HeaderMatcherValidationError{
				field:  "HeaderMatchSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetRangeMatch()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HeaderMatcherValidationError{
						field:  "RangeMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HeaderMatcherValidationError{
						field:  "RangeMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRangeMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderMatcherValidationError{
					field:  "RangeMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *HeaderMatcher_PresentMatch:
		if v == nil {
			err := HeaderMatcherValidationError{
				field:  "HeaderMatchSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for PresentMatch
	case *HeaderMatcher_PrefixMatch:
		if v == nil {
			err := HeaderMatcherValidationError{
				field:  "HeaderMatchSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if utf8.RuneCountInString(m.GetPrefixMatch()) < 1 {
			err := HeaderMatcherValidationError{
				field:  "PrefixMatch",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *HeaderMatcher_SuffixMatch:
		if v == nil {
			err := HeaderMatcherValidationError{
				field:  "HeaderMatchSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if utf8.RuneCountInString(m.GetSuffixMatch()) < 1 {
			err := HeaderMatcherValidationError{
				field:  "SuffixMatch",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *HeaderMatcher_ContainsMatch:
		if v == nil {
			err := HeaderMatcherValidationError{
				field:  "HeaderMatchSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if utf8.RuneCountInString(m.GetContainsMatch()) < 1 {
			err := HeaderMatcherValidationError{
				field:  "ContainsMatch",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *HeaderMatcher_StringMatch:
		if v == nil {
			err := HeaderMatcherValidationError{
				field:  "HeaderMatchSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetStringMatch()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HeaderMatcherValidationError{
						field:  "StringMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HeaderMatcherValidationError{
						field:  "StringMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetStringMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderMatcherValidationError{
					field:  "StringMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return HeaderMatcherMultiError(errors)
	}

	return nil
}

// HeaderMatcherMultiError is an error wrapping multiple validation errors
// returned by HeaderMatcher.ValidateAll() if the designated constraints
// aren't met.
type HeaderMatcherMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderMatcherMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderMatcherMultiError) AllErrors() []error { return m }

// HeaderMatcherValidationError is the validation error returned by
// HeaderMatcher.Validate if the designated constraints aren't met.
type HeaderMatcherValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderMatcherValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderMatcherValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderMatcherValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderMatcherValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderMatcherValidationError) ErrorName() string { return "HeaderMatcherValidationError" }

// Error satisfies the builtin error interface
func (e HeaderMatcherValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderMatcher.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderMatcherValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderMatcherValidationError{}

var _HeaderMatcher_Name_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on QueryParameterMatcher with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *QueryParameterMatcher) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on QueryParameterMatcher with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// QueryParameterMatcherMultiError, or nil if none found.
func (m *QueryParameterMatcher) ValidateAll() error {
	return m.validate(true)
}

func (m *QueryParameterMatcher) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := QueryParameterMatcherValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetName()) > 1024 {
		err := QueryParameterMatcherValidationError{
			field:  "Name",
			reason: "value length must be at most 1024 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.QueryParameterMatchSpecifier.(type) {
	case *QueryParameterMatcher_StringMatch:
		if v == nil {
			err := QueryParameterMatcherValidationError{
				field:  "QueryParameterMatchSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if m.GetStringMatch() == nil {
			err := QueryParameterMatcherValidationError{
				field:  "StringMatch",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetStringMatch()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, QueryParameterMatcherValidationError{
						field:  "StringMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, QueryParameterMatcherValidationError{
						field:  "StringMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetStringMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return QueryParameterMatcherValidationError{
					field:  "StringMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *QueryParameterMatcher_PresentMatch:
		if v == nil {
			err := QueryParameterMatcherValidationError{
				field:  "QueryParameterMatchSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for PresentMatch
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return QueryParameterMatcherMultiError(errors)
	}

	return nil
}

// QueryParameterMatcherMultiError is an error wrapping multiple validation
// errors returned by QueryParameterMatcher.ValidateAll() if the designated
// constraints aren't met.
type QueryParameterMatcherMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m QueryParameterMatcherMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m QueryParameterMatcherMultiError) AllErrors() []error { return m }

// QueryParameterMatcherValidationError is the validation error returned by
// QueryParameterMatcher.Validate if the designated constraints aren't met.
type QueryParameterMatcherValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e QueryParameterMatcherValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e QueryParameterMatcherValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e QueryParameterMatcherValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e QueryParameterMatcherValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e QueryParameterMatcherValidationError) ErrorName() string {
	return "QueryParameterMatcherValidationError"
}

// Error satisfies the builtin error interface
func (e QueryParameterMatcherValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sQueryParameterMatcher.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = QueryParameterMatcherValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = QueryParameterMatcherValidationError{}

// Validate checks the field values on InternalRedirectPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *InternalRedirectPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on InternalRedirectPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// InternalRedirectPolicyMultiError, or nil if none found.
func (m *InternalRedirectPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *InternalRedirectPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetMaxInternalRedirects()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, InternalRedirectPolicyValidationError{
					field:  "MaxInternalRedirects",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, InternalRedirectPolicyValidationError{
					field:  "MaxInternalRedirects",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxInternalRedirects()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return InternalRedirectPolicyValidationError{
				field:  "MaxInternalRedirects",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetRedirectResponseCodes()) > 5 {
		err := InternalRedirectPolicyValidationError{
			field:  "RedirectResponseCodes",
			reason: "value must contain no more than 5 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetPredicates() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, InternalRedirectPolicyValidationError{
						field:  fmt.Sprintf("Predicates[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, InternalRedirectPolicyValidationError{
						field:  fmt.Sprintf("Predicates[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return InternalRedirectPolicyValidationError{
					field:  fmt.Sprintf("Predicates[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for AllowCrossSchemeRedirect

	_InternalRedirectPolicy_ResponseHeadersToCopy_Unique := make(map[string]struct{}, len(m.GetResponseHeadersToCopy()))

	for idx, item := range m.GetResponseHeadersToCopy() {
		_, _ = idx, item

		if _, exists := _InternalRedirectPolicy_ResponseHeadersToCopy_Unique[item]; exists {
			err := InternalRedirectPolicyValidationError{
				field:  fmt.Sprintf("ResponseHeadersToCopy[%v]", idx),
				reason: "repeated value must contain unique items",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {
			_InternalRedirectPolicy_ResponseHeadersToCopy_Unique[item] = struct{}{}
		}

		if !_InternalRedirectPolicy_ResponseHeadersToCopy_Pattern.MatchString(item) {
			err := InternalRedirectPolicyValidationError{
				field:  fmt.Sprintf("ResponseHeadersToCopy[%v]", idx),
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return InternalRedirectPolicyMultiError(errors)
	}

	return nil
}

// InternalRedirectPolicyMultiError is an error wrapping multiple validation
// errors returned by InternalRedirectPolicy.ValidateAll() if the designated
// constraints aren't met.
type InternalRedirectPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m InternalRedirectPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m InternalRedirectPolicyMultiError) AllErrors() []error { return m }

// InternalRedirectPolicyValidationError is the validation error returned by
// InternalRedirectPolicy.Validate if the designated constraints aren't met.
type InternalRedirectPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e InternalRedirectPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e InternalRedirectPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e InternalRedirectPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e InternalRedirectPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e InternalRedirectPolicyValidationError) ErrorName() string {
	return "InternalRedirectPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e InternalRedirectPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sInternalRedirectPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = InternalRedirectPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = InternalRedirectPolicyValidationError{}

var _InternalRedirectPolicy_ResponseHeadersToCopy_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on FilterConfig with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *FilterConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FilterConfig with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in FilterConfigMultiError, or
// nil if none found.
func (m *FilterConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *FilterConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FilterConfigValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FilterConfigValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FilterConfigValidationError{
				field:  "Config",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for IsOptional

	// no validation rules for Disabled

	if len(errors) > 0 {
		return FilterConfigMultiError(errors)
	}

	return nil
}

// FilterConfigMultiError is an error wrapping multiple validation errors
// returned by FilterConfig.ValidateAll() if the designated constraints aren't met.
type FilterConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FilterConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FilterConfigMultiError) AllErrors() []error { return m }

// FilterConfigValidationError is the validation error returned by
// FilterConfig.Validate if the designated constraints aren't met.
type FilterConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FilterConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FilterConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FilterConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FilterConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FilterConfigValidationError) ErrorName() string { return "FilterConfigValidationError" }

// Error satisfies the builtin error interface
func (e FilterConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFilterConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FilterConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FilterConfigValidationError{}

// Validate checks the field values on WeightedCluster_ClusterWeight with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *WeightedCluster_ClusterWeight) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WeightedCluster_ClusterWeight with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// WeightedCluster_ClusterWeightMultiError, or nil if none found.
func (m *WeightedCluster_ClusterWeight) ValidateAll() error {
	return m.validate(true)
}

func (m *WeightedCluster_ClusterWeight) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Name

	if !_WeightedCluster_ClusterWeight_ClusterHeader_Pattern.MatchString(m.GetClusterHeader()) {
		err := WeightedCluster_ClusterWeightValidationError{
			field:  "ClusterHeader",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetWeight()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WeightedCluster_ClusterWeightValidationError{
					field:  "Weight",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WeightedCluster_ClusterWeightValidationError{
					field:  "Weight",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetWeight()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WeightedCluster_ClusterWeightValidationError{
				field:  "Weight",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMetadataMatch()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WeightedCluster_ClusterWeightValidationError{
					field:  "MetadataMatch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WeightedCluster_ClusterWeightValidationError{
					field:  "MetadataMatch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadataMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WeightedCluster_ClusterWeightValidationError{
				field:  "MetadataMatch",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetRequestHeadersToAdd()) > 1000 {
		err := WeightedCluster_ClusterWeightValidationError{
			field:  "RequestHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRequestHeadersToAdd() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, WeightedCluster_ClusterWeightValidationError{
						field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, WeightedCluster_ClusterWeightValidationError{
						field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WeightedCluster_ClusterWeightValidationError{
					field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetRequestHeadersToRemove() {
		_, _ = idx, item

		if !_WeightedCluster_ClusterWeight_RequestHeadersToRemove_Pattern.MatchString(item) {
			err := WeightedCluster_ClusterWeightValidationError{
				field:  fmt.Sprintf("RequestHeadersToRemove[%v]", idx),
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(m.GetResponseHeadersToAdd()) > 1000 {
		err := WeightedCluster_ClusterWeightValidationError{
			field:  "ResponseHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetResponseHeadersToAdd() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, WeightedCluster_ClusterWeightValidationError{
						field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, WeightedCluster_ClusterWeightValidationError{
						field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WeightedCluster_ClusterWeightValidationError{
					field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetResponseHeadersToRemove() {
		_, _ = idx, item

		if !_WeightedCluster_ClusterWeight_ResponseHeadersToRemove_Pattern.MatchString(item) {
			err := WeightedCluster_ClusterWeightValidationError{
				field:  fmt.Sprintf("ResponseHeadersToRemove[%v]", idx),
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	{
		sorted_keys := make([]string, len(m.GetTypedPerFilterConfig()))
		i := 0
		for key := range m.GetTypedPerFilterConfig() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetTypedPerFilterConfig()[key]
			_ = val

			// no validation rules for TypedPerFilterConfig[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, WeightedCluster_ClusterWeightValidationError{
							field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, WeightedCluster_ClusterWeightValidationError{
							field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return WeightedCluster_ClusterWeightValidationError{
						field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	switch v := m.HostRewriteSpecifier.(type) {
	case *WeightedCluster_ClusterWeight_HostRewriteLiteral:
		if v == nil {
			err := WeightedCluster_ClusterWeightValidationError{
				field:  "HostRewriteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_WeightedCluster_ClusterWeight_HostRewriteLiteral_Pattern.MatchString(m.GetHostRewriteLiteral()) {
			err := WeightedCluster_ClusterWeightValidationError{
				field:  "HostRewriteLiteral",
				reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return WeightedCluster_ClusterWeightMultiError(errors)
	}

	return nil
}

// WeightedCluster_ClusterWeightMultiError is an error wrapping multiple
// validation errors returned by WeightedCluster_ClusterWeight.ValidateAll()
// if the designated constraints aren't met.
type WeightedCluster_ClusterWeightMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WeightedCluster_ClusterWeightMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WeightedCluster_ClusterWeightMultiError) AllErrors() []error { return m }

// WeightedCluster_ClusterWeightValidationError is the validation error
// returned by WeightedCluster_ClusterWeight.Validate if the designated
// constraints aren't met.
type WeightedCluster_ClusterWeightValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WeightedCluster_ClusterWeightValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WeightedCluster_ClusterWeightValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WeightedCluster_ClusterWeightValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WeightedCluster_ClusterWeightValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WeightedCluster_ClusterWeightValidationError) ErrorName() string {
	return "WeightedCluster_ClusterWeightValidationError"
}

// Error satisfies the builtin error interface
func (e WeightedCluster_ClusterWeightValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWeightedCluster_ClusterWeight.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WeightedCluster_ClusterWeightValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WeightedCluster_ClusterWeightValidationError{}

var _WeightedCluster_ClusterWeight_ClusterHeader_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _WeightedCluster_ClusterWeight_RequestHeadersToRemove_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _WeightedCluster_ClusterWeight_ResponseHeadersToRemove_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _WeightedCluster_ClusterWeight_HostRewriteLiteral_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on RouteMatch_GrpcRouteMatchOptions with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *RouteMatch_GrpcRouteMatchOptions) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteMatch_GrpcRouteMatchOptions with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RouteMatch_GrpcRouteMatchOptionsMultiError, or nil if none found.
func (m *RouteMatch_GrpcRouteMatchOptions) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteMatch_GrpcRouteMatchOptions) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return RouteMatch_GrpcRouteMatchOptionsMultiError(errors)
	}

	return nil
}

// RouteMatch_GrpcRouteMatchOptionsMultiError is an error wrapping multiple
// validation errors returned by
// RouteMatch_GrpcRouteMatchOptions.ValidateAll() if the designated
// constraints aren't met.
type RouteMatch_GrpcRouteMatchOptionsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteMatch_GrpcRouteMatchOptionsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteMatch_GrpcRouteMatchOptionsMultiError) AllErrors() []error { return m }

// RouteMatch_GrpcRouteMatchOptionsValidationError is the validation error
// returned by RouteMatch_GrpcRouteMatchOptions.Validate if the designated
// constraints aren't met.
type RouteMatch_GrpcRouteMatchOptionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) ErrorName() string {
	return "RouteMatch_GrpcRouteMatchOptionsValidationError"
}

// Error satisfies the builtin error interface
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteMatch_GrpcRouteMatchOptions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteMatch_GrpcRouteMatchOptionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteMatch_GrpcRouteMatchOptionsValidationError{}

// Validate checks the field values on RouteMatch_TlsContextMatchOptions with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *RouteMatch_TlsContextMatchOptions) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteMatch_TlsContextMatchOptions
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// RouteMatch_TlsContextMatchOptionsMultiError, or nil if none found.
func (m *RouteMatch_TlsContextMatchOptions) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteMatch_TlsContextMatchOptions) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetPresented()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteMatch_TlsContextMatchOptionsValidationError{
					field:  "Presented",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteMatch_TlsContextMatchOptionsValidationError{
					field:  "Presented",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPresented()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatch_TlsContextMatchOptionsValidationError{
				field:  "Presented",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetValidated()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteMatch_TlsContextMatchOptionsValidationError{
					field:  "Validated",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteMatch_TlsContextMatchOptionsValidationError{
					field:  "Validated",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetValidated()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatch_TlsContextMatchOptionsValidationError{
				field:  "Validated",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RouteMatch_TlsContextMatchOptionsMultiError(errors)
	}

	return nil
}

// RouteMatch_TlsContextMatchOptionsMultiError is an error wrapping multiple
// validation errors returned by
// RouteMatch_TlsContextMatchOptions.ValidateAll() if the designated
// constraints aren't met.
type RouteMatch_TlsContextMatchOptionsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteMatch_TlsContextMatchOptionsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteMatch_TlsContextMatchOptionsMultiError) AllErrors() []error { return m }

// RouteMatch_TlsContextMatchOptionsValidationError is the validation error
// returned by RouteMatch_TlsContextMatchOptions.Validate if the designated
// constraints aren't met.
type RouteMatch_TlsContextMatchOptionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteMatch_TlsContextMatchOptionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteMatch_TlsContextMatchOptionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteMatch_TlsContextMatchOptionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteMatch_TlsContextMatchOptionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteMatch_TlsContextMatchOptionsValidationError) ErrorName() string {
	return "RouteMatch_TlsContextMatchOptionsValidationError"
}

// Error satisfies the builtin error interface
func (e RouteMatch_TlsContextMatchOptionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteMatch_TlsContextMatchOptions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteMatch_TlsContextMatchOptionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteMatch_TlsContextMatchOptionsValidationError{}

// Validate checks the field values on RouteMatch_ConnectMatcher with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RouteMatch_ConnectMatcher) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteMatch_ConnectMatcher with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RouteMatch_ConnectMatcherMultiError, or nil if none found.
func (m *RouteMatch_ConnectMatcher) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteMatch_ConnectMatcher) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return RouteMatch_ConnectMatcherMultiError(errors)
	}

	return nil
}

// RouteMatch_ConnectMatcherMultiError is an error wrapping multiple validation
// errors returned by RouteMatch_ConnectMatcher.ValidateAll() if the
// designated constraints aren't met.
type RouteMatch_ConnectMatcherMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteMatch_ConnectMatcherMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteMatch_ConnectMatcherMultiError) AllErrors() []error { return m }

// RouteMatch_ConnectMatcherValidationError is the validation error returned by
// RouteMatch_ConnectMatcher.Validate if the designated constraints aren't met.
type RouteMatch_ConnectMatcherValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteMatch_ConnectMatcherValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteMatch_ConnectMatcherValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteMatch_ConnectMatcherValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteMatch_ConnectMatcherValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteMatch_ConnectMatcherValidationError) ErrorName() string {
	return "RouteMatch_ConnectMatcherValidationError"
}

// Error satisfies the builtin error interface
func (e RouteMatch_ConnectMatcherValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteMatch_ConnectMatcher.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteMatch_ConnectMatcherValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteMatch_ConnectMatcherValidationError{}

// Validate checks the field values on RouteAction_RequestMirrorPolicy with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RouteAction_RequestMirrorPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteAction_RequestMirrorPolicy with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RouteAction_RequestMirrorPolicyMultiError, or nil if none found.
func (m *RouteAction_RequestMirrorPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction_RequestMirrorPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Cluster

	if !_RouteAction_RequestMirrorPolicy_ClusterHeader_Pattern.MatchString(m.GetClusterHeader()) {
		err := RouteAction_RequestMirrorPolicyValidationError{
			field:  "ClusterHeader",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetRuntimeFraction()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteAction_RequestMirrorPolicyValidationError{
					field:  "RuntimeFraction",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteAction_RequestMirrorPolicyValidationError{
					field:  "RuntimeFraction",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRuntimeFraction()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_RequestMirrorPolicyValidationError{
				field:  "RuntimeFraction",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTraceSampled()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteAction_RequestMirrorPolicyValidationError{
					field:  "TraceSampled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteAction_RequestMirrorPolicyValidationError{
					field:  "TraceSampled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTraceSampled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_RequestMirrorPolicyValidationError{
				field:  "TraceSampled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for DisableShadowHostSuffixAppend

	if len(errors) > 0 {
		return RouteAction_RequestMirrorPolicyMultiError(errors)
	}

	return nil
}

// RouteAction_RequestMirrorPolicyMultiError is an error wrapping multiple
// validation errors returned by RouteAction_RequestMirrorPolicy.ValidateAll()
// if the designated constraints aren't met.
type RouteAction_RequestMirrorPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteAction_RequestMirrorPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteAction_RequestMirrorPolicyMultiError) AllErrors() []error { return m }

// RouteAction_RequestMirrorPolicyValidationError is the validation error
// returned by RouteAction_RequestMirrorPolicy.Validate if the designated
// constraints aren't met.
type RouteAction_RequestMirrorPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_RequestMirrorPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_RequestMirrorPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_RequestMirrorPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_RequestMirrorPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_RequestMirrorPolicyValidationError) ErrorName() string {
	return "RouteAction_RequestMirrorPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_RequestMirrorPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_RequestMirrorPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_RequestMirrorPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_RequestMirrorPolicyValidationError{}

var _RouteAction_RequestMirrorPolicy_ClusterHeader_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on RouteAction_HashPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RouteAction_HashPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteAction_HashPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RouteAction_HashPolicyMultiError, or nil if none found.
func (m *RouteAction_HashPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction_HashPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Terminal

	oneofPolicySpecifierPresent := false
	switch v := m.PolicySpecifier.(type) {
	case *RouteAction_HashPolicy_Header_:
		if v == nil {
			err := RouteAction_HashPolicyValidationError{
				field:  "PolicySpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPolicySpecifierPresent = true

		if all {
			switch v := interface{}(m.GetHeader()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteAction_HashPolicyValidationError{
						field:  "Header",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteAction_HashPolicyValidationError{
						field:  "Header",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetHeader()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicyValidationError{
					field:  "Header",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RouteAction_HashPolicy_Cookie_:
		if v == nil {
			err := RouteAction_HashPolicyValidationError{
				field:  "PolicySpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPolicySpecifierPresent = true

		if all {
			switch v := interface{}(m.GetCookie()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteAction_HashPolicyValidationError{
						field:  "Cookie",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteAction_HashPolicyValidationError{
						field:  "Cookie",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetCookie()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicyValidationError{
					field:  "Cookie",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RouteAction_HashPolicy_ConnectionProperties_:
		if v == nil {
			err := RouteAction_HashPolicyValidationError{
				field:  "PolicySpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPolicySpecifierPresent = true

		if all {
			switch v := interface{}(m.GetConnectionProperties()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteAction_HashPolicyValidationError{
						field:  "ConnectionProperties",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteAction_HashPolicyValidationError{
						field:  "ConnectionProperties",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetConnectionProperties()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicyValidationError{
					field:  "ConnectionProperties",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RouteAction_HashPolicy_QueryParameter_:
		if v == nil {
			err := RouteAction_HashPolicyValidationError{
				field:  "PolicySpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPolicySpecifierPresent = true

		if all {
			switch v := interface{}(m.GetQueryParameter()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteAction_HashPolicyValidationError{
						field:  "QueryParameter",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteAction_HashPolicyValidationError{
						field:  "QueryParameter",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetQueryParameter()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicyValidationError{
					field:  "QueryParameter",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RouteAction_HashPolicy_FilterState_:
		if v == nil {
			err := RouteAction_HashPolicyValidationError{
				field:  "PolicySpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPolicySpecifierPresent = true

		if all {
			switch v := interface{}(m.GetFilterState()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteAction_HashPolicyValidationError{
						field:  "FilterState",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteAction_HashPolicyValidationError{
						field:  "FilterState",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetFilterState()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicyValidationError{
					field:  "FilterState",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofPolicySpecifierPresent {
		err := RouteAction_HashPolicyValidationError{
			field:  "PolicySpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RouteAction_HashPolicyMultiError(errors)
	}

	return nil
}

// RouteAction_HashPolicyMultiError is an error wrapping multiple validation
// errors returned by RouteAction_HashPolicy.ValidateAll() if the designated
// constraints aren't met.
type RouteAction_HashPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteAction_HashPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteAction_HashPolicyMultiError) AllErrors() []error { return m }

// RouteAction_HashPolicyValidationError is the validation error returned by
// RouteAction_HashPolicy.Validate if the designated constraints aren't met.
type RouteAction_HashPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_HashPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_HashPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_HashPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_HashPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_HashPolicyValidationError) ErrorName() string {
	return "RouteAction_HashPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_HashPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_HashPolicyValidationError{}

// Validate checks the field values on RouteAction_UpgradeConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RouteAction_UpgradeConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteAction_UpgradeConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RouteAction_UpgradeConfigMultiError, or nil if none found.
func (m *RouteAction_UpgradeConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction_UpgradeConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetUpgradeType()) < 1 {
		err := RouteAction_UpgradeConfigValidationError{
			field:  "UpgradeType",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RouteAction_UpgradeConfig_UpgradeType_Pattern.MatchString(m.GetUpgradeType()) {
		err := RouteAction_UpgradeConfigValidationError{
			field:  "UpgradeType",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetEnabled()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteAction_UpgradeConfigValidationError{
					field:  "Enabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteAction_UpgradeConfigValidationError{
					field:  "Enabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_UpgradeConfigValidationError{
				field:  "Enabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetConnectConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteAction_UpgradeConfigValidationError{
					field:  "ConnectConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteAction_UpgradeConfigValidationError{
					field:  "ConnectConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConnectConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_UpgradeConfigValidationError{
				field:  "ConnectConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RouteAction_UpgradeConfigMultiError(errors)
	}

	return nil
}

// RouteAction_UpgradeConfigMultiError is an error wrapping multiple validation
// errors returned by RouteAction_UpgradeConfig.ValidateAll() if the
// designated constraints aren't met.
type RouteAction_UpgradeConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteAction_UpgradeConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteAction_UpgradeConfigMultiError) AllErrors() []error { return m }

// RouteAction_UpgradeConfigValidationError is the validation error returned by
// RouteAction_UpgradeConfig.Validate if the designated constraints aren't met.
type RouteAction_UpgradeConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_UpgradeConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_UpgradeConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_UpgradeConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_UpgradeConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_UpgradeConfigValidationError) ErrorName() string {
	return "RouteAction_UpgradeConfigValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_UpgradeConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_UpgradeConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_UpgradeConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_UpgradeConfigValidationError{}

var _RouteAction_UpgradeConfig_UpgradeType_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on RouteAction_MaxStreamDuration with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RouteAction_MaxStreamDuration) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteAction_MaxStreamDuration with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RouteAction_MaxStreamDurationMultiError, or nil if none found.
func (m *RouteAction_MaxStreamDuration) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction_MaxStreamDuration) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetMaxStreamDuration()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteAction_MaxStreamDurationValidationError{
					field:  "MaxStreamDuration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteAction_MaxStreamDurationValidationError{
					field:  "MaxStreamDuration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxStreamDuration()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_MaxStreamDurationValidationError{
				field:  "MaxStreamDuration",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetGrpcTimeoutHeaderMax()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteAction_MaxStreamDurationValidationError{
					field:  "GrpcTimeoutHeaderMax",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteAction_MaxStreamDurationValidationError{
					field:  "GrpcTimeoutHeaderMax",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGrpcTimeoutHeaderMax()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_MaxStreamDurationValidationError{
				field:  "GrpcTimeoutHeaderMax",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetGrpcTimeoutHeaderOffset()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteAction_MaxStreamDurationValidationError{
					field:  "GrpcTimeoutHeaderOffset",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteAction_MaxStreamDurationValidationError{
					field:  "GrpcTimeoutHeaderOffset",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGrpcTimeoutHeaderOffset()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_MaxStreamDurationValidationError{
				field:  "GrpcTimeoutHeaderOffset",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RouteAction_MaxStreamDurationMultiError(errors)
	}

	return nil
}

// RouteAction_MaxStreamDurationMultiError is an error wrapping multiple
// validation errors returned by RouteAction_MaxStreamDuration.ValidateAll()
// if the designated constraints aren't met.
type RouteAction_MaxStreamDurationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteAction_MaxStreamDurationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteAction_MaxStreamDurationMultiError) AllErrors() []error { return m }

// RouteAction_MaxStreamDurationValidationError is the validation error
// returned by RouteAction_MaxStreamDuration.Validate if the designated
// constraints aren't met.
type RouteAction_MaxStreamDurationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_MaxStreamDurationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_MaxStreamDurationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_MaxStreamDurationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_MaxStreamDurationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_MaxStreamDurationValidationError) ErrorName() string {
	return "RouteAction_MaxStreamDurationValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_MaxStreamDurationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_MaxStreamDuration.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_MaxStreamDurationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_MaxStreamDurationValidationError{}

// Validate checks the field values on RouteAction_HashPolicy_Header with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RouteAction_HashPolicy_Header) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteAction_HashPolicy_Header with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RouteAction_HashPolicy_HeaderMultiError, or nil if none found.
func (m *RouteAction_HashPolicy_Header) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction_HashPolicy_Header) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetHeaderName()) < 1 {
		err := RouteAction_HashPolicy_HeaderValidationError{
			field:  "HeaderName",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RouteAction_HashPolicy_Header_HeaderName_Pattern.MatchString(m.GetHeaderName()) {
		err := RouteAction_HashPolicy_HeaderValidationError{
			field:  "HeaderName",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetRegexRewrite()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteAction_HashPolicy_HeaderValidationError{
					field:  "RegexRewrite",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteAction_HashPolicy_HeaderValidationError{
					field:  "RegexRewrite",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRegexRewrite()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_HashPolicy_HeaderValidationError{
				field:  "RegexRewrite",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RouteAction_HashPolicy_HeaderMultiError(errors)
	}

	return nil
}

// RouteAction_HashPolicy_HeaderMultiError is an error wrapping multiple
// validation errors returned by RouteAction_HashPolicy_Header.ValidateAll()
// if the designated constraints aren't met.
type RouteAction_HashPolicy_HeaderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteAction_HashPolicy_HeaderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteAction_HashPolicy_HeaderMultiError) AllErrors() []error { return m }

// RouteAction_HashPolicy_HeaderValidationError is the validation error
// returned by RouteAction_HashPolicy_Header.Validate if the designated
// constraints aren't met.
type RouteAction_HashPolicy_HeaderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_HashPolicy_HeaderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_HashPolicy_HeaderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_HashPolicy_HeaderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_HashPolicy_HeaderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_HashPolicy_HeaderValidationError) ErrorName() string {
	return "RouteAction_HashPolicy_HeaderValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_HeaderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_Header.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_HashPolicy_HeaderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_HashPolicy_HeaderValidationError{}

var _RouteAction_HashPolicy_Header_HeaderName_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on RouteAction_HashPolicy_CookieAttribute
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *RouteAction_HashPolicy_CookieAttribute) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RouteAction_HashPolicy_CookieAttribute with the rules defined in the proto
// definition for this message. If any rules are violated, the result is a
// list of violation errors wrapped in
// RouteAction_HashPolicy_CookieAttributeMultiError, or nil if none found.
func (m *RouteAction_HashPolicy_CookieAttribute) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction_HashPolicy_CookieAttribute) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := RouteAction_HashPolicy_CookieAttributeValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetName()) > 16384 {
		err := RouteAction_HashPolicy_CookieAttributeValidationError{
			field:  "Name",
			reason: "value length must be at most 16384 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RouteAction_HashPolicy_CookieAttribute_Name_Pattern.MatchString(m.GetName()) {
		err := RouteAction_HashPolicy_CookieAttributeValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetValue()) > 16384 {
		err := RouteAction_HashPolicy_CookieAttributeValidationError{
			field:  "Value",
			reason: "value length must be at most 16384 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RouteAction_HashPolicy_CookieAttribute_Value_Pattern.MatchString(m.GetValue()) {
		err := RouteAction_HashPolicy_CookieAttributeValidationError{
			field:  "Value",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RouteAction_HashPolicy_CookieAttributeMultiError(errors)
	}

	return nil
}

// RouteAction_HashPolicy_CookieAttributeMultiError is an error wrapping
// multiple validation errors returned by
// RouteAction_HashPolicy_CookieAttribute.ValidateAll() if the designated
// constraints aren't met.
type RouteAction_HashPolicy_CookieAttributeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteAction_HashPolicy_CookieAttributeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteAction_HashPolicy_CookieAttributeMultiError) AllErrors() []error { return m }

// RouteAction_HashPolicy_CookieAttributeValidationError is the validation
// error returned by RouteAction_HashPolicy_CookieAttribute.Validate if the
// designated constraints aren't met.
type RouteAction_HashPolicy_CookieAttributeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_HashPolicy_CookieAttributeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_HashPolicy_CookieAttributeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_HashPolicy_CookieAttributeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_HashPolicy_CookieAttributeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_HashPolicy_CookieAttributeValidationError) ErrorName() string {
	return "RouteAction_HashPolicy_CookieAttributeValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_CookieAttributeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_CookieAttribute.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_HashPolicy_CookieAttributeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_HashPolicy_CookieAttributeValidationError{}

var _RouteAction_HashPolicy_CookieAttribute_Name_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _RouteAction_HashPolicy_CookieAttribute_Value_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on RouteAction_HashPolicy_Cookie with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RouteAction_HashPolicy_Cookie) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteAction_HashPolicy_Cookie with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RouteAction_HashPolicy_CookieMultiError, or nil if none found.
func (m *RouteAction_HashPolicy_Cookie) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction_HashPolicy_Cookie) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := RouteAction_HashPolicy_CookieValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTtl()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteAction_HashPolicy_CookieValidationError{
					field:  "Ttl",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteAction_HashPolicy_CookieValidationError{
					field:  "Ttl",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTtl()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_HashPolicy_CookieValidationError{
				field:  "Ttl",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Path

	for idx, item := range m.GetAttributes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RouteAction_HashPolicy_CookieValidationError{
						field:  fmt.Sprintf("Attributes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RouteAction_HashPolicy_CookieValidationError{
						field:  fmt.Sprintf("Attributes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicy_CookieValidationError{
					field:  fmt.Sprintf("Attributes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return RouteAction_HashPolicy_CookieMultiError(errors)
	}

	return nil
}

// RouteAction_HashPolicy_CookieMultiError is an error wrapping multiple
// validation errors returned by RouteAction_HashPolicy_Cookie.ValidateAll()
// if the designated constraints aren't met.
type RouteAction_HashPolicy_CookieMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteAction_HashPolicy_CookieMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteAction_HashPolicy_CookieMultiError) AllErrors() []error { return m }

// RouteAction_HashPolicy_CookieValidationError is the validation error
// returned by RouteAction_HashPolicy_Cookie.Validate if the designated
// constraints aren't met.
type RouteAction_HashPolicy_CookieValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_HashPolicy_CookieValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_HashPolicy_CookieValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_HashPolicy_CookieValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_HashPolicy_CookieValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_HashPolicy_CookieValidationError) ErrorName() string {
	return "RouteAction_HashPolicy_CookieValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_CookieValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_Cookie.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_HashPolicy_CookieValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_HashPolicy_CookieValidationError{}

// Validate checks the field values on
// RouteAction_HashPolicy_ConnectionProperties with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RouteAction_HashPolicy_ConnectionProperties) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RouteAction_HashPolicy_ConnectionProperties with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// RouteAction_HashPolicy_ConnectionPropertiesMultiError, or nil if none found.
func (m *RouteAction_HashPolicy_ConnectionProperties) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction_HashPolicy_ConnectionProperties) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SourceIp

	if len(errors) > 0 {
		return RouteAction_HashPolicy_ConnectionPropertiesMultiError(errors)
	}

	return nil
}

// RouteAction_HashPolicy_ConnectionPropertiesMultiError is an error wrapping
// multiple validation errors returned by
// RouteAction_HashPolicy_ConnectionProperties.ValidateAll() if the designated
// constraints aren't met.
type RouteAction_HashPolicy_ConnectionPropertiesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteAction_HashPolicy_ConnectionPropertiesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteAction_HashPolicy_ConnectionPropertiesMultiError) AllErrors() []error { return m }

// RouteAction_HashPolicy_ConnectionPropertiesValidationError is the validation
// error returned by RouteAction_HashPolicy_ConnectionProperties.Validate if
// the designated constraints aren't met.
type RouteAction_HashPolicy_ConnectionPropertiesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) ErrorName() string {
	return "RouteAction_HashPolicy_ConnectionPropertiesValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_ConnectionProperties.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_HashPolicy_ConnectionPropertiesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_HashPolicy_ConnectionPropertiesValidationError{}

// Validate checks the field values on RouteAction_HashPolicy_QueryParameter
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *RouteAction_HashPolicy_QueryParameter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteAction_HashPolicy_QueryParameter
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// RouteAction_HashPolicy_QueryParameterMultiError, or nil if none found.
func (m *RouteAction_HashPolicy_QueryParameter) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction_HashPolicy_QueryParameter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := RouteAction_HashPolicy_QueryParameterValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RouteAction_HashPolicy_QueryParameterMultiError(errors)
	}

	return nil
}

// RouteAction_HashPolicy_QueryParameterMultiError is an error wrapping
// multiple validation errors returned by
// RouteAction_HashPolicy_QueryParameter.ValidateAll() if the designated
// constraints aren't met.
type RouteAction_HashPolicy_QueryParameterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteAction_HashPolicy_QueryParameterMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteAction_HashPolicy_QueryParameterMultiError) AllErrors() []error { return m }

// RouteAction_HashPolicy_QueryParameterValidationError is the validation error
// returned by RouteAction_HashPolicy_QueryParameter.Validate if the
// designated constraints aren't met.
type RouteAction_HashPolicy_QueryParameterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_HashPolicy_QueryParameterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_HashPolicy_QueryParameterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_HashPolicy_QueryParameterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_HashPolicy_QueryParameterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_HashPolicy_QueryParameterValidationError) ErrorName() string {
	return "RouteAction_HashPolicy_QueryParameterValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_QueryParameterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_QueryParameter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_HashPolicy_QueryParameterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_HashPolicy_QueryParameterValidationError{}

// Validate checks the field values on RouteAction_HashPolicy_FilterState with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *RouteAction_HashPolicy_FilterState) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RouteAction_HashPolicy_FilterState
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// RouteAction_HashPolicy_FilterStateMultiError, or nil if none found.
func (m *RouteAction_HashPolicy_FilterState) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction_HashPolicy_FilterState) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetKey()) < 1 {
		err := RouteAction_HashPolicy_FilterStateValidationError{
			field:  "Key",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RouteAction_HashPolicy_FilterStateMultiError(errors)
	}

	return nil
}

// RouteAction_HashPolicy_FilterStateMultiError is an error wrapping multiple
// validation errors returned by
// RouteAction_HashPolicy_FilterState.ValidateAll() if the designated
// constraints aren't met.
type RouteAction_HashPolicy_FilterStateMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteAction_HashPolicy_FilterStateMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteAction_HashPolicy_FilterStateMultiError) AllErrors() []error { return m }

// RouteAction_HashPolicy_FilterStateValidationError is the validation error
// returned by RouteAction_HashPolicy_FilterState.Validate if the designated
// constraints aren't met.
type RouteAction_HashPolicy_FilterStateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_HashPolicy_FilterStateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_HashPolicy_FilterStateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_HashPolicy_FilterStateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_HashPolicy_FilterStateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_HashPolicy_FilterStateValidationError) ErrorName() string {
	return "RouteAction_HashPolicy_FilterStateValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_FilterStateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_FilterState.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_HashPolicy_FilterStateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_HashPolicy_FilterStateValidationError{}

// Validate checks the field values on RouteAction_UpgradeConfig_ConnectConfig
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *RouteAction_UpgradeConfig_ConnectConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RouteAction_UpgradeConfig_ConnectConfig with the rules defined in the proto
// definition for this message. If any rules are violated, the result is a
// list of violation errors wrapped in
// RouteAction_UpgradeConfig_ConnectConfigMultiError, or nil if none found.
func (m *RouteAction_UpgradeConfig_ConnectConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *RouteAction_UpgradeConfig_ConnectConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetProxyProtocolConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RouteAction_UpgradeConfig_ConnectConfigValidationError{
					field:  "ProxyProtocolConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RouteAction_UpgradeConfig_ConnectConfigValidationError{
					field:  "ProxyProtocolConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetProxyProtocolConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_UpgradeConfig_ConnectConfigValidationError{
				field:  "ProxyProtocolConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for AllowPost

	if len(errors) > 0 {
		return RouteAction_UpgradeConfig_ConnectConfigMultiError(errors)
	}

	return nil
}

// RouteAction_UpgradeConfig_ConnectConfigMultiError is an error wrapping
// multiple validation errors returned by
// RouteAction_UpgradeConfig_ConnectConfig.ValidateAll() if the designated
// constraints aren't met.
type RouteAction_UpgradeConfig_ConnectConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RouteAction_UpgradeConfig_ConnectConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RouteAction_UpgradeConfig_ConnectConfigMultiError) AllErrors() []error { return m }

// RouteAction_UpgradeConfig_ConnectConfigValidationError is the validation
// error returned by RouteAction_UpgradeConfig_ConnectConfig.Validate if the
// designated constraints aren't met.
type RouteAction_UpgradeConfig_ConnectConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_UpgradeConfig_ConnectConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_UpgradeConfig_ConnectConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_UpgradeConfig_ConnectConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_UpgradeConfig_ConnectConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_UpgradeConfig_ConnectConfigValidationError) ErrorName() string {
	return "RouteAction_UpgradeConfig_ConnectConfigValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_UpgradeConfig_ConnectConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_UpgradeConfig_ConnectConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_UpgradeConfig_ConnectConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_UpgradeConfig_ConnectConfigValidationError{}

// Validate checks the field values on RetryPolicy_RetryPriority with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RetryPolicy_RetryPriority) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RetryPolicy_RetryPriority with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RetryPolicy_RetryPriorityMultiError, or nil if none found.
func (m *RetryPolicy_RetryPriority) ValidateAll() error {
	return m.validate(true)
}

func (m *RetryPolicy_RetryPriority) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := RetryPolicy_RetryPriorityValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.ConfigType.(type) {
	case *RetryPolicy_RetryPriority_TypedConfig:
		if v == nil {
			err := RetryPolicy_RetryPriorityValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RetryPolicy_RetryPriorityValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RetryPolicy_RetryPriorityValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicy_RetryPriorityValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return RetryPolicy_RetryPriorityMultiError(errors)
	}

	return nil
}

// RetryPolicy_RetryPriorityMultiError is an error wrapping multiple validation
// errors returned by RetryPolicy_RetryPriority.ValidateAll() if the
// designated constraints aren't met.
type RetryPolicy_RetryPriorityMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RetryPolicy_RetryPriorityMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RetryPolicy_RetryPriorityMultiError) AllErrors() []error { return m }

// RetryPolicy_RetryPriorityValidationError is the validation error returned by
// RetryPolicy_RetryPriority.Validate if the designated constraints aren't met.
type RetryPolicy_RetryPriorityValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicy_RetryPriorityValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicy_RetryPriorityValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicy_RetryPriorityValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicy_RetryPriorityValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicy_RetryPriorityValidationError) ErrorName() string {
	return "RetryPolicy_RetryPriorityValidationError"
}

// Error satisfies the builtin error interface
func (e RetryPolicy_RetryPriorityValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy_RetryPriority.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicy_RetryPriorityValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicy_RetryPriorityValidationError{}

// Validate checks the field values on RetryPolicy_RetryHostPredicate with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RetryPolicy_RetryHostPredicate) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RetryPolicy_RetryHostPredicate with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RetryPolicy_RetryHostPredicateMultiError, or nil if none found.
func (m *RetryPolicy_RetryHostPredicate) ValidateAll() error {
	return m.validate(true)
}

func (m *RetryPolicy_RetryHostPredicate) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := RetryPolicy_RetryHostPredicateValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.ConfigType.(type) {
	case *RetryPolicy_RetryHostPredicate_TypedConfig:
		if v == nil {
			err := RetryPolicy_RetryHostPredicateValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RetryPolicy_RetryHostPredicateValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RetryPolicy_RetryHostPredicateValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicy_RetryHostPredicateValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return RetryPolicy_RetryHostPredicateMultiError(errors)
	}

	return nil
}

// RetryPolicy_RetryHostPredicateMultiError is an error wrapping multiple
// validation errors returned by RetryPolicy_RetryHostPredicate.ValidateAll()
// if the designated constraints aren't met.
type RetryPolicy_RetryHostPredicateMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RetryPolicy_RetryHostPredicateMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RetryPolicy_RetryHostPredicateMultiError) AllErrors() []error { return m }

// RetryPolicy_RetryHostPredicateValidationError is the validation error
// returned by RetryPolicy_RetryHostPredicate.Validate if the designated
// constraints aren't met.
type RetryPolicy_RetryHostPredicateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicy_RetryHostPredicateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicy_RetryHostPredicateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicy_RetryHostPredicateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicy_RetryHostPredicateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicy_RetryHostPredicateValidationError) ErrorName() string {
	return "RetryPolicy_RetryHostPredicateValidationError"
}

// Error satisfies the builtin error interface
func (e RetryPolicy_RetryHostPredicateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy_RetryHostPredicate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicy_RetryHostPredicateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicy_RetryHostPredicateValidationError{}

// Validate checks the field values on RetryPolicy_RetryBackOff with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RetryPolicy_RetryBackOff) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RetryPolicy_RetryBackOff with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RetryPolicy_RetryBackOffMultiError, or nil if none found.
func (m *RetryPolicy_RetryBackOff) ValidateAll() error {
	return m.validate(true)
}

func (m *RetryPolicy_RetryBackOff) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetBaseInterval() == nil {
		err := RetryPolicy_RetryBackOffValidationError{
			field:  "BaseInterval",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if d := m.GetBaseInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RetryPolicy_RetryBackOffValidationError{
				field:  "BaseInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := RetryPolicy_RetryBackOffValidationError{
					field:  "BaseInterval",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetMaxInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RetryPolicy_RetryBackOffValidationError{
				field:  "MaxInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := RetryPolicy_RetryBackOffValidationError{
					field:  "MaxInterval",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return RetryPolicy_RetryBackOffMultiError(errors)
	}

	return nil
}

// RetryPolicy_RetryBackOffMultiError is an error wrapping multiple validation
// errors returned by RetryPolicy_RetryBackOff.ValidateAll() if the designated
// constraints aren't met.
type RetryPolicy_RetryBackOffMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RetryPolicy_RetryBackOffMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RetryPolicy_RetryBackOffMultiError) AllErrors() []error { return m }

// RetryPolicy_RetryBackOffValidationError is the validation error returned by
// RetryPolicy_RetryBackOff.Validate if the designated constraints aren't met.
type RetryPolicy_RetryBackOffValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicy_RetryBackOffValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicy_RetryBackOffValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicy_RetryBackOffValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicy_RetryBackOffValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicy_RetryBackOffValidationError) ErrorName() string {
	return "RetryPolicy_RetryBackOffValidationError"
}

// Error satisfies the builtin error interface
func (e RetryPolicy_RetryBackOffValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy_RetryBackOff.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicy_RetryBackOffValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicy_RetryBackOffValidationError{}

// Validate checks the field values on RetryPolicy_ResetHeader with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RetryPolicy_ResetHeader) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RetryPolicy_ResetHeader with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RetryPolicy_ResetHeaderMultiError, or nil if none found.
func (m *RetryPolicy_ResetHeader) ValidateAll() error {
	return m.validate(true)
}

func (m *RetryPolicy_ResetHeader) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := RetryPolicy_ResetHeaderValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RetryPolicy_ResetHeader_Name_Pattern.MatchString(m.GetName()) {
		err := RetryPolicy_ResetHeaderValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := RetryPolicy_ResetHeaderFormat_name[int32(m.GetFormat())]; !ok {
		err := RetryPolicy_ResetHeaderValidationError{
			field:  "Format",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RetryPolicy_ResetHeaderMultiError(errors)
	}

	return nil
}

// RetryPolicy_ResetHeaderMultiError is an error wrapping multiple validation
// errors returned by RetryPolicy_ResetHeader.ValidateAll() if the designated
// constraints aren't met.
type RetryPolicy_ResetHeaderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RetryPolicy_ResetHeaderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RetryPolicy_ResetHeaderMultiError) AllErrors() []error { return m }

// RetryPolicy_ResetHeaderValidationError is the validation error returned by
// RetryPolicy_ResetHeader.Validate if the designated constraints aren't met.
type RetryPolicy_ResetHeaderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicy_ResetHeaderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicy_ResetHeaderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicy_ResetHeaderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicy_ResetHeaderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicy_ResetHeaderValidationError) ErrorName() string {
	return "RetryPolicy_ResetHeaderValidationError"
}

// Error satisfies the builtin error interface
func (e RetryPolicy_ResetHeaderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy_ResetHeader.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicy_ResetHeaderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicy_ResetHeaderValidationError{}

var _RetryPolicy_ResetHeader_Name_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on RetryPolicy_RateLimitedRetryBackOff with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *RetryPolicy_RateLimitedRetryBackOff) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RetryPolicy_RateLimitedRetryBackOff
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// RetryPolicy_RateLimitedRetryBackOffMultiError, or nil if none found.
func (m *RetryPolicy_RateLimitedRetryBackOff) ValidateAll() error {
	return m.validate(true)
}

func (m *RetryPolicy_RateLimitedRetryBackOff) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetResetHeaders()) < 1 {
		err := RetryPolicy_RateLimitedRetryBackOffValidationError{
			field:  "ResetHeaders",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetResetHeaders() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RetryPolicy_RateLimitedRetryBackOffValidationError{
						field:  fmt.Sprintf("ResetHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RetryPolicy_RateLimitedRetryBackOffValidationError{
						field:  fmt.Sprintf("ResetHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicy_RateLimitedRetryBackOffValidationError{
					field:  fmt.Sprintf("ResetHeaders[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if d := m.GetMaxInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RetryPolicy_RateLimitedRetryBackOffValidationError{
				field:  "MaxInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := RetryPolicy_RateLimitedRetryBackOffValidationError{
					field:  "MaxInterval",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return RetryPolicy_RateLimitedRetryBackOffMultiError(errors)
	}

	return nil
}

// RetryPolicy_RateLimitedRetryBackOffMultiError is an error wrapping multiple
// validation errors returned by
// RetryPolicy_RateLimitedRetryBackOff.ValidateAll() if the designated
// constraints aren't met.
type RetryPolicy_RateLimitedRetryBackOffMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RetryPolicy_RateLimitedRetryBackOffMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RetryPolicy_RateLimitedRetryBackOffMultiError) AllErrors() []error { return m }

// RetryPolicy_RateLimitedRetryBackOffValidationError is the validation error
// returned by RetryPolicy_RateLimitedRetryBackOff.Validate if the designated
// constraints aren't met.
type RetryPolicy_RateLimitedRetryBackOffValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicy_RateLimitedRetryBackOffValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicy_RateLimitedRetryBackOffValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicy_RateLimitedRetryBackOffValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicy_RateLimitedRetryBackOffValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicy_RateLimitedRetryBackOffValidationError) ErrorName() string {
	return "RetryPolicy_RateLimitedRetryBackOffValidationError"
}

// Error satisfies the builtin error interface
func (e RetryPolicy_RateLimitedRetryBackOffValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy_RateLimitedRetryBackOff.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicy_RateLimitedRetryBackOffValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicy_RateLimitedRetryBackOffValidationError{}

// Validate checks the field values on RateLimit_Action with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *RateLimit_Action) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Action with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RateLimit_ActionMultiError, or nil if none found.
func (m *RateLimit_Action) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofActionSpecifierPresent := false
	switch v := m.ActionSpecifier.(type) {
	case *RateLimit_Action_SourceCluster_:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetSourceCluster()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "SourceCluster",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "SourceCluster",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetSourceCluster()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "SourceCluster",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_DestinationCluster_:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetDestinationCluster()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "DestinationCluster",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "DestinationCluster",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetDestinationCluster()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "DestinationCluster",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_RequestHeaders_:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetRequestHeaders()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "RequestHeaders",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "RequestHeaders",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRequestHeaders()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "RequestHeaders",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_QueryParameters_:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetQueryParameters()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "QueryParameters",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "QueryParameters",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetQueryParameters()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "QueryParameters",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_RemoteAddress_:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetRemoteAddress()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "RemoteAddress",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "RemoteAddress",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRemoteAddress()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "RemoteAddress",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_GenericKey_:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetGenericKey()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "GenericKey",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "GenericKey",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetGenericKey()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "GenericKey",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_HeaderValueMatch_:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetHeaderValueMatch()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "HeaderValueMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "HeaderValueMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetHeaderValueMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "HeaderValueMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_DynamicMetadata:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetDynamicMetadata()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "DynamicMetadata",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "DynamicMetadata",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetDynamicMetadata()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "DynamicMetadata",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_Metadata:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetMetadata()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "Metadata",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "Metadata",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_Extension:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetExtension()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "Extension",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "Extension",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetExtension()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "Extension",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_MaskedRemoteAddress_:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetMaskedRemoteAddress()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "MaskedRemoteAddress",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "MaskedRemoteAddress",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetMaskedRemoteAddress()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "MaskedRemoteAddress",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_QueryParameterValueMatch_:
		if v == nil {
			err := RateLimit_ActionValidationError{
				field:  "ActionSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofActionSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetQueryParameterValueMatch()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "QueryParameterValueMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_ActionValidationError{
						field:  "QueryParameterValueMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetQueryParameterValueMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "QueryParameterValueMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofActionSpecifierPresent {
		err := RateLimit_ActionValidationError{
			field:  "ActionSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RateLimit_ActionMultiError(errors)
	}

	return nil
}

// RateLimit_ActionMultiError is an error wrapping multiple validation errors
// returned by RateLimit_Action.ValidateAll() if the designated constraints
// aren't met.
type RateLimit_ActionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_ActionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_ActionMultiError) AllErrors() []error { return m }

// RateLimit_ActionValidationError is the validation error returned by
// RateLimit_Action.Validate if the designated constraints aren't met.
type RateLimit_ActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_ActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_ActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_ActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_ActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_ActionValidationError) ErrorName() string { return "RateLimit_ActionValidationError" }

// Error satisfies the builtin error interface
func (e RateLimit_ActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_ActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_ActionValidationError{}

// Validate checks the field values on RateLimit_Override with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimit_Override) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Override with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RateLimit_OverrideMultiError, or nil if none found.
func (m *RateLimit_Override) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Override) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofOverrideSpecifierPresent := false
	switch v := m.OverrideSpecifier.(type) {
	case *RateLimit_Override_DynamicMetadata_:
		if v == nil {
			err := RateLimit_OverrideValidationError{
				field:  "OverrideSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofOverrideSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetDynamicMetadata()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_OverrideValidationError{
						field:  "DynamicMetadata",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_OverrideValidationError{
						field:  "DynamicMetadata",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetDynamicMetadata()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_OverrideValidationError{
					field:  "DynamicMetadata",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofOverrideSpecifierPresent {
		err := RateLimit_OverrideValidationError{
			field:  "OverrideSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RateLimit_OverrideMultiError(errors)
	}

	return nil
}

// RateLimit_OverrideMultiError is an error wrapping multiple validation errors
// returned by RateLimit_Override.ValidateAll() if the designated constraints
// aren't met.
type RateLimit_OverrideMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_OverrideMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_OverrideMultiError) AllErrors() []error { return m }

// RateLimit_OverrideValidationError is the validation error returned by
// RateLimit_Override.Validate if the designated constraints aren't met.
type RateLimit_OverrideValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_OverrideValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_OverrideValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_OverrideValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_OverrideValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_OverrideValidationError) ErrorName() string {
	return "RateLimit_OverrideValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_OverrideValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Override.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_OverrideValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_OverrideValidationError{}

// Validate checks the field values on RateLimit_HitsAddend with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimit_HitsAddend) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_HitsAddend with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RateLimit_HitsAddendMultiError, or nil if none found.
func (m *RateLimit_HitsAddend) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_HitsAddend) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetNumber(); wrapper != nil {

		if wrapper.GetValue() > 1000000000 {
			err := RateLimit_HitsAddendValidationError{
				field:  "Number",
				reason: "value must be less than or equal to 1000000000",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetFormat() != "" {

		if !strings.HasPrefix(m.GetFormat(), "%") {
			err := RateLimit_HitsAddendValidationError{
				field:  "Format",
				reason: "value does not have prefix \"%\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !strings.HasSuffix(m.GetFormat(), "%") {
			err := RateLimit_HitsAddendValidationError{
				field:  "Format",
				reason: "value does not have suffix \"%\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return RateLimit_HitsAddendMultiError(errors)
	}

	return nil
}

// RateLimit_HitsAddendMultiError is an error wrapping multiple validation
// errors returned by RateLimit_HitsAddend.ValidateAll() if the designated
// constraints aren't met.
type RateLimit_HitsAddendMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_HitsAddendMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_HitsAddendMultiError) AllErrors() []error { return m }

// RateLimit_HitsAddendValidationError is the validation error returned by
// RateLimit_HitsAddend.Validate if the designated constraints aren't met.
type RateLimit_HitsAddendValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_HitsAddendValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_HitsAddendValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_HitsAddendValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_HitsAddendValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_HitsAddendValidationError) ErrorName() string {
	return "RateLimit_HitsAddendValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_HitsAddendValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_HitsAddend.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_HitsAddendValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_HitsAddendValidationError{}

// Validate checks the field values on RateLimit_Action_SourceCluster with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimit_Action_SourceCluster) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Action_SourceCluster with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RateLimit_Action_SourceClusterMultiError, or nil if none found.
func (m *RateLimit_Action_SourceCluster) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action_SourceCluster) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return RateLimit_Action_SourceClusterMultiError(errors)
	}

	return nil
}

// RateLimit_Action_SourceClusterMultiError is an error wrapping multiple
// validation errors returned by RateLimit_Action_SourceCluster.ValidateAll()
// if the designated constraints aren't met.
type RateLimit_Action_SourceClusterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Action_SourceClusterMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Action_SourceClusterMultiError) AllErrors() []error { return m }

// RateLimit_Action_SourceClusterValidationError is the validation error
// returned by RateLimit_Action_SourceCluster.Validate if the designated
// constraints aren't met.
type RateLimit_Action_SourceClusterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_SourceClusterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_SourceClusterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_SourceClusterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_SourceClusterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_SourceClusterValidationError) ErrorName() string {
	return "RateLimit_Action_SourceClusterValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_SourceClusterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_SourceCluster.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_SourceClusterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_SourceClusterValidationError{}

// Validate checks the field values on RateLimit_Action_DestinationCluster with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *RateLimit_Action_DestinationCluster) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Action_DestinationCluster
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// RateLimit_Action_DestinationClusterMultiError, or nil if none found.
func (m *RateLimit_Action_DestinationCluster) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action_DestinationCluster) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return RateLimit_Action_DestinationClusterMultiError(errors)
	}

	return nil
}

// RateLimit_Action_DestinationClusterMultiError is an error wrapping multiple
// validation errors returned by
// RateLimit_Action_DestinationCluster.ValidateAll() if the designated
// constraints aren't met.
type RateLimit_Action_DestinationClusterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Action_DestinationClusterMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Action_DestinationClusterMultiError) AllErrors() []error { return m }

// RateLimit_Action_DestinationClusterValidationError is the validation error
// returned by RateLimit_Action_DestinationCluster.Validate if the designated
// constraints aren't met.
type RateLimit_Action_DestinationClusterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_DestinationClusterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_DestinationClusterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_DestinationClusterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_DestinationClusterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_DestinationClusterValidationError) ErrorName() string {
	return "RateLimit_Action_DestinationClusterValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_DestinationClusterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_DestinationCluster.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_DestinationClusterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_DestinationClusterValidationError{}

// Validate checks the field values on RateLimit_Action_RequestHeaders with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimit_Action_RequestHeaders) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Action_RequestHeaders with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RateLimit_Action_RequestHeadersMultiError, or nil if none found.
func (m *RateLimit_Action_RequestHeaders) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action_RequestHeaders) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetHeaderName()) < 1 {
		err := RateLimit_Action_RequestHeadersValidationError{
			field:  "HeaderName",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RateLimit_Action_RequestHeaders_HeaderName_Pattern.MatchString(m.GetHeaderName()) {
		err := RateLimit_Action_RequestHeadersValidationError{
			field:  "HeaderName",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetDescriptorKey()) < 1 {
		err := RateLimit_Action_RequestHeadersValidationError{
			field:  "DescriptorKey",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for SkipIfAbsent

	if len(errors) > 0 {
		return RateLimit_Action_RequestHeadersMultiError(errors)
	}

	return nil
}

// RateLimit_Action_RequestHeadersMultiError is an error wrapping multiple
// validation errors returned by RateLimit_Action_RequestHeaders.ValidateAll()
// if the designated constraints aren't met.
type RateLimit_Action_RequestHeadersMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Action_RequestHeadersMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Action_RequestHeadersMultiError) AllErrors() []error { return m }

// RateLimit_Action_RequestHeadersValidationError is the validation error
// returned by RateLimit_Action_RequestHeaders.Validate if the designated
// constraints aren't met.
type RateLimit_Action_RequestHeadersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_RequestHeadersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_RequestHeadersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_RequestHeadersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_RequestHeadersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_RequestHeadersValidationError) ErrorName() string {
	return "RateLimit_Action_RequestHeadersValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_RequestHeadersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_RequestHeaders.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_RequestHeadersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_RequestHeadersValidationError{}

var _RateLimit_Action_RequestHeaders_HeaderName_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on RateLimit_Action_QueryParameters with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *RateLimit_Action_QueryParameters) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Action_QueryParameters with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RateLimit_Action_QueryParametersMultiError, or nil if none found.
func (m *RateLimit_Action_QueryParameters) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action_QueryParameters) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetQueryParameterName()) < 1 {
		err := RateLimit_Action_QueryParametersValidationError{
			field:  "QueryParameterName",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetDescriptorKey()) < 1 {
		err := RateLimit_Action_QueryParametersValidationError{
			field:  "DescriptorKey",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for SkipIfAbsent

	if len(errors) > 0 {
		return RateLimit_Action_QueryParametersMultiError(errors)
	}

	return nil
}

// RateLimit_Action_QueryParametersMultiError is an error wrapping multiple
// validation errors returned by
// RateLimit_Action_QueryParameters.ValidateAll() if the designated
// constraints aren't met.
type RateLimit_Action_QueryParametersMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Action_QueryParametersMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Action_QueryParametersMultiError) AllErrors() []error { return m }

// RateLimit_Action_QueryParametersValidationError is the validation error
// returned by RateLimit_Action_QueryParameters.Validate if the designated
// constraints aren't met.
type RateLimit_Action_QueryParametersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_QueryParametersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_QueryParametersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_QueryParametersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_QueryParametersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_QueryParametersValidationError) ErrorName() string {
	return "RateLimit_Action_QueryParametersValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_QueryParametersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_QueryParameters.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_QueryParametersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_QueryParametersValidationError{}

// Validate checks the field values on RateLimit_Action_RemoteAddress with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimit_Action_RemoteAddress) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Action_RemoteAddress with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RateLimit_Action_RemoteAddressMultiError, or nil if none found.
func (m *RateLimit_Action_RemoteAddress) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action_RemoteAddress) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return RateLimit_Action_RemoteAddressMultiError(errors)
	}

	return nil
}

// RateLimit_Action_RemoteAddressMultiError is an error wrapping multiple
// validation errors returned by RateLimit_Action_RemoteAddress.ValidateAll()
// if the designated constraints aren't met.
type RateLimit_Action_RemoteAddressMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Action_RemoteAddressMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Action_RemoteAddressMultiError) AllErrors() []error { return m }

// RateLimit_Action_RemoteAddressValidationError is the validation error
// returned by RateLimit_Action_RemoteAddress.Validate if the designated
// constraints aren't met.
type RateLimit_Action_RemoteAddressValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_RemoteAddressValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_RemoteAddressValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_RemoteAddressValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_RemoteAddressValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_RemoteAddressValidationError) ErrorName() string {
	return "RateLimit_Action_RemoteAddressValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_RemoteAddressValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_RemoteAddress.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_RemoteAddressValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_RemoteAddressValidationError{}

// Validate checks the field values on RateLimit_Action_MaskedRemoteAddress
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *RateLimit_Action_MaskedRemoteAddress) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Action_MaskedRemoteAddress
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// RateLimit_Action_MaskedRemoteAddressMultiError, or nil if none found.
func (m *RateLimit_Action_MaskedRemoteAddress) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action_MaskedRemoteAddress) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetV4PrefixMaskLen(); wrapper != nil {

		if wrapper.GetValue() > 32 {
			err := RateLimit_Action_MaskedRemoteAddressValidationError{
				field:  "V4PrefixMaskLen",
				reason: "value must be less than or equal to 32",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if wrapper := m.GetV6PrefixMaskLen(); wrapper != nil {

		if wrapper.GetValue() > 128 {
			err := RateLimit_Action_MaskedRemoteAddressValidationError{
				field:  "V6PrefixMaskLen",
				reason: "value must be less than or equal to 128",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return RateLimit_Action_MaskedRemoteAddressMultiError(errors)
	}

	return nil
}

// RateLimit_Action_MaskedRemoteAddressMultiError is an error wrapping multiple
// validation errors returned by
// RateLimit_Action_MaskedRemoteAddress.ValidateAll() if the designated
// constraints aren't met.
type RateLimit_Action_MaskedRemoteAddressMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Action_MaskedRemoteAddressMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Action_MaskedRemoteAddressMultiError) AllErrors() []error { return m }

// RateLimit_Action_MaskedRemoteAddressValidationError is the validation error
// returned by RateLimit_Action_MaskedRemoteAddress.Validate if the designated
// constraints aren't met.
type RateLimit_Action_MaskedRemoteAddressValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_MaskedRemoteAddressValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_MaskedRemoteAddressValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_MaskedRemoteAddressValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_MaskedRemoteAddressValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_MaskedRemoteAddressValidationError) ErrorName() string {
	return "RateLimit_Action_MaskedRemoteAddressValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_MaskedRemoteAddressValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_MaskedRemoteAddress.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_MaskedRemoteAddressValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_MaskedRemoteAddressValidationError{}

// Validate checks the field values on RateLimit_Action_GenericKey with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimit_Action_GenericKey) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Action_GenericKey with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RateLimit_Action_GenericKeyMultiError, or nil if none found.
func (m *RateLimit_Action_GenericKey) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action_GenericKey) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetDescriptorValue()) < 1 {
		err := RateLimit_Action_GenericKeyValidationError{
			field:  "DescriptorValue",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for DescriptorKey

	if len(errors) > 0 {
		return RateLimit_Action_GenericKeyMultiError(errors)
	}

	return nil
}

// RateLimit_Action_GenericKeyMultiError is an error wrapping multiple
// validation errors returned by RateLimit_Action_GenericKey.ValidateAll() if
// the designated constraints aren't met.
type RateLimit_Action_GenericKeyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Action_GenericKeyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Action_GenericKeyMultiError) AllErrors() []error { return m }

// RateLimit_Action_GenericKeyValidationError is the validation error returned
// by RateLimit_Action_GenericKey.Validate if the designated constraints
// aren't met.
type RateLimit_Action_GenericKeyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_GenericKeyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_GenericKeyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_GenericKeyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_GenericKeyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_GenericKeyValidationError) ErrorName() string {
	return "RateLimit_Action_GenericKeyValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_GenericKeyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_GenericKey.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_GenericKeyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_GenericKeyValidationError{}

// Validate checks the field values on RateLimit_Action_HeaderValueMatch with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *RateLimit_Action_HeaderValueMatch) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Action_HeaderValueMatch
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// RateLimit_Action_HeaderValueMatchMultiError, or nil if none found.
func (m *RateLimit_Action_HeaderValueMatch) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action_HeaderValueMatch) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for DescriptorKey

	if utf8.RuneCountInString(m.GetDescriptorValue()) < 1 {
		err := RateLimit_Action_HeaderValueMatchValidationError{
			field:  "DescriptorValue",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetExpectMatch()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimit_Action_HeaderValueMatchValidationError{
					field:  "ExpectMatch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimit_Action_HeaderValueMatchValidationError{
					field:  "ExpectMatch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetExpectMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimit_Action_HeaderValueMatchValidationError{
				field:  "ExpectMatch",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetHeaders()) < 1 {
		err := RateLimit_Action_HeaderValueMatchValidationError{
			field:  "Headers",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetHeaders() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_Action_HeaderValueMatchValidationError{
						field:  fmt.Sprintf("Headers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_Action_HeaderValueMatchValidationError{
						field:  fmt.Sprintf("Headers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_Action_HeaderValueMatchValidationError{
					field:  fmt.Sprintf("Headers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return RateLimit_Action_HeaderValueMatchMultiError(errors)
	}

	return nil
}

// RateLimit_Action_HeaderValueMatchMultiError is an error wrapping multiple
// validation errors returned by
// RateLimit_Action_HeaderValueMatch.ValidateAll() if the designated
// constraints aren't met.
type RateLimit_Action_HeaderValueMatchMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Action_HeaderValueMatchMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Action_HeaderValueMatchMultiError) AllErrors() []error { return m }

// RateLimit_Action_HeaderValueMatchValidationError is the validation error
// returned by RateLimit_Action_HeaderValueMatch.Validate if the designated
// constraints aren't met.
type RateLimit_Action_HeaderValueMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_HeaderValueMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_HeaderValueMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_HeaderValueMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_HeaderValueMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_HeaderValueMatchValidationError) ErrorName() string {
	return "RateLimit_Action_HeaderValueMatchValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_HeaderValueMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_HeaderValueMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_HeaderValueMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_HeaderValueMatchValidationError{}

// Validate checks the field values on RateLimit_Action_DynamicMetaData with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *RateLimit_Action_DynamicMetaData) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Action_DynamicMetaData with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RateLimit_Action_DynamicMetaDataMultiError, or nil if none found.
func (m *RateLimit_Action_DynamicMetaData) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action_DynamicMetaData) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetDescriptorKey()) < 1 {
		err := RateLimit_Action_DynamicMetaDataValidationError{
			field:  "DescriptorKey",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadataKey() == nil {
		err := RateLimit_Action_DynamicMetaDataValidationError{
			field:  "MetadataKey",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadataKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimit_Action_DynamicMetaDataValidationError{
					field:  "MetadataKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimit_Action_DynamicMetaDataValidationError{
					field:  "MetadataKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadataKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimit_Action_DynamicMetaDataValidationError{
				field:  "MetadataKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for DefaultValue

	if len(errors) > 0 {
		return RateLimit_Action_DynamicMetaDataMultiError(errors)
	}

	return nil
}

// RateLimit_Action_DynamicMetaDataMultiError is an error wrapping multiple
// validation errors returned by
// RateLimit_Action_DynamicMetaData.ValidateAll() if the designated
// constraints aren't met.
type RateLimit_Action_DynamicMetaDataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Action_DynamicMetaDataMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Action_DynamicMetaDataMultiError) AllErrors() []error { return m }

// RateLimit_Action_DynamicMetaDataValidationError is the validation error
// returned by RateLimit_Action_DynamicMetaData.Validate if the designated
// constraints aren't met.
type RateLimit_Action_DynamicMetaDataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_DynamicMetaDataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_DynamicMetaDataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_DynamicMetaDataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_DynamicMetaDataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_DynamicMetaDataValidationError) ErrorName() string {
	return "RateLimit_Action_DynamicMetaDataValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_DynamicMetaDataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_DynamicMetaData.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_DynamicMetaDataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_DynamicMetaDataValidationError{}

// Validate checks the field values on RateLimit_Action_MetaData with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RateLimit_Action_MetaData) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Action_MetaData with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RateLimit_Action_MetaDataMultiError, or nil if none found.
func (m *RateLimit_Action_MetaData) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action_MetaData) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetDescriptorKey()) < 1 {
		err := RateLimit_Action_MetaDataValidationError{
			field:  "DescriptorKey",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetMetadataKey() == nil {
		err := RateLimit_Action_MetaDataValidationError{
			field:  "MetadataKey",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadataKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimit_Action_MetaDataValidationError{
					field:  "MetadataKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimit_Action_MetaDataValidationError{
					field:  "MetadataKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadataKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimit_Action_MetaDataValidationError{
				field:  "MetadataKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for DefaultValue

	if _, ok := RateLimit_Action_MetaData_Source_name[int32(m.GetSource())]; !ok {
		err := RateLimit_Action_MetaDataValidationError{
			field:  "Source",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for SkipIfAbsent

	if len(errors) > 0 {
		return RateLimit_Action_MetaDataMultiError(errors)
	}

	return nil
}

// RateLimit_Action_MetaDataMultiError is an error wrapping multiple validation
// errors returned by RateLimit_Action_MetaData.ValidateAll() if the
// designated constraints aren't met.
type RateLimit_Action_MetaDataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Action_MetaDataMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Action_MetaDataMultiError) AllErrors() []error { return m }

// RateLimit_Action_MetaDataValidationError is the validation error returned by
// RateLimit_Action_MetaData.Validate if the designated constraints aren't met.
type RateLimit_Action_MetaDataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_MetaDataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_MetaDataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_MetaDataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_MetaDataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_MetaDataValidationError) ErrorName() string {
	return "RateLimit_Action_MetaDataValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_MetaDataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_MetaData.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_MetaDataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_MetaDataValidationError{}

// Validate checks the field values on
// RateLimit_Action_QueryParameterValueMatch with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RateLimit_Action_QueryParameterValueMatch) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RateLimit_Action_QueryParameterValueMatch with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// RateLimit_Action_QueryParameterValueMatchMultiError, or nil if none found.
func (m *RateLimit_Action_QueryParameterValueMatch) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Action_QueryParameterValueMatch) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for DescriptorKey

	if utf8.RuneCountInString(m.GetDescriptorValue()) < 1 {
		err := RateLimit_Action_QueryParameterValueMatchValidationError{
			field:  "DescriptorValue",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetExpectMatch()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimit_Action_QueryParameterValueMatchValidationError{
					field:  "ExpectMatch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimit_Action_QueryParameterValueMatchValidationError{
					field:  "ExpectMatch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetExpectMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimit_Action_QueryParameterValueMatchValidationError{
				field:  "ExpectMatch",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetQueryParameters()) < 1 {
		err := RateLimit_Action_QueryParameterValueMatchValidationError{
			field:  "QueryParameters",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetQueryParameters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RateLimit_Action_QueryParameterValueMatchValidationError{
						field:  fmt.Sprintf("QueryParameters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RateLimit_Action_QueryParameterValueMatchValidationError{
						field:  fmt.Sprintf("QueryParameters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_Action_QueryParameterValueMatchValidationError{
					field:  fmt.Sprintf("QueryParameters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return RateLimit_Action_QueryParameterValueMatchMultiError(errors)
	}

	return nil
}

// RateLimit_Action_QueryParameterValueMatchMultiError is an error wrapping
// multiple validation errors returned by
// RateLimit_Action_QueryParameterValueMatch.ValidateAll() if the designated
// constraints aren't met.
type RateLimit_Action_QueryParameterValueMatchMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Action_QueryParameterValueMatchMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Action_QueryParameterValueMatchMultiError) AllErrors() []error { return m }

// RateLimit_Action_QueryParameterValueMatchValidationError is the validation
// error returned by RateLimit_Action_QueryParameterValueMatch.Validate if the
// designated constraints aren't met.
type RateLimit_Action_QueryParameterValueMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_QueryParameterValueMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_QueryParameterValueMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_QueryParameterValueMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_QueryParameterValueMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_QueryParameterValueMatchValidationError) ErrorName() string {
	return "RateLimit_Action_QueryParameterValueMatchValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_QueryParameterValueMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_QueryParameterValueMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_QueryParameterValueMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_QueryParameterValueMatchValidationError{}

// Validate checks the field values on RateLimit_Override_DynamicMetadata with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *RateLimit_Override_DynamicMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RateLimit_Override_DynamicMetadata
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// RateLimit_Override_DynamicMetadataMultiError, or nil if none found.
func (m *RateLimit_Override_DynamicMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *RateLimit_Override_DynamicMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetMetadataKey() == nil {
		err := RateLimit_Override_DynamicMetadataValidationError{
			field:  "MetadataKey",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadataKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RateLimit_Override_DynamicMetadataValidationError{
					field:  "MetadataKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RateLimit_Override_DynamicMetadataValidationError{
					field:  "MetadataKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadataKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimit_Override_DynamicMetadataValidationError{
				field:  "MetadataKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RateLimit_Override_DynamicMetadataMultiError(errors)
	}

	return nil
}

// RateLimit_Override_DynamicMetadataMultiError is an error wrapping multiple
// validation errors returned by
// RateLimit_Override_DynamicMetadata.ValidateAll() if the designated
// constraints aren't met.
type RateLimit_Override_DynamicMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RateLimit_Override_DynamicMetadataMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RateLimit_Override_DynamicMetadataMultiError) AllErrors() []error { return m }

// RateLimit_Override_DynamicMetadataValidationError is the validation error
// returned by RateLimit_Override_DynamicMetadata.Validate if the designated
// constraints aren't met.
type RateLimit_Override_DynamicMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Override_DynamicMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Override_DynamicMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Override_DynamicMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Override_DynamicMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Override_DynamicMetadataValidationError) ErrorName() string {
	return "RateLimit_Override_DynamicMetadataValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Override_DynamicMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Override_DynamicMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Override_DynamicMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Override_DynamicMetadataValidationError{}
