/* Dialogs.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Dialogs.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* namespace for future migration of AppWindow alert and other question dialogs into single*/
/* place: http://trac.yorba.org/ticket/3452*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite.h>
#include <gtk/gtk.h>
#include "io.elementary.photos.h"
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define IMPORT_UI_REPORT_FAILURE_COUNT 4
#define IMPORT_UI_SAVE_RESULTS_BUTTON_NAME _ ("Save Details…")
#define IMPORT_UI_SAVE_RESULTS_FILE_CHOOSER_TITLE _ ("Save Details")
#define IMPORT_UI_SAVE_RESULTS_RESPONSE_ID 1024
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _batch_import_result_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_result_unref (var), NULL)))
typedef struct _ImportUIParamSpecQuestionParams ImportUIParamSpecQuestionParams;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecTextEntryDialogMediator ParamSpecTextEntryDialogMediator;
enum  {
	ENTRY_MULTI_COMPLETION_0_PROPERTY,
	ENTRY_MULTI_COMPLETION_NUM_PROPERTIES
};
static GParamSpec* entry_multi_completion_properties[ENTRY_MULTI_COMPLETION_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ImportUIParamSpecQuestionParams {
	GParamSpec parent_instance;
};

struct _TextEntryDialogMediatorPrivate {
	TextEntryDialog* dialog;
};

struct _ParamSpecTextEntryDialogMediator {
	GParamSpec parent_instance;
};

struct _EntryMultiCompletionPrivate {
	gchar* delimiter;
};

VALA_EXTERN GFile* export_ui_current_export_dir;
GFile* export_ui_current_export_dir = NULL;
static gpointer import_ui_question_params_parent_class = NULL;
static gint TextEntryDialogMediator_private_offset;
static gpointer text_entry_dialog_mediator_parent_class = NULL;
static gint EntryMultiCompletion_private_offset;
static gpointer entry_multi_completion_parent_class = NULL;
static gpointer event_rename_dialog_parent_class = NULL;

VALA_EXTERN gboolean dialogs_negate_affirm_question (const gchar* message,
                                         const gchar* title);
VALA_EXTERN gchar* import_ui_generate_import_failure_list (GeeList* failed,
                                               gboolean show_dest_id);
static void import_ui_question_params_finalize (ImportUIQuestionParams * obj);
static GType import_ui_question_params_get_type_once (void);
VALA_EXTERN void import_ui_save_import_results (GtkWindow* chooser_dialog_parent,
                                    const gchar* results_log);
static gboolean _text_entry_dialog_mediator_on_modify_validate_text_entry_dialog_on_modify_validate_type (const gchar* text,
                                                                                                   gpointer self);
static gboolean text_entry_dialog_mediator_real_on_modify_validate (TextEntryDialogMediator* self,
                                                             const gchar* text);
static void text_entry_dialog_mediator_finalize (TextEntryDialogMediator * obj);
static GType text_entry_dialog_mediator_get_type_once (void);
static GtkListStore* entry_multi_completion_create_completion_store (GeeCollection* completion_list);
static gboolean entry_multi_completion_match_func (EntryMultiCompletion* self,
                                            GtkEntryCompletion* completion,
                                            const gchar* key,
                                            GtkTreeIter* iter);
static gboolean _entry_multi_completion_match_func_gtk_entry_completion_match_func (GtkEntryCompletion* completion,
                                                                             const gchar* key,
                                                                             GtkTreeIter* iter,
                                                                             gpointer self);
static gchar* entry_multi_completion_get_last_part (const gchar* s,
                                             const gchar* delimiter);
static gboolean entry_multi_completion_real_match_selected (GtkEntryCompletion* base,
                                                     GtkTreeModel* model,
                                                     GtkTreeIter* iter);
static void entry_multi_completion_finalize (GObject * obj);
static GType entry_multi_completion_get_type_once (void);
static gchar* event_rename_dialog_real_execute (EventRenameDialog* self);
static GType event_rename_dialog_get_type_once (void);
static GType welcome_service_entry_get_type_once (void);
static gboolean _progress_dialog_monitor_progress_monitor (guint64 current,
                                                    guint64 total,
                                                    gboolean do_event_loop,
                                                    gpointer self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
dialogs_negate_affirm_question (const gchar* message,
                                const gchar* title)
{
	GraniteMessageDialog* dialog = NULL;
	GraniteMessageDialog* _tmp0_;
	AppWindow* _tmp1_;
	AppWindow* _tmp2_;
	GtkButton* delete_button = NULL;
	GtkWidget* _tmp3_;
	GtkButton* _tmp4_;
	GtkStyleContext* _tmp5_;
	gboolean response = FALSE;
	gboolean result;
	g_return_val_if_fail (message != NULL, FALSE);
	g_return_val_if_fail (title != NULL, FALSE);
	_tmp0_ = granite_message_dialog_new_with_image_from_icon_name (title, message, "dialog-question", GTK_BUTTONS_NONE);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	_tmp1_ = app_window_get_instance ();
	_tmp2_ = _tmp1_;
	gtk_window_set_transient_for ((GtkWindow*) dialog, (GtkWindow*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_window_set_urgency_hint ((GtkWindow*) dialog, TRUE);
	gtk_dialog_add_button ((GtkDialog*) dialog, _ ("_Cancel"), (gint) GTK_RESPONSE_NO);
	_tmp3_ = gtk_dialog_add_button ((GtkDialog*) dialog, _ ("_Delete"), (gint) GTK_RESPONSE_YES);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_button_get_type (), GtkButton));
	delete_button = _tmp4_;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) delete_button);
	gtk_style_context_add_class (_tmp5_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	response = gtk_dialog_run ((GtkDialog*) dialog) == ((gint) GTK_RESPONSE_YES);
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = response;
	_g_object_unref0 (delete_button);
	_g_object_unref0 (dialog);
	return result;
}

gboolean
dialogs_confirm_delete_tag (Tag* tag)
{
	gint count = 0;
	gchar* msg = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (tag != NULL, FALSE);
	count = tag_get_sources_count (tag);
	if (count == 0) {
		result = TRUE;
		return result;
	}
	_tmp0_ = tag_get_user_visible_name (tag);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (ngettext ("This will remove the tag \"%s\" from one photo. Continue?", "This will remove the tag \"%s\" from %d photos. Continue?", (gulong) count), _tmp1_, count);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	msg = _tmp3_;
	_tmp4_ = msg;
	result = dialogs_negate_affirm_question (_tmp4_, RESOURCES_DELETE_TAG_TITLE);
	_g_free0 (msg);
	return result;
}

gboolean
dialogs_confirm_delete_saved_search (SavedSearch* search)
{
	gchar* msg = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (search != NULL, FALSE);
	_tmp0_ = data_object_get_name ((DataObject*) search);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("This will remove the smart album \"%s\". Continue?"), _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	msg = _tmp3_;
	result = dialogs_negate_affirm_question (msg, RESOURCES_DELETE_SAVED_SEARCH_DIALOG_TITLE);
	_g_free0 (msg);
	return result;
}

gboolean
dialogs_confirm_warn_developer_changed (gint number)
{
	gchar* secondary_text = NULL;
	gchar* _tmp0_;
	GraniteMessageDialog* dialog = NULL;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	GraniteMessageDialog* _tmp3_;
	GraniteMessageDialog* _tmp4_;
	AppWindow* _tmp5_;
	AppWindow* _tmp6_;
	GtkButton* switch_button = NULL;
	GtkWidget* _tmp7_;
	GtkButton* _tmp8_;
	GtkStyleContext* _tmp9_;
	gint response = 0;
	gboolean result;
	_tmp0_ = g_strdup (ngettext ("Switching developers will undo all changes you have made to this photo" \
" in Photos", "Switching developers will undo all changes you have made to these phot" \
"os in Photos", (gulong) number));
	secondary_text = _tmp0_;
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("dialog-question");
	_tmp2_ = _tmp1_;
	_tmp3_ = granite_message_dialog_new (_ ("Are You Sure You Want to Switch Developers?"), secondary_text, (GIcon*) _tmp2_, GTK_BUTTONS_CANCEL);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	dialog = _tmp4_;
	_tmp5_ = app_window_get_instance ();
	_tmp6_ = _tmp5_;
	gtk_window_set_transient_for ((GtkWindow*) dialog, (GtkWindow*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = gtk_dialog_add_button ((GtkDialog*) dialog, _ ("_Switch Developer"), (gint) GTK_RESPONSE_YES);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_button_get_type (), GtkButton));
	switch_button = _tmp8_;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) switch_button);
	gtk_style_context_add_class (_tmp9_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = response == ((gint) GTK_RESPONSE_YES);
	_g_object_unref0 (switch_button);
	_g_object_unref0 (dialog);
	_g_free0 (secondary_text);
	return result;
}

GFile*
export_ui_choose_file (const gchar* current_file_basename)
{
	GFile* _tmp0_;
	const gchar* _tmp3_ = NULL;
	GtkFileChooserNative* chooser = NULL;
	AppWindow* _tmp4_;
	AppWindow* _tmp5_;
	GtkFileChooserNative* _tmp6_;
	GtkFileChooserNative* _tmp7_;
	GtkFileChooserNative* _tmp8_;
	GtkFileChooserNative* _tmp9_;
	GFile* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkFileChooserNative* _tmp13_;
	GtkFileChooserNative* _tmp14_;
	GFile* file = NULL;
	GtkFileChooserNative* _tmp15_;
	GtkFileChooserNative* _tmp22_;
	GFile* result;
	g_return_val_if_fail (current_file_basename != NULL, NULL);
	_tmp0_ = export_ui_current_export_dir;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		GFile* _tmp2_;
		_tmp1_ = g_get_home_dir ();
		_tmp2_ = g_file_new_for_path (_tmp1_);
		_g_object_unref0 (export_ui_current_export_dir);
		export_ui_current_export_dir = _tmp2_;
	}
	if (video_reader_is_supported_video_filename (current_file_basename)) {
		_tmp3_ = _ ("Export Video");
	} else {
		_tmp3_ = _ ("Export Photo");
	}
	_tmp4_ = app_window_get_instance ();
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_file_chooser_native_new (_tmp3_, (GtkWindow*) _tmp5_, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Save"), _ ("_Cancel"));
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	chooser = _tmp7_;
	_tmp8_ = chooser;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp8_, TRUE);
	_tmp9_ = chooser;
	_tmp10_ = export_ui_current_export_dir;
	_tmp11_ = g_file_get_path (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp9_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = chooser;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp13_, current_file_basename);
	_tmp14_ = chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp14_, FALSE);
	file = NULL;
	_tmp15_ = chooser;
	if (gtk_native_dialog_run ((GtkNativeDialog*) _tmp15_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		_tmp16_ = chooser;
		_tmp17_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_file_new_for_path (_tmp18_);
		_g_object_unref0 (file);
		file = _tmp19_;
		_g_free0 (_tmp18_);
		_tmp20_ = file;
		_tmp21_ = g_file_get_parent (_tmp20_);
		_g_object_unref0 (export_ui_current_export_dir);
		export_ui_current_export_dir = _tmp21_;
	}
	_tmp22_ = chooser;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp22_);
	result = file;
	_g_object_unref0 (chooser);
	return result;
}

GFile*
export_ui_choose_dir (const gchar* user_title)
{
	GFile* _tmp0_;
	GtkFileChooserNative* chooser = NULL;
	AppWindow* _tmp3_;
	AppWindow* _tmp4_;
	GtkFileChooserNative* _tmp5_;
	GtkFileChooserNative* _tmp6_;
	GtkFileChooserNative* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkFileChooserNative* _tmp11_;
	GFile* dir = NULL;
	GtkFileChooserNative* _tmp12_;
	GtkFileChooserNative* _tmp19_;
	GFile* result;
	_tmp0_ = export_ui_current_export_dir;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		GFile* _tmp2_;
		_tmp1_ = g_get_home_dir ();
		_tmp2_ = g_file_new_for_path (_tmp1_);
		_g_object_unref0 (export_ui_current_export_dir);
		export_ui_current_export_dir = _tmp2_;
	}
	if (user_title == NULL) {
		user_title = _ ("Export Photos");
	}
	_tmp3_ = app_window_get_instance ();
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_file_chooser_native_new (user_title, (GtkWindow*) _tmp4_, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, _ ("_Select"), _ ("_Cancel"));
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	chooser = _tmp6_;
	_tmp7_ = chooser;
	_tmp8_ = export_ui_current_export_dir;
	_tmp9_ = g_file_get_path (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp11_, FALSE);
	dir = NULL;
	_tmp12_ = chooser;
	if (gtk_native_dialog_run ((GtkNativeDialog*) _tmp12_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		GFile* _tmp18_;
		_tmp13_ = chooser;
		_tmp14_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_file_new_for_path (_tmp15_);
		_g_object_unref0 (dir);
		dir = _tmp16_;
		_g_free0 (_tmp15_);
		_tmp17_ = dir;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_g_object_unref0 (export_ui_current_export_dir);
		export_ui_current_export_dir = _tmp18_;
	}
	_tmp19_ = chooser;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp19_);
	result = dir;
	_g_object_unref0 (chooser);
	return result;
}

GtkResponseType
export_error_dialog (GFile* dest,
                     gboolean photos_remaining)
{
	gchar* message = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkResponseType response = 0;
	GtkResponseType result;
	g_return_val_if_fail (dest != NULL, 0);
	_tmp0_ = g_file_get_path (dest);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_ ("Unable to export the following photo due to a file error.\n\n"), _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	message = _tmp3_;
	response = GTK_RESPONSE_NONE;
	if (photos_remaining) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = message;
		_tmp5_ = g_strconcat (_tmp4_, _ ("\n\nWould you like to continue exporting?"), NULL);
		_g_free0 (message);
		message = _tmp5_;
		_tmp6_ = message;
		response = app_window_cancel_affirm_question (_tmp6_, _ ("Con_tinue"), NULL);
	} else {
		const gchar* _tmp7_;
		_tmp7_ = message;
		app_window_error_message (_tmp7_, NULL, NULL);
	}
	result = response;
	_g_free0 (message);
	return result;
}

gchar*
import_ui_generate_import_failure_list (GeeList* failed,
                                        gboolean show_dest_id)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* list = NULL;
	gchar* _tmp2_;
	gint remaining = 0;
	gint _tmp19_;
	gint _tmp20_;
	gchar* result;
	g_return_val_if_fail (failed != NULL, NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) failed);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		result = NULL;
		return result;
	}
	_tmp2_ = g_strdup ("");
	list = _tmp2_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = ctr;
					ctr = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (ctr < IMPORT_UI_REPORT_FAILURE_COUNT) {
					gint _tmp6_;
					gint _tmp7_;
					_tmp6_ = gee_collection_get_size ((GeeCollection*) failed);
					_tmp7_ = _tmp6_;
					_tmp5_ = ctr < _tmp7_;
				} else {
					_tmp5_ = FALSE;
				}
				if (!_tmp5_) {
					break;
				}
				if (show_dest_id) {
					gpointer _tmp9_;
					BatchImportResult* _tmp10_;
					const gchar* _tmp11_;
					_tmp9_ = gee_list_get (failed, ctr);
					_tmp10_ = (BatchImportResult*) _tmp9_;
					_tmp11_ = _tmp10_->dest_identifier;
					_tmp8_ = _tmp11_;
					_batch_import_result_unref0 (_tmp10_);
				} else {
					gpointer _tmp12_;
					BatchImportResult* _tmp13_;
					const gchar* _tmp14_;
					_tmp12_ = gee_list_get (failed, ctr);
					_tmp13_ = (BatchImportResult*) _tmp12_;
					_tmp14_ = _tmp13_->src_identifier;
					_tmp8_ = _tmp14_;
					_batch_import_result_unref0 (_tmp13_);
				}
				_tmp15_ = list;
				_tmp16_ = g_strdup_printf ("%s\n", _tmp8_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
				_g_free0 (list);
				list = _tmp18_;
				_g_free0 (_tmp17_);
			}
		}
	}
	_tmp19_ = gee_collection_get_size ((GeeCollection*) failed);
	_tmp20_ = _tmp19_;
	remaining = _tmp20_ - IMPORT_UI_REPORT_FAILURE_COUNT;
	if (remaining > 0) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = list;
		_tmp22_ = g_strdup_printf (_ ("(and %d more)\n"), remaining);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
		_g_free0 (list);
		list = _tmp24_;
		_g_free0 (_tmp23_);
	}
	result = list;
	return result;
}

ImportUIQuestionParams*
import_ui_question_params_construct (GType object_type,
                                     const gchar* question,
                                     const gchar* yes_button,
                                     const gchar* no_button)
{
	ImportUIQuestionParams* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (question != NULL, NULL);
	g_return_val_if_fail (yes_button != NULL, NULL);
	g_return_val_if_fail (no_button != NULL, NULL);
	self = (ImportUIQuestionParams*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (question);
	_g_free0 (self->question);
	self->question = _tmp0_;
	_tmp1_ = g_strdup (yes_button);
	_g_free0 (self->yes_button);
	self->yes_button = _tmp1_;
	_tmp2_ = g_strdup (no_button);
	_g_free0 (self->no_button);
	self->no_button = _tmp2_;
	return self;
}

ImportUIQuestionParams*
import_ui_question_params_new (const gchar* question,
                               const gchar* yes_button,
                               const gchar* no_button)
{
	return import_ui_question_params_construct (IMPORT_UI_TYPE_QUESTION_PARAMS, question, yes_button, no_button);
}

static void
import_ui_value_question_params_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
import_ui_value_question_params_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		import_ui_question_params_unref (value->data[0].v_pointer);
	}
}

static void
import_ui_value_question_params_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = import_ui_question_params_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
import_ui_value_question_params_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
import_ui_value_question_params_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ImportUIQuestionParams * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = import_ui_question_params_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
import_ui_value_question_params_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	ImportUIQuestionParams ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = import_ui_question_params_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
import_ui_param_spec_question_params (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	ImportUIParamSpecQuestionParams* spec;
	g_return_val_if_fail (g_type_is_a (object_type, IMPORT_UI_TYPE_QUESTION_PARAMS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
import_ui_value_get_question_params (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IMPORT_UI_TYPE_QUESTION_PARAMS), NULL);
	return value->data[0].v_pointer;
}

void
import_ui_value_set_question_params (GValue* value,
                                     gpointer v_object)
{
	ImportUIQuestionParams * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IMPORT_UI_TYPE_QUESTION_PARAMS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IMPORT_UI_TYPE_QUESTION_PARAMS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		import_ui_question_params_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		import_ui_question_params_unref (old);
	}
}

void
import_ui_value_take_question_params (GValue* value,
                                      gpointer v_object)
{
	ImportUIQuestionParams * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IMPORT_UI_TYPE_QUESTION_PARAMS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IMPORT_UI_TYPE_QUESTION_PARAMS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		import_ui_question_params_unref (old);
	}
}

static void
import_ui_question_params_class_init (ImportUIQuestionParamsClass * klass,
                                      gpointer klass_data)
{
	import_ui_question_params_parent_class = g_type_class_peek_parent (klass);
	((ImportUIQuestionParamsClass *) klass)->finalize = import_ui_question_params_finalize;
}

static void
import_ui_question_params_instance_init (ImportUIQuestionParams * self,
                                         gpointer klass)
{
	self->ref_count = 1;
}

static void
import_ui_question_params_finalize (ImportUIQuestionParams * obj)
{
	ImportUIQuestionParams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IMPORT_UI_TYPE_QUESTION_PARAMS, ImportUIQuestionParams);
	g_signal_handlers_destroy (self);
	_g_free0 (self->question);
	_g_free0 (self->yes_button);
	_g_free0 (self->no_button);
}

static GType
import_ui_question_params_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { import_ui_value_question_params_init, import_ui_value_question_params_free_value, import_ui_value_question_params_copy_value, import_ui_value_question_params_peek_pointer, "p", import_ui_value_question_params_collect_value, "p", import_ui_value_question_params_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ImportUIQuestionParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_ui_question_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportUIQuestionParams), 0, (GInstanceInitFunc) import_ui_question_params_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType import_ui_question_params_type_id;
	import_ui_question_params_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ImportUIQuestionParams", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return import_ui_question_params_type_id;
}

GType
import_ui_question_params_get_type (void)
{
	static volatile gsize import_ui_question_params_type_id__once = 0;
	if (g_once_init_enter (&import_ui_question_params_type_id__once)) {
		GType import_ui_question_params_type_id;
		import_ui_question_params_type_id = import_ui_question_params_get_type_once ();
		g_once_init_leave (&import_ui_question_params_type_id__once, import_ui_question_params_type_id);
	}
	return import_ui_question_params_type_id__once;
}

gpointer
import_ui_question_params_ref (gpointer instance)
{
	ImportUIQuestionParams * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
import_ui_question_params_unref (gpointer instance)
{
	ImportUIQuestionParams * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IMPORT_UI_QUESTION_PARAMS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gboolean
import_ui_import_has_photos (GeeCollection* import_collection)
{
	gboolean result;
	g_return_val_if_fail (import_collection != NULL, FALSE);
	{
		GeeIterator* _current_result_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) import_collection);
		_current_result_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			BatchImportResult* current_result = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gboolean _tmp4_ = FALSE;
			BatchImportResult* _tmp5_;
			GFile* _tmp6_;
			_tmp1_ = _current_result_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _current_result_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			current_result = (BatchImportResult*) _tmp3_;
			_tmp5_ = current_result;
			_tmp6_ = _tmp5_->file;
			if (_tmp6_ != NULL) {
				BatchImportResult* _tmp7_;
				GFile* _tmp8_;
				_tmp7_ = current_result;
				_tmp8_ = _tmp7_->file;
				_tmp4_ = photo_file_format_get_by_file_extension (_tmp8_) != PHOTO_FILE_FORMAT_UNKNOWN;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				result = TRUE;
				_batch_import_result_unref0 (current_result);
				_g_object_unref0 (_current_result_it);
				return result;
			}
			_batch_import_result_unref0 (current_result);
		}
		_g_object_unref0 (_current_result_it);
	}
	result = FALSE;
	return result;
}

gboolean
import_ui_import_has_videos (GeeCollection* import_collection)
{
	gboolean result;
	g_return_val_if_fail (import_collection != NULL, FALSE);
	{
		GeeIterator* _current_result_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) import_collection);
		_current_result_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			BatchImportResult* current_result = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gboolean _tmp4_ = FALSE;
			BatchImportResult* _tmp5_;
			GFile* _tmp6_;
			_tmp1_ = _current_result_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _current_result_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			current_result = (BatchImportResult*) _tmp3_;
			_tmp5_ = current_result;
			_tmp6_ = _tmp5_->file;
			if (_tmp6_ != NULL) {
				BatchImportResult* _tmp7_;
				GFile* _tmp8_;
				_tmp7_ = current_result;
				_tmp8_ = _tmp7_->file;
				_tmp4_ = video_reader_is_supported_video_file (_tmp8_);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				result = TRUE;
				_batch_import_result_unref0 (current_result);
				_g_object_unref0 (_current_result_it);
				return result;
			}
			_batch_import_result_unref0 (current_result);
		}
		_g_object_unref0 (_current_result_it);
	}
	result = FALSE;
	return result;
}

gchar*
import_ui_get_media_specific_string (GeeCollection* import_collection,
                                     const gchar* photos_msg,
                                     const gchar* videos_msg,
                                     const gchar* both_msg,
                                     const gchar* neither_msg)
{
	gboolean has_photos = FALSE;
	gboolean has_videos = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* result;
	g_return_val_if_fail (import_collection != NULL, NULL);
	g_return_val_if_fail (photos_msg != NULL, NULL);
	g_return_val_if_fail (videos_msg != NULL, NULL);
	g_return_val_if_fail (both_msg != NULL, NULL);
	g_return_val_if_fail (neither_msg != NULL, NULL);
	has_photos = import_ui_import_has_photos (import_collection);
	has_videos = import_ui_import_has_videos (import_collection);
	if (has_photos) {
		_tmp0_ = has_videos;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (both_msg);
		result = _tmp1_;
		return result;
	} else {
		if (has_photos) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (photos_msg);
			result = _tmp2_;
			return result;
		} else {
			if (has_videos) {
				gchar* _tmp3_;
				_tmp3_ = g_strdup (videos_msg);
				result = _tmp3_;
				return result;
			} else {
				gchar* _tmp4_;
				_tmp4_ = g_strdup (neither_msg);
				result = _tmp4_;
				return result;
			}
		}
	}
}

gchar*
import_ui_create_result_report_from_manifest (ImportManifest* manifest)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gchar* header = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* subhead = NULL;
	GeeList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GeeList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	GeeList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GeeList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	GString* _tmp38_;
	const gchar* _tmp39_;
	gchar* current_file_summary = NULL;
	gchar* _tmp40_;
	GeeList* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	GeeList* _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	GeeList* _tmp103_;
	gint _tmp104_;
	gint _tmp105_;
	GeeList* _tmp132_;
	gint _tmp133_;
	gint _tmp134_;
	GeeList* _tmp161_;
	gint _tmp162_;
	gint _tmp163_;
	GeeList* _tmp194_;
	gint _tmp195_;
	gint _tmp196_;
	GeeList* _tmp223_;
	gint _tmp224_;
	gint _tmp225_;
	GString* _tmp252_;
	const gchar* _tmp253_;
	gchar* _tmp254_;
	gchar* result;
	g_return_val_if_fail (manifest != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = g_strconcat (_ ("Import Results Report"), " (Photos ", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, RESOURCES_APP_VERSION, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, " @ ", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_date_time_new_now_local ();
	_tmp8_ = _tmp7_;
	_tmp9_ = g_date_time_format_iso8601 (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp6_, _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, ")\n\n", NULL);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_date_time_unref0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	header = _tmp14_;
	_tmp15_ = builder;
	_tmp16_ = header;
	g_string_append (_tmp15_, _tmp16_);
	_tmp17_ = manifest->all;
	_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = manifest->all;
	_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup_printf (ngettext ("Attempted to import %d file.", "Attempted to import %d files.", (gulong) _tmp19_), _tmp22_);
	subhead = _tmp23_;
	_tmp24_ = subhead;
	_tmp25_ = g_strconcat (_tmp24_, " ", NULL);
	_g_free0 (subhead);
	subhead = _tmp25_;
	_tmp26_ = subhead;
	_tmp27_ = manifest->success;
	_tmp28_ = gee_collection_get_size ((GeeCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = manifest->success;
	_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strdup_printf (ngettext ("Of these, %d file was successfully imported.", "Of these, %d files were successfully imported.", (gulong) _tmp29_), _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat (_tmp26_, _tmp34_, NULL);
	_g_free0 (subhead);
	subhead = _tmp35_;
	_g_free0 (_tmp34_);
	_tmp36_ = subhead;
	_tmp37_ = g_strconcat (_tmp36_, "\n\n", NULL);
	_g_free0 (subhead);
	subhead = _tmp37_;
	_tmp38_ = builder;
	_tmp39_ = subhead;
	g_string_append (_tmp38_, _tmp39_);
	_tmp40_ = g_strdup ("");
	current_file_summary = _tmp40_;
	_tmp41_ = manifest->already_imported;
	_tmp42_ = gee_collection_get_size ((GeeCollection*) _tmp41_);
	_tmp43_ = _tmp42_;
	if (_tmp43_ > 0) {
		GString* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp44_ = builder;
		_tmp45_ = g_strconcat (_ ("Duplicate Photos/Videos Not Imported:"), "\n\n", NULL);
		_tmp46_ = _tmp45_;
		g_string_append (_tmp44_, _tmp46_);
		_g_free0 (_tmp46_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp47_;
			gint _result_size = 0;
			GeeList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gint _result_index = 0;
			_tmp47_ = manifest->already_imported;
			_result_list = _tmp47_;
			_tmp48_ = _result_list;
			_tmp49_ = gee_collection_get_size ((GeeCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			_result_size = _tmp50_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp51_;
				gint _tmp52_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp53_;
				gpointer _tmp54_;
				BatchImportResult* _tmp55_;
				const gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				BatchImportResult* _tmp63_;
				DuplicatedFile* _tmp64_;
				GFile* _tmp65_;
				GFile* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				GString* _tmp72_;
				const gchar* _tmp73_;
				_result_index = _result_index + 1;
				_tmp51_ = _result_index;
				_tmp52_ = _result_size;
				if (!(_tmp51_ < _tmp52_)) {
					break;
				}
				_tmp53_ = _result_list;
				_tmp54_ = gee_list_get (_tmp53_, _result_index);
				_result_ = (BatchImportResult*) _tmp54_;
				_tmp55_ = _result_;
				_tmp56_ = _tmp55_->src_identifier;
				_tmp57_ = g_strconcat (_tmp56_, " ", NULL);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_strconcat (_tmp58_, _ ("duplicates existing media item"), NULL);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strconcat (_tmp60_, "\n\t", NULL);
				_tmp62_ = _tmp61_;
				_tmp63_ = _result_;
				_tmp64_ = _tmp63_->duplicate_of;
				_tmp65_ = duplicated_file_get_file (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = g_file_get_path (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = g_strconcat (_tmp62_, _tmp68_, NULL);
				_tmp70_ = _tmp69_;
				_tmp71_ = g_strconcat (_tmp70_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp71_;
				_g_free0 (_tmp70_);
				_g_free0 (_tmp68_);
				_g_object_unref0 (_tmp66_);
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
				_g_free0 (_tmp58_);
				_tmp72_ = builder;
				_tmp73_ = current_file_summary;
				g_string_append (_tmp72_, _tmp73_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp74_ = manifest->camera_failed;
	_tmp75_ = gee_collection_get_size ((GeeCollection*) _tmp74_);
	_tmp76_ = _tmp75_;
	if (_tmp76_ > 0) {
		GString* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		_tmp77_ = builder;
		_tmp78_ = g_strconcat (_ ("Photos/Videos Not Imported Due to Camera Errors:"), "\n\n", NULL);
		_tmp79_ = _tmp78_;
		g_string_append (_tmp77_, _tmp79_);
		_g_free0 (_tmp79_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp80_;
			gint _result_size = 0;
			GeeList* _tmp81_;
			gint _tmp82_;
			gint _tmp83_;
			gint _result_index = 0;
			_tmp80_ = manifest->camera_failed;
			_result_list = _tmp80_;
			_tmp81_ = _result_list;
			_tmp82_ = gee_collection_get_size ((GeeCollection*) _tmp81_);
			_tmp83_ = _tmp82_;
			_result_size = _tmp83_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp84_;
				gint _tmp85_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp86_;
				gpointer _tmp87_;
				BatchImportResult* _tmp88_;
				const gchar* _tmp89_;
				gchar* _tmp90_;
				gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				gchar* _tmp95_;
				BatchImportResult* _tmp96_;
				const gchar* _tmp97_;
				gchar* _tmp98_;
				gchar* _tmp99_;
				gchar* _tmp100_;
				GString* _tmp101_;
				const gchar* _tmp102_;
				_result_index = _result_index + 1;
				_tmp84_ = _result_index;
				_tmp85_ = _result_size;
				if (!(_tmp84_ < _tmp85_)) {
					break;
				}
				_tmp86_ = _result_list;
				_tmp87_ = gee_list_get (_tmp86_, _result_index);
				_result_ = (BatchImportResult*) _tmp87_;
				_tmp88_ = _result_;
				_tmp89_ = _tmp88_->src_identifier;
				_tmp90_ = g_strconcat (_tmp89_, "\n\t", NULL);
				_tmp91_ = _tmp90_;
				_tmp92_ = g_strconcat (_tmp91_, _ ("error message:"), NULL);
				_tmp93_ = _tmp92_;
				_tmp94_ = g_strconcat (_tmp93_, " ", NULL);
				_tmp95_ = _tmp94_;
				_tmp96_ = _result_;
				_tmp97_ = _tmp96_->errmsg;
				_tmp98_ = g_strconcat (_tmp95_, _tmp97_, NULL);
				_tmp99_ = _tmp98_;
				_tmp100_ = g_strconcat (_tmp99_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp100_;
				_g_free0 (_tmp99_);
				_g_free0 (_tmp95_);
				_g_free0 (_tmp93_);
				_g_free0 (_tmp91_);
				_tmp101_ = builder;
				_tmp102_ = current_file_summary;
				g_string_append (_tmp101_, _tmp102_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp103_ = manifest->skipped_files;
	_tmp104_ = gee_collection_get_size ((GeeCollection*) _tmp103_);
	_tmp105_ = _tmp104_;
	if (_tmp105_ > 0) {
		GString* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		_tmp106_ = builder;
		_tmp107_ = g_strconcat (_ ("Files Not Imported Because They Weren't Recognized as Photos or Videos" \
":"), "\n\n", NULL);
		_tmp108_ = _tmp107_;
		g_string_append (_tmp106_, _tmp108_);
		_g_free0 (_tmp108_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp109_;
			gint _result_size = 0;
			GeeList* _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			gint _result_index = 0;
			_tmp109_ = manifest->skipped_files;
			_result_list = _tmp109_;
			_tmp110_ = _result_list;
			_tmp111_ = gee_collection_get_size ((GeeCollection*) _tmp110_);
			_tmp112_ = _tmp111_;
			_result_size = _tmp112_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp113_;
				gint _tmp114_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp115_;
				gpointer _tmp116_;
				BatchImportResult* _tmp117_;
				const gchar* _tmp118_;
				gchar* _tmp119_;
				gchar* _tmp120_;
				gchar* _tmp121_;
				gchar* _tmp122_;
				gchar* _tmp123_;
				gchar* _tmp124_;
				BatchImportResult* _tmp125_;
				const gchar* _tmp126_;
				gchar* _tmp127_;
				gchar* _tmp128_;
				gchar* _tmp129_;
				GString* _tmp130_;
				const gchar* _tmp131_;
				_result_index = _result_index + 1;
				_tmp113_ = _result_index;
				_tmp114_ = _result_size;
				if (!(_tmp113_ < _tmp114_)) {
					break;
				}
				_tmp115_ = _result_list;
				_tmp116_ = gee_list_get (_tmp115_, _result_index);
				_result_ = (BatchImportResult*) _tmp116_;
				_tmp117_ = _result_;
				_tmp118_ = _tmp117_->src_identifier;
				_tmp119_ = g_strconcat (_tmp118_, "\n\t", NULL);
				_tmp120_ = _tmp119_;
				_tmp121_ = g_strconcat (_tmp120_, _ ("error message:"), NULL);
				_tmp122_ = _tmp121_;
				_tmp123_ = g_strconcat (_tmp122_, " ", NULL);
				_tmp124_ = _tmp123_;
				_tmp125_ = _result_;
				_tmp126_ = _tmp125_->errmsg;
				_tmp127_ = g_strconcat (_tmp124_, _tmp126_, NULL);
				_tmp128_ = _tmp127_;
				_tmp129_ = g_strconcat (_tmp128_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp129_;
				_g_free0 (_tmp128_);
				_g_free0 (_tmp124_);
				_g_free0 (_tmp122_);
				_g_free0 (_tmp120_);
				_tmp130_ = builder;
				_tmp131_ = current_file_summary;
				g_string_append (_tmp130_, _tmp131_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp132_ = manifest->skipped_photos;
	_tmp133_ = gee_collection_get_size ((GeeCollection*) _tmp132_);
	_tmp134_ = _tmp133_;
	if (_tmp134_ > 0) {
		GString* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		_tmp135_ = builder;
		_tmp136_ = g_strconcat (_ ("Photos/Videos Not Imported Because They Weren't in a Format Photos Und" \
"erstands:"), "\n\n", NULL);
		_tmp137_ = _tmp136_;
		g_string_append (_tmp135_, _tmp137_);
		_g_free0 (_tmp137_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp138_;
			gint _result_size = 0;
			GeeList* _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			gint _result_index = 0;
			_tmp138_ = manifest->skipped_photos;
			_result_list = _tmp138_;
			_tmp139_ = _result_list;
			_tmp140_ = gee_collection_get_size ((GeeCollection*) _tmp139_);
			_tmp141_ = _tmp140_;
			_result_size = _tmp141_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp142_;
				gint _tmp143_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp144_;
				gpointer _tmp145_;
				BatchImportResult* _tmp146_;
				const gchar* _tmp147_;
				gchar* _tmp148_;
				gchar* _tmp149_;
				gchar* _tmp150_;
				gchar* _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				BatchImportResult* _tmp154_;
				const gchar* _tmp155_;
				gchar* _tmp156_;
				gchar* _tmp157_;
				gchar* _tmp158_;
				GString* _tmp159_;
				const gchar* _tmp160_;
				_result_index = _result_index + 1;
				_tmp142_ = _result_index;
				_tmp143_ = _result_size;
				if (!(_tmp142_ < _tmp143_)) {
					break;
				}
				_tmp144_ = _result_list;
				_tmp145_ = gee_list_get (_tmp144_, _result_index);
				_result_ = (BatchImportResult*) _tmp145_;
				_tmp146_ = _result_;
				_tmp147_ = _tmp146_->src_identifier;
				_tmp148_ = g_strconcat (_tmp147_, "\n\t", NULL);
				_tmp149_ = _tmp148_;
				_tmp150_ = g_strconcat (_tmp149_, _ ("error message:"), NULL);
				_tmp151_ = _tmp150_;
				_tmp152_ = g_strconcat (_tmp151_, " ", NULL);
				_tmp153_ = _tmp152_;
				_tmp154_ = _result_;
				_tmp155_ = _tmp154_->errmsg;
				_tmp156_ = g_strconcat (_tmp153_, _tmp155_, NULL);
				_tmp157_ = _tmp156_;
				_tmp158_ = g_strconcat (_tmp157_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp158_;
				_g_free0 (_tmp157_);
				_g_free0 (_tmp153_);
				_g_free0 (_tmp151_);
				_g_free0 (_tmp149_);
				_tmp159_ = builder;
				_tmp160_ = current_file_summary;
				g_string_append (_tmp159_, _tmp160_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp161_ = manifest->write_failed;
	_tmp162_ = gee_collection_get_size ((GeeCollection*) _tmp161_);
	_tmp163_ = _tmp162_;
	if (_tmp163_ > 0) {
		GString* _tmp164_;
		gchar* _tmp165_;
		gchar* _tmp166_;
		_tmp164_ = builder;
		_tmp165_ = g_strconcat (_ ("Photos/Videos Not Imported Because Photos Couldn't Copy Them into its " \
"Library:"), "\n\n", NULL);
		_tmp166_ = _tmp165_;
		g_string_append (_tmp164_, _tmp166_);
		_g_free0 (_tmp166_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp167_;
			gint _result_size = 0;
			GeeList* _tmp168_;
			gint _tmp169_;
			gint _tmp170_;
			gint _result_index = 0;
			_tmp167_ = manifest->write_failed;
			_result_list = _tmp167_;
			_tmp168_ = _result_list;
			_tmp169_ = gee_collection_get_size ((GeeCollection*) _tmp168_);
			_tmp170_ = _tmp169_;
			_result_size = _tmp170_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp171_;
				gint _tmp172_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp173_;
				gpointer _tmp174_;
				BatchImportResult* _tmp175_;
				const gchar* _tmp176_;
				BatchImportResult* _tmp177_;
				const gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				gchar* _tmp181_;
				gchar* _tmp182_;
				gchar* _tmp183_;
				gchar* _tmp184_;
				gchar* _tmp185_;
				gchar* _tmp186_;
				BatchImportResult* _tmp187_;
				const gchar* _tmp188_;
				gchar* _tmp189_;
				gchar* _tmp190_;
				gchar* _tmp191_;
				GString* _tmp192_;
				const gchar* _tmp193_;
				_result_index = _result_index + 1;
				_tmp171_ = _result_index;
				_tmp172_ = _result_size;
				if (!(_tmp171_ < _tmp172_)) {
					break;
				}
				_tmp173_ = _result_list;
				_tmp174_ = gee_list_get (_tmp173_, _result_index);
				_result_ = (BatchImportResult*) _tmp174_;
				_tmp175_ = _result_;
				_tmp176_ = _tmp175_->src_identifier;
				_tmp177_ = _result_;
				_tmp178_ = _tmp177_->dest_identifier;
				_tmp179_ = g_strdup_printf (_ ("couldn't copy %s\n\tto %s"), _tmp176_, _tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = g_strconcat (_tmp180_, "\n\t", NULL);
				_tmp182_ = _tmp181_;
				_tmp183_ = g_strconcat (_tmp182_, _ ("error message:"), NULL);
				_tmp184_ = _tmp183_;
				_tmp185_ = g_strconcat (_tmp184_, " ", NULL);
				_tmp186_ = _tmp185_;
				_tmp187_ = _result_;
				_tmp188_ = _tmp187_->errmsg;
				_tmp189_ = g_strconcat (_tmp186_, _tmp188_, NULL);
				_tmp190_ = _tmp189_;
				_tmp191_ = g_strconcat (_tmp190_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp191_;
				_g_free0 (_tmp190_);
				_g_free0 (_tmp186_);
				_g_free0 (_tmp184_);
				_g_free0 (_tmp182_);
				_g_free0 (_tmp180_);
				_tmp192_ = builder;
				_tmp193_ = current_file_summary;
				g_string_append (_tmp192_, _tmp193_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp194_ = manifest->corrupt_files;
	_tmp195_ = gee_collection_get_size ((GeeCollection*) _tmp194_);
	_tmp196_ = _tmp195_;
	if (_tmp196_ > 0) {
		GString* _tmp197_;
		gchar* _tmp198_;
		gchar* _tmp199_;
		_tmp197_ = builder;
		_tmp198_ = g_strconcat (_ ("Photos/Videos Not Imported Because Files Are Corrupt:"), "\n\n", NULL);
		_tmp199_ = _tmp198_;
		g_string_append (_tmp197_, _tmp199_);
		_g_free0 (_tmp199_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp200_;
			gint _result_size = 0;
			GeeList* _tmp201_;
			gint _tmp202_;
			gint _tmp203_;
			gint _result_index = 0;
			_tmp200_ = manifest->corrupt_files;
			_result_list = _tmp200_;
			_tmp201_ = _result_list;
			_tmp202_ = gee_collection_get_size ((GeeCollection*) _tmp201_);
			_tmp203_ = _tmp202_;
			_result_size = _tmp203_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp204_;
				gint _tmp205_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp206_;
				gpointer _tmp207_;
				BatchImportResult* _tmp208_;
				const gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				gchar* _tmp213_;
				gchar* _tmp214_;
				gchar* _tmp215_;
				BatchImportResult* _tmp216_;
				const gchar* _tmp217_;
				gchar* _tmp218_;
				gchar* _tmp219_;
				gchar* _tmp220_;
				GString* _tmp221_;
				const gchar* _tmp222_;
				_result_index = _result_index + 1;
				_tmp204_ = _result_index;
				_tmp205_ = _result_size;
				if (!(_tmp204_ < _tmp205_)) {
					break;
				}
				_tmp206_ = _result_list;
				_tmp207_ = gee_list_get (_tmp206_, _result_index);
				_result_ = (BatchImportResult*) _tmp207_;
				_tmp208_ = _result_;
				_tmp209_ = _tmp208_->src_identifier;
				_tmp210_ = g_strconcat (_tmp209_, "\n\t", NULL);
				_tmp211_ = _tmp210_;
				_tmp212_ = g_strconcat (_tmp211_, _ ("error message:"), NULL);
				_tmp213_ = _tmp212_;
				_tmp214_ = g_strconcat (_tmp213_, " |", NULL);
				_tmp215_ = _tmp214_;
				_tmp216_ = _result_;
				_tmp217_ = _tmp216_->errmsg;
				_tmp218_ = g_strconcat (_tmp215_, _tmp217_, NULL);
				_tmp219_ = _tmp218_;
				_tmp220_ = g_strconcat (_tmp219_, "|\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp220_;
				_g_free0 (_tmp219_);
				_g_free0 (_tmp215_);
				_g_free0 (_tmp213_);
				_g_free0 (_tmp211_);
				_tmp221_ = builder;
				_tmp222_ = current_file_summary;
				g_string_append (_tmp221_, _tmp222_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp223_ = manifest->failed;
	_tmp224_ = gee_collection_get_size ((GeeCollection*) _tmp223_);
	_tmp225_ = _tmp224_;
	if (_tmp225_ > 0) {
		GString* _tmp226_;
		gchar* _tmp227_;
		gchar* _tmp228_;
		_tmp226_ = builder;
		_tmp227_ = g_strconcat (_ ("Photos/Videos Not Imported for Other Reasons:"), "\n\n", NULL);
		_tmp228_ = _tmp227_;
		g_string_append (_tmp226_, _tmp228_);
		_g_free0 (_tmp228_);
		{
			GeeList* _result_list = NULL;
			GeeList* _tmp229_;
			gint _result_size = 0;
			GeeList* _tmp230_;
			gint _tmp231_;
			gint _tmp232_;
			gint _result_index = 0;
			_tmp229_ = manifest->failed;
			_result_list = _tmp229_;
			_tmp230_ = _result_list;
			_tmp231_ = gee_collection_get_size ((GeeCollection*) _tmp230_);
			_tmp232_ = _tmp231_;
			_result_size = _tmp232_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp233_;
				gint _tmp234_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp235_;
				gpointer _tmp236_;
				BatchImportResult* _tmp237_;
				const gchar* _tmp238_;
				gchar* _tmp239_;
				gchar* _tmp240_;
				gchar* _tmp241_;
				gchar* _tmp242_;
				gchar* _tmp243_;
				gchar* _tmp244_;
				BatchImportResult* _tmp245_;
				const gchar* _tmp246_;
				gchar* _tmp247_;
				gchar* _tmp248_;
				gchar* _tmp249_;
				GString* _tmp250_;
				const gchar* _tmp251_;
				_result_index = _result_index + 1;
				_tmp233_ = _result_index;
				_tmp234_ = _result_size;
				if (!(_tmp233_ < _tmp234_)) {
					break;
				}
				_tmp235_ = _result_list;
				_tmp236_ = gee_list_get (_tmp235_, _result_index);
				_result_ = (BatchImportResult*) _tmp236_;
				_tmp237_ = _result_;
				_tmp238_ = _tmp237_->src_identifier;
				_tmp239_ = g_strconcat (_tmp238_, "\n\t", NULL);
				_tmp240_ = _tmp239_;
				_tmp241_ = g_strconcat (_tmp240_, _ ("error message:"), NULL);
				_tmp242_ = _tmp241_;
				_tmp243_ = g_strconcat (_tmp242_, " ", NULL);
				_tmp244_ = _tmp243_;
				_tmp245_ = _result_;
				_tmp246_ = _tmp245_->errmsg;
				_tmp247_ = g_strconcat (_tmp244_, _tmp246_, NULL);
				_tmp248_ = _tmp247_;
				_tmp249_ = g_strconcat (_tmp248_, "\n\n", NULL);
				_g_free0 (current_file_summary);
				current_file_summary = _tmp249_;
				_g_free0 (_tmp248_);
				_g_free0 (_tmp244_);
				_g_free0 (_tmp242_);
				_g_free0 (_tmp240_);
				_tmp250_ = builder;
				_tmp251_ = current_file_summary;
				g_string_append (_tmp250_, _tmp251_);
				_batch_import_result_unref0 (_result_);
			}
		}
	}
	_tmp252_ = builder;
	_tmp253_ = _tmp252_->str;
	_tmp254_ = g_strdup (_tmp253_);
	result = _tmp254_;
	_g_free0 (current_file_summary);
	_g_free0 (subhead);
	_g_free0 (header);
	_g_string_free0 (builder);
	return result;
}

gboolean
import_ui_report_manifest (ImportManifest* manifest,
                           gboolean show_dest_id,
                           ImportUIQuestionParams* question)
{
	gchar* message = NULL;
	gchar* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeList* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	GeeList* _tmp89_;
	gint _tmp90_;
	gint _tmp91_;
	GeeList* _tmp139_;
	gint _tmp140_;
	gint _tmp141_;
	GeeList* _tmp189_;
	gint _tmp190_;
	gint _tmp191_;
	GeeList* _tmp239_;
	gint _tmp240_;
	gint _tmp241_;
	GeeList* _tmp262_;
	gint _tmp263_;
	gint _tmp264_;
	GeeList* _tmp280_;
	gint _tmp281_;
	gint _tmp282_;
	GeeList* _tmp330_;
	gint _tmp331_;
	gint _tmp332_;
	gint total = 0;
	GeeList* _tmp367_;
	gint _tmp368_;
	gint _tmp369_;
	GeeList* _tmp370_;
	gint _tmp371_;
	gint _tmp372_;
	GeeList* _tmp373_;
	gint _tmp374_;
	gint _tmp375_;
	GeeList* _tmp376_;
	gint _tmp377_;
	gint _tmp378_;
	GeeList* _tmp379_;
	gint _tmp380_;
	gint _tmp381_;
	GeeList* _tmp382_;
	gint _tmp383_;
	gint _tmp384_;
	GeeList* _tmp385_;
	gint _tmp386_;
	gint _tmp387_;
	GeeList* _tmp388_;
	gint _tmp389_;
	gint _tmp390_;
	GeeList* _tmp391_;
	gint _tmp392_;
	gint _tmp393_;
	GeeList* _tmp394_;
	gint _tmp395_;
	gint _tmp396_;
	GraniteMessageDialog* dialog = NULL;
	gint dialog_response = 0;
	gboolean result;
	g_return_val_if_fail (manifest != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	message = _tmp0_;
	_tmp1_ = manifest->already_imported;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		gchar* photos_message = NULL;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GeeList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		gchar* videos_message = NULL;
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GeeList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_;
		gchar* both_message = NULL;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		GeeList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		GeeList* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		GeeList* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp4_ = manifest->already_imported;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = manifest->already_imported;
		_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf (ngettext ("1 duplicate photo was not imported:\n", "%d duplicate photos were not imported:\n", (gulong) _tmp6_), _tmp9_);
		photos_message = _tmp10_;
		_tmp11_ = manifest->already_imported;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = manifest->already_imported;
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf (ngettext ("1 duplicate video was not imported:\n", "%d duplicate videos were not imported:\n", (gulong) _tmp13_), _tmp16_);
		videos_message = _tmp17_;
		_tmp18_ = manifest->already_imported;
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = manifest->already_imported;
		_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf (ngettext ("1 duplicate photo/video was not imported:\n", "%d duplicate photos/videos were not imported:\n", (gulong) _tmp20_), _tmp23_);
		both_message = _tmp24_;
		_tmp25_ = message;
		_tmp26_ = manifest->already_imported;
		_tmp27_ = photos_message;
		_tmp28_ = videos_message;
		_tmp29_ = both_message;
		_tmp30_ = both_message;
		_tmp31_ = import_ui_get_media_specific_string ((GeeCollection*) _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp25_, _tmp32_, NULL);
		_g_free0 (message);
		message = _tmp33_;
		_g_free0 (_tmp32_);
		_tmp34_ = message;
		_tmp35_ = manifest->already_imported;
		_tmp36_ = import_ui_generate_import_failure_list (_tmp35_, show_dest_id);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
		_g_free0 (message);
		message = _tmp38_;
		_g_free0 (_tmp37_);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp39_ = manifest->failed;
	_tmp40_ = gee_collection_get_size ((GeeCollection*) _tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ > 0) {
		const gchar* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gchar* photos_message = NULL;
		GeeList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		GeeList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gchar* _tmp53_;
		gchar* videos_message = NULL;
		GeeList* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		GeeList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gchar* _tmp60_;
		gchar* both_message = NULL;
		GeeList* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		GeeList* _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		gchar* _tmp67_;
		gchar* neither_message = NULL;
		GeeList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		GeeList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gchar* _tmp74_;
		const gchar* _tmp75_;
		GeeList* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp78_;
		const gchar* _tmp79_;
		const gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		const gchar* _tmp84_;
		GeeList* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		_tmp42_ = message;
		_tmp43_ = strlen (_tmp42_);
		_tmp44_ = _tmp43_;
		if (_tmp44_ > 0) {
			const gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp45_ = message;
			_tmp46_ = g_strconcat (_tmp45_, "\n", NULL);
			_g_free0 (message);
			message = _tmp46_;
		}
		_tmp47_ = manifest->failed;
		_tmp48_ = gee_collection_get_size ((GeeCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = manifest->failed;
		_tmp51_ = gee_collection_get_size ((GeeCollection*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strdup_printf (ngettext ("1 photo failed to import due to a file or hardware error:\n", "%d photos failed to import due to a file or hardware error:\n", (gulong) _tmp49_), _tmp52_);
		photos_message = _tmp53_;
		_tmp54_ = manifest->failed;
		_tmp55_ = gee_collection_get_size ((GeeCollection*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = manifest->failed;
		_tmp58_ = gee_collection_get_size ((GeeCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_strdup_printf (ngettext ("1 video failed to import due to a file or hardware error:\n", "%d videos failed to import due to a file or hardware error:\n", (gulong) _tmp56_), _tmp59_);
		videos_message = _tmp60_;
		_tmp61_ = manifest->failed;
		_tmp62_ = gee_collection_get_size ((GeeCollection*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = manifest->failed;
		_tmp65_ = gee_collection_get_size ((GeeCollection*) _tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strdup_printf (ngettext ("1 photo/video failed to import due to a file or hardware error:\n", "%d photos/videos failed to import due to a file or hardware error:\n", (gulong) _tmp63_), _tmp66_);
		both_message = _tmp67_;
		_tmp68_ = manifest->failed;
		_tmp69_ = gee_collection_get_size ((GeeCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = manifest->failed;
		_tmp72_ = gee_collection_get_size ((GeeCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_strdup_printf (ngettext ("1 file failed to import due to a file or hardware error:\n", "%d files failed to import due to a file or hardware error:\n", (gulong) _tmp70_), _tmp73_);
		neither_message = _tmp74_;
		_tmp75_ = message;
		_tmp76_ = manifest->failed;
		_tmp77_ = photos_message;
		_tmp78_ = videos_message;
		_tmp79_ = both_message;
		_tmp80_ = neither_message;
		_tmp81_ = import_ui_get_media_specific_string ((GeeCollection*) _tmp76_, _tmp77_, _tmp78_, _tmp79_, _tmp80_);
		_tmp82_ = _tmp81_;
		_tmp83_ = g_strconcat (_tmp75_, _tmp82_, NULL);
		_g_free0 (message);
		message = _tmp83_;
		_g_free0 (_tmp82_);
		_tmp84_ = message;
		_tmp85_ = manifest->failed;
		_tmp86_ = import_ui_generate_import_failure_list (_tmp85_, show_dest_id);
		_tmp87_ = _tmp86_;
		_tmp88_ = g_strconcat (_tmp84_, _tmp87_, NULL);
		_g_free0 (message);
		message = _tmp88_;
		_g_free0 (_tmp87_);
		_g_free0 (neither_message);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp89_ = manifest->write_failed;
	_tmp90_ = gee_collection_get_size ((GeeCollection*) _tmp89_);
	_tmp91_ = _tmp90_;
	if (_tmp91_ > 0) {
		const gchar* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gchar* photos_message = NULL;
		GeeList* _tmp97_;
		gint _tmp98_;
		gint _tmp99_;
		GeeList* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		gchar* _tmp103_;
		gchar* videos_message = NULL;
		GeeList* _tmp104_;
		gint _tmp105_;
		gint _tmp106_;
		GeeList* _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gchar* _tmp110_;
		gchar* both_message = NULL;
		GeeList* _tmp111_;
		gint _tmp112_;
		gint _tmp113_;
		GeeList* _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		gchar* _tmp117_;
		gchar* neither_message = NULL;
		GeeList* _tmp118_;
		gint _tmp119_;
		gint _tmp120_;
		GeeList* _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gchar* _tmp124_;
		const gchar* _tmp125_;
		GeeList* _tmp126_;
		const gchar* _tmp127_;
		const gchar* _tmp128_;
		const gchar* _tmp129_;
		const gchar* _tmp130_;
		gchar* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		const gchar* _tmp134_;
		GeeList* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		gchar* _tmp138_;
		_tmp92_ = message;
		_tmp93_ = strlen (_tmp92_);
		_tmp94_ = _tmp93_;
		if (_tmp94_ > 0) {
			const gchar* _tmp95_;
			gchar* _tmp96_;
			_tmp95_ = message;
			_tmp96_ = g_strconcat (_tmp95_, "\n", NULL);
			_g_free0 (message);
			message = _tmp96_;
		}
		_tmp97_ = manifest->write_failed;
		_tmp98_ = gee_collection_get_size ((GeeCollection*) _tmp97_);
		_tmp99_ = _tmp98_;
		_tmp100_ = manifest->write_failed;
		_tmp101_ = gee_collection_get_size ((GeeCollection*) _tmp100_);
		_tmp102_ = _tmp101_;
		_tmp103_ = g_strdup_printf (ngettext ("1 photo failed to import because the photo library folder was not writ" \
"able:\n", "%d photos failed to import because the photo library folder was not wr" \
"itable:\n", (gulong) _tmp99_), _tmp102_);
		photos_message = _tmp103_;
		_tmp104_ = manifest->write_failed;
		_tmp105_ = gee_collection_get_size ((GeeCollection*) _tmp104_);
		_tmp106_ = _tmp105_;
		_tmp107_ = manifest->write_failed;
		_tmp108_ = gee_collection_get_size ((GeeCollection*) _tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = g_strdup_printf (ngettext ("1 video failed to import because the photo library folder was not writ" \
"able:\n", "%d videos failed to import because the photo library folder was not wr" \
"itable:\n", (gulong) _tmp106_), _tmp109_);
		videos_message = _tmp110_;
		_tmp111_ = manifest->write_failed;
		_tmp112_ = gee_collection_get_size ((GeeCollection*) _tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = manifest->write_failed;
		_tmp115_ = gee_collection_get_size ((GeeCollection*) _tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = g_strdup_printf (ngettext ("1 photo/video failed to import because the photo library folder was no" \
"t writable:\n", "%d photos/videos failed to import because the photo library folder was" \
" not writable:\n", (gulong) _tmp113_), _tmp116_);
		both_message = _tmp117_;
		_tmp118_ = manifest->write_failed;
		_tmp119_ = gee_collection_get_size ((GeeCollection*) _tmp118_);
		_tmp120_ = _tmp119_;
		_tmp121_ = manifest->write_failed;
		_tmp122_ = gee_collection_get_size ((GeeCollection*) _tmp121_);
		_tmp123_ = _tmp122_;
		_tmp124_ = g_strdup_printf (ngettext ("1 file failed to import because the photo library folder was not writa" \
"ble:\n", "%d files failed to import because the photo library folder was not wri" \
"table:\n", (gulong) _tmp120_), _tmp123_);
		neither_message = _tmp124_;
		_tmp125_ = message;
		_tmp126_ = manifest->write_failed;
		_tmp127_ = photos_message;
		_tmp128_ = videos_message;
		_tmp129_ = both_message;
		_tmp130_ = neither_message;
		_tmp131_ = import_ui_get_media_specific_string ((GeeCollection*) _tmp126_, _tmp127_, _tmp128_, _tmp129_, _tmp130_);
		_tmp132_ = _tmp131_;
		_tmp133_ = g_strconcat (_tmp125_, _tmp132_, NULL);
		_g_free0 (message);
		message = _tmp133_;
		_g_free0 (_tmp132_);
		_tmp134_ = message;
		_tmp135_ = manifest->write_failed;
		_tmp136_ = import_ui_generate_import_failure_list (_tmp135_, show_dest_id);
		_tmp137_ = _tmp136_;
		_tmp138_ = g_strconcat (_tmp134_, _tmp137_, NULL);
		_g_free0 (message);
		message = _tmp138_;
		_g_free0 (_tmp137_);
		_g_free0 (neither_message);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp139_ = manifest->camera_failed;
	_tmp140_ = gee_collection_get_size ((GeeCollection*) _tmp139_);
	_tmp141_ = _tmp140_;
	if (_tmp141_ > 0) {
		const gchar* _tmp142_;
		gint _tmp143_;
		gint _tmp144_;
		gchar* photos_message = NULL;
		GeeList* _tmp147_;
		gint _tmp148_;
		gint _tmp149_;
		GeeList* _tmp150_;
		gint _tmp151_;
		gint _tmp152_;
		gchar* _tmp153_;
		gchar* videos_message = NULL;
		GeeList* _tmp154_;
		gint _tmp155_;
		gint _tmp156_;
		GeeList* _tmp157_;
		gint _tmp158_;
		gint _tmp159_;
		gchar* _tmp160_;
		gchar* both_message = NULL;
		GeeList* _tmp161_;
		gint _tmp162_;
		gint _tmp163_;
		GeeList* _tmp164_;
		gint _tmp165_;
		gint _tmp166_;
		gchar* _tmp167_;
		gchar* neither_message = NULL;
		GeeList* _tmp168_;
		gint _tmp169_;
		gint _tmp170_;
		GeeList* _tmp171_;
		gint _tmp172_;
		gint _tmp173_;
		gchar* _tmp174_;
		const gchar* _tmp175_;
		GeeList* _tmp176_;
		const gchar* _tmp177_;
		const gchar* _tmp178_;
		const gchar* _tmp179_;
		const gchar* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		const gchar* _tmp184_;
		GeeList* _tmp185_;
		gchar* _tmp186_;
		gchar* _tmp187_;
		gchar* _tmp188_;
		_tmp142_ = message;
		_tmp143_ = strlen (_tmp142_);
		_tmp144_ = _tmp143_;
		if (_tmp144_ > 0) {
			const gchar* _tmp145_;
			gchar* _tmp146_;
			_tmp145_ = message;
			_tmp146_ = g_strconcat (_tmp145_, "\n", NULL);
			_g_free0 (message);
			message = _tmp146_;
		}
		_tmp147_ = manifest->camera_failed;
		_tmp148_ = gee_collection_get_size ((GeeCollection*) _tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = manifest->camera_failed;
		_tmp151_ = gee_collection_get_size ((GeeCollection*) _tmp150_);
		_tmp152_ = _tmp151_;
		_tmp153_ = g_strdup_printf (ngettext ("1 photo failed to import due to a camera error:\n", "%d photos failed to import due to a camera error:\n", (gulong) _tmp149_), _tmp152_);
		photos_message = _tmp153_;
		_tmp154_ = manifest->camera_failed;
		_tmp155_ = gee_collection_get_size ((GeeCollection*) _tmp154_);
		_tmp156_ = _tmp155_;
		_tmp157_ = manifest->camera_failed;
		_tmp158_ = gee_collection_get_size ((GeeCollection*) _tmp157_);
		_tmp159_ = _tmp158_;
		_tmp160_ = g_strdup_printf (ngettext ("1 video failed to import due to a camera error:\n", "%d videos failed to import due to a camera error:\n", (gulong) _tmp156_), _tmp159_);
		videos_message = _tmp160_;
		_tmp161_ = manifest->camera_failed;
		_tmp162_ = gee_collection_get_size ((GeeCollection*) _tmp161_);
		_tmp163_ = _tmp162_;
		_tmp164_ = manifest->camera_failed;
		_tmp165_ = gee_collection_get_size ((GeeCollection*) _tmp164_);
		_tmp166_ = _tmp165_;
		_tmp167_ = g_strdup_printf (ngettext ("1 photo/video failed to import due to a camera error:\n", "%d photos/videos failed to import due to a camera error:\n", (gulong) _tmp163_), _tmp166_);
		both_message = _tmp167_;
		_tmp168_ = manifest->camera_failed;
		_tmp169_ = gee_collection_get_size ((GeeCollection*) _tmp168_);
		_tmp170_ = _tmp169_;
		_tmp171_ = manifest->camera_failed;
		_tmp172_ = gee_collection_get_size ((GeeCollection*) _tmp171_);
		_tmp173_ = _tmp172_;
		_tmp174_ = g_strdup_printf (ngettext ("1 file failed to import due to a camera error:\n", "%d files failed to import due to a camera error:\n", (gulong) _tmp170_), _tmp173_);
		neither_message = _tmp174_;
		_tmp175_ = message;
		_tmp176_ = manifest->camera_failed;
		_tmp177_ = photos_message;
		_tmp178_ = videos_message;
		_tmp179_ = both_message;
		_tmp180_ = neither_message;
		_tmp181_ = import_ui_get_media_specific_string ((GeeCollection*) _tmp176_, _tmp177_, _tmp178_, _tmp179_, _tmp180_);
		_tmp182_ = _tmp181_;
		_tmp183_ = g_strconcat (_tmp175_, _tmp182_, NULL);
		_g_free0 (message);
		message = _tmp183_;
		_g_free0 (_tmp182_);
		_tmp184_ = message;
		_tmp185_ = manifest->camera_failed;
		_tmp186_ = import_ui_generate_import_failure_list (_tmp185_, show_dest_id);
		_tmp187_ = _tmp186_;
		_tmp188_ = g_strconcat (_tmp184_, _tmp187_, NULL);
		_g_free0 (message);
		message = _tmp188_;
		_g_free0 (_tmp187_);
		_g_free0 (neither_message);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp189_ = manifest->corrupt_files;
	_tmp190_ = gee_collection_get_size ((GeeCollection*) _tmp189_);
	_tmp191_ = _tmp190_;
	if (_tmp191_ > 0) {
		const gchar* _tmp192_;
		gint _tmp193_;
		gint _tmp194_;
		gchar* photos_message = NULL;
		GeeList* _tmp197_;
		gint _tmp198_;
		gint _tmp199_;
		GeeList* _tmp200_;
		gint _tmp201_;
		gint _tmp202_;
		gchar* _tmp203_;
		gchar* videos_message = NULL;
		GeeList* _tmp204_;
		gint _tmp205_;
		gint _tmp206_;
		GeeList* _tmp207_;
		gint _tmp208_;
		gint _tmp209_;
		gchar* _tmp210_;
		gchar* both_message = NULL;
		GeeList* _tmp211_;
		gint _tmp212_;
		gint _tmp213_;
		GeeList* _tmp214_;
		gint _tmp215_;
		gint _tmp216_;
		gchar* _tmp217_;
		gchar* neither_message = NULL;
		GeeList* _tmp218_;
		gint _tmp219_;
		gint _tmp220_;
		GeeList* _tmp221_;
		gint _tmp222_;
		gint _tmp223_;
		gchar* _tmp224_;
		const gchar* _tmp225_;
		GeeList* _tmp226_;
		const gchar* _tmp227_;
		const gchar* _tmp228_;
		const gchar* _tmp229_;
		const gchar* _tmp230_;
		gchar* _tmp231_;
		gchar* _tmp232_;
		gchar* _tmp233_;
		const gchar* _tmp234_;
		GeeList* _tmp235_;
		gchar* _tmp236_;
		gchar* _tmp237_;
		gchar* _tmp238_;
		_tmp192_ = message;
		_tmp193_ = strlen (_tmp192_);
		_tmp194_ = _tmp193_;
		if (_tmp194_ > 0) {
			const gchar* _tmp195_;
			gchar* _tmp196_;
			_tmp195_ = message;
			_tmp196_ = g_strconcat (_tmp195_, "\n", NULL);
			_g_free0 (message);
			message = _tmp196_;
		}
		_tmp197_ = manifest->corrupt_files;
		_tmp198_ = gee_collection_get_size ((GeeCollection*) _tmp197_);
		_tmp199_ = _tmp198_;
		_tmp200_ = manifest->corrupt_files;
		_tmp201_ = gee_collection_get_size ((GeeCollection*) _tmp200_);
		_tmp202_ = _tmp201_;
		_tmp203_ = g_strdup_printf (ngettext ("1 photo failed to import because it was corrupt:\n", "%d photos failed to import because they were corrupt:\n", (gulong) _tmp199_), _tmp202_);
		photos_message = _tmp203_;
		_tmp204_ = manifest->corrupt_files;
		_tmp205_ = gee_collection_get_size ((GeeCollection*) _tmp204_);
		_tmp206_ = _tmp205_;
		_tmp207_ = manifest->corrupt_files;
		_tmp208_ = gee_collection_get_size ((GeeCollection*) _tmp207_);
		_tmp209_ = _tmp208_;
		_tmp210_ = g_strdup_printf (ngettext ("1 video failed to import because it was corrupt:\n", "%d videos failed to import because they were corrupt:\n", (gulong) _tmp206_), _tmp209_);
		videos_message = _tmp210_;
		_tmp211_ = manifest->corrupt_files;
		_tmp212_ = gee_collection_get_size ((GeeCollection*) _tmp211_);
		_tmp213_ = _tmp212_;
		_tmp214_ = manifest->corrupt_files;
		_tmp215_ = gee_collection_get_size ((GeeCollection*) _tmp214_);
		_tmp216_ = _tmp215_;
		_tmp217_ = g_strdup_printf (ngettext ("1 photo/video failed to import because it was corrupt:\n", "%d photos/videos failed to import because they were corrupt:\n", (gulong) _tmp213_), _tmp216_);
		both_message = _tmp217_;
		_tmp218_ = manifest->corrupt_files;
		_tmp219_ = gee_collection_get_size ((GeeCollection*) _tmp218_);
		_tmp220_ = _tmp219_;
		_tmp221_ = manifest->corrupt_files;
		_tmp222_ = gee_collection_get_size ((GeeCollection*) _tmp221_);
		_tmp223_ = _tmp222_;
		_tmp224_ = g_strdup_printf (ngettext ("1 file failed to import because it was corrupt:\n", "%d files failed to import because it was corrupt:\n", (gulong) _tmp220_), _tmp223_);
		neither_message = _tmp224_;
		_tmp225_ = message;
		_tmp226_ = manifest->corrupt_files;
		_tmp227_ = photos_message;
		_tmp228_ = videos_message;
		_tmp229_ = both_message;
		_tmp230_ = neither_message;
		_tmp231_ = import_ui_get_media_specific_string ((GeeCollection*) _tmp226_, _tmp227_, _tmp228_, _tmp229_, _tmp230_);
		_tmp232_ = _tmp231_;
		_tmp233_ = g_strconcat (_tmp225_, _tmp232_, NULL);
		_g_free0 (message);
		message = _tmp233_;
		_g_free0 (_tmp232_);
		_tmp234_ = message;
		_tmp235_ = manifest->corrupt_files;
		_tmp236_ = import_ui_generate_import_failure_list (_tmp235_, show_dest_id);
		_tmp237_ = _tmp236_;
		_tmp238_ = g_strconcat (_tmp234_, _tmp237_, NULL);
		_g_free0 (message);
		message = _tmp238_;
		_g_free0 (_tmp237_);
		_g_free0 (neither_message);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp239_ = manifest->skipped_photos;
	_tmp240_ = gee_collection_get_size ((GeeCollection*) _tmp239_);
	_tmp241_ = _tmp240_;
	if (_tmp241_ > 0) {
		const gchar* _tmp242_;
		gint _tmp243_;
		gint _tmp244_;
		gchar* skipped_photos_message = NULL;
		GeeList* _tmp247_;
		gint _tmp248_;
		gint _tmp249_;
		GeeList* _tmp250_;
		gint _tmp251_;
		gint _tmp252_;
		gchar* _tmp253_;
		const gchar* _tmp254_;
		const gchar* _tmp255_;
		gchar* _tmp256_;
		const gchar* _tmp257_;
		GeeList* _tmp258_;
		gchar* _tmp259_;
		gchar* _tmp260_;
		gchar* _tmp261_;
		_tmp242_ = message;
		_tmp243_ = strlen (_tmp242_);
		_tmp244_ = _tmp243_;
		if (_tmp244_ > 0) {
			const gchar* _tmp245_;
			gchar* _tmp246_;
			_tmp245_ = message;
			_tmp246_ = g_strconcat (_tmp245_, "\n", NULL);
			_g_free0 (message);
			message = _tmp246_;
		}
		_tmp247_ = manifest->skipped_photos;
		_tmp248_ = gee_collection_get_size ((GeeCollection*) _tmp247_);
		_tmp249_ = _tmp248_;
		_tmp250_ = manifest->skipped_photos;
		_tmp251_ = gee_collection_get_size ((GeeCollection*) _tmp250_);
		_tmp252_ = _tmp251_;
		_tmp253_ = g_strdup_printf (ngettext ("1 unsupported photo skipped:\n", "%d unsupported photos skipped:\n", (gulong) _tmp249_), _tmp252_);
		skipped_photos_message = _tmp253_;
		_tmp254_ = message;
		_tmp255_ = skipped_photos_message;
		_tmp256_ = g_strconcat (_tmp254_, _tmp255_, NULL);
		_g_free0 (message);
		message = _tmp256_;
		_tmp257_ = message;
		_tmp258_ = manifest->skipped_photos;
		_tmp259_ = import_ui_generate_import_failure_list (_tmp258_, show_dest_id);
		_tmp260_ = _tmp259_;
		_tmp261_ = g_strconcat (_tmp257_, _tmp260_, NULL);
		_g_free0 (message);
		message = _tmp261_;
		_g_free0 (_tmp260_);
		_g_free0 (skipped_photos_message);
	}
	_tmp262_ = manifest->skipped_files;
	_tmp263_ = gee_collection_get_size ((GeeCollection*) _tmp262_);
	_tmp264_ = _tmp263_;
	if (_tmp264_ > 0) {
		const gchar* _tmp265_;
		gint _tmp266_;
		gint _tmp267_;
		gchar* skipped_files_message = NULL;
		GeeList* _tmp270_;
		gint _tmp271_;
		gint _tmp272_;
		GeeList* _tmp273_;
		gint _tmp274_;
		gint _tmp275_;
		gchar* _tmp276_;
		const gchar* _tmp277_;
		const gchar* _tmp278_;
		gchar* _tmp279_;
		_tmp265_ = message;
		_tmp266_ = strlen (_tmp265_);
		_tmp267_ = _tmp266_;
		if (_tmp267_ > 0) {
			const gchar* _tmp268_;
			gchar* _tmp269_;
			_tmp268_ = message;
			_tmp269_ = g_strconcat (_tmp268_, "\n", NULL);
			_g_free0 (message);
			message = _tmp269_;
		}
		_tmp270_ = manifest->skipped_files;
		_tmp271_ = gee_collection_get_size ((GeeCollection*) _tmp270_);
		_tmp272_ = _tmp271_;
		_tmp273_ = manifest->skipped_files;
		_tmp274_ = gee_collection_get_size ((GeeCollection*) _tmp273_);
		_tmp275_ = _tmp274_;
		_tmp276_ = g_strdup_printf (ngettext ("1 non-image file skipped.\n", "%d non-image files skipped.\n", (gulong) _tmp272_), _tmp275_);
		skipped_files_message = _tmp276_;
		_tmp277_ = message;
		_tmp278_ = skipped_files_message;
		_tmp279_ = g_strconcat (_tmp277_, _tmp278_, NULL);
		_g_free0 (message);
		message = _tmp279_;
		_g_free0 (skipped_files_message);
	}
	_tmp280_ = manifest->aborted;
	_tmp281_ = gee_collection_get_size ((GeeCollection*) _tmp280_);
	_tmp282_ = _tmp281_;
	if (_tmp282_ > 0) {
		const gchar* _tmp283_;
		gint _tmp284_;
		gint _tmp285_;
		gchar* photos_message = NULL;
		GeeList* _tmp288_;
		gint _tmp289_;
		gint _tmp290_;
		GeeList* _tmp291_;
		gint _tmp292_;
		gint _tmp293_;
		gchar* _tmp294_;
		gchar* videos_message = NULL;
		GeeList* _tmp295_;
		gint _tmp296_;
		gint _tmp297_;
		GeeList* _tmp298_;
		gint _tmp299_;
		gint _tmp300_;
		gchar* _tmp301_;
		gchar* both_message = NULL;
		GeeList* _tmp302_;
		gint _tmp303_;
		gint _tmp304_;
		GeeList* _tmp305_;
		gint _tmp306_;
		gint _tmp307_;
		gchar* _tmp308_;
		gchar* neither_message = NULL;
		GeeList* _tmp309_;
		gint _tmp310_;
		gint _tmp311_;
		GeeList* _tmp312_;
		gint _tmp313_;
		gint _tmp314_;
		gchar* _tmp315_;
		const gchar* _tmp316_;
		GeeList* _tmp317_;
		const gchar* _tmp318_;
		const gchar* _tmp319_;
		const gchar* _tmp320_;
		const gchar* _tmp321_;
		gchar* _tmp322_;
		gchar* _tmp323_;
		gchar* _tmp324_;
		const gchar* _tmp325_;
		GeeList* _tmp326_;
		gchar* _tmp327_;
		gchar* _tmp328_;
		gchar* _tmp329_;
		_tmp283_ = message;
		_tmp284_ = strlen (_tmp283_);
		_tmp285_ = _tmp284_;
		if (_tmp285_ > 0) {
			const gchar* _tmp286_;
			gchar* _tmp287_;
			_tmp286_ = message;
			_tmp287_ = g_strconcat (_tmp286_, "\n", NULL);
			_g_free0 (message);
			message = _tmp287_;
		}
		_tmp288_ = manifest->aborted;
		_tmp289_ = gee_collection_get_size ((GeeCollection*) _tmp288_);
		_tmp290_ = _tmp289_;
		_tmp291_ = manifest->aborted;
		_tmp292_ = gee_collection_get_size ((GeeCollection*) _tmp291_);
		_tmp293_ = _tmp292_;
		_tmp294_ = g_strdup_printf (ngettext ("1 photo skipped due to user cancel:\n", "%d photos skipped due to user cancel:\n", (gulong) _tmp290_), _tmp293_);
		photos_message = _tmp294_;
		_tmp295_ = manifest->aborted;
		_tmp296_ = gee_collection_get_size ((GeeCollection*) _tmp295_);
		_tmp297_ = _tmp296_;
		_tmp298_ = manifest->aborted;
		_tmp299_ = gee_collection_get_size ((GeeCollection*) _tmp298_);
		_tmp300_ = _tmp299_;
		_tmp301_ = g_strdup_printf (ngettext ("1 video skipped due to user cancel:\n", "%d videos skipped due to user cancel:\n", (gulong) _tmp297_), _tmp300_);
		videos_message = _tmp301_;
		_tmp302_ = manifest->aborted;
		_tmp303_ = gee_collection_get_size ((GeeCollection*) _tmp302_);
		_tmp304_ = _tmp303_;
		_tmp305_ = manifest->aborted;
		_tmp306_ = gee_collection_get_size ((GeeCollection*) _tmp305_);
		_tmp307_ = _tmp306_;
		_tmp308_ = g_strdup_printf (ngettext ("1 photo/video skipped due to user cancel:\n", "%d photos/videos skipped due to user cancel:\n", (gulong) _tmp304_), _tmp307_);
		both_message = _tmp308_;
		_tmp309_ = manifest->aborted;
		_tmp310_ = gee_collection_get_size ((GeeCollection*) _tmp309_);
		_tmp311_ = _tmp310_;
		_tmp312_ = manifest->aborted;
		_tmp313_ = gee_collection_get_size ((GeeCollection*) _tmp312_);
		_tmp314_ = _tmp313_;
		_tmp315_ = g_strdup_printf (ngettext ("1 file skipped due to user cancel:\n", "%d file skipped due to user cancel:\n", (gulong) _tmp311_), _tmp314_);
		neither_message = _tmp315_;
		_tmp316_ = message;
		_tmp317_ = manifest->aborted;
		_tmp318_ = photos_message;
		_tmp319_ = videos_message;
		_tmp320_ = both_message;
		_tmp321_ = neither_message;
		_tmp322_ = import_ui_get_media_specific_string ((GeeCollection*) _tmp317_, _tmp318_, _tmp319_, _tmp320_, _tmp321_);
		_tmp323_ = _tmp322_;
		_tmp324_ = g_strconcat (_tmp316_, _tmp323_, NULL);
		_g_free0 (message);
		message = _tmp324_;
		_g_free0 (_tmp323_);
		_tmp325_ = message;
		_tmp326_ = manifest->aborted;
		_tmp327_ = import_ui_generate_import_failure_list (_tmp326_, show_dest_id);
		_tmp328_ = _tmp327_;
		_tmp329_ = g_strconcat (_tmp325_, _tmp328_, NULL);
		_g_free0 (message);
		message = _tmp329_;
		_g_free0 (_tmp328_);
		_g_free0 (neither_message);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp330_ = manifest->success;
	_tmp331_ = gee_collection_get_size ((GeeCollection*) _tmp330_);
	_tmp332_ = _tmp331_;
	if (_tmp332_ > 0) {
		const gchar* _tmp333_;
		gint _tmp334_;
		gint _tmp335_;
		gchar* photos_message = NULL;
		GeeList* _tmp338_;
		gint _tmp339_;
		gint _tmp340_;
		GeeList* _tmp341_;
		gint _tmp342_;
		gint _tmp343_;
		gchar* _tmp344_;
		gchar* videos_message = NULL;
		GeeList* _tmp345_;
		gint _tmp346_;
		gint _tmp347_;
		GeeList* _tmp348_;
		gint _tmp349_;
		gint _tmp350_;
		gchar* _tmp351_;
		gchar* both_message = NULL;
		GeeList* _tmp352_;
		gint _tmp353_;
		gint _tmp354_;
		GeeList* _tmp355_;
		gint _tmp356_;
		gint _tmp357_;
		gchar* _tmp358_;
		const gchar* _tmp359_;
		GeeList* _tmp360_;
		const gchar* _tmp361_;
		const gchar* _tmp362_;
		const gchar* _tmp363_;
		gchar* _tmp364_;
		gchar* _tmp365_;
		gchar* _tmp366_;
		_tmp333_ = message;
		_tmp334_ = strlen (_tmp333_);
		_tmp335_ = _tmp334_;
		if (_tmp335_ > 0) {
			const gchar* _tmp336_;
			gchar* _tmp337_;
			_tmp336_ = message;
			_tmp337_ = g_strconcat (_tmp336_, "\n", NULL);
			_g_free0 (message);
			message = _tmp337_;
		}
		_tmp338_ = manifest->success;
		_tmp339_ = gee_collection_get_size ((GeeCollection*) _tmp338_);
		_tmp340_ = _tmp339_;
		_tmp341_ = manifest->success;
		_tmp342_ = gee_collection_get_size ((GeeCollection*) _tmp341_);
		_tmp343_ = _tmp342_;
		_tmp344_ = g_strdup_printf (ngettext ("1 photo successfully imported.\n", "%d photos successfully imported.\n", (gulong) _tmp340_), _tmp343_);
		photos_message = _tmp344_;
		_tmp345_ = manifest->success;
		_tmp346_ = gee_collection_get_size ((GeeCollection*) _tmp345_);
		_tmp347_ = _tmp346_;
		_tmp348_ = manifest->success;
		_tmp349_ = gee_collection_get_size ((GeeCollection*) _tmp348_);
		_tmp350_ = _tmp349_;
		_tmp351_ = g_strdup_printf (ngettext ("1 video successfully imported.\n", "%d videos successfully imported.\n", (gulong) _tmp347_), _tmp350_);
		videos_message = _tmp351_;
		_tmp352_ = manifest->success;
		_tmp353_ = gee_collection_get_size ((GeeCollection*) _tmp352_);
		_tmp354_ = _tmp353_;
		_tmp355_ = manifest->success;
		_tmp356_ = gee_collection_get_size ((GeeCollection*) _tmp355_);
		_tmp357_ = _tmp356_;
		_tmp358_ = g_strdup_printf (ngettext ("1 photo/video successfully imported.\n", "%d photos/videos successfully imported.\n", (gulong) _tmp354_), _tmp357_);
		both_message = _tmp358_;
		_tmp359_ = message;
		_tmp360_ = manifest->success;
		_tmp361_ = photos_message;
		_tmp362_ = videos_message;
		_tmp363_ = both_message;
		_tmp364_ = import_ui_get_media_specific_string ((GeeCollection*) _tmp360_, _tmp361_, _tmp362_, _tmp363_, "");
		_tmp365_ = _tmp364_;
		_tmp366_ = g_strconcat (_tmp359_, _tmp365_, NULL);
		_g_free0 (message);
		message = _tmp366_;
		_g_free0 (_tmp365_);
		_g_free0 (both_message);
		_g_free0 (videos_message);
		_g_free0 (photos_message);
	}
	_tmp367_ = manifest->success;
	_tmp368_ = gee_collection_get_size ((GeeCollection*) _tmp367_);
	_tmp369_ = _tmp368_;
	_tmp370_ = manifest->failed;
	_tmp371_ = gee_collection_get_size ((GeeCollection*) _tmp370_);
	_tmp372_ = _tmp371_;
	_tmp373_ = manifest->camera_failed;
	_tmp374_ = gee_collection_get_size ((GeeCollection*) _tmp373_);
	_tmp375_ = _tmp374_;
	_tmp376_ = manifest->skipped_photos;
	_tmp377_ = gee_collection_get_size ((GeeCollection*) _tmp376_);
	_tmp378_ = _tmp377_;
	_tmp379_ = manifest->skipped_files;
	_tmp380_ = gee_collection_get_size ((GeeCollection*) _tmp379_);
	_tmp381_ = _tmp380_;
	_tmp382_ = manifest->corrupt_files;
	_tmp383_ = gee_collection_get_size ((GeeCollection*) _tmp382_);
	_tmp384_ = _tmp383_;
	_tmp385_ = manifest->already_imported;
	_tmp386_ = gee_collection_get_size ((GeeCollection*) _tmp385_);
	_tmp387_ = _tmp386_;
	_tmp388_ = manifest->aborted;
	_tmp389_ = gee_collection_get_size ((GeeCollection*) _tmp388_);
	_tmp390_ = _tmp389_;
	_tmp391_ = manifest->write_failed;
	_tmp392_ = gee_collection_get_size ((GeeCollection*) _tmp391_);
	_tmp393_ = _tmp392_;
	total = (((((((_tmp369_ + _tmp372_) + _tmp375_) + _tmp378_) + _tmp381_) + _tmp384_) + _tmp387_) + _tmp390_) + _tmp393_;
	_tmp394_ = manifest->all;
	_tmp395_ = gee_collection_get_size ((GeeCollection*) _tmp394_);
	_tmp396_ = _tmp395_;
	_vala_assert (total == _tmp396_, "total == manifest.all.size");
	if (total == 0) {
		const gchar* _tmp397_;
		gchar* _tmp398_;
		_tmp397_ = message;
		_tmp398_ = g_strconcat (_tmp397_, _ ("No photos or videos imported.\n"), NULL);
		_g_free0 (message);
		message = _tmp398_;
	}
	dialog = NULL;
	dialog_response = (gint) GTK_RESPONSE_NONE;
	if (question == NULL) {
		const gchar* _tmp399_;
		GraniteMessageDialog* _tmp400_;
		GraniteMessageDialog* _tmp401_;
		AppWindow* _tmp402_;
		AppWindow* _tmp403_;
		GtkWidget* save_results_button = NULL;
		GraniteMessageDialog* _tmp404_;
		GtkWidget* _tmp405_;
		GtkWidget* _tmp406_;
		GtkWidget* _tmp407_;
		GeeList* _tmp408_;
		gint _tmp409_;
		gint _tmp410_;
		GeeList* _tmp411_;
		gint _tmp412_;
		gint _tmp413_;
		GtkWidget* ok_button = NULL;
		GraniteMessageDialog* _tmp414_;
		GtkWidget* _tmp415_;
		GtkWidget* _tmp416_;
		GraniteMessageDialog* _tmp417_;
		GtkWidget* _tmp418_;
		GraniteMessageDialog* _tmp419_;
		GraniteMessageDialog* _tmp420_;
		GtkWindow* dialog_parent = NULL;
		GraniteMessageDialog* _tmp421_;
		GtkContainer* _tmp422_;
		GtkWindow* _tmp423_;
		_tmp399_ = message;
		_tmp400_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Import Complete"), _tmp399_, "document-import", GTK_BUTTONS_NONE);
		g_object_ref_sink (_tmp400_);
		_g_object_unref0 (dialog);
		dialog = _tmp400_;
		_tmp401_ = dialog;
		_tmp402_ = app_window_get_instance ();
		_tmp403_ = _tmp402_;
		gtk_window_set_transient_for ((GtkWindow*) _tmp401_, (GtkWindow*) _tmp403_);
		_g_object_unref0 (_tmp403_);
		_tmp404_ = dialog;
		_tmp405_ = gtk_dialog_add_button ((GtkDialog*) _tmp404_, IMPORT_UI_SAVE_RESULTS_BUTTON_NAME, IMPORT_UI_SAVE_RESULTS_RESPONSE_ID);
		_tmp406_ = _g_object_ref0 (_tmp405_);
		save_results_button = _tmp406_;
		_tmp407_ = save_results_button;
		_tmp408_ = manifest->success;
		_tmp409_ = gee_collection_get_size ((GeeCollection*) _tmp408_);
		_tmp410_ = _tmp409_;
		_tmp411_ = manifest->all;
		_tmp412_ = gee_collection_get_size ((GeeCollection*) _tmp411_);
		_tmp413_ = _tmp412_;
		gtk_widget_set_visible (_tmp407_, _tmp410_ < _tmp413_);
		_tmp414_ = dialog;
		_tmp415_ = gtk_dialog_add_button ((GtkDialog*) _tmp414_, _ ("_Done"), (gint) GTK_RESPONSE_OK);
		_tmp416_ = _g_object_ref0 (_tmp415_);
		ok_button = _tmp416_;
		_tmp417_ = dialog;
		_tmp418_ = ok_button;
		gtk_window_set_default ((GtkWindow*) _tmp417_, _tmp418_);
		_tmp419_ = dialog;
		dialog_response = gtk_dialog_run ((GtkDialog*) _tmp419_);
		_tmp420_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp420_);
		_tmp421_ = dialog;
		_tmp422_ = gtk_widget_get_parent ((GtkWidget*) _tmp421_);
		_tmp423_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp422_, gtk_window_get_type (), GtkWindow));
		dialog_parent = _tmp423_;
		if (dialog_response == IMPORT_UI_SAVE_RESULTS_RESPONSE_ID) {
			GtkWindow* _tmp424_;
			gchar* _tmp425_;
			gchar* _tmp426_;
			_tmp424_ = dialog_parent;
			_tmp425_ = import_ui_create_result_report_from_manifest (manifest);
			_tmp426_ = _tmp425_;
			import_ui_save_import_results (_tmp424_, _tmp426_);
			_g_free0 (_tmp426_);
		}
		_g_object_unref0 (dialog_parent);
		_g_object_unref0 (ok_button);
		_g_object_unref0 (save_results_button);
	} else {
		const gchar* _tmp427_;
		const gchar* _tmp428_;
		gchar* _tmp429_;
		gchar* _tmp430_;
		gchar* _tmp431_;
		const gchar* _tmp432_;
		GraniteMessageDialog* _tmp433_;
		GraniteMessageDialog* _tmp434_;
		AppWindow* _tmp435_;
		AppWindow* _tmp436_;
		GtkWidget* save_results_button = NULL;
		GraniteMessageDialog* _tmp437_;
		GtkWidget* _tmp438_;
		GtkWidget* _tmp439_;
		GtkWidget* _tmp440_;
		GeeList* _tmp441_;
		gint _tmp442_;
		gint _tmp443_;
		GeeList* _tmp444_;
		gint _tmp445_;
		gint _tmp446_;
		GtkWidget* no_button = NULL;
		GraniteMessageDialog* _tmp447_;
		const gchar* _tmp448_;
		GtkWidget* _tmp449_;
		GtkWidget* _tmp450_;
		GraniteMessageDialog* _tmp451_;
		const gchar* _tmp452_;
		GraniteMessageDialog* _tmp453_;
		GtkWidget* _tmp454_;
		GraniteMessageDialog* _tmp455_;
		GraniteMessageDialog* _tmp460_;
		GraniteMessageDialog* _tmp461_;
		_tmp427_ = message;
		_tmp428_ = question->question;
		_tmp429_ = g_strconcat ("\n", _tmp428_, NULL);
		_tmp430_ = _tmp429_;
		_tmp431_ = g_strconcat (_tmp427_, _tmp430_, NULL);
		_g_free0 (message);
		message = _tmp431_;
		_g_free0 (_tmp430_);
		_tmp432_ = message;
		_tmp433_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Import Complete"), _tmp432_, "dialog-question", GTK_BUTTONS_NONE);
		g_object_ref_sink (_tmp433_);
		_g_object_unref0 (dialog);
		dialog = _tmp433_;
		_tmp434_ = dialog;
		_tmp435_ = app_window_get_instance ();
		_tmp436_ = _tmp435_;
		gtk_window_set_transient_for ((GtkWindow*) _tmp434_, (GtkWindow*) _tmp436_);
		_g_object_unref0 (_tmp436_);
		_tmp437_ = dialog;
		_tmp438_ = gtk_dialog_add_button ((GtkDialog*) _tmp437_, IMPORT_UI_SAVE_RESULTS_BUTTON_NAME, IMPORT_UI_SAVE_RESULTS_RESPONSE_ID);
		_tmp439_ = _g_object_ref0 (_tmp438_);
		save_results_button = _tmp439_;
		_tmp440_ = save_results_button;
		_tmp441_ = manifest->success;
		_tmp442_ = gee_collection_get_size ((GeeCollection*) _tmp441_);
		_tmp443_ = _tmp442_;
		_tmp444_ = manifest->all;
		_tmp445_ = gee_collection_get_size ((GeeCollection*) _tmp444_);
		_tmp446_ = _tmp445_;
		gtk_widget_set_visible (_tmp440_, _tmp443_ < _tmp446_);
		_tmp447_ = dialog;
		_tmp448_ = question->no_button;
		_tmp449_ = gtk_dialog_add_button ((GtkDialog*) _tmp447_, _tmp448_, (gint) GTK_RESPONSE_NO);
		_tmp450_ = _g_object_ref0 (_tmp449_);
		no_button = _tmp450_;
		_tmp451_ = dialog;
		_tmp452_ = question->yes_button;
		gtk_dialog_add_button ((GtkDialog*) _tmp451_, _tmp452_, (gint) GTK_RESPONSE_YES);
		_tmp453_ = dialog;
		_tmp454_ = no_button;
		gtk_window_set_default ((GtkWindow*) _tmp453_, _tmp454_);
		_tmp455_ = dialog;
		dialog_response = gtk_dialog_run ((GtkDialog*) _tmp455_);
		while (TRUE) {
			GraniteMessageDialog* _tmp456_;
			gchar* _tmp457_;
			gchar* _tmp458_;
			GraniteMessageDialog* _tmp459_;
			if (!(dialog_response == IMPORT_UI_SAVE_RESULTS_RESPONSE_ID)) {
				break;
			}
			_tmp456_ = dialog;
			_tmp457_ = import_ui_create_result_report_from_manifest (manifest);
			_tmp458_ = _tmp457_;
			import_ui_save_import_results ((GtkWindow*) _tmp456_, _tmp458_);
			_g_free0 (_tmp458_);
			_tmp459_ = dialog;
			dialog_response = gtk_dialog_run ((GtkDialog*) _tmp459_);
		}
		_tmp460_ = dialog;
		gtk_widget_hide ((GtkWidget*) _tmp460_);
		_tmp461_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp461_);
		_g_object_unref0 (no_button);
		_g_object_unref0 (save_results_button);
	}
	result = dialog_response == ((gint) GTK_RESPONSE_YES);
	_g_object_unref0 (dialog);
	_g_free0 (message);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
import_ui_save_import_results (GtkWindow* chooser_dialog_parent,
                               const gchar* results_log)
{
	GtkFileChooserNative* chooser_dialog = NULL;
	GtkFileChooserNative* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	const gchar* _tmp3_;
	GtkFileChooserNative* _tmp4_;
	GtkFileChooserNative* _tmp5_;
	gint dialog_result = 0;
	GtkFileChooserNative* _tmp6_;
	GFile* chosen_file = NULL;
	GtkFileChooserNative* _tmp7_;
	GFile* _tmp8_;
	GtkFileChooserNative* _tmp9_;
	GtkFileChooserNative* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (results_log != NULL);
	_tmp0_ = gtk_file_chooser_native_new (IMPORT_UI_SAVE_RESULTS_FILE_CHOOSER_TITLE, chooser_dialog_parent, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Save"), _ ("_Cancel"));
	chooser_dialog = _tmp0_;
	_tmp1_ = chooser_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp1_, TRUE);
	_tmp2_ = chooser_dialog;
	_tmp3_ = g_get_home_dir ();
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp2_, _tmp3_);
	_tmp4_ = chooser_dialog;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp4_, "Photos Import Log.txt");
	_tmp5_ = chooser_dialog;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp5_, FALSE);
	_tmp6_ = chooser_dialog;
	dialog_result = gtk_native_dialog_run ((GtkNativeDialog*) _tmp6_);
	_tmp7_ = chooser_dialog;
	_tmp8_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp7_);
	chosen_file = _tmp8_;
	_tmp9_ = chooser_dialog;
	gtk_native_dialog_hide ((GtkNativeDialog*) _tmp9_);
	_tmp10_ = chooser_dialog;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp10_);
	if (dialog_result == ((gint) GTK_RESPONSE_ACCEPT)) {
		GFile* _tmp12_;
		_tmp12_ = chosen_file;
		_tmp11_ = _tmp12_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		{
			GFileOutputStream* outstream = NULL;
			GFile* _tmp13_;
			GFileOutputStream* _tmp14_;
			GFileOutputStream* _tmp15_;
			guint8* _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_ = 0;
			guint8* _tmp18_;
			gint _tmp18__length1;
			GFileOutputStream* _tmp19_;
			_tmp13_ = chosen_file;
			_tmp14_ = g_file_replace (_tmp13_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
			outstream = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp15_ = outstream;
			_tmp16_ = string_get_data (results_log, &_tmp17_);
			_tmp16__length1 = _tmp17_;
			_tmp18_ = _tmp16_;
			_tmp18__length1 = _tmp16__length1;
			g_output_stream_write ((GOutputStream*) _tmp15_, _tmp18_, (gsize) _tmp18__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (outstream);
				goto __catch0_g_error;
			}
			_tmp19_ = outstream;
			g_output_stream_close ((GOutputStream*) _tmp19_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (outstream);
				goto __catch0_g_error;
			}
			_g_object_unref0 (outstream);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GFile* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GError* _tmp23_;
			const gchar* _tmp24_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp20_ = chosen_file;
			_tmp21_ = g_file_get_path (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = err;
			_tmp24_ = _tmp23_->message;
			g_critical ("Dialogs.vala:635: couldn't save import results to log file %s: %s", _tmp22_, _tmp24_);
			_g_free0 (_tmp22_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (chosen_file);
			_g_object_unref0 (chooser_dialog);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (chosen_file);
	_g_object_unref0 (chooser_dialog);
}

static inline gpointer
text_entry_dialog_mediator_get_instance_private (TextEntryDialogMediator* self)
{
	return G_STRUCT_MEMBER_P (self, TextEntryDialogMediator_private_offset);
}

static gboolean
_text_entry_dialog_mediator_on_modify_validate_text_entry_dialog_on_modify_validate_type (const gchar* text,
                                                                                          gpointer self)
{
	gboolean result;
	result = text_entry_dialog_mediator_on_modify_validate ((TextEntryDialogMediator*) self, text);
	return result;
}

TextEntryDialogMediator*
text_entry_dialog_mediator_construct (GType object_type,
                                      const gchar* title,
                                      const gchar* label,
                                      const gchar* initial_text,
                                      GeeCollection* completion_list,
                                      const gchar* completion_delimiter)
{
	TextEntryDialogMediator* self = NULL;
	TextEntryDialog* _tmp0_;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	self = (TextEntryDialogMediator*) g_type_create_instance (object_type);
	_tmp0_ = text_entry_dialog_new (_text_entry_dialog_mediator_on_modify_validate_text_entry_dialog_on_modify_validate_type, self, title, label, initial_text, completion_list, completion_delimiter);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp0_;
	return self;
}

static gboolean
text_entry_dialog_mediator_real_on_modify_validate (TextEntryDialogMediator* self,
                                                    const gchar* text)
{
	gboolean result;
	g_return_val_if_fail (text != NULL, FALSE);
	result = TRUE;
	return result;
}

gboolean
text_entry_dialog_mediator_on_modify_validate (TextEntryDialogMediator* self,
                                               const gchar* text)
{
	TextEntryDialogMediatorClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = TEXT_ENTRY_DIALOG_MEDIATOR_GET_CLASS (self);
	if (_klass_->on_modify_validate) {
		return _klass_->on_modify_validate (self, text);
	}
	return FALSE;
}

gchar*
_text_entry_dialog_mediator_execute (TextEntryDialogMediator* self)
{
	TextEntryDialog* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dialog;
	_tmp1_ = text_entry_dialog_execute (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
value_text_entry_dialog_mediator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_text_entry_dialog_mediator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		text_entry_dialog_mediator_unref (value->data[0].v_pointer);
	}
}

static void
value_text_entry_dialog_mediator_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = text_entry_dialog_mediator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_text_entry_dialog_mediator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_text_entry_dialog_mediator_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TextEntryDialogMediator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = text_entry_dialog_mediator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_text_entry_dialog_mediator_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	TextEntryDialogMediator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = text_entry_dialog_mediator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_text_entry_dialog_mediator (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecTextEntryDialogMediator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_text_entry_dialog_mediator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR), NULL);
	return value->data[0].v_pointer;
}

void
value_set_text_entry_dialog_mediator (GValue* value,
                                      gpointer v_object)
{
	TextEntryDialogMediator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		text_entry_dialog_mediator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_entry_dialog_mediator_unref (old);
	}
}

void
value_take_text_entry_dialog_mediator (GValue* value,
                                       gpointer v_object)
{
	TextEntryDialogMediator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_entry_dialog_mediator_unref (old);
	}
}

static void
text_entry_dialog_mediator_class_init (TextEntryDialogMediatorClass * klass,
                                       gpointer klass_data)
{
	text_entry_dialog_mediator_parent_class = g_type_class_peek_parent (klass);
	((TextEntryDialogMediatorClass *) klass)->finalize = text_entry_dialog_mediator_finalize;
	g_type_class_adjust_private_offset (klass, &TextEntryDialogMediator_private_offset);
	((TextEntryDialogMediatorClass *) klass)->on_modify_validate = (gboolean (*) (TextEntryDialogMediator*, const gchar*)) text_entry_dialog_mediator_real_on_modify_validate;
}

static void
text_entry_dialog_mediator_instance_init (TextEntryDialogMediator * self,
                                          gpointer klass)
{
	self->priv = text_entry_dialog_mediator_get_instance_private (self);
	self->ref_count = 1;
}

static void
text_entry_dialog_mediator_finalize (TextEntryDialogMediator * obj)
{
	TextEntryDialogMediator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, TextEntryDialogMediator);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->dialog);
}

static GType
text_entry_dialog_mediator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_text_entry_dialog_mediator_init, value_text_entry_dialog_mediator_free_value, value_text_entry_dialog_mediator_copy_value, value_text_entry_dialog_mediator_peek_pointer, "p", value_text_entry_dialog_mediator_collect_value, "p", value_text_entry_dialog_mediator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TextEntryDialogMediatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_entry_dialog_mediator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextEntryDialogMediator), 0, (GInstanceInitFunc) text_entry_dialog_mediator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType text_entry_dialog_mediator_type_id;
	text_entry_dialog_mediator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TextEntryDialogMediator", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	TextEntryDialogMediator_private_offset = g_type_add_instance_private (text_entry_dialog_mediator_type_id, sizeof (TextEntryDialogMediatorPrivate));
	return text_entry_dialog_mediator_type_id;
}

GType
text_entry_dialog_mediator_get_type (void)
{
	static volatile gsize text_entry_dialog_mediator_type_id__once = 0;
	if (g_once_init_enter (&text_entry_dialog_mediator_type_id__once)) {
		GType text_entry_dialog_mediator_type_id;
		text_entry_dialog_mediator_type_id = text_entry_dialog_mediator_get_type_once ();
		g_once_init_leave (&text_entry_dialog_mediator_type_id__once, text_entry_dialog_mediator_type_id);
	}
	return text_entry_dialog_mediator_type_id__once;
}

gpointer
text_entry_dialog_mediator_ref (gpointer instance)
{
	TextEntryDialogMediator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
text_entry_dialog_mediator_unref (gpointer instance)
{
	TextEntryDialogMediator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEXT_ENTRY_DIALOG_MEDIATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gchar*
build_alert_body_text (const gchar* primary_text,
                       const gchar* secondary_text,
                       gboolean should_escape)
{
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	if (should_escape) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = guarded_markup_escape_text (primary_text);
		_tmp1_ = _tmp0_;
		_tmp2_ = guarded_markup_escape_text (secondary_text);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("<span weight=\"Bold\" size=\"larger\">%s</span>\n%s", _tmp1_, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = guarded_markup_escape_text (primary_text);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("<span weight=\"Bold\" size=\"larger\">%s</span>\n%s", _tmp7_, secondary_text);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	result = _tmp9_;
	return result;
}

static inline gpointer
entry_multi_completion_get_instance_private (EntryMultiCompletion* self)
{
	return G_STRUCT_MEMBER_P (self, EntryMultiCompletion_private_offset);
}

static gboolean
_entry_multi_completion_match_func_gtk_entry_completion_match_func (GtkEntryCompletion* completion,
                                                                    const gchar* key,
                                                                    GtkTreeIter* iter,
                                                                    gpointer self)
{
	gboolean result;
	result = entry_multi_completion_match_func ((EntryMultiCompletion*) self, completion, key, iter);
	return result;
}

EntryMultiCompletion*
entry_multi_completion_construct (GType object_type,
                                  GeeCollection* completion_list,
                                  const gchar* delimiter)
{
	EntryMultiCompletion * self = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	GtkListStore* _tmp4_;
	GtkListStore* _tmp5_;
	g_return_val_if_fail (completion_list != NULL, NULL);
	self = (EntryMultiCompletion*) g_object_new (object_type, NULL);
	if (delimiter == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (delimiter);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 1;
	}
	_vala_assert (_tmp0_, "delimiter == null || delimiter.length == 1");
	_tmp3_ = g_strdup (delimiter);
	_g_free0 (self->priv->delimiter);
	self->priv->delimiter = _tmp3_;
	_tmp4_ = entry_multi_completion_create_completion_store (completion_list);
	_tmp5_ = _tmp4_;
	gtk_entry_completion_set_model ((GtkEntryCompletion*) self, (GtkTreeModel*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	gtk_entry_completion_set_text_column ((GtkEntryCompletion*) self, 0);
	gtk_entry_completion_set_match_func ((GtkEntryCompletion*) self, _entry_multi_completion_match_func_gtk_entry_completion_match_func, g_object_ref (self), g_object_unref);
	return self;
}

EntryMultiCompletion*
entry_multi_completion_new (GeeCollection* completion_list,
                            const gchar* delimiter)
{
	return entry_multi_completion_construct (TYPE_ENTRY_MULTI_COMPLETION, completion_list, delimiter);
}

static GtkListStore*
entry_multi_completion_create_completion_store (GeeCollection* completion_list)
{
	GtkListStore* completion_store = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter store_iter = {0};
	GeeIterator* completion_iter = NULL;
	GeeIterator* _tmp1_;
	GtkListStore* result;
	g_return_val_if_fail (completion_list != NULL, NULL);
	_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
	completion_store = _tmp0_;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) completion_list);
	completion_iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		GtkListStore* _tmp5_;
		GtkTreeIter _tmp6_;
		GeeIterator* _tmp7_;
		gpointer _tmp8_;
		gchar* _tmp9_;
		_tmp2_ = completion_iter;
		if (!gee_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = completion_store;
		gtk_list_store_append (_tmp3_, &_tmp4_);
		store_iter = _tmp4_;
		_tmp5_ = completion_store;
		_tmp6_ = store_iter;
		_tmp7_ = completion_iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		_tmp9_ = (gchar*) _tmp8_;
		gtk_list_store_set (_tmp5_, &_tmp6_, 0, _tmp9_, -1, -1);
		_g_free0 (_tmp9_);
	}
	result = completion_store;
	_g_object_unref0 (completion_iter);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
entry_multi_completion_match_func (EntryMultiCompletion* self,
                                   GtkEntryCompletion* completion,
                                   const gchar* key,
                                   GtkTreeIter* iter)
{
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	gchar* possible_match = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* normed_key = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (completion != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = gtk_entry_completion_get_model (completion);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = *iter;
	gtk_tree_model_get (_tmp2_, &_tmp3_, 0, &_tmp4_, -1);
	_g_free0 (possible_match);
	possible_match = _tmp4_;
	_tmp5_ = possible_match;
	_tmp6_ = g_utf8_casefold (_tmp5_, (gssize) -1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_normalize (_tmp7_, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
	_g_free0 (possible_match);
	possible_match = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = g_utf8_normalize (key, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
	normed_key = _tmp9_;
	_tmp10_ = self->priv->delimiter;
	if (_tmp10_ == NULL) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
		_tmp11_ = possible_match;
		_tmp12_ = normed_key;
		_tmp13_ = string_strip (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_str_has_prefix (_tmp11_, _tmp14_);
		_g_free0 (_tmp14_);
		result = _tmp15_;
		_g_free0 (normed_key);
		_g_free0 (possible_match);
		_g_object_unref0 (model);
		return result;
	} else {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* last_part = NULL;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gboolean _tmp35_;
		_tmp16_ = normed_key;
		_tmp17_ = self->priv->delimiter;
		if (string_contains (_tmp16_, _tmp17_)) {
			gint offset = 0;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gint position = 0;
			GtkWidget* _tmp21_;
			_tmp18_ = normed_key;
			_tmp19_ = normed_key;
			_tmp20_ = self->priv->delimiter;
			offset = g_utf8_strlen (_tmp18_, (gssize) string_last_index_of_char (_tmp19_, (gunichar) string_get (_tmp20_, (glong) 0), 0));
			_tmp21_ = gtk_entry_completion_get_entry ((GtkEntryCompletion*) self);
			position = gtk_editable_get_position ((GtkEditable*) G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_entry_get_type (), GtkEntry));
			if (position <= offset) {
				result = FALSE;
				_g_free0 (normed_key);
				_g_free0 (possible_match);
				_g_object_unref0 (model);
				return result;
			}
		}
		_tmp22_ = normed_key;
		_tmp23_ = string_strip (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->delimiter;
		_tmp26_ = entry_multi_completion_get_last_part (_tmp24_, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp24_);
		last_part = _tmp27_;
		_tmp28_ = last_part;
		_tmp29_ = strlen (_tmp28_);
		_tmp30_ = _tmp29_;
		if (_tmp30_ == 0) {
			result = FALSE;
			_g_free0 (last_part);
			_g_free0 (normed_key);
			_g_free0 (possible_match);
			_g_object_unref0 (model);
			return result;
		}
		_tmp31_ = possible_match;
		_tmp32_ = last_part;
		_tmp33_ = string_strip (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_str_has_prefix (_tmp31_, _tmp34_);
		_g_free0 (_tmp34_);
		result = _tmp35_;
		_g_free0 (last_part);
		_g_free0 (normed_key);
		_g_free0 (possible_match);
		_g_object_unref0 (model);
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
entry_multi_completion_real_match_selected (GtkEntryCompletion* base,
                                            GtkTreeModel* model,
                                            GtkTreeIter* iter)
{
	EntryMultiCompletion * self;
	gchar* match = NULL;
	GtkTreeIter _tmp0_;
	gchar* _tmp1_ = NULL;
	GtkEntry* entry = NULL;
	GtkWidget* _tmp2_;
	GtkEntry* _tmp3_;
	gchar* old_text = NULL;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_;
	gchar* new_text = NULL;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GtkEntry* _tmp32_;
	GtkEntry* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gboolean result;
	self = (EntryMultiCompletion*) base;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1);
	_g_free0 (match);
	match = _tmp1_;
	_tmp2_ = gtk_entry_completion_get_entry ((GtkEntryCompletion*) self);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_entry_get_type (), GtkEntry));
	entry = _tmp3_;
	_tmp4_ = entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = g_utf8_normalize (_tmp5_, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
	old_text = _tmp6_;
	_tmp7_ = old_text;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ > 0) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = old_text;
		_tmp11_ = self->priv->delimiter;
		if (string_contains (_tmp10_, _tmp11_)) {
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp13_ = self->priv->delimiter;
			if (g_strcmp0 (_tmp13_, " ") != 0) {
				_tmp12_ = " ";
			} else {
				_tmp12_ = "";
			}
			_tmp14_ = old_text;
			_tmp15_ = old_text;
			_tmp16_ = self->priv->delimiter;
			_tmp17_ = string_substring (_tmp14_, (glong) 0, (glong) (string_last_index_of_char (_tmp15_, (gunichar) string_get (_tmp16_, (glong) 0), 0) + 1));
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, _tmp12_, NULL);
			_g_free0 (old_text);
			old_text = _tmp19_;
			_g_free0 (_tmp18_);
		} else {
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("");
			_g_free0 (old_text);
			old_text = _tmp20_;
		}
	}
	_tmp22_ = self->priv->delimiter;
	if (g_strcmp0 (_tmp22_, " ") != 0) {
		_tmp21_ = " ";
	} else {
		_tmp21_ = "";
	}
	_tmp23_ = old_text;
	_tmp24_ = match;
	_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->delimiter;
	_tmp28_ = g_strconcat (_tmp26_, _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat (_tmp29_, _tmp21_, NULL);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	_g_free0 (_tmp26_);
	new_text = _tmp31_;
	_tmp32_ = entry;
	gtk_entry_set_text (_tmp32_, new_text);
	_tmp33_ = entry;
	_tmp34_ = strlen (new_text);
	_tmp35_ = _tmp34_;
	gtk_editable_set_position ((GtkEditable*) _tmp33_, (gint) _tmp35_);
	result = TRUE;
	_g_free0 (new_text);
	_g_free0 (old_text);
	_g_object_unref0 (entry);
	_g_free0 (match);
	return result;
}

static gchar*
entry_multi_completion_get_last_part (const gchar* s,
                                      const gchar* delimiter)
{
	gchar** split = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint split_length1;
	gint _split_size_;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	g_return_val_if_fail (delimiter != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (s, delimiter, 0);
	split = _tmp1_;
	split_length1 = _vala_array_length (_tmp0_);
	_split_size_ = split_length1;
	_tmp3_ = split;
	_tmp3__length1 = split_length1;
	if (_tmp3_ != NULL) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		_tmp4_ = split;
		_tmp4__length1 = split_length1;
		_tmp5_ = _tmp4_[0];
		_tmp2_ = _tmp5_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = split;
		_tmp6__length1 = split_length1;
		_tmp7_ = split;
		_tmp7__length1 = split_length1;
		_tmp8_ = _tmp6_[_tmp7__length1 - 1];
		_tmp9_ = g_strdup (_tmp8_);
		result = _tmp9_;
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		result = _tmp10_;
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
}

static void
entry_multi_completion_class_init (EntryMultiCompletionClass * klass,
                                   gpointer klass_data)
{
	entry_multi_completion_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EntryMultiCompletion_private_offset);
	((GtkEntryCompletionClass *) klass)->match_selected = (gboolean (*) (GtkEntryCompletion*, GtkTreeModel*, GtkTreeIter*)) entry_multi_completion_real_match_selected;
	G_OBJECT_CLASS (klass)->finalize = entry_multi_completion_finalize;
}

static void
entry_multi_completion_instance_init (EntryMultiCompletion * self,
                                      gpointer klass)
{
	self->priv = entry_multi_completion_get_instance_private (self);
}

static void
entry_multi_completion_finalize (GObject * obj)
{
	EntryMultiCompletion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletion);
	_g_free0 (self->priv->delimiter);
	G_OBJECT_CLASS (entry_multi_completion_parent_class)->finalize (obj);
}

static GType
entry_multi_completion_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EntryMultiCompletionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) entry_multi_completion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EntryMultiCompletion), 0, (GInstanceInitFunc) entry_multi_completion_instance_init, NULL };
	GType entry_multi_completion_type_id;
	entry_multi_completion_type_id = g_type_register_static (gtk_entry_completion_get_type (), "EntryMultiCompletion", &g_define_type_info, 0);
	EntryMultiCompletion_private_offset = g_type_add_instance_private (entry_multi_completion_type_id, sizeof (EntryMultiCompletionPrivate));
	return entry_multi_completion_type_id;
}

GType
entry_multi_completion_get_type (void)
{
	static volatile gsize entry_multi_completion_type_id__once = 0;
	if (g_once_init_enter (&entry_multi_completion_type_id__once)) {
		GType entry_multi_completion_type_id;
		entry_multi_completion_type_id = entry_multi_completion_get_type_once ();
		g_once_init_leave (&entry_multi_completion_type_id__once, entry_multi_completion_type_id);
	}
	return entry_multi_completion_type_id__once;
}

EventRenameDialog*
event_rename_dialog_construct (GType object_type,
                               const gchar* event_name)
{
	EventRenameDialog* self = NULL;
	self = (EventRenameDialog*) text_entry_dialog_mediator_construct (object_type, _ ("Rename Event"), _ ("Name:"), event_name, NULL, NULL);
	return self;
}

EventRenameDialog*
event_rename_dialog_new (const gchar* event_name)
{
	return event_rename_dialog_construct (TYPE_EVENT_RENAME_DIALOG, event_name);
}

static gchar*
event_rename_dialog_real_execute (EventRenameDialog* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = _text_entry_dialog_mediator_execute ((TextEntryDialogMediator*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = event_prep_event_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
event_rename_dialog_execute (EventRenameDialog* self)
{
	EventRenameDialogClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = EVENT_RENAME_DIALOG_GET_CLASS (self);
	if (_klass_->execute) {
		return _klass_->execute (self);
	}
	return NULL;
}

static void
event_rename_dialog_class_init (EventRenameDialogClass * klass,
                                gpointer klass_data)
{
	event_rename_dialog_parent_class = g_type_class_peek_parent (klass);
	((EventRenameDialogClass *) klass)->execute = (gchar* (*) (EventRenameDialog*)) event_rename_dialog_real_execute;
}

static void
event_rename_dialog_instance_init (EventRenameDialog * self,
                                   gpointer klass)
{
}

static GType
event_rename_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventRenameDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_rename_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventRenameDialog), 0, (GInstanceInitFunc) event_rename_dialog_instance_init, NULL };
	GType event_rename_dialog_type_id;
	event_rename_dialog_type_id = g_type_register_static (TYPE_TEXT_ENTRY_DIALOG_MEDIATOR, "EventRenameDialog", &g_define_type_info, 0);
	return event_rename_dialog_type_id;
}

GType
event_rename_dialog_get_type (void)
{
	static volatile gsize event_rename_dialog_type_id__once = 0;
	if (g_once_init_enter (&event_rename_dialog_type_id__once)) {
		GType event_rename_dialog_type_id;
		event_rename_dialog_type_id = event_rename_dialog_get_type_once ();
		g_once_init_leave (&event_rename_dialog_type_id__once, event_rename_dialog_type_id);
	}
	return event_rename_dialog_type_id__once;
}

gboolean
revert_editable_dialog (GtkWindow* parent,
                        GeeCollection* photos)
{
	gint count = 0;
	gchar* primary_text = NULL;
	gchar* _tmp6_;
	gchar* secondary_text = NULL;
	gchar* _tmp7_;
	gchar* action = NULL;
	gchar* _tmp8_;
	GraniteMessageDialog* dialog = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GraniteMessageDialog* _tmp11_;
	GraniteMessageDialog* _tmp12_;
	GtkWidget* revert_button = NULL;
	GraniteMessageDialog* _tmp13_;
	const gchar* _tmp14_;
	GtkWidget* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkResponseType _result_ = 0;
	GraniteMessageDialog* _tmp19_;
	GraniteMessageDialog* _tmp20_;
	gboolean result;
	g_return_val_if_fail (parent != NULL, FALSE);
	g_return_val_if_fail (photos != NULL, FALSE);
	count = 0;
	{
		GeeIterator* _photo_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) photos);
		_photo_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			Photo* photo = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			Photo* _tmp4_;
			_tmp1_ = _photo_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _photo_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			photo = (Photo*) _tmp3_;
			_tmp4_ = photo;
			if (photo_has_editable (_tmp4_)) {
				gint _tmp5_;
				_tmp5_ = count;
				count = _tmp5_ + 1;
			}
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
	if (count == 0) {
		result = FALSE;
		return result;
	}
	_tmp6_ = g_strdup (ngettext ("Revert External Edit?", "Revert External Edits?", (gulong) count));
	primary_text = _tmp6_;
	_tmp7_ = g_strdup_printf (ngettext ("This will destroy all changes made to the external file. Continue?", "This will destroy all changes made to %d external files. Continue?", (gulong) count), count);
	secondary_text = _tmp7_;
	_tmp8_ = g_strdup (ngettext ("Re_vert External Edit", "Re_vert External Edits", (gulong) count));
	action = _tmp8_;
	_tmp9_ = primary_text;
	_tmp10_ = secondary_text;
	_tmp11_ = granite_message_dialog_new_with_image_from_icon_name (_tmp9_, _tmp10_, "dialog-warning", GTK_BUTTONS_CANCEL);
	g_object_ref_sink (_tmp11_);
	dialog = _tmp11_;
	_tmp12_ = dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp12_, parent);
	_tmp13_ = dialog;
	_tmp14_ = action;
	_tmp15_ = gtk_dialog_add_button ((GtkDialog*) _tmp13_, _tmp14_, (gint) GTK_RESPONSE_YES);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	revert_button = _tmp16_;
	_tmp17_ = revert_button;
	_tmp18_ = gtk_widget_get_style_context (_tmp17_);
	gtk_style_context_add_class (_tmp18_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp19_ = dialog;
	_result_ = (GtkResponseType) gtk_dialog_run ((GtkDialog*) _tmp19_);
	_tmp20_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp20_);
	result = _result_ == GTK_RESPONSE_YES;
	_g_object_unref0 (revert_button);
	_g_object_unref0 (dialog);
	_g_free0 (action);
	_g_free0 (secondary_text);
	_g_free0 (primary_text);
	return result;
}

gboolean
remove_offline_dialog (GtkWindow* owner,
                       gint count)
{
	gchar* primary_text = NULL;
	gchar* _tmp0_;
	gchar* secondary_text = NULL;
	gchar* _tmp1_;
	GraniteMessageDialog* dialog = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GraniteMessageDialog* _tmp4_;
	GraniteMessageDialog* _tmp5_;
	GtkButton* remove_button = NULL;
	GraniteMessageDialog* _tmp6_;
	GtkWidget* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkResponseType _result_ = 0;
	GraniteMessageDialog* _tmp11_;
	GraniteMessageDialog* _tmp12_;
	gboolean result;
	g_return_val_if_fail (owner != NULL, FALSE);
	if (count == 0) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_strdup (ngettext (_ ("Remove Photo From Library"), _ ("Remove Photos From Library"), (gulong) count));
	primary_text = _tmp0_;
	_tmp1_ = g_strdup_printf (ngettext ("This will remove the photo from the library. Continue?", "This will remove %d photos from the library. Continue?", (gulong) count), count);
	secondary_text = _tmp1_;
	_tmp2_ = primary_text;
	_tmp3_ = secondary_text;
	_tmp4_ = granite_message_dialog_new_with_image_from_icon_name (_tmp2_, _tmp3_, "dialog-warning", GTK_BUTTONS_CANCEL);
	g_object_ref_sink (_tmp4_);
	dialog = _tmp4_;
	_tmp5_ = dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, owner);
	_tmp6_ = dialog;
	_tmp7_ = gtk_dialog_add_button ((GtkDialog*) _tmp6_, _ ("_Remove"), (gint) GTK_RESPONSE_OK);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_button_get_type (), GtkButton));
	remove_button = _tmp8_;
	_tmp9_ = remove_button;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_add_class (_tmp10_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp11_ = dialog;
	_result_ = (GtkResponseType) gtk_dialog_run ((GtkDialog*) _tmp11_);
	_tmp12_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp12_);
	result = _result_ == GTK_RESPONSE_OK;
	_g_object_unref0 (remove_button);
	_g_object_unref0 (dialog);
	_g_free0 (secondary_text);
	_g_free0 (primary_text);
	return result;
}

void
multiple_object_error_dialog (GeeArrayList* objects,
                              const gchar* message,
                              const gchar* title)
{
	gchar* dialog_message = NULL;
	gchar* _tmp0_;
	gint remainder = 0;
	gint _tmp14_;
	gint _tmp15_;
	GraniteMessageDialog* dialog = NULL;
	const gchar* _tmp20_;
	GraniteMessageDialog* _tmp21_;
	AppWindow* _tmp22_;
	AppWindow* _tmp23_;
	g_return_if_fail (objects != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = g_strconcat (message, "\n", NULL);
	dialog_message = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp6_;
				gpointer _tmp7_;
				DataObject* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (i < MAX_OBJECTS_DISPLAYED) {
					gint _tmp4_;
					gint _tmp5_;
					_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) objects);
					_tmp5_ = _tmp4_;
					_tmp3_ = _tmp5_ > i;
				} else {
					_tmp3_ = FALSE;
				}
				if (!_tmp3_) {
					break;
				}
				_tmp6_ = dialog_message;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) objects, i);
				_tmp8_ = (DataObject*) _tmp7_;
				_tmp9_ = data_object_to_string (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat ("\n", _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp6_, _tmp12_, NULL);
				_g_free0 (dialog_message);
				dialog_message = _tmp13_;
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
				_g_object_unref0 (_tmp8_);
			}
		}
	}
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) objects);
	_tmp15_ = _tmp14_;
	remainder = _tmp15_ - MAX_OBJECTS_DISPLAYED;
	if (remainder > 0) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp16_ = dialog_message;
		_tmp17_ = g_strdup_printf (ngettext ("\n\nAnd %d other.", "\n\nAnd %d others.", (gulong) remainder), remainder);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp16_, _tmp18_, NULL);
		_g_free0 (dialog_message);
		dialog_message = _tmp19_;
		_g_free0 (_tmp18_);
	}
	_tmp20_ = dialog_message;
	_tmp21_ = granite_message_dialog_new_with_image_from_icon_name (title, _tmp20_, "dialog-error", GTK_BUTTONS_CLOSE);
	g_object_ref_sink (_tmp21_);
	dialog = _tmp21_;
	_tmp22_ = app_window_get_instance ();
	_tmp23_ = _tmp22_;
	gtk_window_set_transient_for ((GtkWindow*) dialog, (GtkWindow*) _tmp23_);
	_g_object_unref0 (_tmp23_);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_free0 (dialog_message);
}

void
welcome_service_entry_execute (WelcomeServiceEntry* self)
{
	WelcomeServiceEntryIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = WELCOME_SERVICE_ENTRY_GET_INTERFACE (self);
	if (_iface_->execute) {
		_iface_->execute (self);
	}
}

static void
welcome_service_entry_default_init (WelcomeServiceEntryIface * iface,
                                    gpointer iface_data)
{
}

static GType
welcome_service_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WelcomeServiceEntryIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) welcome_service_entry_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType welcome_service_entry_type_id;
	welcome_service_entry_type_id = g_type_register_static (G_TYPE_INTERFACE, "WelcomeServiceEntry", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (welcome_service_entry_type_id, G_TYPE_OBJECT);
	return welcome_service_entry_type_id;
}

GType
welcome_service_entry_get_type (void)
{
	static volatile gsize welcome_service_entry_type_id__once = 0;
	if (g_once_init_enter (&welcome_service_entry_type_id__once)) {
		GType welcome_service_entry_type_id;
		welcome_service_entry_type_id = welcome_service_entry_get_type_once ();
		g_once_init_leave (&welcome_service_entry_type_id__once, welcome_service_entry_type_id);
	}
	return welcome_service_entry_type_id__once;
}

GtkResponseType
copy_files_dialog (void)
{
	gchar* msg = NULL;
	gchar* _tmp0_;
	GraniteMessageDialog* dialog = NULL;
	GraniteMessageDialog* _tmp1_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	GtkResponseType _result_ = 0;
	GtkResponseType result;
	_tmp0_ = g_strdup (_ ("Photos can copy the photos into your library folder or it can import t" \
"hem without copying."));
	msg = _tmp0_;
	_tmp1_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Import to Library"), msg, "dialog-question", GTK_BUTTONS_CANCEL);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	gtk_window_set_transient_for ((GtkWindow*) dialog, (GtkWindow*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	gtk_dialog_add_button ((GtkDialog*) dialog, _ ("Co_py Photos"), (gint) GTK_RESPONSE_ACCEPT);
	gtk_dialog_add_button ((GtkDialog*) dialog, _ ("_Import in Place"), (gint) GTK_RESPONSE_REJECT);
	_result_ = (GtkResponseType) gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_;
	_g_object_unref0 (dialog);
	_g_free0 (msg);
	return result;
}

void
remove_photos_from_library (GeeCollection* photos)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (photos != NULL);
	_tmp0_ = gee_collection_get_size (photos);
	_tmp1_ = _tmp0_;
	remove_from_app (photos, _ ("Remove From Library"), ngettext ("Removing Photo From Library", "Removing Photos From Library", (gulong) _tmp1_), FALSE);
}

static gboolean
_progress_dialog_monitor_progress_monitor (guint64 current,
                                           guint64 total,
                                           gboolean do_event_loop,
                                           gpointer self)
{
	gboolean result;
	result = progress_dialog_monitor ((ProgressDialog*) self, current, total, do_event_loop);
	return result;
}

void
remove_from_app (GeeCollection* sources,
                 const gchar* dialog_title,
                 const gchar* progress_dialog_text,
                 gboolean delete_files)
{
	gint _tmp0_;
	gint _tmp1_;
	GeeArrayList* photos = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* videos = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	AppWindow* _tmp6_;
	AppWindow* _tmp7_;
	ProgressDialog* progress = NULL;
	ProgressMonitor monitor = NULL;
	gpointer monitor_target;
	GDestroyNotify monitor_target_destroy_notify;
	gint _tmp8_;
	gint _tmp9_;
	LibraryPhotoSourceCollection* _tmp14_;
	GeeArrayList* _tmp15_;
	ProgressMonitor _tmp16_;
	gpointer _tmp16__target;
	VideoSourceCollection* _tmp17_;
	GeeArrayList* _tmp18_;
	ProgressMonitor _tmp19_;
	gpointer _tmp19__target;
	ProgressDialog* _tmp38_;
	AppWindow* _tmp40_;
	AppWindow* _tmp41_;
	g_return_if_fail (sources != NULL);
	g_return_if_fail (dialog_title != NULL);
	g_return_if_fail (progress_dialog_text != NULL);
	_tmp0_ = gee_collection_get_size (sources);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	_tmp2_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	photos = _tmp2_;
	_tmp3_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	videos = _tmp3_;
	_tmp4_ = photos;
	_tmp5_ = videos;
	media_source_collection_filter_media (sources, (GeeCollection*) _tmp4_, (GeeCollection*) _tmp5_);
	_tmp6_ = app_window_get_instance ();
	_tmp7_ = _tmp6_;
	page_window_set_busy_cursor ((PageWindow*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	progress = NULL;
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	_tmp8_ = gee_collection_get_size (sources);
	_tmp9_ = _tmp8_;
	if (_tmp9_ >= 20) {
		AppWindow* _tmp10_;
		AppWindow* _tmp11_;
		ProgressDialog* _tmp12_;
		ProgressDialog* _tmp13_;
		_tmp10_ = app_window_get_instance ();
		_tmp11_ = _tmp10_;
		_tmp12_ = progress_dialog_new ((GtkWindow*) _tmp11_, progress_dialog_text, NULL);
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (progress);
		progress = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_tmp13_ = progress;
		(monitor_target_destroy_notify == NULL) ? NULL : (monitor_target_destroy_notify (monitor_target), NULL);
		monitor = NULL;
		monitor_target = NULL;
		monitor_target_destroy_notify = NULL;
		monitor = _progress_dialog_monitor_progress_monitor;
		monitor_target = g_object_ref (_tmp13_);
		monitor_target_destroy_notify = g_object_unref;
	}
	_tmp14_ = library_photo_global;
	_tmp15_ = photos;
	_tmp16_ = monitor;
	_tmp16__target = monitor_target;
	media_source_collection_remove_from_app ((MediaSourceCollection*) _tmp14_, (GeeCollection*) _tmp15_, delete_files, _tmp16_, _tmp16__target, NULL);
	_tmp17_ = video_global;
	_tmp18_ = videos;
	_tmp19_ = monitor;
	_tmp19__target = monitor_target;
	media_source_collection_remove_from_app ((MediaSourceCollection*) _tmp17_, (GeeCollection*) _tmp18_, delete_files, _tmp19_, _tmp19__target, NULL);
	if (delete_files) {
		GeeArrayList* not_deleted_photos = NULL;
		GeeArrayList* _tmp20_;
		GeeArrayList* not_deleted_videos = NULL;
		GeeArrayList* _tmp21_;
		LibraryPhotoSourceCollection* _tmp22_;
		GeeArrayList* _tmp23_;
		ProgressMonitor _tmp24_;
		gpointer _tmp24__target;
		GeeArrayList* _tmp25_;
		VideoSourceCollection* _tmp26_;
		GeeArrayList* _tmp27_;
		ProgressMonitor _tmp28_;
		gpointer _tmp28__target;
		GeeArrayList* _tmp29_;
		gint num_not_deleted = 0;
		GeeArrayList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		GeeArrayList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp20_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		not_deleted_photos = _tmp20_;
		_tmp21_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		not_deleted_videos = _tmp21_;
		_tmp22_ = library_photo_global;
		_tmp23_ = photos;
		_tmp24_ = monitor;
		_tmp24__target = monitor_target;
		_tmp25_ = not_deleted_photos;
		media_source_collection_delete_backing_files ((MediaSourceCollection*) _tmp22_, (GeeCollection*) _tmp23_, _tmp24_, _tmp24__target, (GeeList*) _tmp25_);
		_tmp26_ = video_global;
		_tmp27_ = videos;
		_tmp28_ = monitor;
		_tmp28__target = monitor_target;
		_tmp29_ = not_deleted_videos;
		media_source_collection_delete_backing_files ((MediaSourceCollection*) _tmp26_, (GeeCollection*) _tmp27_, _tmp28_, _tmp28__target, (GeeList*) _tmp29_);
		_tmp30_ = not_deleted_photos;
		_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = not_deleted_videos;
		_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		num_not_deleted = _tmp32_ + _tmp35_;
		if (num_not_deleted > 0) {
			gchar* delete_failed_message = NULL;
			gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp36_ = g_strdup_printf (ngettext ("The photo or video cannot be deleted.", "%d photos/videos cannot be deleted.", (gulong) num_not_deleted), num_not_deleted);
			delete_failed_message = _tmp36_;
			_tmp37_ = delete_failed_message;
			app_window_error_message (dialog_title, _tmp37_, NULL);
			_g_free0 (delete_failed_message);
		}
		_g_object_unref0 (not_deleted_videos);
		_g_object_unref0 (not_deleted_photos);
	}
	_tmp38_ = progress;
	if (_tmp38_ != NULL) {
		ProgressDialog* _tmp39_;
		_tmp39_ = progress;
		progress_dialog_close (_tmp39_);
	}
	_tmp40_ = app_window_get_instance ();
	_tmp41_ = _tmp40_;
	page_window_set_normal_cursor ((PageWindow*) _tmp41_);
	_g_object_unref0 (_tmp41_);
	(monitor_target_destroy_notify == NULL) ? NULL : (monitor_target_destroy_notify (monitor_target), NULL);
	monitor = NULL;
	monitor_target = NULL;
	monitor_target_destroy_notify = NULL;
	_g_object_unref0 (progress);
	_g_object_unref0 (videos);
	_g_object_unref0 (photos);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

