#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkEnSightWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMultiBlockPLOT3DReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNek5000Reader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPChacoReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPDataSetReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPDataSetWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPImageWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPlot3DMetaReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPOpenFOAMReader_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIOParallelCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkEnSightWriter_Init(csi);
  vtkMultiBlockPLOT3DReader_Init(csi);
  vtkNek5000Reader_Init(csi);
  vtkPChacoReader_Init(csi);
  vtkPDataSetReader_Init(csi);
  vtkPDataSetWriter_Init(csi);
  vtkPImageWriter_Init(csi);
  vtkPlot3DMetaReader_Init(csi);
  vtkPOpenFOAMReader_Init(csi);
}
