// python wrapper for vtkSMTrace
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMTrace.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMTrace(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMTrace_ClassNew(); }

#ifndef DECLARED_PyvtkSMObject_ClassNew
extern "C" { PyObject *PyvtkSMObject_ClassNew(); }
#define DECLARED_PyvtkSMObject_ClassNew
#endif

static PyObject *
PyvtkSMTrace_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMTrace::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMTrace::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMTrace *tempr = vtkSMTrace::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMTrace *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMTrace::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMTrace::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMTrace::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetActiveTracer(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetActiveTracer");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkSMTrace *tempr = vtkSMTrace::GetActiveTracer();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_StartTrace(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "StartTrace");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    vtkSMTrace *tempr = vtkSMTrace::StartTrace(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_StopTrace(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "StopTrace");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    std::string tempr = vtkSMTrace::StopTrace();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_SetTraceXMLDefaults(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTraceXMLDefaults");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTraceXMLDefaults(temp0);
    }
    else
    {
      op->vtkSMTrace::SetTraceXMLDefaults(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetTraceXMLDefaults(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTraceXMLDefaults");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTraceXMLDefaults() :
      op->vtkSMTrace::GetTraceXMLDefaults());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_SetLogTraceToStdout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLogTraceToStdout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLogTraceToStdout(temp0);
    }
    else
    {
      op->vtkSMTrace::SetLogTraceToStdout(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetLogTraceToStdout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLogTraceToStdout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLogTraceToStdout() :
      op->vtkSMTrace::GetLogTraceToStdout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_SetFullyTraceSupplementalProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFullyTraceSupplementalProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFullyTraceSupplementalProxies(temp0);
    }
    else
    {
      op->vtkSMTrace::SetFullyTraceSupplementalProxies(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetFullyTraceSupplementalProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFullyTraceSupplementalProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFullyTraceSupplementalProxies() :
      op->vtkSMTrace::GetFullyTraceSupplementalProxies());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_SetSkipRenderingComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSkipRenderingComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSkipRenderingComponents(temp0);
    }
    else
    {
      op->vtkSMTrace::SetSkipRenderingComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetSkipRenderingComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSkipRenderingComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSkipRenderingComponents() :
      op->vtkSMTrace::GetSkipRenderingComponents());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_SetFullyTraceCameraAdjustments(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFullyTraceCameraAdjustments");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFullyTraceCameraAdjustments(temp0);
    }
    else
    {
      op->vtkSMTrace::SetFullyTraceCameraAdjustments(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetFullyTraceCameraAdjustments(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFullyTraceCameraAdjustments");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFullyTraceCameraAdjustments() :
      op->vtkSMTrace::GetFullyTraceCameraAdjustments());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_SetPropertiesToTraceOnCreate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPropertiesToTraceOnCreate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPropertiesToTraceOnCreate(temp0);
    }
    else
    {
      op->vtkSMTrace::SetPropertiesToTraceOnCreate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetPropertiesToTraceOnCreateMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPropertiesToTraceOnCreateMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPropertiesToTraceOnCreateMinValue() :
      op->vtkSMTrace::GetPropertiesToTraceOnCreateMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetPropertiesToTraceOnCreateMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPropertiesToTraceOnCreateMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPropertiesToTraceOnCreateMaxValue() :
      op->vtkSMTrace::GetPropertiesToTraceOnCreateMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetPropertiesToTraceOnCreate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPropertiesToTraceOnCreate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPropertiesToTraceOnCreate() :
      op->vtkSMTrace::GetPropertiesToTraceOnCreate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetCurrentTrace(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCurrentTrace");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTrace *op = static_cast<vtkSMTrace *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetCurrentTrace() :
      op->vtkSMTrace::GetCurrentTrace());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTrace_GetState(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetState");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    std::string tempr = vtkSMTrace::GetState(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMTrace_Methods[] = {
  {"IsTypeOf", PyvtkSMTrace_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMTrace_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMTrace_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMTrace\nC++: static vtkSMTrace *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMTrace_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMTrace\nC++: vtkSMTrace *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMTrace_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMTrace_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetActiveTracer", PyvtkSMTrace_GetActiveTracer, METH_VARARGS,
   "GetActiveTracer() -> vtkSMTrace\nC++: static vtkSMTrace *GetActiveTracer()\n\nProvides access to the \"active\" tracer. There can only be one\nactive tracer in the application currently.\n"},
  {"StartTrace", PyvtkSMTrace_StartTrace, METH_VARARGS,
   "StartTrace(preamble:str=...) -> vtkSMTrace\nC++: static vtkSMTrace *StartTrace(const char *preamble=nullptr)\n\nMethods to start/stop tracing. This will create a new instance of\nvtkSMTrace and set that up as the active tracer. If an active\ntracer is already present, then this will simply return the\ncurrent active tracer.\n\n@arg `preamble` non-null string to use as the header for the\ngenerated\n     trace. If nullptr, then a default preamble using ParaView\nversion\n     number will be used. If empty string, then no preamble will\n     be added added.\n"},
  {"StopTrace", PyvtkSMTrace_StopTrace, METH_VARARGS,
   "StopTrace() -> str\nC++: static std::string StopTrace()\n\nStop trace and return the generated trace script. This will also\ndestroy the active tracer.\n"},
  {"SetTraceXMLDefaults", PyvtkSMTrace_SetTraceXMLDefaults, METH_VARARGS,
   "SetTraceXMLDefaults(self, _arg:bool) -> None\nC++: virtual void SetTraceXMLDefaults(bool _arg)\n\nGet/Set whether all properties should be saved for a proxy,\nincluding the default values. If false, only the properties that\nhave been modified from the XML-defaults will be logged.\n"},
  {"GetTraceXMLDefaults", PyvtkSMTrace_GetTraceXMLDefaults, METH_VARARGS,
   "GetTraceXMLDefaults(self) -> bool\nC++: virtual bool GetTraceXMLDefaults()\n\n"},
  {"SetLogTraceToStdout", PyvtkSMTrace_SetLogTraceToStdout, METH_VARARGS,
   "SetLogTraceToStdout(self, _arg:bool) -> None\nC++: virtual void SetLogTraceToStdout(bool _arg)\n\nLog generated trace to stdout as the trace is being generated\n(useful for debugging).\n"},
  {"GetLogTraceToStdout", PyvtkSMTrace_GetLogTraceToStdout, METH_VARARGS,
   "GetLogTraceToStdout(self) -> bool\nC++: virtual bool GetLogTraceToStdout()\n\n"},
  {"SetFullyTraceSupplementalProxies", PyvtkSMTrace_SetFullyTraceSupplementalProxies, METH_VARARGS,
   "SetFullyTraceSupplementalProxies(self, _arg:bool) -> None\nC++: virtual void SetFullyTraceSupplementalProxies(bool _arg)\n\nSupplemental proxies are proxies that not explicitly created by\nthe user i.e. proxies such as lookup tables, scalar bars,\nanimation scene, etc. When set to true (default is false), the\nfirst time such a proxy is encountered in the trace, the trace\nwill log the property values on that proxy using the\nPropertiesToTraceOnCreate rules.\n"},
  {"GetFullyTraceSupplementalProxies", PyvtkSMTrace_GetFullyTraceSupplementalProxies, METH_VARARGS,
   "GetFullyTraceSupplementalProxies(self) -> bool\nC++: virtual bool GetFullyTraceSupplementalProxies()\n\n"},
  {"SetSkipRenderingComponents", PyvtkSMTrace_SetSkipRenderingComponents, METH_VARARGS,
   "SetSkipRenderingComponents(self, _arg:bool) -> None\nC++: virtual void SetSkipRenderingComponents(bool _arg)\n\nSkip rendering components such as views, representations.\n"},
  {"GetSkipRenderingComponents", PyvtkSMTrace_GetSkipRenderingComponents, METH_VARARGS,
   "GetSkipRenderingComponents(self) -> bool\nC++: virtual bool GetSkipRenderingComponents()\n\n"},
  {"SetFullyTraceCameraAdjustments", PyvtkSMTrace_SetFullyTraceCameraAdjustments, METH_VARARGS,
   "SetFullyTraceCameraAdjustments(self, _arg:bool) -> None\nC++: virtual void SetFullyTraceCameraAdjustments(bool _arg)\n\nThe trace will include camera interaction. (default false)\n"},
  {"GetFullyTraceCameraAdjustments", PyvtkSMTrace_GetFullyTraceCameraAdjustments, METH_VARARGS,
   "GetFullyTraceCameraAdjustments(self) -> bool\nC++: virtual bool GetFullyTraceCameraAdjustments()\n\n"},
  {"SetPropertiesToTraceOnCreate", PyvtkSMTrace_SetPropertiesToTraceOnCreate, METH_VARARGS,
   "SetPropertiesToTraceOnCreate(self, _arg:int) -> None\nC++: virtual void SetPropertiesToTraceOnCreate(int _arg)\n\n"},
  {"GetPropertiesToTraceOnCreateMinValue", PyvtkSMTrace_GetPropertiesToTraceOnCreateMinValue, METH_VARARGS,
   "GetPropertiesToTraceOnCreateMinValue(self) -> int\nC++: virtual int GetPropertiesToTraceOnCreateMinValue()\n\n"},
  {"GetPropertiesToTraceOnCreateMaxValue", PyvtkSMTrace_GetPropertiesToTraceOnCreateMaxValue, METH_VARARGS,
   "GetPropertiesToTraceOnCreateMaxValue(self) -> int\nC++: virtual int GetPropertiesToTraceOnCreateMaxValue()\n\n"},
  {"GetPropertiesToTraceOnCreate", PyvtkSMTrace_GetPropertiesToTraceOnCreate, METH_VARARGS,
   "GetPropertiesToTraceOnCreate(self) -> int\nC++: virtual int GetPropertiesToTraceOnCreate()\n\n"},
  {"GetCurrentTrace", PyvtkSMTrace_GetCurrentTrace, METH_VARARGS,
   "GetCurrentTrace(self) -> str\nC++: std::string GetCurrentTrace()\n\nReturn the current trace.\n"},
  {"GetState", PyvtkSMTrace_GetState, METH_VARARGS,
   "GetState(options:vtkSMProxy) -> str\nC++: static std::string GetState(vtkSMProxy *options)\n\nGenerate a Python state for the application and return it. Note\nthis cannot be called when Python tracing is active.\n\n`options` is a proxy with options to customize the state\ngeneration such as `('pythontracing', 'PythonStateOptions')`.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMTrace_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("trace_xml_defaults"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTrace_GetTraceXMLDefaults(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMTrace_SetTraceXMLDefaults(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMTrace_SetTraceXMLDefaults(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTraceXMLDefaults/SetTraceXMLDefaults\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("log_trace_to_stdout"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTrace_GetLogTraceToStdout(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMTrace_SetLogTraceToStdout(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMTrace_SetLogTraceToStdout(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLogTraceToStdout/SetLogTraceToStdout\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fully_trace_supplemental_proxies"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTrace_GetFullyTraceSupplementalProxies(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMTrace_SetFullyTraceSupplementalProxies(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMTrace_SetFullyTraceSupplementalProxies(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFullyTraceSupplementalProxies/SetFullyTraceSupplementalProxies\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("skip_rendering_components"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTrace_GetSkipRenderingComponents(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMTrace_SetSkipRenderingComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMTrace_SetSkipRenderingComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSkipRenderingComponents/SetSkipRenderingComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fully_trace_camera_adjustments"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTrace_GetFullyTraceCameraAdjustments(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMTrace_SetFullyTraceCameraAdjustments(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMTrace_SetFullyTraceCameraAdjustments(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFullyTraceCameraAdjustments/SetFullyTraceCameraAdjustments\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("properties_to_trace_on_create"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTrace_GetPropertiesToTraceOnCreate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMTrace_SetPropertiesToTraceOnCreate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMTrace_SetPropertiesToTraceOnCreate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPropertiesToTraceOnCreate/SetPropertiesToTraceOnCreate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_tracer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTrace_GetActiveTracer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveTracer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("current_trace"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTrace_GetCurrentTrace(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCurrentTrace\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMTrace_Doc =
  "vtkSMTrace - vtkSMTrace is used to produce Python trace in the\nParaView application.\n\n"
  "Superclass: vtkSMObject\n\n"
  "vtkSMTrace is used to produce Python trace in the ParaView\n"
  "application. To start/stop trace, use the static API\n"
  "vtkSMTrace::StartTrace() and vtkSMTrace::StopTrace(). That sets up\n"
  "the vtkSMTrace instance used as the ActiveTracer. You can setup\n"
  "configuration parameters on the vtkSMTrace instance returned by\n"
  "vtkSMTrace::StartTrace(). The configuration parameters control\n"
  "various aspects of the trace.\n\n"
  "To effective tracing, the application logic should explicitly trace\n"
  "traceable actions by using the SM_SCOPED_TRACE() macro. This macro\n"
  "will have any effect only when there's an ActiveTracer setup i.e\n"
  "tracing is in effect. The result on using SM_SCOPED_TRACE() when\n"
  "tracing is active, is to crate a Python class instance. The name of\n"
  "the class is the argument to SM_SCOPED_TRACE() and the class is\n"
  "defined in paraview.smtrace module. There are various classes defined\n"
  "for tracing specific actions like Show, RegisterViewProxy, and\n"
  "generic actions like PropertiesModified. Keyword or positional\n"
  "arguments can be passed to the constructor using the following the\n"
  "syntax:\n\n"
  "{.cpp}\n"
  "   // pass keyword arguments.\n"
  "   SM_SCOPED_TRACE(PropertiesModified)\n"
  "               .arg(\"proxy\", aProxy)\n"
  "               .arg(\"comment\", \"some comment\");\n\n\n"
  "   // pass positional arguments.\n"
  "   SM_SCOPED_TRACE(PropertiesModified)\n"
  "               .arg(aProxy)\n"
  "               .arg(\"some comment\");\n\n\n"
  "   // mixing positional and keyword arguments.\n"
  "   SM_SCOPED_TRACE(PropertiesModified)\n"
  "               .arg(aProxy)\n"
  "               .arg(\"comment\", \"some comment\");\n\n"
  "The constructed class instance is finalized and deleted when the\n"
  "temporary variable created by the macro goes out of scope (hence the\n"
  "name SM_SCOPED_TRACE).\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMTrace_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMTrace", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMTrace_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMTrace_StaticNew()
{
  return vtkSMTrace::New();
}

PyObject *PyvtkSMTrace_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMTrace_Type, PyvtkSMTrace_Methods,
    "vtkSMTrace",
 &PyvtkSMTrace_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMObject_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 4; c++)
  {
    static const struct { const char *name; int value; }
      constants[4] = {
        { "RECORD_ALL_PROPERTIES", vtkSMTrace::RECORD_ALL_PROPERTIES },
        { "RECORD_MODIFIED_PROPERTIES", vtkSMTrace::RECORD_MODIFIED_PROPERTIES },
        { "RECORD_USER_MODIFIED_PROPERTIES", vtkSMTrace::RECORD_USER_MODIFIED_PROPERTIES },
        { "RECORD_ACTIVE_MODIFIED_PROPERTIES", vtkSMTrace::RECORD_ACTIVE_MODIFIED_PROPERTIES },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMTrace_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMTrace(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMTrace_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMTrace", o) != 0)
  {
    Py_DECREF(o);
  }

}

