/**
 *
 * @file d_refine_functions.h
 *
 * PaStiX refinement functions implementations.
 *
 * @copyright 2015-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author Mathieu Faverge
 * @author Pierre Ramet
 * @author Xavier Lacoste
 * @author Gregoire Pichon
 * @author Theophile Terraz
 * @author Vincent Bridonneau
 * @date 2024-07-05
 * @generated from /build/pastix/src/pastix-6.4.0/refinement/z_refine_functions.h, normal z -> d, Sun Feb 15 18:01:29 2026
 *
 * @addtogroup pastix_dev_refine
 * @{
 *   @brief TODO.
 *
 **/

#ifndef _d_refine_functions_h_
#define _d_refine_functions_h_

#include "common.h"
#include "bcsc/bcsc.h"

#ifndef DOXYGEN_SHOULD_SKIP_THIS
/**
 * @brief TODO
 */
struct d_solver
{
    pastix_int_t    (* getN   )   (pastix_data_t *);
    pastix_fixdbl_t (* getEps )   (pastix_data_t *);
    pastix_int_t    (* getImax)   (pastix_data_t *);
    pastix_int_t    (* getRestart)(pastix_data_t *);

    void* (*malloc)(size_t);
    void  (*free)(void*);

    void   (*output_oneiter)( pastix_fixdbl_t, pastix_fixdbl_t, double, pastix_int_t);
    void   (*output_final)( pastix_data_t *, double, pastix_int_t,
                            pastix_fixdbl_t, void*, double*);

    void   (*scal)( pastix_data_t *, pastix_int_t, double, double * );
    double (*dot) ( pastix_data_t *, pastix_int_t, const double *, const double * );
    void   (*copy)( pastix_data_t *, pastix_int_t, const double *, double * );
    void   (*axpy)( pastix_data_t *, pastix_int_t, double, const double *, double *);
    void   (*spmv)( const pastix_data_t *, pastix_trans_t, double, const double *, double, double * );
    void   (*spsv)( pastix_data_t *, double *, float * );
    double (*norm)( pastix_data_t *, pastix_int_t, const double * );
    void   (*gemv)( pastix_data_t *, pastix_int_t, pastix_int_t,
                    double, const double *, pastix_int_t,
                    const double *, double, double *);
};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

void d_refine_init(struct d_solver *, pastix_data_t*);

pastix_int_t d_gmres_smp   ( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );
pastix_int_t d_grad_smp    ( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );
pastix_int_t d_pivot_smp   ( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );
pastix_int_t d_bicgstab_smp( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );

/**
 * @}
 */
#endif /* _d_refine_functions_h_ */
