/* This file is part of GDB.

   Copyright 2002, 2007 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   --

   This file was generated by the program igen */

#ifndef IDECODE_C
#define IDECODE_C

#include "inline.c"

#include "cpu.h"
#include "idecode.h"
#include "semantics.h"
#include "icache.h"
#ifdef HAVE_COMMON_FPU
#include "sim-inline.h"
#include "sim-fpu.h"
#endif
#include "support.h"

#include <setjmp.h>

enum {
  /* greater or equal to zero => table */
  function_entry = -1,
  boolean_entry = -2,
};

typedef struct _idecode_table_entry {
  int shift;
  instruction_word mask;
  instruction_word value;  void *function_or_table;
} idecode_table_entry;



static idecode_table_entry idecode_table_6_10__0_30_31__16_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO0 },
  /*1*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO1 },
  /*2*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO2 },
  /*3*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO3 },
  /*4*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO4 },
  /*5*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO5 },
  /*6*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO6 },
  /*7*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO7 },
  /*8*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO8 },
  /*9*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO9 },
  /*10*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO10 },
  /*11*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO11 },
  /*12*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO12 },
  /*13*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO13 },
  /*14*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO14 },
  /*15*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO15 },
  /*16*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO16 },
  /*17*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO17 },
  /*18*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO18 },
  /*19*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO19 },
  /*20*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO20 },
  /*21*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO21 },
  /*22*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO22 },
  /*23*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO23 },
  /*24*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO24 },
  /*25*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO25 },
  /*26*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO26 },
  /*27*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO27 },
  /*28*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO28 },
  /*29*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO29 },
  /*30*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO30 },
  /*31*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK0_BO31 },
};

static idecode_table_entry idecode_table_6_10__1_30_31__16_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO0 },
  /*1*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO1 },
  /*2*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO2 },
  /*3*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO3 },
  /*4*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO4 },
  /*5*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO5 },
  /*6*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO6 },
  /*7*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO7 },
  /*8*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO8 },
  /*9*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO9 },
  /*10*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO10 },
  /*11*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO11 },
  /*12*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO12 },
  /*13*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO13 },
  /*14*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO14 },
  /*15*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO15 },
  /*16*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO16 },
  /*17*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO17 },
  /*18*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO18 },
  /*19*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO19 },
  /*20*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO20 },
  /*21*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO21 },
  /*22*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO22 },
  /*23*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO23 },
  /*24*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO24 },
  /*25*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO25 },
  /*26*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO26 },
  /*27*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO27 },
  /*28*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO28 },
  /*29*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO29 },
  /*30*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO30 },
  /*31*/ { function_entry, 0, 0, icache_Branch_Conditional_AA0_LK1_BO31 },
};

static idecode_table_entry idecode_table_6_10__2_30_31__16_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO0 },
  /*1*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO1 },
  /*2*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO2 },
  /*3*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO3 },
  /*4*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO4 },
  /*5*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO5 },
  /*6*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO6 },
  /*7*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO7 },
  /*8*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO8 },
  /*9*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO9 },
  /*10*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO10 },
  /*11*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO11 },
  /*12*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO12 },
  /*13*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO13 },
  /*14*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO14 },
  /*15*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO15 },
  /*16*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO16 },
  /*17*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO17 },
  /*18*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO18 },
  /*19*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO19 },
  /*20*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO20 },
  /*21*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO21 },
  /*22*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO22 },
  /*23*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO23 },
  /*24*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO24 },
  /*25*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO25 },
  /*26*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO26 },
  /*27*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO27 },
  /*28*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO28 },
  /*29*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO29 },
  /*30*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO30 },
  /*31*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK0_BO31 },
};

static idecode_table_entry idecode_table_6_10__3_30_31__16_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO0 },
  /*1*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO1 },
  /*2*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO2 },
  /*3*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO3 },
  /*4*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO4 },
  /*5*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO5 },
  /*6*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO6 },
  /*7*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO7 },
  /*8*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO8 },
  /*9*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO9 },
  /*10*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO10 },
  /*11*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO11 },
  /*12*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO12 },
  /*13*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO13 },
  /*14*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO14 },
  /*15*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO15 },
  /*16*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO16 },
  /*17*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO17 },
  /*18*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO18 },
  /*19*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO19 },
  /*20*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO20 },
  /*21*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO21 },
  /*22*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO22 },
  /*23*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO23 },
  /*24*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO24 },
  /*25*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO25 },
  /*26*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO26 },
  /*27*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO27 },
  /*28*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO28 },
  /*29*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO29 },
  /*30*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO30 },
  /*31*/ { function_entry, 0, 0, icache_Branch_Conditional_AA1_LK1_BO31 },
};

static idecode_table_entry idecode_table_11_20__678_21_31__31_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Move_from_Special_Purpose_Register_SPR256 },
  /*1*/ { function_entry, 0, 0, icache_Move_from_Special_Purpose_Register_SPR },
};

static idecode_table_entry idecode_table_11_20__934_21_31__31_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Move_to_Special_Purpose_Register_SPR256 },
  /*1*/ { function_entry, 0, 0, icache_Move_to_Special_Purpose_Register_SPR },
};

static idecode_table_entry idecode_table_11_15__14_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Add_Immediate_RA0 },
  /*1*/ { function_entry, 0, 0, icache_Add_Immediate_RA },
};

static idecode_table_entry idecode_table_11_15__15_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Add_Immediate_Shifted_RA0 },
  /*1*/ { function_entry, 0, 0, icache_Add_Immediate_Shifted_RA },
};

static idecode_table_entry idecode_table_30_31__16_0_5[] = {
  /*0*/ { 21, MASK32(6,10), 0, idecode_table_6_10__0_30_31__16_0_5 },
  /*1*/ { 21, MASK32(6,10), 0, idecode_table_6_10__1_30_31__16_0_5 },
  /*2*/ { 21, MASK32(6,10), 0, idecode_table_6_10__2_30_31__16_0_5 },
  /*3*/ { 21, MASK32(6,10), 0, idecode_table_6_10__3_30_31__16_0_5 },
};

static idecode_table_entry idecode_table_30_31__18_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Branch_AA0_LK0 },
  /*1*/ { function_entry, 0, 0, icache_Branch_AA0_LK1 },
  /*2*/ { function_entry, 0, 0, icache_Branch_AA1_LK0 },
  /*3*/ { function_entry, 0, 0, icache_Branch_AA1_LK1 },
};

static idecode_table_entry idecode_table_21_31__19_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Move_Condition_Register_Field },
  /*1*/ { function_entry, 0, 0, icache_illegal },
  /*2*/ { function_entry, 0, 0, icache_illegal },
  /*3*/ { function_entry, 0, 0, icache_illegal },
  /*4*/ { function_entry, 0, 0, icache_illegal },
  /*5*/ { function_entry, 0, 0, icache_illegal },
  /*6*/ { function_entry, 0, 0, icache_illegal },
  /*7*/ { function_entry, 0, 0, icache_illegal },
  /*8*/ { function_entry, 0, 0, icache_illegal },
  /*9*/ { function_entry, 0, 0, icache_illegal },
  /*10*/ { function_entry, 0, 0, icache_illegal },
  /*11*/ { function_entry, 0, 0, icache_illegal },
  /*12*/ { function_entry, 0, 0, icache_illegal },
  /*13*/ { function_entry, 0, 0, icache_illegal },
  /*14*/ { function_entry, 0, 0, icache_illegal },
  /*15*/ { function_entry, 0, 0, icache_illegal },
  /*16*/ { function_entry, 0, 0, icache_illegal },
  /*17*/ { function_entry, 0, 0, icache_illegal },
  /*18*/ { function_entry, 0, 0, icache_illegal },
  /*19*/ { function_entry, 0, 0, icache_illegal },
  /*20*/ { function_entry, 0, 0, icache_illegal },
  /*21*/ { function_entry, 0, 0, icache_illegal },
  /*22*/ { function_entry, 0, 0, icache_illegal },
  /*23*/ { function_entry, 0, 0, icache_illegal },
  /*24*/ { function_entry, 0, 0, icache_illegal },
  /*25*/ { function_entry, 0, 0, icache_illegal },
  /*26*/ { function_entry, 0, 0, icache_illegal },
  /*27*/ { function_entry, 0, 0, icache_illegal },
  /*28*/ { function_entry, 0, 0, icache_illegal },
  /*29*/ { function_entry, 0, 0, icache_illegal },
  /*30*/ { function_entry, 0, 0, icache_illegal },
  /*31*/ { function_entry, 0, 0, icache_illegal },
  /*32*/ { function_entry, 0, 0, icache_Branch_Conditional_to_Link_Register_LK0 },
  /*33*/ { function_entry, 0, 0, icache_Branch_Conditional_to_Link_Register_LK1 },
  /*34*/ { function_entry, 0, 0, icache_illegal },
  /*35*/ { function_entry, 0, 0, icache_illegal },
  /*36*/ { function_entry, 0, 0, icache_illegal },
  /*37*/ { function_entry, 0, 0, icache_illegal },
  /*38*/ { function_entry, 0, 0, icache_illegal },
  /*39*/ { function_entry, 0, 0, icache_illegal },
  /*40*/ { function_entry, 0, 0, icache_illegal },
  /*41*/ { function_entry, 0, 0, icache_illegal },
  /*42*/ { function_entry, 0, 0, icache_illegal },
  /*43*/ { function_entry, 0, 0, icache_illegal },
  /*44*/ { function_entry, 0, 0, icache_illegal },
  /*45*/ { function_entry, 0, 0, icache_illegal },
  /*46*/ { function_entry, 0, 0, icache_illegal },
  /*47*/ { function_entry, 0, 0, icache_illegal },
  /*48*/ { function_entry, 0, 0, icache_illegal },
  /*49*/ { function_entry, 0, 0, icache_illegal },
  /*50*/ { function_entry, 0, 0, icache_illegal },
  /*51*/ { function_entry, 0, 0, icache_illegal },
  /*52*/ { function_entry, 0, 0, icache_illegal },
  /*53*/ { function_entry, 0, 0, icache_illegal },
  /*54*/ { function_entry, 0, 0, icache_illegal },
  /*55*/ { function_entry, 0, 0, icache_illegal },
  /*56*/ { function_entry, 0, 0, icache_illegal },
  /*57*/ { function_entry, 0, 0, icache_illegal },
  /*58*/ { function_entry, 0, 0, icache_illegal },
  /*59*/ { function_entry, 0, 0, icache_illegal },
  /*60*/ { function_entry, 0, 0, icache_illegal },
  /*61*/ { function_entry, 0, 0, icache_illegal },
  /*62*/ { function_entry, 0, 0, icache_illegal },
  /*63*/ { function_entry, 0, 0, icache_illegal },
  /*64*/ { function_entry, 0, 0, icache_illegal },
  /*65*/ { function_entry, 0, 0, icache_illegal },
  /*66*/ { function_entry, 0, 0, icache_Condition_Register_NOR },
  /*67*/ { function_entry, 0, 0, icache_illegal },
  /*68*/ { function_entry, 0, 0, icache_illegal },
  /*69*/ { function_entry, 0, 0, icache_illegal },
  /*70*/ { function_entry, 0, 0, icache_illegal },
  /*71*/ { function_entry, 0, 0, icache_illegal },
  /*72*/ { function_entry, 0, 0, icache_illegal },
  /*73*/ { function_entry, 0, 0, icache_illegal },
  /*74*/ { function_entry, 0, 0, icache_illegal },
  /*75*/ { function_entry, 0, 0, icache_illegal },
  /*76*/ { function_entry, 0, 0, icache_illegal },
  /*77*/ { function_entry, 0, 0, icache_illegal },
  /*78*/ { function_entry, 0, 0, icache_illegal },
  /*79*/ { function_entry, 0, 0, icache_illegal },
  /*80*/ { function_entry, 0, 0, icache_illegal },
  /*81*/ { function_entry, 0, 0, icache_illegal },
  /*82*/ { function_entry, 0, 0, icache_illegal },
  /*83*/ { function_entry, 0, 0, icache_illegal },
  /*84*/ { function_entry, 0, 0, icache_illegal },
  /*85*/ { function_entry, 0, 0, icache_illegal },
  /*86*/ { function_entry, 0, 0, icache_illegal },
  /*87*/ { function_entry, 0, 0, icache_illegal },
  /*88*/ { function_entry, 0, 0, icache_illegal },
  /*89*/ { function_entry, 0, 0, icache_illegal },
  /*90*/ { function_entry, 0, 0, icache_illegal },
  /*91*/ { function_entry, 0, 0, icache_illegal },
  /*92*/ { function_entry, 0, 0, icache_illegal },
  /*93*/ { function_entry, 0, 0, icache_illegal },
  /*94*/ { function_entry, 0, 0, icache_illegal },
  /*95*/ { function_entry, 0, 0, icache_illegal },
  /*96*/ { function_entry, 0, 0, icache_illegal },
  /*97*/ { function_entry, 0, 0, icache_illegal },
  /*98*/ { function_entry, 0, 0, icache_illegal },
  /*99*/ { function_entry, 0, 0, icache_illegal },
  /*100*/ { function_entry, 0, 0, icache_Return_From_Interrupt },
  /*101*/ { function_entry, 0, 0, icache_illegal },
  /*102*/ { function_entry, 0, 0, icache_illegal },
  /*103*/ { function_entry, 0, 0, icache_illegal },
  /*104*/ { function_entry, 0, 0, icache_illegal },
  /*105*/ { function_entry, 0, 0, icache_illegal },
  /*106*/ { function_entry, 0, 0, icache_illegal },
  /*107*/ { function_entry, 0, 0, icache_illegal },
  /*108*/ { function_entry, 0, 0, icache_illegal },
  /*109*/ { function_entry, 0, 0, icache_illegal },
  /*110*/ { function_entry, 0, 0, icache_illegal },
  /*111*/ { function_entry, 0, 0, icache_illegal },
  /*112*/ { function_entry, 0, 0, icache_illegal },
  /*113*/ { function_entry, 0, 0, icache_illegal },
  /*114*/ { function_entry, 0, 0, icache_illegal },
  /*115*/ { function_entry, 0, 0, icache_illegal },
  /*116*/ { function_entry, 0, 0, icache_illegal },
  /*117*/ { function_entry, 0, 0, icache_illegal },
  /*118*/ { function_entry, 0, 0, icache_illegal },
  /*119*/ { function_entry, 0, 0, icache_illegal },
  /*120*/ { function_entry, 0, 0, icache_illegal },
  /*121*/ { function_entry, 0, 0, icache_illegal },
  /*122*/ { function_entry, 0, 0, icache_illegal },
  /*123*/ { function_entry, 0, 0, icache_illegal },
  /*124*/ { function_entry, 0, 0, icache_illegal },
  /*125*/ { function_entry, 0, 0, icache_illegal },
  /*126*/ { function_entry, 0, 0, icache_illegal },
  /*127*/ { function_entry, 0, 0, icache_illegal },
  /*128*/ { function_entry, 0, 0, icache_illegal },
  /*129*/ { function_entry, 0, 0, icache_illegal },
  /*130*/ { function_entry, 0, 0, icache_illegal },
  /*131*/ { function_entry, 0, 0, icache_illegal },
  /*132*/ { function_entry, 0, 0, icache_illegal },
  /*133*/ { function_entry, 0, 0, icache_illegal },
  /*134*/ { function_entry, 0, 0, icache_illegal },
  /*135*/ { function_entry, 0, 0, icache_illegal },
  /*136*/ { function_entry, 0, 0, icache_illegal },
  /*137*/ { function_entry, 0, 0, icache_illegal },
  /*138*/ { function_entry, 0, 0, icache_illegal },
  /*139*/ { function_entry, 0, 0, icache_illegal },
  /*140*/ { function_entry, 0, 0, icache_illegal },
  /*141*/ { function_entry, 0, 0, icache_illegal },
  /*142*/ { function_entry, 0, 0, icache_illegal },
  /*143*/ { function_entry, 0, 0, icache_illegal },
  /*144*/ { function_entry, 0, 0, icache_illegal },
  /*145*/ { function_entry, 0, 0, icache_illegal },
  /*146*/ { function_entry, 0, 0, icache_illegal },
  /*147*/ { function_entry, 0, 0, icache_illegal },
  /*148*/ { function_entry, 0, 0, icache_illegal },
  /*149*/ { function_entry, 0, 0, icache_illegal },
  /*150*/ { function_entry, 0, 0, icache_illegal },
  /*151*/ { function_entry, 0, 0, icache_illegal },
  /*152*/ { function_entry, 0, 0, icache_illegal },
  /*153*/ { function_entry, 0, 0, icache_illegal },
  /*154*/ { function_entry, 0, 0, icache_illegal },
  /*155*/ { function_entry, 0, 0, icache_illegal },
  /*156*/ { function_entry, 0, 0, icache_illegal },
  /*157*/ { function_entry, 0, 0, icache_illegal },
  /*158*/ { function_entry, 0, 0, icache_illegal },
  /*159*/ { function_entry, 0, 0, icache_illegal },
  /*160*/ { function_entry, 0, 0, icache_illegal },
  /*161*/ { function_entry, 0, 0, icache_illegal },
  /*162*/ { function_entry, 0, 0, icache_illegal },
  /*163*/ { function_entry, 0, 0, icache_illegal },
  /*164*/ { function_entry, 0, 0, icache_illegal },
  /*165*/ { function_entry, 0, 0, icache_illegal },
  /*166*/ { function_entry, 0, 0, icache_illegal },
  /*167*/ { function_entry, 0, 0, icache_illegal },
  /*168*/ { function_entry, 0, 0, icache_illegal },
  /*169*/ { function_entry, 0, 0, icache_illegal },
  /*170*/ { function_entry, 0, 0, icache_illegal },
  /*171*/ { function_entry, 0, 0, icache_illegal },
  /*172*/ { function_entry, 0, 0, icache_illegal },
  /*173*/ { function_entry, 0, 0, icache_illegal },
  /*174*/ { function_entry, 0, 0, icache_illegal },
  /*175*/ { function_entry, 0, 0, icache_illegal },
  /*176*/ { function_entry, 0, 0, icache_illegal },
  /*177*/ { function_entry, 0, 0, icache_illegal },
  /*178*/ { function_entry, 0, 0, icache_illegal },
  /*179*/ { function_entry, 0, 0, icache_illegal },
  /*180*/ { function_entry, 0, 0, icache_illegal },
  /*181*/ { function_entry, 0, 0, icache_illegal },
  /*182*/ { function_entry, 0, 0, icache_illegal },
  /*183*/ { function_entry, 0, 0, icache_illegal },
  /*184*/ { function_entry, 0, 0, icache_illegal },
  /*185*/ { function_entry, 0, 0, icache_illegal },
  /*186*/ { function_entry, 0, 0, icache_illegal },
  /*187*/ { function_entry, 0, 0, icache_illegal },
  /*188*/ { function_entry, 0, 0, icache_illegal },
  /*189*/ { function_entry, 0, 0, icache_illegal },
  /*190*/ { function_entry, 0, 0, icache_illegal },
  /*191*/ { function_entry, 0, 0, icache_illegal },
  /*192*/ { function_entry, 0, 0, icache_illegal },
  /*193*/ { function_entry, 0, 0, icache_illegal },
  /*194*/ { function_entry, 0, 0, icache_illegal },
  /*195*/ { function_entry, 0, 0, icache_illegal },
  /*196*/ { function_entry, 0, 0, icache_illegal },
  /*197*/ { function_entry, 0, 0, icache_illegal },
  /*198*/ { function_entry, 0, 0, icache_illegal },
  /*199*/ { function_entry, 0, 0, icache_illegal },
  /*200*/ { function_entry, 0, 0, icache_illegal },
  /*201*/ { function_entry, 0, 0, icache_illegal },
  /*202*/ { function_entry, 0, 0, icache_illegal },
  /*203*/ { function_entry, 0, 0, icache_illegal },
  /*204*/ { function_entry, 0, 0, icache_illegal },
  /*205*/ { function_entry, 0, 0, icache_illegal },
  /*206*/ { function_entry, 0, 0, icache_illegal },
  /*207*/ { function_entry, 0, 0, icache_illegal },
  /*208*/ { function_entry, 0, 0, icache_illegal },
  /*209*/ { function_entry, 0, 0, icache_illegal },
  /*210*/ { function_entry, 0, 0, icache_illegal },
  /*211*/ { function_entry, 0, 0, icache_illegal },
  /*212*/ { function_entry, 0, 0, icache_illegal },
  /*213*/ { function_entry, 0, 0, icache_illegal },
  /*214*/ { function_entry, 0, 0, icache_illegal },
  /*215*/ { function_entry, 0, 0, icache_illegal },
  /*216*/ { function_entry, 0, 0, icache_illegal },
  /*217*/ { function_entry, 0, 0, icache_illegal },
  /*218*/ { function_entry, 0, 0, icache_illegal },
  /*219*/ { function_entry, 0, 0, icache_illegal },
  /*220*/ { function_entry, 0, 0, icache_illegal },
  /*221*/ { function_entry, 0, 0, icache_illegal },
  /*222*/ { function_entry, 0, 0, icache_illegal },
  /*223*/ { function_entry, 0, 0, icache_illegal },
  /*224*/ { function_entry, 0, 0, icache_illegal },
  /*225*/ { function_entry, 0, 0, icache_illegal },
  /*226*/ { function_entry, 0, 0, icache_illegal },
  /*227*/ { function_entry, 0, 0, icache_illegal },
  /*228*/ { function_entry, 0, 0, icache_illegal },
  /*229*/ { function_entry, 0, 0, icache_illegal },
  /*230*/ { function_entry, 0, 0, icache_illegal },
  /*231*/ { function_entry, 0, 0, icache_illegal },
  /*232*/ { function_entry, 0, 0, icache_illegal },
  /*233*/ { function_entry, 0, 0, icache_illegal },
  /*234*/ { function_entry, 0, 0, icache_illegal },
  /*235*/ { function_entry, 0, 0, icache_illegal },
  /*236*/ { function_entry, 0, 0, icache_illegal },
  /*237*/ { function_entry, 0, 0, icache_illegal },
  /*238*/ { function_entry, 0, 0, icache_illegal },
  /*239*/ { function_entry, 0, 0, icache_illegal },
  /*240*/ { function_entry, 0, 0, icache_illegal },
  /*241*/ { function_entry, 0, 0, icache_illegal },
  /*242*/ { function_entry, 0, 0, icache_illegal },
  /*243*/ { function_entry, 0, 0, icache_illegal },
  /*244*/ { function_entry, 0, 0, icache_illegal },
  /*245*/ { function_entry, 0, 0, icache_illegal },
  /*246*/ { function_entry, 0, 0, icache_illegal },
  /*247*/ { function_entry, 0, 0, icache_illegal },
  /*248*/ { function_entry, 0, 0, icache_illegal },
  /*249*/ { function_entry, 0, 0, icache_illegal },
  /*250*/ { function_entry, 0, 0, icache_illegal },
  /*251*/ { function_entry, 0, 0, icache_illegal },
  /*252*/ { function_entry, 0, 0, icache_illegal },
  /*253*/ { function_entry, 0, 0, icache_illegal },
  /*254*/ { function_entry, 0, 0, icache_illegal },
  /*255*/ { function_entry, 0, 0, icache_illegal },
  /*256*/ { function_entry, 0, 0, icache_illegal },
  /*257*/ { function_entry, 0, 0, icache_illegal },
  /*258*/ { function_entry, 0, 0, icache_Condition_Register_AND_with_Complement },
  /*259*/ { function_entry, 0, 0, icache_illegal },
  /*260*/ { function_entry, 0, 0, icache_illegal },
  /*261*/ { function_entry, 0, 0, icache_illegal },
  /*262*/ { function_entry, 0, 0, icache_illegal },
  /*263*/ { function_entry, 0, 0, icache_illegal },
  /*264*/ { function_entry, 0, 0, icache_illegal },
  /*265*/ { function_entry, 0, 0, icache_illegal },
  /*266*/ { function_entry, 0, 0, icache_illegal },
  /*267*/ { function_entry, 0, 0, icache_illegal },
  /*268*/ { function_entry, 0, 0, icache_illegal },
  /*269*/ { function_entry, 0, 0, icache_illegal },
  /*270*/ { function_entry, 0, 0, icache_illegal },
  /*271*/ { function_entry, 0, 0, icache_illegal },
  /*272*/ { function_entry, 0, 0, icache_illegal },
  /*273*/ { function_entry, 0, 0, icache_illegal },
  /*274*/ { function_entry, 0, 0, icache_illegal },
  /*275*/ { function_entry, 0, 0, icache_illegal },
  /*276*/ { function_entry, 0, 0, icache_illegal },
  /*277*/ { function_entry, 0, 0, icache_illegal },
  /*278*/ { function_entry, 0, 0, icache_illegal },
  /*279*/ { function_entry, 0, 0, icache_illegal },
  /*280*/ { function_entry, 0, 0, icache_illegal },
  /*281*/ { function_entry, 0, 0, icache_illegal },
  /*282*/ { function_entry, 0, 0, icache_illegal },
  /*283*/ { function_entry, 0, 0, icache_illegal },
  /*284*/ { function_entry, 0, 0, icache_illegal },
  /*285*/ { function_entry, 0, 0, icache_illegal },
  /*286*/ { function_entry, 0, 0, icache_illegal },
  /*287*/ { function_entry, 0, 0, icache_illegal },
  /*288*/ { function_entry, 0, 0, icache_illegal },
  /*289*/ { function_entry, 0, 0, icache_illegal },
  /*290*/ { function_entry, 0, 0, icache_illegal },
  /*291*/ { function_entry, 0, 0, icache_illegal },
  /*292*/ { function_entry, 0, 0, icache_illegal },
  /*293*/ { function_entry, 0, 0, icache_illegal },
  /*294*/ { function_entry, 0, 0, icache_illegal },
  /*295*/ { function_entry, 0, 0, icache_illegal },
  /*296*/ { function_entry, 0, 0, icache_illegal },
  /*297*/ { function_entry, 0, 0, icache_illegal },
  /*298*/ { function_entry, 0, 0, icache_illegal },
  /*299*/ { function_entry, 0, 0, icache_illegal },
  /*300*/ { function_entry, 0, 0, icache_Instruction_Synchronize },
  /*301*/ { function_entry, 0, 0, icache_illegal },
  /*302*/ { function_entry, 0, 0, icache_illegal },
  /*303*/ { function_entry, 0, 0, icache_illegal },
  /*304*/ { function_entry, 0, 0, icache_illegal },
  /*305*/ { function_entry, 0, 0, icache_illegal },
  /*306*/ { function_entry, 0, 0, icache_illegal },
  /*307*/ { function_entry, 0, 0, icache_illegal },
  /*308*/ { function_entry, 0, 0, icache_illegal },
  /*309*/ { function_entry, 0, 0, icache_illegal },
  /*310*/ { function_entry, 0, 0, icache_illegal },
  /*311*/ { function_entry, 0, 0, icache_illegal },
  /*312*/ { function_entry, 0, 0, icache_illegal },
  /*313*/ { function_entry, 0, 0, icache_illegal },
  /*314*/ { function_entry, 0, 0, icache_illegal },
  /*315*/ { function_entry, 0, 0, icache_illegal },
  /*316*/ { function_entry, 0, 0, icache_illegal },
  /*317*/ { function_entry, 0, 0, icache_illegal },
  /*318*/ { function_entry, 0, 0, icache_illegal },
  /*319*/ { function_entry, 0, 0, icache_illegal },
  /*320*/ { function_entry, 0, 0, icache_illegal },
  /*321*/ { function_entry, 0, 0, icache_illegal },
  /*322*/ { function_entry, 0, 0, icache_illegal },
  /*323*/ { function_entry, 0, 0, icache_illegal },
  /*324*/ { function_entry, 0, 0, icache_illegal },
  /*325*/ { function_entry, 0, 0, icache_illegal },
  /*326*/ { function_entry, 0, 0, icache_illegal },
  /*327*/ { function_entry, 0, 0, icache_illegal },
  /*328*/ { function_entry, 0, 0, icache_illegal },
  /*329*/ { function_entry, 0, 0, icache_illegal },
  /*330*/ { function_entry, 0, 0, icache_illegal },
  /*331*/ { function_entry, 0, 0, icache_illegal },
  /*332*/ { function_entry, 0, 0, icache_illegal },
  /*333*/ { function_entry, 0, 0, icache_illegal },
  /*334*/ { function_entry, 0, 0, icache_illegal },
  /*335*/ { function_entry, 0, 0, icache_illegal },
  /*336*/ { function_entry, 0, 0, icache_illegal },
  /*337*/ { function_entry, 0, 0, icache_illegal },
  /*338*/ { function_entry, 0, 0, icache_illegal },
  /*339*/ { function_entry, 0, 0, icache_illegal },
  /*340*/ { function_entry, 0, 0, icache_illegal },
  /*341*/ { function_entry, 0, 0, icache_illegal },
  /*342*/ { function_entry, 0, 0, icache_illegal },
  /*343*/ { function_entry, 0, 0, icache_illegal },
  /*344*/ { function_entry, 0, 0, icache_illegal },
  /*345*/ { function_entry, 0, 0, icache_illegal },
  /*346*/ { function_entry, 0, 0, icache_illegal },
  /*347*/ { function_entry, 0, 0, icache_illegal },
  /*348*/ { function_entry, 0, 0, icache_illegal },
  /*349*/ { function_entry, 0, 0, icache_illegal },
  /*350*/ { function_entry, 0, 0, icache_illegal },
  /*351*/ { function_entry, 0, 0, icache_illegal },
  /*352*/ { function_entry, 0, 0, icache_illegal },
  /*353*/ { function_entry, 0, 0, icache_illegal },
  /*354*/ { function_entry, 0, 0, icache_illegal },
  /*355*/ { function_entry, 0, 0, icache_illegal },
  /*356*/ { function_entry, 0, 0, icache_illegal },
  /*357*/ { function_entry, 0, 0, icache_illegal },
  /*358*/ { function_entry, 0, 0, icache_illegal },
  /*359*/ { function_entry, 0, 0, icache_illegal },
  /*360*/ { function_entry, 0, 0, icache_illegal },
  /*361*/ { function_entry, 0, 0, icache_illegal },
  /*362*/ { function_entry, 0, 0, icache_illegal },
  /*363*/ { function_entry, 0, 0, icache_illegal },
  /*364*/ { function_entry, 0, 0, icache_illegal },
  /*365*/ { function_entry, 0, 0, icache_illegal },
  /*366*/ { function_entry, 0, 0, icache_illegal },
  /*367*/ { function_entry, 0, 0, icache_illegal },
  /*368*/ { function_entry, 0, 0, icache_illegal },
  /*369*/ { function_entry, 0, 0, icache_illegal },
  /*370*/ { function_entry, 0, 0, icache_illegal },
  /*371*/ { function_entry, 0, 0, icache_illegal },
  /*372*/ { function_entry, 0, 0, icache_illegal },
  /*373*/ { function_entry, 0, 0, icache_illegal },
  /*374*/ { function_entry, 0, 0, icache_illegal },
  /*375*/ { function_entry, 0, 0, icache_illegal },
  /*376*/ { function_entry, 0, 0, icache_illegal },
  /*377*/ { function_entry, 0, 0, icache_illegal },
  /*378*/ { function_entry, 0, 0, icache_illegal },
  /*379*/ { function_entry, 0, 0, icache_illegal },
  /*380*/ { function_entry, 0, 0, icache_illegal },
  /*381*/ { function_entry, 0, 0, icache_illegal },
  /*382*/ { function_entry, 0, 0, icache_illegal },
  /*383*/ { function_entry, 0, 0, icache_illegal },
  /*384*/ { function_entry, 0, 0, icache_illegal },
  /*385*/ { function_entry, 0, 0, icache_illegal },
  /*386*/ { function_entry, 0, 0, icache_Condition_Register_XOR },
  /*387*/ { function_entry, 0, 0, icache_illegal },
  /*388*/ { function_entry, 0, 0, icache_illegal },
  /*389*/ { function_entry, 0, 0, icache_illegal },
  /*390*/ { function_entry, 0, 0, icache_illegal },
  /*391*/ { function_entry, 0, 0, icache_illegal },
  /*392*/ { function_entry, 0, 0, icache_illegal },
  /*393*/ { function_entry, 0, 0, icache_illegal },
  /*394*/ { function_entry, 0, 0, icache_illegal },
  /*395*/ { function_entry, 0, 0, icache_illegal },
  /*396*/ { function_entry, 0, 0, icache_illegal },
  /*397*/ { function_entry, 0, 0, icache_illegal },
  /*398*/ { function_entry, 0, 0, icache_illegal },
  /*399*/ { function_entry, 0, 0, icache_illegal },
  /*400*/ { function_entry, 0, 0, icache_illegal },
  /*401*/ { function_entry, 0, 0, icache_illegal },
  /*402*/ { function_entry, 0, 0, icache_illegal },
  /*403*/ { function_entry, 0, 0, icache_illegal },
  /*404*/ { function_entry, 0, 0, icache_illegal },
  /*405*/ { function_entry, 0, 0, icache_illegal },
  /*406*/ { function_entry, 0, 0, icache_illegal },
  /*407*/ { function_entry, 0, 0, icache_illegal },
  /*408*/ { function_entry, 0, 0, icache_illegal },
  /*409*/ { function_entry, 0, 0, icache_illegal },
  /*410*/ { function_entry, 0, 0, icache_illegal },
  /*411*/ { function_entry, 0, 0, icache_illegal },
  /*412*/ { function_entry, 0, 0, icache_illegal },
  /*413*/ { function_entry, 0, 0, icache_illegal },
  /*414*/ { function_entry, 0, 0, icache_illegal },
  /*415*/ { function_entry, 0, 0, icache_illegal },
  /*416*/ { function_entry, 0, 0, icache_illegal },
  /*417*/ { function_entry, 0, 0, icache_illegal },
  /*418*/ { function_entry, 0, 0, icache_illegal },
  /*419*/ { function_entry, 0, 0, icache_illegal },
  /*420*/ { function_entry, 0, 0, icache_illegal },
  /*421*/ { function_entry, 0, 0, icache_illegal },
  /*422*/ { function_entry, 0, 0, icache_illegal },
  /*423*/ { function_entry, 0, 0, icache_illegal },
  /*424*/ { function_entry, 0, 0, icache_illegal },
  /*425*/ { function_entry, 0, 0, icache_illegal },
  /*426*/ { function_entry, 0, 0, icache_illegal },
  /*427*/ { function_entry, 0, 0, icache_illegal },
  /*428*/ { function_entry, 0, 0, icache_illegal },
  /*429*/ { function_entry, 0, 0, icache_illegal },
  /*430*/ { function_entry, 0, 0, icache_illegal },
  /*431*/ { function_entry, 0, 0, icache_illegal },
  /*432*/ { function_entry, 0, 0, icache_illegal },
  /*433*/ { function_entry, 0, 0, icache_illegal },
  /*434*/ { function_entry, 0, 0, icache_illegal },
  /*435*/ { function_entry, 0, 0, icache_illegal },
  /*436*/ { function_entry, 0, 0, icache_illegal },
  /*437*/ { function_entry, 0, 0, icache_illegal },
  /*438*/ { function_entry, 0, 0, icache_illegal },
  /*439*/ { function_entry, 0, 0, icache_illegal },
  /*440*/ { function_entry, 0, 0, icache_illegal },
  /*441*/ { function_entry, 0, 0, icache_illegal },
  /*442*/ { function_entry, 0, 0, icache_illegal },
  /*443*/ { function_entry, 0, 0, icache_illegal },
  /*444*/ { function_entry, 0, 0, icache_illegal },
  /*445*/ { function_entry, 0, 0, icache_illegal },
  /*446*/ { function_entry, 0, 0, icache_illegal },
  /*447*/ { function_entry, 0, 0, icache_illegal },
  /*448*/ { function_entry, 0, 0, icache_illegal },
  /*449*/ { function_entry, 0, 0, icache_illegal },
  /*450*/ { function_entry, 0, 0, icache_Condition_Register_NAND },
  /*451*/ { function_entry, 0, 0, icache_illegal },
  /*452*/ { function_entry, 0, 0, icache_illegal },
  /*453*/ { function_entry, 0, 0, icache_illegal },
  /*454*/ { function_entry, 0, 0, icache_illegal },
  /*455*/ { function_entry, 0, 0, icache_illegal },
  /*456*/ { function_entry, 0, 0, icache_illegal },
  /*457*/ { function_entry, 0, 0, icache_illegal },
  /*458*/ { function_entry, 0, 0, icache_illegal },
  /*459*/ { function_entry, 0, 0, icache_illegal },
  /*460*/ { function_entry, 0, 0, icache_illegal },
  /*461*/ { function_entry, 0, 0, icache_illegal },
  /*462*/ { function_entry, 0, 0, icache_illegal },
  /*463*/ { function_entry, 0, 0, icache_illegal },
  /*464*/ { function_entry, 0, 0, icache_illegal },
  /*465*/ { function_entry, 0, 0, icache_illegal },
  /*466*/ { function_entry, 0, 0, icache_illegal },
  /*467*/ { function_entry, 0, 0, icache_illegal },
  /*468*/ { function_entry, 0, 0, icache_illegal },
  /*469*/ { function_entry, 0, 0, icache_illegal },
  /*470*/ { function_entry, 0, 0, icache_illegal },
  /*471*/ { function_entry, 0, 0, icache_illegal },
  /*472*/ { function_entry, 0, 0, icache_illegal },
  /*473*/ { function_entry, 0, 0, icache_illegal },
  /*474*/ { function_entry, 0, 0, icache_illegal },
  /*475*/ { function_entry, 0, 0, icache_illegal },
  /*476*/ { function_entry, 0, 0, icache_illegal },
  /*477*/ { function_entry, 0, 0, icache_illegal },
  /*478*/ { function_entry, 0, 0, icache_illegal },
  /*479*/ { function_entry, 0, 0, icache_illegal },
  /*480*/ { function_entry, 0, 0, icache_illegal },
  /*481*/ { function_entry, 0, 0, icache_illegal },
  /*482*/ { function_entry, 0, 0, icache_illegal },
  /*483*/ { function_entry, 0, 0, icache_illegal },
  /*484*/ { function_entry, 0, 0, icache_illegal },
  /*485*/ { function_entry, 0, 0, icache_illegal },
  /*486*/ { function_entry, 0, 0, icache_illegal },
  /*487*/ { function_entry, 0, 0, icache_illegal },
  /*488*/ { function_entry, 0, 0, icache_illegal },
  /*489*/ { function_entry, 0, 0, icache_illegal },
  /*490*/ { function_entry, 0, 0, icache_illegal },
  /*491*/ { function_entry, 0, 0, icache_illegal },
  /*492*/ { function_entry, 0, 0, icache_illegal },
  /*493*/ { function_entry, 0, 0, icache_illegal },
  /*494*/ { function_entry, 0, 0, icache_illegal },
  /*495*/ { function_entry, 0, 0, icache_illegal },
  /*496*/ { function_entry, 0, 0, icache_illegal },
  /*497*/ { function_entry, 0, 0, icache_illegal },
  /*498*/ { function_entry, 0, 0, icache_illegal },
  /*499*/ { function_entry, 0, 0, icache_illegal },
  /*500*/ { function_entry, 0, 0, icache_illegal },
  /*501*/ { function_entry, 0, 0, icache_illegal },
  /*502*/ { function_entry, 0, 0, icache_illegal },
  /*503*/ { function_entry, 0, 0, icache_illegal },
  /*504*/ { function_entry, 0, 0, icache_illegal },
  /*505*/ { function_entry, 0, 0, icache_illegal },
  /*506*/ { function_entry, 0, 0, icache_illegal },
  /*507*/ { function_entry, 0, 0, icache_illegal },
  /*508*/ { function_entry, 0, 0, icache_illegal },
  /*509*/ { function_entry, 0, 0, icache_illegal },
  /*510*/ { function_entry, 0, 0, icache_illegal },
  /*511*/ { function_entry, 0, 0, icache_illegal },
  /*512*/ { function_entry, 0, 0, icache_illegal },
  /*513*/ { function_entry, 0, 0, icache_illegal },
  /*514*/ { function_entry, 0, 0, icache_Condition_Register_AND },
  /*515*/ { function_entry, 0, 0, icache_illegal },
  /*516*/ { function_entry, 0, 0, icache_illegal },
  /*517*/ { function_entry, 0, 0, icache_illegal },
  /*518*/ { function_entry, 0, 0, icache_illegal },
  /*519*/ { function_entry, 0, 0, icache_illegal },
  /*520*/ { function_entry, 0, 0, icache_illegal },
  /*521*/ { function_entry, 0, 0, icache_illegal },
  /*522*/ { function_entry, 0, 0, icache_illegal },
  /*523*/ { function_entry, 0, 0, icache_illegal },
  /*524*/ { function_entry, 0, 0, icache_illegal },
  /*525*/ { function_entry, 0, 0, icache_illegal },
  /*526*/ { function_entry, 0, 0, icache_illegal },
  /*527*/ { function_entry, 0, 0, icache_illegal },
  /*528*/ { function_entry, 0, 0, icache_illegal },
  /*529*/ { function_entry, 0, 0, icache_illegal },
  /*530*/ { function_entry, 0, 0, icache_illegal },
  /*531*/ { function_entry, 0, 0, icache_illegal },
  /*532*/ { function_entry, 0, 0, icache_illegal },
  /*533*/ { function_entry, 0, 0, icache_illegal },
  /*534*/ { function_entry, 0, 0, icache_illegal },
  /*535*/ { function_entry, 0, 0, icache_illegal },
  /*536*/ { function_entry, 0, 0, icache_illegal },
  /*537*/ { function_entry, 0, 0, icache_illegal },
  /*538*/ { function_entry, 0, 0, icache_illegal },
  /*539*/ { function_entry, 0, 0, icache_illegal },
  /*540*/ { function_entry, 0, 0, icache_illegal },
  /*541*/ { function_entry, 0, 0, icache_illegal },
  /*542*/ { function_entry, 0, 0, icache_illegal },
  /*543*/ { function_entry, 0, 0, icache_illegal },
  /*544*/ { function_entry, 0, 0, icache_illegal },
  /*545*/ { function_entry, 0, 0, icache_illegal },
  /*546*/ { function_entry, 0, 0, icache_illegal },
  /*547*/ { function_entry, 0, 0, icache_illegal },
  /*548*/ { function_entry, 0, 0, icache_illegal },
  /*549*/ { function_entry, 0, 0, icache_illegal },
  /*550*/ { function_entry, 0, 0, icache_illegal },
  /*551*/ { function_entry, 0, 0, icache_illegal },
  /*552*/ { function_entry, 0, 0, icache_illegal },
  /*553*/ { function_entry, 0, 0, icache_illegal },
  /*554*/ { function_entry, 0, 0, icache_illegal },
  /*555*/ { function_entry, 0, 0, icache_illegal },
  /*556*/ { function_entry, 0, 0, icache_illegal },
  /*557*/ { function_entry, 0, 0, icache_illegal },
  /*558*/ { function_entry, 0, 0, icache_illegal },
  /*559*/ { function_entry, 0, 0, icache_illegal },
  /*560*/ { function_entry, 0, 0, icache_illegal },
  /*561*/ { function_entry, 0, 0, icache_illegal },
  /*562*/ { function_entry, 0, 0, icache_illegal },
  /*563*/ { function_entry, 0, 0, icache_illegal },
  /*564*/ { function_entry, 0, 0, icache_illegal },
  /*565*/ { function_entry, 0, 0, icache_illegal },
  /*566*/ { function_entry, 0, 0, icache_illegal },
  /*567*/ { function_entry, 0, 0, icache_illegal },
  /*568*/ { function_entry, 0, 0, icache_illegal },
  /*569*/ { function_entry, 0, 0, icache_illegal },
  /*570*/ { function_entry, 0, 0, icache_illegal },
  /*571*/ { function_entry, 0, 0, icache_illegal },
  /*572*/ { function_entry, 0, 0, icache_illegal },
  /*573*/ { function_entry, 0, 0, icache_illegal },
  /*574*/ { function_entry, 0, 0, icache_illegal },
  /*575*/ { function_entry, 0, 0, icache_illegal },
  /*576*/ { function_entry, 0, 0, icache_illegal },
  /*577*/ { function_entry, 0, 0, icache_illegal },
  /*578*/ { function_entry, 0, 0, icache_Condition_Register_Equivalent },
  /*579*/ { function_entry, 0, 0, icache_illegal },
  /*580*/ { function_entry, 0, 0, icache_illegal },
  /*581*/ { function_entry, 0, 0, icache_illegal },
  /*582*/ { function_entry, 0, 0, icache_illegal },
  /*583*/ { function_entry, 0, 0, icache_illegal },
  /*584*/ { function_entry, 0, 0, icache_illegal },
  /*585*/ { function_entry, 0, 0, icache_illegal },
  /*586*/ { function_entry, 0, 0, icache_illegal },
  /*587*/ { function_entry, 0, 0, icache_illegal },
  /*588*/ { function_entry, 0, 0, icache_illegal },
  /*589*/ { function_entry, 0, 0, icache_illegal },
  /*590*/ { function_entry, 0, 0, icache_illegal },
  /*591*/ { function_entry, 0, 0, icache_illegal },
  /*592*/ { function_entry, 0, 0, icache_illegal },
  /*593*/ { function_entry, 0, 0, icache_illegal },
  /*594*/ { function_entry, 0, 0, icache_illegal },
  /*595*/ { function_entry, 0, 0, icache_illegal },
  /*596*/ { function_entry, 0, 0, icache_illegal },
  /*597*/ { function_entry, 0, 0, icache_illegal },
  /*598*/ { function_entry, 0, 0, icache_illegal },
  /*599*/ { function_entry, 0, 0, icache_illegal },
  /*600*/ { function_entry, 0, 0, icache_illegal },
  /*601*/ { function_entry, 0, 0, icache_illegal },
  /*602*/ { function_entry, 0, 0, icache_illegal },
  /*603*/ { function_entry, 0, 0, icache_illegal },
  /*604*/ { function_entry, 0, 0, icache_illegal },
  /*605*/ { function_entry, 0, 0, icache_illegal },
  /*606*/ { function_entry, 0, 0, icache_illegal },
  /*607*/ { function_entry, 0, 0, icache_illegal },
  /*608*/ { function_entry, 0, 0, icache_illegal },
  /*609*/ { function_entry, 0, 0, icache_illegal },
  /*610*/ { function_entry, 0, 0, icache_illegal },
  /*611*/ { function_entry, 0, 0, icache_illegal },
  /*612*/ { function_entry, 0, 0, icache_illegal },
  /*613*/ { function_entry, 0, 0, icache_illegal },
  /*614*/ { function_entry, 0, 0, icache_illegal },
  /*615*/ { function_entry, 0, 0, icache_illegal },
  /*616*/ { function_entry, 0, 0, icache_illegal },
  /*617*/ { function_entry, 0, 0, icache_illegal },
  /*618*/ { function_entry, 0, 0, icache_illegal },
  /*619*/ { function_entry, 0, 0, icache_illegal },
  /*620*/ { function_entry, 0, 0, icache_illegal },
  /*621*/ { function_entry, 0, 0, icache_illegal },
  /*622*/ { function_entry, 0, 0, icache_illegal },
  /*623*/ { function_entry, 0, 0, icache_illegal },
  /*624*/ { function_entry, 0, 0, icache_illegal },
  /*625*/ { function_entry, 0, 0, icache_illegal },
  /*626*/ { function_entry, 0, 0, icache_illegal },
  /*627*/ { function_entry, 0, 0, icache_illegal },
  /*628*/ { function_entry, 0, 0, icache_illegal },
  /*629*/ { function_entry, 0, 0, icache_illegal },
  /*630*/ { function_entry, 0, 0, icache_illegal },
  /*631*/ { function_entry, 0, 0, icache_illegal },
  /*632*/ { function_entry, 0, 0, icache_illegal },
  /*633*/ { function_entry, 0, 0, icache_illegal },
  /*634*/ { function_entry, 0, 0, icache_illegal },
  /*635*/ { function_entry, 0, 0, icache_illegal },
  /*636*/ { function_entry, 0, 0, icache_illegal },
  /*637*/ { function_entry, 0, 0, icache_illegal },
  /*638*/ { function_entry, 0, 0, icache_illegal },
  /*639*/ { function_entry, 0, 0, icache_illegal },
  /*640*/ { function_entry, 0, 0, icache_illegal },
  /*641*/ { function_entry, 0, 0, icache_illegal },
  /*642*/ { function_entry, 0, 0, icache_illegal },
  /*643*/ { function_entry, 0, 0, icache_illegal },
  /*644*/ { function_entry, 0, 0, icache_illegal },
  /*645*/ { function_entry, 0, 0, icache_illegal },
  /*646*/ { function_entry, 0, 0, icache_illegal },
  /*647*/ { function_entry, 0, 0, icache_illegal },
  /*648*/ { function_entry, 0, 0, icache_illegal },
  /*649*/ { function_entry, 0, 0, icache_illegal },
  /*650*/ { function_entry, 0, 0, icache_illegal },
  /*651*/ { function_entry, 0, 0, icache_illegal },
  /*652*/ { function_entry, 0, 0, icache_illegal },
  /*653*/ { function_entry, 0, 0, icache_illegal },
  /*654*/ { function_entry, 0, 0, icache_illegal },
  /*655*/ { function_entry, 0, 0, icache_illegal },
  /*656*/ { function_entry, 0, 0, icache_illegal },
  /*657*/ { function_entry, 0, 0, icache_illegal },
  /*658*/ { function_entry, 0, 0, icache_illegal },
  /*659*/ { function_entry, 0, 0, icache_illegal },
  /*660*/ { function_entry, 0, 0, icache_illegal },
  /*661*/ { function_entry, 0, 0, icache_illegal },
  /*662*/ { function_entry, 0, 0, icache_illegal },
  /*663*/ { function_entry, 0, 0, icache_illegal },
  /*664*/ { function_entry, 0, 0, icache_illegal },
  /*665*/ { function_entry, 0, 0, icache_illegal },
  /*666*/ { function_entry, 0, 0, icache_illegal },
  /*667*/ { function_entry, 0, 0, icache_illegal },
  /*668*/ { function_entry, 0, 0, icache_illegal },
  /*669*/ { function_entry, 0, 0, icache_illegal },
  /*670*/ { function_entry, 0, 0, icache_illegal },
  /*671*/ { function_entry, 0, 0, icache_illegal },
  /*672*/ { function_entry, 0, 0, icache_illegal },
  /*673*/ { function_entry, 0, 0, icache_illegal },
  /*674*/ { function_entry, 0, 0, icache_illegal },
  /*675*/ { function_entry, 0, 0, icache_illegal },
  /*676*/ { function_entry, 0, 0, icache_illegal },
  /*677*/ { function_entry, 0, 0, icache_illegal },
  /*678*/ { function_entry, 0, 0, icache_illegal },
  /*679*/ { function_entry, 0, 0, icache_illegal },
  /*680*/ { function_entry, 0, 0, icache_illegal },
  /*681*/ { function_entry, 0, 0, icache_illegal },
  /*682*/ { function_entry, 0, 0, icache_illegal },
  /*683*/ { function_entry, 0, 0, icache_illegal },
  /*684*/ { function_entry, 0, 0, icache_illegal },
  /*685*/ { function_entry, 0, 0, icache_illegal },
  /*686*/ { function_entry, 0, 0, icache_illegal },
  /*687*/ { function_entry, 0, 0, icache_illegal },
  /*688*/ { function_entry, 0, 0, icache_illegal },
  /*689*/ { function_entry, 0, 0, icache_illegal },
  /*690*/ { function_entry, 0, 0, icache_illegal },
  /*691*/ { function_entry, 0, 0, icache_illegal },
  /*692*/ { function_entry, 0, 0, icache_illegal },
  /*693*/ { function_entry, 0, 0, icache_illegal },
  /*694*/ { function_entry, 0, 0, icache_illegal },
  /*695*/ { function_entry, 0, 0, icache_illegal },
  /*696*/ { function_entry, 0, 0, icache_illegal },
  /*697*/ { function_entry, 0, 0, icache_illegal },
  /*698*/ { function_entry, 0, 0, icache_illegal },
  /*699*/ { function_entry, 0, 0, icache_illegal },
  /*700*/ { function_entry, 0, 0, icache_illegal },
  /*701*/ { function_entry, 0, 0, icache_illegal },
  /*702*/ { function_entry, 0, 0, icache_illegal },
  /*703*/ { function_entry, 0, 0, icache_illegal },
  /*704*/ { function_entry, 0, 0, icache_illegal },
  /*705*/ { function_entry, 0, 0, icache_illegal },
  /*706*/ { function_entry, 0, 0, icache_illegal },
  /*707*/ { function_entry, 0, 0, icache_illegal },
  /*708*/ { function_entry, 0, 0, icache_illegal },
  /*709*/ { function_entry, 0, 0, icache_illegal },
  /*710*/ { function_entry, 0, 0, icache_illegal },
  /*711*/ { function_entry, 0, 0, icache_illegal },
  /*712*/ { function_entry, 0, 0, icache_illegal },
  /*713*/ { function_entry, 0, 0, icache_illegal },
  /*714*/ { function_entry, 0, 0, icache_illegal },
  /*715*/ { function_entry, 0, 0, icache_illegal },
  /*716*/ { function_entry, 0, 0, icache_illegal },
  /*717*/ { function_entry, 0, 0, icache_illegal },
  /*718*/ { function_entry, 0, 0, icache_illegal },
  /*719*/ { function_entry, 0, 0, icache_illegal },
  /*720*/ { function_entry, 0, 0, icache_illegal },
  /*721*/ { function_entry, 0, 0, icache_illegal },
  /*722*/ { function_entry, 0, 0, icache_illegal },
  /*723*/ { function_entry, 0, 0, icache_illegal },
  /*724*/ { function_entry, 0, 0, icache_illegal },
  /*725*/ { function_entry, 0, 0, icache_illegal },
  /*726*/ { function_entry, 0, 0, icache_illegal },
  /*727*/ { function_entry, 0, 0, icache_illegal },
  /*728*/ { function_entry, 0, 0, icache_illegal },
  /*729*/ { function_entry, 0, 0, icache_illegal },
  /*730*/ { function_entry, 0, 0, icache_illegal },
  /*731*/ { function_entry, 0, 0, icache_illegal },
  /*732*/ { function_entry, 0, 0, icache_illegal },
  /*733*/ { function_entry, 0, 0, icache_illegal },
  /*734*/ { function_entry, 0, 0, icache_illegal },
  /*735*/ { function_entry, 0, 0, icache_illegal },
  /*736*/ { function_entry, 0, 0, icache_illegal },
  /*737*/ { function_entry, 0, 0, icache_illegal },
  /*738*/ { function_entry, 0, 0, icache_illegal },
  /*739*/ { function_entry, 0, 0, icache_illegal },
  /*740*/ { function_entry, 0, 0, icache_illegal },
  /*741*/ { function_entry, 0, 0, icache_illegal },
  /*742*/ { function_entry, 0, 0, icache_illegal },
  /*743*/ { function_entry, 0, 0, icache_illegal },
  /*744*/ { function_entry, 0, 0, icache_illegal },
  /*745*/ { function_entry, 0, 0, icache_illegal },
  /*746*/ { function_entry, 0, 0, icache_illegal },
  /*747*/ { function_entry, 0, 0, icache_illegal },
  /*748*/ { function_entry, 0, 0, icache_illegal },
  /*749*/ { function_entry, 0, 0, icache_illegal },
  /*750*/ { function_entry, 0, 0, icache_illegal },
  /*751*/ { function_entry, 0, 0, icache_illegal },
  /*752*/ { function_entry, 0, 0, icache_illegal },
  /*753*/ { function_entry, 0, 0, icache_illegal },
  /*754*/ { function_entry, 0, 0, icache_illegal },
  /*755*/ { function_entry, 0, 0, icache_illegal },
  /*756*/ { function_entry, 0, 0, icache_illegal },
  /*757*/ { function_entry, 0, 0, icache_illegal },
  /*758*/ { function_entry, 0, 0, icache_illegal },
  /*759*/ { function_entry, 0, 0, icache_illegal },
  /*760*/ { function_entry, 0, 0, icache_illegal },
  /*761*/ { function_entry, 0, 0, icache_illegal },
  /*762*/ { function_entry, 0, 0, icache_illegal },
  /*763*/ { function_entry, 0, 0, icache_illegal },
  /*764*/ { function_entry, 0, 0, icache_illegal },
  /*765*/ { function_entry, 0, 0, icache_illegal },
  /*766*/ { function_entry, 0, 0, icache_illegal },
  /*767*/ { function_entry, 0, 0, icache_illegal },
  /*768*/ { function_entry, 0, 0, icache_illegal },
  /*769*/ { function_entry, 0, 0, icache_illegal },
  /*770*/ { function_entry, 0, 0, icache_illegal },
  /*771*/ { function_entry, 0, 0, icache_illegal },
  /*772*/ { function_entry, 0, 0, icache_illegal },
  /*773*/ { function_entry, 0, 0, icache_illegal },
  /*774*/ { function_entry, 0, 0, icache_illegal },
  /*775*/ { function_entry, 0, 0, icache_illegal },
  /*776*/ { function_entry, 0, 0, icache_illegal },
  /*777*/ { function_entry, 0, 0, icache_illegal },
  /*778*/ { function_entry, 0, 0, icache_illegal },
  /*779*/ { function_entry, 0, 0, icache_illegal },
  /*780*/ { function_entry, 0, 0, icache_illegal },
  /*781*/ { function_entry, 0, 0, icache_illegal },
  /*782*/ { function_entry, 0, 0, icache_illegal },
  /*783*/ { function_entry, 0, 0, icache_illegal },
  /*784*/ { function_entry, 0, 0, icache_illegal },
  /*785*/ { function_entry, 0, 0, icache_illegal },
  /*786*/ { function_entry, 0, 0, icache_illegal },
  /*787*/ { function_entry, 0, 0, icache_illegal },
  /*788*/ { function_entry, 0, 0, icache_illegal },
  /*789*/ { function_entry, 0, 0, icache_illegal },
  /*790*/ { function_entry, 0, 0, icache_illegal },
  /*791*/ { function_entry, 0, 0, icache_illegal },
  /*792*/ { function_entry, 0, 0, icache_illegal },
  /*793*/ { function_entry, 0, 0, icache_illegal },
  /*794*/ { function_entry, 0, 0, icache_illegal },
  /*795*/ { function_entry, 0, 0, icache_illegal },
  /*796*/ { function_entry, 0, 0, icache_illegal },
  /*797*/ { function_entry, 0, 0, icache_illegal },
  /*798*/ { function_entry, 0, 0, icache_illegal },
  /*799*/ { function_entry, 0, 0, icache_illegal },
  /*800*/ { function_entry, 0, 0, icache_illegal },
  /*801*/ { function_entry, 0, 0, icache_illegal },
  /*802*/ { function_entry, 0, 0, icache_illegal },
  /*803*/ { function_entry, 0, 0, icache_illegal },
  /*804*/ { function_entry, 0, 0, icache_illegal },
  /*805*/ { function_entry, 0, 0, icache_illegal },
  /*806*/ { function_entry, 0, 0, icache_illegal },
  /*807*/ { function_entry, 0, 0, icache_illegal },
  /*808*/ { function_entry, 0, 0, icache_illegal },
  /*809*/ { function_entry, 0, 0, icache_illegal },
  /*810*/ { function_entry, 0, 0, icache_illegal },
  /*811*/ { function_entry, 0, 0, icache_illegal },
  /*812*/ { function_entry, 0, 0, icache_illegal },
  /*813*/ { function_entry, 0, 0, icache_illegal },
  /*814*/ { function_entry, 0, 0, icache_illegal },
  /*815*/ { function_entry, 0, 0, icache_illegal },
  /*816*/ { function_entry, 0, 0, icache_illegal },
  /*817*/ { function_entry, 0, 0, icache_illegal },
  /*818*/ { function_entry, 0, 0, icache_illegal },
  /*819*/ { function_entry, 0, 0, icache_illegal },
  /*820*/ { function_entry, 0, 0, icache_illegal },
  /*821*/ { function_entry, 0, 0, icache_illegal },
  /*822*/ { function_entry, 0, 0, icache_illegal },
  /*823*/ { function_entry, 0, 0, icache_illegal },
  /*824*/ { function_entry, 0, 0, icache_illegal },
  /*825*/ { function_entry, 0, 0, icache_illegal },
  /*826*/ { function_entry, 0, 0, icache_illegal },
  /*827*/ { function_entry, 0, 0, icache_illegal },
  /*828*/ { function_entry, 0, 0, icache_illegal },
  /*829*/ { function_entry, 0, 0, icache_illegal },
  /*830*/ { function_entry, 0, 0, icache_illegal },
  /*831*/ { function_entry, 0, 0, icache_illegal },
  /*832*/ { function_entry, 0, 0, icache_illegal },
  /*833*/ { function_entry, 0, 0, icache_illegal },
  /*834*/ { function_entry, 0, 0, icache_Condition_Register_OR_with_Complement },
  /*835*/ { function_entry, 0, 0, icache_illegal },
  /*836*/ { function_entry, 0, 0, icache_illegal },
  /*837*/ { function_entry, 0, 0, icache_illegal },
  /*838*/ { function_entry, 0, 0, icache_illegal },
  /*839*/ { function_entry, 0, 0, icache_illegal },
  /*840*/ { function_entry, 0, 0, icache_illegal },
  /*841*/ { function_entry, 0, 0, icache_illegal },
  /*842*/ { function_entry, 0, 0, icache_illegal },
  /*843*/ { function_entry, 0, 0, icache_illegal },
  /*844*/ { function_entry, 0, 0, icache_illegal },
  /*845*/ { function_entry, 0, 0, icache_illegal },
  /*846*/ { function_entry, 0, 0, icache_illegal },
  /*847*/ { function_entry, 0, 0, icache_illegal },
  /*848*/ { function_entry, 0, 0, icache_illegal },
  /*849*/ { function_entry, 0, 0, icache_illegal },
  /*850*/ { function_entry, 0, 0, icache_illegal },
  /*851*/ { function_entry, 0, 0, icache_illegal },
  /*852*/ { function_entry, 0, 0, icache_illegal },
  /*853*/ { function_entry, 0, 0, icache_illegal },
  /*854*/ { function_entry, 0, 0, icache_illegal },
  /*855*/ { function_entry, 0, 0, icache_illegal },
  /*856*/ { function_entry, 0, 0, icache_illegal },
  /*857*/ { function_entry, 0, 0, icache_illegal },
  /*858*/ { function_entry, 0, 0, icache_illegal },
  /*859*/ { function_entry, 0, 0, icache_illegal },
  /*860*/ { function_entry, 0, 0, icache_illegal },
  /*861*/ { function_entry, 0, 0, icache_illegal },
  /*862*/ { function_entry, 0, 0, icache_illegal },
  /*863*/ { function_entry, 0, 0, icache_illegal },
  /*864*/ { function_entry, 0, 0, icache_illegal },
  /*865*/ { function_entry, 0, 0, icache_illegal },
  /*866*/ { function_entry, 0, 0, icache_illegal },
  /*867*/ { function_entry, 0, 0, icache_illegal },
  /*868*/ { function_entry, 0, 0, icache_illegal },
  /*869*/ { function_entry, 0, 0, icache_illegal },
  /*870*/ { function_entry, 0, 0, icache_illegal },
  /*871*/ { function_entry, 0, 0, icache_illegal },
  /*872*/ { function_entry, 0, 0, icache_illegal },
  /*873*/ { function_entry, 0, 0, icache_illegal },
  /*874*/ { function_entry, 0, 0, icache_illegal },
  /*875*/ { function_entry, 0, 0, icache_illegal },
  /*876*/ { function_entry, 0, 0, icache_illegal },
  /*877*/ { function_entry, 0, 0, icache_illegal },
  /*878*/ { function_entry, 0, 0, icache_illegal },
  /*879*/ { function_entry, 0, 0, icache_illegal },
  /*880*/ { function_entry, 0, 0, icache_illegal },
  /*881*/ { function_entry, 0, 0, icache_illegal },
  /*882*/ { function_entry, 0, 0, icache_illegal },
  /*883*/ { function_entry, 0, 0, icache_illegal },
  /*884*/ { function_entry, 0, 0, icache_illegal },
  /*885*/ { function_entry, 0, 0, icache_illegal },
  /*886*/ { function_entry, 0, 0, icache_illegal },
  /*887*/ { function_entry, 0, 0, icache_illegal },
  /*888*/ { function_entry, 0, 0, icache_illegal },
  /*889*/ { function_entry, 0, 0, icache_illegal },
  /*890*/ { function_entry, 0, 0, icache_illegal },
  /*891*/ { function_entry, 0, 0, icache_illegal },
  /*892*/ { function_entry, 0, 0, icache_illegal },
  /*893*/ { function_entry, 0, 0, icache_illegal },
  /*894*/ { function_entry, 0, 0, icache_illegal },
  /*895*/ { function_entry, 0, 0, icache_illegal },
  /*896*/ { function_entry, 0, 0, icache_illegal },
  /*897*/ { function_entry, 0, 0, icache_illegal },
  /*898*/ { function_entry, 0, 0, icache_Condition_Register_OR },
  /*899*/ { function_entry, 0, 0, icache_illegal },
  /*900*/ { function_entry, 0, 0, icache_illegal },
  /*901*/ { function_entry, 0, 0, icache_illegal },
  /*902*/ { function_entry, 0, 0, icache_illegal },
  /*903*/ { function_entry, 0, 0, icache_illegal },
  /*904*/ { function_entry, 0, 0, icache_illegal },
  /*905*/ { function_entry, 0, 0, icache_illegal },
  /*906*/ { function_entry, 0, 0, icache_illegal },
  /*907*/ { function_entry, 0, 0, icache_illegal },
  /*908*/ { function_entry, 0, 0, icache_illegal },
  /*909*/ { function_entry, 0, 0, icache_illegal },
  /*910*/ { function_entry, 0, 0, icache_illegal },
  /*911*/ { function_entry, 0, 0, icache_illegal },
  /*912*/ { function_entry, 0, 0, icache_illegal },
  /*913*/ { function_entry, 0, 0, icache_illegal },
  /*914*/ { function_entry, 0, 0, icache_illegal },
  /*915*/ { function_entry, 0, 0, icache_illegal },
  /*916*/ { function_entry, 0, 0, icache_illegal },
  /*917*/ { function_entry, 0, 0, icache_illegal },
  /*918*/ { function_entry, 0, 0, icache_illegal },
  /*919*/ { function_entry, 0, 0, icache_illegal },
  /*920*/ { function_entry, 0, 0, icache_illegal },
  /*921*/ { function_entry, 0, 0, icache_illegal },
  /*922*/ { function_entry, 0, 0, icache_illegal },
  /*923*/ { function_entry, 0, 0, icache_illegal },
  /*924*/ { function_entry, 0, 0, icache_illegal },
  /*925*/ { function_entry, 0, 0, icache_illegal },
  /*926*/ { function_entry, 0, 0, icache_illegal },
  /*927*/ { function_entry, 0, 0, icache_illegal },
  /*928*/ { function_entry, 0, 0, icache_illegal },
  /*929*/ { function_entry, 0, 0, icache_illegal },
  /*930*/ { function_entry, 0, 0, icache_illegal },
  /*931*/ { function_entry, 0, 0, icache_illegal },
  /*932*/ { function_entry, 0, 0, icache_illegal },
  /*933*/ { function_entry, 0, 0, icache_illegal },
  /*934*/ { function_entry, 0, 0, icache_illegal },
  /*935*/ { function_entry, 0, 0, icache_illegal },
  /*936*/ { function_entry, 0, 0, icache_illegal },
  /*937*/ { function_entry, 0, 0, icache_illegal },
  /*938*/ { function_entry, 0, 0, icache_illegal },
  /*939*/ { function_entry, 0, 0, icache_illegal },
  /*940*/ { function_entry, 0, 0, icache_illegal },
  /*941*/ { function_entry, 0, 0, icache_illegal },
  /*942*/ { function_entry, 0, 0, icache_illegal },
  /*943*/ { function_entry, 0, 0, icache_illegal },
  /*944*/ { function_entry, 0, 0, icache_illegal },
  /*945*/ { function_entry, 0, 0, icache_illegal },
  /*946*/ { function_entry, 0, 0, icache_illegal },
  /*947*/ { function_entry, 0, 0, icache_illegal },
  /*948*/ { function_entry, 0, 0, icache_illegal },
  /*949*/ { function_entry, 0, 0, icache_illegal },
  /*950*/ { function_entry, 0, 0, icache_illegal },
  /*951*/ { function_entry, 0, 0, icache_illegal },
  /*952*/ { function_entry, 0, 0, icache_illegal },
  /*953*/ { function_entry, 0, 0, icache_illegal },
  /*954*/ { function_entry, 0, 0, icache_illegal },
  /*955*/ { function_entry, 0, 0, icache_illegal },
  /*956*/ { function_entry, 0, 0, icache_illegal },
  /*957*/ { function_entry, 0, 0, icache_illegal },
  /*958*/ { function_entry, 0, 0, icache_illegal },
  /*959*/ { function_entry, 0, 0, icache_illegal },
  /*960*/ { function_entry, 0, 0, icache_illegal },
  /*961*/ { function_entry, 0, 0, icache_illegal },
  /*962*/ { function_entry, 0, 0, icache_illegal },
  /*963*/ { function_entry, 0, 0, icache_illegal },
  /*964*/ { function_entry, 0, 0, icache_illegal },
  /*965*/ { function_entry, 0, 0, icache_illegal },
  /*966*/ { function_entry, 0, 0, icache_illegal },
  /*967*/ { function_entry, 0, 0, icache_illegal },
  /*968*/ { function_entry, 0, 0, icache_illegal },
  /*969*/ { function_entry, 0, 0, icache_illegal },
  /*970*/ { function_entry, 0, 0, icache_illegal },
  /*971*/ { function_entry, 0, 0, icache_illegal },
  /*972*/ { function_entry, 0, 0, icache_illegal },
  /*973*/ { function_entry, 0, 0, icache_illegal },
  /*974*/ { function_entry, 0, 0, icache_illegal },
  /*975*/ { function_entry, 0, 0, icache_illegal },
  /*976*/ { function_entry, 0, 0, icache_illegal },
  /*977*/ { function_entry, 0, 0, icache_illegal },
  /*978*/ { function_entry, 0, 0, icache_illegal },
  /*979*/ { function_entry, 0, 0, icache_illegal },
  /*980*/ { function_entry, 0, 0, icache_illegal },
  /*981*/ { function_entry, 0, 0, icache_illegal },
  /*982*/ { function_entry, 0, 0, icache_illegal },
  /*983*/ { function_entry, 0, 0, icache_illegal },
  /*984*/ { function_entry, 0, 0, icache_illegal },
  /*985*/ { function_entry, 0, 0, icache_illegal },
  /*986*/ { function_entry, 0, 0, icache_illegal },
  /*987*/ { function_entry, 0, 0, icache_illegal },
  /*988*/ { function_entry, 0, 0, icache_illegal },
  /*989*/ { function_entry, 0, 0, icache_illegal },
  /*990*/ { function_entry, 0, 0, icache_illegal },
  /*991*/ { function_entry, 0, 0, icache_illegal },
  /*992*/ { function_entry, 0, 0, icache_illegal },
  /*993*/ { function_entry, 0, 0, icache_illegal },
  /*994*/ { function_entry, 0, 0, icache_illegal },
  /*995*/ { function_entry, 0, 0, icache_illegal },
  /*996*/ { function_entry, 0, 0, icache_illegal },
  /*997*/ { function_entry, 0, 0, icache_illegal },
  /*998*/ { function_entry, 0, 0, icache_illegal },
  /*999*/ { function_entry, 0, 0, icache_illegal },
  /*1000*/ { function_entry, 0, 0, icache_illegal },
  /*1001*/ { function_entry, 0, 0, icache_illegal },
  /*1002*/ { function_entry, 0, 0, icache_illegal },
  /*1003*/ { function_entry, 0, 0, icache_illegal },
  /*1004*/ { function_entry, 0, 0, icache_illegal },
  /*1005*/ { function_entry, 0, 0, icache_illegal },
  /*1006*/ { function_entry, 0, 0, icache_illegal },
  /*1007*/ { function_entry, 0, 0, icache_illegal },
  /*1008*/ { function_entry, 0, 0, icache_illegal },
  /*1009*/ { function_entry, 0, 0, icache_illegal },
  /*1010*/ { function_entry, 0, 0, icache_illegal },
  /*1011*/ { function_entry, 0, 0, icache_illegal },
  /*1012*/ { function_entry, 0, 0, icache_illegal },
  /*1013*/ { function_entry, 0, 0, icache_illegal },
  /*1014*/ { function_entry, 0, 0, icache_illegal },
  /*1015*/ { function_entry, 0, 0, icache_illegal },
  /*1016*/ { function_entry, 0, 0, icache_illegal },
  /*1017*/ { function_entry, 0, 0, icache_illegal },
  /*1018*/ { function_entry, 0, 0, icache_illegal },
  /*1019*/ { function_entry, 0, 0, icache_illegal },
  /*1020*/ { function_entry, 0, 0, icache_illegal },
  /*1021*/ { function_entry, 0, 0, icache_illegal },
  /*1022*/ { function_entry, 0, 0, icache_illegal },
  /*1023*/ { function_entry, 0, 0, icache_illegal },
  /*1024*/ { function_entry, 0, 0, icache_illegal },
  /*1025*/ { function_entry, 0, 0, icache_illegal },
  /*1026*/ { function_entry, 0, 0, icache_illegal },
  /*1027*/ { function_entry, 0, 0, icache_illegal },
  /*1028*/ { function_entry, 0, 0, icache_illegal },
  /*1029*/ { function_entry, 0, 0, icache_illegal },
  /*1030*/ { function_entry, 0, 0, icache_illegal },
  /*1031*/ { function_entry, 0, 0, icache_illegal },
  /*1032*/ { function_entry, 0, 0, icache_illegal },
  /*1033*/ { function_entry, 0, 0, icache_illegal },
  /*1034*/ { function_entry, 0, 0, icache_illegal },
  /*1035*/ { function_entry, 0, 0, icache_illegal },
  /*1036*/ { function_entry, 0, 0, icache_illegal },
  /*1037*/ { function_entry, 0, 0, icache_illegal },
  /*1038*/ { function_entry, 0, 0, icache_illegal },
  /*1039*/ { function_entry, 0, 0, icache_illegal },
  /*1040*/ { function_entry, 0, 0, icache_illegal },
  /*1041*/ { function_entry, 0, 0, icache_illegal },
  /*1042*/ { function_entry, 0, 0, icache_illegal },
  /*1043*/ { function_entry, 0, 0, icache_illegal },
  /*1044*/ { function_entry, 0, 0, icache_illegal },
  /*1045*/ { function_entry, 0, 0, icache_illegal },
  /*1046*/ { function_entry, 0, 0, icache_illegal },
  /*1047*/ { function_entry, 0, 0, icache_illegal },
  /*1048*/ { function_entry, 0, 0, icache_illegal },
  /*1049*/ { function_entry, 0, 0, icache_illegal },
  /*1050*/ { function_entry, 0, 0, icache_illegal },
  /*1051*/ { function_entry, 0, 0, icache_illegal },
  /*1052*/ { function_entry, 0, 0, icache_illegal },
  /*1053*/ { function_entry, 0, 0, icache_illegal },
  /*1054*/ { function_entry, 0, 0, icache_illegal },
  /*1055*/ { function_entry, 0, 0, icache_illegal },
  /*1056*/ { function_entry, 0, 0, icache_Branch_Conditional_to_Count_Register_LK0 },
  /*1057*/ { function_entry, 0, 0, icache_Branch_Conditional_to_Count_Register_LK1 },
  /*1058*/ { function_entry, 0, 0, icache_illegal },
  /*1059*/ { function_entry, 0, 0, icache_illegal },
  /*1060*/ { function_entry, 0, 0, icache_illegal },
  /*1061*/ { function_entry, 0, 0, icache_illegal },
  /*1062*/ { function_entry, 0, 0, icache_illegal },
  /*1063*/ { function_entry, 0, 0, icache_illegal },
  /*1064*/ { function_entry, 0, 0, icache_illegal },
  /*1065*/ { function_entry, 0, 0, icache_illegal },
  /*1066*/ { function_entry, 0, 0, icache_illegal },
  /*1067*/ { function_entry, 0, 0, icache_illegal },
  /*1068*/ { function_entry, 0, 0, icache_illegal },
  /*1069*/ { function_entry, 0, 0, icache_illegal },
  /*1070*/ { function_entry, 0, 0, icache_illegal },
  /*1071*/ { function_entry, 0, 0, icache_illegal },
  /*1072*/ { function_entry, 0, 0, icache_illegal },
  /*1073*/ { function_entry, 0, 0, icache_illegal },
  /*1074*/ { function_entry, 0, 0, icache_illegal },
  /*1075*/ { function_entry, 0, 0, icache_illegal },
  /*1076*/ { function_entry, 0, 0, icache_illegal },
  /*1077*/ { function_entry, 0, 0, icache_illegal },
  /*1078*/ { function_entry, 0, 0, icache_illegal },
  /*1079*/ { function_entry, 0, 0, icache_illegal },
  /*1080*/ { function_entry, 0, 0, icache_illegal },
  /*1081*/ { function_entry, 0, 0, icache_illegal },
  /*1082*/ { function_entry, 0, 0, icache_illegal },
  /*1083*/ { function_entry, 0, 0, icache_illegal },
  /*1084*/ { function_entry, 0, 0, icache_illegal },
  /*1085*/ { function_entry, 0, 0, icache_illegal },
  /*1086*/ { function_entry, 0, 0, icache_illegal },
  /*1087*/ { function_entry, 0, 0, icache_illegal },
  /*1088*/ { function_entry, 0, 0, icache_illegal },
  /*1089*/ { function_entry, 0, 0, icache_illegal },
  /*1090*/ { function_entry, 0, 0, icache_illegal },
  /*1091*/ { function_entry, 0, 0, icache_illegal },
  /*1092*/ { function_entry, 0, 0, icache_illegal },
  /*1093*/ { function_entry, 0, 0, icache_illegal },
  /*1094*/ { function_entry, 0, 0, icache_illegal },
  /*1095*/ { function_entry, 0, 0, icache_illegal },
  /*1096*/ { function_entry, 0, 0, icache_illegal },
  /*1097*/ { function_entry, 0, 0, icache_illegal },
  /*1098*/ { function_entry, 0, 0, icache_illegal },
  /*1099*/ { function_entry, 0, 0, icache_illegal },
  /*1100*/ { function_entry, 0, 0, icache_illegal },
  /*1101*/ { function_entry, 0, 0, icache_illegal },
  /*1102*/ { function_entry, 0, 0, icache_illegal },
  /*1103*/ { function_entry, 0, 0, icache_illegal },
  /*1104*/ { function_entry, 0, 0, icache_illegal },
  /*1105*/ { function_entry, 0, 0, icache_illegal },
  /*1106*/ { function_entry, 0, 0, icache_illegal },
  /*1107*/ { function_entry, 0, 0, icache_illegal },
  /*1108*/ { function_entry, 0, 0, icache_illegal },
  /*1109*/ { function_entry, 0, 0, icache_illegal },
  /*1110*/ { function_entry, 0, 0, icache_illegal },
  /*1111*/ { function_entry, 0, 0, icache_illegal },
  /*1112*/ { function_entry, 0, 0, icache_illegal },
  /*1113*/ { function_entry, 0, 0, icache_illegal },
  /*1114*/ { function_entry, 0, 0, icache_illegal },
  /*1115*/ { function_entry, 0, 0, icache_illegal },
  /*1116*/ { function_entry, 0, 0, icache_illegal },
  /*1117*/ { function_entry, 0, 0, icache_illegal },
  /*1118*/ { function_entry, 0, 0, icache_illegal },
  /*1119*/ { function_entry, 0, 0, icache_illegal },
  /*1120*/ { function_entry, 0, 0, icache_illegal },
  /*1121*/ { function_entry, 0, 0, icache_illegal },
  /*1122*/ { function_entry, 0, 0, icache_illegal },
  /*1123*/ { function_entry, 0, 0, icache_illegal },
  /*1124*/ { function_entry, 0, 0, icache_illegal },
  /*1125*/ { function_entry, 0, 0, icache_illegal },
  /*1126*/ { function_entry, 0, 0, icache_illegal },
  /*1127*/ { function_entry, 0, 0, icache_illegal },
  /*1128*/ { function_entry, 0, 0, icache_illegal },
  /*1129*/ { function_entry, 0, 0, icache_illegal },
  /*1130*/ { function_entry, 0, 0, icache_illegal },
  /*1131*/ { function_entry, 0, 0, icache_illegal },
  /*1132*/ { function_entry, 0, 0, icache_illegal },
  /*1133*/ { function_entry, 0, 0, icache_illegal },
  /*1134*/ { function_entry, 0, 0, icache_illegal },
  /*1135*/ { function_entry, 0, 0, icache_illegal },
  /*1136*/ { function_entry, 0, 0, icache_illegal },
  /*1137*/ { function_entry, 0, 0, icache_illegal },
  /*1138*/ { function_entry, 0, 0, icache_illegal },
  /*1139*/ { function_entry, 0, 0, icache_illegal },
  /*1140*/ { function_entry, 0, 0, icache_illegal },
  /*1141*/ { function_entry, 0, 0, icache_illegal },
  /*1142*/ { function_entry, 0, 0, icache_illegal },
  /*1143*/ { function_entry, 0, 0, icache_illegal },
  /*1144*/ { function_entry, 0, 0, icache_illegal },
  /*1145*/ { function_entry, 0, 0, icache_illegal },
  /*1146*/ { function_entry, 0, 0, icache_illegal },
  /*1147*/ { function_entry, 0, 0, icache_illegal },
  /*1148*/ { function_entry, 0, 0, icache_illegal },
  /*1149*/ { function_entry, 0, 0, icache_illegal },
  /*1150*/ { function_entry, 0, 0, icache_illegal },
  /*1151*/ { function_entry, 0, 0, icache_illegal },
  /*1152*/ { function_entry, 0, 0, icache_illegal },
  /*1153*/ { function_entry, 0, 0, icache_illegal },
  /*1154*/ { function_entry, 0, 0, icache_illegal },
  /*1155*/ { function_entry, 0, 0, icache_illegal },
  /*1156*/ { function_entry, 0, 0, icache_illegal },
  /*1157*/ { function_entry, 0, 0, icache_illegal },
  /*1158*/ { function_entry, 0, 0, icache_illegal },
  /*1159*/ { function_entry, 0, 0, icache_illegal },
  /*1160*/ { function_entry, 0, 0, icache_illegal },
  /*1161*/ { function_entry, 0, 0, icache_illegal },
  /*1162*/ { function_entry, 0, 0, icache_illegal },
  /*1163*/ { function_entry, 0, 0, icache_illegal },
  /*1164*/ { function_entry, 0, 0, icache_illegal },
  /*1165*/ { function_entry, 0, 0, icache_illegal },
  /*1166*/ { function_entry, 0, 0, icache_illegal },
  /*1167*/ { function_entry, 0, 0, icache_illegal },
  /*1168*/ { function_entry, 0, 0, icache_illegal },
  /*1169*/ { function_entry, 0, 0, icache_illegal },
  /*1170*/ { function_entry, 0, 0, icache_illegal },
  /*1171*/ { function_entry, 0, 0, icache_illegal },
  /*1172*/ { function_entry, 0, 0, icache_illegal },
  /*1173*/ { function_entry, 0, 0, icache_illegal },
  /*1174*/ { function_entry, 0, 0, icache_illegal },
  /*1175*/ { function_entry, 0, 0, icache_illegal },
  /*1176*/ { function_entry, 0, 0, icache_illegal },
  /*1177*/ { function_entry, 0, 0, icache_illegal },
  /*1178*/ { function_entry, 0, 0, icache_illegal },
  /*1179*/ { function_entry, 0, 0, icache_illegal },
  /*1180*/ { function_entry, 0, 0, icache_illegal },
  /*1181*/ { function_entry, 0, 0, icache_illegal },
  /*1182*/ { function_entry, 0, 0, icache_illegal },
  /*1183*/ { function_entry, 0, 0, icache_illegal },
  /*1184*/ { function_entry, 0, 0, icache_illegal },
  /*1185*/ { function_entry, 0, 0, icache_illegal },
  /*1186*/ { function_entry, 0, 0, icache_illegal },
  /*1187*/ { function_entry, 0, 0, icache_illegal },
  /*1188*/ { function_entry, 0, 0, icache_illegal },
  /*1189*/ { function_entry, 0, 0, icache_illegal },
  /*1190*/ { function_entry, 0, 0, icache_illegal },
  /*1191*/ { function_entry, 0, 0, icache_illegal },
  /*1192*/ { function_entry, 0, 0, icache_illegal },
  /*1193*/ { function_entry, 0, 0, icache_illegal },
  /*1194*/ { function_entry, 0, 0, icache_illegal },
  /*1195*/ { function_entry, 0, 0, icache_illegal },
  /*1196*/ { function_entry, 0, 0, icache_illegal },
  /*1197*/ { function_entry, 0, 0, icache_illegal },
  /*1198*/ { function_entry, 0, 0, icache_illegal },
  /*1199*/ { function_entry, 0, 0, icache_illegal },
  /*1200*/ { function_entry, 0, 0, icache_illegal },
  /*1201*/ { function_entry, 0, 0, icache_illegal },
  /*1202*/ { function_entry, 0, 0, icache_illegal },
  /*1203*/ { function_entry, 0, 0, icache_illegal },
  /*1204*/ { function_entry, 0, 0, icache_illegal },
  /*1205*/ { function_entry, 0, 0, icache_illegal },
  /*1206*/ { function_entry, 0, 0, icache_illegal },
  /*1207*/ { function_entry, 0, 0, icache_illegal },
  /*1208*/ { function_entry, 0, 0, icache_illegal },
  /*1209*/ { function_entry, 0, 0, icache_illegal },
  /*1210*/ { function_entry, 0, 0, icache_illegal },
  /*1211*/ { function_entry, 0, 0, icache_illegal },
  /*1212*/ { function_entry, 0, 0, icache_illegal },
  /*1213*/ { function_entry, 0, 0, icache_illegal },
  /*1214*/ { function_entry, 0, 0, icache_illegal },
  /*1215*/ { function_entry, 0, 0, icache_illegal },
  /*1216*/ { function_entry, 0, 0, icache_illegal },
  /*1217*/ { function_entry, 0, 0, icache_illegal },
  /*1218*/ { function_entry, 0, 0, icache_illegal },
  /*1219*/ { function_entry, 0, 0, icache_illegal },
  /*1220*/ { function_entry, 0, 0, icache_illegal },
  /*1221*/ { function_entry, 0, 0, icache_illegal },
  /*1222*/ { function_entry, 0, 0, icache_illegal },
  /*1223*/ { function_entry, 0, 0, icache_illegal },
  /*1224*/ { function_entry, 0, 0, icache_illegal },
  /*1225*/ { function_entry, 0, 0, icache_illegal },
  /*1226*/ { function_entry, 0, 0, icache_illegal },
  /*1227*/ { function_entry, 0, 0, icache_illegal },
  /*1228*/ { function_entry, 0, 0, icache_illegal },
  /*1229*/ { function_entry, 0, 0, icache_illegal },
  /*1230*/ { function_entry, 0, 0, icache_illegal },
  /*1231*/ { function_entry, 0, 0, icache_illegal },
  /*1232*/ { function_entry, 0, 0, icache_illegal },
  /*1233*/ { function_entry, 0, 0, icache_illegal },
  /*1234*/ { function_entry, 0, 0, icache_illegal },
  /*1235*/ { function_entry, 0, 0, icache_illegal },
  /*1236*/ { function_entry, 0, 0, icache_illegal },
  /*1237*/ { function_entry, 0, 0, icache_illegal },
  /*1238*/ { function_entry, 0, 0, icache_illegal },
  /*1239*/ { function_entry, 0, 0, icache_illegal },
  /*1240*/ { function_entry, 0, 0, icache_illegal },
  /*1241*/ { function_entry, 0, 0, icache_illegal },
  /*1242*/ { function_entry, 0, 0, icache_illegal },
  /*1243*/ { function_entry, 0, 0, icache_illegal },
  /*1244*/ { function_entry, 0, 0, icache_illegal },
  /*1245*/ { function_entry, 0, 0, icache_illegal },
  /*1246*/ { function_entry, 0, 0, icache_illegal },
  /*1247*/ { function_entry, 0, 0, icache_illegal },
  /*1248*/ { function_entry, 0, 0, icache_illegal },
  /*1249*/ { function_entry, 0, 0, icache_illegal },
  /*1250*/ { function_entry, 0, 0, icache_illegal },
  /*1251*/ { function_entry, 0, 0, icache_illegal },
  /*1252*/ { function_entry, 0, 0, icache_illegal },
  /*1253*/ { function_entry, 0, 0, icache_illegal },
  /*1254*/ { function_entry, 0, 0, icache_illegal },
  /*1255*/ { function_entry, 0, 0, icache_illegal },
  /*1256*/ { function_entry, 0, 0, icache_illegal },
  /*1257*/ { function_entry, 0, 0, icache_illegal },
  /*1258*/ { function_entry, 0, 0, icache_illegal },
  /*1259*/ { function_entry, 0, 0, icache_illegal },
  /*1260*/ { function_entry, 0, 0, icache_illegal },
  /*1261*/ { function_entry, 0, 0, icache_illegal },
  /*1262*/ { function_entry, 0, 0, icache_illegal },
  /*1263*/ { function_entry, 0, 0, icache_illegal },
  /*1264*/ { function_entry, 0, 0, icache_illegal },
  /*1265*/ { function_entry, 0, 0, icache_illegal },
  /*1266*/ { function_entry, 0, 0, icache_illegal },
  /*1267*/ { function_entry, 0, 0, icache_illegal },
  /*1268*/ { function_entry, 0, 0, icache_illegal },
  /*1269*/ { function_entry, 0, 0, icache_illegal },
  /*1270*/ { function_entry, 0, 0, icache_illegal },
  /*1271*/ { function_entry, 0, 0, icache_illegal },
  /*1272*/ { function_entry, 0, 0, icache_illegal },
  /*1273*/ { function_entry, 0, 0, icache_illegal },
  /*1274*/ { function_entry, 0, 0, icache_illegal },
  /*1275*/ { function_entry, 0, 0, icache_illegal },
  /*1276*/ { function_entry, 0, 0, icache_illegal },
  /*1277*/ { function_entry, 0, 0, icache_illegal },
  /*1278*/ { function_entry, 0, 0, icache_illegal },
  /*1279*/ { function_entry, 0, 0, icache_illegal },
  /*1280*/ { function_entry, 0, 0, icache_illegal },
  /*1281*/ { function_entry, 0, 0, icache_illegal },
  /*1282*/ { function_entry, 0, 0, icache_illegal },
  /*1283*/ { function_entry, 0, 0, icache_illegal },
  /*1284*/ { function_entry, 0, 0, icache_illegal },
  /*1285*/ { function_entry, 0, 0, icache_illegal },
  /*1286*/ { function_entry, 0, 0, icache_illegal },
  /*1287*/ { function_entry, 0, 0, icache_illegal },
  /*1288*/ { function_entry, 0, 0, icache_illegal },
  /*1289*/ { function_entry, 0, 0, icache_illegal },
  /*1290*/ { function_entry, 0, 0, icache_illegal },
  /*1291*/ { function_entry, 0, 0, icache_illegal },
  /*1292*/ { function_entry, 0, 0, icache_illegal },
  /*1293*/ { function_entry, 0, 0, icache_illegal },
  /*1294*/ { function_entry, 0, 0, icache_illegal },
  /*1295*/ { function_entry, 0, 0, icache_illegal },
  /*1296*/ { function_entry, 0, 0, icache_illegal },
  /*1297*/ { function_entry, 0, 0, icache_illegal },
  /*1298*/ { function_entry, 0, 0, icache_illegal },
  /*1299*/ { function_entry, 0, 0, icache_illegal },
  /*1300*/ { function_entry, 0, 0, icache_illegal },
  /*1301*/ { function_entry, 0, 0, icache_illegal },
  /*1302*/ { function_entry, 0, 0, icache_illegal },
  /*1303*/ { function_entry, 0, 0, icache_illegal },
  /*1304*/ { function_entry, 0, 0, icache_illegal },
  /*1305*/ { function_entry, 0, 0, icache_illegal },
  /*1306*/ { function_entry, 0, 0, icache_illegal },
  /*1307*/ { function_entry, 0, 0, icache_illegal },
  /*1308*/ { function_entry, 0, 0, icache_illegal },
  /*1309*/ { function_entry, 0, 0, icache_illegal },
  /*1310*/ { function_entry, 0, 0, icache_illegal },
  /*1311*/ { function_entry, 0, 0, icache_illegal },
  /*1312*/ { function_entry, 0, 0, icache_illegal },
  /*1313*/ { function_entry, 0, 0, icache_illegal },
  /*1314*/ { function_entry, 0, 0, icache_illegal },
  /*1315*/ { function_entry, 0, 0, icache_illegal },
  /*1316*/ { function_entry, 0, 0, icache_illegal },
  /*1317*/ { function_entry, 0, 0, icache_illegal },
  /*1318*/ { function_entry, 0, 0, icache_illegal },
  /*1319*/ { function_entry, 0, 0, icache_illegal },
  /*1320*/ { function_entry, 0, 0, icache_illegal },
  /*1321*/ { function_entry, 0, 0, icache_illegal },
  /*1322*/ { function_entry, 0, 0, icache_illegal },
  /*1323*/ { function_entry, 0, 0, icache_illegal },
  /*1324*/ { function_entry, 0, 0, icache_illegal },
  /*1325*/ { function_entry, 0, 0, icache_illegal },
  /*1326*/ { function_entry, 0, 0, icache_illegal },
  /*1327*/ { function_entry, 0, 0, icache_illegal },
  /*1328*/ { function_entry, 0, 0, icache_illegal },
  /*1329*/ { function_entry, 0, 0, icache_illegal },
  /*1330*/ { function_entry, 0, 0, icache_illegal },
  /*1331*/ { function_entry, 0, 0, icache_illegal },
  /*1332*/ { function_entry, 0, 0, icache_illegal },
  /*1333*/ { function_entry, 0, 0, icache_illegal },
  /*1334*/ { function_entry, 0, 0, icache_illegal },
  /*1335*/ { function_entry, 0, 0, icache_illegal },
  /*1336*/ { function_entry, 0, 0, icache_illegal },
  /*1337*/ { function_entry, 0, 0, icache_illegal },
  /*1338*/ { function_entry, 0, 0, icache_illegal },
  /*1339*/ { function_entry, 0, 0, icache_illegal },
  /*1340*/ { function_entry, 0, 0, icache_illegal },
  /*1341*/ { function_entry, 0, 0, icache_illegal },
  /*1342*/ { function_entry, 0, 0, icache_illegal },
  /*1343*/ { function_entry, 0, 0, icache_illegal },
  /*1344*/ { function_entry, 0, 0, icache_illegal },
  /*1345*/ { function_entry, 0, 0, icache_illegal },
  /*1346*/ { function_entry, 0, 0, icache_illegal },
  /*1347*/ { function_entry, 0, 0, icache_illegal },
  /*1348*/ { function_entry, 0, 0, icache_illegal },
  /*1349*/ { function_entry, 0, 0, icache_illegal },
  /*1350*/ { function_entry, 0, 0, icache_illegal },
  /*1351*/ { function_entry, 0, 0, icache_illegal },
  /*1352*/ { function_entry, 0, 0, icache_illegal },
  /*1353*/ { function_entry, 0, 0, icache_illegal },
  /*1354*/ { function_entry, 0, 0, icache_illegal },
  /*1355*/ { function_entry, 0, 0, icache_illegal },
  /*1356*/ { function_entry, 0, 0, icache_illegal },
  /*1357*/ { function_entry, 0, 0, icache_illegal },
  /*1358*/ { function_entry, 0, 0, icache_illegal },
  /*1359*/ { function_entry, 0, 0, icache_illegal },
  /*1360*/ { function_entry, 0, 0, icache_illegal },
  /*1361*/ { function_entry, 0, 0, icache_illegal },
  /*1362*/ { function_entry, 0, 0, icache_illegal },
  /*1363*/ { function_entry, 0, 0, icache_illegal },
  /*1364*/ { function_entry, 0, 0, icache_illegal },
  /*1365*/ { function_entry, 0, 0, icache_illegal },
  /*1366*/ { function_entry, 0, 0, icache_illegal },
  /*1367*/ { function_entry, 0, 0, icache_illegal },
  /*1368*/ { function_entry, 0, 0, icache_illegal },
  /*1369*/ { function_entry, 0, 0, icache_illegal },
  /*1370*/ { function_entry, 0, 0, icache_illegal },
  /*1371*/ { function_entry, 0, 0, icache_illegal },
  /*1372*/ { function_entry, 0, 0, icache_illegal },
  /*1373*/ { function_entry, 0, 0, icache_illegal },
  /*1374*/ { function_entry, 0, 0, icache_illegal },
  /*1375*/ { function_entry, 0, 0, icache_illegal },
  /*1376*/ { function_entry, 0, 0, icache_illegal },
  /*1377*/ { function_entry, 0, 0, icache_illegal },
  /*1378*/ { function_entry, 0, 0, icache_illegal },
  /*1379*/ { function_entry, 0, 0, icache_illegal },
  /*1380*/ { function_entry, 0, 0, icache_illegal },
  /*1381*/ { function_entry, 0, 0, icache_illegal },
  /*1382*/ { function_entry, 0, 0, icache_illegal },
  /*1383*/ { function_entry, 0, 0, icache_illegal },
  /*1384*/ { function_entry, 0, 0, icache_illegal },
  /*1385*/ { function_entry, 0, 0, icache_illegal },
  /*1386*/ { function_entry, 0, 0, icache_illegal },
  /*1387*/ { function_entry, 0, 0, icache_illegal },
  /*1388*/ { function_entry, 0, 0, icache_illegal },
  /*1389*/ { function_entry, 0, 0, icache_illegal },
  /*1390*/ { function_entry, 0, 0, icache_illegal },
  /*1391*/ { function_entry, 0, 0, icache_illegal },
  /*1392*/ { function_entry, 0, 0, icache_illegal },
  /*1393*/ { function_entry, 0, 0, icache_illegal },
  /*1394*/ { function_entry, 0, 0, icache_illegal },
  /*1395*/ { function_entry, 0, 0, icache_illegal },
  /*1396*/ { function_entry, 0, 0, icache_illegal },
  /*1397*/ { function_entry, 0, 0, icache_illegal },
  /*1398*/ { function_entry, 0, 0, icache_illegal },
  /*1399*/ { function_entry, 0, 0, icache_illegal },
  /*1400*/ { function_entry, 0, 0, icache_illegal },
  /*1401*/ { function_entry, 0, 0, icache_illegal },
  /*1402*/ { function_entry, 0, 0, icache_illegal },
  /*1403*/ { function_entry, 0, 0, icache_illegal },
  /*1404*/ { function_entry, 0, 0, icache_illegal },
  /*1405*/ { function_entry, 0, 0, icache_illegal },
  /*1406*/ { function_entry, 0, 0, icache_illegal },
  /*1407*/ { function_entry, 0, 0, icache_illegal },
  /*1408*/ { function_entry, 0, 0, icache_illegal },
  /*1409*/ { function_entry, 0, 0, icache_illegal },
  /*1410*/ { function_entry, 0, 0, icache_illegal },
  /*1411*/ { function_entry, 0, 0, icache_illegal },
  /*1412*/ { function_entry, 0, 0, icache_illegal },
  /*1413*/ { function_entry, 0, 0, icache_illegal },
  /*1414*/ { function_entry, 0, 0, icache_illegal },
  /*1415*/ { function_entry, 0, 0, icache_illegal },
  /*1416*/ { function_entry, 0, 0, icache_illegal },
  /*1417*/ { function_entry, 0, 0, icache_illegal },
  /*1418*/ { function_entry, 0, 0, icache_illegal },
  /*1419*/ { function_entry, 0, 0, icache_illegal },
  /*1420*/ { function_entry, 0, 0, icache_illegal },
  /*1421*/ { function_entry, 0, 0, icache_illegal },
  /*1422*/ { function_entry, 0, 0, icache_illegal },
  /*1423*/ { function_entry, 0, 0, icache_illegal },
  /*1424*/ { function_entry, 0, 0, icache_illegal },
  /*1425*/ { function_entry, 0, 0, icache_illegal },
  /*1426*/ { function_entry, 0, 0, icache_illegal },
  /*1427*/ { function_entry, 0, 0, icache_illegal },
  /*1428*/ { function_entry, 0, 0, icache_illegal },
  /*1429*/ { function_entry, 0, 0, icache_illegal },
  /*1430*/ { function_entry, 0, 0, icache_illegal },
  /*1431*/ { function_entry, 0, 0, icache_illegal },
  /*1432*/ { function_entry, 0, 0, icache_illegal },
  /*1433*/ { function_entry, 0, 0, icache_illegal },
  /*1434*/ { function_entry, 0, 0, icache_illegal },
  /*1435*/ { function_entry, 0, 0, icache_illegal },
  /*1436*/ { function_entry, 0, 0, icache_illegal },
  /*1437*/ { function_entry, 0, 0, icache_illegal },
  /*1438*/ { function_entry, 0, 0, icache_illegal },
  /*1439*/ { function_entry, 0, 0, icache_illegal },
  /*1440*/ { function_entry, 0, 0, icache_illegal },
  /*1441*/ { function_entry, 0, 0, icache_illegal },
  /*1442*/ { function_entry, 0, 0, icache_illegal },
  /*1443*/ { function_entry, 0, 0, icache_illegal },
  /*1444*/ { function_entry, 0, 0, icache_illegal },
  /*1445*/ { function_entry, 0, 0, icache_illegal },
  /*1446*/ { function_entry, 0, 0, icache_illegal },
  /*1447*/ { function_entry, 0, 0, icache_illegal },
  /*1448*/ { function_entry, 0, 0, icache_illegal },
  /*1449*/ { function_entry, 0, 0, icache_illegal },
  /*1450*/ { function_entry, 0, 0, icache_illegal },
  /*1451*/ { function_entry, 0, 0, icache_illegal },
  /*1452*/ { function_entry, 0, 0, icache_illegal },
  /*1453*/ { function_entry, 0, 0, icache_illegal },
  /*1454*/ { function_entry, 0, 0, icache_illegal },
  /*1455*/ { function_entry, 0, 0, icache_illegal },
  /*1456*/ { function_entry, 0, 0, icache_illegal },
  /*1457*/ { function_entry, 0, 0, icache_illegal },
  /*1458*/ { function_entry, 0, 0, icache_illegal },
  /*1459*/ { function_entry, 0, 0, icache_illegal },
  /*1460*/ { function_entry, 0, 0, icache_illegal },
  /*1461*/ { function_entry, 0, 0, icache_illegal },
  /*1462*/ { function_entry, 0, 0, icache_illegal },
  /*1463*/ { function_entry, 0, 0, icache_illegal },
  /*1464*/ { function_entry, 0, 0, icache_illegal },
  /*1465*/ { function_entry, 0, 0, icache_illegal },
  /*1466*/ { function_entry, 0, 0, icache_illegal },
  /*1467*/ { function_entry, 0, 0, icache_illegal },
  /*1468*/ { function_entry, 0, 0, icache_illegal },
  /*1469*/ { function_entry, 0, 0, icache_illegal },
  /*1470*/ { function_entry, 0, 0, icache_illegal },
  /*1471*/ { function_entry, 0, 0, icache_illegal },
  /*1472*/ { function_entry, 0, 0, icache_illegal },
  /*1473*/ { function_entry, 0, 0, icache_illegal },
  /*1474*/ { function_entry, 0, 0, icache_illegal },
  /*1475*/ { function_entry, 0, 0, icache_illegal },
  /*1476*/ { function_entry, 0, 0, icache_illegal },
  /*1477*/ { function_entry, 0, 0, icache_illegal },
  /*1478*/ { function_entry, 0, 0, icache_illegal },
  /*1479*/ { function_entry, 0, 0, icache_illegal },
  /*1480*/ { function_entry, 0, 0, icache_illegal },
  /*1481*/ { function_entry, 0, 0, icache_illegal },
  /*1482*/ { function_entry, 0, 0, icache_illegal },
  /*1483*/ { function_entry, 0, 0, icache_illegal },
  /*1484*/ { function_entry, 0, 0, icache_illegal },
  /*1485*/ { function_entry, 0, 0, icache_illegal },
  /*1486*/ { function_entry, 0, 0, icache_illegal },
  /*1487*/ { function_entry, 0, 0, icache_illegal },
  /*1488*/ { function_entry, 0, 0, icache_illegal },
  /*1489*/ { function_entry, 0, 0, icache_illegal },
  /*1490*/ { function_entry, 0, 0, icache_illegal },
  /*1491*/ { function_entry, 0, 0, icache_illegal },
  /*1492*/ { function_entry, 0, 0, icache_illegal },
  /*1493*/ { function_entry, 0, 0, icache_illegal },
  /*1494*/ { function_entry, 0, 0, icache_illegal },
  /*1495*/ { function_entry, 0, 0, icache_illegal },
  /*1496*/ { function_entry, 0, 0, icache_illegal },
  /*1497*/ { function_entry, 0, 0, icache_illegal },
  /*1498*/ { function_entry, 0, 0, icache_illegal },
  /*1499*/ { function_entry, 0, 0, icache_illegal },
  /*1500*/ { function_entry, 0, 0, icache_illegal },
  /*1501*/ { function_entry, 0, 0, icache_illegal },
  /*1502*/ { function_entry, 0, 0, icache_illegal },
  /*1503*/ { function_entry, 0, 0, icache_illegal },
  /*1504*/ { function_entry, 0, 0, icache_illegal },
  /*1505*/ { function_entry, 0, 0, icache_illegal },
  /*1506*/ { function_entry, 0, 0, icache_illegal },
  /*1507*/ { function_entry, 0, 0, icache_illegal },
  /*1508*/ { function_entry, 0, 0, icache_illegal },
  /*1509*/ { function_entry, 0, 0, icache_illegal },
  /*1510*/ { function_entry, 0, 0, icache_illegal },
  /*1511*/ { function_entry, 0, 0, icache_illegal },
  /*1512*/ { function_entry, 0, 0, icache_illegal },
  /*1513*/ { function_entry, 0, 0, icache_illegal },
  /*1514*/ { function_entry, 0, 0, icache_illegal },
  /*1515*/ { function_entry, 0, 0, icache_illegal },
  /*1516*/ { function_entry, 0, 0, icache_illegal },
  /*1517*/ { function_entry, 0, 0, icache_illegal },
  /*1518*/ { function_entry, 0, 0, icache_illegal },
  /*1519*/ { function_entry, 0, 0, icache_illegal },
  /*1520*/ { function_entry, 0, 0, icache_illegal },
  /*1521*/ { function_entry, 0, 0, icache_illegal },
  /*1522*/ { function_entry, 0, 0, icache_illegal },
  /*1523*/ { function_entry, 0, 0, icache_illegal },
  /*1524*/ { function_entry, 0, 0, icache_illegal },
  /*1525*/ { function_entry, 0, 0, icache_illegal },
  /*1526*/ { function_entry, 0, 0, icache_illegal },
  /*1527*/ { function_entry, 0, 0, icache_illegal },
  /*1528*/ { function_entry, 0, 0, icache_illegal },
  /*1529*/ { function_entry, 0, 0, icache_illegal },
  /*1530*/ { function_entry, 0, 0, icache_illegal },
  /*1531*/ { function_entry, 0, 0, icache_illegal },
  /*1532*/ { function_entry, 0, 0, icache_illegal },
  /*1533*/ { function_entry, 0, 0, icache_illegal },
  /*1534*/ { function_entry, 0, 0, icache_illegal },
  /*1535*/ { function_entry, 0, 0, icache_illegal },
  /*1536*/ { function_entry, 0, 0, icache_illegal },
  /*1537*/ { function_entry, 0, 0, icache_illegal },
  /*1538*/ { function_entry, 0, 0, icache_illegal },
  /*1539*/ { function_entry, 0, 0, icache_illegal },
  /*1540*/ { function_entry, 0, 0, icache_illegal },
  /*1541*/ { function_entry, 0, 0, icache_illegal },
  /*1542*/ { function_entry, 0, 0, icache_illegal },
  /*1543*/ { function_entry, 0, 0, icache_illegal },
  /*1544*/ { function_entry, 0, 0, icache_illegal },
  /*1545*/ { function_entry, 0, 0, icache_illegal },
  /*1546*/ { function_entry, 0, 0, icache_illegal },
  /*1547*/ { function_entry, 0, 0, icache_illegal },
  /*1548*/ { function_entry, 0, 0, icache_illegal },
  /*1549*/ { function_entry, 0, 0, icache_illegal },
  /*1550*/ { function_entry, 0, 0, icache_illegal },
  /*1551*/ { function_entry, 0, 0, icache_illegal },
  /*1552*/ { function_entry, 0, 0, icache_illegal },
  /*1553*/ { function_entry, 0, 0, icache_illegal },
  /*1554*/ { function_entry, 0, 0, icache_illegal },
  /*1555*/ { function_entry, 0, 0, icache_illegal },
  /*1556*/ { function_entry, 0, 0, icache_illegal },
  /*1557*/ { function_entry, 0, 0, icache_illegal },
  /*1558*/ { function_entry, 0, 0, icache_illegal },
  /*1559*/ { function_entry, 0, 0, icache_illegal },
  /*1560*/ { function_entry, 0, 0, icache_illegal },
  /*1561*/ { function_entry, 0, 0, icache_illegal },
  /*1562*/ { function_entry, 0, 0, icache_illegal },
  /*1563*/ { function_entry, 0, 0, icache_illegal },
  /*1564*/ { function_entry, 0, 0, icache_illegal },
  /*1565*/ { function_entry, 0, 0, icache_illegal },
  /*1566*/ { function_entry, 0, 0, icache_illegal },
  /*1567*/ { function_entry, 0, 0, icache_illegal },
  /*1568*/ { function_entry, 0, 0, icache_illegal },
  /*1569*/ { function_entry, 0, 0, icache_illegal },
  /*1570*/ { function_entry, 0, 0, icache_illegal },
  /*1571*/ { function_entry, 0, 0, icache_illegal },
  /*1572*/ { function_entry, 0, 0, icache_illegal },
  /*1573*/ { function_entry, 0, 0, icache_illegal },
  /*1574*/ { function_entry, 0, 0, icache_illegal },
  /*1575*/ { function_entry, 0, 0, icache_illegal },
  /*1576*/ { function_entry, 0, 0, icache_illegal },
  /*1577*/ { function_entry, 0, 0, icache_illegal },
  /*1578*/ { function_entry, 0, 0, icache_illegal },
  /*1579*/ { function_entry, 0, 0, icache_illegal },
  /*1580*/ { function_entry, 0, 0, icache_illegal },
  /*1581*/ { function_entry, 0, 0, icache_illegal },
  /*1582*/ { function_entry, 0, 0, icache_illegal },
  /*1583*/ { function_entry, 0, 0, icache_illegal },
  /*1584*/ { function_entry, 0, 0, icache_illegal },
  /*1585*/ { function_entry, 0, 0, icache_illegal },
  /*1586*/ { function_entry, 0, 0, icache_illegal },
  /*1587*/ { function_entry, 0, 0, icache_illegal },
  /*1588*/ { function_entry, 0, 0, icache_illegal },
  /*1589*/ { function_entry, 0, 0, icache_illegal },
  /*1590*/ { function_entry, 0, 0, icache_illegal },
  /*1591*/ { function_entry, 0, 0, icache_illegal },
  /*1592*/ { function_entry, 0, 0, icache_illegal },
  /*1593*/ { function_entry, 0, 0, icache_illegal },
  /*1594*/ { function_entry, 0, 0, icache_illegal },
  /*1595*/ { function_entry, 0, 0, icache_illegal },
  /*1596*/ { function_entry, 0, 0, icache_illegal },
  /*1597*/ { function_entry, 0, 0, icache_illegal },
  /*1598*/ { function_entry, 0, 0, icache_illegal },
  /*1599*/ { function_entry, 0, 0, icache_illegal },
  /*1600*/ { function_entry, 0, 0, icache_illegal },
  /*1601*/ { function_entry, 0, 0, icache_illegal },
  /*1602*/ { function_entry, 0, 0, icache_illegal },
  /*1603*/ { function_entry, 0, 0, icache_illegal },
  /*1604*/ { function_entry, 0, 0, icache_illegal },
  /*1605*/ { function_entry, 0, 0, icache_illegal },
  /*1606*/ { function_entry, 0, 0, icache_illegal },
  /*1607*/ { function_entry, 0, 0, icache_illegal },
  /*1608*/ { function_entry, 0, 0, icache_illegal },
  /*1609*/ { function_entry, 0, 0, icache_illegal },
  /*1610*/ { function_entry, 0, 0, icache_illegal },
  /*1611*/ { function_entry, 0, 0, icache_illegal },
  /*1612*/ { function_entry, 0, 0, icache_illegal },
  /*1613*/ { function_entry, 0, 0, icache_illegal },
  /*1614*/ { function_entry, 0, 0, icache_illegal },
  /*1615*/ { function_entry, 0, 0, icache_illegal },
  /*1616*/ { function_entry, 0, 0, icache_illegal },
  /*1617*/ { function_entry, 0, 0, icache_illegal },
  /*1618*/ { function_entry, 0, 0, icache_illegal },
  /*1619*/ { function_entry, 0, 0, icache_illegal },
  /*1620*/ { function_entry, 0, 0, icache_illegal },
  /*1621*/ { function_entry, 0, 0, icache_illegal },
  /*1622*/ { function_entry, 0, 0, icache_illegal },
  /*1623*/ { function_entry, 0, 0, icache_illegal },
  /*1624*/ { function_entry, 0, 0, icache_illegal },
  /*1625*/ { function_entry, 0, 0, icache_illegal },
  /*1626*/ { function_entry, 0, 0, icache_illegal },
  /*1627*/ { function_entry, 0, 0, icache_illegal },
  /*1628*/ { function_entry, 0, 0, icache_illegal },
  /*1629*/ { function_entry, 0, 0, icache_illegal },
  /*1630*/ { function_entry, 0, 0, icache_illegal },
  /*1631*/ { function_entry, 0, 0, icache_illegal },
  /*1632*/ { function_entry, 0, 0, icache_illegal },
  /*1633*/ { function_entry, 0, 0, icache_illegal },
  /*1634*/ { function_entry, 0, 0, icache_illegal },
  /*1635*/ { function_entry, 0, 0, icache_illegal },
  /*1636*/ { function_entry, 0, 0, icache_illegal },
  /*1637*/ { function_entry, 0, 0, icache_illegal },
  /*1638*/ { function_entry, 0, 0, icache_illegal },
  /*1639*/ { function_entry, 0, 0, icache_illegal },
  /*1640*/ { function_entry, 0, 0, icache_illegal },
  /*1641*/ { function_entry, 0, 0, icache_illegal },
  /*1642*/ { function_entry, 0, 0, icache_illegal },
  /*1643*/ { function_entry, 0, 0, icache_illegal },
  /*1644*/ { function_entry, 0, 0, icache_illegal },
  /*1645*/ { function_entry, 0, 0, icache_illegal },
  /*1646*/ { function_entry, 0, 0, icache_illegal },
  /*1647*/ { function_entry, 0, 0, icache_illegal },
  /*1648*/ { function_entry, 0, 0, icache_illegal },
  /*1649*/ { function_entry, 0, 0, icache_illegal },
  /*1650*/ { function_entry, 0, 0, icache_illegal },
  /*1651*/ { function_entry, 0, 0, icache_illegal },
  /*1652*/ { function_entry, 0, 0, icache_illegal },
  /*1653*/ { function_entry, 0, 0, icache_illegal },
  /*1654*/ { function_entry, 0, 0, icache_illegal },
  /*1655*/ { function_entry, 0, 0, icache_illegal },
  /*1656*/ { function_entry, 0, 0, icache_illegal },
  /*1657*/ { function_entry, 0, 0, icache_illegal },
  /*1658*/ { function_entry, 0, 0, icache_illegal },
  /*1659*/ { function_entry, 0, 0, icache_illegal },
  /*1660*/ { function_entry, 0, 0, icache_illegal },
  /*1661*/ { function_entry, 0, 0, icache_illegal },
  /*1662*/ { function_entry, 0, 0, icache_illegal },
  /*1663*/ { function_entry, 0, 0, icache_illegal },
  /*1664*/ { function_entry, 0, 0, icache_illegal },
  /*1665*/ { function_entry, 0, 0, icache_illegal },
  /*1666*/ { function_entry, 0, 0, icache_illegal },
  /*1667*/ { function_entry, 0, 0, icache_illegal },
  /*1668*/ { function_entry, 0, 0, icache_illegal },
  /*1669*/ { function_entry, 0, 0, icache_illegal },
  /*1670*/ { function_entry, 0, 0, icache_illegal },
  /*1671*/ { function_entry, 0, 0, icache_illegal },
  /*1672*/ { function_entry, 0, 0, icache_illegal },
  /*1673*/ { function_entry, 0, 0, icache_illegal },
  /*1674*/ { function_entry, 0, 0, icache_illegal },
  /*1675*/ { function_entry, 0, 0, icache_illegal },
  /*1676*/ { function_entry, 0, 0, icache_illegal },
  /*1677*/ { function_entry, 0, 0, icache_illegal },
  /*1678*/ { function_entry, 0, 0, icache_illegal },
  /*1679*/ { function_entry, 0, 0, icache_illegal },
  /*1680*/ { function_entry, 0, 0, icache_illegal },
  /*1681*/ { function_entry, 0, 0, icache_illegal },
  /*1682*/ { function_entry, 0, 0, icache_illegal },
  /*1683*/ { function_entry, 0, 0, icache_illegal },
  /*1684*/ { function_entry, 0, 0, icache_illegal },
  /*1685*/ { function_entry, 0, 0, icache_illegal },
  /*1686*/ { function_entry, 0, 0, icache_illegal },
  /*1687*/ { function_entry, 0, 0, icache_illegal },
  /*1688*/ { function_entry, 0, 0, icache_illegal },
  /*1689*/ { function_entry, 0, 0, icache_illegal },
  /*1690*/ { function_entry, 0, 0, icache_illegal },
  /*1691*/ { function_entry, 0, 0, icache_illegal },
  /*1692*/ { function_entry, 0, 0, icache_illegal },
  /*1693*/ { function_entry, 0, 0, icache_illegal },
  /*1694*/ { function_entry, 0, 0, icache_illegal },
  /*1695*/ { function_entry, 0, 0, icache_illegal },
  /*1696*/ { function_entry, 0, 0, icache_illegal },
  /*1697*/ { function_entry, 0, 0, icache_illegal },
  /*1698*/ { function_entry, 0, 0, icache_illegal },
  /*1699*/ { function_entry, 0, 0, icache_illegal },
  /*1700*/ { function_entry, 0, 0, icache_illegal },
  /*1701*/ { function_entry, 0, 0, icache_illegal },
  /*1702*/ { function_entry, 0, 0, icache_illegal },
  /*1703*/ { function_entry, 0, 0, icache_illegal },
  /*1704*/ { function_entry, 0, 0, icache_illegal },
  /*1705*/ { function_entry, 0, 0, icache_illegal },
  /*1706*/ { function_entry, 0, 0, icache_illegal },
  /*1707*/ { function_entry, 0, 0, icache_illegal },
  /*1708*/ { function_entry, 0, 0, icache_illegal },
  /*1709*/ { function_entry, 0, 0, icache_illegal },
  /*1710*/ { function_entry, 0, 0, icache_illegal },
  /*1711*/ { function_entry, 0, 0, icache_illegal },
  /*1712*/ { function_entry, 0, 0, icache_illegal },
  /*1713*/ { function_entry, 0, 0, icache_illegal },
  /*1714*/ { function_entry, 0, 0, icache_illegal },
  /*1715*/ { function_entry, 0, 0, icache_illegal },
  /*1716*/ { function_entry, 0, 0, icache_illegal },
  /*1717*/ { function_entry, 0, 0, icache_illegal },
  /*1718*/ { function_entry, 0, 0, icache_illegal },
  /*1719*/ { function_entry, 0, 0, icache_illegal },
  /*1720*/ { function_entry, 0, 0, icache_illegal },
  /*1721*/ { function_entry, 0, 0, icache_illegal },
  /*1722*/ { function_entry, 0, 0, icache_illegal },
  /*1723*/ { function_entry, 0, 0, icache_illegal },
  /*1724*/ { function_entry, 0, 0, icache_illegal },
  /*1725*/ { function_entry, 0, 0, icache_illegal },
  /*1726*/ { function_entry, 0, 0, icache_illegal },
  /*1727*/ { function_entry, 0, 0, icache_illegal },
  /*1728*/ { function_entry, 0, 0, icache_illegal },
  /*1729*/ { function_entry, 0, 0, icache_illegal },
  /*1730*/ { function_entry, 0, 0, icache_illegal },
  /*1731*/ { function_entry, 0, 0, icache_illegal },
  /*1732*/ { function_entry, 0, 0, icache_illegal },
  /*1733*/ { function_entry, 0, 0, icache_illegal },
  /*1734*/ { function_entry, 0, 0, icache_illegal },
  /*1735*/ { function_entry, 0, 0, icache_illegal },
  /*1736*/ { function_entry, 0, 0, icache_illegal },
  /*1737*/ { function_entry, 0, 0, icache_illegal },
  /*1738*/ { function_entry, 0, 0, icache_illegal },
  /*1739*/ { function_entry, 0, 0, icache_illegal },
  /*1740*/ { function_entry, 0, 0, icache_illegal },
  /*1741*/ { function_entry, 0, 0, icache_illegal },
  /*1742*/ { function_entry, 0, 0, icache_illegal },
  /*1743*/ { function_entry, 0, 0, icache_illegal },
  /*1744*/ { function_entry, 0, 0, icache_illegal },
  /*1745*/ { function_entry, 0, 0, icache_illegal },
  /*1746*/ { function_entry, 0, 0, icache_illegal },
  /*1747*/ { function_entry, 0, 0, icache_illegal },
  /*1748*/ { function_entry, 0, 0, icache_illegal },
  /*1749*/ { function_entry, 0, 0, icache_illegal },
  /*1750*/ { function_entry, 0, 0, icache_illegal },
  /*1751*/ { function_entry, 0, 0, icache_illegal },
  /*1752*/ { function_entry, 0, 0, icache_illegal },
  /*1753*/ { function_entry, 0, 0, icache_illegal },
  /*1754*/ { function_entry, 0, 0, icache_illegal },
  /*1755*/ { function_entry, 0, 0, icache_illegal },
  /*1756*/ { function_entry, 0, 0, icache_illegal },
  /*1757*/ { function_entry, 0, 0, icache_illegal },
  /*1758*/ { function_entry, 0, 0, icache_illegal },
  /*1759*/ { function_entry, 0, 0, icache_illegal },
  /*1760*/ { function_entry, 0, 0, icache_illegal },
  /*1761*/ { function_entry, 0, 0, icache_illegal },
  /*1762*/ { function_entry, 0, 0, icache_illegal },
  /*1763*/ { function_entry, 0, 0, icache_illegal },
  /*1764*/ { function_entry, 0, 0, icache_illegal },
  /*1765*/ { function_entry, 0, 0, icache_illegal },
  /*1766*/ { function_entry, 0, 0, icache_illegal },
  /*1767*/ { function_entry, 0, 0, icache_illegal },
  /*1768*/ { function_entry, 0, 0, icache_illegal },
  /*1769*/ { function_entry, 0, 0, icache_illegal },
  /*1770*/ { function_entry, 0, 0, icache_illegal },
  /*1771*/ { function_entry, 0, 0, icache_illegal },
  /*1772*/ { function_entry, 0, 0, icache_illegal },
  /*1773*/ { function_entry, 0, 0, icache_illegal },
  /*1774*/ { function_entry, 0, 0, icache_illegal },
  /*1775*/ { function_entry, 0, 0, icache_illegal },
  /*1776*/ { function_entry, 0, 0, icache_illegal },
  /*1777*/ { function_entry, 0, 0, icache_illegal },
  /*1778*/ { function_entry, 0, 0, icache_illegal },
  /*1779*/ { function_entry, 0, 0, icache_illegal },
  /*1780*/ { function_entry, 0, 0, icache_illegal },
  /*1781*/ { function_entry, 0, 0, icache_illegal },
  /*1782*/ { function_entry, 0, 0, icache_illegal },
  /*1783*/ { function_entry, 0, 0, icache_illegal },
  /*1784*/ { function_entry, 0, 0, icache_illegal },
  /*1785*/ { function_entry, 0, 0, icache_illegal },
  /*1786*/ { function_entry, 0, 0, icache_illegal },
  /*1787*/ { function_entry, 0, 0, icache_illegal },
  /*1788*/ { function_entry, 0, 0, icache_illegal },
  /*1789*/ { function_entry, 0, 0, icache_illegal },
  /*1790*/ { function_entry, 0, 0, icache_illegal },
  /*1791*/ { function_entry, 0, 0, icache_illegal },
  /*1792*/ { function_entry, 0, 0, icache_illegal },
  /*1793*/ { function_entry, 0, 0, icache_illegal },
  /*1794*/ { function_entry, 0, 0, icache_illegal },
  /*1795*/ { function_entry, 0, 0, icache_illegal },
  /*1796*/ { function_entry, 0, 0, icache_illegal },
  /*1797*/ { function_entry, 0, 0, icache_illegal },
  /*1798*/ { function_entry, 0, 0, icache_illegal },
  /*1799*/ { function_entry, 0, 0, icache_illegal },
  /*1800*/ { function_entry, 0, 0, icache_illegal },
  /*1801*/ { function_entry, 0, 0, icache_illegal },
  /*1802*/ { function_entry, 0, 0, icache_illegal },
  /*1803*/ { function_entry, 0, 0, icache_illegal },
  /*1804*/ { function_entry, 0, 0, icache_illegal },
  /*1805*/ { function_entry, 0, 0, icache_illegal },
  /*1806*/ { function_entry, 0, 0, icache_illegal },
  /*1807*/ { function_entry, 0, 0, icache_illegal },
  /*1808*/ { function_entry, 0, 0, icache_illegal },
  /*1809*/ { function_entry, 0, 0, icache_illegal },
  /*1810*/ { function_entry, 0, 0, icache_illegal },
  /*1811*/ { function_entry, 0, 0, icache_illegal },
  /*1812*/ { function_entry, 0, 0, icache_illegal },
  /*1813*/ { function_entry, 0, 0, icache_illegal },
  /*1814*/ { function_entry, 0, 0, icache_illegal },
  /*1815*/ { function_entry, 0, 0, icache_illegal },
  /*1816*/ { function_entry, 0, 0, icache_illegal },
  /*1817*/ { function_entry, 0, 0, icache_illegal },
  /*1818*/ { function_entry, 0, 0, icache_illegal },
  /*1819*/ { function_entry, 0, 0, icache_illegal },
  /*1820*/ { function_entry, 0, 0, icache_illegal },
  /*1821*/ { function_entry, 0, 0, icache_illegal },
  /*1822*/ { function_entry, 0, 0, icache_illegal },
  /*1823*/ { function_entry, 0, 0, icache_illegal },
  /*1824*/ { function_entry, 0, 0, icache_illegal },
  /*1825*/ { function_entry, 0, 0, icache_illegal },
  /*1826*/ { function_entry, 0, 0, icache_illegal },
  /*1827*/ { function_entry, 0, 0, icache_illegal },
  /*1828*/ { function_entry, 0, 0, icache_illegal },
  /*1829*/ { function_entry, 0, 0, icache_illegal },
  /*1830*/ { function_entry, 0, 0, icache_illegal },
  /*1831*/ { function_entry, 0, 0, icache_illegal },
  /*1832*/ { function_entry, 0, 0, icache_illegal },
  /*1833*/ { function_entry, 0, 0, icache_illegal },
  /*1834*/ { function_entry, 0, 0, icache_illegal },
  /*1835*/ { function_entry, 0, 0, icache_illegal },
  /*1836*/ { function_entry, 0, 0, icache_illegal },
  /*1837*/ { function_entry, 0, 0, icache_illegal },
  /*1838*/ { function_entry, 0, 0, icache_illegal },
  /*1839*/ { function_entry, 0, 0, icache_illegal },
  /*1840*/ { function_entry, 0, 0, icache_illegal },
  /*1841*/ { function_entry, 0, 0, icache_illegal },
  /*1842*/ { function_entry, 0, 0, icache_illegal },
  /*1843*/ { function_entry, 0, 0, icache_illegal },
  /*1844*/ { function_entry, 0, 0, icache_illegal },
  /*1845*/ { function_entry, 0, 0, icache_illegal },
  /*1846*/ { function_entry, 0, 0, icache_illegal },
  /*1847*/ { function_entry, 0, 0, icache_illegal },
  /*1848*/ { function_entry, 0, 0, icache_illegal },
  /*1849*/ { function_entry, 0, 0, icache_illegal },
  /*1850*/ { function_entry, 0, 0, icache_illegal },
  /*1851*/ { function_entry, 0, 0, icache_illegal },
  /*1852*/ { function_entry, 0, 0, icache_illegal },
  /*1853*/ { function_entry, 0, 0, icache_illegal },
  /*1854*/ { function_entry, 0, 0, icache_illegal },
  /*1855*/ { function_entry, 0, 0, icache_illegal },
  /*1856*/ { function_entry, 0, 0, icache_illegal },
  /*1857*/ { function_entry, 0, 0, icache_illegal },
  /*1858*/ { function_entry, 0, 0, icache_illegal },
  /*1859*/ { function_entry, 0, 0, icache_illegal },
  /*1860*/ { function_entry, 0, 0, icache_illegal },
  /*1861*/ { function_entry, 0, 0, icache_illegal },
  /*1862*/ { function_entry, 0, 0, icache_illegal },
  /*1863*/ { function_entry, 0, 0, icache_illegal },
  /*1864*/ { function_entry, 0, 0, icache_illegal },
  /*1865*/ { function_entry, 0, 0, icache_illegal },
  /*1866*/ { function_entry, 0, 0, icache_illegal },
  /*1867*/ { function_entry, 0, 0, icache_illegal },
  /*1868*/ { function_entry, 0, 0, icache_illegal },
  /*1869*/ { function_entry, 0, 0, icache_illegal },
  /*1870*/ { function_entry, 0, 0, icache_illegal },
  /*1871*/ { function_entry, 0, 0, icache_illegal },
  /*1872*/ { function_entry, 0, 0, icache_illegal },
  /*1873*/ { function_entry, 0, 0, icache_illegal },
  /*1874*/ { function_entry, 0, 0, icache_illegal },
  /*1875*/ { function_entry, 0, 0, icache_illegal },
  /*1876*/ { function_entry, 0, 0, icache_illegal },
  /*1877*/ { function_entry, 0, 0, icache_illegal },
  /*1878*/ { function_entry, 0, 0, icache_illegal },
  /*1879*/ { function_entry, 0, 0, icache_illegal },
  /*1880*/ { function_entry, 0, 0, icache_illegal },
  /*1881*/ { function_entry, 0, 0, icache_illegal },
  /*1882*/ { function_entry, 0, 0, icache_illegal },
  /*1883*/ { function_entry, 0, 0, icache_illegal },
  /*1884*/ { function_entry, 0, 0, icache_illegal },
  /*1885*/ { function_entry, 0, 0, icache_illegal },
  /*1886*/ { function_entry, 0, 0, icache_illegal },
  /*1887*/ { function_entry, 0, 0, icache_illegal },
  /*1888*/ { function_entry, 0, 0, icache_illegal },
  /*1889*/ { function_entry, 0, 0, icache_illegal },
  /*1890*/ { function_entry, 0, 0, icache_illegal },
  /*1891*/ { function_entry, 0, 0, icache_illegal },
  /*1892*/ { function_entry, 0, 0, icache_illegal },
  /*1893*/ { function_entry, 0, 0, icache_illegal },
  /*1894*/ { function_entry, 0, 0, icache_illegal },
  /*1895*/ { function_entry, 0, 0, icache_illegal },
  /*1896*/ { function_entry, 0, 0, icache_illegal },
  /*1897*/ { function_entry, 0, 0, icache_illegal },
  /*1898*/ { function_entry, 0, 0, icache_illegal },
  /*1899*/ { function_entry, 0, 0, icache_illegal },
  /*1900*/ { function_entry, 0, 0, icache_illegal },
  /*1901*/ { function_entry, 0, 0, icache_illegal },
  /*1902*/ { function_entry, 0, 0, icache_illegal },
  /*1903*/ { function_entry, 0, 0, icache_illegal },
  /*1904*/ { function_entry, 0, 0, icache_illegal },
  /*1905*/ { function_entry, 0, 0, icache_illegal },
  /*1906*/ { function_entry, 0, 0, icache_illegal },
  /*1907*/ { function_entry, 0, 0, icache_illegal },
  /*1908*/ { function_entry, 0, 0, icache_illegal },
  /*1909*/ { function_entry, 0, 0, icache_illegal },
  /*1910*/ { function_entry, 0, 0, icache_illegal },
  /*1911*/ { function_entry, 0, 0, icache_illegal },
  /*1912*/ { function_entry, 0, 0, icache_illegal },
  /*1913*/ { function_entry, 0, 0, icache_illegal },
  /*1914*/ { function_entry, 0, 0, icache_illegal },
  /*1915*/ { function_entry, 0, 0, icache_illegal },
  /*1916*/ { function_entry, 0, 0, icache_illegal },
  /*1917*/ { function_entry, 0, 0, icache_illegal },
  /*1918*/ { function_entry, 0, 0, icache_illegal },
  /*1919*/ { function_entry, 0, 0, icache_illegal },
  /*1920*/ { function_entry, 0, 0, icache_illegal },
  /*1921*/ { function_entry, 0, 0, icache_illegal },
  /*1922*/ { function_entry, 0, 0, icache_illegal },
  /*1923*/ { function_entry, 0, 0, icache_illegal },
  /*1924*/ { function_entry, 0, 0, icache_illegal },
  /*1925*/ { function_entry, 0, 0, icache_illegal },
  /*1926*/ { function_entry, 0, 0, icache_illegal },
  /*1927*/ { function_entry, 0, 0, icache_illegal },
  /*1928*/ { function_entry, 0, 0, icache_illegal },
  /*1929*/ { function_entry, 0, 0, icache_illegal },
  /*1930*/ { function_entry, 0, 0, icache_illegal },
  /*1931*/ { function_entry, 0, 0, icache_illegal },
  /*1932*/ { function_entry, 0, 0, icache_illegal },
  /*1933*/ { function_entry, 0, 0, icache_illegal },
  /*1934*/ { function_entry, 0, 0, icache_illegal },
  /*1935*/ { function_entry, 0, 0, icache_illegal },
  /*1936*/ { function_entry, 0, 0, icache_illegal },
  /*1937*/ { function_entry, 0, 0, icache_illegal },
  /*1938*/ { function_entry, 0, 0, icache_illegal },
  /*1939*/ { function_entry, 0, 0, icache_illegal },
  /*1940*/ { function_entry, 0, 0, icache_illegal },
  /*1941*/ { function_entry, 0, 0, icache_illegal },
  /*1942*/ { function_entry, 0, 0, icache_illegal },
  /*1943*/ { function_entry, 0, 0, icache_illegal },
  /*1944*/ { function_entry, 0, 0, icache_illegal },
  /*1945*/ { function_entry, 0, 0, icache_illegal },
  /*1946*/ { function_entry, 0, 0, icache_illegal },
  /*1947*/ { function_entry, 0, 0, icache_illegal },
  /*1948*/ { function_entry, 0, 0, icache_illegal },
  /*1949*/ { function_entry, 0, 0, icache_illegal },
  /*1950*/ { function_entry, 0, 0, icache_illegal },
  /*1951*/ { function_entry, 0, 0, icache_illegal },
  /*1952*/ { function_entry, 0, 0, icache_illegal },
  /*1953*/ { function_entry, 0, 0, icache_illegal },
  /*1954*/ { function_entry, 0, 0, icache_illegal },
  /*1955*/ { function_entry, 0, 0, icache_illegal },
  /*1956*/ { function_entry, 0, 0, icache_illegal },
  /*1957*/ { function_entry, 0, 0, icache_illegal },
  /*1958*/ { function_entry, 0, 0, icache_illegal },
  /*1959*/ { function_entry, 0, 0, icache_illegal },
  /*1960*/ { function_entry, 0, 0, icache_illegal },
  /*1961*/ { function_entry, 0, 0, icache_illegal },
  /*1962*/ { function_entry, 0, 0, icache_illegal },
  /*1963*/ { function_entry, 0, 0, icache_illegal },
  /*1964*/ { function_entry, 0, 0, icache_illegal },
  /*1965*/ { function_entry, 0, 0, icache_illegal },
  /*1966*/ { function_entry, 0, 0, icache_illegal },
  /*1967*/ { function_entry, 0, 0, icache_illegal },
  /*1968*/ { function_entry, 0, 0, icache_illegal },
  /*1969*/ { function_entry, 0, 0, icache_illegal },
  /*1970*/ { function_entry, 0, 0, icache_illegal },
  /*1971*/ { function_entry, 0, 0, icache_illegal },
  /*1972*/ { function_entry, 0, 0, icache_illegal },
  /*1973*/ { function_entry, 0, 0, icache_illegal },
  /*1974*/ { function_entry, 0, 0, icache_illegal },
  /*1975*/ { function_entry, 0, 0, icache_illegal },
  /*1976*/ { function_entry, 0, 0, icache_illegal },
  /*1977*/ { function_entry, 0, 0, icache_illegal },
  /*1978*/ { function_entry, 0, 0, icache_illegal },
  /*1979*/ { function_entry, 0, 0, icache_illegal },
  /*1980*/ { function_entry, 0, 0, icache_illegal },
  /*1981*/ { function_entry, 0, 0, icache_illegal },
  /*1982*/ { function_entry, 0, 0, icache_illegal },
  /*1983*/ { function_entry, 0, 0, icache_illegal },
  /*1984*/ { function_entry, 0, 0, icache_illegal },
  /*1985*/ { function_entry, 0, 0, icache_illegal },
  /*1986*/ { function_entry, 0, 0, icache_illegal },
  /*1987*/ { function_entry, 0, 0, icache_illegal },
  /*1988*/ { function_entry, 0, 0, icache_illegal },
  /*1989*/ { function_entry, 0, 0, icache_illegal },
  /*1990*/ { function_entry, 0, 0, icache_illegal },
  /*1991*/ { function_entry, 0, 0, icache_illegal },
  /*1992*/ { function_entry, 0, 0, icache_illegal },
  /*1993*/ { function_entry, 0, 0, icache_illegal },
  /*1994*/ { function_entry, 0, 0, icache_illegal },
  /*1995*/ { function_entry, 0, 0, icache_illegal },
  /*1996*/ { function_entry, 0, 0, icache_illegal },
  /*1997*/ { function_entry, 0, 0, icache_illegal },
  /*1998*/ { function_entry, 0, 0, icache_illegal },
  /*1999*/ { function_entry, 0, 0, icache_illegal },
  /*2000*/ { function_entry, 0, 0, icache_illegal },
  /*2001*/ { function_entry, 0, 0, icache_illegal },
  /*2002*/ { function_entry, 0, 0, icache_illegal },
  /*2003*/ { function_entry, 0, 0, icache_illegal },
  /*2004*/ { function_entry, 0, 0, icache_illegal },
  /*2005*/ { function_entry, 0, 0, icache_illegal },
  /*2006*/ { function_entry, 0, 0, icache_illegal },
  /*2007*/ { function_entry, 0, 0, icache_illegal },
  /*2008*/ { function_entry, 0, 0, icache_illegal },
  /*2009*/ { function_entry, 0, 0, icache_illegal },
  /*2010*/ { function_entry, 0, 0, icache_illegal },
  /*2011*/ { function_entry, 0, 0, icache_illegal },
  /*2012*/ { function_entry, 0, 0, icache_illegal },
  /*2013*/ { function_entry, 0, 0, icache_illegal },
  /*2014*/ { function_entry, 0, 0, icache_illegal },
  /*2015*/ { function_entry, 0, 0, icache_illegal },
  /*2016*/ { function_entry, 0, 0, icache_illegal },
  /*2017*/ { function_entry, 0, 0, icache_illegal },
  /*2018*/ { function_entry, 0, 0, icache_illegal },
  /*2019*/ { function_entry, 0, 0, icache_illegal },
  /*2020*/ { function_entry, 0, 0, icache_illegal },
  /*2021*/ { function_entry, 0, 0, icache_illegal },
  /*2022*/ { function_entry, 0, 0, icache_illegal },
  /*2023*/ { function_entry, 0, 0, icache_illegal },
  /*2024*/ { function_entry, 0, 0, icache_illegal },
  /*2025*/ { function_entry, 0, 0, icache_illegal },
  /*2026*/ { function_entry, 0, 0, icache_illegal },
  /*2027*/ { function_entry, 0, 0, icache_illegal },
  /*2028*/ { function_entry, 0, 0, icache_illegal },
  /*2029*/ { function_entry, 0, 0, icache_illegal },
  /*2030*/ { function_entry, 0, 0, icache_illegal },
  /*2031*/ { function_entry, 0, 0, icache_illegal },
  /*2032*/ { function_entry, 0, 0, icache_illegal },
  /*2033*/ { function_entry, 0, 0, icache_illegal },
  /*2034*/ { function_entry, 0, 0, icache_illegal },
  /*2035*/ { function_entry, 0, 0, icache_illegal },
  /*2036*/ { function_entry, 0, 0, icache_illegal },
  /*2037*/ { function_entry, 0, 0, icache_illegal },
  /*2038*/ { function_entry, 0, 0, icache_illegal },
  /*2039*/ { function_entry, 0, 0, icache_illegal },
  /*2040*/ { function_entry, 0, 0, icache_illegal },
  /*2041*/ { function_entry, 0, 0, icache_illegal },
  /*2042*/ { function_entry, 0, 0, icache_illegal },
  /*2043*/ { function_entry, 0, 0, icache_illegal },
  /*2044*/ { function_entry, 0, 0, icache_illegal },
  /*2045*/ { function_entry, 0, 0, icache_illegal },
  /*2046*/ { function_entry, 0, 0, icache_illegal },
  /*2047*/ { function_entry, 0, 0, icache_illegal },
};

static idecode_table_entry idecode_table_31_31__20_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0 },
  /*1*/ { function_entry, 0, 0, icache_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1 },
};

static idecode_table_entry idecode_table_31_31__21_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0 },
  /*1*/ { function_entry, 0, 0, icache_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1 },
};

static idecode_table_entry idecode_table_31_31__23_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Rotate_Left_Word_then_AND_with_Mask_Rc0 },
  /*1*/ { function_entry, 0, 0, icache_Rotate_Left_Word_then_AND_with_Mask_Rc1 },
};

static idecode_table_entry idecode_table_21_31__31_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Compare },
  /*1*/ { function_entry, 0, 0, icache_illegal },
  /*2*/ { function_entry, 0, 0, icache_illegal },
  /*3*/ { function_entry, 0, 0, icache_illegal },
  /*4*/ { function_entry, 0, 0, icache_illegal },
  /*5*/ { function_entry, 0, 0, icache_illegal },
  /*6*/ { function_entry, 0, 0, icache_illegal },
  /*7*/ { function_entry, 0, 0, icache_illegal },
  /*8*/ { function_entry, 0, 0, icache_Trap_Word },
  /*9*/ { function_entry, 0, 0, icache_illegal },
  /*10*/ { function_entry, 0, 0, icache_illegal },
  /*11*/ { function_entry, 0, 0, icache_illegal },
  /*12*/ { function_entry, 0, 0, icache_illegal },
  /*13*/ { function_entry, 0, 0, icache_illegal },
  /*14*/ { function_entry, 0, 0, icache_illegal },
  /*15*/ { function_entry, 0, 0, icache_illegal },
  /*16*/ { function_entry, 0, 0, icache_Subtract_From_Carrying_OE0_Rc0 },
  /*17*/ { function_entry, 0, 0, icache_Subtract_From_Carrying_OE0_Rc1 },
  /*18*/ { function_entry, 0, 0, icache_illegal },
  /*19*/ { function_entry, 0, 0, icache_illegal },
  /*20*/ { function_entry, 0, 0, icache_Add_Carrying_OE0_Rc0 },
  /*21*/ { function_entry, 0, 0, icache_Add_Carrying_OE0_Rc1 },
  /*22*/ { function_entry, 0, 0, icache_Multiply_High_Word_Unsigned_Rc0 },
  /*23*/ { function_entry, 0, 0, icache_Multiply_High_Word_Unsigned_Rc1 },
  /*24*/ { function_entry, 0, 0, icache_illegal },
  /*25*/ { function_entry, 0, 0, icache_illegal },
  /*26*/ { function_entry, 0, 0, icache_illegal },
  /*27*/ { function_entry, 0, 0, icache_illegal },
  /*28*/ { function_entry, 0, 0, icache_illegal },
  /*29*/ { function_entry, 0, 0, icache_illegal },
  /*30*/ { function_entry, 0, 0, icache_illegal },
  /*31*/ { function_entry, 0, 0, icache_illegal },
  /*32*/ { function_entry, 0, 0, icache_illegal },
  /*33*/ { function_entry, 0, 0, icache_illegal },
  /*34*/ { function_entry, 0, 0, icache_illegal },
  /*35*/ { function_entry, 0, 0, icache_illegal },
  /*36*/ { function_entry, 0, 0, icache_illegal },
  /*37*/ { function_entry, 0, 0, icache_illegal },
  /*38*/ { function_entry, 0, 0, icache_Move_From_Condition_Register },
  /*39*/ { function_entry, 0, 0, icache_illegal },
  /*40*/ { function_entry, 0, 0, icache_Load_Word_And_Reserve_Indexed },
  /*41*/ { function_entry, 0, 0, icache_illegal },
  /*42*/ { function_entry, 0, 0, icache_illegal },
  /*43*/ { function_entry, 0, 0, icache_illegal },
  /*44*/ { function_entry, 0, 0, icache_illegal },
  /*45*/ { function_entry, 0, 0, icache_illegal },
  /*46*/ { function_entry, 0, 0, icache_Load_Word_and_Zero_Indexed },
  /*47*/ { function_entry, 0, 0, icache_illegal },
  /*48*/ { function_entry, 0, 0, icache_Shift_Left_Word_Rc0 },
  /*49*/ { function_entry, 0, 0, icache_Shift_Left_Word_Rc1 },
  /*50*/ { function_entry, 0, 0, icache_illegal },
  /*51*/ { function_entry, 0, 0, icache_illegal },
  /*52*/ { function_entry, 0, 0, icache_Count_Leading_Zeros_Word_Rc0 },
  /*53*/ { function_entry, 0, 0, icache_Count_Leading_Zeros_Word_Rc1 },
  /*54*/ { function_entry, 0, 0, icache_illegal },
  /*55*/ { function_entry, 0, 0, icache_illegal },
  /*56*/ { function_entry, 0, 0, icache_AND_Rc0 },
  /*57*/ { function_entry, 0, 0, icache_AND_Rc1 },
  /*58*/ { function_entry, 0, 0, icache_illegal },
  /*59*/ { function_entry, 0, 0, icache_illegal },
  /*60*/ { function_entry, 0, 0, icache_illegal },
  /*61*/ { function_entry, 0, 0, icache_illegal },
  /*62*/ { function_entry, 0, 0, icache_illegal },
  /*63*/ { function_entry, 0, 0, icache_illegal },
  /*64*/ { function_entry, 0, 0, icache_Compare_Logical },
  /*65*/ { function_entry, 0, 0, icache_illegal },
  /*66*/ { function_entry, 0, 0, icache_illegal },
  /*67*/ { function_entry, 0, 0, icache_illegal },
  /*68*/ { function_entry, 0, 0, icache_illegal },
  /*69*/ { function_entry, 0, 0, icache_illegal },
  /*70*/ { function_entry, 0, 0, icache_illegal },
  /*71*/ { function_entry, 0, 0, icache_illegal },
  /*72*/ { function_entry, 0, 0, icache_illegal },
  /*73*/ { function_entry, 0, 0, icache_illegal },
  /*74*/ { function_entry, 0, 0, icache_illegal },
  /*75*/ { function_entry, 0, 0, icache_illegal },
  /*76*/ { function_entry, 0, 0, icache_illegal },
  /*77*/ { function_entry, 0, 0, icache_illegal },
  /*78*/ { function_entry, 0, 0, icache_illegal },
  /*79*/ { function_entry, 0, 0, icache_illegal },
  /*80*/ { function_entry, 0, 0, icache_Subtract_From_OE0_Rc0 },
  /*81*/ { function_entry, 0, 0, icache_Subtract_From_OE0_Rc1 },
  /*82*/ { function_entry, 0, 0, icache_illegal },
  /*83*/ { function_entry, 0, 0, icache_illegal },
  /*84*/ { function_entry, 0, 0, icache_illegal },
  /*85*/ { function_entry, 0, 0, icache_illegal },
  /*86*/ { function_entry, 0, 0, icache_illegal },
  /*87*/ { function_entry, 0, 0, icache_illegal },
  /*88*/ { function_entry, 0, 0, icache_illegal },
  /*89*/ { function_entry, 0, 0, icache_illegal },
  /*90*/ { function_entry, 0, 0, icache_illegal },
  /*91*/ { function_entry, 0, 0, icache_illegal },
  /*92*/ { function_entry, 0, 0, icache_illegal },
  /*93*/ { function_entry, 0, 0, icache_illegal },
  /*94*/ { function_entry, 0, 0, icache_illegal },
  /*95*/ { function_entry, 0, 0, icache_illegal },
  /*96*/ { function_entry, 0, 0, icache_illegal },
  /*97*/ { function_entry, 0, 0, icache_illegal },
  /*98*/ { function_entry, 0, 0, icache_illegal },
  /*99*/ { function_entry, 0, 0, icache_illegal },
  /*100*/ { function_entry, 0, 0, icache_illegal },
  /*101*/ { function_entry, 0, 0, icache_illegal },
  /*102*/ { function_entry, 0, 0, icache_illegal },
  /*103*/ { function_entry, 0, 0, icache_illegal },
  /*104*/ { function_entry, 0, 0, icache_illegal },
  /*105*/ { function_entry, 0, 0, icache_illegal },
  /*106*/ { function_entry, 0, 0, icache_illegal },
  /*107*/ { function_entry, 0, 0, icache_illegal },
  /*108*/ { function_entry, 0, 0, icache_Data_Cache_Block_Store },
  /*109*/ { function_entry, 0, 0, icache_illegal },
  /*110*/ { function_entry, 0, 0, icache_Load_Word_and_Zero_with_Update_Indexed },
  /*111*/ { function_entry, 0, 0, icache_illegal },
  /*112*/ { function_entry, 0, 0, icache_illegal },
  /*113*/ { function_entry, 0, 0, icache_illegal },
  /*114*/ { function_entry, 0, 0, icache_illegal },
  /*115*/ { function_entry, 0, 0, icache_illegal },
  /*116*/ { function_entry, 0, 0, icache_illegal },
  /*117*/ { function_entry, 0, 0, icache_illegal },
  /*118*/ { function_entry, 0, 0, icache_illegal },
  /*119*/ { function_entry, 0, 0, icache_illegal },
  /*120*/ { function_entry, 0, 0, icache_AND_with_Complement_Rc0 },
  /*121*/ { function_entry, 0, 0, icache_AND_with_Complement_Rc1 },
  /*122*/ { function_entry, 0, 0, icache_illegal },
  /*123*/ { function_entry, 0, 0, icache_illegal },
  /*124*/ { function_entry, 0, 0, icache_illegal },
  /*125*/ { function_entry, 0, 0, icache_illegal },
  /*126*/ { function_entry, 0, 0, icache_illegal },
  /*127*/ { function_entry, 0, 0, icache_illegal },
  /*128*/ { function_entry, 0, 0, icache_illegal },
  /*129*/ { function_entry, 0, 0, icache_illegal },
  /*130*/ { function_entry, 0, 0, icache_illegal },
  /*131*/ { function_entry, 0, 0, icache_illegal },
  /*132*/ { function_entry, 0, 0, icache_illegal },
  /*133*/ { function_entry, 0, 0, icache_illegal },
  /*134*/ { function_entry, 0, 0, icache_illegal },
  /*135*/ { function_entry, 0, 0, icache_illegal },
  /*136*/ { function_entry, 0, 0, icache_illegal },
  /*137*/ { function_entry, 0, 0, icache_illegal },
  /*138*/ { function_entry, 0, 0, icache_illegal },
  /*139*/ { function_entry, 0, 0, icache_illegal },
  /*140*/ { function_entry, 0, 0, icache_illegal },
  /*141*/ { function_entry, 0, 0, icache_illegal },
  /*142*/ { function_entry, 0, 0, icache_illegal },
  /*143*/ { function_entry, 0, 0, icache_illegal },
  /*144*/ { function_entry, 0, 0, icache_illegal },
  /*145*/ { function_entry, 0, 0, icache_illegal },
  /*146*/ { function_entry, 0, 0, icache_illegal },
  /*147*/ { function_entry, 0, 0, icache_illegal },
  /*148*/ { function_entry, 0, 0, icache_illegal },
  /*149*/ { function_entry, 0, 0, icache_illegal },
  /*150*/ { function_entry, 0, 0, icache_Multiply_High_Word_Rc0 },
  /*151*/ { function_entry, 0, 0, icache_Multiply_High_Word_Rc1 },
  /*152*/ { function_entry, 0, 0, icache_illegal },
  /*153*/ { function_entry, 0, 0, icache_illegal },
  /*154*/ { function_entry, 0, 0, icache_illegal },
  /*155*/ { function_entry, 0, 0, icache_illegal },
  /*156*/ { function_entry, 0, 0, icache_illegal },
  /*157*/ { function_entry, 0, 0, icache_illegal },
  /*158*/ { function_entry, 0, 0, icache_illegal },
  /*159*/ { function_entry, 0, 0, icache_illegal },
  /*160*/ { function_entry, 0, 0, icache_illegal },
  /*161*/ { function_entry, 0, 0, icache_illegal },
  /*162*/ { function_entry, 0, 0, icache_illegal },
  /*163*/ { function_entry, 0, 0, icache_illegal },
  /*164*/ { function_entry, 0, 0, icache_illegal },
  /*165*/ { function_entry, 0, 0, icache_illegal },
  /*166*/ { function_entry, 0, 0, icache_Move_From_Machine_State_Register },
  /*167*/ { function_entry, 0, 0, icache_illegal },
  /*168*/ { function_entry, 0, 0, icache_illegal },
  /*169*/ { function_entry, 0, 0, icache_illegal },
  /*170*/ { function_entry, 0, 0, icache_illegal },
  /*171*/ { function_entry, 0, 0, icache_illegal },
  /*172*/ { function_entry, 0, 0, icache_Data_Cache_Block_Flush },
  /*173*/ { function_entry, 0, 0, icache_illegal },
  /*174*/ { function_entry, 0, 0, icache_Load_Byte_and_Zero_Indexed },
  /*175*/ { function_entry, 0, 0, icache_illegal },
  /*176*/ { function_entry, 0, 0, icache_illegal },
  /*177*/ { function_entry, 0, 0, icache_illegal },
  /*178*/ { function_entry, 0, 0, icache_illegal },
  /*179*/ { function_entry, 0, 0, icache_illegal },
  /*180*/ { function_entry, 0, 0, icache_illegal },
  /*181*/ { function_entry, 0, 0, icache_illegal },
  /*182*/ { function_entry, 0, 0, icache_illegal },
  /*183*/ { function_entry, 0, 0, icache_illegal },
  /*184*/ { function_entry, 0, 0, icache_illegal },
  /*185*/ { function_entry, 0, 0, icache_illegal },
  /*186*/ { function_entry, 0, 0, icache_illegal },
  /*187*/ { function_entry, 0, 0, icache_illegal },
  /*188*/ { function_entry, 0, 0, icache_illegal },
  /*189*/ { function_entry, 0, 0, icache_illegal },
  /*190*/ { function_entry, 0, 0, icache_illegal },
  /*191*/ { function_entry, 0, 0, icache_illegal },
  /*192*/ { function_entry, 0, 0, icache_illegal },
  /*193*/ { function_entry, 0, 0, icache_illegal },
  /*194*/ { function_entry, 0, 0, icache_illegal },
  /*195*/ { function_entry, 0, 0, icache_illegal },
  /*196*/ { function_entry, 0, 0, icache_illegal },
  /*197*/ { function_entry, 0, 0, icache_illegal },
  /*198*/ { function_entry, 0, 0, icache_illegal },
  /*199*/ { function_entry, 0, 0, icache_illegal },
  /*200*/ { function_entry, 0, 0, icache_illegal },
  /*201*/ { function_entry, 0, 0, icache_illegal },
  /*202*/ { function_entry, 0, 0, icache_illegal },
  /*203*/ { function_entry, 0, 0, icache_illegal },
  /*204*/ { function_entry, 0, 0, icache_illegal },
  /*205*/ { function_entry, 0, 0, icache_illegal },
  /*206*/ { function_entry, 0, 0, icache_illegal },
  /*207*/ { function_entry, 0, 0, icache_illegal },
  /*208*/ { function_entry, 0, 0, icache_Negate_OE0_Rc0 },
  /*209*/ { function_entry, 0, 0, icache_Negate_OE0_Rc1 },
  /*210*/ { function_entry, 0, 0, icache_illegal },
  /*211*/ { function_entry, 0, 0, icache_illegal },
  /*212*/ { function_entry, 0, 0, icache_illegal },
  /*213*/ { function_entry, 0, 0, icache_illegal },
  /*214*/ { function_entry, 0, 0, icache_illegal },
  /*215*/ { function_entry, 0, 0, icache_illegal },
  /*216*/ { function_entry, 0, 0, icache_illegal },
  /*217*/ { function_entry, 0, 0, icache_illegal },
  /*218*/ { function_entry, 0, 0, icache_illegal },
  /*219*/ { function_entry, 0, 0, icache_illegal },
  /*220*/ { function_entry, 0, 0, icache_illegal },
  /*221*/ { function_entry, 0, 0, icache_illegal },
  /*222*/ { function_entry, 0, 0, icache_illegal },
  /*223*/ { function_entry, 0, 0, icache_illegal },
  /*224*/ { function_entry, 0, 0, icache_illegal },
  /*225*/ { function_entry, 0, 0, icache_illegal },
  /*226*/ { function_entry, 0, 0, icache_illegal },
  /*227*/ { function_entry, 0, 0, icache_illegal },
  /*228*/ { function_entry, 0, 0, icache_illegal },
  /*229*/ { function_entry, 0, 0, icache_illegal },
  /*230*/ { function_entry, 0, 0, icache_illegal },
  /*231*/ { function_entry, 0, 0, icache_illegal },
  /*232*/ { function_entry, 0, 0, icache_illegal },
  /*233*/ { function_entry, 0, 0, icache_illegal },
  /*234*/ { function_entry, 0, 0, icache_illegal },
  /*235*/ { function_entry, 0, 0, icache_illegal },
  /*236*/ { function_entry, 0, 0, icache_illegal },
  /*237*/ { function_entry, 0, 0, icache_illegal },
  /*238*/ { function_entry, 0, 0, icache_Load_Byte_and_Zero_with_Update_Indexed },
  /*239*/ { function_entry, 0, 0, icache_illegal },
  /*240*/ { function_entry, 0, 0, icache_illegal },
  /*241*/ { function_entry, 0, 0, icache_illegal },
  /*242*/ { function_entry, 0, 0, icache_illegal },
  /*243*/ { function_entry, 0, 0, icache_illegal },
  /*244*/ { function_entry, 0, 0, icache_illegal },
  /*245*/ { function_entry, 0, 0, icache_illegal },
  /*246*/ { function_entry, 0, 0, icache_illegal },
  /*247*/ { function_entry, 0, 0, icache_illegal },
  /*248*/ { function_entry, 0, 0, icache_NOR_Rc0 },
  /*249*/ { function_entry, 0, 0, icache_NOR_Rc1 },
  /*250*/ { function_entry, 0, 0, icache_illegal },
  /*251*/ { function_entry, 0, 0, icache_illegal },
  /*252*/ { function_entry, 0, 0, icache_illegal },
  /*253*/ { function_entry, 0, 0, icache_illegal },
  /*254*/ { function_entry, 0, 0, icache_illegal },
  /*255*/ { function_entry, 0, 0, icache_illegal },
  /*256*/ { function_entry, 0, 0, icache_illegal },
  /*257*/ { function_entry, 0, 0, icache_illegal },
  /*258*/ { function_entry, 0, 0, icache_illegal },
  /*259*/ { function_entry, 0, 0, icache_illegal },
  /*260*/ { function_entry, 0, 0, icache_illegal },
  /*261*/ { function_entry, 0, 0, icache_illegal },
  /*262*/ { function_entry, 0, 0, icache_illegal },
  /*263*/ { function_entry, 0, 0, icache_illegal },
  /*264*/ { function_entry, 0, 0, icache_illegal },
  /*265*/ { function_entry, 0, 0, icache_illegal },
  /*266*/ { function_entry, 0, 0, icache_illegal },
  /*267*/ { function_entry, 0, 0, icache_illegal },
  /*268*/ { function_entry, 0, 0, icache_illegal },
  /*269*/ { function_entry, 0, 0, icache_illegal },
  /*270*/ { function_entry, 0, 0, icache_illegal },
  /*271*/ { function_entry, 0, 0, icache_illegal },
  /*272*/ { function_entry, 0, 0, icache_Subtract_From_Extended_OE0_Rc0 },
  /*273*/ { function_entry, 0, 0, icache_Subtract_From_Extended_OE0_Rc1 },
  /*274*/ { function_entry, 0, 0, icache_illegal },
  /*275*/ { function_entry, 0, 0, icache_illegal },
  /*276*/ { function_entry, 0, 0, icache_Add_Extended_OE0_Rc0 },
  /*277*/ { function_entry, 0, 0, icache_Add_Extended_OE0_Rc1 },
  /*278*/ { function_entry, 0, 0, icache_illegal },
  /*279*/ { function_entry, 0, 0, icache_illegal },
  /*280*/ { function_entry, 0, 0, icache_illegal },
  /*281*/ { function_entry, 0, 0, icache_illegal },
  /*282*/ { function_entry, 0, 0, icache_illegal },
  /*283*/ { function_entry, 0, 0, icache_illegal },
  /*284*/ { function_entry, 0, 0, icache_illegal },
  /*285*/ { function_entry, 0, 0, icache_illegal },
  /*286*/ { function_entry, 0, 0, icache_illegal },
  /*287*/ { function_entry, 0, 0, icache_illegal },
  /*288*/ { function_entry, 0, 0, icache_Move_to_Condition_Register_Fields },
  /*289*/ { function_entry, 0, 0, icache_illegal },
  /*290*/ { function_entry, 0, 0, icache_illegal },
  /*291*/ { function_entry, 0, 0, icache_illegal },
  /*292*/ { function_entry, 0, 0, icache_Move_To_Machine_State_Register },
  /*293*/ { function_entry, 0, 0, icache_illegal },
  /*294*/ { function_entry, 0, 0, icache_illegal },
  /*295*/ { function_entry, 0, 0, icache_illegal },
  /*296*/ { function_entry, 0, 0, icache_illegal },
  /*297*/ { function_entry, 0, 0, icache_illegal },
  /*298*/ { function_entry, 0, 0, icache_illegal },
  /*299*/ { function_entry, 0, 0, icache_illegal },
  /*300*/ { function_entry, 0, 0, icache_illegal },
  /*301*/ { function_entry, 0, 0, icache_Store_Word_Conditional_Indexed },
  /*302*/ { function_entry, 0, 0, icache_Store_Word_Indexed },
  /*303*/ { function_entry, 0, 0, icache_illegal },
  /*304*/ { function_entry, 0, 0, icache_illegal },
  /*305*/ { function_entry, 0, 0, icache_illegal },
  /*306*/ { function_entry, 0, 0, icache_illegal },
  /*307*/ { function_entry, 0, 0, icache_illegal },
  /*308*/ { function_entry, 0, 0, icache_illegal },
  /*309*/ { function_entry, 0, 0, icache_illegal },
  /*310*/ { function_entry, 0, 0, icache_illegal },
  /*311*/ { function_entry, 0, 0, icache_illegal },
  /*312*/ { function_entry, 0, 0, icache_illegal },
  /*313*/ { function_entry, 0, 0, icache_illegal },
  /*314*/ { function_entry, 0, 0, icache_illegal },
  /*315*/ { function_entry, 0, 0, icache_illegal },
  /*316*/ { function_entry, 0, 0, icache_illegal },
  /*317*/ { function_entry, 0, 0, icache_illegal },
  /*318*/ { function_entry, 0, 0, icache_illegal },
  /*319*/ { function_entry, 0, 0, icache_illegal },
  /*320*/ { function_entry, 0, 0, icache_illegal },
  /*321*/ { function_entry, 0, 0, icache_illegal },
  /*322*/ { function_entry, 0, 0, icache_illegal },
  /*323*/ { function_entry, 0, 0, icache_illegal },
  /*324*/ { function_entry, 0, 0, icache_illegal },
  /*325*/ { function_entry, 0, 0, icache_illegal },
  /*326*/ { function_entry, 0, 0, icache_illegal },
  /*327*/ { function_entry, 0, 0, icache_illegal },
  /*328*/ { function_entry, 0, 0, icache_illegal },
  /*329*/ { function_entry, 0, 0, icache_illegal },
  /*330*/ { function_entry, 0, 0, icache_illegal },
  /*331*/ { function_entry, 0, 0, icache_illegal },
  /*332*/ { function_entry, 0, 0, icache_illegal },
  /*333*/ { function_entry, 0, 0, icache_illegal },
  /*334*/ { function_entry, 0, 0, icache_illegal },
  /*335*/ { function_entry, 0, 0, icache_illegal },
  /*336*/ { function_entry, 0, 0, icache_illegal },
  /*337*/ { function_entry, 0, 0, icache_illegal },
  /*338*/ { function_entry, 0, 0, icache_illegal },
  /*339*/ { function_entry, 0, 0, icache_illegal },
  /*340*/ { function_entry, 0, 0, icache_illegal },
  /*341*/ { function_entry, 0, 0, icache_illegal },
  /*342*/ { function_entry, 0, 0, icache_illegal },
  /*343*/ { function_entry, 0, 0, icache_illegal },
  /*344*/ { function_entry, 0, 0, icache_illegal },
  /*345*/ { function_entry, 0, 0, icache_illegal },
  /*346*/ { function_entry, 0, 0, icache_illegal },
  /*347*/ { function_entry, 0, 0, icache_illegal },
  /*348*/ { function_entry, 0, 0, icache_illegal },
  /*349*/ { function_entry, 0, 0, icache_illegal },
  /*350*/ { function_entry, 0, 0, icache_illegal },
  /*351*/ { function_entry, 0, 0, icache_illegal },
  /*352*/ { function_entry, 0, 0, icache_illegal },
  /*353*/ { function_entry, 0, 0, icache_illegal },
  /*354*/ { function_entry, 0, 0, icache_illegal },
  /*355*/ { function_entry, 0, 0, icache_illegal },
  /*356*/ { function_entry, 0, 0, icache_illegal },
  /*357*/ { function_entry, 0, 0, icache_illegal },
  /*358*/ { function_entry, 0, 0, icache_illegal },
  /*359*/ { function_entry, 0, 0, icache_illegal },
  /*360*/ { function_entry, 0, 0, icache_illegal },
  /*361*/ { function_entry, 0, 0, icache_illegal },
  /*362*/ { function_entry, 0, 0, icache_illegal },
  /*363*/ { function_entry, 0, 0, icache_illegal },
  /*364*/ { function_entry, 0, 0, icache_illegal },
  /*365*/ { function_entry, 0, 0, icache_illegal },
  /*366*/ { function_entry, 0, 0, icache_Store_Word_with_Update_Indexed },
  /*367*/ { function_entry, 0, 0, icache_illegal },
  /*368*/ { function_entry, 0, 0, icache_illegal },
  /*369*/ { function_entry, 0, 0, icache_illegal },
  /*370*/ { function_entry, 0, 0, icache_illegal },
  /*371*/ { function_entry, 0, 0, icache_illegal },
  /*372*/ { function_entry, 0, 0, icache_illegal },
  /*373*/ { function_entry, 0, 0, icache_illegal },
  /*374*/ { function_entry, 0, 0, icache_illegal },
  /*375*/ { function_entry, 0, 0, icache_illegal },
  /*376*/ { function_entry, 0, 0, icache_illegal },
  /*377*/ { function_entry, 0, 0, icache_illegal },
  /*378*/ { function_entry, 0, 0, icache_illegal },
  /*379*/ { function_entry, 0, 0, icache_illegal },
  /*380*/ { function_entry, 0, 0, icache_illegal },
  /*381*/ { function_entry, 0, 0, icache_illegal },
  /*382*/ { function_entry, 0, 0, icache_illegal },
  /*383*/ { function_entry, 0, 0, icache_illegal },
  /*384*/ { function_entry, 0, 0, icache_illegal },
  /*385*/ { function_entry, 0, 0, icache_illegal },
  /*386*/ { function_entry, 0, 0, icache_illegal },
  /*387*/ { function_entry, 0, 0, icache_illegal },
  /*388*/ { function_entry, 0, 0, icache_illegal },
  /*389*/ { function_entry, 0, 0, icache_illegal },
  /*390*/ { function_entry, 0, 0, icache_illegal },
  /*391*/ { function_entry, 0, 0, icache_illegal },
  /*392*/ { function_entry, 0, 0, icache_illegal },
  /*393*/ { function_entry, 0, 0, icache_illegal },
  /*394*/ { function_entry, 0, 0, icache_illegal },
  /*395*/ { function_entry, 0, 0, icache_illegal },
  /*396*/ { function_entry, 0, 0, icache_illegal },
  /*397*/ { function_entry, 0, 0, icache_illegal },
  /*398*/ { function_entry, 0, 0, icache_illegal },
  /*399*/ { function_entry, 0, 0, icache_illegal },
  /*400*/ { function_entry, 0, 0, icache_Subtract_from_Zero_Extended_OE0_Rc0 },
  /*401*/ { function_entry, 0, 0, icache_Subtract_from_Zero_Extended_OE0_Rc1 },
  /*402*/ { function_entry, 0, 0, icache_illegal },
  /*403*/ { function_entry, 0, 0, icache_illegal },
  /*404*/ { function_entry, 0, 0, icache_Add_to_Zero_Extended_OE0_Rc0 },
  /*405*/ { function_entry, 0, 0, icache_Add_to_Zero_Extended_OE0_Rc1 },
  /*406*/ { function_entry, 0, 0, icache_illegal },
  /*407*/ { function_entry, 0, 0, icache_illegal },
  /*408*/ { function_entry, 0, 0, icache_illegal },
  /*409*/ { function_entry, 0, 0, icache_illegal },
  /*410*/ { function_entry, 0, 0, icache_illegal },
  /*411*/ { function_entry, 0, 0, icache_illegal },
  /*412*/ { function_entry, 0, 0, icache_illegal },
  /*413*/ { function_entry, 0, 0, icache_illegal },
  /*414*/ { function_entry, 0, 0, icache_illegal },
  /*415*/ { function_entry, 0, 0, icache_illegal },
  /*416*/ { function_entry, 0, 0, icache_illegal },
  /*417*/ { function_entry, 0, 0, icache_illegal },
  /*418*/ { function_entry, 0, 0, icache_illegal },
  /*419*/ { function_entry, 0, 0, icache_illegal },
  /*420*/ { function_entry, 0, 0, icache_Move_To_Segment_Register },
  /*421*/ { function_entry, 0, 0, icache_illegal },
  /*422*/ { function_entry, 0, 0, icache_illegal },
  /*423*/ { function_entry, 0, 0, icache_illegal },
  /*424*/ { function_entry, 0, 0, icache_illegal },
  /*425*/ { function_entry, 0, 0, icache_illegal },
  /*426*/ { function_entry, 0, 0, icache_illegal },
  /*427*/ { function_entry, 0, 0, icache_illegal },
  /*428*/ { function_entry, 0, 0, icache_illegal },
  /*429*/ { function_entry, 0, 0, icache_illegal },
  /*430*/ { function_entry, 0, 0, icache_Store_Byte_Indexed },
  /*431*/ { function_entry, 0, 0, icache_illegal },
  /*432*/ { function_entry, 0, 0, icache_illegal },
  /*433*/ { function_entry, 0, 0, icache_illegal },
  /*434*/ { function_entry, 0, 0, icache_illegal },
  /*435*/ { function_entry, 0, 0, icache_illegal },
  /*436*/ { function_entry, 0, 0, icache_illegal },
  /*437*/ { function_entry, 0, 0, icache_illegal },
  /*438*/ { function_entry, 0, 0, icache_illegal },
  /*439*/ { function_entry, 0, 0, icache_illegal },
  /*440*/ { function_entry, 0, 0, icache_illegal },
  /*441*/ { function_entry, 0, 0, icache_illegal },
  /*442*/ { function_entry, 0, 0, icache_illegal },
  /*443*/ { function_entry, 0, 0, icache_illegal },
  /*444*/ { function_entry, 0, 0, icache_illegal },
  /*445*/ { function_entry, 0, 0, icache_illegal },
  /*446*/ { function_entry, 0, 0, icache_illegal },
  /*447*/ { function_entry, 0, 0, icache_illegal },
  /*448*/ { function_entry, 0, 0, icache_illegal },
  /*449*/ { function_entry, 0, 0, icache_illegal },
  /*450*/ { function_entry, 0, 0, icache_illegal },
  /*451*/ { function_entry, 0, 0, icache_illegal },
  /*452*/ { function_entry, 0, 0, icache_illegal },
  /*453*/ { function_entry, 0, 0, icache_illegal },
  /*454*/ { function_entry, 0, 0, icache_illegal },
  /*455*/ { function_entry, 0, 0, icache_illegal },
  /*456*/ { function_entry, 0, 0, icache_illegal },
  /*457*/ { function_entry, 0, 0, icache_illegal },
  /*458*/ { function_entry, 0, 0, icache_illegal },
  /*459*/ { function_entry, 0, 0, icache_illegal },
  /*460*/ { function_entry, 0, 0, icache_illegal },
  /*461*/ { function_entry, 0, 0, icache_illegal },
  /*462*/ { function_entry, 0, 0, icache_illegal },
  /*463*/ { function_entry, 0, 0, icache_illegal },
  /*464*/ { function_entry, 0, 0, icache_Subtract_From_Minus_One_Extended_OE0_Rc0 },
  /*465*/ { function_entry, 0, 0, icache_Subtract_From_Minus_One_Extended_OE0_Rc1 },
  /*466*/ { function_entry, 0, 0, icache_illegal },
  /*467*/ { function_entry, 0, 0, icache_illegal },
  /*468*/ { function_entry, 0, 0, icache_Add_to_Minus_One_Extended_OE0_Rc0 },
  /*469*/ { function_entry, 0, 0, icache_Add_to_Minus_One_Extended_OE0_Rc1 },
  /*470*/ { function_entry, 0, 0, icache_Multiply_Low_Word_OE0_Rc0 },
  /*471*/ { function_entry, 0, 0, icache_Multiply_Low_Word_OE0_Rc1 },
  /*472*/ { function_entry, 0, 0, icache_illegal },
  /*473*/ { function_entry, 0, 0, icache_illegal },
  /*474*/ { function_entry, 0, 0, icache_illegal },
  /*475*/ { function_entry, 0, 0, icache_illegal },
  /*476*/ { function_entry, 0, 0, icache_illegal },
  /*477*/ { function_entry, 0, 0, icache_illegal },
  /*478*/ { function_entry, 0, 0, icache_illegal },
  /*479*/ { function_entry, 0, 0, icache_illegal },
  /*480*/ { function_entry, 0, 0, icache_illegal },
  /*481*/ { function_entry, 0, 0, icache_illegal },
  /*482*/ { function_entry, 0, 0, icache_illegal },
  /*483*/ { function_entry, 0, 0, icache_illegal },
  /*484*/ { function_entry, 0, 0, icache_Move_To_Segment_Register_Indirect },
  /*485*/ { function_entry, 0, 0, icache_illegal },
  /*486*/ { function_entry, 0, 0, icache_illegal },
  /*487*/ { function_entry, 0, 0, icache_illegal },
  /*488*/ { function_entry, 0, 0, icache_illegal },
  /*489*/ { function_entry, 0, 0, icache_illegal },
  /*490*/ { function_entry, 0, 0, icache_illegal },
  /*491*/ { function_entry, 0, 0, icache_illegal },
  /*492*/ { function_entry, 0, 0, icache_Data_Cache_Block_Touch_for_Store },
  /*493*/ { function_entry, 0, 0, icache_illegal },
  /*494*/ { function_entry, 0, 0, icache_Store_Byte_with_Update_Indexed },
  /*495*/ { function_entry, 0, 0, icache_illegal },
  /*496*/ { function_entry, 0, 0, icache_illegal },
  /*497*/ { function_entry, 0, 0, icache_illegal },
  /*498*/ { function_entry, 0, 0, icache_illegal },
  /*499*/ { function_entry, 0, 0, icache_illegal },
  /*500*/ { function_entry, 0, 0, icache_illegal },
  /*501*/ { function_entry, 0, 0, icache_illegal },
  /*502*/ { function_entry, 0, 0, icache_illegal },
  /*503*/ { function_entry, 0, 0, icache_illegal },
  /*504*/ { function_entry, 0, 0, icache_illegal },
  /*505*/ { function_entry, 0, 0, icache_illegal },
  /*506*/ { function_entry, 0, 0, icache_illegal },
  /*507*/ { function_entry, 0, 0, icache_illegal },
  /*508*/ { function_entry, 0, 0, icache_illegal },
  /*509*/ { function_entry, 0, 0, icache_illegal },
  /*510*/ { function_entry, 0, 0, icache_illegal },
  /*511*/ { function_entry, 0, 0, icache_illegal },
  /*512*/ { function_entry, 0, 0, icache_illegal },
  /*513*/ { function_entry, 0, 0, icache_illegal },
  /*514*/ { function_entry, 0, 0, icache_illegal },
  /*515*/ { function_entry, 0, 0, icache_illegal },
  /*516*/ { function_entry, 0, 0, icache_illegal },
  /*517*/ { function_entry, 0, 0, icache_illegal },
  /*518*/ { function_entry, 0, 0, icache_illegal },
  /*519*/ { function_entry, 0, 0, icache_illegal },
  /*520*/ { function_entry, 0, 0, icache_illegal },
  /*521*/ { function_entry, 0, 0, icache_illegal },
  /*522*/ { function_entry, 0, 0, icache_illegal },
  /*523*/ { function_entry, 0, 0, icache_illegal },
  /*524*/ { function_entry, 0, 0, icache_illegal },
  /*525*/ { function_entry, 0, 0, icache_illegal },
  /*526*/ { function_entry, 0, 0, icache_illegal },
  /*527*/ { function_entry, 0, 0, icache_illegal },
  /*528*/ { function_entry, 0, 0, icache_illegal },
  /*529*/ { function_entry, 0, 0, icache_illegal },
  /*530*/ { function_entry, 0, 0, icache_illegal },
  /*531*/ { function_entry, 0, 0, icache_illegal },
  /*532*/ { function_entry, 0, 0, icache_Add_OE0_Rc0 },
  /*533*/ { function_entry, 0, 0, icache_Add_OE0_Rc1 },
  /*534*/ { function_entry, 0, 0, icache_illegal },
  /*535*/ { function_entry, 0, 0, icache_illegal },
  /*536*/ { function_entry, 0, 0, icache_illegal },
  /*537*/ { function_entry, 0, 0, icache_illegal },
  /*538*/ { function_entry, 0, 0, icache_illegal },
  /*539*/ { function_entry, 0, 0, icache_illegal },
  /*540*/ { function_entry, 0, 0, icache_illegal },
  /*541*/ { function_entry, 0, 0, icache_illegal },
  /*542*/ { function_entry, 0, 0, icache_illegal },
  /*543*/ { function_entry, 0, 0, icache_illegal },
  /*544*/ { function_entry, 0, 0, icache_illegal },
  /*545*/ { function_entry, 0, 0, icache_illegal },
  /*546*/ { function_entry, 0, 0, icache_illegal },
  /*547*/ { function_entry, 0, 0, icache_illegal },
  /*548*/ { function_entry, 0, 0, icache_illegal },
  /*549*/ { function_entry, 0, 0, icache_illegal },
  /*550*/ { function_entry, 0, 0, icache_illegal },
  /*551*/ { function_entry, 0, 0, icache_illegal },
  /*552*/ { function_entry, 0, 0, icache_illegal },
  /*553*/ { function_entry, 0, 0, icache_illegal },
  /*554*/ { function_entry, 0, 0, icache_illegal },
  /*555*/ { function_entry, 0, 0, icache_illegal },
  /*556*/ { function_entry, 0, 0, icache_Data_Cache_Block_Touch },
  /*557*/ { function_entry, 0, 0, icache_illegal },
  /*558*/ { function_entry, 0, 0, icache_Load_Halfword_and_Zero_Indexed },
  /*559*/ { function_entry, 0, 0, icache_illegal },
  /*560*/ { function_entry, 0, 0, icache_illegal },
  /*561*/ { function_entry, 0, 0, icache_illegal },
  /*562*/ { function_entry, 0, 0, icache_illegal },
  /*563*/ { function_entry, 0, 0, icache_illegal },
  /*564*/ { function_entry, 0, 0, icache_illegal },
  /*565*/ { function_entry, 0, 0, icache_illegal },
  /*566*/ { function_entry, 0, 0, icache_illegal },
  /*567*/ { function_entry, 0, 0, icache_illegal },
  /*568*/ { function_entry, 0, 0, icache_Equivalent_Rc0 },
  /*569*/ { function_entry, 0, 0, icache_Equivalent_Rc1 },
  /*570*/ { function_entry, 0, 0, icache_illegal },
  /*571*/ { function_entry, 0, 0, icache_illegal },
  /*572*/ { function_entry, 0, 0, icache_illegal },
  /*573*/ { function_entry, 0, 0, icache_illegal },
  /*574*/ { function_entry, 0, 0, icache_illegal },
  /*575*/ { function_entry, 0, 0, icache_illegal },
  /*576*/ { function_entry, 0, 0, icache_illegal },
  /*577*/ { function_entry, 0, 0, icache_illegal },
  /*578*/ { function_entry, 0, 0, icache_illegal },
  /*579*/ { function_entry, 0, 0, icache_illegal },
  /*580*/ { function_entry, 0, 0, icache_illegal },
  /*581*/ { function_entry, 0, 0, icache_illegal },
  /*582*/ { function_entry, 0, 0, icache_illegal },
  /*583*/ { function_entry, 0, 0, icache_illegal },
  /*584*/ { function_entry, 0, 0, icache_illegal },
  /*585*/ { function_entry, 0, 0, icache_illegal },
  /*586*/ { function_entry, 0, 0, icache_illegal },
  /*587*/ { function_entry, 0, 0, icache_illegal },
  /*588*/ { function_entry, 0, 0, icache_illegal },
  /*589*/ { function_entry, 0, 0, icache_illegal },
  /*590*/ { function_entry, 0, 0, icache_illegal },
  /*591*/ { function_entry, 0, 0, icache_illegal },
  /*592*/ { function_entry, 0, 0, icache_illegal },
  /*593*/ { function_entry, 0, 0, icache_illegal },
  /*594*/ { function_entry, 0, 0, icache_illegal },
  /*595*/ { function_entry, 0, 0, icache_illegal },
  /*596*/ { function_entry, 0, 0, icache_illegal },
  /*597*/ { function_entry, 0, 0, icache_illegal },
  /*598*/ { function_entry, 0, 0, icache_illegal },
  /*599*/ { function_entry, 0, 0, icache_illegal },
  /*600*/ { function_entry, 0, 0, icache_illegal },
  /*601*/ { function_entry, 0, 0, icache_illegal },
  /*602*/ { function_entry, 0, 0, icache_illegal },
  /*603*/ { function_entry, 0, 0, icache_illegal },
  /*604*/ { function_entry, 0, 0, icache_illegal },
  /*605*/ { function_entry, 0, 0, icache_illegal },
  /*606*/ { function_entry, 0, 0, icache_illegal },
  /*607*/ { function_entry, 0, 0, icache_illegal },
  /*608*/ { function_entry, 0, 0, icache_illegal },
  /*609*/ { function_entry, 0, 0, icache_illegal },
  /*610*/ { function_entry, 0, 0, icache_illegal },
  /*611*/ { function_entry, 0, 0, icache_illegal },
  /*612*/ { function_entry, 0, 0, icache_TLB_Invalidate_Entry },
  /*613*/ { function_entry, 0, 0, icache_illegal },
  /*614*/ { function_entry, 0, 0, icache_illegal },
  /*615*/ { function_entry, 0, 0, icache_illegal },
  /*616*/ { function_entry, 0, 0, icache_illegal },
  /*617*/ { function_entry, 0, 0, icache_illegal },
  /*618*/ { function_entry, 0, 0, icache_illegal },
  /*619*/ { function_entry, 0, 0, icache_illegal },
  /*620*/ { function_entry, 0, 0, icache_illegal },
  /*621*/ { function_entry, 0, 0, icache_illegal },
  /*622*/ { function_entry, 0, 0, icache_Load_Halfword_and_Zero_with_Update_Indexed },
  /*623*/ { function_entry, 0, 0, icache_illegal },
  /*624*/ { function_entry, 0, 0, icache_illegal },
  /*625*/ { function_entry, 0, 0, icache_illegal },
  /*626*/ { function_entry, 0, 0, icache_illegal },
  /*627*/ { function_entry, 0, 0, icache_illegal },
  /*628*/ { function_entry, 0, 0, icache_illegal },
  /*629*/ { function_entry, 0, 0, icache_illegal },
  /*630*/ { function_entry, 0, 0, icache_illegal },
  /*631*/ { function_entry, 0, 0, icache_illegal },
  /*632*/ { function_entry, 0, 0, icache_XOR_Rc0 },
  /*633*/ { function_entry, 0, 0, icache_XOR_Rc1 },
  /*634*/ { function_entry, 0, 0, icache_illegal },
  /*635*/ { function_entry, 0, 0, icache_illegal },
  /*636*/ { function_entry, 0, 0, icache_illegal },
  /*637*/ { function_entry, 0, 0, icache_illegal },
  /*638*/ { function_entry, 0, 0, icache_illegal },
  /*639*/ { function_entry, 0, 0, icache_illegal },
  /*640*/ { function_entry, 0, 0, icache_illegal },
  /*641*/ { function_entry, 0, 0, icache_illegal },
  /*642*/ { function_entry, 0, 0, icache_illegal },
  /*643*/ { function_entry, 0, 0, icache_illegal },
  /*644*/ { function_entry, 0, 0, icache_illegal },
  /*645*/ { function_entry, 0, 0, icache_illegal },
  /*646*/ { function_entry, 0, 0, icache_illegal },
  /*647*/ { function_entry, 0, 0, icache_illegal },
  /*648*/ { function_entry, 0, 0, icache_illegal },
  /*649*/ { function_entry, 0, 0, icache_illegal },
  /*650*/ { function_entry, 0, 0, icache_illegal },
  /*651*/ { function_entry, 0, 0, icache_illegal },
  /*652*/ { function_entry, 0, 0, icache_illegal },
  /*653*/ { function_entry, 0, 0, icache_illegal },
  /*654*/ { function_entry, 0, 0, icache_illegal },
  /*655*/ { function_entry, 0, 0, icache_illegal },
  /*656*/ { function_entry, 0, 0, icache_illegal },
  /*657*/ { function_entry, 0, 0, icache_illegal },
  /*658*/ { function_entry, 0, 0, icache_illegal },
  /*659*/ { function_entry, 0, 0, icache_illegal },
  /*660*/ { function_entry, 0, 0, icache_illegal },
  /*661*/ { function_entry, 0, 0, icache_illegal },
  /*662*/ { function_entry, 0, 0, icache_illegal },
  /*663*/ { function_entry, 0, 0, icache_illegal },
  /*664*/ { function_entry, 0, 0, icache_illegal },
  /*665*/ { function_entry, 0, 0, icache_illegal },
  /*666*/ { function_entry, 0, 0, icache_illegal },
  /*667*/ { function_entry, 0, 0, icache_illegal },
  /*668*/ { function_entry, 0, 0, icache_illegal },
  /*669*/ { function_entry, 0, 0, icache_illegal },
  /*670*/ { function_entry, 0, 0, icache_illegal },
  /*671*/ { function_entry, 0, 0, icache_illegal },
  /*672*/ { function_entry, 0, 0, icache_illegal },
  /*673*/ { function_entry, 0, 0, icache_illegal },
  /*674*/ { function_entry, 0, 0, icache_illegal },
  /*675*/ { function_entry, 0, 0, icache_illegal },
  /*676*/ { function_entry, 0, 0, icache_illegal },
  /*677*/ { function_entry, 0, 0, icache_illegal },
  /*678*/ { boolean_entry, MASK32(11, 20), INSERTED32(256, 11, 20), idecode_table_11_20__678_21_31__31_0_5 },
  /*679*/ { function_entry, 0, 0, icache_illegal },
  /*680*/ { function_entry, 0, 0, icache_illegal },
  /*681*/ { function_entry, 0, 0, icache_illegal },
  /*682*/ { function_entry, 0, 0, icache_illegal },
  /*683*/ { function_entry, 0, 0, icache_illegal },
  /*684*/ { function_entry, 0, 0, icache_illegal },
  /*685*/ { function_entry, 0, 0, icache_illegal },
  /*686*/ { function_entry, 0, 0, icache_Load_Halfword_Algebraic_Indexed },
  /*687*/ { function_entry, 0, 0, icache_illegal },
  /*688*/ { function_entry, 0, 0, icache_illegal },
  /*689*/ { function_entry, 0, 0, icache_illegal },
  /*690*/ { function_entry, 0, 0, icache_illegal },
  /*691*/ { function_entry, 0, 0, icache_illegal },
  /*692*/ { function_entry, 0, 0, icache_illegal },
  /*693*/ { function_entry, 0, 0, icache_illegal },
  /*694*/ { function_entry, 0, 0, icache_illegal },
  /*695*/ { function_entry, 0, 0, icache_illegal },
  /*696*/ { function_entry, 0, 0, icache_illegal },
  /*697*/ { function_entry, 0, 0, icache_illegal },
  /*698*/ { function_entry, 0, 0, icache_illegal },
  /*699*/ { function_entry, 0, 0, icache_illegal },
  /*700*/ { function_entry, 0, 0, icache_illegal },
  /*701*/ { function_entry, 0, 0, icache_illegal },
  /*702*/ { function_entry, 0, 0, icache_illegal },
  /*703*/ { function_entry, 0, 0, icache_illegal },
  /*704*/ { function_entry, 0, 0, icache_illegal },
  /*705*/ { function_entry, 0, 0, icache_illegal },
  /*706*/ { function_entry, 0, 0, icache_illegal },
  /*707*/ { function_entry, 0, 0, icache_illegal },
  /*708*/ { function_entry, 0, 0, icache_illegal },
  /*709*/ { function_entry, 0, 0, icache_illegal },
  /*710*/ { function_entry, 0, 0, icache_illegal },
  /*711*/ { function_entry, 0, 0, icache_illegal },
  /*712*/ { function_entry, 0, 0, icache_illegal },
  /*713*/ { function_entry, 0, 0, icache_illegal },
  /*714*/ { function_entry, 0, 0, icache_illegal },
  /*715*/ { function_entry, 0, 0, icache_illegal },
  /*716*/ { function_entry, 0, 0, icache_illegal },
  /*717*/ { function_entry, 0, 0, icache_illegal },
  /*718*/ { function_entry, 0, 0, icache_illegal },
  /*719*/ { function_entry, 0, 0, icache_illegal },
  /*720*/ { function_entry, 0, 0, icache_illegal },
  /*721*/ { function_entry, 0, 0, icache_illegal },
  /*722*/ { function_entry, 0, 0, icache_illegal },
  /*723*/ { function_entry, 0, 0, icache_illegal },
  /*724*/ { function_entry, 0, 0, icache_illegal },
  /*725*/ { function_entry, 0, 0, icache_illegal },
  /*726*/ { function_entry, 0, 0, icache_illegal },
  /*727*/ { function_entry, 0, 0, icache_illegal },
  /*728*/ { function_entry, 0, 0, icache_illegal },
  /*729*/ { function_entry, 0, 0, icache_illegal },
  /*730*/ { function_entry, 0, 0, icache_illegal },
  /*731*/ { function_entry, 0, 0, icache_illegal },
  /*732*/ { function_entry, 0, 0, icache_illegal },
  /*733*/ { function_entry, 0, 0, icache_illegal },
  /*734*/ { function_entry, 0, 0, icache_illegal },
  /*735*/ { function_entry, 0, 0, icache_illegal },
  /*736*/ { function_entry, 0, 0, icache_illegal },
  /*737*/ { function_entry, 0, 0, icache_illegal },
  /*738*/ { function_entry, 0, 0, icache_illegal },
  /*739*/ { function_entry, 0, 0, icache_illegal },
  /*740*/ { function_entry, 0, 0, icache_TLB_Invalidate_All },
  /*741*/ { function_entry, 0, 0, icache_illegal },
  /*742*/ { function_entry, 0, 0, icache_Move_From_Time_Base },
  /*743*/ { function_entry, 0, 0, icache_illegal },
  /*744*/ { function_entry, 0, 0, icache_illegal },
  /*745*/ { function_entry, 0, 0, icache_illegal },
  /*746*/ { function_entry, 0, 0, icache_illegal },
  /*747*/ { function_entry, 0, 0, icache_illegal },
  /*748*/ { function_entry, 0, 0, icache_illegal },
  /*749*/ { function_entry, 0, 0, icache_illegal },
  /*750*/ { function_entry, 0, 0, icache_Load_Halfword_Algebraic_with_Update_Indexed },
  /*751*/ { function_entry, 0, 0, icache_illegal },
  /*752*/ { function_entry, 0, 0, icache_illegal },
  /*753*/ { function_entry, 0, 0, icache_illegal },
  /*754*/ { function_entry, 0, 0, icache_illegal },
  /*755*/ { function_entry, 0, 0, icache_illegal },
  /*756*/ { function_entry, 0, 0, icache_illegal },
  /*757*/ { function_entry, 0, 0, icache_illegal },
  /*758*/ { function_entry, 0, 0, icache_illegal },
  /*759*/ { function_entry, 0, 0, icache_illegal },
  /*760*/ { function_entry, 0, 0, icache_illegal },
  /*761*/ { function_entry, 0, 0, icache_illegal },
  /*762*/ { function_entry, 0, 0, icache_illegal },
  /*763*/ { function_entry, 0, 0, icache_illegal },
  /*764*/ { function_entry, 0, 0, icache_illegal },
  /*765*/ { function_entry, 0, 0, icache_illegal },
  /*766*/ { function_entry, 0, 0, icache_illegal },
  /*767*/ { function_entry, 0, 0, icache_illegal },
  /*768*/ { function_entry, 0, 0, icache_illegal },
  /*769*/ { function_entry, 0, 0, icache_illegal },
  /*770*/ { function_entry, 0, 0, icache_illegal },
  /*771*/ { function_entry, 0, 0, icache_illegal },
  /*772*/ { function_entry, 0, 0, icache_illegal },
  /*773*/ { function_entry, 0, 0, icache_illegal },
  /*774*/ { function_entry, 0, 0, icache_illegal },
  /*775*/ { function_entry, 0, 0, icache_illegal },
  /*776*/ { function_entry, 0, 0, icache_illegal },
  /*777*/ { function_entry, 0, 0, icache_illegal },
  /*778*/ { function_entry, 0, 0, icache_illegal },
  /*779*/ { function_entry, 0, 0, icache_illegal },
  /*780*/ { function_entry, 0, 0, icache_illegal },
  /*781*/ { function_entry, 0, 0, icache_illegal },
  /*782*/ { function_entry, 0, 0, icache_illegal },
  /*783*/ { function_entry, 0, 0, icache_illegal },
  /*784*/ { function_entry, 0, 0, icache_illegal },
  /*785*/ { function_entry, 0, 0, icache_illegal },
  /*786*/ { function_entry, 0, 0, icache_illegal },
  /*787*/ { function_entry, 0, 0, icache_illegal },
  /*788*/ { function_entry, 0, 0, icache_illegal },
  /*789*/ { function_entry, 0, 0, icache_illegal },
  /*790*/ { function_entry, 0, 0, icache_illegal },
  /*791*/ { function_entry, 0, 0, icache_illegal },
  /*792*/ { function_entry, 0, 0, icache_illegal },
  /*793*/ { function_entry, 0, 0, icache_illegal },
  /*794*/ { function_entry, 0, 0, icache_illegal },
  /*795*/ { function_entry, 0, 0, icache_illegal },
  /*796*/ { function_entry, 0, 0, icache_illegal },
  /*797*/ { function_entry, 0, 0, icache_illegal },
  /*798*/ { function_entry, 0, 0, icache_illegal },
  /*799*/ { function_entry, 0, 0, icache_illegal },
  /*800*/ { function_entry, 0, 0, icache_illegal },
  /*801*/ { function_entry, 0, 0, icache_illegal },
  /*802*/ { function_entry, 0, 0, icache_illegal },
  /*803*/ { function_entry, 0, 0, icache_illegal },
  /*804*/ { function_entry, 0, 0, icache_illegal },
  /*805*/ { function_entry, 0, 0, icache_illegal },
  /*806*/ { function_entry, 0, 0, icache_illegal },
  /*807*/ { function_entry, 0, 0, icache_illegal },
  /*808*/ { function_entry, 0, 0, icache_illegal },
  /*809*/ { function_entry, 0, 0, icache_illegal },
  /*810*/ { function_entry, 0, 0, icache_illegal },
  /*811*/ { function_entry, 0, 0, icache_illegal },
  /*812*/ { function_entry, 0, 0, icache_illegal },
  /*813*/ { function_entry, 0, 0, icache_illegal },
  /*814*/ { function_entry, 0, 0, icache_Store_Half_Word_Indexed },
  /*815*/ { function_entry, 0, 0, icache_illegal },
  /*816*/ { function_entry, 0, 0, icache_illegal },
  /*817*/ { function_entry, 0, 0, icache_illegal },
  /*818*/ { function_entry, 0, 0, icache_illegal },
  /*819*/ { function_entry, 0, 0, icache_illegal },
  /*820*/ { function_entry, 0, 0, icache_illegal },
  /*821*/ { function_entry, 0, 0, icache_illegal },
  /*822*/ { function_entry, 0, 0, icache_illegal },
  /*823*/ { function_entry, 0, 0, icache_illegal },
  /*824*/ { function_entry, 0, 0, icache_OR_with_Complement_Rc0 },
  /*825*/ { function_entry, 0, 0, icache_OR_with_Complement_Rc1 },
  /*826*/ { function_entry, 0, 0, icache_illegal },
  /*827*/ { function_entry, 0, 0, icache_illegal },
  /*828*/ { function_entry, 0, 0, icache_illegal },
  /*829*/ { function_entry, 0, 0, icache_illegal },
  /*830*/ { function_entry, 0, 0, icache_illegal },
  /*831*/ { function_entry, 0, 0, icache_illegal },
  /*832*/ { function_entry, 0, 0, icache_illegal },
  /*833*/ { function_entry, 0, 0, icache_illegal },
  /*834*/ { function_entry, 0, 0, icache_illegal },
  /*835*/ { function_entry, 0, 0, icache_illegal },
  /*836*/ { function_entry, 0, 0, icache_illegal },
  /*837*/ { function_entry, 0, 0, icache_illegal },
  /*838*/ { function_entry, 0, 0, icache_illegal },
  /*839*/ { function_entry, 0, 0, icache_illegal },
  /*840*/ { function_entry, 0, 0, icache_illegal },
  /*841*/ { function_entry, 0, 0, icache_illegal },
  /*842*/ { function_entry, 0, 0, icache_illegal },
  /*843*/ { function_entry, 0, 0, icache_illegal },
  /*844*/ { function_entry, 0, 0, icache_illegal },
  /*845*/ { function_entry, 0, 0, icache_illegal },
  /*846*/ { function_entry, 0, 0, icache_illegal },
  /*847*/ { function_entry, 0, 0, icache_illegal },
  /*848*/ { function_entry, 0, 0, icache_illegal },
  /*849*/ { function_entry, 0, 0, icache_illegal },
  /*850*/ { function_entry, 0, 0, icache_illegal },
  /*851*/ { function_entry, 0, 0, icache_illegal },
  /*852*/ { function_entry, 0, 0, icache_illegal },
  /*853*/ { function_entry, 0, 0, icache_illegal },
  /*854*/ { function_entry, 0, 0, icache_illegal },
  /*855*/ { function_entry, 0, 0, icache_illegal },
  /*856*/ { function_entry, 0, 0, icache_illegal },
  /*857*/ { function_entry, 0, 0, icache_illegal },
  /*858*/ { function_entry, 0, 0, icache_illegal },
  /*859*/ { function_entry, 0, 0, icache_illegal },
  /*860*/ { function_entry, 0, 0, icache_illegal },
  /*861*/ { function_entry, 0, 0, icache_illegal },
  /*862*/ { function_entry, 0, 0, icache_illegal },
  /*863*/ { function_entry, 0, 0, icache_illegal },
  /*864*/ { function_entry, 0, 0, icache_illegal },
  /*865*/ { function_entry, 0, 0, icache_illegal },
  /*866*/ { function_entry, 0, 0, icache_illegal },
  /*867*/ { function_entry, 0, 0, icache_illegal },
  /*868*/ { function_entry, 0, 0, icache_illegal },
  /*869*/ { function_entry, 0, 0, icache_illegal },
  /*870*/ { function_entry, 0, 0, icache_illegal },
  /*871*/ { function_entry, 0, 0, icache_illegal },
  /*872*/ { function_entry, 0, 0, icache_illegal },
  /*873*/ { function_entry, 0, 0, icache_illegal },
  /*874*/ { function_entry, 0, 0, icache_illegal },
  /*875*/ { function_entry, 0, 0, icache_illegal },
  /*876*/ { function_entry, 0, 0, icache_illegal },
  /*877*/ { function_entry, 0, 0, icache_illegal },
  /*878*/ { function_entry, 0, 0, icache_Store_Half_Word_with_Update_Indexed },
  /*879*/ { function_entry, 0, 0, icache_illegal },
  /*880*/ { function_entry, 0, 0, icache_illegal },
  /*881*/ { function_entry, 0, 0, icache_illegal },
  /*882*/ { function_entry, 0, 0, icache_illegal },
  /*883*/ { function_entry, 0, 0, icache_illegal },
  /*884*/ { function_entry, 0, 0, icache_illegal },
  /*885*/ { function_entry, 0, 0, icache_illegal },
  /*886*/ { function_entry, 0, 0, icache_illegal },
  /*887*/ { function_entry, 0, 0, icache_illegal },
  /*888*/ { function_entry, 0, 0, icache_OR_Rc0 },
  /*889*/ { function_entry, 0, 0, icache_OR_Rc1 },
  /*890*/ { function_entry, 0, 0, icache_illegal },
  /*891*/ { function_entry, 0, 0, icache_illegal },
  /*892*/ { function_entry, 0, 0, icache_illegal },
  /*893*/ { function_entry, 0, 0, icache_illegal },
  /*894*/ { function_entry, 0, 0, icache_illegal },
  /*895*/ { function_entry, 0, 0, icache_illegal },
  /*896*/ { function_entry, 0, 0, icache_illegal },
  /*897*/ { function_entry, 0, 0, icache_illegal },
  /*898*/ { function_entry, 0, 0, icache_illegal },
  /*899*/ { function_entry, 0, 0, icache_illegal },
  /*900*/ { function_entry, 0, 0, icache_illegal },
  /*901*/ { function_entry, 0, 0, icache_illegal },
  /*902*/ { function_entry, 0, 0, icache_illegal },
  /*903*/ { function_entry, 0, 0, icache_illegal },
  /*904*/ { function_entry, 0, 0, icache_illegal },
  /*905*/ { function_entry, 0, 0, icache_illegal },
  /*906*/ { function_entry, 0, 0, icache_illegal },
  /*907*/ { function_entry, 0, 0, icache_illegal },
  /*908*/ { function_entry, 0, 0, icache_illegal },
  /*909*/ { function_entry, 0, 0, icache_illegal },
  /*910*/ { function_entry, 0, 0, icache_illegal },
  /*911*/ { function_entry, 0, 0, icache_illegal },
  /*912*/ { function_entry, 0, 0, icache_illegal },
  /*913*/ { function_entry, 0, 0, icache_illegal },
  /*914*/ { function_entry, 0, 0, icache_illegal },
  /*915*/ { function_entry, 0, 0, icache_illegal },
  /*916*/ { function_entry, 0, 0, icache_illegal },
  /*917*/ { function_entry, 0, 0, icache_illegal },
  /*918*/ { function_entry, 0, 0, icache_Divide_Word_Unsigned_OE0_Rc0 },
  /*919*/ { function_entry, 0, 0, icache_Divide_Word_Unsigned_OE0_Rc1 },
  /*920*/ { function_entry, 0, 0, icache_illegal },
  /*921*/ { function_entry, 0, 0, icache_illegal },
  /*922*/ { function_entry, 0, 0, icache_illegal },
  /*923*/ { function_entry, 0, 0, icache_illegal },
  /*924*/ { function_entry, 0, 0, icache_illegal },
  /*925*/ { function_entry, 0, 0, icache_illegal },
  /*926*/ { function_entry, 0, 0, icache_illegal },
  /*927*/ { function_entry, 0, 0, icache_illegal },
  /*928*/ { function_entry, 0, 0, icache_illegal },
  /*929*/ { function_entry, 0, 0, icache_illegal },
  /*930*/ { function_entry, 0, 0, icache_illegal },
  /*931*/ { function_entry, 0, 0, icache_illegal },
  /*932*/ { function_entry, 0, 0, icache_illegal },
  /*933*/ { function_entry, 0, 0, icache_illegal },
  /*934*/ { boolean_entry, MASK32(11, 20), INSERTED32(256, 11, 20), idecode_table_11_20__934_21_31__31_0_5 },
  /*935*/ { function_entry, 0, 0, icache_illegal },
  /*936*/ { function_entry, 0, 0, icache_illegal },
  /*937*/ { function_entry, 0, 0, icache_illegal },
  /*938*/ { function_entry, 0, 0, icache_illegal },
  /*939*/ { function_entry, 0, 0, icache_illegal },
  /*940*/ { function_entry, 0, 0, icache_Data_Cache_Block_Invalidate },
  /*941*/ { function_entry, 0, 0, icache_illegal },
  /*942*/ { function_entry, 0, 0, icache_illegal },
  /*943*/ { function_entry, 0, 0, icache_illegal },
  /*944*/ { function_entry, 0, 0, icache_illegal },
  /*945*/ { function_entry, 0, 0, icache_illegal },
  /*946*/ { function_entry, 0, 0, icache_illegal },
  /*947*/ { function_entry, 0, 0, icache_illegal },
  /*948*/ { function_entry, 0, 0, icache_illegal },
  /*949*/ { function_entry, 0, 0, icache_illegal },
  /*950*/ { function_entry, 0, 0, icache_illegal },
  /*951*/ { function_entry, 0, 0, icache_illegal },
  /*952*/ { function_entry, 0, 0, icache_NAND_Rc0 },
  /*953*/ { function_entry, 0, 0, icache_NAND_Rc1 },
  /*954*/ { function_entry, 0, 0, icache_illegal },
  /*955*/ { function_entry, 0, 0, icache_illegal },
  /*956*/ { function_entry, 0, 0, icache_illegal },
  /*957*/ { function_entry, 0, 0, icache_illegal },
  /*958*/ { function_entry, 0, 0, icache_illegal },
  /*959*/ { function_entry, 0, 0, icache_illegal },
  /*960*/ { function_entry, 0, 0, icache_illegal },
  /*961*/ { function_entry, 0, 0, icache_illegal },
  /*962*/ { function_entry, 0, 0, icache_illegal },
  /*963*/ { function_entry, 0, 0, icache_illegal },
  /*964*/ { function_entry, 0, 0, icache_illegal },
  /*965*/ { function_entry, 0, 0, icache_illegal },
  /*966*/ { function_entry, 0, 0, icache_illegal },
  /*967*/ { function_entry, 0, 0, icache_illegal },
  /*968*/ { function_entry, 0, 0, icache_illegal },
  /*969*/ { function_entry, 0, 0, icache_illegal },
  /*970*/ { function_entry, 0, 0, icache_illegal },
  /*971*/ { function_entry, 0, 0, icache_illegal },
  /*972*/ { function_entry, 0, 0, icache_illegal },
  /*973*/ { function_entry, 0, 0, icache_illegal },
  /*974*/ { function_entry, 0, 0, icache_illegal },
  /*975*/ { function_entry, 0, 0, icache_illegal },
  /*976*/ { function_entry, 0, 0, icache_illegal },
  /*977*/ { function_entry, 0, 0, icache_illegal },
  /*978*/ { function_entry, 0, 0, icache_illegal },
  /*979*/ { function_entry, 0, 0, icache_illegal },
  /*980*/ { function_entry, 0, 0, icache_illegal },
  /*981*/ { function_entry, 0, 0, icache_illegal },
  /*982*/ { function_entry, 0, 0, icache_Divide_Word_OE0_Rc0 },
  /*983*/ { function_entry, 0, 0, icache_Divide_Word_OE0_Rc1 },
  /*984*/ { function_entry, 0, 0, icache_illegal },
  /*985*/ { function_entry, 0, 0, icache_illegal },
  /*986*/ { function_entry, 0, 0, icache_illegal },
  /*987*/ { function_entry, 0, 0, icache_illegal },
  /*988*/ { function_entry, 0, 0, icache_illegal },
  /*989*/ { function_entry, 0, 0, icache_illegal },
  /*990*/ { function_entry, 0, 0, icache_illegal },
  /*991*/ { function_entry, 0, 0, icache_illegal },
  /*992*/ { function_entry, 0, 0, icache_illegal },
  /*993*/ { function_entry, 0, 0, icache_illegal },
  /*994*/ { function_entry, 0, 0, icache_illegal },
  /*995*/ { function_entry, 0, 0, icache_illegal },
  /*996*/ { function_entry, 0, 0, icache_illegal },
  /*997*/ { function_entry, 0, 0, icache_illegal },
  /*998*/ { function_entry, 0, 0, icache_illegal },
  /*999*/ { function_entry, 0, 0, icache_illegal },
  /*1000*/ { function_entry, 0, 0, icache_illegal },
  /*1001*/ { function_entry, 0, 0, icache_illegal },
  /*1002*/ { function_entry, 0, 0, icache_illegal },
  /*1003*/ { function_entry, 0, 0, icache_illegal },
  /*1004*/ { function_entry, 0, 0, icache_illegal },
  /*1005*/ { function_entry, 0, 0, icache_illegal },
  /*1006*/ { function_entry, 0, 0, icache_illegal },
  /*1007*/ { function_entry, 0, 0, icache_illegal },
  /*1008*/ { function_entry, 0, 0, icache_illegal },
  /*1009*/ { function_entry, 0, 0, icache_illegal },
  /*1010*/ { function_entry, 0, 0, icache_illegal },
  /*1011*/ { function_entry, 0, 0, icache_illegal },
  /*1012*/ { function_entry, 0, 0, icache_illegal },
  /*1013*/ { function_entry, 0, 0, icache_illegal },
  /*1014*/ { function_entry, 0, 0, icache_illegal },
  /*1015*/ { function_entry, 0, 0, icache_illegal },
  /*1016*/ { function_entry, 0, 0, icache_illegal },
  /*1017*/ { function_entry, 0, 0, icache_illegal },
  /*1018*/ { function_entry, 0, 0, icache_illegal },
  /*1019*/ { function_entry, 0, 0, icache_illegal },
  /*1020*/ { function_entry, 0, 0, icache_illegal },
  /*1021*/ { function_entry, 0, 0, icache_illegal },
  /*1022*/ { function_entry, 0, 0, icache_illegal },
  /*1023*/ { function_entry, 0, 0, icache_illegal },
  /*1024*/ { function_entry, 0, 0, icache_Move_to_Condition_Register_from_XER },
  /*1025*/ { function_entry, 0, 0, icache_illegal },
  /*1026*/ { function_entry, 0, 0, icache_illegal },
  /*1027*/ { function_entry, 0, 0, icache_illegal },
  /*1028*/ { function_entry, 0, 0, icache_illegal },
  /*1029*/ { function_entry, 0, 0, icache_illegal },
  /*1030*/ { function_entry, 0, 0, icache_illegal },
  /*1031*/ { function_entry, 0, 0, icache_illegal },
  /*1032*/ { function_entry, 0, 0, icache_illegal },
  /*1033*/ { function_entry, 0, 0, icache_illegal },
  /*1034*/ { function_entry, 0, 0, icache_illegal },
  /*1035*/ { function_entry, 0, 0, icache_illegal },
  /*1036*/ { function_entry, 0, 0, icache_illegal },
  /*1037*/ { function_entry, 0, 0, icache_illegal },
  /*1038*/ { function_entry, 0, 0, icache_illegal },
  /*1039*/ { function_entry, 0, 0, icache_illegal },
  /*1040*/ { function_entry, 0, 0, icache_Subtract_From_Carrying_OE1_Rc0 },
  /*1041*/ { function_entry, 0, 0, icache_Subtract_From_Carrying_OE1_Rc1 },
  /*1042*/ { function_entry, 0, 0, icache_illegal },
  /*1043*/ { function_entry, 0, 0, icache_illegal },
  /*1044*/ { function_entry, 0, 0, icache_Add_Carrying_OE1_Rc0 },
  /*1045*/ { function_entry, 0, 0, icache_Add_Carrying_OE1_Rc1 },
  /*1046*/ { function_entry, 0, 0, icache_illegal },
  /*1047*/ { function_entry, 0, 0, icache_illegal },
  /*1048*/ { function_entry, 0, 0, icache_illegal },
  /*1049*/ { function_entry, 0, 0, icache_illegal },
  /*1050*/ { function_entry, 0, 0, icache_illegal },
  /*1051*/ { function_entry, 0, 0, icache_illegal },
  /*1052*/ { function_entry, 0, 0, icache_illegal },
  /*1053*/ { function_entry, 0, 0, icache_illegal },
  /*1054*/ { function_entry, 0, 0, icache_illegal },
  /*1055*/ { function_entry, 0, 0, icache_illegal },
  /*1056*/ { function_entry, 0, 0, icache_illegal },
  /*1057*/ { function_entry, 0, 0, icache_illegal },
  /*1058*/ { function_entry, 0, 0, icache_illegal },
  /*1059*/ { function_entry, 0, 0, icache_illegal },
  /*1060*/ { function_entry, 0, 0, icache_illegal },
  /*1061*/ { function_entry, 0, 0, icache_illegal },
  /*1062*/ { function_entry, 0, 0, icache_illegal },
  /*1063*/ { function_entry, 0, 0, icache_illegal },
  /*1064*/ { function_entry, 0, 0, icache_illegal },
  /*1065*/ { function_entry, 0, 0, icache_illegal },
  /*1066*/ { function_entry, 0, 0, icache_Load_String_Word_Indexed },
  /*1067*/ { function_entry, 0, 0, icache_illegal },
  /*1068*/ { function_entry, 0, 0, icache_Load_Word_ByteReverse_Indexed },
  /*1069*/ { function_entry, 0, 0, icache_illegal },
  /*1070*/ { function_entry, 0, 0, icache_Load_FloatingPoint_Single_Indexed },
  /*1071*/ { function_entry, 0, 0, icache_illegal },
  /*1072*/ { function_entry, 0, 0, icache_Shift_Right_Word_Rc0 },
  /*1073*/ { function_entry, 0, 0, icache_Shift_Right_Word_Rc1 },
  /*1074*/ { function_entry, 0, 0, icache_illegal },
  /*1075*/ { function_entry, 0, 0, icache_illegal },
  /*1076*/ { function_entry, 0, 0, icache_illegal },
  /*1077*/ { function_entry, 0, 0, icache_illegal },
  /*1078*/ { function_entry, 0, 0, icache_illegal },
  /*1079*/ { function_entry, 0, 0, icache_illegal },
  /*1080*/ { function_entry, 0, 0, icache_illegal },
  /*1081*/ { function_entry, 0, 0, icache_illegal },
  /*1082*/ { function_entry, 0, 0, icache_illegal },
  /*1083*/ { function_entry, 0, 0, icache_illegal },
  /*1084*/ { function_entry, 0, 0, icache_illegal },
  /*1085*/ { function_entry, 0, 0, icache_illegal },
  /*1086*/ { function_entry, 0, 0, icache_illegal },
  /*1087*/ { function_entry, 0, 0, icache_illegal },
  /*1088*/ { function_entry, 0, 0, icache_illegal },
  /*1089*/ { function_entry, 0, 0, icache_illegal },
  /*1090*/ { function_entry, 0, 0, icache_illegal },
  /*1091*/ { function_entry, 0, 0, icache_illegal },
  /*1092*/ { function_entry, 0, 0, icache_illegal },
  /*1093*/ { function_entry, 0, 0, icache_illegal },
  /*1094*/ { function_entry, 0, 0, icache_illegal },
  /*1095*/ { function_entry, 0, 0, icache_illegal },
  /*1096*/ { function_entry, 0, 0, icache_illegal },
  /*1097*/ { function_entry, 0, 0, icache_illegal },
  /*1098*/ { function_entry, 0, 0, icache_illegal },
  /*1099*/ { function_entry, 0, 0, icache_illegal },
  /*1100*/ { function_entry, 0, 0, icache_illegal },
  /*1101*/ { function_entry, 0, 0, icache_illegal },
  /*1102*/ { function_entry, 0, 0, icache_illegal },
  /*1103*/ { function_entry, 0, 0, icache_illegal },
  /*1104*/ { function_entry, 0, 0, icache_Subtract_From_OE1_Rc0 },
  /*1105*/ { function_entry, 0, 0, icache_Subtract_From_OE1_Rc1 },
  /*1106*/ { function_entry, 0, 0, icache_illegal },
  /*1107*/ { function_entry, 0, 0, icache_illegal },
  /*1108*/ { function_entry, 0, 0, icache_illegal },
  /*1109*/ { function_entry, 0, 0, icache_illegal },
  /*1110*/ { function_entry, 0, 0, icache_illegal },
  /*1111*/ { function_entry, 0, 0, icache_illegal },
  /*1112*/ { function_entry, 0, 0, icache_illegal },
  /*1113*/ { function_entry, 0, 0, icache_illegal },
  /*1114*/ { function_entry, 0, 0, icache_illegal },
  /*1115*/ { function_entry, 0, 0, icache_illegal },
  /*1116*/ { function_entry, 0, 0, icache_illegal },
  /*1117*/ { function_entry, 0, 0, icache_illegal },
  /*1118*/ { function_entry, 0, 0, icache_illegal },
  /*1119*/ { function_entry, 0, 0, icache_illegal },
  /*1120*/ { function_entry, 0, 0, icache_illegal },
  /*1121*/ { function_entry, 0, 0, icache_illegal },
  /*1122*/ { function_entry, 0, 0, icache_illegal },
  /*1123*/ { function_entry, 0, 0, icache_illegal },
  /*1124*/ { function_entry, 0, 0, icache_illegal },
  /*1125*/ { function_entry, 0, 0, icache_illegal },
  /*1126*/ { function_entry, 0, 0, icache_illegal },
  /*1127*/ { function_entry, 0, 0, icache_illegal },
  /*1128*/ { function_entry, 0, 0, icache_illegal },
  /*1129*/ { function_entry, 0, 0, icache_illegal },
  /*1130*/ { function_entry, 0, 0, icache_illegal },
  /*1131*/ { function_entry, 0, 0, icache_illegal },
  /*1132*/ { function_entry, 0, 0, icache_TLB_Synchronize },
  /*1133*/ { function_entry, 0, 0, icache_illegal },
  /*1134*/ { function_entry, 0, 0, icache_Load_FloatingPoint_Single_with_Update_Indexed },
  /*1135*/ { function_entry, 0, 0, icache_illegal },
  /*1136*/ { function_entry, 0, 0, icache_illegal },
  /*1137*/ { function_entry, 0, 0, icache_illegal },
  /*1138*/ { function_entry, 0, 0, icache_illegal },
  /*1139*/ { function_entry, 0, 0, icache_illegal },
  /*1140*/ { function_entry, 0, 0, icache_illegal },
  /*1141*/ { function_entry, 0, 0, icache_illegal },
  /*1142*/ { function_entry, 0, 0, icache_illegal },
  /*1143*/ { function_entry, 0, 0, icache_illegal },
  /*1144*/ { function_entry, 0, 0, icache_illegal },
  /*1145*/ { function_entry, 0, 0, icache_illegal },
  /*1146*/ { function_entry, 0, 0, icache_illegal },
  /*1147*/ { function_entry, 0, 0, icache_illegal },
  /*1148*/ { function_entry, 0, 0, icache_illegal },
  /*1149*/ { function_entry, 0, 0, icache_illegal },
  /*1150*/ { function_entry, 0, 0, icache_illegal },
  /*1151*/ { function_entry, 0, 0, icache_illegal },
  /*1152*/ { function_entry, 0, 0, icache_illegal },
  /*1153*/ { function_entry, 0, 0, icache_illegal },
  /*1154*/ { function_entry, 0, 0, icache_illegal },
  /*1155*/ { function_entry, 0, 0, icache_illegal },
  /*1156*/ { function_entry, 0, 0, icache_illegal },
  /*1157*/ { function_entry, 0, 0, icache_illegal },
  /*1158*/ { function_entry, 0, 0, icache_illegal },
  /*1159*/ { function_entry, 0, 0, icache_illegal },
  /*1160*/ { function_entry, 0, 0, icache_illegal },
  /*1161*/ { function_entry, 0, 0, icache_illegal },
  /*1162*/ { function_entry, 0, 0, icache_illegal },
  /*1163*/ { function_entry, 0, 0, icache_illegal },
  /*1164*/ { function_entry, 0, 0, icache_illegal },
  /*1165*/ { function_entry, 0, 0, icache_illegal },
  /*1166*/ { function_entry, 0, 0, icache_illegal },
  /*1167*/ { function_entry, 0, 0, icache_illegal },
  /*1168*/ { function_entry, 0, 0, icache_illegal },
  /*1169*/ { function_entry, 0, 0, icache_illegal },
  /*1170*/ { function_entry, 0, 0, icache_illegal },
  /*1171*/ { function_entry, 0, 0, icache_illegal },
  /*1172*/ { function_entry, 0, 0, icache_illegal },
  /*1173*/ { function_entry, 0, 0, icache_illegal },
  /*1174*/ { function_entry, 0, 0, icache_illegal },
  /*1175*/ { function_entry, 0, 0, icache_illegal },
  /*1176*/ { function_entry, 0, 0, icache_illegal },
  /*1177*/ { function_entry, 0, 0, icache_illegal },
  /*1178*/ { function_entry, 0, 0, icache_illegal },
  /*1179*/ { function_entry, 0, 0, icache_illegal },
  /*1180*/ { function_entry, 0, 0, icache_illegal },
  /*1181*/ { function_entry, 0, 0, icache_illegal },
  /*1182*/ { function_entry, 0, 0, icache_illegal },
  /*1183*/ { function_entry, 0, 0, icache_illegal },
  /*1184*/ { function_entry, 0, 0, icache_illegal },
  /*1185*/ { function_entry, 0, 0, icache_illegal },
  /*1186*/ { function_entry, 0, 0, icache_illegal },
  /*1187*/ { function_entry, 0, 0, icache_illegal },
  /*1188*/ { function_entry, 0, 0, icache_illegal },
  /*1189*/ { function_entry, 0, 0, icache_illegal },
  /*1190*/ { function_entry, 0, 0, icache_Move_From_Segment_Register },
  /*1191*/ { function_entry, 0, 0, icache_illegal },
  /*1192*/ { function_entry, 0, 0, icache_illegal },
  /*1193*/ { function_entry, 0, 0, icache_illegal },
  /*1194*/ { function_entry, 0, 0, icache_Load_String_Word_Immediate },
  /*1195*/ { function_entry, 0, 0, icache_illegal },
  /*1196*/ { function_entry, 0, 0, icache_Synchronize },
  /*1197*/ { function_entry, 0, 0, icache_illegal },
  /*1198*/ { function_entry, 0, 0, icache_Load_FloatingPoint_Double_Indexed },
  /*1199*/ { function_entry, 0, 0, icache_illegal },
  /*1200*/ { function_entry, 0, 0, icache_illegal },
  /*1201*/ { function_entry, 0, 0, icache_illegal },
  /*1202*/ { function_entry, 0, 0, icache_illegal },
  /*1203*/ { function_entry, 0, 0, icache_illegal },
  /*1204*/ { function_entry, 0, 0, icache_illegal },
  /*1205*/ { function_entry, 0, 0, icache_illegal },
  /*1206*/ { function_entry, 0, 0, icache_illegal },
  /*1207*/ { function_entry, 0, 0, icache_illegal },
  /*1208*/ { function_entry, 0, 0, icache_illegal },
  /*1209*/ { function_entry, 0, 0, icache_illegal },
  /*1210*/ { function_entry, 0, 0, icache_illegal },
  /*1211*/ { function_entry, 0, 0, icache_illegal },
  /*1212*/ { function_entry, 0, 0, icache_illegal },
  /*1213*/ { function_entry, 0, 0, icache_illegal },
  /*1214*/ { function_entry, 0, 0, icache_illegal },
  /*1215*/ { function_entry, 0, 0, icache_illegal },
  /*1216*/ { function_entry, 0, 0, icache_illegal },
  /*1217*/ { function_entry, 0, 0, icache_illegal },
  /*1218*/ { function_entry, 0, 0, icache_illegal },
  /*1219*/ { function_entry, 0, 0, icache_illegal },
  /*1220*/ { function_entry, 0, 0, icache_illegal },
  /*1221*/ { function_entry, 0, 0, icache_illegal },
  /*1222*/ { function_entry, 0, 0, icache_illegal },
  /*1223*/ { function_entry, 0, 0, icache_illegal },
  /*1224*/ { function_entry, 0, 0, icache_illegal },
  /*1225*/ { function_entry, 0, 0, icache_illegal },
  /*1226*/ { function_entry, 0, 0, icache_illegal },
  /*1227*/ { function_entry, 0, 0, icache_illegal },
  /*1228*/ { function_entry, 0, 0, icache_illegal },
  /*1229*/ { function_entry, 0, 0, icache_illegal },
  /*1230*/ { function_entry, 0, 0, icache_illegal },
  /*1231*/ { function_entry, 0, 0, icache_illegal },
  /*1232*/ { function_entry, 0, 0, icache_Negate_OE1_Rc0 },
  /*1233*/ { function_entry, 0, 0, icache_Negate_OE1_Rc1 },
  /*1234*/ { function_entry, 0, 0, icache_illegal },
  /*1235*/ { function_entry, 0, 0, icache_illegal },
  /*1236*/ { function_entry, 0, 0, icache_illegal },
  /*1237*/ { function_entry, 0, 0, icache_illegal },
  /*1238*/ { function_entry, 0, 0, icache_illegal },
  /*1239*/ { function_entry, 0, 0, icache_illegal },
  /*1240*/ { function_entry, 0, 0, icache_illegal },
  /*1241*/ { function_entry, 0, 0, icache_illegal },
  /*1242*/ { function_entry, 0, 0, icache_illegal },
  /*1243*/ { function_entry, 0, 0, icache_illegal },
  /*1244*/ { function_entry, 0, 0, icache_illegal },
  /*1245*/ { function_entry, 0, 0, icache_illegal },
  /*1246*/ { function_entry, 0, 0, icache_illegal },
  /*1247*/ { function_entry, 0, 0, icache_illegal },
  /*1248*/ { function_entry, 0, 0, icache_illegal },
  /*1249*/ { function_entry, 0, 0, icache_illegal },
  /*1250*/ { function_entry, 0, 0, icache_illegal },
  /*1251*/ { function_entry, 0, 0, icache_illegal },
  /*1252*/ { function_entry, 0, 0, icache_illegal },
  /*1253*/ { function_entry, 0, 0, icache_illegal },
  /*1254*/ { function_entry, 0, 0, icache_illegal },
  /*1255*/ { function_entry, 0, 0, icache_illegal },
  /*1256*/ { function_entry, 0, 0, icache_illegal },
  /*1257*/ { function_entry, 0, 0, icache_illegal },
  /*1258*/ { function_entry, 0, 0, icache_illegal },
  /*1259*/ { function_entry, 0, 0, icache_illegal },
  /*1260*/ { function_entry, 0, 0, icache_illegal },
  /*1261*/ { function_entry, 0, 0, icache_illegal },
  /*1262*/ { function_entry, 0, 0, icache_Load_FloatingPoint_Double_with_Update_Indexed },
  /*1263*/ { function_entry, 0, 0, icache_illegal },
  /*1264*/ { function_entry, 0, 0, icache_illegal },
  /*1265*/ { function_entry, 0, 0, icache_illegal },
  /*1266*/ { function_entry, 0, 0, icache_illegal },
  /*1267*/ { function_entry, 0, 0, icache_illegal },
  /*1268*/ { function_entry, 0, 0, icache_illegal },
  /*1269*/ { function_entry, 0, 0, icache_illegal },
  /*1270*/ { function_entry, 0, 0, icache_illegal },
  /*1271*/ { function_entry, 0, 0, icache_illegal },
  /*1272*/ { function_entry, 0, 0, icache_illegal },
  /*1273*/ { function_entry, 0, 0, icache_illegal },
  /*1274*/ { function_entry, 0, 0, icache_illegal },
  /*1275*/ { function_entry, 0, 0, icache_illegal },
  /*1276*/ { function_entry, 0, 0, icache_illegal },
  /*1277*/ { function_entry, 0, 0, icache_illegal },
  /*1278*/ { function_entry, 0, 0, icache_illegal },
  /*1279*/ { function_entry, 0, 0, icache_illegal },
  /*1280*/ { function_entry, 0, 0, icache_illegal },
  /*1281*/ { function_entry, 0, 0, icache_illegal },
  /*1282*/ { function_entry, 0, 0, icache_illegal },
  /*1283*/ { function_entry, 0, 0, icache_illegal },
  /*1284*/ { function_entry, 0, 0, icache_illegal },
  /*1285*/ { function_entry, 0, 0, icache_illegal },
  /*1286*/ { function_entry, 0, 0, icache_illegal },
  /*1287*/ { function_entry, 0, 0, icache_illegal },
  /*1288*/ { function_entry, 0, 0, icache_illegal },
  /*1289*/ { function_entry, 0, 0, icache_illegal },
  /*1290*/ { function_entry, 0, 0, icache_illegal },
  /*1291*/ { function_entry, 0, 0, icache_illegal },
  /*1292*/ { function_entry, 0, 0, icache_illegal },
  /*1293*/ { function_entry, 0, 0, icache_illegal },
  /*1294*/ { function_entry, 0, 0, icache_illegal },
  /*1295*/ { function_entry, 0, 0, icache_illegal },
  /*1296*/ { function_entry, 0, 0, icache_Subtract_From_Extended_OE1_Rc0 },
  /*1297*/ { function_entry, 0, 0, icache_Subtract_From_Extended_OE1_Rc1 },
  /*1298*/ { function_entry, 0, 0, icache_illegal },
  /*1299*/ { function_entry, 0, 0, icache_illegal },
  /*1300*/ { function_entry, 0, 0, icache_Add_Extended_OE1_Rc0 },
  /*1301*/ { function_entry, 0, 0, icache_Add_Extended_OE1_Rc1 },
  /*1302*/ { function_entry, 0, 0, icache_illegal },
  /*1303*/ { function_entry, 0, 0, icache_illegal },
  /*1304*/ { function_entry, 0, 0, icache_illegal },
  /*1305*/ { function_entry, 0, 0, icache_illegal },
  /*1306*/ { function_entry, 0, 0, icache_illegal },
  /*1307*/ { function_entry, 0, 0, icache_illegal },
  /*1308*/ { function_entry, 0, 0, icache_illegal },
  /*1309*/ { function_entry, 0, 0, icache_illegal },
  /*1310*/ { function_entry, 0, 0, icache_illegal },
  /*1311*/ { function_entry, 0, 0, icache_illegal },
  /*1312*/ { function_entry, 0, 0, icache_illegal },
  /*1313*/ { function_entry, 0, 0, icache_illegal },
  /*1314*/ { function_entry, 0, 0, icache_illegal },
  /*1315*/ { function_entry, 0, 0, icache_illegal },
  /*1316*/ { function_entry, 0, 0, icache_illegal },
  /*1317*/ { function_entry, 0, 0, icache_illegal },
  /*1318*/ { function_entry, 0, 0, icache_Move_From_Segment_Register_Indirect },
  /*1319*/ { function_entry, 0, 0, icache_illegal },
  /*1320*/ { function_entry, 0, 0, icache_illegal },
  /*1321*/ { function_entry, 0, 0, icache_illegal },
  /*1322*/ { function_entry, 0, 0, icache_Store_String_Word_Indexed },
  /*1323*/ { function_entry, 0, 0, icache_illegal },
  /*1324*/ { function_entry, 0, 0, icache_Store_Word_ByteReversed_Indexed },
  /*1325*/ { function_entry, 0, 0, icache_illegal },
  /*1326*/ { function_entry, 0, 0, icache_Store_FloatingPoint_Single_Indexed },
  /*1327*/ { function_entry, 0, 0, icache_illegal },
  /*1328*/ { function_entry, 0, 0, icache_illegal },
  /*1329*/ { function_entry, 0, 0, icache_illegal },
  /*1330*/ { function_entry, 0, 0, icache_illegal },
  /*1331*/ { function_entry, 0, 0, icache_illegal },
  /*1332*/ { function_entry, 0, 0, icache_illegal },
  /*1333*/ { function_entry, 0, 0, icache_illegal },
  /*1334*/ { function_entry, 0, 0, icache_illegal },
  /*1335*/ { function_entry, 0, 0, icache_illegal },
  /*1336*/ { function_entry, 0, 0, icache_illegal },
  /*1337*/ { function_entry, 0, 0, icache_illegal },
  /*1338*/ { function_entry, 0, 0, icache_illegal },
  /*1339*/ { function_entry, 0, 0, icache_illegal },
  /*1340*/ { function_entry, 0, 0, icache_illegal },
  /*1341*/ { function_entry, 0, 0, icache_illegal },
  /*1342*/ { function_entry, 0, 0, icache_illegal },
  /*1343*/ { function_entry, 0, 0, icache_illegal },
  /*1344*/ { function_entry, 0, 0, icache_illegal },
  /*1345*/ { function_entry, 0, 0, icache_illegal },
  /*1346*/ { function_entry, 0, 0, icache_illegal },
  /*1347*/ { function_entry, 0, 0, icache_illegal },
  /*1348*/ { function_entry, 0, 0, icache_illegal },
  /*1349*/ { function_entry, 0, 0, icache_illegal },
  /*1350*/ { function_entry, 0, 0, icache_illegal },
  /*1351*/ { function_entry, 0, 0, icache_illegal },
  /*1352*/ { function_entry, 0, 0, icache_illegal },
  /*1353*/ { function_entry, 0, 0, icache_illegal },
  /*1354*/ { function_entry, 0, 0, icache_illegal },
  /*1355*/ { function_entry, 0, 0, icache_illegal },
  /*1356*/ { function_entry, 0, 0, icache_illegal },
  /*1357*/ { function_entry, 0, 0, icache_illegal },
  /*1358*/ { function_entry, 0, 0, icache_illegal },
  /*1359*/ { function_entry, 0, 0, icache_illegal },
  /*1360*/ { function_entry, 0, 0, icache_illegal },
  /*1361*/ { function_entry, 0, 0, icache_illegal },
  /*1362*/ { function_entry, 0, 0, icache_illegal },
  /*1363*/ { function_entry, 0, 0, icache_illegal },
  /*1364*/ { function_entry, 0, 0, icache_illegal },
  /*1365*/ { function_entry, 0, 0, icache_illegal },
  /*1366*/ { function_entry, 0, 0, icache_illegal },
  /*1367*/ { function_entry, 0, 0, icache_illegal },
  /*1368*/ { function_entry, 0, 0, icache_illegal },
  /*1369*/ { function_entry, 0, 0, icache_illegal },
  /*1370*/ { function_entry, 0, 0, icache_illegal },
  /*1371*/ { function_entry, 0, 0, icache_illegal },
  /*1372*/ { function_entry, 0, 0, icache_illegal },
  /*1373*/ { function_entry, 0, 0, icache_illegal },
  /*1374*/ { function_entry, 0, 0, icache_illegal },
  /*1375*/ { function_entry, 0, 0, icache_illegal },
  /*1376*/ { function_entry, 0, 0, icache_illegal },
  /*1377*/ { function_entry, 0, 0, icache_illegal },
  /*1378*/ { function_entry, 0, 0, icache_illegal },
  /*1379*/ { function_entry, 0, 0, icache_illegal },
  /*1380*/ { function_entry, 0, 0, icache_illegal },
  /*1381*/ { function_entry, 0, 0, icache_illegal },
  /*1382*/ { function_entry, 0, 0, icache_illegal },
  /*1383*/ { function_entry, 0, 0, icache_illegal },
  /*1384*/ { function_entry, 0, 0, icache_illegal },
  /*1385*/ { function_entry, 0, 0, icache_illegal },
  /*1386*/ { function_entry, 0, 0, icache_illegal },
  /*1387*/ { function_entry, 0, 0, icache_illegal },
  /*1388*/ { function_entry, 0, 0, icache_illegal },
  /*1389*/ { function_entry, 0, 0, icache_illegal },
  /*1390*/ { function_entry, 0, 0, icache_Store_FloatingPoint_Single_with_Update_Indexed },
  /*1391*/ { function_entry, 0, 0, icache_illegal },
  /*1392*/ { function_entry, 0, 0, icache_illegal },
  /*1393*/ { function_entry, 0, 0, icache_illegal },
  /*1394*/ { function_entry, 0, 0, icache_illegal },
  /*1395*/ { function_entry, 0, 0, icache_illegal },
  /*1396*/ { function_entry, 0, 0, icache_illegal },
  /*1397*/ { function_entry, 0, 0, icache_illegal },
  /*1398*/ { function_entry, 0, 0, icache_illegal },
  /*1399*/ { function_entry, 0, 0, icache_illegal },
  /*1400*/ { function_entry, 0, 0, icache_illegal },
  /*1401*/ { function_entry, 0, 0, icache_illegal },
  /*1402*/ { function_entry, 0, 0, icache_illegal },
  /*1403*/ { function_entry, 0, 0, icache_illegal },
  /*1404*/ { function_entry, 0, 0, icache_illegal },
  /*1405*/ { function_entry, 0, 0, icache_illegal },
  /*1406*/ { function_entry, 0, 0, icache_illegal },
  /*1407*/ { function_entry, 0, 0, icache_illegal },
  /*1408*/ { function_entry, 0, 0, icache_illegal },
  /*1409*/ { function_entry, 0, 0, icache_illegal },
  /*1410*/ { function_entry, 0, 0, icache_illegal },
  /*1411*/ { function_entry, 0, 0, icache_illegal },
  /*1412*/ { function_entry, 0, 0, icache_illegal },
  /*1413*/ { function_entry, 0, 0, icache_illegal },
  /*1414*/ { function_entry, 0, 0, icache_illegal },
  /*1415*/ { function_entry, 0, 0, icache_illegal },
  /*1416*/ { function_entry, 0, 0, icache_illegal },
  /*1417*/ { function_entry, 0, 0, icache_illegal },
  /*1418*/ { function_entry, 0, 0, icache_illegal },
  /*1419*/ { function_entry, 0, 0, icache_illegal },
  /*1420*/ { function_entry, 0, 0, icache_illegal },
  /*1421*/ { function_entry, 0, 0, icache_illegal },
  /*1422*/ { function_entry, 0, 0, icache_illegal },
  /*1423*/ { function_entry, 0, 0, icache_illegal },
  /*1424*/ { function_entry, 0, 0, icache_Subtract_from_Zero_Extended_OE1_Rc0 },
  /*1425*/ { function_entry, 0, 0, icache_Subtract_from_Zero_Extended_OE1_Rc1 },
  /*1426*/ { function_entry, 0, 0, icache_illegal },
  /*1427*/ { function_entry, 0, 0, icache_illegal },
  /*1428*/ { function_entry, 0, 0, icache_Add_to_Zero_Extended_OE1_Rc0 },
  /*1429*/ { function_entry, 0, 0, icache_Add_to_Zero_Extended_OE1_Rc1 },
  /*1430*/ { function_entry, 0, 0, icache_illegal },
  /*1431*/ { function_entry, 0, 0, icache_illegal },
  /*1432*/ { function_entry, 0, 0, icache_illegal },
  /*1433*/ { function_entry, 0, 0, icache_illegal },
  /*1434*/ { function_entry, 0, 0, icache_illegal },
  /*1435*/ { function_entry, 0, 0, icache_illegal },
  /*1436*/ { function_entry, 0, 0, icache_illegal },
  /*1437*/ { function_entry, 0, 0, icache_illegal },
  /*1438*/ { function_entry, 0, 0, icache_illegal },
  /*1439*/ { function_entry, 0, 0, icache_illegal },
  /*1440*/ { function_entry, 0, 0, icache_illegal },
  /*1441*/ { function_entry, 0, 0, icache_illegal },
  /*1442*/ { function_entry, 0, 0, icache_illegal },
  /*1443*/ { function_entry, 0, 0, icache_illegal },
  /*1444*/ { function_entry, 0, 0, icache_illegal },
  /*1445*/ { function_entry, 0, 0, icache_illegal },
  /*1446*/ { function_entry, 0, 0, icache_illegal },
  /*1447*/ { function_entry, 0, 0, icache_illegal },
  /*1448*/ { function_entry, 0, 0, icache_illegal },
  /*1449*/ { function_entry, 0, 0, icache_illegal },
  /*1450*/ { function_entry, 0, 0, icache_Store_String_Word_Immedate },
  /*1451*/ { function_entry, 0, 0, icache_illegal },
  /*1452*/ { function_entry, 0, 0, icache_illegal },
  /*1453*/ { function_entry, 0, 0, icache_illegal },
  /*1454*/ { function_entry, 0, 0, icache_Store_FloatingPoint_Double_Indexed },
  /*1455*/ { function_entry, 0, 0, icache_illegal },
  /*1456*/ { function_entry, 0, 0, icache_illegal },
  /*1457*/ { function_entry, 0, 0, icache_illegal },
  /*1458*/ { function_entry, 0, 0, icache_illegal },
  /*1459*/ { function_entry, 0, 0, icache_illegal },
  /*1460*/ { function_entry, 0, 0, icache_illegal },
  /*1461*/ { function_entry, 0, 0, icache_illegal },
  /*1462*/ { function_entry, 0, 0, icache_illegal },
  /*1463*/ { function_entry, 0, 0, icache_illegal },
  /*1464*/ { function_entry, 0, 0, icache_illegal },
  /*1465*/ { function_entry, 0, 0, icache_illegal },
  /*1466*/ { function_entry, 0, 0, icache_illegal },
  /*1467*/ { function_entry, 0, 0, icache_illegal },
  /*1468*/ { function_entry, 0, 0, icache_illegal },
  /*1469*/ { function_entry, 0, 0, icache_illegal },
  /*1470*/ { function_entry, 0, 0, icache_illegal },
  /*1471*/ { function_entry, 0, 0, icache_illegal },
  /*1472*/ { function_entry, 0, 0, icache_illegal },
  /*1473*/ { function_entry, 0, 0, icache_illegal },
  /*1474*/ { function_entry, 0, 0, icache_illegal },
  /*1475*/ { function_entry, 0, 0, icache_illegal },
  /*1476*/ { function_entry, 0, 0, icache_illegal },
  /*1477*/ { function_entry, 0, 0, icache_illegal },
  /*1478*/ { function_entry, 0, 0, icache_illegal },
  /*1479*/ { function_entry, 0, 0, icache_illegal },
  /*1480*/ { function_entry, 0, 0, icache_illegal },
  /*1481*/ { function_entry, 0, 0, icache_illegal },
  /*1482*/ { function_entry, 0, 0, icache_illegal },
  /*1483*/ { function_entry, 0, 0, icache_illegal },
  /*1484*/ { function_entry, 0, 0, icache_illegal },
  /*1485*/ { function_entry, 0, 0, icache_illegal },
  /*1486*/ { function_entry, 0, 0, icache_illegal },
  /*1487*/ { function_entry, 0, 0, icache_illegal },
  /*1488*/ { function_entry, 0, 0, icache_Subtract_From_Minus_One_Extended_OE1_Rc0 },
  /*1489*/ { function_entry, 0, 0, icache_Subtract_From_Minus_One_Extended_OE1_Rc1 },
  /*1490*/ { function_entry, 0, 0, icache_illegal },
  /*1491*/ { function_entry, 0, 0, icache_illegal },
  /*1492*/ { function_entry, 0, 0, icache_Add_to_Minus_One_Extended_OE1_Rc0 },
  /*1493*/ { function_entry, 0, 0, icache_Add_to_Minus_One_Extended_OE1_Rc1 },
  /*1494*/ { function_entry, 0, 0, icache_Multiply_Low_Word_OE1_Rc0 },
  /*1495*/ { function_entry, 0, 0, icache_Multiply_Low_Word_OE1_Rc1 },
  /*1496*/ { function_entry, 0, 0, icache_illegal },
  /*1497*/ { function_entry, 0, 0, icache_illegal },
  /*1498*/ { function_entry, 0, 0, icache_illegal },
  /*1499*/ { function_entry, 0, 0, icache_illegal },
  /*1500*/ { function_entry, 0, 0, icache_illegal },
  /*1501*/ { function_entry, 0, 0, icache_illegal },
  /*1502*/ { function_entry, 0, 0, icache_illegal },
  /*1503*/ { function_entry, 0, 0, icache_illegal },
  /*1504*/ { function_entry, 0, 0, icache_illegal },
  /*1505*/ { function_entry, 0, 0, icache_illegal },
  /*1506*/ { function_entry, 0, 0, icache_illegal },
  /*1507*/ { function_entry, 0, 0, icache_illegal },
  /*1508*/ { function_entry, 0, 0, icache_illegal },
  /*1509*/ { function_entry, 0, 0, icache_illegal },
  /*1510*/ { function_entry, 0, 0, icache_illegal },
  /*1511*/ { function_entry, 0, 0, icache_illegal },
  /*1512*/ { function_entry, 0, 0, icache_illegal },
  /*1513*/ { function_entry, 0, 0, icache_illegal },
  /*1514*/ { function_entry, 0, 0, icache_illegal },
  /*1515*/ { function_entry, 0, 0, icache_illegal },
  /*1516*/ { function_entry, 0, 0, icache_illegal },
  /*1517*/ { function_entry, 0, 0, icache_illegal },
  /*1518*/ { function_entry, 0, 0, icache_Store_FloatingPoint_Double_with_Update_Indexed },
  /*1519*/ { function_entry, 0, 0, icache_illegal },
  /*1520*/ { function_entry, 0, 0, icache_illegal },
  /*1521*/ { function_entry, 0, 0, icache_illegal },
  /*1522*/ { function_entry, 0, 0, icache_illegal },
  /*1523*/ { function_entry, 0, 0, icache_illegal },
  /*1524*/ { function_entry, 0, 0, icache_illegal },
  /*1525*/ { function_entry, 0, 0, icache_illegal },
  /*1526*/ { function_entry, 0, 0, icache_illegal },
  /*1527*/ { function_entry, 0, 0, icache_illegal },
  /*1528*/ { function_entry, 0, 0, icache_illegal },
  /*1529*/ { function_entry, 0, 0, icache_illegal },
  /*1530*/ { function_entry, 0, 0, icache_illegal },
  /*1531*/ { function_entry, 0, 0, icache_illegal },
  /*1532*/ { function_entry, 0, 0, icache_illegal },
  /*1533*/ { function_entry, 0, 0, icache_illegal },
  /*1534*/ { function_entry, 0, 0, icache_illegal },
  /*1535*/ { function_entry, 0, 0, icache_illegal },
  /*1536*/ { function_entry, 0, 0, icache_illegal },
  /*1537*/ { function_entry, 0, 0, icache_illegal },
  /*1538*/ { function_entry, 0, 0, icache_illegal },
  /*1539*/ { function_entry, 0, 0, icache_illegal },
  /*1540*/ { function_entry, 0, 0, icache_illegal },
  /*1541*/ { function_entry, 0, 0, icache_illegal },
  /*1542*/ { function_entry, 0, 0, icache_illegal },
  /*1543*/ { function_entry, 0, 0, icache_illegal },
  /*1544*/ { function_entry, 0, 0, icache_illegal },
  /*1545*/ { function_entry, 0, 0, icache_illegal },
  /*1546*/ { function_entry, 0, 0, icache_illegal },
  /*1547*/ { function_entry, 0, 0, icache_illegal },
  /*1548*/ { function_entry, 0, 0, icache_illegal },
  /*1549*/ { function_entry, 0, 0, icache_illegal },
  /*1550*/ { function_entry, 0, 0, icache_illegal },
  /*1551*/ { function_entry, 0, 0, icache_illegal },
  /*1552*/ { function_entry, 0, 0, icache_illegal },
  /*1553*/ { function_entry, 0, 0, icache_illegal },
  /*1554*/ { function_entry, 0, 0, icache_illegal },
  /*1555*/ { function_entry, 0, 0, icache_illegal },
  /*1556*/ { function_entry, 0, 0, icache_Add_OE1_Rc0 },
  /*1557*/ { function_entry, 0, 0, icache_Add_OE1_Rc1 },
  /*1558*/ { function_entry, 0, 0, icache_illegal },
  /*1559*/ { function_entry, 0, 0, icache_illegal },
  /*1560*/ { function_entry, 0, 0, icache_illegal },
  /*1561*/ { function_entry, 0, 0, icache_illegal },
  /*1562*/ { function_entry, 0, 0, icache_illegal },
  /*1563*/ { function_entry, 0, 0, icache_illegal },
  /*1564*/ { function_entry, 0, 0, icache_illegal },
  /*1565*/ { function_entry, 0, 0, icache_illegal },
  /*1566*/ { function_entry, 0, 0, icache_illegal },
  /*1567*/ { function_entry, 0, 0, icache_illegal },
  /*1568*/ { function_entry, 0, 0, icache_illegal },
  /*1569*/ { function_entry, 0, 0, icache_illegal },
  /*1570*/ { function_entry, 0, 0, icache_illegal },
  /*1571*/ { function_entry, 0, 0, icache_illegal },
  /*1572*/ { function_entry, 0, 0, icache_illegal },
  /*1573*/ { function_entry, 0, 0, icache_illegal },
  /*1574*/ { function_entry, 0, 0, icache_illegal },
  /*1575*/ { function_entry, 0, 0, icache_illegal },
  /*1576*/ { function_entry, 0, 0, icache_illegal },
  /*1577*/ { function_entry, 0, 0, icache_illegal },
  /*1578*/ { function_entry, 0, 0, icache_illegal },
  /*1579*/ { function_entry, 0, 0, icache_illegal },
  /*1580*/ { function_entry, 0, 0, icache_Load_Halfword_ByteReverse_Indexed },
  /*1581*/ { function_entry, 0, 0, icache_illegal },
  /*1582*/ { function_entry, 0, 0, icache_illegal },
  /*1583*/ { function_entry, 0, 0, icache_illegal },
  /*1584*/ { function_entry, 0, 0, icache_Shift_Right_Algebraic_Word_Rc0 },
  /*1585*/ { function_entry, 0, 0, icache_Shift_Right_Algebraic_Word_Rc1 },
  /*1586*/ { function_entry, 0, 0, icache_illegal },
  /*1587*/ { function_entry, 0, 0, icache_illegal },
  /*1588*/ { function_entry, 0, 0, icache_illegal },
  /*1589*/ { function_entry, 0, 0, icache_illegal },
  /*1590*/ { function_entry, 0, 0, icache_illegal },
  /*1591*/ { function_entry, 0, 0, icache_illegal },
  /*1592*/ { function_entry, 0, 0, icache_illegal },
  /*1593*/ { function_entry, 0, 0, icache_illegal },
  /*1594*/ { function_entry, 0, 0, icache_illegal },
  /*1595*/ { function_entry, 0, 0, icache_illegal },
  /*1596*/ { function_entry, 0, 0, icache_illegal },
  /*1597*/ { function_entry, 0, 0, icache_illegal },
  /*1598*/ { function_entry, 0, 0, icache_illegal },
  /*1599*/ { function_entry, 0, 0, icache_illegal },
  /*1600*/ { function_entry, 0, 0, icache_illegal },
  /*1601*/ { function_entry, 0, 0, icache_illegal },
  /*1602*/ { function_entry, 0, 0, icache_illegal },
  /*1603*/ { function_entry, 0, 0, icache_illegal },
  /*1604*/ { function_entry, 0, 0, icache_illegal },
  /*1605*/ { function_entry, 0, 0, icache_illegal },
  /*1606*/ { function_entry, 0, 0, icache_illegal },
  /*1607*/ { function_entry, 0, 0, icache_illegal },
  /*1608*/ { function_entry, 0, 0, icache_illegal },
  /*1609*/ { function_entry, 0, 0, icache_illegal },
  /*1610*/ { function_entry, 0, 0, icache_illegal },
  /*1611*/ { function_entry, 0, 0, icache_illegal },
  /*1612*/ { function_entry, 0, 0, icache_illegal },
  /*1613*/ { function_entry, 0, 0, icache_illegal },
  /*1614*/ { function_entry, 0, 0, icache_illegal },
  /*1615*/ { function_entry, 0, 0, icache_illegal },
  /*1616*/ { function_entry, 0, 0, icache_illegal },
  /*1617*/ { function_entry, 0, 0, icache_illegal },
  /*1618*/ { function_entry, 0, 0, icache_illegal },
  /*1619*/ { function_entry, 0, 0, icache_illegal },
  /*1620*/ { function_entry, 0, 0, icache_illegal },
  /*1621*/ { function_entry, 0, 0, icache_illegal },
  /*1622*/ { function_entry, 0, 0, icache_illegal },
  /*1623*/ { function_entry, 0, 0, icache_illegal },
  /*1624*/ { function_entry, 0, 0, icache_illegal },
  /*1625*/ { function_entry, 0, 0, icache_illegal },
  /*1626*/ { function_entry, 0, 0, icache_illegal },
  /*1627*/ { function_entry, 0, 0, icache_illegal },
  /*1628*/ { function_entry, 0, 0, icache_illegal },
  /*1629*/ { function_entry, 0, 0, icache_illegal },
  /*1630*/ { function_entry, 0, 0, icache_illegal },
  /*1631*/ { function_entry, 0, 0, icache_illegal },
  /*1632*/ { function_entry, 0, 0, icache_illegal },
  /*1633*/ { function_entry, 0, 0, icache_illegal },
  /*1634*/ { function_entry, 0, 0, icache_illegal },
  /*1635*/ { function_entry, 0, 0, icache_illegal },
  /*1636*/ { function_entry, 0, 0, icache_illegal },
  /*1637*/ { function_entry, 0, 0, icache_illegal },
  /*1638*/ { function_entry, 0, 0, icache_illegal },
  /*1639*/ { function_entry, 0, 0, icache_illegal },
  /*1640*/ { function_entry, 0, 0, icache_illegal },
  /*1641*/ { function_entry, 0, 0, icache_illegal },
  /*1642*/ { function_entry, 0, 0, icache_illegal },
  /*1643*/ { function_entry, 0, 0, icache_illegal },
  /*1644*/ { function_entry, 0, 0, icache_illegal },
  /*1645*/ { function_entry, 0, 0, icache_illegal },
  /*1646*/ { function_entry, 0, 0, icache_illegal },
  /*1647*/ { function_entry, 0, 0, icache_illegal },
  /*1648*/ { function_entry, 0, 0, icache_Shift_Right_Algebraic_Word_Immediate_Rc0 },
  /*1649*/ { function_entry, 0, 0, icache_Shift_Right_Algebraic_Word_Immediate_Rc1 },
  /*1650*/ { function_entry, 0, 0, icache_illegal },
  /*1651*/ { function_entry, 0, 0, icache_illegal },
  /*1652*/ { function_entry, 0, 0, icache_illegal },
  /*1653*/ { function_entry, 0, 0, icache_illegal },
  /*1654*/ { function_entry, 0, 0, icache_illegal },
  /*1655*/ { function_entry, 0, 0, icache_illegal },
  /*1656*/ { function_entry, 0, 0, icache_illegal },
  /*1657*/ { function_entry, 0, 0, icache_illegal },
  /*1658*/ { function_entry, 0, 0, icache_illegal },
  /*1659*/ { function_entry, 0, 0, icache_illegal },
  /*1660*/ { function_entry, 0, 0, icache_illegal },
  /*1661*/ { function_entry, 0, 0, icache_illegal },
  /*1662*/ { function_entry, 0, 0, icache_illegal },
  /*1663*/ { function_entry, 0, 0, icache_illegal },
  /*1664*/ { function_entry, 0, 0, icache_illegal },
  /*1665*/ { function_entry, 0, 0, icache_illegal },
  /*1666*/ { function_entry, 0, 0, icache_illegal },
  /*1667*/ { function_entry, 0, 0, icache_illegal },
  /*1668*/ { function_entry, 0, 0, icache_illegal },
  /*1669*/ { function_entry, 0, 0, icache_illegal },
  /*1670*/ { function_entry, 0, 0, icache_illegal },
  /*1671*/ { function_entry, 0, 0, icache_illegal },
  /*1672*/ { function_entry, 0, 0, icache_illegal },
  /*1673*/ { function_entry, 0, 0, icache_illegal },
  /*1674*/ { function_entry, 0, 0, icache_illegal },
  /*1675*/ { function_entry, 0, 0, icache_illegal },
  /*1676*/ { function_entry, 0, 0, icache_illegal },
  /*1677*/ { function_entry, 0, 0, icache_illegal },
  /*1678*/ { function_entry, 0, 0, icache_illegal },
  /*1679*/ { function_entry, 0, 0, icache_illegal },
  /*1680*/ { function_entry, 0, 0, icache_illegal },
  /*1681*/ { function_entry, 0, 0, icache_illegal },
  /*1682*/ { function_entry, 0, 0, icache_illegal },
  /*1683*/ { function_entry, 0, 0, icache_illegal },
  /*1684*/ { function_entry, 0, 0, icache_illegal },
  /*1685*/ { function_entry, 0, 0, icache_illegal },
  /*1686*/ { function_entry, 0, 0, icache_illegal },
  /*1687*/ { function_entry, 0, 0, icache_illegal },
  /*1688*/ { function_entry, 0, 0, icache_illegal },
  /*1689*/ { function_entry, 0, 0, icache_illegal },
  /*1690*/ { function_entry, 0, 0, icache_illegal },
  /*1691*/ { function_entry, 0, 0, icache_illegal },
  /*1692*/ { function_entry, 0, 0, icache_illegal },
  /*1693*/ { function_entry, 0, 0, icache_illegal },
  /*1694*/ { function_entry, 0, 0, icache_illegal },
  /*1695*/ { function_entry, 0, 0, icache_illegal },
  /*1696*/ { function_entry, 0, 0, icache_illegal },
  /*1697*/ { function_entry, 0, 0, icache_illegal },
  /*1698*/ { function_entry, 0, 0, icache_illegal },
  /*1699*/ { function_entry, 0, 0, icache_illegal },
  /*1700*/ { function_entry, 0, 0, icache_illegal },
  /*1701*/ { function_entry, 0, 0, icache_illegal },
  /*1702*/ { function_entry, 0, 0, icache_illegal },
  /*1703*/ { function_entry, 0, 0, icache_illegal },
  /*1704*/ { function_entry, 0, 0, icache_illegal },
  /*1705*/ { function_entry, 0, 0, icache_illegal },
  /*1706*/ { function_entry, 0, 0, icache_illegal },
  /*1707*/ { function_entry, 0, 0, icache_illegal },
  /*1708*/ { function_entry, 0, 0, icache_Enforce_Inorder_Execution_of_IO },
  /*1709*/ { function_entry, 0, 0, icache_illegal },
  /*1710*/ { function_entry, 0, 0, icache_illegal },
  /*1711*/ { function_entry, 0, 0, icache_illegal },
  /*1712*/ { function_entry, 0, 0, icache_illegal },
  /*1713*/ { function_entry, 0, 0, icache_illegal },
  /*1714*/ { function_entry, 0, 0, icache_illegal },
  /*1715*/ { function_entry, 0, 0, icache_illegal },
  /*1716*/ { function_entry, 0, 0, icache_illegal },
  /*1717*/ { function_entry, 0, 0, icache_illegal },
  /*1718*/ { function_entry, 0, 0, icache_illegal },
  /*1719*/ { function_entry, 0, 0, icache_illegal },
  /*1720*/ { function_entry, 0, 0, icache_illegal },
  /*1721*/ { function_entry, 0, 0, icache_illegal },
  /*1722*/ { function_entry, 0, 0, icache_illegal },
  /*1723*/ { function_entry, 0, 0, icache_illegal },
  /*1724*/ { function_entry, 0, 0, icache_illegal },
  /*1725*/ { function_entry, 0, 0, icache_illegal },
  /*1726*/ { function_entry, 0, 0, icache_illegal },
  /*1727*/ { function_entry, 0, 0, icache_illegal },
  /*1728*/ { function_entry, 0, 0, icache_illegal },
  /*1729*/ { function_entry, 0, 0, icache_illegal },
  /*1730*/ { function_entry, 0, 0, icache_illegal },
  /*1731*/ { function_entry, 0, 0, icache_illegal },
  /*1732*/ { function_entry, 0, 0, icache_illegal },
  /*1733*/ { function_entry, 0, 0, icache_illegal },
  /*1734*/ { function_entry, 0, 0, icache_illegal },
  /*1735*/ { function_entry, 0, 0, icache_illegal },
  /*1736*/ { function_entry, 0, 0, icache_illegal },
  /*1737*/ { function_entry, 0, 0, icache_illegal },
  /*1738*/ { function_entry, 0, 0, icache_illegal },
  /*1739*/ { function_entry, 0, 0, icache_illegal },
  /*1740*/ { function_entry, 0, 0, icache_illegal },
  /*1741*/ { function_entry, 0, 0, icache_illegal },
  /*1742*/ { function_entry, 0, 0, icache_illegal },
  /*1743*/ { function_entry, 0, 0, icache_illegal },
  /*1744*/ { function_entry, 0, 0, icache_illegal },
  /*1745*/ { function_entry, 0, 0, icache_illegal },
  /*1746*/ { function_entry, 0, 0, icache_illegal },
  /*1747*/ { function_entry, 0, 0, icache_illegal },
  /*1748*/ { function_entry, 0, 0, icache_illegal },
  /*1749*/ { function_entry, 0, 0, icache_illegal },
  /*1750*/ { function_entry, 0, 0, icache_illegal },
  /*1751*/ { function_entry, 0, 0, icache_illegal },
  /*1752*/ { function_entry, 0, 0, icache_illegal },
  /*1753*/ { function_entry, 0, 0, icache_illegal },
  /*1754*/ { function_entry, 0, 0, icache_illegal },
  /*1755*/ { function_entry, 0, 0, icache_illegal },
  /*1756*/ { function_entry, 0, 0, icache_illegal },
  /*1757*/ { function_entry, 0, 0, icache_illegal },
  /*1758*/ { function_entry, 0, 0, icache_illegal },
  /*1759*/ { function_entry, 0, 0, icache_illegal },
  /*1760*/ { function_entry, 0, 0, icache_illegal },
  /*1761*/ { function_entry, 0, 0, icache_illegal },
  /*1762*/ { function_entry, 0, 0, icache_illegal },
  /*1763*/ { function_entry, 0, 0, icache_illegal },
  /*1764*/ { function_entry, 0, 0, icache_illegal },
  /*1765*/ { function_entry, 0, 0, icache_illegal },
  /*1766*/ { function_entry, 0, 0, icache_illegal },
  /*1767*/ { function_entry, 0, 0, icache_illegal },
  /*1768*/ { function_entry, 0, 0, icache_illegal },
  /*1769*/ { function_entry, 0, 0, icache_illegal },
  /*1770*/ { function_entry, 0, 0, icache_illegal },
  /*1771*/ { function_entry, 0, 0, icache_illegal },
  /*1772*/ { function_entry, 0, 0, icache_illegal },
  /*1773*/ { function_entry, 0, 0, icache_illegal },
  /*1774*/ { function_entry, 0, 0, icache_illegal },
  /*1775*/ { function_entry, 0, 0, icache_illegal },
  /*1776*/ { function_entry, 0, 0, icache_illegal },
  /*1777*/ { function_entry, 0, 0, icache_illegal },
  /*1778*/ { function_entry, 0, 0, icache_illegal },
  /*1779*/ { function_entry, 0, 0, icache_illegal },
  /*1780*/ { function_entry, 0, 0, icache_illegal },
  /*1781*/ { function_entry, 0, 0, icache_illegal },
  /*1782*/ { function_entry, 0, 0, icache_illegal },
  /*1783*/ { function_entry, 0, 0, icache_illegal },
  /*1784*/ { function_entry, 0, 0, icache_illegal },
  /*1785*/ { function_entry, 0, 0, icache_illegal },
  /*1786*/ { function_entry, 0, 0, icache_illegal },
  /*1787*/ { function_entry, 0, 0, icache_illegal },
  /*1788*/ { function_entry, 0, 0, icache_illegal },
  /*1789*/ { function_entry, 0, 0, icache_illegal },
  /*1790*/ { function_entry, 0, 0, icache_illegal },
  /*1791*/ { function_entry, 0, 0, icache_illegal },
  /*1792*/ { function_entry, 0, 0, icache_illegal },
  /*1793*/ { function_entry, 0, 0, icache_illegal },
  /*1794*/ { function_entry, 0, 0, icache_illegal },
  /*1795*/ { function_entry, 0, 0, icache_illegal },
  /*1796*/ { function_entry, 0, 0, icache_illegal },
  /*1797*/ { function_entry, 0, 0, icache_illegal },
  /*1798*/ { function_entry, 0, 0, icache_illegal },
  /*1799*/ { function_entry, 0, 0, icache_illegal },
  /*1800*/ { function_entry, 0, 0, icache_illegal },
  /*1801*/ { function_entry, 0, 0, icache_illegal },
  /*1802*/ { function_entry, 0, 0, icache_illegal },
  /*1803*/ { function_entry, 0, 0, icache_illegal },
  /*1804*/ { function_entry, 0, 0, icache_illegal },
  /*1805*/ { function_entry, 0, 0, icache_illegal },
  /*1806*/ { function_entry, 0, 0, icache_illegal },
  /*1807*/ { function_entry, 0, 0, icache_illegal },
  /*1808*/ { function_entry, 0, 0, icache_illegal },
  /*1809*/ { function_entry, 0, 0, icache_illegal },
  /*1810*/ { function_entry, 0, 0, icache_illegal },
  /*1811*/ { function_entry, 0, 0, icache_illegal },
  /*1812*/ { function_entry, 0, 0, icache_illegal },
  /*1813*/ { function_entry, 0, 0, icache_illegal },
  /*1814*/ { function_entry, 0, 0, icache_illegal },
  /*1815*/ { function_entry, 0, 0, icache_illegal },
  /*1816*/ { function_entry, 0, 0, icache_illegal },
  /*1817*/ { function_entry, 0, 0, icache_illegal },
  /*1818*/ { function_entry, 0, 0, icache_illegal },
  /*1819*/ { function_entry, 0, 0, icache_illegal },
  /*1820*/ { function_entry, 0, 0, icache_illegal },
  /*1821*/ { function_entry, 0, 0, icache_illegal },
  /*1822*/ { function_entry, 0, 0, icache_illegal },
  /*1823*/ { function_entry, 0, 0, icache_illegal },
  /*1824*/ { function_entry, 0, 0, icache_illegal },
  /*1825*/ { function_entry, 0, 0, icache_illegal },
  /*1826*/ { function_entry, 0, 0, icache_illegal },
  /*1827*/ { function_entry, 0, 0, icache_illegal },
  /*1828*/ { function_entry, 0, 0, icache_illegal },
  /*1829*/ { function_entry, 0, 0, icache_illegal },
  /*1830*/ { function_entry, 0, 0, icache_illegal },
  /*1831*/ { function_entry, 0, 0, icache_illegal },
  /*1832*/ { function_entry, 0, 0, icache_illegal },
  /*1833*/ { function_entry, 0, 0, icache_illegal },
  /*1834*/ { function_entry, 0, 0, icache_illegal },
  /*1835*/ { function_entry, 0, 0, icache_illegal },
  /*1836*/ { function_entry, 0, 0, icache_Store_Half_Word_ByteReversed_Indexed },
  /*1837*/ { function_entry, 0, 0, icache_illegal },
  /*1838*/ { function_entry, 0, 0, icache_illegal },
  /*1839*/ { function_entry, 0, 0, icache_illegal },
  /*1840*/ { function_entry, 0, 0, icache_illegal },
  /*1841*/ { function_entry, 0, 0, icache_illegal },
  /*1842*/ { function_entry, 0, 0, icache_illegal },
  /*1843*/ { function_entry, 0, 0, icache_illegal },
  /*1844*/ { function_entry, 0, 0, icache_Extend_Sign_Half_Word_Rc0 },
  /*1845*/ { function_entry, 0, 0, icache_Extend_Sign_Half_Word_Rc1 },
  /*1846*/ { function_entry, 0, 0, icache_illegal },
  /*1847*/ { function_entry, 0, 0, icache_illegal },
  /*1848*/ { function_entry, 0, 0, icache_illegal },
  /*1849*/ { function_entry, 0, 0, icache_illegal },
  /*1850*/ { function_entry, 0, 0, icache_illegal },
  /*1851*/ { function_entry, 0, 0, icache_illegal },
  /*1852*/ { function_entry, 0, 0, icache_illegal },
  /*1853*/ { function_entry, 0, 0, icache_illegal },
  /*1854*/ { function_entry, 0, 0, icache_illegal },
  /*1855*/ { function_entry, 0, 0, icache_illegal },
  /*1856*/ { function_entry, 0, 0, icache_illegal },
  /*1857*/ { function_entry, 0, 0, icache_illegal },
  /*1858*/ { function_entry, 0, 0, icache_illegal },
  /*1859*/ { function_entry, 0, 0, icache_illegal },
  /*1860*/ { function_entry, 0, 0, icache_illegal },
  /*1861*/ { function_entry, 0, 0, icache_illegal },
  /*1862*/ { function_entry, 0, 0, icache_illegal },
  /*1863*/ { function_entry, 0, 0, icache_illegal },
  /*1864*/ { function_entry, 0, 0, icache_illegal },
  /*1865*/ { function_entry, 0, 0, icache_illegal },
  /*1866*/ { function_entry, 0, 0, icache_illegal },
  /*1867*/ { function_entry, 0, 0, icache_illegal },
  /*1868*/ { function_entry, 0, 0, icache_illegal },
  /*1869*/ { function_entry, 0, 0, icache_illegal },
  /*1870*/ { function_entry, 0, 0, icache_illegal },
  /*1871*/ { function_entry, 0, 0, icache_illegal },
  /*1872*/ { function_entry, 0, 0, icache_illegal },
  /*1873*/ { function_entry, 0, 0, icache_illegal },
  /*1874*/ { function_entry, 0, 0, icache_illegal },
  /*1875*/ { function_entry, 0, 0, icache_illegal },
  /*1876*/ { function_entry, 0, 0, icache_illegal },
  /*1877*/ { function_entry, 0, 0, icache_illegal },
  /*1878*/ { function_entry, 0, 0, icache_illegal },
  /*1879*/ { function_entry, 0, 0, icache_illegal },
  /*1880*/ { function_entry, 0, 0, icache_illegal },
  /*1881*/ { function_entry, 0, 0, icache_illegal },
  /*1882*/ { function_entry, 0, 0, icache_illegal },
  /*1883*/ { function_entry, 0, 0, icache_illegal },
  /*1884*/ { function_entry, 0, 0, icache_illegal },
  /*1885*/ { function_entry, 0, 0, icache_illegal },
  /*1886*/ { function_entry, 0, 0, icache_illegal },
  /*1887*/ { function_entry, 0, 0, icache_illegal },
  /*1888*/ { function_entry, 0, 0, icache_illegal },
  /*1889*/ { function_entry, 0, 0, icache_illegal },
  /*1890*/ { function_entry, 0, 0, icache_illegal },
  /*1891*/ { function_entry, 0, 0, icache_illegal },
  /*1892*/ { function_entry, 0, 0, icache_illegal },
  /*1893*/ { function_entry, 0, 0, icache_illegal },
  /*1894*/ { function_entry, 0, 0, icache_illegal },
  /*1895*/ { function_entry, 0, 0, icache_illegal },
  /*1896*/ { function_entry, 0, 0, icache_illegal },
  /*1897*/ { function_entry, 0, 0, icache_illegal },
  /*1898*/ { function_entry, 0, 0, icache_illegal },
  /*1899*/ { function_entry, 0, 0, icache_illegal },
  /*1900*/ { function_entry, 0, 0, icache_illegal },
  /*1901*/ { function_entry, 0, 0, icache_illegal },
  /*1902*/ { function_entry, 0, 0, icache_illegal },
  /*1903*/ { function_entry, 0, 0, icache_illegal },
  /*1904*/ { function_entry, 0, 0, icache_illegal },
  /*1905*/ { function_entry, 0, 0, icache_illegal },
  /*1906*/ { function_entry, 0, 0, icache_illegal },
  /*1907*/ { function_entry, 0, 0, icache_illegal },
  /*1908*/ { function_entry, 0, 0, icache_Extend_Sign_Byte_Rc0 },
  /*1909*/ { function_entry, 0, 0, icache_Extend_Sign_Byte_Rc1 },
  /*1910*/ { function_entry, 0, 0, icache_illegal },
  /*1911*/ { function_entry, 0, 0, icache_illegal },
  /*1912*/ { function_entry, 0, 0, icache_illegal },
  /*1913*/ { function_entry, 0, 0, icache_illegal },
  /*1914*/ { function_entry, 0, 0, icache_illegal },
  /*1915*/ { function_entry, 0, 0, icache_illegal },
  /*1916*/ { function_entry, 0, 0, icache_illegal },
  /*1917*/ { function_entry, 0, 0, icache_illegal },
  /*1918*/ { function_entry, 0, 0, icache_illegal },
  /*1919*/ { function_entry, 0, 0, icache_illegal },
  /*1920*/ { function_entry, 0, 0, icache_illegal },
  /*1921*/ { function_entry, 0, 0, icache_illegal },
  /*1922*/ { function_entry, 0, 0, icache_illegal },
  /*1923*/ { function_entry, 0, 0, icache_illegal },
  /*1924*/ { function_entry, 0, 0, icache_illegal },
  /*1925*/ { function_entry, 0, 0, icache_illegal },
  /*1926*/ { function_entry, 0, 0, icache_illegal },
  /*1927*/ { function_entry, 0, 0, icache_illegal },
  /*1928*/ { function_entry, 0, 0, icache_illegal },
  /*1929*/ { function_entry, 0, 0, icache_illegal },
  /*1930*/ { function_entry, 0, 0, icache_illegal },
  /*1931*/ { function_entry, 0, 0, icache_illegal },
  /*1932*/ { function_entry, 0, 0, icache_illegal },
  /*1933*/ { function_entry, 0, 0, icache_illegal },
  /*1934*/ { function_entry, 0, 0, icache_illegal },
  /*1935*/ { function_entry, 0, 0, icache_illegal },
  /*1936*/ { function_entry, 0, 0, icache_illegal },
  /*1937*/ { function_entry, 0, 0, icache_illegal },
  /*1938*/ { function_entry, 0, 0, icache_illegal },
  /*1939*/ { function_entry, 0, 0, icache_illegal },
  /*1940*/ { function_entry, 0, 0, icache_illegal },
  /*1941*/ { function_entry, 0, 0, icache_illegal },
  /*1942*/ { function_entry, 0, 0, icache_Divide_Word_Unsigned_OE1_Rc0 },
  /*1943*/ { function_entry, 0, 0, icache_Divide_Word_Unsigned_OE1_Rc1 },
  /*1944*/ { function_entry, 0, 0, icache_illegal },
  /*1945*/ { function_entry, 0, 0, icache_illegal },
  /*1946*/ { function_entry, 0, 0, icache_illegal },
  /*1947*/ { function_entry, 0, 0, icache_illegal },
  /*1948*/ { function_entry, 0, 0, icache_illegal },
  /*1949*/ { function_entry, 0, 0, icache_illegal },
  /*1950*/ { function_entry, 0, 0, icache_illegal },
  /*1951*/ { function_entry, 0, 0, icache_illegal },
  /*1952*/ { function_entry, 0, 0, icache_illegal },
  /*1953*/ { function_entry, 0, 0, icache_illegal },
  /*1954*/ { function_entry, 0, 0, icache_illegal },
  /*1955*/ { function_entry, 0, 0, icache_illegal },
  /*1956*/ { function_entry, 0, 0, icache_illegal },
  /*1957*/ { function_entry, 0, 0, icache_illegal },
  /*1958*/ { function_entry, 0, 0, icache_illegal },
  /*1959*/ { function_entry, 0, 0, icache_illegal },
  /*1960*/ { function_entry, 0, 0, icache_illegal },
  /*1961*/ { function_entry, 0, 0, icache_illegal },
  /*1962*/ { function_entry, 0, 0, icache_illegal },
  /*1963*/ { function_entry, 0, 0, icache_illegal },
  /*1964*/ { function_entry, 0, 0, icache_Instruction_Cache_Block_Invalidate },
  /*1965*/ { function_entry, 0, 0, icache_illegal },
  /*1966*/ { function_entry, 0, 0, icache_Store_FloatingPoint_Integer_Word_Indexed },
  /*1967*/ { function_entry, 0, 0, icache_illegal },
  /*1968*/ { function_entry, 0, 0, icache_illegal },
  /*1969*/ { function_entry, 0, 0, icache_illegal },
  /*1970*/ { function_entry, 0, 0, icache_illegal },
  /*1971*/ { function_entry, 0, 0, icache_illegal },
  /*1972*/ { function_entry, 0, 0, icache_illegal },
  /*1973*/ { function_entry, 0, 0, icache_illegal },
  /*1974*/ { function_entry, 0, 0, icache_illegal },
  /*1975*/ { function_entry, 0, 0, icache_illegal },
  /*1976*/ { function_entry, 0, 0, icache_illegal },
  /*1977*/ { function_entry, 0, 0, icache_illegal },
  /*1978*/ { function_entry, 0, 0, icache_illegal },
  /*1979*/ { function_entry, 0, 0, icache_illegal },
  /*1980*/ { function_entry, 0, 0, icache_illegal },
  /*1981*/ { function_entry, 0, 0, icache_illegal },
  /*1982*/ { function_entry, 0, 0, icache_illegal },
  /*1983*/ { function_entry, 0, 0, icache_illegal },
  /*1984*/ { function_entry, 0, 0, icache_illegal },
  /*1985*/ { function_entry, 0, 0, icache_illegal },
  /*1986*/ { function_entry, 0, 0, icache_illegal },
  /*1987*/ { function_entry, 0, 0, icache_illegal },
  /*1988*/ { function_entry, 0, 0, icache_illegal },
  /*1989*/ { function_entry, 0, 0, icache_illegal },
  /*1990*/ { function_entry, 0, 0, icache_illegal },
  /*1991*/ { function_entry, 0, 0, icache_illegal },
  /*1992*/ { function_entry, 0, 0, icache_illegal },
  /*1993*/ { function_entry, 0, 0, icache_illegal },
  /*1994*/ { function_entry, 0, 0, icache_illegal },
  /*1995*/ { function_entry, 0, 0, icache_illegal },
  /*1996*/ { function_entry, 0, 0, icache_illegal },
  /*1997*/ { function_entry, 0, 0, icache_illegal },
  /*1998*/ { function_entry, 0, 0, icache_illegal },
  /*1999*/ { function_entry, 0, 0, icache_illegal },
  /*2000*/ { function_entry, 0, 0, icache_illegal },
  /*2001*/ { function_entry, 0, 0, icache_illegal },
  /*2002*/ { function_entry, 0, 0, icache_illegal },
  /*2003*/ { function_entry, 0, 0, icache_illegal },
  /*2004*/ { function_entry, 0, 0, icache_illegal },
  /*2005*/ { function_entry, 0, 0, icache_illegal },
  /*2006*/ { function_entry, 0, 0, icache_Divide_Word_OE1_Rc0 },
  /*2007*/ { function_entry, 0, 0, icache_Divide_Word_OE1_Rc1 },
  /*2008*/ { function_entry, 0, 0, icache_illegal },
  /*2009*/ { function_entry, 0, 0, icache_illegal },
  /*2010*/ { function_entry, 0, 0, icache_illegal },
  /*2011*/ { function_entry, 0, 0, icache_illegal },
  /*2012*/ { function_entry, 0, 0, icache_illegal },
  /*2013*/ { function_entry, 0, 0, icache_illegal },
  /*2014*/ { function_entry, 0, 0, icache_illegal },
  /*2015*/ { function_entry, 0, 0, icache_illegal },
  /*2016*/ { function_entry, 0, 0, icache_illegal },
  /*2017*/ { function_entry, 0, 0, icache_illegal },
  /*2018*/ { function_entry, 0, 0, icache_illegal },
  /*2019*/ { function_entry, 0, 0, icache_illegal },
  /*2020*/ { function_entry, 0, 0, icache_illegal },
  /*2021*/ { function_entry, 0, 0, icache_illegal },
  /*2022*/ { function_entry, 0, 0, icache_illegal },
  /*2023*/ { function_entry, 0, 0, icache_illegal },
  /*2024*/ { function_entry, 0, 0, icache_illegal },
  /*2025*/ { function_entry, 0, 0, icache_illegal },
  /*2026*/ { function_entry, 0, 0, icache_illegal },
  /*2027*/ { function_entry, 0, 0, icache_illegal },
  /*2028*/ { function_entry, 0, 0, icache_Data_Cache_Block_set_to_Zero },
  /*2029*/ { function_entry, 0, 0, icache_illegal },
  /*2030*/ { function_entry, 0, 0, icache_illegal },
  /*2031*/ { function_entry, 0, 0, icache_illegal },
  /*2032*/ { function_entry, 0, 0, icache_illegal },
  /*2033*/ { function_entry, 0, 0, icache_illegal },
  /*2034*/ { function_entry, 0, 0, icache_illegal },
  /*2035*/ { function_entry, 0, 0, icache_illegal },
  /*2036*/ { function_entry, 0, 0, icache_illegal },
  /*2037*/ { function_entry, 0, 0, icache_illegal },
  /*2038*/ { function_entry, 0, 0, icache_illegal },
  /*2039*/ { function_entry, 0, 0, icache_illegal },
  /*2040*/ { function_entry, 0, 0, icache_illegal },
  /*2041*/ { function_entry, 0, 0, icache_illegal },
  /*2042*/ { function_entry, 0, 0, icache_illegal },
  /*2043*/ { function_entry, 0, 0, icache_illegal },
  /*2044*/ { function_entry, 0, 0, icache_illegal },
  /*2045*/ { function_entry, 0, 0, icache_illegal },
  /*2046*/ { function_entry, 0, 0, icache_illegal },
  /*2047*/ { function_entry, 0, 0, icache_illegal },
};

static idecode_table_entry idecode_table_26_31__59_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_illegal },
  /*1*/ { function_entry, 0, 0, icache_illegal },
  /*2*/ { function_entry, 0, 0, icache_illegal },
  /*3*/ { function_entry, 0, 0, icache_illegal },
  /*4*/ { function_entry, 0, 0, icache_illegal },
  /*5*/ { function_entry, 0, 0, icache_illegal },
  /*6*/ { function_entry, 0, 0, icache_illegal },
  /*7*/ { function_entry, 0, 0, icache_illegal },
  /*8*/ { function_entry, 0, 0, icache_illegal },
  /*9*/ { function_entry, 0, 0, icache_illegal },
  /*10*/ { function_entry, 0, 0, icache_illegal },
  /*11*/ { function_entry, 0, 0, icache_illegal },
  /*12*/ { function_entry, 0, 0, icache_illegal },
  /*13*/ { function_entry, 0, 0, icache_illegal },
  /*14*/ { function_entry, 0, 0, icache_illegal },
  /*15*/ { function_entry, 0, 0, icache_illegal },
  /*16*/ { function_entry, 0, 0, icache_illegal },
  /*17*/ { function_entry, 0, 0, icache_illegal },
  /*18*/ { function_entry, 0, 0, icache_illegal },
  /*19*/ { function_entry, 0, 0, icache_illegal },
  /*20*/ { function_entry, 0, 0, icache_illegal },
  /*21*/ { function_entry, 0, 0, icache_illegal },
  /*22*/ { function_entry, 0, 0, icache_illegal },
  /*23*/ { function_entry, 0, 0, icache_illegal },
  /*24*/ { function_entry, 0, 0, icache_illegal },
  /*25*/ { function_entry, 0, 0, icache_illegal },
  /*26*/ { function_entry, 0, 0, icache_illegal },
  /*27*/ { function_entry, 0, 0, icache_illegal },
  /*28*/ { function_entry, 0, 0, icache_illegal },
  /*29*/ { function_entry, 0, 0, icache_illegal },
  /*30*/ { function_entry, 0, 0, icache_illegal },
  /*31*/ { function_entry, 0, 0, icache_illegal },
  /*32*/ { function_entry, 0, 0, icache_illegal },
  /*33*/ { function_entry, 0, 0, icache_illegal },
  /*34*/ { function_entry, 0, 0, icache_illegal },
  /*35*/ { function_entry, 0, 0, icache_illegal },
  /*36*/ { function_entry, 0, 0, icache_Floating_Divide_Single_Rc0 },
  /*37*/ { function_entry, 0, 0, icache_Floating_Divide_Single_Rc1 },
  /*38*/ { function_entry, 0, 0, icache_illegal },
  /*39*/ { function_entry, 0, 0, icache_illegal },
  /*40*/ { function_entry, 0, 0, icache_Floating_Subtract_Single_Rc0 },
  /*41*/ { function_entry, 0, 0, icache_Floating_Subtract_Single_Rc1 },
  /*42*/ { function_entry, 0, 0, icache_Floating_Add_Single_Rc0 },
  /*43*/ { function_entry, 0, 0, icache_Floating_Add_Single_Rc1 },
  /*44*/ { function_entry, 0, 0, icache_Floating_Square_Root_Single_Rc0 },
  /*45*/ { function_entry, 0, 0, icache_Floating_Square_Root_Single_Rc1 },
  /*46*/ { function_entry, 0, 0, icache_illegal },
  /*47*/ { function_entry, 0, 0, icache_illegal },
  /*48*/ { function_entry, 0, 0, icache_Floating_Reciprocal_Estimate_Single_Rc0 },
  /*49*/ { function_entry, 0, 0, icache_Floating_Reciprocal_Estimate_Single_Rc1 },
  /*50*/ { function_entry, 0, 0, icache_Floating_Multiply_Single_Rc0 },
  /*51*/ { function_entry, 0, 0, icache_Floating_Multiply_Single_Rc1 },
  /*52*/ { function_entry, 0, 0, icache_illegal },
  /*53*/ { function_entry, 0, 0, icache_illegal },
  /*54*/ { function_entry, 0, 0, icache_illegal },
  /*55*/ { function_entry, 0, 0, icache_illegal },
  /*56*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_Single_Rc0 },
  /*57*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_Single_Rc1 },
  /*58*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_Single_Rc0 },
  /*59*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_Single_Rc1 },
  /*60*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_Single_Rc0 },
  /*61*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_Single_Rc1 },
  /*62*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_Single_Rc0 },
  /*63*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_Single_Rc1 },
};

static idecode_table_entry idecode_table_21_31__63_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_Floating_Compare_Unordered },
  /*1*/ { function_entry, 0, 0, icache_illegal },
  /*2*/ { function_entry, 0, 0, icache_illegal },
  /*3*/ { function_entry, 0, 0, icache_illegal },
  /*4*/ { function_entry, 0, 0, icache_illegal },
  /*5*/ { function_entry, 0, 0, icache_illegal },
  /*6*/ { function_entry, 0, 0, icache_illegal },
  /*7*/ { function_entry, 0, 0, icache_illegal },
  /*8*/ { function_entry, 0, 0, icache_illegal },
  /*9*/ { function_entry, 0, 0, icache_illegal },
  /*10*/ { function_entry, 0, 0, icache_illegal },
  /*11*/ { function_entry, 0, 0, icache_illegal },
  /*12*/ { function_entry, 0, 0, icache_illegal },
  /*13*/ { function_entry, 0, 0, icache_illegal },
  /*14*/ { function_entry, 0, 0, icache_illegal },
  /*15*/ { function_entry, 0, 0, icache_illegal },
  /*16*/ { function_entry, 0, 0, icache_illegal },
  /*17*/ { function_entry, 0, 0, icache_illegal },
  /*18*/ { function_entry, 0, 0, icache_illegal },
  /*19*/ { function_entry, 0, 0, icache_illegal },
  /*20*/ { function_entry, 0, 0, icache_illegal },
  /*21*/ { function_entry, 0, 0, icache_illegal },
  /*22*/ { function_entry, 0, 0, icache_illegal },
  /*23*/ { function_entry, 0, 0, icache_illegal },
  /*24*/ { function_entry, 0, 0, icache_Floating_Round_to_SinglePrecision_Rc0 },
  /*25*/ { function_entry, 0, 0, icache_Floating_Round_to_SinglePrecision_Rc1 },
  /*26*/ { function_entry, 0, 0, icache_illegal },
  /*27*/ { function_entry, 0, 0, icache_illegal },
  /*28*/ { function_entry, 0, 0, icache_Floating_Convert_To_Integer_Word_Rc0 },
  /*29*/ { function_entry, 0, 0, icache_Floating_Convert_To_Integer_Word_Rc1 },
  /*30*/ { function_entry, 0, 0, icache_Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc0 },
  /*31*/ { function_entry, 0, 0, icache_Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc1 },
  /*32*/ { function_entry, 0, 0, icache_illegal },
  /*33*/ { function_entry, 0, 0, icache_illegal },
  /*34*/ { function_entry, 0, 0, icache_illegal },
  /*35*/ { function_entry, 0, 0, icache_illegal },
  /*36*/ { function_entry, 0, 0, icache_Floating_Divide_Rc0 },
  /*37*/ { function_entry, 0, 0, icache_Floating_Divide_Rc1 },
  /*38*/ { function_entry, 0, 0, icache_illegal },
  /*39*/ { function_entry, 0, 0, icache_illegal },
  /*40*/ { function_entry, 0, 0, icache_Floating_Subtract_Rc0 },
  /*41*/ { function_entry, 0, 0, icache_Floating_Subtract_Rc1 },
  /*42*/ { function_entry, 0, 0, icache_Floating_Add_Rc0 },
  /*43*/ { function_entry, 0, 0, icache_Floating_Add_Rc1 },
  /*44*/ { function_entry, 0, 0, icache_Floating_Square_Root_Rc0 },
  /*45*/ { function_entry, 0, 0, icache_Floating_Square_Root_Rc1 },
  /*46*/ { function_entry, 0, 0, icache_Floating_Select_FRC0_Rc0 },
  /*47*/ { function_entry, 0, 0, icache_Floating_Select_FRC0_Rc1 },
  /*48*/ { function_entry, 0, 0, icache_illegal },
  /*49*/ { function_entry, 0, 0, icache_illegal },
  /*50*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC0_Rc0 },
  /*51*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC0_Rc1 },
  /*52*/ { function_entry, 0, 0, icache_Floating_Reciprocal_Square_Root_Estimate_Rc0 },
  /*53*/ { function_entry, 0, 0, icache_Floating_Reciprocal_Square_Root_Estimate_Rc1 },
  /*54*/ { function_entry, 0, 0, icache_illegal },
  /*55*/ { function_entry, 0, 0, icache_illegal },
  /*56*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC0_Rc0 },
  /*57*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC0_Rc1 },
  /*58*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC0_Rc0 },
  /*59*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC0_Rc1 },
  /*60*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC0_Rc0 },
  /*61*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC0_Rc1 },
  /*62*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC0_Rc0 },
  /*63*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC0_Rc1 },
  /*64*/ { function_entry, 0, 0, icache_Floating_Compare_Ordered },
  /*65*/ { function_entry, 0, 0, icache_illegal },
  /*66*/ { function_entry, 0, 0, icache_illegal },
  /*67*/ { function_entry, 0, 0, icache_illegal },
  /*68*/ { function_entry, 0, 0, icache_illegal },
  /*69*/ { function_entry, 0, 0, icache_illegal },
  /*70*/ { function_entry, 0, 0, icache_illegal },
  /*71*/ { function_entry, 0, 0, icache_illegal },
  /*72*/ { function_entry, 0, 0, icache_illegal },
  /*73*/ { function_entry, 0, 0, icache_illegal },
  /*74*/ { function_entry, 0, 0, icache_illegal },
  /*75*/ { function_entry, 0, 0, icache_illegal },
  /*76*/ { function_entry, 0, 0, icache_Move_To_FPSCR_Bit_1_Rc0 },
  /*77*/ { function_entry, 0, 0, icache_Move_To_FPSCR_Bit_1_Rc1 },
  /*78*/ { function_entry, 0, 0, icache_illegal },
  /*79*/ { function_entry, 0, 0, icache_illegal },
  /*80*/ { function_entry, 0, 0, icache_Floating_Negate_Rc0 },
  /*81*/ { function_entry, 0, 0, icache_Floating_Negate_Rc1 },
  /*82*/ { function_entry, 0, 0, icache_illegal },
  /*83*/ { function_entry, 0, 0, icache_illegal },
  /*84*/ { function_entry, 0, 0, icache_illegal },
  /*85*/ { function_entry, 0, 0, icache_illegal },
  /*86*/ { function_entry, 0, 0, icache_illegal },
  /*87*/ { function_entry, 0, 0, icache_illegal },
  /*88*/ { function_entry, 0, 0, icache_illegal },
  /*89*/ { function_entry, 0, 0, icache_illegal },
  /*90*/ { function_entry, 0, 0, icache_illegal },
  /*91*/ { function_entry, 0, 0, icache_illegal },
  /*92*/ { function_entry, 0, 0, icache_illegal },
  /*93*/ { function_entry, 0, 0, icache_illegal },
  /*94*/ { function_entry, 0, 0, icache_illegal },
  /*95*/ { function_entry, 0, 0, icache_illegal },
  /*96*/ { function_entry, 0, 0, icache_illegal },
  /*97*/ { function_entry, 0, 0, icache_illegal },
  /*98*/ { function_entry, 0, 0, icache_illegal },
  /*99*/ { function_entry, 0, 0, icache_illegal },
  /*100*/ { function_entry, 0, 0, icache_illegal },
  /*101*/ { function_entry, 0, 0, icache_illegal },
  /*102*/ { function_entry, 0, 0, icache_illegal },
  /*103*/ { function_entry, 0, 0, icache_illegal },
  /*104*/ { function_entry, 0, 0, icache_illegal },
  /*105*/ { function_entry, 0, 0, icache_illegal },
  /*106*/ { function_entry, 0, 0, icache_illegal },
  /*107*/ { function_entry, 0, 0, icache_illegal },
  /*108*/ { function_entry, 0, 0, icache_illegal },
  /*109*/ { function_entry, 0, 0, icache_illegal },
  /*110*/ { function_entry, 0, 0, icache_Floating_Select_FRC1_Rc0 },
  /*111*/ { function_entry, 0, 0, icache_Floating_Select_FRC1_Rc1 },
  /*112*/ { function_entry, 0, 0, icache_illegal },
  /*113*/ { function_entry, 0, 0, icache_illegal },
  /*114*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC1_Rc0 },
  /*115*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC1_Rc1 },
  /*116*/ { function_entry, 0, 0, icache_illegal },
  /*117*/ { function_entry, 0, 0, icache_illegal },
  /*118*/ { function_entry, 0, 0, icache_illegal },
  /*119*/ { function_entry, 0, 0, icache_illegal },
  /*120*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC1_Rc0 },
  /*121*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC1_Rc1 },
  /*122*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC1_Rc0 },
  /*123*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC1_Rc1 },
  /*124*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC1_Rc0 },
  /*125*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC1_Rc1 },
  /*126*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC1_Rc0 },
  /*127*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC1_Rc1 },
  /*128*/ { function_entry, 0, 0, icache_Move_to_Condition_Register_from_FPSCR },
  /*129*/ { function_entry, 0, 0, icache_illegal },
  /*130*/ { function_entry, 0, 0, icache_illegal },
  /*131*/ { function_entry, 0, 0, icache_illegal },
  /*132*/ { function_entry, 0, 0, icache_illegal },
  /*133*/ { function_entry, 0, 0, icache_illegal },
  /*134*/ { function_entry, 0, 0, icache_illegal },
  /*135*/ { function_entry, 0, 0, icache_illegal },
  /*136*/ { function_entry, 0, 0, icache_illegal },
  /*137*/ { function_entry, 0, 0, icache_illegal },
  /*138*/ { function_entry, 0, 0, icache_illegal },
  /*139*/ { function_entry, 0, 0, icache_illegal },
  /*140*/ { function_entry, 0, 0, icache_Move_To_FPSCR_Bit_0_Rc0 },
  /*141*/ { function_entry, 0, 0, icache_Move_To_FPSCR_Bit_0_Rc1 },
  /*142*/ { function_entry, 0, 0, icache_illegal },
  /*143*/ { function_entry, 0, 0, icache_illegal },
  /*144*/ { function_entry, 0, 0, icache_Floating_Move_Register_Rc0 },
  /*145*/ { function_entry, 0, 0, icache_Floating_Move_Register_Rc1 },
  /*146*/ { function_entry, 0, 0, icache_illegal },
  /*147*/ { function_entry, 0, 0, icache_illegal },
  /*148*/ { function_entry, 0, 0, icache_illegal },
  /*149*/ { function_entry, 0, 0, icache_illegal },
  /*150*/ { function_entry, 0, 0, icache_illegal },
  /*151*/ { function_entry, 0, 0, icache_illegal },
  /*152*/ { function_entry, 0, 0, icache_illegal },
  /*153*/ { function_entry, 0, 0, icache_illegal },
  /*154*/ { function_entry, 0, 0, icache_illegal },
  /*155*/ { function_entry, 0, 0, icache_illegal },
  /*156*/ { function_entry, 0, 0, icache_illegal },
  /*157*/ { function_entry, 0, 0, icache_illegal },
  /*158*/ { function_entry, 0, 0, icache_illegal },
  /*159*/ { function_entry, 0, 0, icache_illegal },
  /*160*/ { function_entry, 0, 0, icache_illegal },
  /*161*/ { function_entry, 0, 0, icache_illegal },
  /*162*/ { function_entry, 0, 0, icache_illegal },
  /*163*/ { function_entry, 0, 0, icache_illegal },
  /*164*/ { function_entry, 0, 0, icache_illegal },
  /*165*/ { function_entry, 0, 0, icache_illegal },
  /*166*/ { function_entry, 0, 0, icache_illegal },
  /*167*/ { function_entry, 0, 0, icache_illegal },
  /*168*/ { function_entry, 0, 0, icache_illegal },
  /*169*/ { function_entry, 0, 0, icache_illegal },
  /*170*/ { function_entry, 0, 0, icache_illegal },
  /*171*/ { function_entry, 0, 0, icache_illegal },
  /*172*/ { function_entry, 0, 0, icache_illegal },
  /*173*/ { function_entry, 0, 0, icache_illegal },
  /*174*/ { function_entry, 0, 0, icache_Floating_Select_FRC2_Rc0 },
  /*175*/ { function_entry, 0, 0, icache_Floating_Select_FRC2_Rc1 },
  /*176*/ { function_entry, 0, 0, icache_illegal },
  /*177*/ { function_entry, 0, 0, icache_illegal },
  /*178*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC2_Rc0 },
  /*179*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC2_Rc1 },
  /*180*/ { function_entry, 0, 0, icache_illegal },
  /*181*/ { function_entry, 0, 0, icache_illegal },
  /*182*/ { function_entry, 0, 0, icache_illegal },
  /*183*/ { function_entry, 0, 0, icache_illegal },
  /*184*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC2_Rc0 },
  /*185*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC2_Rc1 },
  /*186*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC2_Rc0 },
  /*187*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC2_Rc1 },
  /*188*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC2_Rc0 },
  /*189*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC2_Rc1 },
  /*190*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC2_Rc0 },
  /*191*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC2_Rc1 },
  /*192*/ { function_entry, 0, 0, icache_illegal },
  /*193*/ { function_entry, 0, 0, icache_illegal },
  /*194*/ { function_entry, 0, 0, icache_illegal },
  /*195*/ { function_entry, 0, 0, icache_illegal },
  /*196*/ { function_entry, 0, 0, icache_illegal },
  /*197*/ { function_entry, 0, 0, icache_illegal },
  /*198*/ { function_entry, 0, 0, icache_illegal },
  /*199*/ { function_entry, 0, 0, icache_illegal },
  /*200*/ { function_entry, 0, 0, icache_illegal },
  /*201*/ { function_entry, 0, 0, icache_illegal },
  /*202*/ { function_entry, 0, 0, icache_illegal },
  /*203*/ { function_entry, 0, 0, icache_illegal },
  /*204*/ { function_entry, 0, 0, icache_illegal },
  /*205*/ { function_entry, 0, 0, icache_illegal },
  /*206*/ { function_entry, 0, 0, icache_illegal },
  /*207*/ { function_entry, 0, 0, icache_illegal },
  /*208*/ { function_entry, 0, 0, icache_illegal },
  /*209*/ { function_entry, 0, 0, icache_illegal },
  /*210*/ { function_entry, 0, 0, icache_illegal },
  /*211*/ { function_entry, 0, 0, icache_illegal },
  /*212*/ { function_entry, 0, 0, icache_illegal },
  /*213*/ { function_entry, 0, 0, icache_illegal },
  /*214*/ { function_entry, 0, 0, icache_illegal },
  /*215*/ { function_entry, 0, 0, icache_illegal },
  /*216*/ { function_entry, 0, 0, icache_illegal },
  /*217*/ { function_entry, 0, 0, icache_illegal },
  /*218*/ { function_entry, 0, 0, icache_illegal },
  /*219*/ { function_entry, 0, 0, icache_illegal },
  /*220*/ { function_entry, 0, 0, icache_illegal },
  /*221*/ { function_entry, 0, 0, icache_illegal },
  /*222*/ { function_entry, 0, 0, icache_illegal },
  /*223*/ { function_entry, 0, 0, icache_illegal },
  /*224*/ { function_entry, 0, 0, icache_illegal },
  /*225*/ { function_entry, 0, 0, icache_illegal },
  /*226*/ { function_entry, 0, 0, icache_illegal },
  /*227*/ { function_entry, 0, 0, icache_illegal },
  /*228*/ { function_entry, 0, 0, icache_illegal },
  /*229*/ { function_entry, 0, 0, icache_illegal },
  /*230*/ { function_entry, 0, 0, icache_illegal },
  /*231*/ { function_entry, 0, 0, icache_illegal },
  /*232*/ { function_entry, 0, 0, icache_illegal },
  /*233*/ { function_entry, 0, 0, icache_illegal },
  /*234*/ { function_entry, 0, 0, icache_illegal },
  /*235*/ { function_entry, 0, 0, icache_illegal },
  /*236*/ { function_entry, 0, 0, icache_illegal },
  /*237*/ { function_entry, 0, 0, icache_illegal },
  /*238*/ { function_entry, 0, 0, icache_Floating_Select_FRC3_Rc0 },
  /*239*/ { function_entry, 0, 0, icache_Floating_Select_FRC3_Rc1 },
  /*240*/ { function_entry, 0, 0, icache_illegal },
  /*241*/ { function_entry, 0, 0, icache_illegal },
  /*242*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC3_Rc0 },
  /*243*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC3_Rc1 },
  /*244*/ { function_entry, 0, 0, icache_illegal },
  /*245*/ { function_entry, 0, 0, icache_illegal },
  /*246*/ { function_entry, 0, 0, icache_illegal },
  /*247*/ { function_entry, 0, 0, icache_illegal },
  /*248*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC3_Rc0 },
  /*249*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC3_Rc1 },
  /*250*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC3_Rc0 },
  /*251*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC3_Rc1 },
  /*252*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC3_Rc0 },
  /*253*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC3_Rc1 },
  /*254*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC3_Rc0 },
  /*255*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC3_Rc1 },
  /*256*/ { function_entry, 0, 0, icache_illegal },
  /*257*/ { function_entry, 0, 0, icache_illegal },
  /*258*/ { function_entry, 0, 0, icache_illegal },
  /*259*/ { function_entry, 0, 0, icache_illegal },
  /*260*/ { function_entry, 0, 0, icache_illegal },
  /*261*/ { function_entry, 0, 0, icache_illegal },
  /*262*/ { function_entry, 0, 0, icache_illegal },
  /*263*/ { function_entry, 0, 0, icache_illegal },
  /*264*/ { function_entry, 0, 0, icache_illegal },
  /*265*/ { function_entry, 0, 0, icache_illegal },
  /*266*/ { function_entry, 0, 0, icache_illegal },
  /*267*/ { function_entry, 0, 0, icache_illegal },
  /*268*/ { function_entry, 0, 0, icache_Move_To_FPSCR_Field_Immediate_Rc0 },
  /*269*/ { function_entry, 0, 0, icache_Move_To_FPSCR_Field_Immediate_Rc1 },
  /*270*/ { function_entry, 0, 0, icache_illegal },
  /*271*/ { function_entry, 0, 0, icache_illegal },
  /*272*/ { function_entry, 0, 0, icache_Floating_Negative_Absolute_Value_Rc0 },
  /*273*/ { function_entry, 0, 0, icache_Floating_Negative_Absolute_Value_Rc1 },
  /*274*/ { function_entry, 0, 0, icache_illegal },
  /*275*/ { function_entry, 0, 0, icache_illegal },
  /*276*/ { function_entry, 0, 0, icache_illegal },
  /*277*/ { function_entry, 0, 0, icache_illegal },
  /*278*/ { function_entry, 0, 0, icache_illegal },
  /*279*/ { function_entry, 0, 0, icache_illegal },
  /*280*/ { function_entry, 0, 0, icache_illegal },
  /*281*/ { function_entry, 0, 0, icache_illegal },
  /*282*/ { function_entry, 0, 0, icache_illegal },
  /*283*/ { function_entry, 0, 0, icache_illegal },
  /*284*/ { function_entry, 0, 0, icache_illegal },
  /*285*/ { function_entry, 0, 0, icache_illegal },
  /*286*/ { function_entry, 0, 0, icache_illegal },
  /*287*/ { function_entry, 0, 0, icache_illegal },
  /*288*/ { function_entry, 0, 0, icache_illegal },
  /*289*/ { function_entry, 0, 0, icache_illegal },
  /*290*/ { function_entry, 0, 0, icache_illegal },
  /*291*/ { function_entry, 0, 0, icache_illegal },
  /*292*/ { function_entry, 0, 0, icache_illegal },
  /*293*/ { function_entry, 0, 0, icache_illegal },
  /*294*/ { function_entry, 0, 0, icache_illegal },
  /*295*/ { function_entry, 0, 0, icache_illegal },
  /*296*/ { function_entry, 0, 0, icache_illegal },
  /*297*/ { function_entry, 0, 0, icache_illegal },
  /*298*/ { function_entry, 0, 0, icache_illegal },
  /*299*/ { function_entry, 0, 0, icache_illegal },
  /*300*/ { function_entry, 0, 0, icache_illegal },
  /*301*/ { function_entry, 0, 0, icache_illegal },
  /*302*/ { function_entry, 0, 0, icache_Floating_Select_FRC4_Rc0 },
  /*303*/ { function_entry, 0, 0, icache_Floating_Select_FRC4_Rc1 },
  /*304*/ { function_entry, 0, 0, icache_illegal },
  /*305*/ { function_entry, 0, 0, icache_illegal },
  /*306*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC4_Rc0 },
  /*307*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC4_Rc1 },
  /*308*/ { function_entry, 0, 0, icache_illegal },
  /*309*/ { function_entry, 0, 0, icache_illegal },
  /*310*/ { function_entry, 0, 0, icache_illegal },
  /*311*/ { function_entry, 0, 0, icache_illegal },
  /*312*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC4_Rc0 },
  /*313*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC4_Rc1 },
  /*314*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC4_Rc0 },
  /*315*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC4_Rc1 },
  /*316*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC4_Rc0 },
  /*317*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC4_Rc1 },
  /*318*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC4_Rc0 },
  /*319*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC4_Rc1 },
  /*320*/ { function_entry, 0, 0, icache_illegal },
  /*321*/ { function_entry, 0, 0, icache_illegal },
  /*322*/ { function_entry, 0, 0, icache_illegal },
  /*323*/ { function_entry, 0, 0, icache_illegal },
  /*324*/ { function_entry, 0, 0, icache_illegal },
  /*325*/ { function_entry, 0, 0, icache_illegal },
  /*326*/ { function_entry, 0, 0, icache_illegal },
  /*327*/ { function_entry, 0, 0, icache_illegal },
  /*328*/ { function_entry, 0, 0, icache_illegal },
  /*329*/ { function_entry, 0, 0, icache_illegal },
  /*330*/ { function_entry, 0, 0, icache_illegal },
  /*331*/ { function_entry, 0, 0, icache_illegal },
  /*332*/ { function_entry, 0, 0, icache_illegal },
  /*333*/ { function_entry, 0, 0, icache_illegal },
  /*334*/ { function_entry, 0, 0, icache_illegal },
  /*335*/ { function_entry, 0, 0, icache_illegal },
  /*336*/ { function_entry, 0, 0, icache_illegal },
  /*337*/ { function_entry, 0, 0, icache_illegal },
  /*338*/ { function_entry, 0, 0, icache_illegal },
  /*339*/ { function_entry, 0, 0, icache_illegal },
  /*340*/ { function_entry, 0, 0, icache_illegal },
  /*341*/ { function_entry, 0, 0, icache_illegal },
  /*342*/ { function_entry, 0, 0, icache_illegal },
  /*343*/ { function_entry, 0, 0, icache_illegal },
  /*344*/ { function_entry, 0, 0, icache_illegal },
  /*345*/ { function_entry, 0, 0, icache_illegal },
  /*346*/ { function_entry, 0, 0, icache_illegal },
  /*347*/ { function_entry, 0, 0, icache_illegal },
  /*348*/ { function_entry, 0, 0, icache_illegal },
  /*349*/ { function_entry, 0, 0, icache_illegal },
  /*350*/ { function_entry, 0, 0, icache_illegal },
  /*351*/ { function_entry, 0, 0, icache_illegal },
  /*352*/ { function_entry, 0, 0, icache_illegal },
  /*353*/ { function_entry, 0, 0, icache_illegal },
  /*354*/ { function_entry, 0, 0, icache_illegal },
  /*355*/ { function_entry, 0, 0, icache_illegal },
  /*356*/ { function_entry, 0, 0, icache_illegal },
  /*357*/ { function_entry, 0, 0, icache_illegal },
  /*358*/ { function_entry, 0, 0, icache_illegal },
  /*359*/ { function_entry, 0, 0, icache_illegal },
  /*360*/ { function_entry, 0, 0, icache_illegal },
  /*361*/ { function_entry, 0, 0, icache_illegal },
  /*362*/ { function_entry, 0, 0, icache_illegal },
  /*363*/ { function_entry, 0, 0, icache_illegal },
  /*364*/ { function_entry, 0, 0, icache_illegal },
  /*365*/ { function_entry, 0, 0, icache_illegal },
  /*366*/ { function_entry, 0, 0, icache_Floating_Select_FRC5_Rc0 },
  /*367*/ { function_entry, 0, 0, icache_Floating_Select_FRC5_Rc1 },
  /*368*/ { function_entry, 0, 0, icache_illegal },
  /*369*/ { function_entry, 0, 0, icache_illegal },
  /*370*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC5_Rc0 },
  /*371*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC5_Rc1 },
  /*372*/ { function_entry, 0, 0, icache_illegal },
  /*373*/ { function_entry, 0, 0, icache_illegal },
  /*374*/ { function_entry, 0, 0, icache_illegal },
  /*375*/ { function_entry, 0, 0, icache_illegal },
  /*376*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC5_Rc0 },
  /*377*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC5_Rc1 },
  /*378*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC5_Rc0 },
  /*379*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC5_Rc1 },
  /*380*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC5_Rc0 },
  /*381*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC5_Rc1 },
  /*382*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC5_Rc0 },
  /*383*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC5_Rc1 },
  /*384*/ { function_entry, 0, 0, icache_illegal },
  /*385*/ { function_entry, 0, 0, icache_illegal },
  /*386*/ { function_entry, 0, 0, icache_illegal },
  /*387*/ { function_entry, 0, 0, icache_illegal },
  /*388*/ { function_entry, 0, 0, icache_illegal },
  /*389*/ { function_entry, 0, 0, icache_illegal },
  /*390*/ { function_entry, 0, 0, icache_illegal },
  /*391*/ { function_entry, 0, 0, icache_illegal },
  /*392*/ { function_entry, 0, 0, icache_illegal },
  /*393*/ { function_entry, 0, 0, icache_illegal },
  /*394*/ { function_entry, 0, 0, icache_illegal },
  /*395*/ { function_entry, 0, 0, icache_illegal },
  /*396*/ { function_entry, 0, 0, icache_illegal },
  /*397*/ { function_entry, 0, 0, icache_illegal },
  /*398*/ { function_entry, 0, 0, icache_illegal },
  /*399*/ { function_entry, 0, 0, icache_illegal },
  /*400*/ { function_entry, 0, 0, icache_illegal },
  /*401*/ { function_entry, 0, 0, icache_illegal },
  /*402*/ { function_entry, 0, 0, icache_illegal },
  /*403*/ { function_entry, 0, 0, icache_illegal },
  /*404*/ { function_entry, 0, 0, icache_illegal },
  /*405*/ { function_entry, 0, 0, icache_illegal },
  /*406*/ { function_entry, 0, 0, icache_illegal },
  /*407*/ { function_entry, 0, 0, icache_illegal },
  /*408*/ { function_entry, 0, 0, icache_illegal },
  /*409*/ { function_entry, 0, 0, icache_illegal },
  /*410*/ { function_entry, 0, 0, icache_illegal },
  /*411*/ { function_entry, 0, 0, icache_illegal },
  /*412*/ { function_entry, 0, 0, icache_illegal },
  /*413*/ { function_entry, 0, 0, icache_illegal },
  /*414*/ { function_entry, 0, 0, icache_illegal },
  /*415*/ { function_entry, 0, 0, icache_illegal },
  /*416*/ { function_entry, 0, 0, icache_illegal },
  /*417*/ { function_entry, 0, 0, icache_illegal },
  /*418*/ { function_entry, 0, 0, icache_illegal },
  /*419*/ { function_entry, 0, 0, icache_illegal },
  /*420*/ { function_entry, 0, 0, icache_illegal },
  /*421*/ { function_entry, 0, 0, icache_illegal },
  /*422*/ { function_entry, 0, 0, icache_illegal },
  /*423*/ { function_entry, 0, 0, icache_illegal },
  /*424*/ { function_entry, 0, 0, icache_illegal },
  /*425*/ { function_entry, 0, 0, icache_illegal },
  /*426*/ { function_entry, 0, 0, icache_illegal },
  /*427*/ { function_entry, 0, 0, icache_illegal },
  /*428*/ { function_entry, 0, 0, icache_illegal },
  /*429*/ { function_entry, 0, 0, icache_illegal },
  /*430*/ { function_entry, 0, 0, icache_Floating_Select_FRC6_Rc0 },
  /*431*/ { function_entry, 0, 0, icache_Floating_Select_FRC6_Rc1 },
  /*432*/ { function_entry, 0, 0, icache_illegal },
  /*433*/ { function_entry, 0, 0, icache_illegal },
  /*434*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC6_Rc0 },
  /*435*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC6_Rc1 },
  /*436*/ { function_entry, 0, 0, icache_illegal },
  /*437*/ { function_entry, 0, 0, icache_illegal },
  /*438*/ { function_entry, 0, 0, icache_illegal },
  /*439*/ { function_entry, 0, 0, icache_illegal },
  /*440*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC6_Rc0 },
  /*441*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC6_Rc1 },
  /*442*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC6_Rc0 },
  /*443*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC6_Rc1 },
  /*444*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC6_Rc0 },
  /*445*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC6_Rc1 },
  /*446*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC6_Rc0 },
  /*447*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC6_Rc1 },
  /*448*/ { function_entry, 0, 0, icache_illegal },
  /*449*/ { function_entry, 0, 0, icache_illegal },
  /*450*/ { function_entry, 0, 0, icache_illegal },
  /*451*/ { function_entry, 0, 0, icache_illegal },
  /*452*/ { function_entry, 0, 0, icache_illegal },
  /*453*/ { function_entry, 0, 0, icache_illegal },
  /*454*/ { function_entry, 0, 0, icache_illegal },
  /*455*/ { function_entry, 0, 0, icache_illegal },
  /*456*/ { function_entry, 0, 0, icache_illegal },
  /*457*/ { function_entry, 0, 0, icache_illegal },
  /*458*/ { function_entry, 0, 0, icache_illegal },
  /*459*/ { function_entry, 0, 0, icache_illegal },
  /*460*/ { function_entry, 0, 0, icache_illegal },
  /*461*/ { function_entry, 0, 0, icache_illegal },
  /*462*/ { function_entry, 0, 0, icache_illegal },
  /*463*/ { function_entry, 0, 0, icache_illegal },
  /*464*/ { function_entry, 0, 0, icache_illegal },
  /*465*/ { function_entry, 0, 0, icache_illegal },
  /*466*/ { function_entry, 0, 0, icache_illegal },
  /*467*/ { function_entry, 0, 0, icache_illegal },
  /*468*/ { function_entry, 0, 0, icache_illegal },
  /*469*/ { function_entry, 0, 0, icache_illegal },
  /*470*/ { function_entry, 0, 0, icache_illegal },
  /*471*/ { function_entry, 0, 0, icache_illegal },
  /*472*/ { function_entry, 0, 0, icache_illegal },
  /*473*/ { function_entry, 0, 0, icache_illegal },
  /*474*/ { function_entry, 0, 0, icache_illegal },
  /*475*/ { function_entry, 0, 0, icache_illegal },
  /*476*/ { function_entry, 0, 0, icache_illegal },
  /*477*/ { function_entry, 0, 0, icache_illegal },
  /*478*/ { function_entry, 0, 0, icache_illegal },
  /*479*/ { function_entry, 0, 0, icache_illegal },
  /*480*/ { function_entry, 0, 0, icache_illegal },
  /*481*/ { function_entry, 0, 0, icache_illegal },
  /*482*/ { function_entry, 0, 0, icache_illegal },
  /*483*/ { function_entry, 0, 0, icache_illegal },
  /*484*/ { function_entry, 0, 0, icache_illegal },
  /*485*/ { function_entry, 0, 0, icache_illegal },
  /*486*/ { function_entry, 0, 0, icache_illegal },
  /*487*/ { function_entry, 0, 0, icache_illegal },
  /*488*/ { function_entry, 0, 0, icache_illegal },
  /*489*/ { function_entry, 0, 0, icache_illegal },
  /*490*/ { function_entry, 0, 0, icache_illegal },
  /*491*/ { function_entry, 0, 0, icache_illegal },
  /*492*/ { function_entry, 0, 0, icache_illegal },
  /*493*/ { function_entry, 0, 0, icache_illegal },
  /*494*/ { function_entry, 0, 0, icache_Floating_Select_FRC7_Rc0 },
  /*495*/ { function_entry, 0, 0, icache_Floating_Select_FRC7_Rc1 },
  /*496*/ { function_entry, 0, 0, icache_illegal },
  /*497*/ { function_entry, 0, 0, icache_illegal },
  /*498*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC7_Rc0 },
  /*499*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC7_Rc1 },
  /*500*/ { function_entry, 0, 0, icache_illegal },
  /*501*/ { function_entry, 0, 0, icache_illegal },
  /*502*/ { function_entry, 0, 0, icache_illegal },
  /*503*/ { function_entry, 0, 0, icache_illegal },
  /*504*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC7_Rc0 },
  /*505*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC7_Rc1 },
  /*506*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC7_Rc0 },
  /*507*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC7_Rc1 },
  /*508*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC7_Rc0 },
  /*509*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC7_Rc1 },
  /*510*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC7_Rc0 },
  /*511*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC7_Rc1 },
  /*512*/ { function_entry, 0, 0, icache_illegal },
  /*513*/ { function_entry, 0, 0, icache_illegal },
  /*514*/ { function_entry, 0, 0, icache_illegal },
  /*515*/ { function_entry, 0, 0, icache_illegal },
  /*516*/ { function_entry, 0, 0, icache_illegal },
  /*517*/ { function_entry, 0, 0, icache_illegal },
  /*518*/ { function_entry, 0, 0, icache_illegal },
  /*519*/ { function_entry, 0, 0, icache_illegal },
  /*520*/ { function_entry, 0, 0, icache_illegal },
  /*521*/ { function_entry, 0, 0, icache_illegal },
  /*522*/ { function_entry, 0, 0, icache_illegal },
  /*523*/ { function_entry, 0, 0, icache_illegal },
  /*524*/ { function_entry, 0, 0, icache_illegal },
  /*525*/ { function_entry, 0, 0, icache_illegal },
  /*526*/ { function_entry, 0, 0, icache_illegal },
  /*527*/ { function_entry, 0, 0, icache_illegal },
  /*528*/ { function_entry, 0, 0, icache_Floating_Absolute_Value_Rc0 },
  /*529*/ { function_entry, 0, 0, icache_Floating_Absolute_Value_Rc1 },
  /*530*/ { function_entry, 0, 0, icache_illegal },
  /*531*/ { function_entry, 0, 0, icache_illegal },
  /*532*/ { function_entry, 0, 0, icache_illegal },
  /*533*/ { function_entry, 0, 0, icache_illegal },
  /*534*/ { function_entry, 0, 0, icache_illegal },
  /*535*/ { function_entry, 0, 0, icache_illegal },
  /*536*/ { function_entry, 0, 0, icache_illegal },
  /*537*/ { function_entry, 0, 0, icache_illegal },
  /*538*/ { function_entry, 0, 0, icache_illegal },
  /*539*/ { function_entry, 0, 0, icache_illegal },
  /*540*/ { function_entry, 0, 0, icache_illegal },
  /*541*/ { function_entry, 0, 0, icache_illegal },
  /*542*/ { function_entry, 0, 0, icache_illegal },
  /*543*/ { function_entry, 0, 0, icache_illegal },
  /*544*/ { function_entry, 0, 0, icache_illegal },
  /*545*/ { function_entry, 0, 0, icache_illegal },
  /*546*/ { function_entry, 0, 0, icache_illegal },
  /*547*/ { function_entry, 0, 0, icache_illegal },
  /*548*/ { function_entry, 0, 0, icache_illegal },
  /*549*/ { function_entry, 0, 0, icache_illegal },
  /*550*/ { function_entry, 0, 0, icache_illegal },
  /*551*/ { function_entry, 0, 0, icache_illegal },
  /*552*/ { function_entry, 0, 0, icache_illegal },
  /*553*/ { function_entry, 0, 0, icache_illegal },
  /*554*/ { function_entry, 0, 0, icache_illegal },
  /*555*/ { function_entry, 0, 0, icache_illegal },
  /*556*/ { function_entry, 0, 0, icache_illegal },
  /*557*/ { function_entry, 0, 0, icache_illegal },
  /*558*/ { function_entry, 0, 0, icache_Floating_Select_FRC8_Rc0 },
  /*559*/ { function_entry, 0, 0, icache_Floating_Select_FRC8_Rc1 },
  /*560*/ { function_entry, 0, 0, icache_illegal },
  /*561*/ { function_entry, 0, 0, icache_illegal },
  /*562*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC8_Rc0 },
  /*563*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC8_Rc1 },
  /*564*/ { function_entry, 0, 0, icache_illegal },
  /*565*/ { function_entry, 0, 0, icache_illegal },
  /*566*/ { function_entry, 0, 0, icache_illegal },
  /*567*/ { function_entry, 0, 0, icache_illegal },
  /*568*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC8_Rc0 },
  /*569*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC8_Rc1 },
  /*570*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC8_Rc0 },
  /*571*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC8_Rc1 },
  /*572*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC8_Rc0 },
  /*573*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC8_Rc1 },
  /*574*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC8_Rc0 },
  /*575*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC8_Rc1 },
  /*576*/ { function_entry, 0, 0, icache_illegal },
  /*577*/ { function_entry, 0, 0, icache_illegal },
  /*578*/ { function_entry, 0, 0, icache_illegal },
  /*579*/ { function_entry, 0, 0, icache_illegal },
  /*580*/ { function_entry, 0, 0, icache_illegal },
  /*581*/ { function_entry, 0, 0, icache_illegal },
  /*582*/ { function_entry, 0, 0, icache_illegal },
  /*583*/ { function_entry, 0, 0, icache_illegal },
  /*584*/ { function_entry, 0, 0, icache_illegal },
  /*585*/ { function_entry, 0, 0, icache_illegal },
  /*586*/ { function_entry, 0, 0, icache_illegal },
  /*587*/ { function_entry, 0, 0, icache_illegal },
  /*588*/ { function_entry, 0, 0, icache_illegal },
  /*589*/ { function_entry, 0, 0, icache_illegal },
  /*590*/ { function_entry, 0, 0, icache_illegal },
  /*591*/ { function_entry, 0, 0, icache_illegal },
  /*592*/ { function_entry, 0, 0, icache_illegal },
  /*593*/ { function_entry, 0, 0, icache_illegal },
  /*594*/ { function_entry, 0, 0, icache_illegal },
  /*595*/ { function_entry, 0, 0, icache_illegal },
  /*596*/ { function_entry, 0, 0, icache_illegal },
  /*597*/ { function_entry, 0, 0, icache_illegal },
  /*598*/ { function_entry, 0, 0, icache_illegal },
  /*599*/ { function_entry, 0, 0, icache_illegal },
  /*600*/ { function_entry, 0, 0, icache_illegal },
  /*601*/ { function_entry, 0, 0, icache_illegal },
  /*602*/ { function_entry, 0, 0, icache_illegal },
  /*603*/ { function_entry, 0, 0, icache_illegal },
  /*604*/ { function_entry, 0, 0, icache_illegal },
  /*605*/ { function_entry, 0, 0, icache_illegal },
  /*606*/ { function_entry, 0, 0, icache_illegal },
  /*607*/ { function_entry, 0, 0, icache_illegal },
  /*608*/ { function_entry, 0, 0, icache_illegal },
  /*609*/ { function_entry, 0, 0, icache_illegal },
  /*610*/ { function_entry, 0, 0, icache_illegal },
  /*611*/ { function_entry, 0, 0, icache_illegal },
  /*612*/ { function_entry, 0, 0, icache_illegal },
  /*613*/ { function_entry, 0, 0, icache_illegal },
  /*614*/ { function_entry, 0, 0, icache_illegal },
  /*615*/ { function_entry, 0, 0, icache_illegal },
  /*616*/ { function_entry, 0, 0, icache_illegal },
  /*617*/ { function_entry, 0, 0, icache_illegal },
  /*618*/ { function_entry, 0, 0, icache_illegal },
  /*619*/ { function_entry, 0, 0, icache_illegal },
  /*620*/ { function_entry, 0, 0, icache_illegal },
  /*621*/ { function_entry, 0, 0, icache_illegal },
  /*622*/ { function_entry, 0, 0, icache_Floating_Select_FRC9_Rc0 },
  /*623*/ { function_entry, 0, 0, icache_Floating_Select_FRC9_Rc1 },
  /*624*/ { function_entry, 0, 0, icache_illegal },
  /*625*/ { function_entry, 0, 0, icache_illegal },
  /*626*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC9_Rc0 },
  /*627*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC9_Rc1 },
  /*628*/ { function_entry, 0, 0, icache_illegal },
  /*629*/ { function_entry, 0, 0, icache_illegal },
  /*630*/ { function_entry, 0, 0, icache_illegal },
  /*631*/ { function_entry, 0, 0, icache_illegal },
  /*632*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC9_Rc0 },
  /*633*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC9_Rc1 },
  /*634*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC9_Rc0 },
  /*635*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC9_Rc1 },
  /*636*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC9_Rc0 },
  /*637*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC9_Rc1 },
  /*638*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC9_Rc0 },
  /*639*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC9_Rc1 },
  /*640*/ { function_entry, 0, 0, icache_illegal },
  /*641*/ { function_entry, 0, 0, icache_illegal },
  /*642*/ { function_entry, 0, 0, icache_illegal },
  /*643*/ { function_entry, 0, 0, icache_illegal },
  /*644*/ { function_entry, 0, 0, icache_illegal },
  /*645*/ { function_entry, 0, 0, icache_illegal },
  /*646*/ { function_entry, 0, 0, icache_illegal },
  /*647*/ { function_entry, 0, 0, icache_illegal },
  /*648*/ { function_entry, 0, 0, icache_illegal },
  /*649*/ { function_entry, 0, 0, icache_illegal },
  /*650*/ { function_entry, 0, 0, icache_illegal },
  /*651*/ { function_entry, 0, 0, icache_illegal },
  /*652*/ { function_entry, 0, 0, icache_illegal },
  /*653*/ { function_entry, 0, 0, icache_illegal },
  /*654*/ { function_entry, 0, 0, icache_illegal },
  /*655*/ { function_entry, 0, 0, icache_illegal },
  /*656*/ { function_entry, 0, 0, icache_illegal },
  /*657*/ { function_entry, 0, 0, icache_illegal },
  /*658*/ { function_entry, 0, 0, icache_illegal },
  /*659*/ { function_entry, 0, 0, icache_illegal },
  /*660*/ { function_entry, 0, 0, icache_illegal },
  /*661*/ { function_entry, 0, 0, icache_illegal },
  /*662*/ { function_entry, 0, 0, icache_illegal },
  /*663*/ { function_entry, 0, 0, icache_illegal },
  /*664*/ { function_entry, 0, 0, icache_illegal },
  /*665*/ { function_entry, 0, 0, icache_illegal },
  /*666*/ { function_entry, 0, 0, icache_illegal },
  /*667*/ { function_entry, 0, 0, icache_illegal },
  /*668*/ { function_entry, 0, 0, icache_illegal },
  /*669*/ { function_entry, 0, 0, icache_illegal },
  /*670*/ { function_entry, 0, 0, icache_illegal },
  /*671*/ { function_entry, 0, 0, icache_illegal },
  /*672*/ { function_entry, 0, 0, icache_illegal },
  /*673*/ { function_entry, 0, 0, icache_illegal },
  /*674*/ { function_entry, 0, 0, icache_illegal },
  /*675*/ { function_entry, 0, 0, icache_illegal },
  /*676*/ { function_entry, 0, 0, icache_illegal },
  /*677*/ { function_entry, 0, 0, icache_illegal },
  /*678*/ { function_entry, 0, 0, icache_illegal },
  /*679*/ { function_entry, 0, 0, icache_illegal },
  /*680*/ { function_entry, 0, 0, icache_illegal },
  /*681*/ { function_entry, 0, 0, icache_illegal },
  /*682*/ { function_entry, 0, 0, icache_illegal },
  /*683*/ { function_entry, 0, 0, icache_illegal },
  /*684*/ { function_entry, 0, 0, icache_illegal },
  /*685*/ { function_entry, 0, 0, icache_illegal },
  /*686*/ { function_entry, 0, 0, icache_Floating_Select_FRC10_Rc0 },
  /*687*/ { function_entry, 0, 0, icache_Floating_Select_FRC10_Rc1 },
  /*688*/ { function_entry, 0, 0, icache_illegal },
  /*689*/ { function_entry, 0, 0, icache_illegal },
  /*690*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC10_Rc0 },
  /*691*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC10_Rc1 },
  /*692*/ { function_entry, 0, 0, icache_illegal },
  /*693*/ { function_entry, 0, 0, icache_illegal },
  /*694*/ { function_entry, 0, 0, icache_illegal },
  /*695*/ { function_entry, 0, 0, icache_illegal },
  /*696*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC10_Rc0 },
  /*697*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC10_Rc1 },
  /*698*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC10_Rc0 },
  /*699*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC10_Rc1 },
  /*700*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC10_Rc0 },
  /*701*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC10_Rc1 },
  /*702*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC10_Rc0 },
  /*703*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC10_Rc1 },
  /*704*/ { function_entry, 0, 0, icache_illegal },
  /*705*/ { function_entry, 0, 0, icache_illegal },
  /*706*/ { function_entry, 0, 0, icache_illegal },
  /*707*/ { function_entry, 0, 0, icache_illegal },
  /*708*/ { function_entry, 0, 0, icache_illegal },
  /*709*/ { function_entry, 0, 0, icache_illegal },
  /*710*/ { function_entry, 0, 0, icache_illegal },
  /*711*/ { function_entry, 0, 0, icache_illegal },
  /*712*/ { function_entry, 0, 0, icache_illegal },
  /*713*/ { function_entry, 0, 0, icache_illegal },
  /*714*/ { function_entry, 0, 0, icache_illegal },
  /*715*/ { function_entry, 0, 0, icache_illegal },
  /*716*/ { function_entry, 0, 0, icache_illegal },
  /*717*/ { function_entry, 0, 0, icache_illegal },
  /*718*/ { function_entry, 0, 0, icache_illegal },
  /*719*/ { function_entry, 0, 0, icache_illegal },
  /*720*/ { function_entry, 0, 0, icache_illegal },
  /*721*/ { function_entry, 0, 0, icache_illegal },
  /*722*/ { function_entry, 0, 0, icache_illegal },
  /*723*/ { function_entry, 0, 0, icache_illegal },
  /*724*/ { function_entry, 0, 0, icache_illegal },
  /*725*/ { function_entry, 0, 0, icache_illegal },
  /*726*/ { function_entry, 0, 0, icache_illegal },
  /*727*/ { function_entry, 0, 0, icache_illegal },
  /*728*/ { function_entry, 0, 0, icache_illegal },
  /*729*/ { function_entry, 0, 0, icache_illegal },
  /*730*/ { function_entry, 0, 0, icache_illegal },
  /*731*/ { function_entry, 0, 0, icache_illegal },
  /*732*/ { function_entry, 0, 0, icache_illegal },
  /*733*/ { function_entry, 0, 0, icache_illegal },
  /*734*/ { function_entry, 0, 0, icache_illegal },
  /*735*/ { function_entry, 0, 0, icache_illegal },
  /*736*/ { function_entry, 0, 0, icache_illegal },
  /*737*/ { function_entry, 0, 0, icache_illegal },
  /*738*/ { function_entry, 0, 0, icache_illegal },
  /*739*/ { function_entry, 0, 0, icache_illegal },
  /*740*/ { function_entry, 0, 0, icache_illegal },
  /*741*/ { function_entry, 0, 0, icache_illegal },
  /*742*/ { function_entry, 0, 0, icache_illegal },
  /*743*/ { function_entry, 0, 0, icache_illegal },
  /*744*/ { function_entry, 0, 0, icache_illegal },
  /*745*/ { function_entry, 0, 0, icache_illegal },
  /*746*/ { function_entry, 0, 0, icache_illegal },
  /*747*/ { function_entry, 0, 0, icache_illegal },
  /*748*/ { function_entry, 0, 0, icache_illegal },
  /*749*/ { function_entry, 0, 0, icache_illegal },
  /*750*/ { function_entry, 0, 0, icache_Floating_Select_FRC11_Rc0 },
  /*751*/ { function_entry, 0, 0, icache_Floating_Select_FRC11_Rc1 },
  /*752*/ { function_entry, 0, 0, icache_illegal },
  /*753*/ { function_entry, 0, 0, icache_illegal },
  /*754*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC11_Rc0 },
  /*755*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC11_Rc1 },
  /*756*/ { function_entry, 0, 0, icache_illegal },
  /*757*/ { function_entry, 0, 0, icache_illegal },
  /*758*/ { function_entry, 0, 0, icache_illegal },
  /*759*/ { function_entry, 0, 0, icache_illegal },
  /*760*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC11_Rc0 },
  /*761*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC11_Rc1 },
  /*762*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC11_Rc0 },
  /*763*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC11_Rc1 },
  /*764*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC11_Rc0 },
  /*765*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC11_Rc1 },
  /*766*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC11_Rc0 },
  /*767*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC11_Rc1 },
  /*768*/ { function_entry, 0, 0, icache_illegal },
  /*769*/ { function_entry, 0, 0, icache_illegal },
  /*770*/ { function_entry, 0, 0, icache_illegal },
  /*771*/ { function_entry, 0, 0, icache_illegal },
  /*772*/ { function_entry, 0, 0, icache_illegal },
  /*773*/ { function_entry, 0, 0, icache_illegal },
  /*774*/ { function_entry, 0, 0, icache_illegal },
  /*775*/ { function_entry, 0, 0, icache_illegal },
  /*776*/ { function_entry, 0, 0, icache_illegal },
  /*777*/ { function_entry, 0, 0, icache_illegal },
  /*778*/ { function_entry, 0, 0, icache_illegal },
  /*779*/ { function_entry, 0, 0, icache_illegal },
  /*780*/ { function_entry, 0, 0, icache_illegal },
  /*781*/ { function_entry, 0, 0, icache_illegal },
  /*782*/ { function_entry, 0, 0, icache_illegal },
  /*783*/ { function_entry, 0, 0, icache_illegal },
  /*784*/ { function_entry, 0, 0, icache_illegal },
  /*785*/ { function_entry, 0, 0, icache_illegal },
  /*786*/ { function_entry, 0, 0, icache_illegal },
  /*787*/ { function_entry, 0, 0, icache_illegal },
  /*788*/ { function_entry, 0, 0, icache_illegal },
  /*789*/ { function_entry, 0, 0, icache_illegal },
  /*790*/ { function_entry, 0, 0, icache_illegal },
  /*791*/ { function_entry, 0, 0, icache_illegal },
  /*792*/ { function_entry, 0, 0, icache_illegal },
  /*793*/ { function_entry, 0, 0, icache_illegal },
  /*794*/ { function_entry, 0, 0, icache_illegal },
  /*795*/ { function_entry, 0, 0, icache_illegal },
  /*796*/ { function_entry, 0, 0, icache_illegal },
  /*797*/ { function_entry, 0, 0, icache_illegal },
  /*798*/ { function_entry, 0, 0, icache_illegal },
  /*799*/ { function_entry, 0, 0, icache_illegal },
  /*800*/ { function_entry, 0, 0, icache_illegal },
  /*801*/ { function_entry, 0, 0, icache_illegal },
  /*802*/ { function_entry, 0, 0, icache_illegal },
  /*803*/ { function_entry, 0, 0, icache_illegal },
  /*804*/ { function_entry, 0, 0, icache_illegal },
  /*805*/ { function_entry, 0, 0, icache_illegal },
  /*806*/ { function_entry, 0, 0, icache_illegal },
  /*807*/ { function_entry, 0, 0, icache_illegal },
  /*808*/ { function_entry, 0, 0, icache_illegal },
  /*809*/ { function_entry, 0, 0, icache_illegal },
  /*810*/ { function_entry, 0, 0, icache_illegal },
  /*811*/ { function_entry, 0, 0, icache_illegal },
  /*812*/ { function_entry, 0, 0, icache_illegal },
  /*813*/ { function_entry, 0, 0, icache_illegal },
  /*814*/ { function_entry, 0, 0, icache_Floating_Select_FRC12_Rc0 },
  /*815*/ { function_entry, 0, 0, icache_Floating_Select_FRC12_Rc1 },
  /*816*/ { function_entry, 0, 0, icache_illegal },
  /*817*/ { function_entry, 0, 0, icache_illegal },
  /*818*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC12_Rc0 },
  /*819*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC12_Rc1 },
  /*820*/ { function_entry, 0, 0, icache_illegal },
  /*821*/ { function_entry, 0, 0, icache_illegal },
  /*822*/ { function_entry, 0, 0, icache_illegal },
  /*823*/ { function_entry, 0, 0, icache_illegal },
  /*824*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC12_Rc0 },
  /*825*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC12_Rc1 },
  /*826*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC12_Rc0 },
  /*827*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC12_Rc1 },
  /*828*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC12_Rc0 },
  /*829*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC12_Rc1 },
  /*830*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC12_Rc0 },
  /*831*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC12_Rc1 },
  /*832*/ { function_entry, 0, 0, icache_illegal },
  /*833*/ { function_entry, 0, 0, icache_illegal },
  /*834*/ { function_entry, 0, 0, icache_illegal },
  /*835*/ { function_entry, 0, 0, icache_illegal },
  /*836*/ { function_entry, 0, 0, icache_illegal },
  /*837*/ { function_entry, 0, 0, icache_illegal },
  /*838*/ { function_entry, 0, 0, icache_illegal },
  /*839*/ { function_entry, 0, 0, icache_illegal },
  /*840*/ { function_entry, 0, 0, icache_illegal },
  /*841*/ { function_entry, 0, 0, icache_illegal },
  /*842*/ { function_entry, 0, 0, icache_illegal },
  /*843*/ { function_entry, 0, 0, icache_illegal },
  /*844*/ { function_entry, 0, 0, icache_illegal },
  /*845*/ { function_entry, 0, 0, icache_illegal },
  /*846*/ { function_entry, 0, 0, icache_illegal },
  /*847*/ { function_entry, 0, 0, icache_illegal },
  /*848*/ { function_entry, 0, 0, icache_illegal },
  /*849*/ { function_entry, 0, 0, icache_illegal },
  /*850*/ { function_entry, 0, 0, icache_illegal },
  /*851*/ { function_entry, 0, 0, icache_illegal },
  /*852*/ { function_entry, 0, 0, icache_illegal },
  /*853*/ { function_entry, 0, 0, icache_illegal },
  /*854*/ { function_entry, 0, 0, icache_illegal },
  /*855*/ { function_entry, 0, 0, icache_illegal },
  /*856*/ { function_entry, 0, 0, icache_illegal },
  /*857*/ { function_entry, 0, 0, icache_illegal },
  /*858*/ { function_entry, 0, 0, icache_illegal },
  /*859*/ { function_entry, 0, 0, icache_illegal },
  /*860*/ { function_entry, 0, 0, icache_illegal },
  /*861*/ { function_entry, 0, 0, icache_illegal },
  /*862*/ { function_entry, 0, 0, icache_illegal },
  /*863*/ { function_entry, 0, 0, icache_illegal },
  /*864*/ { function_entry, 0, 0, icache_illegal },
  /*865*/ { function_entry, 0, 0, icache_illegal },
  /*866*/ { function_entry, 0, 0, icache_illegal },
  /*867*/ { function_entry, 0, 0, icache_illegal },
  /*868*/ { function_entry, 0, 0, icache_illegal },
  /*869*/ { function_entry, 0, 0, icache_illegal },
  /*870*/ { function_entry, 0, 0, icache_illegal },
  /*871*/ { function_entry, 0, 0, icache_illegal },
  /*872*/ { function_entry, 0, 0, icache_illegal },
  /*873*/ { function_entry, 0, 0, icache_illegal },
  /*874*/ { function_entry, 0, 0, icache_illegal },
  /*875*/ { function_entry, 0, 0, icache_illegal },
  /*876*/ { function_entry, 0, 0, icache_illegal },
  /*877*/ { function_entry, 0, 0, icache_illegal },
  /*878*/ { function_entry, 0, 0, icache_Floating_Select_FRC13_Rc0 },
  /*879*/ { function_entry, 0, 0, icache_Floating_Select_FRC13_Rc1 },
  /*880*/ { function_entry, 0, 0, icache_illegal },
  /*881*/ { function_entry, 0, 0, icache_illegal },
  /*882*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC13_Rc0 },
  /*883*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC13_Rc1 },
  /*884*/ { function_entry, 0, 0, icache_illegal },
  /*885*/ { function_entry, 0, 0, icache_illegal },
  /*886*/ { function_entry, 0, 0, icache_illegal },
  /*887*/ { function_entry, 0, 0, icache_illegal },
  /*888*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC13_Rc0 },
  /*889*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC13_Rc1 },
  /*890*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC13_Rc0 },
  /*891*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC13_Rc1 },
  /*892*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC13_Rc0 },
  /*893*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC13_Rc1 },
  /*894*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC13_Rc0 },
  /*895*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC13_Rc1 },
  /*896*/ { function_entry, 0, 0, icache_illegal },
  /*897*/ { function_entry, 0, 0, icache_illegal },
  /*898*/ { function_entry, 0, 0, icache_illegal },
  /*899*/ { function_entry, 0, 0, icache_illegal },
  /*900*/ { function_entry, 0, 0, icache_illegal },
  /*901*/ { function_entry, 0, 0, icache_illegal },
  /*902*/ { function_entry, 0, 0, icache_illegal },
  /*903*/ { function_entry, 0, 0, icache_illegal },
  /*904*/ { function_entry, 0, 0, icache_illegal },
  /*905*/ { function_entry, 0, 0, icache_illegal },
  /*906*/ { function_entry, 0, 0, icache_illegal },
  /*907*/ { function_entry, 0, 0, icache_illegal },
  /*908*/ { function_entry, 0, 0, icache_illegal },
  /*909*/ { function_entry, 0, 0, icache_illegal },
  /*910*/ { function_entry, 0, 0, icache_illegal },
  /*911*/ { function_entry, 0, 0, icache_illegal },
  /*912*/ { function_entry, 0, 0, icache_illegal },
  /*913*/ { function_entry, 0, 0, icache_illegal },
  /*914*/ { function_entry, 0, 0, icache_illegal },
  /*915*/ { function_entry, 0, 0, icache_illegal },
  /*916*/ { function_entry, 0, 0, icache_illegal },
  /*917*/ { function_entry, 0, 0, icache_illegal },
  /*918*/ { function_entry, 0, 0, icache_illegal },
  /*919*/ { function_entry, 0, 0, icache_illegal },
  /*920*/ { function_entry, 0, 0, icache_illegal },
  /*921*/ { function_entry, 0, 0, icache_illegal },
  /*922*/ { function_entry, 0, 0, icache_illegal },
  /*923*/ { function_entry, 0, 0, icache_illegal },
  /*924*/ { function_entry, 0, 0, icache_illegal },
  /*925*/ { function_entry, 0, 0, icache_illegal },
  /*926*/ { function_entry, 0, 0, icache_illegal },
  /*927*/ { function_entry, 0, 0, icache_illegal },
  /*928*/ { function_entry, 0, 0, icache_illegal },
  /*929*/ { function_entry, 0, 0, icache_illegal },
  /*930*/ { function_entry, 0, 0, icache_illegal },
  /*931*/ { function_entry, 0, 0, icache_illegal },
  /*932*/ { function_entry, 0, 0, icache_illegal },
  /*933*/ { function_entry, 0, 0, icache_illegal },
  /*934*/ { function_entry, 0, 0, icache_illegal },
  /*935*/ { function_entry, 0, 0, icache_illegal },
  /*936*/ { function_entry, 0, 0, icache_illegal },
  /*937*/ { function_entry, 0, 0, icache_illegal },
  /*938*/ { function_entry, 0, 0, icache_illegal },
  /*939*/ { function_entry, 0, 0, icache_illegal },
  /*940*/ { function_entry, 0, 0, icache_illegal },
  /*941*/ { function_entry, 0, 0, icache_illegal },
  /*942*/ { function_entry, 0, 0, icache_Floating_Select_FRC14_Rc0 },
  /*943*/ { function_entry, 0, 0, icache_Floating_Select_FRC14_Rc1 },
  /*944*/ { function_entry, 0, 0, icache_illegal },
  /*945*/ { function_entry, 0, 0, icache_illegal },
  /*946*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC14_Rc0 },
  /*947*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC14_Rc1 },
  /*948*/ { function_entry, 0, 0, icache_illegal },
  /*949*/ { function_entry, 0, 0, icache_illegal },
  /*950*/ { function_entry, 0, 0, icache_illegal },
  /*951*/ { function_entry, 0, 0, icache_illegal },
  /*952*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC14_Rc0 },
  /*953*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC14_Rc1 },
  /*954*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC14_Rc0 },
  /*955*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC14_Rc1 },
  /*956*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC14_Rc0 },
  /*957*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC14_Rc1 },
  /*958*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC14_Rc0 },
  /*959*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC14_Rc1 },
  /*960*/ { function_entry, 0, 0, icache_illegal },
  /*961*/ { function_entry, 0, 0, icache_illegal },
  /*962*/ { function_entry, 0, 0, icache_illegal },
  /*963*/ { function_entry, 0, 0, icache_illegal },
  /*964*/ { function_entry, 0, 0, icache_illegal },
  /*965*/ { function_entry, 0, 0, icache_illegal },
  /*966*/ { function_entry, 0, 0, icache_illegal },
  /*967*/ { function_entry, 0, 0, icache_illegal },
  /*968*/ { function_entry, 0, 0, icache_illegal },
  /*969*/ { function_entry, 0, 0, icache_illegal },
  /*970*/ { function_entry, 0, 0, icache_illegal },
  /*971*/ { function_entry, 0, 0, icache_illegal },
  /*972*/ { function_entry, 0, 0, icache_illegal },
  /*973*/ { function_entry, 0, 0, icache_illegal },
  /*974*/ { function_entry, 0, 0, icache_illegal },
  /*975*/ { function_entry, 0, 0, icache_illegal },
  /*976*/ { function_entry, 0, 0, icache_illegal },
  /*977*/ { function_entry, 0, 0, icache_illegal },
  /*978*/ { function_entry, 0, 0, icache_illegal },
  /*979*/ { function_entry, 0, 0, icache_illegal },
  /*980*/ { function_entry, 0, 0, icache_illegal },
  /*981*/ { function_entry, 0, 0, icache_illegal },
  /*982*/ { function_entry, 0, 0, icache_illegal },
  /*983*/ { function_entry, 0, 0, icache_illegal },
  /*984*/ { function_entry, 0, 0, icache_illegal },
  /*985*/ { function_entry, 0, 0, icache_illegal },
  /*986*/ { function_entry, 0, 0, icache_illegal },
  /*987*/ { function_entry, 0, 0, icache_illegal },
  /*988*/ { function_entry, 0, 0, icache_illegal },
  /*989*/ { function_entry, 0, 0, icache_illegal },
  /*990*/ { function_entry, 0, 0, icache_illegal },
  /*991*/ { function_entry, 0, 0, icache_illegal },
  /*992*/ { function_entry, 0, 0, icache_illegal },
  /*993*/ { function_entry, 0, 0, icache_illegal },
  /*994*/ { function_entry, 0, 0, icache_illegal },
  /*995*/ { function_entry, 0, 0, icache_illegal },
  /*996*/ { function_entry, 0, 0, icache_illegal },
  /*997*/ { function_entry, 0, 0, icache_illegal },
  /*998*/ { function_entry, 0, 0, icache_illegal },
  /*999*/ { function_entry, 0, 0, icache_illegal },
  /*1000*/ { function_entry, 0, 0, icache_illegal },
  /*1001*/ { function_entry, 0, 0, icache_illegal },
  /*1002*/ { function_entry, 0, 0, icache_illegal },
  /*1003*/ { function_entry, 0, 0, icache_illegal },
  /*1004*/ { function_entry, 0, 0, icache_illegal },
  /*1005*/ { function_entry, 0, 0, icache_illegal },
  /*1006*/ { function_entry, 0, 0, icache_Floating_Select_FRC15_Rc0 },
  /*1007*/ { function_entry, 0, 0, icache_Floating_Select_FRC15_Rc1 },
  /*1008*/ { function_entry, 0, 0, icache_illegal },
  /*1009*/ { function_entry, 0, 0, icache_illegal },
  /*1010*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC15_Rc0 },
  /*1011*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC15_Rc1 },
  /*1012*/ { function_entry, 0, 0, icache_illegal },
  /*1013*/ { function_entry, 0, 0, icache_illegal },
  /*1014*/ { function_entry, 0, 0, icache_illegal },
  /*1015*/ { function_entry, 0, 0, icache_illegal },
  /*1016*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC15_Rc0 },
  /*1017*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC15_Rc1 },
  /*1018*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC15_Rc0 },
  /*1019*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC15_Rc1 },
  /*1020*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC15_Rc0 },
  /*1021*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC15_Rc1 },
  /*1022*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC15_Rc0 },
  /*1023*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC15_Rc1 },
  /*1024*/ { function_entry, 0, 0, icache_illegal },
  /*1025*/ { function_entry, 0, 0, icache_illegal },
  /*1026*/ { function_entry, 0, 0, icache_illegal },
  /*1027*/ { function_entry, 0, 0, icache_illegal },
  /*1028*/ { function_entry, 0, 0, icache_illegal },
  /*1029*/ { function_entry, 0, 0, icache_illegal },
  /*1030*/ { function_entry, 0, 0, icache_illegal },
  /*1031*/ { function_entry, 0, 0, icache_illegal },
  /*1032*/ { function_entry, 0, 0, icache_illegal },
  /*1033*/ { function_entry, 0, 0, icache_illegal },
  /*1034*/ { function_entry, 0, 0, icache_illegal },
  /*1035*/ { function_entry, 0, 0, icache_illegal },
  /*1036*/ { function_entry, 0, 0, icache_illegal },
  /*1037*/ { function_entry, 0, 0, icache_illegal },
  /*1038*/ { function_entry, 0, 0, icache_illegal },
  /*1039*/ { function_entry, 0, 0, icache_illegal },
  /*1040*/ { function_entry, 0, 0, icache_illegal },
  /*1041*/ { function_entry, 0, 0, icache_illegal },
  /*1042*/ { function_entry, 0, 0, icache_illegal },
  /*1043*/ { function_entry, 0, 0, icache_illegal },
  /*1044*/ { function_entry, 0, 0, icache_illegal },
  /*1045*/ { function_entry, 0, 0, icache_illegal },
  /*1046*/ { function_entry, 0, 0, icache_illegal },
  /*1047*/ { function_entry, 0, 0, icache_illegal },
  /*1048*/ { function_entry, 0, 0, icache_illegal },
  /*1049*/ { function_entry, 0, 0, icache_illegal },
  /*1050*/ { function_entry, 0, 0, icache_illegal },
  /*1051*/ { function_entry, 0, 0, icache_illegal },
  /*1052*/ { function_entry, 0, 0, icache_illegal },
  /*1053*/ { function_entry, 0, 0, icache_illegal },
  /*1054*/ { function_entry, 0, 0, icache_illegal },
  /*1055*/ { function_entry, 0, 0, icache_illegal },
  /*1056*/ { function_entry, 0, 0, icache_illegal },
  /*1057*/ { function_entry, 0, 0, icache_illegal },
  /*1058*/ { function_entry, 0, 0, icache_illegal },
  /*1059*/ { function_entry, 0, 0, icache_illegal },
  /*1060*/ { function_entry, 0, 0, icache_illegal },
  /*1061*/ { function_entry, 0, 0, icache_illegal },
  /*1062*/ { function_entry, 0, 0, icache_illegal },
  /*1063*/ { function_entry, 0, 0, icache_illegal },
  /*1064*/ { function_entry, 0, 0, icache_illegal },
  /*1065*/ { function_entry, 0, 0, icache_illegal },
  /*1066*/ { function_entry, 0, 0, icache_illegal },
  /*1067*/ { function_entry, 0, 0, icache_illegal },
  /*1068*/ { function_entry, 0, 0, icache_illegal },
  /*1069*/ { function_entry, 0, 0, icache_illegal },
  /*1070*/ { function_entry, 0, 0, icache_Floating_Select_FRC16_Rc0 },
  /*1071*/ { function_entry, 0, 0, icache_Floating_Select_FRC16_Rc1 },
  /*1072*/ { function_entry, 0, 0, icache_illegal },
  /*1073*/ { function_entry, 0, 0, icache_illegal },
  /*1074*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC16_Rc0 },
  /*1075*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC16_Rc1 },
  /*1076*/ { function_entry, 0, 0, icache_illegal },
  /*1077*/ { function_entry, 0, 0, icache_illegal },
  /*1078*/ { function_entry, 0, 0, icache_illegal },
  /*1079*/ { function_entry, 0, 0, icache_illegal },
  /*1080*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC16_Rc0 },
  /*1081*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC16_Rc1 },
  /*1082*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC16_Rc0 },
  /*1083*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC16_Rc1 },
  /*1084*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC16_Rc0 },
  /*1085*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC16_Rc1 },
  /*1086*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC16_Rc0 },
  /*1087*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC16_Rc1 },
  /*1088*/ { function_entry, 0, 0, icache_illegal },
  /*1089*/ { function_entry, 0, 0, icache_illegal },
  /*1090*/ { function_entry, 0, 0, icache_illegal },
  /*1091*/ { function_entry, 0, 0, icache_illegal },
  /*1092*/ { function_entry, 0, 0, icache_illegal },
  /*1093*/ { function_entry, 0, 0, icache_illegal },
  /*1094*/ { function_entry, 0, 0, icache_illegal },
  /*1095*/ { function_entry, 0, 0, icache_illegal },
  /*1096*/ { function_entry, 0, 0, icache_illegal },
  /*1097*/ { function_entry, 0, 0, icache_illegal },
  /*1098*/ { function_entry, 0, 0, icache_illegal },
  /*1099*/ { function_entry, 0, 0, icache_illegal },
  /*1100*/ { function_entry, 0, 0, icache_illegal },
  /*1101*/ { function_entry, 0, 0, icache_illegal },
  /*1102*/ { function_entry, 0, 0, icache_illegal },
  /*1103*/ { function_entry, 0, 0, icache_illegal },
  /*1104*/ { function_entry, 0, 0, icache_illegal },
  /*1105*/ { function_entry, 0, 0, icache_illegal },
  /*1106*/ { function_entry, 0, 0, icache_illegal },
  /*1107*/ { function_entry, 0, 0, icache_illegal },
  /*1108*/ { function_entry, 0, 0, icache_illegal },
  /*1109*/ { function_entry, 0, 0, icache_illegal },
  /*1110*/ { function_entry, 0, 0, icache_illegal },
  /*1111*/ { function_entry, 0, 0, icache_illegal },
  /*1112*/ { function_entry, 0, 0, icache_illegal },
  /*1113*/ { function_entry, 0, 0, icache_illegal },
  /*1114*/ { function_entry, 0, 0, icache_illegal },
  /*1115*/ { function_entry, 0, 0, icache_illegal },
  /*1116*/ { function_entry, 0, 0, icache_illegal },
  /*1117*/ { function_entry, 0, 0, icache_illegal },
  /*1118*/ { function_entry, 0, 0, icache_illegal },
  /*1119*/ { function_entry, 0, 0, icache_illegal },
  /*1120*/ { function_entry, 0, 0, icache_illegal },
  /*1121*/ { function_entry, 0, 0, icache_illegal },
  /*1122*/ { function_entry, 0, 0, icache_illegal },
  /*1123*/ { function_entry, 0, 0, icache_illegal },
  /*1124*/ { function_entry, 0, 0, icache_illegal },
  /*1125*/ { function_entry, 0, 0, icache_illegal },
  /*1126*/ { function_entry, 0, 0, icache_illegal },
  /*1127*/ { function_entry, 0, 0, icache_illegal },
  /*1128*/ { function_entry, 0, 0, icache_illegal },
  /*1129*/ { function_entry, 0, 0, icache_illegal },
  /*1130*/ { function_entry, 0, 0, icache_illegal },
  /*1131*/ { function_entry, 0, 0, icache_illegal },
  /*1132*/ { function_entry, 0, 0, icache_illegal },
  /*1133*/ { function_entry, 0, 0, icache_illegal },
  /*1134*/ { function_entry, 0, 0, icache_Floating_Select_FRC17_Rc0 },
  /*1135*/ { function_entry, 0, 0, icache_Floating_Select_FRC17_Rc1 },
  /*1136*/ { function_entry, 0, 0, icache_illegal },
  /*1137*/ { function_entry, 0, 0, icache_illegal },
  /*1138*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC17_Rc0 },
  /*1139*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC17_Rc1 },
  /*1140*/ { function_entry, 0, 0, icache_illegal },
  /*1141*/ { function_entry, 0, 0, icache_illegal },
  /*1142*/ { function_entry, 0, 0, icache_illegal },
  /*1143*/ { function_entry, 0, 0, icache_illegal },
  /*1144*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC17_Rc0 },
  /*1145*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC17_Rc1 },
  /*1146*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC17_Rc0 },
  /*1147*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC17_Rc1 },
  /*1148*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC17_Rc0 },
  /*1149*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC17_Rc1 },
  /*1150*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC17_Rc0 },
  /*1151*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC17_Rc1 },
  /*1152*/ { function_entry, 0, 0, icache_illegal },
  /*1153*/ { function_entry, 0, 0, icache_illegal },
  /*1154*/ { function_entry, 0, 0, icache_illegal },
  /*1155*/ { function_entry, 0, 0, icache_illegal },
  /*1156*/ { function_entry, 0, 0, icache_illegal },
  /*1157*/ { function_entry, 0, 0, icache_illegal },
  /*1158*/ { function_entry, 0, 0, icache_illegal },
  /*1159*/ { function_entry, 0, 0, icache_illegal },
  /*1160*/ { function_entry, 0, 0, icache_illegal },
  /*1161*/ { function_entry, 0, 0, icache_illegal },
  /*1162*/ { function_entry, 0, 0, icache_illegal },
  /*1163*/ { function_entry, 0, 0, icache_illegal },
  /*1164*/ { function_entry, 0, 0, icache_illegal },
  /*1165*/ { function_entry, 0, 0, icache_illegal },
  /*1166*/ { function_entry, 0, 0, icache_Move_From_FPSCR_Rc0 },
  /*1167*/ { function_entry, 0, 0, icache_Move_From_FPSCR_Rc1 },
  /*1168*/ { function_entry, 0, 0, icache_illegal },
  /*1169*/ { function_entry, 0, 0, icache_illegal },
  /*1170*/ { function_entry, 0, 0, icache_illegal },
  /*1171*/ { function_entry, 0, 0, icache_illegal },
  /*1172*/ { function_entry, 0, 0, icache_illegal },
  /*1173*/ { function_entry, 0, 0, icache_illegal },
  /*1174*/ { function_entry, 0, 0, icache_illegal },
  /*1175*/ { function_entry, 0, 0, icache_illegal },
  /*1176*/ { function_entry, 0, 0, icache_illegal },
  /*1177*/ { function_entry, 0, 0, icache_illegal },
  /*1178*/ { function_entry, 0, 0, icache_illegal },
  /*1179*/ { function_entry, 0, 0, icache_illegal },
  /*1180*/ { function_entry, 0, 0, icache_illegal },
  /*1181*/ { function_entry, 0, 0, icache_illegal },
  /*1182*/ { function_entry, 0, 0, icache_illegal },
  /*1183*/ { function_entry, 0, 0, icache_illegal },
  /*1184*/ { function_entry, 0, 0, icache_illegal },
  /*1185*/ { function_entry, 0, 0, icache_illegal },
  /*1186*/ { function_entry, 0, 0, icache_illegal },
  /*1187*/ { function_entry, 0, 0, icache_illegal },
  /*1188*/ { function_entry, 0, 0, icache_illegal },
  /*1189*/ { function_entry, 0, 0, icache_illegal },
  /*1190*/ { function_entry, 0, 0, icache_illegal },
  /*1191*/ { function_entry, 0, 0, icache_illegal },
  /*1192*/ { function_entry, 0, 0, icache_illegal },
  /*1193*/ { function_entry, 0, 0, icache_illegal },
  /*1194*/ { function_entry, 0, 0, icache_illegal },
  /*1195*/ { function_entry, 0, 0, icache_illegal },
  /*1196*/ { function_entry, 0, 0, icache_illegal },
  /*1197*/ { function_entry, 0, 0, icache_illegal },
  /*1198*/ { function_entry, 0, 0, icache_Floating_Select_FRC18_Rc0 },
  /*1199*/ { function_entry, 0, 0, icache_Floating_Select_FRC18_Rc1 },
  /*1200*/ { function_entry, 0, 0, icache_illegal },
  /*1201*/ { function_entry, 0, 0, icache_illegal },
  /*1202*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC18_Rc0 },
  /*1203*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC18_Rc1 },
  /*1204*/ { function_entry, 0, 0, icache_illegal },
  /*1205*/ { function_entry, 0, 0, icache_illegal },
  /*1206*/ { function_entry, 0, 0, icache_illegal },
  /*1207*/ { function_entry, 0, 0, icache_illegal },
  /*1208*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC18_Rc0 },
  /*1209*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC18_Rc1 },
  /*1210*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC18_Rc0 },
  /*1211*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC18_Rc1 },
  /*1212*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC18_Rc0 },
  /*1213*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC18_Rc1 },
  /*1214*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC18_Rc0 },
  /*1215*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC18_Rc1 },
  /*1216*/ { function_entry, 0, 0, icache_illegal },
  /*1217*/ { function_entry, 0, 0, icache_illegal },
  /*1218*/ { function_entry, 0, 0, icache_illegal },
  /*1219*/ { function_entry, 0, 0, icache_illegal },
  /*1220*/ { function_entry, 0, 0, icache_illegal },
  /*1221*/ { function_entry, 0, 0, icache_illegal },
  /*1222*/ { function_entry, 0, 0, icache_illegal },
  /*1223*/ { function_entry, 0, 0, icache_illegal },
  /*1224*/ { function_entry, 0, 0, icache_illegal },
  /*1225*/ { function_entry, 0, 0, icache_illegal },
  /*1226*/ { function_entry, 0, 0, icache_illegal },
  /*1227*/ { function_entry, 0, 0, icache_illegal },
  /*1228*/ { function_entry, 0, 0, icache_illegal },
  /*1229*/ { function_entry, 0, 0, icache_illegal },
  /*1230*/ { function_entry, 0, 0, icache_illegal },
  /*1231*/ { function_entry, 0, 0, icache_illegal },
  /*1232*/ { function_entry, 0, 0, icache_illegal },
  /*1233*/ { function_entry, 0, 0, icache_illegal },
  /*1234*/ { function_entry, 0, 0, icache_illegal },
  /*1235*/ { function_entry, 0, 0, icache_illegal },
  /*1236*/ { function_entry, 0, 0, icache_illegal },
  /*1237*/ { function_entry, 0, 0, icache_illegal },
  /*1238*/ { function_entry, 0, 0, icache_illegal },
  /*1239*/ { function_entry, 0, 0, icache_illegal },
  /*1240*/ { function_entry, 0, 0, icache_illegal },
  /*1241*/ { function_entry, 0, 0, icache_illegal },
  /*1242*/ { function_entry, 0, 0, icache_illegal },
  /*1243*/ { function_entry, 0, 0, icache_illegal },
  /*1244*/ { function_entry, 0, 0, icache_illegal },
  /*1245*/ { function_entry, 0, 0, icache_illegal },
  /*1246*/ { function_entry, 0, 0, icache_illegal },
  /*1247*/ { function_entry, 0, 0, icache_illegal },
  /*1248*/ { function_entry, 0, 0, icache_illegal },
  /*1249*/ { function_entry, 0, 0, icache_illegal },
  /*1250*/ { function_entry, 0, 0, icache_illegal },
  /*1251*/ { function_entry, 0, 0, icache_illegal },
  /*1252*/ { function_entry, 0, 0, icache_illegal },
  /*1253*/ { function_entry, 0, 0, icache_illegal },
  /*1254*/ { function_entry, 0, 0, icache_illegal },
  /*1255*/ { function_entry, 0, 0, icache_illegal },
  /*1256*/ { function_entry, 0, 0, icache_illegal },
  /*1257*/ { function_entry, 0, 0, icache_illegal },
  /*1258*/ { function_entry, 0, 0, icache_illegal },
  /*1259*/ { function_entry, 0, 0, icache_illegal },
  /*1260*/ { function_entry, 0, 0, icache_illegal },
  /*1261*/ { function_entry, 0, 0, icache_illegal },
  /*1262*/ { function_entry, 0, 0, icache_Floating_Select_FRC19_Rc0 },
  /*1263*/ { function_entry, 0, 0, icache_Floating_Select_FRC19_Rc1 },
  /*1264*/ { function_entry, 0, 0, icache_illegal },
  /*1265*/ { function_entry, 0, 0, icache_illegal },
  /*1266*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC19_Rc0 },
  /*1267*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC19_Rc1 },
  /*1268*/ { function_entry, 0, 0, icache_illegal },
  /*1269*/ { function_entry, 0, 0, icache_illegal },
  /*1270*/ { function_entry, 0, 0, icache_illegal },
  /*1271*/ { function_entry, 0, 0, icache_illegal },
  /*1272*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC19_Rc0 },
  /*1273*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC19_Rc1 },
  /*1274*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC19_Rc0 },
  /*1275*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC19_Rc1 },
  /*1276*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC19_Rc0 },
  /*1277*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC19_Rc1 },
  /*1278*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC19_Rc0 },
  /*1279*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC19_Rc1 },
  /*1280*/ { function_entry, 0, 0, icache_illegal },
  /*1281*/ { function_entry, 0, 0, icache_illegal },
  /*1282*/ { function_entry, 0, 0, icache_illegal },
  /*1283*/ { function_entry, 0, 0, icache_illegal },
  /*1284*/ { function_entry, 0, 0, icache_illegal },
  /*1285*/ { function_entry, 0, 0, icache_illegal },
  /*1286*/ { function_entry, 0, 0, icache_illegal },
  /*1287*/ { function_entry, 0, 0, icache_illegal },
  /*1288*/ { function_entry, 0, 0, icache_illegal },
  /*1289*/ { function_entry, 0, 0, icache_illegal },
  /*1290*/ { function_entry, 0, 0, icache_illegal },
  /*1291*/ { function_entry, 0, 0, icache_illegal },
  /*1292*/ { function_entry, 0, 0, icache_illegal },
  /*1293*/ { function_entry, 0, 0, icache_illegal },
  /*1294*/ { function_entry, 0, 0, icache_illegal },
  /*1295*/ { function_entry, 0, 0, icache_illegal },
  /*1296*/ { function_entry, 0, 0, icache_illegal },
  /*1297*/ { function_entry, 0, 0, icache_illegal },
  /*1298*/ { function_entry, 0, 0, icache_illegal },
  /*1299*/ { function_entry, 0, 0, icache_illegal },
  /*1300*/ { function_entry, 0, 0, icache_illegal },
  /*1301*/ { function_entry, 0, 0, icache_illegal },
  /*1302*/ { function_entry, 0, 0, icache_illegal },
  /*1303*/ { function_entry, 0, 0, icache_illegal },
  /*1304*/ { function_entry, 0, 0, icache_illegal },
  /*1305*/ { function_entry, 0, 0, icache_illegal },
  /*1306*/ { function_entry, 0, 0, icache_illegal },
  /*1307*/ { function_entry, 0, 0, icache_illegal },
  /*1308*/ { function_entry, 0, 0, icache_illegal },
  /*1309*/ { function_entry, 0, 0, icache_illegal },
  /*1310*/ { function_entry, 0, 0, icache_illegal },
  /*1311*/ { function_entry, 0, 0, icache_illegal },
  /*1312*/ { function_entry, 0, 0, icache_illegal },
  /*1313*/ { function_entry, 0, 0, icache_illegal },
  /*1314*/ { function_entry, 0, 0, icache_illegal },
  /*1315*/ { function_entry, 0, 0, icache_illegal },
  /*1316*/ { function_entry, 0, 0, icache_illegal },
  /*1317*/ { function_entry, 0, 0, icache_illegal },
  /*1318*/ { function_entry, 0, 0, icache_illegal },
  /*1319*/ { function_entry, 0, 0, icache_illegal },
  /*1320*/ { function_entry, 0, 0, icache_illegal },
  /*1321*/ { function_entry, 0, 0, icache_illegal },
  /*1322*/ { function_entry, 0, 0, icache_illegal },
  /*1323*/ { function_entry, 0, 0, icache_illegal },
  /*1324*/ { function_entry, 0, 0, icache_illegal },
  /*1325*/ { function_entry, 0, 0, icache_illegal },
  /*1326*/ { function_entry, 0, 0, icache_Floating_Select_FRC20_Rc0 },
  /*1327*/ { function_entry, 0, 0, icache_Floating_Select_FRC20_Rc1 },
  /*1328*/ { function_entry, 0, 0, icache_illegal },
  /*1329*/ { function_entry, 0, 0, icache_illegal },
  /*1330*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC20_Rc0 },
  /*1331*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC20_Rc1 },
  /*1332*/ { function_entry, 0, 0, icache_illegal },
  /*1333*/ { function_entry, 0, 0, icache_illegal },
  /*1334*/ { function_entry, 0, 0, icache_illegal },
  /*1335*/ { function_entry, 0, 0, icache_illegal },
  /*1336*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC20_Rc0 },
  /*1337*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC20_Rc1 },
  /*1338*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC20_Rc0 },
  /*1339*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC20_Rc1 },
  /*1340*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC20_Rc0 },
  /*1341*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC20_Rc1 },
  /*1342*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC20_Rc0 },
  /*1343*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC20_Rc1 },
  /*1344*/ { function_entry, 0, 0, icache_illegal },
  /*1345*/ { function_entry, 0, 0, icache_illegal },
  /*1346*/ { function_entry, 0, 0, icache_illegal },
  /*1347*/ { function_entry, 0, 0, icache_illegal },
  /*1348*/ { function_entry, 0, 0, icache_illegal },
  /*1349*/ { function_entry, 0, 0, icache_illegal },
  /*1350*/ { function_entry, 0, 0, icache_illegal },
  /*1351*/ { function_entry, 0, 0, icache_illegal },
  /*1352*/ { function_entry, 0, 0, icache_illegal },
  /*1353*/ { function_entry, 0, 0, icache_illegal },
  /*1354*/ { function_entry, 0, 0, icache_illegal },
  /*1355*/ { function_entry, 0, 0, icache_illegal },
  /*1356*/ { function_entry, 0, 0, icache_illegal },
  /*1357*/ { function_entry, 0, 0, icache_illegal },
  /*1358*/ { function_entry, 0, 0, icache_illegal },
  /*1359*/ { function_entry, 0, 0, icache_illegal },
  /*1360*/ { function_entry, 0, 0, icache_illegal },
  /*1361*/ { function_entry, 0, 0, icache_illegal },
  /*1362*/ { function_entry, 0, 0, icache_illegal },
  /*1363*/ { function_entry, 0, 0, icache_illegal },
  /*1364*/ { function_entry, 0, 0, icache_illegal },
  /*1365*/ { function_entry, 0, 0, icache_illegal },
  /*1366*/ { function_entry, 0, 0, icache_illegal },
  /*1367*/ { function_entry, 0, 0, icache_illegal },
  /*1368*/ { function_entry, 0, 0, icache_illegal },
  /*1369*/ { function_entry, 0, 0, icache_illegal },
  /*1370*/ { function_entry, 0, 0, icache_illegal },
  /*1371*/ { function_entry, 0, 0, icache_illegal },
  /*1372*/ { function_entry, 0, 0, icache_illegal },
  /*1373*/ { function_entry, 0, 0, icache_illegal },
  /*1374*/ { function_entry, 0, 0, icache_illegal },
  /*1375*/ { function_entry, 0, 0, icache_illegal },
  /*1376*/ { function_entry, 0, 0, icache_illegal },
  /*1377*/ { function_entry, 0, 0, icache_illegal },
  /*1378*/ { function_entry, 0, 0, icache_illegal },
  /*1379*/ { function_entry, 0, 0, icache_illegal },
  /*1380*/ { function_entry, 0, 0, icache_illegal },
  /*1381*/ { function_entry, 0, 0, icache_illegal },
  /*1382*/ { function_entry, 0, 0, icache_illegal },
  /*1383*/ { function_entry, 0, 0, icache_illegal },
  /*1384*/ { function_entry, 0, 0, icache_illegal },
  /*1385*/ { function_entry, 0, 0, icache_illegal },
  /*1386*/ { function_entry, 0, 0, icache_illegal },
  /*1387*/ { function_entry, 0, 0, icache_illegal },
  /*1388*/ { function_entry, 0, 0, icache_illegal },
  /*1389*/ { function_entry, 0, 0, icache_illegal },
  /*1390*/ { function_entry, 0, 0, icache_Floating_Select_FRC21_Rc0 },
  /*1391*/ { function_entry, 0, 0, icache_Floating_Select_FRC21_Rc1 },
  /*1392*/ { function_entry, 0, 0, icache_illegal },
  /*1393*/ { function_entry, 0, 0, icache_illegal },
  /*1394*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC21_Rc0 },
  /*1395*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC21_Rc1 },
  /*1396*/ { function_entry, 0, 0, icache_illegal },
  /*1397*/ { function_entry, 0, 0, icache_illegal },
  /*1398*/ { function_entry, 0, 0, icache_illegal },
  /*1399*/ { function_entry, 0, 0, icache_illegal },
  /*1400*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC21_Rc0 },
  /*1401*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC21_Rc1 },
  /*1402*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC21_Rc0 },
  /*1403*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC21_Rc1 },
  /*1404*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC21_Rc0 },
  /*1405*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC21_Rc1 },
  /*1406*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC21_Rc0 },
  /*1407*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC21_Rc1 },
  /*1408*/ { function_entry, 0, 0, icache_illegal },
  /*1409*/ { function_entry, 0, 0, icache_illegal },
  /*1410*/ { function_entry, 0, 0, icache_illegal },
  /*1411*/ { function_entry, 0, 0, icache_illegal },
  /*1412*/ { function_entry, 0, 0, icache_illegal },
  /*1413*/ { function_entry, 0, 0, icache_illegal },
  /*1414*/ { function_entry, 0, 0, icache_illegal },
  /*1415*/ { function_entry, 0, 0, icache_illegal },
  /*1416*/ { function_entry, 0, 0, icache_illegal },
  /*1417*/ { function_entry, 0, 0, icache_illegal },
  /*1418*/ { function_entry, 0, 0, icache_illegal },
  /*1419*/ { function_entry, 0, 0, icache_illegal },
  /*1420*/ { function_entry, 0, 0, icache_illegal },
  /*1421*/ { function_entry, 0, 0, icache_illegal },
  /*1422*/ { function_entry, 0, 0, icache_Move_To_FPSCR_Fields_Rc0 },
  /*1423*/ { function_entry, 0, 0, icache_Move_To_FPSCR_Fields_Rc1 },
  /*1424*/ { function_entry, 0, 0, icache_illegal },
  /*1425*/ { function_entry, 0, 0, icache_illegal },
  /*1426*/ { function_entry, 0, 0, icache_illegal },
  /*1427*/ { function_entry, 0, 0, icache_illegal },
  /*1428*/ { function_entry, 0, 0, icache_illegal },
  /*1429*/ { function_entry, 0, 0, icache_illegal },
  /*1430*/ { function_entry, 0, 0, icache_illegal },
  /*1431*/ { function_entry, 0, 0, icache_illegal },
  /*1432*/ { function_entry, 0, 0, icache_illegal },
  /*1433*/ { function_entry, 0, 0, icache_illegal },
  /*1434*/ { function_entry, 0, 0, icache_illegal },
  /*1435*/ { function_entry, 0, 0, icache_illegal },
  /*1436*/ { function_entry, 0, 0, icache_illegal },
  /*1437*/ { function_entry, 0, 0, icache_illegal },
  /*1438*/ { function_entry, 0, 0, icache_illegal },
  /*1439*/ { function_entry, 0, 0, icache_illegal },
  /*1440*/ { function_entry, 0, 0, icache_illegal },
  /*1441*/ { function_entry, 0, 0, icache_illegal },
  /*1442*/ { function_entry, 0, 0, icache_illegal },
  /*1443*/ { function_entry, 0, 0, icache_illegal },
  /*1444*/ { function_entry, 0, 0, icache_illegal },
  /*1445*/ { function_entry, 0, 0, icache_illegal },
  /*1446*/ { function_entry, 0, 0, icache_illegal },
  /*1447*/ { function_entry, 0, 0, icache_illegal },
  /*1448*/ { function_entry, 0, 0, icache_illegal },
  /*1449*/ { function_entry, 0, 0, icache_illegal },
  /*1450*/ { function_entry, 0, 0, icache_illegal },
  /*1451*/ { function_entry, 0, 0, icache_illegal },
  /*1452*/ { function_entry, 0, 0, icache_illegal },
  /*1453*/ { function_entry, 0, 0, icache_illegal },
  /*1454*/ { function_entry, 0, 0, icache_Floating_Select_FRC22_Rc0 },
  /*1455*/ { function_entry, 0, 0, icache_Floating_Select_FRC22_Rc1 },
  /*1456*/ { function_entry, 0, 0, icache_illegal },
  /*1457*/ { function_entry, 0, 0, icache_illegal },
  /*1458*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC22_Rc0 },
  /*1459*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC22_Rc1 },
  /*1460*/ { function_entry, 0, 0, icache_illegal },
  /*1461*/ { function_entry, 0, 0, icache_illegal },
  /*1462*/ { function_entry, 0, 0, icache_illegal },
  /*1463*/ { function_entry, 0, 0, icache_illegal },
  /*1464*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC22_Rc0 },
  /*1465*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC22_Rc1 },
  /*1466*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC22_Rc0 },
  /*1467*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC22_Rc1 },
  /*1468*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC22_Rc0 },
  /*1469*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC22_Rc1 },
  /*1470*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC22_Rc0 },
  /*1471*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC22_Rc1 },
  /*1472*/ { function_entry, 0, 0, icache_illegal },
  /*1473*/ { function_entry, 0, 0, icache_illegal },
  /*1474*/ { function_entry, 0, 0, icache_illegal },
  /*1475*/ { function_entry, 0, 0, icache_illegal },
  /*1476*/ { function_entry, 0, 0, icache_illegal },
  /*1477*/ { function_entry, 0, 0, icache_illegal },
  /*1478*/ { function_entry, 0, 0, icache_illegal },
  /*1479*/ { function_entry, 0, 0, icache_illegal },
  /*1480*/ { function_entry, 0, 0, icache_illegal },
  /*1481*/ { function_entry, 0, 0, icache_illegal },
  /*1482*/ { function_entry, 0, 0, icache_illegal },
  /*1483*/ { function_entry, 0, 0, icache_illegal },
  /*1484*/ { function_entry, 0, 0, icache_illegal },
  /*1485*/ { function_entry, 0, 0, icache_illegal },
  /*1486*/ { function_entry, 0, 0, icache_illegal },
  /*1487*/ { function_entry, 0, 0, icache_illegal },
  /*1488*/ { function_entry, 0, 0, icache_illegal },
  /*1489*/ { function_entry, 0, 0, icache_illegal },
  /*1490*/ { function_entry, 0, 0, icache_illegal },
  /*1491*/ { function_entry, 0, 0, icache_illegal },
  /*1492*/ { function_entry, 0, 0, icache_illegal },
  /*1493*/ { function_entry, 0, 0, icache_illegal },
  /*1494*/ { function_entry, 0, 0, icache_illegal },
  /*1495*/ { function_entry, 0, 0, icache_illegal },
  /*1496*/ { function_entry, 0, 0, icache_illegal },
  /*1497*/ { function_entry, 0, 0, icache_illegal },
  /*1498*/ { function_entry, 0, 0, icache_illegal },
  /*1499*/ { function_entry, 0, 0, icache_illegal },
  /*1500*/ { function_entry, 0, 0, icache_illegal },
  /*1501*/ { function_entry, 0, 0, icache_illegal },
  /*1502*/ { function_entry, 0, 0, icache_illegal },
  /*1503*/ { function_entry, 0, 0, icache_illegal },
  /*1504*/ { function_entry, 0, 0, icache_illegal },
  /*1505*/ { function_entry, 0, 0, icache_illegal },
  /*1506*/ { function_entry, 0, 0, icache_illegal },
  /*1507*/ { function_entry, 0, 0, icache_illegal },
  /*1508*/ { function_entry, 0, 0, icache_illegal },
  /*1509*/ { function_entry, 0, 0, icache_illegal },
  /*1510*/ { function_entry, 0, 0, icache_illegal },
  /*1511*/ { function_entry, 0, 0, icache_illegal },
  /*1512*/ { function_entry, 0, 0, icache_illegal },
  /*1513*/ { function_entry, 0, 0, icache_illegal },
  /*1514*/ { function_entry, 0, 0, icache_illegal },
  /*1515*/ { function_entry, 0, 0, icache_illegal },
  /*1516*/ { function_entry, 0, 0, icache_illegal },
  /*1517*/ { function_entry, 0, 0, icache_illegal },
  /*1518*/ { function_entry, 0, 0, icache_Floating_Select_FRC23_Rc0 },
  /*1519*/ { function_entry, 0, 0, icache_Floating_Select_FRC23_Rc1 },
  /*1520*/ { function_entry, 0, 0, icache_illegal },
  /*1521*/ { function_entry, 0, 0, icache_illegal },
  /*1522*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC23_Rc0 },
  /*1523*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC23_Rc1 },
  /*1524*/ { function_entry, 0, 0, icache_illegal },
  /*1525*/ { function_entry, 0, 0, icache_illegal },
  /*1526*/ { function_entry, 0, 0, icache_illegal },
  /*1527*/ { function_entry, 0, 0, icache_illegal },
  /*1528*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC23_Rc0 },
  /*1529*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC23_Rc1 },
  /*1530*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC23_Rc0 },
  /*1531*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC23_Rc1 },
  /*1532*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC23_Rc0 },
  /*1533*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC23_Rc1 },
  /*1534*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC23_Rc0 },
  /*1535*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC23_Rc1 },
  /*1536*/ { function_entry, 0, 0, icache_illegal },
  /*1537*/ { function_entry, 0, 0, icache_illegal },
  /*1538*/ { function_entry, 0, 0, icache_illegal },
  /*1539*/ { function_entry, 0, 0, icache_illegal },
  /*1540*/ { function_entry, 0, 0, icache_illegal },
  /*1541*/ { function_entry, 0, 0, icache_illegal },
  /*1542*/ { function_entry, 0, 0, icache_illegal },
  /*1543*/ { function_entry, 0, 0, icache_illegal },
  /*1544*/ { function_entry, 0, 0, icache_illegal },
  /*1545*/ { function_entry, 0, 0, icache_illegal },
  /*1546*/ { function_entry, 0, 0, icache_illegal },
  /*1547*/ { function_entry, 0, 0, icache_illegal },
  /*1548*/ { function_entry, 0, 0, icache_illegal },
  /*1549*/ { function_entry, 0, 0, icache_illegal },
  /*1550*/ { function_entry, 0, 0, icache_illegal },
  /*1551*/ { function_entry, 0, 0, icache_illegal },
  /*1552*/ { function_entry, 0, 0, icache_illegal },
  /*1553*/ { function_entry, 0, 0, icache_illegal },
  /*1554*/ { function_entry, 0, 0, icache_illegal },
  /*1555*/ { function_entry, 0, 0, icache_illegal },
  /*1556*/ { function_entry, 0, 0, icache_illegal },
  /*1557*/ { function_entry, 0, 0, icache_illegal },
  /*1558*/ { function_entry, 0, 0, icache_illegal },
  /*1559*/ { function_entry, 0, 0, icache_illegal },
  /*1560*/ { function_entry, 0, 0, icache_illegal },
  /*1561*/ { function_entry, 0, 0, icache_illegal },
  /*1562*/ { function_entry, 0, 0, icache_illegal },
  /*1563*/ { function_entry, 0, 0, icache_illegal },
  /*1564*/ { function_entry, 0, 0, icache_illegal },
  /*1565*/ { function_entry, 0, 0, icache_illegal },
  /*1566*/ { function_entry, 0, 0, icache_illegal },
  /*1567*/ { function_entry, 0, 0, icache_illegal },
  /*1568*/ { function_entry, 0, 0, icache_illegal },
  /*1569*/ { function_entry, 0, 0, icache_illegal },
  /*1570*/ { function_entry, 0, 0, icache_illegal },
  /*1571*/ { function_entry, 0, 0, icache_illegal },
  /*1572*/ { function_entry, 0, 0, icache_illegal },
  /*1573*/ { function_entry, 0, 0, icache_illegal },
  /*1574*/ { function_entry, 0, 0, icache_illegal },
  /*1575*/ { function_entry, 0, 0, icache_illegal },
  /*1576*/ { function_entry, 0, 0, icache_illegal },
  /*1577*/ { function_entry, 0, 0, icache_illegal },
  /*1578*/ { function_entry, 0, 0, icache_illegal },
  /*1579*/ { function_entry, 0, 0, icache_illegal },
  /*1580*/ { function_entry, 0, 0, icache_illegal },
  /*1581*/ { function_entry, 0, 0, icache_illegal },
  /*1582*/ { function_entry, 0, 0, icache_Floating_Select_FRC24_Rc0 },
  /*1583*/ { function_entry, 0, 0, icache_Floating_Select_FRC24_Rc1 },
  /*1584*/ { function_entry, 0, 0, icache_illegal },
  /*1585*/ { function_entry, 0, 0, icache_illegal },
  /*1586*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC24_Rc0 },
  /*1587*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC24_Rc1 },
  /*1588*/ { function_entry, 0, 0, icache_illegal },
  /*1589*/ { function_entry, 0, 0, icache_illegal },
  /*1590*/ { function_entry, 0, 0, icache_illegal },
  /*1591*/ { function_entry, 0, 0, icache_illegal },
  /*1592*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC24_Rc0 },
  /*1593*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC24_Rc1 },
  /*1594*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC24_Rc0 },
  /*1595*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC24_Rc1 },
  /*1596*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC24_Rc0 },
  /*1597*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC24_Rc1 },
  /*1598*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC24_Rc0 },
  /*1599*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC24_Rc1 },
  /*1600*/ { function_entry, 0, 0, icache_illegal },
  /*1601*/ { function_entry, 0, 0, icache_illegal },
  /*1602*/ { function_entry, 0, 0, icache_illegal },
  /*1603*/ { function_entry, 0, 0, icache_illegal },
  /*1604*/ { function_entry, 0, 0, icache_illegal },
  /*1605*/ { function_entry, 0, 0, icache_illegal },
  /*1606*/ { function_entry, 0, 0, icache_illegal },
  /*1607*/ { function_entry, 0, 0, icache_illegal },
  /*1608*/ { function_entry, 0, 0, icache_illegal },
  /*1609*/ { function_entry, 0, 0, icache_illegal },
  /*1610*/ { function_entry, 0, 0, icache_illegal },
  /*1611*/ { function_entry, 0, 0, icache_illegal },
  /*1612*/ { function_entry, 0, 0, icache_illegal },
  /*1613*/ { function_entry, 0, 0, icache_illegal },
  /*1614*/ { function_entry, 0, 0, icache_illegal },
  /*1615*/ { function_entry, 0, 0, icache_illegal },
  /*1616*/ { function_entry, 0, 0, icache_illegal },
  /*1617*/ { function_entry, 0, 0, icache_illegal },
  /*1618*/ { function_entry, 0, 0, icache_illegal },
  /*1619*/ { function_entry, 0, 0, icache_illegal },
  /*1620*/ { function_entry, 0, 0, icache_illegal },
  /*1621*/ { function_entry, 0, 0, icache_illegal },
  /*1622*/ { function_entry, 0, 0, icache_illegal },
  /*1623*/ { function_entry, 0, 0, icache_illegal },
  /*1624*/ { function_entry, 0, 0, icache_illegal },
  /*1625*/ { function_entry, 0, 0, icache_illegal },
  /*1626*/ { function_entry, 0, 0, icache_illegal },
  /*1627*/ { function_entry, 0, 0, icache_illegal },
  /*1628*/ { function_entry, 0, 0, icache_illegal },
  /*1629*/ { function_entry, 0, 0, icache_illegal },
  /*1630*/ { function_entry, 0, 0, icache_illegal },
  /*1631*/ { function_entry, 0, 0, icache_illegal },
  /*1632*/ { function_entry, 0, 0, icache_illegal },
  /*1633*/ { function_entry, 0, 0, icache_illegal },
  /*1634*/ { function_entry, 0, 0, icache_illegal },
  /*1635*/ { function_entry, 0, 0, icache_illegal },
  /*1636*/ { function_entry, 0, 0, icache_illegal },
  /*1637*/ { function_entry, 0, 0, icache_illegal },
  /*1638*/ { function_entry, 0, 0, icache_illegal },
  /*1639*/ { function_entry, 0, 0, icache_illegal },
  /*1640*/ { function_entry, 0, 0, icache_illegal },
  /*1641*/ { function_entry, 0, 0, icache_illegal },
  /*1642*/ { function_entry, 0, 0, icache_illegal },
  /*1643*/ { function_entry, 0, 0, icache_illegal },
  /*1644*/ { function_entry, 0, 0, icache_illegal },
  /*1645*/ { function_entry, 0, 0, icache_illegal },
  /*1646*/ { function_entry, 0, 0, icache_Floating_Select_FRC25_Rc0 },
  /*1647*/ { function_entry, 0, 0, icache_Floating_Select_FRC25_Rc1 },
  /*1648*/ { function_entry, 0, 0, icache_illegal },
  /*1649*/ { function_entry, 0, 0, icache_illegal },
  /*1650*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC25_Rc0 },
  /*1651*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC25_Rc1 },
  /*1652*/ { function_entry, 0, 0, icache_illegal },
  /*1653*/ { function_entry, 0, 0, icache_illegal },
  /*1654*/ { function_entry, 0, 0, icache_illegal },
  /*1655*/ { function_entry, 0, 0, icache_illegal },
  /*1656*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC25_Rc0 },
  /*1657*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC25_Rc1 },
  /*1658*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC25_Rc0 },
  /*1659*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC25_Rc1 },
  /*1660*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC25_Rc0 },
  /*1661*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC25_Rc1 },
  /*1662*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC25_Rc0 },
  /*1663*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC25_Rc1 },
  /*1664*/ { function_entry, 0, 0, icache_illegal },
  /*1665*/ { function_entry, 0, 0, icache_illegal },
  /*1666*/ { function_entry, 0, 0, icache_illegal },
  /*1667*/ { function_entry, 0, 0, icache_illegal },
  /*1668*/ { function_entry, 0, 0, icache_illegal },
  /*1669*/ { function_entry, 0, 0, icache_illegal },
  /*1670*/ { function_entry, 0, 0, icache_illegal },
  /*1671*/ { function_entry, 0, 0, icache_illegal },
  /*1672*/ { function_entry, 0, 0, icache_illegal },
  /*1673*/ { function_entry, 0, 0, icache_illegal },
  /*1674*/ { function_entry, 0, 0, icache_illegal },
  /*1675*/ { function_entry, 0, 0, icache_illegal },
  /*1676*/ { function_entry, 0, 0, icache_illegal },
  /*1677*/ { function_entry, 0, 0, icache_illegal },
  /*1678*/ { function_entry, 0, 0, icache_illegal },
  /*1679*/ { function_entry, 0, 0, icache_illegal },
  /*1680*/ { function_entry, 0, 0, icache_illegal },
  /*1681*/ { function_entry, 0, 0, icache_illegal },
  /*1682*/ { function_entry, 0, 0, icache_illegal },
  /*1683*/ { function_entry, 0, 0, icache_illegal },
  /*1684*/ { function_entry, 0, 0, icache_illegal },
  /*1685*/ { function_entry, 0, 0, icache_illegal },
  /*1686*/ { function_entry, 0, 0, icache_illegal },
  /*1687*/ { function_entry, 0, 0, icache_illegal },
  /*1688*/ { function_entry, 0, 0, icache_illegal },
  /*1689*/ { function_entry, 0, 0, icache_illegal },
  /*1690*/ { function_entry, 0, 0, icache_illegal },
  /*1691*/ { function_entry, 0, 0, icache_illegal },
  /*1692*/ { function_entry, 0, 0, icache_illegal },
  /*1693*/ { function_entry, 0, 0, icache_illegal },
  /*1694*/ { function_entry, 0, 0, icache_illegal },
  /*1695*/ { function_entry, 0, 0, icache_illegal },
  /*1696*/ { function_entry, 0, 0, icache_illegal },
  /*1697*/ { function_entry, 0, 0, icache_illegal },
  /*1698*/ { function_entry, 0, 0, icache_illegal },
  /*1699*/ { function_entry, 0, 0, icache_illegal },
  /*1700*/ { function_entry, 0, 0, icache_illegal },
  /*1701*/ { function_entry, 0, 0, icache_illegal },
  /*1702*/ { function_entry, 0, 0, icache_illegal },
  /*1703*/ { function_entry, 0, 0, icache_illegal },
  /*1704*/ { function_entry, 0, 0, icache_illegal },
  /*1705*/ { function_entry, 0, 0, icache_illegal },
  /*1706*/ { function_entry, 0, 0, icache_illegal },
  /*1707*/ { function_entry, 0, 0, icache_illegal },
  /*1708*/ { function_entry, 0, 0, icache_illegal },
  /*1709*/ { function_entry, 0, 0, icache_illegal },
  /*1710*/ { function_entry, 0, 0, icache_Floating_Select_FRC26_Rc0 },
  /*1711*/ { function_entry, 0, 0, icache_Floating_Select_FRC26_Rc1 },
  /*1712*/ { function_entry, 0, 0, icache_illegal },
  /*1713*/ { function_entry, 0, 0, icache_illegal },
  /*1714*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC26_Rc0 },
  /*1715*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC26_Rc1 },
  /*1716*/ { function_entry, 0, 0, icache_illegal },
  /*1717*/ { function_entry, 0, 0, icache_illegal },
  /*1718*/ { function_entry, 0, 0, icache_illegal },
  /*1719*/ { function_entry, 0, 0, icache_illegal },
  /*1720*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC26_Rc0 },
  /*1721*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC26_Rc1 },
  /*1722*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC26_Rc0 },
  /*1723*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC26_Rc1 },
  /*1724*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC26_Rc0 },
  /*1725*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC26_Rc1 },
  /*1726*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC26_Rc0 },
  /*1727*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC26_Rc1 },
  /*1728*/ { function_entry, 0, 0, icache_illegal },
  /*1729*/ { function_entry, 0, 0, icache_illegal },
  /*1730*/ { function_entry, 0, 0, icache_illegal },
  /*1731*/ { function_entry, 0, 0, icache_illegal },
  /*1732*/ { function_entry, 0, 0, icache_illegal },
  /*1733*/ { function_entry, 0, 0, icache_illegal },
  /*1734*/ { function_entry, 0, 0, icache_illegal },
  /*1735*/ { function_entry, 0, 0, icache_illegal },
  /*1736*/ { function_entry, 0, 0, icache_illegal },
  /*1737*/ { function_entry, 0, 0, icache_illegal },
  /*1738*/ { function_entry, 0, 0, icache_illegal },
  /*1739*/ { function_entry, 0, 0, icache_illegal },
  /*1740*/ { function_entry, 0, 0, icache_illegal },
  /*1741*/ { function_entry, 0, 0, icache_illegal },
  /*1742*/ { function_entry, 0, 0, icache_illegal },
  /*1743*/ { function_entry, 0, 0, icache_illegal },
  /*1744*/ { function_entry, 0, 0, icache_illegal },
  /*1745*/ { function_entry, 0, 0, icache_illegal },
  /*1746*/ { function_entry, 0, 0, icache_illegal },
  /*1747*/ { function_entry, 0, 0, icache_illegal },
  /*1748*/ { function_entry, 0, 0, icache_illegal },
  /*1749*/ { function_entry, 0, 0, icache_illegal },
  /*1750*/ { function_entry, 0, 0, icache_illegal },
  /*1751*/ { function_entry, 0, 0, icache_illegal },
  /*1752*/ { function_entry, 0, 0, icache_illegal },
  /*1753*/ { function_entry, 0, 0, icache_illegal },
  /*1754*/ { function_entry, 0, 0, icache_illegal },
  /*1755*/ { function_entry, 0, 0, icache_illegal },
  /*1756*/ { function_entry, 0, 0, icache_illegal },
  /*1757*/ { function_entry, 0, 0, icache_illegal },
  /*1758*/ { function_entry, 0, 0, icache_illegal },
  /*1759*/ { function_entry, 0, 0, icache_illegal },
  /*1760*/ { function_entry, 0, 0, icache_illegal },
  /*1761*/ { function_entry, 0, 0, icache_illegal },
  /*1762*/ { function_entry, 0, 0, icache_illegal },
  /*1763*/ { function_entry, 0, 0, icache_illegal },
  /*1764*/ { function_entry, 0, 0, icache_illegal },
  /*1765*/ { function_entry, 0, 0, icache_illegal },
  /*1766*/ { function_entry, 0, 0, icache_illegal },
  /*1767*/ { function_entry, 0, 0, icache_illegal },
  /*1768*/ { function_entry, 0, 0, icache_illegal },
  /*1769*/ { function_entry, 0, 0, icache_illegal },
  /*1770*/ { function_entry, 0, 0, icache_illegal },
  /*1771*/ { function_entry, 0, 0, icache_illegal },
  /*1772*/ { function_entry, 0, 0, icache_illegal },
  /*1773*/ { function_entry, 0, 0, icache_illegal },
  /*1774*/ { function_entry, 0, 0, icache_Floating_Select_FRC27_Rc0 },
  /*1775*/ { function_entry, 0, 0, icache_Floating_Select_FRC27_Rc1 },
  /*1776*/ { function_entry, 0, 0, icache_illegal },
  /*1777*/ { function_entry, 0, 0, icache_illegal },
  /*1778*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC27_Rc0 },
  /*1779*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC27_Rc1 },
  /*1780*/ { function_entry, 0, 0, icache_illegal },
  /*1781*/ { function_entry, 0, 0, icache_illegal },
  /*1782*/ { function_entry, 0, 0, icache_illegal },
  /*1783*/ { function_entry, 0, 0, icache_illegal },
  /*1784*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC27_Rc0 },
  /*1785*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC27_Rc1 },
  /*1786*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC27_Rc0 },
  /*1787*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC27_Rc1 },
  /*1788*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC27_Rc0 },
  /*1789*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC27_Rc1 },
  /*1790*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC27_Rc0 },
  /*1791*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC27_Rc1 },
  /*1792*/ { function_entry, 0, 0, icache_illegal },
  /*1793*/ { function_entry, 0, 0, icache_illegal },
  /*1794*/ { function_entry, 0, 0, icache_illegal },
  /*1795*/ { function_entry, 0, 0, icache_illegal },
  /*1796*/ { function_entry, 0, 0, icache_illegal },
  /*1797*/ { function_entry, 0, 0, icache_illegal },
  /*1798*/ { function_entry, 0, 0, icache_illegal },
  /*1799*/ { function_entry, 0, 0, icache_illegal },
  /*1800*/ { function_entry, 0, 0, icache_illegal },
  /*1801*/ { function_entry, 0, 0, icache_illegal },
  /*1802*/ { function_entry, 0, 0, icache_illegal },
  /*1803*/ { function_entry, 0, 0, icache_illegal },
  /*1804*/ { function_entry, 0, 0, icache_illegal },
  /*1805*/ { function_entry, 0, 0, icache_illegal },
  /*1806*/ { function_entry, 0, 0, icache_illegal },
  /*1807*/ { function_entry, 0, 0, icache_illegal },
  /*1808*/ { function_entry, 0, 0, icache_illegal },
  /*1809*/ { function_entry, 0, 0, icache_illegal },
  /*1810*/ { function_entry, 0, 0, icache_illegal },
  /*1811*/ { function_entry, 0, 0, icache_illegal },
  /*1812*/ { function_entry, 0, 0, icache_illegal },
  /*1813*/ { function_entry, 0, 0, icache_illegal },
  /*1814*/ { function_entry, 0, 0, icache_illegal },
  /*1815*/ { function_entry, 0, 0, icache_illegal },
  /*1816*/ { function_entry, 0, 0, icache_illegal },
  /*1817*/ { function_entry, 0, 0, icache_illegal },
  /*1818*/ { function_entry, 0, 0, icache_illegal },
  /*1819*/ { function_entry, 0, 0, icache_illegal },
  /*1820*/ { function_entry, 0, 0, icache_illegal },
  /*1821*/ { function_entry, 0, 0, icache_illegal },
  /*1822*/ { function_entry, 0, 0, icache_illegal },
  /*1823*/ { function_entry, 0, 0, icache_illegal },
  /*1824*/ { function_entry, 0, 0, icache_illegal },
  /*1825*/ { function_entry, 0, 0, icache_illegal },
  /*1826*/ { function_entry, 0, 0, icache_illegal },
  /*1827*/ { function_entry, 0, 0, icache_illegal },
  /*1828*/ { function_entry, 0, 0, icache_illegal },
  /*1829*/ { function_entry, 0, 0, icache_illegal },
  /*1830*/ { function_entry, 0, 0, icache_illegal },
  /*1831*/ { function_entry, 0, 0, icache_illegal },
  /*1832*/ { function_entry, 0, 0, icache_illegal },
  /*1833*/ { function_entry, 0, 0, icache_illegal },
  /*1834*/ { function_entry, 0, 0, icache_illegal },
  /*1835*/ { function_entry, 0, 0, icache_illegal },
  /*1836*/ { function_entry, 0, 0, icache_illegal },
  /*1837*/ { function_entry, 0, 0, icache_illegal },
  /*1838*/ { function_entry, 0, 0, icache_Floating_Select_FRC28_Rc0 },
  /*1839*/ { function_entry, 0, 0, icache_Floating_Select_FRC28_Rc1 },
  /*1840*/ { function_entry, 0, 0, icache_illegal },
  /*1841*/ { function_entry, 0, 0, icache_illegal },
  /*1842*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC28_Rc0 },
  /*1843*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC28_Rc1 },
  /*1844*/ { function_entry, 0, 0, icache_illegal },
  /*1845*/ { function_entry, 0, 0, icache_illegal },
  /*1846*/ { function_entry, 0, 0, icache_illegal },
  /*1847*/ { function_entry, 0, 0, icache_illegal },
  /*1848*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC28_Rc0 },
  /*1849*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC28_Rc1 },
  /*1850*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC28_Rc0 },
  /*1851*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC28_Rc1 },
  /*1852*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC28_Rc0 },
  /*1853*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC28_Rc1 },
  /*1854*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC28_Rc0 },
  /*1855*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC28_Rc1 },
  /*1856*/ { function_entry, 0, 0, icache_illegal },
  /*1857*/ { function_entry, 0, 0, icache_illegal },
  /*1858*/ { function_entry, 0, 0, icache_illegal },
  /*1859*/ { function_entry, 0, 0, icache_illegal },
  /*1860*/ { function_entry, 0, 0, icache_illegal },
  /*1861*/ { function_entry, 0, 0, icache_illegal },
  /*1862*/ { function_entry, 0, 0, icache_illegal },
  /*1863*/ { function_entry, 0, 0, icache_illegal },
  /*1864*/ { function_entry, 0, 0, icache_illegal },
  /*1865*/ { function_entry, 0, 0, icache_illegal },
  /*1866*/ { function_entry, 0, 0, icache_illegal },
  /*1867*/ { function_entry, 0, 0, icache_illegal },
  /*1868*/ { function_entry, 0, 0, icache_illegal },
  /*1869*/ { function_entry, 0, 0, icache_illegal },
  /*1870*/ { function_entry, 0, 0, icache_illegal },
  /*1871*/ { function_entry, 0, 0, icache_illegal },
  /*1872*/ { function_entry, 0, 0, icache_illegal },
  /*1873*/ { function_entry, 0, 0, icache_illegal },
  /*1874*/ { function_entry, 0, 0, icache_illegal },
  /*1875*/ { function_entry, 0, 0, icache_illegal },
  /*1876*/ { function_entry, 0, 0, icache_illegal },
  /*1877*/ { function_entry, 0, 0, icache_illegal },
  /*1878*/ { function_entry, 0, 0, icache_illegal },
  /*1879*/ { function_entry, 0, 0, icache_illegal },
  /*1880*/ { function_entry, 0, 0, icache_illegal },
  /*1881*/ { function_entry, 0, 0, icache_illegal },
  /*1882*/ { function_entry, 0, 0, icache_illegal },
  /*1883*/ { function_entry, 0, 0, icache_illegal },
  /*1884*/ { function_entry, 0, 0, icache_illegal },
  /*1885*/ { function_entry, 0, 0, icache_illegal },
  /*1886*/ { function_entry, 0, 0, icache_illegal },
  /*1887*/ { function_entry, 0, 0, icache_illegal },
  /*1888*/ { function_entry, 0, 0, icache_illegal },
  /*1889*/ { function_entry, 0, 0, icache_illegal },
  /*1890*/ { function_entry, 0, 0, icache_illegal },
  /*1891*/ { function_entry, 0, 0, icache_illegal },
  /*1892*/ { function_entry, 0, 0, icache_illegal },
  /*1893*/ { function_entry, 0, 0, icache_illegal },
  /*1894*/ { function_entry, 0, 0, icache_illegal },
  /*1895*/ { function_entry, 0, 0, icache_illegal },
  /*1896*/ { function_entry, 0, 0, icache_illegal },
  /*1897*/ { function_entry, 0, 0, icache_illegal },
  /*1898*/ { function_entry, 0, 0, icache_illegal },
  /*1899*/ { function_entry, 0, 0, icache_illegal },
  /*1900*/ { function_entry, 0, 0, icache_illegal },
  /*1901*/ { function_entry, 0, 0, icache_illegal },
  /*1902*/ { function_entry, 0, 0, icache_Floating_Select_FRC29_Rc0 },
  /*1903*/ { function_entry, 0, 0, icache_Floating_Select_FRC29_Rc1 },
  /*1904*/ { function_entry, 0, 0, icache_illegal },
  /*1905*/ { function_entry, 0, 0, icache_illegal },
  /*1906*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC29_Rc0 },
  /*1907*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC29_Rc1 },
  /*1908*/ { function_entry, 0, 0, icache_illegal },
  /*1909*/ { function_entry, 0, 0, icache_illegal },
  /*1910*/ { function_entry, 0, 0, icache_illegal },
  /*1911*/ { function_entry, 0, 0, icache_illegal },
  /*1912*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC29_Rc0 },
  /*1913*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC29_Rc1 },
  /*1914*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC29_Rc0 },
  /*1915*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC29_Rc1 },
  /*1916*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC29_Rc0 },
  /*1917*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC29_Rc1 },
  /*1918*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC29_Rc0 },
  /*1919*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC29_Rc1 },
  /*1920*/ { function_entry, 0, 0, icache_illegal },
  /*1921*/ { function_entry, 0, 0, icache_illegal },
  /*1922*/ { function_entry, 0, 0, icache_illegal },
  /*1923*/ { function_entry, 0, 0, icache_illegal },
  /*1924*/ { function_entry, 0, 0, icache_illegal },
  /*1925*/ { function_entry, 0, 0, icache_illegal },
  /*1926*/ { function_entry, 0, 0, icache_illegal },
  /*1927*/ { function_entry, 0, 0, icache_illegal },
  /*1928*/ { function_entry, 0, 0, icache_illegal },
  /*1929*/ { function_entry, 0, 0, icache_illegal },
  /*1930*/ { function_entry, 0, 0, icache_illegal },
  /*1931*/ { function_entry, 0, 0, icache_illegal },
  /*1932*/ { function_entry, 0, 0, icache_illegal },
  /*1933*/ { function_entry, 0, 0, icache_illegal },
  /*1934*/ { function_entry, 0, 0, icache_illegal },
  /*1935*/ { function_entry, 0, 0, icache_illegal },
  /*1936*/ { function_entry, 0, 0, icache_illegal },
  /*1937*/ { function_entry, 0, 0, icache_illegal },
  /*1938*/ { function_entry, 0, 0, icache_illegal },
  /*1939*/ { function_entry, 0, 0, icache_illegal },
  /*1940*/ { function_entry, 0, 0, icache_illegal },
  /*1941*/ { function_entry, 0, 0, icache_illegal },
  /*1942*/ { function_entry, 0, 0, icache_illegal },
  /*1943*/ { function_entry, 0, 0, icache_illegal },
  /*1944*/ { function_entry, 0, 0, icache_illegal },
  /*1945*/ { function_entry, 0, 0, icache_illegal },
  /*1946*/ { function_entry, 0, 0, icache_illegal },
  /*1947*/ { function_entry, 0, 0, icache_illegal },
  /*1948*/ { function_entry, 0, 0, icache_illegal },
  /*1949*/ { function_entry, 0, 0, icache_illegal },
  /*1950*/ { function_entry, 0, 0, icache_illegal },
  /*1951*/ { function_entry, 0, 0, icache_illegal },
  /*1952*/ { function_entry, 0, 0, icache_illegal },
  /*1953*/ { function_entry, 0, 0, icache_illegal },
  /*1954*/ { function_entry, 0, 0, icache_illegal },
  /*1955*/ { function_entry, 0, 0, icache_illegal },
  /*1956*/ { function_entry, 0, 0, icache_illegal },
  /*1957*/ { function_entry, 0, 0, icache_illegal },
  /*1958*/ { function_entry, 0, 0, icache_illegal },
  /*1959*/ { function_entry, 0, 0, icache_illegal },
  /*1960*/ { function_entry, 0, 0, icache_illegal },
  /*1961*/ { function_entry, 0, 0, icache_illegal },
  /*1962*/ { function_entry, 0, 0, icache_illegal },
  /*1963*/ { function_entry, 0, 0, icache_illegal },
  /*1964*/ { function_entry, 0, 0, icache_illegal },
  /*1965*/ { function_entry, 0, 0, icache_illegal },
  /*1966*/ { function_entry, 0, 0, icache_Floating_Select_FRC30_Rc0 },
  /*1967*/ { function_entry, 0, 0, icache_Floating_Select_FRC30_Rc1 },
  /*1968*/ { function_entry, 0, 0, icache_illegal },
  /*1969*/ { function_entry, 0, 0, icache_illegal },
  /*1970*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC30_Rc0 },
  /*1971*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC30_Rc1 },
  /*1972*/ { function_entry, 0, 0, icache_illegal },
  /*1973*/ { function_entry, 0, 0, icache_illegal },
  /*1974*/ { function_entry, 0, 0, icache_illegal },
  /*1975*/ { function_entry, 0, 0, icache_illegal },
  /*1976*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC30_Rc0 },
  /*1977*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC30_Rc1 },
  /*1978*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC30_Rc0 },
  /*1979*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC30_Rc1 },
  /*1980*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC30_Rc0 },
  /*1981*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC30_Rc1 },
  /*1982*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC30_Rc0 },
  /*1983*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC30_Rc1 },
  /*1984*/ { function_entry, 0, 0, icache_illegal },
  /*1985*/ { function_entry, 0, 0, icache_illegal },
  /*1986*/ { function_entry, 0, 0, icache_illegal },
  /*1987*/ { function_entry, 0, 0, icache_illegal },
  /*1988*/ { function_entry, 0, 0, icache_illegal },
  /*1989*/ { function_entry, 0, 0, icache_illegal },
  /*1990*/ { function_entry, 0, 0, icache_illegal },
  /*1991*/ { function_entry, 0, 0, icache_illegal },
  /*1992*/ { function_entry, 0, 0, icache_illegal },
  /*1993*/ { function_entry, 0, 0, icache_illegal },
  /*1994*/ { function_entry, 0, 0, icache_illegal },
  /*1995*/ { function_entry, 0, 0, icache_illegal },
  /*1996*/ { function_entry, 0, 0, icache_illegal },
  /*1997*/ { function_entry, 0, 0, icache_illegal },
  /*1998*/ { function_entry, 0, 0, icache_illegal },
  /*1999*/ { function_entry, 0, 0, icache_illegal },
  /*2000*/ { function_entry, 0, 0, icache_illegal },
  /*2001*/ { function_entry, 0, 0, icache_illegal },
  /*2002*/ { function_entry, 0, 0, icache_illegal },
  /*2003*/ { function_entry, 0, 0, icache_illegal },
  /*2004*/ { function_entry, 0, 0, icache_illegal },
  /*2005*/ { function_entry, 0, 0, icache_illegal },
  /*2006*/ { function_entry, 0, 0, icache_illegal },
  /*2007*/ { function_entry, 0, 0, icache_illegal },
  /*2008*/ { function_entry, 0, 0, icache_illegal },
  /*2009*/ { function_entry, 0, 0, icache_illegal },
  /*2010*/ { function_entry, 0, 0, icache_illegal },
  /*2011*/ { function_entry, 0, 0, icache_illegal },
  /*2012*/ { function_entry, 0, 0, icache_illegal },
  /*2013*/ { function_entry, 0, 0, icache_illegal },
  /*2014*/ { function_entry, 0, 0, icache_illegal },
  /*2015*/ { function_entry, 0, 0, icache_illegal },
  /*2016*/ { function_entry, 0, 0, icache_illegal },
  /*2017*/ { function_entry, 0, 0, icache_illegal },
  /*2018*/ { function_entry, 0, 0, icache_illegal },
  /*2019*/ { function_entry, 0, 0, icache_illegal },
  /*2020*/ { function_entry, 0, 0, icache_illegal },
  /*2021*/ { function_entry, 0, 0, icache_illegal },
  /*2022*/ { function_entry, 0, 0, icache_illegal },
  /*2023*/ { function_entry, 0, 0, icache_illegal },
  /*2024*/ { function_entry, 0, 0, icache_illegal },
  /*2025*/ { function_entry, 0, 0, icache_illegal },
  /*2026*/ { function_entry, 0, 0, icache_illegal },
  /*2027*/ { function_entry, 0, 0, icache_illegal },
  /*2028*/ { function_entry, 0, 0, icache_illegal },
  /*2029*/ { function_entry, 0, 0, icache_illegal },
  /*2030*/ { function_entry, 0, 0, icache_Floating_Select_FRC31_Rc0 },
  /*2031*/ { function_entry, 0, 0, icache_Floating_Select_FRC31_Rc1 },
  /*2032*/ { function_entry, 0, 0, icache_illegal },
  /*2033*/ { function_entry, 0, 0, icache_illegal },
  /*2034*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC31_Rc0 },
  /*2035*/ { function_entry, 0, 0, icache_Floating_Multiply_FRC31_Rc1 },
  /*2036*/ { function_entry, 0, 0, icache_illegal },
  /*2037*/ { function_entry, 0, 0, icache_illegal },
  /*2038*/ { function_entry, 0, 0, icache_illegal },
  /*2039*/ { function_entry, 0, 0, icache_illegal },
  /*2040*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC31_Rc0 },
  /*2041*/ { function_entry, 0, 0, icache_Floating_MultiplySubtract_FRC31_Rc1 },
  /*2042*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC31_Rc0 },
  /*2043*/ { function_entry, 0, 0, icache_Floating_MultiplyAdd_FRC31_Rc1 },
  /*2044*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC31_Rc0 },
  /*2045*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplySubtract_FRC31_Rc1 },
  /*2046*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC31_Rc0 },
  /*2047*/ { function_entry, 0, 0, icache_Floating_Negative_MultiplyAdd_FRC31_Rc1 },
};

static idecode_table_entry idecode_table_0_5[] = {
  /*0*/ { function_entry, 0, 0, icache_instruction_call },
  /*1*/ { function_entry, 0, 0, icache_illegal },
  /*2*/ { function_entry, 0, 0, icache_illegal },
  /*3*/ { function_entry, 0, 0, icache_Trap_Word_Immediate },
  /*4*/ { function_entry, 0, 0, icache_illegal },
  /*5*/ { function_entry, 0, 0, icache_illegal },
  /*6*/ { function_entry, 0, 0, icache_illegal },
  /*7*/ { function_entry, 0, 0, icache_Multiply_Low_Immediate },
  /*8*/ { function_entry, 0, 0, icache_Subtract_From_Immediate_Carrying },
  /*9*/ { function_entry, 0, 0, icache_illegal },
  /*10*/ { function_entry, 0, 0, icache_Compare_Logical_Immediate },
  /*11*/ { function_entry, 0, 0, icache_Compare_Immediate },
  /*12*/ { function_entry, 0, 0, icache_Add_Immediate_Carrying },
  /*13*/ { function_entry, 0, 0, icache_Add_Immediate_Carrying_and_Record },
  /*14*/ { boolean_entry, MASK32(11, 15), INSERTED32(0, 11, 15), idecode_table_11_15__14_0_5 },
  /*15*/ { boolean_entry, MASK32(11, 15), INSERTED32(0, 11, 15), idecode_table_11_15__15_0_5 },
  /*16*/ { 0, MASK32(30,31), 0, idecode_table_30_31__16_0_5 },
  /*17*/ { function_entry, 0, 0, icache_System_Call },
  /*18*/ { 0, MASK32(30,31), 0, idecode_table_30_31__18_0_5 },
  /*19*/ { 0, MASK32(21,31), 0, idecode_table_21_31__19_0_5 },
  /*20*/ { 0, MASK32(31,31), 0, idecode_table_31_31__20_0_5 },
  /*21*/ { 0, MASK32(31,31), 0, idecode_table_31_31__21_0_5 },
  /*22*/ { function_entry, 0, 0, icache_illegal },
  /*23*/ { 0, MASK32(31,31), 0, idecode_table_31_31__23_0_5 },
  /*24*/ { function_entry, 0, 0, icache_OR_Immediate },
  /*25*/ { function_entry, 0, 0, icache_OR_Immediate_Shifted },
  /*26*/ { function_entry, 0, 0, icache_XOR_Immediate },
  /*27*/ { function_entry, 0, 0, icache_XOR_Immediate_Shifted },
  /*28*/ { function_entry, 0, 0, icache_AND_Immediate },
  /*29*/ { function_entry, 0, 0, icache_AND_Immediate_Shifted },
  /*30*/ { function_entry, 0, 0, icache_illegal },
  /*31*/ { 0, MASK32(21,31), 0, idecode_table_21_31__31_0_5 },
  /*32*/ { function_entry, 0, 0, icache_Load_Word_and_Zero },
  /*33*/ { function_entry, 0, 0, icache_Load_Word_and_Zero_with_Update },
  /*34*/ { function_entry, 0, 0, icache_Load_Byte_and_Zero },
  /*35*/ { function_entry, 0, 0, icache_Load_Byte_and_Zero_with_Update },
  /*36*/ { function_entry, 0, 0, icache_Store_Word },
  /*37*/ { function_entry, 0, 0, icache_Store_Word_with_Update },
  /*38*/ { function_entry, 0, 0, icache_Store_Byte },
  /*39*/ { function_entry, 0, 0, icache_Store_Byte_with_Update },
  /*40*/ { function_entry, 0, 0, icache_Load_Halfword_and_Zero },
  /*41*/ { function_entry, 0, 0, icache_Load_Halfword_and_Zero_with_Update },
  /*42*/ { function_entry, 0, 0, icache_Load_Halfword_Algebraic },
  /*43*/ { function_entry, 0, 0, icache_Load_Halfword_Algebraic_with_Update },
  /*44*/ { function_entry, 0, 0, icache_Store_Half_Word },
  /*45*/ { function_entry, 0, 0, icache_Store_Half_Word_with_Update },
  /*46*/ { function_entry, 0, 0, icache_Load_Multiple_Word },
  /*47*/ { function_entry, 0, 0, icache_Store_Multiple_Word },
  /*48*/ { function_entry, 0, 0, icache_Load_FloatingPoint_Single },
  /*49*/ { function_entry, 0, 0, icache_Load_FloatingPoint_Single_with_Update },
  /*50*/ { function_entry, 0, 0, icache_Load_FloatingPoint_Double },
  /*51*/ { function_entry, 0, 0, icache_Load_FloatingPoint_Double_with_Update },
  /*52*/ { function_entry, 0, 0, icache_Store_FloatingPoint_Single },
  /*53*/ { function_entry, 0, 0, icache_Store_FloatingPoint_Single_with_Update },
  /*54*/ { function_entry, 0, 0, icache_Store_FloatingPoint_Double },
  /*55*/ { function_entry, 0, 0, icache_Store_FloatingPoint_Double_with_Update },
  /*56*/ { function_entry, 0, 0, icache_illegal },
  /*57*/ { function_entry, 0, 0, icache_illegal },
  /*58*/ { function_entry, 0, 0, icache_illegal },
  /*59*/ { 0, MASK32(26,31), 0, idecode_table_26_31__59_0_5 },
  /*60*/ { function_entry, 0, 0, icache_illegal },
  /*61*/ { function_entry, 0, 0, icache_illegal },
  /*62*/ { function_entry, 0, 0, icache_illegal },
  /*63*/ { 0, MASK32(21,31), 0, idecode_table_21_31__63_0_5 },
};

PSIM_INLINE_IDECODE\
(void)
idecode_run(psim *system,
            event_queue *events,
            cpu *const processors[],
            const int nr_cpus)
{
  jmp_buf halt;
  jmp_buf restart;
  int last_cpu;
  int current_cpu;
  int cpu_nr;

  /* flush the icache of a possible break insn */
  for (cpu_nr = 0; cpu_nr < nr_cpus; cpu_nr++)
    cpu_flush_icache(processors[cpu_nr]);

  /* set the halt target initially */
  psim_set_halt_and_restart(system, &halt, NULL);
  if (setjmp(halt))
    return;

  /* where were we before the halt? */
  last_cpu = psim_last_cpu(system);

  /* check for need to force event processing first */
  if (WITH_EVENTS) {
    if (last_cpu == nr_cpus) {
      /* halted during event processing */
      event_queue_process(events);
      last_cpu = -1;
    }
    else if (last_cpu == nr_cpus - 1) {
      /* last cpu did halt */
      if (event_queue_tick(events)) {
        event_queue_process(events);
      }
      last_cpu = -1;
    }
  }
  else {
   if (last_cpu == nr_cpus - 1)
     /* cpu zero is next */
     last_cpu = -1;
  }

  /* have ensured that the event queue can not be first */
  ASSERT(last_cpu >= -1 && last_cpu < nr_cpus - 1);

  /* CASE 2: SMP (With or without ICACHE)

     The complexity here comes from needing to correctly restart the
     system when it is aborted.  In particular if cpu0 requests a
     restart, the next cpu is still cpu1.  Cpu0 being restarted after
     all the other CPU's and the event queue have been processed */

  /* now establish the restart target */
  psim_set_halt_and_restart(system, &halt, &restart);
  if (setjmp(restart)) {
    current_cpu = psim_last_cpu(system);
    ASSERT(current_cpu >= 0 && current_cpu < nr_cpus);
  }
  else {
    current_cpu = last_cpu;
    ASSERT(current_cpu >= -1 && current_cpu < nr_cpus);
  }

  while (1) {

    if (WITH_EVENTS) {
      current_cpu += 1;
      if (current_cpu == nr_cpus) {
        if (event_queue_tick(events)) {
          event_queue_process(events);
        }
        current_cpu = 0;
      }
    }
    else {
      current_cpu = (current_cpu + 1) % nr_cpus;
    }

    {
      cpu *processor = processors[current_cpu];
      unsigned_word cia =
        cpu_get_program_counter(processor);
      idecode_cache *cache_entry =
        cpu_icache_entry(processor, cia);

      if (cache_entry->address == cia) {

        /* cache hit */
        idecode_semantic *semantic = cache_entry->semantic;
        cia = semantic(processor, cache_entry, cia);
        cpu_set_program_counter(processor, cia);

      }
      else {

        /* cache miss */
        instruction_word instruction =
          vm_instruction_map_read(cpu_instruction_map(processor), processor, cia);
        if (WITH_MON != 0)
          mon_event(mon_event_icache_miss, processors[current_cpu], cia);
        {
          /* prime the search */
          idecode_table_entry *table = idecode_table_0_5;
          int opcode = EXTRACTED32(instruction, 0, 5);
          idecode_table_entry *table_entry = table + opcode;

          /* iterate until a leaf */
          while (1) {
            signed shift = table_entry->shift;
          if (shift == function_entry) break;
            if (shift >= 0) {
              table = ((idecode_table_entry*)
                       table_entry->function_or_table);
              opcode = ((instruction & table_entry->mask)
                        >> shift);
              table_entry = table + opcode;
            }
            else {
              /* must be a boolean */
              ASSERT(table_entry->shift == boolean_entry);
              opcode = ((instruction & table_entry->mask)
                        != table_entry->value);
              table = ((idecode_table_entry*)
                       table_entry->function_or_table);
              table_entry = table + opcode;
            }
          }

          /* call the leaf code */
          cia = (((idecode_icache*)table_entry->function_or_table)
            (processor, instruction, cia, cache_entry));
        }
        cpu_set_program_counter(processor, cia);

      }
    }
  }
}

PSIM_INLINE_IDECODE\
(void)
idecode_run_until_stop(psim *system,
                       volatile int *keep_running,
                       event_queue *events,
                       cpu *const processors[],
                       const int nr_cpus)
{
  jmp_buf halt;
  jmp_buf restart;
  int last_cpu;
  int current_cpu;
  int cpu_nr;

  /* flush the icache of a possible break insn */
  for (cpu_nr = 0; cpu_nr < nr_cpus; cpu_nr++)
    cpu_flush_icache(processors[cpu_nr]);

  /* set the halt target initially */
  psim_set_halt_and_restart(system, &halt, NULL);
  if (setjmp(halt))
    return;

  /* where were we before the halt? */
  last_cpu = psim_last_cpu(system);

  /* check for need to force event processing first */
  if (WITH_EVENTS) {
    if (last_cpu == nr_cpus) {
      /* halted during event processing */
      event_queue_process(events);
      last_cpu = -1;
    }
    else if (last_cpu == nr_cpus - 1) {
      /* last cpu did halt */
      if (event_queue_tick(events)) {
        event_queue_process(events);
      }
      last_cpu = -1;
    }
  }
  else {
   if (last_cpu == nr_cpus - 1)
     /* cpu zero is next */
     last_cpu = -1;
  }

  /* have ensured that the event queue can not be first */
  ASSERT(last_cpu >= -1 && last_cpu < nr_cpus - 1);

  /* CASE 2: SMP (With or without ICACHE)

     The complexity here comes from needing to correctly restart the
     system when it is aborted.  In particular if cpu0 requests a
     restart, the next cpu is still cpu1.  Cpu0 being restarted after
     all the other CPU's and the event queue have been processed */

  /* now establish the restart target */
  psim_set_halt_and_restart(system, &halt, &restart);
  if (setjmp(restart)) {
    current_cpu = psim_last_cpu(system);
    ASSERT(current_cpu >= 0 && current_cpu < nr_cpus);
  }
  else {
    current_cpu = last_cpu;
    ASSERT(current_cpu >= -1 && current_cpu < nr_cpus);
  }

  while (1) {

    if (WITH_EVENTS) {
      current_cpu += 1;
      if (current_cpu == nr_cpus) {
        if (event_queue_tick(events)) {
          event_queue_process(events);
        }
        current_cpu = 0;
      }
    }
    else {
      current_cpu = (current_cpu + 1) % nr_cpus;
    }

    {
      cpu *processor = processors[current_cpu];
      unsigned_word cia =
        cpu_get_program_counter(processor);
      idecode_cache *cache_entry =
        cpu_icache_entry(processor, cia);

      if (cache_entry->address == cia) {

        /* cache hit */
        idecode_semantic *semantic = cache_entry->semantic;
        cia = semantic(processor, cache_entry, cia);
        if (keep_running != NULL && !*keep_running)
          cpu_halt(processor, cia, was_continuing, 0/*ignore-signal*/);
        cpu_set_program_counter(processor, cia);

      }
      else {

        /* cache miss */
        instruction_word instruction =
          vm_instruction_map_read(cpu_instruction_map(processor), processor, cia);
        if (WITH_MON != 0)
          mon_event(mon_event_icache_miss, processors[current_cpu], cia);
        {
          /* prime the search */
          idecode_table_entry *table = idecode_table_0_5;
          int opcode = EXTRACTED32(instruction, 0, 5);
          idecode_table_entry *table_entry = table + opcode;

          /* iterate until a leaf */
          while (1) {
            signed shift = table_entry->shift;
          if (shift == function_entry) break;
            if (shift >= 0) {
              table = ((idecode_table_entry*)
                       table_entry->function_or_table);
              opcode = ((instruction & table_entry->mask)
                        >> shift);
              table_entry = table + opcode;
            }
            else {
              /* must be a boolean */
              ASSERT(table_entry->shift == boolean_entry);
              opcode = ((instruction & table_entry->mask)
                        != table_entry->value);
              table = ((idecode_table_entry*)
                       table_entry->function_or_table);
              table_entry = table + opcode;
            }
          }

          /* call the leaf code */
          cia = (((idecode_icache*)table_entry->function_or_table)
            (processor, instruction, cia, cache_entry));
        }
        if (keep_running != NULL && !*keep_running)
          cpu_halt(processor, cia, was_continuing, 0/*ignore-signal*/);
        cpu_set_program_counter(processor, cia);

      }
    }
  }
}

#endif /* _IDECODE_C_*/
