#ifndef SBK_CUTTERPLUGINWRAPPER_H
#define SBK_CUTTERPLUGINWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <CutterPlugin.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

class CutterPluginWrapper : public CutterPlugin
{
public:
    CutterPluginWrapper();
    CutterPluginWrapper(const CutterPluginWrapper &) = delete;
    CutterPluginWrapper& operator=(const CutterPluginWrapper &) = delete;
    CutterPluginWrapper(CutterPluginWrapper &&) = delete;
    CutterPluginWrapper& operator=(CutterPluginWrapper &&) = delete;
    ~CutterPluginWrapper() override;

    ::QString getAuthor() const override;
    static ::QString sbk_o_getAuthor(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    ::QString getDescription() const override;
    static ::QString sbk_o_getDescription(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    ::QString getName() const override;
    static ::QString sbk_o_getName(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    ::QString getVersion() const override;
    static ::QString sbk_o_getVersion(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void registerDecompilers() override;
    static void sbk_o_registerDecompilers(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void setupInterface(::MainWindow * main) override;
    static void sbk_o_setupInterface(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::MainWindow * main);
    void setupPlugin() override;
    void terminate() override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 8> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_CUTTERPLUGINWRAPPER_H
