/* Debug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Debug.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <unistd.h>

#define DEBUG_DEFAULT_LOG_MASK ((G_LOG_LEVEL_CRITICAL | G_LOG_LEVEL_WARNING) | G_LOG_LEVEL_MESSAGE)
#define DEBUG_VIEWER_PREFIX "V"
#define DEBUG_LIBRARY_PREFIX "L"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

VALA_EXTERN GLogLevelFlags debug_log_mask;
GLogLevelFlags debug_log_mask = 0;
VALA_EXTERN gchar* debug_log_app_version_prefix;
gchar* debug_log_app_version_prefix = NULL;
VALA_EXTERN FILE* debug_log_out;
FILE* debug_log_out = NULL;
VALA_EXTERN FILE* debug_log_err;
FILE* debug_log_err = NULL;
VALA_EXTERN FILE* debug_log_file_stream;
FILE* debug_log_file_stream = NULL;
VALA_EXTERN GTimeZone* application_timezone;

VALA_EXTERN void debug_init (const gchar* app_version_prefix);
VALA_EXTERN GFile* app_dirs_get_log_file (void);
VALA_EXTERN void debug_info_handler (const gchar* domain,
                         GLogLevelFlags flags,
                         const gchar* message);
static void _debug_info_handler_glog_func (const gchar* log_domain,
                                    GLogLevelFlags log_levels,
                                    const gchar* message,
                                    gpointer self);
VALA_EXTERN void debug_debug_handler (const gchar* domain,
                          GLogLevelFlags flags,
                          const gchar* message);
static void _debug_debug_handler_glog_func (const gchar* log_domain,
                                     GLogLevelFlags log_levels,
                                     const gchar* message,
                                     gpointer self);
VALA_EXTERN void debug_message_handler (const gchar* domain,
                            GLogLevelFlags flags,
                            const gchar* message);
static void _debug_message_handler_glog_func (const gchar* log_domain,
                                       GLogLevelFlags log_levels,
                                       const gchar* message,
                                       gpointer self);
VALA_EXTERN void debug_warning_handler (const gchar* domain,
                            GLogLevelFlags flags,
                            const gchar* message);
static void _debug_warning_handler_glog_func (const gchar* log_domain,
                                       GLogLevelFlags log_levels,
                                       const gchar* message,
                                       gpointer self);
VALA_EXTERN void debug_critical_handler (const gchar* domain,
                             GLogLevelFlags flags,
                             const gchar* message);
static void _debug_critical_handler_glog_func (const gchar* log_domain,
                                        GLogLevelFlags log_levels,
                                        const gchar* message,
                                        gpointer self);
VALA_EXTERN void debug_terminate (void);
VALA_EXTERN gboolean debug_is_enabled (GLogLevelFlags flag);
VALA_EXTERN void debug_log (FILE* stream,
                const gchar* prefix,
                const gchar* message);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_debug_info_handler_glog_func (const gchar* log_domain,
                               GLogLevelFlags log_levels,
                               const gchar* message,
                               gpointer self)
{
	debug_info_handler (log_domain, log_levels, message);
}

static void
_debug_debug_handler_glog_func (const gchar* log_domain,
                                GLogLevelFlags log_levels,
                                const gchar* message,
                                gpointer self)
{
	debug_debug_handler (log_domain, log_levels, message);
}

static void
_debug_message_handler_glog_func (const gchar* log_domain,
                                  GLogLevelFlags log_levels,
                                  const gchar* message,
                                  gpointer self)
{
	debug_message_handler (log_domain, log_levels, message);
}

static void
_debug_warning_handler_glog_func (const gchar* log_domain,
                                  GLogLevelFlags log_levels,
                                  const gchar* message,
                                  gpointer self)
{
	debug_warning_handler (log_domain, log_levels, message);
}

static void
_debug_critical_handler_glog_func (const gchar* log_domain,
                                   GLogLevelFlags log_levels,
                                   const gchar* message,
                                   gpointer self)
{
	debug_critical_handler (log_domain, log_levels, message);
}

void
debug_init (const gchar* app_version_prefix)
{
	gchar* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar* log_file_error_msg = NULL;
	GFile* _tmp3_ = NULL;
	const gchar* _tmp4_;
	GFile* log_file = NULL;
	GFile* _tmp6_;
	GFile* _tmp7_;
	const gchar* _tmp31_;
	gboolean _tmp42_ = FALSE;
	const gchar* _tmp44_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (app_version_prefix != NULL);
	_tmp0_ = g_strdup (app_version_prefix);
	_g_free0 (debug_log_app_version_prefix);
	debug_log_app_version_prefix = _tmp0_;
	_tmp1_ = stdout;
	debug_log_out = _tmp1_;
	_tmp2_ = stderr;
	debug_log_err = _tmp2_;
	log_file_error_msg = NULL;
	_tmp4_ = debug_log_app_version_prefix;
	if (g_strcmp0 (_tmp4_, DEBUG_LIBRARY_PREFIX) == 0) {
		GFile* _tmp5_;
		_tmp5_ = app_dirs_get_log_file ();
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp5_;
	} else {
		_g_object_unref0 (_tmp3_);
		_tmp3_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp3_);
	log_file = _tmp6_;
	_tmp7_ = log_file;
	if (_tmp7_ != NULL) {
		GFile* log_dir = NULL;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		FILE* _tmp23_;
		FILE* _tmp24_;
		_tmp8_ = log_file;
		_tmp9_ = g_file_get_parent (_tmp8_);
		log_dir = _tmp9_;
		{
			GFile* _tmp10_;
			_tmp10_ = log_dir;
			if (g_file_query_exists (_tmp10_, NULL) == FALSE) {
				gboolean _tmp11_ = FALSE;
				GFile* _tmp12_;
				_tmp12_ = log_dir;
				_tmp11_ = g_file_make_directory_with_parents (_tmp12_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				if (!_tmp11_) {
					GFile* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp13_ = log_dir;
					_tmp14_ = g_file_get_path (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strdup_printf ("Unable to create data directory %s", _tmp15_);
					_g_free0 (log_file_error_msg);
					log_file_error_msg = _tmp16_;
					_g_free0 (_tmp15_);
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp17_ = err;
			_tmp18_ = _tmp17_->message;
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (log_file_error_msg);
			log_file_error_msg = _tmp19_;
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (log_dir);
			_g_object_unref0 (log_file);
			_g_object_unref0 (_tmp3_);
			_g_free0 (log_file_error_msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp20_ = log_file;
		_tmp21_ = g_file_get_path (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_fopen (_tmp22_, "w");
		_fclose0 (debug_log_file_stream);
		debug_log_file_stream = _tmp23_;
		_g_free0 (_tmp22_);
		_tmp24_ = debug_log_file_stream;
		if (_tmp24_ != NULL) {
			FILE* _tmp25_;
			FILE* _tmp26_;
			_tmp25_ = debug_log_file_stream;
			debug_log_out = _tmp25_;
			_tmp26_ = debug_log_file_stream;
			debug_log_err = _tmp26_;
		} else {
			GFile* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp27_ = log_file;
			_tmp28_ = g_file_get_path (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf ("Unable to open or create log file %s", _tmp29_);
			_g_free0 (log_file_error_msg);
			log_file_error_msg = _tmp30_;
			_g_free0 (_tmp29_);
		}
		_g_object_unref0 (log_dir);
	}
	_tmp31_ = g_getenv ("SHOTWELL_LOG");
	if (_tmp31_ != NULL) {
		debug_log_mask = G_LOG_LEVEL_MASK;
	} else {
		GLogLevelFlags _tmp32_ = 0U;
		const gchar* _tmp33_;
		GLogLevelFlags _tmp34_ = 0U;
		const gchar* _tmp35_;
		GLogLevelFlags _tmp36_ = 0U;
		const gchar* _tmp37_;
		GLogLevelFlags _tmp38_ = 0U;
		const gchar* _tmp39_;
		GLogLevelFlags _tmp40_ = 0U;
		const gchar* _tmp41_;
		_tmp33_ = g_getenv ("SHOTWELL_INFO");
		if (_tmp33_ != NULL) {
			_tmp32_ = debug_log_mask | G_LOG_LEVEL_INFO;
		} else {
			_tmp32_ = debug_log_mask;
		}
		debug_log_mask = _tmp32_;
		_tmp35_ = g_getenv ("SHOTWELL_DEBUG");
		if (_tmp35_ != NULL) {
			_tmp34_ = debug_log_mask | G_LOG_LEVEL_DEBUG;
		} else {
			_tmp34_ = debug_log_mask;
		}
		debug_log_mask = _tmp34_;
		_tmp37_ = g_getenv ("SHOTWELL_MESSAGE");
		if (_tmp37_ != NULL) {
			_tmp36_ = debug_log_mask | G_LOG_LEVEL_MESSAGE;
		} else {
			_tmp36_ = debug_log_mask;
		}
		debug_log_mask = _tmp36_;
		_tmp39_ = g_getenv ("SHOTWELL_WARNING");
		if (_tmp39_ != NULL) {
			_tmp38_ = debug_log_mask | G_LOG_LEVEL_WARNING;
		} else {
			_tmp38_ = debug_log_mask;
		}
		debug_log_mask = _tmp38_;
		_tmp41_ = g_getenv ("SHOTWELL_CRITICAL");
		if (_tmp41_ != NULL) {
			_tmp40_ = debug_log_mask | G_LOG_LEVEL_CRITICAL;
		} else {
			_tmp40_ = debug_log_mask;
		}
		debug_log_mask = _tmp40_;
	}
	g_log_set_handler (NULL, G_LOG_LEVEL_INFO, _debug_info_handler_glog_func, NULL);
	g_log_set_handler (NULL, G_LOG_LEVEL_DEBUG, _debug_debug_handler_glog_func, NULL);
	g_log_set_handler (NULL, G_LOG_LEVEL_MESSAGE, _debug_message_handler_glog_func, NULL);
	g_log_set_handler (NULL, G_LOG_LEVEL_WARNING, _debug_warning_handler_glog_func, NULL);
	g_log_set_handler (NULL, G_LOG_LEVEL_CRITICAL, _debug_critical_handler_glog_func, NULL);
	if (debug_log_mask == 0) {
		GFile* _tmp43_;
		_tmp43_ = log_file;
		_tmp42_ = _tmp43_ != NULL;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		debug_log_mask = DEBUG_DEFAULT_LOG_MASK;
	}
	_tmp44_ = log_file_error_msg;
	if (_tmp44_ != NULL) {
		const gchar* _tmp45_;
		_tmp45_ = log_file_error_msg;
		g_warning ("Debug.vala:95: %s", _tmp45_);
	}
	_g_object_unref0 (log_file);
	_g_object_unref0 (_tmp3_);
	_g_free0 (log_file_error_msg);
}

void
debug_terminate (void)
{
}

gboolean
debug_is_enabled (GLogLevelFlags flag)
{
	gboolean result;
	result = (debug_log_mask & flag) > 0;
	return result;
}

void
debug_log (FILE* stream,
           const gchar* prefix,
           const gchar* message)
{
	const gchar* _tmp0_;
	GTimeZone* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (stream != NULL);
	g_return_if_fail (prefix != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = debug_log_app_version_prefix;
	_tmp1_ = application_timezone;
	_tmp2_ = g_date_time_new_now (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_date_time_format (_tmp3_, "%F %T");
	_tmp5_ = _tmp4_;
	fprintf (stream, "%s %d %s [%s] %s\n", _tmp0_, (gint) getpid (), _tmp5_, prefix, message);
	_g_free0 (_tmp5_);
	_g_date_time_unref0 (_tmp3_);
	fflush (stream);
}

void
debug_info_handler (const gchar* domain,
                    GLogLevelFlags flags,
                    const gchar* message)
{
	g_return_if_fail (message != NULL);
	if (debug_is_enabled (G_LOG_LEVEL_INFO)) {
		FILE* _tmp0_;
		_tmp0_ = debug_log_out;
		debug_log (_tmp0_, "INF", message);
	}
}

void
debug_debug_handler (const gchar* domain,
                     GLogLevelFlags flags,
                     const gchar* message)
{
	g_return_if_fail (message != NULL);
	if (debug_is_enabled (G_LOG_LEVEL_DEBUG)) {
		FILE* _tmp0_;
		_tmp0_ = debug_log_out;
		debug_log (_tmp0_, "DBG", message);
	}
}

void
debug_message_handler (const gchar* domain,
                       GLogLevelFlags flags,
                       const gchar* message)
{
	g_return_if_fail (message != NULL);
	if (debug_is_enabled (G_LOG_LEVEL_MESSAGE)) {
		FILE* _tmp0_;
		_tmp0_ = debug_log_err;
		debug_log (_tmp0_, "MSG", message);
	}
}

void
debug_warning_handler (const gchar* domain,
                       GLogLevelFlags flags,
                       const gchar* message)
{
	g_return_if_fail (message != NULL);
	if (debug_is_enabled (G_LOG_LEVEL_WARNING)) {
		FILE* _tmp0_;
		_tmp0_ = debug_log_err;
		debug_log (_tmp0_, "WRN", message);
	}
}

void
debug_critical_handler (const gchar* domain,
                        GLogLevelFlags flags,
                        const gchar* message)
{
	g_return_if_fail (message != NULL);
	if (debug_is_enabled (G_LOG_LEVEL_CRITICAL)) {
		FILE* _tmp0_;
		FILE* _tmp1_;
		_tmp0_ = debug_log_err;
		debug_log (_tmp0_, "CRT", message);
		_tmp1_ = debug_log_file_stream;
		if (_tmp1_ != NULL) {
			FILE* _tmp2_;
			_tmp2_ = stderr;
			debug_log (_tmp2_, "CRT", message);
		}
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

