// Code generated by smithy-go-codegen DO NOT EDIT.

package ecr

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the IAM principals that are excluded from having their image pull times
// recorded.
func (c *Client) ListPullTimeUpdateExclusions(ctx context.Context, params *ListPullTimeUpdateExclusionsInput, optFns ...func(*Options)) (*ListPullTimeUpdateExclusionsOutput, error) {
	if params == nil {
		params = &ListPullTimeUpdateExclusionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPullTimeUpdateExclusions", params, optFns, c.addOperationListPullTimeUpdateExclusionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPullTimeUpdateExclusionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPullTimeUpdateExclusionsInput struct {

	// The maximum number of pull time update exclusion results returned by
	// ListPullTimeUpdateExclusions in paginated output. When this parameter is used,
	// ListPullTimeUpdateExclusions only returns maxResults results in a single page
	// along with a nextToken response element. The remaining results of the initial
	// request can be seen by sending another ListPullTimeUpdateExclusions request
	// with the returned nextToken value. This value can be between 1 and 1000. If
	// this parameter is not used, then ListPullTimeUpdateExclusions returns up to 100
	// results and a nextToken value, if applicable.
	MaxResults *int32

	// The nextToken value returned from a previous paginated
	// ListPullTimeUpdateExclusions request where maxResults was used and the results
	// exceeded the value of that parameter. Pagination continues from the end of the
	// previous results that returned the nextToken value. This value is null when
	// there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPullTimeUpdateExclusionsOutput struct {

	// The nextToken value to include in a future ListPullTimeUpdateExclusions
	// request. When the results of a ListPullTimeUpdateExclusions request exceed
	// maxResults , this value can be used to retrieve the next page of results. This
	// value is null when there are no more results to return.
	NextToken *string

	// The list of IAM principal ARNs that are excluded from having their image pull
	// times recorded.
	PullTimeUpdateExclusions []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPullTimeUpdateExclusionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListPullTimeUpdateExclusions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListPullTimeUpdateExclusions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPullTimeUpdateExclusions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPullTimeUpdateExclusions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListPullTimeUpdateExclusions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPullTimeUpdateExclusions",
	}
}
