/* Effect: dither/noise-shape   Copyright (c) 2008-9 robs@users.sourceforge.net
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef NDEBUG /* Enable assert always. */
#undef NDEBUG /* Must undef above assert.h or other that might include it. */
#endif

#include "sox_i.h"
#include "sdm.h"

#undef RANQD1
#define RANQD1 ranqd1(p->ranqd1)

typedef enum { /* Collection of various filters from the net */
  Shape_none, Shape_lipshitz, Shape_f_weighted, Shape_modified_e_weighted,
  Shape_improved_e_weighted, Shape_gesemann, Shape_shibata, Shape_low_shibata, Shape_high_shibata,
  Shape_shibata_A0, Shape_shibata_A1, Shape_shibata_A2, Shape_shibata_A3, Shape_shibata_A4, Shape_shibata_A5, Shape_shibata_A6, Shape_shibata_A_saturated,
  Shape_shibata_B0, Shape_shibata_B1, Shape_shibata_B2, Shape_shibata_B3, Shape_shibata_B4, Shape_shibata_B5, Shape_shibata_B6,
} filter_name_t;
static lsx_enum_item const filter_names[] = {
  LSX_ENUM_ITEM(Shape_,none)
  LSX_ENUM_ITEM(Shape_,lipshitz)
  {"f-weighted", Shape_f_weighted},
  {"modified-e-weighted", Shape_modified_e_weighted},
  {"improved-e-weighted", Shape_improved_e_weighted},
  LSX_ENUM_ITEM(Shape_,gesemann)
  LSX_ENUM_ITEM(Shape_,shibata)
  {"low-shibata", Shape_low_shibata},
  {"high-shibata", Shape_high_shibata},
  {"shibata-A0", Shape_shibata_A0},
  {"shibata-A1", Shape_shibata_A1},
  {"shibata-A2", Shape_shibata_A2},
  {"shibata-A3", Shape_shibata_A3},
  {"shibata-A4", Shape_shibata_A4},
  {"shibata-A5", Shape_shibata_A5},
  {"shibata-A6", Shape_shibata_A6},
  {"shibata-A-saturated", Shape_shibata_A_saturated},
  {"shibata-B0", Shape_shibata_B0},
  {"shibata-B1", Shape_shibata_B1},
  {"shibata-B2", Shape_shibata_B2},
  {"shibata-B3", Shape_shibata_B3},
  {"shibata-B4", Shape_shibata_B4},
  {"shibata-B5", Shape_shibata_B5},
  {"shibata-B6", Shape_shibata_B6},
  {0, 0}};

typedef struct {
  sox_rate_t  rate;
  enum {fir, iir} type;
  size_t len;
  int gain_cB; /* Chosen so clips are few if any, but not guaranteed none. */
  double const * coefs;
  filter_name_t name;
} filter_t;

static double const lip44[] = {2.033, -2.165, 1.959, -1.590, .6149};
static double const fwe44[] = {
  2.412, -3.370, 3.937, -4.174, 3.353, -2.205, 1.281, -.569, .0847};
static double const mew44[] = {
  1.662, -1.263, .4827, -.2913, .1268, -.1124, .03252, -.01265, -.03524};
static double const iew44[] = {
  2.847, -4.685, 6.214, -7.184, 6.639, -5.032, 3.263, -1.632, .4191};
static double const ges44[] = {
  2.2061, -.4706, -.2534, -.6214, 1.0587, .0676, -.6054, -.2738};
static double const ges48[] = {
  2.2374, -.7339, -.1251, -.6033, .903, .0116, -.5853, -.2571};

static double const shi48[] = {
  2.8720729351043701172,  -5.0413231849670410156,   6.2442994117736816406,
  -5.8483986854553222656, 3.7067542076110839844,  -1.0495119094848632812,
  -1.1830236911773681641,   2.1126792430877685547, -1.9094531536102294922,
  0.99913084506988525391, -0.17090806365013122559, -0.32615602016448974609,
  0.39127644896507263184, -0.26876461505889892578,  0.097676105797290802002,
  -0.023473845794796943665,
};
static double const shi44[] = {
  2.6773197650909423828,  -4.8308925628662109375,   6.570110321044921875,
  -7.4572014808654785156, 6.7263274192810058594,  -4.8481650352478027344,
  2.0412089824676513672,   0.7006359100341796875, -2.9537565708160400391,
  4.0800385475158691406,  -4.1845216751098632812,   3.3311812877655029297,
  -2.1179926395416259766,   0.879302978515625,      -0.031759146600961685181,
  -0.42382788658142089844, 0.47882103919982910156, -0.35490813851356506348,
  0.17496839165687561035, -0.060908168554306030273,
};
static double const shi38[] = {
  1.6335992813110351562,  -2.2615492343902587891,   2.4077029228210449219,
  -2.6341717243194580078, 2.1440362930297851562,  -1.8153258562088012695,
  1.0816224813461303711,  -0.70302653312683105469, 0.15991993248462677002,
  0.041549518704414367676, -0.29416576027870178223,  0.2518316805362701416,
  -0.27766478061676025391,  0.15785403549671173096, -0.10165894031524658203,
  0.016833892092108726501,
};
static double const shi32[] =
{ /* dmaker 32000: bestmax=4.99659 (inverted) */
0.82118552923202515,
-1.0063692331314087,
0.62341964244842529,
-1.0447187423706055,
0.64532512426376343,
-0.87615132331848145,
0.52219754457473755,
-0.67434263229370117,
0.44954317808151245,
-0.52557498216629028,
0.34567299485206604,
-0.39618203043937683,
0.26791760325431824,
-0.28936097025871277,
0.1883765310049057,
-0.19097308814525604,
0.10431359708309174,
-0.10633844882249832,
0.046832218766212463,
-0.039653312414884567,
};
static double const shi22[] =
{ /* dmaker 22050: bestmax=5.77762 (inverted) */
0.056581053882837296,
-0.56956905126571655,
-0.40727734565734863,
-0.33870288729667664,
-0.29810553789138794,
-0.19039161503314972,
-0.16510021686553955,
-0.13468159735202789,
-0.096633769571781158,
-0.081049129366874695,
-0.064953058958053589,
-0.054459091275930405,
-0.043378707021474838,
-0.03660014271736145,
-0.026256965473294258,
-0.018786206841468811,
-0.013387725688517094,
-0.0090983230620622635,
-0.0026585909072309732,
-0.00042083300650119781,
};
static double const shi16[] =
{ /* dmaker 16000: bestmax=5.97128 (inverted) */
-0.37251132726669312,
-0.81423574686050415,
-0.55010956525802612,
-0.47405767440795898,
-0.32624706625938416,
-0.3161766529083252,
-0.2286367267370224,
-0.22916607558727264,
-0.19565616548061371,
-0.18160104751586914,
-0.15423151850700378,
-0.14104481041431427,
-0.11844276636838913,
-0.097583092749118805,
-0.076493598520755768,
-0.068106919527053833,
-0.041881654411554337,
-0.036922425031661987,
-0.019364040344953537,
-0.014994367957115173,
};
static double const shi11[] =
{ /* dmaker 11025: bestmax=5.9406 (inverted) */
-0.9264228343963623,
-0.98695987462997437,
-0.631156325340271,
-0.51966935396194458,
-0.39738872647285461,
-0.35679301619529724,
-0.29720726609230042,
-0.26310476660728455,
-0.21719355881214142,
-0.18561814725399017,
-0.15404847264289856,
-0.12687471508979797,
-0.10339745879173279,
-0.083688631653785706,
-0.05875682458281517,
-0.046893671154975891,
-0.027950936928391457,
-0.020740609616041183,
-0.009366452693939209,
-0.0060260160826146603,
};
static double const shi08[] =
{ /* dmaker 8000: bestmax=5.56234 (inverted) */
-1.202863335609436,
-0.94103097915649414,
-0.67878556251525879,
-0.57650017738342285,
-0.50004476308822632,
-0.44349345564842224,
-0.37833768129348755,
-0.34028723835945129,
-0.29413089156150818,
-0.24994957447052002,
-0.21715600788593292,
-0.18792112171649933,
-0.15268312394618988,
-0.12135542929172516,
-0.099610626697540283,
-0.075273610651493073,
-0.048787496984004974,
-0.042586319148540497,
-0.028991291299462318,
-0.011869125068187714,
};
static double const shl48[] = {
  2.3925774097442626953,  -3.4350297451019287109,   3.1853709220886230469,
  -1.8117271661758422852, -0.20124770700931549072,  1.4759907722473144531,
  -1.7210904359817504883,   0.97746700048446655273, -0.13790138065814971924,
  -0.38185903429985046387,  0.27421241998672485352,  0.066584214568138122559,
  -0.35223302245140075684,  0.37672343850135803223, -0.23964276909828186035,
  0.068674825131893157959,
};
static double const shl44[] = {
  2.0833916664123535156,  -3.0418450832366943359,   3.2047898769378662109,
  -2.7571926116943359375, 1.4978630542755126953,  -0.3427594602108001709,
  -0.71733748912811279297,  1.0737057924270629883, -1.0225815773010253906,
  0.56649994850158691406, -0.20968692004680633545, -0.065378531813621520996,
  0.10322438180446624756, -0.067442022264003753662, -0.00495197344571352005,
};
static double const shh44[] = {
   3.0259189605712890625, -6.0268716812133789062,   9.195003509521484375,
   -11.824929237365722656, 12.767142295837402344, -11.917946815490722656,
   9.1739168167114257812,  -5.3712320327758789062, 1.1393624544143676758,
   2.4484779834747314453,  -4.9719839096069335938,   6.0392003059387207031,
   -5.9359521865844726562,  4.903278350830078125,   -3.5527443885803222656,
   2.1909697055816650391, -1.1672389507293701172,  0.4903914332389831543,
   -0.16519790887832641602,  0.023217858746647834778,
};

/* SSRC, ATH Curve A, 44100 */

static double const shibata_A0_44[] =
    {
      0.59543782472610473633,
      -0.0025078731123358011246,
      -0.18518058955669403076,
      -0.0010374293196946382523,
      -0.1036634296178817749,
      -0.053248628973960876465,
      -8.4030049038119614124e-05,
      -3.8569933025200953125e-08,
      -0.026413010433316230774,
      -0.00068438396556302905083,
      3.1580505037709372118e-06,
      0.031739629805088043213,
    };
static double const shibata_A1_44[] =
    {
      0.9982020258903503418,
      -0.59951537847518920898,
      0.081278324127197265625,
      9.2977395979687571526e-05,
      -0.20252060890197753906,
      -0.024194804951548576355,
      0.00090227433247491717339,
      -0.045577544718980789185,
      -0.044477824121713638306,
      -0.0030681777279824018478,
      -0.00016936450265347957611,
      -6.8561035959646687843e-07,
    };
static double const shibata_A2_44[] =
    {
      1.356863856315612793,
      -1.2252935171127319336,
      0.62355506420135498047,
      -0.22562094032764434814,
      -0.23557975888252258301,
      0.13536362349987030029,
      -0.091538146138191223145,
      -0.056445639580488204956,
      3.9614424167666584253e-05,
      -0.023561919108033180237,
      -0.010756319388747215271,
      -0.00031949131516739726067,
      0.0014337620232254266739,
      -0.0084551237523555755615,
      -0.00021318180370144546032,
      7.6175922004040330648e-05,
      0.0010102330707013607025,
      4.5030275941826403141e-05,
      0.0013433821732178330421,
      0.0013937242329120635986,
      0.00043306700536049902439,
      0.00046949787065386772156,
      0.00014775841555092483759,
      -4.1060175135498866439e-05,
    };
static double const shibata_A3_44[] =
    {
      1.7714835405349731445,
      -2.160381317138671875,
      1.8512212038040161133,
      -1.3459416627883911133,
      0.52356457710266113281,
      -0.1598011404275894165,
      -0.079563401639461517334,
      0.017584055662155151367,
      -0.039745520800352096558,
      -0.021822927519679069519,
      -0.0072338962927460670471,
      -0.00083879311569035053253,
      -0.0094792330637574195862,
      -0.0068564494140446186066,
      0.00039525484316982328892,
      -0.0040870164521038532257,
    };
static double const shibata_A4_44[] =
    {
      2.1551730632781982422,
      -3.1482026576995849609,
      3.4208805561065673828,
      -3.1343655586242675781,
      2.1552324295043945312,
      -1.2698539495468139648,
      0.50336593389511108398,
      -0.16464470326900482178,
      -0.013838037848472595215,
      -0.0062505742534995079041,
      0.0041691507212817668915,
      -0.013679158873856067657,
      -0.0024516219273209571838,
      0.00024407464661635458469,
      -0.0052452399395406246185,
      -0.00042019927059300243855,
      0.0004135201452299952507,
      0.00016322935698553919792,
      -0.00047321102465502917767,
      0.00093277986161410808563,
    };
static double const shibata_A5_44[] =
    {
      2.5096075534820556641,
      -4.2519822120666503906,
      5.4792313575744628906,
      -5.97249603271484375,
      5.294708251953125,
      -4.0664181709289550781,
      2.5247132778167724609,
      -1.3039399385452270508,
      0.44613662362098693848,
      -0.097044020891189575195,
      -0.016150593757629394531,
      -0.0060916151851415634155,
      0.01326625235378742218,
      -0.017414959147572517395,
      0.00079903466394171118736,
      7.114160212040587794e-07,
    };
static double const shibata_A6_44[] =
    {
      2.8263266086578369141,
      -5.3534359931945800781,
      7.8042058944702148438,
      -9.6793689727783203125,
      10.157135009765625,
      -9.4399957656860351562,
      7.614612579345703125,
      -5.4245176315307617188,
      3.2478282451629638672,
      -1.630185246467590332,
      0.58538019657135009766,
      -0.11710002273321151733,
      -0.033543668687343597412,
      0.0088841468095779418945,
      0.017314357683062553406,
      -0.033262729644775390625,
      0.018168220296502113342,
      -0.0068015027791261672974,
      -0.00096911948639899492264,
      0.00096489343559369444847,
    };

/* SSRC, ATH Curve B, 44100 */

static double const shibata_B0_44[] =
    {
      0.56017816066741943359,
      -0.00032013398595154285431,
      -0.28353634476661682129,
      -2.0154238882241770625e-05,
      -2.8024095399814541452e-07,
      -0.0013137641362845897675,
      -0.13863940536975860596,
      4.6821247678963118233e-07,
      -4.3743430069298483431e-06,
      -0.0040733972564339637756,
      -0.00017294117424171417952,
      0.011740575544536113739,
    };
static double const shibata_B1_44[] =
    {
      1.0638480186462402344,
      -0.66863000392913818359,
      -2.2443387024395633489e-06,
      0.011665554717183113098,
      1.3796089660900179297e-05,
      -0.15546366572380065918,
      -0.034445952624082565308,
      -0.0051354211755096912384,
      -0.04103728756308555603,
      -0.019456973299384117126,
      -0.00030115628032945096493,
      0,
    };
static double const shibata_B2_44[] =
    {
      1.5528930425643920898,
      -1.4595929384231567383,
      0.55787962675094604492,
      0.0042479122057557106018,
      -0.24744692444801330566,
      -0.010727410204708576202,
      0.024524994194507598877,
      -0.084559261798858642578,
      -0.021680492907762527466,
      -0.0078514227643609046936,
      -0.010477361269295215607,
      -0.0061291921883821487427,
      -0.0056792846880853176117,
      -0.0011211306555196642876,
      -0.0014330057892948389053,
      -0.00097884633578360080719,
      -0.00021456897957250475883,
      0.00010452028800500556827,
      0.0010217631934210658073,
      0.0014363396912813186646,
    };
static double const shibata_B3_44[] =
    {
      2.0674252510070800781,
      -2.6145982742309570312,
      1.9563752412796020508,
      -0.92442721128463745117,
      -0.0049272147007286548615,
      0.18960046768188476562,
      -0.16765585541725158691,
      -0.020780716091394424438,
      -0.00021837331587448716164,
      -0.013521989807486534119,
      -0.019153339788317680359,
      -0.0059661092236638069153,
      -0.0014546891907230019569,
      -0.0061949742957949638367,
      -0.0024373924825340509415,
      -0.0032744421623647212982,
      -0.00016406788199674338102,
      -0.00043720021494664251804,
      -0.00068944186205044388771,
      0.00069793453440070152283,
    };
static double const shibata_B4_44[] =
    {
      2.5422441959381103516,
      -3.9492623805999755859,
      4.082462310791015625,
      -3.1288163661956787109,
      1.5902516841888427734,
      -0.52063500881195068359,
      -0.034919787198305130005,
      0.054061867296695709229,
      -0.038279779255390167236,
      -0.0070470790378749370575,
      -0.022740921005606651306,
      0.0088992407545447349548,
      -0.0074287117458879947662,
      -0.0079405372962355613708,
      -0.00075413304148241877556,
      -0.00014326006930787116289,
      -0.0031513145659118890762,
      -0.00010745167674031108618,
      9.9756995041389018297e-05,
      0.0002400560770183801651,
      0.00022666374570690095425,
      -6.6967804741580039263e-06,
      0.00028052827110514044762,
      0,
    };
static double const shibata_B5_44[] =
    {
      3.0226423740386962891,
      -5.5270595550537109375,
      7.0363101959228515625,
      -6.8852219581604003906,
      5.1172428131103515625,
      -2.9304540157318115234,
      1.1258685588836669922,
      -0.25490742921829223633,
      -0.019723705947399139404,
      -0.015306896530091762543,
      0.023763004690408706665,
      -0.015180897898972034454,
      -0.013075054623186588287,
      0.0064899893477559089661,
      -0.0024698353372514247894,
      -0.0042672571726143360138,
      1.1534318673511734232e-06,
      7.4574086283973883837e-06,
      -5.058841452409978956e-07,
      -8.1296411735820583999e-06,
    };
static double const shibata_B6_44[] =
    {
      3.5288703441619873047,
      -7.3978977203369140625,
      11.062552452087402344,
      -12.915676116943359375,
      12.005429267883300781,
      -8.9765348434448242188,
      5.1754517555236816406,
      -2.1034460067749023438,
      0.34860187768936157227,
      0.21167574822902679443,
      -0.17974011600017547607,
      0.030822610482573509216,
      0.024646494537591934204,
      -0.010657157748937606812,
      -0.0079134432598948478699,
      0.0043759951367974281311,
      0.0048155616968870162964,
      -0.0055646821856498718262,
      0.0013907034881412982941,
      0.0022238297387957572937,
      -0.00068998814094811677933,
      -0.00026916823117062449455,
      0.00075513543561100959778,
      0,
    };

/* SSRC, ATH Curve A, 48000 */

static double const shibata_A0_48[] =
    {
      0.64815437793731689453,
      -0.00013292329094838351011,
      -0.15284439921379089355,
      -0.024795081466436386108,
      -0.028879294171929359436,
      -0.097741305828094482422,
      3.7233345210552215576e-05,
      3.0361816243384964764e-06,
      -2.6851517759496346116e-05,
      -0.015118855983018875122,
      -0.00011908156011486425996,
      4.0203917706094216555e-06,
      0.03214230760931968689,
      1.2108691862522391602e-06,
      0,
      2.4130819564760486173e-09,
    };
static double const shibata_A1_48[] =
    {
      1.0375014543533325195,
      -0.55585253238677978516,
      -6.2009254179429262877e-05,
      0.054276779294013977051,
      -0.14064073562622070312,
      -0.1073406711220741272,
      6.7414471232041250914e-06,
      0.00090507784625515341759,
      -0.071966759860515594482,
      -0.018717750906944274902,
      -0.0038517464417964220047,
      -0.0057432847097516059875,
      -0.0011602794984355568886,
      -0.00023562647402286529541,
      -6.1770442698616534472e-05,
      -0.0016767864581197500229,
    };
static double const shibata_A2_48[] =
    {
      1.4919577836990356445,
      -1.3089178800582885742,
      0.54051631689071655273,
      -0.00036113749956712126732,
      -0.36303195357322692871,
      0.10911127924919128418,
      0.0073106382042169570923,
      -0.11545914411544799805,
      0.00377228553406894207,
      -0.012545258738100528717,
      -0.02927248738706111908,
      -0.0050022001378238201141,
      -0.00020218851568643003702,
      -0.004905734676867723465,
      -0.0051279761828482151031,
      -0.0025056710001081228256,
    };
static double const shibata_A3_48[] =
    {
      1.9601591825485229492,
      -2.4060547351837158203,
      1.9488849639892578125,
      -1.1626639366149902344,
      0.25297921895980834961,
      0.031299483031034469604,
      -0.11234971880912780762,
      -0.028672901913523674011,
      0.0084085874259471893311,
      -0.040343299508094787598,
      -0.014730192720890045166,
      -0.0081526516005396842957,
      -0.00078110158210620284081,
      -0.010703166946768760681,
      -0.007504582870751619339,
      6.7899374698754400015e-05,
      -0.0045952727086842060089,
      -0.0015685434918850660324,
      -8.0333913501817733049e-05,
      0,
    };
static double const shibata_A4_48[] =
    {
      2.4219727516174316406,
      -3.6378045082092285156,
      3.8756568431854248047,
      -3.2019908428192138672,
      1.8469271659851074219,
      -0.76111799478530883789,
      0.083762630820274353027,
      0.064117647707462310791,
      -0.066511705517768859863,
      -0.011620322242379188538,
      -0.00089677015785127878189,
      0.0038908864371478557587,
      -0.011067331768572330475,
      -0.0016393634723499417305,
      0.0021009922493249177933,
      -0.0039737410843372344971,
      -0.00064989842940121889114,
      0.00064297980861738324165,
      0.0010019573383033275604,
      -0.00024940294679254293442,
      0.00020461704116314649582,
      0.0014896913198754191399,
      -3.6964305763831362128e-05,
      5.5592459830222651362e-05,
      0.00022196055215317755938,
      0.00011919181270059198141,
      -0.00021784781711176037788,
      -5.855178824276663363e-05,
    };
static double const shibata_A5_48[] =
    {
      2.8460333347320556641,
      -5.0355429649353027344,
      6.4927110671997070312,
      -6.6689691543579101562,
      5.3422427177429199219,
      -3.4331059455871582031,
      1.5913537740707397461,
      -0.48210138082504272461,
      -0.0084637729451060295105,
      0.035323332995176315308,
      -0.0055271289311349391937,
      -0.021560266613960266113,
      -0.0061011519283056259155,
      0.0090660518035292625427,
      -0.010759642347693443298,
      -0.0046441229060292243958,
      0.0028851281385868787766,
      -0.0027118360158056020737,
      -0.0008332781144417822361,
      6.3722327467985451221e-05,
    };
static double const shibata_A6_48[] =
    {
      3.2601516246795654297,
      -6.5575695037841796875,
      9.74866485595703125,
      -11.7130889892578125,
      11.504628181457519531,
      -9.4859628677368164062,
      6.4042730331420898438,
      -3.4772820472717285156,
      1.3327382802963256836,
      -0.26464575529098510742,
      -0.081823304295539855957,
      0.044643409550189971924,
      0.021642472594976425171,
      -0.04283212125301361084,
      0.0033832620829343795776,
      0.016050558537244796753,
      -0.019443769007921218872,
      0.0020140456035733222961,
      0.0051018465310335159302,
      -0.0049441442824900150299,
      -0.001399693894200026989,
      0.0035810119006782770157,
      -0.0022099197376519441605,
      -0.00010120005026692524552,
      0.00077120866626501083374,
      -4.7727549826959148049e-05,
      -0.00047057875781320035458,
      0.00053522014059126377106,
    };

/* SSRC, ATH Curve B, 48000 */

static double const shibata_B0_48[] =
    {
      0.6524372100830078125,
      -6.076441422919742763e-06,
      -0.23769626021385192871,
      -0.000635539996437728405,
      -1.2602968126884661615e-06,
      -9.5054092525970190763e-06,
      -0.052108168601989746094,
      -0.051929716020822525024,
      -1.5829242556719691493e-06,
      7.0671262619725894183e-08,
      8.8266028797079343349e-07,
      0.0051737497560679912567,
    };
static double const shibata_B1_48[] =
    {
      1.133047938346862793,
      -0.65767991542816162109,
      -0.00032861577346920967102,
      5.3428146884471061639e-07,
      -0.00015824155707377940416,
      -0.045498214662075042725,
      -0.11496848613023757935,
      -1.4669727534055709839e-05,
      -2.1825994735991116613e-06,
      -0.04351314157247543335,
      -0.0047881226055324077606,
      0,
    };
static double const shibata_B2_48[] =
    {
      1.6628091335296630859,
      -1.4971796274185180664,
      0.53692084550857543945,
      5.8460878790356218815e-05,
      -0.11764197796583175659,
      -0.087953954935073852539,
      -0.00031151156872510910034,
      0.0071666454896330833435,
      -0.0624333210289478302,
      -0.014062460511922836304,
      -0.00068763544550165534019,
      -0.0032515849452465772629,
      -0.0086512034758925437927,
      -0.00013604816922452300787,
      -9.8600306955631822348e-05,
      -0.00063699163729324936867,
    };
static double const shibata_B3_48[] =
    {
      2.2278966903686523438,
      -2.7684540748596191406,
      1.950432896614074707,
      -0.76130187511444091797,
      -0.059634834527969360352,
      0.09099829941987991333,
      -0.0021133834961801767349,
      -0.089261904358863830566,
      -0.0056450613774359226227,
      0.0063776262104511260986,
      -0.018127651885151863098,
      -0.0075408210977911949158,
      -0.0060678133741021156311,
      0.00023856009647715836763,
      -0.0022084014490246772766,
      -0.0037000982556492090225,
    };
static double const shibata_B4_48[] =
    {
      2.7479245662689208984,
      -4.2712616920471191406,
      4.2730498313903808594,
      -2.9785141944885253906,
      1.2957186698913574219,
      -0.31362664699554443359,
      -0.029963159933686256409,
      -0.023559728637337684631,
      0.020922580733895301819,
      -0.023302176967263221741,
      -0.0055510243400931358337,
      -0.0067555652931332588196,
      -0.0011096433736383914948,
      -0.00098128849640488624573,
      -0.0034134739544242620468,
      -0.0025581021327525377274,
      0.00023128408065531402826,
      -0.00079201703192666172981,
      -0.00075990450568497180939,
      -4.8069246076920535415e-06,
    };
static double const shibata_B5_48[] =
    {
      3.3172307014465332031,
      -6.1978197097778320312,
      7.7909684181213378906,
      -7.1505522727966308594,
      4.7267832756042480469,
      -2.1657605171203613281,
      0.50765365362167358398,
      0.028446925804018974304,
      -0.061983801424503326416,
      -0.0052601275965571403503,
      -0.0093981074169278144836,
      0.015898862853646278381,
      -0.010791713371872901917,
      -0.0031401265878230333328,
      -0.00092148158000782132149,
      0.0030198376625776290894,
      -0.0031266580335795879364,
      -0.00065209472086280584335,
      0.00054945144802331924438,
      4.1805269574979320168e-05,
    };
static double const shibata_B6_48[] =
    {
      3.8836567401885986328,
      -8.4325723648071289062,
      12.618600845336914062,
      -14.162892341613769531,
      12.145025253295898438,
      -7.9046030044555664062,
      3.6286561489105224609,
      -0.95813679695129394531,
      -0.019669502973556518555,
      0.045369073748588562012,
      0.078012384474277496338,
      -0.083914883434772491455,
      0.019228875637054443359,
      0.011115396395325660706,
      -0.0085456911474466323853,
      0,
    };

/* SSRC, ATH Curve A, 88200 */

static double const shibata_A0_88[] =
      {
	0.81275081634521484375,
	1.3415416333373286761e-07,
	-1.4003169781062752008e-05,
	-0.027366658672690391541,
	-0.06308479607105255127,
	-0.00041124963900074362755,
	-0.0014667811337858438492,
	-0.0034636424388736486435,
	-0.01444795168936252594,
	-0.050686400383710861206,
	-0.00031657953513786196709,
	-7.6081778388470411301e-07,
	1.3391935453910264187e-06,
	1.1084978268627310172e-06,
	2.3458991904590220656e-07,
	7.1970474024851682771e-09,
	-0.00024097530695144087076,
	-0.00081339181633666157722,
	-0.0027072627563029527664,
	-1.2289029655221384019e-05,
	-2.4080820821836823598e-06,
	2.6516547677601920441e-06,
	0.022208366543054580688,
	1.8090953801674913848e-07,
      };

static double const shibata_A1_88[] =
      {
	1.1759521961212158203,
	-0.004028123803436756134,
	-0.47074413299560546875,
	-0.00051633489783853292465,
	0.034613370895385742188,
	0.090879365801811218262,
	-2.4943574317148886621e-05,
	-0.040280379354953765869,
	-0.084476247429847717285,
	-0.020952062681317329407,
	6.4247273257933557034e-05,
	0.015425831079483032227,
	0.00034846802009269595146,
	-0.00021460390416905283928,
	-0.038064550608396530151,
	-0.0075228977948427200317,
	-0.00010572007158771157265,
	-0.00088893284555524587631,
	-0.0051207961514592170715,
	-0.0047091664746403694153,
	-0.0013088451232761144638,
	-0.0010616352083161473274,
	-5.3146239224588498473e-05,
	-2.692748421395663172e-05,
	7.112140337994787842e-06,
	3.7880614399909973145e-05,
	-0.00015048061322886496782,
	-0.0014544483274221420288,
	-0.00033794986666180193424,
	-0.00062911584973335266113,
	-1.7671519358941623068e-08,
	1.289341753363260068e-07,
      };

static double const shibata_A2_88[] =
      {
	2.0752036571502685547,
	-1.4316110610961914062,
	-4.1018622141564264894e-05,
	0.30747786164283752441,
	0.01503494754433631897,
	-0.0020690073724836111069,
	-0.095445446670055389404,
	-0.017573365941643714905,
	0.0015146844089031219482,
	0.0097157200798392295837,
	0.0032300157472491264343,
	-0.0011662221513688564301,
	-0.012702429667115211487,
	-0.013680535368621349335,
	-0.00032695711706764996052,
	-0.00033481238642707467079,
	0.0019418919691815972328,
	-0.0065598445944488048553,
	-0.0031848684884607791901,
	-0.0011857076315209269524,
      };

static double const shibata_A0_96[] =
      {
	0.83362782001495361328,
	4.7663510827078425791e-07,
	-5.5927204812178388238e-05,
	-0.00091767607955262064934,
	-0.085019297897815704346,
	-0.00030864097061567008495,
	-2.7474849048303440213e-05,
	-3.4470554965082556009e-05,
	-0.0068166172131896018982,
	-0.0051032402552664279938,
	-0.048310291022062301636,
	-3.4194424642919329926e-06,
	-3.9387387573697196785e-08,
	5.2296832109277602285e-06,
	2.1815125364810228348e-05,
	5.8060527408088091761e-06,
	8.8975330072571523488e-06,
	-2.8793074307031929493e-06,
	-1.0142302926396951079e-05,
	-0.00088343484094366431236,
	-6.6521701228339225054e-05,
	-4.3032446228608023375e-07,
	1.5573209566355217248e-06,
	0.0032469024881720542908,
	0.013371952809393405914,
	0.0016697095707058906555,
	0.00033745748805813491344,
	3.8218466215766966343e-05,
	8.0883961345534771681e-05,
	1.7631093214731663465e-05,
	4.7317589633166790009e-06,
	3.8150733416841831058e-07,
      };

static double const shibata_A1_96[] =
      {
	1.2260272502899169922,
	-0.0014651787932962179184,
	-0.48510685563087463379,
	-0.00016445807705167680979,
	3.7136185710551217198e-05,
	0.11480120569467544556,
	-0.00045887456508353352547,
	-0.0017981674754992127419,
	-0.077026084065437316895,
	-0.040429998189210891724,
	4.6414548705797642469e-05,
	0.00040040328167378902435,
	0.00013407132064457982779,
	0.003484065178781747818,
	-0.00048559889546595513821,
	-0.01950314640998840332,
	-0.017391569912433624268,
	-0.0019728131592273712158,
	-8.8219474037032341585e-07,
	-0.00064927618950605392456,
	-0.0049143577925860881805,
	-0.0023035951890051364899,
	-0.00063752382993698120117,
	-0.00076101027661934494972,
      };

static double const shibata_A2_96[] =
      {
	2.1041114330291748047,
	-1.4101417064666748047,
	-0.0035147387534379959106,
	0.18617971241474151611,
	0.11117676645517349243,
	-0.0013629450695589184761,
	-0.055446717888116836548,
	-0.056859914213418960571,
	-0.0039573232643306255341,
	0.0025663347914814949036,
	0.014090753160417079926,
	0.0062257084064185619354,
	-0.0065397350117564201355,
	-0.019066527485847473145,
	-0.0035695792175829410553,
	-0.001226439489983022213,
	0.00011440102389315143228,
	-0.00019808727665804326534,
	-0.0032306648790836334229,
	-0.0046777799725532531738,
	-0.0010407331865280866623,
	-0.00097329093841835856438,
	-0.00078034552279859781265,
	-0.00038853226578794419765,
	4.1947296267608180642e-05,
	0.0001729554060148075223,
	-0.00059315189719200134277,
	-0.00069724785862490534782,
	-0.00050402310444042086601,
	-0.00037623706157319247723,
	-0.00017440004739910364151,
	0,
      };

static double const shibata_A0_192[] =
      {
	0.92986786365509033203,
	2.3757004328217590228e-06,
	1.3239204008641536348e-06,
	4.5336445708699102397e-08,
	-1.0855699201783863828e-06,
	-7.5193946713625336997e-07,
	-0.010574714280664920807,
	-0.015397379174828529358,
	-0.0071734646335244178772,
	-0.0040416326373815536499,
	-0.00031543619115836918354,
	-6.079084869270445779e-06,
	-2.5614752303226850927e-05,
	-6.444113296311115846e-06,
	-0.00014342019858304411173,
	-9.9886632298762378923e-09,
	-0.00011001565144397318363,
	-0.00026444403920322656631,
	-0.018070342019200325012,
	-0.013997578062117099762,
      };

static double const shibata_A1_192[] =
      {
	1.3312897682189941406,
	0.00043348263716325163841,
	-0.0040898225270211696625,
	-0.45905736088752746582,
	-0.00030199048342183232307,
	2.5365816327393986285e-05,
	-0.00053758098511025309563,
	0.00010294133971910923719,
	0.12356997281312942505,
	-3.46512497344519943e-05,
	0.0011937879025936126709,
	-0.000649263791274279356,
	-0.0082960268482565879822,
	-0.031590048223733901978,
	-0.0019864565692842006683,
	-0.0055887317284941673279,
	-0.0046014585532248020172,
	-0.0045781680382788181305,
	-5.6712280638748779893e-05,
	0.00011149531201226636767,
	0.00028292578645050525665,
	0.00034148831036873161793,
	0.0033573799300938844681,
	0.0023941406980156898499,
	-0.00041498657083138823509,
	-6.4982996264006942511e-05,
	-0.00090611475752666592598,
	-0.0047907871194183826447,
	-0.0037444231566041707993,
	-0.00016722116561140865088,
	-0.0011758945183828473091,
	-0.0008123705047182738781,
	-1.1241873835388105363e-05,
	-0.00011657441064016893506,
	-0.00014767059474252164364,
	-1.7531696357764303684e-05,
	-0.0002746190002653747797,
	-0.00073906377656385302544,
	-0.00038272203528322279453,
	-0.00068217515945434570312,
	-0.0010574184125289320946,
	-1.5615147503922344185e-06,
	-2.1584497517324052751e-05,
	0,
      };

static double const shibata_A2_192[] =
      {
	2.1174826622009277344,
	-0.79300129413604736328,
	-0.5887165069580078125,
	-0.0045170621015131473541,
	-2.2400596208171918988e-05,
	0.34981065988540649414,
	0.0014674699632450938225,
	-0.035286050289869308472,
        -0.03057491593062877655,
	-0.0080999247729778289795,
	-0.024920884519815444946,
	-0.010276389308273792267,
	-0.002827338874340057373,
	0.011965871788561344147,
	-0.0011787357507273554802,
	0.0015875700628384947777,
	0.0012219551717862486839,
	0.0041509792208671569824,
	0.00023660375154577195644,
	-0.00023469136795029044151,
	0.00024544104235246777534,
	-0.002350530354306101799,
	-0.0010635280050337314606,
	-0.0021934446413069963455,
	0.00018601950432639569044,
	-0.00053444207878783345222,
	-0.0005648268270306289196,
	-6.5553147578611969948e-05,
	0.00050351343816146254539,
	0.00069776934105902910233,
	0.0002154307876480743289,
	0.00055884284665808081627,
	-0.00095591234276071190834,
	-0.00018323963740840554237,
	-0.001184734981507062912,
	5.5957076256163418293e-05,
	-0.00021092590759508311749,
	9.2614163804682902992e-06,
	-1.6893125575734302402e-05,
	-0.00010291898797731846571,
	-8.7052303570089861751e-06,
	-2.1893838493269868195e-05,
	2.0483348635025322437e-05,
	-9.3148359155748039484e-05,
	-5.4571984946960583329e-05,
	1.0393147931608837098e-05,
	-4.1864630475174635649e-05,
	3.3142681786557659507e-05,
	4.6412500864789763e-07,
	-3.1690757168689742684e-05,
	2.9199603886809200048e-05,
	-4.1371429688297212124e-05,
	3.0970045372669119388e-06,
	-0.00013081972429063171148,
	0,
	0,
      };
   
static double const shibata_A0_8[] =
      {
	-0.76159644126892089844,
	-0.19409510493278503418,
	0.035044945776462554932,
	2.6458980073584825732e-07,
	-0.0038298231083899736404,
	1.07096025203645695e-06,
	0.0043701459653675556183,
	-0.0010622221743687987328,
      };

static double const shibata_A1_8[] =
      {
	-1.0272867679595947266,
	-0.57039743661880493164,
	-0.22854259610176086426,
	-0.11283638328313827515,
	-0.04545628279447555542,
	-0.015480343252420425415,
	1.8298457860055350466e-07,
	0,
      };

static double const shibata_A_saturated_8[] =
      {
	-1.1738812923431396484,
	-0.87636357545852661133,
	-0.61603987216949462891,
	-0.52298575639724731445,
	-0.44386821985244750977,
	-0.38358041644096374512,
	-0.32324904203414916992,
	-0.27636924386024475098,
	-0.22878263890743255615,
	-0.1899569779634475708,
	-0.15033221244812011719,
	-0.11752252280712127686,
	-0.084870077669620513916,
	-0.057567544281482696533,
	-0.032759506255388259888,
	-0.013133523054420948029,
      };

static double const shibata_A0_11[] =
      {
	-0.53594851493835449219,
	-0.43384709954261779785,
	-8.2579242643987527117e-07,
	0.0023528621532022953033,
	0.020154647529125213623,
	-0.0076960241422057151794,
	0,
	-2.1015614137809279782e-08,
      };

static double const shibata_A1_11[] =
      {
	-0.77642798423767089844,
	-0.73626911640167236328,
	-0.28617018461227416992,
	-0.14926058053970336914,
	-0.035679142922163009644,
	-0.016192987561225891113,
	0,
	0,
      };

static double const shibata_A_saturated_11[] =
      {
	-0.90201318264007568359,
	-0.96327704191207885742,
	-0.59832245111465454102,
	-0.48709768056869506836,
	-0.36537483334541320801,
	-0.31974372267723083496,
	-0.26105600595474243164,
	-0.22021849453449249268,
	-0.17551329731941223145,
	-0.1435108184814453125,
	-0.10948005318641662598,
	-0.085198312997817993164,
	-0.059693295508623123169,
	-0.041339982300996780396,
	-0.021607741713523864746,
	-0.0095272064208984375,
      };

static double const shibata_A0_22[] =
      {
	0.24690496921539306641,
	-0.4056072533130645752,
	-0.178049430251121521,
	-0.12218115478754043579,
	-0.044338006526231765747,
	7.4252207014069426805e-06,
	0.0029117804951965808868,
	0,
      };

static double const shibata_A1_22[] =
      {
	0.091535776853561401367,
	-0.53762668371200561523,
	-0.36664107441902160645,
	-0.29549720883369445801,
	-0.25240615010261535645,
	-0.14534264802932739258,
	-0.12099406123161315918,
	-0.089816331863403320312,
	-0.049367569386959075928,
	-0.030478563159704208374,
	-0.01209077145904302597,
	-0.0082031264901161193848,
      };

static double const shibata_A_saturated_22[] =
      {
	0.06466051936149597168,
	-0.55687421560287475586,
	-0.39284247159957885742,
	-0.3238837122917175293,
	-0.28003260493278503418,
	-0.17455317080020904541,
	-0.15124039351940155029,
	-0.12386889010667800903,
	-0.087459541857242584229,
	-0.071950778365135192871,
	-0.052037805318832397461,
	-0.044413808733224868774,
	-0.029589230194687843323,
	-0.020830472931265830994,
	-0.010722415521740913391,
	-0.0067992187105119228363,
      };

static const filter_t filters[] = {
  {44100, fir,  5, 210, lip44, Shape_lipshitz},
  {46000, fir,  9, 276, fwe44, Shape_f_weighted},
  {46000, fir,  9, 160, mew44, Shape_modified_e_weighted},
  {46000, fir,  9, 321, iew44, Shape_improved_e_weighted},
  {48000, iir,  4, 220, ges48, Shape_gesemann},
  {44100, iir,  4, 230, ges44, Shape_gesemann},
  {48000, fir, 16, 301, shi48, Shape_shibata},
  {44100, fir, 20, 333, shi44, Shape_shibata},
  {37800, fir, 16, 240, shi38, Shape_shibata},
  {32000, fir, 20, 240/*TBD*/, shi32, Shape_shibata},
  {22050, fir, 20, 240/*TBD*/, shi22, Shape_shibata},
  {16000, fir, 20, 240/*TBD*/, shi16, Shape_shibata},
  {11025, fir, 20, 240/*TBD*/, shi11, Shape_shibata},
  { 8000, fir, 20, 240/*TBD*/, shi08, Shape_shibata},
  {48000, fir, 16, 250, shl48, Shape_low_shibata},
  {44100, fir, 15, 250, shl44, Shape_low_shibata},
  {44100, fir, 20, 383, shh44, Shape_high_shibata},

  {44100, fir, 12, 240/*TBD*/, shibata_A0_44, Shape_shibata_A0},
  {44100, fir, 12, 240/*TBD*/, shibata_A1_44, Shape_shibata_A1},
  {44100, fir, 24, 240/*TBD*/, shibata_A2_44, Shape_shibata_A2},
  {44100, fir, 16, 240/*TBD*/, shibata_A3_44, Shape_shibata_A3},
  {44100, fir, 20, 240/*TBD*/, shibata_A4_44, Shape_shibata_A4},
  {44100, fir, 16, 240/*TBD*/, shibata_A5_44, Shape_shibata_A5},
  {44100, fir, 20, 240/*TBD*/, shibata_A6_44, Shape_shibata_A6},

  {44100, fir, 12, 240/*TBD*/, shibata_B0_44, Shape_shibata_B0},
  {44100, fir, 11, 240/*TBD*/, shibata_B1_44, Shape_shibata_B1},
  {44100, fir, 20, 240/*TBD*/, shibata_B2_44, Shape_shibata_B2},
  {44100, fir, 20, 240/*TBD*/, shibata_B3_44, Shape_shibata_B3},
  {44100, fir, 23, 240/*TBD*/, shibata_B4_44, Shape_shibata_B4},
  {44100, fir, 20, 240/*TBD*/, shibata_B5_44, Shape_shibata_B5},
  {44100, fir, 24, 240/*TBD*/, shibata_B6_44, Shape_shibata_B6},

  {48000, fir, 16, 240/*TBD*/, shibata_A0_48, Shape_shibata_A0},
  {48000, fir, 16, 240/*TBD*/, shibata_A1_48, Shape_shibata_A1},
  {48000, fir, 16, 240/*TBD*/, shibata_A2_48, Shape_shibata_A2},
  {48000, fir, 19, 240/*TBD*/, shibata_A3_48, Shape_shibata_A3},
  {48000, fir, 28, 240/*TBD*/, shibata_A4_48, Shape_shibata_A4},
  {48000, fir, 20, 240/*TBD*/, shibata_A5_48, Shape_shibata_A5},
  {48000, fir, 28, 240/*TBD*/, shibata_A6_48, Shape_shibata_A6},

  {48000, fir, 12, 240/*TBD*/, shibata_B0_48, Shape_shibata_B0},
  {48000, fir, 11, 240/*TBD*/, shibata_B1_48, Shape_shibata_B1},
  {48000, fir, 16, 240/*TBD*/, shibata_B2_48, Shape_shibata_B2},
  {48000, fir, 16, 240/*TBD*/, shibata_B3_48, Shape_shibata_B3},
  {48000, fir, 20, 240/*TBD*/, shibata_B4_48, Shape_shibata_B4},
  {48000, fir, 20, 240/*TBD*/, shibata_B5_48, Shape_shibata_B5},
  {48000, fir, 16, 240/*TBD*/, shibata_B6_48, Shape_shibata_B6},

  {88200, fir, 24, 240/*TBD*/, shibata_A0_88, Shape_shibata_A0},
  {88200, fir, 32, 240/*TBD*/, shibata_A1_88, Shape_shibata_A1},
  {88200, fir, 20, 240/*TBD*/, shibata_A2_88, Shape_shibata_A2},

  {96000, fir, 32, 240/*TBD*/, shibata_A0_96, Shape_shibata_A0},
  {96000, fir, 24, 240/*TBD*/, shibata_A1_96, Shape_shibata_A1},
  {96000, fir, 31, 240/*TBD*/, shibata_A2_96, Shape_shibata_A2},

  {192000, fir, 20, 240/*TBD*/, shibata_A0_192, Shape_shibata_A0},
  {192000, fir, 44, 240/*TBD*/, shibata_A1_192, Shape_shibata_A1},
  {192000, fir, 54, 240/*TBD*/, shibata_A2_192, Shape_shibata_A2},

  {8000, fir, 8, 240/*TBD*/, shibata_A0_8, Shape_shibata_A0},
  {8000, fir, 7, 240/*TBD*/, shibata_A1_8, Shape_shibata_A1},
  {8000, fir, 16, 240/*TBD*/, shibata_A_saturated_8, Shape_shibata_A_saturated},

  {11025, fir, 8, 240/*TBD*/, shibata_A0_11, Shape_shibata_A0},
  {11025, fir, 6, 240/*TBD*/, shibata_A1_11, Shape_shibata_A1},
  {11025, fir, 16, 240/*TBD*/, shibata_A_saturated_11, Shape_shibata_A_saturated},

  {22050, fir, 7, 240/*TBD*/, shibata_A0_22, Shape_shibata_A0},
  {22050, fir, 12, 240/*TBD*/, shibata_A1_22, Shape_shibata_A1},
  {22050, fir, 16, 240/*TBD*/, shibata_A_saturated_22, Shape_shibata_A_saturated},

  {    0, fir,  0,   0,  NULL, Shape_none},
};

#define MAX_N 28

typedef struct {
  filter_name_t filter_name;
  sox_bool      auto_detect, alt_tpdf;
  double        dummy;

  double        previous_errors[MAX_N * 2];
  double        previous_outputs[MAX_N * 2];
  size_t        pos, precision;
  uint64_t      num_output;
  int32_t       history, ranqd1, r;
  double const  * coefs;
  sox_bool      dither_off;
  sox_effect_handler_flow flow;
  sdm_t         *sdm;
} priv_t;

#define CONVOLVE _ _ _ _
#define NAME flow_iir_4
#define IIR
#define N 4
#include "dither.h"
#undef IIR
#define CONVOLVE _ _ _ _ _
#define NAME flow_fir_5
#define N 5
#include "dither.h"
#define CONVOLVE _ _ _ _ _ _ _ _ _
#define NAME flow_fir_9
#define N 9
#include "dither.h"
#define CONVOLVE _ _ _ _ _ _ _ _ _ _ _
#define NAME flow_fir_11
#define N 11
#include "dither.h"
#define CONVOLVE _ _ _ _ _ _ _ _ _ _ _ _
#define NAME flow_fir_12
#define N 12
#include "dither.h"
#define CONVOLVE _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
#define NAME flow_fir_15
#define N 15
#include "dither.h"
#define CONVOLVE _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
#define NAME flow_fir_16
#define N 16
#include "dither.h"
#define CONVOLVE _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
#define NAME flow_fir_19
#define N 19
#include "dither.h"
#define CONVOLVE _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
#define NAME flow_fir_20
#define N 20
#include "dither.h"
#define CONVOLVE _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
#define NAME flow_fir_23
#define N 23
#include "dither.h"
#define CONVOLVE _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
#define NAME flow_fir_24
#define N 24
#include "dither.h"
#define CONVOLVE _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
#define NAME flow_fir_28
#define N 28
#include "dither.h"


static int flow_sdm(sox_effect_t * effp, const sox_sample_t * ibuf,
    sox_sample_t * obuf, size_t * isamp, size_t * osamp)
{
  priv_t * p = (priv_t *)effp->priv;
  return sdm_process(p->sdm, ibuf, obuf, isamp, osamp);
}

static int flow_no_shape(sox_effect_t * effp, const sox_sample_t * ibuf,
    sox_sample_t * obuf, size_t * isamp, size_t * osamp)
{
  priv_t * p = (priv_t *)effp->priv;
  size_t len = *isamp = *osamp = min(*isamp, *osamp);

  while (len--) {
    if (p->auto_detect) {
      p->history = (p->history << 1) +
          !!(*ibuf & (((unsigned)-1) >> p->precision));
      if (p->history && p->dither_off) {
        p->dither_off = sox_false;
        lsx_debug("flow %" PRIuPTR ": on  @ %" PRIu64, effp->flow, p->num_output);
      } else if (!p->history && !p->dither_off) {
        p->dither_off = sox_true;
        lsx_debug("flow %" PRIuPTR ": off @ %" PRIu64, effp->flow, p->num_output);
      }
    }

    if (!p->dither_off) {
      int32_t r = RANQD1 >> p->precision;
      double d = ((double)*ibuf++ + r + (p->alt_tpdf? -p->r : (RANQD1 >> p->precision))) / (1 << (32 - p->precision));
      int i = d < 0? d - .5 : d + .5;
      p->r = r;
      if (i <= (int)((unsigned)-1 << (p->precision-1)))
        ++effp->clips, *obuf = SOX_SAMPLE_MIN;
      else if (i > (int)SOX_INT_MAX(p->precision))
        ++effp->clips, *obuf = SOX_INT_MAX(p->precision) << (32 - p->precision);
      else *obuf = i << (32 - p->precision);
      ++obuf;
    }
    else
      *obuf++ = *ibuf++;
    ++p->num_output;
  }
  return SOX_SUCCESS;
}

static int getopts_dither(sox_effect_t * effp, int argc, char * * argv)
{
  priv_t * p = (priv_t *)effp->priv;
  int c;
  lsx_getopt_t optstate;
  lsx_getopt_init(argc, argv, "+aSsf:p:", NULL, lsx_getopt_flag_none, 1, &optstate);

  while ((c = lsx_getopt(&optstate)) != -1) switch (c) {
    case 'a': p->auto_detect = sox_true; break;
    case 'S': p->alt_tpdf = sox_true; break;
    case 's': p->filter_name = Shape_shibata; break;
    case 'f':
      p->filter_name = lsx_enum_option(c, optstate.arg, filter_names);
      if (p->filter_name == INT_MAX)
        return SOX_EOF;
      break;
    GETOPT_NUMERIC(optstate, 'p', precision, 1, 24)
    default: /* invalid option or missing obligatory argument */
      if (optstate.ind > argc) {
        lsx_fail("-%c what?", optstate.opt);
      } else {
        lsx_fail("invalid option `-%c'", optstate.opt);
	return lsx_usage(effp);
      }
      return SOX_EOF;
  }
  argc -= optstate.ind, argv += optstate.ind;
  if (argc) {
    lsx_fail("extra argument `%s'", argv[0]);
    return SOX_EOF;
  }
  return SOX_SUCCESS;
}

static int start_dither(sox_effect_t * effp)
{
  priv_t * p = (priv_t *)effp->priv;
  double mult = 1; /* Amount the noise shaping multiplies up the TPDF (+/-1) */

  if (p->precision == 0)
    p->precision = effp->out_signal.precision;

  if (effp->in_signal.precision <= p->precision || p->precision > 24)
    return SOX_EFF_NULL;   /* Dithering not needed at this resolution */

  effp->out_signal.precision = effp->in_signal.precision;

  if (p->precision == 1) {
    p->sdm = sdm_init(NULL, effp->in_signal.rate, 0, 0, 0);
    if (!p->sdm)
      return SOX_EOF;

    p->flow = flow_sdm;
    return SOX_SUCCESS;
  }

  p->flow = flow_no_shape;
  if (p->filter_name) {
    filter_t const * f;

    for (f = filters; f->len && (f->name != p->filter_name || fabs(effp->in_signal.rate - f->rate) / f->rate > .05); ++f); /* 5% leeway on frequency */
    if (!f->len) {
      p->alt_tpdf |= effp->in_signal.rate >= 22050;
      if (!effp->flow)
        lsx_warn("no `%s' filter is available for rate %g; using %s TPDF",
            lsx_find_enum_value(p->filter_name, filter_names)->text,
            effp->in_signal.rate, p->alt_tpdf? "sloped" : "plain");
    }
    else {
      assert(f->len <= MAX_N);
      if (f->type == fir) switch(f->len) {
        case  5: p->flow = flow_fir_5 ; break;
        case  9: p->flow = flow_fir_9 ; break;
        case 11: p->flow = flow_fir_11; break;
        case 12: p->flow = flow_fir_12; break;
        case 15: p->flow = flow_fir_15; break;
        case 16: p->flow = flow_fir_16; break;
        case 19: p->flow = flow_fir_19; break;
        case 20: p->flow = flow_fir_20; break;
        case 23: p->flow = flow_fir_23; break;
        case 24: p->flow = flow_fir_24; break;
        case 28: p->flow = flow_fir_28; break;
        default: assert(sox_false);
      } else switch(f->len) {
        case  4: p->flow = flow_iir_4 ; break;
        default: assert(sox_false);
      }
      p->coefs = f->coefs;
      mult = dB_to_linear(f->gain_cB * 0.1);
    }
  }
  p->ranqd1 = ranqd1(sox_globals.ranqd1) + effp->flow;
  if (effp->in_signal.mult) /* (Takes account of ostart mult (sox.c). */
    *effp->in_signal.mult *= (SOX_SAMPLE_MAX - (1 << (31 - p->precision)) *
        (2 * mult + 1)) / (SOX_SAMPLE_MAX - (1 << (31 - p->precision)));
  return SOX_SUCCESS;
}

static int flow_dither(sox_effect_t * effp, const sox_sample_t * ibuf,
    sox_sample_t * obuf, size_t * isamp, size_t * osamp)
{
  priv_t * p = (priv_t *)effp->priv;
  return p->flow(effp, ibuf, obuf, isamp, osamp);
}

static int drain_dither(sox_effect_t * effp, sox_sample_t * obuf, size_t * osamp)
{
  priv_t * p = (priv_t *)effp->priv;
  if (p->sdm)
    return sdm_drain(p->sdm, obuf, osamp);
  *osamp = 0;
  return SOX_SUCCESS;
}

static int stop_dither(sox_effect_t * effp)
{
  priv_t * p = (priv_t *)effp->priv;
  if (p->sdm)
    sdm_close(p->sdm);
  return SOX_SUCCESS;
}

sox_effect_handler_t const * lsx_dither_effect_fn(void)
{
  static const char usage[] = "[-S|-s|-f filter] [-a] [-p precision]";
  static char const * const extra_usage[] = {
    "(none)   Use TPDF",
    "-S       Use sloped TPDF (without noise shaping)",
    "-s       Shape noise (with a Shibata filter)",
    "-f name  Set shaping filter to one of: lipshitz, f-weighted,",
    "         modified-e-weighted, improved-e-weighted, gesemann,",
    "         shibata, low-shibata, high-shibata, shibata-A0 to shibata-B6",
    "-a       Automatically turn dithering on & off as needed (use with caution!)",
    "-p bits  Override the target sample precision",
    NULL
  };
  static sox_effect_handler_t handler = {
    "dither", usage, extra_usage, SOX_EFF_PREC,
    getopts_dither, start_dither, flow_dither, drain_dither, stop_dither, 0,
    sizeof(priv_t)
  };
  return &handler;
}
