/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// LifecycleApplyConfiguration represents a declarative configuration of the Lifecycle type for use
// with apply.
//
// Lifecycle describes actions that the management system should take in response to container lifecycle
// events. For the PostStart and PreStop lifecycle handlers, management of the container blocks
// until the action is complete, unless the container process fails, in which case the handler is aborted.
type LifecycleApplyConfiguration struct {
	// PostStart is called immediately after a container is created. If the handler fails,
	// the container is terminated and restarted according to its restart policy.
	// Other management of the container blocks until the hook completes.
	// More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
	PostStart *LifecycleHandlerApplyConfiguration `json:"postStart,omitempty"`
	// PreStop is called immediately before a container is terminated due to an
	// API request or management event such as liveness/startup probe failure,
	// preemption, resource contention, etc. The handler is not called if the
	// container crashes or exits. The Pod's termination grace period countdown begins before the
	// PreStop hook is executed. Regardless of the outcome of the handler, the
	// container will eventually terminate within the Pod's termination grace
	// period (unless delayed by finalizers). Other management of the container blocks until the hook completes
	// or until the termination grace period is reached.
	// More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
	PreStop *LifecycleHandlerApplyConfiguration `json:"preStop,omitempty"`
	// StopSignal defines which signal will be sent to a container when it is being stopped.
	// If not specified, the default is defined by the container runtime in use.
	// StopSignal can only be set for Pods with a non-empty .spec.os.name
	StopSignal *corev1.Signal `json:"stopSignal,omitempty"`
}

// LifecycleApplyConfiguration constructs a declarative configuration of the Lifecycle type for use with
// apply.
func Lifecycle() *LifecycleApplyConfiguration {
	return &LifecycleApplyConfiguration{}
}

// WithPostStart sets the PostStart field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PostStart field is set to the value of the last call.
func (b *LifecycleApplyConfiguration) WithPostStart(value *LifecycleHandlerApplyConfiguration) *LifecycleApplyConfiguration {
	b.PostStart = value
	return b
}

// WithPreStop sets the PreStop field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PreStop field is set to the value of the last call.
func (b *LifecycleApplyConfiguration) WithPreStop(value *LifecycleHandlerApplyConfiguration) *LifecycleApplyConfiguration {
	b.PreStop = value
	return b
}

// WithStopSignal sets the StopSignal field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StopSignal field is set to the value of the last call.
func (b *LifecycleApplyConfiguration) WithStopSignal(value corev1.Signal) *LifecycleApplyConfiguration {
	b.StopSignal = &value
	return b
}
