const char metrics_stash_lua[] =
"-- Based on https://github.com/tarantool/crud/blob/73bf5bf9353f9b9ee69c95bb14c610be8f2daeac/crud/common/stash.lua\n"
"\n"
"local stash = {}\n"
"\n"
"--- Available stashes list.\n"
"--\n"
"-- @tfield string cfg\n"
"--  Stash for metrics module configuration.\n"
"--\n"
"stash.name = {\n"
"    cfg = '__metrics_cfg',\n"
"    cfg_internal = '__metrics_cfg_internal'\n"
"}\n"
"\n"
"--- Setup Tarantool Cartridge reload.\n"
"--\n"
"-- @function setup_cartridge_reload\n"
"--\n"
"-- @return Returns\n"
"--\n"
"function stash.setup_cartridge_reload()\n"
"    local hotreload = require('cartridge.hotreload')\n"
"    for _, name in pairs(stash.name) do\n"
"        hotreload.whitelist_globals({ name })\n"
"    end\n"
"end\n"
"\n"
"--- Get a stash instance, initialize if needed.\n"
"--\n"
"--  Stashes are persistent to package reload.\n"
"--  To use them with Cartridge roles reload,\n"
"--  call `stash.setup_cartridge_reload` in role.\n"
"--\n"
"-- @function get\n"
"--\n"
"-- @string name\n"
"--  Stash identifier. Use one from `stash.name` table.\n"
"--\n"
"-- @treturn table A stash instance.\n"
"--\n"
"function stash.get(name)\n"
"    local instance = rawget(_G, name) or {}\n"
"    rawset(_G, name, instance)\n"
"\n"
"    return instance\n"
"end\n"
"\n"
"return stash\n"
""
;
