// python wrapper for ttkMergeTreeClustering
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMergeTreeClustering.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMergeTreeClustering(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMergeTreeClustering_ClassNew(); }


static PyObject *
PyttkMergeTreeClustering_SetEpsilon1UseFarthestSaddle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon1UseFarthestSaddle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon1UseFarthestSaddle(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetEpsilon1UseFarthestSaddle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetEpsilon1UseFarthestSaddle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon1UseFarthestSaddle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEpsilon1UseFarthestSaddle() :
      op->ttkMergeTreeClustering::GetEpsilon1UseFarthestSaddle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetEpsilonTree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilonTree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilonTree1(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetEpsilonTree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetEpsilonTree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilonTree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEpsilonTree1() :
      op->ttkMergeTreeClustering::GetEpsilonTree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetEpsilon2Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon2Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon2Tree1(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetEpsilon2Tree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetEpsilon2Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon2Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEpsilon2Tree1() :
      op->ttkMergeTreeClustering::GetEpsilon2Tree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetEpsilon3Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon3Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon3Tree1(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetEpsilon3Tree1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetEpsilon3Tree1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon3Tree1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEpsilon3Tree1() :
      op->ttkMergeTreeClustering::GetEpsilon3Tree1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetPersistenceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPersistenceThreshold(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetPersistenceThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetPersistenceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPersistenceThreshold() :
      op->ttkMergeTreeClustering::GetPersistenceThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetUseMinMaxPair(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseMinMaxPair");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseMinMaxPair(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetUseMinMaxPair(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetUseMinMaxPair(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseMinMaxPair");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseMinMaxPair() :
      op->ttkMergeTreeClustering::GetUseMinMaxPair());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetDeleteMultiPersPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeleteMultiPersPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeleteMultiPersPairs(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetDeleteMultiPersPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetDeleteMultiPersPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeleteMultiPersPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDeleteMultiPersPairs() :
      op->ttkMergeTreeClustering::GetDeleteMultiPersPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetBackend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackend(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetBackend(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetBackend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBackend() :
      op->ttkMergeTreeClustering::GetBackend());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetAlpha(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAlpha(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetAlpha(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetAlpha(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetAlpha() :
      op->ttkMergeTreeClustering::GetAlpha());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetAssignmentSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAssignmentSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAssignmentSolver(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetAssignmentSolver(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetAssignmentSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAssignmentSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAssignmentSolver() :
      op->ttkMergeTreeClustering::GetAssignmentSolver());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetBranchDecomposition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBranchDecomposition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBranchDecomposition(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetBranchDecomposition(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetBranchDecomposition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBranchDecomposition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetBranchDecomposition() :
      op->ttkMergeTreeClustering::GetBranchDecomposition());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetDeterministic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeterministic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeterministic(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetDeterministic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetDeterministic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeterministic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDeterministic() :
      op->ttkMergeTreeClustering::GetDeterministic());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetNormalizedWasserstein(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalizedWasserstein");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNormalizedWasserstein(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetNormalizedWasserstein(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetNormalizedWasserstein(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNormalizedWasserstein");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNormalizedWasserstein() :
      op->ttkMergeTreeClustering::GetNormalizedWasserstein());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetKeepSubtree(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeepSubtree");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeepSubtree(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetKeepSubtree(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetKeepSubtree(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetKeepSubtree");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetKeepSubtree() :
      op->ttkMergeTreeClustering::GetKeepSubtree());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetJoinSplitMixtureCoefficient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetJoinSplitMixtureCoefficient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetJoinSplitMixtureCoefficient(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetJoinSplitMixtureCoefficient(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetJoinSplitMixtureCoefficient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetJoinSplitMixtureCoefficient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetJoinSplitMixtureCoefficient() :
      op->ttkMergeTreeClustering::GetJoinSplitMixtureCoefficient());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetComputeBarycenter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeBarycenter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeBarycenter(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetComputeBarycenter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetComputeBarycenter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeBarycenter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeBarycenter() :
      op->ttkMergeTreeClustering::GetComputeBarycenter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetNumberOfBarycenters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfBarycenters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfBarycenters(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetNumberOfBarycenters(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetNumberOfBarycenters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfBarycenters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfBarycenters() :
      op->ttkMergeTreeClustering::GetNumberOfBarycenters());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetBarycenterSizeLimitPercent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBarycenterSizeLimitPercent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBarycenterSizeLimitPercent(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetBarycenterSizeLimitPercent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetBarycenterSizeLimitPercent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBarycenterSizeLimitPercent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetBarycenterSizeLimitPercent() :
      op->ttkMergeTreeClustering::GetBarycenterSizeLimitPercent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetBranchMetric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBranchMetric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBranchMetric(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetBranchMetric(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetPathMetric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPathMetric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPathMetric(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetPathMetric(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetNonMatchingWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNonMatchingWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNonMatchingWeight(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetNonMatchingWeight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetNonMatchingWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNonMatchingWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetNonMatchingWeight() :
      op->ttkMergeTreeClustering::GetNonMatchingWeight());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetBarycenterPositionAlpha(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBarycenterPositionAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBarycenterPositionAlpha(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetBarycenterPositionAlpha(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetBarycenterPositionAlpha(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBarycenterPositionAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetBarycenterPositionAlpha() :
      op->ttkMergeTreeClustering::GetBarycenterPositionAlpha());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetOutputTrees(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputTrees");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputTrees(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetOutputTrees(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetOutputTrees(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputTrees");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOutputTrees() :
      op->ttkMergeTreeClustering::GetOutputTrees());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetOutputSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputSegmentation(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetOutputSegmentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetOutputSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOutputSegmentation() :
      op->ttkMergeTreeClustering::GetOutputSegmentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetPlanarLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPlanarLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPlanarLayout(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetPlanarLayout(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetPlanarLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPlanarLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPlanarLayout() :
      op->ttkMergeTreeClustering::GetPlanarLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetBranchDecompositionPlanarLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBranchDecompositionPlanarLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBranchDecompositionPlanarLayout(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetBranchDecompositionPlanarLayout(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetBranchDecompositionPlanarLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBranchDecompositionPlanarLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetBranchDecompositionPlanarLayout() :
      op->ttkMergeTreeClustering::GetBranchDecompositionPlanarLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetBranchSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBranchSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBranchSpacing(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetBranchSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetBranchSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBranchSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetBranchSpacing() :
      op->ttkMergeTreeClustering::GetBranchSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetRescaleTreesIndividually(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRescaleTreesIndividually");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRescaleTreesIndividually(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetRescaleTreesIndividually(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetRescaleTreesIndividually(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRescaleTreesIndividually");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRescaleTreesIndividually() :
      op->ttkMergeTreeClustering::GetRescaleTreesIndividually());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetDimensionSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDimensionSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDimensionSpacing(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetDimensionSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetDimensionSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDimensionSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetDimensionSpacing() :
      op->ttkMergeTreeClustering::GetDimensionSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetDimensionToShift(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDimensionToShift");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDimensionToShift(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetDimensionToShift(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetDimensionToShift(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDimensionToShift");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDimensionToShift() :
      op->ttkMergeTreeClustering::GetDimensionToShift());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImportantPairs(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetImportantPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetImportantPairs() :
      op->ttkMergeTreeClustering::GetImportantPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetMaximumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaximumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaximumImportantPairs(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetMaximumImportantPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetMaximumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaximumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMaximumImportantPairs() :
      op->ttkMergeTreeClustering::GetMaximumImportantPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetMinimumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinimumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinimumImportantPairs(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetMinimumImportantPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetMinimumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinimumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMinimumImportantPairs() :
      op->ttkMergeTreeClustering::GetMinimumImportantPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImportantPairsSpacing(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetImportantPairsSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetImportantPairsSpacing() :
      op->ttkMergeTreeClustering::GetImportantPairsSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetNonImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNonImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNonImportantPairsSpacing(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetNonImportantPairsSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetNonImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNonImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetNonImportantPairsSpacing() :
      op->ttkMergeTreeClustering::GetNonImportantPairsSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetNonImportantPairsProximity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNonImportantPairsProximity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNonImportantPairsProximity(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetNonImportantPairsProximity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetNonImportantPairsProximity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNonImportantPairsProximity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetNonImportantPairsProximity() :
      op->ttkMergeTreeClustering::GetNonImportantPairsProximity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetExcludeImportantPairsLower(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExcludeImportantPairsLower");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExcludeImportantPairsLower(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetExcludeImportantPairsLower(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetExcludeImportantPairsLower(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExcludeImportantPairsLower");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetExcludeImportantPairsLower() :
      op->ttkMergeTreeClustering::GetExcludeImportantPairsLower());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SetExcludeImportantPairsHigher(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExcludeImportantPairsHigher");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExcludeImportantPairsHigher(temp0);
    }
    else
    {
      op->ttkMergeTreeClustering::SetExcludeImportantPairsHigher(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetExcludeImportantPairsHigher(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExcludeImportantPairsHigher");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetExcludeImportantPairsHigher() :
      op->ttkMergeTreeClustering::GetExcludeImportantPairsHigher());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMergeTreeClustering::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMergeTreeClustering::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMergeTreeClustering *tempr = ttkMergeTreeClustering::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMergeTreeClustering *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMergeTreeClustering::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMergeTreeClustering::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeClustering_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeClustering *op = static_cast<ttkMergeTreeClustering *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMergeTreeClustering::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkMergeTreeClustering_Methods[] = {
  {"SetEpsilon1UseFarthestSaddle", PyttkMergeTreeClustering_SetEpsilon1UseFarthestSaddle, METH_VARARGS,
   "SetEpsilon1UseFarthestSaddle(self, epsilon1UseFarthestSaddle:bool)\n     -> None\nC++: void SetEpsilon1UseFarthestSaddle(\n    bool epsilon1UseFarthestSaddle)\n\nAutomatically generate getters and setters of filter parameters\nvia vtkMacros.\n"},
  {"GetEpsilon1UseFarthestSaddle", PyttkMergeTreeClustering_GetEpsilon1UseFarthestSaddle, METH_VARARGS,
   "GetEpsilon1UseFarthestSaddle(self) -> bool\nC++: virtual bool GetEpsilon1UseFarthestSaddle()\n\n"},
  {"SetEpsilonTree1", PyttkMergeTreeClustering_SetEpsilonTree1, METH_VARARGS,
   "SetEpsilonTree1(self, epsilonTree1:float) -> None\nC++: void SetEpsilonTree1(double epsilonTree1)\n\n"},
  {"GetEpsilonTree1", PyttkMergeTreeClustering_GetEpsilonTree1, METH_VARARGS,
   "GetEpsilonTree1(self) -> float\nC++: virtual double GetEpsilonTree1()\n\n"},
  {"SetEpsilon2Tree1", PyttkMergeTreeClustering_SetEpsilon2Tree1, METH_VARARGS,
   "SetEpsilon2Tree1(self, epsilon2Tree1:float) -> None\nC++: void SetEpsilon2Tree1(double epsilon2Tree1)\n\n"},
  {"GetEpsilon2Tree1", PyttkMergeTreeClustering_GetEpsilon2Tree1, METH_VARARGS,
   "GetEpsilon2Tree1(self) -> float\nC++: virtual double GetEpsilon2Tree1()\n\n"},
  {"SetEpsilon3Tree1", PyttkMergeTreeClustering_SetEpsilon3Tree1, METH_VARARGS,
   "SetEpsilon3Tree1(self, epsilon3Tree1:float) -> None\nC++: void SetEpsilon3Tree1(double epsilon3Tree1)\n\n"},
  {"GetEpsilon3Tree1", PyttkMergeTreeClustering_GetEpsilon3Tree1, METH_VARARGS,
   "GetEpsilon3Tree1(self) -> float\nC++: virtual double GetEpsilon3Tree1()\n\n"},
  {"SetPersistenceThreshold", PyttkMergeTreeClustering_SetPersistenceThreshold, METH_VARARGS,
   "SetPersistenceThreshold(self, persistenceThreshold:float) -> None\nC++: void SetPersistenceThreshold(double persistenceThreshold)\n\n"},
  {"GetPersistenceThreshold", PyttkMergeTreeClustering_GetPersistenceThreshold, METH_VARARGS,
   "GetPersistenceThreshold(self) -> float\nC++: virtual double GetPersistenceThreshold()\n\n"},
  {"SetUseMinMaxPair", PyttkMergeTreeClustering_SetUseMinMaxPair, METH_VARARGS,
   "SetUseMinMaxPair(self, useMinMaxPair:bool) -> None\nC++: void SetUseMinMaxPair(bool useMinMaxPair)\n\n"},
  {"GetUseMinMaxPair", PyttkMergeTreeClustering_GetUseMinMaxPair, METH_VARARGS,
   "GetUseMinMaxPair(self) -> bool\nC++: virtual bool GetUseMinMaxPair()\n\n"},
  {"SetDeleteMultiPersPairs", PyttkMergeTreeClustering_SetDeleteMultiPersPairs, METH_VARARGS,
   "SetDeleteMultiPersPairs(self, deleteMultiPersPairs:bool) -> None\nC++: void SetDeleteMultiPersPairs(bool deleteMultiPersPairs)\n\n"},
  {"GetDeleteMultiPersPairs", PyttkMergeTreeClustering_GetDeleteMultiPersPairs, METH_VARARGS,
   "GetDeleteMultiPersPairs(self) -> bool\nC++: virtual bool GetDeleteMultiPersPairs()\n\n"},
  {"SetBackend", PyttkMergeTreeClustering_SetBackend, METH_VARARGS,
   "SetBackend(self, newBackend:int) -> None\nC++: void SetBackend(int newBackend)\n\n"},
  {"GetBackend", PyttkMergeTreeClustering_GetBackend, METH_VARARGS,
   "GetBackend(self) -> int\nC++: virtual int GetBackend()\n\n"},
  {"SetAlpha", PyttkMergeTreeClustering_SetAlpha, METH_VARARGS,
   "SetAlpha(self, alpha:float) -> None\nC++: void SetAlpha(double alpha)\n\n"},
  {"GetAlpha", PyttkMergeTreeClustering_GetAlpha, METH_VARARGS,
   "GetAlpha(self) -> float\nC++: virtual double GetAlpha()\n\n"},
  {"SetAssignmentSolver", PyttkMergeTreeClustering_SetAssignmentSolver, METH_VARARGS,
   "SetAssignmentSolver(self, assignmentSolver:int) -> None\nC++: void SetAssignmentSolver(int assignmentSolver)\n\n"},
  {"GetAssignmentSolver", PyttkMergeTreeClustering_GetAssignmentSolver, METH_VARARGS,
   "GetAssignmentSolver(self) -> int\nC++: virtual int GetAssignmentSolver()\n\n"},
  {"SetBranchDecomposition", PyttkMergeTreeClustering_SetBranchDecomposition, METH_VARARGS,
   "SetBranchDecomposition(self, branchDecomposition:bool) -> None\nC++: void SetBranchDecomposition(bool branchDecomposition)\n\n"},
  {"GetBranchDecomposition", PyttkMergeTreeClustering_GetBranchDecomposition, METH_VARARGS,
   "GetBranchDecomposition(self) -> bool\nC++: virtual bool GetBranchDecomposition()\n\n"},
  {"SetDeterministic", PyttkMergeTreeClustering_SetDeterministic, METH_VARARGS,
   "SetDeterministic(self, deterministic:bool) -> None\nC++: void SetDeterministic(bool deterministic)\n\n"},
  {"GetDeterministic", PyttkMergeTreeClustering_GetDeterministic, METH_VARARGS,
   "GetDeterministic(self) -> bool\nC++: virtual bool GetDeterministic()\n\n"},
  {"SetNormalizedWasserstein", PyttkMergeTreeClustering_SetNormalizedWasserstein, METH_VARARGS,
   "SetNormalizedWasserstein(self, normalizedWasserstein:bool) -> None\nC++: void SetNormalizedWasserstein(bool normalizedWasserstein)\n\n"},
  {"GetNormalizedWasserstein", PyttkMergeTreeClustering_GetNormalizedWasserstein, METH_VARARGS,
   "GetNormalizedWasserstein(self) -> bool\nC++: virtual bool GetNormalizedWasserstein()\n\n"},
  {"SetKeepSubtree", PyttkMergeTreeClustering_SetKeepSubtree, METH_VARARGS,
   "SetKeepSubtree(self, keepSubtree:bool) -> None\nC++: void SetKeepSubtree(bool keepSubtree)\n\n"},
  {"GetKeepSubtree", PyttkMergeTreeClustering_GetKeepSubtree, METH_VARARGS,
   "GetKeepSubtree(self) -> bool\nC++: virtual bool GetKeepSubtree()\n\n"},
  {"SetJoinSplitMixtureCoefficient", PyttkMergeTreeClustering_SetJoinSplitMixtureCoefficient, METH_VARARGS,
   "SetJoinSplitMixtureCoefficient(self,\n    joinSplitMixtureCoefficient:float) -> None\nC++: void SetJoinSplitMixtureCoefficient(\n    double joinSplitMixtureCoefficient)\n\n"},
  {"GetJoinSplitMixtureCoefficient", PyttkMergeTreeClustering_GetJoinSplitMixtureCoefficient, METH_VARARGS,
   "GetJoinSplitMixtureCoefficient(self) -> float\nC++: virtual double GetJoinSplitMixtureCoefficient()\n\n"},
  {"SetComputeBarycenter", PyttkMergeTreeClustering_SetComputeBarycenter, METH_VARARGS,
   "SetComputeBarycenter(self, computeBarycenter:bool) -> None\nC++: void SetComputeBarycenter(bool computeBarycenter)\n\n"},
  {"GetComputeBarycenter", PyttkMergeTreeClustering_GetComputeBarycenter, METH_VARARGS,
   "GetComputeBarycenter(self) -> bool\nC++: virtual bool GetComputeBarycenter()\n\n"},
  {"SetNumberOfBarycenters", PyttkMergeTreeClustering_SetNumberOfBarycenters, METH_VARARGS,
   "SetNumberOfBarycenters(self, numberOfBarycenters:int) -> None\nC++: void SetNumberOfBarycenters(unsigned int numberOfBarycenters)\n\n"},
  {"GetNumberOfBarycenters", PyttkMergeTreeClustering_GetNumberOfBarycenters, METH_VARARGS,
   "GetNumberOfBarycenters(self) -> int\nC++: virtual unsigned int GetNumberOfBarycenters()\n\n"},
  {"SetBarycenterSizeLimitPercent", PyttkMergeTreeClustering_SetBarycenterSizeLimitPercent, METH_VARARGS,
   "SetBarycenterSizeLimitPercent(self, percent:float) -> None\nC++: void SetBarycenterSizeLimitPercent(double percent)\n\n"},
  {"GetBarycenterSizeLimitPercent", PyttkMergeTreeClustering_GetBarycenterSizeLimitPercent, METH_VARARGS,
   "GetBarycenterSizeLimitPercent(self) -> float\nC++: virtual double GetBarycenterSizeLimitPercent()\n\n"},
  {"SetBranchMetric", PyttkMergeTreeClustering_SetBranchMetric, METH_VARARGS,
   "SetBranchMetric(self, m:int) -> None\nC++: void SetBranchMetric(int m)\n\n"},
  {"SetPathMetric", PyttkMergeTreeClustering_SetPathMetric, METH_VARARGS,
   "SetPathMetric(self, m:int) -> None\nC++: void SetPathMetric(int m)\n\n"},
  {"SetNonMatchingWeight", PyttkMergeTreeClustering_SetNonMatchingWeight, METH_VARARGS,
   "SetNonMatchingWeight(self, weight:float) -> None\nC++: void SetNonMatchingWeight(double weight)\n\n"},
  {"GetNonMatchingWeight", PyttkMergeTreeClustering_GetNonMatchingWeight, METH_VARARGS,
   "GetNonMatchingWeight(self) -> float\nC++: virtual double GetNonMatchingWeight()\n\n"},
  {"SetBarycenterPositionAlpha", PyttkMergeTreeClustering_SetBarycenterPositionAlpha, METH_VARARGS,
   "SetBarycenterPositionAlpha(self, _arg:bool) -> None\nC++: virtual void SetBarycenterPositionAlpha(bool _arg)\n\n"},
  {"GetBarycenterPositionAlpha", PyttkMergeTreeClustering_GetBarycenterPositionAlpha, METH_VARARGS,
   "GetBarycenterPositionAlpha(self) -> bool\nC++: virtual bool GetBarycenterPositionAlpha()\n\n"},
  {"SetOutputTrees", PyttkMergeTreeClustering_SetOutputTrees, METH_VARARGS,
   "SetOutputTrees(self, _arg:bool) -> None\nC++: virtual void SetOutputTrees(bool _arg)\n\n"},
  {"GetOutputTrees", PyttkMergeTreeClustering_GetOutputTrees, METH_VARARGS,
   "GetOutputTrees(self) -> bool\nC++: virtual bool GetOutputTrees()\n\n"},
  {"SetOutputSegmentation", PyttkMergeTreeClustering_SetOutputSegmentation, METH_VARARGS,
   "SetOutputSegmentation(self, _arg:bool) -> None\nC++: virtual void SetOutputSegmentation(bool _arg)\n\n"},
  {"GetOutputSegmentation", PyttkMergeTreeClustering_GetOutputSegmentation, METH_VARARGS,
   "GetOutputSegmentation(self) -> bool\nC++: virtual bool GetOutputSegmentation()\n\n"},
  {"SetPlanarLayout", PyttkMergeTreeClustering_SetPlanarLayout, METH_VARARGS,
   "SetPlanarLayout(self, _arg:bool) -> None\nC++: virtual void SetPlanarLayout(bool _arg)\n\n"},
  {"GetPlanarLayout", PyttkMergeTreeClustering_GetPlanarLayout, METH_VARARGS,
   "GetPlanarLayout(self) -> bool\nC++: virtual bool GetPlanarLayout()\n\n"},
  {"SetBranchDecompositionPlanarLayout", PyttkMergeTreeClustering_SetBranchDecompositionPlanarLayout, METH_VARARGS,
   "SetBranchDecompositionPlanarLayout(self, _arg:bool) -> None\nC++: virtual void SetBranchDecompositionPlanarLayout(bool _arg)\n\n"},
  {"GetBranchDecompositionPlanarLayout", PyttkMergeTreeClustering_GetBranchDecompositionPlanarLayout, METH_VARARGS,
   "GetBranchDecompositionPlanarLayout(self) -> bool\nC++: virtual bool GetBranchDecompositionPlanarLayout()\n\n"},
  {"SetBranchSpacing", PyttkMergeTreeClustering_SetBranchSpacing, METH_VARARGS,
   "SetBranchSpacing(self, _arg:float) -> None\nC++: virtual void SetBranchSpacing(double _arg)\n\n"},
  {"GetBranchSpacing", PyttkMergeTreeClustering_GetBranchSpacing, METH_VARARGS,
   "GetBranchSpacing(self) -> float\nC++: virtual double GetBranchSpacing()\n\n"},
  {"SetRescaleTreesIndividually", PyttkMergeTreeClustering_SetRescaleTreesIndividually, METH_VARARGS,
   "SetRescaleTreesIndividually(self, _arg:bool) -> None\nC++: virtual void SetRescaleTreesIndividually(bool _arg)\n\n"},
  {"GetRescaleTreesIndividually", PyttkMergeTreeClustering_GetRescaleTreesIndividually, METH_VARARGS,
   "GetRescaleTreesIndividually(self) -> bool\nC++: virtual bool GetRescaleTreesIndividually()\n\n"},
  {"SetDimensionSpacing", PyttkMergeTreeClustering_SetDimensionSpacing, METH_VARARGS,
   "SetDimensionSpacing(self, _arg:float) -> None\nC++: virtual void SetDimensionSpacing(double _arg)\n\n"},
  {"GetDimensionSpacing", PyttkMergeTreeClustering_GetDimensionSpacing, METH_VARARGS,
   "GetDimensionSpacing(self) -> float\nC++: virtual double GetDimensionSpacing()\n\n"},
  {"SetDimensionToShift", PyttkMergeTreeClustering_SetDimensionToShift, METH_VARARGS,
   "SetDimensionToShift(self, _arg:int) -> None\nC++: virtual void SetDimensionToShift(int _arg)\n\n"},
  {"GetDimensionToShift", PyttkMergeTreeClustering_GetDimensionToShift, METH_VARARGS,
   "GetDimensionToShift(self) -> int\nC++: virtual int GetDimensionToShift()\n\n"},
  {"SetImportantPairs", PyttkMergeTreeClustering_SetImportantPairs, METH_VARARGS,
   "SetImportantPairs(self, _arg:float) -> None\nC++: virtual void SetImportantPairs(double _arg)\n\n"},
  {"GetImportantPairs", PyttkMergeTreeClustering_GetImportantPairs, METH_VARARGS,
   "GetImportantPairs(self) -> float\nC++: virtual double GetImportantPairs()\n\n"},
  {"SetMaximumImportantPairs", PyttkMergeTreeClustering_SetMaximumImportantPairs, METH_VARARGS,
   "SetMaximumImportantPairs(self, _arg:int) -> None\nC++: virtual void SetMaximumImportantPairs(int _arg)\n\n"},
  {"GetMaximumImportantPairs", PyttkMergeTreeClustering_GetMaximumImportantPairs, METH_VARARGS,
   "GetMaximumImportantPairs(self) -> int\nC++: virtual int GetMaximumImportantPairs()\n\n"},
  {"SetMinimumImportantPairs", PyttkMergeTreeClustering_SetMinimumImportantPairs, METH_VARARGS,
   "SetMinimumImportantPairs(self, _arg:int) -> None\nC++: virtual void SetMinimumImportantPairs(int _arg)\n\n"},
  {"GetMinimumImportantPairs", PyttkMergeTreeClustering_GetMinimumImportantPairs, METH_VARARGS,
   "GetMinimumImportantPairs(self) -> int\nC++: virtual int GetMinimumImportantPairs()\n\n"},
  {"SetImportantPairsSpacing", PyttkMergeTreeClustering_SetImportantPairsSpacing, METH_VARARGS,
   "SetImportantPairsSpacing(self, _arg:float) -> None\nC++: virtual void SetImportantPairsSpacing(double _arg)\n\n"},
  {"GetImportantPairsSpacing", PyttkMergeTreeClustering_GetImportantPairsSpacing, METH_VARARGS,
   "GetImportantPairsSpacing(self) -> float\nC++: virtual double GetImportantPairsSpacing()\n\n"},
  {"SetNonImportantPairsSpacing", PyttkMergeTreeClustering_SetNonImportantPairsSpacing, METH_VARARGS,
   "SetNonImportantPairsSpacing(self, _arg:float) -> None\nC++: virtual void SetNonImportantPairsSpacing(double _arg)\n\n"},
  {"GetNonImportantPairsSpacing", PyttkMergeTreeClustering_GetNonImportantPairsSpacing, METH_VARARGS,
   "GetNonImportantPairsSpacing(self) -> float\nC++: virtual double GetNonImportantPairsSpacing()\n\n"},
  {"SetNonImportantPairsProximity", PyttkMergeTreeClustering_SetNonImportantPairsProximity, METH_VARARGS,
   "SetNonImportantPairsProximity(self, _arg:float) -> None\nC++: virtual void SetNonImportantPairsProximity(double _arg)\n\n"},
  {"GetNonImportantPairsProximity", PyttkMergeTreeClustering_GetNonImportantPairsProximity, METH_VARARGS,
   "GetNonImportantPairsProximity(self) -> float\nC++: virtual double GetNonImportantPairsProximity()\n\n"},
  {"SetExcludeImportantPairsLower", PyttkMergeTreeClustering_SetExcludeImportantPairsLower, METH_VARARGS,
   "SetExcludeImportantPairsLower(self, _arg:str) -> None\nC++: virtual void SetExcludeImportantPairsLower(\n    const std::string &_arg)\n\n"},
  {"GetExcludeImportantPairsLower", PyttkMergeTreeClustering_GetExcludeImportantPairsLower, METH_VARARGS,
   "GetExcludeImportantPairsLower(self) -> str\nC++: virtual std::string GetExcludeImportantPairsLower()\n\n"},
  {"SetExcludeImportantPairsHigher", PyttkMergeTreeClustering_SetExcludeImportantPairsHigher, METH_VARARGS,
   "SetExcludeImportantPairsHigher(self, _arg:str) -> None\nC++: virtual void SetExcludeImportantPairsHigher(\n    const std::string &_arg)\n\n"},
  {"GetExcludeImportantPairsHigher", PyttkMergeTreeClustering_GetExcludeImportantPairsHigher, METH_VARARGS,
   "GetExcludeImportantPairsHigher(self) -> str\nC++: virtual std::string GetExcludeImportantPairsHigher()\n\n"},
  {"IsTypeOf", PyttkMergeTreeClustering_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMergeTreeClustering_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMergeTreeClustering_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkMergeTreeClustering\nC++: static ttkMergeTreeClustering *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMergeTreeClustering_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMergeTreeClustering\nC++: ttkMergeTreeClustering *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMergeTreeClustering_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMergeTreeClustering_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMergeTreeClustering_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("epsilon1_use_farthest_saddle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetEpsilon1UseFarthestSaddle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetEpsilon1UseFarthestSaddle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetEpsilon1UseFarthestSaddle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon1UseFarthestSaddle/SetEpsilon1UseFarthestSaddle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon_tree1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetEpsilonTree1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetEpsilonTree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetEpsilonTree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilonTree1/SetEpsilonTree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon2_tree1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetEpsilon2Tree1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetEpsilon2Tree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetEpsilon2Tree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon2Tree1/SetEpsilon2Tree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon3_tree1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetEpsilon3Tree1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetEpsilon3Tree1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetEpsilon3Tree1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon3Tree1/SetEpsilon3Tree1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("persistence_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetPersistenceThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetPersistenceThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetPersistenceThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPersistenceThreshold/SetPersistenceThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_min_max_pair"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetUseMinMaxPair(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetUseMinMaxPair(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetUseMinMaxPair(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseMinMaxPair/SetUseMinMaxPair\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delete_multi_pers_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetDeleteMultiPersPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetDeleteMultiPersPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetDeleteMultiPersPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDeleteMultiPersPairs/SetDeleteMultiPersPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("backend"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetBackend(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetBackend(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetBackend(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBackend/SetBackend\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("alpha"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetAlpha(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetAlpha(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetAlpha(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAlpha/SetAlpha\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("assignment_solver"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetAssignmentSolver(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetAssignmentSolver(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetAssignmentSolver(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAssignmentSolver/SetAssignmentSolver\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("branch_decomposition"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetBranchDecomposition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetBranchDecomposition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetBranchDecomposition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBranchDecomposition/SetBranchDecomposition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("deterministic"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetDeterministic(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetDeterministic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetDeterministic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDeterministic/SetDeterministic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("normalized_wasserstein"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetNormalizedWasserstein(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetNormalizedWasserstein(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetNormalizedWasserstein(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNormalizedWasserstein/SetNormalizedWasserstein\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("keep_subtree"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetKeepSubtree(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetKeepSubtree(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetKeepSubtree(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetKeepSubtree/SetKeepSubtree\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("join_split_mixture_coefficient"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetJoinSplitMixtureCoefficient(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetJoinSplitMixtureCoefficient(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetJoinSplitMixtureCoefficient(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetJoinSplitMixtureCoefficient/SetJoinSplitMixtureCoefficient\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_barycenter"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetComputeBarycenter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetComputeBarycenter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetComputeBarycenter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeBarycenter/SetComputeBarycenter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("barycenter_size_limit_percent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetBarycenterSizeLimitPercent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetBarycenterSizeLimitPercent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetBarycenterSizeLimitPercent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBarycenterSizeLimitPercent/SetBarycenterSizeLimitPercent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("branch_metric"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetBranchMetric(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetBranchMetric(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBranchMetric\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("path_metric"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetPathMetric(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetPathMetric(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPathMetric\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("non_matching_weight"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetNonMatchingWeight(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetNonMatchingWeight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetNonMatchingWeight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNonMatchingWeight/SetNonMatchingWeight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("barycenter_position_alpha"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetBarycenterPositionAlpha(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetBarycenterPositionAlpha(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetBarycenterPositionAlpha(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBarycenterPositionAlpha/SetBarycenterPositionAlpha\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_trees"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetOutputTrees(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetOutputTrees(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetOutputTrees(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputTrees/SetOutputTrees\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_segmentation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetOutputSegmentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetOutputSegmentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetOutputSegmentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputSegmentation/SetOutputSegmentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("planar_layout"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetPlanarLayout(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetPlanarLayout(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetPlanarLayout(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPlanarLayout/SetPlanarLayout\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("branch_decomposition_planar_layout"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetBranchDecompositionPlanarLayout(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetBranchDecompositionPlanarLayout(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetBranchDecompositionPlanarLayout(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBranchDecompositionPlanarLayout/SetBranchDecompositionPlanarLayout\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("branch_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetBranchSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetBranchSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetBranchSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBranchSpacing/SetBranchSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rescale_trees_individually"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetRescaleTreesIndividually(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetRescaleTreesIndividually(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetRescaleTreesIndividually(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRescaleTreesIndividually/SetRescaleTreesIndividually\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("dimension_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetDimensionSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetDimensionSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetDimensionSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDimensionSpacing/SetDimensionSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("dimension_to_shift"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetDimensionToShift(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetDimensionToShift(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetDimensionToShift(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDimensionToShift/SetDimensionToShift\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("important_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetImportantPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetImportantPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetImportantPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImportantPairs/SetImportantPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("maximum_important_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetMaximumImportantPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetMaximumImportantPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetMaximumImportantPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaximumImportantPairs/SetMaximumImportantPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("minimum_important_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetMinimumImportantPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetMinimumImportantPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetMinimumImportantPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMinimumImportantPairs/SetMinimumImportantPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("important_pairs_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetImportantPairsSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetImportantPairsSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetImportantPairsSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImportantPairsSpacing/SetImportantPairsSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("non_important_pairs_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetNonImportantPairsSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetNonImportantPairsSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetNonImportantPairsSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNonImportantPairsSpacing/SetNonImportantPairsSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("non_important_pairs_proximity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetNonImportantPairsProximity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetNonImportantPairsProximity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetNonImportantPairsProximity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNonImportantPairsProximity/SetNonImportantPairsProximity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exclude_important_pairs_lower"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetExcludeImportantPairsLower(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetExcludeImportantPairsLower(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetExcludeImportantPairsLower(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExcludeImportantPairsLower/SetExcludeImportantPairsLower\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exclude_important_pairs_higher"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetExcludeImportantPairsHigher(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetExcludeImportantPairsHigher(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetExcludeImportantPairsHigher(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExcludeImportantPairsHigher/SetExcludeImportantPairsHigher\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_barycenters"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeClustering_GetNumberOfBarycenters(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeClustering_SetNumberOfBarycenters(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeClustering_SetNumberOfBarycenters(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfBarycenters/SetNumberOfBarycenters\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMergeTreeClustering_Doc =
  "ttkMergeTreeClustering - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Mathieu Pont (mathieu.pont@lip6.fr)\\date 2021.\n\n"
  "TTK VTK-filter that wraps the ttk::MergeTreeClustering module.\n\n"
  "This VTK filter uses the ttk::MergeTreeClustering module to compute\n"
  "the edit distance between two merge trees.\n\n"
  "\\param Input vtkMultiBlockDataSet Input trees\n"
  "\\param Input (optional) vtkMultiBlockDataSet Input trees\n"
  "\\param Output vtkMultiBlockDataSet Input trees (processed)\n"
  "\\param Output vtkMultiBlockDataSet Centroids trees\n"
  "\\param Output vtkMultiBlockDataSet Matchings\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(),\n"
  "GetOutputDataObject()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication\n\n"
  "\"Wasserstein Distances, Geodesics and Barycenters of Merge Trees\"\n\n"
  "Mathieu Pont, Jules Vidal, Julie Delon, Julien Tierny.\n\n"
  "Proc. of IEEE VIS 2021.\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2021\n\n"
  "\\sa ttk::MergeTreeClustering\n"
  "\\sa ttkAlgorithm\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeClustering/\"\n"
  "  >Merge Tree Clustering example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeFeatureTracking/\"\n"
  "  >Merge Tree Feature Tracking example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeWAE/\">Me\n"
  "  rge tree Wasserstein Auto-Encoder example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreePGA/\">Me\n"
  "  rge Tree Principal Geodesic Analysis example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMergeTreeClustering_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMergeTreeClustering.ttkMergeTreeClustering", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMergeTreeClustering_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMergeTreeClustering_StaticNew()
{
  return ttkMergeTreeClustering::New();
}

PyObject *PyttkMergeTreeClustering_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMergeTreeClustering_Type, PyttkMergeTreeClustering_Methods,
    "ttkMergeTreeClustering",
 &PyttkMergeTreeClustering_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMergeTreeClustering_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMergeTreeClustering(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMergeTreeClustering_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMergeTreeClustering", o) != 0)
  {
    Py_DECREF(o);
  }

}

