/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	dynamic "github.com/traefik/traefik/v3/pkg/config/dynamic"
)

// ServersTransportSpecApplyConfiguration represents a declarative configuration of the ServersTransportSpec type for use
// with apply.
type ServersTransportSpecApplyConfiguration struct {
	ServerName          *string                               `json:"serverName,omitempty"`
	InsecureSkipVerify  *bool                                 `json:"insecureSkipVerify,omitempty"`
	RootCAs             []RootCAApplyConfiguration            `json:"rootCAs,omitempty"`
	RootCAsSecrets      []string                              `json:"rootCAsSecrets,omitempty"`
	CertificatesSecrets []string                              `json:"certificatesSecrets,omitempty"`
	MaxIdleConnsPerHost *int                                  `json:"maxIdleConnsPerHost,omitempty"`
	ForwardingTimeouts  *ForwardingTimeoutsApplyConfiguration `json:"forwardingTimeouts,omitempty"`
	DisableHTTP2        *bool                                 `json:"disableHTTP2,omitempty"`
	PeerCertURI         *string                               `json:"peerCertURI,omitempty"`
	Spiffe              *dynamic.Spiffe                       `json:"spiffe,omitempty"`
}

// ServersTransportSpecApplyConfiguration constructs a declarative configuration of the ServersTransportSpec type for use with
// apply.
func ServersTransportSpec() *ServersTransportSpecApplyConfiguration {
	return &ServersTransportSpecApplyConfiguration{}
}

// WithServerName sets the ServerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServerName field is set to the value of the last call.
func (b *ServersTransportSpecApplyConfiguration) WithServerName(value string) *ServersTransportSpecApplyConfiguration {
	b.ServerName = &value
	return b
}

// WithInsecureSkipVerify sets the InsecureSkipVerify field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the InsecureSkipVerify field is set to the value of the last call.
func (b *ServersTransportSpecApplyConfiguration) WithInsecureSkipVerify(value bool) *ServersTransportSpecApplyConfiguration {
	b.InsecureSkipVerify = &value
	return b
}

// WithRootCAs adds the given value to the RootCAs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RootCAs field.
func (b *ServersTransportSpecApplyConfiguration) WithRootCAs(values ...*RootCAApplyConfiguration) *ServersTransportSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRootCAs")
		}
		b.RootCAs = append(b.RootCAs, *values[i])
	}
	return b
}

// WithRootCAsSecrets adds the given value to the RootCAsSecrets field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RootCAsSecrets field.
func (b *ServersTransportSpecApplyConfiguration) WithRootCAsSecrets(values ...string) *ServersTransportSpecApplyConfiguration {
	for i := range values {
		b.RootCAsSecrets = append(b.RootCAsSecrets, values[i])
	}
	return b
}

// WithCertificatesSecrets adds the given value to the CertificatesSecrets field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CertificatesSecrets field.
func (b *ServersTransportSpecApplyConfiguration) WithCertificatesSecrets(values ...string) *ServersTransportSpecApplyConfiguration {
	for i := range values {
		b.CertificatesSecrets = append(b.CertificatesSecrets, values[i])
	}
	return b
}

// WithMaxIdleConnsPerHost sets the MaxIdleConnsPerHost field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxIdleConnsPerHost field is set to the value of the last call.
func (b *ServersTransportSpecApplyConfiguration) WithMaxIdleConnsPerHost(value int) *ServersTransportSpecApplyConfiguration {
	b.MaxIdleConnsPerHost = &value
	return b
}

// WithForwardingTimeouts sets the ForwardingTimeouts field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ForwardingTimeouts field is set to the value of the last call.
func (b *ServersTransportSpecApplyConfiguration) WithForwardingTimeouts(value *ForwardingTimeoutsApplyConfiguration) *ServersTransportSpecApplyConfiguration {
	b.ForwardingTimeouts = value
	return b
}

// WithDisableHTTP2 sets the DisableHTTP2 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DisableHTTP2 field is set to the value of the last call.
func (b *ServersTransportSpecApplyConfiguration) WithDisableHTTP2(value bool) *ServersTransportSpecApplyConfiguration {
	b.DisableHTTP2 = &value
	return b
}

// WithPeerCertURI sets the PeerCertURI field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PeerCertURI field is set to the value of the last call.
func (b *ServersTransportSpecApplyConfiguration) WithPeerCertURI(value string) *ServersTransportSpecApplyConfiguration {
	b.PeerCertURI = &value
	return b
}

// WithSpiffe sets the Spiffe field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Spiffe field is set to the value of the last call.
func (b *ServersTransportSpecApplyConfiguration) WithSpiffe(value dynamic.Spiffe) *ServersTransportSpecApplyConfiguration {
	b.Spiffe = &value
	return b
}
