// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "ImagePropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

ImagePropertyGroup::ImagePropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
}

void ImagePropertyGroup::update(ImageProperty *newState)
{
    if (newState == m_state) {
        return;
    }

    m_state = newState;

    if (!newState) {
    } else {
    }

    Q_EMIT sourceChanged();
    Q_EMIT widthChanged();
    Q_EMIT heightChanged();
    Q_EMIT xOffsetChanged();
    Q_EMIT yOffsetChanged();
    Q_EMIT flagsChanged();
    Q_EMIT maskColorChanged();
    Q_EMIT updated();
}

void ImagePropertyGroup::refreshColors()
{
    Q_EMIT maskColorChanged();
}

QJSValue ImagePropertyGroup::source() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->source();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue ImagePropertyGroup::width() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->width();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue ImagePropertyGroup::height() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->height();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue ImagePropertyGroup::xOffset() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->xOffset();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue ImagePropertyGroup::yOffset() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->yOffset();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue ImagePropertyGroup::flags() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->flags();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue ImagePropertyGroup::maskColor() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->maskColor();
    if (value) {
        return m_style->engine()->toScriptValue(value.value().toQColor());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

#include "moc_ImagePropertyGroup.cpp"