//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// vec.template.cpp file to make changes.

#include "pxr/base/gf/vec2f.h"

#include "pxr/pxr.h"
#include "pxr/base/gf/math.h"
#include "pxr/base/gf/ostreamHelpers.h"
#include "pxr/base/tf/type.h"

// Include headers for other vec types to support wrapping conversions and
// operators.
#include "pxr/base/gf/vec2d.h"
#include "pxr/base/gf/vec2h.h"
#include "pxr/base/gf/vec2i.h"

#include <vector>
#include <ostream>

PXR_NAMESPACE_OPEN_SCOPE

TF_REGISTRY_FUNCTION(TfType) {
    TfType::Define<GfVec2f>();
}

std::ostream& 
operator<<(std::ostream &out, GfVec2f const &v)
{
    return out << '(' 
        << Gf_OstreamHelperP(v[0]) << ", " 
        << Gf_OstreamHelperP(v[1]) << ')';
}


bool
GfVec2f::operator==(GfVec2d const &other) const
{
    return _data[0] == other[0] &&
           _data[1] == other[1];
}
bool
GfVec2f::operator==(GfVec2h const &other) const
{
    return _data[0] == other[0] &&
           _data[1] == other[1];
}
bool
GfVec2f::operator==(GfVec2i const &other) const
{
    return _data[0] == other[0] &&
           _data[1] == other[1];
}


PXR_NAMESPACE_CLOSE_SCOPE
