/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDatabase.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSSQLTransactionCallback.h"
#include "JSSQLTransactionErrorCallback.h"
#include "JSVoidCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDatabasePrototypeFunction_changeVersion);
static JSC_DECLARE_HOST_FUNCTION(jsDatabasePrototypeFunction_transaction);
static JSC_DECLARE_HOST_FUNCTION(jsDatabasePrototypeFunction_readTransaction);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDatabaseConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDatabase_version);

class JSDatabasePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDatabasePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDatabasePrototype* ptr = new (NotNull, JSC::allocateCell<JSDatabasePrototype>(vm)) JSDatabasePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDatabasePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDatabasePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDatabasePrototype, JSDatabasePrototype::Base);

using JSDatabaseDOMConstructor = JSDOMConstructorNotConstructable<JSDatabase>;

template<> const ClassInfo JSDatabaseDOMConstructor::s_info = { "Database"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDatabaseDOMConstructor) };

template<> JSValue JSDatabaseDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDatabaseDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Database"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDatabase::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSDatabasePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDatabaseConstructor, 0 } },
    HashTableValue { "version"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDatabase_version, 0 } },
    HashTableValue { "changeVersion"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDatabasePrototypeFunction_changeVersion, 2 } },
    HashTableValue { "transaction"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDatabasePrototypeFunction_transaction, 1 } },
    HashTableValue { "readTransaction"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDatabasePrototypeFunction_readTransaction, 1 } },
};

const ClassInfo JSDatabasePrototype::s_info = { "Database"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDatabasePrototype) };

void JSDatabasePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDatabase::info(), JSDatabasePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDatabase::s_info = { "Database"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDatabase) };

JSDatabase::JSDatabase(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Database>&& impl)
    : JSDOMWrapper<Database>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, Database>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDatabase::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDatabasePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDatabasePrototype::create(vm, &globalObject, structure);
}

JSObject* JSDatabase::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDatabase>(vm, globalObject);
}

JSValue JSDatabase::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDatabaseDOMConstructor, DOMConstructorID::Database>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDatabase::destroy(JSC::JSCell* cell)
{
    JSDatabase* thisObject = static_cast<JSDatabase*>(cell);
    thisObject->JSDatabase::~JSDatabase();
}

JSC_DEFINE_CUSTOM_GETTER(jsDatabaseConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDatabasePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDatabase::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDatabase_versionGetter(JSGlobalObject& lexicalGlobalObject, JSDatabase& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.version())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDatabase_version, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDatabase>::get<jsDatabase_versionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDatabasePrototypeFunction_changeVersionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDatabase>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto oldVersionConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (oldVersionConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto newVersionConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (newVersionConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto callbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSSQLTransactionCallback>>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "callback"_s, "Database"_s, "changeVersion"_s); });
    if (callbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSSQLTransactionErrorCallback>>>(*lexicalGlobalObject, argument3.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 3, "errorCallback"_s, "Database"_s, "changeVersion"_s); });
    if (errorCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto successCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSVoidCallback>>>(*lexicalGlobalObject, argument4.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 4, "successCallback"_s, "Database"_s, "changeVersion"_s); });
    if (successCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.changeVersion(oldVersionConversionResult.releaseReturnValue(), newVersionConversionResult.releaseReturnValue(), callbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue(), successCallbackConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDatabasePrototypeFunction_changeVersion, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDatabase>::call<jsDatabasePrototypeFunction_changeVersionBody>(*lexicalGlobalObject, *callFrame, "changeVersion");
}

static inline JSC::EncodedJSValue jsDatabasePrototypeFunction_transactionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDatabase>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callbackConversionResult = convert<IDLCallbackFunction<JSSQLTransactionCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback"_s, "Database"_s, "transaction"_s); });
    if (callbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSSQLTransactionErrorCallback>>>(*lexicalGlobalObject, argument1.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "errorCallback"_s, "Database"_s, "transaction"_s); });
    if (errorCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto successCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSVoidCallback>>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "successCallback"_s, "Database"_s, "transaction"_s); });
    if (successCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.transaction(callbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue(), successCallbackConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDatabasePrototypeFunction_transaction, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDatabase>::call<jsDatabasePrototypeFunction_transactionBody>(*lexicalGlobalObject, *callFrame, "transaction");
}

static inline JSC::EncodedJSValue jsDatabasePrototypeFunction_readTransactionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDatabase>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callbackConversionResult = convert<IDLCallbackFunction<JSSQLTransactionCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback"_s, "Database"_s, "readTransaction"_s); });
    if (callbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSSQLTransactionErrorCallback>>>(*lexicalGlobalObject, argument1.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "errorCallback"_s, "Database"_s, "readTransaction"_s); });
    if (errorCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto successCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSVoidCallback>>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "successCallback"_s, "Database"_s, "readTransaction"_s); });
    if (successCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.readTransaction(callbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue(), successCallbackConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDatabasePrototypeFunction_readTransaction, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDatabase>::call<jsDatabasePrototypeFunction_readTransactionBody>(*lexicalGlobalObject, *callFrame, "readTransaction");
}

JSC::GCClient::IsoSubspace* JSDatabase::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDatabase, UseCustomHeapCellType::No>(vm, "JSDatabase"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDatabase.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDatabase = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDatabase.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDatabase = std::forward<decltype(space)>(space); }
    );
}

void JSDatabase::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDatabase*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSDatabaseOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDatabaseOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDatabase = static_cast<JSDatabase*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDatabase->protectedWrapped().ptr(), jsDatabase);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Database@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8DatabaseE[]; }
#endif
template<std::same_as<Database> T>
static inline void verifyVTable(Database* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7Database@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore8DatabaseE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // Database has subclasses. If Database has subclasses that get passed
        // to toJS() we currently require Database you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Database>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<Database>(impl.ptr());
#endif
    return createWrapper<Database>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Database& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Database* JSDatabase::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDatabase*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
