/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathSegLinetoHorizontalRel.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegLinetoHorizontalRelConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegLinetoHorizontalRel_x);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegLinetoHorizontalRel_x);

class JSSVGPathSegLinetoHorizontalRelPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPathSegLinetoHorizontalRelPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathSegLinetoHorizontalRelPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathSegLinetoHorizontalRelPrototype>(vm)) JSSVGPathSegLinetoHorizontalRelPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegLinetoHorizontalRelPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathSegLinetoHorizontalRelPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegLinetoHorizontalRelPrototype, JSSVGPathSegLinetoHorizontalRelPrototype::Base);

using JSSVGPathSegLinetoHorizontalRelDOMConstructor = JSDOMConstructorNotConstructable<JSSVGPathSegLinetoHorizontalRel>;

template<> const ClassInfo JSSVGPathSegLinetoHorizontalRelDOMConstructor::s_info = { "SVGPathSegLinetoHorizontalRel"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegLinetoHorizontalRelDOMConstructor) };

template<> JSValue JSSVGPathSegLinetoHorizontalRelDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGPathSeg::getConstructor(vm, &globalObject);
}

template<> void JSSVGPathSegLinetoHorizontalRelDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGPathSegLinetoHorizontalRel"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathSegLinetoHorizontalRel::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSSVGPathSegLinetoHorizontalRelPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegLinetoHorizontalRelConstructor, 0 } },
    HashTableValue { "x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegLinetoHorizontalRel_x, setJSSVGPathSegLinetoHorizontalRel_x } },
};

const ClassInfo JSSVGPathSegLinetoHorizontalRelPrototype::s_info = { "SVGPathSegLinetoHorizontalRel"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegLinetoHorizontalRelPrototype) };

void JSSVGPathSegLinetoHorizontalRelPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathSegLinetoHorizontalRel::info(), JSSVGPathSegLinetoHorizontalRelPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGPathSegLinetoHorizontalRel::s_info = { "SVGPathSegLinetoHorizontalRel"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegLinetoHorizontalRel) };

JSSVGPathSegLinetoHorizontalRel::JSSVGPathSegLinetoHorizontalRel(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathSegLinetoHorizontalRel>&& impl)
    : JSSVGPathSeg(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGPathSegLinetoHorizontalRel> JSSVGPathSegLinetoHorizontalRel::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGPathSegLinetoHorizontalRel>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGPathSegLinetoHorizontalRel::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGPathSegLinetoHorizontalRelPrototype::createStructure(vm, &globalObject, JSSVGPathSeg::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGPathSegLinetoHorizontalRelPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGPathSegLinetoHorizontalRel::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPathSegLinetoHorizontalRel>(vm, globalObject);
}

JSValue JSSVGPathSegLinetoHorizontalRel::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegLinetoHorizontalRelDOMConstructor, DOMConstructorID::SVGPathSegLinetoHorizontalRel>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegLinetoHorizontalRelConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathSegLinetoHorizontalRelPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPathSegLinetoHorizontalRel::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGPathSegLinetoHorizontalRel_xGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegLinetoHorizontalRel& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.x())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegLinetoHorizontalRel_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegLinetoHorizontalRel>::get<jsSVGPathSegLinetoHorizontalRel_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegLinetoHorizontalRel_xSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegLinetoHorizontalRel& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setX(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegLinetoHorizontalRel_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegLinetoHorizontalRel>::set<setJSSVGPathSegLinetoHorizontalRel_xSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGPathSegLinetoHorizontalRel::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGPathSegLinetoHorizontalRel, UseCustomHeapCellType::No>(vm, "JSSVGPathSegLinetoHorizontalRel"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGPathSegLinetoHorizontalRel.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGPathSegLinetoHorizontalRel = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGPathSegLinetoHorizontalRel.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGPathSegLinetoHorizontalRel = std::forward<decltype(space)>(space); }
    );
}

void JSSVGPathSegLinetoHorizontalRel::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPathSegLinetoHorizontalRel*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
