/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSVisualViewport.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DocumentInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsVisualViewportConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsVisualViewport_offsetLeft);
static JSC_DECLARE_CUSTOM_GETTER(jsVisualViewport_offsetTop);
static JSC_DECLARE_CUSTOM_GETTER(jsVisualViewport_pageLeft);
static JSC_DECLARE_CUSTOM_GETTER(jsVisualViewport_pageTop);
static JSC_DECLARE_CUSTOM_GETTER(jsVisualViewport_width);
static JSC_DECLARE_CUSTOM_GETTER(jsVisualViewport_height);
static JSC_DECLARE_CUSTOM_GETTER(jsVisualViewport_scale);
static JSC_DECLARE_CUSTOM_GETTER(jsVisualViewport_onresize);
static JSC_DECLARE_CUSTOM_SETTER(setJSVisualViewport_onresize);
static JSC_DECLARE_CUSTOM_GETTER(jsVisualViewport_onscroll);
static JSC_DECLARE_CUSTOM_SETTER(setJSVisualViewport_onscroll);
static JSC_DECLARE_CUSTOM_GETTER(jsVisualViewport_onscrollend);
static JSC_DECLARE_CUSTOM_SETTER(setJSVisualViewport_onscrollend);

class JSVisualViewportPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVisualViewportPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVisualViewportPrototype* ptr = new (NotNull, JSC::allocateCell<JSVisualViewportPrototype>(vm)) JSVisualViewportPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVisualViewportPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVisualViewportPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVisualViewportPrototype, JSVisualViewportPrototype::Base);

using JSVisualViewportDOMConstructor = JSDOMConstructorNotConstructable<JSVisualViewport>;

template<> const ClassInfo JSVisualViewportDOMConstructor::s_info = { "VisualViewport"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVisualViewportDOMConstructor) };

template<> JSValue JSVisualViewportDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSVisualViewportDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "VisualViewport"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSVisualViewport::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 11> JSVisualViewportPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsVisualViewportConstructor, 0 } },
    HashTableValue { "offsetLeft"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVisualViewport_offsetLeft, 0 } },
    HashTableValue { "offsetTop"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVisualViewport_offsetTop, 0 } },
    HashTableValue { "pageLeft"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVisualViewport_pageLeft, 0 } },
    HashTableValue { "pageTop"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVisualViewport_pageTop, 0 } },
    HashTableValue { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVisualViewport_width, 0 } },
    HashTableValue { "height"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVisualViewport_height, 0 } },
    HashTableValue { "scale"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVisualViewport_scale, 0 } },
    HashTableValue { "onresize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVisualViewport_onresize, setJSVisualViewport_onresize } },
    HashTableValue { "onscroll"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVisualViewport_onscroll, setJSVisualViewport_onscroll } },
    HashTableValue { "onscrollend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVisualViewport_onscrollend, setJSVisualViewport_onscrollend } },
};

const ClassInfo JSVisualViewportPrototype::s_info = { "VisualViewport"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVisualViewportPrototype) };

void JSVisualViewportPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVisualViewport::info(), JSVisualViewportPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollendEventEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onscrollend"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSVisualViewport::s_info = { "VisualViewport"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVisualViewport) };

JSVisualViewport::JSVisualViewport(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VisualViewport>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<VisualViewport> JSVisualViewport::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, VisualViewport>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSVisualViewport::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSVisualViewportPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSVisualViewportPrototype::create(vm, &globalObject, structure);
}

JSObject* JSVisualViewport::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVisualViewport>(vm, globalObject);
}

JSValue JSVisualViewport::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVisualViewportDOMConstructor, DOMConstructorID::VisualViewport>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsVisualViewportConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVisualViewportPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSVisualViewport::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsVisualViewport_offsetLeftGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.offsetLeft())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVisualViewport_offsetLeft, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewport_offsetLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVisualViewport_offsetTopGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.offsetTop())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVisualViewport_offsetTop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewport_offsetTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVisualViewport_pageLeftGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.pageLeft())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVisualViewport_pageLeft, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewport_pageLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVisualViewport_pageTopGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.pageTop())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVisualViewport_pageTop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewport_pageTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVisualViewport_widthGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVisualViewport_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewport_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVisualViewport_heightGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVisualViewport_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewport_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVisualViewport_scaleGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.scale())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVisualViewport_scale, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewport_scaleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVisualViewport_onresizeGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsVisualViewport_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewport_onresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVisualViewport_onresizeSetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().resizeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVisualViewport_onresize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::set<setJSVisualViewport_onresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVisualViewport_onscrollGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsVisualViewport_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewport_onscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVisualViewport_onscrollSetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().scrollEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVisualViewport_onscroll, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::set<setJSVisualViewport_onscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVisualViewport_onscrollendGetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().scrollendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsVisualViewport_onscrollend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::get<jsVisualViewport_onscrollendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVisualViewport_onscrollendSetter(JSGlobalObject& lexicalGlobalObject, JSVisualViewport& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().scrollendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVisualViewport_onscrollend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVisualViewport>::set<setJSVisualViewport_onscrollendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSVisualViewport::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSVisualViewport, UseCustomHeapCellType::No>(vm, "JSVisualViewport"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForVisualViewport.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForVisualViewport = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForVisualViewport.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForVisualViewport = std::forward<decltype(space)>(space); }
    );
}

void JSVisualViewport::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVisualViewport*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSVisualViewportOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsVisualViewport = jsCast<JSVisualViewport*>(handle.slot()->asCell());
    auto* owner = WTF::getPtr(jsVisualViewport->wrapped().window());
    if (!owner)
        return false;
    if (reason) [[unlikely]]
        *reason = "Reachable from Window"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSVisualViewportOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVisualViewport = static_cast<JSVisualViewport*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsVisualViewport->protectedWrapped().ptr(), jsVisualViewport);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VisualViewport@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14VisualViewportE[]; }
#endif
template<std::same_as<VisualViewport> T>
static inline void verifyVTable(VisualViewport* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7VisualViewport@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14VisualViewportE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // VisualViewport has subclasses. If VisualViewport has subclasses that get passed
        // to toJS() we currently require VisualViewport you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VisualViewport>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<VisualViewport>(impl.ptr());
#endif
    return createWrapper<VisualViewport>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VisualViewport& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VisualViewport* JSVisualViewport::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVisualViewport*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
