/* log.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from log.vala, do not modify */

/*
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 * Copyright © 2013 Seif Lotfy <seif@lotfy.com>
 * Copyright © 2013 Rico Tzschichholz <ricotz@ubuntu.com>
 *
 * Based upon a C implementation (© 2010-2012 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *  Michal Hruby <michal.hruby@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist.h"
#include <glib.h>
#include "zeitgeist-internal.h"
#include <glib-object.h>
#include "zeitgeist-datamodel.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define ZEITGEIST_LOG_TYPE_DB_WORKER (zeitgeist_log_db_worker_get_type ())
#define ZEITGEIST_LOG_DB_WORKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_LOG_TYPE_DB_WORKER, ZeitgeistLogDbWorker))
#define ZEITGEIST_LOG_DB_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_LOG_TYPE_DB_WORKER, ZeitgeistLogDbWorkerClass))
#define ZEITGEIST_LOG_IS_DB_WORKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_LOG_TYPE_DB_WORKER))
#define ZEITGEIST_LOG_IS_DB_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_LOG_TYPE_DB_WORKER))
#define ZEITGEIST_LOG_DB_WORKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_LOG_TYPE_DB_WORKER, ZeitgeistLogDbWorkerClass))

typedef struct _ZeitgeistLogDbWorker ZeitgeistLogDbWorker;
typedef struct _ZeitgeistLogDbWorkerClass ZeitgeistLogDbWorkerClass;
enum  {
	ZEITGEIST_LOG_0_PROPERTY,
	ZEITGEIST_LOG_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_log_properties[ZEITGEIST_LOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _zeitgeist_log_db_worker_unref0(var) ((var == NULL) ? NULL : (var = (zeitgeist_log_db_worker_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistLogInsertEventData ZeitgeistLogInsertEventData;
typedef struct _ZeitgeistLogInsertEventsData ZeitgeistLogInsertEventsData;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _ZeitgeistLogFindEventsData ZeitgeistLogFindEventsData;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _ZeitgeistLogFindEventIdsData ZeitgeistLogFindEventIdsData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _ZeitgeistLogGetEventsData ZeitgeistLogGetEventsData;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _ZeitgeistLogFindRelatedUrisData ZeitgeistLogFindRelatedUrisData;
typedef struct _ZeitgeistLogDeleteEventsData ZeitgeistLogDeleteEventsData;
typedef struct _ZeitgeistLogQuitData ZeitgeistLogQuitData;
typedef struct _ZeitgeistLogReinstallMonitorData ZeitgeistLogReinstallMonitorData;
typedef struct _Block10Data Block10Data;
typedef struct _ZeitgeistLogDbWorkerPrivate ZeitgeistLogDbWorkerPrivate;
typedef struct _ZeitgeistLogParamSpecDbWorker ZeitgeistLogParamSpecDbWorker;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistLogPrivate {
	ZeitgeistRemoteLog* proxy;
	GVariant* engine_version;
	GHashTable* monitors;
	ZeitgeistDbReader* dbreader;
	GThreadPool* threads;
	gboolean allow_direct_read;
};

struct _Block1Data {
	int _ref_count_;
	ZeitgeistLog* self;
	GMainLoop* mainloop;
};

struct _ZeitgeistLogInsertEventData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistLog* self;
	ZeitgeistEvent* event;
	GCancellable* cancellable;
	GArray* result;
	GPtrArray* events;
	GPtrArray* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	GArray* _tmp4_;
	GError* _inner_error0_;
};

struct _ZeitgeistLogInsertEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistLog* self;
	GPtrArray* events;
	GCancellable* cancellable;
	GArray* result;
	GPtrArray* events_cp;
	GPtrArray* _tmp0_;
	gint i;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GPtrArray* _tmp5_;
	gconstpointer _tmp6_;
	ZeitgeistEvent* _tmp7_;
	guint32* ids;
	ZeitgeistRemoteLog* _tmp8_;
	GPtrArray* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	gint _tmp12_;
	guint32* _tmp13_;
	guint32* _tmp14_;
	gint _tmp14__length1;
	gint ids_length1;
	gint _ids_size_;
	GArray* _result_;
	GArray* _tmp15_;
	gint _vala1_i;
	gboolean _tmp16_;
	gint _tmp17_;
	guint32* _tmp18_;
	gint _tmp18__length1;
	GArray* _tmp19_;
	guint32* _tmp20_;
	gint _tmp20__length1;
	guint32 _tmp21_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	ZeitgeistLog* self;
	GPtrArray* event_templates_cp;
	ZeitgeistTimeRange* time_range;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistResultType result_type;
	gpointer _async_data_;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	ZeitgeistSimpleResultSet* result_set;
	GError* _error_;
};

struct _ZeitgeistLogFindEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistLog* self;
	ZeitgeistTimeRange* time_range;
	GPtrArray* event_templates;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistResultType result_type;
	GCancellable* cancellable;
	ZeitgeistResultSet* result;
	Block2Data* _data2_;
	GPtrArray* _tmp0_;
	gint i;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GPtrArray* _tmp5_;
	gconstpointer _tmp6_;
	ZeitgeistEvent* _tmp7_;
	ZeitgeistDbReader* _tmp8_;
	Block3Data* _data3_;
	GThreadFunc run;
	gpointer run_target;
	GThreadPool* _tmp9_;
	GThreadFunc _tmp10_;
	gpointer _tmp10__target;
	ZeitgeistLogDbWorker* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	ZeitgeistSimpleResultSet* _tmp15_;
	ZeitgeistResultSet* _tmp16_;
	GVariant* _result_;
	ZeitgeistRemoteLog* _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GPtrArray* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	GPtrArray* _tmp25_;
	GVariant* _tmp26_;
	GPtrArray* _tmp27_;
	ZeitgeistSimpleResultSet* _tmp28_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	ZeitgeistLog* self;
	GPtrArray* event_templates_cp;
	ZeitgeistTimeRange* time_range;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistResultType result_type;
	gpointer _async_data_;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	guint32* ids;
	gint ids_length1;
	gint _ids_size_;
	GError* _error_;
};

struct _ZeitgeistLogFindEventIdsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistLog* self;
	ZeitgeistTimeRange* time_range;
	GPtrArray* event_templates;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistResultType result_type;
	GCancellable* cancellable;
	guint32* result;
	gint result_length1;
	Block4Data* _data4_;
	GPtrArray* _tmp0_;
	gint i;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GPtrArray* _tmp5_;
	gconstpointer _tmp6_;
	ZeitgeistEvent* _tmp7_;
	ZeitgeistDbReader* _tmp8_;
	Block5Data* _data5_;
	GThreadFunc run;
	gpointer run_target;
	GThreadPool* _tmp9_;
	GThreadFunc _tmp10_;
	gpointer _tmp10__target;
	ZeitgeistLogDbWorker* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	guint32* _tmp15_;
	gint _tmp15__length1;
	guint32* _tmp16_;
	gint _tmp16__length1;
	guint32* _tmp17_;
	gint _tmp17__length1;
	guint32* _tmp18_;
	ZeitgeistRemoteLog* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	GPtrArray* _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	gint _tmp25_;
	guint32* _tmp26_;
	guint32* _tmp27_;
	gint _tmp27__length1;
	gint _tmp18__length1;
	gint __tmp18__size_;
	guint32* _tmp28_;
	gint _tmp28__length1;
	guint32* _tmp29_;
	gint _tmp29__length1;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	ZeitgeistLog* self;
	guint32* simple_event_ids;
	gint simple_event_ids_length1;
	gint _simple_event_ids_size_;
	gpointer _async_data_;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	ZeitgeistSimpleResultSet* result_set;
	GError* _error_;
};

struct _ZeitgeistLogGetEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistLog* self;
	GArray* event_ids;
	GCancellable* cancellable;
	ZeitgeistResultSet* result;
	Block6Data* _data6_;
	guint32* _tmp0_;
	gint i;
	gboolean _tmp1_;
	gint _tmp2_;
	guint32* _tmp3_;
	gint _tmp3__length1;
	ZeitgeistDbReader* _tmp4_;
	Block7Data* _data7_;
	GThreadFunc run;
	gpointer run_target;
	GThreadPool* _tmp5_;
	GThreadFunc _tmp6_;
	gpointer _tmp6__target;
	ZeitgeistLogDbWorker* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	ZeitgeistSimpleResultSet* _tmp11_;
	ZeitgeistResultSet* _tmp12_;
	GVariant* _result_;
	ZeitgeistRemoteLog* _tmp13_;
	guint32* _tmp14_;
	gint _tmp14__length1;
	GVariant* _tmp15_;
	GPtrArray* _tmp16_;
	GVariant* _tmp17_;
	GPtrArray* _tmp18_;
	ZeitgeistSimpleResultSet* _tmp19_;
	GError* _inner_error0_;
};

struct _Block8Data {
	int _ref_count_;
	ZeitgeistLog* self;
	GPtrArray* events_cp;
	GPtrArray* results_cp;
	ZeitgeistTimeRange* time_range;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistRelevantResultType result_type;
	gpointer _async_data_;
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
	GError* _error_;
};

struct _ZeitgeistLogFindRelatedUrisData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistLog* self;
	ZeitgeistTimeRange* time_range;
	GPtrArray* event_templates;
	GPtrArray* result_event_templates;
	ZeitgeistStorageState storage_state;
	guint32 num_events;
	ZeitgeistRelevantResultType result_type;
	GCancellable* cancellable;
	gchar** result;
	gint result_length1;
	Block8Data* _data8_;
	GPtrArray* _tmp0_;
	gint i;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GPtrArray* _tmp5_;
	gconstpointer _tmp6_;
	ZeitgeistEvent* _tmp7_;
	GPtrArray* _tmp8_;
	gint _vala1_i;
	gboolean _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GPtrArray* _tmp13_;
	gconstpointer _tmp14_;
	ZeitgeistEvent* _tmp15_;
	ZeitgeistDbReader* _tmp16_;
	Block9Data* _data9_;
	GThreadFunc run;
	gpointer run_target;
	GThreadPool* _tmp17_;
	GThreadFunc _tmp18_;
	gpointer _tmp18__target;
	ZeitgeistLogDbWorker* _tmp19_;
	GError* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar** _tmp26_;
	ZeitgeistRemoteLog* _tmp27_;
	GVariant* _tmp28_;
	GVariant* _tmp29_;
	GPtrArray* _tmp30_;
	GVariant* _tmp31_;
	GVariant* _tmp32_;
	GPtrArray* _tmp33_;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	gint _tmp36_;
	gchar** _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	gint _tmp26__length1;
	gint __tmp26__size_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	gchar** _tmp40_;
	gint _tmp40__length1;
	GError* _inner_error0_;
};

struct _ZeitgeistLogDeleteEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistLog* self;
	GArray* event_ids;
	GCancellable* cancellable;
	ZeitgeistTimeRange* result;
	guint32* _ids;
	guint32* _tmp0_;
	gint _ids_length1;
	gint __ids_size_;
	gint i;
	gboolean _tmp1_;
	gint _tmp2_;
	guint32* _tmp3_;
	gint _tmp3__length1;
	GVariant* time_range;
	ZeitgeistRemoteLog* _tmp4_;
	guint32* _tmp5_;
	gint _tmp5__length1;
	GVariant* _tmp6_;
	ZeitgeistTimeRange* _tmp7_;
	GVariant* _tmp8_;
	ZeitgeistTimeRange* _tmp9_;
	ZeitgeistTimeRange* _tmp10_;
	GError* _inner_error0_;
};

struct _ZeitgeistLogQuitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistLog* self;
	GCancellable* cancellable;
	ZeitgeistRemoteLog* _tmp0_;
	GError* _inner_error0_;
};

struct _ZeitgeistLogReinstallMonitorData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistLog* self;
	ZeitgeistMonitor* monitor;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	GDBusConnection* conn;
	ZeitgeistRemoteLog* _tmp4_;
	GDBusConnection* _tmp5_;
	GDBusConnection* _tmp6_;
	guint registration_id;
	GDBusConnection* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	GHashTable* _tmp12_;
	ZeitgeistMonitor* _tmp13_;
	GError* err;
	GError* _tmp14_;
	const gchar* _tmp15_;
	ZeitgeistRemoteLog* _tmp16_;
	char* _tmp17_;
	char* _tmp18_;
	ZeitgeistTimeRange* _tmp19_;
	ZeitgeistTimeRange* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	GPtrArray* _tmp23_;
	GPtrArray* _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GError* _inner_error0_;
};

struct _Block10Data {
	int _ref_count_;
	ZeitgeistLog* self;
	ZeitgeistMonitor* monitor;
};

struct _ZeitgeistLogDbWorker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ZeitgeistLogDbWorkerPrivate * priv;
};

struct _ZeitgeistLogDbWorkerClass {
	GTypeClass parent_class;
	void (*finalize) (ZeitgeistLogDbWorker *self);
};

struct _ZeitgeistLogDbWorkerPrivate {
	GThreadFunc func;
	gpointer func_target;
};

struct _ZeitgeistLogParamSpecDbWorker {
	GParamSpec parent_instance;
};

static gint ZeitgeistLog_private_offset;
static gpointer zeitgeist_log_parent_class = NULL;
static ZeitgeistLog* zeitgeist_log_default_instance;
static ZeitgeistLog* zeitgeist_log_default_instance = NULL;
static gint ZeitgeistLogDbWorker_private_offset;
static gpointer zeitgeist_log_db_worker_parent_class = NULL;

static gpointer zeitgeist_log_db_worker_ref (gpointer instance);
static void zeitgeist_log_db_worker_unref (gpointer instance);
static GParamSpec* zeitgeist_log_param_spec_db_worker (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags) G_GNUC_UNUSED ;
static void zeitgeist_log_value_set_db_worker (GValue* value,
                                        gpointer v_object) G_GNUC_UNUSED ;
static void zeitgeist_log_value_take_db_worker (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED ;
static gpointer zeitgeist_log_value_get_db_worker (const GValue* value) G_GNUC_UNUSED ;
static GType zeitgeist_log_db_worker_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static void __lambda9_ (Block1Data* _data1_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda9__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void zeitgeist_log_real_on_connection_established (ZeitgeistQueuedProxyWrapper* base);
static void zeitgeist_log_reinstall_monitor (ZeitgeistLog* self,
                                      ZeitgeistMonitor* monitor,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void zeitgeist_log_reinstall_monitor_finish (ZeitgeistLog* self,
                                             GAsyncResult* _res_);
static GVariant* _variant_new1 (ZeitgeistVersionStruct value);
static void ___lambda10_ (ZeitgeistLog* self,
                   ZeitgeistLogDbWorker* worker);
static void zeitgeist_log_db_worker_run (ZeitgeistLogDbWorker* self);
static void ____lambda10__gfunc (gpointer data,
                          gpointer self);
static void zeitgeist_log_real_on_connection_lost (ZeitgeistQueuedProxyWrapper* base);
static void zeitgeist_log_insert_event_data_free (gpointer _data);
static gboolean zeitgeist_log_insert_event_co (ZeitgeistLogInsertEventData* _data_);
static void zeitgeist_log_insert_event_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void zeitgeist_log_insert_events_data_free (gpointer _data);
static gboolean zeitgeist_log_insert_events_co (ZeitgeistLogInsertEventsData* _data_);
static void zeitgeist_log_insert_events_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void zeitgeist_log_find_events_data_free (gpointer _data);
static gboolean zeitgeist_log_find_events_co (ZeitgeistLogFindEventsData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void* ___lambda11_ (Block3Data* _data3_);
static gboolean _zeitgeist_log_find_events_co_gsource_func (gpointer self);
static gpointer ____lambda11__gthread_func (gpointer self);
static ZeitgeistLogDbWorker* zeitgeist_log_db_worker_new (GThreadFunc func,
                                                   gpointer func_target);
static ZeitgeistLogDbWorker* zeitgeist_log_db_worker_construct (GType object_type,
                                                         GThreadFunc func,
                                                         gpointer func_target);
static void zeitgeist_log_find_events_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static void zeitgeist_log_find_event_ids_data_free (gpointer _data);
static gboolean zeitgeist_log_find_event_ids_co (ZeitgeistLogFindEventIdsData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void* ___lambda12_ (Block5Data* _data5_);
static gboolean _zeitgeist_log_find_event_ids_co_gsource_func (gpointer self);
static gpointer ____lambda12__gthread_func (gpointer self);
static guint32* _vala_array_dup1 (guint32* self,
                           gssize length);
static void zeitgeist_log_find_event_ids_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void zeitgeist_log_get_events_data_free (gpointer _data);
static gboolean zeitgeist_log_get_events_co (ZeitgeistLogGetEventsData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void* ___lambda13_ (Block7Data* _data7_);
static gboolean _zeitgeist_log_get_events_co_gsource_func (gpointer self);
static gpointer ____lambda13__gthread_func (gpointer self);
static void zeitgeist_log_get_events_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static void zeitgeist_log_find_related_uris_data_free (gpointer _data);
static gboolean zeitgeist_log_find_related_uris_co (ZeitgeistLogFindRelatedUrisData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void* ___lambda14_ (Block9Data* _data9_);
static gboolean _zeitgeist_log_find_related_uris_co_gsource_func (gpointer self);
static gpointer ____lambda14__gthread_func (gpointer self);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void zeitgeist_log_find_related_uris_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void zeitgeist_log_delete_events_data_free (gpointer _data);
static gboolean zeitgeist_log_delete_events_co (ZeitgeistLogDeleteEventsData* _data_);
static void zeitgeist_log_delete_events_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void zeitgeist_log_quit_data_free (gpointer _data);
static gboolean zeitgeist_log_quit_co (ZeitgeistLogQuitData* _data_);
static void zeitgeist_log_quit_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_);
static void zeitgeist_log_reinstall_monitor_data_free (gpointer _data);
static gboolean zeitgeist_log_reinstall_monitor_co (ZeitgeistLogReinstallMonitorData* _data_);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda15_ (Block10Data* _data10_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda15__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void zeitgeist_log_db_worker_finalize (ZeitgeistLogDbWorker * obj);
static GType zeitgeist_log_db_worker_get_type_once (void);
static void zeitgeist_log_finalize (GObject * obj);
static GType zeitgeist_log_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
zeitgeist_log_get_instance_private (ZeitgeistLog* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistLog_private_offset);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data1_->self;
		_g_main_loop_unref0 (_data1_->mainloop);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
__lambda9_ (Block1Data* _data1_,
            GObject* obj,
            GAsyncResult* res)
{
	ZeitgeistLog* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		ZeitgeistRemoteLog* _tmp0_ = NULL;
		ZeitgeistRemoteLog* _tmp1_;
		ZeitgeistRemoteLog* _tmp2_;
		ZeitgeistRemoteLog* _tmp3_;
		ZeitgeistRemoteLog* _tmp4_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (ZeitgeistRemoteLog*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (ZeitgeistRemoteLog*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->proxy);
		self->priv->proxy = _tmp3_;
		_tmp4_ = self->priv->proxy;
		zeitgeist_queued_proxy_wrapper_proxy_acquired ((ZeitgeistQueuedProxyWrapper*) self, (GObject*) _tmp4_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_critical ("log.vala:103: Unable to connect to Zeitgeist: %s", _tmp6_);
		_tmp7_ = err;
		zeitgeist_queued_proxy_wrapper_proxy_unavailable ((ZeitgeistQueuedProxyWrapper*) self, _tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_main_loop_quit (_data1_->mainloop);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda9__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda9_ (self, source_object, res);
	block1_data_unref (self);
}

ZeitgeistLog*
zeitgeist_log_construct (GType object_type)
{
	ZeitgeistLog * self = NULL;
	Block1Data* _data1_;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GMainContext* _tmp3_;
	GMainLoop* _tmp4_;
	GError* _inner_error0_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	self = (ZeitgeistLog*) zeitgeist_queued_proxy_wrapper_construct (object_type);
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, NULL);
	_g_hash_table_unref0 (self->priv->monitors);
	self->priv->monitors = _tmp2_;
	_tmp3_ = g_main_context_get_thread_default ();
	_tmp4_ = g_main_loop_new (_tmp3_, FALSE);
	_data1_->mainloop = _tmp4_;
	self->priv->allow_direct_read = zeitgeist_utils_log_may_read_directly ();
	g_async_initable_new_async (ZEITGEIST_TYPE_REMOTE_LOG_PROXY, 0, NULL, ___lambda9__gasync_ready_callback, block1_data_ref (_data1_), "g-flags", 0, "g-name", ZEITGEIST_UTILS_ENGINE_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", ZEITGEIST_UTILS_ENGINE_DBUS_PATH, "g-interface-name", "org.gnome.zeitgeist.Log", NULL);
	g_main_loop_run (_data1_->mainloop);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}

ZeitgeistLog*
zeitgeist_log_new (void)
{
	return zeitgeist_log_construct (ZEITGEIST_TYPE_LOG);
}

/**
     * Get a unique instance of #ZeitgeistLog, that you can share in your
     * application without caring about memory management.
     *
     * See zeitgeist_log_new() for more information.
     *
     * @return ZeitgeistLog.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ZeitgeistLog*
zeitgeist_log_get_default (void)
{
	ZeitgeistLog* _tmp0_;
	ZeitgeistLog* _tmp2_;
	ZeitgeistLog* _tmp3_;
	ZeitgeistLog* result;
	_tmp0_ = zeitgeist_log_default_instance;
	if (_tmp0_ == NULL) {
		ZeitgeistLog* _tmp1_;
		_tmp1_ = zeitgeist_log_new ();
		_g_object_unref0 (zeitgeist_log_default_instance);
		zeitgeist_log_default_instance = _tmp1_;
	}
	_tmp2_ = zeitgeist_log_default_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static GVariant*
_variant_new1 (ZeitgeistVersionStruct value)
{
	GVariantBuilder _tmp6_;
	g_variant_builder_init (&_tmp6_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp6_, g_variant_new_int32 (value.major));
	g_variant_builder_add_value (&_tmp6_, g_variant_new_int32 (value.minor));
	g_variant_builder_add_value (&_tmp6_, g_variant_new_int32 (value.micro));
	return g_variant_ref_sink (g_variant_builder_end (&_tmp6_));
}

static void
___lambda10_ (ZeitgeistLog* self,
              ZeitgeistLogDbWorker* worker)
{
	g_return_if_fail (worker != NULL);
	zeitgeist_log_db_worker_run (worker);
	_zeitgeist_log_db_worker_unref0 (worker);
}

static void
____lambda10__gfunc (gpointer data,
                     gpointer self)
{
	___lambda10_ ((ZeitgeistLog*) self, (ZeitgeistLogDbWorker*) data);
}

static void
zeitgeist_log_real_on_connection_established (ZeitgeistQueuedProxyWrapper* base)
{
	ZeitgeistLog * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	ZeitgeistRemoteLog* _tmp3_;
	ZeitgeistVersionStruct _tmp4_ = {0};
	ZeitgeistVersionStruct _tmp5_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistLog*) base;
	_tmp0_ = self->priv->monitors;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	{
		GList* monitor_collection = NULL;
		GList* monitor_it = NULL;
		monitor_collection = _tmp1_;
		for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
			ZeitgeistMonitor* monitor = NULL;
			monitor = (ZeitgeistMonitor*) monitor_it->data;
			{
				ZeitgeistMonitor* _tmp2_;
				_tmp2_ = monitor;
				zeitgeist_log_reinstall_monitor (self, _tmp2_, NULL, NULL);
			}
		}
		(monitor_collection == NULL) ? NULL : (monitor_collection = (g_list_free (monitor_collection), NULL));
	}
	_tmp3_ = self->priv->proxy;
	zeitgeist_remote_log_get_version (_tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	_tmp7_ = _variant_new1 (_tmp5_);
	_g_variant_unref0 (self->priv->engine_version);
	self->priv->engine_version = _tmp7_;
	_tmp8_ = self->priv->engine_version;
	_tmp9_ = g_variant_get_type_string (_tmp8_);
	g_warn_if_fail (g_strcmp0 (_tmp9_, "(iii)") == 0);
	{
		GThreadPool* _tmp10_ = NULL;
		GThreadPool* _tmp11_;
		GThreadPool* _tmp12_;
		_tmp11_ = g_thread_pool_new (____lambda10__gfunc, self, (gint) g_get_num_processors (), TRUE, &_inner_error0_);
		_tmp10_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_THREAD_ERROR) {
				goto __catch0_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp12_ = _tmp10_;
		_tmp10_ = NULL;
		_g_thread_pool_free0 (self->priv->threads);
		self->priv->threads = _tmp12_;
		_g_thread_pool_free0 (_tmp10_);
	}
	goto __finally0;
	__catch0_g_thread_error:
	{
		GError* err = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = err;
		_tmp14_ = _tmp13_->message;
		g_warning ("log.vala:148: %s", _tmp14_);
		_g_thread_pool_free0 (self->priv->threads);
		self->priv->threads = NULL;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (self->priv->allow_direct_read) {
		GThreadPool* _tmp18_;
		_tmp18_ = self->priv->threads;
		_tmp17_ = _tmp18_ != NULL;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ZeitgeistRemoteLog* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp19_ = self->priv->proxy;
		_tmp20_ = zeitgeist_remote_log_get_datapath (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp16_ = g_strcmp0 (_tmp22_, ":memory:") != 0;
		_g_free0 (_tmp22_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ZeitgeistRemoteLog* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp23_ = self->priv->proxy;
		_tmp24_ = zeitgeist_remote_log_get_datapath (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp15_ = g_file_test (_tmp26_, G_FILE_TEST_EXISTS);
		_g_free0 (_tmp26_);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ZeitgeistRemoteLog* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp27_ = self->priv->proxy;
		_tmp28_ = zeitgeist_remote_log_get_datapath (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_;
		zeitgeist_utils_set_database_file_path (_tmp30_);
		_g_free0 (_tmp30_);
		{
			ZeitgeistDbReader* _tmp31_ = NULL;
			ZeitgeistDbReader* _tmp32_;
			ZeitgeistDbReader* _tmp33_;
			_tmp32_ = zeitgeist_db_reader_new (&_inner_error0_);
			_tmp31_ = _tmp32_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					goto __catch1_zeitgeist_engine_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp33_ = _tmp31_;
			_tmp31_ = NULL;
			_g_object_unref0 (self->priv->dbreader);
			self->priv->dbreader = _tmp33_;
			_g_object_unref0 (_tmp31_);
		}
		goto __finally1;
		__catch1_zeitgeist_engine_error:
		{
			GError* err = NULL;
			GError* _tmp34_;
			const gchar* _tmp35_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp34_ = err;
			_tmp35_ = _tmp34_->message;
			g_warning ("log.vala:159: %s", _tmp35_);
			_g_object_unref0 (self->priv->dbreader);
			self->priv->dbreader = NULL;
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		_g_object_unref0 (self->priv->dbreader);
		self->priv->dbreader = NULL;
	}
}

static void
zeitgeist_log_real_on_connection_lost (ZeitgeistQueuedProxyWrapper* base)
{
	ZeitgeistLog * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	self = (ZeitgeistLog*) base;
	_tmp0_ = self->priv->monitors;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	{
		GList* monitor_collection = NULL;
		GList* monitor_it = NULL;
		monitor_collection = _tmp1_;
		for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
			ZeitgeistMonitor* monitor = NULL;
			monitor = (ZeitgeistMonitor*) monitor_it->data;
			{
				GHashTable* _tmp2_;
				ZeitgeistMonitor* _tmp3_;
				ZeitgeistMonitor* _tmp4_;
				_tmp2_ = self->priv->monitors;
				_tmp3_ = monitor;
				_tmp4_ = _g_object_ref0 (_tmp3_);
				g_hash_table_replace (_tmp2_, _tmp4_, (gpointer) ((guintptr) 0));
			}
		}
		(monitor_collection == NULL) ? NULL : (monitor_collection = (g_list_free (monitor_collection), NULL));
	}
	_g_object_unref0 (self->priv->dbreader);
	self->priv->dbreader = NULL;
}

static void
zeitgeist_log_insert_event_data_free (gpointer _data)
{
	ZeitgeistLogInsertEventData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->event);
	_g_object_unref0 (_data_->cancellable);
	_g_array_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogInsertEventData, _data_);
}

void
zeitgeist_log_insert_event (ZeitgeistLog* self,
                            ZeitgeistEvent* event,
                            GCancellable* cancellable,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	ZeitgeistLogInsertEventData* _data_;
	ZeitgeistLog* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_data_ = g_slice_new0 (ZeitgeistLogInsertEventData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_log_insert_event_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (event);
	_g_object_unref0 (_data_->event);
	_data_->event = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	zeitgeist_log_insert_event_co (_data_);
}

GArray*
zeitgeist_log_insert_event_finish (ZeitgeistLog* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	GArray* result;
	ZeitgeistLogInsertEventData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
    * Asynchronously send a set of events to the Zeitgeist daemon, requesting they
    * be inserted into the log.
    *
    * @param event A {@link Event}
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static void
zeitgeist_log_insert_event_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	ZeitgeistLogInsertEventData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_insert_event_co (_data_);
}

static gboolean
zeitgeist_log_insert_event_co (ZeitgeistLogInsertEventData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->events = _data_->_tmp0_;
	_data_->_tmp1_ = _g_object_ref0 (_data_->event);
	g_ptr_array_add (_data_->events, _data_->_tmp1_);
	_data_->_state_ = 1;
	zeitgeist_log_insert_events (_data_->self, _data_->events, _data_->cancellable, zeitgeist_log_insert_event_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = zeitgeist_log_insert_events_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp2_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->events);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp2_;
	_data_->_tmp2_ = NULL;
	_data_->result = _data_->_tmp4_;
	_g_array_unref0 (_data_->_tmp2_);
	_g_ptr_array_unref0 (_data_->events);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_log_insert_events_data_free (gpointer _data)
{
	ZeitgeistLogInsertEventsData* _data_;
	_data_ = _data;
	_g_ptr_array_unref0 (_data_->events);
	_g_object_unref0 (_data_->cancellable);
	_g_array_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogInsertEventsData, _data_);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
zeitgeist_log_insert_events (ZeitgeistLog* self,
                             GPtrArray* events,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	ZeitgeistLogInsertEventsData* _data_;
	ZeitgeistLog* _tmp0_;
	GPtrArray* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_data_ = g_slice_new0 (ZeitgeistLogInsertEventsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_log_insert_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_ptr_array_ref0 (events);
	_g_ptr_array_unref0 (_data_->events);
	_data_->events = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	zeitgeist_log_insert_events_co (_data_);
}

GArray*
zeitgeist_log_insert_events_finish (ZeitgeistLog* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	GArray* result;
	ZeitgeistLogInsertEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
    * Asynchronously send a set of events to the Zeitgeist daemon, requesting they
    * be inserted into the log.
    *
    * @param events An {@link GLib.GenericArray} of {@link Event}
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
zeitgeist_log_insert_events_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	ZeitgeistLogInsertEventsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_insert_events_co (_data_);
}

static gboolean
zeitgeist_log_insert_events_co (ZeitgeistLogInsertEventsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->events_cp = _data_->_tmp0_;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp3_ = vala_g_ptr_array_get_length (_data_->events);
				_data_->_tmp4_ = _data_->_tmp3_;
				if (!(_data_->i < _data_->_tmp4_)) {
					break;
				}
				_data_->_tmp5_ = _data_->events_cp;
				_data_->_tmp6_ = g_ptr_array_index (_data_->events, (guint) _data_->i);
				_data_->_tmp7_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp6_);
				g_ptr_array_add (_data_->_tmp5_, _data_->_tmp7_);
			}
		}
	}
	_data_->_state_ = 1;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_insert_events_ready, _data_);
	return FALSE;
	_state_1:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->events_cp);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->self->priv->proxy;
	_data_->_tmp9_ = _data_->events_cp;
	_data_->_tmp10_ = zeitgeist_events_to_variant (_data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = 0;
	_data_->_state_ = 2;
	zeitgeist_remote_log_insert_events (_data_->_tmp8_, _data_->_tmp11_, _data_->cancellable, NULL, zeitgeist_log_insert_events_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp13_ = zeitgeist_remote_log_insert_events_finish (_data_->_tmp8_, _data_->_res_, &_data_->_tmp12_, &_data_->_inner_error0_);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp14__length1 = _data_->_tmp12_;
	_g_variant_unref0 (_data_->_tmp11_);
	_data_->ids = _data_->_tmp14_;
	_data_->ids_length1 = _data_->_tmp14__length1;
	_data_->_ids_size_ = _data_->ids_length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->events_cp);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = g_array_new (TRUE, TRUE, sizeof (guint32));
	_data_->_result_ = _data_->_tmp15_;
	{
		_data_->_vala1_i = 0;
		{
			_data_->_tmp16_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp16_) {
					_data_->_vala1_i = _data_->_vala1_i + 1;
					_data_->_tmp17_ = _data_->_vala1_i;
				}
				_data_->_tmp16_ = FALSE;
				_data_->_tmp18_ = _data_->ids;
				_data_->_tmp18__length1 = _data_->ids_length1;
				if (!(_data_->_vala1_i < _data_->_tmp18__length1)) {
					break;
				}
				_data_->_tmp19_ = _data_->_result_;
				_data_->_tmp20_ = _data_->ids;
				_data_->_tmp20__length1 = _data_->ids_length1;
				_data_->_tmp21_ = _data_->_tmp20_[_data_->_vala1_i];
				g_array_append_val (_data_->_tmp19_, _data_->_tmp21_);
			}
		}
	}
	_data_->result = _data_->_result_;
	_data_->ids = (g_free (_data_->ids), NULL);
	_g_ptr_array_unref0 (_data_->events_cp);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
    * Asynchronously send a set of events to the Zeitgeist daemon, requesting they
    * be inserted into the log.
    * This method is &quot;fire and forget&quot; and the caller will never know
    * whether the events was successfully inserted or not.
    *
    * This method is exactly equivalent to calling zeitgeist_log_insert_event()
    * with NULL set as @cancellable, @callback, and @user_data.
    *
    * @param event A {@link Event}
    */
void
zeitgeist_log_insert_event_no_reply (ZeitgeistLog* self,
                                     ZeitgeistEvent* event,
                                     GError** error)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	zeitgeist_log_insert_event (self, event, NULL, NULL, NULL);
}

/**
    * Asynchronously send a set of events to the Zeitgeist daemon, requesting they
    * be inserted into the log.
    * This method is &quot;fire and forget&quot; and the caller will never know
    * whether the events was successfully inserted or not.
    *
    * This method is exactly equivalent to calling zeitgeist_log_insert_event()
    * with NULL set as @cancellable, @callback, and @user_data.
    *
    * @param events An {@link GLib.GenericArray} of {@link Event}
    */
void
zeitgeist_log_insert_events_no_reply (ZeitgeistLog* self,
                                      GPtrArray* events,
                                      GError** error)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	zeitgeist_log_insert_events (self, events, NULL, NULL, NULL);
}

static void
zeitgeist_log_find_events_data_free (gpointer _data)
{
	ZeitgeistLogFindEventsData* _data_;
	_data_ = _data;
	_g_ptr_array_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogFindEventsData, _data_);
}

void
zeitgeist_log_find_events (ZeitgeistLog* self,
                           ZeitgeistTimeRange* time_range,
                           GPtrArray* event_templates,
                           ZeitgeistStorageState storage_state,
                           guint32 num_events,
                           ZeitgeistResultType result_type,
                           GCancellable* cancellable,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	ZeitgeistLogFindEventsData* _data_;
	ZeitgeistLog* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	GPtrArray* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (event_templates != NULL);
	_data_ = g_slice_new0 (ZeitgeistLogFindEventsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_log_find_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (time_range);
	_g_object_unref0 (_data_->time_range);
	_data_->time_range = _tmp1_;
	_tmp2_ = _g_ptr_array_ref0 (event_templates);
	_g_ptr_array_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp2_;
	_data_->storage_state = storage_state;
	_data_->num_events = num_events;
	_data_->result_type = result_type;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	zeitgeist_log_find_events_co (_data_);
}

ZeitgeistResultSet*
zeitgeist_log_find_events_finish (ZeitgeistLog* self,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	ZeitgeistResultSet* result;
	ZeitgeistLogFindEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
    * Send a query matching a collection of {@link Event} templates to the {@link Log}.
    * The query will match if an event matches any of the templates. If an event
    * template has more than one {@link Subject} the query will match if any one
    * of the {@link Subject}s templates match.
    *
    * The query will be done via an asynchronous DBus call and this method will
    * return immediately. The return value will be passed to callback as a list
    * of {@link Event}s. This list must be the sole argument for the callback.
    *
    * If you need to do a query yielding a large (or unpredictable) result set
    * and you only want to show some of the results at the same time (eg., by
    * paging them), consider using {@link find_event_ids}.
    *
    * In order to use this method there needs to be a mainloop runnning.
    * Both Qt and GLib mainloops are supported.
    *
    * @param time_range {@link TimeRange} A time range in which the events should be considered in
    * @param storage_state {@link StorageState} storage state
    * @param event_templates An {@link GLib.GenericArray} of {@link Event}
    * @param num_events int represteing the number of events that should be returned
    * @param result_type {@link ResultType} how the events should be grouped and sorted
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data2_->self;
		_g_ptr_array_unref0 (_data2_->event_templates_cp);
		_g_object_unref0 (_data2_->time_range);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data3_->_data2_->self;
		_g_error_free0 (_data3_->_error_);
		_g_object_unref0 (_data3_->result_set);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
_zeitgeist_log_find_events_co_gsource_func (gpointer self)
{
	gboolean result;
	result = zeitgeist_log_find_events_co (self);
	return result;
}

static void*
___lambda11_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	ZeitgeistLog* self;
	GError* _inner_error0_ = NULL;
	void* result;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	{
		GPtrArray* _result_ = NULL;
		ZeitgeistDbReader* _tmp0_;
		GPtrArray* _tmp1_;
		GPtrArray* _tmp2_;
		ZeitgeistSimpleResultSet* _tmp3_;
		_tmp0_ = self->priv->dbreader;
		_tmp1_ = _data2_->event_templates_cp;
		_tmp2_ = zeitgeist_db_reader_find_events (_tmp0_, _data2_->time_range, _tmp1_, (guint) _data2_->storage_state, (guint) _data2_->num_events, (guint) _data2_->result_type, NULL, &_inner_error0_);
		_result_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = zeitgeist_simple_result_set_new (_result_);
		_g_object_unref0 (_data3_->result_set);
		_data3_->result_set = _tmp3_;
		_g_ptr_array_unref0 (_result_);
	}
	goto __finally0;
	__catch0_zeitgeist_engine_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_g_error_free0 (_data3_->_error_);
		_data3_->_error_ = _tmp5_;
		_g_error_free0 (err);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_find_events_co_gsource_func, _data2_->_async_data_, NULL);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gpointer
____lambda11__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda11_ (self);
	block3_data_unref (self);
	return result;
}

static void
zeitgeist_log_find_events_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	ZeitgeistLogFindEventsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_find_events_co (_data_);
}

static gboolean
zeitgeist_log_find_events_co (ZeitgeistLogFindEventsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data2_->time_range);
	_data_->_data2_->time_range = _data_->time_range;
	_data_->_data2_->storage_state = _data_->storage_state;
	_data_->_data2_->num_events = _data_->num_events;
	_data_->_data2_->result_type = _data_->result_type;
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->_data2_->event_templates_cp = _data_->_tmp0_;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp3_ = vala_g_ptr_array_get_length (_data_->event_templates);
				_data_->_tmp4_ = _data_->_tmp3_;
				if (!(_data_->i < _data_->_tmp4_)) {
					break;
				}
				_data_->_tmp5_ = _data_->_data2_->event_templates_cp;
				_data_->_tmp6_ = g_ptr_array_index (_data_->event_templates, (guint) _data_->i);
				_data_->_tmp7_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp6_);
				g_ptr_array_add (_data_->_tmp5_, _data_->_tmp7_);
			}
		}
	}
	_data_->_tmp8_ = _data_->self->priv->dbreader;
	if (_data_->_tmp8_ != NULL) {
		_data_->_data3_ = g_slice_new0 (Block3Data);
		_data_->_data3_->_ref_count_ = 1;
		_data_->_data3_->_data2_ = block2_data_ref (_data_->_data2_);
		_data_->_data3_->result_set = NULL;
		_data_->_data3_->_error_ = NULL;
		_data_->run = ____lambda11__gthread_func;
		_data_->run_target = block3_data_ref (_data_->_data3_);
		_data_->_tmp9_ = _data_->self->priv->threads;
		_data_->_tmp10_ = _data_->run;
		_data_->_tmp10__target = _data_->run_target;
		_data_->_tmp11_ = zeitgeist_log_db_worker_new (_data_->_tmp10_, _data_->_tmp10__target);
		g_thread_pool_push (_data_->_tmp9_, _data_->_tmp11_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp12_ = _data_->_data3_->_error_;
		if (_data_->_tmp12_ != NULL) {
			_data_->_tmp13_ = _data_->_data3_->_error_;
			_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
			_data_->_inner_error0_ = _data_->_tmp14_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp15_ = _data_->_data3_->result_set;
		_data_->_tmp16_ = _g_object_ref0 ((ZeitgeistResultSet*) _data_->_tmp15_);
		_data_->result = _data_->_tmp16_;
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_find_events_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->self->priv->proxy;
	_data_->_tmp18_ = zeitgeist_time_range_to_variant (_data_->_data2_->time_range);
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = _data_->_data2_->event_templates_cp;
	_data_->_tmp21_ = zeitgeist_events_to_variant (_data_->_tmp20_);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_state_ = 3;
	zeitgeist_remote_log_find_events (_data_->_tmp17_, _data_->_tmp19_, _data_->_tmp22_, (guint) _data_->_data2_->storage_state, (guint) _data_->_data2_->num_events, (guint) _data_->_data2_->result_type, _data_->cancellable, NULL, zeitgeist_log_find_events_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp23_ = zeitgeist_remote_log_find_events_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp24_ = _data_->_tmp23_;
	_g_variant_unref0 (_data_->_tmp22_);
	_g_variant_unref0 (_data_->_tmp19_);
	_data_->_result_ = _data_->_tmp24_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp26_ = _data_->_result_;
	_data_->_tmp27_ = zeitgeist_events_from_variant (_data_->_tmp26_, &_data_->_inner_error0_);
	_data_->_tmp25_ = _data_->_tmp27_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->_result_);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = zeitgeist_simple_result_set_new (_data_->_tmp25_);
	_data_->result = (ZeitgeistResultSet*) _data_->_tmp28_;
	_g_ptr_array_unref0 (_data_->_tmp25_);
	_g_variant_unref0 (_data_->_result_);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_log_find_event_ids_data_free (gpointer _data)
{
	ZeitgeistLogFindEventIdsData* _data_;
	_data_ = _data;
	_g_ptr_array_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_data_->result = (g_free (_data_->result), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogFindEventIdsData, _data_);
}

void
zeitgeist_log_find_event_ids (ZeitgeistLog* self,
                              ZeitgeistTimeRange* time_range,
                              GPtrArray* event_templates,
                              ZeitgeistStorageState storage_state,
                              guint32 num_events,
                              ZeitgeistResultType result_type,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	ZeitgeistLogFindEventIdsData* _data_;
	ZeitgeistLog* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	GPtrArray* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (event_templates != NULL);
	_data_ = g_slice_new0 (ZeitgeistLogFindEventIdsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_log_find_event_ids_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (time_range);
	_g_object_unref0 (_data_->time_range);
	_data_->time_range = _tmp1_;
	_tmp2_ = _g_ptr_array_ref0 (event_templates);
	_g_ptr_array_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp2_;
	_data_->storage_state = storage_state;
	_data_->num_events = num_events;
	_data_->result_type = result_type;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	zeitgeist_log_find_event_ids_co (_data_);
}

guint32*
zeitgeist_log_find_event_ids_finish (ZeitgeistLog* self,
                                     GAsyncResult* _res_,
                                     gint* result_length1,
                                     GError** error)
{
	guint32* result;
	ZeitgeistLogFindEventIdsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

/**
    * Send a query matching a collection of {@link Event} templates to the {@link Log}.
    * The query will match if an event matches any of the templates. If an event
    * template has more than one {@link Subject} the query will match if any one
    * of the {@link Subject}s templates match.
    *
    * The query will be done via an asynchronous DBus call and this method will
    * return immediately. The return value will be passed to callback as a list
    * of intergers represrting {@link Event} id's.
    * This list must be the sole argument for the callback.
    *
    * In order to use this method there needs to be a mainloop runnning.
    * Both Qt and GLib mainloops are supported.
    *
    * @param time_range {@link TimeRange} A time range in which the events should be considered in
    * @param storage_state {@link StorageState} storage state
    * @param event_templates An {@link GLib.GenericArray} of {@link Event}
    * @param num_events int represteing the number of events that should be returned
    * @param result_type {@link ResultType} how the events should be grouped and sorted
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data4_->self;
		_g_ptr_array_unref0 (_data4_->event_templates_cp);
		_g_object_unref0 (_data4_->time_range);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data5_->_data4_->self;
		_g_error_free0 (_data5_->_error_);
		_data5_->ids = (g_free (_data5_->ids), NULL);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
_zeitgeist_log_find_event_ids_co_gsource_func (gpointer self)
{
	gboolean result;
	result = zeitgeist_log_find_event_ids_co (self);
	return result;
}

static void*
___lambda12_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	ZeitgeistLog* self;
	GError* _inner_error0_ = NULL;
	void* result;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	{
		guint32* _tmp0_ = NULL;
		ZeitgeistDbReader* _tmp1_;
		GPtrArray* _tmp2_;
		gint _tmp3_ = 0;
		guint32* _tmp4_;
		gint _tmp0__length1;
		gint __tmp0__size_;
		guint32* _tmp5_;
		gint _tmp5__length1;
		_tmp1_ = self->priv->dbreader;
		_tmp2_ = _data4_->event_templates_cp;
		_tmp4_ = zeitgeist_db_reader_find_event_ids (_tmp1_, _data4_->time_range, _tmp2_, (guint) _data4_->storage_state, (guint) _data4_->num_events, (guint) _data4_->result_type, NULL, &_tmp3_, &_inner_error0_);
		_tmp0_ = _tmp4_;
		_tmp0__length1 = _tmp3_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp5__length1 = _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		_data5_->ids = (g_free (_data5_->ids), NULL);
		_data5_->ids = _tmp5_;
		_data5_->ids_length1 = _tmp5__length1;
		_data5_->_ids_size_ = _data5_->ids_length1;
		_tmp0_ = (g_free (_tmp0_), NULL);
	}
	goto __finally0;
	__catch0_zeitgeist_engine_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		GError* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _g_error_copy0 (_tmp6_);
		_g_error_free0 (_data5_->_error_);
		_data5_->_error_ = _tmp7_;
		_g_error_free0 (err);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_find_event_ids_co_gsource_func, _data4_->_async_data_, NULL);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gpointer
____lambda12__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda12_ (self);
	block5_data_unref (self);
	return result;
}

static guint32*
_vala_array_dup1 (guint32* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint32));
	}
	return NULL;
}

static void
zeitgeist_log_find_event_ids_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	ZeitgeistLogFindEventIdsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_find_event_ids_co (_data_);
}

static gboolean
zeitgeist_log_find_event_ids_co (ZeitgeistLogFindEventIdsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data4_->time_range);
	_data_->_data4_->time_range = _data_->time_range;
	_data_->_data4_->storage_state = _data_->storage_state;
	_data_->_data4_->num_events = _data_->num_events;
	_data_->_data4_->result_type = _data_->result_type;
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->_data4_->event_templates_cp = _data_->_tmp0_;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp3_ = vala_g_ptr_array_get_length (_data_->event_templates);
				_data_->_tmp4_ = _data_->_tmp3_;
				if (!(_data_->i < _data_->_tmp4_)) {
					break;
				}
				_data_->_tmp5_ = _data_->_data4_->event_templates_cp;
				_data_->_tmp6_ = g_ptr_array_index (_data_->event_templates, (guint) _data_->i);
				_data_->_tmp7_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp6_);
				g_ptr_array_add (_data_->_tmp5_, _data_->_tmp7_);
			}
		}
	}
	_data_->_tmp8_ = _data_->self->priv->dbreader;
	if (_data_->_tmp8_ != NULL) {
		_data_->_data5_ = g_slice_new0 (Block5Data);
		_data_->_data5_->_ref_count_ = 1;
		_data_->_data5_->_data4_ = block4_data_ref (_data_->_data4_);
		_data_->_data5_->ids = NULL;
		_data_->_data5_->ids_length1 = 0;
		_data_->_data5_->_ids_size_ = _data_->_data5_->ids_length1;
		_data_->_data5_->_error_ = NULL;
		_data_->run = ____lambda12__gthread_func;
		_data_->run_target = block5_data_ref (_data_->_data5_);
		_data_->_tmp9_ = _data_->self->priv->threads;
		_data_->_tmp10_ = _data_->run;
		_data_->_tmp10__target = _data_->run_target;
		_data_->_tmp11_ = zeitgeist_log_db_worker_new (_data_->_tmp10_, _data_->_tmp10__target);
		g_thread_pool_push (_data_->_tmp9_, _data_->_tmp11_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block5_data_unref (_data_->_data5_);
			_data_->_data5_ = NULL;
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp12_ = _data_->_data5_->_error_;
		if (_data_->_tmp12_ != NULL) {
			_data_->_tmp13_ = _data_->_data5_->_error_;
			_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
			_data_->_inner_error0_ = _data_->_tmp14_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block5_data_unref (_data_->_data5_);
			_data_->_data5_ = NULL;
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp15_ = _data_->_data5_->ids;
		_data_->_tmp15__length1 = _data_->_data5_->ids_length1;
		_data_->_tmp16_ = (_data_->_tmp15_ != NULL) ? _vala_array_dup1 (_data_->_tmp15_, _data_->_tmp15__length1) : _data_->_tmp15_;
		_data_->_tmp16__length1 = _data_->_tmp15__length1;
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp17__length1 = _data_->_tmp16__length1;
		_data_->result_length1 = _data_->_tmp17__length1;
		_data_->result = _data_->_tmp17_;
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_find_event_ids_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->self->priv->proxy;
	_data_->_tmp20_ = zeitgeist_time_range_to_variant (_data_->_data4_->time_range);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = _data_->_data4_->event_templates_cp;
	_data_->_tmp23_ = zeitgeist_events_to_variant (_data_->_tmp22_);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = 0;
	_data_->_state_ = 3;
	zeitgeist_remote_log_find_event_ids (_data_->_tmp19_, _data_->_tmp21_, _data_->_tmp24_, (guint) _data_->_data4_->storage_state, (guint) _data_->_data4_->num_events, (guint) _data_->_data4_->result_type, _data_->cancellable, NULL, zeitgeist_log_find_event_ids_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp26_ = zeitgeist_remote_log_find_event_ids_finish (_data_->_tmp19_, _data_->_res_, &_data_->_tmp25_, &_data_->_inner_error0_);
	_data_->_tmp27_ = _data_->_tmp26_;
	_data_->_tmp27__length1 = _data_->_tmp25_;
	_g_variant_unref0 (_data_->_tmp24_);
	_g_variant_unref0 (_data_->_tmp21_);
	_data_->_tmp18_ = _data_->_tmp27_;
	_data_->_tmp18__length1 = _data_->_tmp27__length1;
	_data_->__tmp18__size_ = _data_->_tmp18__length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = _data_->_tmp18_;
	_data_->_tmp28__length1 = _data_->_tmp18__length1;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18__length1 = 0;
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp29__length1 = _data_->_tmp28__length1;
	_data_->result_length1 = _data_->_tmp29__length1;
	_data_->result = _data_->_tmp29_;
	_data_->_tmp18_ = (g_free (_data_->_tmp18_), NULL);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_log_get_events_data_free (gpointer _data)
{
	ZeitgeistLogGetEventsData* _data_;
	_data_ = _data;
	_g_array_unref0 (_data_->event_ids);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogGetEventsData, _data_);
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

void
zeitgeist_log_get_events (ZeitgeistLog* self,
                          GArray* event_ids,
                          GCancellable* cancellable,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	ZeitgeistLogGetEventsData* _data_;
	ZeitgeistLog* _tmp0_;
	GArray* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event_ids != NULL);
	_data_ = g_slice_new0 (ZeitgeistLogGetEventsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_log_get_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_array_ref0 (event_ids);
	_g_array_unref0 (_data_->event_ids);
	_data_->event_ids = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	zeitgeist_log_get_events_co (_data_);
}

ZeitgeistResultSet*
zeitgeist_log_get_events_finish (ZeitgeistLog* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	ZeitgeistResultSet* result;
	ZeitgeistLogGetEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
    * Look up a collection of {@link Event} in the {@link Log} given a collection
    * of event ids. This is useful for looking up the event data for events found
    * with the find_event_ids_* family of functions.
    *
    * Each {@link Event} which is not found in the {@link Log} is represented by
    * NULL in the resulting collection. The query will be done via an asynchronous
    * DBus call and this method will return immediately. The returned events will
    * be passed to callback as a list of {@link Event}s, which must be the only
    * argument of the function.
    *
    * In order to use this method there needs to be a mainloop runnning.
    *
    * @param event_ids a {@link GLib.Array} of {@link Event} ids
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data6_->self;
		_data6_->simple_event_ids = (g_free (_data6_->simple_event_ids), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data7_->_data6_->self;
		_g_error_free0 (_data7_->_error_);
		_g_object_unref0 (_data7_->result_set);
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
_zeitgeist_log_get_events_co_gsource_func (gpointer self)
{
	gboolean result;
	result = zeitgeist_log_get_events_co (self);
	return result;
}

static void*
___lambda13_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	ZeitgeistLog* self;
	GError* _inner_error0_ = NULL;
	void* result;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	{
		GPtrArray* _result_ = NULL;
		ZeitgeistDbReader* _tmp0_;
		guint32* _tmp1_;
		gint _tmp1__length1;
		GPtrArray* _tmp2_;
		ZeitgeistSimpleResultSet* _tmp3_;
		_tmp0_ = self->priv->dbreader;
		_tmp1_ = _data6_->simple_event_ids;
		_tmp1__length1 = _data6_->simple_event_ids_length1;
		_tmp2_ = zeitgeist_db_reader_get_events (_tmp0_, _tmp1_, (gint) _tmp1__length1, NULL, &_inner_error0_);
		_result_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = zeitgeist_simple_result_set_new (_result_);
		_g_object_unref0 (_data7_->result_set);
		_data7_->result_set = _tmp3_;
		_g_ptr_array_unref0 (_result_);
	}
	goto __finally0;
	__catch0_zeitgeist_engine_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_g_error_free0 (_data7_->_error_);
		_data7_->_error_ = _tmp5_;
		_g_error_free0 (err);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_get_events_co_gsource_func, _data6_->_async_data_, NULL);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gpointer
____lambda13__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda13_ (self);
	block7_data_unref (self);
	return result;
}

static void
zeitgeist_log_get_events_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	ZeitgeistLogGetEventsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_get_events_co (_data_);
}

static gboolean
zeitgeist_log_get_events_co (ZeitgeistLogGetEventsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_data_->_data6_->_async_data_ = _data_;
	_data_->_tmp0_ = g_new0 (guint32, _data_->event_ids->len);
	_data_->_data6_->simple_event_ids = _data_->_tmp0_;
	_data_->_data6_->simple_event_ids_length1 = _data_->event_ids->len;
	_data_->_data6_->_simple_event_ids_size_ = _data_->_data6_->simple_event_ids_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				if (!(((guint) _data_->i) < _data_->event_ids->len)) {
					break;
				}
				_data_->_tmp3_ = _data_->_data6_->simple_event_ids;
				_data_->_tmp3__length1 = _data_->_data6_->simple_event_ids_length1;
				_data_->_tmp3_[_data_->i] = g_array_index (_data_->event_ids, guint32, (guint) _data_->i);
			}
		}
	}
	_data_->_tmp4_ = _data_->self->priv->dbreader;
	if (_data_->_tmp4_ != NULL) {
		_data_->_data7_ = g_slice_new0 (Block7Data);
		_data_->_data7_->_ref_count_ = 1;
		_data_->_data7_->_data6_ = block6_data_ref (_data_->_data6_);
		_data_->_data7_->result_set = NULL;
		_data_->_data7_->_error_ = NULL;
		_data_->run = ____lambda13__gthread_func;
		_data_->run_target = block7_data_ref (_data_->_data7_);
		_data_->_tmp5_ = _data_->self->priv->threads;
		_data_->_tmp6_ = _data_->run;
		_data_->_tmp6__target = _data_->run_target;
		_data_->_tmp7_ = zeitgeist_log_db_worker_new (_data_->_tmp6_, _data_->_tmp6__target);
		g_thread_pool_push (_data_->_tmp5_, _data_->_tmp7_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block7_data_unref (_data_->_data7_);
			_data_->_data7_ = NULL;
			block6_data_unref (_data_->_data6_);
			_data_->_data6_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp8_ = _data_->_data7_->_error_;
		if (_data_->_tmp8_ != NULL) {
			_data_->_tmp9_ = _data_->_data7_->_error_;
			_data_->_tmp10_ = _g_error_copy0 (_data_->_tmp9_);
			_data_->_inner_error0_ = _data_->_tmp10_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block7_data_unref (_data_->_data7_);
			_data_->_data7_ = NULL;
			block6_data_unref (_data_->_data6_);
			_data_->_data6_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = _data_->_data7_->result_set;
		_data_->_tmp12_ = _g_object_ref0 ((ZeitgeistResultSet*) _data_->_tmp11_);
		_data_->result = _data_->_tmp12_;
		block7_data_unref (_data_->_data7_);
		_data_->_data7_ = NULL;
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_get_events_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->self->priv->proxy;
	_data_->_tmp14_ = _data_->_data6_->simple_event_ids;
	_data_->_tmp14__length1 = _data_->_data6_->simple_event_ids_length1;
	_data_->_state_ = 3;
	zeitgeist_remote_log_get_events (_data_->_tmp13_, _data_->_tmp14_, (gint) _data_->_tmp14__length1, _data_->cancellable, NULL, zeitgeist_log_get_events_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp15_ = zeitgeist_remote_log_get_events_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_result_ = _data_->_tmp15_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->_result_;
	_data_->_tmp18_ = zeitgeist_events_from_variant (_data_->_tmp17_, &_data_->_inner_error0_);
	_data_->_tmp16_ = _data_->_tmp18_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->_result_);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = zeitgeist_simple_result_set_new (_data_->_tmp16_);
	_data_->result = (ZeitgeistResultSet*) _data_->_tmp19_;
	_g_ptr_array_unref0 (_data_->_tmp16_);
	_g_variant_unref0 (_data_->_result_);
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_log_find_related_uris_data_free (gpointer _data)
{
	ZeitgeistLogFindRelatedUrisData* _data_;
	_data_ = _data;
	_g_ptr_array_unref0 (_data_->event_templates);
	_g_ptr_array_unref0 (_data_->result_event_templates);
	_g_object_unref0 (_data_->cancellable);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogFindRelatedUrisData, _data_);
}

void
zeitgeist_log_find_related_uris (ZeitgeistLog* self,
                                 ZeitgeistTimeRange* time_range,
                                 GPtrArray* event_templates,
                                 GPtrArray* result_event_templates,
                                 ZeitgeistStorageState storage_state,
                                 guint32 num_events,
                                 ZeitgeistRelevantResultType result_type,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	ZeitgeistLogFindRelatedUrisData* _data_;
	ZeitgeistLog* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (event_templates != NULL);
	g_return_if_fail (result_event_templates != NULL);
	_data_ = g_slice_new0 (ZeitgeistLogFindRelatedUrisData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_log_find_related_uris_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (time_range);
	_g_object_unref0 (_data_->time_range);
	_data_->time_range = _tmp1_;
	_tmp2_ = _g_ptr_array_ref0 (event_templates);
	_g_ptr_array_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp2_;
	_tmp3_ = _g_ptr_array_ref0 (result_event_templates);
	_g_ptr_array_unref0 (_data_->result_event_templates);
	_data_->result_event_templates = _tmp3_;
	_data_->storage_state = storage_state;
	_data_->num_events = num_events;
	_data_->result_type = result_type;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_log_find_related_uris_co (_data_);
}

gchar**
zeitgeist_log_find_related_uris_finish (ZeitgeistLog* self,
                                        GAsyncResult* _res_,
                                        gint* result_length1,
                                        GError** error)
{
	gchar** result;
	ZeitgeistLogFindRelatedUrisData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

/**
    * Get a list of URIs of subjects which frequently occur together with events
    * matching event_templates. Possibly restricting to time_range or to URIs
    * that occur as subject of events matching result_event_templates.
    *
    * @param time_range {@link TimeRange} A time range in which the events should be considered in
    * @param storage_state {@link StorageState} storage state
    * @param event_templates An {@link GLib.GenericArray} of {@link Event} describing the events to relate to
    * @param result_event_templates An {@link GLib.GenericArray} of {@link Event} desrcibing the result to be returned
    * @param num_events int represteing the number of events that should be returned
    * @param result_type {@link ResultType} how the events should be grouped and sorted
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data8_->self;
		_g_ptr_array_unref0 (_data8_->results_cp);
		_g_ptr_array_unref0 (_data8_->events_cp);
		_g_object_unref0 (_data8_->time_range);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data9_->_data8_->self;
		_g_error_free0 (_data9_->_error_);
		_data9_->uris = (_vala_array_free (_data9_->uris, _data9_->uris_length1, (GDestroyNotify) g_free), NULL);
		block8_data_unref (_data9_->_data8_);
		_data9_->_data8_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}

static gboolean
_zeitgeist_log_find_related_uris_co_gsource_func (gpointer self)
{
	gboolean result;
	result = zeitgeist_log_find_related_uris_co (self);
	return result;
}

static void*
___lambda14_ (Block9Data* _data9_)
{
	Block8Data* _data8_;
	ZeitgeistLog* self;
	GError* _inner_error0_ = NULL;
	void* result;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	{
		gchar** _tmp0_ = NULL;
		ZeitgeistDbReader* _tmp1_;
		GPtrArray* _tmp2_;
		GPtrArray* _tmp3_;
		gint _tmp4_ = 0;
		gchar** _tmp5_;
		gint _tmp0__length1;
		gint __tmp0__size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp1_ = self->priv->dbreader;
		_tmp2_ = _data8_->events_cp;
		_tmp3_ = _data8_->results_cp;
		_tmp5_ = zeitgeist_db_reader_find_related_uris (_tmp1_, _data8_->time_range, _tmp2_, _tmp3_, (guint) _data8_->storage_state, (guint) _data8_->num_events, (guint) _data8_->result_type, NULL, &_tmp4_, &_inner_error0_);
		_tmp0_ = _tmp5_;
		_tmp0__length1 = _tmp4_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp6_ = _tmp0_;
		_tmp6__length1 = _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		_data9_->uris = (_vala_array_free (_data9_->uris, _data9_->uris_length1, (GDestroyNotify) g_free), NULL);
		_data9_->uris = _tmp6_;
		_data9_->uris_length1 = _tmp6__length1;
		_data9_->_uris_size_ = _data9_->uris_length1;
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_zeitgeist_engine_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_g_error_free0 (_data9_->_error_);
		_data9_->_error_ = _tmp8_;
		_g_error_free0 (err);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _zeitgeist_log_find_related_uris_co_gsource_func, _data8_->_async_data_, NULL);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gpointer
____lambda14__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda14_ (self);
	block9_data_unref (self);
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
zeitgeist_log_find_related_uris_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	ZeitgeistLogFindRelatedUrisData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_find_related_uris_co (_data_);
}

static gboolean
zeitgeist_log_find_related_uris_co (ZeitgeistLogFindRelatedUrisData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data8_->time_range);
	_data_->_data8_->time_range = _data_->time_range;
	_data_->_data8_->storage_state = _data_->storage_state;
	_data_->_data8_->num_events = _data_->num_events;
	_data_->_data8_->result_type = _data_->result_type;
	_data_->_data8_->_async_data_ = _data_;
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->_data8_->events_cp = _data_->_tmp0_;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp3_ = vala_g_ptr_array_get_length (_data_->event_templates);
				_data_->_tmp4_ = _data_->_tmp3_;
				if (!(_data_->i < _data_->_tmp4_)) {
					break;
				}
				_data_->_tmp5_ = _data_->_data8_->events_cp;
				_data_->_tmp6_ = g_ptr_array_index (_data_->event_templates, (guint) _data_->i);
				_data_->_tmp7_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp6_);
				g_ptr_array_add (_data_->_tmp5_, _data_->_tmp7_);
			}
		}
	}
	_data_->_tmp8_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->_data8_->results_cp = _data_->_tmp8_;
	{
		_data_->_vala1_i = 0;
		{
			_data_->_tmp9_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp9_) {
					_data_->_tmp10_ = _data_->_vala1_i;
					_data_->_vala1_i = _data_->_tmp10_ + 1;
				}
				_data_->_tmp9_ = FALSE;
				_data_->_tmp11_ = vala_g_ptr_array_get_length (_data_->result_event_templates);
				_data_->_tmp12_ = _data_->_tmp11_;
				if (!(_data_->_vala1_i < _data_->_tmp12_)) {
					break;
				}
				_data_->_tmp13_ = _data_->_data8_->results_cp;
				_data_->_tmp14_ = g_ptr_array_index (_data_->result_event_templates, (guint) _data_->_vala1_i);
				_data_->_tmp15_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp14_);
				g_ptr_array_add (_data_->_tmp13_, _data_->_tmp15_);
			}
		}
	}
	_data_->_tmp16_ = _data_->self->priv->dbreader;
	if (_data_->_tmp16_ != NULL) {
		_data_->_data9_ = g_slice_new0 (Block9Data);
		_data_->_data9_->_ref_count_ = 1;
		_data_->_data9_->_data8_ = block8_data_ref (_data_->_data8_);
		_data_->_data9_->uris = NULL;
		_data_->_data9_->uris_length1 = 0;
		_data_->_data9_->_uris_size_ = _data_->_data9_->uris_length1;
		_data_->_data9_->_error_ = NULL;
		_data_->run = ____lambda14__gthread_func;
		_data_->run_target = block9_data_ref (_data_->_data9_);
		_data_->_tmp17_ = _data_->self->priv->threads;
		_data_->_tmp18_ = _data_->run;
		_data_->_tmp18__target = _data_->run_target;
		_data_->_tmp19_ = zeitgeist_log_db_worker_new (_data_->_tmp18_, _data_->_tmp18__target);
		g_thread_pool_push (_data_->_tmp17_, _data_->_tmp19_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block9_data_unref (_data_->_data9_);
			_data_->_data9_ = NULL;
			block8_data_unref (_data_->_data8_);
			_data_->_data8_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp20_ = _data_->_data9_->_error_;
		if (_data_->_tmp20_ != NULL) {
			_data_->_tmp21_ = _data_->_data9_->_error_;
			_data_->_tmp22_ = _g_error_copy0 (_data_->_tmp21_);
			_data_->_inner_error0_ = _data_->_tmp22_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block9_data_unref (_data_->_data9_);
			_data_->_data9_ = NULL;
			block8_data_unref (_data_->_data8_);
			_data_->_data8_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp23_ = _data_->_data9_->uris;
		_data_->_tmp23__length1 = _data_->_data9_->uris_length1;
		_data_->_tmp24_ = (_data_->_tmp23_ != NULL) ? _vala_array_dup2 (_data_->_tmp23_, _data_->_tmp23__length1) : _data_->_tmp23_;
		_data_->_tmp24__length1 = _data_->_tmp23__length1;
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp25__length1 = _data_->_tmp24__length1;
		_data_->result_length1 = _data_->_tmp25__length1;
		_data_->result = _data_->_tmp25_;
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_find_related_uris_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = _data_->self->priv->proxy;
	_data_->_tmp28_ = zeitgeist_time_range_to_variant (_data_->_data8_->time_range);
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp30_ = _data_->_data8_->events_cp;
	_data_->_tmp31_ = zeitgeist_events_to_variant (_data_->_tmp30_);
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = _data_->_data8_->results_cp;
	_data_->_tmp34_ = zeitgeist_events_to_variant (_data_->_tmp33_);
	_data_->_tmp35_ = _data_->_tmp34_;
	_data_->_tmp36_ = 0;
	_data_->_state_ = 3;
	zeitgeist_remote_log_find_related_uris (_data_->_tmp27_, _data_->_tmp29_, _data_->_tmp32_, _data_->_tmp35_, (guint) _data_->_data8_->storage_state, (guint) _data_->_data8_->num_events, (guint) _data_->_data8_->result_type, _data_->cancellable, NULL, zeitgeist_log_find_related_uris_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp37_ = zeitgeist_remote_log_find_related_uris_finish (_data_->_tmp27_, _data_->_res_, &_data_->_tmp36_, &_data_->_inner_error0_);
	_data_->_tmp38_ = _data_->_tmp37_;
	_data_->_tmp38__length1 = _data_->_tmp36_;
	_g_variant_unref0 (_data_->_tmp35_);
	_g_variant_unref0 (_data_->_tmp32_);
	_g_variant_unref0 (_data_->_tmp29_);
	_data_->_tmp26_ = _data_->_tmp38_;
	_data_->_tmp26__length1 = _data_->_tmp38__length1;
	_data_->__tmp26__size_ = _data_->_tmp26__length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp39_ = _data_->_tmp26_;
	_data_->_tmp39__length1 = _data_->_tmp26__length1;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26__length1 = 0;
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp40__length1 = _data_->_tmp39__length1;
	_data_->result_length1 = _data_->_tmp40__length1;
	_data_->result = _data_->_tmp40_;
	_data_->_tmp26_ = (_vala_array_free (_data_->_tmp26_, _data_->_tmp26__length1, (GDestroyNotify) g_free), NULL);
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_log_delete_events_data_free (gpointer _data)
{
	ZeitgeistLogDeleteEventsData* _data_;
	_data_ = _data;
	_g_array_unref0 (_data_->event_ids);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogDeleteEventsData, _data_);
}

void
zeitgeist_log_delete_events (ZeitgeistLog* self,
                             GArray* event_ids,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	ZeitgeistLogDeleteEventsData* _data_;
	ZeitgeistLog* _tmp0_;
	GArray* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event_ids != NULL);
	_data_ = g_slice_new0 (ZeitgeistLogDeleteEventsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_log_delete_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_array_ref0 (event_ids);
	_g_array_unref0 (_data_->event_ids);
	_data_->event_ids = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	zeitgeist_log_delete_events_co (_data_);
}

ZeitgeistTimeRange*
zeitgeist_log_delete_events_finish (ZeitgeistLog* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	ZeitgeistTimeRange* result;
	ZeitgeistLogDeleteEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
    * Delete a collection of events from the zeitgeist log given their event ids.
    *
    * The deletion will be done asynchronously, and this method returns immediately.
    *
    * @param event_ids Array<uint32>
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static void
zeitgeist_log_delete_events_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	ZeitgeistLogDeleteEventsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_delete_events_co (_data_);
}

static gboolean
zeitgeist_log_delete_events_co (ZeitgeistLogDeleteEventsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_new0 (guint32, _data_->event_ids->len);
	_data_->_ids = _data_->_tmp0_;
	_data_->_ids_length1 = _data_->event_ids->len;
	_data_->__ids_size_ = _data_->_ids_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				if (!(((guint) _data_->i) < _data_->event_ids->len)) {
					break;
				}
				_data_->_tmp3_ = _data_->_ids;
				_data_->_tmp3__length1 = _data_->_ids_length1;
				_data_->_tmp3_[_data_->i] = g_array_index (_data_->event_ids, guint32, (guint) _data_->i);
			}
		}
	}
	_data_->_state_ = 1;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_delete_events_ready, _data_);
	return FALSE;
	_state_1:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->_ids = (g_free (_data_->_ids), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->proxy;
	_data_->_tmp5_ = _data_->_ids;
	_data_->_tmp5__length1 = _data_->_ids_length1;
	_data_->_state_ = 2;
	zeitgeist_remote_log_delete_events (_data_->_tmp4_, _data_->_tmp5_, (gint) _data_->_tmp5__length1, _data_->cancellable, NULL, zeitgeist_log_delete_events_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp6_ = zeitgeist_remote_log_delete_events_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
	_data_->time_range = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->_ids = (g_free (_data_->_ids), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->time_range;
	_data_->_tmp9_ = zeitgeist_time_range_new_from_variant (_data_->_tmp8_, &_data_->_inner_error0_);
	_data_->_tmp7_ = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->time_range);
		_data_->_ids = (g_free (_data_->_ids), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->_tmp7_;
	_data_->_tmp7_ = NULL;
	_data_->result = _data_->_tmp10_;
	_g_object_unref0 (_data_->_tmp7_);
	_g_variant_unref0 (_data_->time_range);
	_data_->_ids = (g_free (_data_->_ids), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_log_quit_data_free (gpointer _data)
{
	ZeitgeistLogQuitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogQuitData, _data_);
}

void
zeitgeist_log_quit (ZeitgeistLog* self,
                    GCancellable* cancellable,
                    GAsyncReadyCallback _callback_,
                    gpointer _user_data_)
{
	ZeitgeistLogQuitData* _data_;
	ZeitgeistLog* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ZeitgeistLogQuitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_log_quit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	zeitgeist_log_quit_co (_data_);
}

void
zeitgeist_log_quit_finish (ZeitgeistLog* self,
                           GAsyncResult* _res_,
                           GError** error)
{
	ZeitgeistLogQuitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
    * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
    */
static void
zeitgeist_log_quit_ready (GObject* source_object,
                          GAsyncResult* _res_,
                          gpointer _user_data_)
{
	ZeitgeistLogQuitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_log_quit_co (_data_);
}

static gboolean
zeitgeist_log_quit_co (ZeitgeistLogQuitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_log_quit_ready, _data_);
	return FALSE;
	_state_1:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = _data_->self->priv->proxy;
	_data_->_state_ = 2;
	zeitgeist_remote_log_quit (_data_->_tmp0_, _data_->cancellable, zeitgeist_log_quit_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_remote_log_quit_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
    * Install a monitor in the Zeitgeist engine that calls back when events matching
    * event_templates are logged. The matching is done exactly as in the find_* family
    * of methods and in Event.matches_template. Furthermore matched events must also
    * have timestamps lying in time_range.
    *
    * To remove a monitor call remove_monitor() on the returned Monitor instance.
    *
    * @param monitor A {@link Monitor} to report back inserts and deletes
    */
void
zeitgeist_log_install_monitor (ZeitgeistLog* self,
                               ZeitgeistMonitor* monitor,
                               GError** error)
{
	GHashTable* _tmp0_;
	ZeitgeistMonitor* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	_tmp0_ = self->priv->monitors;
	_tmp1_ = _g_object_ref0 (monitor);
	g_hash_table_insert (_tmp0_, _tmp1_, (gpointer) ((guintptr) 0));
	_tmp2_ = zeitgeist_queued_proxy_wrapper_get_is_connected ((ZeitgeistQueuedProxyWrapper*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		zeitgeist_log_reinstall_monitor (self, monitor, NULL, NULL);
	}
}

static void
zeitgeist_log_reinstall_monitor_data_free (gpointer _data)
{
	ZeitgeistLogReinstallMonitorData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->monitor);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistLogReinstallMonitorData, _data_);
}

static void
zeitgeist_log_reinstall_monitor (ZeitgeistLog* self,
                                 ZeitgeistMonitor* monitor,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	ZeitgeistLogReinstallMonitorData* _data_;
	ZeitgeistLog* _tmp0_;
	ZeitgeistMonitor* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	_data_ = g_slice_new0 (ZeitgeistLogReinstallMonitorData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_log_reinstall_monitor_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (monitor);
	_g_object_unref0 (_data_->monitor);
	_data_->monitor = _tmp1_;
	zeitgeist_log_reinstall_monitor_co (_data_);
}

static void
zeitgeist_log_reinstall_monitor_finish (ZeitgeistLog* self,
                                        GAsyncResult* _res_)
{
	ZeitgeistLogReinstallMonitorData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
zeitgeist_log_reinstall_monitor_co (ZeitgeistLogReinstallMonitorData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = zeitgeist_queued_proxy_wrapper_get_is_connected ((ZeitgeistQueuedProxyWrapper*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_vala_return_val_if_fail (_data_->_tmp1_, "is_connected", FALSE);
	_data_->_tmp2_ = _data_->self->priv->monitors;
	_data_->_tmp3_ = g_hash_table_lookup (_data_->_tmp2_, _data_->monitor);
	if (((guint) ((guintptr) _data_->_tmp3_)) == ((guint) 0)) {
		_data_->_tmp4_ = _data_->self->priv->proxy;
		_data_->_tmp5_ = g_dbus_proxy_get_connection (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, g_dbus_proxy_get_type (), GDBusProxy));
		_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
		_data_->conn = _data_->_tmp6_;
		{
			_data_->_tmp7_ = _data_->conn;
			_data_->_tmp8_ = zeitgeist_monitor_get_path (_data_->monitor);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = zeitgeist_remote_monitor_register_object ((ZeitgeistRemoteMonitor*) _data_->monitor, _data_->_tmp7_, (const gchar*) _data_->_tmp9_, &_data_->_inner_error0_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_g_free0 (_data_->_tmp9_);
			_data_->registration_id = _data_->_tmp11_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				_g_object_unref0 (_data_->conn);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp12_ = _data_->self->priv->monitors;
			_data_->_tmp13_ = _g_object_ref0 (_data_->monitor);
			g_hash_table_replace (_data_->_tmp12_, _data_->_tmp13_, (gpointer) ((guintptr) _data_->registration_id));
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp14_ = _data_->err;
			_data_->_tmp15_ = _data_->_tmp14_->message;
			g_warning ("log.vala:561: Error installing monitor: %s", _data_->_tmp15_);
			_g_error_free0 (_data_->err);
			_g_object_unref0 (_data_->conn);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->conn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->conn);
	}
	_data_->_tmp16_ = _data_->self->priv->proxy;
	_data_->_tmp17_ = zeitgeist_monitor_get_path (_data_->monitor);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = zeitgeist_monitor_get_time_range (_data_->monitor);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = zeitgeist_time_range_to_variant (_data_->_tmp20_);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = zeitgeist_monitor_get_templates (_data_->monitor);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = zeitgeist_events_to_variant (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->_tmp25_;
	zeitgeist_remote_log_install_monitor (_data_->_tmp16_, _data_->_tmp18_, _data_->_tmp22_, _data_->_tmp26_, NULL, NULL, NULL);
	_g_variant_unref0 (_data_->_tmp26_);
	_g_ptr_array_unref0 (_data_->_tmp24_);
	_g_variant_unref0 (_data_->_tmp22_);
	_g_free0 (_data_->_tmp18_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
    * Remove a monitor from Zeitgeist engine that calls back when events matching event_templates are logged.
    *
    * @param monitor A {@link Monitor} to report back inserts and deletes
    */
static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		ZeitgeistLog* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->monitor);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda15_ (Block10Data* _data10_,
             GObject* obj,
             GAsyncResult* res)
{
	ZeitgeistLog* self;
	GError* _inner_error0_ = NULL;
	self = _data10_->self;
	g_return_if_fail (res != NULL);
	{
		zeitgeist_remote_log_remove_monitor_finish (G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_REMOTE_LOG, ZeitgeistRemoteLog), res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		char* _tmp0_;
		char* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = zeitgeist_monitor_get_path (_data10_->monitor);
		_tmp1_ = _tmp0_;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("Failed to remove monitor from Zeitgeist. Retracting" "%s from the bus nonetheless: %s", _tmp1_, _tmp3_);
		_g_free0 (_tmp1_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda15__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda15_ (self, source_object, res);
	block10_data_unref (self);
}

void
zeitgeist_log_remove_monitor (ZeitgeistLog* self,
                              ZeitgeistMonitor* monitor,
                              GError** error)
{
	Block10Data* _data10_;
	ZeitgeistRemoteLog* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	guint registration_id = 0U;
	GHashTable* _tmp3_;
	gconstpointer _tmp4_;
	GHashTable* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_g_object_unref0 (_data10_->monitor);
	_data10_->monitor = monitor;
	_tmp0_ = self->priv->proxy;
	_tmp1_ = zeitgeist_monitor_get_path (_data10_->monitor);
	_tmp2_ = _tmp1_;
	zeitgeist_remote_log_remove_monitor (_tmp0_, _tmp2_, NULL, ___lambda15__gasync_ready_callback, block10_data_ref (_data10_));
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->monitors;
	_tmp4_ = g_hash_table_lookup (_tmp3_, _data10_->monitor);
	registration_id = (guint) ((guintptr) _tmp4_);
	if (registration_id != ((guint) 0)) {
		GDBusConnection* connection = NULL;
		ZeitgeistRemoteLog* _tmp5_;
		GDBusConnection* _tmp6_;
		GDBusConnection* _tmp7_;
		GDBusConnection* _tmp8_;
		_tmp5_ = self->priv->proxy;
		_tmp6_ = g_dbus_proxy_get_connection (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_dbus_proxy_get_type (), GDBusProxy));
		_tmp7_ = _g_object_ref0 (_tmp6_);
		connection = _tmp7_;
		_tmp8_ = connection;
		g_dbus_connection_unregister_object (_tmp8_, registration_id);
		_g_object_unref0 (connection);
	}
	_tmp9_ = self->priv->monitors;
	g_hash_table_remove (_tmp9_, _data10_->monitor);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

/**
    * Gets version of currently running Zeitgeist daemon.
    *
    * This method will return the version of Zeitgeist daemon this instance is
    * connected to. If you call this method right after zeitgeist_log_new(),
    * only zeros will be returned, a valid version number will only be returned
    * once this instance successfully connected to the Zeitgeist daemon - ie.
    * the value of the "is-connected" property must be TRUE (you can connect
    * to the "notify::is-connected" signal otherwise).
    *
    * @param major Location for the major version
    * @param minor Location for the minor version
    * @param micro Location for the micro version
    */
void
zeitgeist_log_get_version (ZeitgeistLog* self,
                           gint* major,
                           gint* minor,
                           gint* micro)
{
	gint _vala_major = 0;
	gint _vala_minor = 0;
	gint _vala_micro = 0;
	GVariant* _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_micro = 0;
	_vala_minor = _vala_micro;
	_vala_major = _vala_minor;
	_tmp0_ = self->priv->engine_version;
	if (_tmp0_ != NULL) {
		GVariant* _tmp1_;
		_tmp1_ = self->priv->engine_version;
		g_variant_get (_tmp1_, "(iii)", &_vala_major, &_vala_minor, &_vala_micro, NULL);
	}
	if (major) {
		*major = _vala_major;
	}
	if (minor) {
		*minor = _vala_minor;
	}
	if (micro) {
		*micro = _vala_micro;
	}
}

/**
    * Gets extensions of the running Zeitgeist daemon.
    *
    * @return array of extenstions names strings
    */
gchar**
zeitgeist_log_get_extensions (ZeitgeistLog* self,
                              gint* result_length1)
{
	ZeitgeistRemoteLog* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->proxy;
	_tmp1_ = zeitgeist_remote_log_get_extensions (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

/**
    * Gets datapath of the running Zeitgeist daemon.
    *
    * @return string datapath
    */
gchar*
zeitgeist_log_datapath (ZeitgeistLog* self)
{
	ZeitgeistRemoteLog* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->proxy;
	_tmp1_ = zeitgeist_remote_log_get_datapath (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static inline gpointer
zeitgeist_log_db_worker_get_instance_private (ZeitgeistLogDbWorker* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistLogDbWorker_private_offset);
}

static ZeitgeistLogDbWorker*
zeitgeist_log_db_worker_construct (GType object_type,
                                   GThreadFunc func,
                                   gpointer func_target)
{
	ZeitgeistLogDbWorker* self = NULL;
	self = (ZeitgeistLogDbWorker*) g_type_create_instance (object_type);
	self->priv->func = func;
	self->priv->func_target = func_target;
	return self;
}

static ZeitgeistLogDbWorker*
zeitgeist_log_db_worker_new (GThreadFunc func,
                             gpointer func_target)
{
	return zeitgeist_log_db_worker_construct (ZEITGEIST_LOG_TYPE_DB_WORKER, func, func_target);
}

static void
zeitgeist_log_db_worker_run (ZeitgeistLogDbWorker* self)
{
	GThreadFunc _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->func;
	_tmp0__target = self->priv->func_target;
	_tmp0_ (_tmp0__target);
}

static void
zeitgeist_log_value_db_worker_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
zeitgeist_log_value_db_worker_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		zeitgeist_log_db_worker_unref (value->data[0].v_pointer);
	}
}

static void
zeitgeist_log_value_db_worker_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = zeitgeist_log_db_worker_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
zeitgeist_log_value_db_worker_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
zeitgeist_log_value_db_worker_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ZeitgeistLogDbWorker * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = zeitgeist_log_db_worker_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
zeitgeist_log_value_db_worker_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	ZeitgeistLogDbWorker ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = zeitgeist_log_db_worker_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
zeitgeist_log_param_spec_db_worker (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	ZeitgeistLogParamSpecDbWorker* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ZEITGEIST_LOG_TYPE_DB_WORKER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
zeitgeist_log_value_get_db_worker (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_LOG_TYPE_DB_WORKER), NULL);
	return value->data[0].v_pointer;
}

static void
zeitgeist_log_value_set_db_worker (GValue* value,
                                   gpointer v_object)
{
	ZeitgeistLogDbWorker * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_LOG_TYPE_DB_WORKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_LOG_TYPE_DB_WORKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		zeitgeist_log_db_worker_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_log_db_worker_unref (old);
	}
}

static void
zeitgeist_log_value_take_db_worker (GValue* value,
                                    gpointer v_object)
{
	ZeitgeistLogDbWorker * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_LOG_TYPE_DB_WORKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_LOG_TYPE_DB_WORKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_log_db_worker_unref (old);
	}
}

static void
zeitgeist_log_db_worker_class_init (ZeitgeistLogDbWorkerClass * klass,
                                    gpointer klass_data)
{
	zeitgeist_log_db_worker_parent_class = g_type_class_peek_parent (klass);
	((ZeitgeistLogDbWorkerClass *) klass)->finalize = zeitgeist_log_db_worker_finalize;
	g_type_class_adjust_private_offset (klass, &ZeitgeistLogDbWorker_private_offset);
}

static void
zeitgeist_log_db_worker_instance_init (ZeitgeistLogDbWorker * self,
                                       gpointer klass)
{
	self->priv = zeitgeist_log_db_worker_get_instance_private (self);
	self->ref_count = 1;
}

static void
zeitgeist_log_db_worker_finalize (ZeitgeistLogDbWorker * obj)
{
	ZeitgeistLogDbWorker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_LOG_TYPE_DB_WORKER, ZeitgeistLogDbWorker);
	g_signal_handlers_destroy (self);
}

static GType
zeitgeist_log_db_worker_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { zeitgeist_log_value_db_worker_init, zeitgeist_log_value_db_worker_free_value, zeitgeist_log_value_db_worker_copy_value, zeitgeist_log_value_db_worker_peek_pointer, "p", zeitgeist_log_value_db_worker_collect_value, "p", zeitgeist_log_value_db_worker_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistLogDbWorkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_log_db_worker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistLogDbWorker), 0, (GInstanceInitFunc) zeitgeist_log_db_worker_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType zeitgeist_log_db_worker_type_id;
	zeitgeist_log_db_worker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ZeitgeistLogDbWorker", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ZeitgeistLogDbWorker_private_offset = g_type_add_instance_private (zeitgeist_log_db_worker_type_id, sizeof (ZeitgeistLogDbWorkerPrivate));
	return zeitgeist_log_db_worker_type_id;
}

static GType
zeitgeist_log_db_worker_get_type (void)
{
	static volatile gsize zeitgeist_log_db_worker_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_log_db_worker_type_id__once)) {
		GType zeitgeist_log_db_worker_type_id;
		zeitgeist_log_db_worker_type_id = zeitgeist_log_db_worker_get_type_once ();
		g_once_init_leave (&zeitgeist_log_db_worker_type_id__once, zeitgeist_log_db_worker_type_id);
	}
	return zeitgeist_log_db_worker_type_id__once;
}

static gpointer
zeitgeist_log_db_worker_ref (gpointer instance)
{
	ZeitgeistLogDbWorker * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
zeitgeist_log_db_worker_unref (gpointer instance)
{
	ZeitgeistLogDbWorker * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ZEITGEIST_LOG_DB_WORKER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
zeitgeist_log_class_init (ZeitgeistLogClass * klass,
                          gpointer klass_data)
{
	zeitgeist_log_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistLog_private_offset);
	((ZeitgeistQueuedProxyWrapperClass *) klass)->on_connection_established = (void (*) (ZeitgeistQueuedProxyWrapper*)) zeitgeist_log_real_on_connection_established;
	((ZeitgeistQueuedProxyWrapperClass *) klass)->on_connection_lost = (void (*) (ZeitgeistQueuedProxyWrapper*)) zeitgeist_log_real_on_connection_lost;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_log_finalize;
}

static void
zeitgeist_log_instance_init (ZeitgeistLog * self,
                             gpointer klass)
{
	self->priv = zeitgeist_log_get_instance_private (self);
}

static void
zeitgeist_log_finalize (GObject * obj)
{
	ZeitgeistLog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_LOG, ZeitgeistLog);
	_g_object_unref0 (self->priv->proxy);
	_g_variant_unref0 (self->priv->engine_version);
	_g_hash_table_unref0 (self->priv->monitors);
	_g_object_unref0 (self->priv->dbreader);
	_g_thread_pool_free0 (self->priv->threads);
	G_OBJECT_CLASS (zeitgeist_log_parent_class)->finalize (obj);
}

/**
 * Primary access point for talking to the Zeitgeist daemon
 *
 * {@link Log} encapsulates the low level access to the Zeitgeist daemon.
 * You can use it to manage the log by inserting and deleting entries as well
 * as do queries on the logged data.
 *
 * It's important to realize that the #ZeitgeistLog class does not expose
 * any API that does synchronous communications with the message bus -
 * everything is asynchronous. To ease development some of the methods have
 * variants that are "fire and forget" ignoring the normal return value, so
 * that callbacks does not have to be set up.
 */
static GType
zeitgeist_log_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistLogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_log_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistLog), 0, (GInstanceInitFunc) zeitgeist_log_instance_init, NULL };
	GType zeitgeist_log_type_id;
	zeitgeist_log_type_id = g_type_register_static (ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER, "ZeitgeistLog", &g_define_type_info, 0);
	ZeitgeistLog_private_offset = g_type_add_instance_private (zeitgeist_log_type_id, sizeof (ZeitgeistLogPrivate));
	return zeitgeist_log_type_id;
}

GType
zeitgeist_log_get_type (void)
{
	static volatile gsize zeitgeist_log_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_log_type_id__once)) {
		GType zeitgeist_log_type_id;
		zeitgeist_log_type_id = zeitgeist_log_get_type_once ();
		g_once_init_leave (&zeitgeist_log_type_id__once, zeitgeist_log_type_id);
	}
	return zeitgeist_log_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

