/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseDataSource;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseTableEngine;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class ClickhouseTable
extends GenericTable
implements DBPObjectStatistics {
    private static final Log log = Log.getLog(ClickhouseTable.class);
    private Long tableSize;
    private long tableRows;
    private Date lastModifyTime;
    private String maxDate;
    private String minDate;
    private ClickhouseTableEngine engine;
    private String engineMessage;
    private String metadataPath;

    ClickhouseTable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
        if (dbResult != null) {
            this.tableSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"total_bytes");
            this.tableRows = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"total_rows");
            this.lastModifyTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"metadata_modification_time");
            String engineName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"engine");
            this.engine = this.searchEngine(engineName);
            this.engineMessage = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"engine_full");
            this.metadataPath = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"metadata_path");
        } else {
            this.setDefaultEngine();
        }
    }

    @Nullable
    private ClickhouseTableEngine searchEngine(String engineName) {
        if (CommonUtils.isNotEmpty((String)engineName)) {
            return this.getDataSource().getEngineByName(engineName);
        }
        return null;
    }

    private void setDefaultEngine() {
        List<ClickhouseTableEngine> tableEngines = this.getDataSource().getTableEngines();
        if (!CommonUtils.isEmpty(tableEngines)) {
            this.engine = tableEngines.stream().filter(e -> e.getName().equals("Log")).findFirst().orElse(tableEngines.get(0));
        }
    }

    public String getTableType() {
        return super.getTableType();
    }

    public boolean hasStatistics() {
        return this.tableSize != null;
    }

    @Property(category="Statistics", viewable=true, order=20, formatter=ByteNumberFormat.class)
    public long getStatObjectSize() {
        return this.tableSize == null ? 0L : this.tableSize;
    }

    @Property(category="Statistics", viewable=true, order=21)
    @Nullable
    public synchronized Long getRowCount(DBRProgressMonitor monitor) {
        return this.tableRows;
    }

    @Property(category="Statistics", order=22)
    public Date getLastModifyTime(DBRProgressMonitor monitor) {
        return this.lastModifyTime;
    }

    @Property(category="Statistics", order=23)
    public String getMinDate(DBRProgressMonitor monitor) {
        return this.minDate;
    }

    @Property(category="Statistics", order=24)
    public String getMaxDate(DBRProgressMonitor monitor) {
        return this.maxDate;
    }

    @Property(viewable=true, order=25, editable=true, listProvider=EngineListProvider.class)
    public ClickhouseTableEngine getEngine() {
        return this.engine;
    }

    public void setEngine(ClickhouseTableEngine engine) {
        this.engine = engine;
    }

    @Property(viewable=true, order=26, editable=true, length=PropertyLength.MULTILINE)
    public String getEngineMessage() {
        return this.engineMessage;
    }

    public void setEngineMessage(String engineMessage) {
        this.engineMessage = engineMessage;
    }

    @Property(category="Statistics", viewable=true, order=27)
    public String getMetadataPath() {
        return this.metadataPath;
    }

    @Property(viewable=true, editableExpr="object.dataSource.isServerVersionAtLeast(21, 6)", updatableExpr="object.dataSource.isServerVersionAtLeast(21, 6)", length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    private void readStatistics(DBRProgressMonitor monitor) {
        if (this.hasStatistics()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read relation statistics");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("select sum(bytes) as table_size, sum(rows) as table_rows, max(modification_time) as latest_modification,min(min_date) AS min_date,max(max_date) AS max_date FROM system.parts\nWHERE active AND database=? AND table=?\nGROUP BY table");){
                    dbStat.setString(1, ((GenericStructContainer)this.getContainer()).getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.fetchStatistics(dbResult);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading relation statistics", (Throwable)e);
        }
    }

    void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.tableSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"table_size");
        this.tableRows = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"table_rows");
        this.lastModifyTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"latest_modification");
        this.maxDate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"max_date");
        this.minDate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"min_date");
    }

    public String generateTableUpdateBegin(String tableName) {
        return "ALTER TABLE " + tableName + " UPDATE ";
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        DBSObject dbsObject = super.refreshObject(monitor);
        this.readStatistics(monitor);
        return dbsObject;
    }

    public String generateTableUpdateSet() {
        return "";
    }

    public String generateTableDeleteFrom(String tableName) {
        return "ALTER TABLE " + tableName + " DELETE ";
    }

    @NotNull
    public ClickhouseDataSource getDataSource() {
        return (ClickhouseDataSource)super.getDataSource();
    }

    public static class EngineListProvider
    implements IPropertyValueListProvider<ClickhouseTable> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(ClickhouseTable object) {
            return object.getDataSource().getTableEngines().toArray();
        }
    }
}

