/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.sql;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.TPTokenType;

public class OracleDialectRules
implements TPRuleProvider {
    @NotNull
    public TPRule[] extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.INITIAL || position == TPRuleProvider.RulePosition.PARTITION) {
            return new TPRule[]{new QStringRule()};
        }
        return new TPRule[0];
    }

    private static class QStringRule
    implements TPPredicateRule {
        private final TPToken stringToken = new TPTokenDefault((TPTokenType)SQLTokenType.T_STRING);
        private int quoteStartChar = -1;

        QStringRule() {
        }

        private TPToken doEvaluate(TPCharacterScanner scanner, boolean resume) {
            int c;
            int n = c = resume ? 113 : scanner.read();
            if (c == 81 || c == 113) {
                int n2 = c = resume ? 39 : scanner.read();
                if (c == 39) {
                    boolean quoteCharRead = false;
                    boolean quoteCharNeedsToBeUnread = false;
                    if (resume && this.quoteStartChar != -1) {
                        quoteCharRead = true;
                    }
                    if (!quoteCharRead) {
                        this.quoteStartChar = scanner.read();
                        quoteCharNeedsToBeUnread = true;
                    }
                    if (!Character.isLetterOrDigit(this.quoteStartChar)) {
                        char quoteEndChar = QStringRule.getQuoteEndChar((char)this.quoteStartChar);
                        if (this.tryReadQString(scanner, quoteEndChar)) {
                            return this.stringToken;
                        }
                        if (quoteCharNeedsToBeUnread) {
                            scanner.unread();
                        }
                    } else {
                        this.quoteStartChar = -1;
                        scanner.unread();
                    }
                }
                if (!resume) {
                    scanner.unread();
                }
            }
            if (!resume) {
                scanner.unread();
            }
            return TPTokenAbstract.UNDEFINED;
        }

        private boolean tryReadQString(TPCharacterScanner scanner, char quoteEndChar) {
            boolean isEndOfText;
            boolean isEndOfLiteral;
            int charsRead = 0;
            int n = -1;
            int n2 = -1;
            do {
                int n3;
                void var4_5 = n3;
                n3 = scanner.read();
                ++charsRead;
                isEndOfLiteral = var4_5 == quoteEndChar && n3 == 39;
                boolean bl = isEndOfText = n3 == -1;
            } while (!isEndOfLiteral && !isEndOfText);
            if (isEndOfText) {
                int i = 0;
                while (i < charsRead) {
                    scanner.unread();
                    ++i;
                }
            }
            return isEndOfLiteral;
        }

        private static char getQuoteEndChar(char startChar) {
            switch (startChar) {
                case '<': {
                    return '>';
                }
                case '(': {
                    return ')';
                }
                case '[': {
                    return ']';
                }
                case '{': {
                    return '}';
                }
            }
            return startChar;
        }

        public TPToken getSuccessToken() {
            return this.stringToken;
        }

        public TPToken evaluate(TPCharacterScanner scanner) {
            return this.doEvaluate(scanner, false);
        }

        public TPToken evaluate(TPCharacterScanner scanner, boolean resume) {
            return this.doEvaluate(scanner, resume);
        }
    }
}

