/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.dameng.model.DamengDataSource;
import org.jkiss.dbeaver.ext.dameng.model.DamengSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;

public class DamengExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<DBSCatalog, DamengSchema> {
    private String activeSchemaName;

    public DamengExecutionContext(JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    public DBSCatalog getDefaultCatalog() {
        return null;
    }

    public DamengSchema getDefaultSchema() {
        return this.activeSchemaName == null ? null : (DamengSchema)this.getDataSource().getSchemaCache().getCachedObject(this.activeSchemaName);
    }

    public boolean supportsCatalogChange() {
        return false;
    }

    public boolean supportsSchemaChange() {
        return true;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, DBSCatalog catalog, DamengSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, DamengSchema schema) throws DBCException {
        DamengSchema oldSelectedEntity = this.getDefaultSchema();
        if (schema == null || oldSelectedEntity == schema) {
            return;
        }
        this.setCurrentSchema(monitor, schema.getName());
        this.activeSchemaName = schema.getName();
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query active schema");){
            DBPConnectionBootstrap bootstrap;
            String bootstrapSchemaName;
            if (useBootstrapSettings && !CommonUtils.isEmpty((String)(bootstrapSchemaName = (bootstrap = this.getBootstrapSettings()).getDefaultSchemaName())) && !bootstrapSchemaName.equals(this.activeSchemaName)) {
                this.setCurrentSchema(monitor, bootstrap.getDefaultSchemaName());
            }
            this.activeSchemaName = JDBCUtils.queryString((Connection)session, (String)"SELECT SYS_CONTEXT( 'USERENV', 'CURRENT_SCHEMA' ) FROM DUAL", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
        return true;
    }

    @NotNull
    public DamengDataSource getDataSource() {
        return (DamengDataSource)super.getDataSource();
    }

    public DamengExecutionContext getContextDefaults() {
        return this;
    }

    private void setCurrentSchema(DBRProgressMonitor monitor, String activeSchemaName) throws DBCException {
        DamengSchema oldDefaultSchema = this.getDefaultSchema();
        try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
            JDBCUtils.executeSQL((Connection)session, (String)("SET SCHEMA " + DBUtils.getQuotedIdentifier((DBPDataSource)session.getDataSource(), (String)activeSchemaName)), (Object[])new Object[0]);
            this.activeSchemaName = activeSchemaName;
            DamengSchema newDefaultSchema = this.getDefaultSchema();
            DBUtils.fireObjectSelectionChange((DBSObject)oldDefaultSchema, (DBSObject)newDefaultSchema, (DBCExecutionContext)this);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
    }

    @NotNull
    public DBCCachedContextDefaults getCachedDefault() {
        return new DBCCachedContextDefaults(null, this.activeSchemaName);
    }
}

