/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.resource;

import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.core.resource.PathScanner;
import io.cucumber.core.resource.Resource;
import io.cucumber.core.resource.Resources;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ResourceScanner<R> {
    private static final Predicate<String> NULL_FILTER = x -> true;
    private final PathScanner pathScanner = new PathScanner();
    private final Supplier<ClassLoader> classLoaderSupplier;
    private final Predicate<Path> canLoad;
    private final Function<Resource, Optional<R>> loadResource;

    public ResourceScanner(Supplier<ClassLoader> classLoaderSupplier, Predicate<Path> canLoad, Function<Resource, Optional<R>> loadResource) {
        this.classLoaderSupplier = classLoaderSupplier;
        this.canLoad = canLoad;
        this.loadResource = loadResource;
    }

    public List<R> scanForResourcesInClasspathRoot(URI root, Predicate<String> packageFilter) {
        Objects.requireNonNull(root, "root must not be null");
        Objects.requireNonNull(packageFilter, "packageFilter must not be null");
        BiFunction<Path, Path, Resource> createResource = Resources.createClasspathRootResource();
        return this.findResourcesForUri(root, "", packageFilter, createResource);
    }

    private List<R> findResourcesForUri(URI baseUri, String basePackageName, Predicate<String> packageFilter, BiFunction<Path, Path, Resource> createResource) {
        ArrayList resources = new ArrayList();
        this.pathScanner.findResourcesForUri(baseUri, this.canLoad, this.processResource(basePackageName, packageFilter, createResource, resources::add));
        return resources;
    }

    private Function<Path, Consumer<Path>> processResource(String basePackageName, Predicate<String> packageFilter, BiFunction<Path, Path, Resource> createResource, Consumer<R> consumer) {
        return baseDir -> path -> {
            String packageName = ClasspathSupport.determinePackageName(baseDir, basePackageName, path);
            if (packageFilter.test(packageName)) {
                createResource.andThen(this.loadResource).apply((Path)baseDir, (Path)path).ifPresent(consumer);
            }
        };
    }

    public List<R> scanForResourcesInPackage(String packageName, Predicate<String> packageFilter) {
        ClasspathSupport.requireValidPackageName(packageName);
        Objects.requireNonNull(packageFilter, "packageFilter must not be null");
        BiFunction<Path, Path, Resource> createResource = Resources.createPackageResource(packageName);
        List<URI> rootUrisForPackage = ClasspathSupport.getUrisForPackage(this.getClassLoader(), packageName);
        return this.findResourcesForUris(rootUrisForPackage, packageName, packageFilter, createResource);
    }

    private ClassLoader getClassLoader() {
        return this.classLoaderSupplier.get();
    }

    private List<R> findResourcesForUris(List<URI> baseUris, String basePackageName, Predicate<String> packageFilter, BiFunction<Path, Path, Resource> createResource) {
        return baseUris.stream().map(baseUri -> this.findResourcesForUri((URI)baseUri, basePackageName, packageFilter, createResource)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public List<R> scanForClasspathResource(String resourceName, Predicate<String> packageFilter) {
        Objects.requireNonNull(resourceName, "resourceName must not be null");
        Objects.requireNonNull(packageFilter, "packageFilter must not be null");
        List<URI> urisForResource = ClasspathSupport.getUrisForResource(this.getClassLoader(), resourceName);
        BiFunction<Path, Path, Resource> createResource = Resources.createClasspathResource(resourceName);
        return this.findResourcesForUris(urisForResource, "", packageFilter, createResource);
    }

    public List<R> scanForResourcesPath(Path resourcePath) {
        Objects.requireNonNull(resourcePath, "resourcePath must not be null");
        ArrayList resources = new ArrayList();
        this.pathScanner.findResourcesForPath(resourcePath, this.canLoad, this.processResource("", NULL_FILTER, Resources.createUriResource(), resources::add));
        return resources;
    }

    public List<R> scanForResourcesUri(URI classpathResourceUri) {
        Objects.requireNonNull(classpathResourceUri, "classpathResourceUri must not be null");
        if ("classpath".equals(classpathResourceUri.getScheme())) {
            return this.scanForClasspathResource(ClasspathSupport.resourceName(classpathResourceUri), NULL_FILTER);
        }
        return this.findResourcesForUri(classpathResourceUri, "", NULL_FILTER, Resources.createUriResource());
    }
}

