/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.protocol.data;

import com.github.robtimus.net.protocol.data.Handler;
import com.github.robtimus.net.protocol.data.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class DataURLs {
    private static final Handler SHARED_HANDLER = new Handler();

    private DataURLs() {
    }

    public static URL create(String spec) throws MalformedURLException {
        return new URL(null, spec, SHARED_HANDLER);
    }

    public static Builder.FromText builder(String data) {
        Objects.requireNonNull(data);
        return new Builder.FromText(sb -> sb.append(data));
    }

    public static Builder.FromText builder(Reader data) {
        Objects.requireNonNull(data);
        return new Builder.FromText(sb -> DataURLs.copyData(data, sb));
    }

    public static Builder.FromBytes builder(byte[] data) {
        Objects.requireNonNull(data);
        return new Builder.FromBytes(() -> new ByteArrayInputStream(data));
    }

    public static Builder.FromBytes builder(InputStream data) {
        Objects.requireNonNull(data);
        return new Builder.FromBytes(() -> data);
    }

    private static void copyData(Reader data, StringBuilder dest) {
        char[] buffer = new char[4096];
        try {
            int len;
            while ((len = data.read(buffer)) != -1) {
                dest.append(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void copyData(InputStream data, OutputStream dest) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = data.read(buffer)) != -1) {
            dest.write(buffer, 0, len);
        }
    }

    static final class Base64Appender
    extends OutputStream {
        private final StringBuilder dest;
        private char[] buffer;

        Base64Appender(StringBuilder dest) {
            this.dest = dest;
        }

        @Override
        public void write(int b) throws IOException {
            char c = this.convert(b);
            this.dest.append(c);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int n;
            int offset = off;
            for (int remaining = len; remaining > 0; remaining -= n) {
                n = this.convertToBuffer(b, offset, remaining);
                this.dest.append(this.buffer, 0, n);
                offset += n;
            }
        }

        private char convert(int b) {
            return (char)b;
        }

        private int convertToBuffer(byte[] b, int off, int len) {
            if (this.buffer == null) {
                this.buffer = new char[1024];
            }
            int i = off;
            for (int j = 0; i < off + len && j < this.buffer.length; ++j, ++i) {
                this.buffer[j] = this.convert(b[i]);
            }
            return Math.min(this.buffer.length, len);
        }
    }

    public static abstract class Builder {
        private Builder() {
        }

        public WithMediaType withMediaType(String mediaType) {
            Objects.requireNonNull(mediaType);
            return new WithMediaType(this, MediaType.parse(mediaType));
        }

        public URL build() {
            return this.build(null);
        }

        abstract URL build(MediaType var1);

        final URL createURL(String file) {
            try {
                return new URL("data", null, -1, file, SHARED_HANDLER);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }

        public static final class WithMediaType {
            private final Builder parent;
            private final String mimeType;
            private final Map<String, String> parameters;

            private WithMediaType(Builder parent, MediaType mediaType) {
                this.parent = parent;
                this.mimeType = mediaType.getMimeType();
                this.parameters = new LinkedHashMap<String, String>(mediaType.getParameters());
            }

            public WithMediaType withMediaTypeParameter(String name, String value) {
                Objects.requireNonNull(name);
                if (value == null) {
                    this.parameters.remove(name);
                } else {
                    this.parameters.put(name, value);
                }
                return this;
            }

            public WithMediaType withCharset(Charset charset) {
                String value = charset.name();
                return this.withMediaTypeParameter("charset", value);
            }

            public URL build() {
                MediaType mediaType = MediaType.create(this.mimeType, this.parameters);
                return this.parent.build(mediaType);
            }
        }

        public static final class FromBytes
        extends Builder {
            private final Supplier<InputStream> dataSupplier;
            private boolean base64Data;

            private FromBytes(Supplier<InputStream> dataSupplier) {
                this.dataSupplier = dataSupplier;
                this.base64Data = true;
            }

            public Builder withBase64Data(boolean base64Data) {
                this.base64Data = base64Data;
                return this;
            }

            @Override
            URL build(MediaType mediaType) {
                StringBuilder file;
                block28: {
                    file = new StringBuilder();
                    if (mediaType != null) {
                        file.append(mediaType);
                    }
                    Charset charset = Handler.getCharset(mediaType);
                    if (this.base64Data) {
                        file.append(";base64");
                        file.append(',');
                        try (Base64Appender appender = new Base64Appender(file);
                             OutputStream dest = Base64.getEncoder().wrap(appender);){
                            InputStream data = this.dataSupplier.get();
                            DataURLs.copyData(data, dest);
                            break block28;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    file.append(',');
                    InputStreamReader data = new InputStreamReader(this.dataSupplier.get(), charset);
                    DataURLs.copyData(data, file);
                }
                return this.createURL(file.toString());
            }
        }

        public static final class FromText
        extends Builder {
            private final Consumer<StringBuilder> dataAppender;

            private FromText(Consumer<StringBuilder> dataAppender) {
                this.dataAppender = dataAppender;
            }

            @Override
            URL build(MediaType mediaType) {
                StringBuilder file = new StringBuilder();
                if (mediaType != null) {
                    file.append(mediaType);
                }
                file.append(',');
                this.dataAppender.accept(file);
                return this.createURL(file.toString());
            }
        }
    }
}

