/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.view.swing.map.Drawable;
import org.freeplane.view.swing.map.NodeView;

abstract class DrawableShape
implements Drawable {
    static final Color standardSelectedNodeColor = ResourceController.getResourceController().getColorProperty("standardselectednodecolor");
    static final String PREFER_BORDER_COLOR_FOR_STATE_SYMBOL_BACKGROUND = "preferBorderColorForStateSymbolBackground";

    DrawableShape() {
    }

    @Override
    public void draw(Graphics2D g, NodeView nodeView, Rectangle r) {
        Color color = g.getColor();
        Color edgeColor = this.getEdgeColor(nodeView);
        Shape shape = this.getShape(r);
        Color fillColor = this.getFillColor(nodeView);
        if (fillColor != null) {
            g.setColor(fillColor);
            g.fill(shape);
        }
        g.setColor(edgeColor);
        this.drawShape(g, shape, r, nodeView);
        g.setColor(color);
    }

    protected void drawShape(Graphics2D g, Shape shape, Rectangle r, NodeView nodeView) {
        g.draw(shape);
    }

    abstract Shape getShape(Rectangle var1);

    protected Color getEdgeColor(NodeView nodeView) {
        Color mapBackground;
        Color border = nodeView.getMainView().getBorderColor();
        return DrawableShape.isVisible(border, mapBackground = nodeView.getMap().getBackground()) || DrawableShape.isVisible(nodeView.getTextBackground(), mapBackground) ? border : nodeView.getEdgeColor();
    }

    private static boolean isVisible(Color color, Color backgroundColor) {
        return color.getAlpha() != 0 && !color.equals(backgroundColor);
    }

    protected Color getFillColor(NodeView nodeView) {
        Color nodeBackground;
        Color mapBackground = nodeView.getMap().getBackground();
        Color border = nodeView.getMainView().getBorderColor();
        Color edge = nodeView.getEdgeColor();
        if (ResourceController.getResourceController().getBooleanProperty(PREFER_BORDER_COLOR_FOR_STATE_SYMBOL_BACKGROUND)) {
            if (DrawableShape.isVisible(border, mapBackground)) {
                return border;
            }
            if (DrawableShape.isVisible(edge, mapBackground)) {
                return edge;
            }
        }
        if (DrawableShape.isVisible(nodeBackground = nodeView.getTextBackground(), mapBackground) || DrawableShape.isVisible(border, mapBackground) || DrawableShape.isVisible(edge, mapBackground)) {
            return nodeBackground;
        }
        return standardSelectedNodeColor;
    }
}

