/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import ghidra.graph.visualization.GroupVertex;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import java.util.HashSet;
import java.util.Set;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.sublayout.VisualGraphCollapser;

public class GhidraGraphCollapser
extends VisualGraphCollapser<AttributedVertex, AttributedEdge> {
    public GhidraGraphCollapser(VisualizationServer<AttributedVertex, AttributedEdge> vv) {
        super(vv);
    }

    public void ungroupSelectedVertices() {
        this.expand(this.vv.getSelectedVertices());
    }

    public AttributedVertex groupSelectedVertices() {
        MutableSelectedState selectedVState = this.vv.getSelectedVertexState();
        MutableSelectedState selectedEState = this.vv.getSelectedEdgeState();
        Set selected = selectedVState.getSelected();
        if (selected.size() > 1) {
            AttributedVertex groupVertex = (AttributedVertex)this.collapse(selected, s -> GroupVertex.groupVertices(selected));
            selectedVState.clear();
            selectedEState.clear();
            selectedVState.select((Object)groupVertex);
            return groupVertex;
        }
        return null;
    }

    public Set<AttributedVertex> convertToOutermostVertices(Set<AttributedVertex> vertices) {
        HashSet<AttributedVertex> set = new HashSet<AttributedVertex>();
        for (AttributedVertex v : vertices) {
            set.add(this.getOutermostVertex(v));
        }
        return set;
    }

    public AttributedVertex getOutermostVertex(AttributedVertex vertex) {
        AttributedVertex owner;
        while (!this.graph.containsVertex((Object)vertex) && (owner = (AttributedVertex)this.findOwnerOf(vertex)) != null) {
            vertex = owner;
        }
        return vertex;
    }
}

