/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.events;

import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import java.lang.ref.WeakReference;

public abstract class AbstractSelectionPluginEvent
extends PluginEvent {
    private final ProgramSelection selection;
    private final WeakReference<Program> programRef;

    public AbstractSelectionPluginEvent(String sourceName, String eventName, ProgramSelection selection, Program program) {
        super(sourceName, eventName);
        if (selection == null) {
            NullPointerException exc = new NullPointerException("Null ProgramSelection in creating Selection Plugin Event");
            Msg.showError((Object)((Object)this), null, (String)"Internal Error", (Object)"Null SelectionEvent being created.  Trace and remove this problem", (Throwable)exc);
        }
        this.selection = selection;
        this.programRef = new WeakReference<Program>(program);
    }

    public ProgramSelection getSelection() {
        return this.selection;
    }

    public Program getProgram() {
        return (Program)this.programRef.get();
    }

    protected String getDetails() {
        return String.valueOf(((Object)((Object)this)).getClass()) + " ==> " + String.valueOf(this.selection);
    }
}

