/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.complzss;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.complzss.CompLzssFileSystem;
import ghidra.file.formats.lzss.LzssCompressionHeader;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CompLzssFileSystemFactory
implements GFileSystemFactoryByteProvider<CompLzssFileSystem>,
GFileSystemProbeBytesOnly {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompLzssFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        try {
            CompLzssFileSystem fs;
            CompLzssFileSystem compLzssFileSystem = fs = new CompLzssFileSystem(targetFSRL, byteProvider, fsService, monitor);
            return compLzssFileSystem;
        }
        finally {
            byteProvider.close();
        }
    }

    public int getBytesRequired() {
        return 8;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return LzssCompressionHeader.probe(startBytes);
    }
}

