/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import javajs.util.BS;
import javajs.util.OC;
import javajs.util.T3;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.C;

public class PMeshWriter {
    private IsosurfaceMesh imesh;
    boolean isBinary;
    private OC oc;
    private int i0;
    private int[][] polygonIndexes;
    private boolean selectedPolyOnly;
    private BS bsPolygons;
    private boolean haveBsDisplay;
    private boolean colorSolid;
    private boolean colorArrayed;
    private short cx;
    private short[] vertexColixes;
    private boolean noColor;
    private short[] contourColixes;
    private float[] vertexValues;
    private int vertexCount;
    private int[] imap;

    Object write(IsosurfaceMesh isosurfaceMesh, boolean isBinary) {
        this.imesh = isosurfaceMesh;
        this.isBinary = isBinary;
        BS bsPoly = new BS();
        BS bsVert = new BS();
        BS bsPoints = new BS();
        if (this.imesh.showPoints || this.imesh.pc <= 0) {
            this.checkPoints(bsPoints);
        }
        bsVert.or(bsPoints);
        if (this.imesh.drawTriangles) {
            this.checkTriangles(false, bsPoly, bsVert);
        }
        if (this.imesh.pc > 0 && this.imesh.fillTriangles) {
            this.checkTriangles(true, bsPoly, bsVert);
        }
        this.imap = new int[this.vertexCount];
        int[] iimap = new int[this.vertexCount];
        int nV = 0;
        int i = bsVert.nextSetBit(0);
        while (i >= 0) {
            iimap[nV] = i;
            this.imap[i] = nV++;
            i = bsVert.nextSetBit(i + 1);
        }
        this.writePmeshHeader(nV);
        if (!isBinary) {
            this.outputInt(nV);
        }
        for (i = 0; i < nV; ++i) {
            this.outputXYZ(this.imesh.vs[iimap[i]]);
        }
        if (!isBinary) {
            this.outputInt(-1);
        }
        if (this.imesh.showPoints || this.imesh.pc <= 0) {
            this.outputPoints(bsPoints);
        }
        bsVert.or(bsPoints);
        BS bsDone = new BS();
        if (this.imesh.drawTriangles) {
            this.outputTriangles(false, bsPoly, bsDone);
        }
        if (this.imesh.pc > 0 && this.imesh.fillTriangles) {
            this.outputTriangles(true, bsPoly, bsDone);
        }
        if (isBinary) {
            this.oc.writeInt(0);
        } else {
            this.oc.append("0\n");
        }
        this.oc.closeChannel();
        return isBinary ? this.oc.toByteArray() : (byte[])this.oc.toString();
    }

    private void outputPoints(BS bsPoints) {
        int color = C.getArgb(this.cx);
        int i = bsPoints.nextSetBit(0);
        while (i >= 0) {
            if (!this.imesh.isColorSolid && this.imesh.vcs != null) {
                this.cx = this.imesh.vcs[i];
                color = C.getArgb(this.cx);
            }
            this.outputPoint(this.imap[i], color);
            i = bsPoints.nextSetBit(i + 1);
        }
    }

    private void outputTriangles(boolean fill, BS bsPoly, BS bsDone) {
        int color = C.getArgb(this.cx);
        int i = bsPoly.nextSetBit(0);
        while (i >= 0) {
            int check;
            int[] polygon = this.polygonIndexes[i];
            int iA = this.imap[polygon[0]];
            int iB = this.imap[polygon[1]];
            int iC = this.imap[polygon[2]];
            if (this.colorSolid) {
                if (this.colorArrayed && i < this.imesh.pcs.length) {
                    this.cx = this.imesh.pcs[i];
                }
            } else {
                this.cx = this.vertexColixes[polygon[0]];
            }
            color = C.getArgb(this.cx);
            if (fill) {
                if (iB == iC) {
                    if (iA == iB) {
                        this.outputPoint(iA, color);
                    } else {
                        this.outputEdge(iA, iB, color);
                    }
                    bsDone.set(i);
                } else {
                    if (this.imesh.colorsExplicit) {
                        color = polygon[4];
                    }
                    this.outputTriangle(iA, iB, iC, color, 999);
                }
            } else if (!bsDone.get(i) && (check = 7 & polygon[3]) != 0) {
                if (!this.noColor && this.colorArrayed) {
                    color = C.getArgb(this.imesh.fillTriangles ? (short)4 : this.contourColixes[polygon[4] % this.contourColixes.length]);
                }
                this.outputTriangle(iA, iB, iC, color, check);
            }
            i = bsPoly.nextSetBit(i + 1);
        }
    }

    private void checkPoints(BS bsVert) {
        int i;
        boolean slabPoints = this.imesh.pc == 0 && this.selectedPolyOnly;
        int incr = this.imesh.vertexIncrement;
        int n = i = !this.imesh.hasGridPoints || this.imesh.firstRealVertex < 0 ? 0 : this.imesh.firstRealVertex;
        while (i < this.vertexCount) {
            if (!(this.vertexValues != null && Float.isNaN(this.vertexValues[i]) || this.imesh.jvxlData.thisSet != null && !this.imesh.jvxlData.thisSet.get(this.imesh.vertexSets[i]) || !this.imesh.isColorSolid || this.haveBsDisplay && !this.imesh.bsDisplay.get(i) || slabPoints && !this.bsPolygons.get(i))) {
                bsVert.set(i);
            }
            i += incr;
        }
    }

    private void checkTriangles(boolean fill, BS bsPoly, BS bsVert) {
        this.setup(fill);
        int i = this.imesh.pc;
        while (--i >= 0) {
            int[] polygon = this.polygonIndexes[i];
            if (polygon == null || this.selectedPolyOnly && !this.bsPolygons.get(i)) continue;
            int iA = polygon[0];
            if (this.imesh.jvxlData.thisSet != null && this.imesh.vertexSets != null && !this.imesh.jvxlData.thisSet.get(this.imesh.vertexSets[iA])) continue;
            int iB = polygon[1];
            int iC = polygon[2];
            if (this.haveBsDisplay && (!this.imesh.bsDisplay.get(iA) || !this.imesh.bsDisplay.get(iB) || !this.imesh.bsDisplay.get(iC)) || this.colorSolid && this.colorArrayed && i < this.imesh.pcs.length && this.imesh.pcs[i] == 0) continue;
            bsPoly.set(i);
            bsVert.set(iA);
            bsVert.set(iB);
            bsVert.set(iC);
        }
    }

    private void setup(boolean fill) {
        this.vertexCount = this.imesh.vc;
        this.vertexValues = this.imesh.vvs;
        this.polygonIndexes = this.imesh.pis;
        this.cx = !fill && this.imesh.meshColix != 0 ? this.imesh.meshColix : this.imesh.colix;
        this.vertexColixes = (short[])(!fill && this.imesh.meshColix != 0 ? null : this.imesh.vcs);
        this.colorSolid = this.vertexColixes == null;
        this.noColor = this.vertexColixes == null || !fill && this.imesh.meshColix != 0;
        boolean bl = this.colorArrayed = this.colorSolid && this.imesh.pcs != null;
        if (this.colorArrayed && !fill && this.imesh.fillTriangles) {
            this.colorArrayed = false;
        }
        this.contourColixes = this.imesh.jvxlData.contourColixes;
        this.haveBsDisplay = this.imesh.bsDisplay != null;
        this.selectedPolyOnly = this.imesh.bsSlabDisplay != null;
        this.bsPolygons = this.selectedPolyOnly ? this.imesh.bsSlabDisplay : null;
    }

    private void writePmeshHeader(int nV) {
        this.oc = this.imesh.vwr.getOutputChannel(null, null);
        if (this.isBinary) {
            this.oc.writeByteAsInt(80);
            this.oc.writeByteAsInt(77);
            this.oc.writeByteAsInt(1);
            this.oc.writeByteAsInt(0);
            this.oc.writeInt(1);
            this.oc.writeInt(nV);
            this.oc.writeInt(-1);
            for (int i = 0; i < 16; ++i) {
                this.oc.writeInt(0);
            }
        } else {
            this.oc.append("#JmolPmesh\n");
        }
    }

    private void outputInt(int i) {
        if (this.isBinary) {
            this.oc.writeInt(i);
        } else {
            this.oc.append("" + i + "\n");
        }
    }

    private int outputPoint(int iA, int color) {
        this.outputInt(-1);
        this.outputInt(iA);
        this.outputInt(color);
        return 1;
    }

    private void outputXYZ(T3 pt) {
        if (this.isBinary) {
            this.oc.writeFloat(pt.x);
            this.oc.writeFloat(pt.y);
            this.oc.writeFloat(pt.z);
        } else {
            this.oc.append(pt.x + " " + pt.y + " " + pt.z + "\n");
        }
    }

    private void outputEdge(int iA, int iB, int color) {
        this.outputInt(-2);
        this.outputInt(iA);
        this.outputInt(iB);
        this.outputInt(color);
    }

    private void outputTriangle(int iA, int iB, int iC, int color, int check) {
        if (check == 999) {
            this.outputInt(-3);
            this.outputInt(iA);
            this.outputInt(iB);
            this.outputInt(iC);
            this.outputInt(color);
            return;
        }
        if ((check & 1) != 0) {
            this.outputEdge(iA, iB, color);
        }
        if ((check & 2) != 0) {
            this.outputEdge(iB, iC, color);
        }
        if ((check & 4) != 0) {
            this.outputEdge(iC, iA, color);
        }
    }
}

