/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Objects;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.image.node.ProducerIdsImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;

public final class ProducerIdsImage {
    public static final ProducerIdsImage EMPTY = new ProducerIdsImage(-1L);
    private final long nextProducerId;

    public ProducerIdsImage(long nextProducerId) {
        this.nextProducerId = nextProducerId;
    }

    public long nextProducerId() {
        return this.nextProducerId;
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        if (this.nextProducerId >= 0L) {
            writer.write(0, new ProducerIdsRecord().setBrokerId(-1).setBrokerEpoch(-1L).setNextProducerId(this.nextProducerId));
        }
    }

    public boolean isEmpty() {
        return this.nextProducerId == ProducerIdsImage.EMPTY.nextProducerId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProducerIdsImage)) {
            return false;
        }
        ProducerIdsImage other = (ProducerIdsImage)o;
        return this.nextProducerId == other.nextProducerId;
    }

    public int hashCode() {
        return Objects.hash(this.nextProducerId);
    }

    public String toString() {
        return new ProducerIdsImageNode(this).stringify();
    }
}

