/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import io.smallrye.common.resource.Resource;
import io.smallrye.common.resource.ResourceURLStreamHandler;
import io.smallrye.common.resource.ResourceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.attribute.FileTime;
import java.security.CodeSigner;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class JarFileResource
extends Resource {
    private final URL base;
    private final JarFile jarFile;
    private final JarEntry jarEntry;
    private URL url;

    JarFileResource(URL base, JarFile jarFile, JarEntry jarEntry) {
        super(jarEntry.getName());
        this.base = base;
        this.jarFile = jarFile;
        this.jarEntry = jarEntry;
    }

    @Override
    public URL url() {
        URL url = this.url;
        if (url == null) {
            try {
                url = this.url = new URL(null, new URI("jar", this.base.toURI().toASCIIString() + "!/" + this.pathName(), null).toASCIIString(), new ResourceURLStreamHandler(this));
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return url;
    }

    @Override
    public boolean isDirectory() {
        return this.jarEntry.isDirectory();
    }

    @Override
    public DirectoryStream<Resource> openDirectoryStream() throws IOException {
        if (!this.isDirectory()) {
            return super.openDirectoryStream();
        }
        return new DirectoryStream<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                String ourName = JarFileResource.this.pathName();
                return JarFileResource.this.jarFile.versionedStream().filter(e -> {
                    int si;
                    String name = ResourceUtils.canonicalizeRelativePath(e.getName());
                    if (ourName.isEmpty()) {
                        return name.indexOf(47) == -1;
                    }
                    return name.startsWith(ourName) && name.length() > ourName.length() && name.charAt(ourName.length()) == '/' && ((si = name.indexOf(47, ourName.length() + 1)) == -1 || si == name.length() - 1);
                }).map(e -> new JarFileResource(JarFileResource.this.base, JarFileResource.this.jarFile, (JarEntry)e)).map(r -> r).iterator();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public Instant modifiedTime() {
        FileTime fileTime = this.jarEntry.getLastModifiedTime();
        return fileTime == null ? null : fileTime.toInstant();
    }

    @Override
    public List<CodeSigner> codeSigners() {
        CodeSigner[] array = this.jarEntry.getCodeSigners();
        return array == null ? List.of() : List.of(array);
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.isDirectory() ? InputStream.nullInputStream() : this.jarFile.getInputStream(this.jarEntry);
    }

    @Override
    public long size() {
        return this.jarEntry.getSize();
    }
}

