/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.geo.GeoUtils;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.Point;
import org.opensearch.geometry.Rectangle;
import org.opensearch.geometry.ShapeType;
import org.opensearch.geometry.utils.GeographyValidator;
import org.opensearch.geometry.utils.Geohash;
import org.opensearch.geometry.utils.GeometryValidator;
import org.opensearch.geometry.utils.WellKnownText;
import org.opensearch.index.mapper.AbstractPointGeometryFieldMapper;

public class GeoPoint
implements ToXContentFragment {
    protected double lat;
    protected double lon;

    public GeoPoint() {
    }

    public GeoPoint(String value) {
        this.resetFromString(value);
    }

    public GeoPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public GeoPoint(GeoPoint template) {
        this(template.getLat(), template.getLon());
    }

    public GeoPoint(StreamInput in) throws IOException {
        this.lat = in.readDouble();
        this.lon = in.readDouble();
    }

    public GeoPoint reset(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoPoint resetLat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoPoint resetLon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoPoint resetFromString(String value) {
        return this.resetFromString(value, false, GeoUtils.EffectivePoint.BOTTOM_LEFT);
    }

    public GeoPoint resetFromString(String value, boolean ignoreZValue, GeoUtils.EffectivePoint effectivePoint) {
        if (value.toLowerCase(Locale.ROOT).contains("point")) {
            return this.resetFromWKT(value, ignoreZValue);
        }
        if (value.contains(",")) {
            return this.resetFromCoordinates(value, ignoreZValue);
        }
        return this.parseGeoHash(value, effectivePoint);
    }

    public GeoPoint resetFromCoordinates(String value, boolean ignoreZValue) {
        double lon;
        double lat;
        String[] vals = value.split(",");
        if (vals.length > 3) {
            throw new OpenSearchParseException("failed to parse [{}], expected 2 or 3 coordinates but found: [{}]", new Object[]{value, vals.length});
        }
        try {
            lat = Double.parseDouble(vals[0].trim());
        }
        catch (NumberFormatException ex) {
            throw new OpenSearchParseException("latitude must be a number", new Object[0]);
        }
        try {
            lon = Double.parseDouble(vals[1].trim());
        }
        catch (NumberFormatException ex) {
            throw new OpenSearchParseException("longitude must be a number", new Object[0]);
        }
        if (vals.length > 2) {
            GeoPoint.assertZValue(ignoreZValue, Double.parseDouble(vals[2].trim()));
        }
        return this.reset(lat, lon);
    }

    private GeoPoint resetFromWKT(String value, boolean ignoreZValue) {
        Geometry geometry;
        try {
            geometry = new WellKnownText(false, (GeometryValidator)new GeographyValidator(ignoreZValue)).fromWKT(value);
        }
        catch (Exception e) {
            throw new OpenSearchParseException("Invalid WKT format", (Throwable)e, new Object[0]);
        }
        if (geometry.type() != ShapeType.POINT) {
            throw new OpenSearchParseException("[geo_point] supports only POINT among WKT primitives, but found " + String.valueOf(geometry.type()), new Object[0]);
        }
        Point point = (Point)geometry;
        return this.reset(point.getY(), point.getX());
    }

    GeoPoint parseGeoHash(String geohash, GeoUtils.EffectivePoint effectivePoint) {
        if (effectivePoint == GeoUtils.EffectivePoint.BOTTOM_LEFT) {
            return this.resetFromGeoHash(geohash);
        }
        Rectangle rectangle = Geohash.toBoundingBox((String)geohash);
        switch (effectivePoint) {
            case TOP_LEFT: {
                return this.reset(rectangle.getMaxY(), rectangle.getMinX());
            }
            case TOP_RIGHT: {
                return this.reset(rectangle.getMaxY(), rectangle.getMaxX());
            }
            case BOTTOM_RIGHT: {
                return this.reset(rectangle.getMinY(), rectangle.getMaxX());
            }
        }
        throw new IllegalArgumentException("Unsupported effective point " + String.valueOf((Object)effectivePoint));
    }

    public GeoPoint resetFromIndexHash(long hash) {
        this.lon = Geohash.decodeLongitude((long)hash);
        this.lat = Geohash.decodeLatitude((long)hash);
        return this;
    }

    public GeoPoint resetFromIndexableField(IndexableField field) {
        if (field instanceof LatLonPoint) {
            BytesRef br = field.binaryValue();
            byte[] bytes = Arrays.copyOfRange(br.bytes, br.offset, br.length);
            return this.reset(GeoEncodingUtils.decodeLatitude((byte[])bytes, (int)0), GeoEncodingUtils.decodeLongitude((byte[])bytes, (int)4));
        }
        if (field instanceof LatLonDocValuesField) {
            long encoded = (Long)field.numericValue();
            return this.reset(GeoEncodingUtils.decodeLatitude((int)((int)(encoded >>> 32))), GeoEncodingUtils.decodeLongitude((int)((int)encoded)));
        }
        return this.resetFromIndexHash(Long.parseLong(field.stringValue()));
    }

    public GeoPoint resetFromGeoHash(String geohash) {
        long hash;
        try {
            hash = Geohash.mortonEncode((String)geohash);
        }
        catch (IllegalArgumentException ex) {
            throw new OpenSearchParseException(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        return this.reset(Geohash.decodeLatitude((long)hash), Geohash.decodeLongitude((long)hash));
    }

    public GeoPoint resetFromGeoHash(long geohashLong) {
        int level = (int)(12L - (geohashLong & 0xFL));
        return this.resetFromIndexHash(BitUtil.flipFlop((long)(geohashLong >>> 4 << level * 5 + 2)));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.lat);
        out.writeDouble(this.lon);
    }

    public double lat() {
        return this.lat;
    }

    public double getLat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public double getLon() {
        return this.lon;
    }

    public String geohash() {
        return Geohash.stringEncode((double)this.lon, (double)this.lat);
    }

    public String getGeohash() {
        return Geohash.stringEncode((double)this.lon, (double)this.lat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)o;
        if (Double.compare(geoPoint.lat, this.lat) != 0) {
            return false;
        }
        return Double.compare(geoPoint.lon, this.lon) == 0;
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = Long.hashCode(temp);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + Long.hashCode(temp);
        return result;
    }

    public String toString() {
        return this.lat + ", " + this.lon;
    }

    public static GeoPoint fromGeohash(String geohash) {
        return new GeoPoint().resetFromGeoHash(geohash);
    }

    public static GeoPoint fromGeohash(long geohashLong) {
        return new GeoPoint().resetFromGeoHash(geohashLong);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.latlon(this.lat, this.lon);
    }

    public static double assertZValue(boolean ignoreZValue, double zValue) {
        if (!ignoreZValue) {
            throw new OpenSearchParseException("Exception parsing coordinates: found Z value [{}] but [{}] parameter is [{}]", new Object[]{zValue, AbstractPointGeometryFieldMapper.Names.IGNORE_Z_VALUE, ignoreZValue});
        }
        return zValue;
    }
}

