/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SamplerAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, SamplerAggregation> {
    @Nullable
    private final Integer shardSize;
    public static final JsonpDeserializer<SamplerAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SamplerAggregation::setupSamplerAggregationDeserializer);

    private SamplerAggregation(Builder builder) {
        super(builder);
        this.shardSize = builder.shardSize;
    }

    public static SamplerAggregation of(Function<Builder, ObjectBuilder<SamplerAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Sampler;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSamplerAggregationDeserializer(ObjectDeserializer<Builder> op) {
        SamplerAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.shardSize);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamplerAggregation other = (SamplerAggregation)o;
        return Objects.equals(this.shardSize, other.shardSize);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SamplerAggregation> {
        @Nullable
        private Integer shardSize;

        public Builder() {
        }

        private Builder(SamplerAggregation o) {
            super(o);
            this.shardSize = o.shardSize;
        }

        private Builder(Builder o) {
            super(o);
            this.shardSize = o.shardSize;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        @Override
        @Nonnull
        public SamplerAggregation build() {
            this._checkSingleUse();
            return new SamplerAggregation(this);
        }
    }
}

