/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.http.HttpHeaders;
import com.azure.storage.blob.implementation.accesshelpers.BlobQueryHeadersConstructorProxy;
import com.azure.storage.blob.implementation.models.BlobsQueryHeaders;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import java.time.OffsetDateTime;
import java.util.Map;

public final class BlobQueryHeaders {
    private final BlobsQueryHeaders internalHeaders;
    private String errorCode;

    private BlobQueryHeaders(BlobsQueryHeaders internalHeaders) {
        this.internalHeaders = internalHeaders;
    }

    public BlobQueryHeaders() {
        this.internalHeaders = new BlobsQueryHeaders(new HttpHeaders());
    }

    public OffsetDateTime getLastModified() {
        return this.internalHeaders.getLastModified();
    }

    public BlobQueryHeaders setLastModified(OffsetDateTime lastModified) {
        this.internalHeaders.setLastModified(lastModified);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.internalHeaders.getXMsMeta();
    }

    public BlobQueryHeaders setMetadata(Map<String, String> metadata) {
        this.internalHeaders.setXMsMeta(metadata);
        return this;
    }

    public Long getContentLength() {
        return this.internalHeaders.getContentLength();
    }

    public BlobQueryHeaders setContentLength(Long contentLength) {
        this.internalHeaders.setContentLength(contentLength);
        return this;
    }

    public String getContentType() {
        return this.internalHeaders.getContentType();
    }

    public BlobQueryHeaders setContentType(String contentType) {
        this.internalHeaders.setContentType(contentType);
        return this;
    }

    public String getContentRange() {
        return this.internalHeaders.getContentRange();
    }

    public BlobQueryHeaders setContentRange(String contentRange) {
        this.internalHeaders.setContentRange(contentRange);
        return this;
    }

    public String getETag() {
        return this.internalHeaders.getETag();
    }

    public BlobQueryHeaders setETag(String eTag) {
        this.internalHeaders.setETag(eTag);
        return this;
    }

    public byte[] getContentMd5() {
        return this.internalHeaders.getContentMD5();
    }

    public BlobQueryHeaders setContentMd5(byte[] contentMd5) {
        this.internalHeaders.setContentMD5(contentMd5);
        return this;
    }

    public String getContentEncoding() {
        return this.internalHeaders.getContentEncoding();
    }

    public BlobQueryHeaders setContentEncoding(String contentEncoding) {
        this.internalHeaders.setContentEncoding(contentEncoding);
        return this;
    }

    public String getCacheControl() {
        return this.internalHeaders.getCacheControl();
    }

    public BlobQueryHeaders setCacheControl(String cacheControl) {
        this.internalHeaders.setCacheControl(cacheControl);
        return this;
    }

    public String getContentDisposition() {
        return this.internalHeaders.getContentDisposition();
    }

    public BlobQueryHeaders setContentDisposition(String contentDisposition) {
        this.internalHeaders.setContentDisposition(contentDisposition);
        return this;
    }

    public String getContentLanguage() {
        return this.internalHeaders.getContentLanguage();
    }

    public BlobQueryHeaders setContentLanguage(String contentLanguage) {
        this.internalHeaders.setContentLanguage(contentLanguage);
        return this;
    }

    public Long getBlobSequenceNumber() {
        return this.internalHeaders.getXMsBlobSequenceNumber();
    }

    public BlobQueryHeaders setBlobSequenceNumber(Long blobSequenceNumber) {
        this.internalHeaders.setXMsBlobSequenceNumber(blobSequenceNumber);
        return this;
    }

    public BlobType getBlobType() {
        return this.internalHeaders.getXMsBlobType();
    }

    public BlobQueryHeaders setBlobType(BlobType blobType) {
        this.internalHeaders.setXMsBlobType(blobType);
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        return this.internalHeaders.getXMsCopyCompletionTime();
    }

    public BlobQueryHeaders setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.internalHeaders.setXMsCopyCompletionTime(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.internalHeaders.getXMsCopyStatusDescription();
    }

    public BlobQueryHeaders setCopyStatusDescription(String copyStatusDescription) {
        this.internalHeaders.setXMsCopyStatusDescription(copyStatusDescription);
        return this;
    }

    public String getCopyId() {
        return this.internalHeaders.getXMsCopyId();
    }

    public BlobQueryHeaders setCopyId(String copyId) {
        this.internalHeaders.setXMsCopyId(copyId);
        return this;
    }

    public String getCopyProgress() {
        return this.internalHeaders.getXMsCopyProgress();
    }

    public BlobQueryHeaders setCopyProgress(String copyProgress) {
        this.internalHeaders.setXMsCopyProgress(copyProgress);
        return this;
    }

    public String getCopySource() {
        return this.internalHeaders.getXMsCopySource();
    }

    public BlobQueryHeaders setCopySource(String copySource) {
        this.internalHeaders.setXMsCopySource(copySource);
        return this;
    }

    public CopyStatusType getCopyStatus() {
        return this.internalHeaders.getXMsCopyStatus();
    }

    public BlobQueryHeaders setCopyStatus(CopyStatusType copyStatus) {
        this.internalHeaders.setXMsCopyStatus(copyStatus);
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.internalHeaders.getXMsLeaseDuration();
    }

    public BlobQueryHeaders setLeaseDuration(LeaseDurationType leaseDuration) {
        this.internalHeaders.setXMsLeaseDuration(leaseDuration);
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.internalHeaders.getXMsLeaseState();
    }

    public BlobQueryHeaders setLeaseState(LeaseStateType leaseState) {
        this.internalHeaders.setXMsLeaseState(leaseState);
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.internalHeaders.getXMsLeaseStatus();
    }

    public BlobQueryHeaders setLeaseStatus(LeaseStatusType leaseStatus) {
        this.internalHeaders.setXMsLeaseStatus(leaseStatus);
        return this;
    }

    public String getClientRequestId() {
        return this.internalHeaders.getXMsClientRequestId();
    }

    public BlobQueryHeaders setClientRequestId(String clientRequestId) {
        this.internalHeaders.setXMsClientRequestId(clientRequestId);
        return this;
    }

    public String getRequestId() {
        return this.internalHeaders.getXMsRequestId();
    }

    public BlobQueryHeaders setRequestId(String requestId) {
        this.internalHeaders.setXMsRequestId(requestId);
        return this;
    }

    public String getVersion() {
        return this.internalHeaders.getXMsVersion();
    }

    public BlobQueryHeaders setVersion(String version) {
        this.internalHeaders.setXMsVersion(version);
        return this;
    }

    public String getAcceptRanges() {
        return this.internalHeaders.getAcceptRanges();
    }

    public BlobQueryHeaders setAcceptRanges(String acceptRanges) {
        this.internalHeaders.setAcceptRanges(acceptRanges);
        return this;
    }

    public OffsetDateTime getDateProperty() {
        return this.internalHeaders.getDate();
    }

    public BlobQueryHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.internalHeaders.setDate(dateProperty);
        return this;
    }

    public Integer getBlobCommittedBlockCount() {
        return this.internalHeaders.getXMsBlobCommittedBlockCount();
    }

    public BlobQueryHeaders setBlobCommittedBlockCount(Integer blobCommittedBlockCount) {
        this.internalHeaders.setXMsBlobCommittedBlockCount(blobCommittedBlockCount);
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.internalHeaders.isXMsServerEncrypted();
    }

    public BlobQueryHeaders setServerEncrypted(Boolean serverEncrypted) {
        this.internalHeaders.setXMsServerEncrypted(serverEncrypted);
        return this;
    }

    public String getEncryptionKeySha256() {
        return this.internalHeaders.getXMsEncryptionKeySha256();
    }

    public BlobQueryHeaders setEncryptionKeySha256(String encryptionKeySha256) {
        this.internalHeaders.setXMsEncryptionKeySha256(encryptionKeySha256);
        return this;
    }

    public String getEncryptionScope() {
        return this.internalHeaders.getXMsEncryptionScope();
    }

    public BlobQueryHeaders setEncryptionScope(String encryptionScope) {
        this.internalHeaders.setXMsEncryptionScope(encryptionScope);
        return this;
    }

    public byte[] getBlobContentMd5() {
        return this.internalHeaders.getXMsBlobContentMd5();
    }

    public BlobQueryHeaders setBlobContentMd5(byte[] blobContentMd5) {
        this.internalHeaders.setXMsBlobContentMd5(blobContentMd5);
        return this;
    }

    public byte[] getContentCrc64() {
        return this.internalHeaders.getXMsContentCrc64();
    }

    public BlobQueryHeaders setContentCrc64(byte[] contentCrc64) {
        this.internalHeaders.setXMsContentCrc64(contentCrc64);
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public BlobQueryHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    static {
        BlobQueryHeadersConstructorProxy.setAccessor(BlobQueryHeaders::new);
    }
}

