/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.CollectionUDF;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class MVZipFunctionImpl
extends ImplementorUDF {
    public MVZipFunctionImpl() {
        super(new MVZipImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return sqlOperatorBinding -> {
            RelDataTypeFactory typeFactory = sqlOperatorBinding.getTypeFactory();
            RelDataType elementType = typeFactory.createSqlType(SqlTypeName.VARCHAR);
            return SqlTypeUtil.createArrayType((RelDataTypeFactory)typeFactory, (RelDataType)typeFactory.createTypeWithNullability(elementType, true), (boolean)true);
        };
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY}).or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY, SqlTypeFamily.CHARACTER})));
    }

    public static List<Object> mvzip(List<?> left, List<?> right, String delimiter) {
        if (left == null || right == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int minLength = Math.min(left.size(), right.size());
        for (int i = 0; i < minLength; ++i) {
            String combined = Objects.toString(left.get(i), "") + delimiter + Objects.toString(right.get(i), "");
            result.add(combined);
        }
        return result;
    }

    public static class MVZipImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            if (translatedOperands.size() == 2) {
                return Expressions.call((Method)Types.lookupMethod(MVZipFunctionImpl.class, (String)"mvzip", (Class[])new Class[]{List.class, List.class, String.class}), (Expression[])new Expression[]{translatedOperands.get(0), translatedOperands.get(1), Expressions.constant((Object)",")});
            }
            if (translatedOperands.size() == 3) {
                return Expressions.call((Method)Types.lookupMethod(MVZipFunctionImpl.class, (String)"mvzip", (Class[])new Class[]{List.class, List.class, String.class}), (Expression[])new Expression[]{translatedOperands.get(0), translatedOperands.get(1), translatedOperands.get(2)});
            }
            throw new IllegalArgumentException("mvzip expects 2 or 3 arguments, got " + translatedOperands.size());
        }
    }
}

