from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

LITHUANIAN_LANG_MODEL = {
    31: {  # 'A'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.LIKELY,  # 'B'
        51: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.LIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        39: SequenceLikelihood.LIKELY,  # 'L'
        37: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.POSITIVE,  # 'S'
        35: SequenceLikelihood.LIKELY,  # 'T'
        52: SequenceLikelihood.LIKELY,  # 'U'
        36: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        25: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.LIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.LIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    44: {  # 'B'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.LIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    51: {  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    41: {  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.LIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.LIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.LIKELY,  # 'ž'
    },
    47: {  # 'E'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.LIKELY,  # 'B'
        51: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        39: SequenceLikelihood.LIKELY,  # 'L'
        37: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.LIKELY,  # 'T'
        52: SequenceLikelihood.LIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        4: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    53: {  # 'F'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    48: {  # 'G'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.LIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.LIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    57: {  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    42: {  # 'I'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.LIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        39: SequenceLikelihood.LIKELY,  # 'L'
        37: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.LIKELY,  # 'T'
        52: SequenceLikelihood.LIKELY,  # 'U'
        36: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        4: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.POSITIVE,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.LIKELY,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    45: {  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.POSITIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.LIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    34: {  # 'K'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.LIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.LIKELY,  # 'T'
        52: SequenceLikelihood.LIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.LIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.LIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    39: {  # 'L'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.LIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.LIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.LIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    37: {  # 'M'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.LIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.LIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    43: {  # 'N'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.LIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.LIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.LIKELY,  # 'Ė'
        19: SequenceLikelihood.LIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    49: {  # 'O'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.LIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        39: SequenceLikelihood.LIKELY,  # 'L'
        37: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.LIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    30: {  # 'P'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    67: {  # 'Q'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    46: {  # 'R'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.LIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.LIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.LIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    32: {  # 'S'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.LIKELY,  # 'B'
        51: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.LIKELY,  # 'T'
        52: SequenceLikelihood.LIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.LIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.LIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    35: {  # 'T'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.LIKELY,  # 'U'
        36: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.LIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    52: {  # 'U'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.LIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.LIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.LIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.LIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    36: {  # 'V'
        31: SequenceLikelihood.LIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.LIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.LIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.LIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    60: {  # 'W'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.NEGATIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    61: {  # 'X'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.LIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    59: {  # 'Y'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    62: {  # 'Z'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    2: {  # 'a'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        25: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.POSITIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.LIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.POSITIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    20: {  # 'b'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.POSITIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.POSITIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    25: {  # 'c'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        4: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.LIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    14: {  # 'd'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.LIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.LIKELY,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.LIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.LIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    5: {  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        25: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.POSITIVE,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.POSITIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.LIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.POSITIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    33: {  # 'f'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    16: {  # 'g'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.LIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.LIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.LIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.LIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.POSITIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.LIKELY,  # 'ž'
    },
    40: {  # 'h'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    1: {  # 'i'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        25: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.POSITIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.LIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.POSITIVE,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.POSITIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    17: {  # 'j'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.LIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.POSITIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.POSITIVE,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.POSITIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    10: {  # 'k'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.POSITIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.POSITIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.POSITIVE,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.POSITIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    12: {  # 'l'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        25: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.LIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.POSITIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.POSITIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.LIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.POSITIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.LIKELY,  # 'ž'
    },
    11: {  # 'm'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.LIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.LIKELY,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.LIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.POSITIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    8: {  # 'n'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        25: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.LIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.POSITIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.POSITIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.LIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.LIKELY,  # 'ž'
    },
    6: {  # 'o'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        25: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.POSITIVE,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.POSITIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.POSITIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    13: {  # 'p'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.LIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.LIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.LIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.LIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.POSITIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.LIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.LIKELY,  # 'ž'
    },
    65: {  # 'q'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    7: {  # 'r'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        25: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.LIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.POSITIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.POSITIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.POSITIVE,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.POSITIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    3: {  # 's'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        25: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.LIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.POSITIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.LIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    4: {  # 't'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        25: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.POSITIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.POSITIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.LIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.POSITIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.LIKELY,  # 'ž'
    },
    9: {  # 'u'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        25: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.LIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.POSITIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.POSITIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    15: {  # 'v'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.LIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.POSITIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.POSITIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.LIKELY,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.LIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.POSITIVE,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    54: {  # 'w'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    56: {  # 'x'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    18: {  # 'y'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        25: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.POSITIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.POSITIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.LIKELY,  # 'ž'
    },
    29: {  # 'z'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.UNLIKELY,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.LIKELY,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.LIKELY,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    69: {  # 'Ą'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.NEGATIVE,  # 'E'
        53: SequenceLikelihood.NEGATIVE,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.NEGATIVE,  # 'H'
        42: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.NEGATIVE,  # 'T'
        52: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        25: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        33: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.NEGATIVE,  # 'g'
        40: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.NEGATIVE,  # 'i'
        17: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.NEGATIVE,  # 'l'
        11: SequenceLikelihood.NEGATIVE,  # 'm'
        8: SequenceLikelihood.NEGATIVE,  # 'n'
        6: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        15: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        29: SequenceLikelihood.NEGATIVE,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    24: {  # 'ą'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.LIKELY,  # 'ž'
    },
    63: {  # 'Č'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        57: SequenceLikelihood.NEGATIVE,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.NEGATIVE,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.NEGATIVE,  # 'R'
        32: SequenceLikelihood.NEGATIVE,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.NEGATIVE,  # 'g'
        40: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.NEGATIVE,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        3: SequenceLikelihood.NEGATIVE,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.NEGATIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    28: {  # 'č'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.NEGATIVE,  # 'B'
        51: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.NEGATIVE,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.NEGATIVE,  # 'F'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        57: SequenceLikelihood.NEGATIVE,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        34: SequenceLikelihood.NEGATIVE,  # 'K'
        39: SequenceLikelihood.NEGATIVE,  # 'L'
        37: SequenceLikelihood.NEGATIVE,  # 'M'
        43: SequenceLikelihood.NEGATIVE,  # 'N'
        49: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.NEGATIVE,  # 'R'
        32: SequenceLikelihood.NEGATIVE,  # 'S'
        35: SequenceLikelihood.NEGATIVE,  # 'T'
        52: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    64: {  # 'Ė'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.NEGATIVE,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.NEGATIVE,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.LIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        33: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.NEGATIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.NEGATIVE,  # 'n'
        6: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        29: SequenceLikelihood.NEGATIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    19: {  # 'ė'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.LIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    70: {  # 'Ę'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.NEGATIVE,  # 'E'
        53: SequenceLikelihood.NEGATIVE,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.NEGATIVE,  # 'H'
        42: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        34: SequenceLikelihood.NEGATIVE,  # 'K'
        39: SequenceLikelihood.NEGATIVE,  # 'L'
        37: SequenceLikelihood.NEGATIVE,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.NEGATIVE,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.NEGATIVE,  # 'T'
        52: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        25: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        33: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.NEGATIVE,  # 'g'
        40: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.NEGATIVE,  # 'i'
        17: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        12: SequenceLikelihood.NEGATIVE,  # 'l'
        11: SequenceLikelihood.NEGATIVE,  # 'm'
        8: SequenceLikelihood.NEGATIVE,  # 'n'
        6: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.NEGATIVE,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        15: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        29: SequenceLikelihood.NEGATIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    38: {  # 'ę'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    58: {  # 'Į'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.NEGATIVE,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        29: SequenceLikelihood.NEGATIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    26: {  # 'į'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.NEGATIVE,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.POSITIVE,  # 'g'
        40: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.LIKELY,  # 'ž'
    },
    50: {  # 'Š'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.NEGATIVE,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.NEGATIVE,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.LIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    22: {  # 'š'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.LIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.POSITIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.LIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.LIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.LIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.LIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.LIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    68: {  # 'Ū'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.NEGATIVE,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        33: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.NEGATIVE,  # 'i'
        17: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        15: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        29: SequenceLikelihood.NEGATIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    27: {  # 'ū'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.NEGATIVE,  # 'E'
        53: SequenceLikelihood.NEGATIVE,  # 'F'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        34: SequenceLikelihood.NEGATIVE,  # 'K'
        39: SequenceLikelihood.NEGATIVE,  # 'L'
        37: SequenceLikelihood.NEGATIVE,  # 'M'
        43: SequenceLikelihood.NEGATIVE,  # 'N'
        49: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.NEGATIVE,  # 'R'
        32: SequenceLikelihood.NEGATIVE,  # 'S'
        35: SequenceLikelihood.NEGATIVE,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.NEGATIVE,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.POSITIVE,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.LIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.LIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.LIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.LIKELY,  # 'ž'
    },
    66: {  # 'Ų'
        31: SequenceLikelihood.NEGATIVE,  # 'A'
        44: SequenceLikelihood.NEGATIVE,  # 'B'
        51: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.NEGATIVE,  # 'E'
        53: SequenceLikelihood.NEGATIVE,  # 'F'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        57: SequenceLikelihood.NEGATIVE,  # 'H'
        42: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.NEGATIVE,  # 'L'
        37: SequenceLikelihood.NEGATIVE,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.NEGATIVE,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        25: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        5: SequenceLikelihood.NEGATIVE,  # 'e'
        33: SequenceLikelihood.NEGATIVE,  # 'f'
        16: SequenceLikelihood.NEGATIVE,  # 'g'
        40: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.NEGATIVE,  # 'i'
        17: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        12: SequenceLikelihood.NEGATIVE,  # 'l'
        11: SequenceLikelihood.NEGATIVE,  # 'm'
        8: SequenceLikelihood.NEGATIVE,  # 'n'
        6: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.NEGATIVE,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        15: SequenceLikelihood.NEGATIVE,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.NEGATIVE,  # 'y'
        29: SequenceLikelihood.NEGATIVE,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.NEGATIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.NEGATIVE,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    21: {  # 'ų'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.NEGATIVE,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.UNLIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.LIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        15: SequenceLikelihood.UNLIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.UNLIKELY,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.NEGATIVE,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.UNLIKELY,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.UNLIKELY,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.UNLIKELY,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    55: {  # 'Ž'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.UNLIKELY,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.NEGATIVE,  # 'H'
        42: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        34: SequenceLikelihood.UNLIKELY,  # 'K'
        39: SequenceLikelihood.UNLIKELY,  # 'L'
        37: SequenceLikelihood.UNLIKELY,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.UNLIKELY,  # 'S'
        35: SequenceLikelihood.UNLIKELY,  # 'T'
        52: SequenceLikelihood.UNLIKELY,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        5: SequenceLikelihood.LIKELY,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.UNLIKELY,  # 'g'
        40: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        12: SequenceLikelihood.UNLIKELY,  # 'l'
        11: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        6: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        3: SequenceLikelihood.UNLIKELY,  # 's'
        4: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        15: SequenceLikelihood.LIKELY,  # 'v'
        54: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        18: SequenceLikelihood.LIKELY,  # 'y'
        29: SequenceLikelihood.NEGATIVE,  # 'z'
        69: SequenceLikelihood.UNLIKELY,  # 'Ą'
        24: SequenceLikelihood.UNLIKELY,  # 'ą'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        28: SequenceLikelihood.NEGATIVE,  # 'č'
        64: SequenceLikelihood.UNLIKELY,  # 'Ė'
        19: SequenceLikelihood.UNLIKELY,  # 'ė'
        70: SequenceLikelihood.UNLIKELY,  # 'Ę'
        38: SequenceLikelihood.NEGATIVE,  # 'ę'
        58: SequenceLikelihood.UNLIKELY,  # 'Į'
        26: SequenceLikelihood.NEGATIVE,  # 'į'
        50: SequenceLikelihood.UNLIKELY,  # 'Š'
        22: SequenceLikelihood.NEGATIVE,  # 'š'
        68: SequenceLikelihood.UNLIKELY,  # 'Ū'
        27: SequenceLikelihood.UNLIKELY,  # 'ū'
        66: SequenceLikelihood.UNLIKELY,  # 'Ų'
        21: SequenceLikelihood.NEGATIVE,  # 'ų'
        55: SequenceLikelihood.UNLIKELY,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    23: {  # 'ž'
        31: SequenceLikelihood.UNLIKELY,  # 'A'
        44: SequenceLikelihood.NEGATIVE,  # 'B'
        51: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        47: SequenceLikelihood.UNLIKELY,  # 'E'
        53: SequenceLikelihood.NEGATIVE,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        57: SequenceLikelihood.UNLIKELY,  # 'H'
        42: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        34: SequenceLikelihood.NEGATIVE,  # 'K'
        39: SequenceLikelihood.NEGATIVE,  # 'L'
        37: SequenceLikelihood.NEGATIVE,  # 'M'
        43: SequenceLikelihood.UNLIKELY,  # 'N'
        49: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        67: SequenceLikelihood.NEGATIVE,  # 'Q'
        46: SequenceLikelihood.UNLIKELY,  # 'R'
        32: SequenceLikelihood.NEGATIVE,  # 'S'
        35: SequenceLikelihood.NEGATIVE,  # 'T'
        52: SequenceLikelihood.NEGATIVE,  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'V'
        60: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        59: SequenceLikelihood.UNLIKELY,  # 'Y'
        62: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        5: SequenceLikelihood.POSITIVE,  # 'e'
        33: SequenceLikelihood.UNLIKELY,  # 'f'
        16: SequenceLikelihood.LIKELY,  # 'g'
        40: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        12: SequenceLikelihood.LIKELY,  # 'l'
        11: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        6: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        65: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        3: SequenceLikelihood.POSITIVE,  # 's'
        4: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        15: SequenceLikelihood.POSITIVE,  # 'v'
        54: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        18: SequenceLikelihood.POSITIVE,  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'z'
        69: SequenceLikelihood.NEGATIVE,  # 'Ą'
        24: SequenceLikelihood.LIKELY,  # 'ą'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        28: SequenceLikelihood.UNLIKELY,  # 'č'
        64: SequenceLikelihood.NEGATIVE,  # 'Ė'
        19: SequenceLikelihood.POSITIVE,  # 'ė'
        70: SequenceLikelihood.NEGATIVE,  # 'Ę'
        38: SequenceLikelihood.LIKELY,  # 'ę'
        58: SequenceLikelihood.NEGATIVE,  # 'Į'
        26: SequenceLikelihood.LIKELY,  # 'į'
        50: SequenceLikelihood.NEGATIVE,  # 'Š'
        22: SequenceLikelihood.UNLIKELY,  # 'š'
        68: SequenceLikelihood.NEGATIVE,  # 'Ū'
        27: SequenceLikelihood.LIKELY,  # 'ū'
        66: SequenceLikelihood.NEGATIVE,  # 'Ų'
        21: SequenceLikelihood.LIKELY,  # 'ų'
        55: SequenceLikelihood.NEGATIVE,  # 'Ž'
        23: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
}

# Character Mapping Table(s):
CP775_LITHUANIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 44,  # 'B'
    67: 51,  # 'C'
    68: 41,  # 'D'
    69: 47,  # 'E'
    70: 53,  # 'F'
    71: 48,  # 'G'
    72: 57,  # 'H'
    73: 42,  # 'I'
    74: 45,  # 'J'
    75: 34,  # 'K'
    76: 39,  # 'L'
    77: 37,  # 'M'
    78: 43,  # 'N'
    79: 49,  # 'O'
    80: 30,  # 'P'
    81: 67,  # 'Q'
    82: 46,  # 'R'
    83: 32,  # 'S'
    84: 35,  # 'T'
    85: 52,  # 'U'
    86: 36,  # 'V'
    87: 60,  # 'W'
    88: 61,  # 'X'
    89: 59,  # 'Y'
    90: 62,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 20,  # 'b'
    99: 25,  # 'c'
    100: 14,  # 'd'
    101: 5,  # 'e'
    102: 33,  # 'f'
    103: 16,  # 'g'
    104: 40,  # 'h'
    105: 1,  # 'i'
    106: 17,  # 'j'
    107: 10,  # 'k'
    108: 12,  # 'l'
    109: 11,  # 'm'
    110: 8,  # 'n'
    111: 6,  # 'o'
    112: 13,  # 'p'
    113: 65,  # 'q'
    114: 7,  # 'r'
    115: 3,  # 's'
    116: 4,  # 't'
    117: 9,  # 'u'
    118: 15,  # 'v'
    119: 54,  # 'w'
    120: 56,  # 'x'
    121: 18,  # 'y'
    122: 29,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ć'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'ā'
    132: 0,  # 'ä'
    133: 0,  # 'ģ'
    134: 0,  # 'å'
    135: 0,  # 'ć'
    136: 0,  # 'ł'
    137: 0,  # 'ē'
    138: 0,  # 'Ŗ'
    139: 0,  # 'ŗ'
    140: 0,  # 'ī'
    141: 0,  # 'Ź'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ō'
    148: 0,  # 'ö'
    149: 0,  # 'Ģ'
    150: CharacterCategory.SYMBOL,  # '¢'
    151: 0,  # 'Ś'
    152: 0,  # 'ś'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'Ā'
    161: 0,  # 'Ī'
    162: 0,  # 'ó'
    163: 0,  # 'Ż'
    164: 0,  # 'ż'
    165: 0,  # 'ź'
    166: CharacterCategory.SYMBOL,  # '”'
    167: CharacterCategory.SYMBOL,  # '¦'
    168: CharacterCategory.SYMBOL,  # '©'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: 0,  # 'Ł'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 69,  # 'Ą'
    182: 63,  # 'Č'
    183: 70,  # 'Ę'
    184: 64,  # 'Ė'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 58,  # 'Į'
    190: 50,  # 'Š'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 66,  # 'Ų'
    199: 68,  # 'Ū'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: 55,  # 'Ž'
    208: 24,  # 'ą'
    209: 28,  # 'č'
    210: 38,  # 'ę'
    211: 19,  # 'ė'
    212: 26,  # 'į'
    213: 22,  # 'š'
    214: 21,  # 'ų'
    215: 27,  # 'ū'
    216: 23,  # 'ž'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ō'
    227: 0,  # 'Ń'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'ń'
    232: 0,  # 'Ķ'
    233: 0,  # 'ķ'
    234: 0,  # 'Ļ'
    235: 0,  # 'ļ'
    236: 0,  # 'ņ'
    237: 0,  # 'Ē'
    238: 0,  # 'Ņ'
    239: CharacterCategory.SYMBOL,  # '’'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '“'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '„'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP775_LITHUANIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP775",
    language="Lithuanian",
    char_to_order_map=CP775_LITHUANIAN_CHAR_TO_ORDER,
    language_model=LITHUANIAN_LANG_MODEL,
    typical_positive_ratio=0.9723681489119747,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĄąČčĖėĘęĮįŠšŪūŲųŽž",
)

ISO_8859_4_LITHUANIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 44,  # 'B'
    67: 51,  # 'C'
    68: 41,  # 'D'
    69: 47,  # 'E'
    70: 53,  # 'F'
    71: 48,  # 'G'
    72: 57,  # 'H'
    73: 42,  # 'I'
    74: 45,  # 'J'
    75: 34,  # 'K'
    76: 39,  # 'L'
    77: 37,  # 'M'
    78: 43,  # 'N'
    79: 49,  # 'O'
    80: 30,  # 'P'
    81: 67,  # 'Q'
    82: 46,  # 'R'
    83: 32,  # 'S'
    84: 35,  # 'T'
    85: 52,  # 'U'
    86: 36,  # 'V'
    87: 60,  # 'W'
    88: 61,  # 'X'
    89: 59,  # 'Y'
    90: 62,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 20,  # 'b'
    99: 25,  # 'c'
    100: 14,  # 'd'
    101: 5,  # 'e'
    102: 33,  # 'f'
    103: 16,  # 'g'
    104: 40,  # 'h'
    105: 1,  # 'i'
    106: 17,  # 'j'
    107: 10,  # 'k'
    108: 12,  # 'l'
    109: 11,  # 'm'
    110: 8,  # 'n'
    111: 6,  # 'o'
    112: 13,  # 'p'
    113: 65,  # 'q'
    114: 7,  # 'r'
    115: 3,  # 's'
    116: 4,  # 't'
    117: 9,  # 'u'
    118: 15,  # 'v'
    119: 54,  # 'w'
    120: 56,  # 'x'
    121: 18,  # 'y'
    122: 29,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 69,  # 'Ą'
    162: 0,  # 'ĸ'
    163: 0,  # 'Ŗ'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ĩ'
    166: 0,  # 'Ļ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 50,  # 'Š'
    170: 0,  # 'Ē'
    171: 0,  # 'Ģ'
    172: 0,  # 'Ŧ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 55,  # 'Ž'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 24,  # 'ą'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ŗ'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'ĩ'
    182: 0,  # 'ļ'
    183: 0,  # 'ˇ'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 22,  # 'š'
    186: 0,  # 'ē'
    187: 0,  # 'ģ'
    188: 0,  # 'ŧ'
    189: 0,  # 'Ŋ'
    190: 23,  # 'ž'
    191: 0,  # 'ŋ'
    192: 0,  # 'Ā'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 58,  # 'Į'
    200: 63,  # 'Č'
    201: 0,  # 'É'
    202: 70,  # 'Ę'
    203: 0,  # 'Ë'
    204: 64,  # 'Ė'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ī'
    208: 0,  # 'Đ'
    209: 0,  # 'Ņ'
    210: 0,  # 'Ō'
    211: 0,  # 'Ķ'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 66,  # 'Ų'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ũ'
    222: 68,  # 'Ū'
    223: 0,  # 'ß'
    224: 0,  # 'ā'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 26,  # 'į'
    232: 28,  # 'č'
    233: 0,  # 'é'
    234: 38,  # 'ę'
    235: 0,  # 'ë'
    236: 19,  # 'ė'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ī'
    240: 0,  # 'đ'
    241: 0,  # 'ņ'
    242: 0,  # 'ō'
    243: 0,  # 'ķ'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 21,  # 'ų'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ũ'
    254: 27,  # 'ū'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_4_LITHUANIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-4",
    language="Lithuanian",
    char_to_order_map=ISO_8859_4_LITHUANIAN_CHAR_TO_ORDER,
    language_model=LITHUANIAN_LANG_MODEL,
    typical_positive_ratio=0.9723681489119747,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĄąČčĖėĘęĮįŠšŪūŲųŽž",
)

ISO_8859_13_LITHUANIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 44,  # 'B'
    67: 51,  # 'C'
    68: 41,  # 'D'
    69: 47,  # 'E'
    70: 53,  # 'F'
    71: 48,  # 'G'
    72: 57,  # 'H'
    73: 42,  # 'I'
    74: 45,  # 'J'
    75: 34,  # 'K'
    76: 39,  # 'L'
    77: 37,  # 'M'
    78: 43,  # 'N'
    79: 49,  # 'O'
    80: 30,  # 'P'
    81: 67,  # 'Q'
    82: 46,  # 'R'
    83: 32,  # 'S'
    84: 35,  # 'T'
    85: 52,  # 'U'
    86: 36,  # 'V'
    87: 60,  # 'W'
    88: 61,  # 'X'
    89: 59,  # 'Y'
    90: 62,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 20,  # 'b'
    99: 25,  # 'c'
    100: 14,  # 'd'
    101: 5,  # 'e'
    102: 33,  # 'f'
    103: 16,  # 'g'
    104: 40,  # 'h'
    105: 1,  # 'i'
    106: 17,  # 'j'
    107: 10,  # 'k'
    108: 12,  # 'l'
    109: 11,  # 'm'
    110: 8,  # 'n'
    111: 6,  # 'o'
    112: 13,  # 'p'
    113: 65,  # 'q'
    114: 7,  # 'r'
    115: 3,  # 's'
    116: 4,  # 't'
    117: 9,  # 'u'
    118: 15,  # 'v'
    119: 54,  # 'w'
    120: 56,  # 'x'
    121: 18,  # 'y'
    122: 29,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '”'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '„'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ø'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ŗ'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Æ'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '“'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ø'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'ŗ'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: 0,  # 'æ'
    192: 69,  # 'Ą'
    193: 58,  # 'Į'
    194: 0,  # 'Ā'
    195: 0,  # 'Ć'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 70,  # 'Ę'
    199: 0,  # 'Ē'
    200: 63,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ź'
    203: 64,  # 'Ė'
    204: 0,  # 'Ģ'
    205: 0,  # 'Ķ'
    206: 0,  # 'Ī'
    207: 0,  # 'Ļ'
    208: 50,  # 'Š'
    209: 0,  # 'Ń'
    210: 0,  # 'Ņ'
    211: 0,  # 'Ó'
    212: 0,  # 'Ō'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 66,  # 'Ų'
    217: 0,  # 'Ł'
    218: 0,  # 'Ś'
    219: 68,  # 'Ū'
    220: 0,  # 'Ü'
    221: 0,  # 'Ż'
    222: 55,  # 'Ž'
    223: 0,  # 'ß'
    224: 24,  # 'ą'
    225: 26,  # 'į'
    226: 0,  # 'ā'
    227: 0,  # 'ć'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 38,  # 'ę'
    231: 0,  # 'ē'
    232: 28,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ź'
    235: 19,  # 'ė'
    236: 0,  # 'ģ'
    237: 0,  # 'ķ'
    238: 0,  # 'ī'
    239: 0,  # 'ļ'
    240: 22,  # 'š'
    241: 0,  # 'ń'
    242: 0,  # 'ņ'
    243: 0,  # 'ó'
    244: 0,  # 'ō'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 21,  # 'ų'
    249: 0,  # 'ł'
    250: 0,  # 'ś'
    251: 27,  # 'ū'
    252: 0,  # 'ü'
    253: 0,  # 'ż'
    254: 23,  # 'ž'
    255: CharacterCategory.SYMBOL,  # '’'
}

ISO_8859_13_LITHUANIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-13",
    language="Lithuanian",
    char_to_order_map=ISO_8859_13_LITHUANIAN_CHAR_TO_ORDER,
    language_model=LITHUANIAN_LANG_MODEL,
    typical_positive_ratio=0.9723681489119747,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĄąČčĖėĘęĮįŠšŪūŲųŽž",
)

WINDOWS_1257_LITHUANIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 31,  # 'A'
    66: 44,  # 'B'
    67: 51,  # 'C'
    68: 41,  # 'D'
    69: 47,  # 'E'
    70: 53,  # 'F'
    71: 48,  # 'G'
    72: 57,  # 'H'
    73: 42,  # 'I'
    74: 45,  # 'J'
    75: 34,  # 'K'
    76: 39,  # 'L'
    77: 37,  # 'M'
    78: 43,  # 'N'
    79: 49,  # 'O'
    80: 30,  # 'P'
    81: 67,  # 'Q'
    82: 46,  # 'R'
    83: 32,  # 'S'
    84: 35,  # 'T'
    85: 52,  # 'U'
    86: 36,  # 'V'
    87: 60,  # 'W'
    88: 61,  # 'X'
    89: 59,  # 'Y'
    90: 62,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 20,  # 'b'
    99: 25,  # 'c'
    100: 14,  # 'd'
    101: 5,  # 'e'
    102: 33,  # 'f'
    103: 16,  # 'g'
    104: 40,  # 'h'
    105: 1,  # 'i'
    106: 17,  # 'j'
    107: 10,  # 'k'
    108: 12,  # 'l'
    109: 11,  # 'm'
    110: 8,  # 'n'
    111: 6,  # 'o'
    112: 13,  # 'p'
    113: 65,  # 'q'
    114: 7,  # 'r'
    115: 3,  # 's'
    116: 4,  # 't'
    117: 9,  # 'u'
    118: 15,  # 'v'
    119: 54,  # 'w'
    120: 56,  # 'x'
    121: 18,  # 'y'
    122: 29,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: CharacterCategory.UNDEFINED,  # None
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.SYMBOL,  # '‰'
    138: CharacterCategory.UNDEFINED,  # None
    139: CharacterCategory.SYMBOL,  # '‹'
    140: CharacterCategory.UNDEFINED,  # None
    141: CharacterCategory.SYMBOL,  # '¨'
    142: 0,  # 'ˇ'
    143: CharacterCategory.SYMBOL,  # '¸'
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: CharacterCategory.UNDEFINED,  # None
    155: CharacterCategory.SYMBOL,  # '›'
    156: CharacterCategory.UNDEFINED,  # None
    157: CharacterCategory.SYMBOL,  # '¯'
    158: CharacterCategory.SYMBOL,  # '˛'
    159: CharacterCategory.UNDEFINED,  # None
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.UNDEFINED,  # None
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.UNDEFINED,  # None
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ø'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ŗ'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Æ'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ø'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'ŗ'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: 0,  # 'æ'
    192: 69,  # 'Ą'
    193: 58,  # 'Į'
    194: 0,  # 'Ā'
    195: 0,  # 'Ć'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 70,  # 'Ę'
    199: 0,  # 'Ē'
    200: 63,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ź'
    203: 64,  # 'Ė'
    204: 0,  # 'Ģ'
    205: 0,  # 'Ķ'
    206: 0,  # 'Ī'
    207: 0,  # 'Ļ'
    208: 50,  # 'Š'
    209: 0,  # 'Ń'
    210: 0,  # 'Ņ'
    211: 0,  # 'Ó'
    212: 0,  # 'Ō'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 66,  # 'Ų'
    217: 0,  # 'Ł'
    218: 0,  # 'Ś'
    219: 68,  # 'Ū'
    220: 0,  # 'Ü'
    221: 0,  # 'Ż'
    222: 55,  # 'Ž'
    223: 0,  # 'ß'
    224: 24,  # 'ą'
    225: 26,  # 'į'
    226: 0,  # 'ā'
    227: 0,  # 'ć'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 38,  # 'ę'
    231: 0,  # 'ē'
    232: 28,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ź'
    235: 19,  # 'ė'
    236: 0,  # 'ģ'
    237: 0,  # 'ķ'
    238: 0,  # 'ī'
    239: 0,  # 'ļ'
    240: 22,  # 'š'
    241: 0,  # 'ń'
    242: 0,  # 'ņ'
    243: 0,  # 'ó'
    244: 0,  # 'ō'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 21,  # 'ų'
    249: 0,  # 'ł'
    250: 0,  # 'ś'
    251: 27,  # 'ū'
    252: 0,  # 'ü'
    253: 0,  # 'ż'
    254: 23,  # 'ž'
    255: CharacterCategory.SYMBOL,  # '˙'
}

WINDOWS_1257_LITHUANIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1257",
    language="Lithuanian",
    char_to_order_map=WINDOWS_1257_LITHUANIAN_CHAR_TO_ORDER,
    language_model=LITHUANIAN_LANG_MODEL,
    typical_positive_ratio=0.9723681489119747,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzĄąČčĖėĘęĮįŠšŪūŲųŽž",
)
