/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.managed;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.transaction.xa.XAResource;
import org.apache.tomcat.dbcp.dbcp2.managed.SynchronizationAdapter;
import org.apache.tomcat.dbcp.dbcp2.managed.TransactionContextListener;
import org.apache.tomcat.dbcp.dbcp2.managed.TransactionRegistry;

public class TransactionContext {
    private final TransactionRegistry transactionRegistry;
    private final WeakReference<Transaction> transactionRef;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private Connection sharedConnection;
    private boolean transactionComplete;

    public TransactionContext(TransactionRegistry transactionRegistry, Transaction transaction) {
        this(transactionRegistry, transaction, null);
    }

    public TransactionContext(TransactionRegistry transactionRegistry, Transaction transaction, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Objects.requireNonNull(transactionRegistry, "transactionRegistry");
        Objects.requireNonNull(transaction, "transaction");
        this.transactionRegistry = transactionRegistry;
        this.transactionRef = new WeakReference<Transaction>(transaction);
        this.transactionComplete = false;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
    }

    public void addTransactionContextListener(final TransactionContextListener transactionContextListener) throws SQLException {
        try {
            if (!this.isActive()) {
                Transaction transaction = (Transaction)this.transactionRef.get();
                transactionContextListener.afterCompletion(this, transaction != null && transaction.getStatus() == 3);
                return;
            }
            SynchronizationAdapter synchronizationAdapter = new SynchronizationAdapter(){

                @Override
                public void afterCompletion(int n) {
                    transactionContextListener.afterCompletion(TransactionContext.this, n == 3);
                }
            };
            if (this.transactionSynchronizationRegistry != null) {
                this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)synchronizationAdapter);
            } else {
                this.getTransaction().registerSynchronization((Synchronization)synchronizationAdapter);
            }
        }
        catch (RollbackException rollbackException) {
        }
        catch (Exception exception) {
            throw new SQLException("Unable to register transaction context listener", exception);
        }
    }

    public void completeTransaction() {
        this.transactionComplete = true;
    }

    public Connection getSharedConnection() {
        return this.sharedConnection;
    }

    private Transaction getTransaction() throws SQLException {
        Transaction transaction = (Transaction)this.transactionRef.get();
        if (transaction == null) {
            throw new SQLException("Unable to enlist connection because the transaction has been garbage collected");
        }
        return transaction;
    }

    public boolean isActive() throws SQLException {
        try {
            Transaction transaction = (Transaction)this.transactionRef.get();
            if (transaction == null) {
                return false;
            }
            int n = transaction.getStatus();
            return n == 0 || n == 1;
        }
        catch (SystemException systemException) {
            throw new SQLException("Unable to get transaction status", systemException);
        }
    }

    public boolean isTransactionComplete() {
        return this.transactionComplete;
    }

    public void setSharedConnection(Connection connection) throws SQLException {
        if (this.sharedConnection != null) {
            throw new IllegalStateException("A shared connection is already set");
        }
        Transaction transaction = this.getTransaction();
        try {
            XAResource xAResource = this.transactionRegistry.getXAResource(connection);
            if (!transaction.enlistResource(xAResource)) {
                throw new SQLException("Unable to enlist connection in transaction: enlistResource returns 'false'.");
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw new SQLException("Unable to enlist connection in the transaction", illegalStateException);
        }
        catch (RollbackException rollbackException) {
        }
        catch (SystemException systemException) {
            throw new SQLException("Unable to enlist connection the transaction", systemException);
        }
        this.sharedConnection = connection;
    }
}

