#!/usr/bin/env bash
ps=geodesy_08.ps
# Basic demo of events using velo - here we only show the master frame but
# you can debug the movie making by changing -Fnone to -Fmp4
gmt makecpt -Cturbo -T0/5 > t.cpt
cat << EOF > data.txt
235.6036	40.4414	-0.598	3.184	0.026	0.012	1e-05	2020-02-01T00	CME6
235.6919	40.2475	-1.89	3.287	0.014	0.005	1e-05	2020-02-01T00	P157
235.7172	40.5047	-0.231	2.678	0.023	0.008	1e-05	2020-02-01T00	P159
235.7629	40.691	0.267	2.143	0.026	0.008	1e-05	2020-02-01T00	P162
235.7869	40.6373	0.105	2.147	0.02	0.018	1e-05	2020-02-01T00	P161
235.8667	40.5512	-0.229	2.137	0.025	0.006	1e-05	2020-02-01T00	P160
235.8927	40.4224	-0.527	2.307	0.013	0.034	1e-05	2020-02-01T00	P158
235.9246	40.8763	0.18	1.724	0.017	0.008	1e-05	2020-02-01T00	P058
235.9427	40.2195	-1.437	2.486	0.01	0.008	1e-05	2020-02-01T00	P163
236.0323	40.7911	0.071	1.605	0.018	0.005	1e-05	2020-02-01T00	P169
236.0938	40.0244	-1.974	2.438	0.009	0.006	1e-05	2020-02-01T00	P156
236.1185	40.6686	-0.168	1.493	0.01	0.018	1e-05	2020-02-01T00	P168
236.1198	40.5437	-0.362	1.616	0.011	0.006	1e-05	2020-02-01T00	P167
236.1367	40.8802	-0.051	1.184	0.052	0.045	1e-05	2020-02-01T00	P170
236.1371	40.4351	-0.565	1.685	0.011	0.006	1e-05	2020-02-01T00	P166
236.1467	40.2455	-1.147	1.827	0.02	0.008	1e-05	2020-02-01T00	P165
236.3010	40.5753	-0.592	0.994	0.02	0.005	1e-05	2020-02-01T00	P326
236.3066	40.1192	-1.466	1.589	0.009	0.004	1e-05	2020-02-01T00	P164
236.3442	40.2568	-1.093	1.454	0.021	0.007	1e-05	2020-02-01T00	P324
236.4269	40.4788	-0.769	0.95	0.031	0.015	1e-05	2020-02-01T00	P327
236.5479	40.0822	-1.425	1.283	0.013	0.01	1e-05	2020-02-01T00	P329
EOF
cat << EOF > labels.txt
-124.6	40	2020-01-31T		RISE
-124.6	40	2020-02-01T		PLATEAU
-124.6	40	2020-02-02T		DECAY
-124.6	40	2020-02-03T		NORMAL
-124.6	40	2020-02-04T		FADE
-124.6	40	2020-02-05T		CODA
EOF
gmt math -T2020-01-31T/2020-02-06T/2 --TIME_UNIT=h -o0 T = time.txt
cat << EOF > main.sh
gmt begin
	gmt basemap -R-124.6/-123.3/40/41 -JM5i -B -BWSne -Y0.5i -X0.75i --MAP_FRAME_TYPE=plain
	gmt events labels.txt -L1 -Et -T\${MOVIE_COL0} -F+f12p,Helvetica-Bold,red+jBL -Dj0.1c --TIME_UNIT=d
	gmt events -Z"velo -A16p+e+a40+n6k/0+h0.5 -Se0.50/0" -Ct.cpt -W1.5 -N data.txt -T\${MOVIE_COL0} -Es+r1+p1+d1+f1 -Mi1+c-0.5 -Ms2+c0.5 -Mt+c0 -L3 --TIME_UNIT=d
gmt end
EOF
#gmt movie main.sh -C6ix6ix100 -Ngeodesy_08 -Fmp4 -Mm,ps -Lc0+jTR+o1c/1.5c -Lf+o2c/1.5c -Ttime.txt -Z --FORMAT_CLOCK_MAP=hh
gmt movie main.sh -C6ix6ix100 -Ngeodesy_08 -Fnone -Mm,ps -Lc0+jTR+o1c/1.5c -Lf+o2c/1.5c -Ttime.txt -Z --FORMAT_CLOCK_MAP=hh
rm -f t.cpt time.txt data.txt labels.txt main.sh
