About
-----

[hs-bibutils] is library with Haskell bindings to Chris Putnam's
[bibutils], a library that interconverts between various bibliography
formats using a common MODS-format XML intermediate.

[hs-bibutils] can be used with [pandoc-citeproc] to read and use various
bibliographic database formats for processing and automatically formatting
citations and references according to a [CSL] style.

[pandoc-citeproc] adds to [pandoc], the famous [Haskell] text processing
tool, a Bibtex like citation and bibliographic formatting and generation
facility.

[CSL] is an XML language for specifying citation and bibliographic
formatting, similar in principle to BibTeX `.bst` files or the binary
style files in commercial products like Endnote or Reference Manager.

Documentation
-------------

The [Haddock] generated documentation is available here:

<https://hackage.haskell.org/package/hs-bibutils/docs/Text-Bibutils.html>

Bug Reports
-----------

To submit bug reports you can use the [hs-bibutils] bug tracking
system available at the following address:

<https://github.com/wilx/hs-bibutils/issues>

Credits
-------

Thanks to [Chris Putnam] for his help.

Author
------

Andrea Rossato

`andrea.rossato at unitn dot it`

Maintainer
----------

Václav Haisman

`vhaisman at gmail dot com`

Links to Related Projects
----------------

Bibutils
:    <https://sourceforge.net/p/bibutils/home/Bibutils/>

Pandoc
:    <https://pandoc.org/>

Pandoc-Citeproc
:    <https://github.com/jgm/pandoc-citeproc>

Citeproc-hs:
:    <http://istitutocolli.org/repos/citeproc-hs/>

CSL
:    <http://xbiblio.sourceforge.net/csl/>

Legal
-----

This software is released under the GNU GPL. See LICENSE for more
details.

This is an early, "alpha" release. It carries no warranties of any kind.

Copyright © 2008 – 2010 Andrea Rossato

[hs-bibutils]: https://github.com/wilx/hs-bibutils
[bibutils]: https://sourceforge.net/p/bibutils/home/Bibutils/
[Hackage]: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/hs-bibutils
[citeproc-hs]: http://istitutocolli.org/repos/citeproc-hs/
[CSL]: http://citationstyles.org/
[pandoc]: http://pandoc.org/
[pandoc-citeproc]: https://github.com/jgm/pandoc-citeproc
[Zotero]: http://www.zotero.org
[MODS]: http://www.loc.gov/mods/
[Bruce D'Arcus]: http://community.muohio.edu/blogs/darcusb/
[John MacFarlane]: http://johnmacfarlane.net/
[Chris Putnam]: http://www.scripps.edu/~cdputnam/
[Haskell]:  http://www.haskell.org/
[Haddock]:  http://www.haskell.org/haddock/
